/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.AnnotatedObject;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.WildcardTransitionCriteria;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewSelection;

public class Transition
extends AnnotatedObject
implements TransitionDefinition {
    protected final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$engine$Transition == null ? (class$org$springframework$webflow$engine$Transition = Transition.class$("org.springframework.webflow.engine.Transition")) : class$org$springframework$webflow$engine$Transition));
    private TransitionCriteria matchingCriteria;
    private TransitionCriteria executionCriteria = WildcardTransitionCriteria.INSTANCE;
    private TargetStateResolver targetStateResolver;
    static /* synthetic */ Class class$org$springframework$webflow$engine$Transition;

    public Transition(TargetStateResolver targetStateResolver) {
        this(WildcardTransitionCriteria.INSTANCE, targetStateResolver);
    }

    public Transition(TransitionCriteria matchingCriteria, TargetStateResolver targetStateResolver) {
        this.setMatchingCriteria(matchingCriteria);
        this.setTargetStateResolver(targetStateResolver);
    }

    public String getId() {
        return this.matchingCriteria.toString();
    }

    public String getTargetStateId() {
        return this.targetStateResolver.toString();
    }

    public TransitionCriteria getMatchingCriteria() {
        return this.matchingCriteria;
    }

    public void setMatchingCriteria(TransitionCriteria matchingCriteria) {
        Assert.notNull((Object)matchingCriteria, (String)"The matching criteria is required");
        this.matchingCriteria = matchingCriteria;
    }

    public TransitionCriteria getExecutionCriteria() {
        return this.executionCriteria;
    }

    public void setExecutionCriteria(TransitionCriteria executionCriteria) {
        Assert.notNull((Object)executionCriteria, (String)"The execution criteria is required");
        this.executionCriteria = executionCriteria;
    }

    public TargetStateResolver getTargetStateResolver() {
        return this.targetStateResolver;
    }

    public void setTargetStateResolver(TargetStateResolver targetStateResolver) {
        Assert.notNull((Object)targetStateResolver, (String)"The target state resolver is required");
        this.targetStateResolver = targetStateResolver;
    }

    public boolean matches(RequestContext context) {
        return this.matchingCriteria.test(context);
    }

    public boolean canExecute(RequestContext context) {
        return this.executionCriteria.test(context);
    }

    public ViewSelection execute(State sourceState, RequestControlContext context) throws FlowExecutionException {
        ViewSelection selectedView;
        if (this.canExecute(context)) {
            if (sourceState != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Executing " + this + " out of state '" + sourceState.getId() + "'"));
                }
                if (sourceState instanceof TransitionableState) {
                    ((TransitionableState)sourceState).exit(context);
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing " + this));
            }
            State targetState = this.targetStateResolver.resolveTargetState(this, sourceState, context);
            context.setLastTransition(this);
            selectedView = targetState.enter(context);
        } else if (sourceState != null && sourceState instanceof TransitionableState) {
            selectedView = ((TransitionableState)sourceState).reenter(context);
        } else {
            throw new IllegalStateException("Execution of '" + this + "' was blocked by '" + this.getExecutionCriteria() + "', " + "; however, no source state is set at runtime.  " + "This is an illegal situation: check your flow definition.");
        }
        if (this.logger.isDebugEnabled()) {
            if (context.getFlowExecutionContext().isActive()) {
                this.logger.debug((Object)("Completed execution of " + this + ", as a result the new state is '" + context.getCurrentState().getId() + "' in flow '" + context.getActiveFlow().getId() + "'"));
            } else {
                this.logger.debug((Object)("Completed execution of " + this + ", as a result the flow execution has ended"));
            }
        }
        return selectedView;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("on", (Object)this.getMatchingCriteria()).append("to", (Object)this.getTargetStateResolver()).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

