/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.xml;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.SettableExpression;
import org.springframework.binding.expression.support.CollectionAddingExpression;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.binding.mapping.DefaultAttributeMapper;
import org.springframework.binding.mapping.Mapping;
import org.springframework.binding.mapping.RequiredMapping;
import org.springframework.binding.method.MethodSignature;
import org.springframework.binding.method.Parameter;
import org.springframework.binding.method.Parameters;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.webflow.action.ActionResultExposer;
import org.springframework.webflow.action.EvaluateAction;
import org.springframework.webflow.action.SetAction;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.AnnotatedAction;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowAttributeMapper;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.FlowVariable;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.engine.builder.BaseFlowBuilder;
import org.springframework.webflow.engine.builder.FlowArtifactFactory;
import org.springframework.webflow.engine.builder.FlowBuilderException;
import org.springframework.webflow.engine.builder.FlowServiceLocator;
import org.springframework.webflow.engine.builder.xml.DefaultDocumentLoader;
import org.springframework.webflow.engine.builder.xml.DocumentLoader;
import org.springframework.webflow.engine.builder.xml.ImmutableFlowAttributeMapper;
import org.springframework.webflow.engine.builder.xml.LocalFlowServiceLocator;
import org.springframework.webflow.engine.builder.xml.LocalFlowServiceRegistry;
import org.springframework.webflow.engine.support.AttributeExpression;
import org.springframework.webflow.engine.support.BeanFactoryFlowVariable;
import org.springframework.webflow.engine.support.BooleanExpressionTransitionCriteria;
import org.springframework.webflow.engine.support.SimpleFlowVariable;
import org.springframework.webflow.engine.support.TransitionCriteriaChain;
import org.springframework.webflow.engine.support.TransitionExecutingStateExceptionHandler;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ScopeType;
import org.springframework.webflow.util.ResourceHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlFlowBuilder
extends BaseFlowBuilder
implements ResourceHolder {
    private static final String ID_ATTRIBUTE = "id";
    private static final String IDREF_ATTRIBUTE = "idref";
    private static final String BEAN_ATTRIBUTE = "bean";
    private static final String FLOW_ELEMENT = "flow";
    private static final String START_STATE_ELEMENT = "start-state";
    private static final String ACTION_STATE_ELEMENT = "action-state";
    private static final String ACTION_ELEMENT = "action";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String METHOD_ATTRIBUTE = "method";
    private static final String BEAN_ACTION_ELEMENT = "bean-action";
    private static final String METHOD_ARGUMENTS_ELEMENT = "method-arguments";
    private static final String ARGUMENT_ELEMENT = "argument";
    private static final String EXPRESSION_ATTRIBUTE = "expression";
    private static final String PARAMETER_TYPE_ATTRIBUTE = "parameter-type";
    private static final String METHOD_RESULT_ELEMENT = "method-result";
    private static final String EVALUATE_ACTION_ELEMENT = "evaluate-action";
    private static final String SET_ELEMENT = "set";
    private static final String ATTRIBUTE_ATTRIBUTE = "attribute";
    private static final String EVALUATION_RESULT_ELEMENT = "evaluation-result";
    private static final String DEFAULT_VALUE = "default";
    private static final String VIEW_STATE_ELEMENT = "view-state";
    private static final String VIEW_ATTRIBUTE = "view";
    private static final String DECISION_STATE_ELEMENT = "decision-state";
    private static final String IF_ELEMENT = "if";
    private static final String TEST_ATTRIBUTE = "test";
    private static final String THEN_ATTRIBUTE = "then";
    private static final String ELSE_ATTRIBUTE = "else";
    private static final String SUBFLOW_STATE_ELEMENT = "subflow-state";
    private static final String FLOW_ATTRIBUTE = "flow";
    private static final String ATTRIBUTE_MAPPER_ELEMENT = "attribute-mapper";
    private static final String OUTPUT_MAPPER_ELEMENT = "output-mapper";
    private static final String OUTPUT_ATTRIBUTE_ELEMENT = "output-attribute";
    private static final String INPUT_MAPPER_ELEMENT = "input-mapper";
    private static final String INPUT_ATTRIBUTE_ELEMENT = "input-attribute";
    private static final String MAPPING_ELEMENT = "mapping";
    private static final String SOURCE_ATTRIBUTE = "source";
    private static final String TARGET_ATTRIBUTE = "target";
    private static final String FROM_ATTRIBUTE = "from";
    private static final String TO_ATTRIBUTE = "to";
    private static final String REQUIRED_ATTRIBUTE = "required";
    private static final String TARGET_COLLECTION_ATTRIBUTE = "target-collection";
    private static final String END_STATE_ELEMENT = "end-state";
    private static final String TRANSITION_ELEMENT = "transition";
    private static final String GLOBAL_TRANSITIONS_ELEMENT = "global-transitions";
    private static final String ON_ATTRIBUTE = "on";
    private static final String ON_EXCEPTION_ATTRIBUTE = "on-exception";
    private static final String ATTRIBUTE_ELEMENT = "attribute";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String VALUE_ELEMENT = "value";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String VAR_ELEMENT = "var";
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String START_ACTIONS_ELEMENT = "start-actions";
    private static final String END_ACTIONS_ELEMENT = "end-actions";
    private static final String ENTRY_ACTIONS_ELEMENT = "entry-actions";
    private static final String RENDER_ACTIONS_ELEMENT = "render-actions";
    private static final String EXIT_ACTIONS_ELEMENT = "exit-actions";
    private static final String EXCEPTION_HANDLER_ELEMENT = "exception-handler";
    private static final String INLINE_FLOW_ELEMENT = "inline-flow";
    private static final String IMPORT_ELEMENT = "import";
    private static final String RESOURCE_ATTRIBUTE = "resource";
    protected Resource location;
    private LocalFlowServiceLocator localFlowServiceLocator;
    private DocumentLoader documentLoader = new DefaultDocumentLoader();
    private Document document;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$springframework$webflow$engine$TransitionCriteria;
    static /* synthetic */ Class class$org$springframework$webflow$engine$TargetStateResolver;
    static /* synthetic */ Class class$org$springframework$webflow$engine$ViewSelector;
    static /* synthetic */ Class class$org$springframework$webflow$execution$ScopeType;
    static /* synthetic */ Class class$java$lang$Boolean;

    public XmlFlowBuilder(Resource location) {
        this.setLocation(location);
    }

    public XmlFlowBuilder(Resource location, FlowServiceLocator flowServiceLocator) {
        super(flowServiceLocator);
        this.setLocation(location);
    }

    public Resource getLocation() {
        return this.location;
    }

    public void setLocation(Resource location) {
        Assert.notNull((Object)location, (String)"The resource location of the XML-based flow definition is required");
        this.location = location;
    }

    public void setDocumentLoader(DocumentLoader documentLoader) {
        Assert.notNull((Object)documentLoader, (String)"The XML document loader is required");
        this.documentLoader = documentLoader;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("location", (Object)this.location).toString();
    }

    public void init(String id, AttributeMap attributes) throws FlowBuilderException {
        this.localFlowServiceLocator = new LocalFlowServiceLocator(this.getFlowServiceLocator());
        try {
            this.document = this.documentLoader.loadDocument(this.location);
        }
        catch (IOException e) {
            throw new FlowBuilderException("Could not access the XML flow definition resource at " + this.location, e);
        }
        catch (ParserConfigurationException e) {
            throw new FlowBuilderException("Could not configure the parser to parse the XML flow definition at " + this.location, e);
        }
        catch (SAXException e) {
            throw new FlowBuilderException("Could not parse the XML flow definition document at " + this.location, e);
        }
        this.setFlow(this.parseFlow(id, attributes, this.getDocumentElement()));
    }

    public void buildVariables() throws FlowBuilderException {
        this.parseAndAddFlowVariables(this.getDocumentElement(), this.getFlow());
    }

    public void buildInputMapper() throws FlowBuilderException {
        this.getFlow().setInputMapper(this.parseInputMapper(this.getDocumentElement()));
    }

    public void buildStartActions() throws FlowBuilderException {
        this.parseAndAddStartActions(this.getDocumentElement(), this.getFlow());
    }

    public void buildInlineFlows() throws FlowBuilderException {
        this.parseAndAddInlineFlowDefinitions(this.getDocumentElement(), this.getFlow());
    }

    public void buildStates() throws FlowBuilderException {
        this.parseAndAddStateDefinitions(this.getDocumentElement(), this.getFlow());
    }

    public void buildGlobalTransitions() throws FlowBuilderException {
        this.parseAndAddGlobalTransitions(this.getDocumentElement(), this.getFlow());
    }

    public void buildEndActions() throws FlowBuilderException {
        this.parseAndAddEndActions(this.getDocumentElement(), this.getFlow());
    }

    public void buildOutputMapper() throws FlowBuilderException {
        this.getFlow().setOutputMapper(this.parseOutputMapper(this.getDocumentElement()));
    }

    public void buildExceptionHandlers() throws FlowBuilderException {
        this.getFlow().getExceptionHandlerSet().addAll(this.parseExceptionHandlers(this.getDocumentElement()));
    }

    public void dispose() {
        super.dispose();
        this.localFlowServiceLocator.diposeOfAnyRegistries();
        this.document = null;
    }

    public Resource getResource() {
        return this.location;
    }

    protected Document getDocument() {
        return this.document;
    }

    protected Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    protected FlowServiceLocator getLocalFlowServiceLocator() {
        return this.localFlowServiceLocator;
    }

    protected FlowArtifactFactory getFlowArtifactFactory() {
        return this.getLocalFlowServiceLocator().getFlowArtifactFactory();
    }

    protected Element getChildElementByTagName(Element ele, String childEleName) {
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !this.nodeNameEquals(node, childEleName)) continue;
            return (Element)node;
        }
        return null;
    }

    protected boolean nodeNameEquals(Node node, String desiredName) {
        return desiredName.equals(node.getNodeName()) || desiredName.equals(node.getLocalName());
    }

    private Flow parseFlow(String id, AttributeMap attributes, Element flowElement) {
        if (!this.isFlowElement(flowElement)) {
            throw new IllegalStateException("This is not the 'flow' element");
        }
        Flow flow = this.getFlowArtifactFactory().createFlow(id, this.parseAttributes(flowElement).union(attributes));
        this.initLocalServiceRegistry(flowElement, flow);
        return flow;
    }

    private boolean isFlowElement(Element flowElement) {
        return this.nodeNameEquals(flowElement, "flow");
    }

    private void initLocalServiceRegistry(Element flowElement, Flow flow) {
        List importElements = DomUtils.getChildElementsByTagName((Element)flowElement, (String)IMPORT_ELEMENT);
        Resource[] resources = new Resource[importElements.size()];
        for (int i = 0; i < importElements.size(); ++i) {
            Element importElement = (Element)importElements.get(i);
            try {
                resources[i] = this.getLocation().createRelative(importElement.getAttribute(RESOURCE_ATTRIBUTE));
                continue;
            }
            catch (IOException e) {
                throw new FlowBuilderException("Could not access flow-relative artifact resource '" + importElement.getAttribute(RESOURCE_ATTRIBUTE) + "'", e);
            }
        }
        this.localFlowServiceLocator.push(new LocalFlowServiceRegistry(flow, this.createLocalBeanFactory(flow, resources)));
    }

    protected BeanFactory createLocalBeanFactory(Flow flow, Resource[] resources) {
        GenericApplicationContext context;
        BeanFactory parent = null;
        if (this.localFlowServiceLocator.isEmpty()) {
            try {
                parent = this.getFlowServiceLocator().getBeanFactory();
            }
            catch (UnsupportedOperationException e) {}
        } else {
            parent = this.localFlowServiceLocator.top().getBeanFactory();
        }
        if (parent instanceof WebApplicationContext) {
            GenericWebApplicationContext webContext = new GenericWebApplicationContext();
            webContext.setServletContext(((WebApplicationContext)parent).getServletContext());
            context = webContext;
        } else {
            context = new GenericApplicationContext();
        }
        if (parent instanceof ApplicationContext) {
            context.setParent((ApplicationContext)parent);
        } else if (parent != null) {
            context.getBeanFactory().setParentBeanFactory(parent);
        }
        context.setResourceLoader(this.getFlowServiceLocator().getResourceLoader());
        new XmlBeanDefinitionReader((BeanDefinitionRegistry)context).loadBeanDefinitions(resources);
        this.registerLocalBeans(flow, (ConfigurableBeanFactory)context.getDefaultListableBeanFactory());
        context.refresh();
        return context;
    }

    protected void registerLocalBeans(Flow flow, ConfigurableBeanFactory beanFactory) {
    }

    private void destroyLocalServiceRegistry() {
        this.localFlowServiceLocator.pop();
    }

    private void parseAndAddFlowVariables(Element flowElement, Flow flow) {
        List varElements = DomUtils.getChildElementsByTagName((Element)flowElement, (String)VAR_ELEMENT);
        Iterator it = varElements.iterator();
        while (it.hasNext()) {
            flow.addVariable(this.parseVariable((Element)it.next()));
        }
    }

    private FlowVariable parseVariable(Element element) {
        ScopeType scope = this.parseScope(element, ScopeType.FLOW);
        if (StringUtils.hasText((String)element.getAttribute(BEAN_ATTRIBUTE))) {
            BeanFactory beanFactory = this.getLocalFlowServiceLocator().getBeanFactory();
            return new BeanFactoryFlowVariable(element.getAttribute(NAME_ATTRIBUTE), element.getAttribute(BEAN_ATTRIBUTE), beanFactory, scope);
        }
        if (StringUtils.hasText((String)element.getAttribute(CLASS_ATTRIBUTE))) {
            Class variableClass = (Class)this.fromStringTo(class$java$lang$Class == null ? (class$java$lang$Class = XmlFlowBuilder.class$("java.lang.Class")) : class$java$lang$Class).execute((Object)element.getAttribute(CLASS_ATTRIBUTE));
            return new SimpleFlowVariable(element.getAttribute(NAME_ATTRIBUTE), variableClass, scope);
        }
        BeanFactory beanFactory = this.getLocalFlowServiceLocator().getBeanFactory();
        return new BeanFactoryFlowVariable(element.getAttribute(NAME_ATTRIBUTE), null, beanFactory, scope);
    }

    private void parseAndAddStartActions(Element element, Flow flow) {
        Element startElement = this.getChildElementByTagName(element, START_ACTIONS_ELEMENT);
        if (startElement != null) {
            flow.getStartActionList().addAll(this.parseAnnotatedActions(startElement));
        }
    }

    private void parseAndAddEndActions(Element element, Flow flow) {
        Element endElement = this.getChildElementByTagName(element, END_ACTIONS_ELEMENT);
        if (endElement != null) {
            flow.getEndActionList().addAll(this.parseAnnotatedActions(endElement));
        }
    }

    private void parseAndAddGlobalTransitions(Element element, Flow flow) {
        Element globalTransitionsElement = this.getChildElementByTagName(element, GLOBAL_TRANSITIONS_ELEMENT);
        if (globalTransitionsElement != null) {
            flow.getGlobalTransitionSet().addAll(this.parseTransitions(globalTransitionsElement));
        }
    }

    private void parseAndAddInlineFlowDefinitions(Element parentFlowElement, Flow flow) {
        List inlineFlowElements = DomUtils.getChildElementsByTagName((Element)parentFlowElement, (String)INLINE_FLOW_ELEMENT);
        Iterator it = inlineFlowElements.iterator();
        while (it.hasNext()) {
            Element inlineFlowElement = (Element)it.next();
            String inlineFlowId = inlineFlowElement.getAttribute(ID_ATTRIBUTE);
            Element flowElement = this.getChildElementByTagName(inlineFlowElement, "flow");
            Flow inlineFlow = this.parseFlow(inlineFlowId, null, flowElement);
            this.buildInlineFlow(flowElement, inlineFlow);
            flow.addInlineFlow(inlineFlow);
        }
    }

    private void buildInlineFlow(Element flowElement, Flow inlineFlow) {
        this.parseAndAddFlowVariables(flowElement, inlineFlow);
        inlineFlow.setInputMapper(this.parseInputMapper(flowElement));
        this.parseAndAddStartActions(flowElement, inlineFlow);
        this.parseAndAddInlineFlowDefinitions(flowElement, inlineFlow);
        this.parseAndAddStateDefinitions(flowElement, inlineFlow);
        this.parseAndAddGlobalTransitions(flowElement, inlineFlow);
        this.parseAndAddEndActions(flowElement, inlineFlow);
        inlineFlow.setOutputMapper(this.parseOutputMapper(flowElement));
        inlineFlow.getExceptionHandlerSet().addAll(this.parseExceptionHandlers(flowElement));
        this.destroyLocalServiceRegistry();
    }

    private void parseAndAddStateDefinitions(Element flowElement, Flow flow) {
        NodeList childNodeList = flowElement.getChildNodes();
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node childNode = childNodeList.item(i);
            if (!(childNode instanceof Element)) continue;
            Element stateElement = (Element)childNode;
            if (this.nodeNameEquals(stateElement, ACTION_STATE_ELEMENT)) {
                this.parseAndAddActionState(stateElement, flow);
                continue;
            }
            if (this.nodeNameEquals(stateElement, VIEW_STATE_ELEMENT)) {
                this.parseAndAddViewState(stateElement, flow);
                continue;
            }
            if (this.nodeNameEquals(stateElement, DECISION_STATE_ELEMENT)) {
                this.parseAndAddDecisionState(stateElement, flow);
                continue;
            }
            if (this.nodeNameEquals(stateElement, SUBFLOW_STATE_ELEMENT)) {
                this.parseAndAddSubflowState(stateElement, flow);
                continue;
            }
            if (!this.nodeNameEquals(stateElement, END_STATE_ELEMENT)) continue;
            this.parseAndAddEndState(stateElement, flow);
        }
        this.parseAndSetStartState(flowElement, flow);
    }

    private void parseAndSetStartState(Element element, Flow flow) {
        String startStateId = this.getStartStateId(element);
        flow.setStartState(startStateId);
    }

    private String getStartStateId(Element element) {
        Element startStateElement = this.getChildElementByTagName(element, START_STATE_ELEMENT);
        return startStateElement.getAttribute(IDREF_ATTRIBUTE);
    }

    private void parseAndAddActionState(Element element, Flow flow) {
        this.getFlowArtifactFactory().createActionState(this.parseId(element), flow, this.parseEntryActions(element), this.parseAnnotatedActions(element), this.parseTransitions(element), this.parseExceptionHandlers(element), this.parseExitActions(element), this.parseAttributes(element));
    }

    private void parseAndAddViewState(Element element, Flow flow) {
        this.getFlowArtifactFactory().createViewState(this.parseId(element), flow, this.parseEntryActions(element), this.parseViewSelector(element), this.parseRenderActions(element), this.parseTransitions(element), this.parseExceptionHandlers(element), this.parseExitActions(element), this.parseAttributes(element));
    }

    private void parseAndAddDecisionState(Element element, Flow flow) {
        this.getFlowArtifactFactory().createDecisionState(this.parseId(element), flow, this.parseEntryActions(element), this.parseIfs(element), this.parseExceptionHandlers(element), this.parseExitActions(element), this.parseAttributes(element));
    }

    private void parseAndAddSubflowState(Element element, Flow flow) {
        this.getFlowArtifactFactory().createSubflowState(this.parseId(element), flow, this.parseEntryActions(element), this.parseSubflow(element), this.parseFlowAttributeMapper(element), this.parseTransitions(element), this.parseExceptionHandlers(element), this.parseExitActions(element), this.parseAttributes(element));
    }

    private void parseAndAddEndState(Element element, Flow flow) {
        this.getFlowArtifactFactory().createEndState(this.parseId(element), flow, this.parseEntryActions(element), this.parseViewSelector(element), this.parseOutputMapper(element), this.parseExceptionHandlers(element), this.parseAttributes(element));
    }

    private String parseId(Element element) {
        return element.getAttribute(ID_ATTRIBUTE);
    }

    private Action[] parseEntryActions(Element element) {
        Element entryActionsElement = this.getChildElementByTagName(element, ENTRY_ACTIONS_ELEMENT);
        if (entryActionsElement != null) {
            return this.parseAnnotatedActions(entryActionsElement);
        }
        return null;
    }

    private Action[] parseRenderActions(Element element) {
        Element renderActionsElement = this.getChildElementByTagName(element, RENDER_ACTIONS_ELEMENT);
        if (renderActionsElement != null) {
            return this.parseAnnotatedActions(renderActionsElement);
        }
        return null;
    }

    private Action[] parseExitActions(Element element) {
        Element exitActionsElement = this.getChildElementByTagName(element, EXIT_ACTIONS_ELEMENT);
        if (exitActionsElement != null) {
            return this.parseAnnotatedActions(exitActionsElement);
        }
        return null;
    }

    private Transition[] parseTransitions(Element element) {
        LinkedList<Transition> transitions = new LinkedList<Transition>();
        List transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)TRANSITION_ELEMENT);
        Iterator it = transitionElements.iterator();
        while (it.hasNext()) {
            Element transitionElement = (Element)it.next();
            if (StringUtils.hasText((String)transitionElement.getAttribute(ON_EXCEPTION_ATTRIBUTE))) continue;
            transitions.add(this.parseTransition(transitionElement));
        }
        return transitions.toArray(new Transition[transitions.size()]);
    }

    private Transition parseTransition(Element element) {
        TransitionCriteria matchingCriteria = (TransitionCriteria)this.fromStringTo(class$org$springframework$webflow$engine$TransitionCriteria == null ? (class$org$springframework$webflow$engine$TransitionCriteria = XmlFlowBuilder.class$("org.springframework.webflow.engine.TransitionCriteria")) : class$org$springframework$webflow$engine$TransitionCriteria).execute((Object)element.getAttribute(ON_ATTRIBUTE));
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$engine$TargetStateResolver == null ? (class$org$springframework$webflow$engine$TargetStateResolver = XmlFlowBuilder.class$("org.springframework.webflow.engine.TargetStateResolver")) : class$org$springframework$webflow$engine$TargetStateResolver).execute((Object)element.getAttribute(TO_ATTRIBUTE));
        TransitionCriteria executionCriteria = TransitionCriteriaChain.criteriaChainFor(this.parseAnnotatedActions(element));
        return this.getFlowArtifactFactory().createTransition(targetStateResolver, matchingCriteria, executionCriteria, this.parseAttributes(element));
    }

    private ViewSelector parseViewSelector(Element element) {
        String viewName = element.getAttribute(VIEW_ATTRIBUTE);
        return (ViewSelector)this.fromStringTo(class$org$springframework$webflow$engine$ViewSelector == null ? (class$org$springframework$webflow$engine$ViewSelector = XmlFlowBuilder.class$("org.springframework.webflow.engine.ViewSelector")) : class$org$springframework$webflow$engine$ViewSelector).execute((Object)viewName);
    }

    private Flow parseSubflow(Element element) {
        return this.getLocalFlowServiceLocator().getSubflow(element.getAttribute("flow"));
    }

    private AnnotatedAction[] parseAnnotatedActions(Element element) {
        LinkedList<AnnotatedAction> actions = new LinkedList<AnnotatedAction>();
        NodeList childNodeList = element.getChildNodes();
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node childNode = childNodeList.item(i);
            if (!(childNode instanceof Element)) continue;
            if (this.nodeNameEquals(childNode, ACTION_ELEMENT)) {
                actions.add(this.parseAnnotatedAction((Element)childNode));
                continue;
            }
            if (this.nodeNameEquals(childNode, BEAN_ACTION_ELEMENT)) {
                actions.add(this.parseAnnotatedBeanInvokingAction((Element)childNode));
                continue;
            }
            if (this.nodeNameEquals(childNode, EVALUATE_ACTION_ELEMENT)) {
                actions.add(this.parseAnnotatedEvaluateAction((Element)childNode));
                continue;
            }
            if (!this.nodeNameEquals(childNode, SET_ELEMENT)) continue;
            actions.add(this.parseAnnotatedSetAction((Element)childNode));
        }
        return actions.toArray(new AnnotatedAction[actions.size()]);
    }

    private AnnotatedAction parseAnnotatedAction(Element element) {
        AnnotatedAction annotated = new AnnotatedAction(this.parseAction(element));
        this.parseCommonProperties(element, annotated);
        if (element.hasAttribute(METHOD_ATTRIBUTE)) {
            annotated.setMethod(element.getAttribute(METHOD_ATTRIBUTE));
        }
        return annotated;
    }

    private Action parseAction(Element element) {
        String actionId = element.getAttribute(BEAN_ATTRIBUTE);
        return this.getLocalFlowServiceLocator().getAction(actionId);
    }

    private AnnotatedAction parseCommonProperties(Element element, AnnotatedAction annotated) {
        if (element.hasAttribute(NAME_ATTRIBUTE)) {
            annotated.setName(element.getAttribute(NAME_ATTRIBUTE));
        }
        annotated.getAttributeMap().putAll(this.parseAttributes(element));
        return annotated;
    }

    private AnnotatedAction parseAnnotatedBeanInvokingAction(Element element) {
        AnnotatedAction annotated = new AnnotatedAction(this.parseBeanInvokingAction(element));
        return this.parseCommonProperties(element, annotated);
    }

    private Action parseBeanInvokingAction(Element element) {
        String beanId = element.getAttribute(BEAN_ATTRIBUTE);
        String methodName = element.getAttribute(METHOD_ATTRIBUTE);
        Parameters parameters = this.parseMethodParameters(element);
        MethodSignature methodSignature = new MethodSignature(methodName, parameters);
        ActionResultExposer resultExposer = this.parseMethodResultExposer(element);
        return this.getLocalFlowServiceLocator().getBeanInvokingActionFactory().createBeanInvokingAction(beanId, this.getLocalFlowServiceLocator().getBeanFactory(), methodSignature, resultExposer, this.getLocalFlowServiceLocator().getConversionService(), null);
    }

    private Parameters parseMethodParameters(Element element) {
        Element methodArgumentsElement = this.getChildElementByTagName(element, METHOD_ARGUMENTS_ELEMENT);
        if (methodArgumentsElement == null) {
            return Parameters.NONE;
        }
        Parameters parameters = new Parameters();
        Iterator it = DomUtils.getChildElementsByTagName((Element)methodArgumentsElement, (String)ARGUMENT_ELEMENT).iterator();
        while (it.hasNext()) {
            Element argumentElement = (Element)it.next();
            Expression name = this.getLocalFlowServiceLocator().getExpressionParser().parseExpression(argumentElement.getAttribute(EXPRESSION_ATTRIBUTE));
            Class type = null;
            if (argumentElement.hasAttribute(PARAMETER_TYPE_ATTRIBUTE)) {
                type = (Class)this.fromStringTo(class$java$lang$Class == null ? XmlFlowBuilder.class$("java.lang.Class") : class$java$lang$Class).execute((Object)argumentElement.getAttribute(PARAMETER_TYPE_ATTRIBUTE));
            }
            parameters.add(new Parameter(type, name));
        }
        return parameters;
    }

    private ActionResultExposer parseMethodResultExposer(Element element) {
        Element resultElement = this.getChildElementByTagName(element, METHOD_RESULT_ELEMENT);
        if (resultElement != null) {
            return this.parseActionResultExposer(resultElement);
        }
        return null;
    }

    private ActionResultExposer parseActionResultExposer(Element element) {
        String resultName = element.getAttribute(NAME_ATTRIBUTE);
        return new ActionResultExposer(resultName, this.parseScope(element, ScopeType.REQUEST));
    }

    private AnnotatedAction parseAnnotatedEvaluateAction(Element element) {
        AnnotatedAction annotated = new AnnotatedAction(this.parseEvaluateAction(element));
        return this.parseCommonProperties(element, annotated);
    }

    private Action parseEvaluateAction(Element element) {
        String expressionString = element.getAttribute(EXPRESSION_ATTRIBUTE);
        Expression expression = this.getLocalFlowServiceLocator().getExpressionParser().parseExpression(expressionString);
        return new EvaluateAction(expression, this.parseEvaluationResultExposer(element));
    }

    private ActionResultExposer parseEvaluationResultExposer(Element element) {
        Element resultElement = this.getChildElementByTagName(element, EVALUATION_RESULT_ELEMENT);
        if (resultElement != null) {
            return this.parseActionResultExposer(resultElement);
        }
        return null;
    }

    private AnnotatedAction parseAnnotatedSetAction(Element element) {
        AnnotatedAction annotated = new AnnotatedAction(this.parseSetAction(element));
        return this.parseCommonProperties(element, annotated);
    }

    private Action parseSetAction(Element element) {
        String attributeExpressionString = element.getAttribute("attribute");
        SettableExpression attributeExpression = this.getLocalFlowServiceLocator().getExpressionParser().parseSettableExpression(attributeExpressionString);
        Expression valueExpression = this.getLocalFlowServiceLocator().getExpressionParser().parseExpression(element.getAttribute("value"));
        return new SetAction(attributeExpression, this.parseScope(element, ScopeType.REQUEST), valueExpression);
    }

    private ScopeType parseScope(Element element, ScopeType defaultValue) {
        if (element.hasAttribute(SCOPE_ATTRIBUTE) && !element.getAttribute(SCOPE_ATTRIBUTE).equals(DEFAULT_VALUE)) {
            return (ScopeType)((Object)this.fromStringTo(class$org$springframework$webflow$execution$ScopeType == null ? (class$org$springframework$webflow$execution$ScopeType = XmlFlowBuilder.class$("org.springframework.webflow.execution.ScopeType")) : class$org$springframework$webflow$execution$ScopeType).execute((Object)element.getAttribute(SCOPE_ATTRIBUTE)));
        }
        return defaultValue;
    }

    private AttributeMap parseAttributes(Element element) {
        LocalAttributeMap attributes = new LocalAttributeMap();
        List propertyElements = DomUtils.getChildElementsByTagName((Element)element, (String)"attribute");
        for (int i = 0; i < propertyElements.size(); ++i) {
            this.parseAndSetAttribute((Element)propertyElements.get(i), attributes);
        }
        return attributes;
    }

    private void parseAndSetAttribute(Element element, MutableAttributeMap attributes) {
        String name = element.getAttribute(NAME_ATTRIBUTE);
        String value = null;
        if (element.hasAttribute("value")) {
            value = element.getAttribute("value");
        } else {
            List valueElements = DomUtils.getChildElementsByTagName((Element)element, (String)"value");
            Assert.state((valueElements.size() == 1 ? 1 : 0) != 0, (String)("A property value should be specified for property '" + name + "'"));
            value = DomUtils.getTextValue((Element)((Element)valueElements.get(0)));
        }
        attributes.put(name, this.convertPropertyValue(element, value));
    }

    private Object convertPropertyValue(Element element, String stringValue) {
        if (element.hasAttribute(TYPE_ATTRIBUTE)) {
            Class targetClass = (Class)this.fromStringTo(class$java$lang$Class == null ? (class$java$lang$Class = XmlFlowBuilder.class$("java.lang.Class")) : class$java$lang$Class).execute((Object)element.getAttribute(TYPE_ATTRIBUTE));
            return this.fromStringTo(targetClass).execute((Object)stringValue);
        }
        return stringValue;
    }

    private Transition[] parseIfs(Element element) {
        LinkedList<Transition> transitions = new LinkedList<Transition>();
        List transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)IF_ELEMENT);
        Iterator it = transitionElements.iterator();
        while (it.hasNext()) {
            transitions.addAll(Arrays.asList(this.parseIf((Element)it.next())));
        }
        return transitions.toArray(new Transition[transitions.size()]);
    }

    private Transition[] parseIf(Element element) {
        Transition thenTransition = this.parseThen(element);
        if (StringUtils.hasText((String)element.getAttribute(ELSE_ATTRIBUTE))) {
            Transition elseTransition = this.parseElse(element);
            return new Transition[]{thenTransition, elseTransition};
        }
        return new Transition[]{thenTransition};
    }

    private Transition parseThen(Element element) {
        Expression expression = this.getLocalFlowServiceLocator().getExpressionParser().parseExpression(element.getAttribute(TEST_ATTRIBUTE));
        BooleanExpressionTransitionCriteria matchingCriteria = new BooleanExpressionTransitionCriteria(expression);
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$engine$TargetStateResolver == null ? (class$org$springframework$webflow$engine$TargetStateResolver = XmlFlowBuilder.class$("org.springframework.webflow.engine.TargetStateResolver")) : class$org$springframework$webflow$engine$TargetStateResolver).execute((Object)element.getAttribute(THEN_ATTRIBUTE));
        return this.getFlowArtifactFactory().createTransition(targetStateResolver, matchingCriteria, null, null);
    }

    private Transition parseElse(Element element) {
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$engine$TargetStateResolver == null ? (class$org$springframework$webflow$engine$TargetStateResolver = XmlFlowBuilder.class$("org.springframework.webflow.engine.TargetStateResolver")) : class$org$springframework$webflow$engine$TargetStateResolver).execute((Object)element.getAttribute(ELSE_ATTRIBUTE));
        return this.getFlowArtifactFactory().createTransition(targetStateResolver, null, null, null);
    }

    private FlowAttributeMapper parseFlowAttributeMapper(Element element) {
        Element mapperElement = this.getChildElementByTagName(element, ATTRIBUTE_MAPPER_ELEMENT);
        if (mapperElement == null) {
            return null;
        }
        if (StringUtils.hasText((String)mapperElement.getAttribute(BEAN_ATTRIBUTE))) {
            return this.getLocalFlowServiceLocator().getAttributeMapper(mapperElement.getAttribute(BEAN_ATTRIBUTE));
        }
        return new ImmutableFlowAttributeMapper(this.parseInputMapper(mapperElement), this.parseOutputMapper(mapperElement));
    }

    private AttributeMapper parseInputMapper(Element element) {
        Element mapperElement = this.getChildElementByTagName(element, INPUT_MAPPER_ELEMENT);
        if (mapperElement != null) {
            DefaultAttributeMapper mapper = new DefaultAttributeMapper();
            this.parseSimpleAttributeMappings(mapper, DomUtils.getChildElementsByTagName((Element)mapperElement, (String)INPUT_ATTRIBUTE_ELEMENT));
            this.parseMappings(mapper, mapperElement);
            return mapper;
        }
        return null;
    }

    private AttributeMapper parseOutputMapper(Element element) {
        Element mapperElement = this.getChildElementByTagName(element, OUTPUT_MAPPER_ELEMENT);
        if (mapperElement != null) {
            DefaultAttributeMapper mapper = new DefaultAttributeMapper();
            this.parseSimpleAttributeMappings(mapper, DomUtils.getChildElementsByTagName((Element)mapperElement, (String)OUTPUT_ATTRIBUTE_ELEMENT));
            this.parseMappings(mapper, mapperElement);
            return mapper;
        }
        return null;
    }

    private void parseMappings(DefaultAttributeMapper mapper, Element element) {
        ExpressionParser parser = this.getLocalFlowServiceLocator().getExpressionParser();
        List mappingElements = DomUtils.getChildElementsByTagName((Element)element, (String)MAPPING_ELEMENT);
        Iterator it = mappingElements.iterator();
        while (it.hasNext()) {
            Element mappingElement = (Element)it.next();
            Expression source = parser.parseExpression(mappingElement.getAttribute(SOURCE_ATTRIBUTE));
            SettableExpression target = null;
            if (StringUtils.hasText((String)mappingElement.getAttribute(TARGET_ATTRIBUTE))) {
                target = parser.parseSettableExpression(mappingElement.getAttribute(TARGET_ATTRIBUTE));
            } else if (StringUtils.hasText((String)mappingElement.getAttribute(TARGET_COLLECTION_ATTRIBUTE))) {
                target = new CollectionAddingExpression((Expression)parser.parseSettableExpression(mappingElement.getAttribute(TARGET_COLLECTION_ATTRIBUTE)));
            }
            if (this.getRequired(mappingElement, false)) {
                mapper.addMapping((AttributeMapper)new RequiredMapping(source, target, this.parseTypeConverter(mappingElement)));
                continue;
            }
            mapper.addMapping((AttributeMapper)new Mapping(source, target, this.parseTypeConverter(mappingElement)));
        }
    }

    private void parseSimpleAttributeMappings(DefaultAttributeMapper mapper, List elements) {
        ExpressionParser parser = this.getLocalFlowServiceLocator().getExpressionParser();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            SettableExpression attribute = parser.parseSettableExpression(element.getAttribute(NAME_ATTRIBUTE));
            AttributeExpression expression = new AttributeExpression((Expression)attribute, this.parseScope(element, ScopeType.FLOW));
            if (this.getRequired(element, false)) {
                mapper.addMapping((AttributeMapper)new RequiredMapping((Expression)expression, (SettableExpression)expression, null));
                continue;
            }
            mapper.addMapping((AttributeMapper)new Mapping((Expression)expression, (SettableExpression)expression, null));
        }
    }

    private boolean getRequired(Element element, boolean defaultValue) {
        if (StringUtils.hasText((String)element.getAttribute(REQUIRED_ATTRIBUTE))) {
            return (Boolean)this.fromStringTo(class$java$lang$Boolean == null ? (class$java$lang$Boolean = XmlFlowBuilder.class$("java.lang.Boolean")) : class$java$lang$Boolean).execute((Object)element.getAttribute(REQUIRED_ATTRIBUTE));
        }
        return defaultValue;
    }

    private ConversionExecutor parseTypeConverter(Element element) {
        String from = element.getAttribute(FROM_ATTRIBUTE);
        String to = element.getAttribute(TO_ATTRIBUTE);
        if (StringUtils.hasText((String)from)) {
            if (StringUtils.hasText((String)to)) {
                ConversionService service = this.getLocalFlowServiceLocator().getConversionService();
                Class sourceClass = (Class)this.fromStringTo(class$java$lang$Class == null ? (class$java$lang$Class = XmlFlowBuilder.class$("java.lang.Class")) : class$java$lang$Class).execute((Object)from);
                Class targetClass = (Class)this.fromStringTo(class$java$lang$Class == null ? (class$java$lang$Class = XmlFlowBuilder.class$("java.lang.Class")) : class$java$lang$Class).execute((Object)to);
                return service.getConversionExecutor(sourceClass, targetClass);
            }
            throw new IllegalArgumentException("Use of the 'from' attribute requires use of the 'to' attribute");
        }
        Assert.isTrue((!StringUtils.hasText((String)to) ? 1 : 0) != 0, (String)"Use of the 'to' attribute requires use of the 'from' attribute");
        return null;
    }

    private FlowExecutionExceptionHandler[] parseExceptionHandlers(Element element) {
        FlowExecutionExceptionHandler[] transitionExecutingHandlers = this.parseTransitionExecutingExceptionHandlers(element);
        FlowExecutionExceptionHandler[] customHandlers = this.parseCustomExceptionHandlers(element);
        FlowExecutionExceptionHandler[] exceptionHandlers = new FlowExecutionExceptionHandler[transitionExecutingHandlers.length + customHandlers.length];
        System.arraycopy(transitionExecutingHandlers, 0, exceptionHandlers, 0, transitionExecutingHandlers.length);
        System.arraycopy(customHandlers, 0, exceptionHandlers, transitionExecutingHandlers.length, customHandlers.length);
        return exceptionHandlers;
    }

    private FlowExecutionExceptionHandler[] parseTransitionExecutingExceptionHandlers(Element element) {
        List transitionElements = Collections.EMPTY_LIST;
        if (this.isFlowElement(element)) {
            Element globalTransitionsElement = this.getChildElementByTagName(element, GLOBAL_TRANSITIONS_ELEMENT);
            if (globalTransitionsElement != null) {
                transitionElements = DomUtils.getChildElementsByTagName((Element)globalTransitionsElement, (String)TRANSITION_ELEMENT);
            }
        } else {
            transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)TRANSITION_ELEMENT);
        }
        LinkedList<FlowExecutionExceptionHandler> exceptionHandlers = new LinkedList<FlowExecutionExceptionHandler>();
        Iterator it = transitionElements.iterator();
        while (it.hasNext()) {
            Element transitionElement = (Element)it.next();
            if (!StringUtils.hasText((String)transitionElement.getAttribute(ON_EXCEPTION_ATTRIBUTE))) continue;
            exceptionHandlers.add(this.parseTransitionExecutingExceptionHandler(transitionElement));
        }
        return exceptionHandlers.toArray(new FlowExecutionExceptionHandler[exceptionHandlers.size()]);
    }

    private FlowExecutionExceptionHandler parseTransitionExecutingExceptionHandler(Element element) {
        TransitionExecutingStateExceptionHandler handler = new TransitionExecutingStateExceptionHandler();
        Class exceptionClass = (Class)this.fromStringTo(class$java$lang$Class == null ? (class$java$lang$Class = XmlFlowBuilder.class$("java.lang.Class")) : class$java$lang$Class).execute((Object)element.getAttribute(ON_EXCEPTION_ATTRIBUTE));
        TargetStateResolver targetStateResolver = (TargetStateResolver)this.fromStringTo(class$org$springframework$webflow$engine$TargetStateResolver == null ? (class$org$springframework$webflow$engine$TargetStateResolver = XmlFlowBuilder.class$("org.springframework.webflow.engine.TargetStateResolver")) : class$org$springframework$webflow$engine$TargetStateResolver).execute((Object)element.getAttribute(TO_ATTRIBUTE));
        handler.add(exceptionClass, targetStateResolver);
        handler.getActionList().addAll(this.parseAnnotatedActions(element));
        return handler;
    }

    private FlowExecutionExceptionHandler[] parseCustomExceptionHandlers(Element element) {
        LinkedList<FlowExecutionExceptionHandler> exceptionHandlers = new LinkedList<FlowExecutionExceptionHandler>();
        List handlerElements = DomUtils.getChildElementsByTagName((Element)element, (String)EXCEPTION_HANDLER_ELEMENT);
        for (int i = 0; i < handlerElements.size(); ++i) {
            Element handlerElement = (Element)handlerElements.get(i);
            exceptionHandlers.add(this.parseCustomExceptionHandler(handlerElement));
        }
        return exceptionHandlers.toArray(new FlowExecutionExceptionHandler[exceptionHandlers.size()]);
    }

    private FlowExecutionExceptionHandler parseCustomExceptionHandler(Element element) {
        return this.getLocalFlowServiceLocator().getExceptionHandler(element.getAttribute(BEAN_ATTRIBUTE));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

