/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import java.util.ListIterator;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.impl.FlowExecutionImpl;
import org.springframework.webflow.engine.impl.FlowExecutionListeners;
import org.springframework.webflow.engine.impl.FlowSessionImpl;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;
import org.springframework.webflow.execution.factory.StaticFlowExecutionListenerLoader;
import org.springframework.webflow.execution.repository.support.FlowExecutionStateRestorer;

public class FlowExecutionImplStateRestorer
implements FlowExecutionStateRestorer {
    private FlowDefinitionLocator definitionLocator;
    private FlowExecutionListenerLoader executionListenerLoader = StaticFlowExecutionListenerLoader.EMPTY_INSTANCE;
    private AttributeMap executionAttributes = CollectionUtils.EMPTY_ATTRIBUTE_MAP;

    public FlowExecutionImplStateRestorer(FlowDefinitionLocator definitionLocator) {
        Assert.notNull((Object)definitionLocator, (String)"The flow definition locator is required");
        this.definitionLocator = definitionLocator;
    }

    public void setExecutionAttributes(AttributeMap executionAttributes) {
        Assert.notNull((Object)executionAttributes, (String)"The execution attributes map is required");
        this.executionAttributes = executionAttributes;
    }

    public void setExecutionAttributesMap(Map executionAttributes) {
        Assert.notNull((Object)executionAttributes, (String)"The execution attributes map is required");
        this.executionAttributes = new LocalAttributeMap(executionAttributes);
    }

    public void setExecutionListenerLoader(FlowExecutionListenerLoader executionListenerLoader) {
        Assert.notNull((Object)executionListenerLoader, (String)"The listener loader is required");
        this.executionListenerLoader = executionListenerLoader;
    }

    public FlowExecution restoreState(FlowExecution flowExecution, MutableAttributeMap conversationScope) {
        FlowExecutionImpl impl = (FlowExecutionImpl)flowExecution;
        Flow flow = (Flow)this.definitionLocator.getFlowDefinition(impl.getFlowId());
        impl.setFlow(flow);
        if (impl.hasSessions()) {
            FlowSessionImpl root = impl.getRootSession();
            root.setFlow(flow);
            root.setState(flow.getStateInstance(root.getStateId()));
            if (impl.hasSubflowSessions()) {
                Flow parent = flow;
                ListIterator it = impl.getSubflowSessionIterator();
                while (it.hasNext()) {
                    FlowSessionImpl subflow = (FlowSessionImpl)it.next();
                    Flow definition = parent.containsInlineFlow(subflow.getFlowId()) ? parent.getInlineFlow(subflow.getFlowId()) : (Flow)this.definitionLocator.getFlowDefinition(subflow.getFlowId());
                    subflow.setFlow(definition);
                    subflow.setState(definition.getStateInstance(subflow.getStateId()));
                    parent = definition;
                }
            }
        }
        if (conversationScope == null) {
            conversationScope = new LocalAttributeMap();
        }
        impl.setConversationScope(conversationScope);
        impl.setListeners(new FlowExecutionListeners(this.executionListenerLoader.getListeners(flow)));
        impl.setAttributes(this.executionAttributes);
        return flowExecution;
    }
}

