/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.FlowSessionStatus;

class FlowSessionImpl
implements FlowSession,
Externalizable {
    private transient Flow flow;
    private String flowId;
    private transient State state;
    private String stateId;
    private FlowSessionStatus status = FlowSessionStatus.CREATED;
    private MutableAttributeMap scope = new LocalAttributeMap();
    private MutableAttributeMap flashMap = new LocalAttributeMap();
    private FlowSessionImpl parent;

    public FlowSessionImpl() {
    }

    public FlowSessionImpl(Flow flow, FlowSessionImpl parent) {
        this.setFlow(flow);
        this.parent = parent;
    }

    public FlowDefinition getDefinition() {
        return this.flow;
    }

    public StateDefinition getState() {
        return this.state;
    }

    public FlowSessionStatus getStatus() {
        return this.status;
    }

    public MutableAttributeMap getScope() {
        return this.scope;
    }

    public MutableAttributeMap getFlashMap() {
        return this.flashMap;
    }

    public FlowSession getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.flowId = (String)in.readObject();
        this.stateId = (String)in.readObject();
        this.status = (FlowSessionStatus)((Object)in.readObject());
        this.scope = (MutableAttributeMap)in.readObject();
        this.flashMap = (MutableAttributeMap)in.readObject();
        this.parent = (FlowSessionImpl)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.flowId);
        out.writeObject(this.stateId);
        out.writeObject((Object)this.status);
        out.writeObject(this.scope);
        out.writeObject(this.flashMap);
        out.writeObject(this.parent);
    }

    void setFlow(Flow flow) {
        Assert.notNull((Object)flow, (String)"The flow is required");
        this.flow = flow;
        this.flowId = flow.getId();
    }

    void setState(State state) {
        Assert.notNull((Object)state, (String)"The state is required");
        Assert.isTrue((this.flow == state.getOwner() ? 1 : 0) != 0, (String)"The state does not belong to the flow associated with this flow session");
        this.state = state;
        this.stateId = state.getId();
    }

    void setStatus(FlowSessionStatus status) {
        Assert.notNull((Object)((Object)status), (String)"The flow session status is requred");
        this.status = status;
    }

    String getFlowId() {
        return this.flowId;
    }

    String getStateId() {
        return this.stateId;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flow", (Object)this.flowId).append("state", (Object)this.stateId).append("scope", (Object)this.scope).append("flashMap", (Object)this.flashMap).append("status", (Object)this.status).toString();
    }
}

