/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ClobDBAccess;
import oracle.sql.DatumWithConnection;

public class CLOB
extends DatumWithConnection
implements Clob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    ClobDBAccess dbaccess;
    private int dbChunkSize;
    private short csform;
    boolean isFree = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:32:03_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected CLOB() {
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (byArray != null) {
            this.csform = (byArray[5] & 0xC0) == 64 ? (short)2 : (short)1;
        }
        CLOB.assertNotNull(oracleConnection);
        this.setPhysicalConnectionOf(oracleConnection);
        this.dbaccess = ((OracleConnection)oracleConnection).createClobDBAccess();
        this.dbChunkSize = -1;
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, short s2) throws SQLException {
        this(oracleConnection, byArray);
        this.csform = s2;
    }

    public boolean isNCLOB() {
        return this.csform == 2;
    }

    @Override
    public long length() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().length(this);
    }

    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        char[] cArray;
        int n3;
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        if (n2 < 0 || l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68);
        }
        String string = null;
        string = n2 == 0 ? new String() : ((n3 = this.getChars(l2, n2, cArray = new char[n2])) > 0 ? new String(cArray, 0, n3) : new String());
        return string;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), 0L);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    @Override
    public long position(String string, long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().position(this, string, l2);
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().position(this, (CLOB)clob, l2);
    }

    public int getChars(long l2, int n2, char[] cArray) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().getChars(this, l2, n2, cArray);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.setCharacterStream(0L);
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.setAsciiStream(0L);
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public int putChars(long l2, char[] cArray) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().putChars(this, l2, cArray, 0, cArray != null ? cArray.length : 0);
    }

    public int putChars(long l2, char[] cArray, int n2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().putChars(this, l2, cArray, 0, n2);
    }

    public int putChars(long l2, char[] cArray, int n2, int n3) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().putChars(this, l2, cArray, n2, n3);
    }

    public int putString(long l2, String string) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.setString(l2, string);
    }

    public int getChunkSize() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        if (this.dbChunkSize <= 0) {
            this.dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.dbChunkSize;
    }

    public int getBufferSize() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        int n2 = this.getChunkSize();
        int n3 = 0;
        n3 = n2 >= 32768 || n2 <= 0 ? 32768 : 32768 / n2 * n2;
        return n3;
    }

    public static CLOB empty_lob() throws SQLException {
        return CLOB.getEmptyCLOB();
    }

    public static CLOB getEmptyCLOB() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        CLOB cLOB = new CLOB();
        cLOB.setShareBytes(byArray);
        return cLOB;
    }

    public boolean isEmptyLob() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    public OutputStream getAsciiOutputStream(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.setAsciiStream(l2);
    }

    public Writer getCharacterOutputStream(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.setCharacterStream(l2);
    }

    public InputStream getAsciiStream(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l2);
    }

    public Reader getCharacterStream(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), l2);
    }

    public void trim(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        this.truncate(l2);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n2) throws SQLException {
        return CLOB.createTemporary(connection, bl, n2, (short)1);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n2, short s2) throws SQLException {
        int n3 = n2;
        if (n2 == 1) {
            n3 = 10;
        }
        if (n2 == 2) {
            n3 = 12;
        }
        if (connection == null || n3 != 10 && n3 != 12) {
            DatabaseError.throwSqlException(null, 68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or DURATION_CALL");
        }
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        CLOB cLOB = CLOB.getDBAccess(oracleConnection).createTemporaryClob(oracleConnection, bl, n3, s2);
        cLOB.csform = s2;
        return cLOB;
    }

    public static void freeTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return;
        }
        cLOB.freeTemporary();
    }

    public static boolean isTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return false;
        }
        return cLOB.isTemporary();
    }

    public void freeTemporary() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        this.getDBAccess().freeTemporary(this);
    }

    public boolean isTemporary() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().isTemporary(this);
    }

    public void open(int n2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        this.getDBAccess().open(this, n2);
    }

    public void close() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().isOpen(this);
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1");
        }
        int n2 = 0;
        if (string != null && string.length() != 0) {
            n2 = this.putChars(l2, string.toCharArray());
        }
        return n2;
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        if (l2 < 1L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1");
        }
        if (n2 < 0) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, "'offset' should not be < 0");
        }
        if (n2 + n3 > string.length()) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'offset + len' should not be exceed string length. ");
        }
        int n4 = 0;
        if (string != null && string.length() != 0) {
            n4 = this.putChars(l2, string.toCharArray(), n2, n3);
        }
        return n4;
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l2);
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().newWriter(this, this.getBufferSize(), l2);
    }

    @Override
    public void truncate(long l2) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        if (l2 < 0L) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'len' should not be < 0");
        }
        this.getDBAccess().trim(this, l2);
    }

    @Override
    public Object toJdbc() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return this.getCharacterStream();
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new CLOB[n2];
    }

    public ClobDBAccess getDBAccess() throws SQLException {
        if (this.dbaccess == null) {
            if (this.isEmptyLob()) {
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 98);
            }
            this.dbaccess = this.getInternalConnection().createClobDBAccess();
        }
        if (this.getPhysicalConnection().isClosed()) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 8);
        }
        return this.dbaccess;
    }

    public static ClobDBAccess getDBAccess(Connection connection) throws SQLException {
        return ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().createClobDBAccess();
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return super.getJavaSqlConnection();
    }

    @Override
    public void free() throws SQLException {
        if (this.isOpen()) {
            this.close();
        }
        if (this.isTemporary()) {
            this.freeTemporary();
        }
        this.isFree = true;
        this.dbaccess = null;
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        if (this.isFree) {
            DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 192);
        }
        return this.getDBAccess().newReader(this, this.getChunkSize(), l2, l3);
    }
}

