/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.registry.jrmp;

import java.net.InetAddress;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.ow2.carol.jndi.registry.RMIManageableSocketFactory;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.carol.util.configuration.TraceCarol;
import sun.rmi.registry.RegistryImpl;

public class ManageableRegistry
extends RegistryImpl {
    private static final long serialVersionUID = 8643654737653985265L;
    private static final int INITIAL_CAPACITY = 101;
    private Hashtable<String, Remote> registryObjects = new Hashtable(101);
    private static boolean verbose = false;

    private ManageableRegistry(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    private ManageableRegistry(int port) throws RemoteException {
        this(port, RMISocketFactory.getSocketFactory(), RMISocketFactory.getSocketFactory());
    }

    public void setVerbose(boolean v) {
        System.out.println("RegistryManager.setVerbose(" + v + ")");
        verbose = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote lookup(String name) throws RemoteException, NotBoundException {
        if (verbose) {
            try {
                System.out.println("ManageableRegistry.lookup(" + name + ") from client: " + ManageableRegistry.getClientHost());
            }
            catch (ServerNotActiveException e) {
                e.printStackTrace();
            }
        }
        Hashtable<String, Remote> hashtable = this.registryObjects;
        synchronized (hashtable) {
            Remote obj = this.registryObjects.get(name);
            if (obj == null) {
                throw new NotBoundException(name);
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
        if (verbose) {
            try {
                System.out.println("ManageableRegistry.bind(" + name + ", obj)" + " from client: " + ManageableRegistry.getClientHost());
            }
            catch (ServerNotActiveException e) {
                e.printStackTrace();
            }
        }
        Hashtable<String, Remote> hashtable = this.registryObjects;
        synchronized (hashtable) {
            Remote curr = this.registryObjects.get(name);
            if (curr != null) {
                throw new AlreadyBoundException(name);
            }
            this.registryObjects.put(name, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
        if (verbose) {
            try {
                System.out.println("ManageableRegistry.unbind(" + name + ")" + " from client: " + ManageableRegistry.getClientHost());
            }
            catch (ServerNotActiveException e) {
                e.printStackTrace();
            }
        }
        Hashtable<String, Remote> hashtable = this.registryObjects;
        synchronized (hashtable) {
            Remote obj = this.registryObjects.get(name);
            if (obj == null) {
                throw new NotBoundException(name);
            }
            this.registryObjects.remove(name);
        }
    }

    public void rebind(String name, Remote obj) throws RemoteException, AccessException {
        if (verbose) {
            try {
                System.out.println("ManageableRegistry.rebind(" + name + ", obj)" + " from client: " + ManageableRegistry.getClientHost());
            }
            catch (ServerNotActiveException e) {
                e.printStackTrace();
            }
        }
        this.registryObjects.put(name, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list() throws RemoteException {
        String[] names;
        if (verbose) {
            try {
                System.out.println("ManageableRegistry.list() from client: " + ManageableRegistry.getClientHost());
            }
            catch (ServerNotActiveException e) {
                e.printStackTrace();
            }
        }
        Hashtable<String, Remote> hashtable = this.registryObjects;
        synchronized (hashtable) {
            int i = this.registryObjects.size();
            names = new String[i];
            Enumeration<String> e = this.registryObjects.keys();
            while (--i >= 0) {
                names[i] = e.nextElement();
            }
        }
        return names;
    }

    public static Registry createManagableRegistry(int port, int objectPort, InetAddress inetAddress) throws RemoteException {
        if (objectPort > 0 || inetAddress != null) {
            String protocol = null;
            try {
                protocol = ConfigurationRepository.getCurrentConfiguration().getProtocol().getName();
            }
            catch (Exception e) {
                protocol = null;
            }
            if (protocol == null || protocol.equals("")) {
                TraceCarol.infoCarol("Unknown protocol - setting jrmp");
                protocol = "jrmp";
            }
            RMISocketFactory socketFactory = RMIManageableSocketFactory.register(port, objectPort, inetAddress, protocol);
            return new ManageableRegistry(port, socketFactory, socketFactory);
        }
        return new ManageableRegistry(port);
    }

    public void purge() {
        this.registryObjects.clear();
    }

    public static void main(String[] args) {
        try {
            int regPort = 1099;
            if (args.length >= 1) {
                regPort = Integer.parseInt(args[0]);
            }
            ManageableRegistry.createManagableRegistry(regPort, 0, null);
            System.out.println("ManageableRegistry started on port " + regPort);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

