/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.client;

import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private static final long CHANNEL_EXPIRED_TIMEOUT = 120000L;
    private final Lock groupChannelLock = new ReentrantLock();
    private final HashMap<String, HashMap<Channel, ClientChannelInfo>> groupChannelTable = new HashMap();

    public HashMap<String, HashMap<Channel, ClientChannelInfo>> getGroupChannelTable() {
        HashMap<String, HashMap<Channel, ClientChannelInfo>> newGroupChannelTable;
        block5: {
            newGroupChannelTable = new HashMap<String, HashMap<Channel, ClientChannelInfo>>();
            try {
                if (!this.groupChannelLock.tryLock(3000L, TimeUnit.MILLISECONDS)) break block5;
                try {
                    newGroupChannelTable.putAll(this.groupChannelTable);
                }
                finally {
                    this.groupChannelLock.unlock();
                }
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
        }
        return newGroupChannelTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanNotActiveChannel() {
        block8: {
            try {
                if (this.groupChannelLock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        for (Map.Entry<String, HashMap<Channel, ClientChannelInfo>> entry : this.groupChannelTable.entrySet()) {
                            String group = entry.getKey();
                            HashMap<Channel, ClientChannelInfo> chlMap = entry.getValue();
                            Iterator<Map.Entry<Channel, ClientChannelInfo>> it = chlMap.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry<Channel, ClientChannelInfo> item = it.next();
                                ClientChannelInfo info = item.getValue();
                                long diff = System.currentTimeMillis() - info.getLastUpdateTimestamp();
                                if (diff <= 120000L) continue;
                                it.remove();
                                log.warn("SCAN: remove expired channel[{}] from ProducerManager groupChannelTable, producer group name: {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)info.getChannel()), (Object)group);
                                RemotingUtil.closeChannel((Channel)info.getChannel());
                            }
                        }
                        break block8;
                    }
                    finally {
                        this.groupChannelLock.unlock();
                    }
                }
                log.warn("ProducerManager scanNotActiveChannel lock timeout");
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doChannelCloseEvent(String remoteAddr, Channel channel) {
        block8: {
            if (channel != null) {
                try {
                    if (this.groupChannelLock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                        try {
                            for (Map.Entry<String, HashMap<Channel, ClientChannelInfo>> entry : this.groupChannelTable.entrySet()) {
                                String group = entry.getKey();
                                HashMap<Channel, ClientChannelInfo> clientChannelInfoTable = entry.getValue();
                                ClientChannelInfo clientChannelInfo = clientChannelInfoTable.remove(channel);
                                if (clientChannelInfo == null) continue;
                                log.info("NETTY EVENT: remove channel[{}][{}] from ProducerManager groupChannelTable, producer group: {}", new Object[]{clientChannelInfo.toString(), remoteAddr, group});
                            }
                            break block8;
                        }
                        finally {
                            this.groupChannelLock.unlock();
                        }
                    }
                    log.warn("ProducerManager doChannelCloseEvent lock timeout");
                }
                catch (InterruptedException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProducer(String group, ClientChannelInfo clientChannelInfo) {
        block10: {
            try {
                ClientChannelInfo clientChannelInfoFound = null;
                if (this.groupChannelLock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        HashMap<Object, ClientChannelInfo> channelTable = this.groupChannelTable.get(group);
                        if (null == channelTable) {
                            channelTable = new HashMap();
                            this.groupChannelTable.put(group, channelTable);
                        }
                        if (null == (clientChannelInfoFound = channelTable.get(clientChannelInfo.getChannel()))) {
                            channelTable.put(clientChannelInfo.getChannel(), clientChannelInfo);
                            log.info("new producer connected, group: {} channel: {}", (Object)group, (Object)clientChannelInfo.toString());
                        }
                    }
                    finally {
                        this.groupChannelLock.unlock();
                    }
                    if (clientChannelInfoFound != null) {
                        clientChannelInfoFound.setLastUpdateTimestamp(System.currentTimeMillis());
                    }
                    break block10;
                }
                log.warn("ProducerManager registerProducer lock timeout");
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProducer(String group, ClientChannelInfo clientChannelInfo) {
        block9: {
            try {
                if (this.groupChannelLock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        HashMap<Channel, ClientChannelInfo> channelTable = this.groupChannelTable.get(group);
                        if (null != channelTable && !channelTable.isEmpty()) {
                            ClientChannelInfo old = channelTable.remove(clientChannelInfo.getChannel());
                            if (old != null) {
                                log.info("unregister a producer[{}] from groupChannelTable {}", (Object)group, (Object)clientChannelInfo.toString());
                            }
                            if (channelTable.isEmpty()) {
                                this.groupChannelTable.remove(group);
                                log.info("unregister a producer group[{}] from groupChannelTable", (Object)group);
                            }
                        }
                        break block9;
                    }
                    finally {
                        this.groupChannelLock.unlock();
                    }
                }
                log.warn("ProducerManager unregisterProducer lock timeout");
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
        }
    }
}

