/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.internal;

import io.openmessaging.KeyValue;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultKeyValue
implements KeyValue {
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();

    @Override
    public KeyValue put(String key, int value) {
        this.properties.put(key, String.valueOf(value));
        return this;
    }

    @Override
    public KeyValue put(String key, long value) {
        this.properties.put(key, String.valueOf(value));
        return this;
    }

    @Override
    public KeyValue put(String key, double value) {
        this.properties.put(key, String.valueOf(value));
        return this;
    }

    @Override
    public KeyValue put(String key, String value) {
        this.properties.put(key, String.valueOf(value));
        return this;
    }

    @Override
    public int getInt(String key) {
        if (!this.properties.containsKey(key)) {
            return 0;
        }
        return Integer.valueOf(this.properties.get(key));
    }

    @Override
    public long getLong(String key) {
        if (!this.properties.containsKey(key)) {
            return 0L;
        }
        return Long.valueOf(this.properties.get(key));
    }

    @Override
    public double getDouble(String key) {
        if (!this.properties.containsKey(key)) {
            return 0.0;
        }
        return Double.valueOf(this.properties.get(key));
    }

    @Override
    public String getString(String key) {
        return this.properties.get(key);
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }
}

