/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.log;

import java.lang.reflect.Method;
import java.net.URL;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLogger {
    public static final String CLIENT_LOG_ROOT = "rocketmq.client.logRoot";
    public static final String CLIENT_LOG_MAXINDEX = "rocketmq.client.logFileMaxIndex";
    public static final String CLIENT_LOG_LEVEL = "rocketmq.client.logLevel";
    private static Logger log;

    private static Logger createLogger(String loggerName) {
        String logConfigFilePath = System.getProperty("rocketmq.client.log.configFile", System.getenv("ROCKETMQ_CLIENT_LOG_CONFIGFILE"));
        Boolean isloadconfig = Boolean.parseBoolean(System.getProperty("rocketmq.client.log.loadconfig", "true"));
        String log4JResourceFile = System.getProperty("rocketmq.client.log4j.resource.fileName", "log4j_rocketmq_client.xml");
        String logbackResourceFile = System.getProperty("rocketmq.client.logback.resource.fileName", "logback_rocketmq_client.xml");
        String log4J2ResourceFile = System.getProperty("rocketmq.client.log4j2.resource.fileName", "log4j2_rocketmq_client.xml");
        String clientLogRoot = System.getProperty(CLIENT_LOG_ROOT, System.getProperty("user.home") + "/logs/rocketmqlogs");
        System.setProperty("client.logRoot", clientLogRoot);
        String clientLogLevel = System.getProperty(CLIENT_LOG_LEVEL, "INFO");
        System.setProperty("client.logLevel", clientLogLevel);
        String clientLogMaxIndex = System.getProperty(CLIENT_LOG_MAXINDEX, "10");
        System.setProperty("client.logFileMaxIndex", clientLogMaxIndex);
        if (isloadconfig.booleanValue()) {
            try {
                ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
                Class<?> classType = iLoggerFactory.getClass();
                if (classType.getName().equals("org.slf4j.impl.Log4jLoggerFactory")) {
                    Class<?> domconfigurator = Class.forName("org.apache.log4j.xml.DOMConfigurator");
                    Object domconfiguratorobj = domconfigurator.newInstance();
                    if (null == logConfigFilePath) {
                        Method configure = domconfiguratorobj.getClass().getMethod("configure", URL.class);
                        URL url = ClientLogger.class.getClassLoader().getResource(log4JResourceFile);
                        configure.invoke(domconfiguratorobj, url);
                    } else {
                        Method configure = domconfiguratorobj.getClass().getMethod("configure", String.class);
                        configure.invoke(domconfiguratorobj, logConfigFilePath);
                    }
                } else if (classType.getName().equals("ch.qos.logback.classic.LoggerContext")) {
                    Class<?> context = Class.forName("ch.qos.logback.core.Context");
                    Class<?> joranConfigurator = Class.forName("ch.qos.logback.classic.joran.JoranConfigurator");
                    Object joranConfiguratoroObj = joranConfigurator.newInstance();
                    Method setContext = joranConfiguratoroObj.getClass().getMethod("setContext", context);
                    setContext.invoke(joranConfiguratoroObj, iLoggerFactory);
                    if (null == logConfigFilePath) {
                        URL url = ClientLogger.class.getClassLoader().getResource(logbackResourceFile);
                        Method doConfigure = joranConfiguratoroObj.getClass().getMethod("doConfigure", URL.class);
                        doConfigure.invoke(joranConfiguratoroObj, url);
                    } else {
                        Method doConfigure = joranConfiguratoroObj.getClass().getMethod("doConfigure", String.class);
                        doConfigure.invoke(joranConfiguratoroObj, logConfigFilePath);
                    }
                } else if (classType.getName().equals("org.apache.logging.slf4j.Log4jLoggerFactory")) {
                    Class<?> joranConfigurator = Class.forName("org.apache.logging.log4j.core.config.Configurator");
                    Method initialize = joranConfigurator.getDeclaredMethod("initialize", String.class, String.class);
                    if (null == logConfigFilePath) {
                        initialize.invoke(joranConfigurator, "log4j2", log4J2ResourceFile);
                    } else {
                        initialize.invoke(joranConfigurator, "log4j2", logConfigFilePath);
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        return LoggerFactory.getLogger((String)"RocketmqClient");
    }

    public static Logger getLog() {
        if (log == null) {
            log = ClientLogger.createLogger("RocketmqClient");
            return log;
        }
        return log;
    }

    public static void setLog(Logger log) {
        ClientLogger.log = log;
    }
}

