/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filtersrv.filter;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.filter.MessageFilter;
import org.apache.rocketmq.filtersrv.FiltersrvController;
import org.apache.rocketmq.filtersrv.filter.DynaCode;
import org.apache.rocketmq.filtersrv.filter.FilterClassFetchMethod;
import org.apache.rocketmq.filtersrv.filter.FilterClassInfo;
import org.apache.rocketmq.filtersrv.filter.HttpFilterClassFetchMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterClassManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqFiltersrv");
    private final Object compileLock = new Object();
    private final FiltersrvController filtersrvController;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("FSGetClassScheduledThread"));
    private ConcurrentMap<String, FilterClassInfo> filterClassTable = new ConcurrentHashMap<String, FilterClassInfo>(128);
    private FilterClassFetchMethod filterClassFetchMethod;

    public FilterClassManager(FiltersrvController filtersrvController) {
        this.filtersrvController = filtersrvController;
        this.filterClassFetchMethod = new HttpFilterClassFetchMethod(this.filtersrvController.getFiltersrvConfig().getFilterClassRepertoryUrl());
    }

    private static String buildKey(String consumerGroup, String topic) {
        return topic + "@" + consumerGroup;
    }

    public void start() {
        if (!this.filtersrvController.getFiltersrvConfig().isClientUploadFilterClassEnable()) {
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    FilterClassManager.this.fetchClassFromRemoteHost();
                }
            }, 1L, 1L, TimeUnit.MINUTES);
        }
    }

    private void fetchClassFromRemoteHost() {
        Iterator it = this.filterClassTable.entrySet().iterator();
        while (it.hasNext()) {
            try {
                Map.Entry next = it.next();
                FilterClassInfo filterClassInfo = (FilterClassInfo)next.getValue();
                String[] topicAndGroup = ((String)next.getKey()).split("@");
                String responseStr = this.filterClassFetchMethod.fetch(topicAndGroup[0], topicAndGroup[1], filterClassInfo.getClassName());
                byte[] filterSourceBinary = responseStr.getBytes("UTF-8");
                int classCRC = UtilAll.crc32((byte[])responseStr.getBytes("UTF-8"));
                if (classCRC == filterClassInfo.getClassCRC()) continue;
                String javaSource = new String(filterSourceBinary, "UTF-8");
                Class<?> newClass = DynaCode.compileAndLoadClass(filterClassInfo.getClassName(), javaSource);
                Object newInstance = newClass.newInstance();
                filterClassInfo.setMessageFilter((MessageFilter)newInstance);
                filterClassInfo.setClassCRC(classCRC);
                log.info("fetch Remote class File OK, {} {}", next.getKey(), (Object)filterClassInfo.getClassName());
            }
            catch (Exception e) {
                log.error("fetchClassFromRemoteHost Exception", (Throwable)e);
            }
        }
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerFilterClass(String consumerGroup, String topic, String className, int classCRC, byte[] filterSourceBinary) {
        String key = FilterClassManager.buildKey(consumerGroup, topic);
        boolean registerNew = false;
        FilterClassInfo filterClassInfoPrev = (FilterClassInfo)this.filterClassTable.get(key);
        if (null == filterClassInfoPrev) {
            registerNew = true;
        } else if (this.filtersrvController.getFiltersrvConfig().isClientUploadFilterClassEnable() && filterClassInfoPrev.getClassCRC() != classCRC && classCRC != 0) {
            registerNew = true;
        }
        if (registerNew) {
            Object object = this.compileLock;
            synchronized (object) {
                filterClassInfoPrev = (FilterClassInfo)this.filterClassTable.get(key);
                if (null != filterClassInfoPrev && filterClassInfoPrev.getClassCRC() == classCRC) {
                    return true;
                }
                try {
                    FilterClassInfo filterClassInfoNew = new FilterClassInfo();
                    filterClassInfoNew.setClassName(className);
                    filterClassInfoNew.setClassCRC(0);
                    filterClassInfoNew.setMessageFilter(null);
                    if (this.filtersrvController.getFiltersrvConfig().isClientUploadFilterClassEnable()) {
                        String javaSource = new String(filterSourceBinary, "UTF-8");
                        Class<?> newClass = DynaCode.compileAndLoadClass(className, javaSource);
                        Object newInstance = newClass.newInstance();
                        filterClassInfoNew.setMessageFilter((MessageFilter)newInstance);
                        filterClassInfoNew.setClassCRC(classCRC);
                    }
                    this.filterClassTable.put(key, filterClassInfoNew);
                }
                catch (Throwable e) {
                    String info = String.format("FilterServer, registerFilterClass Exception, consumerGroup: %s topic: %s className: %s", consumerGroup, topic, className);
                    log.error(info, e);
                    return false;
                }
            }
        }
        return true;
    }

    public FilterClassInfo findFilterClass(String consumerGroup, String topic) {
        return (FilterClassInfo)this.filterClassTable.get(FilterClassManager.buildKey(consumerGroup, topic));
    }

    public FilterClassFetchMethod getFilterClassFetchMethod() {
        return this.filterClassFetchMethod;
    }

    public void setFilterClassFetchMethod(FilterClassFetchMethod filterClassFetchMethod) {
        this.filterClassFetchMethod = filterClassFetchMethod;
    }
}

