/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.producer;

import io.openmessaging.BytesMessage;
import io.openmessaging.KeyValue;
import io.openmessaging.Message;
import io.openmessaging.Producer;
import io.openmessaging.Promise;
import io.openmessaging.SendResult;
import io.openmessaging.exception.OMSRuntimeException;
import io.openmessaging.rocketmq.producer.AbstractOMSProducer;
import io.openmessaging.rocketmq.promise.DefaultPromise;
import io.openmessaging.rocketmq.utils.OMSUtil;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendStatus;

public class ProducerImpl
extends AbstractOMSProducer
implements Producer {
    public ProducerImpl(KeyValue properties) {
        super(properties);
    }

    public KeyValue properties() {
        return this.properties;
    }

    public SendResult send(Message message) {
        return this.send(message, this.rocketmqProducer.getSendMsgTimeout());
    }

    public SendResult send(Message message, KeyValue properties) {
        long timeout = properties.containsKey("oms.operation.timeout") ? (long)properties.getInt("oms.operation.timeout") : (long)this.rocketmqProducer.getSendMsgTimeout();
        return this.send(message, timeout);
    }

    private SendResult send(Message message, long timeout) {
        this.checkMessageType(message);
        org.apache.rocketmq.common.message.Message rmqMessage = OMSUtil.msgConvert((BytesMessage)message);
        try {
            org.apache.rocketmq.client.producer.SendResult rmqResult = this.rocketmqProducer.send(rmqMessage, timeout);
            if (!rmqResult.getSendStatus().equals((Object)SendStatus.SEND_OK)) {
                log.error(String.format("Send message to RocketMQ failed, %s", message));
                throw new OMSRuntimeException("-1", "Send message to RocketMQ broker failed.");
            }
            message.headers().put("MessageId", rmqResult.getMsgId());
            return OMSUtil.sendResultConvert(rmqResult);
        }
        catch (Exception e) {
            log.error(String.format("Send message to RocketMQ failed, %s", message), (Throwable)e);
            throw this.checkProducerException(rmqMessage.getTopic(), message.headers().getString("MessageId"), e);
        }
    }

    public Promise<SendResult> sendAsync(Message message) {
        return this.sendAsync(message, this.rocketmqProducer.getSendMsgTimeout());
    }

    public Promise<SendResult> sendAsync(Message message, KeyValue properties) {
        long timeout = properties.containsKey("oms.operation.timeout") ? (long)properties.getInt("oms.operation.timeout") : (long)this.rocketmqProducer.getSendMsgTimeout();
        return this.sendAsync(message, timeout);
    }

    private Promise<SendResult> sendAsync(final Message message, long timeout) {
        this.checkMessageType(message);
        org.apache.rocketmq.common.message.Message rmqMessage = OMSUtil.msgConvert((BytesMessage)message);
        final DefaultPromise<SendResult> promise = new DefaultPromise<SendResult>();
        try {
            this.rocketmqProducer.send(rmqMessage, new SendCallback(){

                public void onSuccess(org.apache.rocketmq.client.producer.SendResult rmqResult) {
                    message.headers().put("MessageId", rmqResult.getMsgId());
                    promise.set((Object)OMSUtil.sendResultConvert(rmqResult));
                }

                public void onException(Throwable e) {
                    promise.setFailure(e);
                }
            }, timeout);
        }
        catch (Exception e) {
            promise.setFailure(e);
        }
        return promise;
    }

    public void sendOneway(Message message) {
        this.checkMessageType(message);
        org.apache.rocketmq.common.message.Message rmqMessage = OMSUtil.msgConvert((BytesMessage)message);
        try {
            this.rocketmqProducer.sendOneway(rmqMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendOneway(Message message, KeyValue properties) {
        this.sendOneway(message);
    }
}

