/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.producer;

import io.openmessaging.BytesMessage;
import io.openmessaging.KeyValue;
import io.openmessaging.Message;
import io.openmessaging.SequenceProducer;
import io.openmessaging.rocketmq.producer.AbstractOMSProducer;
import io.openmessaging.rocketmq.utils.OMSUtil;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.rocketmq.client.Validators;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;

public class SequenceProducerImpl
extends AbstractOMSProducer
implements SequenceProducer {
    private BlockingQueue<Message> msgCacheQueue = new LinkedBlockingQueue<Message>();

    public SequenceProducerImpl(KeyValue properties) {
        super(properties);
    }

    public KeyValue properties() {
        return this.properties;
    }

    public void send(Message message) {
        this.checkMessageType(message);
        org.apache.rocketmq.common.message.Message rmqMessage = OMSUtil.msgConvert((BytesMessage)message);
        try {
            Validators.checkMessage((org.apache.rocketmq.common.message.Message)rmqMessage, (DefaultMQProducer)this.rocketmqProducer);
        }
        catch (MQClientException e) {
            throw this.checkProducerException(rmqMessage.getTopic(), message.headers().getString("MessageId"), e);
        }
        this.msgCacheQueue.add(message);
    }

    public void send(Message message, KeyValue properties) {
        this.send(message);
    }

    public synchronized void commit() {
        ArrayList messages = new ArrayList();
        this.msgCacheQueue.drainTo(messages);
        ArrayList<org.apache.rocketmq.common.message.Message> rmqMessages = new ArrayList<org.apache.rocketmq.common.message.Message>();
        for (Message message : messages) {
            rmqMessages.add(OMSUtil.msgConvert((BytesMessage)message));
        }
        if (rmqMessages.size() == 0) {
            return;
        }
        try {
            SendResult sendResult = this.rocketmqProducer.send(rmqMessages);
            String[] msgIdArray = sendResult.getMsgId().split(",");
            for (int i = 0; i < messages.size(); ++i) {
                Message message = (Message)messages.get(i);
                message.headers().put("MessageId", msgIdArray[i]);
            }
        }
        catch (Exception e) {
            throw this.checkProducerException("", "", e);
        }
    }

    public synchronized void rollback() {
        this.msgCacheQueue.clear();
    }
}

