/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.stat;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.rocketmq.common.protocol.body.ConsumeStatus;
import org.apache.rocketmq.common.stats.StatsItemSet;
import org.apache.rocketmq.common.stats.StatsSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerStatsManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqClient");
    private static final String TOPIC_AND_GROUP_CONSUME_OK_TPS = "CONSUME_OK_TPS";
    private static final String TOPIC_AND_GROUP_CONSUME_FAILED_TPS = "CONSUME_FAILED_TPS";
    private static final String TOPIC_AND_GROUP_CONSUME_RT = "CONSUME_RT";
    private static final String TOPIC_AND_GROUP_PULL_TPS = "PULL_TPS";
    private static final String TOPIC_AND_GROUP_PULL_RT = "PULL_RT";
    private final StatsItemSet topicAndGroupConsumeOKTPS;
    private final StatsItemSet topicAndGroupConsumeRT;
    private final StatsItemSet topicAndGroupConsumeFailedTPS;
    private final StatsItemSet topicAndGroupPullTPS;
    private final StatsItemSet topicAndGroupPullRT;

    public ConsumerStatsManager(ScheduledExecutorService scheduledExecutorService) {
        this.topicAndGroupConsumeOKTPS = new StatsItemSet(TOPIC_AND_GROUP_CONSUME_OK_TPS, scheduledExecutorService, log);
        this.topicAndGroupConsumeRT = new StatsItemSet(TOPIC_AND_GROUP_CONSUME_RT, scheduledExecutorService, log);
        this.topicAndGroupConsumeFailedTPS = new StatsItemSet(TOPIC_AND_GROUP_CONSUME_FAILED_TPS, scheduledExecutorService, log);
        this.topicAndGroupPullTPS = new StatsItemSet(TOPIC_AND_GROUP_PULL_TPS, scheduledExecutorService, log);
        this.topicAndGroupPullRT = new StatsItemSet(TOPIC_AND_GROUP_PULL_RT, scheduledExecutorService, log);
    }

    public void start() {
    }

    public void shutdown() {
    }

    public void incPullRT(String group, String topic, long rt) {
        this.topicAndGroupPullRT.addValue(topic + "@" + group, (int)rt, 1);
    }

    public void incPullTPS(String group, String topic, long msgs) {
        this.topicAndGroupPullTPS.addValue(topic + "@" + group, (int)msgs, 1);
    }

    public void incConsumeRT(String group, String topic, long rt) {
        this.topicAndGroupConsumeRT.addValue(topic + "@" + group, (int)rt, 1);
    }

    public void incConsumeOKTPS(String group, String topic, long msgs) {
        this.topicAndGroupConsumeOKTPS.addValue(topic + "@" + group, (int)msgs, 1);
    }

    public void incConsumeFailedTPS(String group, String topic, long msgs) {
        this.topicAndGroupConsumeFailedTPS.addValue(topic + "@" + group, (int)msgs, 1);
    }

    public ConsumeStatus consumeStatus(String group, String topic) {
        ConsumeStatus cs = new ConsumeStatus();
        StatsSnapshot ss = this.getPullRT(group, topic);
        if (ss != null) {
            cs.setPullRT(ss.getAvgpt());
        }
        if ((ss = this.getPullTPS(group, topic)) != null) {
            cs.setPullTPS(ss.getTps());
        }
        if ((ss = this.getConsumeRT(group, topic)) != null) {
            cs.setConsumeRT(ss.getAvgpt());
        }
        if ((ss = this.getConsumeOKTPS(group, topic)) != null) {
            cs.setConsumeOKTPS(ss.getTps());
        }
        if ((ss = this.getConsumeFailedTPS(group, topic)) != null) {
            cs.setConsumeFailedTPS(ss.getTps());
        }
        if ((ss = this.topicAndGroupConsumeFailedTPS.getStatsDataInHour(topic + "@" + group)) != null) {
            cs.setConsumeFailedMsgs(ss.getSum());
        }
        return cs;
    }

    private StatsSnapshot getPullRT(String group, String topic) {
        return this.topicAndGroupPullRT.getStatsDataInMinute(topic + "@" + group);
    }

    private StatsSnapshot getPullTPS(String group, String topic) {
        return this.topicAndGroupPullTPS.getStatsDataInMinute(topic + "@" + group);
    }

    private StatsSnapshot getConsumeRT(String group, String topic) {
        StatsSnapshot statsData = this.topicAndGroupConsumeRT.getStatsDataInMinute(topic + "@" + group);
        if (0L == statsData.getSum()) {
            statsData = this.topicAndGroupConsumeRT.getStatsDataInHour(topic + "@" + group);
        }
        return statsData;
    }

    private StatsSnapshot getConsumeOKTPS(String group, String topic) {
        return this.topicAndGroupConsumeOKTPS.getStatsDataInMinute(topic + "@" + group);
    }

    private StatsSnapshot getConsumeFailedTPS(String group, String topic) {
        return this.topicAndGroupConsumeFailedTPS.getStatsDataInMinute(topic + "@" + group);
    }
}

