/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.topic;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class DeleteTopicSubCommand
implements SubCommand {
    public static void deleteTopic(DefaultMQAdminExt adminExt, String clusterName, String topic) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        Set<String> masterSet = CommandUtil.fetchMasterAddrByClusterName(adminExt, clusterName);
        adminExt.deleteTopicInBroker(masterSet, topic);
        System.out.printf("delete topic [%s] from cluster [%s] success.%n", topic, clusterName);
        HashSet<String> nameServerSet = null;
        if (adminExt.getNamesrvAddr() != null) {
            String[] ns = adminExt.getNamesrvAddr().trim().split(";");
            nameServerSet = new HashSet<String>(Arrays.asList(ns));
        }
        adminExt.deleteTopicInNameServer(nameServerSet, topic);
        System.out.printf("delete topic [%s] from NameServer success.%n", topic);
    }

    public static void deleteTopicByBroker(DefaultMQAdminExt adminExt, Set<String> brokerAddrs, String topic) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        adminExt.deleteTopicInBroker(brokerAddrs, topic);
        System.out.printf("delete topic [%s] from broker [%s] success.%n", topic, brokerAddrs);
        HashSet<String> nameServerSet = null;
        if (adminExt.getNamesrvAddr() != null) {
            String[] ns = adminExt.getNamesrvAddr().trim().split(";");
            nameServerSet = new HashSet<String>(Arrays.asList(ns));
        }
        adminExt.deleteTopicInNameServer(nameServerSet, topic, brokerAddrs);
        System.out.printf("delete topic [%s] from NameServer success.%n", topic);
    }

    @Override
    public String commandName() {
        return "deleteTopic";
    }

    @Override
    public String commandDesc() {
        return "Delete topic from broker and NameServer.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("t", "topic", true, "topic name");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("c", "clusterName", true, "delete topic from which cluster");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("b", "brokerAddr", true, "create topic to which broker");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt adminExt = new DefaultMQAdminExt(rpcHook);
        adminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String topic = commandLine.getOptionValue('t').trim();
            adminExt.start();
            if (commandLine.hasOption('c')) {
                String clusterName = commandLine.getOptionValue('c').trim();
                DeleteTopicSubCommand.deleteTopic(adminExt, clusterName, topic);
                return;
            }
            if (commandLine.hasOption("b")) {
                String brokerAddrs = commandLine.getOptionValue('b').trim();
                String[] brokerArr = brokerAddrs.split(";");
                if (brokerArr.length <= 0) {
                    throw new IllegalArgumentException("not broker");
                }
                HashSet<String> brokerSet = new HashSet<String>();
                Collections.addAll(brokerSet, brokerArr);
                DeleteTopicSubCommand.deleteTopicByBroker(adminExt, brokerSet, topic);
                return;
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            adminExt.shutdown();
        }
    }
}

