/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.stats;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class TimeStats {
    private final int sampleNumber;
    private final long[] data;
    private volatile double sampleRate = 0.0;
    private double[] percents = new double[]{0.25, 0.5, 0.75, 0.9, 0.95, 0.99};
    private AtomicInteger cnt = new AtomicInteger(0);
    private AtomicInteger maxIdx = new AtomicInteger(0);
    private AtomicLong min = new AtomicLong(Long.MAX_VALUE);
    private AtomicLong max = new AtomicLong(Long.MIN_VALUE);
    private AtomicLong sum = new AtomicLong(0L);
    StringBuilder resultBuilder = new StringBuilder(512);

    public TimeStats(int sampleNumber) {
        this.sampleNumber = sampleNumber;
        this.data = new long[sampleNumber];
        this.sampleRate = 1.0;
    }

    public void add(long value) {
        int t;
        long tmp;
        this.cnt.incrementAndGet();
        this.sum.getAndAdd(value);
        while (value < (tmp = this.min.get())) {
            this.min.compareAndSet(tmp, value);
        }
        while (value > (tmp = this.max.get())) {
            this.max.compareAndSet(tmp, value);
        }
        int idx = this.sampleRate < 1.0 ? (int)((double)this.cnt.get() * this.sampleRate) % this.sampleNumber : this.cnt.get() % this.sampleNumber;
        while (idx > (t = this.maxIdx.get())) {
            this.maxIdx.compareAndSet(t, idx);
        }
        this.data[idx] = value;
    }

    public String reportAndReset(double rate) {
        this.resultBuilder.setLength(0);
        if (this.cnt.get() == 0) {
            return "cnt:0";
        }
        this.resultBuilder.append(String.format("cnt:%6d|avg:%6.2f|max:%6.2f|min:%6.3f|", this.cnt.get(), rate * (double)this.sum.get() / (double)this.cnt.get(), rate * (double)this.max.get(), rate * (double)this.min.get()));
        int dataLen = this.maxIdx.get() + 1;
        long start = System.currentTimeMillis();
        Arrays.sort(this.data, 0, dataLen);
        long elapse = System.currentTimeMillis() - start;
        for (double percent : this.percents) {
            int idx = (int)((double)dataLen * percent);
            this.resultBuilder.append(String.format("p%2.0f:%6.2f|", percent * 100.0, rate * (double)this.data[idx]));
        }
        this.resultBuilder.append(String.format("sort:%2d|", elapse));
        this.maxIdx.set(0);
        this.min.set(Long.MAX_VALUE);
        this.max.set(Long.MIN_VALUE);
        this.sum.set(0L);
        this.cnt.set(0);
        return this.resultBuilder.toString();
    }

    private void updateSampleRate(AtomicInteger lastCnt) {
        this.sampleRate = 1.0 * (double)this.sampleNumber / (double)lastCnt.get();
    }

    public static void main(String[] args) {
        int i;
        long[] data;
        RolloverTimeStats stats = new RolloverTimeStats(10000);
        for (long datum : data = new long[]{1L, 2L, 3L, 4L, 5L}) {
            stats.add(datum);
        }
        System.out.printf("%s\n", stats.reportAndReset());
        for (long datum : data) {
            stats.add(datum);
        }
        System.out.printf("%s\n", stats.reportAndReset());
        for (i = 0; i < 1000; ++i) {
            stats.add(i + 1);
        }
        System.out.printf("%s\n", stats.reportAndReset());
        for (i = 0; i < 100000; ++i) {
            stats.add((long)(Math.random() * 100.0));
        }
        System.out.printf("%s\n", stats.reportAndReset());
        for (i = 0; i < 100000; ++i) {
            stats.add((long)(Math.random() * 100.0));
        }
        System.out.printf("%s\n", stats.reportAndReset());
        for (i = 0; i < 1000; ++i) {
            stats.add(i + 1);
        }
        System.out.printf("%s\n", stats.reportAndReset());
        for (i = 0; i < 1000; ++i) {
            stats.add(i + 1);
        }
        System.out.printf("%s\n", stats.reportAndReset());
    }

    public static class RolloverTimeStats {
        private TimeStats[] stats = new TimeStats[2];
        volatile int idx;

        public RolloverTimeStats(int sampleNumber) {
            this.stats[0] = new TimeStats(sampleNumber);
            this.stats[1] = new TimeStats(sampleNumber);
            this.idx = 0;
        }

        public void add(long value) {
            this.stats[this.idx].add(value);
        }

        public synchronized String reportAndReset() {
            return this.reportAndReset(1.0);
        }

        public synchronized String reportAndReset(double rate) {
            this.stats[1 - this.idx].updateSampleRate(this.stats[this.idx].cnt);
            this.idx = 1 - this.idx;
            return this.stats[1 - this.idx].reportAndReset(rate);
        }
    }
}

