/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filtersrv.filter;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.filter.FilterAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynaCode {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqFiltersrv");
    private static final String FILE_SP = System.getProperty("file.separator");
    private static final String LINE_SP = System.getProperty("line.separator");
    private String sourcePath;
    private String outPutClassPath;
    private ClassLoader parentClassLoader;
    private List<String> codeStrs;
    private Map<String, Class<?>> loadClass;
    private String classpath;
    private String bootclasspath;
    private String extdirs;
    private String encoding;
    private String target;

    public DynaCode(String code) {
        this(Thread.currentThread().getContextClassLoader(), Collections.singletonList(code));
    }

    public DynaCode(ClassLoader parentClassLoader, List<String> codeStrs) {
        this(DynaCode.extractClasspath(parentClassLoader), parentClassLoader, codeStrs);
    }

    public DynaCode(String classpath, ClassLoader parentClassLoader, List<String> codeStrs) {
        this.outPutClassPath = this.sourcePath = System.getProperty("user.home") + FILE_SP + "rocketmq_filter_class" + FILE_SP + UtilAll.getPid();
        this.encoding = "UTF-8";
        this.classpath = classpath;
        this.parentClassLoader = parentClassLoader;
        this.codeStrs = codeStrs;
        this.loadClass = new HashMap(codeStrs.size());
    }

    public DynaCode(List<String> codeStrs) {
        this(Thread.currentThread().getContextClassLoader(), codeStrs);
    }

    private static String extractClasspath(ClassLoader cl) {
        StringBuffer buf = new StringBuffer();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)cl).getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    if (buf.length() > 0) {
                        buf.append(File.pathSeparatorChar);
                    }
                    String s = urls[i].getFile();
                    try {
                        s = URLDecoder.decode(s, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        continue;
                    }
                    File f = new File(s);
                    buf.append(f.getAbsolutePath());
                }
            }
            cl = cl.getParent();
        }
        return buf.toString();
    }

    public static Class<?> compileAndLoadClass(String className, String javaSource) throws Exception {
        String classSimpleName = FilterAPI.simpleClassName((String)className);
        String javaCode = javaSource;
        String newClassSimpleName = classSimpleName + System.currentTimeMillis();
        String newJavaCode = javaCode.replaceAll(classSimpleName, newClassSimpleName);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(newJavaCode);
        DynaCode dc = new DynaCode(codes);
        dc.compileAndLoadClass();
        Map<String, Class<?>> map = dc.getLoadClass();
        Class<?> clazz = map.get(DynaCode.getQualifiedName(newJavaCode));
        return clazz;
    }

    public static String getQualifiedName(String code) {
        StringBuilder sb = new StringBuilder();
        String className = DynaCode.getClassName(code);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            String packageName = DynaCode.getPackageName(code);
            if (StringUtils.isNotBlank((CharSequence)packageName)) {
                sb.append(packageName).append(".");
            }
            sb.append(className);
        }
        return sb.toString();
    }

    public static String getClassName(String code) {
        String className = StringUtils.substringBefore((String)code, (String)"{");
        if (StringUtils.isBlank((CharSequence)className)) {
            return className;
        }
        if (StringUtils.contains((CharSequence)code, (CharSequence)" class ")) {
            className = StringUtils.contains((CharSequence)(className = StringUtils.substringAfter((String)className, (String)" class ")), (CharSequence)" extends ") ? StringUtils.substringBefore((String)className, (String)" extends ").trim() : (StringUtils.contains((CharSequence)className, (CharSequence)" implements ") ? StringUtils.trim((String)StringUtils.substringBefore((String)className, (String)" implements ")) : StringUtils.trim((String)className));
        } else if (StringUtils.contains((CharSequence)code, (CharSequence)" interface ")) {
            className = StringUtils.contains((CharSequence)(className = StringUtils.substringAfter((String)className, (String)" interface ")), (CharSequence)" extends ") ? StringUtils.substringBefore((String)className, (String)" extends ").trim() : StringUtils.trim((String)className);
        } else if (StringUtils.contains((CharSequence)code, (CharSequence)" enum ")) {
            className = StringUtils.trim((String)StringUtils.substringAfter((String)className, (String)" enum "));
        } else {
            return "";
        }
        return className;
    }

    public static String getPackageName(String code) {
        String packageName = StringUtils.substringBefore((String)StringUtils.substringAfter((String)code, (String)"package "), (String)";").trim();
        return packageName;
    }

    public static String getFullClassName(String code) {
        String packageName = DynaCode.getPackageName(code);
        String className = DynaCode.getClassName(code);
        return StringUtils.isBlank((CharSequence)packageName) ? className : packageName + "." + className;
    }

    public void compileAndLoadClass() throws Exception {
        String[] sourceFiles = this.uploadSrcFile();
        this.compile(sourceFiles);
        this.loadClass(this.loadClass.keySet());
    }

    public Map<String, Class<?>> getLoadClass() {
        return this.loadClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] uploadSrcFile() throws Exception {
        ArrayList<String> srcFileAbsolutePaths = new ArrayList<String>(this.codeStrs.size());
        for (String code : this.codeStrs) {
            if (!StringUtils.isNotBlank((CharSequence)code)) continue;
            String packageName = DynaCode.getPackageName(code);
            String className = DynaCode.getClassName(code);
            if (!StringUtils.isNotBlank((CharSequence)className)) continue;
            File srcFile = null;
            BufferedWriter bufferWriter = null;
            try {
                Object srcPath;
                if (StringUtils.isBlank((CharSequence)packageName)) {
                    File pathFile = new File(this.sourcePath);
                    if (!pathFile.exists() && !pathFile.mkdirs()) {
                        throw new RuntimeException("create PathFile Error!");
                    }
                    srcFile = new File(this.sourcePath + FILE_SP + className + ".java");
                } else {
                    srcPath = StringUtils.replace((String)packageName, (String)".", (String)FILE_SP);
                    File pathFile = new File(this.sourcePath + FILE_SP + (String)srcPath);
                    if (!pathFile.exists() && !pathFile.mkdirs()) {
                        throw new RuntimeException("create PathFile Error!");
                    }
                    srcFile = new File(pathFile.getAbsolutePath() + FILE_SP + className + ".java");
                }
                srcPath = this.loadClass;
                synchronized (srcPath) {
                    this.loadClass.put(DynaCode.getFullClassName(code), null);
                }
                if (null != srcFile) {
                    log.warn("Dyna Create Java Source File:----> {}", (Object)srcFile.getAbsolutePath());
                    srcFileAbsolutePaths.add(srcFile.getAbsolutePath());
                    srcFile.deleteOnExit();
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(srcFile), this.encoding);
                bufferWriter = new BufferedWriter(outputStreamWriter);
                for (String lineCode : code.split(LINE_SP)) {
                    bufferWriter.write(lineCode);
                    bufferWriter.newLine();
                }
                bufferWriter.flush();
            }
            finally {
                if (null == bufferWriter) continue;
                bufferWriter.close();
            }
        }
        return srcFileAbsolutePaths.toArray(new String[srcFileAbsolutePaths.size()]);
    }

    private void compile(String[] srcFiles) throws Exception {
        String[] args = this.buildCompileJavacArgs(srcFiles);
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new NullPointerException("ToolProvider.getSystemJavaCompiler() return null,please use JDK replace JRE!");
        }
        int resultCode = compiler.run(null, null, err, args);
        if (resultCode != 0) {
            throw new Exception(err.toString("UTF-8"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClass(Set<String> classFullNames) throws ClassNotFoundException, MalformedURLException {
        Map<String, Class<?>> map = this.loadClass;
        synchronized (map) {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(this.outPutClassPath).toURI().toURL()}, this.parentClassLoader);
            for (String key : classFullNames) {
                Class<?> classz = classLoader.loadClass(key);
                if (null != classz) {
                    this.loadClass.put(key, classz);
                    log.info("Dyna Load Java Class File OK:----> className: {}", (Object)key);
                    continue;
                }
                log.error("Dyna Load Java Class File Fail:----> className: {}", (Object)key);
            }
        }
    }

    private String[] buildCompileJavacArgs(String[] srcFiles) {
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.classpath)) {
            args.add("-classpath");
            args.add(this.classpath);
        }
        if (StringUtils.isNotBlank((CharSequence)this.outPutClassPath)) {
            args.add("-d");
            args.add(this.outPutClassPath);
        }
        if (StringUtils.isNotBlank((CharSequence)this.sourcePath)) {
            args.add("-sourcepath");
            args.add(this.sourcePath);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bootclasspath)) {
            args.add("-bootclasspath");
            args.add(this.bootclasspath);
        }
        if (StringUtils.isNotBlank((CharSequence)this.extdirs)) {
            args.add("-extdirs");
            args.add(this.extdirs);
        }
        if (StringUtils.isNotBlank((CharSequence)this.encoding)) {
            args.add("-encoding");
            args.add(this.encoding);
        }
        if (StringUtils.isNotBlank((CharSequence)this.target)) {
            args.add("-target");
            args.add(this.target);
        }
        for (int i = 0; i < srcFiles.length; ++i) {
            args.add(srcFiles[i]);
        }
        return args.toArray(new String[args.size()]);
    }

    public String getOutPutClassPath() {
        return this.outPutClassPath;
    }

    public void setOutPutClassPath(String outPutClassPath) {
        this.outPutClassPath = outPutClassPath;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public ClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public String getBootclasspath() {
        return this.bootclasspath;
    }

    public void setBootclasspath(String bootclasspath) {
        this.bootclasspath = bootclasspath;
    }

    public String getExtdirs() {
        return this.extdirs;
    }

    public void setExtdirs(String extdirs) {
        this.extdirs = extdirs;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

