/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filtersrv.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.consumer.PullCallback;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.filter.FilterContext;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.PullMessageResponseHeader;
import org.apache.rocketmq.common.protocol.header.filtersrv.RegisterMessageFilterClassRequestHeader;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.filtersrv.FiltersrvController;
import org.apache.rocketmq.filtersrv.filter.FilterClassInfo;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqFiltersrv");
    private final FiltersrvController filtersrvController;

    public DefaultRequestProcessor(FiltersrvController filtersrvController) {
        this.filtersrvController = filtersrvController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("receive request, {} {} {}", new Object[]{request.getCode(), RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), request});
        }
        switch (request.getCode()) {
            case 302: {
                return this.registerMessageFilterClass(ctx, request);
            }
            case 11: {
                return this.pullMessageForward(ctx, request);
            }
        }
        return null;
    }

    public boolean rejectRequest() {
        return false;
    }

    private RemotingCommand registerMessageFilterClass(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        RegisterMessageFilterClassRequestHeader requestHeader = (RegisterMessageFilterClassRequestHeader)request.decodeCommandCustomHeader(RegisterMessageFilterClassRequestHeader.class);
        try {
            boolean ok = this.filtersrvController.getFilterClassManager().registerFilterClass(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getClassName(), requestHeader.getClassCRC(), request.getBody());
            if (!ok) {
                throw new Exception("registerFilterClass error");
            }
        }
        catch (Exception e) {
            response.setCode(1);
            response.setRemark(RemotingHelper.exceptionSimpleDesc((Throwable)e));
            return response;
        }
        response.setCode(0);
        response.setRemark(null);
        return response;
    }

    private RemotingCommand pullMessageForward(final ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        final RemotingCommand response = RemotingCommand.createResponseCommand(PullMessageResponseHeader.class);
        final PullMessageResponseHeader responseHeader = (PullMessageResponseHeader)response.readCustomHeader();
        final PullMessageRequestHeader requestHeader = (PullMessageRequestHeader)request.decodeCommandCustomHeader(PullMessageRequestHeader.class);
        final FilterContext filterContext = new FilterContext();
        filterContext.setConsumerGroup(requestHeader.getConsumerGroup());
        response.setOpaque(request.getOpaque());
        DefaultMQPullConsumer pullConsumer = this.filtersrvController.getDefaultMQPullConsumer();
        final FilterClassInfo findFilterClass = this.filtersrvController.getFilterClassManager().findFilterClass(requestHeader.getConsumerGroup(), requestHeader.getTopic());
        if (null == findFilterClass) {
            response.setCode(1);
            response.setRemark("Find Filter class failed, not registered");
            return response;
        }
        if (null == findFilterClass.getMessageFilter()) {
            response.setCode(1);
            response.setRemark("Find Filter class failed, registered but no class");
            return response;
        }
        responseHeader.setSuggestWhichBrokerId(Long.valueOf(0L));
        MessageQueue mq = new MessageQueue();
        mq.setTopic(requestHeader.getTopic());
        mq.setQueueId(requestHeader.getQueueId().intValue());
        mq.setBrokerName(this.filtersrvController.getBrokerName());
        long offset = requestHeader.getQueueOffset();
        int maxNums = requestHeader.getMaxMsgNums();
        PullCallback pullCallback = new PullCallback(){

            public void onSuccess(PullResult pullResult) {
                responseHeader.setMaxOffset(Long.valueOf(pullResult.getMaxOffset()));
                responseHeader.setMinOffset(Long.valueOf(pullResult.getMinOffset()));
                responseHeader.setNextBeginOffset(Long.valueOf(pullResult.getNextBeginOffset()));
                response.setRemark(null);
                switch (pullResult.getPullStatus()) {
                    case FOUND: {
                        response.setCode(0);
                        ArrayList<MessageExt> msgListOK = new ArrayList<MessageExt>();
                        try {
                            for (MessageExt msg : pullResult.getMsgFoundList()) {
                                boolean match = findFilterClass.getMessageFilter().match(msg, filterContext);
                                if (!match) continue;
                                msgListOK.add(msg);
                            }
                            if (!msgListOK.isEmpty()) {
                                DefaultRequestProcessor.this.returnResponse(requestHeader.getConsumerGroup(), requestHeader.getTopic(), ctx, response, msgListOK);
                                return;
                            }
                            response.setCode(20);
                            break;
                        }
                        catch (Throwable e) {
                            String error = String.format("do Message Filter Exception, ConsumerGroup: %s Topic: %s ", requestHeader.getConsumerGroup(), requestHeader.getTopic());
                            log.error(error, e);
                            response.setCode(1);
                            response.setRemark(error + RemotingHelper.exceptionSimpleDesc((Throwable)e));
                            DefaultRequestProcessor.this.returnResponse(requestHeader.getConsumerGroup(), requestHeader.getTopic(), ctx, response, null);
                            return;
                        }
                    }
                    case NO_MATCHED_MSG: {
                        response.setCode(20);
                        break;
                    }
                    case NO_NEW_MSG: {
                        response.setCode(19);
                        break;
                    }
                    case OFFSET_ILLEGAL: {
                        response.setCode(21);
                        break;
                    }
                }
                DefaultRequestProcessor.this.returnResponse(requestHeader.getConsumerGroup(), requestHeader.getTopic(), ctx, response, null);
            }

            public void onException(Throwable e) {
                response.setCode(1);
                response.setRemark("Pull Callback Exception, " + RemotingHelper.exceptionSimpleDesc((Throwable)e));
                DefaultRequestProcessor.this.returnResponse(requestHeader.getConsumerGroup(), requestHeader.getTopic(), ctx, response, null);
            }
        };
        pullConsumer.pullBlockIfNotFound(mq, null, offset, maxNums, pullCallback);
        return null;
    }

    private void returnResponse(String group, String topic, ChannelHandlerContext ctx, final RemotingCommand response, List<MessageExt> msgList) {
        if (null != msgList) {
            ByteBuffer[] msgBufferList = new ByteBuffer[msgList.size()];
            int bodyTotalSize = 0;
            for (int i = 0; i < msgList.size(); ++i) {
                try {
                    msgBufferList[i] = this.messageToByteBuffer(msgList.get(i));
                    bodyTotalSize += msgBufferList[i].capacity();
                    continue;
                }
                catch (Exception e) {
                    log.error("messageToByteBuffer UnsupportedEncodingException", (Throwable)e);
                }
            }
            ByteBuffer body = ByteBuffer.allocate(bodyTotalSize);
            for (ByteBuffer bb : msgBufferList) {
                bb.flip();
                body.put(bb);
            }
            response.setBody(body.array());
            this.filtersrvController.getFilterServerStatsManager().incGroupGetNums(group, topic, msgList.size());
            this.filtersrvController.getFilterServerStatsManager().incGroupGetSize(group, topic, bodyTotalSize);
        }
        try {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        log.error("FilterServer response to " + future.channel().remoteAddress() + " failed", future.cause());
                        log.error(response.toString());
                    }
                }
            });
        }
        catch (Throwable e) {
            log.error("FilterServer process request over, but response failed", e);
            log.error(response.toString());
        }
    }

    private ByteBuffer messageToByteBuffer(MessageExt msg) throws IOException {
        byte[] data;
        int sysFlag = MessageSysFlag.clearCompressedFlag((int)msg.getSysFlag());
        if (msg.getBody() != null && msg.getBody().length >= this.filtersrvController.getFiltersrvConfig().getCompressMsgBodyOverHowmuch() && (data = UtilAll.compress((byte[])msg.getBody(), (int)this.filtersrvController.getFiltersrvConfig().getZipCompressLevel())) != null) {
            msg.setBody(data);
            sysFlag |= 1;
        }
        int bodyLength = msg.getBody() != null ? msg.getBody().length : 0;
        byte[] topicData = msg.getTopic().getBytes("UTF-8");
        int topicLength = topicData.length;
        String properties = MessageDecoder.messageProperties2String((Map)msg.getProperties());
        byte[] propertiesData = properties.getBytes("UTF-8");
        int propertiesLength = propertiesData.length;
        int msgLen = 88 + bodyLength + 1 + topicLength + 2 + propertiesLength + 0;
        ByteBuffer msgStoreItemMemory = ByteBuffer.allocate(msgLen);
        MessageExt msgInner = msg;
        msgStoreItemMemory.putInt(msgLen);
        msgStoreItemMemory.putInt(-626843481);
        msgStoreItemMemory.putInt(UtilAll.crc32((byte[])msgInner.getBody()));
        msgStoreItemMemory.putInt(msgInner.getQueueId());
        msgStoreItemMemory.putInt(msgInner.getFlag());
        msgStoreItemMemory.putLong(msgInner.getQueueOffset());
        msgStoreItemMemory.putLong(msgInner.getCommitLogOffset());
        msgStoreItemMemory.putInt(sysFlag);
        msgStoreItemMemory.putLong(msgInner.getBornTimestamp());
        msgStoreItemMemory.put(msgInner.getBornHostBytes());
        msgStoreItemMemory.putLong(msgInner.getStoreTimestamp());
        msgStoreItemMemory.put(msgInner.getStoreHostBytes());
        msgStoreItemMemory.putInt(msgInner.getReconsumeTimes());
        msgStoreItemMemory.putLong(msgInner.getPreparedTransactionOffset());
        msgStoreItemMemory.putInt(bodyLength);
        if (bodyLength > 0) {
            msgStoreItemMemory.put(msgInner.getBody());
        }
        msgStoreItemMemory.put((byte)topicLength);
        msgStoreItemMemory.put(topicData);
        msgStoreItemMemory.putShort((short)propertiesLength);
        if (propertiesLength > 0) {
            msgStoreItemMemory.put(propertiesData);
        }
        return msgStoreItemMemory;
    }
}

