/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.filtersrv.stats;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.stats.StatsItemSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterServerStatsManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqFiltersrv");
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("FSStatsThread"));
    private final StatsItemSet groupGetNums = new StatsItemSet("GROUP_GET_NUMS", this.scheduledExecutorService, log);
    private final StatsItemSet groupGetSize = new StatsItemSet("GROUP_GET_SIZE", this.scheduledExecutorService, log);

    public void start() {
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    public void incGroupGetNums(String group, String topic, int incValue) {
        this.groupGetNums.addValue(topic + "@" + group, incValue, 1);
    }

    public void incGroupGetSize(String group, String topic, int incValue) {
        this.groupGetSize.addValue(topic + "@" + group, incValue, 1);
    }
}

