/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.consumer;

import io.openmessaging.BytesMessage;
import io.openmessaging.KeyValue;
import io.openmessaging.Message;
import io.openmessaging.MessageListener;
import io.openmessaging.OMS;
import io.openmessaging.PushConsumer;
import io.openmessaging.ReceivedMessageContext;
import io.openmessaging.exception.OMSRuntimeException;
import io.openmessaging.rocketmq.config.ClientConfig;
import io.openmessaging.rocketmq.utils.BeanUtils;
import io.openmessaging.rocketmq.utils.OMSUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;

public class PushConsumerImpl
implements PushConsumer {
    private final DefaultMQPushConsumer rocketmqPushConsumer;
    private final KeyValue properties;
    private boolean started = false;
    private final Map<String, MessageListener> subscribeTable = new ConcurrentHashMap<String, MessageListener>();
    private final ClientConfig clientConfig;

    public PushConsumerImpl(KeyValue properties) {
        this.rocketmqPushConsumer = new DefaultMQPushConsumer();
        this.properties = properties;
        this.clientConfig = (ClientConfig)((Object)BeanUtils.populate(properties, ClientConfig.class));
        String accessPoints = this.clientConfig.getOmsAccessPoints();
        if (accessPoints == null || accessPoints.isEmpty()) {
            throw new OMSRuntimeException("-1", "OMS AccessPoints is null or empty.");
        }
        this.rocketmqPushConsumer.setNamesrvAddr(accessPoints.replace(',', ';'));
        String consumerGroup = this.clientConfig.getRmqConsumerGroup();
        if (null == consumerGroup || consumerGroup.isEmpty()) {
            throw new OMSRuntimeException("-1", "Consumer Group is necessary for RocketMQ, please set it.");
        }
        this.rocketmqPushConsumer.setConsumerGroup(consumerGroup);
        this.rocketmqPushConsumer.setMaxReconsumeTimes(this.clientConfig.getRmqMaxRedeliveryTimes());
        this.rocketmqPushConsumer.setConsumeTimeout((long)this.clientConfig.getRmqMessageConsumeTimeout());
        this.rocketmqPushConsumer.setConsumeThreadMax(this.clientConfig.getRmqMaxConsumeThreadNums());
        this.rocketmqPushConsumer.setConsumeThreadMin(this.clientConfig.getRmqMinConsumeThreadNums());
        String consumerId = OMSUtil.buildInstanceName();
        this.rocketmqPushConsumer.setInstanceName(consumerId);
        properties.put("oms.consumer.id", consumerId);
        this.rocketmqPushConsumer.registerMessageListener((MessageListenerConcurrently)new MessageListenerImpl());
    }

    public KeyValue properties() {
        return this.properties;
    }

    public void resume() {
        this.rocketmqPushConsumer.resume();
    }

    public void suspend() {
        this.rocketmqPushConsumer.suspend();
    }

    public boolean isSuspended() {
        return this.rocketmqPushConsumer.getDefaultMQPushConsumerImpl().isPause();
    }

    public PushConsumer attachQueue(String queueName, MessageListener listener) {
        this.subscribeTable.put(queueName, listener);
        try {
            this.rocketmqPushConsumer.subscribe(queueName, "*");
        }
        catch (MQClientException e) {
            throw new OMSRuntimeException("-1", String.format("RocketMQ push consumer can't attach to %s.", queueName));
        }
        return this;
    }

    public synchronized void startup() {
        if (!this.started) {
            try {
                this.rocketmqPushConsumer.start();
            }
            catch (MQClientException e) {
                throw new OMSRuntimeException("-1", (Throwable)e);
            }
        }
        this.started = true;
    }

    public synchronized void shutdown() {
        if (this.started) {
            this.rocketmqPushConsumer.shutdown();
        }
        this.started = false;
    }

    class MessageListenerImpl
    implements MessageListenerConcurrently {
        MessageListenerImpl() {
        }

        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> rmqMsgList, ConsumeConcurrentlyContext contextRMQ) {
            MessageExt rmqMsg = rmqMsgList.get(0);
            BytesMessage omsMsg = OMSUtil.msgConvert(rmqMsg);
            MessageListener listener = (MessageListener)PushConsumerImpl.this.subscribeTable.get(rmqMsg.getTopic());
            if (listener == null) {
                throw new OMSRuntimeException("-1", String.format("The topic/queue %s isn't attached to this consumer", rmqMsg.getTopic()));
            }
            final KeyValue contextProperties = OMS.newKeyValue();
            final CountDownLatch sync = new CountDownLatch(1);
            contextProperties.put("rmq.message.consume.status", ConsumeConcurrentlyStatus.RECONSUME_LATER.name());
            ReceivedMessageContext context = new ReceivedMessageContext(){

                public KeyValue properties() {
                    return contextProperties;
                }

                public void ack() {
                    sync.countDown();
                    contextProperties.put("rmq.message.consume.status", ConsumeConcurrentlyStatus.CONSUME_SUCCESS.name());
                }

                public void ack(KeyValue properties) {
                    sync.countDown();
                    contextProperties.put("rmq.message.consume.status", properties.getString("rmq.message.consume.status"));
                }
            };
            long begin = System.currentTimeMillis();
            listener.onMessage((Message)omsMsg, context);
            long costs = System.currentTimeMillis() - begin;
            long timeoutMills = PushConsumerImpl.this.clientConfig.getRmqMessageConsumeTimeout() * 60 * 1000;
            try {
                sync.await(Math.max(0L, timeoutMills - costs), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return ConsumeConcurrentlyStatus.valueOf((String)contextProperties.getString("rmq.message.consume.status"));
        }
    }
}

