#ifndef CARRERA_RETURNCODE_H
#define CARRERA_RETURNCODE_H

#define CARRERA_VERSION "cpp.2.0"
#define SLOG_SIZE 2048
#define RANDOM_KEY_SIZE 16

#define OK 0
#define CACHE_OK 1
#define CACHE_FAIL 2
#define CACHE_FAILE_CLOSED 3

#define FAIL_UNKNOWN 10
#define FAIL_ILLEGAL_MSG 11
#define FAIL_TIMEOUT 12
#define FAIL_TOPIC_NOT_ALLOWED 13
#define FAIL_TOPIC_NOT_EXIST 14
#define FAIL_REFUSED_BY_RATE_LIMITER 15
#define FAIL_SERVER_CONNECTION_ERROR 101

#define CONNECTION_UNHEALTHY -1
#define CONNECTION_HEALTHY 0

#define DOWNGRADE 100
#define CLIENT_EXCEPTION 101
#define MISSING_PARAMETERS 102

//Delay Server
//
#define URL_TYPE_ADDTASK 0
#define URL_TYPE_CANCELTASK 1

#define HTTP_QPS_LIMIT 9002
#define UNAUTHORIZED_REQUEST 9003

#define BAD_HTTP_STATUS 31002
#define DECODE_HTTP_RESPONSE_ERROR 31005

#define UNAUTHORIZED_REQUEST 9003

#define MAX_HOST_NAME_LEN 512
#define MAX_CLIENT_ID_LEN 1024

#define DEFAULT_LOGGER "default_logger"
#define DEFAULT_LOG_FILE_MAX_SIZE (1024 * 1204 * 100) // 100M
#define DEFAULT_LOG_FILE_NUM 10

#define STATE_INIT 0
#define STATE_START 1
#define STATE_STOP 2

#define DELAY_MSG_TYPE 2
#define LOOP_DELAY_MSG_TYPE 3

#define ADD_ACTION 1
#define CANCEL_ACTION 2

#endif
