// Autogenerated by Thrift Compiler (0.9.2)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING

package main

import (
	"carrera/CarreraProducer"
	"flag"
	"fmt"
	"go.intra.xiaojukeji.com/golang/thrift-lib/0.9.2"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
)

func Usage() {
	fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
	flag.PrintDefaults()
	fmt.Fprintln(os.Stderr, "\nFunctions:")
	fmt.Fprintln(os.Stderr, "  Result sendSync(Message message, i64 timeout)")
	fmt.Fprintln(os.Stderr, "  Result sendBatchSync( messages)")
	fmt.Fprintln(os.Stderr, "  Result sendAsync(Message message)")
	fmt.Fprintln(os.Stderr, "  DelayResult sendDelaySync(DelayMessage delayMessage, i64 timeout)")
	fmt.Fprintln(os.Stderr)
	os.Exit(0)
}

func main() {
	flag.Usage = Usage
	var host string
	var port int
	var protocol string
	var urlString string
	var framed bool
	var useHttp bool
	var parsedUrl url.URL
	var trans thrift.TTransport
	_ = strconv.Atoi
	_ = math.Abs
	flag.Usage = Usage
	flag.StringVar(&host, "h", "localhost", "Specify host and port")
	flag.IntVar(&port, "p", 9090, "Specify port")
	flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
	flag.StringVar(&urlString, "u", "", "Specify the url")
	flag.BoolVar(&framed, "framed", false, "Use framed transport")
	flag.BoolVar(&useHttp, "http", false, "Use http")
	flag.Parse()

	if len(urlString) > 0 {
		parsedUrl, err := url.Parse(urlString)
		if err != nil {
			fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
			flag.Usage()
		}
		host = parsedUrl.Host
		useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http"
	} else if useHttp {
		_, err := url.Parse(fmt.Sprint("http://", host, ":", port))
		if err != nil {
			fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
			flag.Usage()
		}
	}

	cmd := flag.Arg(0)
	var err error
	if useHttp {
		trans, err = thrift.NewTHttpClient(parsedUrl.String())
	} else {
		portStr := fmt.Sprint(port)
		if strings.Contains(host, ":") {
			host, portStr, err = net.SplitHostPort(host)
			if err != nil {
				fmt.Fprintln(os.Stderr, "error with host:", err)
				os.Exit(1)
			}
		}
		trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
		if err != nil {
			fmt.Fprintln(os.Stderr, "error resolving address:", err)
			os.Exit(1)
		}
		if framed {
			trans = thrift.NewTFramedTransport(trans)
		}
	}
	if err != nil {
		fmt.Fprintln(os.Stderr, "Error creating transport", err)
		os.Exit(1)
	}
	defer trans.Close()
	var protocolFactory thrift.TProtocolFactory
	switch protocol {
	case "compact":
		protocolFactory = thrift.NewTCompactProtocolFactory()
		break
	case "simplejson":
		protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
		break
	case "json":
		protocolFactory = thrift.NewTJSONProtocolFactory()
		break
	case "binary", "":
		protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
		break
	default:
		fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
		Usage()
		os.Exit(1)
	}
	client := CarreraProducer.NewProducerServiceClientFactory(trans, protocolFactory)
	if err := trans.Open(); err != nil {
		fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
		os.Exit(1)
	}

	switch cmd {
	case "sendSync":
		if flag.NArg()-1 != 2 {
			fmt.Fprintln(os.Stderr, "SendSync requires 2 args")
			flag.Usage()
		}
		arg21 := flag.Arg(1)
		mbTrans22 := thrift.NewTMemoryBufferLen(len(arg21))
		defer mbTrans22.Close()
		_, err23 := mbTrans22.WriteString(arg21)
		if err23 != nil {
			Usage()
			return
		}
		factory24 := thrift.NewTSimpleJSONProtocolFactory()
		jsProt25 := factory24.GetProtocol(mbTrans22)
		argvalue0 := CarreraProducer.NewMessage()
		err26 := argvalue0.Read(jsProt25)
		if err26 != nil {
			Usage()
			return
		}
		value0 := argvalue0
		argvalue1, err27 := (strconv.ParseInt(flag.Arg(2), 10, 64))
		if err27 != nil {
			Usage()
			return
		}
		value1 := argvalue1
		fmt.Print(client.SendSync(value0, value1))
		fmt.Print("\n")
		break
	case "sendBatchSync":
		if flag.NArg()-1 != 1 {
			fmt.Fprintln(os.Stderr, "SendBatchSync requires 1 args")
			flag.Usage()
		}
		arg28 := flag.Arg(1)
		mbTrans29 := thrift.NewTMemoryBufferLen(len(arg28))
		defer mbTrans29.Close()
		_, err30 := mbTrans29.WriteString(arg28)
		if err30 != nil {
			Usage()
			return
		}
		factory31 := thrift.NewTSimpleJSONProtocolFactory()
		jsProt32 := factory31.GetProtocol(mbTrans29)
		containerStruct0 := CarreraProducer.NewSendBatchSyncArgs()
		err33 := containerStruct0.ReadField1(jsProt32)
		if err33 != nil {
			Usage()
			return
		}
		argvalue0 := containerStruct0.Messages
		value0 := argvalue0
		fmt.Print(client.SendBatchSync(value0))
		fmt.Print("\n")
		break
	case "sendAsync":
		if flag.NArg()-1 != 1 {
			fmt.Fprintln(os.Stderr, "SendAsync requires 1 args")
			flag.Usage()
		}
		arg34 := flag.Arg(1)
		mbTrans35 := thrift.NewTMemoryBufferLen(len(arg34))
		defer mbTrans35.Close()
		_, err36 := mbTrans35.WriteString(arg34)
		if err36 != nil {
			Usage()
			return
		}
		factory37 := thrift.NewTSimpleJSONProtocolFactory()
		jsProt38 := factory37.GetProtocol(mbTrans35)
		argvalue0 := CarreraProducer.NewMessage()
		err39 := argvalue0.Read(jsProt38)
		if err39 != nil {
			Usage()
			return
		}
		value0 := argvalue0
		fmt.Print(client.SendAsync(value0))
		fmt.Print("\n")
		break
	case "sendDelaySync":
		if flag.NArg()-1 != 2 {
			fmt.Fprintln(os.Stderr, "SendDelaySync requires 2 args")
			flag.Usage()
		}
		arg40 := flag.Arg(1)
		mbTrans41 := thrift.NewTMemoryBufferLen(len(arg40))
		defer mbTrans41.Close()
		_, err42 := mbTrans41.WriteString(arg40)
		if err42 != nil {
			Usage()
			return
		}
		factory43 := thrift.NewTSimpleJSONProtocolFactory()
		jsProt44 := factory43.GetProtocol(mbTrans41)
		argvalue0 := CarreraProducer.NewDelayMessage()
		err45 := argvalue0.Read(jsProt44)
		if err45 != nil {
			Usage()
			return
		}
		value0 := argvalue0
		argvalue1, err46 := (strconv.ParseInt(flag.Arg(2), 10, 64))
		if err46 != nil {
			Usage()
			return
		}
		value1 := argvalue1
		fmt.Print(client.SendDelaySync(value0, value1))
		fmt.Print("\n")
		break
	case "":
		Usage()
		break
	default:
		fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
	}
}
