/*!
 * jodit - Jodit is awesome and usefully wysiwyg editor with filebrowser
 * Author: Chupurnov <chupurnov@gmail.com> (https://xdsoft.net/)
 * Version: v3.7.1
 * Url: https://xdsoft.net/jodit/
 * License(s): MIT
 */
	
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(self, function() {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 2 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
__webpack_require__(3);
__webpack_require__(4);
if (!Array.from) {
    Array.from = function (object) {
        if (object instanceof Set) {
            var res_1 = [];
            object.forEach(function (a) { return res_1.push(a); });
            return res_1;
        }
        return [].slice.call(object);
    };
}
if (!Array.prototype.includes) {
    Array.prototype.includes = function (value) {
        return this.indexOf(value) > -1;
    };
}
if (typeof Object.assign !== 'function') {
    Object.defineProperty(Object, 'assign', {
        value: function assign(target, varArgs) {
            if (target == null) {
                throw new TypeError('Cannot convert undefined or null to object');
            }
            var to = Object(target);
            for (var index = 1; index < arguments.length; index++) {
                var nextSource = arguments[index];
                if (nextSource != null) {
                    for (var nextKey in nextSource) {
                        if (Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
                            to[nextKey] = nextSource[nextKey];
                        }
                    }
                }
            }
            return to;
        },
        writable: true,
        configurable: true
    });
}
if (!Array.prototype.find) {
    Array.prototype.find = function (value) {
        return this.indexOf(value) > -1 ? value : undefined;
    };
}


/***/ }),
/* 3 */
/***/ (() => {

"use strict";

/*! @source http://purl.eligrey.com/github/classList.js/blob/master/classList.js */
if ("document" in window.self) {
    if (!("classList" in document.createElement("_"))
        || document.createElementNS && !("classList" in document.createElementNS("http://www.w3.org/2000/svg", "g"))) {
        (function (view) {
            "use strict";
            if (!('Element' in view))
                return;
            var classListProp = "classList", protoProp = "prototype", elemCtrProto = view.Element[protoProp], objCtr = Object, strTrim = String[protoProp].trim || function () {
                return this.replace(/^\s+|\s+$/g, "");
            }, arrIndexOf = Array[protoProp].indexOf || function (item) {
                var i = 0, len = this.length;
                for (; i < len; i++) {
                    if (i in this && this[i] === item) {
                        return i;
                    }
                }
                return -1;
            }, DOMEx = function (type, message) {
                this.name = type;
                this.code = DOMException[type];
                this.message = message;
            }, checkTokenAndGetIndex = function (classList, token) {
                if (token === "") {
                    throw new DOMEx("SYNTAX_ERR", "An invalid or illegal string was specified");
                }
                if (/\s/.test(token)) {
                    throw new DOMEx("INVALID_CHARACTER_ERR", "String contains an invalid character");
                }
                return arrIndexOf.call(classList, token);
            }, ClassList = function (elem) {
                var trimmedClasses = strTrim.call(elem.getAttribute("class") || ""), classes = trimmedClasses ? trimmedClasses.split(/\s+/) : [], i = 0, len = classes.length;
                for (; i < len; i++) {
                    this.push(classes[i]);
                }
                this._updateClassName = function () {
                    elem.setAttribute("class", this.toString());
                };
            }, classListProto = ClassList[protoProp] = [], classListGetter = function () {
                return new ClassList(this);
            };
            DOMEx[protoProp] = Error[protoProp];
            classListProto.item = function (i) {
                return this[i] || null;
            };
            classListProto.contains = function (token) {
                token += "";
                return checkTokenAndGetIndex(this, token) !== -1;
            };
            classListProto.add = function () {
                var tokens = arguments, i = 0, l = tokens.length, token, updated = false;
                do {
                    token = tokens[i] + "";
                    if (checkTokenAndGetIndex(this, token) === -1) {
                        this.push(token);
                        updated = true;
                    }
                } while (++i < l);
                if (updated) {
                    this._updateClassName();
                }
            };
            classListProto.remove = function () {
                var tokens = arguments, i = 0, l = tokens.length, token, updated = false, index;
                do {
                    token = tokens[i] + "";
                    index = checkTokenAndGetIndex(this, token);
                    while (index !== -1) {
                        this.splice(index, 1);
                        updated = true;
                        index = checkTokenAndGetIndex(this, token);
                    }
                } while (++i < l);
                if (updated) {
                    this._updateClassName();
                }
            };
            classListProto.toggle = function (token, force) {
                token += "";
                var result = this.contains(token), method = result ?
                    force !== true && "remove"
                    :
                        force !== false && "add";
                if (method) {
                    this[method](token);
                }
                if (force === true || force === false) {
                    return force;
                }
                else {
                    return !result;
                }
            };
            classListProto.toString = function () {
                return this.join(" ");
            };
            if (objCtr.defineProperty) {
                var classListPropDesc = {
                    get: classListGetter,
                    enumerable: true,
                    configurable: true
                };
                try {
                    objCtr.defineProperty(elemCtrProto, classListProp, classListPropDesc);
                }
                catch (ex) {
                    if (ex.number === undefined || ex.number === -0x7FF5EC54) {
                        classListPropDesc.enumerable = false;
                        objCtr.defineProperty(elemCtrProto, classListProp, classListPropDesc);
                    }
                }
            }
            else if (objCtr[protoProp].__defineGetter__) {
                elemCtrProto.__defineGetter__(classListProp, classListGetter);
            }
        }(window.self));
    }
    (function () {
        "use strict";
        var testElement = document.createElement("_");
        testElement.classList.add("c1", "c2");
        if (!testElement.classList.contains("c2")) {
            var createMethod = function (method) {
                var original = DOMTokenList.prototype[method];
                DOMTokenList.prototype[method] = function (token) {
                    var i, len = arguments.length;
                    for (i = 0; i < len; i++) {
                        token = arguments[i];
                        original.call(this, token);
                    }
                };
            };
            createMethod('add');
            createMethod('remove');
        }
        testElement.classList.toggle("c3", false);
        if (testElement.classList.contains("c3")) {
            var _toggle = DOMTokenList.prototype.toggle;
            DOMTokenList.prototype.toggle = function (token, force) {
                if (1 in arguments && !this.contains(token) === !force) {
                    return force;
                }
                else {
                    return _toggle.call(this, token);
                }
            };
        }
        testElement = null;
    }());
}


/***/ }),
/* 4 */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

module.exports = __webpack_require__(5).polyfill();


/***/ }),
/* 5 */
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

/*!
 * @overview es6-promise - a tiny implementation of Promises/A+.
 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
 * @version   v4.2.8+1e68dce6
 */
(function (global, factory) {
     true ? module.exports = factory() :
        0;
}(this, (function () {
    'use strict';
    function objectOrFunction(x) {
        var type = typeof x;
        return x !== null && (type === 'object' || type === 'function');
    }
    function isFunction(x) {
        return typeof x === 'function';
    }
    var _isArray = void 0;
    if (Array.isArray) {
        _isArray = Array.isArray;
    }
    else {
        _isArray = function (x) {
            return Object.prototype.toString.call(x) === '[object Array]';
        };
    }
    var isArray = _isArray;
    var len = 0;
    var vertxNext = void 0;
    var customSchedulerFn = void 0;
    var asap = function asap(callback, arg) {
        queue[len] = callback;
        queue[len + 1] = arg;
        len += 2;
        if (len === 2) {
            if (customSchedulerFn) {
                customSchedulerFn(flush);
            }
            else {
                scheduleFlush();
            }
        }
    };
    function setScheduler(scheduleFn) {
        customSchedulerFn = scheduleFn;
    }
    function setAsap(asapFn) {
        asap = asapFn;
    }
    var browserWindow = typeof window !== 'undefined' ? window : undefined;
    var browserGlobal = browserWindow || {};
    var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
    var isNode = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';
    var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';
    function useNextTick() {
        return function () {
            return process.nextTick(flush);
        };
    }
    function useVertxTimer() {
        if (typeof vertxNext !== 'undefined') {
            return function () {
                vertxNext(flush);
            };
        }
        return useSetTimeout();
    }
    function useMutationObserver() {
        var iterations = 0;
        var observer = new BrowserMutationObserver(flush);
        var node = document.createTextNode('');
        observer.observe(node, { characterData: true });
        return function () {
            node.data = iterations = ++iterations % 2;
        };
    }
    function useMessageChannel() {
        var channel = new MessageChannel();
        channel.port1.onmessage = flush;
        return function () {
            return channel.port2.postMessage(0);
        };
    }
    function useSetTimeout() {
        var globalSetTimeout = setTimeout;
        return function () {
            return globalSetTimeout(flush, 1);
        };
    }
    var queue = new Array(1000);
    function flush() {
        for (var i = 0; i < len; i += 2) {
            var callback = queue[i];
            var arg = queue[i + 1];
            callback(arg);
            queue[i] = undefined;
            queue[i + 1] = undefined;
        }
        len = 0;
    }
    function attemptVertx() {
        try {
            var vertx = Function('return this')().require('vertx');
            vertxNext = vertx.runOnLoop || vertx.runOnContext;
            return useVertxTimer();
        }
        catch (e) {
            return useSetTimeout();
        }
    }
    var scheduleFlush = void 0;
    if (isNode) {
        scheduleFlush = useNextTick();
    }
    else if (BrowserMutationObserver) {
        scheduleFlush = useMutationObserver();
    }
    else if (isWorker) {
        scheduleFlush = useMessageChannel();
    }
    else if (browserWindow === undefined && "function" === 'function') {
        scheduleFlush = attemptVertx();
    }
    else {
        scheduleFlush = useSetTimeout();
    }
    function then(onFulfillment, onRejection) {
        var parent = this;
        var child = new this.constructor(noop);
        if (child[PROMISE_ID] === undefined) {
            makePromise(child);
        }
        var _state = parent._state;
        if (_state) {
            var callback = arguments[_state - 1];
            asap(function () {
                return invokeCallback(_state, child, callback, parent._result);
            });
        }
        else {
            subscribe(parent, child, onFulfillment, onRejection);
        }
        return child;
    }
    function resolve$1(object) {
        var Constructor = this;
        if (object && typeof object === 'object' && object.constructor === Constructor) {
            return object;
        }
        var promise = new Constructor(noop);
        resolve(promise, object);
        return promise;
    }
    var PROMISE_ID = Math.random().toString(36).substring(2);
    function noop() { }
    var PENDING = void 0;
    var FULFILLED = 1;
    var REJECTED = 2;
    function selfFulfillment() {
        return new TypeError("You cannot resolve a promise with itself");
    }
    function cannotReturnOwn() {
        return new TypeError('A promises callback cannot return that same promise.');
    }
    function tryThen(then$$1, value, fulfillmentHandler, rejectionHandler) {
        try {
            then$$1.call(value, fulfillmentHandler, rejectionHandler);
        }
        catch (e) {
            return e;
        }
    }
    function handleForeignThenable(promise, thenable, then$$1) {
        asap(function (promise) {
            var sealed = false;
            var error = tryThen(then$$1, thenable, function (value) {
                if (sealed) {
                    return;
                }
                sealed = true;
                if (thenable !== value) {
                    resolve(promise, value);
                }
                else {
                    fulfill(promise, value);
                }
            }, function (reason) {
                if (sealed) {
                    return;
                }
                sealed = true;
                reject(promise, reason);
            }, 'Settle: ' + (promise._label || ' unknown promise'));
            if (!sealed && error) {
                sealed = true;
                reject(promise, error);
            }
        }, promise);
    }
    function handleOwnThenable(promise, thenable) {
        if (thenable._state === FULFILLED) {
            fulfill(promise, thenable._result);
        }
        else if (thenable._state === REJECTED) {
            reject(promise, thenable._result);
        }
        else {
            subscribe(thenable, undefined, function (value) {
                return resolve(promise, value);
            }, function (reason) {
                return reject(promise, reason);
            });
        }
    }
    function handleMaybeThenable(promise, maybeThenable, then$$1) {
        if (maybeThenable.constructor === promise.constructor && then$$1 === then && maybeThenable.constructor.resolve === resolve$1) {
            handleOwnThenable(promise, maybeThenable);
        }
        else {
            if (then$$1 === undefined) {
                fulfill(promise, maybeThenable);
            }
            else if (isFunction(then$$1)) {
                handleForeignThenable(promise, maybeThenable, then$$1);
            }
            else {
                fulfill(promise, maybeThenable);
            }
        }
    }
    function resolve(promise, value) {
        if (promise === value) {
            reject(promise, selfFulfillment());
        }
        else if (objectOrFunction(value)) {
            var then$$1 = void 0;
            try {
                then$$1 = value.then;
            }
            catch (error) {
                reject(promise, error);
                return;
            }
            handleMaybeThenable(promise, value, then$$1);
        }
        else {
            fulfill(promise, value);
        }
    }
    function publishRejection(promise) {
        if (promise._onerror) {
            promise._onerror(promise._result);
        }
        publish(promise);
    }
    function fulfill(promise, value) {
        if (promise._state !== PENDING) {
            return;
        }
        promise._result = value;
        promise._state = FULFILLED;
        if (promise._subscribers.length !== 0) {
            asap(publish, promise);
        }
    }
    function reject(promise, reason) {
        if (promise._state !== PENDING) {
            return;
        }
        promise._state = REJECTED;
        promise._result = reason;
        asap(publishRejection, promise);
    }
    function subscribe(parent, child, onFulfillment, onRejection) {
        var _subscribers = parent._subscribers;
        var length = _subscribers.length;
        parent._onerror = null;
        _subscribers[length] = child;
        _subscribers[length + FULFILLED] = onFulfillment;
        _subscribers[length + REJECTED] = onRejection;
        if (length === 0 && parent._state) {
            asap(publish, parent);
        }
    }
    function publish(promise) {
        var subscribers = promise._subscribers;
        var settled = promise._state;
        if (subscribers.length === 0) {
            return;
        }
        var child = void 0, callback = void 0, detail = promise._result;
        for (var i = 0; i < subscribers.length; i += 3) {
            child = subscribers[i];
            callback = subscribers[i + settled];
            if (child) {
                invokeCallback(settled, child, callback, detail);
            }
            else {
                callback(detail);
            }
        }
        promise._subscribers.length = 0;
    }
    function invokeCallback(settled, promise, callback, detail) {
        var hasCallback = isFunction(callback), value = void 0, error = void 0, succeeded = true;
        if (hasCallback) {
            try {
                value = callback(detail);
            }
            catch (e) {
                succeeded = false;
                error = e;
            }
            if (promise === value) {
                reject(promise, cannotReturnOwn());
                return;
            }
        }
        else {
            value = detail;
        }
        if (promise._state !== PENDING) {
        }
        else if (hasCallback && succeeded) {
            resolve(promise, value);
        }
        else if (succeeded === false) {
            reject(promise, error);
        }
        else if (settled === FULFILLED) {
            fulfill(promise, value);
        }
        else if (settled === REJECTED) {
            reject(promise, value);
        }
    }
    function initializePromise(promise, resolver) {
        try {
            resolver(function resolvePromise(value) {
                resolve(promise, value);
            }, function rejectPromise(reason) {
                reject(promise, reason);
            });
        }
        catch (e) {
            reject(promise, e);
        }
    }
    var id = 0;
    function nextId() {
        return id++;
    }
    function makePromise(promise) {
        promise[PROMISE_ID] = id++;
        promise._state = undefined;
        promise._result = undefined;
        promise._subscribers = [];
    }
    function validationError() {
        return new Error('Array Methods must be provided an Array');
    }
    var Enumerator = function () {
        function Enumerator(Constructor, input) {
            this._instanceConstructor = Constructor;
            this.promise = new Constructor(noop);
            if (!this.promise[PROMISE_ID]) {
                makePromise(this.promise);
            }
            if (isArray(input)) {
                this.length = input.length;
                this._remaining = input.length;
                this._result = new Array(this.length);
                if (this.length === 0) {
                    fulfill(this.promise, this._result);
                }
                else {
                    this.length = this.length || 0;
                    this._enumerate(input);
                    if (this._remaining === 0) {
                        fulfill(this.promise, this._result);
                    }
                }
            }
            else {
                reject(this.promise, validationError());
            }
        }
        Enumerator.prototype._enumerate = function _enumerate(input) {
            for (var i = 0; this._state === PENDING && i < input.length; i++) {
                this._eachEntry(input[i], i);
            }
        };
        Enumerator.prototype._eachEntry = function _eachEntry(entry, i) {
            var c = this._instanceConstructor;
            var resolve$$1 = c.resolve;
            if (resolve$$1 === resolve$1) {
                var _then = void 0;
                var error = void 0;
                var didError = false;
                try {
                    _then = entry.then;
                }
                catch (e) {
                    didError = true;
                    error = e;
                }
                if (_then === then && entry._state !== PENDING) {
                    this._settledAt(entry._state, i, entry._result);
                }
                else if (typeof _then !== 'function') {
                    this._remaining--;
                    this._result[i] = entry;
                }
                else if (c === Promise$1) {
                    var promise = new c(noop);
                    if (didError) {
                        reject(promise, error);
                    }
                    else {
                        handleMaybeThenable(promise, entry, _then);
                    }
                    this._willSettleAt(promise, i);
                }
                else {
                    this._willSettleAt(new c(function (resolve$$1) {
                        return resolve$$1(entry);
                    }), i);
                }
            }
            else {
                this._willSettleAt(resolve$$1(entry), i);
            }
        };
        Enumerator.prototype._settledAt = function _settledAt(state, i, value) {
            var promise = this.promise;
            if (promise._state === PENDING) {
                this._remaining--;
                if (state === REJECTED) {
                    reject(promise, value);
                }
                else {
                    this._result[i] = value;
                }
            }
            if (this._remaining === 0) {
                fulfill(promise, this._result);
            }
        };
        Enumerator.prototype._willSettleAt = function _willSettleAt(promise, i) {
            var enumerator = this;
            subscribe(promise, undefined, function (value) {
                return enumerator._settledAt(FULFILLED, i, value);
            }, function (reason) {
                return enumerator._settledAt(REJECTED, i, reason);
            });
        };
        return Enumerator;
    }();
    function all(entries) {
        return new Enumerator(this, entries).promise;
    }
    function race(entries) {
        var Constructor = this;
        if (!isArray(entries)) {
            return new Constructor(function (_, reject) {
                return reject(new TypeError('You must pass an array to race.'));
            });
        }
        else {
            return new Constructor(function (resolve, reject) {
                var length = entries.length;
                for (var i = 0; i < length; i++) {
                    Constructor.resolve(entries[i]).then(resolve, reject);
                }
            });
        }
    }
    function reject$1(reason) {
        var Constructor = this;
        var promise = new Constructor(noop);
        reject(promise, reason);
        return promise;
    }
    function needsResolver() {
        throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
    }
    function needsNew() {
        throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
    }
    var Promise$1 = function () {
        function Promise(resolver) {
            this[PROMISE_ID] = nextId();
            this._result = this._state = undefined;
            this._subscribers = [];
            if (noop !== resolver) {
                typeof resolver !== 'function' && needsResolver();
                this instanceof Promise ? initializePromise(this, resolver) : needsNew();
            }
        }
        Promise.prototype.catch = function _catch(onRejection) {
            return this.then(null, onRejection);
        };
        Promise.prototype.finally = function _finally(callback) {
            var promise = this;
            var constructor = promise.constructor;
            if (isFunction(callback)) {
                return promise.then(function (value) {
                    return constructor.resolve(callback()).then(function () {
                        return value;
                    });
                }, function (reason) {
                    return constructor.resolve(callback()).then(function () {
                        throw reason;
                    });
                });
            }
            return promise.then(callback, callback);
        };
        return Promise;
    }();
    Promise$1.prototype.then = then;
    Promise$1.all = all;
    Promise$1.race = race;
    Promise$1.resolve = resolve$1;
    Promise$1.reject = reject$1;
    Promise$1._setScheduler = setScheduler;
    Promise$1._setAsap = setAsap;
    Promise$1._asap = asap;
    function polyfill() {
        var local = void 0;
        if (typeof __webpack_require__.g !== 'undefined') {
            local = __webpack_require__.g;
        }
        else if (typeof self !== 'undefined') {
            local = self;
        }
        else {
            try {
                local = Function('return this')();
            }
            catch (e) {
                throw new Error('polyfill failed because global object is unavailable in this environment');
            }
        }
        var P = local.Promise;
        if (P) {
            var promiseToString = null;
            try {
                promiseToString = Object.prototype.toString.call(P.resolve());
            }
            catch (e) {
            }
            if (promiseToString === '[object Promise]' && !P.cast) {
                return;
            }
        }
        local.Promise = Promise$1;
    }
    Promise$1.polyfill = polyfill;
    Promise$1.Promise = Promise$1;
    return Promise$1;
})));


/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Jodit = void 0;
var tslib_1 = __webpack_require__(7);
var config_1 = __webpack_require__(8);
var consts = __webpack_require__(9);
var modules_1 = __webpack_require__(10);
var helpers_1 = __webpack_require__(19);
var storage_1 = __webpack_require__(169);
var view_with_toolbar_1 = __webpack_require__(166);
var global_1 = __webpack_require__(30);
var decorators_1 = __webpack_require__(99);
var Jodit = (function (_super) {
    tslib_1.__extends(Jodit, _super);
    function Jodit(element, options) {
        var _this = _super.call(this, options, true) || this;
        _this.isJodit = true;
        _this.__defaultStyleDisplayKey = 'data-jodit-default-style-display';
        _this.__defaultClassesKey = 'data-jodit-default-classes';
        _this.commands = {};
        _this.__selectionLocked = null;
        _this.__wasReadOnly = false;
        _this.createInside = new modules_1.Create(function () { return _this.ed; }, _this.o.createAttributes);
        _this.editorIsActive = false;
        _this.__mode = consts.MODE_WYSIWYG;
        _this.__callChangeCount = 0;
        _this.isSilentChange = false;
        _this.elementToPlace = new Map();
        try {
            helpers_1.resolveElement(element, _this.o.shadowRoot || _this.od);
        }
        catch (e) {
            _this.destruct();
            throw e;
        }
        _this.setStatus(modules_1.STATUSES.beforeInit);
        _this.id =
            helpers_1.attr(helpers_1.resolveElement(element, _this.o.shadowRoot || _this.od), 'id') ||
                new Date().getTime().toString();
        global_1.instances[_this.id] = _this;
        _this.storage = storage_1.Storage.makeStorage(true, _this.id);
        _this.attachEvents(options);
        _this.e.on(_this.ow, 'resize', function () {
            if (_this.e) {
                _this.e.fire('resize');
            }
        });
        _this.e.on('prepareWYSIWYGEditor', _this.prepareWYSIWYGEditor);
        _this.selection = new modules_1.Select(_this);
        var beforeInitHookResult = _this.beforeInitHook();
        helpers_1.callPromise(beforeInitHookResult, function () {
            _this.e.fire('beforeInit', _this);
            var initPluginsResult = global_1.pluginSystem.init(_this);
            helpers_1.callPromise(initPluginsResult, function () {
                _this.e.fire('afterPluginSystemInit', _this);
                _this.e.on('changePlace', function () {
                    _this.setReadOnly(_this.o.readonly);
                    _this.setDisabled(_this.o.disabled);
                });
                _this.places.length = 0;
                var addPlaceResult = _this.addPlace(element, options);
                global_1.instances[_this.id] = _this;
                var init = function () {
                    if (_this.e) {
                        _this.e.fire('afterInit', _this);
                    }
                    _this.afterInitHook();
                    _this.setStatus(modules_1.STATUSES.ready);
                    _this.e.fire('afterConstructor', _this);
                };
                helpers_1.callPromise(addPlaceResult, init);
            });
        });
        return _this;
    }
    Jodit.prototype.className = function () {
        return 'Jodit';
    };
    Jodit.prototype.waitForReady = function () {
        var _this = this;
        if (this.isReady) {
            return Promise.resolve(this);
        }
        return this.async.promise(function (resolve) {
            _this.hookStatus('ready', function () { return resolve(_this); });
        });
    };
    Object.defineProperty(Jodit.prototype, "text", {
        get: function () {
            if (this.editor) {
                return this.editor.innerText || '';
            }
            var div = this.createInside.div();
            div.innerHTML = this.getElementValue();
            return div.innerText || '';
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "value", {
        get: function () {
            return this.getEditorValue();
        },
        set: function (html) {
            this.setEditorValue(html);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "defaultTimeout", {
        get: function () {
            return this.options && this.o.observer
                ? this.o.observer.timeout
                : config_1.Config.defaultOptions.observer.timeout;
        },
        enumerable: false,
        configurable: true
    });
    Jodit.atom = function (object) {
        return helpers_1.markAsAtomic(object);
    };
    Jodit.make = function (element, options) {
        return new Jodit(element, options);
    };
    Object.defineProperty(Jodit, "defaultOptions", {
        get: function () {
            return config_1.Config.defaultOptions;
        },
        enumerable: false,
        configurable: true
    });
    Jodit.prototype.setPlaceField = function (field, value) {
        if (!this.currentPlace) {
            this.currentPlace = {};
            this.places = [this.currentPlace];
        }
        this.currentPlace[field] = value;
    };
    Object.defineProperty(Jodit.prototype, "element", {
        get: function () {
            return this.currentPlace.element;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "editor", {
        get: function () {
            return this.currentPlace.editor;
        },
        set: function (editor) {
            this.setPlaceField('editor', editor);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "container", {
        get: function () {
            return this.currentPlace.container;
        },
        set: function (container) {
            this.setPlaceField('container', container);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "workplace", {
        get: function () {
            return this.currentPlace.workplace;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "statusbar", {
        get: function () {
            return this.currentPlace.statusbar;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "iframe", {
        get: function () {
            return this.currentPlace.iframe;
        },
        set: function (iframe) {
            this.setPlaceField('iframe', iframe);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "observer", {
        get: function () {
            return this.currentPlace.observer;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "editorWindow", {
        get: function () {
            return this.currentPlace.editorWindow;
        },
        set: function (win) {
            this.setPlaceField('editorWindow', win);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "ew", {
        get: function () {
            return this.editorWindow;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "editorDocument", {
        get: function () {
            return this.currentPlace.editorWindow.document;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "ed", {
        get: function () {
            return this.editorDocument;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "options", {
        get: function () {
            return this.currentPlace.options;
        },
        set: function (opt) {
            this.setPlaceField('options', opt);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "s", {
        get: function () {
            return this.selection;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "uploader", {
        get: function () {
            return this.getInstance('Uploader', this.o.uploader);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "filebrowser", {
        get: function () {
            var jodit = this;
            var options = helpers_1.ConfigProto({
                defaultTimeout: jodit.defaultTimeout,
                uploader: jodit.o.uploader,
                language: jodit.o.language,
                license: jodit.o.license,
                theme: jodit.o.theme,
                defaultCallback: function (data) {
                    if (data.files && data.files.length) {
                        data.files.forEach(function (file, i) {
                            var url = data.baseurl + file;
                            var isImage = data.isImages
                                ? data.isImages[i]
                                : false;
                            if (isImage) {
                                jodit.s.insertImage(url, null, jodit.o.imageDefaultWidth);
                            }
                            else {
                                jodit.s.insertNode(jodit.createInside.fromHTML("<a href='" + url + "' title='" + url + "'>" + url + "</a>"));
                            }
                        });
                    }
                }
            }, this.o.filebrowser);
            return jodit.getInstance('FileBrowser', options);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Jodit.prototype, "mode", {
        get: function () {
            return this.__mode;
        },
        set: function (mode) {
            this.setMode(mode);
        },
        enumerable: false,
        configurable: true
    });
    Jodit.prototype.getNativeEditorValue = function () {
        var value = this.e.fire('beforeGetNativeEditorValue');
        if (helpers_1.isString(value)) {
            return value;
        }
        if (this.editor) {
            return this.editor.innerHTML;
        }
        return this.getElementValue();
    };
    Jodit.prototype.setNativeEditorValue = function (value) {
        if (this.e.fire('beforeSetNativeEditorValue', value)) {
            return;
        }
        if (this.editor) {
            this.editor.innerHTML = value;
        }
    };
    Jodit.prototype.getEditorValue = function (removeSelectionMarkers) {
        if (removeSelectionMarkers === void 0) { removeSelectionMarkers = true; }
        var value;
        value = this.e.fire('beforeGetValueFromEditor');
        if (value !== undefined) {
            return value;
        }
        value = this.getNativeEditorValue().replace(consts.INVISIBLE_SPACE_REG_EXP(), '');
        if (removeSelectionMarkers) {
            value = value.replace(/<span[^>]+id="jodit-selection_marker_[^>]+><\/span>/g, '');
        }
        if (value === '<br>') {
            value = '';
        }
        var new_value = { value: value };
        this.e.fire('afterGetValueFromEditor', new_value);
        return new_value.value;
    };
    Jodit.prototype.setEditorValue = function (value) {
        var newValue = this.e.fire('beforeSetValueToEditor', value);
        if (newValue === false) {
            return;
        }
        if (helpers_1.isString(newValue)) {
            value = newValue;
        }
        if (!this.editor) {
            if (value !== undefined) {
                this.setElementValue(value);
            }
            return;
        }
        if (!helpers_1.isString(value) && !helpers_1.isVoid(value)) {
            throw helpers_1.error('value must be string');
        }
        if (value !== undefined && this.getNativeEditorValue() !== value) {
            this.setNativeEditorValue(value);
        }
        this.e.fire('postProcessSetEditorValue');
        var old_value = this.getElementValue(), new_value = this.getEditorValue();
        if (!this.isSilentChange &&
            old_value !== new_value &&
            this.__callChangeCount < consts.SAFE_COUNT_CHANGE_CALL) {
            this.setElementValue(new_value);
            this.__callChangeCount += 1;
            try {
                this.observer.upTick();
                this.e.fire('change', new_value, old_value);
                this.e.fire(this.observer, 'change', new_value, old_value);
            }
            finally {
                this.__callChangeCount = 0;
            }
        }
    };
    Jodit.prototype.getElementValue = function () {
        return this.element.value !== undefined
            ? this.element.value
            : this.element.innerHTML;
    };
    Jodit.prototype.setElementValue = function (value) {
        if (!helpers_1.isString(value) && value !== undefined) {
            throw helpers_1.error('value must be string');
        }
        if (value !== undefined) {
            if (this.element !== this.container) {
                if (this.element.value !== undefined) {
                    this.element.value = value;
                }
                else {
                    this.element.innerHTML = value;
                }
            }
        }
        else {
            value = this.getElementValue();
        }
        if (value !== this.getEditorValue()) {
            this.setEditorValue(value);
        }
    };
    Jodit.prototype.registerCommand = function (commandNameOriginal, command, options) {
        var commandName = commandNameOriginal.toLowerCase();
        if (this.commands[commandName] === undefined) {
            this.commands[commandName] = [];
        }
        this.commands[commandName].push(command);
        if (!helpers_1.isFunction(command)) {
            var hotkeys = this.o.commandToHotkeys[commandName] ||
                this.o.commandToHotkeys[commandNameOriginal] ||
                command.hotkeys;
            if (hotkeys) {
                this.registerHotkeyToCommand(hotkeys, commandName, options === null || options === void 0 ? void 0 : options.stopPropagation);
            }
        }
        return this;
    };
    Jodit.prototype.registerHotkeyToCommand = function (hotkeys, commandName, shouldStop) {
        var _this = this;
        if (shouldStop === void 0) { shouldStop = true; }
        var shortcuts = helpers_1.asArray(hotkeys)
            .map(helpers_1.normalizeKeyAliases)
            .map(function (hotkey) { return hotkey + '.hotkey'; })
            .join(' ');
        this.e
            .off(shortcuts)
            .on(shortcuts, function (type, stop) {
            stop.shouldStop = shouldStop !== null && shouldStop !== void 0 ? shouldStop : true;
            return _this.execCommand(commandName);
        });
    };
    Jodit.prototype.execCommand = function (command, showUI, value) {
        if (showUI === void 0) { showUI = false; }
        if (value === void 0) { value = null; }
        if (this.o.readonly && command !== 'selectall') {
            return;
        }
        var result;
        command = command.toLowerCase();
        result = this.e.fire('beforeCommand', command, showUI, value);
        if (result !== false) {
            result = this.execCustomCommands(command, showUI, value);
        }
        if (result !== false) {
            this.s.focus();
            if (command === 'selectall') {
                this.s.select(this.editor, true);
            }
            else {
                try {
                    result = this.nativeExecCommand(command, showUI, value);
                }
                catch (e) {
                    if (false) {}
                }
            }
        }
        this.e.fire('afterCommand', command, showUI, value);
        this.setEditorValue();
        return result;
    };
    Jodit.prototype.nativeExecCommand = function (command, showUI, value) {
        if (showUI === void 0) { showUI = false; }
        if (value === void 0) { value = null; }
        this.isSilentChange = true;
        try {
            return this.ed.execCommand(command, showUI, value);
        }
        finally {
            this.isSilentChange = false;
        }
    };
    Jodit.prototype.execCustomCommands = function (commandName, second, third) {
        var _this = this;
        if (second === void 0) { second = false; }
        if (third === void 0) { third = null; }
        commandName = commandName.toLowerCase();
        if (this.commands[commandName] !== undefined) {
            var result_1;
            var exec = function (command) {
                var callback;
                if (helpers_1.isFunction(command)) {
                    callback = command;
                }
                else {
                    callback = command.exec;
                }
                var resultCurrent = callback.call(_this, commandName, second, third);
                if (resultCurrent !== undefined) {
                    result_1 = resultCurrent;
                }
            };
            for (var i = 0; i < this.commands[commandName].length; i += 1) {
                exec(this.commands[commandName][i]);
            }
            return result_1;
        }
    };
    Jodit.prototype.lock = function (name) {
        if (name === void 0) { name = 'any'; }
        if (_super.prototype.lock.call(this, name)) {
            this.__selectionLocked = this.s.save();
            this.s.clear();
            this.editor.classList.add('jodit_disabled');
            this.e.fire('lock', true);
            return true;
        }
        return false;
    };
    Jodit.prototype.unlock = function () {
        if (_super.prototype.unlock.call(this)) {
            this.editor.classList.remove('jodit_disabled');
            if (this.__selectionLocked) {
                this.s.restore();
            }
            this.e.fire('lock', false);
            return true;
        }
        return false;
    };
    Jodit.prototype.getMode = function () {
        return this.mode;
    };
    Jodit.prototype.isEditorMode = function () {
        return this.getRealMode() === consts.MODE_WYSIWYG;
    };
    Jodit.prototype.getRealMode = function () {
        if (this.getMode() !== consts.MODE_SPLIT) {
            return this.getMode();
        }
        var active = this.od.activeElement;
        if (active &&
            (active === this.iframe ||
                modules_1.Dom.isOrContains(this.editor, active) ||
                modules_1.Dom.isOrContains(this.toolbar.container, active))) {
            return consts.MODE_WYSIWYG;
        }
        return consts.MODE_SOURCE;
    };
    Jodit.prototype.setMode = function (mode) {
        var _this = this;
        var oldmode = this.getMode();
        var data = {
            mode: parseInt(mode.toString(), 10)
        }, modeClasses = [
            'jodit-wysiwyg_mode',
            'jodit-source__mode',
            'jodit_split_mode'
        ];
        if (this.e.fire('beforeSetMode', data) === false) {
            return;
        }
        this.__mode = [
            consts.MODE_SOURCE,
            consts.MODE_WYSIWYG,
            consts.MODE_SPLIT
        ].includes(data.mode)
            ? data.mode
            : consts.MODE_WYSIWYG;
        if (this.o.saveModeInStorage) {
            this.storage.set('jodit_default_mode', this.mode);
        }
        modeClasses.forEach(function (className) {
            _this.container.classList.remove(className);
        });
        this.container.classList.add(modeClasses[this.mode - 1]);
        if (oldmode !== this.getMode()) {
            this.e.fire('afterSetMode');
        }
    };
    Jodit.prototype.toggleMode = function () {
        var mode = this.getMode();
        if ([
            consts.MODE_SOURCE,
            consts.MODE_WYSIWYG,
            this.o.useSplitMode ? consts.MODE_SPLIT : 9
        ].includes(mode + 1)) {
            mode += 1;
        }
        else {
            mode = consts.MODE_WYSIWYG;
        }
        this.setMode(mode);
    };
    Jodit.prototype.setDisabled = function (isDisabled) {
        this.o.disabled = isDisabled;
        var readOnly = this.__wasReadOnly;
        this.setReadOnly(isDisabled || readOnly);
        this.__wasReadOnly = readOnly;
        if (this.editor) {
            this.editor.setAttribute('aria-disabled', isDisabled.toString());
            this.container.classList.toggle('jodit_disabled', isDisabled);
            this.e.fire('disabled', isDisabled);
        }
    };
    Jodit.prototype.getDisabled = function () {
        return this.o.disabled;
    };
    Jodit.prototype.setReadOnly = function (isReadOnly) {
        if (this.__wasReadOnly === isReadOnly) {
            return;
        }
        this.__wasReadOnly = isReadOnly;
        this.o.readonly = isReadOnly;
        if (isReadOnly) {
            this.editor && this.editor.removeAttribute('contenteditable');
        }
        else {
            this.editor && this.editor.setAttribute('contenteditable', 'true');
        }
        this.e && this.e.fire('readonly', isReadOnly);
    };
    Jodit.prototype.getReadOnly = function () {
        return this.o.readonly;
    };
    Jodit.prototype.beforeInitHook = function () {
    };
    Jodit.prototype.afterInitHook = function () {
    };
    Jodit.prototype.initOptions = function (options) {
        this.options = (helpers_1.ConfigProto(options || {}, config_1.Config.defaultOptions));
    };
    Jodit.prototype.initOwners = function () {
        this.editorWindow = this.o.ownerWindow;
        this.ownerWindow = this.o.ownerWindow;
    };
    Jodit.prototype.addPlace = function (source, options) {
        var _this = this;
        var element = helpers_1.resolveElement(source, this.o.shadowRoot || this.od);
        this.attachEvents(options);
        if (element.attributes) {
            helpers_1.toArray(element.attributes).forEach(function (attr) {
                var name = attr.name;
                var value = attr.value;
                if (config_1.Config.defaultOptions[name] !== undefined &&
                    (!options || options[name] === undefined)) {
                    if (['readonly', 'disabled'].indexOf(name) !== -1) {
                        value = value === '' || value === 'true';
                    }
                    if (/^[0-9]+(\.)?([0-9]+)?$/.test(value.toString())) {
                        value = Number(value);
                    }
                    _this.options[name] = value;
                }
            });
        }
        var container = this.c.div('jodit-container');
        container.classList.add('jodit');
        container.classList.add('jodit-container');
        container.classList.add("jodit_theme_" + (this.o.theme || 'default'));
        container.setAttribute('contenteditable', 'false');
        var buffer = null;
        if (this.o.inline) {
            if (['TEXTAREA', 'INPUT'].indexOf(element.nodeName) === -1) {
                container = element;
                element.setAttribute(this.__defaultClassesKey, element.className.toString());
                buffer = container.innerHTML;
                container.innerHTML = '';
            }
            container.classList.add('jodit_inline');
            container.classList.add('jodit-container');
        }
        if (element !== container) {
            if (element.style.display) {
                element.setAttribute(this.__defaultStyleDisplayKey, element.style.display);
            }
            element.style.display = 'none';
        }
        var workplace = this.c.div('jodit-workplace', {
            contenteditable: false
        });
        container.appendChild(workplace);
        var statusbar = new modules_1.StatusBar(this, container);
        if (element.parentNode && element !== container) {
            element.parentNode.insertBefore(container, element);
        }
        Object.defineProperty(element, 'component', {
            enumerable: false,
            configurable: true,
            value: this
        });
        var editor = this.c.div('jodit-wysiwyg', {
            contenteditable: true,
            'aria-disabled': false,
            tabindex: this.o.tabIndex
        });
        workplace.appendChild(editor);
        var currentPlace = {
            editor: editor,
            element: element,
            container: container,
            workplace: workplace,
            statusbar: statusbar,
            options: this.isReady
                ? helpers_1.ConfigProto(options || {}, config_1.Config.defaultOptions)
                : this.options,
            observer: new modules_1.Observer(this),
            editorWindow: this.ow
        };
        this.elementToPlace.set(editor, currentPlace);
        this.setCurrentPlace(currentPlace);
        this.places.push(currentPlace);
        this.setNativeEditorValue(this.getElementValue());
        var initResult = this.initEditor(buffer);
        var opt = this.options;
        var init = function () {
            if (opt.enableDragAndDropFileToEditor &&
                opt.uploader &&
                (opt.uploader.url || opt.uploader.insertImageAsBase64URI)) {
                _this.uploader.bind(_this.editor);
            }
            if (!_this.elementToPlace.get(_this.editor)) {
                _this.elementToPlace.set(_this.editor, currentPlace);
            }
            _this.e.fire('afterAddPlace', currentPlace);
        };
        return helpers_1.callPromise(initResult, init);
    };
    Jodit.prototype.addDisclaimer = function (elm) {
        this.workplace.appendChild(elm);
    };
    Jodit.prototype.setCurrentPlace = function (place) {
        if (this.currentPlace === place) {
            return;
        }
        if (!this.isEditorMode()) {
            this.setMode(consts.MODE_WYSIWYG);
        }
        this.currentPlace = place;
        this.buildToolbar();
        if (this.isReady) {
            this.e.fire('changePlace', place);
        }
    };
    Jodit.prototype.initEditor = function (buffer) {
        var _this = this;
        var result = this.createEditor();
        return helpers_1.callPromise(result, function () {
            if (_this.isInDestruct) {
                return;
            }
            if (_this.element !== _this.container) {
                _this.setElementValue();
            }
            else {
                buffer != null && _this.setEditorValue(buffer);
            }
            var mode = _this.o.defaultMode;
            if (_this.o.saveModeInStorage) {
                var localMode = _this.storage.get('jodit_default_mode');
                if (typeof localMode === 'string') {
                    mode = parseInt(localMode, 10);
                }
            }
            _this.setMode(mode);
            if (_this.o.readonly) {
                _this.__wasReadOnly = false;
                _this.setReadOnly(true);
            }
            if (_this.o.disabled) {
                _this.setDisabled(true);
            }
            try {
                _this.ed.execCommand('defaultParagraphSeparator', false, _this.o.enter.toLowerCase());
            }
            catch (_a) { }
            try {
                _this.ed.execCommand('enableObjectResizing', false, 'false');
            }
            catch (_b) { }
            try {
                _this.ed.execCommand('enableInlineTableEditing', false, 'false');
            }
            catch (_c) { }
        });
    };
    Jodit.prototype.createEditor = function () {
        var _this = this;
        var defaultEditorArea = this.editor;
        var stayDefault = this.e.fire('createEditor', this);
        return helpers_1.callPromise(stayDefault, function () {
            if (_this.isInDestruct) {
                return;
            }
            if (stayDefault === false || helpers_1.isPromise(stayDefault)) {
                modules_1.Dom.safeRemove(defaultEditorArea);
            }
            if (_this.o.editorCssClass) {
                _this.editor.classList.add(_this.o.editorCssClass);
            }
            if (_this.o.style) {
                helpers_1.css(_this.editor, _this.o.style);
            }
            _this.e
                .on('synchro', function () {
                _this.setEditorValue();
            })
                .on('focus', function () {
                _this.editorIsActive = true;
            })
                .on('blur', function () { return (_this.editorIsActive = false); });
            _this.prepareWYSIWYGEditor();
            if (_this.o.direction) {
                var direction = _this.o.direction.toLowerCase() === 'rtl' ? 'rtl' : 'ltr';
                _this.container.style.direction = direction;
                _this.container.setAttribute('dir', direction);
                _this.toolbar.setDirection(direction);
            }
            if (_this.o.triggerChangeEvent) {
                _this.e.on('change', _this.async.debounce(function () {
                    _this.e && _this.e.fire(_this.element, 'change');
                }, _this.defaultTimeout));
            }
        });
    };
    Jodit.prototype.prepareWYSIWYGEditor = function () {
        var _this = this;
        var editor = this.editor;
        if (this.o.spellcheck) {
            this.editor.setAttribute('spellcheck', 'true');
        }
        else {
            this.editor.setAttribute('spellcheck', 'false');
        }
        if (this.o.direction) {
            var direction = this.o.direction.toLowerCase() === 'rtl' ? 'rtl' : 'ltr';
            this.editor.style.direction = direction;
            this.editor.setAttribute('dir', direction);
        }
        this.e
            .on(editor, 'mousedown touchstart focus', function () {
            var place = _this.elementToPlace.get(editor);
            if (place) {
                _this.setCurrentPlace(place);
            }
        })
            .on(editor, 'compositionend', function () {
            _this.setEditorValue();
        })
            .on(editor, 'selectionchange selectionstart keydown keyup input keypress dblclick mousedown mouseup ' +
            'click copy cut dragstart drop dragover paste resize touchstart touchend focus blur', function (event) {
            if (_this.o.readonly || _this.isSilentChange) {
                return;
            }
            var w = _this.ew;
            if (event instanceof w.KeyboardEvent &&
                event.isComposing) {
                return;
            }
            if (_this.e && _this.e.fire) {
                if (_this.e.fire(event.type, event) === false) {
                    return false;
                }
                _this.setEditorValue();
            }
        });
    };
    Jodit.prototype.destruct = function () {
        var _this = this;
        if (this.isInDestruct) {
            return;
        }
        this.setStatus(modules_1.STATUSES.beforeDestruct);
        this.elementToPlace.clear();
        if (!this.editor) {
            return;
        }
        var buffer = this.getEditorValue();
        this.storage.clear();
        this.buffer.clear();
        this.commands = {};
        this.__selectionLocked = null;
        this.e.off(this.ow, 'resize');
        this.e.off(this.ow);
        this.e.off(this.od);
        this.e.off(this.od.body);
        this.places.forEach(function (_a) {
            var container = _a.container, workplace = _a.workplace, statusbar = _a.statusbar, element = _a.element, iframe = _a.iframe, editor = _a.editor, observer = _a.observer;
            if (element !== container) {
                if (element.hasAttribute(_this.__defaultStyleDisplayKey)) {
                    var display = helpers_1.attr(element, _this.__defaultStyleDisplayKey);
                    if (display) {
                        element.style.display = display;
                        element.removeAttribute(_this.__defaultStyleDisplayKey);
                    }
                }
                else {
                    element.style.display = '';
                }
            }
            else {
                if (element.hasAttribute(_this.__defaultClassesKey)) {
                    element.className =
                        helpers_1.attr(element, _this.__defaultClassesKey) || '';
                    element.removeAttribute(_this.__defaultClassesKey);
                }
            }
            if (element.hasAttribute('style') && !helpers_1.attr(element, 'style')) {
                element.removeAttribute('style');
            }
            !statusbar.isInDestruct && statusbar.destruct();
            _this.e.off(container);
            _this.e.off(element);
            _this.e.off(editor);
            modules_1.Dom.safeRemove(workplace);
            modules_1.Dom.safeRemove(editor);
            if (container !== element) {
                modules_1.Dom.safeRemove(container);
            }
            Object.defineProperty(element, 'component', {
                enumerable: false,
                configurable: true,
                value: null
            });
            modules_1.Dom.safeRemove(iframe);
            if (container === element) {
                element.innerHTML = buffer;
            }
            !observer.isInDestruct && observer.destruct();
        });
        this.places.length = 0;
        this.currentPlace = {};
        delete global_1.instances[this.id];
        _super.prototype.destruct.call(this);
    };
    Jodit.fatMode = false;
    Jodit.plugins = global_1.pluginSystem;
    Jodit.modules = global_1.modules;
    Jodit.ns = global_1.modules;
    Jodit.decorators = {};
    Jodit.instances = global_1.instances;
    Jodit.lang = global_1.lang;
    Jodit.core = {
        Plugin: modules_1.Plugin
    };
    tslib_1.__decorate([
        decorators_1.cache
    ], Jodit.prototype, "uploader", null);
    tslib_1.__decorate([
        decorators_1.cache
    ], Jodit.prototype, "filebrowser", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], Jodit.prototype, "prepareWYSIWYGEditor", null);
    return Jodit;
}(view_with_toolbar_1.ViewWithToolbar));
exports.Jodit = Jodit;


/***/ }),
/* 7 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.__classPrivateFieldSet = exports.__classPrivateFieldGet = exports.__importDefault = exports.__importStar = exports.__makeTemplateObject = exports.__asyncValues = exports.__asyncDelegator = exports.__asyncGenerator = exports.__await = exports.__spreadArray = exports.__spreadArrays = exports.__spread = exports.__read = exports.__values = exports.__exportStar = exports.__createBinding = exports.__generator = exports.__awaiter = exports.__metadata = exports.__param = exports.__decorate = exports.__rest = exports.__assign = exports.__extends = void 0;
var extendStatics = function (d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b)
            if (Object.prototype.hasOwnProperty.call(b, p))
                d[p] = b[p]; };
    return extendStatics(d, b);
};
function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}
exports.__extends = __extends;
var __assign = function () {
    exports.__assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s)
                if (Object.prototype.hasOwnProperty.call(s, p))
                    t[p] = s[p];
        }
        return t;
    };
    return exports.__assign.apply(this, arguments);
};
exports.__assign = __assign;
function __rest(s, e) {
    var t = {};
    for (var p in s)
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}
exports.__rest = __rest;
function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}
exports.__decorate = __decorate;
function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); };
}
exports.__param = __param;
function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
        return Reflect.metadata(metadataKey, metadataValue);
}
exports.__metadata = __metadata;
function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try {
            step(generator.next(value));
        }
        catch (e) {
            reject(e);
        } }
        function rejected(value) { try {
            step(generator["throw"](value));
        }
        catch (e) {
            reject(e);
        } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}
exports.__awaiter = __awaiter;
function __generator(thisArg, body) {
    var _ = { label: 0, sent: function () { if (t[0] & 1)
            throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f)
            throw new TypeError("Generator is already executing.");
        while (_)
            try {
                if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                    return t;
                if (y = 0, t)
                    op = [op[0] & 2, t.value];
                switch (op[0]) {
                    case 0:
                    case 1:
                        t = op;
                        break;
                    case 4:
                        _.label++;
                        return { value: op[1], done: false };
                    case 5:
                        _.label++;
                        y = op[1];
                        op = [0];
                        continue;
                    case 7:
                        op = _.ops.pop();
                        _.trys.pop();
                        continue;
                    default:
                        if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                            _ = 0;
                            continue;
                        }
                        if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                            _.label = op[1];
                            break;
                        }
                        if (op[0] === 6 && _.label < t[1]) {
                            _.label = t[1];
                            t = op;
                            break;
                        }
                        if (t && _.label < t[2]) {
                            _.label = t[2];
                            _.ops.push(op);
                            break;
                        }
                        if (t[2])
                            _.ops.pop();
                        _.trys.pop();
                        continue;
                }
                op = body.call(thisArg, _);
            }
            catch (e) {
                op = [6, e];
                y = 0;
            }
            finally {
                f = t = 0;
            }
        if (op[0] & 5)
            throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
    }
}
exports.__generator = __generator;
exports.__createBinding = Object.create ? (function (o, m, k, k2) {
    if (k2 === undefined)
        k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function () { return m[k]; } });
}) : (function (o, m, k, k2) {
    if (k2 === undefined)
        k2 = k;
    o[k2] = m[k];
});
function __exportStar(m, o) {
    for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
            exports.__createBinding(o, m, p);
}
exports.__exportStar = __exportStar;
function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m)
        return m.call(o);
    if (o && typeof o.length === "number")
        return {
            next: function () {
                if (o && i >= o.length)
                    o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}
exports.__values = __values;
function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m)
        return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
    }
    catch (error) {
        e = { error: error };
    }
    finally {
        try {
            if (r && !r.done && (m = i["return"]))
                m.call(i);
        }
        finally {
            if (e)
                throw e.error;
        }
    }
    return ar;
}
exports.__read = __read;
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}
exports.__spread = __spread;
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++)
        s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}
exports.__spreadArrays = __spreadArrays;
function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2)
        for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
                if (!ar)
                    ar = Array.prototype.slice.call(from, 0, i);
                ar[i] = from[i];
            }
        }
    return to.concat(ar || from);
}
exports.__spreadArray = __spreadArray;
function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}
exports.__await = __await;
function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator)
        throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n])
        i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try {
        step(g[n](v));
    }
    catch (e) {
        settle(q[0][3], e);
    } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length)
        resume(q[0][0], q[0][1]); }
}
exports.__asyncGenerator = __asyncGenerator;
function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
}
exports.__asyncDelegator = __asyncDelegator;
function __asyncValues(o) {
    if (!Symbol.asyncIterator)
        throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
}
exports.__asyncValues = __asyncValues;
function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) {
        Object.defineProperty(cooked, "raw", { value: raw });
    }
    else {
        cooked.raw = raw;
    }
    return cooked;
}
exports.__makeTemplateObject = __makeTemplateObject;
;
var __setModuleDefault = Object.create ? (function (o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function (o, v) {
    o["default"] = v;
};
function __importStar(mod) {
    if (mod && mod.__esModule)
        return mod;
    var result = {};
    if (mod != null)
        for (var k in mod)
            if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                exports.__createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}
exports.__importStar = __importStar;
function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}
exports.__importDefault = __importDefault;
function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f)
        throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
        throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}
exports.__classPrivateFieldGet = __classPrivateFieldGet;
function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m")
        throw new TypeError("Private method is not writable");
    if (kind === "a" && !f)
        throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
        throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}
exports.__classPrivateFieldSet = __classPrivateFieldSet;


/***/ }),
/* 8 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Config = void 0;
var consts = __webpack_require__(9);
var Config = (function () {
    function Config() {
        this.namespace = '';
        this.iframe = false;
        this.license = '';
        this.preset = 'custom';
        this.presets = {
            inline: {
                inline: true,
                toolbar: false,
                toolbarInline: true,
                toolbarInlineForSelection: true,
                showXPathInStatusbar: false,
                showCharsCounter: false,
                showWordsCounter: false,
                showPlaceholder: false
            }
        };
        this.ownerDocument = (typeof document !== 'undefined'
            ? document
            : null);
        this.ownerWindow = (typeof window !== 'undefined'
            ? window
            : null);
        this.shadowRoot = null;
        this.zIndex = 0;
        this.readonly = false;
        this.disabled = false;
        this.activeButtonsInReadOnly = [
            'source',
            'fullsize',
            'print',
            'about',
            'dots',
            'selectall'
        ];
        this.toolbarButtonSize = 'middle';
        this.allowTabNavigation = false;
        this.inline = false;
        this.theme = 'default';
        this.saveModeInStorage = false;
        this.spellcheck = true;
        this.editorCssClass = false;
        this.style = false;
        this.triggerChangeEvent = true;
        this.direction = '';
        this.language = 'auto';
        this.debugLanguage = false;
        this.i18n = false;
        this.tabIndex = -1;
        this.toolbar = true;
        this.statusbar = true;
        this.showTooltip = true;
        this.showTooltipDelay = 1000;
        this.useNativeTooltip = false;
        this.enter = consts.PARAGRAPH;
        this.enterBlock = this.enter !== 'br' ? this.enter : consts.PARAGRAPH;
        this.defaultMode = consts.MODE_WYSIWYG;
        this.useSplitMode = false;
        this.colors = {
            greyscale: [
                '#000000',
                '#434343',
                '#666666',
                '#999999',
                '#B7B7B7',
                '#CCCCCC',
                '#D9D9D9',
                '#EFEFEF',
                '#F3F3F3',
                '#FFFFFF'
            ],
            palette: [
                '#980000',
                '#FF0000',
                '#FF9900',
                '#FFFF00',
                '#00F0F0',
                '#00FFFF',
                '#4A86E8',
                '#0000FF',
                '#9900FF',
                '#FF00FF'
            ],
            full: [
                '#E6B8AF',
                '#F4CCCC',
                '#FCE5CD',
                '#FFF2CC',
                '#D9EAD3',
                '#D0E0E3',
                '#C9DAF8',
                '#CFE2F3',
                '#D9D2E9',
                '#EAD1DC',
                '#DD7E6B',
                '#EA9999',
                '#F9CB9C',
                '#FFE599',
                '#B6D7A8',
                '#A2C4C9',
                '#A4C2F4',
                '#9FC5E8',
                '#B4A7D6',
                '#D5A6BD',
                '#CC4125',
                '#E06666',
                '#F6B26B',
                '#FFD966',
                '#93C47D',
                '#76A5AF',
                '#6D9EEB',
                '#6FA8DC',
                '#8E7CC3',
                '#C27BA0',
                '#A61C00',
                '#CC0000',
                '#E69138',
                '#F1C232',
                '#6AA84F',
                '#45818E',
                '#3C78D8',
                '#3D85C6',
                '#674EA7',
                '#A64D79',
                '#85200C',
                '#990000',
                '#B45F06',
                '#BF9000',
                '#38761D',
                '#134F5C',
                '#1155CC',
                '#0B5394',
                '#351C75',
                '#733554',
                '#5B0F00',
                '#660000',
                '#783F04',
                '#7F6000',
                '#274E13',
                '#0C343D',
                '#1C4587',
                '#073763',
                '#20124D',
                '#4C1130'
            ]
        };
        this.colorPickerDefaultTab = 'background';
        this.imageDefaultWidth = 300;
        this.removeButtons = [];
        this.disablePlugins = [];
        this.extraPlugins = [];
        this.extraButtons = [];
        this.extraIcons = {};
        this.createAttributes = {};
        this.sizeLG = 900;
        this.sizeMD = 700;
        this.sizeSM = 400;
        this.buttons = [
            {
                group: 'source',
                buttons: []
            },
            {
                group: 'font-style',
                buttons: []
            },
            {
                group: 'script',
                buttons: []
            },
            {
                group: 'list',
                buttons: ['ul', 'ol']
            },
            {
                group: 'indent',
                buttons: []
            },
            {
                group: 'font',
                buttons: []
            },
            {
                group: 'color',
                buttons: []
            },
            {
                group: 'media',
                buttons: []
            },
            '\n',
            {
                group: 'state',
                buttons: []
            },
            {
                group: 'clipboard',
                buttons: []
            },
            {
                group: 'insert',
                buttons: []
            },
            {
                group: 'form',
                buttons: []
            },
            {
                group: 'history',
                buttons: []
            },
            {
                group: 'search',
                buttons: []
            },
            {
                group: 'other',
                buttons: []
            },
            {
                group: 'info',
                buttons: []
            }
        ];
        this.buttonsMD = [
            'source',
            '|',
            'bold',
            'italic',
            '|',
            'ul',
            'ol',
            'eraser',
            '|',
            'font',
            'fontsize',
            'brush',
            'paragraph',
            '|',
            'image',
            'table',
            'link',
            '|',
            'align',
            '\n',
            'undo',
            'redo',
            '|',
            'hr',
            'copyformat',
            'fullsize',
            'dots'
        ];
        this.buttonsSM = [
            'source',
            '|',
            'bold',
            'italic',
            '|',
            'ul',
            'ol',
            'eraser',
            '|',
            'fontsize',
            'brush',
            'paragraph',
            '|',
            'image',
            'table',
            '\n',
            'link',
            '|',
            'align',
            '|',
            'undo',
            'redo',
            '|',
            'copyformat',
            'fullsize',
            'dots'
        ];
        this.buttonsXS = [
            'bold',
            'image',
            '|',
            'brush',
            'paragraph',
            'eraser',
            '\n',
            'align',
            '|',
            'undo',
            'redo',
            '|',
            'dots'
        ];
        this.events = {};
        this.textIcons = false;
        this.showBrowserColorPicker = true;
    }
    Object.defineProperty(Config, "defaultOptions", {
        get: function () {
            if (!Config.__defaultOptions) {
                Config.__defaultOptions = new Config();
            }
            return Config.__defaultOptions;
        },
        enumerable: false,
        configurable: true
    });
    return Config;
}());
exports.Config = Config;
Config.prototype.controls = {};


/***/ }),
/* 9 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BASE_PATH = exports.KEY_ALIASES = exports.IS_MAC = exports.SAFE_COUNT_CHANGE_CALL = exports.INSERT_ONLY_TEXT = exports.INSERT_AS_TEXT = exports.INSERT_CLEAR_HTML = exports.INSERT_AS_HTML = exports.EMULATE_DBLCLICK_TIMEOUT = exports.MARKER_CLASS = exports.TEXT_HTML = exports.TEXT_PLAIN = exports.IS_IE = exports.MODE_SPLIT = exports.MODE_SOURCE = exports.MODE_WYSIWYG = exports.PARAGRAPH = exports.BR = exports.COMMAND_KEYS = exports.ACCURACY = exports.NEARBY = exports.KEY_F3 = exports.KEY_DELETE = exports.KEY_SPACE = exports.KEY_DOWN = exports.KEY_RIGHT = exports.KEY_UP = exports.KEY_LEFT = exports.KEY_ESC = exports.KEY_ENTER = exports.KEY_TAB = exports.KEY_BACKSPACE = exports.MAY_BE_REMOVED_WITH_KEY = exports.INSEPARABLE_TAGS = exports.IS_INLINE = exports.IS_BLOCK = exports.SPACE_REG_EXP_END = exports.SPACE_REG_EXP_START = exports.SPACE_REG_EXP = exports.INVISIBLE_SPACE_REG_EXP_START = exports.INVISIBLE_SPACE_REG_EXP_END = exports.INVISIBLE_SPACE_REG_EXP = exports.NBSP_SPACE = exports.INVISIBLE_SPACE = void 0;
exports.INVISIBLE_SPACE = '\uFEFF';
exports.NBSP_SPACE = '\u00A0';
var INVISIBLE_SPACE_REG_EXP = function () { return /[\uFEFF]/g; };
exports.INVISIBLE_SPACE_REG_EXP = INVISIBLE_SPACE_REG_EXP;
var INVISIBLE_SPACE_REG_EXP_END = function () { return /[\uFEFF]+$/g; };
exports.INVISIBLE_SPACE_REG_EXP_END = INVISIBLE_SPACE_REG_EXP_END;
var INVISIBLE_SPACE_REG_EXP_START = function () { return /^[\uFEFF]+/g; };
exports.INVISIBLE_SPACE_REG_EXP_START = INVISIBLE_SPACE_REG_EXP_START;
var SPACE_REG_EXP = function () { return /[\s\n\t\r\uFEFF\u200b]+/g; };
exports.SPACE_REG_EXP = SPACE_REG_EXP;
var SPACE_REG_EXP_START = function () { return /^[\s\n\t\r\uFEFF\u200b]+/g; };
exports.SPACE_REG_EXP_START = SPACE_REG_EXP_START;
var SPACE_REG_EXP_END = function () { return /[\s\n\t\r\uFEFF\u200b]+$/g; };
exports.SPACE_REG_EXP_END = SPACE_REG_EXP_END;
exports.IS_BLOCK = /^(ARTICLE|SCRIPT|STYLE|OBJECT|FOOTER|HEADER|NAV|SECTION|IFRAME|JODIT|JODIT-MEDIA|PRE|DIV|P|LI|UL|OL|H[1-6]|BLOCKQUOTE|TR|TD|TH|TBODY|THEAD|TABLE|BODY|HTML|FIGCAPTION|FIGURE|DT|DD|DL|DFN)$/i;
exports.IS_INLINE = /^(STRONG|SPAN|I|EM|B|SUP|SUB)$/i;
exports.INSEPARABLE_TAGS = [
    'img',
    'br',
    'video',
    'iframe',
    'script',
    'input',
    'textarea',
    'hr',
    'link',
    'jodit',
    'jodit-media'
];
exports.MAY_BE_REMOVED_WITH_KEY = RegExp("^" + exports.INSEPARABLE_TAGS.join('|') + "$", 'i');
exports.KEY_BACKSPACE = 'Backspace';
exports.KEY_TAB = 'Tab';
exports.KEY_ENTER = 'Enter';
exports.KEY_ESC = 'Escape';
exports.KEY_LEFT = 'ArrowLeft';
exports.KEY_UP = 'ArrowUp';
exports.KEY_RIGHT = 'ArrowRight';
exports.KEY_DOWN = 'ArrowDown';
exports.KEY_SPACE = 'Space';
exports.KEY_DELETE = 'Delete';
exports.KEY_F3 = 'F3';
exports.NEARBY = 5;
exports.ACCURACY = 10;
exports.COMMAND_KEYS = [
    exports.KEY_BACKSPACE,
    exports.KEY_DELETE,
    exports.KEY_UP,
    exports.KEY_DOWN,
    exports.KEY_RIGHT,
    exports.KEY_LEFT,
    exports.KEY_ENTER,
    exports.KEY_ESC,
    exports.KEY_F3,
    exports.KEY_TAB
];
exports.BR = 'br';
exports.PARAGRAPH = 'p';
exports.MODE_WYSIWYG = 1;
exports.MODE_SOURCE = 2;
exports.MODE_SPLIT = 3;
exports.IS_IE = typeof navigator !== 'undefined' &&
    (navigator.userAgent.indexOf('MSIE') !== -1 ||
        /rv:11.0/i.test(navigator.userAgent));
exports.TEXT_PLAIN = exports.IS_IE ? 'text' : 'text/plain';
exports.TEXT_HTML = exports.IS_IE ? 'html' : 'text/html';
exports.MARKER_CLASS = 'jodit-selection_marker';
exports.EMULATE_DBLCLICK_TIMEOUT = 300;
exports.INSERT_AS_HTML = 'insert_as_html';
exports.INSERT_CLEAR_HTML = 'insert_clear_html';
exports.INSERT_AS_TEXT = 'insert_as_text';
exports.INSERT_ONLY_TEXT = 'insert_only_text';
exports.SAFE_COUNT_CHANGE_CALL = 10;
exports.IS_MAC = typeof window !== 'undefined' &&
    /Mac|iPod|iPhone|iPad/.test(window.navigator.platform);
exports.KEY_ALIASES = {
    add: '+',
    break: 'pause',
    cmd: 'meta',
    command: 'meta',
    ctl: 'control',
    ctrl: 'control',
    del: 'delete',
    down: 'arrowdown',
    esc: 'escape',
    ins: 'insert',
    left: 'arrowleft',
    mod: exports.IS_MAC ? 'meta' : 'control',
    opt: 'alt',
    option: 'alt',
    return: 'enter',
    right: 'arrowright',
    space: ' ',
    spacebar: ' ',
    up: 'arrowup',
    win: 'meta',
    windows: 'meta'
};
exports.BASE_PATH = (function () {
    if (typeof document === 'undefined') {
        return '';
    }
    var script = document.currentScript, removeScriptName = function (s) { return s.replace(/\/[^/]+.js$/, '/'); };
    if (script) {
        return removeScriptName(script.src);
    }
    var scripts = document.querySelectorAll('script[src]');
    if (scripts && scripts.length) {
        return removeScriptName(scripts[scripts.length - 1].src);
    }
    return window.location.href;
})();


/***/ }),
/* 10 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PluginSystem = exports.Uploader = exports.ToolbarCollection = exports.ToolbarEditorCollection = exports.Table = exports.StatusBar = exports.Snapshot = exports.Style = exports.Select = exports.Observer = exports.ImageEditor = exports.Helpers = exports.FileBrowser = exports.ViewWithToolbar = exports.View = exports.Icon = exports.ProgressBar = exports.UIBlock = exports.UICheckbox = exports.UITextArea = exports.UIInput = exports.UIForm = exports.UIList = exports.UIGroup = exports.UISeparator = exports.Popup = exports.UIButton = exports.UIElement = exports.Create = exports.Plugin = exports.Dom = exports.Dialog = exports.Prompt = exports.Confirm = exports.Alert = exports.ContextMenu = exports.STATUSES = exports.ViewComponent = exports.Component = exports.Ajax = exports.Async = void 0;
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(11), exports);
var async_1 = __webpack_require__(159);
Object.defineProperty(exports, "Async", ({ enumerable: true, get: function () { return async_1.Async; } }));
var ajax_1 = __webpack_require__(160);
Object.defineProperty(exports, "Ajax", ({ enumerable: true, get: function () { return ajax_1.Ajax; } }));
var component_1 = __webpack_require__(27);
Object.defineProperty(exports, "Component", ({ enumerable: true, get: function () { return component_1.Component; } }));
Object.defineProperty(exports, "ViewComponent", ({ enumerable: true, get: function () { return component_1.ViewComponent; } }));
Object.defineProperty(exports, "STATUSES", ({ enumerable: true, get: function () { return component_1.STATUSES; } }));
var context_menu_1 = __webpack_require__(161);
Object.defineProperty(exports, "ContextMenu", ({ enumerable: true, get: function () { return context_menu_1.ContextMenu; } }));
var dialog_1 = __webpack_require__(163);
Object.defineProperty(exports, "Alert", ({ enumerable: true, get: function () { return dialog_1.Alert; } }));
Object.defineProperty(exports, "Confirm", ({ enumerable: true, get: function () { return dialog_1.Confirm; } }));
Object.defineProperty(exports, "Prompt", ({ enumerable: true, get: function () { return dialog_1.Prompt; } }));
Object.defineProperty(exports, "Dialog", ({ enumerable: true, get: function () { return dialog_1.Dialog; } }));
var dom_1 = __webpack_require__(32);
Object.defineProperty(exports, "Dom", ({ enumerable: true, get: function () { return dom_1.Dom; } }));
var plugin_1 = __webpack_require__(184);
Object.defineProperty(exports, "Plugin", ({ enumerable: true, get: function () { return plugin_1.Plugin; } }));
var create_1 = __webpack_require__(185);
Object.defineProperty(exports, "Create", ({ enumerable: true, get: function () { return create_1.Create; } }));
var ui_1 = __webpack_require__(75);
Object.defineProperty(exports, "UIElement", ({ enumerable: true, get: function () { return ui_1.UIElement; } }));
Object.defineProperty(exports, "UIButton", ({ enumerable: true, get: function () { return ui_1.UIButton; } }));
Object.defineProperty(exports, "Popup", ({ enumerable: true, get: function () { return ui_1.Popup; } }));
Object.defineProperty(exports, "UISeparator", ({ enumerable: true, get: function () { return ui_1.UISeparator; } }));
Object.defineProperty(exports, "UIGroup", ({ enumerable: true, get: function () { return ui_1.UIGroup; } }));
Object.defineProperty(exports, "UIList", ({ enumerable: true, get: function () { return ui_1.UIList; } }));
Object.defineProperty(exports, "UIForm", ({ enumerable: true, get: function () { return ui_1.UIForm; } }));
Object.defineProperty(exports, "UIInput", ({ enumerable: true, get: function () { return ui_1.UIInput; } }));
Object.defineProperty(exports, "UITextArea", ({ enumerable: true, get: function () { return ui_1.UITextArea; } }));
Object.defineProperty(exports, "UICheckbox", ({ enumerable: true, get: function () { return ui_1.UICheckbox; } }));
Object.defineProperty(exports, "UIBlock", ({ enumerable: true, get: function () { return ui_1.UIBlock; } }));
Object.defineProperty(exports, "ProgressBar", ({ enumerable: true, get: function () { return ui_1.ProgressBar; } }));
Object.defineProperty(exports, "Icon", ({ enumerable: true, get: function () { return ui_1.Icon; } }));
var view_1 = __webpack_require__(168);
Object.defineProperty(exports, "View", ({ enumerable: true, get: function () { return view_1.View; } }));
var view_with_toolbar_1 = __webpack_require__(166);
Object.defineProperty(exports, "ViewWithToolbar", ({ enumerable: true, get: function () { return view_with_toolbar_1.ViewWithToolbar; } }));
var file_browser_1 = __webpack_require__(186);
Object.defineProperty(exports, "FileBrowser", ({ enumerable: true, get: function () { return file_browser_1.FileBrowser; } }));
var Helpers = __webpack_require__(19);
exports.Helpers = Helpers;
var image_editor_1 = __webpack_require__(196);
Object.defineProperty(exports, "ImageEditor", ({ enumerable: true, get: function () { return image_editor_1.ImageEditor; } }));
var observer_1 = __webpack_require__(200);
Object.defineProperty(exports, "Observer", ({ enumerable: true, get: function () { return observer_1.Observer; } }));
var selection_1 = __webpack_require__(204);
Object.defineProperty(exports, "Select", ({ enumerable: true, get: function () { return selection_1.Select; } }));
Object.defineProperty(exports, "Style", ({ enumerable: true, get: function () { return selection_1.Style; } }));
var snapshot_1 = __webpack_require__(201);
Object.defineProperty(exports, "Snapshot", ({ enumerable: true, get: function () { return snapshot_1.Snapshot; } }));
var status_bar_1 = __webpack_require__(208);
Object.defineProperty(exports, "StatusBar", ({ enumerable: true, get: function () { return status_bar_1.StatusBar; } }));
var table_1 = __webpack_require__(210);
Object.defineProperty(exports, "Table", ({ enumerable: true, get: function () { return table_1.Table; } }));
var editor_collection_1 = __webpack_require__(176);
Object.defineProperty(exports, "ToolbarEditorCollection", ({ enumerable: true, get: function () { return editor_collection_1.ToolbarEditorCollection; } }));
var collection_1 = __webpack_require__(174);
Object.defineProperty(exports, "ToolbarCollection", ({ enumerable: true, get: function () { return collection_1.ToolbarCollection; } }));
tslib_1.__exportStar(__webpack_require__(211), exports);
var uploader_1 = __webpack_require__(212);
Object.defineProperty(exports, "Uploader", ({ enumerable: true, get: function () { return uploader_1.Uploader; } }));
var plugin_system_1 = __webpack_require__(31);
Object.defineProperty(exports, "PluginSystem", ({ enumerable: true, get: function () { return plugin_system_1.PluginSystem; } }));


/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(12), exports);
tslib_1.__exportStar(__webpack_require__(18), exports);
tslib_1.__exportStar(__webpack_require__(13), exports);


/***/ }),
/* 12 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EventsNative = void 0;
var tslib_1 = __webpack_require__(7);
var store_1 = __webpack_require__(13);
var is_string_1 = __webpack_require__(14);
var is_function_1 = __webpack_require__(15);
var is_array_1 = __webpack_require__(16);
var type_1 = __webpack_require__(17);
var EventsNative = (function () {
    function EventsNative(doc) {
        var _this = this;
        this.__key = '__JoditEventsNativeNamespaces';
        this.doc = document;
        this.prepareEvent = function (event) {
            if (event.cancelBubble) {
                return;
            }
            if (event.type.match(/^touch/) &&
                event.changedTouches &&
                event.changedTouches.length) {
                ['clientX', 'clientY', 'pageX', 'pageY'].forEach(function (key) {
                    Object.defineProperty(event, key, {
                        value: event.changedTouches[0][key],
                        configurable: true,
                        enumerable: true
                    });
                });
            }
            if (!event.originalEvent) {
                event.originalEvent = event;
            }
            if (event.type === 'paste' &&
                event.clipboardData === undefined &&
                _this.doc.defaultView.clipboardData) {
                Object.defineProperty(event, 'clipboardData', {
                    get: function () {
                        return _this.doc.defaultView.clipboardData;
                    },
                    configurable: true,
                    enumerable: true
                });
            }
        };
        this.currents = [];
        this.__stopped = [];
        this.isDestructed = false;
        if (doc) {
            this.doc = doc;
        }
        this.__key += new Date().getTime();
    }
    EventsNative.prototype.eachEvent = function (events, callback) {
        var _this = this;
        var eventParts = events.split(/[\s,]+/);
        eventParts.forEach(function (eventNameSpace) {
            var eventAndNameSpace = eventNameSpace.split('.');
            var namespace = eventAndNameSpace[1] || store_1.defaultNameSpace;
            callback.call(_this, eventAndNameSpace[0], namespace);
        });
    };
    EventsNative.prototype.getStore = function (subject) {
        if (!subject) {
            throw type_1.error('Need subject');
        }
        if (subject[this.__key] === undefined) {
            var store = new store_1.EventHandlersStore();
            Object.defineProperty(subject, this.__key, {
                enumerable: false,
                configurable: true,
                value: store
            });
        }
        return subject[this.__key];
    };
    EventsNative.prototype.clearStore = function (subject) {
        if (subject[this.__key] !== undefined) {
            delete subject[this.__key];
        }
    };
    EventsNative.prototype.triggerNativeEvent = function (element, event) {
        var evt = this.doc.createEvent('HTMLEvents');
        if (typeof event === 'string') {
            evt.initEvent(event, true, true);
        }
        else {
            evt.initEvent(event.type, event.bubbles, event.cancelable);
            [
                'screenX',
                'screenY',
                'clientX',
                'clientY',
                'target',
                'srcElement',
                'currentTarget',
                'timeStamp',
                'which',
                'keyCode'
            ].forEach(function (property) {
                Object.defineProperty(evt, property, {
                    value: event[property],
                    enumerable: true
                });
            });
            Object.defineProperty(evt, 'originalEvent', {
                value: event,
                enumerable: true
            });
        }
        element.dispatchEvent(evt);
    };
    Object.defineProperty(EventsNative.prototype, "current", {
        get: function () {
            return this.currents[this.currents.length - 1];
        },
        enumerable: false,
        configurable: true
    });
    EventsNative.prototype.on = function (subjectOrEvents, eventsOrCallback, handlerOrSelector, onTop) {
        var _this = this;
        if (onTop === void 0) { onTop = false; }
        var subject = is_string_1.isString(subjectOrEvents) ? this : subjectOrEvents;
        var events = is_string_1.isString(eventsOrCallback)
            ? eventsOrCallback
            : subjectOrEvents;
        var callback = handlerOrSelector;
        if (callback === undefined && is_function_1.isFunction(eventsOrCallback)) {
            callback = eventsOrCallback;
        }
        var store = this.getStore(subject);
        if (!is_string_1.isString(events) || events === '') {
            throw type_1.error('Need events names');
        }
        if (!is_function_1.isFunction(callback)) {
            throw type_1.error('Need event handler');
        }
        if (is_array_1.isArray(subject)) {
            subject.forEach(function (subj) {
                _this.on(subj, events, callback, onTop);
            });
            return this;
        }
        var isDOMElement = is_function_1.isFunction(subject.addEventListener), self = this;
        var syntheticCallback = function (event) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            return callback && callback.call.apply(callback, tslib_1.__spreadArray([this, event], args));
        };
        if (isDOMElement) {
            syntheticCallback = function (event) {
                self.prepareEvent(event);
                if (callback && callback.call(this, event) === false) {
                    event.preventDefault();
                    event.stopImmediatePropagation();
                    return false;
                }
                return;
            };
        }
        this.eachEvent(events, function (event, namespace) {
            if (event === '') {
                throw type_1.error('Need event name');
            }
            if (store.indexOf(event, namespace, callback) === false) {
                var block = {
                    event: event,
                    originalCallback: callback,
                    syntheticCallback: syntheticCallback
                };
                store.set(event, namespace, block, onTop);
                if (isDOMElement) {
                    var options = [
                        'touchstart',
                        'touchend',
                        'scroll',
                        'mousewheel',
                        'mousemove',
                        'touchmove'
                    ].includes(event)
                        ? {
                            passive: true
                        }
                        : false;
                    subject.addEventListener(event, syntheticCallback, options);
                }
            }
        });
        return this;
    };
    EventsNative.prototype.one = function (subjectOrEvents, eventsOrCallback, handlerOrSelector, onTop) {
        var _this = this;
        if (onTop === void 0) { onTop = false; }
        var subject = is_string_1.isString(subjectOrEvents) ? this : subjectOrEvents;
        var events = is_string_1.isString(eventsOrCallback)
            ? eventsOrCallback
            : subjectOrEvents;
        var callback = handlerOrSelector;
        if (callback === undefined && is_function_1.isFunction(eventsOrCallback)) {
            callback = eventsOrCallback;
        }
        var newCallback = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            _this.off(subject, events, newCallback);
            callback.apply(void 0, args);
        };
        this.on(subject, events, newCallback, onTop);
        return this;
    };
    EventsNative.prototype.off = function (subjectOrEvents, eventsOrCallback, handler) {
        var _this = this;
        var subject = is_string_1.isString(subjectOrEvents)
            ? this
            : subjectOrEvents;
        var events = is_string_1.isString(eventsOrCallback)
            ? eventsOrCallback
            : subjectOrEvents;
        var store = this.getStore(subject);
        var callback = handler;
        if (!is_string_1.isString(events) || !events) {
            store.namespaces().forEach(function (namespace) {
                _this.off(subject, '.' + namespace);
            });
            this.clearStore(subject);
            return this;
        }
        if (callback === undefined && is_function_1.isFunction(eventsOrCallback)) {
            callback = eventsOrCallback;
        }
        var isDOMElement = is_function_1.isFunction(subject.removeEventListener), removeEventListener = function (block) {
            if (isDOMElement) {
                subject.removeEventListener(block.event, block.syntheticCallback, false);
            }
        }, removeCallbackFromNameSpace = function (event, namespace) {
            if (event !== '') {
                var blocks = store.get(event, namespace);
                if (blocks && blocks.length) {
                    if (!is_function_1.isFunction(callback)) {
                        blocks.forEach(removeEventListener);
                        blocks.length = 0;
                    }
                    else {
                        var index = store.indexOf(event, namespace, callback);
                        if (index !== false) {
                            removeEventListener(blocks[index]);
                            blocks.splice(index, 1);
                        }
                    }
                }
            }
            else {
                store.events(namespace).forEach(function (eventName) {
                    if (eventName !== '') {
                        removeCallbackFromNameSpace(eventName, namespace);
                    }
                });
            }
        };
        this.eachEvent(events, function (event, namespace) {
            if (namespace === store_1.defaultNameSpace) {
                store.namespaces().forEach(function (name) {
                    removeCallbackFromNameSpace(event, name);
                });
            }
            else {
                removeCallbackFromNameSpace(event, namespace);
            }
        });
        return this;
    };
    EventsNative.prototype.stopPropagation = function (subjectOrEvents, eventsList) {
        var _this = this;
        var subject = is_string_1.isString(subjectOrEvents)
            ? this
            : subjectOrEvents;
        var events = is_string_1.isString(subjectOrEvents)
            ? subjectOrEvents
            : eventsList;
        if (typeof events !== 'string') {
            throw type_1.error('Need event names');
        }
        var store = this.getStore(subject);
        this.eachEvent(events, function (event, namespace) {
            var blocks = store.get(event, namespace);
            if (blocks) {
                _this.__stopped.push(blocks);
            }
            if (namespace === store_1.defaultNameSpace) {
                store
                    .namespaces(true)
                    .forEach(function (ns) {
                    return _this.stopPropagation(subject, event + '.' + ns);
                });
            }
        });
    };
    EventsNative.prototype.removeStop = function (currentBlocks) {
        if (currentBlocks) {
            var index = this.__stopped.indexOf(currentBlocks);
            index !== -1 && this.__stopped.splice(0, index + 1);
        }
    };
    EventsNative.prototype.isStopped = function (currentBlocks) {
        return (currentBlocks !== undefined &&
            this.__stopped.indexOf(currentBlocks) !== -1);
    };
    EventsNative.prototype.fire = function (subjectOrEvents, eventsList) {
        var _this = this;
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        var result, result_value;
        var subject = is_string_1.isString(subjectOrEvents)
            ? this
            : subjectOrEvents;
        var events = is_string_1.isString(subjectOrEvents)
            ? subjectOrEvents
            : eventsList;
        var argumentsList = is_string_1.isString(subjectOrEvents)
            ? tslib_1.__spreadArray([eventsList], args) : args;
        var isDOMElement = is_function_1.isFunction(subject.dispatchEvent);
        if (!isDOMElement && !is_string_1.isString(events)) {
            throw type_1.error('Need events names');
        }
        var store = this.getStore(subject);
        if (!is_string_1.isString(events) && isDOMElement) {
            this.triggerNativeEvent(subject, eventsList);
        }
        else {
            this.eachEvent(events, function (event, namespace) {
                if (isDOMElement) {
                    _this.triggerNativeEvent(subject, event);
                }
                else {
                    var blocks_1 = store.get(event, namespace);
                    if (blocks_1) {
                        try {
                            tslib_1.__spreadArray([], blocks_1).every(function (block) {
                                if (_this.isStopped(blocks_1)) {
                                    return false;
                                }
                                _this.currents.push(event);
                                result_value =
                                    block.syntheticCallback.apply(subject, argumentsList);
                                _this.currents.pop();
                                if (result_value !== undefined) {
                                    result = result_value;
                                }
                                return true;
                            });
                        }
                        finally {
                            _this.removeStop(blocks_1);
                        }
                    }
                    if (namespace === store_1.defaultNameSpace && !isDOMElement) {
                        store
                            .namespaces()
                            .filter(function (ns) { return ns !== namespace; })
                            .forEach(function (ns) {
                            var result_second = _this.fire.apply(_this, tslib_1.__spreadArray([
                                subject,
                                event + '.' + ns
                            ], argumentsList));
                            if (result_second !== undefined) {
                                result = result_second;
                            }
                        });
                    }
                }
            });
        }
        return result;
    };
    EventsNative.prototype.destruct = function () {
        if (!this.isDestructed) {
            return;
        }
        this.isDestructed = true;
        this.off(this);
        this.getStore(this).clear();
        delete this[this.__key];
    };
    return EventsNative;
}());
exports.EventsNative = EventsNative;


/***/ }),
/* 13 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EventHandlersStore = exports.defaultNameSpace = void 0;
exports.defaultNameSpace = 'JoditEventDefaultNamespace';
var EventHandlersStore = (function () {
    function EventHandlersStore() {
        this.__store = {};
    }
    EventHandlersStore.prototype.get = function (event, namespace) {
        if (this.__store[namespace] !== undefined) {
            return this.__store[namespace][event];
        }
    };
    EventHandlersStore.prototype.indexOf = function (event, namespace, originalCallback) {
        var blocks = this.get(event, namespace);
        if (blocks) {
            for (var i = 0; i < blocks.length; i += 1) {
                if (blocks[i].originalCallback === originalCallback) {
                    return i;
                }
            }
        }
        return false;
    };
    EventHandlersStore.prototype.namespaces = function (withoutDefault) {
        if (withoutDefault === void 0) { withoutDefault = false; }
        var nss = Object.keys(this.__store);
        return withoutDefault ? nss.filter(function (ns) { return ns !== exports.defaultNameSpace; }) : nss;
    };
    EventHandlersStore.prototype.events = function (namespace) {
        return this.__store[namespace]
            ? Object.keys(this.__store[namespace])
            : [];
    };
    EventHandlersStore.prototype.set = function (event, namespace, data, onTop) {
        if (onTop === void 0) { onTop = false; }
        if (this.__store[namespace] === undefined) {
            this.__store[namespace] = {};
        }
        if (this.__store[namespace][event] === undefined) {
            this.__store[namespace][event] = [];
        }
        if (!onTop) {
            this.__store[namespace][event].push(data);
        }
        else {
            this.__store[namespace][event].unshift(data);
        }
    };
    EventHandlersStore.prototype.clear = function () {
        this.__store = {};
    };
    return EventHandlersStore;
}());
exports.EventHandlersStore = EventHandlersStore;


/***/ }),
/* 14 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isString = void 0;
function isString(value) {
    return typeof value === 'string';
}
exports.isString = isString;


/***/ }),
/* 15 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isFunction = void 0;
function isFunction(value) {
    return typeof value === 'function';
}
exports.isFunction = isFunction;


/***/ }),
/* 16 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isArray = void 0;
function isArray(elm) {
    return Array.isArray(elm);
}
exports.isArray = isArray;


/***/ }),
/* 17 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.error = void 0;
function error(message) {
    return new TypeError(message);
}
exports.error = error;


/***/ }),
/* 18 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ObserveObject = void 0;
var tslib_1 = __webpack_require__(7);
var helpers_1 = __webpack_require__(19);
var decorators_1 = __webpack_require__(99);
var ObserveObject = (function () {
    function ObserveObject(data, prefix, onEvents) {
        var _this = this;
        if (prefix === void 0) { prefix = []; }
        if (onEvents === void 0) { onEvents = {}; }
        this.__lockEvent = {};
        this.__data = data;
        this.__prefix = prefix;
        this.__onEvents = onEvents;
        Object.keys(data).forEach(function (key) {
            var prefix = _this.__prefix.concat(key).filter(function (a) { return a.length; });
            Object.defineProperty(_this, key, {
                set: function (value) {
                    var _a;
                    var oldValue = data[key];
                    if (!helpers_1.isFastEqual(oldValue, value)) {
                        _this.fire([
                            'beforeChange',
                            "beforeChange." + prefix.join('.')
                        ], key, value);
                        if (helpers_1.isPlainObject(value)) {
                            value = new ObserveObject(value, prefix, _this.__onEvents);
                        }
                        data[key] = value;
                        var sum_1 = [];
                        _this.fire(tslib_1.__spreadArray([
                            'change'
                        ], prefix.reduce(function (rs, p) {
                            sum_1.push(p);
                            rs.push("change." + sum_1.join('.'));
                            return rs;
                        }, [])), prefix.join('.'), oldValue, ((_a = value) === null || _a === void 0 ? void 0 : _a.valueOf)
                            ? value.valueOf()
                            : value);
                    }
                },
                get: function () {
                    return data[key];
                },
                enumerable: true,
                configurable: true
            });
            if (helpers_1.isPlainObject(data[key])) {
                data[key] = new ObserveObject(data[key], prefix, _this.__onEvents);
            }
        });
    }
    ObserveObject.prototype.valueOf = function () {
        return this.__data;
    };
    ObserveObject.prototype.toString = function () {
        return JSON.stringify(this.valueOf());
    };
    ObserveObject.prototype.on = function (event, callback) {
        var _this = this;
        if (helpers_1.isArray(event)) {
            event.map(function (e) { return _this.on(e, callback); });
            return this;
        }
        if (!this.__onEvents[event]) {
            this.__onEvents[event] = [];
        }
        this.__onEvents[event].push(callback);
        return this;
    };
    ObserveObject.prototype.fire = function (event) {
        var _this = this;
        var attr = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            attr[_i - 1] = arguments[_i];
        }
        if (helpers_1.isArray(event)) {
            event.map(function (e) { return _this.fire.apply(_this, tslib_1.__spreadArray([e], attr)); });
            return;
        }
        try {
            if (!this.__lockEvent[event] && this.__onEvents[event]) {
                this.__lockEvent[event] = true;
                this.__onEvents[event].forEach(function (clb) { return clb.call.apply(clb, tslib_1.__spreadArray([_this], attr)); });
            }
        }
        finally {
            this.__lockEvent[event] = false;
        }
    };
    ObserveObject.create = function (data, prefix) {
        if (prefix === void 0) { prefix = []; }
        if (data instanceof ObserveObject) {
            return data;
        }
        return new ObserveObject(data, prefix);
    };
    tslib_1.__decorate([
        decorators_1.nonenumerable
    ], ObserveObject.prototype, "__data", void 0);
    tslib_1.__decorate([
        decorators_1.nonenumerable
    ], ObserveObject.prototype, "__prefix", void 0);
    tslib_1.__decorate([
        decorators_1.nonenumerable
    ], ObserveObject.prototype, "__onEvents", void 0);
    tslib_1.__decorate([
        decorators_1.nonenumerable
    ], ObserveObject.prototype, "__lockEvent", void 0);
    return ObserveObject;
}());
exports.ObserveObject = ObserveObject;


/***/ }),
/* 19 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(20), exports);
tslib_1.__exportStar(__webpack_require__(55), exports);
tslib_1.__exportStar(__webpack_require__(59), exports);
tslib_1.__exportStar(__webpack_require__(61), exports);
tslib_1.__exportStar(__webpack_require__(34), exports);
tslib_1.__exportStar(__webpack_require__(62), exports);
tslib_1.__exportStar(__webpack_require__(64), exports);
tslib_1.__exportStar(__webpack_require__(65), exports);
tslib_1.__exportStar(__webpack_require__(82), exports);
tslib_1.__exportStar(__webpack_require__(143), exports);
tslib_1.__exportStar(__webpack_require__(68), exports);
tslib_1.__exportStar(__webpack_require__(148), exports);
tslib_1.__exportStar(__webpack_require__(150), exports);
tslib_1.__exportStar(__webpack_require__(151), exports);
tslib_1.__exportStar(__webpack_require__(81), exports);
tslib_1.__exportStar(__webpack_require__(153), exports);
tslib_1.__exportStar(__webpack_require__(26), exports);
tslib_1.__exportStar(__webpack_require__(74), exports);
tslib_1.__exportStar(__webpack_require__(154), exports);
tslib_1.__exportStar(__webpack_require__(149), exports);
tslib_1.__exportStar(__webpack_require__(155), exports);
tslib_1.__exportStar(__webpack_require__(152), exports);
tslib_1.__exportStar(__webpack_require__(156), exports);
tslib_1.__exportStar(__webpack_require__(157), exports);
tslib_1.__exportStar(__webpack_require__(67), exports);
tslib_1.__exportStar(__webpack_require__(17), exports);
tslib_1.__exportStar(__webpack_require__(158), exports);


/***/ }),
/* 20 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(21), exports);
tslib_1.__exportStar(__webpack_require__(22), exports);
tslib_1.__exportStar(__webpack_require__(24), exports);
tslib_1.__exportStar(__webpack_require__(52), exports);
tslib_1.__exportStar(__webpack_require__(53), exports);
tslib_1.__exportStar(__webpack_require__(54), exports);


/***/ }),
/* 21 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.markDeprecated = exports.cns = void 0;
var tslib_1 = __webpack_require__(7);
exports.cns = console;
function markDeprecated(method, names, ctx) {
    if (names === void 0) { names = ['']; }
    if (ctx === void 0) { ctx = null; }
    return function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        exports.cns.warn("Method \"" + names[0] + "\" deprecated." +
            (names[1] ? " Use \"" + names[1] + "\" instead" : ''));
        return method.call.apply(method, tslib_1.__spreadArray([ctx], args));
    };
}
exports.markDeprecated = markDeprecated;


/***/ }),
/* 22 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.memorizeExec = exports.keys = exports.loadImage = exports.reset = exports.callPromise = exports.markOwner = exports.attr = exports.call = void 0;
var is_function_1 = __webpack_require__(15);
var is_promise_1 = __webpack_require__(23);
var get_1 = __webpack_require__(24);
var data_bind_1 = __webpack_require__(26);
var checker_1 = __webpack_require__(34);
function call(func) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    return func.apply(void 0, args);
}
exports.call = call;
function attr(elm, key, value) {
    if (!elm || !is_function_1.isFunction(elm.getAttribute)) {
        return null;
    }
    if (/^-/.test(key)) {
        var res = attr(elm, "data" + key);
        if (res) {
            return res;
        }
        key = key.substr(1);
    }
    if (value !== undefined) {
        if (value == null) {
            elm.hasAttribute(key) && elm.removeAttribute(key);
        }
        else {
            elm.setAttribute(key, value.toString());
            return value.toString();
        }
    }
    return elm.getAttribute(key);
}
exports.attr = attr;
function markOwner(jodit, elm) {
    attr(elm, 'data-editor_id', jodit.id);
    !elm.component &&
        Object.defineProperty(elm, 'jodit', {
            value: jodit
        });
}
exports.markOwner = markOwner;
function callPromise(condition, callback) {
    if (is_promise_1.isPromise(condition)) {
        return condition.finally(callback);
    }
    else {
        return callback();
    }
}
exports.callPromise = callPromise;
var map = {};
var reset = function (key) {
    var _a, _b;
    if (!(key in map)) {
        var iframe = document.createElement('iframe');
        try {
            iframe.src = 'about:blank';
            document.body.appendChild(iframe);
            if (!iframe.contentWindow) {
                return null;
            }
            var func = get_1.get(key, iframe.contentWindow), bind = get_1.get(key.split('.').slice(0, -1).join('.'), iframe.contentWindow);
            if (is_function_1.isFunction(func)) {
                map[key] = func.bind(bind);
            }
        }
        catch (e) {
            if (false) {}
        }
        finally {
            (_a = iframe.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(iframe);
        }
    }
    return (_b = map[key]) !== null && _b !== void 0 ? _b : null;
};
exports.reset = reset;
var loadImage = function (src, jodit) {
    return jodit.async.promise(function (res, rej) {
        var image = new Image(), onError = function () {
            jodit.e.off(image);
            rej === null || rej === void 0 ? void 0 : rej();
        }, onSuccess = function () {
            jodit.e.off(image);
            res(image);
        };
        jodit.e
            .one(image, 'load', onSuccess)
            .one(image, 'error', onError)
            .one(image, 'abort', onError);
        image.src = src;
        if (image.complete) {
            onSuccess();
        }
    });
};
exports.loadImage = loadImage;
var keys = function (obj, own) {
    if (own === void 0) { own = true; }
    if (own) {
        return Object.keys(obj);
    }
    var props = [];
    for (var key in obj) {
        props.push(key);
    }
    return props;
};
exports.keys = keys;
var memorizeExec = function (editor, _, _a, preProcessValue) {
    var control = _a.control;
    var key = "button" + control.command;
    var value = (control.args && control.args[0]) || data_bind_1.dataBind(editor, key);
    if (checker_1.isVoid(value)) {
        return false;
    }
    data_bind_1.dataBind(editor, key, value);
    if (preProcessValue) {
        value = preProcessValue(value);
    }
    editor.execCommand(control.command, false, value || undefined);
};
exports.memorizeExec = memorizeExec;


/***/ }),
/* 23 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isPromise = void 0;
function isPromise(val) {
    return val && typeof val.then === 'function';
}
exports.isPromise = isPromise;


/***/ }),
/* 24 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.get = void 0;
var is_string_1 = __webpack_require__(14);
var is_void_1 = __webpack_require__(25);
function get(chain, obj) {
    if (!is_string_1.isString(chain) || !chain.length) {
        return null;
    }
    var parts = chain.split('.');
    var result = obj;
    for (var _i = 0, parts_1 = parts; _i < parts_1.length; _i++) {
        var part = parts_1[_i];
        if (is_void_1.isVoid(result[part])) {
            return null;
        }
        result = result[part];
    }
    if (is_void_1.isVoid(result)) {
        return null;
    }
    return result;
}
exports.get = get;


/***/ }),
/* 25 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isVoid = void 0;
function isVoid(value) {
    return value === undefined || value === null;
}
exports.isVoid = isVoid;


/***/ }),
/* 26 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.dataBind = void 0;
var component_1 = __webpack_require__(27);
var checker_1 = __webpack_require__(34);
var store = new WeakMap();
var dataBind = function (elm, key, value) {
    var itemStore = store.get(elm);
    if (!itemStore) {
        itemStore = {};
        store.set(elm, itemStore);
        var e = null;
        if (elm instanceof component_1.ViewComponent) {
            e = elm.j.e;
        }
        if (checker_1.isViewObject(elm)) {
            e = elm.e;
        }
        e &&
            e.on('beforeDestruct', function () {
                store.delete(elm);
            });
    }
    if (value === undefined) {
        return itemStore[key];
    }
    itemStore[key] = value;
    return value;
};
exports.dataBind = dataBind;


/***/ }),
/* 27 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(28), exports);
tslib_1.__exportStar(__webpack_require__(29), exports);
tslib_1.__exportStar(__webpack_require__(33), exports);


/***/ }),
/* 28 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.STATUSES = void 0;
var STATUSES;
(function (STATUSES) {
    STATUSES["beforeInit"] = "beforeInit";
    STATUSES["ready"] = "ready";
    STATUSES["beforeDestruct"] = "beforeDestruct";
    STATUSES["destructed"] = "destructed";
})(STATUSES = exports.STATUSES || (exports.STATUSES = {}));


/***/ }),
/* 29 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Component = void 0;
var helpers_1 = __webpack_require__(19);
var global_1 = __webpack_require__(30);
var statuses_1 = __webpack_require__(28);
var StatusListHandlers = new Map();
var Component = (function () {
    function Component() {
        this.ownerWindow = window;
        this.__componentStatus = statuses_1.STATUSES.beforeInit;
        this.componentName =
            'jodit-' + helpers_1.kebabCase(this.className() || helpers_1.getClassName(this));
        this.uid = 'jodit-uid-' + global_1.uniqueUid();
    }
    Component.prototype.getFullElName = function (elementName, mod, modValue) {
        var result = [this.componentName];
        if (elementName) {
            elementName = elementName.replace(/[^a-z0-9-]/gi, '-');
            result.push("__" + elementName);
        }
        if (mod) {
            result.push('_', mod);
            result.push('_', helpers_1.isVoid(modValue) ? 'true' : modValue.toString());
        }
        return result.join('');
    };
    Object.defineProperty(Component.prototype, "ownerDocument", {
        get: function () {
            return this.ow.document;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Component.prototype, "od", {
        get: function () {
            return this.ownerDocument;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Component.prototype, "ow", {
        get: function () {
            return this.ownerWindow;
        },
        enumerable: false,
        configurable: true
    });
    Component.prototype.get = function (chain, obj) {
        return helpers_1.get(chain, obj || this);
    };
    Object.defineProperty(Component.prototype, "isReady", {
        get: function () {
            return this.componentStatus === statuses_1.STATUSES.ready;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Component.prototype, "isDestructed", {
        get: function () {
            return this.componentStatus === statuses_1.STATUSES.destructed;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Component.prototype, "isInDestruct", {
        get: function () {
            return (statuses_1.STATUSES.beforeDestruct === this.componentStatus ||
                statuses_1.STATUSES.destructed === this.componentStatus);
        },
        enumerable: false,
        configurable: true
    });
    Component.prototype.bindDestruct = function (jodit) {
        var _this = this;
        var destructMe = function () {
            !_this.isInDestruct && _this.destruct();
        };
        jodit.e && jodit.e.on(statuses_1.STATUSES.beforeDestruct, destructMe);
        this.hookStatus(statuses_1.STATUSES.beforeDestruct, function () {
            jodit.e && jodit.e.off(statuses_1.STATUSES.beforeDestruct, destructMe);
        });
        return this;
    };
    Component.prototype.destruct = function () {
        this.setStatus(statuses_1.STATUSES.destructed);
        if (StatusListHandlers.get(this)) {
            StatusListHandlers.delete(this);
        }
    };
    Object.defineProperty(Component.prototype, "componentStatus", {
        get: function () {
            return this.__componentStatus;
        },
        set: function (componentStatus) {
            this.setStatus(componentStatus);
        },
        enumerable: false,
        configurable: true
    });
    Component.prototype.setStatus = function (componentStatus) {
        return this.setStatusComponent(componentStatus, this);
    };
    Component.prototype.setStatusComponent = function (componentStatus, component) {
        if (componentStatus === this.__componentStatus) {
            return;
        }
        var proto = Object.getPrototypeOf(this);
        if (proto && helpers_1.isFunction(proto.setStatusComponent)) {
            proto.setStatusComponent(componentStatus, component);
        }
        var statuses = StatusListHandlers.get(this), list = statuses === null || statuses === void 0 ? void 0 : statuses[componentStatus];
        if (list && list.length) {
            list.forEach(function (cb) { return cb(component); });
        }
        if (component === this) {
            this.__componentStatus = componentStatus;
        }
    };
    Component.prototype.hookStatus = function (status, callback) {
        var list = StatusListHandlers.get(this);
        if (!list) {
            list = {};
            StatusListHandlers.set(this, list);
        }
        if (!list[status]) {
            list[status] = [];
        }
        list[status].push(callback);
    };
    Component.STATUSES = statuses_1.STATUSES;
    return Component;
}());
exports.Component = Component;


/***/ }),
/* 30 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.eventEmitter = exports.getContainer = exports.extendLang = exports.lang = exports.modules = exports.pluginSystem = exports.uniqueUid = exports.instances = void 0;
var plugin_system_1 = __webpack_require__(31);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var events_1 = __webpack_require__(11);
exports.instances = {};
var counter = 1;
function uniqueUid() {
    counter += 10 * (Math.random() + 1);
    return Math.round(counter).toString(16);
}
exports.uniqueUid = uniqueUid;
exports.pluginSystem = new plugin_system_1.PluginSystem();
exports.modules = {};
exports.lang = {};
var extendLang = function (langs) {
    Object.keys(langs).forEach(function (key) {
        if (exports.lang[key]) {
            Object.assign(exports.lang[key], langs[key]);
        }
        else {
            exports.lang[key] = langs[key];
        }
    });
};
exports.extendLang = extendLang;
var boxes = new WeakMap();
function getContainer(jodit, classFunc, tag, createInsideEditor) {
    if (tag === void 0) { tag = 'div'; }
    if (createInsideEditor === void 0) { createInsideEditor = false; }
    var name = helpers_1.getClassName(classFunc.prototype);
    var data = boxes.get(jodit) || {}, key = name + tag;
    var view = helpers_1.isViewObject(jodit) ? jodit : jodit.j;
    if (!data[key]) {
        var c = view.c, body = jodit.od.body;
        if (createInsideEditor &&
            helpers_1.isJoditObject(jodit) &&
            jodit.od !== jodit.ed) {
            c = jodit.createInside;
            body = tag === 'style' ? jodit.ed.head : jodit.ed.body;
        }
        var box_1 = c.element(tag, {
            className: "jodit jodit-" + helpers_1.kebabCase(name) + "-container jodit-box"
        });
        box_1.classList.add("jodit_theme_" + (view.o.theme || 'default'));
        body.appendChild(box_1);
        data[key] = box_1;
        jodit.hookStatus('beforeDestruct', function () {
            dom_1.Dom.safeRemove(box_1);
            delete data[key];
            if (Object.keys(data).length) {
                boxes.delete(jodit);
            }
        });
        boxes.set(jodit, data);
    }
    data[key].classList.remove('jodit_theme_default', 'jodit_theme_dark');
    data[key].classList.add("jodit_theme_" + (view.o.theme || 'default'));
    return data[key];
}
exports.getContainer = getContainer;
exports.eventEmitter = new events_1.EventsNative();


/***/ }),
/* 31 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PluginSystem = void 0;
var tslib_1 = __webpack_require__(7);
var helpers_1 = __webpack_require__(19);
var PluginSystem = (function () {
    function PluginSystem() {
        this.items = new Map();
    }
    PluginSystem.prototype.normalizeName = function (name) {
        return helpers_1.kebabCase(name).toLowerCase();
    };
    PluginSystem.prototype.add = function (name, plugin) {
        this.items.set(this.normalizeName(name), plugin);
    };
    PluginSystem.prototype.get = function (name) {
        return this.items.get(this.normalizeName(name));
    };
    PluginSystem.prototype.remove = function (name) {
        this.items.delete(this.normalizeName(name));
    };
    PluginSystem.prototype.init = function (jodit) {
        var _this = this;
        var extrasList = jodit.o.extraPlugins.map(function (s) {
            return helpers_1.isString(s) ? { name: s } : s;
        }), disableList = helpers_1.splitArray(jodit.o.disablePlugins).map(function (s) {
            return _this.normalizeName(s);
        }), doneList = [], promiseList = {}, plugins = [], pluginsMap = {}, makeAndInit = function (plugin, name) {
            var _a;
            if (disableList.includes(name) ||
                doneList.includes(name) ||
                promiseList[name]) {
                return;
            }
            var requires = (_a = plugin) === null || _a === void 0 ? void 0 : _a.requires;
            if (requires &&
                helpers_1.isArray(requires) &&
                _this.hasDisabledRequires(disableList, requires)) {
                return;
            }
            var instance = PluginSystem.makePluginInstance(jodit, plugin);
            _this.initOrWait(jodit, name, instance, doneList, promiseList);
            plugins.push(instance);
            pluginsMap[name] = instance;
        };
        var resultLoadExtras = this.loadExtras(jodit, extrasList);
        return helpers_1.callPromise(resultLoadExtras, function () {
            if (jodit.isInDestruct) {
                return;
            }
            _this.items.forEach(makeAndInit);
            _this.addListenerOnBeforeDestruct(jodit, plugins);
            jodit.__plugins = pluginsMap;
        });
    };
    PluginSystem.prototype.hasDisabledRequires = function (disableList, requires) {
        return Boolean((requires === null || requires === void 0 ? void 0 : requires.length) &&
            disableList.some(function (disabled) { return requires.includes(disabled); }));
    };
    PluginSystem.makePluginInstance = function (jodit, plugin) {
        return helpers_1.isFunction(plugin) ? new plugin(jodit) : plugin;
    };
    PluginSystem.prototype.initOrWait = function (jodit, pluginName, instance, doneList, promiseList) {
        var initPlugin = function (name, plugin) {
            if (helpers_1.isInitable(plugin)) {
                var req = plugin.requires;
                if (!(req === null || req === void 0 ? void 0 : req.length) ||
                    req.every(function (name) { return doneList.includes(name); })) {
                    plugin.init(jodit);
                    doneList.push(name);
                }
                else {
                    promiseList[name] = plugin;
                    return false;
                }
            }
            else {
                doneList.push(name);
            }
            if (plugin.hasStyle) {
                PluginSystem.loadStyle(jodit, name);
            }
            return true;
        };
        initPlugin(pluginName, instance);
        Object.keys(promiseList).forEach(function (name) {
            var plugin = promiseList[name];
            if (!plugin) {
                return;
            }
            if (initPlugin(name, plugin)) {
                promiseList[name] = undefined;
                delete promiseList[name];
            }
        });
    };
    PluginSystem.prototype.addListenerOnBeforeDestruct = function (jodit, plugins) {
        jodit.e.on('beforeDestruct', function () {
            plugins.forEach(function (instance) {
                if (helpers_1.isDestructable(instance)) {
                    instance.destruct(jodit);
                }
            });
            plugins.length = 0;
            delete jodit.__plugins;
        });
    };
    PluginSystem.prototype.load = function (jodit, pluginList) {
        var reflect = function (p) {
            return p.then(function (v) { return ({ v: v, status: 'fulfilled' }); }, function (e) { return ({ e: e, status: 'rejected' }); });
        };
        return Promise.all(pluginList.map(function (extra) {
            var url = extra.url ||
                PluginSystem.getFullUrl(jodit, extra.name, true);
            return reflect(helpers_1.appendScriptAsync(jodit, url));
        }));
    };
    PluginSystem.loadStyle = function (jodit, pluginName) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var url;
            return tslib_1.__generator(this, function (_a) {
                url = PluginSystem.getFullUrl(jodit, pluginName, false);
                if (this.styles.has(url)) {
                    return [2];
                }
                this.styles.add(url);
                return [2, helpers_1.appendStyleAsync(jodit, url)];
            });
        });
    };
    PluginSystem.getFullUrl = function (jodit, name, js) {
        name = helpers_1.kebabCase(name);
        return (jodit.basePath +
            'plugins/' +
            name +
            '/' +
            name +
            '.' +
            (js ? 'js' : 'css'));
    };
    PluginSystem.prototype.loadExtras = function (jodit, extrasList) {
        var _this = this;
        if (extrasList && extrasList.length) {
            try {
                var needLoadExtras = extrasList.filter(function (extra) { return !_this.items.has(_this.normalizeName(extra.name)); });
                if (needLoadExtras.length) {
                    return this.load(jodit, needLoadExtras);
                }
            }
            catch (e) {
                if (false) {}
            }
        }
    };
    PluginSystem.styles = new Set();
    return PluginSystem;
}());
exports.PluginSystem = PluginSystem;


/***/ }),
/* 32 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Dom = void 0;
var consts = __webpack_require__(9);
var helpers_1 = __webpack_require__(19);
var Dom = (function () {
    function Dom() {
    }
    Dom.detach = function (node) {
        while (node.firstChild) {
            node.removeChild(node.firstChild);
        }
    };
    Dom.wrapInline = function (current, tag, editor) {
        var tmp, first = current, last = current;
        editor.s.save();
        var needFindNext = false;
        do {
            needFindNext = false;
            tmp = first.previousSibling;
            if (tmp && !Dom.isBlock(tmp, editor.ew)) {
                needFindNext = true;
                first = tmp;
            }
        } while (needFindNext);
        do {
            needFindNext = false;
            tmp = last.nextSibling;
            if (tmp && !Dom.isBlock(tmp, editor.ew)) {
                needFindNext = true;
                last = tmp;
            }
        } while (needFindNext);
        var wrapper = helpers_1.isString(tag) ? editor.createInside.element(tag) : tag;
        if (first.parentNode) {
            first.parentNode.insertBefore(wrapper, first);
        }
        var next = first;
        while (next) {
            next = first.nextSibling;
            wrapper.appendChild(first);
            if (first === last || !next) {
                break;
            }
            first = next;
        }
        editor.s.restore();
        return wrapper;
    };
    Dom.wrap = function (current, tag, create) {
        var wrapper = helpers_1.isString(tag) ? create.element(tag) : tag;
        if (!current.parentNode) {
            return null;
        }
        current.parentNode.insertBefore(wrapper, current);
        wrapper.appendChild(current);
        return wrapper;
    };
    Dom.unwrap = function (node) {
        var parent = node.parentNode;
        if (parent) {
            while (node.firstChild) {
                parent.insertBefore(node.firstChild, node);
            }
            Dom.safeRemove(node);
        }
    };
    Dom.each = function (elm, callback) {
        var node = elm.firstChild;
        if (node) {
            while (node) {
                var next = Dom.next(node, Boolean, elm);
                if (callback(node) === false) {
                    return false;
                }
                if (node.parentNode && !Dom.each(node, callback)) {
                    return false;
                }
                node = next;
            }
        }
        return true;
    };
    Dom.between = function (start, end, callback) {
        var next = start;
        while (next && next !== end) {
            if (start !== next && callback(next)) {
                break;
            }
            var step = next.firstChild || next.nextSibling;
            if (!step) {
                while (next && !next.nextSibling) {
                    next = next.parentNode;
                }
                step = next === null || next === void 0 ? void 0 : next.nextSibling;
            }
            next = step;
        }
    };
    Dom.replace = function (elm, newTagName, create, withAttributes, notMoveContent) {
        if (withAttributes === void 0) { withAttributes = false; }
        if (notMoveContent === void 0) { notMoveContent = false; }
        var tag = helpers_1.isString(newTagName)
            ? create.element(newTagName)
            : newTagName;
        if (!notMoveContent) {
            while (elm.firstChild) {
                tag.appendChild(elm.firstChild);
            }
        }
        if (withAttributes) {
            helpers_1.toArray(elm.attributes).forEach(function (attr) {
                tag.setAttribute(attr.name, attr.value);
            });
        }
        if (elm.parentNode) {
            elm.parentNode.replaceChild(tag, elm);
        }
        return tag;
    };
    Dom.isEmptyTextNode = function (node) {
        return (Dom.isText(node) &&
            (!node.nodeValue ||
                node.nodeValue.replace(consts.INVISIBLE_SPACE_REG_EXP(), '')
                    .length === 0));
    };
    Dom.isEmpty = function (node, condNoEmptyElement) {
        if (condNoEmptyElement === void 0) { condNoEmptyElement = /^(img|svg|canvas|input|textarea|form)$/; }
        if (!node) {
            return true;
        }
        if (Dom.isText(node)) {
            return node.nodeValue == null || helpers_1.trim(node.nodeValue).length === 0;
        }
        return (!condNoEmptyElement.test(node.nodeName.toLowerCase()) &&
            Dom.each(node, function (elm) {
                if ((Dom.isText(elm) &&
                    elm.nodeValue != null &&
                    helpers_1.trim(elm.nodeValue).length !== 0) ||
                    (Dom.isElement(elm) &&
                        condNoEmptyElement.test(elm.nodeName.toLowerCase()))) {
                    return false;
                }
            }));
    };
    Dom.isNode = function (object, win) {
        if (!object) {
            return false;
        }
        if (typeof win === 'object' &&
            win &&
            (typeof win.Node === 'function' ||
                typeof win.Node === 'object')) {
            return object instanceof win.Node;
        }
        return false;
    };
    Dom.isCell = function (elm, win) {
        return Dom.isNode(elm, win) && /^(td|th)$/i.test(elm.nodeName);
    };
    Dom.isImage = function (elm, win) {
        return (Dom.isNode(elm, win) &&
            /^(img|svg|picture|canvas)$/i.test(elm.nodeName));
    };
    Dom.isBlock = function (node, win) {
        return (!helpers_1.isVoid(node) &&
            typeof node === 'object' &&
            Dom.isNode(node, win) &&
            consts.IS_BLOCK.test(node.nodeName));
    };
    Dom.isText = function (node) {
        return Boolean(node && node.nodeType === Node.TEXT_NODE);
    };
    Dom.isElement = function (node) {
        return Boolean(node && node.nodeType === Node.ELEMENT_NODE);
    };
    Dom.isHTMLElement = function (node, win) {
        return (Dom.isNode(node, win) && node instanceof win.HTMLElement);
    };
    Dom.isInlineBlock = function (node) {
        return (Dom.isElement(node) &&
            !/^(BR|HR)$/i.test(node.tagName) &&
            ['inline', 'inline-block'].indexOf(helpers_1.css(node, 'display').toString()) !== -1);
    };
    Dom.canSplitBlock = function (node, win) {
        return (!helpers_1.isVoid(node) &&
            node instanceof win.HTMLElement &&
            Dom.isBlock(node, win) &&
            !/^(TD|TH|CAPTION|FORM)$/.test(node.nodeName) &&
            node.style !== undefined &&
            !/^(fixed|absolute)/i.test(node.style.position));
    };
    Dom.last = function (root, condition) {
        var last = root === null || root === void 0 ? void 0 : root.lastChild;
        if (!last) {
            return null;
        }
        do {
            if (condition(last)) {
                return last;
            }
            var next = last.lastChild;
            if (!next) {
                next = last.previousSibling;
            }
            if (!next && last.parentNode !== root) {
                do {
                    last = last.parentNode;
                } while (last &&
                    !(last === null || last === void 0 ? void 0 : last.previousSibling) &&
                    last.parentNode !== root);
                next = last === null || last === void 0 ? void 0 : last.previousSibling;
            }
            last = next;
        } while (last);
        return null;
    };
    Dom.prev = function (node, condition, root, withChild) {
        if (withChild === void 0) { withChild = true; }
        return Dom.find(node, condition, root, false, 'previousSibling', withChild ? 'lastChild' : false);
    };
    Dom.next = function (node, condition, root, withChild) {
        if (withChild === void 0) { withChild = true; }
        return Dom.find(node, condition, root, undefined, undefined, withChild ? 'firstChild' : false);
    };
    Dom.prevWithClass = function (node, className) {
        return Dom.prev(node, function (node) {
            return (Dom.isElement(node) && node.classList.contains(className));
        }, node.parentNode);
    };
    Dom.nextWithClass = function (node, className) {
        return Dom.next(node, function (elm) { return Dom.isElement(elm) && elm.classList.contains(className); }, node.parentNode);
    };
    Dom.find = function (node, condition, root, recurse, sibling, child) {
        if (recurse === void 0) { recurse = false; }
        if (sibling === void 0) { sibling = 'nextSibling'; }
        if (child === void 0) { child = 'firstChild'; }
        if (recurse && condition(node)) {
            return node;
        }
        var start = node, next;
        do {
            next = start[sibling];
            if (condition(next)) {
                return next ? next : null;
            }
            if (child && next && next[child]) {
                var nextOne = Dom.find(next[child], condition, next, true, sibling, child);
                if (nextOne) {
                    return nextOne;
                }
            }
            if (!next) {
                next = start.parentNode;
            }
            start = next;
        } while (start && start !== root);
        return null;
    };
    Dom.findWithCurrent = function (node, condition, root, sibling, child) {
        if (sibling === void 0) { sibling = 'nextSibling'; }
        if (child === void 0) { child = 'firstChild'; }
        var next = node;
        do {
            if (condition(next)) {
                return next || null;
            }
            if (child && next && next[child]) {
                var nextOne = Dom.findWithCurrent(next[child], condition, next, sibling, child);
                if (nextOne) {
                    return nextOne;
                }
            }
            while (next && !next[sibling] && next !== root) {
                next = next.parentNode;
            }
            if (next && next[sibling] && next !== root) {
                next = next[sibling];
            }
        } while (next && next !== root);
        return null;
    };
    Dom.findSibling = function (node, left, cond) {
        if (left === void 0) { left = true; }
        if (cond === void 0) { cond = function (n) { return !Dom.isEmptyTextNode(n); }; }
        var getSibling = function (node) {
            return left ? node.previousSibling : node.nextSibling;
        };
        var start = getSibling(node);
        while (start && !cond(start)) {
            start = getSibling(start);
        }
        return start && cond(start) ? start : null;
    };
    Dom.up = function (node, condition, root, checkRoot) {
        if (checkRoot === void 0) { checkRoot = false; }
        var start = node;
        if (!start) {
            return null;
        }
        do {
            if (condition(start)) {
                return start;
            }
            if (start === root || !start.parentNode) {
                break;
            }
            start = start.parentNode;
        } while (start && start !== root);
        if (start === root && checkRoot && condition(start)) {
            return start;
        }
        return null;
    };
    Dom.closest = function (node, tagsOrCondition, root) {
        var condition;
        if (helpers_1.isFunction(tagsOrCondition)) {
            condition = tagsOrCondition;
        }
        else if (helpers_1.isArray(tagsOrCondition)) {
            condition = function (tag) {
                return tag &&
                    tagsOrCondition.includes(tag.nodeName.toLowerCase());
            };
        }
        else {
            condition = function (tag) {
                return tag && tagsOrCondition === tag.nodeName.toLowerCase();
            };
        }
        return Dom.up(node, condition, root);
    };
    Dom.furthest = function (node, condition, root) {
        var matchedParent = null, current = node === null || node === void 0 ? void 0 : node.parentElement;
        while (current && current !== root && condition(current)) {
            matchedParent = current;
            current = current === null || current === void 0 ? void 0 : current.parentElement;
        }
        return matchedParent;
    };
    Dom.appendChildFirst = function (root, newElement) {
        var child = root.firstChild;
        if (child) {
            if (child !== newElement) {
                root.insertBefore(newElement, child);
            }
        }
        else {
            root.appendChild(newElement);
        }
    };
    Dom.after = function (elm, newElement) {
        var parentNode = elm.parentNode;
        if (!parentNode) {
            return;
        }
        if (parentNode.lastChild === elm) {
            parentNode.appendChild(newElement);
        }
        else {
            parentNode.insertBefore(newElement, elm.nextSibling);
        }
    };
    Dom.before = function (elm, newElement) {
        var parentNode = elm.parentNode;
        if (!parentNode) {
            return;
        }
        parentNode.insertBefore(newElement, elm);
    };
    Dom.prepend = function (root, newElement) {
        root.insertBefore(newElement, root.firstChild);
    };
    Dom.append = function (root, newElement) {
        var _this = this;
        if (helpers_1.isArray(newElement)) {
            newElement.forEach(function (node) {
                _this.append(root, node);
            });
        }
        else {
            root.appendChild(newElement);
        }
    };
    Dom.moveContent = function (from, to, inStart) {
        if (inStart === void 0) { inStart = false; }
        var fragment = (from.ownerDocument || document).createDocumentFragment();
        helpers_1.toArray(from.childNodes).forEach(function (node) {
            fragment.appendChild(node);
        });
        if (!inStart || !to.firstChild) {
            to.appendChild(fragment);
        }
        else {
            to.insertBefore(fragment, to.firstChild);
        }
    };
    Dom.all = function (node, condition, prev) {
        if (prev === void 0) { prev = false; }
        var nodes = node.childNodes ? helpers_1.toArray(node.childNodes) : [];
        if (condition(node)) {
            return node;
        }
        if (prev) {
            nodes = nodes.reverse();
        }
        nodes.forEach(function (child) {
            Dom.all(child, condition, prev);
        });
        return null;
    };
    Dom.isOrContains = function (root, child, onlyContains) {
        if (onlyContains === void 0) { onlyContains = false; }
        if (root === child) {
            return !onlyContains;
        }
        return Boolean(child && root && this.up(child, function (nd) { return nd === root; }, root, true));
    };
    Dom.safeRemove = function (node) {
        node && node.parentNode && node.parentNode.removeChild(node);
    };
    Dom.hide = function (node) {
        if (!node) {
            return;
        }
        helpers_1.dataBind(node, '__old_display', node.style.display);
        node.style.display = 'none';
    };
    Dom.show = function (node) {
        if (!node) {
            return;
        }
        var display = helpers_1.dataBind(node, '__old_display');
        if (node.style.display === 'none') {
            node.style.display = display || '';
        }
    };
    Dom.isTag = function (node, tagNames) {
        var tags = helpers_1.asArray(tagNames).map(String);
        for (var i = 0; i < tags.length; i += 1) {
            if (this.isElement(node) &&
                node.tagName.toLowerCase() === tags[i].toLowerCase()) {
                return true;
            }
        }
        return false;
    };
    return Dom;
}());
exports.Dom = Dom;


/***/ }),
/* 33 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ViewComponent = void 0;
var tslib_1 = __webpack_require__(7);
var component_1 = __webpack_require__(29);
var ViewComponent = (function (_super) {
    tslib_1.__extends(ViewComponent, _super);
    function ViewComponent(jodit) {
        var _this = _super.call(this) || this;
        _this.setParentView(jodit);
        return _this;
    }
    Object.defineProperty(ViewComponent.prototype, "defaultTimeout", {
        get: function () {
            return this.j.defaultTimeout;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ViewComponent.prototype, "j", {
        get: function () {
            return this.jodit;
        },
        enumerable: false,
        configurable: true
    });
    ViewComponent.prototype.i18n = function (text) {
        var _a;
        var params = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            params[_i - 1] = arguments[_i];
        }
        return (_a = this.j).i18n.apply(_a, tslib_1.__spreadArray([text], params));
    };
    ViewComponent.prototype.setParentView = function (jodit) {
        this.jodit = jodit;
        jodit.components.add(this);
        return this;
    };
    ViewComponent.prototype.destruct = function () {
        this.j.components.delete(this);
        return _super.prototype.destruct.call(this);
    };
    return ViewComponent;
}(component_1.Component));
exports.ViewComponent = ViewComponent;


/***/ }),
/* 34 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(35), exports);
tslib_1.__exportStar(__webpack_require__(16), exports);
tslib_1.__exportStar(__webpack_require__(36), exports);
tslib_1.__exportStar(__webpack_require__(37), exports);
tslib_1.__exportStar(__webpack_require__(15), exports);
tslib_1.__exportStar(__webpack_require__(39), exports);
tslib_1.__exportStar(__webpack_require__(40), exports);
tslib_1.__exportStar(__webpack_require__(41), exports);
tslib_1.__exportStar(__webpack_require__(42), exports);
tslib_1.__exportStar(__webpack_require__(44), exports);
tslib_1.__exportStar(__webpack_require__(45), exports);
tslib_1.__exportStar(__webpack_require__(46), exports);
tslib_1.__exportStar(__webpack_require__(47), exports);
tslib_1.__exportStar(__webpack_require__(43), exports);
tslib_1.__exportStar(__webpack_require__(48), exports);
tslib_1.__exportStar(__webpack_require__(23), exports);
tslib_1.__exportStar(__webpack_require__(14), exports);
tslib_1.__exportStar(__webpack_require__(50), exports);
tslib_1.__exportStar(__webpack_require__(51), exports);
tslib_1.__exportStar(__webpack_require__(25), exports);
tslib_1.__exportStar(__webpack_require__(49), exports);


/***/ }),
/* 35 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.hasBrowserColorPicker = void 0;
function hasBrowserColorPicker() {
    var supportsColor = true;
    try {
        var a = document.createElement('input');
        a.type = 'color';
        supportsColor =
            a.type === 'color' && typeof a.selectionStart !== 'number';
    }
    catch (e) {
        supportsColor = false;
    }
    return supportsColor;
}
exports.hasBrowserColorPicker = hasBrowserColorPicker;


/***/ }),
/* 36 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isBoolean = void 0;
function isBoolean(elm) {
    return typeof elm === 'boolean';
}
exports.isBoolean = isBoolean;


/***/ }),
/* 37 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isFastEqual = exports.isEqual = void 0;
var stringify_1 = __webpack_require__(38);
function isEqual(a, b) {
    return a === b || stringify_1.stringify(a) === stringify_1.stringify(b);
}
exports.isEqual = isEqual;
function isFastEqual(a, b) {
    return a === b;
}
exports.isFastEqual = isFastEqual;


/***/ }),
/* 38 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.stringify = void 0;
function stringify(value, options) {
    if (options === void 0) { options = {}; }
    if (typeof value !== 'object') {
        return String(value);
    }
    var excludeKeys = new Set(options.excludeKeys);
    var map = new WeakMap();
    var r = function (k, v) {
        if (excludeKeys.has(k)) {
            return;
        }
        if (typeof v === 'object' && v != null) {
            if (map.get(v)) {
                return '[refObject]';
            }
            map.set(v, true);
        }
        return v;
    };
    return JSON.stringify(value, r, options.prettify);
}
exports.stringify = stringify;


/***/ }),
/* 39 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isHTML = void 0;
var is_string_1 = __webpack_require__(14);
var isHTML = function (str) {
    return is_string_1.isString(str) &&
        /<([A-Za-z][A-Za-z0-9]*)\b[^>]*>(.*?)<\/\1>/m.test(str.replace(/[\r\n]/g, ''));
};
exports.isHTML = isHTML;


/***/ }),
/* 40 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isHtmlFromWord = void 0;
function isHtmlFromWord(data) {
    return (data.search(/<meta.*?Microsoft Excel\s[\d].*?>/) !== -1 ||
        data.search(/<meta.*?Microsoft Word\s[\d].*?>/) !== -1 ||
        (data.search(/style="[^"]*mso-/) !== -1 && data.search(/<font/) !== -1));
}
exports.isHtmlFromWord = isHtmlFromWord;


/***/ }),
/* 41 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.hasContainer = exports.isDestructable = exports.isInitable = void 0;
var is_function_1 = __webpack_require__(15);
var dom_1 = __webpack_require__(32);
var is_void_1 = __webpack_require__(25);
function isInitable(value) {
    return !is_void_1.isVoid(value) && is_function_1.isFunction(value.init);
}
exports.isInitable = isInitable;
function isDestructable(value) {
    return !is_void_1.isVoid(value) && is_function_1.isFunction(value.destruct);
}
exports.isDestructable = isDestructable;
function hasContainer(value) {
    return !is_void_1.isVoid(value) && dom_1.Dom.isElement(value.container);
}
exports.hasContainer = hasContainer;


/***/ }),
/* 42 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isInt = void 0;
var is_numeric_1 = __webpack_require__(43);
var is_string_1 = __webpack_require__(14);
function isInt(value) {
    if (is_string_1.isString(value) && is_numeric_1.isNumeric(value)) {
        value = parseFloat(value);
    }
    return typeof value === 'number' && Number.isFinite(value) && !(value % 1);
}
exports.isInt = isInt;


/***/ }),
/* 43 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isNumeric = void 0;
var is_string_1 = __webpack_require__(14);
function isNumeric(value) {
    if (is_string_1.isString(value)) {
        if (!value.match(/^([+-])?[0-9]+(\.?)([0-9]+)?(e[0-9]+)?$/)) {
            return false;
        }
        value = parseFloat(value);
    }
    return typeof value === 'number' && !isNaN(value) && isFinite(value);
}
exports.isNumeric = isNumeric;


/***/ }),
/* 44 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isViewObject = exports.isJoditObject = void 0;
var is_function_1 = __webpack_require__(15);
var global_1 = __webpack_require__(30);
function isJoditObject(jodit) {
    return Boolean(jodit &&
        jodit instanceof Object &&
        is_function_1.isFunction(jodit.constructor) &&
        ((typeof Jodit !== 'undefined' && jodit instanceof Jodit) ||
            jodit.isJodit));
}
exports.isJoditObject = isJoditObject;
function isViewObject(jodit) {
    return Boolean(jodit &&
        jodit instanceof Object &&
        is_function_1.isFunction(jodit.constructor) &&
        (jodit instanceof global_1.modules.View || jodit.isView));
}
exports.isViewObject = isViewObject;


/***/ }),
/* 45 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isLicense = void 0;
var is_string_1 = __webpack_require__(14);
var isLicense = function (license) {
    return (is_string_1.isString(license) &&
        license.length === 23 &&
        /^[a-z0-9]{5}-[a-z0-9]{5}-[a-z0-9]{5}-[a-z0-9]{5}$/i.test(license));
};
exports.isLicense = isLicense;


/***/ }),
/* 46 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isNativeFunction = void 0;
function isNativeFunction(f) {
    return (Boolean(f) &&
        (typeof f).toLowerCase() === 'function' &&
        (f === Function.prototype ||
            /^\s*function\s*(\b[a-z$_][a-z0-9$_]*\b)*\s*\((|([a-z$_][a-z0-9$_]*)(\s*,[a-z$_][a-z0-9$_]*)*)\)\s*{\s*\[native code]\s*}\s*$/i.test(String(f))));
}
exports.isNativeFunction = isNativeFunction;


/***/ }),
/* 47 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isNumber = void 0;
function isNumber(value) {
    return typeof value === 'number' && !isNaN(value) && isFinite(value);
}
exports.isNumber = isNumber;


/***/ }),
/* 48 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isPlainObject = void 0;
var is_window_1 = __webpack_require__(49);
function isPlainObject(obj) {
    if (!obj || typeof obj !== 'object' || obj.nodeType || is_window_1.isWindow(obj)) {
        return false;
    }
    return !(obj.constructor &&
        !{}.hasOwnProperty.call(obj.constructor.prototype, 'isPrototypeOf'));
}
exports.isPlainObject = isPlainObject;


/***/ }),
/* 49 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isWindow = void 0;
function isWindow(obj) {
    return obj != null && obj === obj.window;
}
exports.isWindow = isWindow;


/***/ }),
/* 50 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isURL = void 0;
function isURL(str) {
    if (str.includes(' ')) {
        return false;
    }
    if (typeof URL !== 'undefined') {
        try {
            var url = new URL(str);
            return ['https:', 'http:', 'ftp:', 'file:', 'rtmp:'].includes(url.protocol);
        }
        catch (e) {
            return false;
        }
    }
    var a = document.createElement('a');
    a.href = str;
    return Boolean(a.hostname);
}
exports.isURL = isURL;


/***/ }),
/* 51 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.isValidName = void 0;
function isValidName(name) {
    if (!name.length) {
        return false;
    }
    if (/[^0-9A-Za-zа-яА-ЯЁё\w\-_.]/.test(name)) {
        return false;
    }
    return true;
}
exports.isValidName = isValidName;


/***/ }),
/* 52 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.set = void 0;
var is_string_1 = __webpack_require__(14);
var is_numeric_1 = __webpack_require__(43);
var is_array_1 = __webpack_require__(16);
var checker_1 = __webpack_require__(34);
function set(chain, value, obj) {
    if (!is_string_1.isString(chain) || !chain.length) {
        return;
    }
    var parts = chain.split('.');
    var result = obj, key = parts[0];
    for (var i = 0; i < parts.length - 1; i += 1) {
        key = parts[i];
        if (!is_array_1.isArray(result[key]) && !checker_1.isPlainObject(result[key])) {
            result[key] = is_numeric_1.isNumeric(parts[i + 1]) ? [] : {};
        }
        result = result[key];
    }
    if (result) {
        result[parts[parts.length - 1]] = value;
    }
}
exports.set = set;


/***/ }),
/* 53 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getClassName = exports.keepNames = void 0;
var is_function_1 = __webpack_require__(15);
exports.keepNames = new Map();
var getClassName = function (obj) {
    var _a;
    if (is_function_1.isFunction(obj.className)) {
        return obj.className();
    }
    var constructor = ((_a = obj.constructor) === null || _a === void 0 ? void 0 : _a.originalConstructor) || obj.constructor;
    if (exports.keepNames.has(constructor)) {
        return exports.keepNames.get(constructor);
    }
    if (constructor.name) {
        return constructor.name;
    }
    var regex = new RegExp(/^\s*function\s*(\S*)\s*\(/);
    var res = constructor.toString().match(regex);
    return res ? res[1] : '';
};
exports.getClassName = getClassName;


/***/ }),
/* 54 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LimitedStack = void 0;
var LimitedStack = (function () {
    function LimitedStack(limit) {
        this.limit = limit;
        this.stack = [];
    }
    LimitedStack.prototype.push = function (item) {
        this.stack.push(item);
        if (this.stack.length > this.limit) {
            this.stack.shift();
        }
        return this;
    };
    LimitedStack.prototype.pop = function () {
        return this.stack.pop();
    };
    LimitedStack.prototype.find = function (clb) {
        return this.stack.find(clb);
    };
    return LimitedStack;
}());
exports.LimitedStack = LimitedStack;


/***/ }),
/* 55 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.toArray = exports.splitArray = exports.asArray = void 0;
var as_array_1 = __webpack_require__(56);
Object.defineProperty(exports, "asArray", ({ enumerable: true, get: function () { return as_array_1.asArray; } }));
var split_array_1 = __webpack_require__(57);
Object.defineProperty(exports, "splitArray", ({ enumerable: true, get: function () { return split_array_1.splitArray; } }));
var to_array_1 = __webpack_require__(58);
Object.defineProperty(exports, "toArray", ({ enumerable: true, get: function () { return to_array_1.toArray; } }));


/***/ }),
/* 56 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.asArray = void 0;
var is_array_1 = __webpack_require__(16);
var asArray = function (a) { return (is_array_1.isArray(a) ? a : [a]); };
exports.asArray = asArray;


/***/ }),
/* 57 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.splitArray = void 0;
var is_string_1 = __webpack_require__(14);
function splitArray(a) {
    return is_string_1.isString(a) ? a.split(/[,\s]+/) : a;
}
exports.splitArray = splitArray;


/***/ }),
/* 58 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.toArray = void 0;
var utils_1 = __webpack_require__(20);
var is_native_function_1 = __webpack_require__(46);
exports.toArray = function toArray() {
    var _a;
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var func = is_native_function_1.isNativeFunction(Array.from)
        ? Array.from
        : (_a = utils_1.reset('Array.from')) !== null && _a !== void 0 ? _a : Array.from;
    return func.apply(Array, args);
};


/***/ }),
/* 59 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(60), exports);


/***/ }),
/* 60 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.clearTimeout = exports.setTimeout = void 0;
var tslib_1 = __webpack_require__(7);
function setTimeout(callback, timeout) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    if (!timeout) {
        callback.call.apply(callback, tslib_1.__spreadArray([null], args));
    }
    else {
        return window.setTimeout.apply(window, tslib_1.__spreadArray([callback, timeout], args));
    }
    return 0;
}
exports.setTimeout = setTimeout;
function clearTimeout(timer) {
    window.clearTimeout(timer);
}
exports.clearTimeout = clearTimeout;


/***/ }),
/* 61 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.fastClone = exports.markAsAtomic = exports.isAtom = void 0;
var stringify_1 = __webpack_require__(38);
function isAtom(obj) {
    return obj && obj.isAtom;
}
exports.isAtom = isAtom;
function markAsAtomic(obj) {
    Object.defineProperty(obj, 'isAtom', {
        enumerable: false,
        value: true,
        configurable: false
    });
    return obj;
}
exports.markAsAtomic = markAsAtomic;
function fastClone(object) {
    return JSON.parse(stringify_1.stringify(object));
}
exports.fastClone = fastClone;


/***/ }),
/* 62 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(63), exports);


/***/ }),
/* 63 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.colorToHex = void 0;
var colorToHex = function (color) {
    if (color === 'rgba(0, 0, 0, 0)' || color === '') {
        return false;
    }
    if (!color) {
        return '#000000';
    }
    if (color.substr(0, 1) === '#') {
        return color;
    }
    var digits = /([\s\n\t\r]*?)rgb\((\d+), (\d+), (\d+)\)/.exec(color) ||
        /([\s\n\t\r]*?)rgba\((\d+), (\d+), (\d+), ([\d.]+)\)/.exec(color);
    if (!digits) {
        return '#000000';
    }
    var red = parseInt(digits[2], 10), green = parseInt(digits[3], 10), blue = parseInt(digits[4], 10), rgb = blue | (green << 8) | (red << 16);
    var hex = rgb.toString(16).toUpperCase();
    while (hex.length < 6) {
        hex = '0' + hex;
    }
    return digits[1] + '#' + hex;
};
exports.colorToHex = colorToHex;


/***/ }),
/* 64 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConfigFlatten = exports.ConfigProto = void 0;
var tslib_1 = __webpack_require__(7);
var extend_1 = __webpack_require__(61);
var checker_1 = __webpack_require__(34);
var config_1 = __webpack_require__(8);
var utils_1 = __webpack_require__(20);
function ConfigProto(options, proto, deep) {
    if (deep === void 0) { deep = 0; }
    if (Object.getPrototypeOf(options) !== Object.prototype) {
        return options;
    }
    var def = config_1.Config.defaultOptions;
    if (checker_1.isString(options.preset)) {
        if (def.presets[options.preset] !== undefined) {
            var preset_1 = def.presets[options.preset];
            Object.keys(preset_1).forEach(function (subKey) {
                if (checker_1.isVoid(options[subKey])) {
                    options[subKey] = preset_1[subKey];
                }
            });
        }
        delete options.preset;
    }
    var newOpt = {};
    Object.keys(options).forEach(function (key) {
        var opt = options[key], protoKey = proto ? proto[key] : null;
        if (checker_1.isPlainObject(opt) && checker_1.isPlainObject(protoKey) && !extend_1.isAtom(opt)) {
            newOpt[key] = ConfigProto(opt, protoKey, deep + 1);
            return;
        }
        if (deep !== 0 && checker_1.isArray(opt) && !extend_1.isAtom(opt) && checker_1.isArray(protoKey)) {
            newOpt[key] = tslib_1.__spreadArray(tslib_1.__spreadArray([], opt), protoKey.slice(opt.length));
            return;
        }
        newOpt[key] = opt;
    });
    Object.setPrototypeOf(newOpt, proto);
    return newOpt;
}
exports.ConfigProto = ConfigProto;
function ConfigFlatten(obj) {
    return utils_1.keys(obj, false).reduce(function (app, key) {
        app[key] = obj[key];
        return app;
    }, {});
}
exports.ConfigFlatten = ConfigFlatten;


/***/ }),
/* 65 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(66), exports);
tslib_1.__exportStar(__webpack_require__(139), exports);
tslib_1.__exportStar(__webpack_require__(140), exports);
tslib_1.__exportStar(__webpack_require__(141), exports);
tslib_1.__exportStar(__webpack_require__(142), exports);


/***/ }),
/* 66 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.applyStyles = void 0;
var dom_1 = __webpack_require__(32);
var selector_1 = __webpack_require__(67);
var string_1 = __webpack_require__(68);
function normalizeCSS(s) {
    return s
        .replace(/mso-[a-z-]+:[\s]*[^;]+;/gi, '')
        .replace(/mso-[a-z-]+:[\s]*[^";]+$/gi, '')
        .replace(/border[a-z-]*:[\s]*[^;]+;/gi, '')
        .replace(/([0-9.]+)(pt|cm)/gi, function (match, units, metrics) {
        switch (metrics.toLowerCase()) {
            case 'pt':
                return (parseFloat(units) * 1.328).toFixed(0) + 'px';
            case 'cm':
                return (parseFloat(units) * 0.02645833).toFixed(0) + 'px';
        }
        return match;
    });
}
function applyStyles(html) {
    if (html.indexOf('<html ') === -1) {
        return html;
    }
    html = html.substring(html.indexOf('<html '), html.length);
    html = html.substring(0, html.lastIndexOf('</html>') + '</html>'.length);
    var iframe = document.createElement('iframe');
    iframe.style.display = 'none';
    document.body.appendChild(iframe);
    var convertedString = '', collection = [], rules = [];
    try {
        var iframeDoc = iframe.contentDocument ||
            (iframe.contentWindow ? iframe.contentWindow.document : null);
        if (iframeDoc) {
            iframeDoc.open();
            iframeDoc.write(html);
            iframeDoc.close();
            if (iframeDoc.styleSheets.length) {
                rules = iframeDoc.styleSheets[iframeDoc.styleSheets.length - 1].cssRules;
            }
            var _loop_1 = function (idx) {
                if (rules[idx].selectorText === '') {
                    return "continue";
                }
                collection = selector_1.$$(rules[idx].selectorText, iframeDoc.body);
                collection.forEach(function (elm) {
                    elm.style.cssText = normalizeCSS(rules[idx].style.cssText + ';' + elm.style.cssText);
                });
            };
            for (var idx = 0; idx < rules.length; idx += 1) {
                _loop_1(idx);
            }
            dom_1.Dom.each(iframeDoc.body, function (node) {
                if (dom_1.Dom.isElement(node)) {
                    var elm = node;
                    var css = elm.style.cssText;
                    if (css) {
                        elm.style.cssText = normalizeCSS(css);
                    }
                    if (elm.hasAttribute('lang')) {
                        elm.removeAttribute('lang');
                    }
                }
            });
            convertedString = iframeDoc.firstChild
                ? string_1.trim(iframeDoc.body.innerHTML)
                : '';
        }
    }
    catch (_a) {
    }
    finally {
        dom_1.Dom.safeRemove(iframe);
    }
    if (convertedString) {
        html = convertedString;
    }
    return string_1.trim(html
        .replace(/<(\/)?(html|colgroup|col|o:p)[^>]*>/g, '')
        .replace(/<!--[^>]*>/g, ''));
}
exports.applyStyles = applyStyles;


/***/ }),
/* 67 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.resolveElement = exports.cssPath = exports.refs = exports.getXPathByElement = exports.$$ = void 0;
var constants_1 = __webpack_require__(9);
var checker_1 = __webpack_require__(34);
var utils_1 = __webpack_require__(20);
var type_1 = __webpack_require__(17);
var dom_1 = __webpack_require__(32);
var string_1 = __webpack_require__(68);
var array_1 = __webpack_require__(55);
var ui_1 = __webpack_require__(75);
var temp = 1;
var $$temp = function () {
    temp++;
    return temp;
};
function $$(selector, root) {
    var result;
    if ( true &&
        /:scope/.test(selector) &&
        constants_1.IS_IE &&
        !(root && root.nodeType === Node.DOCUMENT_NODE)) {
        var id = root.id, temp_id = id ||
            '_selector_id_' + String(Math.random()).slice(2) + $$temp();
        selector = selector.replace(/:scope/g, '#' + temp_id);
        !id && root.setAttribute('id', temp_id);
        result = root.parentNode.querySelectorAll(selector);
        if (!id) {
            root.removeAttribute('id');
        }
    }
    else {
        result = root.querySelectorAll(selector);
    }
    return [].slice.call(result);
}
exports.$$ = $$;
var getXPathByElement = function (element, root) {
    if (!element || element.nodeType !== Node.ELEMENT_NODE) {
        return '';
    }
    if (!element.parentNode || root === element) {
        return '';
    }
    if (element.id) {
        return "//*[@id='" + element.id + "']";
    }
    var sames = [].filter.call(element.parentNode.childNodes, function (x) { return x.nodeName === element.nodeName; });
    return (exports.getXPathByElement(element.parentNode, root) +
        '/' +
        element.nodeName.toLowerCase() +
        (sames.length > 1
            ? '[' + (array_1.toArray(sames).indexOf(element) + 1) + ']'
            : ''));
};
exports.getXPathByElement = getXPathByElement;
var refs = function (root) {
    if (root instanceof ui_1.UIElement) {
        root = root.container;
    }
    return $$('[ref],[data-ref]', root).reduce(function (def, child) {
        var key = utils_1.attr(child, '-ref');
        if (key && checker_1.isString(key)) {
            def[string_1.camelCase(key)] = child;
            def[key] = child;
        }
        return def;
    }, {});
};
exports.refs = refs;
var cssPath = function (el) {
    if (!dom_1.Dom.isElement(el)) {
        return null;
    }
    var path = [];
    var start = el;
    while (start && start.nodeType === Node.ELEMENT_NODE) {
        var selector = start.nodeName.toLowerCase();
        if (start.id) {
            selector += '#' + start.id;
            path.unshift(selector);
            break;
        }
        else {
            var sib = start, nth = 1;
            do {
                sib = sib.previousElementSibling;
                if (sib && sib.nodeName.toLowerCase() === selector) {
                    nth++;
                }
            } while (sib);
            selector += ':nth-of-type(' + nth + ')';
        }
        path.unshift(selector);
        start = start.parentNode;
    }
    return path.join(' > ');
};
exports.cssPath = cssPath;
function resolveElement(element, od) {
    var resolved = element;
    if (checker_1.isString(element)) {
        try {
            resolved = od.querySelector(element);
        }
        catch (_a) {
            throw type_1.error('String "' + element + '" should be valid HTML selector');
        }
    }
    if (!resolved ||
        typeof resolved !== 'object' ||
        !dom_1.Dom.isElement(resolved) ||
        !resolved.cloneNode) {
        throw type_1.error('Element "' + element + '" should be string or HTMLElement instance');
    }
    return resolved;
}
exports.resolveElement = resolveElement;


/***/ }),
/* 68 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(69), exports);
tslib_1.__exportStar(__webpack_require__(38), exports);
tslib_1.__exportStar(__webpack_require__(70), exports);
tslib_1.__exportStar(__webpack_require__(71), exports);
tslib_1.__exportStar(__webpack_require__(72), exports);
tslib_1.__exportStar(__webpack_require__(73), exports);


/***/ }),
/* 69 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.camelCase = void 0;
var camelCase = function (key) {
    return key.replace(/([-_])(.)/g, function (m, code, letter) {
        return letter.toUpperCase();
    });
};
exports.camelCase = camelCase;


/***/ }),
/* 70 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.kebabCase = void 0;
var kebabCase = function (key) {
    return key
        .replace(/([A-Z])([A-Z])([a-z])/g, '$1-$2$3')
        .replace(/([a-z])([A-Z])/g, '$1-$2')
        .replace(/[\s_]+/g, '-')
        .toLowerCase();
};
exports.kebabCase = kebabCase;


/***/ }),
/* 71 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.trimInv = exports.trim = void 0;
var constants_1 = __webpack_require__(9);
function trim(value) {
    return value
        .replace(constants_1.SPACE_REG_EXP_END(), '')
        .replace(constants_1.SPACE_REG_EXP_START(), '');
}
exports.trim = trim;
function trimInv(value) {
    return value
        .replace(constants_1.INVISIBLE_SPACE_REG_EXP_END(), '')
        .replace(constants_1.INVISIBLE_SPACE_REG_EXP_START(), '');
}
exports.trimInv = trimInv;


/***/ }),
/* 72 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ucfirst = void 0;
var ucfirst = function (value) {
    if (!value.length) {
        return '';
    }
    return value[0].toUpperCase() + value.substr(1);
};
exports.ucfirst = ucfirst;


/***/ }),
/* 73 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.i18n = exports.sprintf = void 0;
var config_1 = __webpack_require__(8);
var default_language_1 = __webpack_require__(74);
var __1 = __webpack_require__(19);
var global_1 = __webpack_require__(30);
var sprintf = function (str, args) {
    if (!args || !args.length) {
        return str;
    }
    var reg = /%([sd])/g;
    var fnd = reg.exec(str);
    var res = str, i = 0;
    while (fnd && args[i] !== undefined) {
        res = res.replace(fnd[0], args[i].toString());
        i += 1;
        fnd = reg.exec(str);
    }
    return res;
};
exports.sprintf = sprintf;
var i18n = function (key, params, options) {
    if (!__1.isString(key)) {
        throw __1.error('i18n: Need string in first argument');
    }
    if (!key.length) {
        return key;
    }
    var debug = Boolean(options !== undefined && options.debugLanguage);
    var store;
    var parse = function (value) {
        return params && params.length ? exports.sprintf(value, params) : value;
    }, defaultLanguage = default_language_1.defaultLanguage(config_1.Config.defaultOptions.language, config_1.Config.defaultOptions.language), language = default_language_1.defaultLanguage(options === null || options === void 0 ? void 0 : options.language, defaultLanguage), tryGet = function (store) {
        if (!store) {
            return;
        }
        if (__1.isString(store[key])) {
            return parse(store[key]);
        }
        var lcKey = key.toLowerCase();
        if (__1.isString(store[lcKey])) {
            return parse(store[lcKey]);
        }
        var ucfKey = __1.ucfirst(key);
        if (__1.isString(store[ucfKey])) {
            return parse(store[ucfKey]);
        }
        return;
    };
    if (global_1.lang[language] !== undefined) {
        store = global_1.lang[language];
    }
    else {
        if (global_1.lang[defaultLanguage] !== undefined) {
            store = global_1.lang[defaultLanguage];
        }
        else {
            store = global_1.lang.en;
        }
    }
    var i18nOvr = options === null || options === void 0 ? void 0 : options.i18n;
    if (i18nOvr && i18nOvr[language]) {
        var result_1 = tryGet(i18nOvr[language]);
        if (result_1) {
            return result_1;
        }
    }
    var result = tryGet(store);
    if (result) {
        return result;
    }
    if (global_1.lang.en && __1.isString(global_1.lang.en[key]) && global_1.lang.en[key]) {
        return parse(global_1.lang.en[key]);
    }
    if (debug) {
        return '{' + key + '}';
    }
    if (false) {}
    return parse(key);
};
exports.i18n = i18n;


/***/ }),
/* 74 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.defaultLanguage = void 0;
var checker_1 = __webpack_require__(34);
var defaultLanguage = function (language, defaultLanguage) {
    if (defaultLanguage === void 0) { defaultLanguage = 'en'; }
    if (language !== 'auto' && checker_1.isString(language)) {
        return language;
    }
    if (document.documentElement && document.documentElement.lang) {
        return document.documentElement.lang;
    }
    if (navigator.language) {
        return navigator.language.substr(0, 2);
    }
    return defaultLanguage;
};
exports.defaultLanguage = defaultLanguage;


/***/ }),
/* 75 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(76), exports);
tslib_1.__exportStar(__webpack_require__(92), exports);
tslib_1.__exportStar(__webpack_require__(116), exports);
tslib_1.__exportStar(__webpack_require__(112), exports);
tslib_1.__exportStar(__webpack_require__(110), exports);
tslib_1.__exportStar(__webpack_require__(95), exports);
tslib_1.__exportStar(__webpack_require__(119), exports);
tslib_1.__exportStar(__webpack_require__(80), exports);
tslib_1.__exportStar(__webpack_require__(137), exports);


/***/ }),
/* 76 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UIElement = void 0;
var tslib_1 = __webpack_require__(7);
var component_1 = __webpack_require__(27);
var dom_1 = __webpack_require__(32);
var traits_1 = __webpack_require__(77);
var helpers_1 = __webpack_require__(19);
var icon_1 = __webpack_require__(80);
var UIElement = (function (_super) {
    tslib_1.__extends(UIElement, _super);
    function UIElement(jodit, options) {
        var _this = _super.call(this, jodit) || this;
        _this.name = '';
        _this.__parentElement = null;
        _this.mods = {};
        _this.container = _this.createContainer(options);
        Object.defineProperty(_this.container, 'component', {
            value: _this,
            configurable: true
        });
        return _this;
    }
    Object.defineProperty(UIElement.prototype, "parentElement", {
        get: function () {
            return this.__parentElement;
        },
        set: function (parentElement) {
            var _this = this;
            this.__parentElement = parentElement;
            if (parentElement) {
                parentElement.hookStatus('beforeDestruct', function () { return _this.destruct(); });
            }
            this.updateParentElement(this);
        },
        enumerable: false,
        configurable: true
    });
    UIElement.prototype.bubble = function (callback) {
        var parent = this.parentElement;
        while (parent) {
            callback(parent);
            parent = parent.parentElement;
        }
        return this;
    };
    UIElement.prototype.updateParentElement = function (target) {
        var _a;
        (_a = this.__parentElement) === null || _a === void 0 ? void 0 : _a.updateParentElement(target);
        return this;
    };
    UIElement.prototype.get = function (chain, obj) {
        return _super.prototype.get.call(this, chain, obj) || this.getElm(chain);
    };
    UIElement.prototype.closest = function (type) {
        var c = typeof type === 'object'
            ? function (pe) { return pe === type; }
            : function (pe) { return pe instanceof type; };
        var pe = this.__parentElement;
        while (pe) {
            if (c(pe)) {
                return pe;
            }
            if (!pe.parentElement && pe.container.parentElement) {
                pe = UIElement.closestElement(pe.container.parentElement, UIElement);
            }
            else {
                pe = pe.parentElement;
            }
        }
        return null;
    };
    UIElement.closestElement = function (node, type) {
        var elm = dom_1.Dom.up(node, function (node) {
            if (node) {
                var component = node.component;
                return component && component instanceof type;
            }
            return false;
        });
        return elm ? elm === null || elm === void 0 ? void 0 : elm.component : null;
    };
    UIElement.prototype.setMod = function (name, value, container) {
        if (container === void 0) { container = this.container; }
        traits_1.Mods.setMod.call(this, name, value);
        return this;
    };
    UIElement.prototype.getMod = function (name) {
        return traits_1.Mods.getMod.call(this, name);
    };
    UIElement.prototype.getElm = function (elementName) {
        return traits_1.Elms.getElm.call(this, elementName);
    };
    UIElement.prototype.getElms = function (elementName) {
        return traits_1.Elms.getElms.call(this, elementName);
    };
    UIElement.prototype.update = function () {
    };
    UIElement.prototype.appendTo = function (element) {
        element.appendChild(this.container);
        return this;
    };
    UIElement.prototype.clearName = function (name) {
        return name.replace(/[^a-zA-Z0-9]/g, '_');
    };
    UIElement.prototype.render = function (options) {
        return this.j.c.div(this.componentName);
    };
    UIElement.prototype.createContainer = function (options) {
        var _this = this;
        var result = this.render(options);
        if (helpers_1.isString(result)) {
            var elm = this.j.c.fromHTML(result
                .replace(/\*([^*]+?)\*/g, function (_, name) { return icon_1.Icon.get(name) || ''; })
                .replace(/&__/g, this.componentName + '__')
                .replace(/~([^~]+?)~/g, function (_, s) { return _this.i18n(s); }));
            elm.classList.add(this.componentName);
            return elm;
        }
        return result;
    };
    UIElement.prototype.destruct = function () {
        dom_1.Dom.safeRemove(this.container);
        this.parentElement = null;
        return _super.prototype.destruct.call(this);
    };
    return UIElement;
}(component_1.ViewComponent));
exports.UIElement = UIElement;


/***/ }),
/* 77 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(78), exports);
tslib_1.__exportStar(__webpack_require__(79), exports);


/***/ }),
/* 78 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Elms = void 0;
var helpers_1 = __webpack_require__(19);
var Elms = (function () {
    function Elms() {
    }
    Elms.getElm = function (elementName) {
        return this.container.querySelector("." + this.getFullElName(elementName));
    };
    Elms.getElms = function (elementName) {
        return helpers_1.toArray(this.container.querySelectorAll("." + this.getFullElName(elementName)));
    };
    return Elms;
}());
exports.Elms = Elms;


/***/ }),
/* 79 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Mods = void 0;
var helpers_1 = __webpack_require__(19);
var Mods = (function () {
    function Mods() {
    }
    Mods.setMod = function (name, value, container) {
        name = name.toLowerCase();
        if (this.mods[name] === value) {
            return;
        }
        var mod = this.componentName + "_" + name, cl = (container || this.container).classList;
        helpers_1.toArray(cl).forEach(function (className) {
            if (className.indexOf(mod) === 0) {
                cl.remove(className);
            }
        });
        value != null &&
            value !== '' &&
            cl.add(mod + "_" + value.toString().toLowerCase());
        this.mods[name] = value;
    };
    Mods.getMod = function (name) {
        var _a;
        return (_a = this.mods[name]) !== null && _a !== void 0 ? _a : null;
    };
    return Mods;
}());
exports.Mods = Mods;


/***/ }),
/* 80 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Icon = void 0;
var css_1 = __webpack_require__(81);
var Icon = (function () {
    function Icon() {
    }
    Icon.getIcon = function (name) {
        if (/^<svg/i.test(name)) {
            return name;
        }
        return (Icon.icons[name] ||
            Icon.icons[name.replace(/-/g, '_')] ||
            Icon.icons[name.toLowerCase()]);
    };
    Icon.exists = function (name) {
        return this.getIcon(name) !== undefined;
    };
    Icon.get = function (name, defaultValue) {
        if (defaultValue === void 0) { defaultValue = '<span></span>'; }
        return this.getIcon(name) || defaultValue;
    };
    Icon.set = function (name, value) {
        this.icons[name.replace('_', '-')] = value;
    };
    Icon.makeIcon = function (jodit, icon) {
        var _a;
        var iconElement;
        if (icon) {
            var clearName = icon.name.replace(/[^a-zA-Z0-9]/g, '_');
            if (icon.iconURL) {
                iconElement = jodit.c.span();
                css_1.css(iconElement, 'backgroundImage', 'url(' +
                    icon.iconURL.replace('{basePath}', (jodit === null || jodit === void 0 ? void 0 : jodit.basePath) || '') +
                    ')');
            }
            else {
                var svg = jodit.e.fire('getIcon', icon.name, icon, clearName) ||
                    Icon.get(icon.name, '') ||
                    ((_a = jodit.o.extraIcons) === null || _a === void 0 ? void 0 : _a[icon.name]);
                if (svg) {
                    iconElement = jodit.c.fromHTML(svg.trim());
                    if (!/^<svg/i.test(icon.name)) {
                        iconElement.classList.add('jodit-icon_' + clearName);
                    }
                }
            }
        }
        if (iconElement) {
            iconElement.classList.add('jodit-icon');
            iconElement.style.fill = icon.fill;
        }
        return iconElement;
    };
    Icon.icons = {};
    return Icon;
}());
exports.Icon = Icon;


/***/ }),
/* 81 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.clearCenterAlign = exports.css = void 0;
var checker_1 = __webpack_require__(34);
var normalize_1 = __webpack_require__(82);
var string_1 = __webpack_require__(68);
var css = function (element, key, value, onlyStyleMode) {
    if (onlyStyleMode === void 0) { onlyStyleMode = false; }
    var numberFieldsReg = /^left|top|bottom|right|width|min|max|height|margin|padding|fontsize|font-size/i;
    if (checker_1.isPlainObject(key) || value !== undefined) {
        var setValue = function (elm, _key, _value) {
            if (!checker_1.isVoid(_value) &&
                numberFieldsReg.test(_key) &&
                checker_1.isNumeric(_value.toString())) {
                _value = parseInt(_value.toString(), 10) + 'px';
            }
            if (_value !== undefined &&
                (_value == null ||
                    exports.css(elm, _key, undefined, true) !==
                        normalize_1.normalizeCssValue(_key, _value))) {
                elm.style[_key] = _value;
            }
        };
        if (checker_1.isPlainObject(key)) {
            var keys = Object.keys(key);
            for (var j = 0; j < keys.length; j += 1) {
                setValue(element, string_1.camelCase(keys[j]), key[keys[j]]);
            }
        }
        else {
            setValue(element, string_1.camelCase(key), value);
        }
        return '';
    }
    var key2 = string_1.kebabCase(key), doc = element.ownerDocument || document, win = doc ? doc.defaultView || doc.parentWindow : false;
    var currentValue = element.style[key];
    var result = '';
    if (currentValue !== undefined && currentValue !== '') {
        result = currentValue;
    }
    else if (win && !onlyStyleMode) {
        result = win.getComputedStyle(element).getPropertyValue(key2);
    }
    if (numberFieldsReg.test(key) &&
        /^[-+]?[0-9.]+px$/.test(result.toString())) {
        result = parseInt(result.toString(), 10);
    }
    return normalize_1.normalizeCssValue(key, result);
};
exports.css = css;
var clearCenterAlign = function (image) {
    if (exports.css(image, 'display') === 'block') {
        exports.css(image, 'display', '');
    }
    var style = image.style;
    if (style.marginLeft === 'auto' && style.marginRight === 'auto') {
        style.marginLeft = '';
        style.marginRight = '';
    }
};
exports.clearCenterAlign = clearCenterAlign;


/***/ }),
/* 82 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(83), exports);
tslib_1.__exportStar(__webpack_require__(84), exports);
tslib_1.__exportStar(__webpack_require__(85), exports);
tslib_1.__exportStar(__webpack_require__(86), exports);
tslib_1.__exportStar(__webpack_require__(87), exports);
tslib_1.__exportStar(__webpack_require__(88), exports);
tslib_1.__exportStar(__webpack_require__(89), exports);
tslib_1.__exportStar(__webpack_require__(90), exports);
tslib_1.__exportStar(__webpack_require__(91), exports);


/***/ }),
/* 83 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.normalizeKeyAliases = void 0;
var string_1 = __webpack_require__(68);
var constants_1 = __webpack_require__(9);
function normalizeKeyAliases(keys) {
    var memory = {};
    return keys
        .replace(/\+\+/g, '+add')
        .split(/[\s]*\+[\s]*/)
        .map(function (key) { return string_1.trim(key.toLowerCase()); })
        .map(function (key) { return constants_1.KEY_ALIASES[key] || key; })
        .sort()
        .filter(function (key) { return !memory[key] && key !== '' && (memory[key] = true); })
        .join('+');
}
exports.normalizeKeyAliases = normalizeKeyAliases;


/***/ }),
/* 84 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.normalizeLicense = void 0;
var normalizeLicense = function (license, count) {
    if (count === void 0) { count = 8; }
    var parts = [];
    while (license.length) {
        parts.push(license.substr(0, count));
        license = license.substr(count);
    }
    parts[1] = parts[1].replace(/./g, '*');
    parts[2] = parts[2].replace(/./g, '*');
    return parts.join('-');
};
exports.normalizeLicense = normalizeLicense;


/***/ }),
/* 85 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.normalizeNode = void 0;
var constants_1 = __webpack_require__(9);
var dom_1 = __webpack_require__(32);
var normalizeNode = function (node) {
    if (!node) {
        return;
    }
    if (dom_1.Dom.isText(node) && node.nodeValue != null && node.parentNode) {
        while (dom_1.Dom.isText(node.nextSibling)) {
            if (node.nextSibling.nodeValue != null) {
                node.nodeValue += node.nextSibling.nodeValue;
            }
            node.nodeValue = node.nodeValue.replace(constants_1.INVISIBLE_SPACE_REG_EXP(), '');
            dom_1.Dom.safeRemove(node.nextSibling);
        }
    }
    else {
        exports.normalizeNode(node.firstChild);
    }
    exports.normalizeNode(node.nextSibling);
};
exports.normalizeNode = normalizeNode;


/***/ }),
/* 86 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.normalizePath = void 0;
var string_1 = __webpack_require__(68);
var normalizePath = function () {
    var path = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        path[_i] = arguments[_i];
    }
    return path
        .filter(function (part) { return string_1.trim(part).length; })
        .map(function (part, index) {
        part = part.replace(/([^:])[\\/]+/g, '$1/');
        if (index) {
            part = part.replace(/^\//, '');
        }
        if (index !== path.length - 1) {
            part = part.replace(/\/$/, '');
        }
        return part;
    })
        .join('/');
};
exports.normalizePath = normalizePath;


/***/ }),
/* 87 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.normalizeRelativePath = void 0;
var normalizeRelativePath = function (path) {
    var sections = path.split('/'), builder = sections.reduce(function (builder, section) {
        switch (section) {
            case '': {
                break;
            }
            case '.': {
                break;
            }
            case '..': {
                builder.pop();
                break;
            }
            default: {
                builder.push(section);
                break;
            }
        }
        return builder;
    }, []);
    return builder.join('/') + (path.endsWith('/') ? '/' : '');
};
exports.normalizeRelativePath = normalizeRelativePath;


/***/ }),
/* 88 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.normalizeSize = void 0;
var normalizeSize = function (value) {
    if (/^[0-9]+$/.test(value.toString())) {
        return value + 'px';
    }
    return value.toString();
};
exports.normalizeSize = normalizeSize;


/***/ }),
/* 89 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.normalizeUrl = void 0;
var normalizeUrl = function () {
    var urls = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        urls[_i] = arguments[_i];
    }
    return urls
        .filter(function (url) { return url.length; })
        .map(function (url) { return url.replace(/\/$/, ''); })
        .join('/')
        .replace(/([^:])[\\/]+/g, '$1/');
};
exports.normalizeUrl = normalizeUrl;


/***/ }),
/* 90 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.normalizeCssValue = void 0;
var checker_1 = __webpack_require__(34);
var string_1 = __webpack_require__(68);
var color_1 = __webpack_require__(62);
function normalizeCssValue(key, value) {
    switch (string_1.kebabCase(key)) {
        case 'font-weight':
            switch (value.toString().toLowerCase()) {
                case '700':
                case 'bold':
                    return 700;
                case '400':
                case 'normal':
                    return 400;
                case '900':
                case 'heavy':
                    return 900;
            }
            return checker_1.isNumeric(value) ? Number(value) : value;
    }
    if (/color/i.test(key) && /^rgb/i.test(value.toString())) {
        return color_1.colorToHex(value.toString()) || value;
    }
    return value;
}
exports.normalizeCssValue = normalizeCssValue;


/***/ }),
/* 91 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.normalizeColor = void 0;
var color_1 = __webpack_require__(62);
var string_1 = __webpack_require__(68);
var normalizeColor = function (colorInput) {
    var newcolor = ['#'];
    var color = color_1.colorToHex(colorInput);
    if (!color) {
        return false;
    }
    color = string_1.trim(color.toUpperCase());
    color = color.substr(1);
    if (color.length === 3) {
        for (var i = 0; i < 3; i += 1) {
            newcolor.push(color[i]);
            newcolor.push(color[i]);
        }
        return newcolor.join('');
    }
    if (color.length > 6) {
        color = color.substr(0, 6);
    }
    return '#' + color;
};
exports.normalizeColor = normalizeColor;


/***/ }),
/* 92 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(93), exports);
tslib_1.__exportStar(__webpack_require__(114), exports);


/***/ }),
/* 93 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Button = exports.UIButton = exports.UIButtonState = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(94);
var element_1 = __webpack_require__(76);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var icon_1 = __webpack_require__(80);
var list_1 = __webpack_require__(95);
var decorators_1 = __webpack_require__(99);
var component_1 = __webpack_require__(27);
var UIButtonState = function () { return ({
    size: 'middle',
    type: 'button',
    name: '',
    value: '',
    status: '',
    disabled: false,
    activated: false,
    icon: {
        name: 'empty',
        fill: '',
        iconURL: ''
    },
    tooltip: '',
    text: '',
    tabIndex: undefined
}); };
exports.UIButtonState = UIButtonState;
var UIButton = (function (_super) {
    tslib_1.__extends(UIButton, _super);
    function UIButton(jodit, state) {
        var _this = _super.call(this, jodit) || this;
        _this.isButton = true;
        _this.state = exports.UIButtonState();
        _this.actionHandlers = [];
        _this.updateSize();
        _this.onChangeSize();
        _this.onChangeStatus();
        if (state) {
            _this.hookStatus(component_1.STATUSES.ready, function () {
                _this.setState(state);
            });
        }
        return _this;
    }
    UIButton.prototype.className = function () {
        return 'UIButton';
    };
    UIButton.prototype.setState = function (state) {
        Object.assign(this.state, state);
        return this;
    };
    UIButton.prototype.onChangeSize = function () {
        this.setMod('size', this.state.size);
    };
    UIButton.prototype.onChangeType = function () {
        helpers_1.attr(this.container, 'type', this.state.type);
    };
    UIButton.prototype.updateSize = function () {
        var pe = this.closest(list_1.UIList);
        if (pe) {
            this.state.size = pe.buttonSize;
            return;
        }
    };
    UIButton.prototype.onChangeStatus = function () {
        this.setMod('status', this.state.status);
    };
    UIButton.prototype.onChangeText = function () {
        this.text.textContent = this.jodit.i18n(this.state.text);
    };
    UIButton.prototype.onChangeTextSetMode = function () {
        this.setMod('text-icons', Boolean(this.state.text.trim().length));
    };
    UIButton.prototype.onChangeDisabled = function () {
        helpers_1.attr(this.container, 'disabled', this.state.disabled || null);
    };
    UIButton.prototype.onChangeActivated = function () {
        helpers_1.attr(this.container, 'aria-pressed', this.state.activated);
    };
    UIButton.prototype.onChangeName = function () {
        this.container.classList.add(this.componentName + "_" + this.clearName(this.state.name));
        this.name = this.state.name;
        helpers_1.attr(this.container, 'data-ref', this.state.name);
        helpers_1.attr(this.container, 'ref', this.state.name);
    };
    UIButton.prototype.onChangeTooltip = function () {
        if (this.get('j.o.useNativeTooltip')) {
            helpers_1.attr(this.container, 'title', this.state.tooltip);
        }
        helpers_1.attr(this.container, 'aria-label', this.state.tooltip);
    };
    UIButton.prototype.onChangeTabIndex = function () {
        helpers_1.attr(this.container, 'tabIndex', this.state.tabIndex);
    };
    UIButton.prototype.onChangeIcon = function () {
        var textIcons = this.get('j.o.textIcons');
        if (textIcons === true ||
            (helpers_1.isFunction(textIcons) && textIcons(this.state.name))) {
            return;
        }
        dom_1.Dom.detach(this.icon);
        var iconElement = icon_1.Icon.makeIcon(this.j, this.state.icon);
        iconElement && this.icon.appendChild(iconElement);
    };
    UIButton.prototype.focus = function () {
        this.container.focus();
    };
    UIButton.prototype.isFocused = function () {
        var activeElement = this.od.activeElement;
        return Boolean(activeElement && dom_1.Dom.isOrContains(this.container, activeElement));
    };
    UIButton.prototype.createContainer = function () {
        var cn = this.componentName;
        var button = this.j.c.element('button', {
            class: cn,
            type: 'button',
            role: 'button',
            ariaPressed: false
        });
        this.icon = this.j.c.span(cn + '__icon');
        this.text = this.j.c.span(cn + '__text');
        button.appendChild(this.icon);
        button.appendChild(this.text);
        this.j.e.on(button, 'click', this.onActionFire);
        return button;
    };
    UIButton.prototype.destruct = function () {
        this.j.e.off(this.container);
        return _super.prototype.destruct.call(this);
    };
    UIButton.prototype.onAction = function (callback) {
        this.actionHandlers.push(callback);
        return this;
    };
    UIButton.prototype.onActionFire = function (e) {
        var _this = this;
        e.buffer = {
            actionTrigger: this
        };
        this.actionHandlers.forEach(function (callback) { return callback.call(_this, e); });
    };
    tslib_1.__decorate([
        decorators_1.watch('state.size')
    ], UIButton.prototype, "onChangeSize", null);
    tslib_1.__decorate([
        decorators_1.watch('state.type')
    ], UIButton.prototype, "onChangeType", null);
    tslib_1.__decorate([
        decorators_1.watch('parentElement')
    ], UIButton.prototype, "updateSize", null);
    tslib_1.__decorate([
        decorators_1.watch('state.status')
    ], UIButton.prototype, "onChangeStatus", null);
    tslib_1.__decorate([
        decorators_1.watch('state.text')
    ], UIButton.prototype, "onChangeText", null);
    tslib_1.__decorate([
        decorators_1.watch('state.text')
    ], UIButton.prototype, "onChangeTextSetMode", null);
    tslib_1.__decorate([
        decorators_1.watch('state.disabled')
    ], UIButton.prototype, "onChangeDisabled", null);
    tslib_1.__decorate([
        decorators_1.watch('state.activated')
    ], UIButton.prototype, "onChangeActivated", null);
    tslib_1.__decorate([
        decorators_1.watch('state.name')
    ], UIButton.prototype, "onChangeName", null);
    tslib_1.__decorate([
        decorators_1.watch('state.tooltip')
    ], UIButton.prototype, "onChangeTooltip", null);
    tslib_1.__decorate([
        decorators_1.watch('state.tabIndex')
    ], UIButton.prototype, "onChangeTabIndex", null);
    tslib_1.__decorate([
        decorators_1.watch('state.icon')
    ], UIButton.prototype, "onChangeIcon", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], UIButton.prototype, "onActionFire", null);
    UIButton = tslib_1.__decorate([
        decorators_1.component
    ], UIButton);
    return UIButton;
}(element_1.UIElement));
exports.UIButton = UIButton;
function Button(jodit, stateOrText, text, status) {
    var button = new UIButton(jodit);
    button.state.tabIndex = jodit.o.allowTabNavigation ? 0 : -1;
    if (helpers_1.isString(stateOrText)) {
        button.state.icon.name = stateOrText;
        button.state.name = stateOrText;
        if (status) {
            button.state.status = status;
        }
        if (text) {
            button.state.text = text;
        }
    }
    else {
        button.setState(stateOrText);
    }
    return button;
}
exports.Button = Button;


/***/ }),
/* 94 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 95 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UIList = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(96);
var button_1 = __webpack_require__(92);
var get_strong_control_types_1 = __webpack_require__(97);
var decorators_1 = __webpack_require__(99);
var group_1 = __webpack_require__(110);
var separator_1 = __webpack_require__(112);
var buttons_1 = __webpack_require__(113);
var get_control_type_1 = __webpack_require__(98);
var helpers_1 = __webpack_require__(19);
var UIList = (function (_super) {
    tslib_1.__extends(UIList, _super);
    function UIList(jodit) {
        var _this = _super.call(this, jodit) || this;
        _this.mode = 'horizontal';
        _this.removeButtons = [];
        _this.onChangeMode();
        return _this;
    }
    UIList.prototype.className = function () {
        return 'UIList';
    };
    UIList.prototype.onChangeMode = function () {
        this.setMod('mode', this.mode);
    };
    UIList.prototype.makeGroup = function () {
        return new group_1.UIGroup(this.jodit);
    };
    Object.defineProperty(UIList.prototype, "buttons", {
        get: function () {
            return this.allChildren.filter(function (elm) { return elm instanceof button_1.UIButton; });
        },
        enumerable: false,
        configurable: true
    });
    UIList.prototype.getButtonsNames = function () {
        return this.buttons
            .map(function (a) { return (a instanceof button_1.UIButton && a.state.name) || ''; })
            .filter(function (a) { return a !== ''; });
    };
    UIList.prototype.setRemoveButtons = function (removeButtons) {
        this.removeButtons = removeButtons || [];
        return this;
    };
    UIList.prototype.build = function (items, target) {
        var _this = this;
        if (target === void 0) { target = null; }
        items = helpers_1.splitArray(items);
        this.clear();
        var lastBtnSeparator = false;
        var line = this.makeGroup();
        this.append(line);
        var group;
        var addButton = function (control) {
            var elm = null;
            switch (control.name) {
                case '\n':
                    line = _this.makeGroup();
                    group = _this.makeGroup();
                    line.append(group);
                    _this.append(line);
                    break;
                case '|':
                    if (!lastBtnSeparator) {
                        lastBtnSeparator = true;
                        elm = new separator_1.UISeparator(_this.j);
                    }
                    break;
                default:
                    lastBtnSeparator = false;
                    elm = _this.makeButton(control, target);
            }
            if (elm) {
                if (!group) {
                    group = _this.makeGroup();
                    line.append(group);
                }
                group.append(elm);
            }
        };
        var isNotRemoved = function (b) {
            return !_this.removeButtons.includes(b.name);
        };
        items.forEach(function (item) {
            if (buttons_1.isButtonGroup(item)) {
                var buttons = item.buttons.filter(function (b) { return b; });
                if (buttons.length) {
                    group = _this.makeGroup();
                    line.append(group);
                    group.setMod('separated', true).setMod('group', item.group);
                    get_strong_control_types_1.getStrongControlTypes(buttons, _this.j.o.controls)
                        .filter(isNotRemoved)
                        .forEach(addButton);
                }
            }
            else {
                var control = get_control_type_1.getControlType(item, _this.j.o.controls);
                isNotRemoved(control) && addButton(control);
            }
        });
        this.update();
        return this;
    };
    UIList.prototype.makeButton = function (control, target) {
        return new button_1.UIButton(this.j);
    };
    tslib_1.__decorate([
        decorators_1.watch('mode')
    ], UIList.prototype, "onChangeMode", null);
    UIList = tslib_1.__decorate([
        decorators_1.component
    ], UIList);
    return UIList;
}(group_1.UIGroup));
exports.UIList = UIList;


/***/ }),
/* 96 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 97 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getStrongControlTypes = void 0;
var get_control_type_1 = __webpack_require__(98);
var config_1 = __webpack_require__(8);
var checker_1 = __webpack_require__(34);
var helpers_1 = __webpack_require__(19);
function getStrongControlTypes(items, controls) {
    var elements = checker_1.isArray(items)
        ? items
        : helpers_1.keys(items, false).map(function (key) {
            var value = items[key] || {};
            return helpers_1.ConfigProto({ name: key }, value);
        });
    return elements.map(function (item) {
        return get_control_type_1.getControlType(item, controls || config_1.Config.defaultOptions.controls);
    });
}
exports.getStrongControlTypes = getStrongControlTypes;


/***/ }),
/* 98 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.findControlType = exports.getControlType = void 0;
var tslib_1 = __webpack_require__(7);
var helpers_1 = __webpack_require__(19);
var config_1 = __webpack_require__(8);
function getControlType(button, controls) {
    var buttonControl;
    if (!controls)
        controls = config_1.Config.defaultOptions.controls;
    if (!helpers_1.isString(button)) {
        buttonControl = tslib_1.__assign({ name: 'empty' }, helpers_1.ConfigFlatten(button));
        if (controls[buttonControl.name] !== undefined) {
            buttonControl = tslib_1.__assign(tslib_1.__assign({}, helpers_1.ConfigFlatten(controls[buttonControl.name])), helpers_1.ConfigFlatten(buttonControl));
        }
    }
    else {
        buttonControl = findControlType(button, controls) || {
            name: button,
            command: button,
            tooltip: button
        };
    }
    return buttonControl;
}
exports.getControlType = getControlType;
function findControlType(path, controls) {
    var _a = path.split(/\./), namespaceOrKey = _a[0], key = _a[1];
    var store = controls;
    if (key != null) {
        if (controls[namespaceOrKey] !== undefined) {
            store = controls[namespaceOrKey];
        }
    }
    else {
        key = namespaceOrKey;
    }
    return store[key]
        ? tslib_1.__assign({ name: key }, helpers_1.ConfigFlatten(store[key])) : undefined;
}
exports.findControlType = findControlType;


/***/ }),
/* 99 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.autobind = void 0;
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(100), exports);
tslib_1.__exportStar(__webpack_require__(101), exports);
tslib_1.__exportStar(__webpack_require__(102), exports);
tslib_1.__exportStar(__webpack_require__(103), exports);
tslib_1.__exportStar(__webpack_require__(104), exports);
tslib_1.__exportStar(__webpack_require__(105), exports);
tslib_1.__exportStar(__webpack_require__(106), exports);
tslib_1.__exportStar(__webpack_require__(107), exports);
tslib_1.__exportStar(__webpack_require__(108), exports);
var autobind_decorator_1 = __webpack_require__(109);
Object.defineProperty(exports, "autobind", ({ enumerable: true, get: function () { return autobind_decorator_1.default; } }));


/***/ }),
/* 100 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.cache = void 0;
var helpers_1 = __webpack_require__(19);
function cache(target, name, descriptor) {
    var getter = descriptor.get;
    if (!getter) {
        throw helpers_1.error('Getter property descriptor expected');
    }
    descriptor.get = function () {
        var value = getter.call(this);
        if (value && value.noCache === true) {
            return value;
        }
        Object.defineProperty(this, name, {
            configurable: descriptor.configurable,
            enumerable: descriptor.enumerable,
            writable: false,
            value: value
        });
        return value;
    };
}
exports.cache = cache;


/***/ }),
/* 101 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.component = void 0;
var tslib_1 = __webpack_require__(7);
var helpers_1 = __webpack_require__(19);
var cn = function (elm) {
    return helpers_1.isFunction(elm.className) ? elm.className() : NaN;
};
function component(constructorFunction) {
    var newConstructorFunction = (function (_super) {
        tslib_1.__extends(newConstructorFunction, _super);
        function newConstructorFunction() {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var _this = _super.apply(this, args) || this;
            var isSamePrototype = Object.getPrototypeOf(_this) ===
                newConstructorFunction.prototype;
            var isSameClassName = cn(_this) ===
                cn(newConstructorFunction.prototype);
            if (false) {}
            if (isSamePrototype || isSameClassName) {
                _this.setStatus('ready');
            }
            return _this;
        }
        return newConstructorFunction;
    }(constructorFunction));
    newConstructorFunction.prototype.constructor = constructorFunction;
    return newConstructorFunction;
}
exports.component = component;


/***/ }),
/* 102 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.throttle = exports.debounce = void 0;
var helpers_1 = __webpack_require__(19);
var component_1 = __webpack_require__(27);
function debounce(timeout, firstCallImmediately, method) {
    if (firstCallImmediately === void 0) { firstCallImmediately = false; }
    if (method === void 0) { method = 'debounce'; }
    return function (target, propertyKey) {
        if (!helpers_1.isFunction(target[propertyKey])) {
            throw helpers_1.error('Handler must be a Function');
        }
        target.hookStatus(component_1.STATUSES.ready, function (component) {
            var view = helpers_1.isViewObject(component)
                ? component
                : component.jodit;
            var realTimeout = helpers_1.isFunction(timeout)
                ? timeout(component)
                : timeout;
            component[propertyKey] = view.async[method](component[propertyKey].bind(component), helpers_1.isNumber(realTimeout) || helpers_1.isPlainObject(realTimeout)
                ? realTimeout
                : view.defaultTimeout, firstCallImmediately);
        });
    };
}
exports.debounce = debounce;
function throttle(timeout, firstCallImmediately) {
    if (firstCallImmediately === void 0) { firstCallImmediately = false; }
    return debounce(timeout, firstCallImmediately, 'throttle');
}
exports.throttle = throttle;


/***/ }),
/* 103 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.idle = void 0;
var tslib_1 = __webpack_require__(7);
var component_1 = __webpack_require__(27);
var helpers_1 = __webpack_require__(19);
function idle() {
    return function (target, propertyKey) {
        if (!helpers_1.isFunction(target[propertyKey])) {
            throw helpers_1.error('Handler must be a Function');
        }
        target.hookStatus(component_1.STATUSES.ready, function (component) {
            var view = helpers_1.isViewObject(component)
                ? component
                : component.jodit;
            var originalMethod = component[propertyKey];
            component[propertyKey] = function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return view.async.requestIdleCallback(originalMethod.bind.apply(originalMethod, tslib_1.__spreadArray([component], args)));
            };
        });
    };
}
exports.idle = idle;


/***/ }),
/* 104 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.hook = void 0;
var helpers_1 = __webpack_require__(19);
function hook(status) {
    return function (target, propertyKey) {
        if (!helpers_1.isFunction(target[propertyKey])) {
            throw helpers_1.error('Handler must be a Function');
        }
        target.hookStatus(status, function (component) {
            target[propertyKey].call(component);
        });
    };
}
exports.hook = hook;


/***/ }),
/* 105 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.nonenumerable = void 0;
var nonenumerable = function (target, propertyKey) {
    var descriptor = Object.getOwnPropertyDescriptor(target, propertyKey) || {};
    if (descriptor.enumerable !== false) {
        Object.defineProperty(target, propertyKey, {
            enumerable: false,
            set: function (value) {
                Object.defineProperty(this, propertyKey, {
                    enumerable: false,
                    writable: true,
                    value: value
                });
            }
        });
    }
};
exports.nonenumerable = nonenumerable;


/***/ }),
/* 106 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.persistent = void 0;
var component_1 = __webpack_require__(27);
var helpers_1 = __webpack_require__(19);
function persistent(target, propertyKey) {
    target.hookStatus(component_1.STATUSES.ready, function (component) {
        var jodit = helpers_1.isViewObject(component)
            ? component
            : component.jodit, storageKey = "" + jodit.options.namespace + component.componentName + "_prop_" + propertyKey, initialValue = component[propertyKey];
        Object.defineProperty(component, propertyKey, {
            get: function () {
                var _a;
                return (_a = jodit.storage.get(storageKey)) !== null && _a !== void 0 ? _a : initialValue;
            },
            set: function (value) {
                jodit.storage.set(storageKey, value);
            }
        });
    });
}
exports.persistent = persistent;


/***/ }),
/* 107 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.wait = void 0;
var helpers_1 = __webpack_require__(19);
var component_1 = __webpack_require__(27);
function wait(condition) {
    return function (target, propertyKey) {
        if (!helpers_1.isFunction(target[propertyKey])) {
            throw helpers_1.error('Handler must be a Function');
        }
        target.hookStatus(component_1.STATUSES.ready, function (component) {
            var async = helpers_1.isViewObject(component)
                ? component.async
                : component.j.async;
            var realMethod = component[propertyKey];
            var timeout = 0;
            component[propertyKey] = function callProxy() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                async.clearTimeout(timeout);
                if (condition(component)) {
                    realMethod.apply(component, args);
                }
                else {
                    timeout = async.setTimeout(function () { return callProxy.apply(void 0, args); }, 10);
                }
            };
        });
    };
}
exports.wait = wait;


/***/ }),
/* 108 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.watch = exports.getPropertyDescriptor = void 0;
var tslib_1 = __webpack_require__(7);
var helpers_1 = __webpack_require__(19);
var events_1 = __webpack_require__(11);
var component_1 = __webpack_require__(27);
function getPropertyDescriptor(obj, prop) {
    var desc;
    do {
        desc = Object.getOwnPropertyDescriptor(obj, prop);
        obj = Object.getPrototypeOf(obj);
    } while (!desc && obj);
    return desc;
}
exports.getPropertyDescriptor = getPropertyDescriptor;
function watch(observeFields, context) {
    return function (target, propertyKey) {
        if (!helpers_1.isFunction(target[propertyKey])) {
            throw helpers_1.error('Handler must be a Function');
        }
        var process = function (component) {
            var callback = function (key) {
                var _a;
                var args = [];
                for (var _i = 1; _i < arguments.length; _i++) {
                    args[_i - 1] = arguments[_i];
                }
                if (!component.isInDestruct) {
                    return (_a = component)[propertyKey].apply(_a, tslib_1.__spreadArray([key], args));
                }
            };
            helpers_1.splitArray(observeFields).forEach(function (field) {
                if (/:/.test(field)) {
                    var _a = field.split(':'), objectPath = _a[0], eventName_1 = _a[1];
                    var view_1 = helpers_1.isViewObject(component)
                        ? component
                        : component.jodit;
                    if (objectPath.length) {
                        context = component.get(objectPath);
                    }
                    if (helpers_1.isFunction(context)) {
                        context = context(component);
                    }
                    view_1.events.on(context || component, eventName_1, callback);
                    if (!context) {
                        view_1.events.on(eventName_1, callback);
                    }
                    view_1.hookStatus('beforeDestruct', function () {
                        view_1.events
                            .off(context || component, eventName_1, callback)
                            .off(eventName_1, callback);
                    });
                    return;
                }
                var parts = field.split('.'), key = parts[0];
                var value = component[key];
                if (value instanceof events_1.ObserveObject) {
                    value.on("change." + field, callback);
                }
                else if (helpers_1.isPlainObject(value) && parts.length > 1) {
                    var observe = events_1.ObserveObject.create(value, [key]);
                    observe.on("change." + field, callback);
                    component[key] = observe;
                }
                else {
                    var descriptor_1 = getPropertyDescriptor(target, key);
                    Object.defineProperty(component, key, {
                        configurable: true,
                        set: function (v) {
                            var oldValue = value;
                            if (oldValue === v) {
                                return;
                            }
                            value = v;
                            if (descriptor_1 && descriptor_1.set) {
                                descriptor_1.set.call(component, v);
                            }
                            if (helpers_1.isPlainObject(value)) {
                                value = events_1.ObserveObject.create(value, [key]);
                                value.on('change.' + field, callback);
                            }
                            callback(key, oldValue, value);
                        },
                        get: function () {
                            if (descriptor_1 && descriptor_1.get) {
                                return descriptor_1.get.call(component);
                            }
                            return value;
                        }
                    });
                }
            });
        };
        if (helpers_1.isFunction(target.hookStatus)) {
            target.hookStatus(component_1.STATUSES.ready, process);
        }
        else {
            process(target);
        }
    };
}
exports.watch = watch;
exports.default = watch;


/***/ }),
/* 109 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.boundClass = exports.boundMethod = void 0;
function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function _typeof(obj) { return typeof obj; };
}
else {
    _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };
} return _typeof(obj); }
function boundMethod(target, key, descriptor) {
    var fn = descriptor.value;
    if (typeof fn !== 'function') {
        throw new TypeError("@boundMethod decorator can only be applied to methods not: ".concat(_typeof(fn)));
    }
    var definingProperty = false;
    return {
        configurable: true,
        get: function get() {
            if (definingProperty || this === target.prototype || this.hasOwnProperty(key) || typeof fn !== 'function') {
                return fn;
            }
            var boundFn = fn.bind(this);
            definingProperty = true;
            Object.defineProperty(this, key, {
                configurable: true,
                get: function get() {
                    return boundFn;
                },
                set: function set(value) {
                    fn = value;
                    delete this[key];
                }
            });
            definingProperty = false;
            return boundFn;
        },
        set: function set(value) {
            fn = value;
        }
    };
}
exports.boundMethod = boundMethod;
function boundClass(target) {
    var keys;
    if (typeof Reflect !== 'undefined' && typeof Reflect.ownKeys === 'function') {
        keys = Reflect.ownKeys(target.prototype);
    }
    else {
        keys = Object.getOwnPropertyNames(target.prototype);
        if (typeof Object.getOwnPropertySymbols === 'function') {
            keys = keys.concat(Object.getOwnPropertySymbols(target.prototype));
        }
    }
    keys.forEach(function (key) {
        if (key === 'constructor') {
            return;
        }
        var descriptor = Object.getOwnPropertyDescriptor(target.prototype, key);
        if (typeof descriptor.value === 'function') {
            Object.defineProperty(target.prototype, key, boundMethod(target, key, descriptor));
        }
    });
    return target;
}
exports.boundClass = boundClass;
function autobind() {
    if (arguments.length === 1) {
        return boundClass.apply(void 0, arguments);
    }
    return boundMethod.apply(void 0, arguments);
}
exports.default = autobind;


/***/ }),
/* 110 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UIGroup = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(111);
var element_1 = __webpack_require__(76);
var decorators_1 = __webpack_require__(99);
var helpers_1 = __webpack_require__(19);
var dom_1 = __webpack_require__(32);
var UIGroup = (function (_super) {
    tslib_1.__extends(UIGroup, _super);
    function UIGroup(jodit, elements, options) {
        var _this = _super.call(this, jodit, options) || this;
        _this.syncMod = false;
        _this.elements = [];
        _this.buttonSize = 'middle';
        elements === null || elements === void 0 ? void 0 : elements.forEach(function (elm) { return elm && _this.append(elm); });
        if (options === null || options === void 0 ? void 0 : options.name) {
            _this.name = options.name;
        }
        return _this;
    }
    UIGroup_1 = UIGroup;
    UIGroup.prototype.className = function () {
        return 'UIGroup';
    };
    Object.defineProperty(UIGroup.prototype, "allChildren", {
        get: function () {
            var result = [];
            var stack = tslib_1.__spreadArray([], this.elements);
            while (stack.length) {
                var elm = stack.shift();
                if (helpers_1.isArray(elm)) {
                    stack.push.apply(stack, elm);
                }
                else if (elm instanceof UIGroup_1) {
                    stack.push.apply(stack, elm.elements);
                }
                else {
                    elm && result.push(elm);
                }
            }
            return result;
        },
        enumerable: false,
        configurable: true
    });
    UIGroup.prototype.update = function () {
        this.elements.forEach(function (elm) { return elm.update(); });
        this.setMod('size', this.buttonSize);
    };
    UIGroup.prototype.append = function (elm, distElement) {
        var _this = this;
        if (helpers_1.isArray(elm)) {
            elm.forEach(function (item) { return _this.append(item); });
            return this;
        }
        this.elements.push(elm);
        if (elm.name) {
            elm.container.classList.add(this.getFullElName(elm.name));
        }
        if (distElement) {
            this.getElm(distElement).appendChild(elm.container);
        }
        else {
            this.appendChildToContainer(elm.container);
        }
        elm.parentElement = this;
        elm.update();
        return this;
    };
    UIGroup.prototype.setMod = function (name, value) {
        if (this.syncMod) {
            this.elements.forEach(function (elm) { return elm.setMod(name, value); });
        }
        return _super.prototype.setMod.call(this, name, value);
    };
    UIGroup.prototype.appendChildToContainer = function (childContainer) {
        this.container.appendChild(childContainer);
    };
    UIGroup.prototype.remove = function (elm) {
        var index = this.elements.indexOf(elm);
        if (index !== -1) {
            this.elements.splice(index, 1);
            dom_1.Dom.safeRemove(elm.container);
            elm.parentElement = null;
        }
        return this;
    };
    UIGroup.prototype.clear = function () {
        this.elements.forEach(function (elm) { return elm.destruct(); });
        this.elements.length = 0;
        return this;
    };
    UIGroup.prototype.destruct = function () {
        this.clear();
        return _super.prototype.destruct.call(this);
    };
    var UIGroup_1;
    tslib_1.__decorate([
        decorators_1.watch('buttonSize')
    ], UIGroup.prototype, "update", null);
    UIGroup = UIGroup_1 = tslib_1.__decorate([
        decorators_1.component
    ], UIGroup);
    return UIGroup;
}(element_1.UIElement));
exports.UIGroup = UIGroup;


/***/ }),
/* 111 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 112 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UISeparator = void 0;
var tslib_1 = __webpack_require__(7);
var element_1 = __webpack_require__(76);
var decorators_1 = __webpack_require__(99);
var UISeparator = (function (_super) {
    tslib_1.__extends(UISeparator, _super);
    function UISeparator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UISeparator.prototype.className = function () {
        return 'UISeparator';
    };
    UISeparator = tslib_1.__decorate([
        decorators_1.component
    ], UISeparator);
    return UISeparator;
}(element_1.UIElement));
exports.UISeparator = UISeparator;


/***/ }),
/* 113 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.flatButtonsSet = exports.isButtonGroup = void 0;
var checker_1 = __webpack_require__(34);
var isButtonGroup = function (item) {
    return checker_1.isArray(item.buttons);
};
exports.isButtonGroup = isButtonGroup;
var flatButtonsSet = function (buttons) {
    return new Set(buttons.reduce(function (acc, item) {
        if (exports.isButtonGroup(item)) {
            acc.push.apply(acc, item.buttons);
        }
        else {
            acc.push(item);
        }
        return acc;
    }, []));
};
exports.flatButtonsSet = flatButtonsSet;


/***/ }),
/* 114 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UIButtonGroup = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(115);
var group_1 = __webpack_require__(110);
var decorators_1 = __webpack_require__(99);
var button_1 = __webpack_require__(93);
var UIButtonGroup = (function (_super) {
    tslib_1.__extends(UIButtonGroup, _super);
    function UIButtonGroup(jodit, options) {
        if (options === void 0) { options = {
            radio: true
        }; }
        var _a, _b;
        var _this = _super.call(this, jodit, (_a = options.options) === null || _a === void 0 ? void 0 : _a.map(function (opt) {
            var btn = new button_1.UIButton(jodit, {
                text: opt.text,
                value: opt.value,
                status: 'primary'
            });
            btn.onAction(function () {
                _this.select(opt.value);
            });
            return btn;
        }), options) || this;
        _this.options = options;
        _this.select((_b = options.value) !== null && _b !== void 0 ? _b : 0);
        return _this;
    }
    UIButtonGroup.prototype.className = function () {
        return 'UIButtonGroup';
    };
    UIButtonGroup.prototype.render = function (options) {
        return "<div>\n\t\t\t<div class=\"&__label\">~" + options.label + "~</div>\n\t\t\t<div class=\"&__options\"></div>\n\t\t</div>";
    };
    UIButtonGroup.prototype.appendChildToContainer = function (childContainer) {
        this.getElm('options').appendChild(childContainer);
    };
    UIButtonGroup.prototype.select = function (indexOrValue) {
        var _this = this;
        var _a, _b;
        this.elements.forEach(function (elm, index) {
            if (index === indexOrValue || elm.state.value === indexOrValue) {
                elm.state.activated = true;
            }
            else if (_this.options.radio) {
                elm.state.activated = false;
            }
        });
        var result = this.elements
            .filter(function (elm) { return elm.state.activated; })
            .map(function (elm) { return ({
            text: elm.state.text,
            value: elm.state.value
        }); });
        this.jodit.e.fire(this, 'select', result);
        (_b = (_a = this.options).onChange) === null || _b === void 0 ? void 0 : _b.call(_a, result);
    };
    UIButtonGroup = tslib_1.__decorate([
        decorators_1.component
    ], UIButtonGroup);
    return UIButtonGroup;
}(group_1.UIGroup));
exports.UIButtonGroup = UIButtonGroup;


/***/ }),
/* 115 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 116 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(117), exports);


/***/ }),
/* 117 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Popup = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(118);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var global_1 = __webpack_require__(30);
var element_1 = __webpack_require__(76);
var decorators_1 = __webpack_require__(99);
var Popup = (function (_super) {
    tslib_1.__extends(Popup, _super);
    function Popup(jodit, smart) {
        if (smart === void 0) { smart = true; }
        var _this = _super.call(this, jodit) || this;
        _this.smart = smart;
        _this.isOpened = false;
        _this.strategy = 'leftBottom';
        _this.viewBound = function () { return ({
            left: 0,
            top: 0,
            width: _this.ow.innerWidth,
            height: _this.ow.innerHeight
        }); };
        _this.childrenPopups = new Set();
        helpers_1.attr(_this.container, 'role', 'popup');
        return _this;
    }
    Popup.prototype.className = function () {
        return 'Popup';
    };
    Popup.prototype.updateParentElement = function (target) {
        var _this = this;
        if (target !== this && target instanceof Popup) {
            this.childrenPopups.forEach(function (popup) {
                if (!target.closest(popup) && popup.isOpened) {
                    popup.close();
                }
            });
            if (!this.childrenPopups.has(target)) {
                this.j.e.on(target, 'beforeClose', function () {
                    _this.childrenPopups.delete(target);
                });
            }
            this.childrenPopups.add(target);
        }
        return _super.prototype.updateParentElement.call(this, target);
    };
    Popup.prototype.setContent = function (content) {
        dom_1.Dom.detach(this.container);
        var box = this.j.c.div(this.componentName + "__content");
        var elm;
        if (content instanceof element_1.UIElement) {
            elm = content.container;
            content.parentElement = this;
        }
        else if (helpers_1.isString(content)) {
            elm = this.j.c.fromHTML(content);
        }
        else {
            elm = content;
        }
        box.appendChild(elm);
        this.container.appendChild(box);
        this.updatePosition();
        return this;
    };
    Popup.prototype.open = function (getBound, keepPosition) {
        if (keepPosition === void 0) { keepPosition = false; }
        helpers_1.markOwner(this.jodit, this.container);
        this.isOpened = true;
        this.addGlobalListeners();
        this.targetBound = !keepPosition
            ? getBound
            : this.getKeepBound(getBound);
        var parentContainer = global_1.getContainer(this.jodit, Popup);
        if (parentContainer !== this.container.parentElement) {
            parentContainer.appendChild(this.container);
        }
        this.updatePosition();
        this.j.e.fire(this, 'afterOpen');
        return this;
    };
    Popup.prototype.getKeepBound = function (getBound) {
        var _this = this;
        var oldBound = getBound();
        var elmUnderCursor = this.od.elementFromPoint(oldBound.left, oldBound.top);
        if (!elmUnderCursor) {
            return getBound;
        }
        var element = dom_1.Dom.isHTMLElement(elmUnderCursor, this.ow)
            ? elmUnderCursor
            : elmUnderCursor.parentElement;
        var oldPos = helpers_1.position(element, this.j);
        return function () {
            var bound = getBound();
            var newPos = helpers_1.position(element, _this.j);
            return tslib_1.__assign(tslib_1.__assign({}, bound), { top: bound.top + (newPos.top - oldPos.top), left: bound.left + (newPos.left - oldPos.left) });
        };
    };
    Popup.prototype.updatePosition = function () {
        if (!this.isOpened) {
            return this;
        }
        var _a = this.calculatePosition(this.targetBound(), this.viewBound(), helpers_1.position(this.container, this.j)), pos = _a[0], strategy = _a[1];
        this.setMod('strategy', strategy);
        helpers_1.css(this.container, {
            left: pos.left,
            top: pos.top
        });
        this.childrenPopups.forEach(function (popup) { return popup.updatePosition(); });
        return this;
    };
    Popup.prototype.calculatePosition = function (target, view, container, defaultStrategy) {
        if (defaultStrategy === void 0) { defaultStrategy = this.strategy; }
        var x = {
            left: target.left,
            right: target.left - (container.width - target.width)
        }, y = {
            bottom: target.top + target.height,
            top: target.top - container.height
        };
        var list = Object.keys(x).reduce(function (keys, xKey) {
            return keys.concat(Object.keys(y).map(function (yKey) { return "" + xKey + helpers_1.ucfirst(yKey); }));
        }, []);
        var getPointByStrategy = function (strategy) {
            var _a = helpers_1.kebabCase(strategy).split('-'), xKey = _a[0], yKey = _a[1];
            return {
                left: x[xKey],
                top: y[yKey],
                width: container.width,
                height: container.height
            };
        };
        var getMatchStrategy = function (inBox) {
            var strategy = null;
            if (Popup.boxInView(getPointByStrategy(defaultStrategy), inBox)) {
                strategy = defaultStrategy;
            }
            else {
                strategy =
                    list.find(function (key) {
                        if (Popup.boxInView(getPointByStrategy(key), inBox)) {
                            return key;
                        }
                        return;
                    }) || null;
            }
            return strategy;
        };
        var strategy = getMatchStrategy(helpers_1.position(this.j.container, this.j));
        if (!strategy || !Popup.boxInView(getPointByStrategy(strategy), view)) {
            strategy = getMatchStrategy(view) || strategy || defaultStrategy;
        }
        return [getPointByStrategy(strategy), strategy];
    };
    Popup.boxInView = function (box, view) {
        var accuracy = 2;
        return (box.top - view.top >= -accuracy &&
            box.left - view.left >= -accuracy &&
            view.top + view.height - (box.top + box.height) >= -accuracy &&
            view.left + view.width - (box.left + box.width) >= -accuracy);
    };
    Popup.prototype.close = function () {
        if (!this.isOpened) {
            return this;
        }
        this.isOpened = false;
        this.childrenPopups.forEach(function (popup) { return popup.close(); });
        this.j.e.fire(this, 'beforeClose');
        this.j.e.fire('beforePopupClose', this);
        this.removeGlobalListeners();
        dom_1.Dom.safeRemove(this.container);
        return this;
    };
    Popup.prototype.closeOnOutsideClick = function (e) {
        if (!this.isOpened) {
            return;
        }
        if (!e.target) {
            this.close();
            return;
        }
        var box = element_1.UIElement.closestElement(e.target, Popup);
        if (box && (this === box || box.closest(this))) {
            return;
        }
        this.close();
    };
    Popup.prototype.addGlobalListeners = function () {
        var up = this.updatePosition, ow = this.ow;
        global_1.eventEmitter.on('closeAllPopups', this.close);
        if (this.smart) {
            this.j.e
                .on('escape', this.close)
                .on('mousedown touchstart', this.closeOnOutsideClick)
                .on(ow, 'mousedown touchstart', this.closeOnOutsideClick);
        }
        this.j.e
            .on('closeAllPopups', this.close)
            .on('resize', up)
            .on(this.container, 'scroll mousewheel', up)
            .on(ow, 'scroll', up)
            .on(ow, 'resize', up);
    };
    Popup.prototype.removeGlobalListeners = function () {
        var up = this.updatePosition, ow = this.ow;
        global_1.eventEmitter.off('closeAllPopups', this.close);
        if (this.smart) {
            this.j.e
                .off('escape', this.close)
                .off('mousedown touchstart', this.closeOnOutsideClick)
                .off(ow, 'mousedown touchstart', this.closeOnOutsideClick);
        }
        this.j.e
            .off('closeAllPopups', this.close)
            .off('resize', up)
            .off(this.container, 'scroll mousewheel', up)
            .off(ow, 'scroll', up)
            .off(ow, 'resize', up);
    };
    Popup.prototype.setZIndex = function (index) {
        this.container.style.zIndex = index.toString();
    };
    Popup.prototype.destruct = function () {
        this.close();
        return _super.prototype.destruct.call(this);
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], Popup.prototype, "updatePosition", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], Popup.prototype, "close", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], Popup.prototype, "closeOnOutsideClick", null);
    return Popup;
}(element_1.UIElement));
exports.Popup = Popup;


/***/ }),
/* 118 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 119 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(120), exports);
tslib_1.__exportStar(__webpack_require__(121), exports);
tslib_1.__exportStar(__webpack_require__(135), exports);


/***/ }),
/* 120 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UIForm = void 0;
var tslib_1 = __webpack_require__(7);
var group_1 = __webpack_require__(110);
var inputs_1 = __webpack_require__(121);
var utils_1 = __webpack_require__(20);
var decorators_1 = __webpack_require__(99);
var UIForm = (function (_super) {
    tslib_1.__extends(UIForm, _super);
    function UIForm() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UIForm.prototype.className = function () {
        return 'UIForm';
    };
    UIForm.prototype.submit = function () {
        this.j.e.fire(this.container, 'submit');
    };
    UIForm.prototype.validate = function () {
        var inputs = this.allChildren.filter(function (elm) { return elm instanceof inputs_1.UIInput; });
        for (var _i = 0, inputs_2 = inputs; _i < inputs_2.length; _i++) {
            var input = inputs_2[_i];
            if (!input.validate()) {
                return false;
            }
        }
        var selects = this.allChildren.filter(function (elm) { return elm instanceof inputs_1.UISelect; });
        for (var _a = 0, selects_1 = selects; _a < selects_1.length; _a++) {
            var select = selects_1[_a];
            if (!select.validate()) {
                return false;
            }
        }
        return true;
    };
    UIForm.prototype.onSubmit = function (handler) {
        var _this = this;
        this.j.e.on(this.container, 'submit', function () {
            var inputs = _this.allChildren.filter(function (elm) { return elm instanceof inputs_1.UIInput; });
            if (!_this.validate()) {
                return false;
            }
            handler(inputs.reduce(function (res, item) {
                res[item.state.name] = item.value;
                return res;
            }, {}));
            return false;
        });
    };
    UIForm.prototype.createContainer = function () {
        var form = this.j.c.element('form');
        form.classList.add(this.componentName);
        utils_1.attr(form, 'dir', this.j.o.direction || 'auto');
        return form;
    };
    UIForm = tslib_1.__decorate([
        decorators_1.component
    ], UIForm);
    return UIForm;
}(group_1.UIGroup));
exports.UIForm = UIForm;


/***/ }),
/* 121 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(122), exports);
tslib_1.__exportStar(__webpack_require__(127), exports);
tslib_1.__exportStar(__webpack_require__(129), exports);
tslib_1.__exportStar(__webpack_require__(131), exports);
tslib_1.__exportStar(__webpack_require__(133), exports);


/***/ }),
/* 122 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UIInput = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(123);
var element_1 = __webpack_require__(76);
var helpers_1 = __webpack_require__(19);
var dom_1 = __webpack_require__(32);
var decorators_1 = __webpack_require__(99);
var icon_1 = __webpack_require__(80);
var validators_1 = __webpack_require__(124);
var UIInput = (function (_super) {
    tslib_1.__extends(UIInput, _super);
    function UIInput(jodit, options) {
        var _this = _super.call(this, jodit, options) || this;
        _this.label = _this.j.c.span(_this.getFullElName('label'));
        _this.icon = _this.j.c.span(_this.getFullElName('icon'));
        _this.clearButton = _this.j.c.span(_this.getFullElName('clear'), icon_1.Icon.get('cancel'));
        _this.state = tslib_1.__assign({}, UIInput_1.defaultState);
        _this.__errorBox = _this.j.c.span(_this.getFullElName('error'));
        _this.validators = new Set([]);
        Object.assign(_this.state, options);
        if (_this.state.clearButton !== undefined) {
            _this.j.e
                .on(_this.clearButton, 'click', function (e) {
                e.preventDefault();
                _this.nativeInput.value = '';
                _this.j.e.fire(_this.nativeInput, 'input');
                _this.focus();
            })
                .on(_this.nativeInput, 'input', function () {
                _this.state.clearButton = Boolean(_this.value.length);
            });
            _this.state.clearButton = Boolean(_this.value.length);
        }
        _this.j.e
            .on(_this.nativeInput, 'focus blur', function () {
            _this.onChangeFocus();
        })
            .on(_this.nativeInput, 'input change', _this.onChangeValue);
        _this.onChangeState();
        _this.onChangeClassName();
        _this.onChangeStateValue();
        return _this;
    }
    UIInput_1 = UIInput;
    UIInput.prototype.className = function () {
        return 'UIInput';
    };
    UIInput.prototype.onChangeClear = function () {
        if (this.state.clearButton) {
            dom_1.Dom.after(this.nativeInput, this.clearButton);
        }
        else {
            dom_1.Dom.safeRemove(this.clearButton);
        }
    };
    UIInput.prototype.onChangeClassName = function (ignore, oldClassName) {
        oldClassName && this.container.classList.remove(oldClassName);
        this.state.className &&
            this.container.classList.add(this.state.className);
    };
    UIInput.prototype.onChangeState = function () {
        this.name = this.state.name;
        var input = this.nativeInput, _a = this.state, name = _a.name, icon = _a.icon, type = _a.type, ref = _a.ref, required = _a.required, placeholder = _a.placeholder, autocomplete = _a.autocomplete, label = _a.label;
        helpers_1.attr(input, 'name', name);
        helpers_1.attr(input, 'type', type);
        helpers_1.attr(input, 'data-ref', ref || name);
        helpers_1.attr(input, 'ref', ref || name);
        helpers_1.attr(input, 'required', required || null);
        helpers_1.attr(input, 'autocomplete', !autocomplete ? 'off' : null);
        helpers_1.attr(input, 'placeholder', placeholder ? this.j.i18n(placeholder) : '');
        if (icon && icon_1.Icon.exists(icon)) {
            dom_1.Dom.before(input, this.icon);
            this.icon.innerHTML = icon_1.Icon.get(icon);
        }
        else {
            dom_1.Dom.safeRemove(this.icon);
        }
        if (label) {
            dom_1.Dom.before(this.wrapper, this.label);
            this.label.innerText = this.j.i18n(label);
        }
        else {
            dom_1.Dom.safeRemove(this.label);
        }
        this.updateValidators();
    };
    UIInput.prototype.updateValidators = function () {
        var _this = this;
        var _a;
        this.validators.clear();
        if (this.state.required) {
            this.validators.add(validators_1.inputValidators.required);
        }
        (_a = this.state.validators) === null || _a === void 0 ? void 0 : _a.forEach(function (name) {
            var validator = validators_1.inputValidators[name];
            validator && _this.validators.add(validator);
        });
    };
    Object.defineProperty(UIInput.prototype, "error", {
        set: function (value) {
            this.setMod('has-error', Boolean(value));
            if (!value) {
                dom_1.Dom.safeRemove(this.__errorBox);
            }
            else {
                this.__errorBox.innerText = this.j.i18n(value, this.j.i18n(this.state.label || ''));
                this.container.appendChild(this.__errorBox);
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(UIInput.prototype, "value", {
        get: function () {
            return this.nativeInput.value;
        },
        set: function (value) {
            if (this.value !== value) {
                this.nativeInput.value = value;
                this.onChangeValue();
            }
        },
        enumerable: false,
        configurable: true
    });
    UIInput.prototype.onChangeStateValue = function () {
        this.value = this.state.value;
    };
    UIInput.prototype.onChangeValue = function () {
        var _a, _b;
        var value = this.value;
        this.state.value = value;
        this.j.e.fire(this, 'change', value);
        (_b = (_a = this.state).onChange) === null || _b === void 0 ? void 0 : _b.call(_a, value);
    };
    UIInput.prototype.validate = function () {
        var _this = this;
        this.error = '';
        return helpers_1.toArray(this.validators).every(function (validator) { return validator(_this); });
    };
    UIInput.prototype.createContainer = function (options) {
        var container = _super.prototype.createContainer.call(this);
        this.wrapper = this.j.c.div(this.getFullElName('wrapper'));
        if (!this.nativeInput) {
            this.nativeInput = this.createNativeInput(options);
        }
        var nativeInput = this.nativeInput;
        nativeInput.classList.add(this.getFullElName('input'));
        this.wrapper.appendChild(nativeInput);
        container.appendChild(this.wrapper);
        helpers_1.attr(nativeInput, 'dir', this.j.o.direction || 'auto');
        return container;
    };
    UIInput.prototype.createNativeInput = function (options) {
        return this.j.create.element('input');
    };
    UIInput.prototype.focus = function () {
        this.nativeInput.focus();
    };
    Object.defineProperty(UIInput.prototype, "isFocused", {
        get: function () {
            return this.nativeInput === this.j.od.activeElement;
        },
        enumerable: false,
        configurable: true
    });
    UIInput.prototype.onChangeFocus = function () {
        this.setMod('focused', this.isFocused);
    };
    var UIInput_1;
    UIInput.defaultState = {
        className: '',
        autocomplete: true,
        name: '',
        value: '',
        icon: '',
        label: '',
        ref: '',
        type: 'text',
        placeholder: '',
        required: false,
        validators: []
    };
    tslib_1.__decorate([
        decorators_1.watch('state.clearButton')
    ], UIInput.prototype, "onChangeClear", null);
    tslib_1.__decorate([
        decorators_1.watch('state.className')
    ], UIInput.prototype, "onChangeClassName", null);
    tslib_1.__decorate([
        decorators_1.watch([
            'state.name',
            'state.type',
            'state.label',
            'state.placeholder',
            'state.autocomplete',
            'state.icon'
        ]),
        decorators_1.debounce()
    ], UIInput.prototype, "onChangeState", null);
    tslib_1.__decorate([
        decorators_1.watch('state.value')
    ], UIInput.prototype, "onChangeStateValue", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], UIInput.prototype, "onChangeValue", null);
    UIInput = UIInput_1 = tslib_1.__decorate([
        decorators_1.component
    ], UIInput);
    return UIInput;
}(element_1.UIElement));
exports.UIInput = UIInput;


/***/ }),
/* 123 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 124 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.selectValidators = exports.inputValidators = void 0;
exports.inputValidators = __webpack_require__(125);
exports.selectValidators = __webpack_require__(126);


/***/ }),
/* 125 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.url = exports.required = void 0;
var helpers_1 = __webpack_require__(19);
exports.required = function (input) {
    if (!helpers_1.trim(input.value).length) {
        input.error = 'Please fill out this field';
        return false;
    }
    return true;
};
exports.url = function (input) {
    if (!helpers_1.isURL(helpers_1.trim(input.value))) {
        input.error = 'Please enter a web address';
        return false;
    }
    return true;
};


/***/ }),
/* 126 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.required = void 0;
var helpers_1 = __webpack_require__(19);
exports.required = function (select) {
    if (!helpers_1.trim(select.value).length) {
        select.error = 'Please fill out this field';
        return false;
    }
    return true;
};


/***/ }),
/* 127 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UITextArea = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(128);
var input_1 = __webpack_require__(122);
var decorators_1 = __webpack_require__(99);
var UITextArea = (function (_super) {
    tslib_1.__extends(UITextArea, _super);
    function UITextArea() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UITextArea.prototype.className = function () {
        return 'UITextArea';
    };
    UITextArea.prototype.createContainer = function (options) {
        this.nativeInput = this.j.create.element('textarea');
        return _super.prototype.createContainer.call(this, options);
    };
    UITextArea = tslib_1.__decorate([
        decorators_1.component
    ], UITextArea);
    return UITextArea;
}(input_1.UIInput));
exports.UITextArea = UITextArea;


/***/ }),
/* 128 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 129 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UICheckbox = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(130);
var input_1 = __webpack_require__(122);
var decorators_1 = __webpack_require__(99);
var UICheckbox = (function (_super) {
    tslib_1.__extends(UICheckbox, _super);
    function UICheckbox(jodit, options) {
        return _super.call(this, jodit, tslib_1.__assign(tslib_1.__assign({}, options), { type: 'checkbox' })) || this;
    }
    UICheckbox.prototype.className = function () {
        return 'UICheckbox';
    };
    UICheckbox.prototype.render = function (options) {
        return this.j.c.element('label', {
            className: this.componentName
        });
    };
    UICheckbox = tslib_1.__decorate([
        decorators_1.component
    ], UICheckbox);
    return UICheckbox;
}(input_1.UIInput));
exports.UICheckbox = UICheckbox;


/***/ }),
/* 130 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 131 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UISelect = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(132);
var helpers_1 = __webpack_require__(19);
var decorators_1 = __webpack_require__(99);
var input_1 = __webpack_require__(122);
var validators_1 = __webpack_require__(124);
var UISelect = (function (_super) {
    tslib_1.__extends(UISelect, _super);
    function UISelect(jodit, state) {
        var _this = _super.call(this, jodit, state) || this;
        _this.state = tslib_1.__assign({}, UISelect_1.defaultState);
        Object.assign(_this.state, state);
        return _this;
    }
    UISelect_1 = UISelect;
    UISelect.prototype.className = function () {
        return 'UISelect';
    };
    UISelect.prototype.createContainer = function (state) {
        var _a;
        var container = _super.prototype.createContainer.call(this, state);
        var j = this.j, nativeInput = this.nativeInput;
        var opt = function () { return j.create.element('option'); };
        if (state.placeholder !== undefined) {
            var option = opt();
            option.value = '';
            option.text = j.i18n(state.placeholder);
            nativeInput.add(option);
        }
        (_a = state.options) === null || _a === void 0 ? void 0 : _a.forEach(function (element) {
            var option = opt();
            option.value = element.value.toString();
            option.text = j.i18n(element.text);
            nativeInput.add(option);
        });
        if (state.size && state.size > 0) {
            helpers_1.attr(nativeInput, 'size', state.size);
        }
        if (state.multiple) {
            helpers_1.attr(nativeInput, 'multiple', '');
        }
        return container;
    };
    UISelect.prototype.createNativeInput = function () {
        return this.j.create.element('select');
    };
    UISelect.prototype.updateValidators = function () {
        _super.prototype.updateValidators.call(this);
        if (this.state.required) {
            this.validators.delete(validators_1.inputValidators.required);
            this.validators.add(validators_1.selectValidators.required);
        }
    };
    var UISelect_1;
    UISelect.defaultState = tslib_1.__assign(tslib_1.__assign({}, input_1.UIInput.defaultState), { options: [], size: 1, multiple: false });
    UISelect = UISelect_1 = tslib_1.__decorate([
        decorators_1.component
    ], UISelect);
    return UISelect;
}(input_1.UIInput));
exports.UISelect = UISelect;


/***/ }),
/* 132 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 133 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UIFileInput = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(134);
var input_1 = __webpack_require__(122);
var decorators_1 = __webpack_require__(99);
var button_1 = __webpack_require__(92);
var UIFileInput = (function (_super) {
    tslib_1.__extends(UIFileInput, _super);
    function UIFileInput(jodit, options) {
        var _this = _super.call(this, jodit, tslib_1.__assign({ type: 'file' }, options)) || this;
        _this.state = tslib_1.__assign(tslib_1.__assign({}, input_1.UIInput.defaultState), { type: 'file', onlyImages: true });
        return _this;
    }
    UIFileInput.prototype.className = function () {
        return 'UIFileInput';
    };
    UIFileInput.prototype.createContainer = function (options) {
        this.button = new button_1.UIButton(this.j, {
            icon: {
                name: 'plus'
            }
        });
        var container = this.button.container;
        if (!this.nativeInput) {
            this.nativeInput = this.createNativeInput(options);
        }
        var nativeInput = this.nativeInput;
        nativeInput.classList.add(this.getFullElName('input'));
        container.classList.add(this.componentName);
        container.appendChild(nativeInput);
        return container;
    };
    UIFileInput.prototype.createNativeInput = function (options) {
        return this.j.create.fromHTML("<input\n\t\t\ttype=\"file\"\n\t\t\taccept=\"" + (options.onlyImages ? 'image/*' : '*') + "\"\n\t\t\ttabindex=\"-1\"\n\t\t\tdir=\"auto\"\n\t\t\tmultiple=\"\"\n\t\t/>");
    };
    UIFileInput = tslib_1.__decorate([
        decorators_1.component
    ], UIFileInput);
    return UIFileInput;
}(input_1.UIInput));
exports.UIFileInput = UIFileInput;


/***/ }),
/* 134 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 135 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UIBlock = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(136);
var group_1 = __webpack_require__(110);
var utils_1 = __webpack_require__(20);
var decorators_1 = __webpack_require__(99);
var UIBlock = (function (_super) {
    tslib_1.__extends(UIBlock, _super);
    function UIBlock(jodit, elements, options) {
        if (options === void 0) { options = {
            align: 'left'
        }; }
        var _this = _super.call(this, jodit, elements) || this;
        _this.options = options;
        _this.setMod('align', _this.options.align || 'left');
        _this.setMod('width', _this.options.width || '');
        _this.options.mod && _this.setMod(_this.options.mod, true);
        utils_1.attr(_this.container, 'data-ref', options.ref);
        utils_1.attr(_this.container, 'ref', options.ref);
        return _this;
    }
    UIBlock.prototype.className = function () {
        return 'UIBlock';
    };
    UIBlock = tslib_1.__decorate([
        decorators_1.component
    ], UIBlock);
    return UIBlock;
}(group_1.UIGroup));
exports.UIBlock = UIBlock;


/***/ }),
/* 136 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 137 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ProgressBar = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(138);
var dom_1 = __webpack_require__(32);
var element_1 = __webpack_require__(76);
var ProgressBar = (function (_super) {
    tslib_1.__extends(ProgressBar, _super);
    function ProgressBar() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ProgressBar.prototype.className = function () {
        return 'ProgressBar';
    };
    ProgressBar.prototype.render = function () {
        return '<div><div></div></div>';
    };
    ProgressBar.prototype.show = function () {
        var container = this.j.workplace || this.j.container;
        container.appendChild(this.container);
        return this;
    };
    ProgressBar.prototype.hide = function () {
        dom_1.Dom.safeRemove(this.container);
        return this;
    };
    ProgressBar.prototype.progress = function (percentage) {
        this.container.style.width = percentage.toFixed(2) + '%';
        return this;
    };
    ProgressBar.prototype.destruct = function () {
        this.hide();
        return _super.prototype.destruct.call(this);
    };
    return ProgressBar;
}(element_1.UIElement));
exports.ProgressBar = ProgressBar;


/***/ }),
/* 138 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 139 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.cleanFromWord = void 0;
var dom_1 = __webpack_require__(32);
var string_1 = __webpack_require__(68);
var array_1 = __webpack_require__(55);
function cleanFromWord(html) {
    if (html.indexOf('<html ') !== -1) {
        html = html.substring(html.indexOf('<html '), html.length);
        html = html.substring(0, html.lastIndexOf('</html>') + '</html>'.length);
    }
    var convertedString = '';
    try {
        var div = document.createElement('div');
        div.innerHTML = html;
        var marks_1 = [];
        if (div.firstChild) {
            dom_1.Dom.all(div, function (node) {
                if (!node) {
                    return;
                }
                switch (node.nodeType) {
                    case Node.ELEMENT_NODE:
                        switch (node.nodeName) {
                            case 'STYLE':
                            case 'LINK':
                            case 'META':
                                marks_1.push(node);
                                break;
                            case 'W:SDT':
                            case 'W:SDTPR':
                            case 'FONT':
                                dom_1.Dom.unwrap(node);
                                break;
                            default:
                                array_1.toArray(node.attributes).forEach(function (attr) {
                                    if ([
                                        'src',
                                        'href',
                                        'rel',
                                        'content'
                                    ].indexOf(attr.name.toLowerCase()) === -1) {
                                        node.removeAttribute(attr.name);
                                    }
                                });
                        }
                        break;
                    case Node.TEXT_NODE:
                        break;
                    default:
                        marks_1.push(node);
                }
            });
        }
        marks_1.forEach(dom_1.Dom.safeRemove);
        convertedString = div.innerHTML;
    }
    catch (e) { }
    if (convertedString) {
        html = convertedString;
    }
    html = html.split(/(\n)/).filter(string_1.trim).join('\n');
    return html
        .replace(/<(\/)?(html|colgroup|col|o:p)[^>]*>/g, '')
        .replace(/<!--[^>]*>/g, '');
}
exports.cleanFromWord = cleanFromWord;


/***/ }),
/* 140 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.htmlspecialchars = void 0;
function htmlspecialchars(html) {
    var tmp = document.createElement('div');
    tmp.textContent = html;
    return tmp.innerHTML;
}
exports.htmlspecialchars = htmlspecialchars;


/***/ }),
/* 141 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.stripTags = void 0;
var checker_1 = __webpack_require__(34);
var selector_1 = __webpack_require__(67);
var string_1 = __webpack_require__(68);
var dom_1 = __webpack_require__(32);
function stripTags(html, doc) {
    if (doc === void 0) { doc = document; }
    var tmp = doc.createElement('div');
    if (checker_1.isString(html)) {
        tmp.innerHTML = html;
    }
    else {
        tmp.appendChild(html);
    }
    selector_1.$$('DIV, P, BR, H1, H2, H3, H4, H5, H6, HR', tmp).forEach(function (p) {
        var pr = p.parentNode;
        if (!pr) {
            return;
        }
        var nx = p.nextSibling;
        if (dom_1.Dom.isText(nx) && /^\s/.test(nx.nodeValue || '')) {
            return;
        }
        if (nx) {
            pr.insertBefore(doc.createTextNode(' '), nx);
        }
    });
    return string_1.trim(tmp.innerText) || '';
}
exports.stripTags = stripTags;


/***/ }),
/* 142 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.nl2br = void 0;
function nl2br(html) {
    return html.replace(/([^>])([\n\r]+)/g, '$1<br/>$2');
}
exports.nl2br = nl2br;


/***/ }),
/* 143 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(144), exports);
tslib_1.__exportStar(__webpack_require__(145), exports);
tslib_1.__exportStar(__webpack_require__(146), exports);
tslib_1.__exportStar(__webpack_require__(147), exports);


/***/ }),
/* 144 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getContentWidth = void 0;
var getContentWidth = function (element, win) {
    var pi = function (value) { return parseInt(value, 10); }, style = win.getComputedStyle(element), width = element.offsetWidth, paddingLeft = pi(style.getPropertyValue('padding-left') || '0'), paddingRight = pi(style.getPropertyValue('padding-right') || '0');
    return width - paddingLeft - paddingRight;
};
exports.getContentWidth = getContentWidth;


/***/ }),
/* 145 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.innerWidth = void 0;
var innerWidth = function (element, win) {
    var computedStyle = win.getComputedStyle(element);
    var elementWidth = element.clientWidth;
    elementWidth -=
        parseFloat(computedStyle.paddingLeft || '0') +
            parseFloat(computedStyle.paddingRight || '0');
    return elementWidth;
};
exports.innerWidth = innerWidth;


/***/ }),
/* 146 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.offset = void 0;
var offset = function (elm, jodit, doc, recurse) {
    if (recurse === void 0) { recurse = false; }
    var rect;
    try {
        rect = elm.getBoundingClientRect();
    }
    catch (e) {
        rect = {
            top: 0,
            bottom: 0,
            left: 0,
            right: 0,
            width: 0,
            height: 0
        };
    }
    var body = doc.body, docElem = doc.documentElement || {
        clientTop: 0,
        clientLeft: 0,
        scrollTop: 0,
        scrollLeft: 0
    }, win = doc.defaultView || doc.parentWindow, scrollTop = win.pageYOffset || docElem.scrollTop || body.scrollTop, scrollLeft = win.pageXOffset || docElem.scrollLeft || body.scrollLeft, clientTop = docElem.clientTop || body.clientTop || 0, clientLeft = docElem.clientLeft || body.clientLeft || 0;
    var topValue, leftValue;
    var iframe = jodit.iframe;
    if (!recurse && jodit && jodit.options && jodit.o.iframe && iframe) {
        var _a = exports.offset(iframe, jodit, jodit.od, true), top_1 = _a.top, left = _a.left;
        topValue = rect.top + top_1;
        leftValue = rect.left + left;
    }
    else {
        topValue = rect.top + scrollTop - clientTop;
        leftValue = rect.left + scrollLeft - clientLeft;
    }
    return {
        top: Math.round(topValue),
        left: Math.round(leftValue),
        width: rect.width,
        height: rect.height
    };
};
exports.offset = offset;


/***/ }),
/* 147 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.position = void 0;
var checker_1 = __webpack_require__(34);
function position(elm, jodit, recurse) {
    if (recurse === void 0) { recurse = false; }
    var rect = elm.getBoundingClientRect();
    var xPos = rect.left, yPos = rect.top;
    if (checker_1.isJoditObject(jodit) && jodit.iframe && !recurse) {
        var _a = position(jodit.iframe, jodit, true), left = _a.left, top_1 = _a.top;
        xPos += left;
        yPos += top_1;
    }
    return {
        left: Math.round(xPos),
        top: Math.round(yPos),
        width: Math.round(elm.offsetWidth),
        height: Math.round(elm.offsetHeight)
    };
}
exports.position = position;


/***/ }),
/* 148 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.loadNext = exports.appendStyleAsync = exports.appendScriptAsync = exports.appendScript = void 0;
var tslib_1 = __webpack_require__(7);
var complete_url_1 = __webpack_require__(149);
var checker_1 = __webpack_require__(34);
var alreadyLoadedList = new Map();
var cacheLoaders = function (loader) {
    return function (jodit, url) { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
        var promise;
        return tslib_1.__generator(this, function (_a) {
            if (alreadyLoadedList.has(url)) {
                return [2, alreadyLoadedList.get(url)];
            }
            promise = loader(jodit, url);
            alreadyLoadedList.set(url, promise);
            return [2, promise];
        });
    }); };
};
var appendScript = function (jodit, url, callback) {
    var script = jodit.c.element('script');
    script.type = 'text/javascript';
    script.async = true;
    if (checker_1.isFunction(callback) && !jodit.isInDestruct) {
        jodit.e.on(script, 'load', callback);
    }
    if (!script.src) {
        script.src = complete_url_1.completeUrl(url);
    }
    jodit.od.body.appendChild(script);
    return {
        callback: callback,
        element: script
    };
};
exports.appendScript = appendScript;
exports.appendScriptAsync = cacheLoaders(function (jodit, url) {
    return new Promise(function (resolve, reject) {
        var element = exports.appendScript(jodit, url, resolve).element;
        !jodit.isInDestruct && jodit.e.on(element, 'error', reject);
    });
});
exports.appendStyleAsync = cacheLoaders(function (jodit, url) {
    return new Promise(function (resolve, reject) {
        var link = jodit.c.element('link');
        link.rel = 'stylesheet';
        link.media = 'all';
        link.crossOrigin = 'anonymous';
        var callback = function () { return resolve(link); };
        !jodit.isInDestruct &&
            jodit.e.on(link, 'load', callback).on(link, 'error', reject);
        link.href = complete_url_1.completeUrl(url);
        if (jodit.o.shadowRoot) {
            jodit.o.shadowRoot.appendChild(link);
        }
        else {
            jodit.od.body.appendChild(link);
        }
    });
});
var loadNext = function (jodit, urls, i) {
    if (i === void 0) { i = 0; }
    if (!checker_1.isString(urls[i])) {
        return Promise.resolve();
    }
    return exports.appendScriptAsync(jodit, urls[i]).then(function () {
        return exports.loadNext(jodit, urls, i + 1);
    });
};
exports.loadNext = loadNext;


/***/ }),
/* 149 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.completeUrl = void 0;
var completeUrl = function (url) {
    if (window.location.protocol === 'file:' && /^\/\//.test(url)) {
        url = 'https:' + url;
    }
    return url;
};
exports.completeUrl = completeUrl;


/***/ }),
/* 150 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.browser = void 0;
var browser = function (browser) {
    var ua = navigator.userAgent.toLowerCase(), match = /(firefox)[\s/]([\w.]+)/.exec(ua) ||
        /(chrome)[\s/]([\w.]+)/.exec(ua) ||
        /(webkit)[\s/]([\w.]+)/.exec(ua) ||
        /(opera)(?:.*version)[\s/]([\w.]+)/.exec(ua) ||
        /(msie)[\s]([\w.]+)/.exec(ua) ||
        /(trident)\/([\w.]+)/.exec(ua) ||
        ua.indexOf('compatible') < 0 ||
        [];
    if (browser === 'version') {
        return match[2];
    }
    if (browser === 'webkit') {
        return match[1] === 'chrome' || match[1] === 'webkit';
    }
    if (browser === 'ff') {
        return match[1] === 'firefox';
    }
    if (browser === 'msie') {
        return match[1] === 'trident' || match[1] === 'msie';
    }
    return match[1] === browser;
};
exports.browser = browser;


/***/ }),
/* 151 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.convertMediaUrlToVideoEmbed = void 0;
var checker_1 = __webpack_require__(34);
var parse_query_1 = __webpack_require__(152);
var convertMediaUrlToVideoEmbed = function (url, width, height) {
    if (width === void 0) { width = 400; }
    if (height === void 0) { height = 345; }
    if (!checker_1.isURL(url)) {
        return url;
    }
    var parser = document.createElement('a'), pattern1 = /(?:http?s?:\/\/)?(?:www\.)?(?:vimeo\.com)\/?(.+)/g;
    parser.href = url;
    if (!width) {
        width = 400;
    }
    if (!height) {
        height = 345;
    }
    var protocol = parser.protocol || '';
    switch (parser.hostname) {
        case 'www.vimeo.com':
        case 'vimeo.com':
            return pattern1.test(url)
                ? url.replace(pattern1, '<iframe width="' +
                    width +
                    '" height="' +
                    height +
                    '" src="' +
                    protocol +
                    '//player.vimeo.com/video/$1" frameborder="0" allowfullscreen></iframe>')
                : url;
        case 'youtube.com':
        case 'www.youtube.com':
        case 'youtu.be':
        case 'www.youtu.be': {
            var query = parser.search
                ? parse_query_1.parseQuery(parser.search)
                : { v: parser.pathname.substr(1) };
            return query.v
                ? '<iframe width="' +
                    width +
                    '" height="' +
                    height +
                    '" src="' +
                    protocol +
                    '//www.youtube.com/embed/' +
                    query.v +
                    '" frameborder="0" allowfullscreen></iframe>'
                : url;
        }
    }
    return url;
};
exports.convertMediaUrlToVideoEmbed = convertMediaUrlToVideoEmbed;


/***/ }),
/* 152 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.parseQuery = void 0;
var parseQuery = function (queryString) {
    var query = {}, a = queryString.substr(1).split('&');
    for (var i = 0; i < a.length; i += 1) {
        var keyValue = a[i].split('=');
        query[decodeURIComponent(keyValue[0])] = decodeURIComponent(keyValue[1] || '');
    }
    return query;
};
exports.parseQuery = parseQuery;


/***/ }),
/* 153 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ctrlKey = void 0;
var ctrlKey = function (e) {
    if (typeof navigator !== 'undefined' &&
        navigator.userAgent.indexOf('Mac OS X') !== -1) {
        if (e.metaKey && !e.altKey) {
            return true;
        }
    }
    else if (e.ctrlKey && !e.altKey) {
        return true;
    }
    return false;
};
exports.ctrlKey = ctrlKey;


/***/ }),
/* 154 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.each = void 0;
var checker_1 = __webpack_require__(34);
function each(obj, callback) {
    var length, keys, i;
    if (checker_1.isArray(obj)) {
        length = obj.length;
        for (i = 0; i < length; i += 1) {
            if (callback.call(obj[i], i, obj[i]) === false) {
                return false;
            }
        }
    }
    else {
        keys = Object.keys(obj);
        for (i = 0; i < keys.length; i += 1) {
            if (callback.call(obj[keys[i]], keys[i], obj[keys[i]]) === false) {
                return false;
            }
        }
    }
    return true;
}
exports.each = each;


/***/ }),
/* 155 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.humanSizeToBytes = void 0;
var humanSizeToBytes = function (human) {
    if (/^[0-9.]+$/.test(human.toString())) {
        return parseFloat(human);
    }
    var format = human.substr(-2, 2).toUpperCase(), formats = ['KB', 'MB', 'GB', 'TB'], number = parseFloat(human.substr(0, human.length - 2));
    return formats.indexOf(format) !== -1
        ? number * Math.pow(1024, formats.indexOf(format) + 1)
        : parseInt(human, 10);
};
exports.humanSizeToBytes = humanSizeToBytes;


/***/ }),
/* 156 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.buildQuery = void 0;
var checker_1 = __webpack_require__(34);
var buildQuery = function (data, prefix) {
    var str = [];
    var enc = encodeURIComponent;
    for (var dataKey in data) {
        if (Object.prototype.hasOwnProperty.call(data, dataKey)) {
            var k = prefix ? prefix + '[' + dataKey + ']' : dataKey;
            var v = data[dataKey];
            str.push(checker_1.isPlainObject(v) ? exports.buildQuery(v, k) : enc(k) + '=' + enc(v));
        }
    }
    return str.join('&');
};
exports.buildQuery = buildQuery;


/***/ }),
/* 157 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.scrollIntoViewIfNeeded = exports.inView = void 0;
var inView = function (elm, root, doc) {
    var rect = elm.getBoundingClientRect(), el = elm;
    var top = rect.top, height = rect.height;
    do {
        if (el && el.parentNode) {
            el = el.parentNode;
            rect = el.getBoundingClientRect();
            if (!(top <= rect.bottom)) {
                return false;
            }
            if (top + height <= rect.top) {
                return false;
            }
        }
    } while (el && el !== root && el.parentNode);
    return (top <= ((doc.documentElement && doc.documentElement.clientHeight) || 0));
};
exports.inView = inView;
var scrollIntoViewIfNeeded = function (elm, root, doc) {
    if (!exports.inView(elm, root, doc)) {
        if (root.clientHeight !== root.scrollHeight) {
            root.scrollTop = elm.offsetTop;
        }
        if (!exports.inView(elm, root, doc)) {
            elm.scrollIntoView();
        }
    }
};
exports.scrollIntoViewIfNeeded = scrollIntoViewIfNeeded;


/***/ }),
/* 158 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.val = void 0;
var val = function (elm, selector, value) {
    var child = elm.querySelector(selector);
    if (!child) {
        return '';
    }
    if (value) {
        child.value = value;
    }
    return child.value;
};
exports.val = val;


/***/ }),
/* 159 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Async = void 0;
var tslib_1 = __webpack_require__(7);
var helpers_1 = __webpack_require__(19);
var Async = (function () {
    function Async() {
        var _this = this;
        var _a, _b, _c, _d;
        this.timers = new Map();
        this.promisesRejections = new Set();
        this.requestsIdle = new Set();
        this.requestIdleCallbackNative = (_b = (_a = window['requestIdleCallback']) === null || _a === void 0 ? void 0 : _a.bind(window)) !== null && _b !== void 0 ? _b : (function (callback) {
            var start = Date.now();
            return _this.setTimeout(function () {
                callback({
                    didTimeout: false,
                    timeRemaining: function () { return Math.max(0, 50 - (Date.now() - start)); }
                });
            }, 1);
        });
        this.cancelIdleCallbackNative = (_d = (_c = window['cancelIdleCallback']) === null || _c === void 0 ? void 0 : _c.bind(window)) !== null && _d !== void 0 ? _d : (function (request) {
            _this.clearTimeout(request);
        });
        this.isDestructed = false;
    }
    Async.prototype.setTimeout = function (callback, timeout) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        if (this.isDestructed) {
            return 0;
        }
        var options = {};
        if (!helpers_1.isNumber(timeout)) {
            options = timeout;
            timeout = options.timeout || 0;
        }
        if (options.label) {
            this.clearLabel(options.label);
        }
        var timer = helpers_1.setTimeout.apply(void 0, tslib_1.__spreadArray([callback, timeout], args)), key = options.label || timer;
        this.timers.set(key, timer);
        return timer;
    };
    Async.prototype.clearLabel = function (label) {
        if (label && this.timers.has(label)) {
            helpers_1.clearTimeout(this.timers.get(label));
            this.timers.delete(label);
        }
    };
    Async.prototype.clearTimeout = function (timerOrLabel) {
        if (helpers_1.isString(timerOrLabel)) {
            return this.clearLabel(timerOrLabel);
        }
        helpers_1.clearTimeout(timerOrLabel);
        this.timers.delete(timerOrLabel);
    };
    Async.prototype.debounce = function (fn, timeout, firstCallImmediately) {
        var _this = this;
        if (firstCallImmediately === void 0) { firstCallImmediately = false; }
        var timer = 0, fired = false;
        var promises = [];
        var callFn = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            if (!fired) {
                timer = 0;
                var res = fn.apply(void 0, args);
                fired = true;
                if (promises.length) {
                    var runPromises = function () {
                        promises.forEach(function (res) { return res(); });
                        promises.length = 0;
                    };
                    helpers_1.isPromise(res) ? res.finally(runPromises) : runPromises();
                }
            }
        };
        var onFire = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            fired = false;
            if (!timeout) {
                callFn.apply(void 0, args);
            }
            else {
                if (!timer && firstCallImmediately) {
                    callFn.apply(void 0, args);
                }
                helpers_1.clearTimeout(timer);
                timer = _this.setTimeout(function () { return callFn.apply(void 0, args); }, helpers_1.isFunction(timeout) ? timeout() : timeout);
                _this.timers.set(fn, timer);
            }
        };
        return helpers_1.isPlainObject(timeout) && timeout.promisify
            ? function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                var promise = _this.promise(function (res) {
                    promises.push(res);
                });
                onFire.apply(void 0, args);
                return promise;
            }
            : onFire;
    };
    Async.prototype.throttle = function (fn, timeout, ignore) {
        var _this = this;
        if (ignore === void 0) { ignore = false; }
        var timer = null, needInvoke, callee, lastArgs;
        return function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            needInvoke = true;
            lastArgs = args;
            if (!timeout) {
                fn.apply(void 0, lastArgs);
                return;
            }
            if (!timer) {
                callee = function () {
                    if (needInvoke) {
                        fn.apply(void 0, lastArgs);
                        needInvoke = false;
                        timer = _this.setTimeout(callee, helpers_1.isFunction(timeout) ? timeout() : timeout);
                        _this.timers.set(callee, timer);
                    }
                    else {
                        timer = null;
                    }
                };
                callee();
            }
        };
    };
    Async.prototype.promise = function (executor) {
        var _this = this;
        var rejectCallback = function () { };
        var promise = new Promise(function (resolve, reject) {
            _this.promisesRejections.add(reject);
            rejectCallback = reject;
            return executor(resolve, reject);
        });
        if (!promise.finally && "es5" !== 'es2018') {
            promise.finally = function (onfinally) {
                promise.then(onfinally).catch(onfinally);
                return promise;
            };
        }
        promise.finally(function () {
            _this.promisesRejections.delete(rejectCallback);
        });
        promise.rejectCallback = rejectCallback;
        return promise;
    };
    Async.prototype.promiseState = function (p) {
        var _this = this;
        if (p.status) {
            return p.status;
        }
        if (!Promise.race) {
            return new Promise(function (resolve) {
                p.then(function (v) {
                    resolve('fulfilled');
                    return v;
                }, function (e) {
                    resolve('rejected');
                    throw e;
                });
                _this.setTimeout(function () {
                    resolve('pending');
                }, 100);
            });
        }
        var t = {};
        return Promise.race([p, t]).then(function (v) { return (v === t ? 'pending' : 'fulfilled'); }, function () { return 'rejected'; });
    };
    Async.prototype.requestIdleCallback = function (callback) {
        var request = this.requestIdleCallbackNative(callback);
        this.requestsIdle.add(request);
        return request;
    };
    Async.prototype.requestIdlePromise = function () {
        var _this = this;
        return new Promise(function (res) {
            var request = _this.requestIdleCallback(function () { return res(request); });
        });
    };
    Async.prototype.cancelIdleCallback = function (request) {
        this.requestsIdle.delete(request);
        return this.cancelIdleCallbackNative(request);
    };
    Async.prototype.clear = function () {
        var _this = this;
        this.requestsIdle.forEach(function (key) {
            _this.cancelIdleCallback(key);
        });
        this.timers.forEach(function (key) {
            helpers_1.clearTimeout(_this.timers.get(key));
        });
        this.timers.clear();
        this.promisesRejections.forEach(function (reject) {
            reject();
        });
        this.promisesRejections.clear();
    };
    Async.prototype.destruct = function () {
        this.clear();
        this.isDestructed = true;
    };
    return Async;
}());
exports.Async = Async;


/***/ }),
/* 160 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Ajax = void 0;
var tslib_1 = __webpack_require__(7);
var config_1 = __webpack_require__(8);
var helpers_1 = __webpack_require__(19);
config_1.Config.prototype.defaultAjaxOptions = {
    dataType: 'json',
    method: 'GET',
    url: '',
    data: null,
    contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
    headers: {
        'X-REQUESTED-WITH': 'XMLHttpRequest'
    },
    withCredentials: false,
    xhr: function () {
        return new XMLHttpRequest();
    }
};
var Ajax = (function () {
    function Ajax(jodit, options) {
        var _this = this;
        this.jodit = jodit;
        this.success_response_codes = [200, 201, 202];
        this.resolved = false;
        this.activated = false;
        this.options = helpers_1.ConfigProto(options || {}, config_1.Config.prototype.defaultAjaxOptions);
        this.xhr = this.o.xhr ? this.o.xhr() : new XMLHttpRequest();
        jodit &&
            jodit.events &&
            jodit.e.on('beforeDestruct', function () {
                _this.abort();
            });
    }
    Ajax.prototype.__buildParams = function (obj, prefix) {
        if (helpers_1.isFunction(this.o.queryBuild)) {
            return this.o.queryBuild.call(this, obj, prefix);
        }
        if (helpers_1.isString(obj) ||
            (this.j.ow.FormData &&
                obj instanceof this.j.ow.FormData)) {
            return obj;
        }
        return helpers_1.buildQuery(obj);
    };
    Object.defineProperty(Ajax.prototype, "o", {
        get: function () {
            return this.options;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Ajax.prototype, "j", {
        get: function () {
            return this.jodit;
        },
        enumerable: false,
        configurable: true
    });
    Ajax.prototype.abort = function () {
        try {
            this.xhr.abort();
        }
        catch (_a) { }
        return this;
    };
    Ajax.prototype.send = function () {
        var _this = this;
        this.activated = true;
        return new Promise(function (resolve, reject) {
            var __parse = function (resp) {
                var result = null;
                if (_this.o.dataType === 'json') {
                    result = JSON.parse(resp);
                }
                if (!result) {
                    throw helpers_1.error('No JSON format');
                }
                return result;
            };
            _this.xhr.onabort = function () {
                reject(helpers_1.error(_this.xhr.statusText));
            };
            _this.xhr.onerror = function () {
                reject(helpers_1.error(_this.xhr.statusText));
            };
            _this.xhr.ontimeout = function () {
                reject(helpers_1.error(_this.xhr.statusText));
            };
            _this.xhr.onload = function () {
                _this.response = _this.xhr.responseText;
                _this.status = _this.xhr.status;
                _this.resolved = true;
                resolve.call(_this.xhr, __parse(_this.response) || {});
            };
            _this.xhr.onprogress = function (e) {
                var _a, _b;
                var percentComplete = 0;
                if (e.lengthComputable) {
                    percentComplete = (e.loaded / e.total) * 100;
                }
                (_b = (_a = _this.options).onProgress) === null || _b === void 0 ? void 0 : _b.call(_a, percentComplete);
            };
            _this.xhr.onreadystatechange = function () {
                var _a, _b;
                (_b = (_a = _this.options).onProgress) === null || _b === void 0 ? void 0 : _b.call(_a, 10);
                if (_this.xhr.readyState === XMLHttpRequest.DONE) {
                    var resp = _this.xhr.responseText;
                    _this.response = resp;
                    _this.status = _this.xhr.status;
                    _this.resolved = true;
                    if (_this.success_response_codes.indexOf(_this.xhr.status) > -1) {
                        resolve.call(_this.xhr, __parse(resp));
                    }
                    else {
                        reject.call(_this.xhr, helpers_1.error(_this.xhr.statusText ||
                            _this.j.i18n('Connection error!')));
                    }
                }
            };
            _this.xhr.withCredentials = _this.o.withCredentials || false;
            var _a = _this.prepareRequest(), url = _a.url, data = _a.data, method = _a.method;
            _this.xhr.open(method, url, true);
            if (_this.o.contentType && _this.xhr.setRequestHeader) {
                _this.xhr.setRequestHeader('Content-type', _this.o.contentType);
            }
            if (_this.o.headers && _this.xhr.setRequestHeader) {
                helpers_1.each(_this.o.headers, function (key, value) {
                    _this.xhr.setRequestHeader(key, value);
                });
            }
            setTimeout(function () {
                _this.xhr.send(data ? _this.__buildParams(data) : undefined);
            }, 0);
        });
    };
    Ajax.prototype.prepareRequest = function () {
        if (!this.o.url) {
            throw helpers_1.error('Need URL for AJAX request');
        }
        var url = this.o.url;
        var data = this.o.data;
        var method = (this.o.method || 'get').toLowerCase();
        if (method === 'get' && data && helpers_1.isPlainObject(data)) {
            var qIndex = url.indexOf('?');
            if (qIndex !== -1) {
                var urlData = helpers_1.parseQuery(url);
                url =
                    url.substr(0, qIndex) +
                        '?' +
                        helpers_1.buildQuery(tslib_1.__assign(tslib_1.__assign({}, urlData), data));
            }
            else {
                url += '?' + helpers_1.buildQuery(this.o.data);
            }
        }
        var request = {
            url: url,
            method: method,
            data: data
        };
        Ajax.log.splice(100);
        Ajax.log.push(request);
        return request;
    };
    Ajax.prototype.destruct = function () {
        if (this.activated && !this.resolved) {
            this.abort();
            this.resolved = true;
        }
    };
    Ajax.log = [];
    return Ajax;
}());
exports.Ajax = Ajax;


/***/ }),
/* 161 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextMenu = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(162);
var popup_1 = __webpack_require__(116);
var button_1 = __webpack_require__(92);
var checker_1 = __webpack_require__(34);
var ContextMenu = (function (_super) {
    tslib_1.__extends(ContextMenu, _super);
    function ContextMenu() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ContextMenu.prototype.className = function () {
        return 'ContextMenu';
    };
    ContextMenu.prototype.show = function (x, y, actions) {
        var _this = this;
        var self = this, content = this.j.c.div('jodit-context-menu__actions');
        if (!checker_1.isArray(actions)) {
            return;
        }
        actions.forEach(function (item) {
            if (!item) {
                return;
            }
            var action = button_1.Button(_this.jodit, item.icon || 'empty', item.title);
            _this.jodit && action.setParentView(_this.jodit);
            action.setMod('context', 'menu');
            action.onAction(function (e) {
                var _a;
                (_a = item.exec) === null || _a === void 0 ? void 0 : _a.call(self, e);
                self.close();
                return false;
            });
            content.appendChild(action.container);
        });
        _super.prototype.setContent.call(this, content)
            .open(function () { return ({ left: x, top: y, width: 0, height: 0 }); }, true);
    };
    return ContextMenu;
}(popup_1.Popup));
exports.ContextMenu = ContextMenu;


/***/ }),
/* 162 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 163 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Confirm = exports.Prompt = exports.Alert = exports.Dialog = void 0;
var dialog_1 = __webpack_require__(164);
Object.defineProperty(exports, "Dialog", ({ enumerable: true, get: function () { return dialog_1.Dialog; } }));
var alert_1 = __webpack_require__(181);
Object.defineProperty(exports, "Alert", ({ enumerable: true, get: function () { return alert_1.Alert; } }));
var prompt_1 = __webpack_require__(182);
Object.defineProperty(exports, "Prompt", ({ enumerable: true, get: function () { return prompt_1.Prompt; } }));
var confirm_1 = __webpack_require__(183);
Object.defineProperty(exports, "Confirm", ({ enumerable: true, get: function () { return confirm_1.Confirm; } }));


/***/ }),
/* 164 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Dialog = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(165);
var config_1 = __webpack_require__(8);
var constants_1 = __webpack_require__(9);
var helpers_1 = __webpack_require__(19);
var view_with_toolbar_1 = __webpack_require__(166);
var dom_1 = __webpack_require__(32);
var component_1 = __webpack_require__(27);
var global_1 = __webpack_require__(30);
var decorators_1 = __webpack_require__(99);
var view_1 = __webpack_require__(168);
config_1.Config.prototype.dialog = {
    namespace: '',
    extraButtons: [],
    resizable: true,
    draggable: true,
    buttons: ['dialog.close'],
    removeButtons: []
};
config_1.Config.prototype.controls.dialog = {
    close: {
        icon: 'cancel',
        exec: function (dialog) {
            dialog.close();
            dialog.toggleFullSizeBox(false);
        }
    }
};
var Dialog = (function (_super) {
    tslib_1.__extends(Dialog, _super);
    function Dialog(options) {
        var _this = _super.call(this, options) || this;
        _this.destroyAfterClose = false;
        _this.moved = false;
        _this.iSetMaximization = false;
        _this.resizable = false;
        _this.draggable = false;
        _this.startX = 0;
        _this.startY = 0;
        _this.startPoint = { x: 0, y: 0, w: 0, h: 0 };
        _this.lockSelect = function () {
            _this.setMod('moved', true);
        };
        _this.unlockSelect = function () {
            _this.setMod('moved', false);
        };
        _this.onResize = function () {
            if (_this.options &&
                _this.o.resizable &&
                !_this.moved &&
                _this.isOpened &&
                !_this.offsetX &&
                !_this.offsetY) {
                _this.setPosition();
            }
        };
        _this.isModal = false;
        _this.isOpened = false;
        var self = _this;
        self.options = helpers_1.ConfigProto(options !== null && options !== void 0 ? options : {}, helpers_1.ConfigProto({
            toolbarButtonSize: 'middle'
        }, helpers_1.ConfigProto(config_1.Config.prototype.dialog, view_1.View.defaultOptions)));
        dom_1.Dom.safeRemove(self.container);
        var n = _this.getFullElName.bind(_this);
        self.container = _this.c.fromHTML("<div style=\"z-index:" + self.o.zIndex + "\" class=\"jodit jodit-dialog " + _this.componentName + "\">\n\t\t\t\t<div class=\"" + n('overlay') + "\"></div>\n\t\t\t\t<div class=\"" + _this.getFullElName('panel') + "\">\n\t\t\t\t\t<div class=\"" + n('header') + "\">\n\t\t\t\t\t\t<div class=\"" + n('header-title') + "\"></div>\n\t\t\t\t\t\t<div class=\"" + n('header-toolbar') + "\"></div>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"" + n('content') + "\"></div>\n\t\t\t\t\t<div class=\"" + n('footer') + "\"></div>\n\t\t\t\t\t" + (self.o.resizable ? "<div class=\"" + n('resizer') + "\"></div>" : '') + "\n\t\t\t\t</div>\n\t\t\t</div>");
        helpers_1.attr(self.container, 'role', 'dialog');
        Object.defineProperty(self.container, 'component', {
            value: _this
        });
        self.setMod('theme', self.o.theme || 'default');
        self.dialog = self.getElm('panel');
        helpers_1.css(self.dialog, {
            maxWidth: self.options.maxWidth,
            minHeight: self.options.minHeight,
            minWidth: self.options.minWidth
        });
        self.resizer = self.getElm('resizer');
        self.dialogbox_header = self.getElm('header-title');
        self.dialogbox_content = self.getElm('content');
        self.dialogbox_footer = self.getElm('footer');
        self.dialogbox_toolbar = self.getElm('header-toolbar');
        var headerBox = self.getElm('header');
        headerBox && self.e.on(headerBox, 'mousedown', self.onHeaderMouseDown);
        if (self.o.resizable) {
            self.e.on(self.resizer, 'mousedown', self.onResizerMouseDown);
        }
        var fullSize = global_1.pluginSystem.get('fullsize');
        helpers_1.isFunction(fullSize) && fullSize(self);
        _this.e
            .on(self.container, 'close_dialog', self.close)
            .on(_this.ow, 'keydown', _this.onEsc)
            .on(_this.ow, 'resize', _this.onResize);
        return _this;
    }
    Dialog.prototype.className = function () {
        return 'Dialog';
    };
    Object.defineProperty(Dialog.prototype, "destination", {
        get: function () {
            return this.od.body;
        },
        enumerable: false,
        configurable: true
    });
    Dialog.prototype.setElements = function (root, elements) {
        var _this = this;
        var elements_list = [];
        helpers_1.asArray(elements).forEach(function (elm) {
            if (helpers_1.isArray(elm)) {
                var div = _this.c.div(_this.getFullElName('column'));
                elements_list.push(div);
                root.appendChild(div);
                return _this.setElements(div, elm);
            }
            var element;
            if (helpers_1.isString(elm)) {
                element = _this.c.fromHTML(elm);
            }
            else {
                element = helpers_1.hasContainer(elm) ? elm.container : elm;
            }
            elements_list.push(element);
            if (element.parentNode !== root) {
                root.appendChild(element);
            }
        });
        helpers_1.toArray(root.childNodes).forEach(function (elm) {
            if (elements_list.indexOf(elm) === -1) {
                root.removeChild(elm);
            }
        });
    };
    Dialog.prototype.onMouseUp = function () {
        if (this.draggable || this.resizable) {
            this.e.off(this.ow, 'mousemove', this.onMouseMove);
            this.draggable = false;
            this.resizable = false;
            this.unlockSelect();
            if (this.e) {
                this.removeGlobalResizeListeners();
                this.e.fire(this, 'endResize endMove');
            }
        }
    };
    Dialog.prototype.onHeaderMouseDown = function (e) {
        var target = e.target;
        if (!this.o.draggable ||
            (target && target.nodeName.match(/^(INPUT|SELECT)$/))) {
            return;
        }
        this.draggable = true;
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.startPoint.x = helpers_1.css(this.dialog, 'left');
        this.startPoint.y = helpers_1.css(this.dialog, 'top');
        this.setMaxZIndex();
        e.preventDefault();
        this.lockSelect();
        this.addGlobalResizeListeners();
        if (this.e) {
            this.e.fire(this, 'startMove');
        }
    };
    Dialog.prototype.onMouseMove = function (e) {
        if (this.draggable && this.o.draggable) {
            this.setPosition(this.startPoint.x + e.clientX - this.startX, this.startPoint.y + e.clientY - this.startY);
            if (this.e) {
                this.e.fire(this, 'move', e.clientX - this.startX, e.clientY - this.startY);
            }
            e.stopImmediatePropagation();
        }
        if (this.resizable && this.o.resizable) {
            this.setSize(this.startPoint.w + e.clientX - this.startX, this.startPoint.h + e.clientY - this.startY);
            if (this.e) {
                this.e.fire(this, 'resizeDialog', e.clientX - this.startX, e.clientY - this.startY);
            }
        }
    };
    Dialog.prototype.onEsc = function (e) {
        if (this.isOpened &&
            e.key === constants_1.KEY_ESC &&
            this.getMod('static') !== true) {
            var me = this.getMaxZIndexDialog();
            if (me) {
                me.close();
            }
            else {
                this.close();
            }
            e.stopImmediatePropagation();
        }
    };
    Dialog.prototype.onResizerMouseDown = function (e) {
        this.resizable = true;
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.startPoint.w = this.dialog.offsetWidth;
        this.startPoint.h = this.dialog.offsetHeight;
        this.lockSelect();
        this.addGlobalResizeListeners();
        if (this.e) {
            this.e.fire(this, 'startResize');
        }
    };
    Dialog.prototype.addGlobalResizeListeners = function () {
        var self = this;
        self.e
            .on(self.ow, 'mousemove', self.onMouseMove)
            .on(self.ow, 'mouseup', self.onMouseUp);
    };
    Dialog.prototype.removeGlobalResizeListeners = function () {
        var self = this;
        self.e
            .off(self.ow, 'mousemove', self.onMouseMove)
            .off(self.ow, 'mouseup', self.onMouseUp);
    };
    Dialog.prototype.setSize = function (w, h) {
        if (w == null) {
            w = this.dialog.offsetWidth;
        }
        if (h == null) {
            h = this.dialog.offsetHeight;
        }
        helpers_1.css(this.dialog, {
            width: w,
            height: h
        });
        return this;
    };
    Dialog.prototype.calcAutoSize = function () {
        this.setSize('auto', 'auto');
        this.setSize();
        return this;
    };
    Dialog.prototype.setPosition = function (x, y) {
        var w = this.ow.innerWidth, h = this.ow.innerHeight;
        var left = w / 2 - this.dialog.offsetWidth / 2, top = h / 2 - this.dialog.offsetHeight / 2;
        if (left < 0) {
            left = 0;
        }
        if (top < 0) {
            top = 0;
        }
        if (x !== undefined && y !== undefined) {
            this.offsetX = x;
            this.offsetY = y;
            this.moved = Math.abs(x - left) > 100 || Math.abs(y - top) > 100;
        }
        this.dialog.style.left = (x || left) + 'px';
        this.dialog.style.top = (y || top) + 'px';
        return this;
    };
    Dialog.prototype.setHeader = function (content) {
        this.setElements(this.dialogbox_header, content);
        return this;
    };
    Dialog.prototype.setContent = function (content) {
        this.setElements(this.dialogbox_content, content);
        return this;
    };
    Dialog.prototype.setFooter = function (content) {
        this.setElements(this.dialogbox_footer, content);
        this.setMod('footer', Boolean(content));
        return this;
    };
    Dialog.prototype.getZIndex = function () {
        return parseInt(helpers_1.css(this.container, 'zIndex'), 10) || 0;
    };
    Dialog.prototype.getMaxZIndexDialog = function () {
        var maxZi = 0, dlg, zIndex, res = this;
        helpers_1.$$('.jodit-dialog', this.destination).forEach(function (dialog) {
            dlg = dialog.component;
            zIndex = parseInt(helpers_1.css(dialog, 'zIndex'), 10);
            if (dlg.isOpened && !isNaN(zIndex) && zIndex > maxZi) {
                res = dlg;
                maxZi = zIndex;
            }
        });
        return res;
    };
    Dialog.prototype.setMaxZIndex = function () {
        var maxZIndex = 20000004, zIndex = 0;
        helpers_1.$$('.jodit-dialog', this.destination).forEach(function (dialog) {
            zIndex = parseInt(helpers_1.css(dialog, 'zIndex'), 10);
            maxZIndex = Math.max(isNaN(zIndex) ? 0 : zIndex, maxZIndex);
        });
        this.container.style.zIndex = (maxZIndex + 1).toString();
    };
    Dialog.prototype.maximization = function (condition) {
        if (helpers_1.isVoid(condition)) {
            condition = !this.getMod('fullsize');
        }
        this.setMod('fullsize', condition);
        this.toggleFullSizeBox(condition);
        this.iSetMaximization = condition;
        return condition;
    };
    Dialog.prototype.toggleFullSizeBox = function (condition) {
        [this.destination, this.destination.parentNode].forEach(function (box) {
            box &&
                box.classList &&
                box.classList.toggle('jodit_fullsize-box_true', condition);
        });
    };
    Dialog.prototype.open = function (contentOrClose, titleOrModal, destroyAfterClose, modal) {
        global_1.eventEmitter.fire('closeAllPopups hideHelpers');
        if (this.e.fire(this, 'beforeOpen') === false) {
            return this;
        }
        if (helpers_1.isBoolean(contentOrClose)) {
            destroyAfterClose = contentOrClose;
        }
        if (helpers_1.isBoolean(titleOrModal)) {
            modal = titleOrModal;
        }
        this.destroyAfterClose = destroyAfterClose === true;
        var content = helpers_1.isBoolean(contentOrClose) ? undefined : contentOrClose;
        var title = helpers_1.isBoolean(titleOrModal) ? undefined : titleOrModal;
        if (title !== undefined) {
            this.setHeader(title);
        }
        if (content) {
            this.setContent(content);
        }
        this.setMod('active', true);
        this.isOpened = true;
        this.setModal(modal);
        this.destination.appendChild(this.container);
        this.setPosition(this.offsetX, this.offsetY);
        this.setMaxZIndex();
        if (this.o.fullsize) {
            this.maximization(true);
        }
        this.e.fire('afterOpen', this);
        return this;
    };
    Dialog.prototype.setModal = function (modal) {
        this.isModal = Boolean(modal);
        this.setMod('modal', this.isModal);
        return this;
    };
    Dialog.prototype.close = function (e) {
        var _a, _b;
        if (this.isDestructed ||
            !this.isOpened ||
            this.getMod('static') === true) {
            return this;
        }
        if (e) {
            e.stopImmediatePropagation();
            e.preventDefault();
        }
        if (this.e) {
            this.e.fire('beforeClose', this);
        }
        this.setMod('active', false);
        this.isOpened = false;
        this.e.fire('toggleFullSize', false);
        if (this.iSetMaximization) {
            this.maximization(false);
        }
        dom_1.Dom.safeRemove(this.container);
        this.removeGlobalResizeListeners();
        if (this.destroyAfterClose) {
            this.destruct();
        }
        (_a = this.e) === null || _a === void 0 ? void 0 : _a.fire(this, 'afterClose');
        (_b = this.e) === null || _b === void 0 ? void 0 : _b.fire(this.ow, 'joditCloseDialog');
        return this;
    };
    Dialog.prototype.buildToolbar = function () {
        this.o.buttons &&
            this.toolbar
                .build(helpers_1.splitArray(this.o.buttons))
                .setMod('mode', 'header')
                .appendTo(this.dialogbox_toolbar);
    };
    Dialog.prototype.destruct = function () {
        if (this.isInDestruct) {
            return;
        }
        this.setStatus(component_1.STATUSES.beforeDestruct);
        if (this.isOpened) {
            this.close();
        }
        if (this.events) {
            this.removeGlobalResizeListeners();
            this.events
                .off(this.container, 'close_dialog', self.close)
                .off(this.ow, 'keydown', this.onEsc)
                .off(this.ow, 'resize', this.onResize);
        }
        _super.prototype.destruct.call(this);
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], Dialog.prototype, "onMouseUp", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], Dialog.prototype, "onHeaderMouseDown", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], Dialog.prototype, "onMouseMove", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], Dialog.prototype, "onEsc", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], Dialog.prototype, "onResizerMouseDown", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], Dialog.prototype, "close", null);
    tslib_1.__decorate([
        decorators_1.hook('ready')
    ], Dialog.prototype, "buildToolbar", null);
    Dialog = tslib_1.__decorate([
        decorators_1.component
    ], Dialog);
    return Dialog;
}(view_with_toolbar_1.ViewWithToolbar));
exports.Dialog = Dialog;


/***/ }),
/* 165 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 166 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ViewWithToolbar = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(167);
var view_1 = __webpack_require__(168);
var helpers_1 = __webpack_require__(19);
var dom_1 = __webpack_require__(32);
var factory_1 = __webpack_require__(173);
var component_1 = __webpack_require__(27);
var buttons_1 = __webpack_require__(113);
var decorators_1 = __webpack_require__(99);
var ViewWithToolbar = (function (_super) {
    tslib_1.__extends(ViewWithToolbar, _super);
    function ViewWithToolbar(options, isJodit) {
        if (isJodit === void 0) { isJodit = false; }
        var _this = _super.call(this, options, isJodit) || this;
        _this.toolbar = factory_1.makeCollection(_this);
        _this.defaultToolbarContainer = _this.c.div('jodit-toolbar__box');
        _this.registeredButtons = new Set();
        _this.groupToButtons = {};
        _this.isJodit = false;
        _this.isJodit = isJodit;
        _this.e.on('beforeToolbarBuild', _this.beforeToolbarBuild);
        return _this;
    }
    Object.defineProperty(ViewWithToolbar.prototype, "toolbarContainer", {
        get: function () {
            if (!this.o.fullsize &&
                (helpers_1.isString(this.o.toolbar) ||
                    dom_1.Dom.isHTMLElement(this.o.toolbar, this.ow))) {
                return helpers_1.resolveElement(this.o.toolbar, this.o.shadowRoot || this.od);
            }
            this.o.toolbar &&
                dom_1.Dom.appendChildFirst(this.container, this.defaultToolbarContainer);
            return this.defaultToolbarContainer;
        },
        enumerable: false,
        configurable: true
    });
    ViewWithToolbar.prototype.setPanel = function (element) {
        this.o.toolbar = element;
        this.buildToolbar();
    };
    ViewWithToolbar.prototype.buildToolbar = function () {
        if (!this.o.toolbar) {
            return;
        }
        var buttons = this.o.buttons
            ? helpers_1.splitArray(this.o.buttons)
            : [];
        this.toolbar
            .setRemoveButtons(this.o.removeButtons)
            .build(buttons.concat(this.o.extraButtons || []))
            .appendTo(this.toolbarContainer);
    };
    ViewWithToolbar.prototype.registerButton = function (btn) {
        var _a;
        this.registeredButtons.add(btn);
        var group = (_a = btn.group) !== null && _a !== void 0 ? _a : 'other';
        if (!this.groupToButtons[group]) {
            this.groupToButtons[group] = [];
        }
        if (btn.position != null) {
            this.groupToButtons[group][btn.position] = btn.name;
        }
        else {
            this.groupToButtons[group].push(btn.name);
        }
        return this;
    };
    ViewWithToolbar.prototype.unregisterButton = function (btn) {
        var _a;
        this.registeredButtons.delete(btn);
        var groupName = (_a = btn.group) !== null && _a !== void 0 ? _a : 'other', group = this.groupToButtons[groupName];
        if (group) {
            var index = group.indexOf(btn.name);
            if (index !== -1) {
                group.splice(index, 1);
            }
            if (group.length === 0) {
                delete this.groupToButtons[groupName];
            }
        }
        return this;
    };
    ViewWithToolbar.prototype.beforeToolbarBuild = function (items) {
        var _this = this;
        if (Object.keys(this.groupToButtons).length) {
            return items.map(function (item) {
                if (buttons_1.isButtonGroup(item) &&
                    item.group &&
                    _this.groupToButtons[item.group]) {
                    return {
                        group: item.group,
                        buttons: tslib_1.__spreadArray(tslib_1.__spreadArray([], item.buttons), _this.groupToButtons[item.group])
                    };
                }
                return item;
            });
        }
    };
    ViewWithToolbar.prototype.destruct = function () {
        if (this.isDestructed) {
            return;
        }
        this.setStatus(component_1.STATUSES.beforeDestruct);
        this.e.off('beforeToolbarBuild', this.beforeToolbarBuild);
        this.toolbar.destruct();
        _super.prototype.destruct.call(this);
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], ViewWithToolbar.prototype, "beforeToolbarBuild", null);
    return ViewWithToolbar;
}(view_1.View));
exports.ViewWithToolbar = ViewWithToolbar;


/***/ }),
/* 167 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 168 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.View = void 0;
var tslib_1 = __webpack_require__(7);
var storage_1 = __webpack_require__(169);
var helpers_1 = __webpack_require__(19);
var constants_1 = __webpack_require__(9);
var modules_1 = __webpack_require__(10);
var async_1 = __webpack_require__(159);
var global_1 = __webpack_require__(30);
var decorators_1 = __webpack_require__(99);
var traits_1 = __webpack_require__(77);
var View = (function (_super) {
    tslib_1.__extends(View, _super);
    function View(options, isJodit) {
        if (isJodit === void 0) { isJodit = false; }
        var _this = _super.call(this) || this;
        _this.isJodit = isJodit;
        _this.isView = true;
        _this.mods = {};
        _this.components = new Set();
        _this.version = "3.7.1";
        _this.async = new async_1.Async();
        _this.buffer = storage_1.Storage.makeStorage();
        _this.storage = storage_1.Storage.makeStorage(true, _this.componentName);
        _this.OPTIONS = View.defaultOptions;
        _this.__isFullSize = false;
        _this.__whoLocked = '';
        _this.isLockedNotBy = function (name) {
            return _this.isLocked && _this.__whoLocked !== name;
        };
        _this.__modulesInstances = new Map();
        _this.id = new Date().getTime().toString();
        _this.buffer = storage_1.Storage.makeStorage();
        _this.initOptions(options);
        _this.initOwners();
        _this.events = new modules_1.EventsNative(_this.od);
        _this.create = new modules_1.Create(_this.od);
        _this.container = _this.c.div();
        _this.container.classList.add('jodit');
        _this.progressbar = new modules_1.ProgressBar(_this);
        return _this;
    }
    View.prototype.setMod = function (name, value) {
        traits_1.Mods.setMod.call(this, name, value);
        return this;
    };
    View.prototype.getMod = function (name) {
        return traits_1.Mods.getMod.call(this, name);
    };
    View.prototype.getElm = function (elementName) {
        return traits_1.Elms.getElm.call(this, elementName);
    };
    View.prototype.getElms = function (elementName) {
        return traits_1.Elms.getElms.call(this, elementName);
    };
    Object.defineProperty(View.prototype, "basePath", {
        get: function () {
            if (this.o.basePath) {
                return this.o.basePath;
            }
            return constants_1.BASE_PATH;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(View.prototype, "defaultTimeout", {
        get: function () {
            return helpers_1.isVoid(this.o.defaultTimeout) ? 100 : this.o.defaultTimeout;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(View.prototype, "c", {
        get: function () {
            return this.create;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(View.prototype, "container", {
        get: function () {
            return this.__container;
        },
        set: function (container) {
            this.__container = container;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(View.prototype, "e", {
        get: function () {
            return this.events;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(View.prototype, "options", {
        get: function () {
            return this.__options;
        },
        set: function (options) {
            this.__options = options;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(View.prototype, "o", {
        get: function () {
            return this.options;
        },
        enumerable: false,
        configurable: true
    });
    View.prototype.i18n = function (text) {
        var params = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            params[_i - 1] = arguments[_i];
        }
        return helpers_1.i18n(text, params, this.options);
    };
    View.prototype.toggleFullSize = function (isFullSize) {
        if (isFullSize === undefined) {
            isFullSize = !this.__isFullSize;
        }
        if (isFullSize === this.__isFullSize) {
            return;
        }
        this.__isFullSize = isFullSize;
        if (this.events) {
            this.e.fire('toggleFullSize', isFullSize);
        }
    };
    Object.defineProperty(View.prototype, "isLocked", {
        get: function () {
            return this.__whoLocked !== '';
        },
        enumerable: false,
        configurable: true
    });
    View.prototype.lock = function (name) {
        if (name === void 0) { name = 'any'; }
        if (!this.isLocked) {
            this.__whoLocked = name;
            return true;
        }
        return false;
    };
    View.prototype.unlock = function () {
        if (this.isLocked) {
            this.__whoLocked = '';
            return true;
        }
        return false;
    };
    Object.defineProperty(View.prototype, "isFullSize", {
        get: function () {
            return this.__isFullSize;
        },
        enumerable: false,
        configurable: true
    });
    View.prototype.getVersion = function () {
        return "3.7.1";
    };
    View.getVersion = function () {
        return "3.7.1";
    };
    View.prototype.initOptions = function (options) {
        this.options = helpers_1.ConfigProto(options || {}, helpers_1.ConfigProto(this.options || {}, View.defaultOptions));
    };
    View.prototype.initOwners = function () {
        var _a;
        this.ownerWindow = (_a = this.o.ownerWindow) !== null && _a !== void 0 ? _a : window;
    };
    View.prototype.attachEvents = function (options) {
        var _this = this;
        if (!options) {
            return;
        }
        var e = options === null || options === void 0 ? void 0 : options.events;
        e && Object.keys(e).forEach(function (key) { return _this.e.on(key, e[key]); });
    };
    View.prototype.getInstance = function (moduleName, options) {
        var instance = this.e.fire(helpers_1.camelCase('getInstance_' + moduleName), options);
        if (instance) {
            return instance;
        }
        var module = global_1.modules[moduleName], mi = this.__modulesInstances;
        if (!helpers_1.isFunction(module)) {
            throw helpers_1.error('Need real module name');
        }
        if (!mi.has(moduleName)) {
            var instance_1 = module.prototype instanceof modules_1.ViewComponent
                ? new module(this, options)
                : new module(options);
            this.components.add(instance_1);
            mi.set(moduleName, instance_1);
        }
        return mi.get(moduleName);
    };
    View.prototype.addDisclaimer = function (elm) {
        this.container.appendChild(elm);
    };
    View.prototype.beforeDestruct = function () {
        this.e.fire(modules_1.STATUSES.beforeDestruct, this);
        this.components.forEach(function (component) {
            if (helpers_1.isDestructable(component) && !component.isInDestruct) {
                component.destruct();
            }
        });
        this.components.clear();
    };
    View.prototype.destruct = function () {
        if (this.isDestructed) {
            return;
        }
        if (this.async) {
            this.async.destruct();
        }
        if (this.events) {
            this.e.destruct();
        }
        if (this.buffer) {
            this.buffer.clear();
        }
        modules_1.Dom.safeRemove(this.container);
        _super.prototype.destruct.call(this);
    };
    tslib_1.__decorate([
        decorators_1.hook(modules_1.STATUSES.beforeDestruct)
    ], View.prototype, "beforeDestruct", null);
    return View;
}(modules_1.Component));
exports.View = View;
View.defaultOptions = {
    extraButtons: [],
    textIcons: false,
    namespace: '',
    removeButtons: [],
    zIndex: 100002,
    defaultTimeout: 100,
    fullsize: false,
    showTooltip: true,
    useNativeTooltip: false,
    buttons: [],
    globalFullSize: true
};


/***/ }),
/* 169 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(170), exports);
tslib_1.__exportStar(__webpack_require__(171), exports);
tslib_1.__exportStar(__webpack_require__(172), exports);


/***/ }),
/* 170 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MemoryStorageProvider = void 0;
var MemoryStorageProvider = (function () {
    function MemoryStorageProvider() {
        this.data = new Map();
    }
    MemoryStorageProvider.prototype.set = function (key, value) {
        this.data.set(key, value);
    };
    MemoryStorageProvider.prototype.delete = function (key) {
        this.data.delete(key);
    };
    MemoryStorageProvider.prototype.get = function (key) {
        return this.data.get(key);
    };
    MemoryStorageProvider.prototype.exists = function (key) {
        return this.data.has(key);
    };
    MemoryStorageProvider.prototype.clear = function () {
        this.data.clear();
    };
    return MemoryStorageProvider;
}());
exports.MemoryStorageProvider = MemoryStorageProvider;


/***/ }),
/* 171 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LocalStorageProvider = exports.canUsePersistentStorage = void 0;
exports.canUsePersistentStorage = (function () {
    var canUse = function () {
        var tmpKey = '___Jodit___' + Math.random().toString();
        try {
            localStorage.setItem(tmpKey, '1');
            var result_1 = localStorage.getItem(tmpKey) === '1';
            localStorage.removeItem(tmpKey);
            return result_1;
        }
        catch (_a) { }
        return false;
    };
    var result;
    return function () {
        if (result === undefined) {
            result = canUse();
        }
        return result;
    };
})();
var LocalStorageProvider = (function () {
    function LocalStorageProvider(rootKey) {
        this.rootKey = rootKey;
    }
    LocalStorageProvider.prototype.set = function (key, value) {
        try {
            var buffer = localStorage.getItem(this.rootKey);
            var json = buffer ? JSON.parse(buffer) : {};
            json[key] = value;
            localStorage.setItem(this.rootKey, JSON.stringify(json));
        }
        catch (_a) { }
    };
    LocalStorageProvider.prototype.delete = function (key) {
        try {
            localStorage.removeItem(this.rootKey);
        }
        catch (_a) { }
    };
    LocalStorageProvider.prototype.get = function (key) {
        try {
            var buffer = localStorage.getItem(this.rootKey);
            var json = buffer ? JSON.parse(buffer) : {};
            return json[key] !== undefined ? json[key] : null;
        }
        catch (_a) { }
    };
    LocalStorageProvider.prototype.exists = function (key) {
        return this.get(key) != null;
    };
    LocalStorageProvider.prototype.clear = function () {
        try {
            localStorage.removeItem(this.rootKey);
        }
        catch (_a) { }
    };
    return LocalStorageProvider;
}());
exports.LocalStorageProvider = LocalStorageProvider;


/***/ }),
/* 172 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Storage = exports.StorageKey = void 0;
var helpers_1 = __webpack_require__(19);
var local_storage_provider_1 = __webpack_require__(171);
var memory_storage_provider_1 = __webpack_require__(170);
exports.StorageKey = 'Jodit_';
var Storage = (function () {
    function Storage(provider, suffix) {
        this.provider = provider;
        this.prefix = exports.StorageKey;
        if (suffix) {
            this.prefix += suffix;
        }
    }
    Storage.prototype.set = function (key, value) {
        this.provider.set(helpers_1.camelCase(this.prefix + key), value);
    };
    Storage.prototype.delete = function (key) {
        this.provider.delete(helpers_1.camelCase(this.prefix + key));
    };
    Storage.prototype.get = function (key) {
        return this.provider.get(helpers_1.camelCase(this.prefix + key));
    };
    Storage.prototype.exists = function (key) {
        return this.provider.exists(helpers_1.camelCase(this.prefix + key));
    };
    Storage.prototype.clear = function () {
        return this.provider.clear();
    };
    Storage.makeStorage = function (persistent, suffix) {
        if (persistent === void 0) { persistent = false; }
        var provider;
        if (persistent && local_storage_provider_1.canUsePersistentStorage()) {
            provider = new local_storage_provider_1.LocalStorageProvider(exports.StorageKey + suffix);
        }
        if (!provider) {
            provider = new memory_storage_provider_1.MemoryStorageProvider();
        }
        return new Storage(provider, suffix);
    };
    return Storage;
}());
exports.Storage = Storage;


/***/ }),
/* 173 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.makeButton = exports.makeCollection = void 0;
var helpers_1 = __webpack_require__(19);
var collection_1 = __webpack_require__(174);
var editor_collection_1 = __webpack_require__(176);
var button_1 = __webpack_require__(177);
var content_1 = __webpack_require__(179);
function makeCollection(jodit, parentElement) {
    var collection = helpers_1.isJoditObject(jodit)
        ? new editor_collection_1.ToolbarEditorCollection(jodit)
        : new collection_1.ToolbarCollection(jodit);
    if (jodit.o.textIcons) {
        collection.container.classList.add('jodit_text_icons');
    }
    if (parentElement) {
        collection.parentElement = parentElement;
    }
    if (jodit.o.toolbarButtonSize) {
        collection.buttonSize = jodit.o.toolbarButtonSize;
    }
    return collection;
}
exports.makeCollection = makeCollection;
function makeButton(jodit, control, target) {
    if (target === void 0) { target = null; }
    if (helpers_1.isFunction(control.getContent)) {
        return new content_1.ToolbarContent(jodit, control, target);
    }
    var button = new button_1.ToolbarButton(jodit, control, target);
    button.state.tabIndex = jodit.o.allowTabNavigation ? 0 : -1;
    return button;
}
exports.makeButton = makeButton;


/***/ }),
/* 174 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToolbarCollection = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(175);
var helpers_1 = __webpack_require__(19);
var ui_1 = __webpack_require__(75);
var factory_1 = __webpack_require__(173);
var decorators_1 = __webpack_require__(99);
var ToolbarCollection = (function (_super) {
    tslib_1.__extends(ToolbarCollection, _super);
    function ToolbarCollection(jodit) {
        var _this = _super.call(this, jodit) || this;
        _this.listenEvents = 'updateToolbar changeStack mousedown mouseup keydown change afterInit readonly afterResize ' +
            'selectionchange changeSelection focus afterSetMode touchstart focus blur';
        _this.update = _this.j.async.debounce(_this.immediateUpdate, function () { return _this.j.defaultTimeout; });
        _this.initEvents();
        return _this;
    }
    ToolbarCollection.prototype.className = function () {
        return 'ToolbarCollection';
    };
    Object.defineProperty(ToolbarCollection.prototype, "firstButton", {
        get: function () {
            var button = this.buttons[0];
            return button || null;
        },
        enumerable: false,
        configurable: true
    });
    ToolbarCollection.prototype.makeButton = function (control, target) {
        if (target === void 0) { target = null; }
        return factory_1.makeButton(this.j, control, target);
    };
    ToolbarCollection.prototype.shouldBeActive = function (button) {
        if (helpers_1.isJoditObject(this.j) && !this.j.editorIsActive) {
            return false;
        }
        if (helpers_1.isFunction(button.control.isActive)) {
            return button.control.isActive(this.j, button.control, button);
        }
        return undefined;
    };
    ToolbarCollection.prototype.shouldBeDisabled = function (button) {
        if (this.j.o.disabled) {
            return true;
        }
        if (this.j.o.readonly &&
            (!this.j.o.activeButtonsInReadOnly ||
                !this.j.o.activeButtonsInReadOnly.includes(button.control.name))) {
            return true;
        }
        var isDisabled;
        if (helpers_1.isFunction(button.control.isDisabled)) {
            isDisabled = button.control.isDisabled(this.j, button.control, button);
        }
        return isDisabled;
    };
    ToolbarCollection.prototype.getTarget = function (button) {
        return button.target || null;
    };
    ToolbarCollection.prototype.immediateUpdate = function () {
        if (this.isDestructed || this.j.isLocked) {
            return;
        }
        _super.prototype.update.call(this);
        this.j.e.fire('afterUpdateToolbar');
    };
    ToolbarCollection.prototype.setDirection = function (direction) {
        this.container.style.direction = direction;
        this.container.setAttribute('dir', direction);
    };
    ToolbarCollection.prototype.initEvents = function () {
        this.j.e
            .on(this.listenEvents, this.update)
            .on('afterSetMode focus', this.immediateUpdate);
    };
    ToolbarCollection.prototype.build = function (items, target) {
        if (target === void 0) { target = null; }
        var itemsWithGroupps = this.j.e.fire('beforeToolbarBuild', items);
        if (itemsWithGroupps) {
            items = itemsWithGroupps;
        }
        _super.prototype.build.call(this, items, target);
        return this;
    };
    ToolbarCollection.prototype.destruct = function () {
        if (this.isDestructed) {
            return;
        }
        this.j.e
            .off(this.listenEvents, this.update)
            .off('afterSetMode focus', this.immediateUpdate);
        _super.prototype.destruct.call(this);
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], ToolbarCollection.prototype, "immediateUpdate", null);
    ToolbarCollection = tslib_1.__decorate([
        decorators_1.component
    ], ToolbarCollection);
    return ToolbarCollection;
}(ui_1.UIList));
exports.ToolbarCollection = ToolbarCollection;


/***/ }),
/* 175 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 176 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToolbarEditorCollection = void 0;
var tslib_1 = __webpack_require__(7);
var collection_1 = __webpack_require__(174);
var consts = __webpack_require__(9);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var decorators_1 = __webpack_require__(99);
var ToolbarEditorCollection = (function (_super) {
    tslib_1.__extends(ToolbarEditorCollection, _super);
    function ToolbarEditorCollection(jodit) {
        var _this = _super.call(this, jodit) || this;
        _this.checkActiveStatus = function (cssObject, node) {
            var matches = 0, total = 0;
            Object.keys(cssObject).forEach(function (cssProperty) {
                var cssValue = cssObject[cssProperty];
                if (helpers_1.isFunction(cssValue)) {
                    if (cssValue(_this.j, helpers_1.css(node, cssProperty).toString())) {
                        matches += 1;
                    }
                }
                else {
                    if (cssValue.indexOf(helpers_1.css(node, cssProperty).toString()) !== -1) {
                        matches += 1;
                    }
                }
                total += 1;
            });
            return total === matches;
        };
        _this.prependInvisibleInput(_this.container);
        return _this;
    }
    ToolbarEditorCollection.prototype.className = function () {
        return 'ToolbarEditorCollection';
    };
    ToolbarEditorCollection.prototype.shouldBeDisabled = function (button) {
        var disabled = _super.prototype.shouldBeDisabled.call(this, button);
        if (disabled !== undefined) {
            return disabled;
        }
        var mode = button.control.mode === undefined
            ? consts.MODE_WYSIWYG
            : button.control.mode;
        return !(mode === consts.MODE_SPLIT || mode === this.j.getRealMode());
    };
    ToolbarEditorCollection.prototype.shouldBeActive = function (button) {
        var _this = this;
        var active = _super.prototype.shouldBeActive.call(this, button);
        if (active !== undefined) {
            return active;
        }
        var element = this.j.selection ? this.j.s.current() : null;
        if (!element) {
            return false;
        }
        var elm;
        if (button.control.tags) {
            var tags_1 = button.control.tags;
            elm = element;
            if (dom_1.Dom.up(elm, function (node) {
                if (node &&
                    tags_1.indexOf(node.nodeName.toLowerCase()) !== -1) {
                    return true;
                }
            }, this.j.editor)) {
                return true;
            }
        }
        if (button.control.css) {
            var css_1 = button.control.css;
            elm = element;
            if (dom_1.Dom.up(elm, function (node) {
                if (node && !dom_1.Dom.isText(node)) {
                    return _this.checkActiveStatus(css_1, node);
                }
            }, this.j.editor)) {
                return true;
            }
        }
        return false;
    };
    ToolbarEditorCollection.prototype.getTarget = function (button) {
        return button.target || this.j.s.current() || null;
    };
    ToolbarEditorCollection.prototype.prependInvisibleInput = function (container) {
        var input = this.j.create.element('input', {
            tabIndex: -1,
            style: 'width: 0; height:0; position: absolute; visibility: hidden;'
        });
        dom_1.Dom.appendChildFirst(container, input);
    };
    ToolbarEditorCollection = tslib_1.__decorate([
        decorators_1.component
    ], ToolbarEditorCollection);
    return ToolbarEditorCollection;
}(collection_1.ToolbarCollection));
exports.ToolbarEditorCollection = ToolbarEditorCollection;


/***/ }),
/* 177 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToolbarButton = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(178);
var button_1 = __webpack_require__(92);
var decorators_1 = __webpack_require__(99);
var dom_1 = __webpack_require__(32);
var popup_1 = __webpack_require__(116);
var factory_1 = __webpack_require__(173);
var helpers_1 = __webpack_require__(19);
var ui_1 = __webpack_require__(75);
var collection_1 = __webpack_require__(174);
var component_1 = __webpack_require__(27);
var get_control_type_1 = __webpack_require__(98);
var ToolbarButton = (function (_super) {
    tslib_1.__extends(ToolbarButton, _super);
    function ToolbarButton(jodit, control, target) {
        if (target === void 0) { target = null; }
        var _this = _super.call(this, jodit) || this;
        _this.control = control;
        _this.target = target;
        _this.state = tslib_1.__assign(tslib_1.__assign({}, button_1.UIButtonState()), { theme: 'toolbar', currentValue: '', hasTrigger: false });
        jodit.e.on([_this.button, _this.trigger], 'mousedown', function (e) {
            return e.preventDefault();
        });
        _this.onAction(_this.onClick);
        _this.hookStatus(component_1.STATUSES.ready, function () {
            _this.initFromControl();
            _this.initTooltip();
            _this.update();
        });
        return _this;
    }
    ToolbarButton.prototype.className = function () {
        return 'ToolbarButton';
    };
    Object.defineProperty(ToolbarButton.prototype, "toolbar", {
        get: function () {
            return this.closest(collection_1.ToolbarCollection);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ToolbarButton.prototype, "button", {
        get: function () {
            return this.container.querySelector("button." + this.componentName + "__button");
        },
        enumerable: false,
        configurable: true
    });
    ToolbarButton.prototype.update = function () {
        var _a = this, control = _a.control, state = _a.state, tc = this.closest(collection_1.ToolbarCollection);
        if (tc) {
            state.disabled = Boolean(tc.shouldBeDisabled(this));
            state.activated = Boolean(tc.shouldBeActive(this));
        }
        if (helpers_1.isFunction(control.update)) {
            control.update(this);
        }
        _super.prototype.update.call(this);
    };
    ToolbarButton.prototype.onChangeActivated = function () {
        helpers_1.attr(this.button, 'aria-pressed', this.state.activated);
        _super.prototype.onChangeActivated.call(this);
    };
    ToolbarButton.prototype.onChangeText = function () {
        if (helpers_1.isFunction(this.control.template)) {
            this.text.innerHTML = this.control.template(this.j, this.control.name, this.j.i18n(this.state.text));
        }
        else {
            _super.prototype.onChangeText.call(this);
        }
        this.setMod('text-icons', Boolean(this.text.innerText.trim().length));
    };
    ToolbarButton.prototype.onChangeTabIndex = function () {
        helpers_1.attr(this.button, 'tabIndex', this.state.tabIndex);
    };
    ToolbarButton.prototype.createContainer = function () {
        var cn = this.componentName;
        var container = this.j.c.span(cn), button = _super.prototype.createContainer.call(this);
        helpers_1.attr(container, 'role', 'listitem');
        button.classList.remove(cn);
        button.classList.add(cn + '__button');
        Object.defineProperty(button, 'component', {
            value: this
        });
        container.appendChild(button);
        this.trigger = this.j.c.fromHTML("<span role=\"trigger\" class=\"" + cn + "__trigger\">" + ui_1.Icon.get('chevron') + "</span>");
        this.j.e.on(this.trigger, 'click', this.onTriggerClick.bind(this));
        return container;
    };
    ToolbarButton.prototype.focus = function () {
        var _a;
        (_a = this.container.querySelector('button')) === null || _a === void 0 ? void 0 : _a.focus();
    };
    ToolbarButton.prototype.onChangeHasTrigger = function () {
        if (this.state.hasTrigger) {
            this.container.appendChild(this.trigger);
        }
        else {
            dom_1.Dom.safeRemove(this.trigger);
        }
        this.setMod('with-trigger', this.state.hasTrigger || null);
    };
    ToolbarButton.prototype.onChangeDisabled = function () {
        var dsb = this.state.disabled ? 'disabled' : null;
        helpers_1.attr(this.trigger, 'disabled', dsb);
        helpers_1.attr(this.button, 'disabled', dsb);
        helpers_1.attr(this.container, 'disabled', dsb);
    };
    ToolbarButton.prototype.initTooltip = function () {
        var _this = this;
        if (!this.j.o.textIcons &&
            this.j.o.showTooltip &&
            !this.j.o.useNativeTooltip) {
            this.j.e
                .off(this.container, 'mouseenter mouseleave')
                .on(this.container, 'mousemove', function (e) {
                if (!_this.state.tooltip) {
                    return;
                }
                !_this.state.disabled &&
                    _this.j.e.fire('delayShowTooltip', function () { return ({
                        x: e.clientX + 10,
                        y: e.clientY + 10
                    }); }, _this.state.tooltip);
            })
                .on(this.container, 'mouseleave', function () {
                _this.j.e.fire('hideTooltip');
            });
        }
    };
    ToolbarButton.prototype.initFromControl = function () {
        var _a;
        var _b = this, ctr = _b.control, state = _b.state;
        this.updateSize();
        state.name = ctr.name;
        var textIcons = this.j.o.textIcons;
        if (textIcons === true ||
            (helpers_1.isFunction(textIcons) && textIcons(ctr.name)) ||
            ctr.template) {
            state.icon = button_1.UIButtonState().icon;
            state.text = ctr.text || ctr.name;
        }
        else {
            if (ctr.iconURL) {
                state.icon.iconURL = ctr.iconURL;
            }
            else {
                var name_1 = ctr.icon || ctr.name;
                state.icon.name =
                    ui_1.Icon.exists(name_1) || ((_a = this.j.o.extraIcons) === null || _a === void 0 ? void 0 : _a[name_1])
                        ? name_1
                        : '';
            }
            if (!ctr.iconURL && !state.icon.name) {
                state.text = ctr.text || ctr.name;
            }
        }
        if (ctr.tooltip) {
            state.tooltip = this.j.i18n(helpers_1.isFunction(ctr.tooltip)
                ? ctr.tooltip(this.j, ctr, this)
                : ctr.tooltip);
        }
        state.hasTrigger = Boolean(ctr.list || (ctr.popup && ctr.exec));
    };
    ToolbarButton.prototype.onTriggerClick = function (e) {
        var _this = this;
        var _a, _b, _c;
        var ctr = this.control;
        e.buffer = {
            actionTrigger: this
        };
        if (ctr.list) {
            return this.openControlList(ctr);
        }
        if (helpers_1.isFunction(ctr.popup)) {
            var popup = new popup_1.Popup(this.j);
            popup.parentElement = this;
            if (this.j.e.fire(helpers_1.camelCase("before-" + ctr.name + "-open-popup"), this.target, ctr, popup) !== false) {
                var target = (_c = (_b = (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.getTarget(this)) !== null && _b !== void 0 ? _b : this.target) !== null && _c !== void 0 ? _c : null;
                var elm = ctr.popup(this.j, target, ctr, popup.close, this);
                if (elm) {
                    popup
                        .setContent(helpers_1.isString(elm) ? this.j.c.fromHTML(elm) : elm)
                        .open(function () { return helpers_1.position(_this.container); });
                }
            }
            this.j.e.fire(helpers_1.camelCase("after-" + ctr.name + "-open-popup"), popup.container);
        }
    };
    ToolbarButton.prototype.openControlList = function (control) {
        var _this = this;
        var _a;
        var controls = (_a = this.jodit.options.controls) !== null && _a !== void 0 ? _a : {}, getControl = function (key) {
            return get_control_type_1.findControlType(key, controls);
        };
        var list = control.list, menu = new popup_1.Popup(this.j), toolbar = factory_1.makeCollection(this.j);
        menu.parentElement = this;
        toolbar.parentElement = menu;
        toolbar.mode = 'vertical';
        var getButton = function (key, value) {
            if (helpers_1.isString(value) && getControl(value)) {
                return tslib_1.__assign({ name: value.toString() }, getControl(value));
            }
            if (helpers_1.isString(key) && getControl(key)) {
                return tslib_1.__assign(tslib_1.__assign({ name: key.toString() }, getControl(key)), (typeof value === 'object' ? value : {}));
            }
            var childControl = {
                name: key.toString(),
                template: control.childTemplate,
                exec: control.exec,
                data: control.data,
                command: control.command,
                isActive: control.isChildActive,
                isDisabled: control.isChildDisabled,
                mode: control.mode,
                args: tslib_1.__spreadArray(tslib_1.__spreadArray([], (control.args ? control.args : [])), [key, value])
            };
            if (helpers_1.isString(value)) {
                childControl.text = value;
            }
            return childControl;
        };
        toolbar.build(helpers_1.isArray(list)
            ? list.map(getButton)
            : helpers_1.keys(list, false).map(function (key) { return getButton(key, list[key]); }), this.target);
        menu.setContent(toolbar.container).open(function () { return helpers_1.position(_this.container); });
        this.state.activated = true;
        this.j.e.on(menu, 'afterClose', function () {
            _this.state.activated = false;
        });
    };
    ToolbarButton.prototype.onClick = function (originalEvent) {
        var _a, _b, _c, _d, _e, _f, _g;
        var ctr = this.control;
        if (helpers_1.isFunction(ctr.exec)) {
            var target = (_c = (_b = (_a = this.toolbar) === null || _a === void 0 ? void 0 : _a.getTarget(this)) !== null && _b !== void 0 ? _b : this.target) !== null && _c !== void 0 ? _c : null;
            var result = ctr.exec(this.j, target, {
                control: ctr,
                originalEvent: originalEvent,
                button: this
            });
            if (result !== false && result !== true) {
                (_e = (_d = this.j) === null || _d === void 0 ? void 0 : _d.e) === null || _e === void 0 ? void 0 : _e.fire('synchro');
                if (this.parentElement) {
                    this.parentElement.update();
                }
                (_g = (_f = this.j) === null || _f === void 0 ? void 0 : _f.e) === null || _g === void 0 ? void 0 : _g.fire('closeAllPopups afterExec');
            }
            if (result !== false) {
                return;
            }
        }
        if (ctr.list) {
            return this.openControlList(ctr);
        }
        if (helpers_1.isFunction(ctr.popup)) {
            return this.onTriggerClick(originalEvent);
        }
        if (ctr.command || ctr.name) {
            helpers_1.call(helpers_1.isJoditObject(this.j)
                ? this.j.execCommand.bind(this.j)
                : this.j.od.execCommand.bind(this.j.od), ctr.command || ctr.name, false, ctr.args && ctr.args[0]);
            this.j.e.fire('closeAllPopups');
        }
    };
    tslib_1.__decorate([
        decorators_1.watch('state.hasTrigger')
    ], ToolbarButton.prototype, "onChangeHasTrigger", null);
    ToolbarButton = tslib_1.__decorate([
        decorators_1.component
    ], ToolbarButton);
    return ToolbarButton;
}(button_1.UIButton));
exports.ToolbarButton = ToolbarButton;


/***/ }),
/* 178 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 179 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToolbarContent = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(180);
var button_1 = __webpack_require__(92);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var decorators_1 = __webpack_require__(99);
var ToolbarContent = (function (_super) {
    tslib_1.__extends(ToolbarContent, _super);
    function ToolbarContent(jodit, control, target) {
        if (target === void 0) { target = null; }
        var _this = _super.call(this, jodit) || this;
        _this.control = control;
        _this.target = target;
        _this.container.classList.add(_this.componentName + "_" + _this.clearName(control.name));
        helpers_1.attr(_this.container, 'role', 'content');
        return _this;
    }
    ToolbarContent.prototype.className = function () {
        return 'ToolbarContent';
    };
    ToolbarContent.prototype.update = function () {
        var content = this.control.getContent(this.j, this.control, this);
        if (helpers_1.isString(content) || content.parentNode !== this.container) {
            dom_1.Dom.detach(this.container);
            this.container.appendChild(helpers_1.isString(content) ? this.j.create.fromHTML(content) : content);
        }
        _super.prototype.update.call(this);
    };
    ToolbarContent.prototype.createContainer = function () {
        return this.j.c.span(this.componentName);
    };
    ToolbarContent = tslib_1.__decorate([
        decorators_1.component
    ], ToolbarContent);
    return ToolbarContent;
}(button_1.UIButton));
exports.ToolbarContent = ToolbarContent;


/***/ }),
/* 180 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 181 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Alert = void 0;
var dialog_1 = __webpack_require__(164);
var helpers_1 = __webpack_require__(19);
var dom_1 = __webpack_require__(32);
var ui_1 = __webpack_require__(75);
var Alert = function (msg, title, callback, className) {
    if (className === void 0) { className = 'jodit-dialog_alert'; }
    if (helpers_1.isFunction(title)) {
        callback = title;
        title = undefined;
    }
    var dialog = new dialog_1.Dialog(), container = dialog.c.div(className), okButton = ui_1.Button(dialog, 'ok', 'Ok');
    helpers_1.asArray(msg).forEach(function (oneMessage) {
        container.appendChild(dom_1.Dom.isNode(oneMessage, dialog.ow)
            ? oneMessage
            : dialog.c.fromHTML(oneMessage));
    });
    okButton.onAction(function () {
        if (!callback || !helpers_1.isFunction(callback) || callback(dialog) !== false) {
            dialog.close();
        }
    });
    dialog.setFooter([okButton]);
    dialog.open(container, title || '&nbsp;', true, true);
    okButton.focus();
    return dialog;
};
exports.Alert = Alert;


/***/ }),
/* 182 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Prompt = void 0;
var dialog_1 = __webpack_require__(164);
var ui_1 = __webpack_require__(75);
var helpers_1 = __webpack_require__(19);
var Prompt = function (msg, title, callback, placeholder, defaultValue) {
    var dialog = new dialog_1.Dialog(), cancelButton = ui_1.Button(dialog, 'cancel', 'Cancel'), okButton = ui_1.Button(dialog, 'ok', 'Ok'), form = dialog.c.element('form', {
        class: 'jodit-dialog_prompt'
    }), inputElement = dialog.c.element('input', {
        autofocus: true,
        class: 'jodit-input'
    }), labelElement = dialog.c.element('label');
    if (helpers_1.isFunction(title)) {
        callback = title;
        title = undefined;
    }
    if (placeholder) {
        helpers_1.attr(inputElement, 'placeholder', placeholder);
    }
    labelElement.appendChild(dialog.c.text(msg));
    form.appendChild(labelElement);
    form.appendChild(inputElement);
    cancelButton.onAction(dialog.close);
    var onclick = function () {
        if (!callback ||
            !helpers_1.isFunction(callback) ||
            callback(inputElement.value) !== false) {
            dialog.close();
        }
    };
    okButton.onAction(onclick);
    dialog.e.on(form, 'submit', function () {
        onclick();
        return false;
    });
    dialog.setFooter([okButton, cancelButton]);
    dialog.open(form, title || '&nbsp;', true, true);
    inputElement.focus();
    if (defaultValue !== undefined && defaultValue.length) {
        inputElement.value = defaultValue;
        inputElement.select();
    }
    return dialog;
};
exports.Prompt = Prompt;


/***/ }),
/* 183 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Confirm = void 0;
var dialog_1 = __webpack_require__(164);
var helpers_1 = __webpack_require__(19);
var ui_1 = __webpack_require__(75);
var Confirm = function (msg, title, callback) {
    var dialog = new dialog_1.Dialog(), $div = dialog.c.fromHTML('<form class="jodit-dialog_prompt"></form>'), $label = dialog.c.element('label');
    if (helpers_1.isFunction(title)) {
        callback = title;
        title = undefined;
    }
    $label.appendChild(dialog.c.fromHTML(msg));
    $div.appendChild($label);
    var action = function (yes) { return function () {
        if (!callback || callback(yes) !== false) {
            dialog.close();
        }
    }; };
    var $cancel = ui_1.Button(dialog, 'cancel', 'Cancel');
    var $ok = ui_1.Button(dialog, 'ok', 'Yes');
    $cancel.onAction(action(false));
    $ok.onAction(action(true));
    dialog.e.on($div, 'submit', function () {
        action(true)();
        return false;
    });
    dialog.setFooter([$ok, $cancel]);
    dialog.open($div, title || '&nbsp;', true, true);
    $ok.focus();
    return dialog;
};
exports.Confirm = Confirm;


/***/ }),
/* 184 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Plugin = void 0;
var tslib_1 = __webpack_require__(7);
var component_1 = __webpack_require__(27);
var decorators_1 = __webpack_require__(99);
var helpers_1 = __webpack_require__(19);
var Plugin = (function (_super) {
    tslib_1.__extends(Plugin, _super);
    function Plugin(jodit) {
        var _this = _super.call(this, jodit) || this;
        _this.requires = [];
        _this.buttons = [];
        _this.hasStyle = false;
        jodit.e
            .on('afterPluginSystemInit', function () {
            var _a;
            if (helpers_1.isJoditObject(jodit)) {
                (_a = _this.buttons) === null || _a === void 0 ? void 0 : _a.forEach(function (btn) {
                    jodit.registerButton(btn);
                });
            }
        })
            .on('afterInit', function () {
            _this.setStatus(component_1.STATUSES.ready);
            _this.afterInit(jodit);
        })
            .on('beforeDestruct', _this.destruct);
        return _this;
    }
    Plugin.prototype.className = function () {
        return '';
    };
    Plugin.prototype.init = function (jodit) {
    };
    Plugin.prototype.destruct = function () {
        var _a, _b, _c;
        if (!this.isInDestruct) {
            this.setStatus(component_1.STATUSES.beforeDestruct);
            var j_1 = this.j;
            if (helpers_1.isJoditObject(j_1)) {
                (_a = this.buttons) === null || _a === void 0 ? void 0 : _a.forEach(function (btn) {
                    j_1 === null || j_1 === void 0 ? void 0 : j_1.unregisterButton(btn);
                });
            }
            (_c = (_b = this.j) === null || _b === void 0 ? void 0 : _b.events) === null || _c === void 0 ? void 0 : _c.off('beforeDestruct', this.destruct);
            this.beforeDestruct(this.j);
            _super.prototype.destruct.call(this);
        }
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], Plugin.prototype, "destruct", null);
    return Plugin;
}(component_1.ViewComponent));
exports.Plugin = Plugin;


/***/ }),
/* 185 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Create = void 0;
var helpers_1 = __webpack_require__(19);
var dom_1 = __webpack_require__(32);
var constants_1 = __webpack_require__(9);
var Create = (function () {
    function Create(document, createAttributes) {
        this.document = document;
        this.createAttributes = createAttributes;
        this.applyAttributes = function (elm, attrs) {
            helpers_1.each(attrs, function (key, value) {
                if (helpers_1.isPlainObject(value) && key === 'style') {
                    helpers_1.css(elm, value);
                }
                else {
                    if (key === 'className') {
                        key = 'class';
                    }
                    elm.setAttribute(helpers_1.kebabCase(key), value.toString());
                }
            });
        };
    }
    Object.defineProperty(Create.prototype, "doc", {
        get: function () {
            return helpers_1.isFunction(this.document) ? this.document() : this.document;
        },
        enumerable: false,
        configurable: true
    });
    Create.prototype.element = function (tagName, childrenOrAttributes, children) {
        var _this = this;
        var elm = this.doc.createElement(tagName.toLowerCase());
        this.applyCreateAttributes(elm);
        if (childrenOrAttributes) {
            if (helpers_1.isPlainObject(childrenOrAttributes)) {
                this.applyAttributes(elm, childrenOrAttributes);
            }
            else {
                children = childrenOrAttributes;
            }
        }
        if (children) {
            helpers_1.asArray(children).forEach(function (child) {
                return elm.appendChild(typeof child === 'string' ? _this.fromHTML(child) : child);
            });
        }
        return elm;
    };
    Create.prototype.div = function (className, childrenOrAttributes, children) {
        var div = this.element('div', childrenOrAttributes, children);
        if (className) {
            div.className = className;
        }
        return div;
    };
    Create.prototype.span = function (className, childrenOrAttributes, children) {
        var span = this.element('span', childrenOrAttributes, children);
        if (className) {
            span.className = className;
        }
        return span;
    };
    Create.prototype.a = function (className, childrenOrAttributes, children) {
        var a = this.element('a', childrenOrAttributes, children);
        if (className) {
            a.className = className;
        }
        return a;
    };
    Create.prototype.text = function (value) {
        return this.doc.createTextNode(value);
    };
    Create.prototype.fake = function () {
        return this.text(constants_1.INVISIBLE_SPACE);
    };
    Create.prototype.fragment = function () {
        return this.doc.createDocumentFragment();
    };
    Create.prototype.fromHTML = function (html, refsToggleElement) {
        var div = this.div();
        div.innerHTML = html.toString();
        var child = div.firstChild !== div.lastChild || !div.firstChild
            ? div
            : div.firstChild;
        dom_1.Dom.safeRemove(child);
        if (refsToggleElement) {
            var refElements_1 = helpers_1.refs(child);
            Object.keys(refsToggleElement).forEach(function (key) {
                var elm = refElements_1[key];
                if (elm && refsToggleElement[key] === false) {
                    dom_1.Dom.hide(elm);
                }
            });
        }
        return child;
    };
    Create.prototype.applyCreateAttributes = function (elm) {
        if (this.createAttributes) {
            var ca = this.createAttributes;
            if (ca && ca[elm.tagName.toLowerCase()]) {
                var attrs = ca[elm.tagName.toLowerCase()];
                if (helpers_1.isFunction(attrs)) {
                    attrs(elm);
                }
                else if (helpers_1.isPlainObject(attrs)) {
                    this.applyAttributes(elm, attrs);
                }
            }
        }
    };
    return Create;
}());
exports.Create = Create;


/***/ }),
/* 186 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileBrowser = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(187);
var config_1 = __webpack_require__(8);
var consts = __webpack_require__(9);
var dialog_1 = __webpack_require__(163);
var storage_1 = __webpack_require__(169);
var helpers_1 = __webpack_require__(19);
var view_with_toolbar_1 = __webpack_require__(166);
__webpack_require__(188);
var dom_1 = __webpack_require__(32);
var events_1 = __webpack_require__(11);
var consts_1 = __webpack_require__(189);
var factories_1 = __webpack_require__(190);
var state_listeners_1 = __webpack_require__(193);
var native_listeners_1 = __webpack_require__(194);
var self_listeners_1 = __webpack_require__(199);
var data_provider_1 = __webpack_require__(191);
var decorators_1 = __webpack_require__(99);
var FileBrowser = (function (_super) {
    tslib_1.__extends(FileBrowser, _super);
    function FileBrowser(options) {
        var _a;
        var _this = _super.call(this, options) || this;
        _this.loader = _this.c.div(consts_1.F_CLASS + '__loader', consts_1.ICON_LOADER);
        _this.browser = _this.c.div(consts_1.F_CLASS + ' non-selected');
        _this.status_line = _this.c.div(consts_1.F_CLASS + '__status');
        _this.tree = _this.c.div(consts_1.F_CLASS + '__tree');
        _this.files = _this.c.div(consts_1.F_CLASS + '__files');
        _this.state = events_1.ObserveObject.create({
            currentPath: '',
            currentSource: data_provider_1.DEFAULT_SOURCE_NAME,
            currentBaseUrl: '',
            activeElements: [],
            elements: [],
            messages: [],
            sources: [],
            view: 'tiles',
            sortBy: 'changed-desc',
            filterWord: '',
            onlyImages: false
        });
        _this.errorHandler = function (resp) {
            if (resp instanceof Error) {
                _this.status(_this.i18n(resp.message));
            }
            else {
                _this.status(_this.dataProvider.getMessage(resp));
            }
        };
        _this.close = function () {
            _this.dialog.close();
        };
        _this.elementsMap = {};
        _this.attachEvents(options);
        var self = _this;
        self.options = helpers_1.ConfigProto(options || {}, config_1.Config.defaultOptions.filebrowser);
        self.storage = storage_1.Storage.makeStorage(_this.o.saveStateInStorage);
        self.dataProvider = factories_1.makeDataProvider(self, self.options);
        self.dialog = new dialog_1.Dialog({
            fullsize: self.o.fullsize,
            ownerWindow: self.ownerWindow,
            theme: self.o.theme,
            globalFullSize: self.o.globalFullSize,
            language: _this.o.language,
            minWidth: Math.min(700, screen.width),
            minHeight: 300,
            buttons: (_a = _this.o.headerButtons) !== null && _a !== void 0 ? _a : ['fullsize', 'dialog.close']
        });
        ['afterClose', 'beforeOpen'].forEach(function (proxyEvent) {
            self.dialog.events.on(self.dialog, proxyEvent, function () {
                _this.e.fire(proxyEvent);
            });
        });
        if (self.o.showFoldersPanel) {
            self.browser.appendChild(self.tree);
        }
        self.browser.appendChild(self.files);
        self.browser.appendChild(self.status_line);
        self_listeners_1.selfListeners.call(self);
        native_listeners_1.nativeListeners.call(self);
        state_listeners_1.stateListeners.call(self);
        self.dialog.setSize(self.o.width, self.o.height);
        var keys = [
            'getLocalFileByUrl',
            'crop',
            'resize',
            'create',
            'fileMove',
            'folderMove',
            'fileRename',
            'folderRename',
            'fileRemove',
            'folderRemove',
            'folder',
            'items',
            'permissions'
        ];
        keys.forEach(function (key) {
            if (_this.options[key] != null) {
                _this.options[key] = helpers_1.ConfigProto(_this.options[key], _this.o.ajax);
            }
        });
        var view = _this.storage.get(consts_1.F_CLASS + '_view');
        if (view && _this.o.view == null) {
            self.state.view = view === 'list' ? 'list' : 'tiles';
        }
        else {
            self.state.view = self.o.view === 'list' ? 'list' : 'tiles';
        }
        _this.state.fire('change.view');
        var sortBy = self.storage.get(consts_1.F_CLASS + '_sortby');
        if (sortBy) {
            var parts = sortBy.split('-');
            self.state.sortBy = ['changed', 'name', 'size'].includes(parts[0])
                ? sortBy
                : 'changed-desc';
        }
        else {
            self.state.sortBy = self.o.sortBy || 'changed-desc';
        }
        self.initUploader(self);
        return _this;
    }
    FileBrowser.prototype.className = function () {
        return 'FileBrowser';
    };
    FileBrowser.prototype.loadItems = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                this.files.classList.add('jodit-filebrowser_active');
                this.files.appendChild(this.loader.cloneNode(true));
                return [2, this.dataProvider
                        .items(this.state.currentPath, this.state.currentSource, {
                        sortBy: this.state.sortBy,
                        onlyImages: this.state.onlyImages,
                        filterWord: this.state.filterWord
                    })
                        .then(function (resp) {
                        _this.state.elements = resp;
                        _this.state.activeElements = [];
                    })
                        .catch(this.status)];
            });
        });
    };
    FileBrowser.prototype.loadTree = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var errorUni, items, tree;
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                errorUni = function (e) {
                    throw e instanceof Error ? e : helpers_1.error(e);
                };
                if (this.uploader) {
                    this.uploader.setPath(this.state.currentPath);
                    this.uploader.setSource(this.state.currentSource);
                }
                this.tree.classList.add('jodit-filebrowser_active');
                dom_1.Dom.detach(this.tree);
                this.tree.appendChild(this.loader.cloneNode(true));
                items = this.loadItems();
                if (this.o.showFoldersPanel) {
                    tree = this.dataProvider
                        .tree(this.state.currentPath, this.state.currentSource)
                        .then(function (resp) {
                        _this.state.sources = resp;
                    })
                        .catch(function (e) {
                        _this.errorHandler(errorUni(_this.i18n('Error on load folders')));
                        errorUni(e);
                    });
                    return [2, Promise.all([tree, items]).catch(helpers_1.error)];
                }
                else {
                    this.tree.classList.remove('jodit-filebrowser_active');
                }
                return [2, items.catch(helpers_1.error)];
            });
        });
    };
    FileBrowser.prototype.deleteFile = function (name, source) {
        var _this = this;
        return this.dataProvider
            .fileRemove(this.state.currentPath, name, source)
            .then(function (message) {
            _this.status(message || _this.i18n('File "%s" was deleted', name), true);
        })
            .catch(this.status);
    };
    FileBrowser.prototype.onSelect = function (callback) {
        var _this = this;
        return function () {
            if (_this.state.activeElements.length) {
                var files_1 = [];
                var isImages_1 = [];
                _this.state.activeElements.forEach(function (elm) {
                    var url = elm.fileURL;
                    if (url) {
                        files_1.push(url);
                        isImages_1.push(elm.isImage || false);
                    }
                });
                _this.close();
                var data = {
                    baseurl: '',
                    files: files_1,
                    isImages: isImages_1
                };
                if (helpers_1.isFunction(callback)) {
                    callback(data);
                }
                _this.close();
            }
            return false;
        };
    };
    Object.defineProperty(FileBrowser.prototype, "isOpened", {
        get: function () {
            return this.dialog.isOpened && this.browser.style.display !== 'none';
        },
        enumerable: false,
        configurable: true
    });
    FileBrowser.prototype.status = function (message, success) {
        var _this = this;
        if (!helpers_1.isString(message)) {
            message = message.message;
        }
        this.status_line.classList.remove('jodit-filebrowser_success');
        this.status_line.classList.add('jodit-filebrowser_active');
        var messageBox = this.c.div();
        messageBox.textContent = message;
        this.status_line.appendChild(messageBox);
        if (success) {
            this.status_line.classList.add('jodit-filebrowser_success');
        }
        this.async.setTimeout(function () {
            _this.status_line.classList.remove('jodit-filebrowser_active');
            dom_1.Dom.detach(_this.status_line);
        }, {
            timeout: this.o.howLongShowMsg,
            label: 'fileBrowser.status'
        });
    };
    FileBrowser.prototype.open = function (callback, onlyImages) {
        var _this = this;
        if (callback === void 0) { callback = this.o
            .defaultCallback; }
        if (onlyImages === void 0) { onlyImages = false; }
        this.state.onlyImages = onlyImages;
        return this.async.promise(function (resolve, reject) {
            var _a;
            if (!_this.o.items || !_this.o.items.url) {
                throw helpers_1.error('Need set options.filebrowser.ajax.url');
            }
            var localTimeout = 0;
            _this.e
                .off(_this.files, 'dblclick')
                .on(_this.files, 'dblclick', _this.onSelect(callback))
                .on(_this.files, 'touchstart', function () {
                var now = new Date().getTime();
                if (now - localTimeout < consts.EMULATE_DBLCLICK_TIMEOUT) {
                    _this.onSelect(callback)();
                }
                localTimeout = now;
            })
                .off('select.filebrowser')
                .on('select.filebrowser', _this.onSelect(callback));
            var header = _this.c.div();
            _this.toolbar.build((_a = _this.o.buttons) !== null && _a !== void 0 ? _a : []).appendTo(header);
            _this.dialog.open(_this.browser, header);
            _this.e.fire('sort.filebrowser', _this.state.sortBy);
            _this.loadTree().then(resolve, reject);
        });
    };
    FileBrowser.prototype.initUploader = function (editor) {
        var _this = this;
        var _a;
        var self = this, options = (_a = editor === null || editor === void 0 ? void 0 : editor.options) === null || _a === void 0 ? void 0 : _a.uploader, uploaderOptions = helpers_1.ConfigProto(options || {}, config_1.Config.defaultOptions.uploader);
        var uploadHandler = function () {
            return _this.loadItems();
        };
        self.uploader = self.getInstance('Uploader', uploaderOptions);
        self.uploader.setPath(self.state.currentPath);
        self.uploader.setSource(self.state.currentSource);
        self.uploader.bind(self.browser, uploadHandler, self.errorHandler);
        self.e.on('bindUploader.filebrowser', function (button) {
            self.uploader.bind(button, uploadHandler, self.errorHandler);
        });
    };
    FileBrowser.prototype.destruct = function () {
        if (this.isInDestruct) {
            return;
        }
        this.dialog.destruct();
        this.events && this.e.off('.filebrowser');
        this.uploader && this.uploader.destruct();
        _super.prototype.destruct.call(this);
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], FileBrowser.prototype, "status", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], FileBrowser.prototype, "open", null);
    return FileBrowser;
}(view_with_toolbar_1.ViewWithToolbar));
exports.FileBrowser = FileBrowser;


/***/ }),
/* 187 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 188 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
var config_1 = __webpack_require__(8);
var helpers_1 = __webpack_require__(19);
var consts_1 = __webpack_require__(189);
var ui_1 = __webpack_require__(75);
config_1.Config.prototype.filebrowser = {
    namespace: '',
    extraButtons: [],
    filter: function (item, search) {
        search = search.toLowerCase();
        if (helpers_1.isString(item)) {
            return item.toLowerCase().indexOf(search) !== -1;
        }
        if (helpers_1.isString(item.name)) {
            return item.name.toLowerCase().indexOf(search) !== -1;
        }
        if (helpers_1.isString(item.file)) {
            return item.file.toLowerCase().indexOf(search) !== -1;
        }
        return true;
    },
    sortBy: 'changed-desc',
    sort: function (a, b, sortBy) {
        var _a = sortBy.toLowerCase().split('-'), sortAttr = _a[0], arrow = _a[1], asc = arrow === 'asc';
        var compareStr = function (f, s) {
            if (f < s) {
                return asc ? -1 : 1;
            }
            if (f > s) {
                return asc ? 1 : -1;
            }
            return 0;
        };
        if (helpers_1.isString(a)) {
            return compareStr(a.toLowerCase(), b.toLowerCase());
        }
        if (a[sortAttr] === undefined || sortAttr === 'name') {
            if (helpers_1.isString(a.name)) {
                return compareStr(a.name.toLowerCase(), b.name.toLowerCase());
            }
            if (helpers_1.isString(a.file)) {
                return compareStr(a.file.toLowerCase(), b.file.toLowerCase());
            }
            return 0;
        }
        switch (sortAttr) {
            case 'changed': {
                var f = new Date(a.changed).getTime(), s = new Date(b.changed).getTime();
                return asc ? f - s : s - f;
            }
            case 'size': {
                var f = helpers_1.humanSizeToBytes(a.size), s = helpers_1.humanSizeToBytes(b.size);
                return asc ? f - s : s - f;
            }
        }
        return 0;
    },
    editImage: true,
    preview: true,
    showPreviewNavigation: true,
    showSelectButtonInPreview: true,
    contextMenu: true,
    howLongShowMsg: 3000,
    createNewFolder: true,
    deleteFolder: true,
    renameFolder: true,
    moveFolder: true,
    moveFile: true,
    showFoldersPanel: true,
    width: 859,
    height: 400,
    buttons: [
        'filebrowser.upload',
        'filebrowser.remove',
        'filebrowser.update',
        'filebrowser.select',
        'filebrowser.edit',
        '|',
        'filebrowser.tiles',
        'filebrowser.list',
        '|',
        'filebrowser.filter',
        '|',
        'filebrowser.sort'
    ],
    removeButtons: [],
    fullsize: false,
    showTooltip: true,
    view: null,
    isSuccess: function (resp) {
        return resp.success;
    },
    getMessage: function (resp) {
        return resp.data.messages !== undefined && helpers_1.isArray(resp.data.messages)
            ? resp.data.messages.join(' ')
            : '';
    },
    showFileName: true,
    showFileSize: true,
    showFileChangeTime: true,
    saveStateInStorage: true,
    pixelOffsetLoadNewChunk: 200,
    getThumbTemplate: function (item, source, source_name) {
        var opt = this.options, showName = opt.showFileName, showSize = opt.showFileSize && item.size, showTime = opt.showFileChangeTime && item.time;
        var name = '';
        if (item.file !== undefined) {
            name = item.file;
        }
        var info = "<div class=\"" + consts_1.ITEM_CLASS + "-info\">" + (showName ? "<span class=\"" + consts_1.ITEM_CLASS + "-info-filename\">" + name + "</span>" : '') + (showSize
            ? "<span class=\"" + consts_1.ITEM_CLASS + "-info-filesize\">" + item.size + "</span>"
            : '') + (showTime
            ? "<span class=\"" + consts_1.ITEM_CLASS + "-info-filechanged\">" + showTime + "</span>"
            : '') + "</div>";
        return "<a\n\t\t\tdata-jodit-filebrowser-item=\"true\"\n\t\t\tdata-is-file=\"" + (item.isImage ? 0 : 1) + "\"\n\t\t\tdraggable=\"true\"\n\t\t\tclass=\"" + consts_1.ITEM_CLASS + "\"\n\t\t\thref=\"" + item.fileURL + "\"\n\t\t\tdata-source=\"" + source_name + "\"\n\t\t\tdata-path=\"" + item.path + "\"\n\t\t\tdata-name=\"" + name + "\"\n\t\t\ttitle=\"" + name + "\"\n\t\t\tdata-url=\"" + item.fileURL + "\">\n\t\t\t\t<img\n\t\t\t\t\tdata-is-file=\"" + (item.isImage ? 0 : 1) + "\"\n\t\t\t\t\tdata-src=\"" + item.fileURL + "\"\n\t\t\t\t\tsrc=\"" + item.imageURL + "\"\n\t\t\t\t\talt=\"" + name + "\"\n\t\t\t\t\tloading=\"lazy\"\n\t\t\t\t/>\n\t\t\t\t" + (showName || showSize || showTime ? info : '') + "\n\t\t\t</a>";
    },
    ajax: tslib_1.__assign(tslib_1.__assign({}, config_1.Config.prototype.defaultAjaxOptions), { url: '', async: true, data: {}, cache: true, contentType: 'application/x-www-form-urlencoded; charset=UTF-8', method: 'POST', processData: true, dataType: 'json', headers: {}, prepareData: function (data) {
            return data;
        },
        process: function (resp) {
            return resp;
        } }),
    create: {
        data: { action: 'folderCreate' }
    },
    getLocalFileByUrl: {
        data: { action: 'getLocalFileByUrl' }
    },
    resize: {
        data: { action: 'imageResize' }
    },
    crop: {
        data: { action: 'imageCrop' }
    },
    fileMove: {
        data: { action: 'fileMove' }
    },
    folderMove: {
        data: { action: 'folderMove' }
    },
    fileRename: {
        data: { action: 'fileRename' }
    },
    folderRename: {
        data: { action: 'folderRename' }
    },
    fileRemove: {
        data: { action: 'fileRemove' }
    },
    folderRemove: {
        data: { action: 'folderRemove' }
    },
    items: {
        data: { action: 'files' }
    },
    folder: {
        data: { action: 'folders' }
    },
    permissions: {
        data: { action: 'permissions' }
    }
};
config_1.Config.prototype.controls.filebrowser = {
    upload: {
        icon: 'plus',
        isInput: true,
        isDisabled: function (browser) {
            return !browser.dataProvider.canI('FileUpload');
        },
        getContent: function (filebrowser) {
            var btn = new ui_1.UIFileInput(filebrowser, {
                onlyImages: filebrowser.state.onlyImages
            });
            filebrowser.e.fire('bindUploader.filebrowser', btn.container);
            return btn.container;
        }
    },
    remove: {
        icon: 'bin',
        isDisabled: function (browser) {
            return (!browser.state.activeElements.length ||
                !browser.dataProvider.canI('FileRemove'));
        },
        exec: function (editor) {
            editor.e.fire('fileRemove.filebrowser');
        }
    },
    update: {
        exec: function (editor) {
            editor.e.fire('update.filebrowser');
        }
    },
    select: {
        icon: 'check',
        isDisabled: function (browser) {
            return !browser.state.activeElements.length;
        },
        exec: function (editor) {
            editor.e.fire('select.filebrowser');
        }
    },
    edit: {
        icon: 'pencil',
        isDisabled: function (browser) {
            var selected = browser.state.activeElements;
            return (selected.length !== 1 ||
                !selected[0].isImage ||
                !(browser.dataProvider.canI('ImageCrop') ||
                    browser.dataProvider.canI('ImageResize')));
        },
        exec: function (editor) {
            editor.e.fire('edit.filebrowser');
        }
    },
    tiles: {
        icon: 'th',
        isActive: function (filebrowser) {
            return filebrowser.state.view === 'tiles';
        },
        exec: function (filebrowser) {
            filebrowser.e.fire('view.filebrowser', 'tiles');
        }
    },
    list: {
        icon: 'th-list',
        isActive: function (filebrowser) {
            return filebrowser.state.view === 'list';
        },
        exec: function (filebrowser) {
            filebrowser.e.fire('view.filebrowser', 'list');
        }
    },
    filter: {
        isInput: true,
        getContent: function (filebrowser, _, b) {
            var oldInput = b.container.querySelector('.jodit-input');
            if (oldInput) {
                return oldInput;
            }
            var input = filebrowser.c.element('input', {
                class: 'jodit-input',
                placeholder: filebrowser.i18n('Filter')
            });
            input.value = filebrowser.state.filterWord;
            filebrowser.e.on(input, 'keydown mousedown', filebrowser.async.debounce(function () {
                filebrowser.e.fire('filter.filebrowser', input.value);
            }, filebrowser.defaultTimeout));
            return input;
        }
    },
    sort: {
        isInput: true,
        getContent: function (fb) {
            var select = fb.c.fromHTML('<select class="jodit-input jodit-select">' +
                ("<option value=\"changed-asc\">" + fb.i18n('Sort by changed') + " (\u2B06)</option>") +
                ("<option value=\"changed-desc\">" + fb.i18n('Sort by changed') + " (\u2B07)</option>") +
                ("<option value=\"name-asc\">" + fb.i18n('Sort by name') + " (\u2B06)</option>") +
                ("<option value=\"name-desc\">" + fb.i18n('Sort by name') + " (\u2B07)</option>") +
                ("<option value=\"size-asc\">" + fb.i18n('Sort by size') + " (\u2B06)</option>") +
                ("<option value=\"size-desc\">" + fb.i18n('Sort by size') + " (\u2B07)</option>") +
                '</select>');
            select.value = fb.state.sortBy;
            fb.e
                .on('sort.filebrowser', function (value) {
                if (select.value !== value) {
                    select.value = value;
                }
            })
                .on(select, 'change', function () {
                fb.e.fire('sort.filebrowser', select.value);
            });
            return select;
        }
    }
};


/***/ }),
/* 189 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ICON_LOADER = exports.ITEM_CLASS = exports.F_CLASS = void 0;
exports.F_CLASS = 'jodit-filebrowser';
exports.ITEM_CLASS = exports.F_CLASS + '__files-item';
exports.ICON_LOADER = '<i class="jodit-icon_loader"></i>';


/***/ }),
/* 190 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.makeContextMenu = exports.makeDataProvider = void 0;
var data_provider_1 = __webpack_require__(191);
var context_menu_1 = __webpack_require__(161);
function makeDataProvider(parent, options) {
    return new data_provider_1.default(parent, options);
}
exports.makeDataProvider = makeDataProvider;
function makeContextMenu(parent) {
    return new context_menu_1.ContextMenu(parent);
}
exports.makeContextMenu = makeContextMenu;


/***/ }),
/* 191 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DEFAULT_SOURCE_NAME = void 0;
var tslib_1 = __webpack_require__(7);
var helpers_1 = __webpack_require__(19);
var ajax_1 = __webpack_require__(160);
var decorators_1 = __webpack_require__(99);
var item_1 = __webpack_require__(192);
exports.DEFAULT_SOURCE_NAME = 'default';
var possibleRules = (/* unused pure expression or super */ null && ([
    'allowFiles',
    'allowFileMove',
    'allowFileUpload',
    'allowFileUploadRemote',
    'allowFileRemove',
    'allowFileRename',
    'allowFolders',
    'allowFolderMove',
    'allowFolderCreate',
    'allowFolderRemove',
    'allowFolderRename',
    'allowImageResize',
    'allowImageCrop'
]));
var DataProvider = (function () {
    function DataProvider(parent, options) {
        this.parent = parent;
        this.options = options;
        this.__currentPermissions = null;
        this.ajaxInstances = new Map();
        this.progressHandler = function (ignore) { };
    }
    Object.defineProperty(DataProvider.prototype, "o", {
        get: function () {
            return this.options;
        },
        enumerable: false,
        configurable: true
    });
    DataProvider.prototype.get = function (name, success, error) {
        var _this = this;
        var ai = this.ajaxInstances;
        if (ai.has(name)) {
            var ajax_2 = ai.get(name);
            ajax_2 === null || ajax_2 === void 0 ? void 0 : ajax_2.abort();
            ai.delete(name);
        }
        var opts = helpers_1.ConfigProto(this.options[name] !== undefined
            ? this.options[name]
            : {}, helpers_1.ConfigProto({
            onProgress: this.progressHandler
        }, this.o.ajax));
        if (opts.prepareData) {
            opts.data = opts.prepareData.call(this, opts.data);
        }
        var ajax = new ajax_1.Ajax(this.parent, opts);
        var promise = ajax.send();
        ai.set(name, ajax);
        promise = promise.then(function (resp) {
            if (!_this.isSuccess(resp)) {
                throw new Error(_this.getMessage(resp));
            }
            return resp;
        });
        if (success) {
            promise = promise.then(success);
        }
        if (error) {
            promise = promise.catch(error);
        }
        return promise.finally(function () {
            ajax.destruct();
            ai.delete(name);
            _this.progressHandler(100);
        });
    };
    DataProvider.prototype.onProgress = function (callback) {
        this.progressHandler = callback;
    };
    DataProvider.prototype.permissions = function (path, source) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                if (!this.o.permissions) {
                    return [2, null];
                }
                this.o.permissions.data.path = path;
                this.o.permissions.data.source = source;
                if (this.o.permissions.url) {
                    return [2, this.get('permissions').then(function (resp) {
                            var process = _this.o.permissions.process;
                            if (!process) {
                                process = _this.o.ajax.process;
                            }
                            if (process) {
                                var respData = process.call(self, resp);
                                if (respData.data.permissions) {
                                    _this.__currentPermissions = respData.data.permissions;
                                }
                            }
                            return _this.__currentPermissions;
                        })];
                }
                return [2, null];
            });
        });
    };
    DataProvider.prototype.canI = function (action) {
        var rule = 'allow' + action;
        if (false) {}
        return (this.__currentPermissions == null ||
            this.__currentPermissions[rule] === undefined ||
            this.__currentPermissions[rule]);
    };
    DataProvider.prototype.items = function (path, source, mods) {
        if (mods === void 0) { mods = {}; }
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var opt;
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                opt = this.options;
                if (!opt.items) {
                    return [2, Promise.reject('Set Items api options')];
                }
                opt.items.data.path = path;
                opt.items.data.source = source;
                opt.items.data.mods = mods;
                return [2, this.get('items').then(function (resp) {
                        var process = _this.o.items.process;
                        if (!process) {
                            process = _this.o.ajax.process;
                        }
                        if (process) {
                            resp = process.call(self, resp);
                        }
                        return _this.generateItemsList(resp.data.sources, mods);
                    })];
            });
        });
    };
    DataProvider.prototype.generateItemsList = function (sources, mods) {
        var _this = this;
        if (mods === void 0) { mods = {}; }
        var elements = [];
        var canBeFile = function (item) {
            return !mods.onlyImages || item.isImage === undefined || item.isImage;
        }, inFilter = function (item) {
            var _a;
            return !((_a = mods.filterWord) === null || _a === void 0 ? void 0 : _a.length) ||
                _this.o.filter === undefined ||
                _this.o.filter(item, mods.filterWord);
        };
        sources.forEach(function (source) {
            if (source.files && source.files.length) {
                var sort_1 = _this.o.sort;
                if (helpers_1.isFunction(sort_1) && mods.sortBy) {
                    source.files.sort(function (a, b) { return sort_1(a, b, mods.sortBy); });
                }
                source.files.forEach(function (item) {
                    if (inFilter(item) && canBeFile(item)) {
                        elements.push(item_1.FileBrowserItem.create(tslib_1.__assign(tslib_1.__assign({}, item), { sourceName: source.name, source: source })));
                    }
                });
            }
        });
        return elements;
    };
    DataProvider.prototype.tree = function (path, source) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _this = this;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        path = helpers_1.normalizeRelativePath(path);
                        return [4, this.permissions(path, source)];
                    case 1:
                        _a.sent();
                        if (!this.o.folder) {
                            return [2, Promise.reject('Set Folder Api options')];
                        }
                        this.o.folder.data.path = path;
                        this.o.folder.data.source = source;
                        return [2, this.get('folder').then(function (resp) {
                                var process = _this.o.folder.process;
                                if (!process) {
                                    process = _this.o.ajax.process;
                                }
                                if (process) {
                                    resp = process.call(self, resp);
                                }
                                return resp.data.sources;
                            })];
                }
            });
        });
    };
    DataProvider.prototype.getPathByUrl = function (url) {
        var _this = this;
        helpers_1.set('options.getLocalFileByUrl.data.url', url, this);
        return this.get('getLocalFileByUrl', function (resp) {
            if (_this.isSuccess(resp)) {
                return resp.data;
            }
            throw helpers_1.error(_this.getMessage(resp));
        });
    };
    DataProvider.prototype.createFolder = function (name, path, source) {
        var _this = this;
        var create = this.o.create;
        if (!create) {
            throw helpers_1.error('Set Create api options');
        }
        create.data.source = source;
        create.data.path = path;
        create.data.name = name;
        return this.get('create').then(function (resp) {
            if (_this.isSuccess(resp)) {
                return true;
            }
            throw helpers_1.error(_this.getMessage(resp));
        });
    };
    DataProvider.prototype.move = function (filepath, path, source, isFile) {
        var _this = this;
        var mode = isFile
            ? 'fileMove'
            : 'folderMove';
        var option = this.options[mode];
        if (!option) {
            throw helpers_1.error('Set Move api options');
        }
        option.data.from = filepath;
        option.data.path = path;
        option.data.source = source;
        return this.get(mode).then(function (resp) {
            if (_this.isSuccess(resp)) {
                return true;
            }
            throw helpers_1.error(_this.getMessage(resp));
        });
    };
    DataProvider.prototype.remove = function (action, path, file, source) {
        var _this = this;
        var fr = this.o[action];
        if (!fr) {
            throw helpers_1.error("Set \"" + action + "\" api options");
        }
        fr.data.path = path;
        fr.data.name = file;
        fr.data.source = source;
        return this.get(action).then(function (resp) {
            if (fr.process) {
                resp = fr.process.call(_this, resp);
            }
            if (!_this.isSuccess(resp)) {
                throw helpers_1.error(_this.getMessage(resp));
            }
            return _this.getMessage(resp);
        });
    };
    DataProvider.prototype.fileRemove = function (path, file, source) {
        return this.remove('fileRemove', path, file, source);
    };
    DataProvider.prototype.folderRemove = function (path, file, source) {
        return this.remove('folderRemove', path, file, source);
    };
    DataProvider.prototype.rename = function (action, path, name, newname, source) {
        var _this = this;
        var fr = this.o[action];
        if (!fr) {
            throw helpers_1.error("Set \"" + action + "\" api options");
        }
        fr.data.path = path;
        fr.data.name = name;
        fr.data.newname = newname;
        fr.data.source = source;
        return this.get(action).then(function (resp) {
            if (fr.process) {
                resp = fr.process.call(self, resp);
            }
            if (!_this.isSuccess(resp)) {
                throw helpers_1.error(_this.getMessage(resp));
            }
            return _this.getMessage(resp);
        });
    };
    DataProvider.prototype.folderRename = function (path, name, newname, source) {
        return this.rename('folderRename', path, name, newname, source);
    };
    DataProvider.prototype.fileRename = function (path, name, newname, source) {
        return this.rename('fileRename', path, name, newname, source);
    };
    DataProvider.prototype.changeImage = function (type, path, source, name, newname, box) {
        var _this = this;
        if (!this.o[type]) {
            this.o[type] = {
                data: {}
            };
        }
        var query = this.o[type];
        if (query.data === undefined) {
            query.data = {
                action: type
            };
        }
        query.data.newname = newname || name;
        if (box) {
            query.data.box = box;
        }
        query.data.path = path;
        query.data.name = name;
        query.data.source = source;
        return this.get(type).then(function (resp) {
            if (_this.isSuccess(resp)) {
                return true;
            }
            throw helpers_1.error(_this.getMessage(resp));
        });
    };
    DataProvider.prototype.crop = function (path, source, name, newname, box) {
        return this.changeImage('crop', path, source, name, newname, box);
    };
    DataProvider.prototype.resize = function (path, source, name, newname, box) {
        return this.changeImage('resize', path, source, name, newname, box);
    };
    DataProvider.prototype.getMessage = function (resp) {
        return this.options.getMessage(resp);
    };
    DataProvider.prototype.isSuccess = function (resp) {
        return this.options.isSuccess(resp);
    };
    DataProvider.prototype.destruct = function () {
        this.ajaxInstances.forEach(function (a) { return a.destruct(); });
        this.ajaxInstances.clear();
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], DataProvider.prototype, "isSuccess", null);
    return DataProvider;
}());
exports.default = DataProvider;


/***/ }),
/* 192 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileBrowserItem = void 0;
var helpers_1 = __webpack_require__(19);
var FileBrowserItem = (function () {
    function FileBrowserItem(data) {
        var _this = this;
        this.data = data;
        Object.keys(data).forEach(function (key) {
            _this[key] = data[key];
        });
    }
    FileBrowserItem.create = function (data) {
        if (data instanceof FileBrowserItem) {
            return data;
        }
        return new FileBrowserItem(data);
    };
    Object.defineProperty(FileBrowserItem.prototype, "path", {
        get: function () {
            return helpers_1.normalizePath(this.data.source.path ? this.data.source.path + '/' : '/');
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileBrowserItem.prototype, "imageURL", {
        get: function () {
            var timestamp = new Date().getTime().toString(), _a = this.data, thumbIsAbsolute = _a.thumbIsAbsolute, source = _a.source, thumb = _a.thumb, file = _a.file, path = thumb || file;
            return thumbIsAbsolute && path
                ? path
                : helpers_1.normalizeUrl(source.baseurl, source.path, path || '') +
                    '?_tmst=' +
                    timestamp;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileBrowserItem.prototype, "fileURL", {
        get: function () {
            var name = this.data.name;
            var _a = this.data, file = _a.file, fileIsAbsolute = _a.fileIsAbsolute, source = _a.source;
            if (file !== undefined) {
                name = file;
            }
            return fileIsAbsolute && name
                ? name
                : helpers_1.normalizeUrl(source.baseurl, source.path, name || '');
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileBrowserItem.prototype, "time", {
        get: function () {
            var changed = this.data.changed;
            return ((changed &&
                (typeof changed === 'number'
                    ? new Date(changed).toLocaleString()
                    : changed)) ||
                '');
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FileBrowserItem.prototype, "uniqueHashKey", {
        get: function () {
            var data = this.data;
            var key = [
                data.sourceName,
                data.name,
                data.file,
                this.time,
                data.thumb
            ].join('_');
            key = key.toLowerCase().replace(/[^0-9a-z\-.]/g, '-');
            return key;
        },
        enumerable: false,
        configurable: true
    });
    FileBrowserItem.prototype.toJSON = function () {
        return this.data;
    };
    return FileBrowserItem;
}());
exports.FileBrowserItem = FileBrowserItem;


/***/ }),
/* 193 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.stateListeners = void 0;
var consts_1 = __webpack_require__(189);
var dom_1 = __webpack_require__(32);
var normalize_1 = __webpack_require__(82);
var ui_1 = __webpack_require__(75);
var DEFAULT_SOURCE_NAME = 'default', ITEM_ACTIVE_CLASS = consts_1.ITEM_CLASS + '_active_true';
function stateListeners() {
    var _this = this;
    var _a = this, state = _a.state, files = _a.files, create = _a.create, options = _a.options, elementsMap = _a.elementsMap, getDomElement = function (item) {
        var key = item.uniqueHashKey;
        if (elementsMap[key]) {
            return elementsMap[key].elm;
        }
        var elm = create.fromHTML(options.getThumbTemplate.call(_this, item, item.source, item.sourceName.toString()));
        elm.dataset.key = key;
        elementsMap[key] = {
            item: item,
            elm: elm
        };
        return elementsMap[key].elm;
    };
    state
        .on(['change.currentPath', 'change.currentSource'], this.async.debounce(function () {
        _this.loadTree();
    }, this.defaultTimeout))
        .on('beforeChange.activeElements', function () {
        state.activeElements.forEach(function (item) {
            var key = item.uniqueHashKey, elm = elementsMap[key].elm;
            elm && elm.classList.remove(ITEM_ACTIVE_CLASS);
        });
    })
        .on('change.activeElements', function () {
        _this.e.fire('changeSelection');
        state.activeElements.forEach(function (item) {
            var key = item.uniqueHashKey, elm = elementsMap[key].elm;
            elm && elm.classList.add(ITEM_ACTIVE_CLASS);
        });
    })
        .on('change.view', function () {
        files.classList.remove(consts_1.F_CLASS + '__files_view_tiles');
        files.classList.remove(consts_1.F_CLASS + '__files_view_list');
        files.classList.add(consts_1.F_CLASS + '__files_view_' + state.view);
        _this.storage.set(consts_1.F_CLASS + '_view', state.view);
    })
        .on('change.sortBy', function () {
        _this.storage.set(consts_1.F_CLASS + '_sortby', state.sortBy);
    })
        .on('change.elements', this.async.debounce(function () {
        dom_1.Dom.detach(files);
        if (state.elements.length) {
            state.elements.forEach(function (item) {
                _this.files.appendChild(getDomElement(item));
            });
        }
        else {
            files.appendChild(create.div(consts_1.F_CLASS + '_no_files', _this.i18n('There are no files')));
        }
    }, this.defaultTimeout))
        .on('change.sources', this.async.debounce(function () {
        dom_1.Dom.detach(_this.tree);
        state.sources.forEach(function (source) {
            var sourceName = source.name;
            if (sourceName && sourceName !== DEFAULT_SOURCE_NAME) {
                _this.tree.appendChild(create.div(consts_1.F_CLASS + '__source-title', sourceName));
            }
            source.folders.forEach(function (name) {
                var folderElm = create.a(consts_1.F_CLASS + '__tree-item', {
                    draggable: 'draggable',
                    href: 'javascript:void(0)',
                    'data-path': normalize_1.normalizePath(source.path, name + '/'),
                    'data-name': name,
                    'data-source': sourceName,
                    'data-source-path': source.path
                }, create.span(consts_1.F_CLASS + '__tree-item-title', name));
                var action = function (actionName) { return function (e) {
                    _this.e.fire(actionName + ".filebrowser", {
                        name: name,
                        path: normalize_1.normalizePath(source.path + '/'),
                        source: sourceName
                    });
                    e.stopPropagation();
                }; };
                _this.e.on(folderElm, 'click', action('openFolder'));
                _this.tree.appendChild(folderElm);
                if (name === '..' || name === '.') {
                    return;
                }
                if (options.renameFolder &&
                    _this.dataProvider.canI('FolderRename')) {
                    var btn = ui_1.Button(_this, {
                        icon: { name: 'pencil' },
                        name: 'rename',
                        tooltip: 'Rename',
                        size: 'tiny'
                    });
                    btn.onAction(action('renameFolder'));
                    folderElm.appendChild(btn.container);
                }
                if (options.deleteFolder &&
                    _this.dataProvider.canI('FolderRemove')) {
                    var btn = ui_1.Button(_this, {
                        icon: { name: 'cancel' },
                        name: 'remove',
                        tooltip: 'Delete',
                        size: 'tiny'
                    });
                    btn.onAction(action('removeFolder'));
                    folderElm.appendChild(btn.container);
                }
            });
            if (options.createNewFolder &&
                _this.dataProvider.canI('FolderCreate')) {
                var button = ui_1.Button(_this, 'plus', 'Add folder', 'secondary');
                button.onAction(function () {
                    _this.e.fire('addFolder', {
                        path: normalize_1.normalizePath(source.path + '/'),
                        source: sourceName
                    });
                });
                _this.tree.appendChild(button.container);
            }
        });
    }, this.defaultTimeout));
}
exports.stateListeners = stateListeners;


/***/ }),
/* 194 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.nativeListeners = exports.getItem = void 0;
var tslib_1 = __webpack_require__(7);
var helpers_1 = __webpack_require__(19);
var consts_1 = __webpack_require__(189);
var context_menu_1 = __webpack_require__(195);
var dom_1 = __webpack_require__(32);
var getItem = function (node, root, tag) {
    if (tag === void 0) { tag = 'a'; }
    return dom_1.Dom.closest(node, function (elm) { return dom_1.Dom.isElement(elm) && dom_1.Dom.isTag(elm, tag); }, root);
};
exports.getItem = getItem;
function nativeListeners() {
    var _this = this;
    var dragElement = false;
    var self = this;
    var elementToItem = function (elm) {
        var key = elm.dataset.key, item = self.elementsMap[key || ''].item;
        return item;
    };
    self.e
        .on(self.tree, 'dragstart', function (e) {
        var a = exports.getItem(e.target, self.dialog.container);
        if (!a) {
            return;
        }
        if (self.o.moveFolder) {
            dragElement = a;
        }
    })
        .on(self.tree, 'drop', function (e) {
        if ((self.o.moveFile || self.o.moveFolder) && dragElement) {
            var path = helpers_1.attr(dragElement, '-path') || '';
            if (!self.o.moveFolder &&
                dragElement.classList.contains(consts_1.F_CLASS + '__tree-item')) {
                return false;
            }
            if (dragElement.classList.contains(consts_1.ITEM_CLASS)) {
                path += helpers_1.attr(dragElement, '-name');
                if (!self.o.moveFile) {
                    return false;
                }
            }
            var a = exports.getItem(e.target, self.dialog.container);
            if (!a) {
                return;
            }
            self.dataProvider
                .move(path, helpers_1.attr(a, '-path') || '', helpers_1.attr(a, '-source') || '', dragElement.classList.contains(consts_1.ITEM_CLASS))
                .then(function () {
                self.loadTree();
            }, self.status);
            dragElement = false;
        }
    })
        .on(self.files, 'contextmenu', context_menu_1.default(self))
        .on(self.files, 'click', function (e) {
        if (!helpers_1.ctrlKey(e)) {
            _this.state.activeElements = [];
        }
    })
        .on(self.files, 'click', function (e) {
        var a = exports.getItem(e.target, self.dialog.container);
        if (!a) {
            return;
        }
        var item = elementToItem(a);
        if (!item) {
            return;
        }
        if (!helpers_1.ctrlKey(e)) {
            self.state.activeElements = [item];
        }
        else {
            self.state.activeElements = tslib_1.__spreadArray(tslib_1.__spreadArray([], self.state.activeElements), [
                item
            ]);
        }
        e.stopPropagation();
        return false;
    })
        .on(self.files, 'dragstart', function (e) {
        if (self.o.moveFile) {
            var a = exports.getItem(e.target, self.dialog.container);
            if (!a) {
                return;
            }
            dragElement = a;
        }
    })
        .on(self.dialog.container, 'drop', function (e) {
        return e.preventDefault();
    });
}
exports.nativeListeners = nativeListeners;


/***/ }),
/* 195 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
var dialog_1 = __webpack_require__(163);
var dom_1 = __webpack_require__(32);
var consts_1 = __webpack_require__(189);
var helpers_1 = __webpack_require__(19);
var factories_1 = __webpack_require__(190);
var ui_1 = __webpack_require__(75);
var native_listeners_1 = __webpack_require__(194);
var image_editor_1 = __webpack_require__(196);
var CLASS_PREVIEW = consts_1.F_CLASS + '_preview_', preview_tpl_next = function (next, right) {
    if (next === void 0) { next = 'next'; }
    if (right === void 0) { right = 'right'; }
    return "<a href=\"javascript:void(0)\" class=\"" + CLASS_PREVIEW + "navigation " + CLASS_PREVIEW + "navigation-" + next + "\">" +
        '' +
        ui_1.Icon.get('angle-' + right) +
        '</a>';
};
exports.default = (function (self) {
    if (!self.o.contextMenu) {
        return function () { };
    }
    var contextmenu = factories_1.makeContextMenu(self);
    return function (e) {
        var a = native_listeners_1.getItem(e.target, self.dialog.container);
        if (!a) {
            return;
        }
        var item = a;
        var opt = self.options, ga = function (key) { return helpers_1.attr(item, key) || ''; };
        self.async.setTimeout(function () {
            contextmenu.show(e.clientX, e.clientY, [
                ga('data-is-file') !== '1' &&
                    opt.editImage &&
                    (self.dataProvider.canI('ImageResize') ||
                        self.dataProvider.canI('ImageCrop'))
                    ? {
                        icon: 'pencil',
                        title: 'Edit',
                        exec: function () {
                            return image_editor_1.openImageEditor.call(self, ga('href'), ga('data-name'), ga('data-path'), ga('data-source'));
                        }
                    }
                    : false,
                self.dataProvider.canI('FileRename')
                    ? {
                        icon: 'italic',
                        title: 'Rename',
                        exec: function () { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
                            return tslib_1.__generator(this, function (_a) {
                                self.e.fire('fileRename.filebrowser', ga('data-name'), ga('data-path'), ga('data-source'));
                                return [2];
                            });
                        }); }
                    }
                    : false,
                self.dataProvider.canI('FileRemove')
                    ? {
                        icon: 'bin',
                        title: 'Delete',
                        exec: function () { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
                            return tslib_1.__generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4, self.deleteFile(ga('data-name'), ga('data-source'))];
                                    case 1:
                                        _a.sent();
                                        self.state.activeElements = [];
                                        return [2, self.loadTree()];
                                }
                            });
                        }); }
                    }
                    : false,
                opt.preview
                    ? {
                        icon: 'eye',
                        title: 'Preview',
                        exec: function () {
                            var preview = new dialog_1.Dialog({
                                fullsize: self.o.fullsize,
                                language: self.o.language,
                                buttons: ['fullsize', 'dialog.close']
                            }), temp_content = self.c.div(consts_1.F_CLASS + '_preview', consts_1.ICON_LOADER), preview_box = self.c.div(consts_1.F_CLASS + '_preview_box'), next = self.c.fromHTML(preview_tpl_next()), prev = self.c.fromHTML(preview_tpl_next('prev', 'left')), addLoadHandler = function (src) {
                                var image = self.c.element('img');
                                image.setAttribute('src', src);
                                var onload = function () {
                                    var _a;
                                    if (self.isInDestruct) {
                                        return;
                                    }
                                    self.e.off(image, 'load');
                                    dom_1.Dom.detach(temp_content);
                                    if (opt.showPreviewNavigation) {
                                        if (dom_1.Dom.prevWithClass(item, consts_1.ITEM_CLASS)) {
                                            temp_content.appendChild(prev);
                                        }
                                        if (dom_1.Dom.nextWithClass(item, consts_1.ITEM_CLASS)) {
                                            temp_content.appendChild(next);
                                        }
                                    }
                                    temp_content.appendChild(preview_box);
                                    preview_box.appendChild(image);
                                    preview.setPosition();
                                    (_a = self === null || self === void 0 ? void 0 : self.events) === null || _a === void 0 ? void 0 : _a.fire('previewOpenedAndLoaded');
                                };
                                self.e.on(image, 'load', onload);
                                if (image.complete) {
                                    onload();
                                }
                            };
                            self.e.on([next, prev], 'click', function () {
                                if (this.classList.contains(CLASS_PREVIEW +
                                    'navigation-next')) {
                                    item = dom_1.Dom.nextWithClass(item, consts_1.ITEM_CLASS);
                                }
                                else {
                                    item = dom_1.Dom.prevWithClass(item, consts_1.ITEM_CLASS);
                                }
                                if (!item) {
                                    throw helpers_1.error('Need element');
                                }
                                dom_1.Dom.detach(temp_content);
                                dom_1.Dom.detach(preview_box);
                                temp_content.innerHTML = consts_1.ICON_LOADER;
                                addLoadHandler(ga('href'));
                            });
                            self.e.on('beforeDestruct', function () {
                                preview.destruct();
                            });
                            preview.container.classList.add(consts_1.F_CLASS + '_preview_dialog');
                            preview.setContent(temp_content);
                            preview.setPosition();
                            preview.open();
                            addLoadHandler(ga('href'));
                            self.events
                                .on('beforeDestruct', function () {
                                preview.destruct();
                            })
                                .fire('previewOpened');
                        }
                    }
                    : false,
                {
                    icon: 'upload',
                    title: 'Download',
                    exec: function () {
                        var url = ga('href');
                        if (url) {
                            self.ow.open(url);
                        }
                    }
                }
            ]);
        }, self.defaultTimeout);
        self === null || self === void 0 ? void 0 : self.e.on('beforeDestruct', function () {
            contextmenu.destruct();
        });
        e.stopPropagation();
        e.preventDefault();
        return false;
    };
});


/***/ }),
/* 196 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.openImageEditor = exports.ImageEditor = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(197);
var config_1 = __webpack_require__(8);
var component_1 = __webpack_require__(27);
var dialog_1 = __webpack_require__(163);
var helpers_1 = __webpack_require__(19);
var dom_1 = __webpack_require__(32);
var button_1 = __webpack_require__(92);
var form_1 = __webpack_require__(198);
var decorators_1 = __webpack_require__(99);
config_1.Config.prototype.imageeditor = {
    min_width: 20,
    min_height: 20,
    closeAfterSave: false,
    width: '85%',
    height: '85%',
    crop: true,
    resize: true,
    resizeUseRatio: true,
    resizeMinWidth: 20,
    resizeMinHeight: 20,
    cropUseRatio: true,
    cropDefaultWidth: '70%',
    cropDefaultHeight: '70%'
};
var jie = 'jodit-image-editor';
var TABS = {
    resize: 'resize',
    crop: 'crop'
};
var ImageEditor = (function (_super) {
    tslib_1.__extends(ImageEditor, _super);
    function ImageEditor(editor) {
        var _this = _super.call(this, editor) || this;
        _this.resizeUseRatio = true;
        _this.cropUseRatio = true;
        _this.clicked = false;
        _this.start_x = 0;
        _this.start_y = 0;
        _this.top_x = 0;
        _this.top_y = 0;
        _this.width = 0;
        _this.height = 0;
        _this.activeTab = TABS.resize;
        _this.naturalWidth = 0;
        _this.naturalHeight = 0;
        _this.ratio = 0;
        _this.new_h = 0;
        _this.new_w = 0;
        _this.diff_x = 0;
        _this.diff_y = 0;
        _this.cropBox = {
            x: 0,
            y: 0,
            w: 0,
            h: 0
        };
        _this.resizeBox = {
            w: 0,
            h: 0
        };
        _this.calcCropBox = function () {
            var node = _this.crop_box.parentNode, w = node.offsetWidth * 0.8, h = node.offsetHeight * 0.8;
            var wn = w, hn = h;
            var _a = _this, nw = _a.naturalWidth, nh = _a.naturalHeight;
            if (w > nw && h > nh) {
                wn = nw;
                hn = nh;
            }
            else if (_this.ratio > w / h) {
                wn = w;
                hn = nh * (w / nw);
            }
            else {
                wn = nw * (h / nh);
                hn = h;
            }
            helpers_1.css(_this.crop_box, {
                width: wn,
                height: hn
            });
        };
        _this.showCrop = function () {
            if (!_this.cropImage) {
                return;
            }
            _this.calcCropBox();
            var w = _this.cropImage.offsetWidth ||
                _this.image.offsetWidth ||
                _this.image.naturalWidth;
            _this.new_w = ImageEditor_1.calcValueByPercent(w, _this.o.cropDefaultWidth);
            var h = _this.cropImage.offsetHeight ||
                _this.image.offsetHeight ||
                _this.image.naturalHeight;
            if (_this.cropUseRatio) {
                _this.new_h = _this.new_w / _this.ratio;
            }
            else {
                _this.new_h = ImageEditor_1.calcValueByPercent(h, _this.o.cropDefaultHeight);
            }
            helpers_1.css(_this.cropHandler, {
                backgroundImage: 'url(' + helpers_1.attr(_this.cropImage, 'src') + ')',
                width: _this.new_w,
                height: _this.new_h,
                left: w / 2 - _this.new_w / 2,
                top: h / 2 - _this.new_h / 2
            });
            _this.j.e.fire(_this.cropHandler, 'updatesize');
        };
        _this.updateCropBox = function () {
            if (!_this.cropImage) {
                return;
            }
            var ratioX = _this.cropImage.offsetWidth / _this.naturalWidth, ratioY = _this.cropImage.offsetHeight / _this.naturalHeight;
            _this.cropBox.x = helpers_1.css(_this.cropHandler, 'left') / ratioX;
            _this.cropBox.y = helpers_1.css(_this.cropHandler, 'top') / ratioY;
            _this.cropBox.w = _this.cropHandler.offsetWidth / ratioX;
            _this.cropBox.h = _this.cropHandler.offsetHeight / ratioY;
            _this.sizes.textContent =
                _this.cropBox.w.toFixed(0) + 'x' + _this.cropBox.h.toFixed(0);
        };
        _this.updateResizeBox = function () {
            _this.resizeBox.w = _this.image.offsetWidth || _this.naturalWidth;
            _this.resizeBox.h = _this.image.offsetHeight || _this.naturalHeight;
        };
        _this.setHandlers = function () {
            var self = _this;
            var _a = helpers_1.refs(_this.editor), widthInput = _a.widthInput, heightInput = _a.heightInput;
            self.j.e
                .on([
                self.editor.querySelector('.jodit_bottomright'),
                self.cropHandler
            ], "mousedown." + jie, _this.onResizeHandleMouseDown)
                .on(_this.j.ow, "resize." + jie, function () {
                _this.j.e.fire(self.resizeHandler, 'updatesize');
                self.showCrop();
                _this.j.e.fire(self.cropHandler, 'updatesize');
            });
            self.j.e
                .on(helpers_1.toArray(_this.editor.querySelectorAll("." + jie + "__slider-title")), 'click', _this.onTitleModeClick)
                .on([widthInput, heightInput], 'input', _this.onChangeSizeInput);
            var _b = helpers_1.refs(_this.editor), keepAspectRatioResize = _b.keepAspectRatioResize, keepAspectRatioCrop = _b.keepAspectRatioCrop;
            if (keepAspectRatioResize) {
                keepAspectRatioResize.addEventListener('change', function () {
                    _this.resizeUseRatio = keepAspectRatioResize.checked;
                });
            }
            if (keepAspectRatioCrop) {
                keepAspectRatioCrop.addEventListener('change', function () {
                    _this.cropUseRatio = keepAspectRatioCrop.checked;
                });
            }
            self.j.e
                .on(self.resizeHandler, 'updatesize', function () {
                helpers_1.css(self.resizeHandler, {
                    top: 0,
                    left: 0,
                    width: self.image.offsetWidth || self.naturalWidth,
                    height: self.image.offsetHeight || self.naturalHeight
                });
                _this.updateResizeBox();
            })
                .on(self.cropHandler, 'updatesize', function () {
                if (!self.cropImage) {
                    return;
                }
                var new_x = helpers_1.css(self.cropHandler, 'left'), new_y = helpers_1.css(self.cropHandler, 'top'), new_width = self.cropHandler.offsetWidth, new_height = self.cropHandler.offsetHeight;
                if (new_x < 0) {
                    new_x = 0;
                }
                if (new_y < 0) {
                    new_y = 0;
                }
                if (new_x + new_width > self.cropImage.offsetWidth) {
                    new_width = self.cropImage.offsetWidth - new_x;
                    if (self.cropUseRatio) {
                        new_height = new_width / self.ratio;
                    }
                }
                if (new_y + new_height > self.cropImage.offsetHeight) {
                    new_height = self.cropImage.offsetHeight - new_y;
                    if (self.cropUseRatio) {
                        new_width = new_height * self.ratio;
                    }
                }
                helpers_1.css(self.cropHandler, {
                    width: new_width,
                    height: new_height,
                    left: new_x,
                    top: new_y,
                    backgroundPosition: -new_x - 1 + 'px ' + (-new_y - 1) + 'px',
                    backgroundSize: self.cropImage.offsetWidth +
                        'px ' +
                        self.cropImage.offsetHeight +
                        'px'
                });
                self.updateCropBox();
            });
            Object.values(self.buttons).forEach(function (button) {
                button.onAction(function () {
                    var data = {
                        action: self.activeTab,
                        box: self.activeTab === TABS.resize
                            ? self.resizeBox
                            : self.cropBox
                    };
                    switch (button) {
                        case self.buttons.saveas:
                            dialog_1.Prompt(self.j.i18n('Enter new name'), self.j.i18n('Save in new file'), function (name) {
                                if (!helpers_1.trim(name)) {
                                    dialog_1.Alert(self.j.i18n('The name should not be empty')).bindDestruct(_this.j);
                                    return false;
                                }
                                self.onSave(name, data, self.hide, function (e) {
                                    dialog_1.Alert(e.message).bindDestruct(self.j);
                                });
                            }).bindDestruct(_this.j);
                            break;
                        case self.buttons.save:
                            self.onSave(undefined, data, self.hide, function (e) {
                                dialog_1.Alert(e.message).bindDestruct(self.j);
                            });
                            break;
                        case self.buttons.reset:
                            if (self.activeTab === TABS.resize) {
                                helpers_1.css(self.image, {
                                    width: null,
                                    height: null
                                });
                                widthInput.value = self.naturalWidth.toString();
                                heightInput.value = self.naturalHeight.toString();
                                self.j.e.fire(self.resizeHandler, 'updatesize');
                            }
                            else {
                                self.showCrop();
                            }
                            break;
                    }
                });
            });
        };
        _this.options =
            editor && editor.o && editor.o.imageeditor
                ? editor.o.imageeditor
                : config_1.Config.defaultOptions.imageeditor;
        var o = _this.options;
        _this.resizeUseRatio = o.resizeUseRatio;
        _this.cropUseRatio = o.cropUseRatio;
        _this.buttons = {
            reset: button_1.Button(_this.j, 'update', 'Reset'),
            save: button_1.Button(_this.j, 'save', 'Save'),
            saveas: button_1.Button(_this.j, 'save', 'Save as ...')
        };
        _this.activeTab = o.resize ? TABS.resize : TABS.crop;
        _this.editor = form_1.form(_this.j, _this.options);
        var _a = helpers_1.refs(_this.editor), resizeBox = _a.resizeBox, cropBox = _a.cropBox;
        _this.resize_box = resizeBox;
        _this.crop_box = cropBox;
        _this.sizes = _this.editor.querySelector("." + jie + "__area." + jie + "__area_crop .jodit-image-editor__sizes");
        _this.resizeHandler = _this.editor.querySelector("." + jie + "__resizer");
        _this.cropHandler = _this.editor.querySelector("." + jie + "__croper");
        _this.dialog = new dialog_1.Dialog({
            fullsize: _this.j.o.fullsize,
            globalFullSize: _this.j.o.globalFullSize,
            language: _this.j.o.language,
            buttons: ['fullsize', 'dialog.close']
        });
        _this.dialog.setContent(_this.editor);
        _this.dialog.setSize(_this.o.width, _this.o.height);
        _this.dialog.setHeader([
            _this.buttons.reset,
            _this.buttons.save,
            _this.buttons.saveas
        ]);
        _this.setHandlers();
        return _this;
    }
    ImageEditor_1 = ImageEditor;
    ImageEditor.prototype.className = function () {
        return 'ImageEditor';
    };
    ImageEditor.prototype.onTitleModeClick = function (e) {
        var self = this, title = e.target;
        var slide = title === null || title === void 0 ? void 0 : title.parentElement;
        if (!slide) {
            return;
        }
        helpers_1.$$("." + jie + "__slider,." + jie + "__area", self.editor).forEach(function (elm) {
            return elm.classList.remove(jie + "_active");
        });
        slide.classList.add(jie + "_active");
        self.activeTab = helpers_1.attr(slide, '-area') || TABS.resize;
        var tab = self.editor.querySelector("." + jie + "__area." + jie + "__area_" + self.activeTab);
        if (tab) {
            tab.classList.add(jie + "_active");
        }
        if (self.activeTab === TABS.crop) {
            self.showCrop();
        }
    };
    ImageEditor.prototype.onChangeSizeInput = function (e) {
        var self = this, input = e.target, _a = helpers_1.refs(this.editor), widthInput = _a.widthInput, heightInput = _a.heightInput, isWidth = helpers_1.attr(input, 'data-ref') === 'widthInput', x = parseInt(input.value, 10), minX = isWidth ? self.o.min_width : self.o.min_height, minY = !isWidth ? self.o.min_width : self.o.min_height;
        var y;
        if (x > minX) {
            helpers_1.css(self.image, isWidth ? 'width' : 'height', x);
            if (self.resizeUseRatio) {
                y = isWidth
                    ? Math.round(x / self.ratio)
                    : Math.round(x * self.ratio);
                if (y > minY) {
                    helpers_1.css(self.image, !isWidth ? 'width' : 'height', y);
                    if (isWidth) {
                        heightInput.value = y.toString();
                    }
                    else {
                        widthInput.value = y.toString();
                    }
                }
            }
        }
        this.j.e.fire(self.resizeHandler, 'updatesize');
    };
    ImageEditor.prototype.onResizeHandleMouseDown = function (e) {
        var self = this;
        self.target = e.target;
        e.preventDefault();
        e.stopImmediatePropagation();
        self.clicked = true;
        self.start_x = e.clientX;
        self.start_y = e.clientY;
        if (self.activeTab === TABS.crop) {
            self.top_x = helpers_1.css(self.cropHandler, 'left');
            self.top_y = helpers_1.css(self.cropHandler, 'top');
            self.width = self.cropHandler.offsetWidth;
            self.height = self.cropHandler.offsetHeight;
        }
        else {
            self.width = self.image.offsetWidth;
            self.height = self.image.offsetHeight;
        }
        self.j.e
            .on(this.j.ow, 'mousemove', this.onGlobalMouseMove)
            .one(this.j.ow, 'mouseup', this.onGlobalMouseUp);
    };
    ImageEditor.prototype.onGlobalMouseUp = function (e) {
        if (this.clicked) {
            this.clicked = false;
            e.stopImmediatePropagation();
            this.j.e.off(this.j.ow, 'mousemove', this.onGlobalMouseMove);
        }
    };
    ImageEditor.prototype.onGlobalMouseMove = function (e) {
        var self = this;
        if (!self.clicked) {
            return;
        }
        var _a = helpers_1.refs(this.editor), widthInput = _a.widthInput, heightInput = _a.heightInput;
        self.diff_x = e.clientX - self.start_x;
        self.diff_y = e.clientY - self.start_y;
        if ((self.activeTab === TABS.resize && self.resizeUseRatio) ||
            (self.activeTab === TABS.crop && self.cropUseRatio)) {
            if (self.diff_x) {
                self.new_w = self.width + self.diff_x;
                self.new_h = Math.round(self.new_w / self.ratio);
            }
            else {
                self.new_h = self.height + self.diff_y;
                self.new_w = Math.round(self.new_h * self.ratio);
            }
        }
        else {
            self.new_w = self.width + self.diff_x;
            self.new_h = self.height + self.diff_y;
        }
        if (self.activeTab === TABS.resize) {
            if (self.new_w > self.o.resizeMinWidth) {
                helpers_1.css(self.image, 'width', self.new_w + 'px');
                widthInput.value = self.new_w.toString();
            }
            if (self.new_h > self.o.resizeMinHeight) {
                helpers_1.css(self.image, 'height', self.new_h + 'px');
                heightInput.value = self.new_h.toString();
            }
            this.j.e.fire(self.resizeHandler, 'updatesize');
        }
        else {
            if (self.target !== self.cropHandler) {
                if (self.top_x + self.new_w > self.cropImage.offsetWidth) {
                    self.new_w = self.cropImage.offsetWidth - self.top_x;
                }
                if (self.top_y + self.new_h > self.cropImage.offsetHeight) {
                    self.new_h = self.cropImage.offsetHeight - self.top_y;
                }
                helpers_1.css(self.cropHandler, {
                    width: self.new_w,
                    height: self.new_h
                });
            }
            else {
                if (self.top_x + self.diff_x + self.cropHandler.offsetWidth >
                    self.cropImage.offsetWidth) {
                    self.diff_x =
                        self.cropImage.offsetWidth -
                            self.top_x -
                            self.cropHandler.offsetWidth;
                }
                helpers_1.css(self.cropHandler, 'left', self.top_x + self.diff_x);
                if (self.top_y + self.diff_y + self.cropHandler.offsetHeight >
                    self.cropImage.offsetHeight) {
                    self.diff_y =
                        self.cropImage.offsetHeight -
                            self.top_y -
                            self.cropHandler.offsetHeight;
                }
                helpers_1.css(self.cropHandler, 'top', self.top_y + self.diff_y);
            }
            this.j.e.fire(self.cropHandler, 'updatesize');
        }
    };
    Object.defineProperty(ImageEditor.prototype, "o", {
        get: function () {
            return this.options;
        },
        enumerable: false,
        configurable: true
    });
    ImageEditor.prototype.hide = function () {
        this.dialog.close();
    };
    ImageEditor.prototype.open = function (url, save) {
        var _this = this;
        return this.j.async.promise(function (resolve) {
            var timestamp = new Date().getTime();
            _this.image = _this.j.c.element('img');
            helpers_1.$$('img,.jodit-icon_loader', _this.resize_box).forEach(dom_1.Dom.safeRemove);
            helpers_1.$$('img,.jodit-icon_loader', _this.crop_box).forEach(dom_1.Dom.safeRemove);
            helpers_1.css(_this.cropHandler, 'background', 'transparent');
            _this.onSave = save;
            _this.resize_box.appendChild(_this.j.c.element('i', { class: 'jodit-icon_loader' }));
            _this.crop_box.appendChild(_this.j.c.element('i', { class: 'jodit-icon_loader' }));
            if (/\?/.test(url)) {
                url += '&_tst=' + timestamp;
            }
            else {
                url += '?_tst=' + timestamp;
            }
            _this.image.setAttribute('src', url);
            _this.dialog.open();
            var _a = helpers_1.refs(_this.editor), widthInput = _a.widthInput, heightInput = _a.heightInput;
            var onload = function () {
                if (_this.isDestructed) {
                    return;
                }
                _this.image.removeEventListener('load', onload);
                _this.naturalWidth = _this.image.naturalWidth;
                _this.naturalHeight = _this.image.naturalHeight;
                widthInput.value = _this.naturalWidth.toString();
                heightInput.value = _this.naturalHeight.toString();
                _this.ratio = _this.naturalWidth / _this.naturalHeight;
                _this.resize_box.appendChild(_this.image);
                _this.cropImage = _this.image.cloneNode(true);
                _this.crop_box.appendChild(_this.cropImage);
                helpers_1.$$('.jodit-icon_loader', _this.editor).forEach(dom_1.Dom.safeRemove);
                if (_this.activeTab === TABS.crop) {
                    _this.showCrop();
                }
                _this.j.e.fire(_this.resizeHandler, 'updatesize');
                _this.j.e.fire(_this.cropHandler, 'updatesize');
                _this.dialog.setPosition();
                _this.j.e.fire('afterImageEditor');
                resolve(_this.dialog);
            };
            _this.image.addEventListener('load', onload);
            if (_this.image.complete) {
                onload();
            }
        });
    };
    ImageEditor.prototype.destruct = function () {
        if (this.isDestructed) {
            return;
        }
        if (this.dialog && !this.dialog.isInDestruct) {
            this.dialog.destruct();
        }
        dom_1.Dom.safeRemove(this.editor);
        if (this.j.e) {
            this.j.e
                .off(this.j.ow, 'mousemove', this.onGlobalMouseMove)
                .off(this.j.ow, 'mouseup', this.onGlobalMouseUp)
                .off(this.ow, "." + jie)
                .off("." + jie);
        }
        _super.prototype.destruct.call(this);
    };
    var ImageEditor_1;
    ImageEditor.calcValueByPercent = function (value, percent) {
        var percentStr = percent.toString();
        var valueNbr = parseFloat(value.toString());
        var match;
        match = /^[-+]?[0-9]+(px)?$/.exec(percentStr);
        if (match) {
            return parseInt(percentStr, 10);
        }
        match = /^([-+]?[0-9.]+)%$/.exec(percentStr);
        if (match) {
            return Math.round(valueNbr * (parseFloat(match[1]) / 100));
        }
        return valueNbr || 0;
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], ImageEditor.prototype, "onTitleModeClick", null);
    tslib_1.__decorate([
        decorators_1.debounce(),
        decorators_1.autobind
    ], ImageEditor.prototype, "onChangeSizeInput", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], ImageEditor.prototype, "onResizeHandleMouseDown", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], ImageEditor.prototype, "onGlobalMouseUp", null);
    tslib_1.__decorate([
        decorators_1.throttle(10)
    ], ImageEditor.prototype, "onGlobalMouseMove", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], ImageEditor.prototype, "hide", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], ImageEditor.prototype, "open", null);
    ImageEditor = ImageEditor_1 = tslib_1.__decorate([
        decorators_1.component
    ], ImageEditor);
    return ImageEditor;
}(component_1.ViewComponent));
exports.ImageEditor = ImageEditor;
function openImageEditor(href, name, path, source, onSuccess, onFailed) {
    var _this = this;
    return this.getInstance('ImageEditor', this.o).open(href, function (newname, box, success, failed) {
        var promise;
        if (box.action === 'resize') {
            promise = _this.dataProvider.resize(path, source, name, newname, box.box);
        }
        else {
            promise = _this.dataProvider.crop(path, source, name, newname, box.box);
        }
        promise
            .then(function (ok) {
            if (ok) {
                success();
                if (onSuccess) {
                    onSuccess();
                }
            }
        })
            .catch(function (error) {
            failed(error);
            if (onFailed) {
                onFailed(error);
            }
        });
    });
}
exports.openImageEditor = openImageEditor;


/***/ }),
/* 197 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 198 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.form = void 0;
var ui_1 = __webpack_require__(75);
var jie = 'jodit-image-editor';
var gi = ui_1.Icon.get.bind(ui_1.Icon);
var act = function (el, className) {
    if (className === void 0) { className = 'jodti-image-editor_active'; }
    return el ? className : '';
};
var form = function (editor, o) {
    var i = editor.i18n.bind(editor);
    var switcher = function (label, ref, active) {
        if (active === void 0) { active = true; }
        return "<div class=\"jodit-form__group\">\n\t\t\t<label>" + i(label) + "</label>\n\n\t\t\t<label class='jodi-switcher'>\n\t\t\t\t<input " + act(active, 'checked') + " data-ref=\"" + ref + "\" type=\"checkbox\"/>\n\t\t\t\t<span class=\"jodi-switcher__slider\"></span>\n\t\t\t</label>\n\t</div>";
    };
    return editor.create.fromHTML("<form class=\"" + jie + " jodit-properties\">\n\t\t<div class=\"jodit-grid jodit-grid_xs-column\">\n\t\t\t<div class=\"jodit_col-lg-3-4 jodit_col-sm-5-5\">\n\t\t\t" + (o.resize
        ? "<div class=\"" + jie + "__area " + jie + "__area_resize " + jie + "_active\">\n\t\t\t\t\t\t\t<div data-ref=\"resizeBox\" class=\"" + jie + "__box\"></div>\n\t\t\t\t\t\t\t<div class=\"" + jie + "__resizer\">\n\t\t\t\t\t\t\t\t<i class=\"jodit_bottomright\"></i>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>"
        : '') + "\n\t\t\t" + (o.crop
        ? "<div class=\"" + jie + "__area " + jie + "__area_crop " + act(!o.resize) + "\">\n\t\t\t\t\t\t\t<div data-ref=\"cropBox\" class=\"" + jie + "__box\">\n\t\t\t\t\t\t\t\t<div class=\"" + jie + "__croper\">\n\t\t\t\t\t\t\t\t\t<i class=\"jodit_bottomright\"></i>\n\t\t\t\t\t\t\t\t\t<i class=\"" + jie + "__sizes\"></i>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>"
        : '') + "\n\t\t\t</div>\n\t\t\t<div class=\"jodit_col-lg-1-4 jodit_col-sm-5-5\">\n\t\t\t" + (o.resize
        ? "<div data-area=\"resize\" class=\"" + jie + "__slider " + jie + "_active\">\n\t\t\t\t\t\t\t<div class=\"" + jie + "__slider-title\">\n\t\t\t\t\t\t\t\t" + gi('resize') + "\n\t\t\t\t\t\t\t\t" + i('Resize') + "\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"" + jie + "__slider-content\">\n\t\t\t\t\t\t\t\t<div class=\"jodit-form__group\">\n\t\t\t\t\t\t\t\t\t<label>\n\t\t\t\t\t\t\t\t\t\t" + i('Width') + "\n\t\t\t\t\t\t\t\t\t</label>\n\t\t\t\t\t\t\t\t\t<input type=\"number\" data-ref=\"widthInput\" class=\"jodit-input\"/>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t<div class=\"jodit-form__group\">\n\t\t\t\t\t\t\t\t\t<label>\n\t\t\t\t\t\t\t\t\t\t" + i('Height') + "\n\t\t\t\t\t\t\t\t\t</label>\n\t\t\t\t\t\t\t\t\t<input type=\"number\" data-ref=\"heightInput\" class=\"jodit-input\"/>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t" + switcher('Keep Aspect Ratio', 'keepAspectRatioResize') + "\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>"
        : '') + "\n\t\t\t" + (o.crop
        ? "<div data-area=\"crop\" class=\"" + jie + "__slider " + act(!o.resize) + "'\">\n\t\t\t\t\t\t\t<div class=\"" + jie + "__slider-title\">\n\t\t\t\t\t\t\t\t" + gi('crop') + "\n\t\t\t\t\t\t\t\t" + i('Crop') + "\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"" + jie + "__slider-content\">\n\t\t\t\t\t\t\t\t" + switcher('Keep Aspect Ratio', 'keepAspectRatioCrop') + "\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>"
        : '') + "\n\t\t\t</div>\n\t\t</div>\n\t</form>");
};
exports.form = form;


/***/ }),
/* 199 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.selfListeners = void 0;
var dialog_1 = __webpack_require__(163);
var checker_1 = __webpack_require__(34);
var helpers_1 = __webpack_require__(19);
var data_provider_1 = __webpack_require__(191);
var image_editor_1 = __webpack_require__(196);
function selfListeners() {
    var _this = this;
    var state = this.state, dp = this.dataProvider, self = this;
    self.e
        .on('view.filebrowser', function (view) {
        if (view !== state.view) {
            state.view = view;
        }
    })
        .on('sort.filebrowser', function (value) {
        if (value !== state.sortBy) {
            state.sortBy = value;
            self.loadItems();
        }
    })
        .on('filter.filebrowser', function (value) {
        if (value !== state.filterWord) {
            state.filterWord = value;
            self.loadItems();
        }
    })
        .on('openFolder.filebrowser', function (data) {
        var path;
        if (data.name === '..') {
            path = data.path
                .split('/')
                .filter(function (p) { return p.length; })
                .slice(0, -1)
                .join('/');
        }
        else {
            path = helpers_1.normalizePath(data.path, data.name);
        }
        self.state.currentPath = path;
        self.state.currentSource =
            data.name === '.' ? data_provider_1.DEFAULT_SOURCE_NAME : data.source;
    })
        .on('removeFolder.filebrowser', function (data) {
        dialog_1.Confirm(self.i18n('Are you sure?'), self.i18n('Delete'), function (yes) {
            if (yes) {
                dp.folderRemove(data.path, data.name, data.source)
                    .then(function (message) {
                    self.status(message, true);
                    self.loadTree();
                })
                    .catch(self.status);
            }
        }).bindDestruct(self);
    })
        .on('renameFolder.filebrowser', function (data) {
        dialog_1.Prompt(self.i18n('Enter new name'), self.i18n('Rename'), function (newName) {
            if (!checker_1.isValidName(newName)) {
                self.status(self.i18n('Enter new name'));
                return false;
            }
            dp.folderRename(data.path, data.name, newName, data.source)
                .then(function (message) {
                self.state.activeElements = [];
                self.status(message, true);
                self.loadTree();
            })
                .catch(self.status);
            return;
        }, self.i18n('type name'), data.name).bindDestruct(self);
    })
        .on('addFolder.filebrowser', function (data) {
        dialog_1.Prompt(self.i18n('Enter Directory name'), self.i18n('Create directory'), function (name) {
            dp.createFolder(name, data.path, data.source).then(function () {
                self.loadTree();
            }, self.status);
        }, self.i18n('type name')).bindDestruct(self);
    })
        .on('fileRemove.filebrowser', function () {
        if (self.state.activeElements.length) {
            dialog_1.Confirm(self.i18n('Are you sure?'), '', function (yes) {
                if (yes) {
                    var promises_1 = [];
                    self.state.activeElements.forEach(function (item) {
                        promises_1.push(self.deleteFile(item.file || item.name || '', item.sourceName));
                    });
                    self.state.activeElements = [];
                    Promise.all(promises_1).then(function () {
                        return self.loadTree();
                    });
                }
            }).bindDestruct(self);
        }
    })
        .on('edit.filebrowser', function () {
        if (self.state.activeElements.length === 1) {
            var file = _this.state.activeElements[0];
            image_editor_1.openImageEditor.call(self, file.fileURL, file.file || '', file.path, file.sourceName);
        }
    })
        .on('fileRename.filebrowser', function (name, path, source) {
        if (self.state.activeElements.length === 1) {
            dialog_1.Prompt(self.i18n('Enter new name'), self.i18n('Rename'), function (newName) {
                if (!checker_1.isValidName(newName)) {
                    self.status(self.i18n('Enter new name'));
                    return false;
                }
                dp.fileRename(path, name, newName, source)
                    .then(function (message) {
                    self.state.activeElements = [];
                    self.status(message, true);
                    self.loadItems();
                })
                    .catch(self.status);
                return;
            }, self.i18n('type name'), name).bindDestruct(_this);
        }
    })
        .on('update.filebrowser', function () {
        self.loadTree();
    });
}
exports.selfListeners = selfListeners;


/***/ }),
/* 200 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Observer = void 0;
var tslib_1 = __webpack_require__(7);
var config_1 = __webpack_require__(8);
var component_1 = __webpack_require__(27);
var snapshot_1 = __webpack_require__(201);
var stack_1 = __webpack_require__(202);
var command_1 = __webpack_require__(203);
var decorators_1 = __webpack_require__(99);
config_1.Config.prototype.observer = {
    maxHistoryLength: Infinity,
    timeout: 100
};
var Observer = (function (_super) {
    tslib_1.__extends(Observer, _super);
    function Observer(editor) {
        var _this = _super.call(this, editor) || this;
        _this.stack = new stack_1.Stack(_this.j.o.observer.maxHistoryLength);
        _this.snapshot = new snapshot_1.Snapshot(_this.j);
        _this.updateTick = 0;
        editor.e.on('afterAddPlace.observer', function () {
            if (_this.isInDestruct) {
                return;
            }
            _this.startValue = _this.snapshot.make();
            editor.events
                .on('internalChange', function () {
                _this.startValue = _this.snapshot.make();
            })
                .on(editor.editor, [
                'changeSelection',
                'selectionstart',
                'selectionchange',
                'mousedown',
                'mouseup',
                'keydown',
                'keyup'
            ]
                .map(function (f) { return f + '.observer'; })
                .join(' '), function () {
                if (_this.startValue.html ===
                    _this.j.getNativeEditorValue()) {
                    _this.startValue = _this.snapshot.make();
                }
            })
                .on(_this, 'change.observer', _this.onChange);
        });
        return _this;
    }
    Observer.prototype.className = function () {
        return 'Observer';
    };
    Object.defineProperty(Observer.prototype, "startValue", {
        get: function () {
            return this.__startValue;
        },
        set: function (value) {
            this.__startValue = value;
        },
        enumerable: false,
        configurable: true
    });
    Observer.prototype.upTick = function () {
        this.updateTick += 1;
    };
    Observer.prototype.onChange = function () {
        if (this.snapshot.isBlocked) {
            return;
        }
        this.updateStack();
    };
    Observer.prototype.updateStack = function (replace) {
        if (replace === void 0) { replace = false; }
        var newValue = this.snapshot.make();
        if (!snapshot_1.Snapshot.equal(newValue, this.startValue)) {
            var newCommand = new command_1.Command(this.startValue, newValue, this, this.updateTick);
            if (replace) {
                var command = this.stack.current();
                if (command && this.updateTick === command.tick) {
                    this.stack.replace(newCommand);
                }
            }
            else {
                this.stack.push(newCommand);
            }
            this.startValue = newValue;
            this.fireChangeStack();
        }
    };
    Observer.prototype.redo = function () {
        if (this.stack.redo()) {
            this.startValue = this.snapshot.make();
            this.fireChangeStack();
        }
    };
    Observer.prototype.undo = function () {
        if (this.stack.undo()) {
            this.startValue = this.snapshot.make();
            this.fireChangeStack();
        }
    };
    Observer.prototype.clear = function () {
        this.startValue = this.snapshot.make();
        this.stack.clear();
        this.fireChangeStack();
    };
    Observer.prototype.replaceSnapshot = function () {
        this.updateStack(true);
    };
    Observer.prototype.fireChangeStack = function () {
        var _a;
        this.j && !this.j.isInDestruct && ((_a = this.j.events) === null || _a === void 0 ? void 0 : _a.fire('changeStack'));
    };
    Observer.prototype.destruct = function () {
        if (this.j.events) {
            this.j.e.off('.observer');
        }
        this.snapshot.destruct();
        _super.prototype.destruct.call(this);
    };
    tslib_1.__decorate([
        decorators_1.debounce()
    ], Observer.prototype, "onChange", null);
    return Observer;
}(component_1.ViewComponent));
exports.Observer = Observer;


/***/ }),
/* 201 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Snapshot = void 0;
var tslib_1 = __webpack_require__(7);
var component_1 = __webpack_require__(27);
var dom_1 = __webpack_require__(32);
var Snapshot = (function (_super) {
    tslib_1.__extends(Snapshot, _super);
    function Snapshot() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isBlocked = false;
        return _this;
    }
    Snapshot.prototype.className = function () {
        return 'Snapshot';
    };
    Snapshot.equal = function (first, second) {
        return (first.html === second.html &&
            JSON.stringify(first.range) === JSON.stringify(second.range));
    };
    Snapshot.countNodesBeforeInParent = function (elm) {
        if (!elm.parentNode) {
            return 0;
        }
        var elms = elm.parentNode.childNodes;
        var count = 0, last = null, j;
        for (j = 0; j < elms.length; j += 1) {
            if (last &&
                !(dom_1.Dom.isText(elms[j]) && elms[j].textContent === '') &&
                !(dom_1.Dom.isText(last) && dom_1.Dom.isText(elms[j]))) {
                count += 1;
            }
            if (elms[j] === elm) {
                return count;
            }
            last = elms[j];
        }
        return 0;
    };
    Snapshot.strokeOffset = function (elm, offset) {
        while (dom_1.Dom.isText(elm)) {
            elm = elm.previousSibling;
            if (dom_1.Dom.isText(elm) && elm.textContent != null) {
                offset += elm.textContent.length;
            }
        }
        return offset;
    };
    Snapshot.prototype.calcHierarchyLadder = function (elm) {
        var counts = [];
        if (!elm || !elm.parentNode || !dom_1.Dom.isOrContains(this.j.editor, elm)) {
            return [];
        }
        while (elm && elm !== this.j.editor) {
            if (elm) {
                counts.push(Snapshot.countNodesBeforeInParent(elm));
            }
            elm = elm.parentNode;
        }
        return counts.reverse();
    };
    Snapshot.prototype.getElementByLadder = function (ladder) {
        var n = this.j.editor, i;
        for (i = 0; n && i < ladder.length; i += 1) {
            n = n.childNodes[ladder[i]];
        }
        return n;
    };
    Snapshot.prototype.make = function () {
        var snapshot = {
            html: '',
            range: {
                startContainer: [],
                startOffset: 0,
                endContainer: [],
                endOffset: 0
            }
        };
        snapshot.html = this.j.getNativeEditorValue();
        var sel = this.j.s.sel;
        if (sel && sel.rangeCount) {
            var range = sel.getRangeAt(0), startContainer = this.calcHierarchyLadder(range.startContainer), endContainer = this.calcHierarchyLadder(range.endContainer);
            var startOffset = Snapshot.strokeOffset(range.startContainer, range.startOffset), endOffset = Snapshot.strokeOffset(range.endContainer, range.endOffset);
            if (!startContainer.length &&
                range.startContainer !== this.j.editor) {
                startOffset = 0;
            }
            if (!endContainer.length && range.endContainer !== this.j.editor) {
                endOffset = 0;
            }
            snapshot.range = {
                startContainer: startContainer,
                startOffset: startOffset,
                endContainer: endContainer,
                endOffset: endOffset
            };
        }
        return snapshot;
    };
    Snapshot.prototype.restore = function (snapshot) {
        this.isBlocked = true;
        var scroll = this.storeScrollState();
        var value = this.j.getNativeEditorValue();
        if (value !== snapshot.html) {
            this.j.setEditorValue(snapshot.html);
        }
        this.restoreOnlySelection(snapshot);
        this.restoreScrollState(scroll);
        this.isBlocked = false;
    };
    Snapshot.prototype.storeScrollState = function () {
        return [this.j.ow.scrollY, this.j.editor.scrollTop];
    };
    Snapshot.prototype.restoreScrollState = function (scrolls) {
        var j = this.j, ow = j.ow;
        ow.scrollTo(ow.scrollX, scrolls[0]);
        j.editor.scrollTop = scrolls[1];
    };
    Snapshot.prototype.restoreOnlySelection = function (snapshot) {
        try {
            if (snapshot.range) {
                var range = this.j.ed.createRange();
                range.setStart(this.getElementByLadder(snapshot.range.startContainer), snapshot.range.startOffset);
                range.setEnd(this.getElementByLadder(snapshot.range.endContainer), snapshot.range.endOffset);
                this.j.s.selectRange(range);
            }
        }
        catch (__ignore) {
            this.j.editor.lastChild &&
                this.j.s.setCursorAfter(this.j.editor.lastChild);
            if (false) {}
        }
    };
    Snapshot.prototype.destruct = function () {
        this.isBlocked = false;
        _super.prototype.destruct.call(this);
    };
    return Snapshot;
}(component_1.ViewComponent));
exports.Snapshot = Snapshot;


/***/ }),
/* 202 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Stack = void 0;
var Stack = (function () {
    function Stack(size) {
        this.size = size;
        this.commands = [];
        this.stackPosition = -1;
    }
    Object.defineProperty(Stack.prototype, "length", {
        get: function () {
            return this.commands.length;
        },
        enumerable: false,
        configurable: true
    });
    Stack.prototype.clearRedo = function () {
        this.commands.length = this.stackPosition + 1;
    };
    Stack.prototype.clear = function () {
        this.commands.length = 0;
        this.stackPosition = -1;
    };
    Stack.prototype.push = function (command) {
        this.clearRedo();
        this.commands.push(command);
        this.stackPosition += 1;
        if (this.commands.length > this.size) {
            this.commands.shift();
            this.stackPosition -= 1;
        }
    };
    Stack.prototype.replace = function (command) {
        this.commands[this.stackPosition] = command;
    };
    Stack.prototype.current = function () {
        return this.commands[this.stackPosition];
    };
    Stack.prototype.undo = function () {
        if (this.canUndo()) {
            if (this.commands[this.stackPosition]) {
                this.commands[this.stackPosition].undo();
            }
            this.stackPosition -= 1;
            return true;
        }
        return false;
    };
    Stack.prototype.redo = function () {
        if (this.canRedo()) {
            this.stackPosition += 1;
            if (this.commands[this.stackPosition]) {
                this.commands[this.stackPosition].redo();
            }
            return true;
        }
        return false;
    };
    Stack.prototype.canUndo = function () {
        return this.stackPosition >= 0;
    };
    Stack.prototype.canRedo = function () {
        return this.stackPosition < this.commands.length - 1;
    };
    return Stack;
}());
exports.Stack = Stack;


/***/ }),
/* 203 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Command = void 0;
var Command = (function () {
    function Command(oldValue, newValue, observer, tick) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.observer = observer;
        this.tick = tick;
    }
    Command.prototype.undo = function () {
        this.observer.snapshot.restore(this.oldValue);
    };
    Command.prototype.redo = function () {
        this.observer.snapshot.restore(this.newValue);
    };
    return Command;
}());
exports.Command = Command;


/***/ }),
/* 204 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(205), exports);
tslib_1.__exportStar(__webpack_require__(207), exports);


/***/ }),
/* 205 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Style = void 0;
var constants_1 = __webpack_require__(9);
var apply_style_1 = __webpack_require__(206);
var Style = (function () {
    function Style(options) {
        this.options = options;
    }
    Object.defineProperty(Style.prototype, "element", {
        get: function () {
            return this.options.element || this.defaultTag;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Style.prototype, "elementIsBlock", {
        get: function () {
            return Boolean(this.options.element && constants_1.IS_BLOCK.test(this.options.element));
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Style.prototype, "defaultTag", {
        get: function () {
            if (this.options.defaultTag) {
                return this.options.defaultTag;
            }
            return this.elementIsBlock ? 'p' : 'span';
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Style.prototype, "elementIsDefault", {
        get: function () {
            return this.element === this.defaultTag;
        },
        enumerable: false,
        configurable: true
    });
    Style.prototype.apply = function (jodit) {
        var applyStyle = new apply_style_1.ApplyStyle(jodit, this);
        applyStyle.apply();
    };
    return Style;
}());
exports.Style = Style;


/***/ }),
/* 206 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ApplyStyle = void 0;
var tslib_1 = __webpack_require__(7);
var checker_1 = __webpack_require__(34);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var decorators_1 = __webpack_require__(99);
var mode;
(function (mode) {
    mode["UNWRAP"] = "UNWRAP";
    mode["WRAP"] = "WRAP";
})(mode || (mode = {}));
var ApplyStyle = (function () {
    function ApplyStyle(jodit, style) {
        this.jodit = jodit;
        this.style = style;
    }
    ApplyStyle.prototype.apply = function () {
        var sel = this.jodit.selection;
        var isCollapsed = sel.isCollapsed();
        if (isCollapsed) {
            var font = this.jodit.createInside.element('font');
            sel.insertNode(font, false, false);
            sel.setCursorIn(font);
            sel.save();
            if (!this.checkSpecialElements(font)) {
                this.applyToElement(font);
            }
            dom_1.Dom.unwrap(font);
        }
        else {
            sel.save();
            helpers_1.normalizeNode(sel.area.firstChild);
            sel.wrapInTag(this.applyToElement);
        }
        sel.restore();
    };
    ApplyStyle.prototype.applyToElement = function (font) {
        var _this = this;
        var area = this.jodit.selection.area;
        if (this.checkSpecialElements(font)) {
            return;
        }
        if (this.checkSuitableParent(font) ||
            this.checkSuitableChild(font) ||
            this.checkClosestWrapper(font) ||
            this.unwrapChildren(font)) {
            return;
        }
        if (!this.mode) {
            this.mode = mode.WRAP;
        }
        if (this.mode !== mode.WRAP) {
            return;
        }
        var wrapper = font;
        if (this.style.elementIsBlock) {
            var ulReg_1 = /^(ul|ol|li|td|th|tr|tbody|table)$/i;
            var box_1 = dom_1.Dom.up(font, function (node) {
                if (node && dom_1.Dom.isBlock(node, _this.jodit.s.win)) {
                    if (ulReg_1.test(_this.style.element) ||
                        !ulReg_1.test(node.nodeName)) {
                        return true;
                    }
                }
                return false;
            }, area);
            if (box_1) {
                wrapper = box_1;
            }
            else {
                wrapper = this.wrapUnwrappedText(font);
            }
        }
        var newWrapper = dom_1.Dom.replace(wrapper, this.style.element, this.jodit.createInside, true);
        helpers_1.attr(newWrapper, 'size', null);
        if (this.style.elementIsBlock) {
            this.postProcessListElement(newWrapper);
        }
        if (this.style.options.style && this.style.elementIsDefault) {
            helpers_1.css(newWrapper, this.style.options.style);
        }
        if (this.style.options.className) {
            newWrapper.classList.toggle(this.style.options.className);
        }
    };
    ApplyStyle.prototype.checkSpecialElements = function (font) {
        var editor = this.jodit.editor;
        return Boolean(dom_1.Dom.closest(font, ['style', 'script'], editor));
    };
    ApplyStyle.prototype.checkSuitableParent = function (font) {
        var parentNode = font.parentNode;
        if (parentNode &&
            !dom_1.Dom.next(font, this.isNormalNode, parentNode) &&
            !dom_1.Dom.prev(font, this.isNormalNode, parentNode) &&
            this.isSuitableElement(parentNode, false) &&
            parentNode !== this.jodit.s.area &&
            (!dom_1.Dom.isBlock(parentNode, this.jodit.ew) ||
                this.style.elementIsBlock)) {
            this.toggleStyles(parentNode);
            return true;
        }
        return false;
    };
    ApplyStyle.prototype.checkSuitableChild = function (font) {
        var firstChild = font.firstChild;
        if (firstChild && this.jodit.s.isMarker(firstChild)) {
            firstChild = firstChild.nextSibling;
        }
        if (firstChild &&
            !dom_1.Dom.next(firstChild, this.isNormalNode, font) &&
            !dom_1.Dom.prev(firstChild, this.isNormalNode, font) &&
            this.isSuitableElement(firstChild, false)) {
            this.toggleStyles(firstChild);
            return true;
        }
        return false;
    };
    ApplyStyle.prototype.checkClosestWrapper = function (font) {
        var wrapper = dom_1.Dom.closest(font, this.isSuitableElement, this.jodit.editor);
        if (wrapper) {
            if (this.style.elementIsBlock) {
                this.toggleStyles(wrapper);
                return true;
            }
            var leftRange = this.jodit.s.createRange();
            leftRange.setStartBefore(wrapper);
            leftRange.setEndBefore(font);
            var leftFragment = leftRange.extractContents();
            if ((!leftFragment.textContent ||
                !helpers_1.trim(leftFragment.textContent).length) &&
                leftFragment.firstChild) {
                dom_1.Dom.unwrap(leftFragment.firstChild);
            }
            if (wrapper.parentNode) {
                wrapper.parentNode.insertBefore(leftFragment, wrapper);
            }
            leftRange.setStartAfter(font);
            leftRange.setEndAfter(wrapper);
            var rightFragment = leftRange.extractContents();
            if ((!rightFragment.textContent ||
                !helpers_1.trim(rightFragment.textContent).length) &&
                rightFragment.firstChild) {
                dom_1.Dom.unwrap(rightFragment.firstChild);
            }
            dom_1.Dom.after(wrapper, rightFragment);
            this.toggleStyles(wrapper);
            return true;
        }
        return false;
    };
    ApplyStyle.prototype.elementHasSameStyle = function (elm, rules) {
        return Boolean(checker_1.isPlainObject(rules) &&
            !dom_1.Dom.isTag(elm, 'font') &&
            dom_1.Dom.isHTMLElement(elm, this.jodit.ew) &&
            helpers_1.each(rules, function (property, checkValue) {
                var value = helpers_1.css(elm, property, undefined, true);
                return (!checker_1.isVoid(value) &&
                    value !== '' &&
                    !checker_1.isVoid(checkValue) &&
                    helpers_1.normalizeCssValue(property, checkValue)
                        .toString()
                        .toLowerCase() === value.toString().toLowerCase());
            }));
    };
    ApplyStyle.prototype.isSuitableElement = function (elm, strict) {
        if (strict === void 0) { strict = true; }
        if (!elm) {
            return false;
        }
        var _a = this.style, element = _a.element, elementIsDefault = _a.elementIsDefault, options = _a.options;
        var elmHasSameStyle = this.elementHasSameStyle(elm, options.style);
        var elmIsSame = elm.nodeName.toLowerCase() === element;
        return (((!elementIsDefault || !strict) && elmIsSame) ||
            (elmHasSameStyle && this.isNormalNode(elm)));
    };
    ApplyStyle.prototype.isNormalNode = function (elm) {
        return Boolean(elm != null &&
            !dom_1.Dom.isEmptyTextNode(elm) &&
            !this.jodit.s.isMarker(elm));
    };
    ApplyStyle.prototype.toggleStyles = function (elm) {
        var _this = this;
        var style = this.style.options.style;
        if (style && elm.nodeName.toLowerCase() === this.style.defaultTag) {
            Object.keys(style).forEach(function (rule) {
                if (_this.mode === mode.UNWRAP ||
                    helpers_1.css(elm, rule) ===
                        helpers_1.normalizeCssValue(rule, style[rule])) {
                    helpers_1.css(elm, rule, '');
                    if (_this.mode === undefined) {
                        _this.mode = mode.UNWRAP;
                    }
                }
                else {
                    helpers_1.css(elm, rule, style[rule]);
                    if (_this.mode === undefined) {
                        _this.mode = mode.WRAP;
                    }
                }
            });
        }
        var isBlock = dom_1.Dom.isBlock(elm, this.jodit.ew);
        var isSuitableInline = !isBlock &&
            (!helpers_1.attr(elm, 'style') ||
                elm.nodeName.toLowerCase() !== this.style.defaultTag);
        var isSuitableBlock = !isSuitableInline &&
            isBlock &&
            elm.nodeName.toLowerCase() === this.style.element;
        if (isSuitableInline || isSuitableBlock) {
            dom_1.Dom.unwrap(elm);
            if (this.mode === undefined) {
                this.mode = mode.UNWRAP;
            }
        }
    };
    ApplyStyle.prototype.unwrapChildren = function (font) {
        var _this = this;
        var needUnwrap = [];
        var firstElementSuit;
        if (font.firstChild) {
            dom_1.Dom.find(font.firstChild, function (elm) {
                if (elm && _this.isSuitableElement(elm)) {
                    if (firstElementSuit === undefined) {
                        firstElementSuit = true;
                    }
                    needUnwrap.push(elm);
                }
                else {
                    if (firstElementSuit === undefined) {
                        firstElementSuit = false;
                    }
                }
                return false;
            }, font, true);
        }
        needUnwrap.forEach(dom_1.Dom.unwrap);
        return Boolean(firstElementSuit);
    };
    ApplyStyle.prototype.wrapUnwrappedText = function (elm) {
        var _a = this.jodit.selection, area = _a.area, win = _a.win;
        var edge = function (n, key) {
            if (key === void 0) { key = 'previousSibling'; }
            var edgeNode = n, node = n;
            while (node) {
                edgeNode = node;
                if (node[key]) {
                    node = node[key];
                }
                else {
                    node =
                        node.parentNode &&
                            !dom_1.Dom.isBlock(node.parentNode, win) &&
                            node.parentNode !== area
                            ? node.parentNode
                            : null;
                }
                if (dom_1.Dom.isBlock(node, win)) {
                    break;
                }
            }
            return edgeNode;
        };
        var start = edge(elm), end = edge(elm, 'nextSibling');
        var range = this.jodit.s.createRange();
        range.setStartBefore(start);
        range.setEndAfter(end);
        var fragment = range.extractContents();
        var wrapper = this.jodit.createInside.element(this.style.element);
        wrapper.appendChild(fragment);
        range.insertNode(wrapper);
        if (this.style.elementIsBlock) {
            this.postProcessListElement(wrapper);
            if (dom_1.Dom.isEmpty(wrapper) &&
                !dom_1.Dom.isTag(wrapper.firstElementChild, 'br')) {
                wrapper.appendChild(this.jodit.createInside.element('br'));
            }
        }
        return wrapper;
    };
    ApplyStyle.prototype.postProcessListElement = function (wrapper) {
        if (/^(OL|UL)$/i.test(this.style.element) &&
            !dom_1.Dom.isTag(wrapper.firstElementChild, 'li')) {
            var ci = this.jodit.createInside;
            var li = dom_1.Dom.replace(wrapper, 'li', ci), ul = dom_1.Dom.wrap(li, this.style.element, ci);
            if (ul) {
                wrapper = ul;
            }
        }
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], ApplyStyle.prototype, "applyToElement", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], ApplyStyle.prototype, "isSuitableElement", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], ApplyStyle.prototype, "isNormalNode", null);
    return ApplyStyle;
}());
exports.ApplyStyle = ApplyStyle;


/***/ }),
/* 207 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Select = void 0;
var tslib_1 = __webpack_require__(7);
var consts = __webpack_require__(9);
var constants_1 = __webpack_require__(9);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var style_1 = __webpack_require__(205);
var decorators_1 = __webpack_require__(99);
var Select = (function () {
    function Select(jodit) {
        var _this = this;
        this.jodit = jodit;
        this.isMarker = function (elm) {
            return dom_1.Dom.isNode(elm, _this.win) &&
                dom_1.Dom.isTag(elm, 'span') &&
                elm.hasAttribute('data-' + consts.MARKER_CLASS);
        };
        this.eachSelection = function (callback) {
            var sel = _this.sel;
            if (sel && sel.rangeCount) {
                var range = sel.getRangeAt(0);
                var nodes_1 = [], startOffset = range.startOffset, length_1 = _this.area.childNodes.length, elementOffset = startOffset < length_1 ? startOffset : length_1 - 1, start = range.startContainer === _this.area
                    ? _this.area.childNodes[elementOffset]
                    : range.startContainer, end_1 = range.endContainer === _this.area
                    ? _this.area.childNodes[range.endOffset - 1]
                    : range.endContainer;
                dom_1.Dom.find(start, function (node) {
                    if (node &&
                        node !== _this.area &&
                        !dom_1.Dom.isEmptyTextNode(node) &&
                        !_this.isMarker(node)) {
                        nodes_1.push(node);
                    }
                    return (node === end_1 ||
                        (node && node.contains && node.contains(end_1)));
                }, _this.area, true, 'nextSibling', false);
                var forEvery_1 = function (current) {
                    if (!dom_1.Dom.isOrContains(_this.j.editor, current, true)) {
                        return;
                    }
                    if (current.nodeName.match(/^(UL|OL)$/)) {
                        return helpers_1.toArray(current.childNodes).forEach(forEvery_1);
                    }
                    if (dom_1.Dom.isTag(current, 'li')) {
                        if (current.firstChild) {
                            current = current.firstChild;
                        }
                        else {
                            var currentB = _this.j.createInside.text(constants_1.INVISIBLE_SPACE);
                            current.appendChild(currentB);
                            current = currentB;
                        }
                    }
                    callback(current);
                };
                if (nodes_1.length === 0 && dom_1.Dom.isEmptyTextNode(start)) {
                    nodes_1.push(start);
                }
                nodes_1.forEach(forEvery_1);
            }
        };
        jodit.e.on('removeMarkers', function () {
            _this.removeMarkers();
        });
    }
    Object.defineProperty(Select.prototype, "j", {
        get: function () {
            return this.jodit;
        },
        enumerable: false,
        configurable: true
    });
    Select.prototype.errorNode = function (node) {
        if (!dom_1.Dom.isNode(node, this.win)) {
            throw helpers_1.error('Parameter node must be instance of Node');
        }
    };
    Object.defineProperty(Select.prototype, "area", {
        get: function () {
            return this.j.editor;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Select.prototype, "win", {
        get: function () {
            return this.j.ew;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Select.prototype, "doc", {
        get: function () {
            return this.j.ed;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Select.prototype, "sel", {
        get: function () {
            if (this.j.o.shadowRoot) {
                return this.j.o.shadowRoot.getSelection();
            }
            return this.win.getSelection();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Select.prototype, "range", {
        get: function () {
            var sel = this.sel;
            return sel && sel.rangeCount ? sel.getRangeAt(0) : this.createRange();
        },
        enumerable: false,
        configurable: true
    });
    Select.prototype.createRange = function (select) {
        if (select === void 0) { select = false; }
        var range = this.doc.createRange();
        if (select) {
            this.selectRange(range);
        }
        return range;
    };
    Select.prototype.remove = function () {
        var sel = this.sel, current = this.current();
        if (sel && current) {
            for (var i = 0; i < sel.rangeCount; i += 1) {
                sel.getRangeAt(i).deleteContents();
                sel.getRangeAt(i).collapse(true);
            }
        }
    };
    Select.prototype.clear = function () {
        var _a, _b;
        if ((_a = this.sel) === null || _a === void 0 ? void 0 : _a.rangeCount) {
            (_b = this.sel) === null || _b === void 0 ? void 0 : _b.removeAllRanges();
        }
    };
    Select.prototype.removeNode = function (node) {
        if (!dom_1.Dom.isOrContains(this.j.editor, node, true)) {
            throw helpers_1.error("Selection.removeNode can remove only editor's children");
        }
        dom_1.Dom.safeRemove(node);
        this.j.e.fire('afterRemoveNode', node);
    };
    Select.prototype.insertCursorAtPoint = function (x, y) {
        var _this = this;
        this.removeMarkers();
        try {
            var rng_1 = this.createRange();
            (function () {
                if (_this.doc.caretPositionFromPoint) {
                    var caret = _this.doc.caretPositionFromPoint(x, y);
                    if (caret) {
                        rng_1.setStart(caret.offsetNode, caret.offset);
                        return;
                    }
                }
                if (_this.doc.caretRangeFromPoint) {
                    var caret = _this.doc.caretRangeFromPoint(x, y);
                    rng_1.setStart(caret.startContainer, caret.startOffset);
                }
            })();
            rng_1.collapse(true);
            this.selectRange(rng_1);
            return true;
        }
        catch (_a) { }
        return false;
    };
    Object.defineProperty(Select.prototype, "hasMarkers", {
        get: function () {
            return Boolean(helpers_1.$$('span[data-' + consts.MARKER_CLASS + ']', this.area).length);
        },
        enumerable: false,
        configurable: true
    });
    Select.prototype.removeMarkers = function () {
        helpers_1.$$('span[data-' + consts.MARKER_CLASS + ']', this.area).forEach(dom_1.Dom.safeRemove);
    };
    Select.prototype.marker = function (atStart, range) {
        if (atStart === void 0) { atStart = false; }
        var newRange = null;
        if (range) {
            newRange = range.cloneRange();
            newRange.collapse(atStart);
        }
        var marker = this.j.createInside.span();
        marker.id =
            consts.MARKER_CLASS +
                '_' +
                Number(new Date()) +
                '_' +
                String(Math.random()).slice(2);
        marker.style.lineHeight = '0';
        marker.style.display = 'none';
        marker.setAttribute('data-' + consts.MARKER_CLASS, atStart ? 'start' : 'end');
        marker.appendChild(this.j.createInside.text(consts.INVISIBLE_SPACE));
        if (newRange) {
            if (dom_1.Dom.isOrContains(this.area, atStart ? newRange.startContainer : newRange.endContainer)) {
                newRange.insertNode(marker);
            }
        }
        return marker;
    };
    Select.prototype.restore = function () {
        var range = false;
        var markAttr = function (start) {
            return "span[data-" + consts.MARKER_CLASS + "=" + (start ? 'start' : 'end') + "]";
        };
        var start = this.area.querySelector(markAttr(true)), end = this.area.querySelector(markAttr(false));
        if (!start) {
            return;
        }
        range = this.createRange();
        if (!end) {
            var previousNode = start.previousSibling;
            if (dom_1.Dom.isText(previousNode)) {
                range.setStart(previousNode, previousNode.nodeValue ? previousNode.nodeValue.length : 0);
            }
            else {
                range.setStartBefore(start);
            }
            dom_1.Dom.safeRemove(start);
            range.collapse(true);
        }
        else {
            range.setStartAfter(start);
            dom_1.Dom.safeRemove(start);
            range.setEndBefore(end);
            dom_1.Dom.safeRemove(end);
        }
        if (range) {
            this.selectRange(range);
        }
    };
    Select.prototype.save = function (silent) {
        if (silent === void 0) { silent = false; }
        if (this.hasMarkers) {
            return [];
        }
        var sel = this.sel;
        if (!sel || !sel.rangeCount) {
            return [];
        }
        var info = [], length = sel.rangeCount, ranges = [];
        for (var i = 0; i < length; i += 1) {
            ranges[i] = sel.getRangeAt(i);
            if (ranges[i].collapsed) {
                var start = this.marker(true, ranges[i]);
                info[i] = {
                    startId: start.id,
                    collapsed: true,
                    startMarker: start.outerHTML
                };
            }
            else {
                var start = this.marker(true, ranges[i]);
                var end = this.marker(false, ranges[i]);
                info[i] = {
                    startId: start.id,
                    endId: end.id,
                    collapsed: false,
                    startMarker: start.outerHTML,
                    endMarker: end.outerHTML
                };
            }
        }
        if (!silent) {
            sel.removeAllRanges();
            for (var i = length - 1; i >= 0; --i) {
                var startElm = this.doc.getElementById(info[i].startId);
                if (startElm) {
                    if (info[i].collapsed) {
                        ranges[i].setStartAfter(startElm);
                        ranges[i].collapse(true);
                    }
                    else {
                        ranges[i].setStartBefore(startElm);
                        if (info[i].endId) {
                            var endElm = this.doc.getElementById(info[i].endId);
                            if (endElm) {
                                ranges[i].setEndAfter(endElm);
                            }
                        }
                    }
                }
                try {
                    sel.addRange(ranges[i].cloneRange());
                }
                catch (_a) { }
            }
        }
        return info;
    };
    Select.prototype.focus = function (options) {
        var _a, _b;
        if (options === void 0) { options = {
            preventScroll: true
        }; }
        if (!this.isFocused()) {
            if (this.j.iframe) {
                if (this.doc.readyState === 'complete') {
                    this.j.iframe.focus();
                }
            }
            this.win.focus();
            this.area.focus(options);
            var sel = this.sel, range = (sel === null || sel === void 0 ? void 0 : sel.rangeCount) ? sel === null || sel === void 0 ? void 0 : sel.getRangeAt(0) : null;
            if (!range || !dom_1.Dom.isOrContains(this.area, range.startContainer)) {
                var range_1 = this.createRange();
                range_1.setStart(this.area, 0);
                range_1.collapse(true);
                this.selectRange(range_1, false);
            }
            if (!this.j.editorIsActive) {
                (_b = (_a = this.j) === null || _a === void 0 ? void 0 : _a.events) === null || _b === void 0 ? void 0 : _b.fire('focus');
            }
            return true;
        }
        return false;
    };
    Select.prototype.isCollapsed = function () {
        var sel = this.sel;
        for (var r = 0; sel && r < sel.rangeCount; r += 1) {
            if (!sel.getRangeAt(r).collapsed) {
                return false;
            }
        }
        return true;
    };
    Select.prototype.isFocused = function () {
        return (this.doc.hasFocus &&
            this.doc.hasFocus() &&
            this.area === this.doc.activeElement);
    };
    Select.prototype.current = function (checkChild) {
        if (checkChild === void 0) { checkChild = true; }
        if (this.j.getRealMode() === consts.MODE_WYSIWYG) {
            var sel = this.sel;
            if (!sel || sel.rangeCount === 0) {
                return null;
            }
            var range = sel.getRangeAt(0);
            var node = range.startContainer, rightMode_1 = false;
            var child = function (nd) {
                return rightMode_1 ? nd.lastChild : nd.firstChild;
            };
            if (dom_1.Dom.isTag(node, 'br') && sel.isCollapsed) {
                return node;
            }
            if (!dom_1.Dom.isText(node)) {
                node = range.startContainer.childNodes[range.startOffset];
                if (!node) {
                    node =
                        range.startContainer.childNodes[range.startOffset - 1];
                    rightMode_1 = true;
                }
                if (node && sel.isCollapsed && !dom_1.Dom.isText(node)) {
                    if (!rightMode_1 && dom_1.Dom.isText(node.previousSibling)) {
                        node = node.previousSibling;
                    }
                    else if (checkChild) {
                        var current = child(node);
                        while (current) {
                            if (current && dom_1.Dom.isText(current)) {
                                node = current;
                                break;
                            }
                            current = child(current);
                        }
                    }
                }
                if (node && !sel.isCollapsed && !dom_1.Dom.isText(node)) {
                    var leftChild = node, rightChild = node;
                    do {
                        leftChild = leftChild.firstChild;
                        rightChild = rightChild.lastChild;
                    } while (leftChild && rightChild && !dom_1.Dom.isText(leftChild));
                    if (leftChild === rightChild &&
                        leftChild &&
                        dom_1.Dom.isText(leftChild)) {
                        node = leftChild;
                    }
                }
            }
            if (node && dom_1.Dom.isOrContains(this.area, node)) {
                return node;
            }
        }
        return null;
    };
    Select.prototype.insertNode = function (node, insertCursorAfter, fireChange) {
        var _a;
        if (insertCursorAfter === void 0) { insertCursorAfter = true; }
        if (fireChange === void 0) { fireChange = true; }
        this.errorNode(node);
        if (!this.isFocused() && this.j.isEditorMode()) {
            this.focus();
            this.restore();
        }
        var sel = this.sel;
        if (!this.isCollapsed()) {
            this.j.execCommand('Delete');
        }
        if (sel && sel.rangeCount) {
            var range = sel.getRangeAt(0);
            if (dom_1.Dom.isOrContains(this.area, range.commonAncestorContainer)) {
                if (dom_1.Dom.isTag(range.startContainer, constants_1.INSEPARABLE_TAGS) &&
                    range.collapsed) {
                    (_a = range.startContainer.parentNode) === null || _a === void 0 ? void 0 : _a.insertBefore(node, range.startContainer);
                }
                else {
                    range.deleteContents();
                    range.insertNode(node);
                }
            }
            else {
                this.area.appendChild(node);
            }
        }
        else {
            this.area.appendChild(node);
        }
        if (insertCursorAfter) {
            if (node.nodeType === Node.DOCUMENT_FRAGMENT_NODE) {
                node.lastChild && this.setCursorAfter(node.lastChild);
            }
            else {
                this.setCursorAfter(node);
            }
        }
        if (fireChange && this.j.events) {
            this.j.e.fire('synchro');
        }
        if (this.j.events) {
            this.j.e.fire('afterInsertNode', node);
        }
    };
    Select.prototype.insertHTML = function (html) {
        if (html === '') {
            return;
        }
        var node = this.j.createInside.div(), fragment = this.j.createInside.fragment();
        var lastChild;
        if (!this.isFocused() && this.j.isEditorMode()) {
            this.focus();
            this.restore();
        }
        if (!dom_1.Dom.isNode(html, this.win)) {
            node.innerHTML = html.toString();
        }
        else {
            node.appendChild(html);
        }
        if (!this.j.isEditorMode() &&
            this.j.e.fire('insertHTML', node.innerHTML) === false) {
            return;
        }
        lastChild = node.lastChild;
        if (!lastChild) {
            return;
        }
        while (node.firstChild) {
            lastChild = node.firstChild;
            fragment.appendChild(node.firstChild);
        }
        this.insertNode(fragment, false, false);
        if (lastChild) {
            this.setCursorAfter(lastChild);
        }
        else {
            this.setCursorIn(fragment);
        }
        if (this.j.e) {
            this.j.e.fire('synchro');
        }
    };
    Select.prototype.insertImage = function (url, styles, defaultWidth) {
        if (styles === void 0) { styles = null; }
        if (defaultWidth === void 0) { defaultWidth = null; }
        var image = helpers_1.isString(url) ? this.j.createInside.element('img') : url;
        if (helpers_1.isString(url)) {
            image.setAttribute('src', url);
        }
        if (defaultWidth != null) {
            var dw = defaultWidth.toString();
            if (dw &&
                'auto' !== dw &&
                String(dw).indexOf('px') < 0 &&
                String(dw).indexOf('%') < 0) {
                dw += 'px';
            }
            helpers_1.css(image, 'width', dw);
        }
        if (styles && typeof styles === 'object') {
            helpers_1.css(image, styles);
        }
        var onload = function () {
            if (image.naturalHeight < image.offsetHeight ||
                image.naturalWidth < image.offsetWidth) {
                image.style.width = '';
                image.style.height = '';
            }
            image.removeEventListener('load', onload);
        };
        this.j.e.on(image, 'load', onload);
        if (image.complete) {
            onload();
        }
        this.insertNode(image);
        this.j.e.fire('afterInsertImage', image);
    };
    Select.prototype.cursorInTheEdge = function (start, parentBlock) {
        var _a, _b;
        var end = !start, range = (_a = this.sel) === null || _a === void 0 ? void 0 : _a.getRangeAt(0), current = this.current(false);
        if (!range ||
            !current ||
            !dom_1.Dom.isOrContains(parentBlock, current, true)) {
            return null;
        }
        var container = start ? range.startContainer : range.endContainer;
        var offset = start ? range.startOffset : range.endOffset;
        var check = function (elm) {
            return elm && !dom_1.Dom.isTag(elm, 'br') && !dom_1.Dom.isEmptyTextNode(elm);
        };
        if (dom_1.Dom.isText(container)) {
            var text = ((_b = container.nodeValue) === null || _b === void 0 ? void 0 : _b.length) ? container.nodeValue : '';
            if (end && text.replace(constants_1.INVISIBLE_SPACE_REG_EXP_END(), '').length > offset) {
                return false;
            }
            var inv = constants_1.INVISIBLE_SPACE_REG_EXP_START().exec(text);
            if (start &&
                ((inv && inv[0].length < offset) || (!inv && offset > 0))) {
                return false;
            }
        }
        else {
            var children = helpers_1.toArray(container.childNodes);
            if (end) {
                if (children.slice(offset).some(check)) {
                    return false;
                }
            }
            else {
                if (children.slice(0, offset).some(check)) {
                    return false;
                }
            }
        }
        return !helpers_1.call(start ? dom_1.Dom.prev : dom_1.Dom.next, current, check, parentBlock);
    };
    Select.prototype.cursorOnTheLeft = function (parentBlock) {
        return this.cursorInTheEdge(true, parentBlock);
    };
    Select.prototype.cursorOnTheRight = function (parentBlock) {
        return this.cursorInTheEdge(false, parentBlock);
    };
    Select.prototype.setCursorAfter = function (node) {
        return this.setCursorNearWith(node, false);
    };
    Select.prototype.setCursorBefore = function (node) {
        return this.setCursorNearWith(node, true);
    };
    Select.prototype.setCursorNearWith = function (node, inStart) {
        var _this = this;
        var _a, _b;
        this.errorNode(node);
        if (!dom_1.Dom.up(node, function (elm) {
            return elm === _this.area || (elm && elm.parentNode === _this.area);
        }, this.area)) {
            throw helpers_1.error('Node element must be in editor');
        }
        var range = this.createRange();
        var fakeNode = null;
        if (!dom_1.Dom.isText(node)) {
            fakeNode = this.j.createInside.text(consts.INVISIBLE_SPACE);
            inStart ? range.setStartBefore(node) : range.setEndAfter(node);
            range.collapse(inStart);
            range.insertNode(fakeNode);
            range.selectNode(fakeNode);
        }
        else {
            if (inStart) {
                range.setStart(node, 0);
            }
            else {
                range.setEnd(node, (_b = (_a = node.nodeValue) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0);
            }
        }
        range.collapse(inStart);
        this.selectRange(range);
        return fakeNode;
    };
    Select.prototype.setCursorIn = function (node, inStart) {
        var _this = this;
        if (inStart === void 0) { inStart = false; }
        this.errorNode(node);
        if (!dom_1.Dom.up(node, function (elm) {
            return elm === _this.area || (elm && elm.parentNode === _this.area);
        }, this.area)) {
            throw helpers_1.error('Node element must be in editor');
        }
        var range = this.createRange();
        var start = node, last = node;
        do {
            if (dom_1.Dom.isText(start)) {
                break;
            }
            last = start;
            start = inStart ? start.firstChild : start.lastChild;
        } while (start);
        if (!start) {
            var fakeNode = this.j.createInside.text(consts.INVISIBLE_SPACE);
            if (!/^(img|br|input)$/i.test(last.nodeName)) {
                last.appendChild(fakeNode);
                last = fakeNode;
            }
            else {
                start = last;
            }
        }
        range.selectNodeContents(start || last);
        range.collapse(inStart);
        this.selectRange(range);
        return last;
    };
    Select.prototype.selectRange = function (range, focus) {
        if (focus === void 0) { focus = true; }
        var sel = this.sel;
        if (focus && !this.isFocused()) {
            this.focus();
        }
        if (sel) {
            sel.removeAllRanges();
            sel.addRange(range);
        }
        this.j.e.fire('changeSelection');
    };
    Select.prototype.select = function (node, inward) {
        var _this = this;
        if (inward === void 0) { inward = false; }
        this.errorNode(node);
        if (!dom_1.Dom.up(node, function (elm) {
            return elm === _this.area || (elm && elm.parentNode === _this.area);
        }, this.area)) {
            throw helpers_1.error('Node element must be in editor');
        }
        var range = this.createRange();
        range[inward ? 'selectNodeContents' : 'selectNode'](node);
        this.selectRange(range);
    };
    Object.defineProperty(Select.prototype, "html", {
        get: function () {
            var sel = this.sel;
            if (sel && sel.rangeCount > 0) {
                var range = sel.getRangeAt(0);
                var clonedSelection = range.cloneContents();
                var div = this.j.createInside.div();
                div.appendChild(clonedSelection);
                return div.innerHTML;
            }
            return '';
        },
        enumerable: false,
        configurable: true
    });
    Select.prototype.wrapInTag = function (tagOrCallback) {
        var _this = this;
        helpers_1.$$('*[style*=font-size]', this.area).forEach(function (elm) {
            elm.style &&
                elm.style.fontSize &&
                elm.setAttribute('data-font-size', elm.style.fontSize.toString());
        });
        if (!this.isCollapsed()) {
            this.j.nativeExecCommand('fontsize', false, '7');
        }
        else {
            var font = this.j.createInside.element('font');
            helpers_1.attr(font, 'size', 7);
            this.insertNode(font, false, false);
        }
        helpers_1.$$('*[data-font-size]', this.area).forEach(function (elm) {
            var fontSize = helpers_1.attr(elm, 'data-font-size');
            if (elm.style && fontSize) {
                elm.style.fontSize = fontSize;
                elm.removeAttribute('data-font-size');
            }
        });
        var result = [];
        helpers_1.$$('font[size="7"]', this.area).forEach(function (font) {
            try {
                if (font.firstChild &&
                    font.firstChild === font.lastChild &&
                    _this.isMarker(font.firstChild)) {
                    return;
                }
                if (helpers_1.isFunction(tagOrCallback)) {
                    tagOrCallback(font);
                }
                else {
                    result.push(dom_1.Dom.replace(font, tagOrCallback, _this.j.createInside));
                }
            }
            finally {
                var pn = font.parentNode;
                if (pn) {
                    dom_1.Dom.unwrap(font);
                    if (dom_1.Dom.isEmpty(pn)) {
                        dom_1.Dom.unwrap(pn);
                    }
                }
            }
        });
        return result;
    };
    Select.prototype.applyStyle = function (style, options) {
        if (options === void 0) { options = {}; }
        var styleElm = new style_1.Style({
            style: style,
            element: options.element,
            className: options.className,
            defaultTag: options.defaultTag
        });
        styleElm.apply(this.j);
    };
    Select.prototype.splitSelection = function (currentBox) {
        if (!this.isCollapsed()) {
            return null;
        }
        var leftRange = this.createRange();
        var range = this.range;
        leftRange.setStartBefore(currentBox);
        var cursorOnTheRight = this.cursorOnTheRight(currentBox);
        var cursorOnTheLeft = this.cursorOnTheLeft(currentBox);
        var br = this.j.createInside.element('br'), prevFake = this.j.createInside.text(constants_1.INVISIBLE_SPACE), nextFake = prevFake.cloneNode();
        try {
            if (cursorOnTheRight || cursorOnTheLeft) {
                range.insertNode(br);
                var clearBR = function (start, getNext) {
                    var next = getNext(start);
                    while (next) {
                        var nextSib = getNext(next);
                        if (next &&
                            (dom_1.Dom.isTag(next, 'br') || dom_1.Dom.isEmptyTextNode(next))) {
                            dom_1.Dom.safeRemove(next);
                        }
                        else {
                            break;
                        }
                        next = nextSib;
                    }
                };
                clearBR(br, function (n) { return n.nextSibling; });
                clearBR(br, function (n) { return n.previousSibling; });
                dom_1.Dom.after(br, nextFake);
                dom_1.Dom.before(br, prevFake);
                if (cursorOnTheRight) {
                    leftRange.setEndBefore(br);
                    range.setEndBefore(br);
                }
                else {
                    leftRange.setEndAfter(br);
                    range.setEndAfter(br);
                }
            }
            else {
                leftRange.setEnd(range.startContainer, range.startOffset);
            }
            var fragment = leftRange.extractContents();
            if (currentBox.parentNode) {
                try {
                    currentBox.parentNode.insertBefore(fragment, currentBox);
                    if (cursorOnTheRight && (br === null || br === void 0 ? void 0 : br.parentNode)) {
                        var range_2 = this.createRange();
                        range_2.setStartBefore(br);
                        this.selectRange(range_2);
                    }
                }
                catch (e) {
                    if (false) {}
                }
            }
            var fillFakeParent = function (fake) {
                var _a, _b, _c;
                if (((_a = fake === null || fake === void 0 ? void 0 : fake.parentNode) === null || _a === void 0 ? void 0 : _a.firstChild) === ((_b = fake === null || fake === void 0 ? void 0 : fake.parentNode) === null || _b === void 0 ? void 0 : _b.lastChild)) {
                    (_c = fake === null || fake === void 0 ? void 0 : fake.parentNode) === null || _c === void 0 ? void 0 : _c.appendChild(br.cloneNode());
                }
            };
            fillFakeParent(prevFake);
            fillFakeParent(nextFake);
        }
        finally {
            dom_1.Dom.safeRemove(prevFake);
            dom_1.Dom.safeRemove(nextFake);
        }
        return currentBox.previousElementSibling;
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], Select.prototype, "focus", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], Select.prototype, "setCursorAfter", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], Select.prototype, "setCursorBefore", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], Select.prototype, "setCursorIn", null);
    return Select;
}());
exports.Select = Select;


/***/ }),
/* 208 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StatusBar = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(209);
var component_1 = __webpack_require__(27);
var dom_1 = __webpack_require__(32);
var StatusBar = (function (_super) {
    tslib_1.__extends(StatusBar, _super);
    function StatusBar(jodit, target) {
        var _this = _super.call(this, jodit) || this;
        _this.target = target;
        _this.container = jodit.c.div('jodit-status-bar');
        target.appendChild(_this.container);
        _this.hide();
        return _this;
    }
    StatusBar.prototype.className = function () {
        return 'StatusBar';
    };
    StatusBar.prototype.hide = function () {
        this.container.classList.add('jodit_hidden');
    };
    StatusBar.prototype.show = function () {
        this.container.classList.remove('jodit_hidden');
    };
    Object.defineProperty(StatusBar.prototype, "isShown", {
        get: function () {
            return !this.container.classList.contains('jodit_hidden');
        },
        enumerable: false,
        configurable: true
    });
    StatusBar.prototype.getHeight = function () {
        var _a, _b;
        return (_b = (_a = this.container) === null || _a === void 0 ? void 0 : _a.offsetHeight) !== null && _b !== void 0 ? _b : 0;
    };
    StatusBar.prototype.findEmpty = function (inTheRight) {
        var _a;
        if (inTheRight === void 0) { inTheRight = false; }
        var items = (_a = this.container) === null || _a === void 0 ? void 0 : _a.querySelectorAll('.jodit-status-bar__item' +
            (inTheRight ? '.jodit-status-bar__item-right' : ''));
        if (items) {
            for (var i = 0; i < items.length; i += 1) {
                if (!items[i].innerHTML.trim().length) {
                    return items[i];
                }
            }
        }
    };
    StatusBar.prototype.append = function (child, inTheRight) {
        var _a;
        if (inTheRight === void 0) { inTheRight = false; }
        var wrapper = this.findEmpty(inTheRight) ||
            this.j.c.div('jodit-status-bar__item');
        if (inTheRight) {
            wrapper.classList.add('jodit-status-bar__item-right');
        }
        wrapper.appendChild(child);
        (_a = this.container) === null || _a === void 0 ? void 0 : _a.appendChild(wrapper);
        if (this.j.o.statusbar) {
            this.show();
        }
        this.j.e.fire('resize');
    };
    StatusBar.prototype.destruct = function () {
        this.setStatus(component_1.STATUSES.beforeDestruct);
        dom_1.Dom.safeRemove(this.container);
        _super.prototype.destruct.call(this);
    };
    return StatusBar;
}(component_1.ViewComponent));
exports.StatusBar = StatusBar;


/***/ }),
/* 209 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 210 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Table = void 0;
var tslib_1 = __webpack_require__(7);
var consts = __webpack_require__(9);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var component_1 = __webpack_require__(27);
var global_1 = __webpack_require__(30);
var decorators_1 = __webpack_require__(99);
var Table = (function (_super) {
    tslib_1.__extends(Table, _super);
    function Table() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.selected = new Set();
        return _this;
    }
    Table.prototype.className = function () {
        return 'Table';
    };
    Table.prototype.recalculateStyles = function () {
        var style = global_1.getContainer(this.j, Table, 'style', true);
        var selectors = [];
        this.selected.forEach(function (td) {
            var selector = helpers_1.cssPath(td);
            selector && selectors.push(selector);
        });
        style.innerHTML = selectors.length
            ? selectors.join(',') +
                ("{" + this.jodit.options.table.selectionCellStyle + "}")
            : '';
    };
    Table.prototype.addSelection = function (td) {
        this.selected.add(td);
        this.recalculateStyles();
        var table = dom_1.Dom.closest(td, 'table', this.j.editor);
        if (table) {
            var cells = Table.selectedByTable.get(table) || new Set();
            cells.add(td);
            Table.selectedByTable.set(table, cells);
        }
    };
    Table.prototype.removeSelection = function (td) {
        this.selected.delete(td);
        this.recalculateStyles();
        var table = dom_1.Dom.closest(td, 'table', this.j.editor);
        if (table) {
            var cells = Table.selectedByTable.get(table);
            if (cells) {
                cells.delete(td);
                if (!cells.size) {
                    Table.selectedByTable.delete(table);
                }
            }
        }
    };
    Table.prototype.getAllSelectedCells = function () {
        return helpers_1.toArray(this.selected);
    };
    Table.getSelectedCellsByTable = function (table) {
        var cells = Table.selectedByTable.get(table);
        return cells ? helpers_1.toArray(cells) : [];
    };
    Table.prototype.destruct = function () {
        this.selected.clear();
        return _super.prototype.destruct.call(this);
    };
    Table.getRowsCount = function (table) {
        return table.rows.length;
    };
    Table.getColumnsCount = function (table) {
        var matrix = Table.formalMatrix(table);
        return matrix.reduce(function (max_count, cells) {
            return Math.max(max_count, cells.length);
        }, 0);
    };
    Table.formalMatrix = function (table, callback) {
        var matrix = [[]];
        var rows = helpers_1.toArray(table.rows);
        var setCell = function (cell, i) {
            if (matrix[i] === undefined) {
                matrix[i] = [];
            }
            var colSpan = cell.colSpan, rowSpan = cell.rowSpan;
            var column, row, currentColumn = 0;
            while (matrix[i][currentColumn]) {
                currentColumn += 1;
            }
            for (row = 0; row < rowSpan; row += 1) {
                for (column = 0; column < colSpan; column += 1) {
                    if (matrix[i + row] === undefined) {
                        matrix[i + row] = [];
                    }
                    if (callback &&
                        callback(cell, i + row, currentColumn + column, colSpan, rowSpan) === false) {
                        return false;
                    }
                    matrix[i + row][currentColumn + column] = cell;
                }
            }
        };
        for (var i = 0; i < rows.length; i += 1) {
            var cells = helpers_1.toArray(rows[i].cells);
            for (var j = 0; j < cells.length; j += 1) {
                if (setCell(cells[j], i) === false) {
                    return matrix;
                }
            }
        }
        return matrix;
    };
    Table.formalCoordinate = function (table, cell, max) {
        if (max === void 0) { max = false; }
        var i = 0, j = 0, width = 1, height = 1;
        Table.formalMatrix(table, function (td, ii, jj, colSpan, rowSpan) {
            if (cell === td) {
                i = ii;
                j = jj;
                width = colSpan || 1;
                height = rowSpan || 1;
                if (max) {
                    j += (colSpan || 1) - 1;
                    i += (rowSpan || 1) - 1;
                }
                return false;
            }
        });
        return [i, j, width, height];
    };
    Table.appendRow = function (table, line, after, create) {
        var row;
        if (!line) {
            var columnsCount = Table.getColumnsCount(table);
            row = create.element('tr');
            for (var j = 0; j < columnsCount; j += 1) {
                row.appendChild(create.element('td'));
            }
        }
        else {
            row = line.cloneNode(true);
            helpers_1.$$('td,th', line).forEach(function (cell) {
                var rowspan = helpers_1.attr(cell, 'rowspan');
                if (rowspan && parseInt(rowspan, 10) > 1) {
                    var newRowSpan = parseInt(rowspan, 10) - 1;
                    helpers_1.attr(cell, 'rowspan', newRowSpan > 1 ? newRowSpan : null);
                }
            });
            helpers_1.$$('td,th', row).forEach(function (cell) {
                cell.innerHTML = '';
            });
        }
        if (after && line && line.nextSibling) {
            line.parentNode &&
                line.parentNode.insertBefore(row, line.nextSibling);
        }
        else if (!after && line) {
            line.parentNode && line.parentNode.insertBefore(row, line);
        }
        else {
            (helpers_1.$$(':scope>tbody', table)[0] || table).appendChild(row);
        }
    };
    Table.removeRow = function (table, rowIndex) {
        var box = Table.formalMatrix(table);
        var dec;
        var row = table.rows[rowIndex];
        helpers_1.each(box[rowIndex], function (j, cell) {
            dec = false;
            if (rowIndex - 1 >= 0 && box[rowIndex - 1][j] === cell) {
                dec = true;
            }
            else if (box[rowIndex + 1] && box[rowIndex + 1][j] === cell) {
                if (cell.parentNode === row &&
                    cell.parentNode.nextSibling) {
                    dec = true;
                    var nextCell = j + 1;
                    while (box[rowIndex + 1][nextCell] === cell) {
                        nextCell += 1;
                    }
                    var nextRow = dom_1.Dom.next(cell.parentNode, function (elm) { return dom_1.Dom.isTag(elm, 'tr'); }, table);
                    if (box[rowIndex + 1][nextCell]) {
                        nextRow.insertBefore(cell, box[rowIndex + 1][nextCell]);
                    }
                    else {
                        nextRow.appendChild(cell);
                    }
                }
            }
            else {
                dom_1.Dom.safeRemove(cell);
            }
            if (dec &&
                (cell.parentNode === row || cell !== box[rowIndex][j - 1])) {
                var rowSpan = cell.rowSpan;
                helpers_1.attr(cell, 'rowspan', rowSpan - 1 > 1 ? (rowSpan - 1).toString() : null);
            }
        });
        dom_1.Dom.safeRemove(row);
    };
    Table.appendColumn = function (table, j, after, create) {
        var box = Table.formalMatrix(table);
        var i;
        if (j === undefined || j < 0) {
            j = Table.getColumnsCount(table) - 1;
        }
        for (i = 0; i < box.length; i += 1) {
            var cell = create.element('td');
            var td = box[i][j];
            var added = false;
            if (after) {
                if ((box[i] && td && j + 1 >= box[i].length) ||
                    td !== box[i][j + 1]) {
                    if (td.nextSibling) {
                        td.parentNode &&
                            td.parentNode.insertBefore(cell, td.nextSibling);
                    }
                    else {
                        td.parentNode && td.parentNode.appendChild(cell);
                    }
                    added = true;
                }
            }
            else {
                if (j - 1 < 0 ||
                    (box[i][j] !== box[i][j - 1] && box[i][j].parentNode)) {
                    td.parentNode &&
                        td.parentNode.insertBefore(cell, box[i][j]);
                    added = true;
                }
            }
            if (!added) {
                box[i][j].setAttribute('colspan', (parseInt(helpers_1.attr(box[i][j], 'colspan') || '1', 10) + 1).toString());
            }
        }
    };
    Table.removeColumn = function (table, j) {
        var box = Table.formalMatrix(table);
        var dec;
        helpers_1.each(box, function (i, cells) {
            var td = cells[j];
            dec = false;
            if (j - 1 >= 0 && box[i][j - 1] === td) {
                dec = true;
            }
            else if (j + 1 < cells.length && box[i][j + 1] === td) {
                dec = true;
            }
            else {
                dom_1.Dom.safeRemove(td);
            }
            if (dec && (i - 1 < 0 || td !== box[i - 1][j])) {
                var colSpan = td.colSpan;
                helpers_1.attr(td, 'colspan', colSpan - 1 > 1 ? (colSpan - 1).toString() : null);
            }
        });
    };
    Table.getSelectedBound = function (table, selectedCells) {
        var bound = [
            [Infinity, Infinity],
            [0, 0]
        ];
        var box = Table.formalMatrix(table);
        var i, j, k;
        for (i = 0; i < box.length; i += 1) {
            for (j = 0; box[i] && j < box[i].length; j += 1) {
                if (selectedCells.includes(box[i][j])) {
                    bound[0][0] = Math.min(i, bound[0][0]);
                    bound[0][1] = Math.min(j, bound[0][1]);
                    bound[1][0] = Math.max(i, bound[1][0]);
                    bound[1][1] = Math.max(j, bound[1][1]);
                }
            }
        }
        for (i = bound[0][0]; i <= bound[1][0]; i += 1) {
            for (k = 1, j = bound[0][1]; j <= bound[1][1]; j += 1) {
                while (box[i] && box[i][j - k] && box[i][j] === box[i][j - k]) {
                    bound[0][1] = Math.min(j - k, bound[0][1]);
                    bound[1][1] = Math.max(j - k, bound[1][1]);
                    k += 1;
                }
                k = 1;
                while (box[i] && box[i][j + k] && box[i][j] === box[i][j + k]) {
                    bound[0][1] = Math.min(j + k, bound[0][1]);
                    bound[1][1] = Math.max(j + k, bound[1][1]);
                    k += 1;
                }
                k = 1;
                while (box[i - k] && box[i][j] === box[i - k][j]) {
                    bound[0][0] = Math.min(i - k, bound[0][0]);
                    bound[1][0] = Math.max(i - k, bound[1][0]);
                    k += 1;
                }
                k = 1;
                while (box[i + k] && box[i][j] === box[i + k][j]) {
                    bound[0][0] = Math.min(i + k, bound[0][0]);
                    bound[1][0] = Math.max(i + k, bound[1][0]);
                    k += 1;
                }
            }
        }
        return bound;
    };
    Table.normalizeTable = function (table) {
        var i, j, min, not;
        var __marked = [], box = Table.formalMatrix(table);
        for (j = 0; j < box[0].length; j += 1) {
            min = 1000000;
            not = false;
            for (i = 0; i < box.length; i += 1) {
                if (box[i][j] === undefined) {
                    continue;
                }
                if (box[i][j].colSpan < 2) {
                    not = true;
                    break;
                }
                min = Math.min(min, box[i][j].colSpan);
            }
            if (!not) {
                for (i = 0; i < box.length; i += 1) {
                    if (box[i][j] === undefined) {
                        continue;
                    }
                    Table.__mark(box[i][j], 'colspan', box[i][j].colSpan - min + 1, __marked);
                }
            }
        }
        for (i = 0; i < box.length; i += 1) {
            min = 1000000;
            not = false;
            for (j = 0; j < box[i].length; j += 1) {
                if (box[i][j] === undefined) {
                    continue;
                }
                if (box[i][j].rowSpan < 2) {
                    not = true;
                    break;
                }
                min = Math.min(min, box[i][j].rowSpan);
            }
            if (!not) {
                for (j = 0; j < box[i].length; j += 1) {
                    if (box[i][j] === undefined) {
                        continue;
                    }
                    Table.__mark(box[i][j], 'rowspan', box[i][j].rowSpan - min + 1, __marked);
                }
            }
        }
        for (i = 0; i < box.length; i += 1) {
            for (j = 0; j < box[i].length; j += 1) {
                if (box[i][j] === undefined) {
                    continue;
                }
                if (box[i][j].hasAttribute('rowspan') &&
                    box[i][j].rowSpan === 1) {
                    box[i][j].removeAttribute('rowspan');
                }
                if (box[i][j].hasAttribute('colspan') &&
                    box[i][j].colSpan === 1) {
                    box[i][j].removeAttribute('colspan');
                }
                if (box[i][j].hasAttribute('class') &&
                    !helpers_1.attr(box[i][j], 'class')) {
                    box[i][j].removeAttribute('class');
                }
            }
        }
        Table.__unmark(__marked);
    };
    Table.mergeSelected = function (table, jodit) {
        var html = [], bound = Table.getSelectedBound(table, Table.getSelectedCellsByTable(table));
        var w = 0, first = null, first_j = 0, td, cols = 0, rows = 0;
        var __marked = [];
        if (bound && (bound[0][0] - bound[1][0] || bound[0][1] - bound[1][1])) {
            Table.formalMatrix(table, function (cell, i, j, cs, rs) {
                if (i >= bound[0][0] && i <= bound[1][0]) {
                    if (j >= bound[0][1] && j <= bound[1][1]) {
                        td = cell;
                        if (td.__i_am_already_was) {
                            return;
                        }
                        td.__i_am_already_was = true;
                        if (i === bound[0][0] && td.style.width) {
                            w += td.offsetWidth;
                        }
                        if (helpers_1.trim(cell.innerHTML.replace(/<br(\/)?>/g, '')) !== '') {
                            html.push(cell.innerHTML);
                        }
                        if (cs > 1) {
                            cols += cs - 1;
                        }
                        if (rs > 1) {
                            rows += rs - 1;
                        }
                        if (!first) {
                            first = cell;
                            first_j = j;
                        }
                        else {
                            Table.__mark(td, 'remove', 1, __marked);
                            instance(jodit).removeSelection(td);
                        }
                    }
                }
            });
            cols = bound[1][1] - bound[0][1] + 1;
            rows = bound[1][0] - bound[0][0] + 1;
            if (first) {
                if (cols > 1) {
                    Table.__mark(first, 'colspan', cols, __marked);
                }
                if (rows > 1) {
                    Table.__mark(first, 'rowspan', rows, __marked);
                }
                if (w) {
                    Table.__mark(first, 'width', ((w / table.offsetWidth) * 100).toFixed(consts.ACCURACY) + '%', __marked);
                    if (first_j) {
                        Table.setColumnWidthByDelta(table, first_j, 0, true, __marked);
                    }
                }
                first.innerHTML = html.join('<br/>');
                instance(jodit).addSelection(first);
                delete first.__i_am_already_was;
                Table.__unmark(__marked);
                Table.normalizeTable(table);
                helpers_1.each(helpers_1.toArray(table.rows), function (index, tr) {
                    if (!tr.cells.length) {
                        dom_1.Dom.safeRemove(tr);
                    }
                });
            }
        }
    };
    Table.splitHorizontal = function (table, jodit) {
        var coord, td, tr, parent, after;
        var __marked = [];
        Table.getSelectedCellsByTable(table).forEach(function (cell) {
            td = jodit.createInside.element('td');
            td.appendChild(jodit.createInside.element('br'));
            tr = jodit.createInside.element('tr');
            coord = Table.formalCoordinate(table, cell);
            if (cell.rowSpan < 2) {
                Table.formalMatrix(table, function (tdElm, i, j) {
                    if (coord[0] === i &&
                        coord[1] !== j &&
                        tdElm !== cell) {
                        Table.__mark(tdElm, 'rowspan', tdElm.rowSpan + 1, __marked);
                    }
                });
                dom_1.Dom.after(dom_1.Dom.closest(cell, 'tr', table), tr);
                tr.appendChild(td);
            }
            else {
                Table.__mark(cell, 'rowspan', cell.rowSpan - 1, __marked);
                Table.formalMatrix(table, function (tdElm, i, j) {
                    if (i > coord[0] &&
                        i < coord[0] + cell.rowSpan &&
                        coord[1] > j &&
                        tdElm.parentNode
                            .rowIndex === i) {
                        after = tdElm;
                    }
                    if (coord[0] < i && tdElm === cell) {
                        parent = table.rows[i];
                    }
                });
                if (after) {
                    dom_1.Dom.after(after, td);
                }
                else {
                    parent.insertBefore(td, parent.firstChild);
                }
            }
            if (cell.colSpan > 1) {
                Table.__mark(td, 'colspan', cell.colSpan, __marked);
            }
            Table.__unmark(__marked);
            instance(jodit).removeSelection(cell);
        });
        this.normalizeTable(table);
    };
    Table.splitVertical = function (table, jodit) {
        var coord, td, percentage;
        var __marked = [];
        Table.getSelectedCellsByTable(table).forEach(function (cell) {
            coord = Table.formalCoordinate(table, cell);
            if (cell.colSpan < 2) {
                Table.formalMatrix(table, function (tdElm, i, j) {
                    if (coord[1] === j &&
                        coord[0] !== i &&
                        tdElm !== cell) {
                        Table.__mark(tdElm, 'colspan', tdElm.colSpan + 1, __marked);
                    }
                });
            }
            else {
                Table.__mark(cell, 'colspan', cell.colSpan - 1, __marked);
            }
            td = jodit.createInside.element('td');
            td.appendChild(jodit.createInside.element('br'));
            if (cell.rowSpan > 1) {
                Table.__mark(td, 'rowspan', cell.rowSpan, __marked);
            }
            var oldWidth = cell.offsetWidth;
            dom_1.Dom.after(cell, td);
            percentage = oldWidth / table.offsetWidth / 2;
            Table.__mark(cell, 'width', (percentage * 100).toFixed(consts.ACCURACY) + '%', __marked);
            Table.__mark(td, 'width', (percentage * 100).toFixed(consts.ACCURACY) + '%', __marked);
            Table.__unmark(__marked);
            instance(jodit).removeSelection(cell);
        });
        Table.normalizeTable(table);
    };
    Table.setColumnWidthByDelta = function (table, j, delta, noUnmark, marked) {
        var box = Table.formalMatrix(table);
        var i, w, percent;
        for (i = 0; i < box.length; i += 1) {
            w = box[i][j].offsetWidth;
            percent = ((w + delta) / table.offsetWidth) * 100;
            Table.__mark(box[i][j], 'width', percent.toFixed(consts.ACCURACY) + '%', marked);
        }
        if (!noUnmark) {
            Table.__unmark(marked);
        }
    };
    Table.__mark = function (cell, key, value, marked) {
        marked.push(cell);
        if (!cell.__marked_value) {
            cell.__marked_value = {};
        }
        cell.__marked_value[key] = value === undefined ? 1 : value;
    };
    Table.__unmark = function (marked) {
        marked.forEach(function (cell) {
            if (cell.__marked_value) {
                helpers_1.each(cell.__marked_value, function (key, value) {
                    switch (key) {
                        case 'remove':
                            dom_1.Dom.safeRemove(cell);
                            break;
                        case 'rowspan':
                            if (value > 1) {
                                cell.setAttribute('rowspan', value.toString());
                            }
                            else {
                                cell.removeAttribute('rowspan');
                            }
                            break;
                        case 'colspan':
                            if (value > 1) {
                                cell.setAttribute('colspan', value.toString());
                            }
                            else {
                                cell.removeAttribute('colspan');
                            }
                            break;
                        case 'width':
                            cell.style.width = value.toString();
                            break;
                    }
                    delete cell.__marked_value[key];
                });
                delete cell.__marked_value;
            }
        });
    };
    Table.selectedByTable = new WeakMap();
    tslib_1.__decorate([
        decorators_1.debounce()
    ], Table.prototype, "recalculateStyles", null);
    return Table;
}(component_1.ViewComponent));
exports.Table = Table;
var instance = function (j) { return j.getInstance('Table', j.o); };


/***/ }),
/* 211 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(177), exports);
tslib_1.__exportStar(__webpack_require__(179), exports);


/***/ }),
/* 212 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Uploader = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(213);
var config_1 = __webpack_require__(8);
var constants_1 = __webpack_require__(9);
var ajax_1 = __webpack_require__(160);
var helpers_1 = __webpack_require__(19);
var dom_1 = __webpack_require__(32);
var component_1 = __webpack_require__(27);
var global_1 = __webpack_require__(30);
config_1.Config.prototype.enableDragAndDropFileToEditor = true;
config_1.Config.prototype.uploader = {
    url: '',
    insertImageAsBase64URI: false,
    imagesExtensions: ['jpg', 'png', 'jpeg', 'gif'],
    headers: null,
    data: null,
    filesVariableName: function (i) {
        return "files[" + i + "]";
    },
    withCredentials: false,
    pathVariableName: 'path',
    format: 'json',
    method: 'POST',
    prepareData: function (formData) {
        return formData;
    },
    isSuccess: function (resp) {
        return resp.success;
    },
    getMessage: function (resp) {
        return resp.data.messages !== undefined && helpers_1.isArray(resp.data.messages)
            ? resp.data.messages.join(' ')
            : '';
    },
    process: function (resp) {
        return resp.data;
    },
    error: function (e) {
        this.j.e.fire('errorMessage', e.message, 'error', 4000);
    },
    defaultHandlerSuccess: function (resp) {
        var j = this.j || this;
        if (!helpers_1.isJoditObject(j)) {
            return;
        }
        if (resp.files && resp.files.length) {
            resp.files.forEach(function (filename, index) {
                var _a = resp.isImages && resp.isImages[index]
                    ? ['img', 'src']
                    : ['a', 'href'], tagName = _a[0], attr = _a[1];
                var elm = j.createInside.element(tagName);
                elm.setAttribute(attr, resp.baseurl + filename);
                if (tagName === 'a') {
                    elm.textContent = resp.baseurl + filename;
                }
                if (tagName === 'img') {
                    j.s.insertImage(elm, null, j.o.imageDefaultWidth);
                }
                else {
                    j.s.insertNode(elm);
                }
            });
        }
    },
    defaultHandlerError: function (e) {
        this.j.e.fire('errorMessage', e.message);
    },
    contentType: function (requestData) {
        return this.j.ow.FormData !== undefined &&
            typeof requestData !== 'string'
            ? false
            : 'application/x-www-form-urlencoded; charset=UTF-8';
    }
};
var Uploader = (function (_super) {
    tslib_1.__extends(Uploader, _super);
    function Uploader(editor, options) {
        var _this = _super.call(this, editor) || this;
        _this.path = '';
        _this.source = 'default';
        _this.ajaxInstances = [];
        _this.options = helpers_1.ConfigProto(options || {}, helpers_1.ConfigProto(config_1.Config.defaultOptions.uploader, helpers_1.isJoditObject(editor) ? editor.o.uploader : {}));
        return _this;
    }
    Uploader.prototype.className = function () {
        return 'Uploader';
    };
    Uploader.dataURItoBlob = function (dataURI) {
        var byteString = atob(dataURI.split(',')[1]), mimeString = dataURI
            .split(',')[0]
            .split(':')[1]
            .split(';')[0], ab = new ArrayBuffer(byteString.length), ia = new Uint8Array(ab);
        for (var i = 0; i < byteString.length; i += 1) {
            ia[i] = byteString.charCodeAt(i);
        }
        return new Blob([ia], { type: mimeString });
    };
    Object.defineProperty(Uploader.prototype, "o", {
        get: function () {
            return this.options;
        },
        enumerable: false,
        configurable: true
    });
    Uploader.prototype.buildData = function (data) {
        if (this.o.buildData && typeof this.o.buildData === 'function') {
            return this.o.buildData.call(this, data);
        }
        var FD = this.j.ow.FormData;
        if (FD !== undefined) {
            if (data instanceof FD) {
                return data;
            }
            if (helpers_1.isString(data)) {
                return data;
            }
            var newdata_1 = new FD();
            Object.keys(data).forEach(function (key) {
                newdata_1.append(key, data[key]);
            });
            return newdata_1;
        }
        return data;
    };
    Uploader.prototype.send = function (data, success) {
        var _this = this;
        var requestData = this.buildData(data), sendData = function (request) {
            var ajax = new ajax_1.Ajax(_this.j, {
                xhr: function () {
                    var xhr = new XMLHttpRequest();
                    if (_this.j.ow.FormData !== undefined &&
                        xhr.upload) {
                        _this.j.progressbar.show().progress(10);
                        xhr.upload.addEventListener('progress', function (evt) {
                            if (evt.lengthComputable) {
                                var percentComplete = evt.loaded / evt.total;
                                percentComplete *= 100;
                                console.log('progress', percentComplete);
                                _this.j.progressbar
                                    .show()
                                    .progress(percentComplete);
                                if (percentComplete >= 100) {
                                    _this.j.progressbar.hide();
                                }
                            }
                        }, false);
                    }
                    else {
                        _this.j.progressbar.hide();
                    }
                    return xhr;
                },
                method: _this.o.method || 'POST',
                data: request,
                url: helpers_1.isFunction(_this.o.url)
                    ? _this.o.url(request)
                    : _this.o.url,
                headers: _this.o.headers,
                queryBuild: _this.o.queryBuild,
                contentType: _this.o.contentType.call(_this, request),
                dataType: _this.o.format || 'json',
                withCredentials: _this.o.withCredentials || false
            });
            _this.ajaxInstances.push(ajax);
            var removeAjaxInstanceFromList = function () {
                var index = _this.ajaxInstances.indexOf(ajax);
                if (index !== -1) {
                    _this.ajaxInstances.splice(index, 1);
                }
            };
            return ajax
                .send()
                .then(function (resp) {
                removeAjaxInstanceFromList();
                success.call(_this, resp);
            })
                .catch(function (error) {
                removeAjaxInstanceFromList();
                _this.o.error.call(_this, error);
            });
        };
        if (requestData instanceof Promise) {
            return requestData.then(sendData).catch(function (error) {
                _this.o.error.call(_this, error);
            });
        }
        else {
            return sendData(requestData);
        }
    };
    Uploader.prototype.sendFiles = function (files, handlerSuccess, handlerError, process) {
        var _this = this;
        if (!files) {
            return Promise.reject(helpers_1.error('Need files'));
        }
        var uploader = this;
        var fileList = helpers_1.toArray(files);
        if (!fileList.length) {
            return Promise.reject(helpers_1.error('Need files'));
        }
        var promises = [];
        if (this.o.insertImageAsBase64URI) {
            var file_1, i = void 0;
            var _loop_1 = function () {
                file_1 = fileList[i];
                if (file_1 && file_1.type) {
                    var mime = file_1.type.match(/\/([a-z0-9]+)/i);
                    var extension = mime[1]
                        ? mime[1].toLowerCase()
                        : '';
                    if (this_1.o.imagesExtensions.includes(extension)) {
                        var reader_1 = new FileReader();
                        promises.push(new Promise(function (resolve, reject) {
                            reader_1.onerror = reject;
                            reader_1.onloadend = function () {
                                var resp = {
                                    baseurl: '',
                                    files: [reader_1.result],
                                    isImages: [true]
                                };
                                if (typeof (handlerSuccess ||
                                    uploader.options
                                        .defaultHandlerSuccess) === 'function') {
                                    (handlerSuccess ||
                                        uploader.options
                                            .defaultHandlerSuccess).call(uploader, resp);
                                }
                                resolve(resp);
                            };
                            reader_1.readAsDataURL(file_1);
                        }));
                        fileList[i] = null;
                    }
                }
            };
            var this_1 = this;
            for (i = 0; i < fileList.length; i += 1) {
                _loop_1();
            }
        }
        fileList = fileList.filter(function (a) { return a; });
        if (fileList.length) {
            var form_1 = new FormData();
            form_1.append(this.o.pathVariableName, uploader.path);
            form_1.append('source', uploader.source);
            var file = void 0;
            for (var i = 0; i < fileList.length; i += 1) {
                file = fileList[i];
                if (file) {
                    var mime = file.type.match(/\/([a-z0-9]+)/i);
                    var extension = mime && mime[1] ? mime[1].toLowerCase() : '';
                    var newName = fileList[i].name ||
                        Math.random().toString().replace('.', '');
                    if (extension) {
                        var extForReg = extension;
                        if (['jpeg', 'jpg'].includes(extForReg)) {
                            extForReg = 'jpeg|jpg';
                        }
                        var reEnd = new RegExp('.(' + extForReg + ')$', 'i');
                        if (!reEnd.test(newName)) {
                            newName += '.' + extension;
                        }
                    }
                    form_1.append(this.o.filesVariableName(i), fileList[i], newName);
                }
            }
            if (process) {
                process(form_1);
            }
            if (uploader.o.data && helpers_1.isPlainObject(uploader.o.data)) {
                Object.keys(uploader.o.data).forEach(function (key) {
                    form_1.append(key, uploader.o.data[key]);
                });
            }
            uploader.o.prepareData.call(this, form_1);
            promises.push(uploader
                .send(form_1, function (resp) {
                if (_this.o.isSuccess.call(uploader, resp)) {
                    if (typeof (handlerSuccess ||
                        uploader.o.defaultHandlerSuccess) === 'function') {
                        (handlerSuccess ||
                            uploader.options
                                .defaultHandlerSuccess).call(uploader, uploader.o.process.call(uploader, resp));
                    }
                }
                else {
                    if (helpers_1.isFunction(handlerError ||
                        uploader.o.defaultHandlerError)) {
                        (handlerError ||
                            uploader.options
                                .defaultHandlerError).call(uploader, helpers_1.error(uploader.o.getMessage.call(uploader, resp)));
                        return;
                    }
                }
            })
                .then(function () {
                _this.j.events && _this.j.e.fire('filesWereUploaded');
            }));
        }
        return Promise.all(promises);
    };
    Uploader.prototype.setPath = function (path) {
        this.path = path;
    };
    Uploader.prototype.setSource = function (source) {
        this.source = source;
    };
    Uploader.prototype.bind = function (form, handlerSuccess, handlerError) {
        var _this = this;
        var self = this, onPaste = function (e) {
            var i, file, extension;
            var cData = e.clipboardData;
            var process = function (formdata) {
                if (file) {
                    formdata.append('extension', extension);
                    formdata.append('mimetype', file.type);
                }
            };
            if (!constants_1.IS_IE && hasFiles(cData)) {
                _this.sendFiles(cData.files, handlerSuccess, handlerError);
                return false;
            }
            if (constants_1.IS_IE && !false) {
                if (cData &&
                    (!cData.types.length || cData.types[0] !== constants_1.TEXT_PLAIN)) {
                    var div_1 = _this.j.c.div('', {
                        tabindex: -1,
                        style: 'left: -9999px; top: 0; width: 0; height: 100%;line-height: 140%; ' +
                            'overflow: hidden; position: fixed; z-index: 2147483647; word-break: break-all;',
                        contenteditable: true
                    });
                    global_1.getContainer(_this.j, Uploader).appendChild(div_1);
                    var selection_1 = helpers_1.isJoditObject(_this.j)
                        ? _this.j.s.save()
                        : null, restore_1 = function () {
                        return selection_1 &&
                            helpers_1.isJoditObject(_this.j) &&
                            _this.j.s.restore();
                    };
                    div_1.focus();
                    _this.j.async.setTimeout(function () {
                        var child = div_1.firstChild;
                        dom_1.Dom.safeRemove(div_1);
                        if (child && child.hasAttribute('src')) {
                            var src = helpers_1.attr(child, 'src') || '';
                            restore_1();
                            self.sendFiles([Uploader.dataURItoBlob(src)], handlerSuccess, handlerError);
                        }
                    }, _this.j.defaultTimeout);
                }
                return;
            }
            if (cData && cData.items && cData.items.length) {
                var items = cData.items;
                for (i = 0; i < items.length; i += 1) {
                    if (items[i].kind === 'file' &&
                        items[i].type === 'image/png') {
                        file = items[i].getAsFile();
                        if (file) {
                            var mime = file.type.match(/\/([a-z0-9]+)/i);
                            extension = mime[1]
                                ? mime[1].toLowerCase()
                                : '';
                            _this.sendFiles([file], handlerSuccess, handlerError, process);
                        }
                        e.preventDefault();
                        break;
                    }
                }
            }
        };
        if (this.j && this.j.editor !== form) {
            self.j.e.on(form, 'paste', onPaste);
        }
        else {
            self.j.e.on('beforePaste', onPaste);
        }
        var hasFiles = function (data) {
            return Boolean(data && data.files && data.files.length !== 0);
        };
        self.j.e
            .on(form, 'dragend dragover dragenter dragleave drop', function (e) {
            e.preventDefault();
        })
            .on(form, 'dragover', function (event) {
            if (hasFiles(event.dataTransfer)) {
                form.classList.contains('jodit_draghover') ||
                    form.classList.add('jodit_draghover');
                event.preventDefault();
            }
        })
            .on(form, 'dragend', function (event) {
            if (hasFiles(event.dataTransfer)) {
                form.classList.contains('jodit_draghover') &&
                    form.classList.remove('jodit_draghover');
                event.preventDefault();
            }
        })
            .on(form, 'drop', function (event) {
            form.classList.remove('jodit_draghover');
            if (hasFiles(event.dataTransfer)) {
                event.preventDefault();
                event.stopImmediatePropagation();
                _this.sendFiles(event.dataTransfer.files, handlerSuccess, handlerError);
            }
        });
        var inputFile = form.querySelector('input[type=file]');
        if (inputFile) {
            self.j.e.on(inputFile, 'change', function () {
                self.sendFiles(this.files, handlerSuccess, handlerError).then(function () {
                    inputFile.value = '';
                    if (!/safari/i.test(navigator.userAgent)) {
                        inputFile.type = '';
                        inputFile.type = 'file';
                    }
                });
            });
        }
    };
    Uploader.prototype.uploadRemoteImage = function (url, handlerSuccess, handlerError) {
        var _this = this;
        var uploader = this;
        uploader.send({
            action: 'fileUploadRemote',
            url: url
        }, function (resp) {
            if (uploader.o.isSuccess.call(uploader, resp)) {
                if (typeof handlerSuccess === 'function') {
                    handlerSuccess.call(uploader, _this.o.process.call(_this, resp));
                }
                else {
                    _this.o.defaultHandlerSuccess.call(uploader, _this.o.process.call(_this, resp));
                }
            }
            else {
                if (typeof (handlerError || uploader.o.defaultHandlerError) === 'function') {
                    (handlerError || _this.o.defaultHandlerError).call(uploader, helpers_1.error(uploader.o.getMessage.call(_this, resp)));
                    return;
                }
            }
        });
    };
    Uploader.prototype.destruct = function () {
        this.setStatus(component_1.STATUSES.beforeDestruct);
        this.ajaxInstances.forEach(function (ajax) {
            try {
                ajax.destruct();
            }
            catch (_a) { }
        });
        _super.prototype.destruct.call(this);
    };
    return Uploader;
}(component_1.ViewComponent));
exports.Uploader = Uploader;


/***/ }),
/* 213 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 214 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
var checker_1 = __webpack_require__(34);
var en = __webpack_require__(215);
var exp = {
    en: en
};
if (true) {
    var ar = __webpack_require__(216);
    var cs_cz = __webpack_require__(217);
    var de = __webpack_require__(218);
    var es = __webpack_require__(219);
    var fr = __webpack_require__(220);
    var he = __webpack_require__(221);
    var hu = __webpack_require__(222);
    var id = __webpack_require__(223);
    var it = __webpack_require__(224);
    var ja = __webpack_require__(225);
    var ko = __webpack_require__(226);
    var nl = __webpack_require__(227);
    var pl = __webpack_require__(228);
    var pt_br = __webpack_require__(229);
    var ru = __webpack_require__(230);
    var tr = __webpack_require__(231);
    var zh_cn = __webpack_require__(232);
    var zh_tw = __webpack_require__(233);
    exp = {
        ar: ar,
        cs_cz: cs_cz,
        de: de,
        en: en,
        es: es,
        fr: fr,
        he: he,
        hu: hu,
        id: id,
        it: it,
        ja: ja,
        ko: ko,
        nl: nl,
        pl: pl,
        pt_br: pt_br,
        ru: ru,
        tr: tr,
        zh_cn: zh_cn,
        zh_tw: zh_tw
    };
}
var get = function (value) { return value.default || value; }, hashLang = {};
if (checker_1.isArray(get(en))) {
    get(en).forEach(function (key, index) {
        hashLang[index] = key;
    });
}
Object.keys(exp).forEach(function (lang) {
    var list = get(exp[lang]);
    if (checker_1.isArray(list)) {
        exp[lang] = {};
        list.forEach(function (value, index) {
            exp[lang][hashLang[index]] = value;
        });
    }
});
exports.default = exp;


/***/ }),
/* 215 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Start writing...',
	pencil: 'Edit',
	Quadrate: 'Square'
};


/***/ }),
/* 216 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'إبدأ في الكتابة...',
	'About Jodit': 'حول جوديت',
	'Jodit Editor': 'محرر جوديت',
	"Jodit User's Guide": 'دليل مستخدم جوديت',
	'contains detailed help for using': 'يحتوي على مساعدة مفصلة للاستخدام',
	'For information about the license, please go to our website:':
		'للحصول على معلومات حول الترخيص، يرجى الذهاب لموقعنا:',
	'Buy full version': 'شراء النسخة الكاملة',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'حقوق الطبع والنشر © XDSoft.net - Chupurnov Valeriy. كل الحقوق محفوظة.',
	Anchor: 'مِرْساة',
	'Open in new tab': 'فتح في نافذة جديدة',
	'Open editor in fullsize': 'فتح المحرر في الحجم الكامل',
	'Clear Formatting': 'مسح التنسيق',
	'Fill color or set the text color': 'ملء اللون أو تعيين لون النص',
	Redo: 'إعادة',
	Undo: 'تراجع',
	Bold: 'عريض',
	Italic: 'مائل',
	'Insert Unordered List': 'إدراج قائمة غير مرتبة',
	'Insert Ordered List': 'إدراج قائمة مرتبة',
	'Align Center': 'محاذاة للوسط',
	'Align Justify': 'محاذاة مثبتة',
	'Align Left': 'محاذاة لليسار',
	'Align Right': 'محاذاة لليمين',
	'Insert Horizontal Line': 'إدراج خط أفقي',
	'Insert Image': 'إدراج صورة',
	'Insert file': 'ادخال الملف',
	'Insert youtube/vimeo video': 'إدراج فيديو يوتيوب/فيميو ',
	'Insert link': 'إدراج رابط',
	'Font size': 'حجم الخط',
	'Font family': 'نوع الخط',
	'Insert format block': 'إدراج كتلة تنسيق',
	Normal: 'عادي',
	'Heading 1': 'عنوان 1',
	'Heading 2': 'عنوان 2',
	'Heading 3': 'عنوان 3',
	'Heading 4': 'عنوان 4',
	Quote: 'إقتباس',
	Code: 'كود',
	Insert: 'إدراج',
	'Insert table': 'إدراج جدول',
	'Decrease Indent': 'تقليل المسافة البادئة',
	'Increase Indent': 'زيادة المسافة البادئة',
	'Select Special Character': 'تحديد أحرف خاصة',
	'Insert Special Character': 'إدراج حرف خاص',
	'Paint format': 'تنسيق الرسم',
	'Change mode': 'تغيير الوضع',
	Margins: 'هوامش',
	top: 'أعلى',
	right: 'يمين',
	bottom: 'أسفل',
	left: 'يسار',
	Styles: 'الأنماط',
	Classes: 'الطبقات',
	Align: 'محاذاة',
	Right: 'اليمين',
	Center: 'الوسط',
	Left: 'اليسار',
	'--Not Set--': '--غير مضبوط--',
	Src: 'Src',
	Title: 'العنوان',
	Alternative: 'العنوان البديل',
	Link: 'الرابط',
	'Open link in new tab': 'افتح الرابط في نافذة جديدة',
	Image: 'الصورة',
	file: 'ملف',
	Advanced: 'متقدم',
	'Image properties': 'خصائص الصورة',
	Cancel: 'إلغاء',
	Ok: 'حسنا',
	'File Browser': 'متصفح الملفات',
	'Error on load list': 'حدث خطأ في تحميل القائمة ',
	'Error on load folders': 'حدث خطأ في تحميل المجلدات',
	'Are you sure?': 'هل أنت واثق؟',
	'Enter Directory name': 'أدخل اسم المجلد',
	'Create directory': 'إنشاء مجلد',
	'type name': 'أكتب إسم',
	'Drop image': 'إسقاط صورة',
	'Drop file': 'إسقاط الملف',
	'or click': 'أو أنقر',
	'Alternative text': 'النص البديل',
	Upload: 'رفع',
	Browse: 'تصفح',
	Background: 'الخلفية',
	Text: 'نص',
	Top: 'أعلى',
	Middle: 'الوسط',
	Bottom: 'الأسفل',
	'Insert column before': 'إدراج عمود قبل',
	'Insert column after': 'إدراج عمود بعد',
	'Insert row above': 'إدراج صف أعلى',
	'Insert row below': 'إدراج صف أسفل',
	'Delete table': 'حذف الجدول',
	'Delete row': 'حذف الصف',
	'Delete column': 'حذف العمود',
	'Empty cell': 'خلية فارغة',
	'Chars: %d': '%d حرف',
	'Words: %d': '%d كلام',
	'Strike through': 'اضرب من خلال',
	Underline: 'أكد',
	superscript: 'حرف فوقي',
	subscript: 'مخطوطة',
	'Cut selection': 'قطع الاختيار',
	'Select all': 'اختر الكل',
	Break: 'استراحة',
	'Search for': 'البحث عن',
	'Replace with': 'استبدل ب',
	Replace: 'محل',
	Paste: 'معجون',
	'Choose Content to Paste': 'اختر محتوى للصق',
	source: 'مصدر',
	bold: 'بالخط العريض',
	italic: 'مائل',
	brush: 'شغل',
	link: 'صلة',
	undo: 'إلغاء',
	redo: 'كرر',
	table: 'طاولة',
	image: 'صورة',
	eraser: 'نظيف',
	paragraph: 'فقرة',
	fontsize: 'حجم الخط',
	video: 'فيديو',
	font: 'الخط',
	about: 'حول المحرر',
	print: 'طباعة',
	symbol: 'رمز',
	underline: 'أكد',
	strikethrough: 'شطب',
	indent: 'المسافة البادئة',
	outdent: 'نتوء',
	fullsize: 'ملء الشاشة',
	shrink: 'الحجم التقليدي',
	copyformat: 'نسخ التنسيق',
	hr: 'الخط',
	ul: 'قائمة',
	ol: 'قائمة مرقمة',
	cut: 'قطع',
	selectall: 'اختر الكل',
	'Embed code': 'قانون',
	'Open link': 'فتح الرابط',
	'Edit link': 'تعديل الرابط',
	'No follow': 'سمة Nofollow',
	Unlink: 'إزالة الرابط',
	Update: 'تحديث',
	pencil: 'لتحرير',
	Eye: 'مراجعة',
	' URL': 'URL',
	Edit: 'تحرير',
	'Horizontal align': 'محاذاة أفقية',
	Filter: 'فلتر',
	'Sort by changed': 'عن طريق التغيير',
	'Sort by name': 'بالاسم',
	'Sort by size': 'حسب الحجم',
	'Add folder': 'إضافة مجلد',
	Reset: 'إعادة',
	Save: 'احتفظ',
	'Save as ...': 'حفظ باسم',
	Resize: 'تغيير الحجم',
	Crop: 'حجم القطع',
	Width: 'عرض',
	Height: 'ارتفاع',
	'Keep Aspect Ratio': 'حافظ على النسب',
	Yes: 'أن',
	No: 'لا',
	Remove: 'حذف',
	Select: 'تميز',
	'Select %s': 'تميز %s',
	'Vertical align': 'محاذاة عمودية',
	Split: 'انشق، مزق',
	Merge: 'اذهب',
	'Add column': 'أضف العمود',
	'Add row': 'اضف سطر',
	'License: %s': 'رخصة %s',
	Delete: 'حذف',
	'Split vertical': 'انقسام عمودي',
	'Split horizontal': 'تقسيم أفقي',
	Border: 'الحدود',
	'Your code is similar to HTML. Keep as HTML?':
		'يشبه الكود الخاص بك HTML. تبقي كما HTML؟',
	'Paste as HTML': 'الصق ك HTML',
	Keep: 'احتفظ',
	'Insert as Text': 'إدراج كنص',
	'Insert only Text': 'إدراج النص فقط',
	'You can only edit your own images. Download this image on the host?':
		'يمكنك فقط تحرير صورك الخاصة. تحميل هذه الصورة على المضيف؟',
	'The image has been successfully uploaded to the host!':
		'تم تحميل الصورة بنجاح على الخادم!',
	palette: 'لوحة',
	'There are no files': 'لا توجد ملفات في هذا الدليل.',
	Rename: 'إعادة تسمية',
	'Enter new name': 'أدخل اسم جديد',
	preview: 'معاينة',
	download: 'تحميل',
	'Paste from clipboard': 'لصق من الحافظة',
	"Your browser doesn't support direct access to the clipboard.":
		'متصفحك لا يدعم إمكانية الوصول المباشر إلى الحافظة.',
	'Copy selection': 'نسخ التحديد',
	copy: 'نسخ',
	'Border radius': 'دائرة نصف قطرها الحدود',
	'Show all': 'عرض كل',
	Apply: 'تطبيق',
	'Please fill out this field': 'يرجى ملء هذا المجال',
	'Please enter a web address': 'يرجى إدخال عنوان ويب',
	Default: 'الافتراضي',
	Circle: 'دائرة',
	Dot: 'نقطة',
	Quadrate: 'المربعة',
	Find: 'البحث',
	'Find Previous': 'تجد السابقة',
	'Find Next': 'تجد التالي',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'للصق المحتوى قادم من Microsoft Word/Excel الوثيقة. هل تريد أن تبقي شكل أو تنظيفه ؟ ',
	'Word Paste Detected': 'كلمة لصق الكشف عن',
	Clean: 'نظيفة',
	'Insert className': 'أدخل اسم الفصل'
};


/***/ }),
/* 217 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Napiš něco',
	'About Jodit': 'O Jodit',
	'Jodit Editor': 'Editor Jodit',
	'Free Non-commercial Version': 'Verze pro nekomerční použití',
	"Jodit User's Guide": 'Jodit Uživatelská příručka',
	'contains detailed help for using': 'obsahuje detailní nápovědu',
	'For information about the license, please go to our website:':
		'Pro informace o licenci, prosím, přejděte na naši stránku:',
	'Buy full version': 'Koupit plnou verzi',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. Všechna práva vyhrazena.',
	Anchor: 'Anchor',
	'Open in new tab': 'Otevřít v nové záložce',
	'Open editor in fullsize': 'Otevřít v celoobrazovkovém režimu',
	'Clear Formatting': 'Vyčistit formátování',
	'Fill color or set the text color': 'Barva výplně a písma',
	Redo: 'Vpřed',
	Undo: 'Zpět',
	Bold: 'Tučné',
	Italic: 'Kurzíva',
	'Insert Unordered List': 'Odrážky',
	'Insert Ordered List': 'Číslovaný seznam',
	'Align Center': 'Zarovnat na střed',
	'Align Justify': 'Zarovnat do bloku',
	'Align Left': 'Zarovnat vlevo',
	'Align Right': 'Zarovnat vpravo',
	'Insert Horizontal Line': 'Vložit horizontální linku',
	'Insert Image': 'Vložit obrázek',
	'Insert file': 'Vložit soubor',
	'Insert youtube/vimeo video': 'Vložit video (YT/Vimeo)',
	'Insert link': 'Vložit odkaz',
	'Font size': 'Velikost písma',
	'Font family': 'Typ písma',
	'Insert format block': 'Formátovat blok',
	Normal: 'Normální text',
	'Heading 1': 'Nadpis 1',
	'Heading 2': 'Nadpis 2',
	'Heading 3': 'Nadpis 3',
	'Heading 4': 'Nadpis 4',
	Quote: 'Citát',
	Code: 'Kód',
	Insert: 'Vložit',
	'Insert table': 'Vložit tabulku',
	'Decrease Indent': 'Zmenšit odsazení',
	'Increase Indent': 'Zvětšit odsazení',
	'Select Special Character': 'Vybrat speciální symbol',
	'Insert Special Character': 'Vložit speciální symbol',
	'Paint format': 'Použít formát',
	'Change mode': 'Změnit mód',
	Margins: 'Okraje',
	top: 'horní',
	right: 'pravý',
	bottom: 'spodní',
	left: 'levý',
	Styles: 'Styly',
	Classes: 'Třídy',
	Align: 'Zarovnání',
	Right: 'Vpravo',
	Center: 'Na střed',
	Left: 'Vlevo',
	'--Not Set--': '--nenastaveno--',
	Src: 'src',
	Title: 'Titulek',
	Alternative: 'Alternativní text (alt)',
	Link: 'Link',
	'Open link in new tab': 'Otevřít link v nové záložce',
	Image: 'Obrázek',
	file: 'soubor',
	Advanced: 'Rozšířené',
	'Image properties': 'Vlastnosti obrázku',
	Cancel: 'Zpět',
	Ok: 'Ok',
	'Your code is similar to HTML. Keep as HTML?':
		'Váš text se podobá HTML. Vložit ho jako HTML?',
	'Paste as HTML': 'Vložit jako HTML',
	Keep: 'Ponechat originál',
	Clean: 'Vyčistit',
	'Insert as Text': 'Vložit jako TEXT',
	'Insert only Text': 'Vložit pouze TEXT',
	'Word Paste Detected': 'Detekován fragment z Wordu nebo Excelu',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'Obsah, který vkládáte, je pravděpodobně z Microsoft Word / Excel. Chcete ponechat formát nebo vložit pouze text?',
	'File Browser': 'Prohlížeč souborů',
	'Error on load list': 'Chyba při načítání seznamu souborů',
	'Error on load folders': 'Chyba při načítání složek',
	'Are you sure?': 'Jste si jistý(á)?',
	'Enter Directory name': 'Název složky',
	'Create directory': 'Vytvořit složku',
	'type name': 'název',
	'Drop image': 'Přetáhněte sem obrázek',
	'Drop file': 'Přetáhněte sem soubor',
	'or click': 'nebo klikněte',
	'Alternative text': 'Alternativní text',
	Browse: 'Server',
	Upload: 'Nahrát',
	Background: 'Pozadí',
	Text: 'Text',
	Top: 'Nahoru',
	Middle: 'Na střed',
	Bottom: 'Dolu',
	'Insert column before': 'Vložit sloupec před',
	'Insert column after': 'Vložit sloupec za',
	'Insert row above': 'Vložit řádek nad',
	'Insert row below': 'Vložit řádek pod',
	'Delete table': 'Vymazat tabulku',
	'Delete row': 'Vymazat řádku',
	'Delete column': 'Vymazat sloupec',
	'Empty cell': 'Vyčistit buňku',
	source: 'HTML',
	bold: 'tučně',
	italic: 'kurzíva',
	brush: 'štětec',
	link: 'odkaz',
	undo: 'zpět',
	redo: 'vpřed',
	table: 'tabulka',
	image: 'obrázek',
	eraser: 'guma',
	paragraph: 'odstavec',
	fontsize: 'velikost písma',
	video: 'video',
	font: 'písmo',
	about: 'о editoru',
	print: 'tisk',
	symbol: 'symbol',
	underline: 'podtrženo',
	strikethrough: 'přeškrtnuto',
	indent: 'zvětšit odsazení',
	outdent: 'zmenšit odsazení',
	fullsize: 'celoobrazovkový režim',
	shrink: 'smrsknout',
	copyformat: 'Kopírovat formát',
	hr: 'Linka',
	ul: 'Odrážka',
	ol: 'Číslovaný seznam',
	cut: 'Vyjmout',
	selectall: 'Označit vše',
	'Embed code': 'Kód',
	'Open link': 'Otevřít odkaz',
	'Edit link': 'Upravit odkaz',
	'No follow': 'Atribut no-follow',
	Unlink: 'Odstranit odkaz',
	Eye: 'Zobrazit',
	pencil: 'Chcete-li upravit',
	Update: 'Aktualizovat',
	' URL': 'URL',
	Edit: 'Editovat',
	'Horizontal align': 'Horizontální zarovnání',
	Filter: 'Filtr',
	'Sort by changed': 'Dle poslední změny',
	'Sort by name': 'Dle názvu',
	'Sort by size': 'Dle velikosti',
	'Add folder': 'Přidat složku',
	Reset: 'Reset',
	Save: 'Uložit',
	'Save as ...': 'Uložit jako...',
	Resize: 'Změnit rozměr',
	Crop: 'Ořezat',
	Width: 'Šířka',
	Height: 'Výška',
	'Keep Aspect Ratio': 'Ponechat poměr',
	Yes: 'Ano',
	No: 'Ne',
	Remove: 'Vyjmout',
	Select: 'Označit',
	'Chars: %d': 'Znaky: %d',
	'Words: %d': 'Slova: %d',
	All: 'Vše',
	'Select %s': 'Označit %s',
	'Select all': 'Označit vše',
	'Vertical align': 'Vertikální zarovnání',
	Split: 'Rozdělit',
	'Split vertical': 'Rozdělit vertikálně',
	'Split horizontal': 'Rozdělit horizontálně',
	Merge: 'Spojit',
	'Add column': 'Přidat sloupec',
	'Add row': 'Přidat řádek',
	Delete: 'Vymazat',
	Border: 'Okraj',
	'License: %s': 'Licence: %s',
	'Strike through': 'Přeškrtnuto',
	Underline: 'Podtrženo',
	superscript: 'Horní index',
	subscript: 'Dolní index',
	'Cut selection': 'Vyjmout označené',
	Break: 'Zalomení',
	'Search for': 'Najdi',
	'Replace with': 'Nahradit za',
	Replace: 'Vyměňte',
	Paste: 'Vložit',
	'Choose Content to Paste': 'Vyber obsah pro vložení',
	'You can only edit your own images. Download this image on the host?':
		'Můžete upravovat pouze své obrázky. Načíst obrázek?',
	'The image has been successfully uploaded to the host!':
		'Obrázek byl úspěšně nahrán!',
	palette: 'paleta',
	'There are no files': 'V tomto adresáři nejsou žádné soubory.',
	Rename: 'přejmenovat',
	'Enter new name': 'Zadejte nový název',
	preview: 'náhled',
	download: 'Stažení',
	'Paste from clipboard': 'Vložit ze schránky',
	"Your browser doesn't support direct access to the clipboard.":
		'Váš prohlížeč nepodporuje přímý přístup do schránky.',
	'Copy selection': 'Kopírovat výběr',
	copy: 'kopírování',
	'Border radius': 'Border radius',
	'Show all': 'Zobrazit všechny',
	Apply: 'Platí',
	'Please fill out this field': 'Prosím, vyplňte toto pole',
	'Please enter a web address': 'Prosím, zadejte webovou adresu',
	Default: 'Výchozí',
	Circle: 'Kruh',
	Dot: 'Dot',
	Quadrate: 'Quadrate',
	Find: 'Najít',
	'Find Previous': 'Najít Předchozí',
	'Find Next': 'Najít Další',
	'Insert className': 'Vložte název třídy'
};


/***/ }),
/* 218 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Bitte geben Sie einen Text ein',
	Advanced: 'Fortgeschritten',
	'About Jodit': 'Über Jodit',
	'Jodit Editor': 'Jodit Editor',
	"Jodit User's Guide": 'Das Jodit Benutzerhandbuch',
	'contains detailed help for using':
		'beinhaltet ausführliche Informationen wie Sie den Editor verwenden können.',
	'For information about the license, please go to our website:':
		'Für Informationen zur Lizenz, besuchen Sie bitte unsere Web-Präsenz:',
	'Buy full version': 'Vollversion kaufen',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. Alle Rechte vorbehalten.',
	Anchor: 'Anker',
	'Open in new tab': 'In neuer Registerkarte öffnen',
	'Open editor in fullsize': 'Editor in voller Größe öffnen',
	'Clear Formatting': 'Formatierung löschen',
	'Fill color or set the text color': 'Füllfarbe oder Textfarbe ändern',
	Redo: 'Wiederholen',
	Undo: 'Rückgängig machen',
	Bold: 'Fett',
	Italic: 'Kursiv',
	'Insert Unordered List': 'Unsortierte Liste einfügen',
	'Insert Ordered List': 'Nummerierte Liste einfügen',
	'Align Center': 'Mittig ausrichten',
	'Align Justify': 'Blocksatz',
	'Align Left': 'Links ausrichten',
	'Align Right': 'Rechts ausrichten',
	'Insert Horizontal Line': 'Horizontale Linie einfügen',
	'Insert Image': 'Bild einfügen',
	'Insert file': 'Datei einfügen',
	'Insert youtube/vimeo video': 'Youtube/vimeo Video einfügen',
	'Insert link': 'Link einfügen',
	'Font size': 'Schriftgröße',
	'Font family': 'Schriftfamilie',
	'Insert format block': 'Formatblock einfügen',
	Normal: 'Normal',
	'Heading 1': 'Überschrift 1',
	'Heading 2': 'Überschrift 2',
	'Heading 3': 'Überschrift 3',
	'Heading 4': 'Überschrift 4',
	Quote: 'Zitat',
	Code: 'Code',
	Insert: 'Einfügen',
	'Insert table': 'Tabelle einfügen',
	'Decrease Indent': 'Einzug verkleinern',
	'Increase Indent': 'Einzug vergrößern',
	'Select Special Character': 'Sonderzeichen auswählen',
	'Insert Special Character': 'Sonderzeichen einfügen',
	'Paint format': 'Format kopieren',
	'Change mode': 'Änderungsmodus',
	Margins: 'Ränder',
	top: 'Oben',
	right: 'Rechts',
	bottom: 'Unten',
	left: 'Links',
	Styles: 'CSS Stil',
	Classes: 'CSS Klassen',
	Align: 'Ausrichtung',
	Right: 'Rechts',
	Center: 'Zentriert',
	Left: 'Links',
	'--Not Set--': 'Keine',
	Src: 'Pfad',
	Title: 'Titel',
	Alternative: 'Alternativer Text',
	Link: 'Link',
	'Open link in new tab': 'Link in neuem Tab öffnen',
	Image: 'Bild',
	file: 'Datei',
	Advansed: 'Erweitert',
	'Image properties': 'Bildeigenschaften',
	Cancel: 'Abbrechen',
	Ok: 'OK',
	'Your code is similar to HTML. Keep as HTML?':
		'Ihr Text ähnelt HTML-Code. Als HTML beibehalten?',
	'Paste as HTML': 'Als HTML einfügen?',
	Keep: 'Original speichern',
	Clean: 'Säubern',
	'Insert as Text': 'Als Text einfügen',
	'Word Paste Detected': 'In Word formatierter Text erkannt',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'Der Inhalt, den Sie einfügen, stammt aus einem Microsoft Word / Excel-Dokument. Möchten Sie das Format erhalten oder bereinigen?',
	'Insert only Text': 'Nur Text einfügen',
	'File Browser': 'Dateibrowser',
	'Error on load list': 'Fehler beim Laden der Liste',
	'Error on load folders': 'Fehler beim Laden der Ordner',
	'Are you sure?': 'Sind Sie sicher?',
	'Enter Directory name': 'Geben Sie den Verzeichnisnamen ein',
	'Create directory': 'Verzeichnis erstellen',
	'type name': 'Typname',
	'Drop image': 'Bild hier hinziehen',
	'Drop file': 'Datei löschen',
	'or click': 'oder hier klicken',
	'Alternative text': 'Alternativtext',
	Browse: 'Auswählen',
	Upload: 'Hochladen',
	Background: 'Hintergrund',
	Text: 'Text',
	Top: 'Oben',
	Middle: 'Mittig',
	Bottom: 'Unten',
	'Insert column before': 'Spalte davor einfügen',
	'Insert column after': 'Spalte danach einfügen',
	'Insert row above': 'Zeile oberhalb einfügen',
	'Insert row below': 'Zeile unterhalb einfügen',
	'Delete table': 'Tabelle löschen',
	'Delete row': 'Zeile löschen',
	'Delete column': 'Spalte löschen',
	'Empty cell': 'Zelle leeren',
	Delete: 'Löschen',
	'Strike through': 'Durchstreichen',
	Underline: 'Unterstreichen',
	Break: 'Pause',
	'Search for': 'Suche nach',
	'Replace with': 'Ersetzen durch',
	Replace: 'Ersetzen',
	Edit: 'Bearbeiten',
	'Vertical align': 'Vertikale Ausrichtung',
	'Horizontal align': 'Horizontale Ausrichtung',
	Filter: 'Filter',
	'Sort by changed': 'Sortieren nach geändert',
	'Sort by name': 'Nach Name sortieren',
	'Sort by size': 'Nach Größe sortiert',
	'Add folder': 'Ordner hinzufügen',
	'Split vertical': 'Vertikal unterteilen',
	'Split horizontal': 'Horizontal unterteilen',
	Split: 'Unterteilen',
	Merge: 'Vereinen',
	'Add column': 'Spalte hinzufügen',
	'Add row': 'Zeile hinzufügen',
	Border: 'Rand',
	'Embed code': 'Code einbetten',
	Update: 'Aktualisieren',
	superscript: 'Hochgestellen',
	subscript: 'Tiefstellen',
	'Cut selection': 'Auswahl ausschneiden',
	Paste: 'Einfügen',
	'Choose Content to Paste': 'Wählen Sie den Inhalt zum Einfügen aus',
	'Chars: %d': 'Zeichen: %d',
	'Words: %d': 'Wörter: %d',
	All: 'Alles markieren',
	'Select %s': 'Markieren: %s',
	'Select all': 'Alles markieren',
	source: 'HTML',
	bold: 'Fett gedruckt',
	italic: 'Kursiv',
	brush: 'Bürste',
	link: 'Verknüpfung',
	undo: 'Rückgängig machen',
	redo: 'Wiederholen',
	table: 'Tabelle',
	image: 'Bild',
	eraser: 'Radiergummi',
	paragraph: 'Absatz',
	fontsize: 'Schriftgröße',
	video: 'Video',
	font: 'Schriftart',
	about: 'Über',
	print: 'Drucken',
	symbol: 'Symbol',
	underline: 'Unterstreichen',
	strikethrough: 'Durchstreichen',
	indent: 'Einzug',
	outdent: 'Herausstellen',
	fullsize: 'Vollgröße',
	shrink: 'Schrumpfen',
	copyformat: 'Format kopierenт',
	hr: 'die Linie',
	ul: 'Liste von',
	ol: 'Nummerierte Liste',
	cut: 'Schneiden',
	selectall: 'Wählen Sie Alle aus',
	'Open link': 'Link öffnen',
	'Edit link': 'Link bearbeiten',
	'No follow': 'Nofollow-Attribut',
	Unlink: 'Link entfernen',
	Eye: 'Ansehen',
	pencil: 'Bearbeiten',
	' URL': 'URL',
	Reset: 'Wiederherstellen',
	Save: 'Speichern',
	'Save as ...': 'Speichern als',
	Resize: 'Größe ändern',
	Crop: 'Größe anpassen',
	Width: 'Breite',
	Height: 'Höhe',
	'Keep Aspect Ratio': 'Seitenverhältnis beibehalten',
	Yes: 'Ja',
	No: 'Nein',
	Remove: 'Entfernen',
	Select: 'Markieren',
	'You can only edit your own images. Download this image on the host?':
		'Sie können nur Ihre eigenen Bilder bearbeiten. Dieses Bild auf den Host herunterladen?',
	'The image has been successfully uploaded to the host!':
		'Das Bild wurde erfolgreich auf den Server hochgeladen!',
	palette: 'Palette',
	'There are no files': 'In diesem Verzeichnis befinden sich keine Dateien.',
	Rename: 'Umbenennen',
	'Enter new name': 'Geben Sie einen neuen Namen ein',
	preview: 'Vorschau',
	download: 'Herunterladen',
	'Paste from clipboard': 'Aus Zwischenablage einfügen',
	"Your browser doesn't support direct access to the clipboard.":
		'Ihr Browser unterstützt keinen direkten Zugriff auf die Zwischenablage.',
	'Copy selection': 'Auswahl kopieren',
	copy: 'Kopieren',
	'Border radius': 'Radius für abgerundete Ecken',
	'Show all': 'Alle anzeigen',
	Apply: 'Anwenden',
	'Please fill out this field': 'Bitte füllen Sie dieses Feld aus',
	'Please enter a web address': 'Bitte geben Sie eine Web-Adresse ein',
	Default: 'Standard',
	Circle: 'Kreis',
	Dot: 'Dot',
	Quadrate: 'Quadrate',
	Find: 'Suchen',
	'Find Previous': 'Suche vorherige',
	'Find Next': 'Weitersuchen',
	'Insert className': 'Vložte název třídy'
};


/***/ }),
/* 219 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Escriba algo...',
	Advanced: 'Avanzado',
	'About Jodit': 'Acerca de Jodit',
	'Jodit Editor': 'Jodit Editor',
	"Jodit User's Guide": 'Guía de usuario Jodit',
	'contains detailed help for using': 'contiene ayuda detallada para el uso.',
	'For information about the license, please go to our website:':
		'Para información sobre la licencia, por favor visite nuestro sitio:',
	'Buy full version': 'Compre la versión completa',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. Todos los derechos reservados.',
	Anchor: 'Anclar',
	'Open in new tab': 'Abrir en nueva pestaña',
	'Open editor in fullsize': 'Abrir editor en pantalla completa',
	'Clear Formatting': 'Limpiar formato',
	'Fill color or set the text color': 'Color de relleno o de letra',
	Redo: 'Rehacer',
	Undo: 'Deshacer',
	Bold: 'Negrita',
	Italic: 'Cursiva',
	'Insert Unordered List': 'Insertar lista no ordenada',
	'Insert Ordered List': 'Insertar lista ordenada',
	'Align Center': 'Alinear Centrado',
	'Align Justify': 'Alinear Justificado',
	'Align Left': 'Alinear Izquierda',
	'Align Right': 'Alinear Derecha',
	'Insert Horizontal Line': 'Insertar línea horizontal',
	'Insert Image': 'Insertar imagen',
	'Insert file': 'Insertar archivo',
	'Insert youtube/vimeo video': 'Insertar video de Youtube/vimeo',
	'Insert link': 'Insertar vínculo',
	'Font size': 'Tamaño de letra',
	'Font family': 'Familia de letra',
	'Insert format block': 'Insertar bloque',
	Normal: 'Normal',
	'Heading 1': 'Encabezado 1',
	'Heading 2': 'Encabezado 2',
	'Heading 3': 'Encabezado 3',
	'Heading 4': 'Encabezado 4',
	Quote: 'Cita',
	Code: 'Código',
	Insert: 'Insertar',
	'Insert table': 'Insertar tabla',
	'Decrease Indent': 'Disminuir sangría',
	'Increase Indent': 'Aumentar sangría',
	'Select Special Character': 'Seleccionar caracter especial',
	'Insert Special Character': 'Insertar caracter especial',
	'Paint format': 'Copiar formato',
	'Change mode': 'Cambiar modo',
	Margins: 'Márgenes',
	top: 'arriba',
	right: 'derecha',
	bottom: 'abajo',
	left: 'izquierda',
	Styles: 'Estilos CSS',
	Classes: 'Clases CSS',
	Align: 'Alinear',
	Right: 'Derecha',
	Center: 'Centrado',
	Left: 'Izquierda',
	'--Not Set--': '--No Establecido--',
	Src: 'Fuente',
	Title: 'Título',
	Alternative: 'Texto Alternativo',
	Link: 'Vínculo',
	'Open link in new tab': 'Abrir vínculo en nueva pestaña',
	Image: 'Imagen',
	file: 'Archivo',
	Advansed: 'Avanzado',
	'Image properties': 'Propiedades de imagen',
	Cancel: 'Cancelar',
	Ok: 'Aceptar',
	'Your code is similar to HTML. Keep as HTML?':
		'El código es similar a HTML. ¿Mantener como HTML?',
	'Paste as HTML': 'Pegar como HTML?',
	Keep: 'Mantener',
	Clean: 'Limpiar',
	'Insert as Text': 'Insertar como texto',
	'Word Paste Detected': 'Pegado desde Word detectado',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'El contenido pegado proviene de un documento de Microsoft Word/Excel. ¿Desea mantener el formato o limpiarlo?',
	'Insert only Text': 'Insertar solo texto',
	'File Browser': 'Buscar archivo',
	'Error on load list': 'Error al cargar la lista',
	'Error on load folders': 'Error al cargar las carpetas',
	'Are you sure?': '¿Está seguro?',
	'Enter Directory name': 'Entre nombre de carpeta',
	'Create directory': 'Crear carpeta',
	'type name': 'Entre el nombre',
	'Drop image': 'Soltar imagen',
	'Drop file': 'Soltar archivo',
	'or click': 'o click',
	'Alternative text': 'Texto alternativo',
	Browse: 'Buscar',
	Upload: 'Subir',
	Background: 'Fondo',
	Text: 'Texto',
	Top: 'Arriba',
	Middle: 'Centro',
	Bottom: 'Abajo',
	'Insert column before': 'Insertar columna antes',
	'Insert column after': 'Interar columna después',
	'Insert row above': 'Insertar fila arriba',
	'Insert row below': 'Insertar fila debajo',
	'Delete table': 'Borrar tabla',
	'Delete row': 'Borrar fila',
	'Delete column': 'Borrar columna',
	'Empty cell': 'Vaciar celda',
	Delete: 'Borrar',
	'Strike through': 'Tachado',
	Underline: 'Subrayado',
	Break: 'Pausa',
	'Search for': 'Buscar',
	'Replace with': 'Reemplazar con',
	Replace: 'Reemplazar',
	Edit: 'Editar',
	'Vertical align': 'Alineación vertical',
	'Horizontal align': 'Alineación horizontal',
	Filter: 'filtrar',
	'Sort by changed': 'Ordenar por fecha modificación',
	'Sort by name': 'Ordenar por nombre',
	'Sort by size': 'Ordenar por tamaño',
	'Add folder': 'Agregar carpeta',
	Split: 'Dividir',
	'Split vertical': 'Dividir vertical',
	'Split horizontal': 'Dividir horizontal',
	Merge: 'Mezclar',
	'Add column': 'Agregar columna',
	'Add row': 'Agregar fila',
	Border: 'Borde',
	'Embed code': 'Incluir código',
	Update: 'Actualizar',
	superscript: 'superíndice',
	subscript: 'subíndice',
	'Cut selection': 'Cortar selección',
	Paste: 'Pegar',
	'Choose Content to Paste': 'Seleccionar contenido para pegar',
	'Chars: %d': 'Caracteres: %d',
	'Words: %d': 'Palabras: %d',
	All: 'Todo',
	'Select %s': 'Seleccionar: %s',
	'Select all': 'Seleccionar todo',
	source: 'HTML',
	bold: 'negrita',
	italic: 'cursiva',
	brush: 'Brocha',
	link: 'Vínculo',
	undo: 'deshacer',
	redo: 'rehacer',
	table: 'Tabla',
	image: 'Imagen',
	eraser: 'Borrar',
	paragraph: 'Párrafo',
	fontsize: 'Tamaño de letra',
	video: 'Video',
	font: 'Letra',
	about: 'Acerca de',
	print: 'Imprimir',
	symbol: 'Símbolo',
	underline: 'subrayar',
	strikethrough: 'tachar',
	indent: 'sangría',
	outdent: 'quitar sangría',
	fullsize: 'Tamaño completo',
	shrink: 'encoger',
	copyformat: 'Copiar formato',
	hr: 'línea horizontal',
	ul: 'lista sin ordenar',
	ol: 'lista ordenada',
	cut: 'Cortar',
	selectall: 'Seleccionar todo',
	'Open link': 'Abrir vínculo',
	'Edit link': 'Editar vínculo',
	'No follow': 'No seguir',
	Unlink: 'Desvincular',
	Eye: 'Ver',
	pencil: 'Para editar',
	' URL': 'URL',
	Reset: 'Resetear',
	Save: 'Guardar',
	'Save as ...': 'Guardar como...',
	Resize: 'Redimensionar',
	Crop: 'Recortar',
	Width: 'Ancho',
	Height: 'Alto',
	'Keep Aspect Ratio': 'Mantener relación de aspecto',
	Yes: 'Si',
	No: 'No',
	Remove: 'Quitar',
	Select: 'Seleccionar',
	'You can only edit your own images. Download this image on the host?':
		'Solo puedes editar tus propias imágenes. ¿Descargar esta imagen en el servidor?',
	'The image has been successfully uploaded to the host!':
		'¡La imagen se ha subido correctamente al servidor!',
	palette: 'paleta',
	'There are no files': 'No hay archivos en este directorio.',
	Rename: 'renombrar',
	'Enter new name': 'Ingresa un nuevo nombre',
	preview: 'avance',
	download: 'Descargar',
	'Paste from clipboard': 'Pegar desde el portapapeles',
	"Your browser doesn't support direct access to the clipboard.":
		'Su navegador no soporta el acceso directo en el portapapeles.',
	'Copy selection': 'Selección de copia',
	copy: 'copia',
	'Border radius': 'Radio frontera',
	'Show all': 'Mostrar todos los',
	Apply: 'Aplicar',
	'Please fill out this field': 'Por favor, rellene este campo',
	'Please enter a web address': 'Por favor, introduzca una dirección web',
	Default: 'Predeterminado',
	Circle: 'Círculo',
	Dot: 'Punto',
	Quadrate: 'Cuadro',
	//Ordered list
	'Lower Alpha': 'Letra Minúscula',
	'Lower Greek': 'Griego Minúscula',
	'Lower Roman': 'Romano Minúscula',
	'Upper Alpha': 'Letra Mayúscula',
	'Upper Roman': 'Romano Mayúscula',
	Find: 'Encontrar',
	'Find Previous': 'Buscar Anterior',
	'Find Next': 'Buscar Siguiente',
	'Insert className': 'Insertar nombre de clase'
};


/***/ }),
/* 220 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Ecrivez ici',
	'About Jodit': 'A propos de Jodit',
	'Jodit Editor': 'Editeur Jodit',
	"Jodit User's Guide": "Guide de l'utilisateur",
	'contains detailed help for using': "Aide détaillée à l'utilisation",
	'For information about the license, please go to our website:':
		'Consulter la licence sur notre site web:',
	'Buy full version': 'Acheter la version complète',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. Tous droits réservés.',
	Anchor: 'Ancre',
	'Open in new tab': 'Ouvrir dans un nouvel onglet',
	'Open editor in fullsize': "Ouvrir l'éditeur en pleine page",
	'Clear Formatting': 'Supprimer le formattage',
	'Fill color or set the text color':
		'Modifier la couleur du fond ou du texte',
	Redo: 'Refaire',
	Undo: 'Défaire',
	Bold: 'Gras',
	Italic: 'Italique',
	'Insert Unordered List': 'Liste non ordonnée',
	'Insert Ordered List': 'Liste ordonnée',
	'Align Center': 'Centrer',
	'Align Justify': 'Justifier',
	'Align Left': 'Aligner à gauche ',
	'Align Right': 'Aligner à droite',
	'Insert Horizontal Line': 'Insérer une ligne horizontale',
	'Insert Image': 'Insérer une image',
	'Insert file': 'Insérer un fichier',
	'Insert youtube/vimeo video': 'Insérer une vidéo',
	'Insert link': 'Insérer un lien',
	'Font size': 'Taille des caractères',
	'Font family': 'Famille des caractères',
	'Insert format block': 'Bloc formatté',
	Normal: 'Normal',
	'Heading 1': 'Titre 1',
	'Heading 2': 'Titre 2',
	'Heading 3': 'Titre 3',
	'Heading 4': 'Titre 4',
	Quote: 'Citation',
	Code: 'Code',
	Insert: 'Insérer',
	'Insert table': 'Insérer un tableau',
	'Decrease Indent': 'Diminuer le retrait',
	'Increase Indent': 'Retrait plus',
	'Select Special Character': 'Sélectionnez un caractère spécial',
	'Insert Special Character': 'Insérer un caractère spécial',
	'Paint format': 'Cloner le format',
	'Change mode': 'Mode wysiwyg <-> code html',
	Margins: 'Marges',
	top: 'haut',
	right: 'droite',
	bottom: 'Bas',
	left: 'gauche',
	Styles: 'Styles',
	Classes: 'Classes',
	Align: 'Alignement',
	Right: 'Droite',
	Center: 'Centre',
	Left: 'Gauche',
	'--Not Set--': '--Non disponible--',
	Src: 'Source',
	Title: 'Titre',
	Alternative: 'Alternative',
	Filter: 'Filtre',
	Link: 'Lien',
	'Open link in new tab': 'Ouvrir le lien dans un nouvel onglet',
	Image: 'Image',
	file: 'fichier',
	Advanced: 'Avancé',
	'Image properties': "Propriétés de l'image",
	Cancel: 'Annuler',
	Ok: 'OK',
	'Your code is similar to HTML. Keep as HTML?':
		'Votre texte que vous essayez de coller est similaire au HTML. Collez-le en HTML?',
	'Paste as HTML': 'Coller en HTML?',
	Keep: "Sauvegarder l'original",
	Clean: 'Nettoyer',
	'Insert as Text': 'Coller en tant que texte',
	'Word Paste Detected': "C'est peut-être un fragment de Word ou Excel",
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		"Le contenu que vous insérez provient d'un document Microsoft Word / Excel. Voulez-vous enregistrer le format ou l'effacer?",
	'Insert only Text': 'Coller le texte seulement',
	'File Browser': 'Explorateur de fichiers',
	'Error on load list': 'Erreur de liste de chargement',
	'Error on load folders': 'Erreur de dossier de chargement',
	'Are you sure?': 'Etes-vous sûrs ?',
	'Enter Directory name': 'Entrer le non de dossier',
	'Create directory': 'Créer un dossier',
	'type name': 'type de fichier',
	'Drop image': 'Coller une image',
	'Drop file': 'Déposer un fichier',
	'or click': 'ou cliquer',
	'Alternative text': 'Texte de remplacemement',
	Browse: 'Chercher',
	Upload: 'Charger',
	Background: 'Arrière-plan',
	Text: 'Texte',
	Top: 'Haut',
	Middle: 'Milieu',
	Bottom: 'Bas',
	'Insert column before': 'Insérer une colonne avant',
	'Insert column after': 'Insérer une colonne après',
	'Insert row above': 'Insérer une ligne en dessus',
	'Insert row below': 'Insérer une ligne en dessous',
	'Delete table': 'Supprimer le tableau',
	'Delete row': 'Supprimer la ligne',
	'Delete column': 'Supprimer la colonne',
	'Empty cell': 'Vider la cellule',
	'Chars: %d': 'Symboles: %d',
	'Words: %d': 'Mots: %d',
	Split: 'Split',
	'Split vertical': 'Split vertical',
	'Split horizontal': 'Split horizontal',
	'Strike through': 'Frapper à travers',
	Underline: 'Souligner',
	superscript: 'exposant',
	subscript: 'indice',
	'Cut selection': 'Couper la sélection',
	'Select all': 'Tout sélectionner',
	Break: 'Pause',
	'Search for': 'Rechercher',
	'Replace with': 'Remplacer par',
	Replace: 'Remplacer',
	Paste: 'Coller',
	'Choose Content to Paste': 'Choisissez le contenu à coller',
	source: 'la source',
	bold: 'graisseux',
	italic: 'italique',
	brush: 'verser',
	link: 'lien',
	undo: 'abolir',
	redo: 'prêt',
	table: 'graphique',
	image: 'Image',
	eraser: 'la gommen',
	paragraph: 'clause',
	fontsize: 'taille de police',
	video: 'Video',
	font: 'police',
	about: "à propos de l'éditeur",
	print: 'impression',
	symbol: 'caractère',
	underline: 'souligné',
	strikethrough: 'barré',
	indent: 'indentation',
	outdent: 'indifférent',
	fullsize: 'taille réelle',
	shrink: 'taille conventionnelle',
	copyformat: 'Format de copie',
	hr: 'la ligne',
	ul: 'Liste des',
	ol: 'Liste numérotée',
	cut: 'Couper',
	selectall: 'Sélectionner tout',
	'Open link': 'Ouvrir le lien',
	'Edit link': 'Modifier le lien',
	'No follow': 'Attribut Nofollow',
	Unlink: 'Supprimer le lien',
	Eye: 'Voir',
	pencil: 'Pour éditer',
	' URL': 'URL',
	Reset: 'Restaurer',
	Save: 'Sauvegarder',
	'Save as ...': 'Enregistrer sous',
	Resize: 'Changer la taille',
	Crop: 'Taille de garniture',
	Width: 'Largeur',
	Height: 'Hauteur',
	'Keep Aspect Ratio': 'Garder les proportions',
	Yes: 'Oui',
	No: 'Non',
	Remove: 'Supprimer',
	Select: 'Mettre en évidence',
	'Select %s': 'Mettre en évidence: %s',
	Update: 'Mettre à jour',
	'Vertical align': 'Alignement vertical',
	Merge: 'aller',
	'Add column': 'Ajouter une colonne',
	'Add row': 'Ajouter une rangée',
	Delete: 'Effacer',
	'Horizontal align': 'Alignement horizontal',
	'Sort by changed': 'Trier par modifié',
	'Sort by name': 'Trier par nom',
	'Sort by size': 'Classer par taille',
	'Add folder': 'Ajouter le dossier',
	'You can only edit your own images. Download this image on the host?':
		"Vous ne pouvez éditer que vos propres images. Téléchargez cette image sur l'hôte?",
	'The image has been successfully uploaded to the host!':
		"L'image a été téléchargée avec succès sur le serveur!null",
	palette: 'Palette',
	'There are no files': "Il n'y a aucun fichier dans ce répertoire.",
	Rename: 'renommer',
	'Enter new name': 'Entrez un nouveau nom',
	preview: 'Aperçu',
	download: 'Télécharger',
	'Paste from clipboard': 'Coller à partir du presse-papiers',
	"Your browser doesn't support direct access to the clipboard.":
		"Votre navigateur ne prend pas en charge l'accès direct à la presse-papiers.",
	'Copy selection': 'Copier la sélection',
	copy: 'copie',
	'Border radius': 'Rayon des frontières',
	'Show all': 'Afficher tous les',
	Apply: 'Appliquer',
	'Please fill out this field': 'Veuillez remplir ce champ',
	'Please enter a web address': 'Veuillez entrer une adresse web',
	Default: 'Par défaut',
	Circle: 'Cercle',
	Dot: 'Dot',
	Quadrate: 'Quadrate',
	Find: 'Trouver',
	'Find Previous': 'Trouvez Précédente',
	'Find Next': 'Suivant',
	'Insert className': 'Insérer un nom de classe'
};


/***/ }),
/* 221 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'הקלד משהו...',
	Advanced: 'מתקדם',
	'About Jodit': 'About Jodit',
	'Jodit Editor': 'Jodit Editor',
	"Jodit User's Guide": "Jodit User's Guide",
	'contains detailed help for using': 'contains detailed help for using.',
	'For information about the license, please go to our website:':
		'For information about the license, please go to our website:',
	'Buy full version': 'Buy full version',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.',
	Anchor: 'מקום עיגון',
	'Open in new tab': 'פתח בכרטיסיה חדשה',
	'Open editor in fullsize': 'פתח את העורך בחלון חדש',
	'Clear Formatting': 'נקה עיצוב',
	'Fill color or set the text color': 'שנה צבע טקסט או רקע',
	Redo: 'בצע שוב',
	Undo: 'בטל',
	Bold: 'מודגש',
	Italic: 'נטוי',
	'Insert Unordered List': 'הכנס רשימת תבליטים',
	'Insert Ordered List': 'הכנס רשימה ממוספרת',
	'Align Center': 'מרכז',
	'Align Justify': 'ישר ',
	'Align Left': 'ישר לשמאל',
	'Align Right': 'ישר לימין',
	'Insert Horizontal Line': 'הכנס קו אופקי',
	'Insert Image': 'הכנס תמונה',
	'Insert file': 'הכנס קובץ',
	'Insert youtube/vimeo video': 'הכנס סרטון וידאו מYouTube/Vimeo',
	'Insert link': 'הכנס קישור',
	'Font size': 'גודל גופן',
	'Font family': 'גופן',
	'Insert format block': 'מעוצב מראש',
	Normal: 'רגיל',
	'Heading 1': 'כותרת 1',
	'Heading 2': 'כותרת 2',
	'Heading 3': 'כותרת 3',
	'Heading 4': 'כותרת 4',
	Quote: 'ציטוט',
	Code: 'קוד',
	Insert: 'הכנס',
	'Insert table': 'הכנס טבלה',
	'Decrease Indent': 'הקטן כניסה',
	'Increase Indent': 'הגדל כניסה',
	'Select Special Character': 'בחר תו מיוחד',
	'Insert Special Character': 'הכנס תו מיוחד',
	'Paint format': 'העתק עיצוב',
	'Change mode': 'החלף מצב',
	Margins: 'ריווח',
	top: 'עליון',
	right: 'ימין',
	bottom: 'תחתון',
	left: 'שמאל',
	Styles: 'עיצוב CSS',
	Classes: 'מחלקת CSS',
	Align: 'יישור',
	Right: 'ימין',
	Center: 'מרכז',
	Left: 'שמאל',
	'--Not Set--': '--לא נקבע--',
	Src: 'מקור',
	Title: 'כותרת',
	Alternative: 'כיתוב חלופי',
	Link: 'קישור',
	'Open link in new tab': 'פתח בכרטיסיה חדשה',
	Image: 'תמונה',
	file: 'קובץ',
	Advansed: 'מתקדם',
	'Image properties': 'מאפייני תמונה',
	Cancel: 'ביטול',
	Ok: 'אישור',
	'Your code is similar to HTML. Keep as HTML?':
		'הקוד דומה לHTML, האם להשאיר כHTML',
	'Paste as HTML': 'הדבק כHTML',
	Keep: 'השאר',
	Clean: 'נקה',
	'Insert as Text': 'הכנס כטקסט',
	'Word Paste Detected': 'זוהתה הדבקה מ"וורד"',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'התוכן המודבק מגיע ממסמך וורד/אקסל. האם ברצונך להשאיר את העיצוב או לנקותו',
	'Insert only Text': 'הכנס טקסט בלבד',
	'File Browser': 'סייר הקבצים',
	'Error on load list': 'שגיאה  בזמן טעינת רשימה',
	'Error on load folders': 'שגיאה בזמן טעינת תקיות',
	'Are you sure?': 'האם אתה בטוח?',
	'Enter Directory name': 'הכנס שם תקיה',
	'Create directory': 'צור תקיה',
	'type name': 'סוג הקובץ',
	'Drop image': 'הסר תמונה',
	'Drop file': 'הסר קובץ',
	'or click': 'או לחץ',
	'Alternative text': 'כיתוב חלופי',
	Browse: 'סייר',
	Upload: 'העלה',
	Background: 'רקע',
	Text: 'טקסט',
	Top: 'עליון',
	Middle: 'מרכז',
	Bottom: 'תחתון',
	'Insert column before': 'הכנס עמודה לפני',
	'Insert column after': 'הכנס עמודה אחרי',
	'Insert row above': 'הכנס שורה מעל',
	'Insert row below': 'הכנס שורה מתחת',
	'Delete table': 'מחק טבלה',
	'Delete row': 'מחק שורה',
	'Delete column': 'מחק עמודה',
	'Empty cell': 'רוקן תא',
	Delete: 'מחק',
	'Strike through': 'קו חוצה',
	Underline: 'קו תחתון',
	Break: 'שבירת שורה',
	'Search for': 'חפש',
	'Replace with': 'החלף ב',
	Replace: 'להחליף',
	Edit: 'ערוך',
	'Vertical align': 'יישור אנכי',
	'Horizontal align': 'יישור אופקי',
	Filter: 'סנן',
	'Sort by changed': 'מין לפי שינוי',
	'Sort by name': 'מיין לפי שם',
	'Sort by size': 'מיין לפי גודל',
	'Add folder': 'הוסף תקייה',
	Split: 'פיצול',
	'Split vertical': 'פיצול אנכי',
	'Split horizontal': 'פיצול אופקי',
	Merge: 'מזג',
	'Add column': 'הוסף עמודה',
	'Add row': 'הוסף שורה',
	Border: 'מסגרת',
	'Embed code': 'הוסף קוד',
	Update: 'עדכן',
	superscript: 'superscript',
	subscript: 'subscript',
	'Cut selection': 'גזור בחירה',
	Paste: 'הדבק',
	'Choose Content to Paste': 'בחר תוכן להדבקה',
	'Chars: %d': 'תווים: %d',
	'Words: %d': 'מילים: %d',
	All: 'הכל',
	'Select %s': 'נבחר: %s',
	'Select all': 'בחר הכל',
	source: 'HTML',
	bold: 'מודגש',
	italic: 'נטוי',
	brush: 'מברשת',
	link: 'קישור',
	undo: 'בטל',
	redo: 'בצע שוב',
	table: 'טבלה',
	image: 'תמונה',
	eraser: 'מחק',
	paragraph: 'פסקה',
	fontsize: 'גודל גופן',
	video: 'וידאו',
	font: 'גופן',
	about: 'עלינו',
	print: 'הדפס',
	symbol: 'תו מיוחד',
	underline: 'קו תחתון',
	strikethrough: 'קו חוצה',
	indent: 'הגדל כניסה',
	outdent: 'הקטן כניסה',
	fullsize: 'גודל מלא',
	shrink: 'כווץ',
	copyformat: 'העתק עיצוב',
	hr: 'קו אופקי',
	ul: 'רשימת תבליטים',
	ol: 'רשימה ממוספרת',
	cut: 'חתוך',
	selectall: 'בחר הכל',
	'Open link': 'פתח קישור',
	'Edit link': 'ערוך קישור',
	'No follow': 'ללא מעקב',
	Unlink: 'בטל קישור',
	Eye: 'הצג',
	pencil: 'כדי לערוך',
	' URL': 'כתובת',
	Reset: 'אפס',
	Save: 'שמור',
	'Save as ...': 'שמור בשם...',
	Resize: 'שנה גודל',
	Crop: 'חתוך',
	Width: 'רוחב',
	Height: 'גובה',
	'Keep Aspect Ratio': 'שמור יחס',
	Yes: 'כן',
	No: 'לא',
	Remove: 'הסר',
	Select: 'בחר',
	'You can only edit your own images. Download this image on the host?':
		'רק קבצים המשוייכים שלך ניתנים לעריכה. האם להוריד את הקובץ?',
	'The image has been successfully uploaded to the host!':
		'התמונה עלתה בהצלחה!',
	palette: 'לוח',
	'There are no files': 'אין קבצים בספריה זו.',
	Rename: 'הונגרית',
	'Enter new name': 'הזן שם חדש',
	preview: 'תצוגה מקדימה',
	download: 'הורד',
	'Paste from clipboard': 'להדביק מהלוח',
	"Your browser doesn't support direct access to the clipboard.":
		'הדפדפן שלך לא תומך גישה ישירה ללוח.',
	'Copy selection': 'העתק בחירה',
	copy: 'העתק',
	'Border radius': 'רדיוס הגבול',
	'Show all': 'הצג את כל',
	Apply: 'החל',
	'Please fill out this field': 'נא למלא שדה זה',
	'Please enter a web address': 'אנא הזן כתובת אינטרנט',
	Default: 'ברירת המחדל',
	Circle: 'מעגל',
	Dot: 'נקודה',
	Quadrate: 'הריבוע הזה',
	Find: 'למצוא',
	'Find Previous': 'מצא את הקודם',
	'Find Next': 'חפש את הבא',
	'Insert className': 'הכנס את שם הכיתה'
};


/***/ }),
/* 222 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Írjon be valamit',
	Advanced: 'Haladó',
	'About Jodit': 'Joditról',
	'Jodit Editor': 'Jodit Editor',
	'Free Non-commercial Version': 'Ingyenes változat',
	"Jodit User's Guide": 'Jodit útmutató',
	'contains detailed help for using': 'további segítséget tartalmaz',
	'For information about the license, please go to our website:':
		'További licence információkért látogassa meg a weboldalunkat:',
	'Buy full version': 'Teljes verzió megvásárlása',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. Minden jog fenntartva.',
	Anchor: 'Horgony',
	'Open in new tab': 'Megnyitás új lapon',
	'Open editor in fullsize': 'Megnyitás teljes méretben',
	'Clear Formatting': 'Formázás törlése',
	'Fill color or set the text color': 'Háttér/szöveg szín',
	Redo: 'Újra',
	Undo: 'Visszavon',
	Bold: 'Félkövér',
	Italic: 'Dőlt',
	'Insert Unordered List': 'Pontozott lista',
	'Insert Ordered List': 'Számozott lista',
	'Align Center': 'Középre zárt',
	'Align Justify': 'Sorkizárt',
	'Align Left': 'Balra zárt',
	'Align Right': 'Jobbra zárt',
	'Insert Horizontal Line': 'Vízszintes vonal beszúrása',
	'Insert Image': 'Kép beszúrás',
	'Insert file': 'Fájl beszúrás',
	'Insert youtube/vimeo video': 'Youtube videó beszúrása',
	'Insert link': 'Link beszúrás',
	'Font size': 'Betűméret',
	'Font family': 'Betűtípus',
	'Insert format block': 'Formázott blokk beszúrása',
	Normal: 'Normál',
	'Heading 1': 'Fejléc 1',
	'Heading 2': 'Fejléc 2',
	'Heading 3': 'Fejléc 3',
	'Heading 4': 'Fejléc 4',
	Quote: 'Idézet',
	Code: 'Kód',
	Insert: 'Beszúr',
	'Insert table': 'Táblázat beszúrása',
	'Decrease Indent': 'Behúzás csökkentése',
	'Increase Indent': 'Behúzás növelése',
	'Select Special Character': 'Speciális karakter kiválasztása',
	'Insert Special Character': 'Speciális karakter beszúrása',
	'Paint format': 'Kép formázása',
	'Change mode': 'Nézet váltása',
	Print: 'Nyomtatás',
	Margins: 'Szegélyek',
	top: 'felső',
	right: 'jobb',
	bottom: 'alsó',
	left: 'bal',
	Styles: 'CSS stílusok',
	Classes: 'CSS osztályok',
	Align: 'Igazítás',
	Right: 'Jobbra',
	Center: 'Középre',
	Left: 'Balra',
	'--Not Set--': 'Nincs',
	Src: 'Forrás',
	Title: 'Cím',
	Alternative: 'Helyettesítő szöveg',
	Link: 'Link',
	'Open link in new tab': 'Link megnyitása új lapon',
	Image: 'Kép',
	file: 'Fájl',
	Advansed: 'További beállítás',
	'Image properties': 'Kép tulajdonságai',
	Cancel: 'Mégsem',
	Ok: 'OK',
	'Your code is similar to HTML. Keep as HTML?':
		'A beillesztett szöveg HTML-nek tűnik. Megtartsuk HTML-ként?',
	'Paste as HTML': 'Beszúrás HTML-ként',
	Keep: 'Megtartás',
	Clean: 'Elvetés',
	'Insert as Text': 'Beszúrás szövegként',
	'Word Paste Detected': 'Word-ből másolt szöveg',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'A beillesztett tartalom Microsoft Word/Excel dokumentumból származik. Meg szeretné tartani a formátumát?',
	'Insert only Text': 'Csak szöveg beillesztése',
	'File Browser': 'Fájl tallózó',
	'Error on load list': 'Hiba a lista betöltése közben',
	'Error on load folders': 'Hiba a mappák betöltése közben',
	'Are you sure?': 'Biztosan ezt szeretné?',
	'Enter Directory name': 'Írjon be egy mappanevet',
	'Create directory': 'Mappa létrehozása',
	'type name': 'írjon be bevet',
	'Drop image': 'Húzza ide a képet',
	'Drop file': 'Húzza ide a fájlt',
	'or click': 'vagy kattintson',
	'Alternative text': 'Helyettesítő szöveg',
	Browse: 'Tallóz',
	Upload: 'Feltölt',
	Background: 'Háttér',
	Text: 'Szöveg',
	Top: 'Fent',
	Middle: 'Középen',
	Bottom: 'Lent',
	'Insert column before': 'Oszlop beszúrás elé',
	'Insert column after': 'Oszlop beszúrás utána',
	'Insert row above': 'Sor beszúrás fölé',
	'Insert row below': 'Sor beszúrás alá',
	'Delete table': 'Táblázat törlése',
	'Delete row': 'Sor törlése',
	'Delete column': 'Oszlop törlése',
	'Empty cell': 'Cella tartalmának törlése',
	Delete: 'Törlés',
	'Strike through': 'Áthúzott',
	Underline: 'Aláhúzott',
	Break: 'Szünet',
	'Search for': 'Keresés',
	'Replace with': 'Csere erre',
	Replace: 'Cserélje ki',
	Edit: 'Szerkeszt',
	'Vertical align': 'Függőleges igazítás',
	'Horizontal align': 'Vízszintes igazítás',
	Filter: 'Szűrő',
	'Sort by changed': 'Rendezés módosítás szerint',
	'Sort by name': 'Rendezés név szerint',
	'Sort by size': 'Rendezés méret szerint',
	'Add folder': 'Mappa hozzáadás',
	'Split vertical': 'Függőleges felosztás',
	'Split horizontal': 'Vízszintes felosztás',
	Merge: 'Összevonás',
	'Add column': 'Oszlop hozzáadás',
	'Add row': 'Sor hozzáadás',
	Border: 'Szegély',
	'Embed code': 'Beágyazott kód',
	Update: 'Frissít',
	superscript: 'Felső index',
	subscript: 'Alsó index',
	'Cut selection': 'Kivágás',
	Paste: 'Beillesztés',
	'Choose Content to Paste': 'Válasszon tartalmat a beillesztéshez',
	Split: 'Felosztás',
	'Chars: %d': 'Karakterek száma: %d',
	'Words: %d': 'Szavak száma: %d',
	All: 'Összes',
	'Select %s': 'Kijelöl: %s',
	'Select all': 'Összes kijelölése',
	source: 'HTML',
	bold: 'Félkövér',
	italic: 'Dőlt',
	brush: 'Ecset',
	link: 'Link',
	undo: 'Visszavon',
	redo: 'Újra',
	table: 'Táblázat',
	image: 'Kép',
	eraser: 'Törlés',
	paragraph: 'Paragráfus',
	fontsize: 'Betűméret',
	video: 'Videó',
	font: 'Betű',
	about: 'Rólunk',
	print: 'Nyomtat',
	symbol: 'Szimbólum',
	underline: 'Aláhúzott',
	strikethrough: 'Áthúzott',
	indent: 'Behúzás',
	outdent: 'Aussenseiter',
	fullsize: 'Teljes méret',
	shrink: 'Összenyom',
	copyformat: 'Formátum másolás',
	hr: 'Egyenes vonal',
	ul: 'Lista',
	ol: 'Számozott lista',
	cut: 'Kivág',
	selectall: 'Összes kijelölése',
	'Open link': 'Link megnyitása',
	'Edit link': 'Link szerkesztése',
	'No follow': 'Nincs követés',
	Unlink: 'Link leválasztása',
	Eye: 'felülvizsgálat',
	pencil: 'Szerkesztés',
	' URL': 'URL',
	Reset: 'Visszaállít',
	Save: 'Mentés',
	'Save as ...': 'Mentés másként...',
	Resize: 'Átméretezés',
	Crop: 'Kivág',
	Width: 'Szélesség',
	Height: 'Magasság',
	'Keep Aspect Ratio': 'Képarány megtartása',
	Yes: 'Igen',
	No: 'Nem',
	Remove: 'Eltávolít',
	Select: 'Kijelöl',
	'You can only edit your own images. Download this image on the host?':
		'Csak a saját képeit tudja szerkeszteni. Letölti ezt a képet?',
	'The image has been successfully uploaded to the host!':
		'Kép sikeresen feltöltve!',
	palette: 'Palette',
	'There are no files': 'Er zijn geen bestanden in deze map.',
	Rename: 'átnevezés',
	'Enter new name': 'Adja meg az új nevet',
	preview: 'előnézet',
	download: 'Letöltés',
	'Paste from clipboard': 'Illessze be a vágólap',
	"Your browser doesn't support direct access to the clipboard.":
		'A böngésző nem támogatja a közvetlen hozzáférést biztosít a vágólapra.',
	'Copy selection': 'Másolás kiválasztása',
	copy: 'másolás',
	'Border radius': 'Határ sugár',
	'Show all': 'Összes',
	Apply: 'Alkalmazni',
	'Please fill out this field': 'Kérjük, töltse ki ezt a mezőt,',
	'Please enter a web address': 'Kérjük, írja be a webcímet',
	Default: 'Alapértelmezett',
	Circle: 'Kör',
	Dot: 'Pont',
	Quadrate: 'Quadrate',
	Find: 'Találni',
	'Find Previous': 'Megtalálja Előző',
	'Find Next': 'Következő Keresése',
	'Insert className': 'Helyezze be az osztály nevét'
};


/***/ }),
/* 223 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Ketik sesuatu',
	'About Jodit': 'Tentang Jodit',
	'Jodit Editor': 'Editor Jodit',
	'Free Non-commercial Version': 'Versi Bebas Non-komersil',
	"Jodit User's Guide": 'Panduan Pengguna Jodit',
	'contains detailed help for using': 'mencakup detail bantuan penggunaan',
	'For information about the license, please go to our website:':
		'Untuk informasi tentang lisensi, silakan kunjungi website:',
	'Buy full version': 'Beli versi lengkap',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Hak Cipta © XDSoft.net - Chupurnov Valeriy. Hak cipta dilindungi undang-undang.',
	Anchor: 'Tautan',
	'Open in new tab': 'Buka di tab baru',
	'Open editor in fullsize': 'Buka editor dalam ukuran penuh',
	'Clear Formatting': 'Hapus Pemformatan',
	'Fill color or set the text color': 'Isi warna atau atur warna teks',
	Redo: 'Ulangi',
	Undo: 'Batalkan',
	Bold: 'Tebal',
	Italic: 'Miring',
	'Insert Unordered List': 'Sisipkan Daftar Tidak Berurut',
	'Insert Ordered List': 'Sisipkan Daftar Berurut',
	'Align Center': 'Tengah',
	'Align Justify': 'Penuh',
	'Align Left': 'Kiri',
	'Align Right': 'Kanan',
	'Insert Horizontal Line': 'Sisipkan Garis Horizontal',
	'Insert Image': 'Sisipkan Gambar',
	'Insert file': 'Sisipkan Berkas',
	'Insert youtube/vimeo video': 'Sisipkan video youtube/vimeo',
	'Insert link': 'Sisipkan tautan',
	'Font size': 'Ukuran font',
	'Font family': 'Keluarga font',
	'Insert format block': 'Sisipkan blok format',
	Normal: 'Normal',
	'Heading 1': 'Heading 1',
	'Heading 2': 'Heading 2',
	'Heading 3': 'Heading 3',
	'Heading 4': 'Heading 4',
	Quote: 'Kutip',
	Code: 'Kode',
	Insert: 'Sisipkan',
	'Insert table': 'Sisipkan tabel',
	'Decrease Indent': 'Kurangi Indentasi',
	'Increase Indent': 'Tambah Indentasi',
	'Select Special Character': 'Pilih Karakter Spesial',
	'Insert Special Character': 'Sisipkan Karakter Spesial',
	'Paint format': 'Formar warna',
	'Change mode': 'Ubah mode',
	Margins: 'Batas',
	top: 'atas',
	right: 'kanan',
	bottom: 'bawah',
	left: 'kiri',
	Styles: 'Gaya',
	Classes: 'Class',
	Align: 'Rata',
	Right: 'Kanan',
	Center: 'Tengah',
	Left: 'Kiri',
	'--Not Set--': '--Tidak diset--',
	Src: 'Src',
	Title: 'Judul',
	Alternative: 'Teks alternatif',
	Link: 'Tautan',
	'Open link in new tab': 'Buka tautan di tab baru',
	Image: 'Gambar',
	file: 'berkas',
	Advanced: 'Lanjutan',
	'Image properties': 'Properti gambar',
	Cancel: 'Batal',
	Ok: 'Ya',
	'Your code is similar to HTML. Keep as HTML?':
		'Kode Anda cenderung ke HTML. Biarkan sebagai HTML?',
	'Paste as HTML': 'Paste sebagai HTML',
	Keep: 'Jaga',
	Clean: 'Bersih',
	'Insert as Text': 'Sisipkan sebagai teks',
	'Insert only Text': 'Sisipkan hanya teks',
	'Word Paste Detected': 'Terdeteksi paste dari Word',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'Konten dipaste dari dokumen Microsoft Word/Excel. Apakah Anda ingin tetap menjaga format atau membersihkannya?',
	'File Browser': 'Penjelajah Berkas',
	'Error on load list': 'Error ketika memuat list',
	'Error on load folders': 'Error ketika memuat folder',
	'Are you sure?': 'Apakah Anda yakin?',
	'Enter Directory name': 'Masukkan nama Direktori',
	'Create directory': 'Buat direktori',
	'type name': 'ketik nama',
	'Drop image': 'Letakkan gambar',
	'Drop file': 'Letakkan berkas',
	'or click': 'atau klik',
	'Alternative text': 'Teks alternatif',
	Browse: 'Jelajahi',
	Upload: 'Unggah',
	Background: 'Latar Belakang',
	Text: 'Teks',
	Top: 'Atas',
	Middle: 'Tengah',
	Bottom: 'Bawah',
	'Insert column before': 'Sisipkan kolom sebelumnya',
	'Insert column after': 'Sisipkan kolom setelahnya',
	'Insert row above': 'Sisipkan baris di atasnya',
	'Insert row below': 'Sisipkan baris di bawahnya',
	'Delete table': 'Hapus tabel',
	'Delete row': 'Hapus baris',
	'Delete column': 'Hapus kolom',
	'Empty cell': 'Kosongkan cell',
	source: 'sumber',
	bold: 'tebal',
	italic: 'miring',
	brush: 'sikat',
	link: 'tautan',
	undo: 'batalkan',
	redo: 'ulangi',
	table: 'tabel',
	image: 'gambar',
	eraser: 'penghapus',
	paragraph: 'paragraf',
	fontsize: 'ukuran font',
	video: 'video',
	font: 'font',
	about: 'tentang',
	print: 'cetak',
	symbol: 'simbol',
	underline: 'garis bawah',
	strikethrough: 'coret',
	indent: 'menjorok ke dalam',
	outdent: 'menjorok ke luar',
	fullsize: 'ukuran penuh',
	shrink: 'menyusut',
	copyformat: 'salin format',
	hr: 'hr',
	ul: 'ul',
	ol: 'ol',
	cut: 'potong',
	selectall: 'Pilih semua',
	'Embed code': 'Kode embed',
	'Open link': 'Buka tautan',
	'Edit link': 'Edit tautan',
	'No follow': 'No follow',
	Unlink: 'Hapus tautan',
	Eye: 'Mata',
	pencil: 'pensil',
	Update: 'Perbarui',
	' URL': 'URL',
	Edit: 'Edit',
	'Horizontal align': 'Perataan horizontal',
	Filter: 'Filter',
	'Sort by changed': 'Urutkan berdasarkan perubahan',
	'Sort by name': 'Urutkan berdasarkan nama',
	'Sort by size': 'Urutkan berdasarkan ukuran',
	'Add folder': 'Tambah folder',
	Reset: 'Reset',
	Save: 'Simpan',
	'Save as ...': 'Simpan sebagai...',
	Resize: 'Ubah ukuran',
	Crop: 'Crop',
	Width: 'Lebar',
	Height: 'Tinggi',
	'Keep Aspect Ratio': 'Jaga aspek rasio',
	Yes: 'Ya',
	No: 'Tidak',
	Remove: 'Copot',
	Select: 'Pilih',
	'Chars: %d': 'Karakter: %d',
	'Words: %d': 'Kata: %d',
	All: 'Semua',
	'Select %s': 'Pilih %s',
	'Select all': 'Pilih semua',
	'Vertical align': 'Rata vertikal',
	Split: 'Bagi',
	'Split vertical': 'Bagi secara vertikal',
	'Split horizontal': 'Bagi secara horizontal',
	Merge: 'Gabungkan',
	'Add column': 'Tambah kolom',
	'Add row': 'tambah baris',
	Delete: 'Hapus',
	Border: 'Bingkai',
	'License: %s': 'Lisensi: %s',
	'Strike through': 'Coret',
	Underline: 'Garis Bawah',
	superscript: 'Superskrip',
	subscript: 'Subskrip',
	'Cut selection': 'Potong pilihan',
	Break: 'Berhenti',
	'Search for': 'Mencari',
	'Replace with': 'Ganti dengan',
	Replace: 'Mengganti',
	Paste: 'Paste',
	'Choose Content to Paste': 'Pilih konten untuk dipaste',
	'You can only edit your own images. Download this image on the host?':
		'Anda hanya dapat mengedit gambar Anda sendiri. Unduh gambar ini di host?',
	'The image has been successfully uploaded to the host!':
		'Gambar telah sukses diunggah ke host!',
	palette: 'palet',
	'There are no files': 'Tidak ada berkas',
	Rename: 'ganti nama',
	'Enter new name': 'Masukkan nama baru',
	preview: 'pratinjau',
	download: 'Unduh',
	'Paste from clipboard': 'Paste dari clipboard',
	"Your browser doesn't support direct access to the clipboard.":
		'Browser anda tidak mendukung akses langsung ke clipboard.',
	'Copy selection': 'Copy seleksi',
	copy: 'copy',
	'Border radius': 'Border radius',
	'Show all': 'Tampilkan semua',
	Apply: 'Menerapkan',
	'Please fill out this field': 'Silahkan mengisi kolom ini',
	'Please enter a web address': 'Silahkan masukkan alamat web',
	Default: 'Default',
	Circle: 'Lingkaran',
	Dot: 'Dot',
	Quadrate: 'Kuadrat',
	Find: 'Menemukan',
	'Find Previous': 'Menemukan Sebelumnya',
	'Find Next': 'Menemukan Berikutnya',
	'Insert className': 'Masukkan nama kelas'
};


/***/ }),
/* 224 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Scrivi qualcosa...',
	Advanced: 'Avanzato',
	'About Jodit': 'A proposito di Jodit',
	'Jodit Editor': 'Jodit Editor',
	"Jodit User's Guide": 'Guida utente di Jodit',
	'contains detailed help for using':
		"contiene una guida dettagliata per l'uso.",
	'For information about the license, please go to our website:':
		'Per informazioni sulla licenza, si prega di visitare il nostro sito:',
	'Buy full version': 'Acquista la versione completa',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. Alle Rechte vorbehalten.',
	Anchor: 'Ancora',
	'Open in new tab': 'Apri in una nuova scheda',
	'Open editor in fullsize': "Apri l'editor a schermo intero",
	'Clear Formatting': 'Formato chiaro',
	'Fill color or set the text color': 'Riempi colore o lettera',
	Redo: 'Ripristina',
	Undo: 'Annulla',
	Bold: 'Grassetto',
	Italic: 'Corsivo',
	'Insert Unordered List': 'Inserisci lista non ordinata',
	'Insert Ordered List': "Inserisci l'elenco ordinato",
	'Align Center': 'Allinea Centra',
	'Align Justify': 'Allineare Giustificato',
	'Align Left': 'Allinea a Sinistra',
	'Align Right': 'Allinea a Destra',
	'Insert Horizontal Line': 'Inserisci la linea orizzontale',
	'Insert Image': 'Inserisci immagine',
	'Insert file': 'Inserisci un file',
	'Insert youtube/vimeo video': 'Inserisci video Youtube/Vimeo',
	'Insert link': 'Inserisci il link',
	'Font size': 'Dimensione del carattere',
	'Font family': 'Tipo di font',
	'Insert format block': 'Inserisci blocco',
	Normal: 'Normale',
	'Heading 1': 'Heading 1',
	'Heading 2': 'Heading 2',
	'Heading 3': 'Heading 3',
	'Heading 4': 'Heading 4',
	Quote: 'Citazione',
	Code: 'Codice',
	Insert: 'Inserisci',
	'Insert table': 'Inserisci tabella',
	'Decrease Indent': 'Riduci il rientro',
	'Increase Indent': 'Aumenta il rientro',
	'Select Special Character': 'Seleziona una funzione speciale',
	'Insert Special Character': 'Inserisci un carattere speciale',
	'Paint format': 'Copia formato',
	'Change mode': 'Cambia modo',
	Margins: 'Margini',
	top: 'su',
	right: 'destra',
	bottom: 'giù',
	left: 'sinistra',
	Styles: 'Stili CSS',
	Classes: 'Classi CSS',
	Align: 'Allinea',
	Right: 'Destra',
	Center: 'Centro',
	Left: 'Sinistra',
	'--Not Set--': '--Non Impostato--',
	Src: 'Fonte',
	Title: 'Titolo',
	Alternative: 'Testo Alternativo',
	Link: 'Link',
	'Open link in new tab': 'Apri il link in una nuova scheda',
	Image: 'Immagine',
	file: 'Archivio',
	Advansed: 'Avanzato',
	'Image properties': "Proprietà dell'immagine",
	Cancel: 'Annulla',
	Ok: 'Accetta',
	'Your code is similar to HTML. Keep as HTML?':
		"Il codice è simile all'HTML. Mantieni come HTML?",
	'Paste as HTML': 'Incolla come HTML?',
	Keep: 'Mantieni',
	Clean: 'Pulisci',
	'Insert as Text': 'Inserisci come testo',
	'Word Paste Detected': 'Incollato da Word rilevato',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'Il contenuto incollato proviene da un documento Microsoft Word / Excel. Vuoi mantenere il formato o pulirlo?',
	'Insert only Text': 'Inserisci solo il testo',
	'File Browser': 'Cerca il file',
	'Error on load list': "Errore durante il caricamento dell'elenco",
	'Error on load folders': 'Errore durante il caricamento delle cartelle',
	'Are you sure?': 'Sei sicuro?',
	'Enter Directory name': 'Inserisci il nome della cartella',
	'Create directory': 'Crea cartella',
	'type name': 'Entre el nombre',
	'Drop image': "Rilascia l'immagine",
	'Drop file': 'Rilascia file',
	'or click': 'o click',
	'Alternative text': 'Testo alternativo',
	Browse: 'Sfoglia',
	Upload: 'Carica',
	Background: 'Sfondo',
	Text: 'Testo',
	Top: 'Su',
	Middle: 'Centro',
	Bottom: 'Sotto',
	'Insert column before': 'Inserisci prima la colonna',
	'Insert column after': 'Inserisci colonna dopo',
	'Insert row above': 'Inserisci la riga sopra',
	'Insert row below': 'Inserisci la riga sotto',
	'Delete table': 'Elimina tabella',
	'Delete row': 'Elimina riga',
	'Delete column': 'Elimina colonna',
	'Empty cell': 'Cella vuota',
	Delete: 'Cancella',
	'Strike through': 'Barrato',
	Underline: 'Sottolineato',
	Break: 'Pausa',
	'Search for': 'Cerca',
	'Replace with': 'Sostituisci con',
	Replace: 'Sostituire',
	Edit: 'Modifica',
	'Vertical align': 'Allineamento verticala',
	'Horizontal align': 'Allineamento orizzontale',
	Filter: 'Filtro',
	'Sort by changed': 'Ordina per data di modifica',
	'Sort by name': 'Ordina per nome',
	'Sort by size': 'Ordina per dimensione',
	'Add folder': 'Aggiungi cartella',
	Split: 'Dividere',
	'Split vertical': 'Dividere verticalmente',
	'Split horizontal': 'Diviso orizzontale',
	Merge: 'Fondi',
	'Add column': 'Aggiungi colonna',
	'Add row': 'Aggiungi riga',
	Border: 'Bordo',
	'Embed code': 'Includi codice',
	Update: 'Aggiornare',
	superscript: 'indice',
	subscript: 'deponente',
	'Cut selection': 'Taglia la selezione',
	Paste: 'Incolla',
	'Choose Content to Paste': 'Seleziona il contenuto da incollare',
	'Chars: %d': 'Caratteri: %d',
	'Words: %d': 'Parole: %d',
	All: 'Tutto',
	'Select %s': 'Seleziona: %s',
	'Select all': 'Seleziona tutto',
	source: 'HTML',
	bold: 'Grassetto',
	italic: 'Corsivo',
	brush: 'Pennello',
	link: 'Link',
	undo: 'Annulla',
	redo: 'Ripristina',
	table: 'Tabella',
	image: 'Immagine',
	eraser: 'Gomma',
	paragraph: 'Paragrafo',
	fontsize: 'Dimensione del carattere',
	video: 'Video',
	font: 'Font',
	about: 'Approposito di',
	print: 'Stampa',
	symbol: 'Simbolo',
	underline: 'Sottolineato',
	strikethrough: 'Barrato',
	indent: 'trattino',
	outdent: 'annulla rientro',
	fullsize: 'A grandezza normale',
	shrink: 'comprimere',
	copyformat: 'Copia il formato',
	hr: 'linea orizzontale',
	ul: 'lista non ordinata',
	ol: 'lista ordinata',
	cut: 'Taglia',
	selectall: 'Seleziona tutto',
	'Open link': 'Apri link',
	'Edit link': 'Modifica link',
	'No follow': 'Non seguire',
	Unlink: 'Togli link',
	Eye: 'Recensione',
	pencil: 'Per modificare',
	' URL': ' URL',
	Reset: 'Reset',
	Save: 'Salva',
	'Save as ...': 'Salva con nome...',
	Resize: 'Ridimensiona',
	Crop: 'Tagliare',
	Width: 'Larghezza',
	Height: 'Altezza',
	'Keep Aspect Ratio': 'Mantenere le proporzioni',
	Yes: 'Si',
	No: 'No',
	Remove: 'Rimuovere',
	Select: 'Seleziona',
	'You can only edit your own images. Download this image on the host?':
		'Puoi modificare solo le tue immagini. Scarica questa immagine sul server?',
	'The image has been successfully uploaded to the host!':
		"L'immagine è stata caricata con successo sul server!",
	palette: 'tavolozza',
	'There are no files': 'Non ci sono file in questa directory.',
	Rename: 'ungherese',
	'Enter new name': 'Inserisci un nuovo nome',
	preview: 'anteprima',
	download: 'Scaricare',
	'Paste from clipboard': 'Incolla dagli appunti',
	"Your browser doesn't support direct access to the clipboard.":
		"Il tuo browser non supporta l'accesso diretto agli appunti.",
	'Copy selection': 'Selezione di copia',
	copy: 'copia',
	'Border radius': 'Border radius',
	'Show all': 'Mostra tutti',
	Apply: 'Applicare',
	'Please fill out this field': 'Si prega di compilare questo campo',
	'Please enter a web address': 'Si prega di inserire un indirizzo web',
	Default: 'Di Default',
	Circle: 'Cerchio',
	Dot: 'Dot',
	Quadrate: 'Quadrate',
	Find: 'Trovare',
	'Find Previous': 'Trova Precedente',
	'Find Next': 'Trova Successivo',
	'Insert className': 'Inserisci il nome della classe'
};


/***/ }),
/* 225 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'なにかタイプしてください',
	Advanced: '高度な設定',
	'About Jodit': 'Joditについて',
	'Jodit Editor': 'Jodit Editor',
	"Jodit User's Guide": 'Jodit ユーザーズ・ガイド',
	'contains detailed help for using': '詳しい使い方',
	'For information about the license, please go to our website:':
		'ライセンス詳細についてはJodit Webサイトを確認ください：',
	'Buy full version': 'フルバージョンを購入',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.',
	Anchor: 'Anchor',
	'Open in new tab': '新しいタブで開く',
	'Open editor in fullsize': 'エディターのサイズ（フル/ノーマル）',
	'Clear Formatting': '書式をクリア',
	'Fill color or set the text color': 'テキストの色',
	Redo: 'やり直し',
	Undo: '元に戻す',
	Bold: '太字',
	Italic: '斜体',
	'Insert Unordered List': '箇条書き',
	'Insert Ordered List': '番号付きリスト',
	'Align Center': '中央揃え',
	'Align Justify': '両端揃え',
	'Align Left': '左揃え',
	'Align Right': '右揃え',
	'Insert Horizontal Line': '区切り線を挿入',
	'Insert Image': '画像を挿入',
	'Insert file': 'ファイルを挿入',
	'Insert youtube/vimeo video': 'Youtube/Vimeo 動画',
	'Insert link': 'リンクを挿入',
	'Font size': 'フォントサイズ',
	'Font family': 'フォント',
	'Insert format block': 'テキストのスタイル',
	Normal: '指定なし',
	'Heading 1': 'タイトル1',
	'Heading 2': 'タイトル2',
	'Heading 3': 'タイトル3',
	'Heading 4': 'タイトル4',
	Quote: '引用',
	Code: 'コード',
	Insert: '挿入',
	'Insert table': '表を挿入',
	'Decrease Indent': 'インデント減',
	'Increase Indent': 'インデント増',
	'Select Special Character': '特殊文字を選択',
	'Insert Special Character': '特殊文字を挿入',
	'Paint format': '書式を貼付け',
	'Change mode': '編集モード切替え',
	Margins: 'マージン',
	top: '上',
	right: '右',
	bottom: '下',
	left: '左',
	Styles: 'スタイル',
	Classes: 'クラス',
	Align: '配置',
	Right: '右寄せ',
	Center: '中央寄せ',
	Left: '左寄せ',
	'--Not Set--': '指定なし',
	Src: 'ソース',
	Title: 'タイトル',
	Alternative: '代替テキスト',
	Link: 'リンク',
	'Open link in new tab': '新しいタブで開く',
	Image: '画像',
	file: 'ファイル',
	Advansed: 'Advansed',
	'Image properties': '画像のプロパティー',
	Cancel: 'キャンセル',
	Ok: '確定',
	'Your code is similar to HTML. Keep as HTML?': 'HTMLコードを保持しますか？',
	'Paste as HTML': 'HTMLで貼付け',
	Keep: 'HTMLを保持',
	Clean: 'Clean',
	'Insert as Text': 'HTMLをテキストにする',
	'Word Paste Detected': 'Word Paste Detected',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?',
	'Insert only Text': 'テキストだけ',
	'File Browser': 'File Browser',
	'Error on load list': 'Error on load list',
	'Error on load folders': 'Error on load folders',
	'Are you sure?': 'Are you sure?',
	'Enter Directory name': 'Enter Directory name',
	'Create directory': 'Create directory',
	'type name': 'type name',
	'Drop image': 'ここに画像をドロップ',
	'Drop file': 'ここにファイルをドロップ',
	'or click': 'or クリック',
	'Alternative text': '代替テキスト',
	Browse: 'ブラウズ',
	Upload: 'アップロード',
	Background: '背景',
	Text: '文字',
	Top: '上',
	Middle: '中央',
	Bottom: '下',
	'Insert column before': '左に列を挿入',
	'Insert column after': '右に列を挿入',
	'Insert row above': '上に行を挿入',
	'Insert row below': '下に行を挿入',
	'Delete table': '表を削除',
	'Delete row': '行を削除',
	'Delete column': '列を削除',
	'Empty cell': 'セルを空にする',
	'Chars: %d': '文字数: %d',
	'Words: %d': '単語数: %d',
	'Strike through': '取り消し線',
	Underline: '下線',
	superscript: '上付き文字',
	subscript: '下付き文字',
	'Cut selection': '切り取り',
	'Select all': 'すべて選択',
	Break: 'Pause',
	'Search for': '検索',
	'Replace with': '置換',
	Replace: '交換',
	Paste: '貼付け',
	'Choose Content to Paste': '選択した内容を貼付け',
	All: '全部',
	source: 'source',
	bold: 'bold',
	italic: 'italic',
	brush: 'brush',
	link: 'link',
	undo: 'undo',
	redo: 'redo',
	table: 'table',
	image: 'image',
	eraser: 'eraser',
	paragraph: 'paragraph',
	fontsize: 'fontsize',
	video: 'video',
	font: 'font',
	about: 'about',
	print: 'print',
	symbol: 'symbol',
	underline: 'underline',
	strikethrough: 'strikethrough',
	indent: 'indent',
	outdent: 'outdent',
	fullsize: 'fullsize',
	shrink: 'shrink',
	copyformat: 'copyformat',
	hr: '分割線',
	ul: '箇条書き',
	ol: '番号付きリスト',
	cut: '切り取り',
	selectall: 'すべて選択',
	'Open link': 'リンクを開く',
	'Edit link': 'リンクを編集',
	'No follow': 'No follow',
	Unlink: 'リンク解除',
	Eye: 'サイトを確認',
	' URL': 'URL',
	Reset: 'リセット',
	Save: '保存',
	'Save as ...': 'Save as ...',
	Resize: 'リサイズ',
	Crop: 'Crop',
	Width: '幅',
	Height: '高さ',
	'Keep Aspect Ratio': '縦横比を保持',
	Yes: 'はい',
	No: 'いいえ',
	Remove: '移除',
	Select: '選択',
	'Select %s': '選択: %s',
	Update: '更新',
	'Vertical align': '垂直方向の配置',
	Merge: 'セルの結合',
	'Add column': '列を追加',
	'Add row': '行を追加',
	Border: '境界線',
	'Embed code': '埋め込みコード',
	Delete: '削除',
	Edit: '編集',
	'Horizontal align': '水平方向の配置',
	Filter: 'Filter',
	'Sort by changed': 'Sort by changed',
	'Sort by name': 'Sort by name',
	'Sort by size': 'Sort by size',
	'Add folder': 'Add folder',
	Split: '分割',
	'Split vertical': 'セルの分割（垂直方向）',
	'Split horizontal': 'セルの分割（水平方向）',
	'You can only edit your own images. Download this image on the host?':
		'You can only edit your own images. Download this image on the host?',
	'The image has been successfully uploaded to the host!':
		'The image has been successfully uploaded to the host!',
	palette: 'パレット',
	pencil: '鉛筆',
	'There are no files': 'There are no files',
	Rename: 'Rename',
	'Enter new name': 'Enter new name',
	preview: 'プレビュー',
	download: 'ダウンロード',
	'Paste from clipboard': '貼り付け',
	"Your browser doesn't support direct access to the clipboard.":
		'お使いのブラウザはクリップボードを使用できません',
	'Copy selection': 'コピー',
	copy: 'copy',
	'Border radius': '角の丸み',
	'Show all': '全て表示',
	Apply: '適用',
	'Please fill out this field': 'まだこの分野',
	'Please enter a web address': 'を入力してくださいウェブアドレス',
	Default: 'デフォルト',
	Circle: '白丸',
	Dot: '黒丸',
	Quadrate: '四角',
	Find: '見',
	'Find Previous': '探前',
	'Find Next': '由来',
	'Lower Alpha': '英小文字',
	'Lower Greek': 'ギリシャ文字',
	'Lower Roman': 'ローマ数字小文字',
	'Upper Alpha': '英大文字',
	'Upper Roman': 'ローマ数字大文字',
	'Insert className': 'クラス名を挿入'
};


/***/ }),
/* 226 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': '무엇이든 입력하세요',
	'About Jodit': 'Jodit에 대하여',
	'Jodit Editor': 'Jodit Editor',
	"Jodit User's Guide": 'Jodit 사용자 안내서',
	'contains detailed help for using': '자세한 도움말이 들어있어요',
	'For information about the license, please go to our website:':
		'라이센스에 관해서는 Jodit 웹 사이트를 방문해주세요：',
	'Buy full version': '풀 버전 구입하기',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'© XDSoft.net - Chupurnov Valeriy. 에게 저작권과 모든 권리가 있습니다.',
	Anchor: 'Anchor',
	'Open in new tab': '새 탭에서 열기',
	'Open editor in fullsize': '전체 크기로 보기',
	'Clear Formatting': '서식 지우기',
	'Fill color or set the text color': '글씨 색상',
	Redo: '재실행',
	Undo: '실행 취소',
	Bold: '굵게',
	Italic: '기울임',
	'Insert Unordered List': '글머리 목록',
	'Insert Ordered List': '번호 목록',
	'Align Center': '가운데 정렬',
	'Align Justify': '양쪽 정렬',
	'Align Left': '왼쪽 정렬',
	'Align Right': '오른쪽 정렬',
	'Insert Horizontal Line': '수평 구분선 넣기',
	'Insert Image': '이미지 넣기',
	'Insert file': '파일 넣기',
	'Insert youtube/vimeo video': 'Youtube/Vimeo 동영상',
	'Insert link': '링크 넣기',
	'Font size': '글꼴 크기',
	'Font family': '글꼴',
	'Insert format block': '블록 요소 넣기',
	Normal: '일반 텍스트',
	'Heading 1': '제목 1',
	'Heading 2': '제목 2',
	'Heading 3': '제목 3',
	'Heading 4': '제목 4',
	Quote: '인용',
	Code: '코드',
	Insert: '붙여 넣기',
	'Insert table': '테이블',
	'Decrease Indent': '들여쓰기 감소',
	'Increase Indent': '들여쓰기 증가',
	'Select Special Character': '특수문자 선택',
	'Insert Special Character': '특수문자 입력',
	'Paint format': '페인트 형식',
	'Change mode': '편집모드 변경',
	Margins: '마진',
	top: '위',
	right: '오른쪽',
	bottom: '아래',
	left: '왼쪽',
	Styles: '스타일',
	Classes: '클래스',
	Align: '정렬',
	Right: '오른쪽으로',
	Center: '가운데로',
	Left: '왼쪽으로',
	'--Not Set--': '--지정 안 함--',
	Src: '경로(src)',
	Title: '제목',
	Alternative: '대체 텍스트(alt)',
	Link: '링크',
	'Open link in new tab': '새 탭에서 열기',
	file: '파일',
	Advanced: '고급',
	'Image properties': '이미지 속성',
	Cancel: '취소',
	Ok: '확인',
	'Your code is similar to HTML. Keep as HTML?':
		'HTML 코드로 감지했어요. 코드인채로 붙여넣을까요?',
	'Paste as HTML': 'HTML로 붙여넣기',
	Keep: '원본 유지',
	Clean: '지우기',
	'Insert as Text': '텍스트로 넣기',
	'Insert only Text': '텍스트만 넣기',
	'Word Paste Detected': 'Word 붙여넣기 감지',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'Microsoft Word/Excel 문서로 감지했어요. 서식을 유지한채로 붙여넣을까요?',
	'File Browser': '파일 탐색기',
	'Error on load list': '목록 불러오기 에러',
	'Error on load folders': '폴더 불러오기',
	'Are you sure?': '정말 진행할까요?',
	'Enter Directory name': '디렉토리 이름 입력',
	'Create directory': '디렉토리 생성',
	'type name': '이름 입력',
	'Drop image': '이미지 드래그',
	'Drop file': '파일 드래그',
	'or click': '혹은 클릭',
	'Alternative text': '대체 텍스트',
	Browse: '탐색',
	Upload: '업로드',
	Background: '배경',
	Text: '텍스트',
	Top: '위',
	Middle: '중앙',
	Bottom: '아래',
	'Insert column before': '이전 열에 삽입',
	'Insert column after': '다음 열에 삽입',
	'Insert row above': '위 행에 삽입',
	'Insert row below': '아래 행에 삽입',
	'Delete table': '테이블 삭제',
	'Delete row': '행 삭제',
	'Delete column': '열 삭제',
	'Empty cell': '빈 셀',
	source: 'HTML 소스',
	bold: '볼드',
	italic: '이탤릭',
	brush: '브러시',
	link: '링크',
	undo: '실행 취소',
	redo: '재실행',
	table: '테이블',
	image: '이미지',
	eraser: '지우개',
	paragraph: '문단',
	fontsize: '글꼴 크기',
	video: '비디오',
	font: '글꼴',
	about: '편집기 정보',
	print: '프린트',
	symbol: '기호',
	underline: '밑줄',
	strikethrough: '취소선',
	indent: '들여쓰기',
	outdent: '내어쓰기',
	fullsize: '전체 화면',
	shrink: '일반 화면',
	copyformat: '복사 형식',
	hr: '구분선',
	ul: '글머리 목록',
	ol: '번호 목록',
	cut: '잘라내기',
	selectall: '모두 선택',
	'Embed code': 'Embed 코드',
	'Open link': '링크 열기',
	'Edit link': '링크 편집',
	'No follow': 'No follow',
	Unlink: '링크 제거',
	Eye: '사이트 확인',
	pencil: '연필',
	Update: '갱신',
	' URL': 'URL',
	Edit: '편집',
	'Horizontal align': '수평 정렬',
	Filter: '필터',
	'Sort by changed': '변경일 정렬',
	'Sort by name': '이름 정렬',
	'Sort by size': '크기 정렬',
	'Add folder': '새 폴더',
	Reset: '초기화',
	Save: '저장',
	'Save as ...': '새로 저장하기 ...',
	Resize: '리사이즈',
	Crop: '크롭',
	Width: '가로 길이',
	Height: '세로 높이',
	'Keep Aspect Ratio': '비율 유지하기',
	Yes: '네',
	No: '아니오',
	Remove: '제거',
	Select: '선택',
	'Chars: %d': '문자수: %d',
	'Words: %d': '단어수: %d',
	All: '모두',
	'Select all': '모두 선택',
	'Select %s': '선택: %s',
	'Vertical align': '수직 정렬',
	Split: '분할',
	'Split vertical': '세로 셀 분할',
	'Split horizontal': '가로 셀 분할',
	Merge: '셀 병합',
	'Add column': '열 추가',
	'Add row': '행 추가',
	Delete: '삭제',
	Border: '외곽선',
	'License: %s': '라이센스: %s',
	'Strike through': '취소선',
	Underline: '밑줄',
	superscript: '윗첨자',
	subscript: '아래첨자',
	'Cut selection': '선택 잘라내기',
	Break: '구분자',
	'Search for': '검색',
	'Replace with': '대체하기',
	Replace: '대체',
	Paste: '붙여넣기',
	'Choose Content to Paste': '붙여넣을 내용 선택',
	'You can only edit your own images. Download this image on the host?':
		'외부 이미지는 편집할 수 없어요. 외부 이미지를 다운로드 할까요?',
	'The image has been successfully uploaded to the host!':
		'이미지를 무사히 업로드 했어요!',
	palette: '팔레트',
	'There are no files': '파일이 없어요',
	Rename: '이름 변경',
	'Enter new name': '새 이름 입력',
	preview: '리미보기',
	download: '다운로드',
	'Paste from clipboard': '클립보드 붙여넣기',
	"Your browser doesn't support direct access to the clipboard.":
		'사용중인 브라우저가 클립보드 접근을 지원하지 않아요.',
	'Copy selection': '선택 복사',
	copy: '복사',
	'Border radius': '둥근 테두리',
	'Show all': '모두 보기',
	Apply: '적용',
	'Please fill out this field': '이 분야',
	'Please enter a web address': '를 입력하십시오.웹 주소',
	Default: '기본',
	Circle: '원',
	Dot: '점',
	Quadrate: '정방형',
	Find: '찾기',
	'Find Previous': '이전 찾기',
	'Find Next': '다음 찾기',
	'Insert className': '수업 이름 삽입'
};


/***/ }),
/* 227 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Begin met typen..',
	Advanced: 'Geavanceerd',
	'About Jodit': 'Over Jodit',
	'Jodit Editor': 'Jodit Editor',
	'Free Non-commercial Version': 'Gratis niet-commerciële versie',
	"Jodit User's Guide": 'Jodit gebruikershandleiding',
	'contains detailed help for using':
		'bevat gedetailleerde informatie voor gebruik.',
	'For information about the license, please go to our website:':
		'Voor informatie over de licentie, ga naar onze website:',
	'Buy full version': 'Volledige versie kopen',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. Alle rechten voorbehouden.',
	Anchor: 'Anker',
	'Open in new tab': 'Open in nieuwe tab',
	'Open editor in fullsize': 'Editor in volledig scherm openen',
	'Clear Formatting': 'Opmaak verwijderen',
	'Fill color or set the text color': 'Vulkleur of tekstkleur aanpassen',
	Redo: 'Opnieuw',
	Undo: 'Ongedaan maken',
	Bold: 'Vet',
	Italic: 'Cursief',
	'Insert Unordered List': 'Geordende list invoegen',
	'Insert Ordered List': 'Ongeordende lijst invoegen',
	'Align Center': 'Centreren',
	'Align Justify': 'Uitlijnen op volledige breedte',
	'Align Left': 'Links uitlijnen',
	'Align Right': 'Rechts uitlijnen',
	'Insert Horizontal Line': 'Horizontale lijn invoegen',
	'Insert Image': 'Afbeelding invoegen',
	'Insert file': 'Bestand invoegen',
	'Insert youtube/vimeo video': 'Youtube/Vimeo video invoegen',
	'Insert link': 'Link toevoegen',
	'Font size': 'Tekstgrootte',
	'Font family': 'Lettertype',
	'Insert format block': 'Format blok invoegen',
	Normal: 'Normaal',
	'Heading 1': 'Koptekst 1',
	'Heading 2': 'Koptekst 2',
	'Heading 3': 'Koptekst 3',
	'Heading 4': 'Koptekst 4',
	Quote: 'Citaat',
	Code: 'Code',
	Insert: 'Invoegen',
	'Insert table': 'Tabel invoegen',
	'Decrease Indent': 'Inspringing verkleinen',
	'Increase Indent': 'Inspringing vergroten',
	'Select Special Character': 'Symbool selecteren',
	'Insert Special Character': 'Symbool invoegen',
	'Paint format': 'Opmaak kopieren',
	'Change mode': 'Modus veranderen',
	Margins: 'Marges',
	top: 'Boven',
	right: 'Rechts',
	bottom: 'Onder',
	left: 'Links',
	Styles: 'CSS styles',
	Classes: 'CSS classes',
	Align: 'Uitlijning',
	Right: 'Rechts',
	Center: 'Gecentreerd',
	Left: 'Links',
	'--Not Set--': '--Leeg--',
	Src: 'Src',
	Title: 'Titel',
	Alternative: 'Alternatieve tekst',
	Link: 'Link',
	'Open link in new tab': 'Link in nieuwe tab openen',
	Image: 'Afbeelding',
	file: 'Bestand',
	Advansed: 'Geavanceerd',
	'Image properties': 'Afbeeldingseigenschappen',
	Cancel: 'Annuleren',
	Ok: 'OK',
	'Your code is similar to HTML. Keep as HTML?':
		'Deze code lijkt op HTML. Als HTML behouden?',
	'Paste as HTML': 'Invoegen als HTML',
	Keep: 'Origineel behouden',
	Clean: 'Opschonen',
	'Insert as Text': 'Als tekst invoegen',
	'Word Paste Detected': 'Word-tekst gedetecteerd',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'De geplakte tekst is afkomstig van een Microsoft Word/Excel document. Wil je de opmaak behouden of opschonen?',
	'Insert only Text': 'Als onopgemaakte tekst invoegen',
	'File Browser': 'Bestandsbrowser',
	'Error on load list': 'Fout bij het laden van de lijst',
	'Error on load folders': 'Fout bij het laden van de mappenlijst',
	'Are you sure?': 'Weet je het zeker?',
	'Enter Directory name': 'Geef de map een naam',
	'Create directory': 'Map aanmaken',
	'type name': 'Type naam',
	'Drop image': 'Sleep hier een afbeelding naartoe',
	'Drop file': 'Sleep hier een bestand naartoe',
	'or click': 'of klik',
	'Alternative text': 'Alternatieve tekst',
	Browse: 'Bladeren',
	Upload: 'Uploaden',
	Background: 'Achtergrond',
	Text: 'Tekst',
	Top: 'Boven',
	Middle: 'Midden',
	Bottom: 'Onder',
	'Insert column before': 'Kolom invoegen (voor)',
	'Insert column after': 'Kolom invoegen (na)',
	'Insert row above': 'Rij invoegen (boven)',
	'Insert row below': 'Rij invoegen (onder)',
	'Delete table': 'Tabel verwijderen',
	'Delete row': 'Rij verwijderen',
	'Delete column': 'Kolom verwijderen',
	'Empty cell': 'Cel leegmaken',
	Delete: 'Verwijderen',
	'Strike through': 'Doorstrepen',
	Underline: 'Onderstrepen',
	Break: 'Enter',
	'Search for': 'Zoek naar',
	'Replace with': 'Vervangen door',
	Replace: 'Vervangen',
	Edit: 'Bewerken',
	'Vertical align': 'Verticaal uitlijnen',
	'Horizontal align': 'Horizontaal uitlijnen',
	Filter: 'Filteren',
	'Sort by changed': 'Sorteren op wijzigingsdatum',
	'Sort by name': 'Sorteren op naam',
	'Sort by size': 'Sorteren op grootte',
	'Add folder': 'Map toevoegen',
	Split: 'Splitsen',
	'Split vertical': 'Verticaal splitsen',
	'Split horizontal': 'Horizontaal splitsen',
	Merge: 'Samenvoegen',
	'Add column': 'Kolom toevoegen',
	'Add row': 'Rij toevoegen',
	Border: 'Rand',
	'Embed code': 'Embed code',
	Update: 'Updaten',
	superscript: 'Superscript',
	subscript: 'Subscript',
	'Cut selection': 'Selectie knippen',
	Paste: 'Plakken',
	'Choose Content to Paste': 'Kies content om te plakken',
	'Chars: %d': 'Tekens: %d',
	'Words: %d': 'Woorden: %d',
	All: 'Alles',
	'Select %s': 'Selecteer: %s',
	'Select all': 'Selecteer alles',
	source: 'Broncode',
	bold: 'vet',
	italic: 'cursief',
	brush: 'kwast',
	link: 'link',
	undo: 'ongedaan maken',
	redo: 'opnieuw',
	table: 'tabel',
	image: 'afbeelding',
	eraser: 'gum',
	paragraph: 'paragraaf',
	fontsize: 'lettergrootte',
	video: 'video',
	font: 'lettertype',
	about: 'over',
	print: 'afdrukken',
	symbol: 'symbool',
	underline: 'onderstreept',
	strikethrough: 'doorgestreept',
	indent: 'inspringen',
	outdent: 'minder inspringen',
	fullsize: 'volledige grootte',
	shrink: 'kleiner maken',
	copyformat: 'opmaak kopiëren',
	hr: 'horizontale lijn',
	ul: 'lijst',
	ol: 'genummerde lijst',
	cut: 'knip',
	selectall: 'alles selecteren',
	'Open link': 'link openen',
	'Edit link': 'link aanpassen',
	'No follow': 'niet volgen',
	Unlink: 'link verwijderen',
	Eye: 'Recensie',
	pencil: 'Om te bewerken',
	' URL': ' URL',
	Reset: 'Herstellen',
	Save: 'Opslaan',
	'Save as ...': 'Opslaan als ...',
	Resize: 'Grootte aanpassen',
	Crop: 'Bijknippen',
	Width: 'Breedte',
	Height: 'Hoogte',
	'Keep Aspect Ratio': 'Verhouding behouden',
	Yes: 'Ja',
	No: 'Nee',
	Remove: 'Verwijderen',
	Select: 'Selecteren',
	'You can only edit your own images. Download this image on the host?':
		'Je kunt alleen je eigen afbeeldingen aanpassen. Deze afbeelding downloaden?',
	'The image has been successfully uploaded to the host!':
		'De afbeelding is succesvol geüploadet!',
	palette: 'Palette',
	'There are no files': 'Er zijn geen bestanden in deze map.',
	Rename: 'Hongaars',
	'Enter new name': 'Voer een nieuwe naam in',
	preview: 'voorvertoning',
	download: 'Download',
	'Paste from clipboard': 'Plakken van klembord',
	"Your browser doesn't support direct access to the clipboard.":
		'Uw browser ondersteunt geen directe toegang tot het klembord.',
	'Copy selection': 'Selectie kopiëren',
	copy: 'kopiëren',
	'Border radius': 'Border radius',
	'Show all': 'Toon alle',
	Apply: 'Toepassing',
	'Please fill out this field': 'Vul dit veld',
	'Please enter a web address': 'Voer een webadres',
	Default: 'Standaard',
	Circle: 'Cirkel',
	Dot: 'Dot',
	Quadrate: 'Quadrate',
	Find: 'Zoeken',
	'Find Previous': 'Vorige Zoeken',
	'Find Next': 'Volgende Zoeken',
	'Insert className': 'Voeg de klassenaam in'
};


/***/ }),
/* 228 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Napisz coś',
	Advanced: 'Zaawansowane',
	'About Jodit': 'O Jodit',
	'Jodit Editor': 'Edytor Jodit',
	"Jodit User's Guide": 'Instrukcja Jodit',
	'contains detailed help for using':
		'zawiera szczegółowe informacje dotyczące użytkowania.',
	'For information about the license, please go to our website:':
		'Odwiedź naszą stronę, aby uzyskać więcej informacji na temat licencji:',
	'Buy full version': 'Zakup pełnej wersji',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. Wszystkie prawa zastrzeżone.',
	Anchor: 'Kotwica',
	'Open in new tab': 'Otwórz w nowej zakładce',
	'Open editor in fullsize': 'Otwórz edytor w pełnym rozmiarze',
	'Clear Formatting': 'Wyczyść formatowanie',
	'Fill color or set the text color':
		'Kolor wypełnienia lub ustaw kolor tekstu',
	Redo: 'Ponów',
	Undo: 'Cofnij',
	Bold: 'Pogrubienie',
	Italic: 'Kursywa',
	'Insert Unordered List': 'Wstaw listę wypunktowaną',
	'Insert Ordered List': 'Wstaw listę numeryczną',
	'Align Center': 'Wyśrodkuj',
	'Align Justify': 'Wyjustuj',
	'Align Left': 'Wyrównaj do lewej',
	'Align Right': 'Wyrównaj do prawej',
	'Insert Horizontal Line': 'Wstaw linię poziomą',
	'Insert Image': 'Wstaw grafikę',
	'Insert file': 'Wstaw plik',
	'Insert youtube/vimeo video': 'Wstaw film Youtube/vimeo',
	'Insert link': 'Wstaw link',
	'Font size': 'Rozmiar tekstu',
	'Font family': 'Krój czcionki',
	'Insert format block': 'Wstaw formatowanie',
	Normal: 'Normalne',
	'Heading 1': 'Nagłówek 1',
	'Heading 2': 'Nagłówek 2',
	'Heading 3': 'Nagłówek 3',
	'Heading 4': 'Nagłówek 4',
	Quote: 'Cytat',
	Code: 'Kod',
	Insert: 'Wstaw',
	'Insert table': 'Wstaw tabelę',
	'Decrease Indent': 'Zmniejsz wcięcie',
	'Increase Indent': 'Zwiększ wcięcie',
	'Select Special Character': 'Wybierz znak specjalny',
	'Insert Special Character': 'Wstaw znak specjalny',
	'Paint format': 'Malarz formatów',
	'Change mode': 'Zmień tryb',
	Margins: 'Marginesy',
	top: 'Górny',
	right: 'Prawy',
	bottom: 'Dolny',
	left: 'Levy',
	Styles: 'Style CSS',
	Classes: 'Klasy CSS',
	Align: 'Wyrównanie',
	Right: 'Prawa',
	Center: 'środek',
	Left: 'Lewa',
	'--Not Set--': 'brak',
	Src: 'Źródło',
	Title: 'Tytuł',
	Alternative: 'Tekst alternatywny',
	Link: 'Link',
	'Open link in new tab': 'Otwórz w nowej zakładce',
	Image: 'Grafika',
	file: 'Plik',
	Advansed: 'Zaawansowne',
	'Image properties': 'Właściwości grafiki',
	Cancel: 'Anuluj',
	Ok: 'OK',
	'Your code is similar to HTML. Keep as HTML?':
		'Twój kod wygląda jak HTML. Zachować HTML?',
	'Paste as HTML': 'Wkleić jako HTML?',
	Keep: 'Oryginalny tekst',
	Clean: 'Wyczyść',
	'Insert as Text': 'Wstaw jako tekst',
	'Word Paste Detected': 'Wykryto tekst w formacie Word',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'Wklejany tekst pochodzi z dokumentu Microsoft Word/Excel. Chcesz zachować ten format czy wyczyścić go? ',
	'Insert only Text': 'Wstaw tylko treść',
	'File Browser': 'Przeglądarka plików',
	'Error on load list': 'Błąd ładowania listy plików',
	'Error on load folders': 'Błąd ładowania folderów',
	'Are you sure?': 'Czy jesteś pewien?',
	'Enter Directory name': 'Wprowadź nazwę folderu',
	'Create directory': 'Utwórz folder',
	'type name': 'wprowadź nazwę',
	'Drop image': 'Upuść plik graficzny',
	'Drop file': 'Upuść plik',
	'or click': 'lub kliknij tu',
	'Alternative text': 'Tekst alternatywny',
	Browse: 'Przeglądaj',
	Upload: 'Wczytaj',
	Background: 'Tło',
	Text: 'Treść',
	Top: 'Góra',
	Middle: 'Środek',
	Bottom: 'Dół',
	'Insert column before': 'Wstaw kolumnę przed',
	'Insert column after': 'Wstaw kolumnę po',
	'Insert row above': 'Wstaw wiersz przed',
	'Insert row below': 'Wstaw wiersz po',
	'Delete table': 'Usuń tabelę',
	'Delete row': 'Usuń wiersz',
	'Delete column': 'Usuń kolumnę',
	'Empty cell': 'Wyczyść komórkę',
	Delete: 'Usuń',
	'Strike through': 'Przekreślenie',
	Underline: 'Podkreślenie',
	Break: 'Przerwa',
	'Search for': 'Szukaj',
	'Replace with': 'Zamień na',
	Replace: 'Wymienić',
	Edit: 'Edytuj',
	'Vertical align': 'Wyrównywanie w pionie',
	'Horizontal align': 'Wyrównywanie w poziomie',
	Filter: 'Filtruj',
	'Sort by changed': 'Sortuj wg zmiany',
	'Sort by name': 'Sortuj wg nazwy',
	'Sort by size': 'Sortuj wg rozmiaru',
	'Add folder': 'Dodaj folder',
	'Split vertical': 'Podziel w pionie',
	'Split horizontal': 'Podziel w poziomie',
	Split: 'Podziel',
	Merge: 'Scal',
	'Add column': 'Dodaj kolumnę',
	'Add row': 'Dodaj wiersz',
	Border: 'Obramowanie',
	'Embed code': 'Wstaw kod',
	Update: 'Aktualizuj',
	superscript: 'indeks górny',
	subscript: 'index dolny',
	'Cut selection': 'Wytnij zaznaczenie',
	Paste: 'Wklej',
	'Choose Content to Paste': 'Wybierz zawartość do wklejenia',
	'Chars: %d': 'Znaki: %d',
	'Words: %d': 'Słowa: %d',
	All: 'Wszystko',
	'Select %s': 'Wybierz: %s',
	'Select all': 'Wybierz wszystko',
	source: 'HTML',
	bold: 'pogrubienie',
	italic: 'kursywa',
	brush: 'pędzel',
	link: 'link',
	undo: 'cofnij',
	redo: 'ponów',
	table: 'tabela',
	image: 'grafika',
	eraser: 'wyczyść',
	paragraph: 'akapit',
	fontsize: 'rozmiar czcionki',
	video: 'wideo',
	font: 'czcionka',
	about: 'O programie',
	print: 'drukuj',
	symbol: 'symbol',
	underline: 'podkreślenie',
	strikethrough: 'przekreślenie',
	indent: 'wcięcie',
	outdent: 'wycięcie',
	fullsize: 'pełen rozmiar',
	shrink: 'przytnij',
	copyformat: 'format kopii',
	hr: 'linia pozioma',
	ul: 'lista',
	ol: 'lista numerowana',
	cut: 'wytnij',
	selectall: 'zaznacz wszystko',
	'Open link': 'otwórz link',
	'Edit link': 'edytuj link',
	'No follow': 'Atrybut no-follow',
	Unlink: 'Usuń link',
	Eye: 'szukaj',
	pencil: 'edytuj',
	' URL': 'URL',
	Reset: 'wyczyść',
	Save: 'zapisz',
	'Save as ...': 'zapisz jako',
	Resize: 'Zmień rozmiar',
	Crop: 'Przytnij',
	Width: 'Szerokość',
	Height: 'Wysokość',
	'Keep Aspect Ratio': 'Zachowaj proporcje',
	Yes: 'Tak',
	No: 'Nie',
	Remove: 'Usuń',
	Select: 'Wybierz',
	'You can only edit your own images. Download this image on the host?':
		'Możesz edytować tylko swoje grafiki. Czy chcesz pobrać tą grafikę?',
	'The image has been successfully uploaded to the host!':
		'Grafika została pomyślnienie dodana na serwer',
	palette: 'Paleta',
	'There are no files': 'Brak plików.',
	Rename: 'zmień nazwę',
	'Enter new name': 'Wprowadź nową nazwę',
	preview: 'podgląd',
	download: 'pobierz',
	'Paste from clipboard': 'Wklej ze schowka',
	"Your browser doesn't support direct access to the clipboard.":
		'Twoja przeglądarka nie obsługuje schowka',
	'Copy selection': 'Kopiuj zaznaczenie',
	copy: 'kopiuj',
	'Border radius': 'Zaokrąglenie krawędzi',
	'Show all': 'Pokaż wszystkie',
	Apply: 'Zastosuj',
	'Please fill out this field': 'Proszę wypełnić to pole',
	'Please enter a web address': 'Proszę, wpisz adres sieci web',
	Default: 'Domyślnie',
	Circle: 'Koło',
	Dot: 'Punkt',
	Quadrate: 'Kwadrat',
	Find: 'Znaleźć',
	'Find Previous': 'Znaleźć Poprzednie',
	'Find Next': 'Znajdź Dalej',
	'Insert className': 'Wstaw nazwę zajęć'
};


/***/ }),
/* 229 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Escreva algo...',
	Advanced: 'Avançado',
	'About Jodit': 'Sobre o Jodit',
	'Jodit Editor': 'Editor Jodit',
	"Jodit User's Guide": 'Guia de usuário Jodit',
	'contains detailed help for using': 'contém ajuda detalhada para o uso.',
	'For information about the license, please go to our website:':
		'Para informação sobre a licença, por favor visite nosso site:',
	'Buy full version': 'Compre a versão completa',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. Todos os direitos reservados.',
	Anchor: 'Link',
	'Open in new tab': 'Abrir em nova aba',
	'Open editor in fullsize': 'Abrir editor em tela cheia',
	'Clear Formatting': 'Limpar formatação',
	'Fill color or set the text color': 'Cor de preenchimento ou cor do texto',
	Redo: 'Refazer',
	Undo: 'Desfazer',
	Bold: 'Negrito',
	Italic: 'Itálico',
	'Insert Unordered List': 'Inserir lista não ordenada',
	'Insert Ordered List': 'Inserir lista ordenada',
	'Align Center': 'Centralizar',
	'Align Justify': 'Justificar',
	'Align Left': 'Alinhar à Esquerda',
	'Align Right': 'Alinhar à Direita',
	'Insert Horizontal Line': 'Inserir linha horizontal',
	'Insert Image': 'Inserir imagem',
	'Insert file': 'Inserir arquivo',
	'Insert youtube/vimeo video': 'Inserir vídeo do Youtube/vimeo',
	'Insert link': 'Inserir link',
	'Font size': 'Tamanho da letra',
	'Font family': 'Fonte',
	'Insert format block': 'Inserir bloco',
	Normal: 'Normal',
	'Heading 1': 'Cabeçalho 1',
	'Heading 2': 'Cabeçalho 2',
	'Heading 3': 'Cabeçalho 3',
	'Heading 4': 'Cabeçalho 4',
	Quote: 'Citação',
	Code: 'Código',
	Insert: 'Inserir',
	'Insert table': 'Inserir tabela',
	'Decrease Indent': 'Diminuir recuo',
	'Increase Indent': 'Aumentar recuo',
	'Select Special Character': 'Selecionar caractere especial',
	'Insert Special Character': 'Inserir caractere especial',
	'Paint format': 'Copiar formato',
	'Change mode': 'Mudar modo',
	Margins: 'Margens',
	top: 'cima',
	right: 'direta',
	bottom: 'baixo',
	left: 'esquerda',
	Styles: 'Estilos CSS',
	Classes: 'Classes CSS',
	Align: 'Alinhamento',
	Right: 'Direita',
	Center: 'Centro',
	Left: 'Esquerda',
	'--Not Set--': '--Não Estabelecido--',
	Src: 'Fonte',
	Title: 'Título',
	Alternative: 'Texto Alternativo',
	Link: 'Link',
	'Open link in new tab': 'Abrir link em nova aba',
	Image: 'Imagem',
	file: 'Arquivo',
	Advansed: 'Avançado',
	'Image properties': 'Propriedades da imagem',
	Cancel: 'Cancelar',
	Ok: 'Ok',
	'Your code is similar to HTML. Keep as HTML?':
		'Seu código é similar ao HTML. Manter como HTML?',
	'Paste as HTML': 'Colar como HTML?',
	Keep: 'Manter',
	Clean: 'Limpar',
	'Insert as Text': 'Inserir como Texto',
	'Word Paste Detected': 'Colado do Word Detectado',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'O conteúdo colado veio de um documento Microsoft Word/Excel. Você deseja manter o formato ou limpa-lo?',
	'Insert only Text': 'Inserir somente o Texto',
	'File Browser': 'Procurar arquivo',
	'Error on load list': 'Erro ao carregar a lista',
	'Error on load folders': 'Erro ao carregar as pastas',
	'Are you sure?': 'Você tem certeza?',
	'Enter Directory name': 'Escreva o nome da pasta',
	'Create directory': 'Criar pasta',
	'type name': 'Escreva seu nome',
	'Drop image': 'Soltar imagem',
	'Drop file': 'Soltar arquivo',
	'or click': 'ou clique',
	'Alternative text': 'Texto alternativo',
	Browse: 'Explorar',
	Upload: 'Upload',
	Background: 'Fundo',
	Text: 'Texto',
	Top: 'Cima',
	Middle: 'Meio',
	Bottom: 'Baixo',
	'Insert column before': 'Inserir coluna antes',
	'Insert column after': 'Inserir coluna depois',
	'Insert row above': 'Inserir linha acima',
	'Insert row below': 'Inserir linha abaixo',
	'Delete table': 'Excluir tabela',
	'Delete row': 'Excluir linha',
	'Delete column': 'Excluir coluna',
	'Empty cell': 'Limpar célula',
	Delete: 'Excluir',
	'Strike through': 'Tachado',
	Underline: 'Sublinhar',
	Break: 'Pausa',
	'Search for': 'Procurar por',
	'Replace with': 'Substituir com',
	Replace: 'Substituir',
	Edit: 'Editar',
	'Vertical align': 'Alinhamento vertical',
	'Horizontal align': 'Alinhamento horizontal',
	Filter: 'filtrar',
	'Sort by changed': 'Ordenar por modificação',
	'Sort by name': 'Ordenar por nome',
	'Sort by size': 'Ordenar por tamanho',
	'Add folder': 'Adicionar pasta',
	Split: 'Dividir',
	'Split vertical': 'Dividir vertical',
	'Split horizontal': 'Dividir horizontal',
	Merge: 'Mesclar',
	'Add column': 'Adicionar coluna',
	'Add row': 'Adicionar linha',
	Border: 'Borda',
	'Embed code': 'Incluir código',
	Update: 'Atualizar',
	superscript: 'sobrescrito',
	subscript: 'subscrito',
	'Cut selection': 'Cortar seleção',
	Paste: 'Colar',
	'Choose Content to Paste': 'Escolher conteúdo para colar',
	'Chars: %d': 'Caracteres: %d',
	'Words: %d': 'Palavras: %d',
	All: 'Tudo',
	'Select %s': 'Selecionar: %s',
	'Select all': 'Selecionar tudo',
	source: 'HTML',
	bold: 'negrito',
	italic: 'itálico',
	brush: 'pincel',
	link: 'link',
	undo: 'desfazer',
	redo: 'refazer',
	table: 'tabela',
	image: 'imagem',
	eraser: 'apagar',
	paragraph: 'parágrafo',
	fontsize: 'tamanho da letra',
	video: 'vídeo',
	font: 'fonte',
	about: 'Sobre de',
	print: 'Imprimir',
	symbol: 'Símbolo',
	underline: 'sublinhar',
	strikethrough: 'tachado',
	indent: 'recuar',
	outdent: 'diminuir recuo',
	fullsize: 'Tamanho completo',
	shrink: 'diminuir',
	copyformat: 'Copiar formato',
	hr: 'linha horizontal',
	ul: 'lista não ordenada',
	ol: 'lista ordenada',
	cut: 'Cortar',
	selectall: 'Selecionar tudo',
	'Open link': 'Abrir link',
	'Edit link': 'Editar link',
	'No follow': 'Não siga',
	Unlink: 'Remover link',
	Eye: 'Visualizar',
	pencil: 'Editar',
	' URL': 'URL',
	Reset: 'Resetar',
	Save: 'Salvar',
	'Save as ...': 'Salvar como...',
	Resize: 'Redimensionar',
	Crop: 'Recortar',
	Width: 'Largura',
	Height: 'Altura',
	'Keep Aspect Ratio': 'Manter a proporção',
	Yes: 'Sim',
	No: 'Não',
	Remove: 'Remover',
	Select: 'Selecionar',
	'You can only edit your own images. Download this image on the host?':
		'Você só pode editar suas próprias imagens. Baixar essa imagem pro servidor?',
	'The image has been successfully uploaded to the host!':
		'A imagem foi enviada com sucesso para o servidor!',
	palette: 'Palette',
	'There are no files': 'Não há arquivos nesse diretório.',
	Rename: 'Húngara',
	'Enter new name': 'Digite um novo nome',
	preview: 'preview',
	download: 'Baixar',
	'Paste from clipboard': 'Colar da área de transferência',
	"Your browser doesn't support direct access to the clipboard.":
		'O seu navegador não oferece suporte a acesso direto para a área de transferência.',
	'Copy selection': 'Selecção de cópia',
	copy: 'cópia',
	'Border radius': 'Border radius',
	'Show all': 'Mostrar todos os',
	Apply: 'Aplicar',
	'Please fill out this field': 'Por favor, preencha este campo',
	'Please enter a web address': 'Por favor introduza um endereço web',
	Default: 'Padrão',
	Circle: 'Círculo',
	Dot: 'Ponto',
	Quadrate: 'Quadro',
	//Ordered list
	'Lower Alpha': 'Letra Minúscula',
	'Lower Greek': 'Grego Minúscula',
	'Lower Roman': 'Romano Minúscula',
	'Upper Alpha': 'Letra Maiúscula',
	'Upper Roman': 'Romano Maiúscula',
	Find: 'Encontrar',
	'Find Previous': 'Encontrar Anteriores',
	'Find Next': 'Localizar Próxima',
	'Insert className': 'Insira o nome da classe'
};


/***/ }),
/* 230 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Напишите что-либо',
	'About Jodit': 'О Jodit',
	'Jodit Editor': 'Редактор Jodit',
	"Jodit User's Guide": 'Jodit Руководство пользователя',
	'contains detailed help for using':
		'содержит детальную информацию по использованию',
	'For information about the license, please go to our website:':
		'Для получения сведений о лицензии , пожалуйста, перейдите на наш сайт:',
	'Buy full version': 'Купить полную версию',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Авторские права © XDSoft.net - Чупурнов Валерий. Все права защищены.',
	Anchor: 'Анкор',
	'Open in new tab': 'Открывать ссылку в новой вкладке',
	'Open editor in fullsize': 'Открыть редактор в полном размере',
	'Clear Formatting': 'Очистить форматирование',
	'Fill color or set the text color': 'Цвет заливки или цвет текста',
	Redo: 'Повтор',
	Undo: 'Отмена',
	Bold: 'Жирный',
	Italic: 'Наклонный',
	'Insert Unordered List': 'Вставка маркированного списка',
	'Insert Ordered List': 'Вставить нумерованный список',
	'Align Center': 'Выровнять по центру',
	'Align Justify': 'Выровнять по ширине',
	'Align Left': 'Выровнять по левому краю',
	'Align Right': 'Выровнять по правому краю',
	'Insert Horizontal Line': 'Вставить горизонтальную линию',
	'Insert Image': 'Вставить изображение',
	'Insert file': 'Вставить файл',
	'Insert youtube/vimeo video': 'Вставьте видео',
	'Insert link': 'Вставить ссылку',
	'Font size': 'Размер шрифта',
	'Font family': 'Шрифт',
	'Insert format block': 'Вставить блочный элемент',
	Normal: 'Нормальный текст',
	'Heading 1': 'Заголовок 1',
	'Heading 2': 'Заголовок 2',
	'Heading 3': 'Заголовок 3',
	'Heading 4': 'Заголовок 4',
	Quote: 'Цитата',
	Code: 'Код',
	Insert: 'Вставить',
	'Insert table': 'Вставить таблицу',
	'Decrease Indent': 'Уменьшить отступ',
	'Increase Indent': 'Увеличить отступ',
	'Select Special Character': 'Выберите специальный символ',
	'Insert Special Character': 'Вставить специальный символ',
	'Paint format': 'Формат краски',
	'Change mode': 'Источник',
	Margins: 'Отступы',
	top: 'сверху',
	right: 'справа',
	bottom: 'снизу',
	left: 'слева',
	Styles: 'Стили',
	Classes: 'Классы',
	Align: 'Выравнивание',
	Right: 'По правому краю',
	Center: 'По центру',
	Left: 'По левому краю',
	'--Not Set--': '--не устанавливать--',
	Src: 'src',
	Title: 'Заголовок',
	Alternative: 'Альтернативный текст (alt)',
	Link: 'Ссылка',
	'Open link in new tab': 'Открывать ссылку в новом окне',
	file: 'Файл',
	Advanced: 'Расширенные',
	'Image properties': 'Свойства изображения',
	Cancel: 'Отмена',
	Ok: 'Ок',
	'Your code is similar to HTML. Keep as HTML?':
		'Ваш текст, который вы пытаетесь вставить похож на HTML. Вставить его как HTML?',
	'Paste as HTML': 'Вставить как HTML?',
	Keep: 'Сохранить оригинал',
	Clean: 'Почистить',
	'Insert as Text': 'Вставить как текст',
	'Insert only Text': 'Вставить только текст',
	'Word Paste Detected': 'Возможно это фрагмент Word или Excel',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'Контент который вы вставляете поступает из документа Microsoft Word / Excel. Вы хотите сохранить формат или очистить его?',
	'File Browser': 'Браузер файлов',
	'Error on load list': 'Ошибка при загрузке списка изображений',
	'Error on load folders': 'Ошибка при загрузке списка директорий',
	'Are you sure?': 'Вы уверены?',
	'Enter Directory name': 'Введите название директории',
	'Create directory': 'Создать директорию',
	'type name': 'введите название',
	'Drop image': 'Перетащите сюда изображение',
	'Drop file': 'Перетащите сюда файл',
	'or click': 'или нажмите',
	'Alternative text': 'Альтернативный текст',
	Browse: 'Сервер',
	Upload: 'Загрузка',
	Background: 'Фон',
	Text: 'Текст',
	Top: ' К верху',
	Middle: 'По середине',
	Bottom: 'К низу',
	'Insert column before': 'Вставить столбец до',
	'Insert column after': 'Вставить столбец после',
	'Insert row above': 'Вставить ряд выше',
	'Insert row below': 'Вставить ряд ниже',
	'Delete table': 'Удалить таблицу',
	'Delete row': 'Удалять ряд',
	'Delete column': 'Удалить столбец',
	'Empty cell': 'Очистить ячейку',
	source: 'HTML',
	bold: 'жирный',
	italic: 'курсив',
	brush: 'заливка',
	link: 'ссылка',
	undo: 'отменить',
	redo: 'повторить',
	table: 'таблица',
	image: 'Изображение',
	eraser: 'очистить',
	paragraph: 'параграф',
	fontsize: 'размер шрифта',
	video: 'видео',
	font: 'шрифт',
	about: 'о редакторе',
	print: 'печать',
	symbol: 'символ',
	underline: 'подчеркнутый',
	strikethrough: 'перечеркнутый',
	indent: 'отступ',
	outdent: 'выступ',
	fullsize: 'во весь экран',
	shrink: 'обычный размер',
	copyformat: 'Копировать формат',
	hr: 'линия',
	ul: 'Список',
	ol: 'Нумерованный список',
	cut: 'Вырезать',
	selectall: 'Выделить все',
	'Embed code': 'Код',
	'Open link': 'Открыть ссылку',
	'Edit link': 'Редактировать ссылку',
	'No follow': 'Атрибут nofollow',
	Unlink: 'Убрать ссылку',
	Eye: 'Просмотр',
	pencil: 'Редактировать',
	Update: 'Обновить',
	' URL': 'URL',
	Edit: 'Редактировать',
	'Horizontal align': 'Горизонтальное выравнивание',
	Filter: 'Фильтр',
	'Sort by changed': 'По изменению',
	'Sort by name': 'По имени',
	'Sort by size': 'По размеру',
	'Add folder': 'Добавить папку',
	Reset: 'Восстановить',
	Save: 'Сохранить',
	'Save as ...': 'Сохранить как',
	Resize: 'Изменить размер',
	Crop: 'Обрезать размер',
	Width: 'Ширина',
	Height: 'Высота',
	'Keep Aspect Ratio': 'Сохранять пропорции',
	Yes: 'Да',
	No: 'Нет',
	Remove: 'Удалить',
	Select: 'Выделить',
	'Chars: %d': 'Символов: %d',
	'Words: %d': 'Слов: %d',
	All: 'Выделить все',
	'Select %s': 'Выделить: %s',
	'Select all': 'Выделить все',
	'Vertical align': 'Вертикальное выравнивание',
	Split: 'Разделить',
	'Split vertical': 'Разделить по вертикали',
	'Split horizontal': 'Разделить по горизонтали',
	Merge: 'Объединить в одну',
	'Add column': 'Добавить столбец',
	'Add row': 'Добавить строку',
	Delete: 'Удалить',
	Border: 'Рамка',
	'License: %s': 'Лицензия: %s',
	'Strike through': 'Перечеркнуть',
	Underline: 'Подчеркивание',
	superscript: 'верхний индекс',
	subscript: 'индекс',
	'Cut selection': 'Вырезать',
	Break: 'Разделитель',
	'Search for': 'Найти',
	'Replace with': 'Заменить на',
	Replace: 'Заменить',
	Paste: 'Вставить',
	'Choose Content to Paste': 'Выбрать контент для вставки',
	'You can only edit your own images. Download this image on the host?':
		'Вы можете редактировать только свои собственные изображения. Загрузить это изображение на ваш сервер?',
	'The image has been successfully uploaded to the host!':
		'Изображение успешно загружено на сервер!',
	palette: 'палитра',
	'There are no files': 'В данном каталоге нет файлов',
	Rename: 'Переименовать',
	'Enter new name': 'Введите новое имя',
	preview: 'Предпросмотр',
	download: 'Скачать',
	'Paste from clipboard': 'Вставить из буфера обмена',
	"Your browser doesn't support direct access to the clipboard.":
		'Ваш браузер не поддерживает прямой доступ к буферу обмена.',
	'Copy selection': 'Скопировать выделенное',
	copy: 'копия',
	'Border radius': 'Радиус границы',
	'Show all': 'Показать все',
	Apply: 'Применить',
	'Please fill out this field': 'Пожалуйста, заполните это поле',
	'Please enter a web address': 'Пожалуйста, введите веб-адрес',
	Default: 'По умолчанию',
	Circle: 'Круг',
	Dot: 'Точка',
	Quadrate: 'Квадрат',
	Find: 'Найти',
	'Find Previous': 'Найти Предыдущие',
	'Find Next': 'Найти Далее',
	'Insert className': 'Вставить название класса'
};


/***/ }),
/* 231 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': 'Bir şeyler yaz',
	Advanced: 'Gelişmiş',
	'About Jodit': 'Jodit Hakkında',
	'Jodit Editor': 'Jodit Editor',
	"Jodit User's Guide": 'Jodit Kullanım Kılavuzu',
	'contains detailed help for using': 'kullanım için detaylı bilgiler içerir',
	'For information about the license, please go to our website:':
		'Lisans hakkında bilgi için lütfen web sitemize gidin:',
	'Buy full version': 'Tam versiyonunu satın al',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. Tüm hakları saklıdır.',
	Anchor: 'Bağlantı',
	'Open in new tab': 'Yeni sekmede aç',
	'Open editor in fullsize': 'Editörü tam ekranda aç',
	'Clear Formatting': 'Stili temizle',
	'Fill color or set the text color': 'Renk doldur veya yazı rengi seç',
	Redo: 'Yinele',
	Undo: 'Geri Al',
	Bold: 'Kalın',
	Italic: 'İtalik',
	'Insert Unordered List': 'Sırasız Liste Ekle',
	'Insert Ordered List': 'Sıralı Liste Ekle',
	'Align Center': 'Ortala',
	'Align Justify': 'Kenarlara Yasla',
	'Align Left': 'Sola Yasla',
	'Align Right': 'Sağa Yasla',
	'Insert Horizontal Line': 'Yatay Çizgi Ekle',
	'Insert Image': 'Resim Ekle',
	'Insert file': 'Dosya Ekle',
	'Insert youtube/vimeo video': 'Youtube/Vimeo Videosu Ekle',
	'Insert link': 'Bağlantı Ekle',
	'Font size': 'Font Boyutu',
	'Font family': 'Font Ailesi',
	'Insert format block': 'Blok Ekle',
	Normal: 'Normal',
	'Heading 1': 'Başlık 1',
	'Heading 2': 'Başlık 2',
	'Heading 3': 'Başlık 3',
	'Heading 4': 'Başlık 4',
	Quote: 'Alıntı',
	Code: 'Kod',
	Insert: 'Ekle',
	'Insert table': 'Tablo Ekle',
	'Decrease Indent': 'Girintiyi Azalt',
	'Increase Indent': 'Girintiyi Arttır',
	'Select Special Character': 'Özel Karakter Seç',
	'Insert Special Character': 'Özel Karakter Ekle',
	'Paint format': 'Resim Biçimi',
	'Change mode': 'Mod Değiştir',
	Margins: 'Boşluklar',
	top: 'Üst',
	right: 'Sağ',
	bottom: 'Alt',
	left: 'Sol',
	Styles: 'CSS Stilleri',
	Classes: 'CSS Sınıfları',
	Align: 'Hizalama',
	Right: 'Sağ',
	Center: 'Ortalı',
	Left: 'Sol',
	'--Not Set--': 'Belirsiz',
	Src: 'Kaynak',
	Title: 'Başlık',
	Alternative: 'Alternatif Yazı',
	Link: 'Link',
	'Open link in new tab': 'Bağlantıyı yeni sekmede aç',
	Image: 'Resim',
	file: 'Dosya',
	Advansed: 'Gelişmiş',
	'Image properties': 'Resim özellikleri',
	Cancel: 'İptal',
	Ok: 'Tamam',
	'Your code is similar to HTML. Keep as HTML?':
		'Kodunuz HTML koduna benziyor. HTML olarak devam etmek ister misiniz?',
	'Paste as HTML': 'HTML olarak yapıştır',
	Keep: 'Sakla',
	Clean: 'Temizle',
	'Insert as Text': 'Yazı olarak ekle',
	'Word Paste Detected': 'Word biçiminde yapıştırma algılandı',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'Der Inhalt, den Sie einfügen, stammt aus einem Microsoft Word / Excel-Dokument. Möchten Sie das Format erhalten oder löschen?',
	'Insert only Text': 'Sadece yazıyı ekle',
	'File Browser': 'Dosya Listeleyici',
	'Error on load list': 'Liste yüklenirken hata oluştu',
	'Error on load folders': 'Klasörler yüklenirken hata oluştur',
	'Are you sure?': 'Emin misiniz?',
	'Enter Directory name': 'Dizin yolu giriniz',
	'Create directory': 'Dizin oluştur',
	'type name': 'İsim yaz',
	'Drop image': 'Resim bırak',
	'Drop file': 'Dosya bırak',
	'or click': 'veya tıkla',
	'Alternative text': 'Alternatif yazı',
	Browse: 'Gözat',
	Upload: 'Yükle',
	Background: 'Arka plan',
	Text: 'Yazı',
	Top: 'Üst',
	Middle: 'Orta',
	Bottom: 'Aşağı',
	'Insert column before': 'Öncesine kolon ekle',
	'Insert column after': 'Sonrasına kolon ekle',
	'Insert row above': 'Üstüne satır ekle',
	'Insert row below': 'Altına satır ekle',
	'Delete table': 'Tabloyu sil',
	'Delete row': 'Satırı sil',
	'Delete column': 'Kolonu sil',
	'Empty cell': 'Hücreyi temizle',
	Delete: 'Sil',
	'Strike through': 'Üstü çizili',
	Underline: 'Alt çizgi',
	Break: 'Satır sonu',
	'Search for': 'Ara',
	'Replace with': 'Şununla değiştir',
	Replace: 'Değiştir',
	Edit: 'Düzenle',
	'Vertical align': 'Dikey hizala',
	'Horizontal align': 'Yatay hizala',
	Filter: 'Filtre',
	'Sort by changed': 'Değişime göre sırala',
	'Sort by name': 'İsme göre sırala',
	'Sort by size': 'Boyuta göre sırala',
	'Add folder': 'Klasör ekle',
	Split: 'Ayır',
	'Split vertical': 'Dikey ayır',
	'Split horizontal': 'Yatay ayır',
	Merge: 'Birleştir',
	'Add column': 'Kolon ekle',
	'Add row': 'Satır ekle',
	Border: 'Kenarlık',
	'Embed code': 'Kod ekle',
	Update: 'Güncelle',
	superscript: 'Üst yazı',
	subscript: 'Alt yazı',
	'Cut selection': 'Seçilimi kes',
	Paste: 'Yapıştır',
	'Choose Content to Paste': 'Yapıştırılacak içerik seç',
	'Chars: %d': 'Harfler: %d',
	'Words: %d': 'Kelimeler: %d',
	All: 'Tümü',
	'Select %s': 'Seç: %s',
	'Select all': 'Tümünü seç',
	source: 'Kaynak',
	bold: 'Kalın',
	italic: 'italik',
	brush: 'Fırça',
	link: 'Bağlantı',
	undo: 'Geri al',
	redo: 'Yinele',
	table: 'Tablo',
	image: 'Resim',
	eraser: 'Silgi',
	paragraph: 'Paragraf',
	fontsize: 'Font boyutu',
	video: 'Video',
	font: 'Font',
	about: 'Hakkında',
	print: 'Yazdır',
	symbol: 'Sembol',
	underline: 'Alt çizgi',
	strikethrough: 'Üstü çizili',
	indent: 'Girinti',
	outdent: 'Çıkıntı',
	fullsize: 'Tam ekran',
	shrink: 'Küçült',
	copyformat: 'Kopyalama Biçimi',
	hr: 'Ayraç',
	ul: 'Sırasız liste',
	ol: 'Sıralı liste',
	cut: 'Kes',
	selectall: 'Tümünü seç',
	'Open link': 'Bağlantıyı aç',
	'Edit link': 'Bağlantıyı düzenle',
	'No follow': 'Nofollow özelliği',
	Unlink: 'Bağlantıyı kaldır',
	Eye: 'Yorumu',
	pencil: 'Düzenlemek için',
	' URL': 'URL',
	Reset: 'Sıfırla',
	Save: 'Kaydet',
	'Save as ...': 'Farklı kaydet',
	Resize: 'Boyutlandır',
	Crop: 'Kırp',
	Width: 'Genişlik',
	Height: 'Yükseklik',
	'Keep Aspect Ratio': 'En boy oranını koru',
	Yes: 'Evet',
	No: 'Hayır',
	Remove: 'Sil',
	Select: 'Seç',
	'You can only edit your own images. Download this image on the host?':
		'Sadece kendi resimlerinizi düzenleyebilirsiniz. Bu görseli kendi hostunuza indirmek ister misiniz?',
	'The image has been successfully uploaded to the host!':
		'Görsel başarıyla hostunuza yüklendi',
	palette: 'Palet',
	'There are no files': 'Bu dizinde dosya yok',
	Rename: 'Yeniden isimlendir',
	'Enter new name': 'Yeni isim girin',
	preview: 'Ön izleme',
	download: 'İndir',
	'Paste from clipboard': 'Panodan yapıştır ',
	"Your browser doesn't support direct access to the clipboard.":
		'Tarayıcınız panoya doğrudan erişimi desteklemiyor.',
	'Copy selection': 'Seçimi kopyala',
	copy: 'Kopyala',
	'Border radius': 'Sınır yarıçapı',
	'Show all': 'Tümünü Göster',
	Apply: 'Uygula',
	'Please fill out this field': 'Lütfen bu alanı doldurun',
	'Please enter a web address': 'Lütfen bir web adresi girin',
	Default: 'Varsayılan',
	Circle: 'Daire',
	Dot: 'Nokta',
	Quadrate: 'Kare',
	Find: 'Bul',
	'Find Previous': 'Öncekini Bul',
	'Find Next': 'Sonrakini Bul',
	'Insert className': 'Sınıf adı girin'
};


/***/ }),
/* 232 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': '输入一些内容',
	Advanced: '高级',
	'About Jodit': '关于Jodit',
	'Jodit Editor': 'Jodit Editor',
	'Free Non-commercial Version': 'Free Non-commercial Version',
	"Jodit User's Guide": '开发者指南',
	'contains detailed help for using': '使用帮助',
	'For information about the license, please go to our website:':
		'有关许可证的信息，请访问我们的网站：',
	'Buy full version': '购买完整版本',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. 版权所有',
	Anchor: 'Anchor',
	'Open in new tab': '在新窗口打开',
	'Open editor in fullsize': '全屏编辑',
	'Clear Formatting': '清除样式',
	'Fill color or set the text color': '颜色',
	Redo: '重做',
	Undo: '撤销',
	Bold: '粗体',
	Italic: '斜体',
	'Insert Unordered List': '符号列表',
	'Insert Ordered List': '编号',
	'Align Center': '居中',
	'Align Justify': '对齐文本',
	'Align Left': '左对齐',
	'Align Right': '右对齐',
	'Insert Horizontal Line': '分割线',
	'Insert Image': '图片',
	'Insert file': '文件',
	'Insert youtube/vimeo video': '视频',
	'Insert link': '链接',
	'Font size': '字号',
	'Font family': '字体',
	'Insert format block': '格式块',
	Normal: '默认',
	'Heading 1': '标题1',
	'Heading 2': '标题2',
	'Heading 3': '标题3',
	'Heading 4': '标题4',
	Quote: '引用',
	Code: '代码',
	Insert: '插入',
	'Insert table': '表格',
	'Decrease Indent': '减少缩进',
	'Increase Indent': '增加缩进',
	'Select Special Character': '选择特殊符号',
	'Insert Special Character': '特殊符号',
	'Paint format': '格式复制',
	'Change mode': '改变模式',
	Margins: '外边距（Margins）',
	top: 'top',
	right: 'right',
	bottom: 'bottom',
	left: 'left',
	Styles: '样式',
	Classes: 'Classes',
	Align: '对齐方式',
	Right: '居右',
	Center: '居中',
	Left: '居左',
	'--Not Set--': '无',
	Src: 'Src',
	Title: 'Title',
	Alternative: 'Alternative',
	Link: 'Link',
	'Open link in new tab': '在新窗口打开链接',
	Image: '图片',
	file: 'file',
	Advansed: '高级',
	'Image properties': '图片属性',
	Cancel: '取消',
	Ok: '确定',
	'Your code is similar to HTML. Keep as HTML?':
		'你粘贴的文本是一段html代码，是否保留源格式',
	'Paste as HTML': 'html粘贴',
	Keep: '保留源格式',
	Clean: '匹配目标格式',
	'Insert as Text': '把html代码视为普通文本',
	'Word Paste Detected': '文本粘贴',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'正在粘贴 Word/Excel 的文本，是否保留源格式？',
	'Insert only Text': '只保留文本',
	'File Browser': '文件管理',
	'Error on load list': '加载list错误',
	'Error on load folders': '加载folders错误',
	'Are you sure?': '你确定吗？',
	'Enter Directory name': '输入路径',
	'Create directory': '创建路径',
	'type name': 'type name',
	'Drop image': '拖动图片到此',
	'Drop file': '拖动文件到此',
	'or click': '或点击',
	'Alternative text': 'Alternative text',
	Browse: '浏览',
	Upload: '上传',
	Background: '背景色',
	Text: '文字',
	Top: '顶部',
	Middle: '中间',
	Bottom: '底部',
	'Insert column before': '在之前插入列',
	'Insert column after': '在之后插入列',
	'Insert row above': '在之前插入行',
	'Insert row below': '在之后插入行',
	'Delete table': '删除表格',
	'Delete row': '删除行',
	'Delete column': '删除列',
	'Empty cell': '清除内容',
	'Chars: %d': '字符数: %d',
	'Words: %d': '单词数: %d',
	'Strike through': '删除线',
	Underline: '下划线',
	superscript: '上标',
	subscript: '下标',
	'Cut selection': '剪切',
	'Select all': '全选',
	Break: 'Break',
	'Search for': '查找',
	'Replace with': '替换为',
	Replace: '替换',
	Edit: '编辑',
	Paste: '粘贴',
	'Choose Content to Paste': '选择内容并粘贴',
	All: '全部',
	source: '源码',
	bold: '粗体',
	italic: '斜体',
	brush: '颜色',
	link: '链接',
	undo: '撤销',
	redo: '重做',
	table: '表格',
	image: '图片',
	eraser: '橡皮擦',
	paragraph: '段落',
	fontsize: '字号',
	video: '视频',
	font: '字体',
	about: '关于',
	print: '打印',
	symbol: '符号',
	underline: '下划线',
	strikethrough: '上出现',
	indent: '增加缩进',
	outdent: '减少缩进',
	fullsize: '全屏',
	shrink: '收缩',
	copyformat: '复制格式',
	hr: '分割线',
	ul: '无序列表',
	ol: '顺序列表',
	cut: '剪切',
	selectall: '全选',
	'Open link': '打开链接',
	'Edit link': '编辑链接',
	'No follow': 'No follow',
	Unlink: '取消链接',
	Eye: '预览',
	' URL': 'URL',
	Reset: '重置',
	Save: '保存',
	'Save as ...': '保存为',
	Resize: '调整大小',
	Crop: '剪切',
	Width: '宽',
	Height: '高',
	'Keep Aspect Ratio': '保持长宽比',
	Yes: '是',
	No: '不',
	Remove: '移除',
	Select: '选择',
	'Select %s': '选择: %s',
	Update: '更新',
	'Vertical align': '垂直对齐',
	Merge: '合并',
	'Add column': '添加列',
	'Add row': '添加行',
	Border: '边框',
	'Embed code': '嵌入代码',
	Delete: '删除',
	'Horizontal align': '水平对齐',
	Filter: '筛选',
	'Sort by changed': '修改时间排序',
	'Sort by name': '名称排序',
	'Sort by size': '大小排序',
	'Add folder': '新建文件夹',
	Split: '拆分',
	'Split vertical': '垂直拆分',
	'Split horizontal': '水平拆分',
	'You can only edit your own images. Download this image on the host?':
		'你只能编辑你自己的图片。Download this image on the host?',
	'The image has been successfully uploaded to the host!': '图片上传成功',
	palette: '调色板',
	pencil: '铅笔',
	'There are no files': '此目录中沒有文件。',
	Rename: '重命名',
	'Enter new name': '输入新名称',
	preview: '预览',
	download: '下载',
	'Paste from clipboard': '粘贴从剪贴板',
	"Your browser doesn't support direct access to the clipboard.":
		'你浏览器不支持直接访问的剪贴板。',
	'Copy selection': '复制选中内容',
	copy: '复制',
	'Border radius': '边界半径',
	'Show all': '显示所有',
	Apply: '应用',
	'Please fill out this field': '请填写这个字段',
	'Please enter a web address': '请输入一个网址',
	Default: '默认',
	Circle: '圆圈',
	Dot: '点',
	Quadrate: '方形',
	Find: '搜索',
	'Find Previous': '查找上一个',
	'Find Next': '查找下一个',
	'Insert className': '插入班级名称'
};


/***/ }),
/* 233 */
/***/ ((module) => {

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */

module.exports = {
	'Type something': '輸入一些內容',
	Advanced: '高級',
	'About Jodit': '關於Jodit',
	'Jodit Editor': 'Jodit Editor',
	"Jodit User's Guide": '開發者指南',
	'contains detailed help for using': '使用幫助',
	'For information about the license, please go to our website:':
		'有關許可證的信息，請訪問我們的網站：',
	'Buy full version': '購買完整版本',
	'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.':
		'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.',
	Anchor: 'Anchor',
	'Open in new tab': '在新窗口打開',
	'Open editor in fullsize': '全屏編輯',
	'Clear Formatting': '清除樣式',
	'Fill color or set the text color': '顏色',
	Redo: '重做',
	Undo: '撤銷',
	Bold: '粗體',
	Italic: '斜體',
	'Insert Unordered List': '符號列表',
	'Insert Ordered List': '編號',
	'Align Center': '居中',
	'Align Justify': '對齊文本',
	'Align Left': '左對齊',
	'Align Right': '右對齊',
	'Insert Horizontal Line': '分割線',
	'Insert Image': '圖片',
	'Insert file': '文件',
	'Insert youtube/vimeo video': 'youtube/vimeo 影片',
	'Insert link': '鏈接',
	'Font size': '字號',
	'Font family': '字體',
	'Insert format block': '格式塊',
	Normal: '文本',
	'Heading 1': '標題1',
	'Heading 2': '標題2',
	'Heading 3': '標題3',
	'Heading 4': '標題4',
	Quote: '引用',
	Code: '代碼',
	Insert: '插入',
	'Insert table': '表格',
	'Decrease Indent': '減少縮進',
	'Increase Indent': '增加縮進',
	'Select Special Character': '選擇特殊符號',
	'Insert Special Character': '特殊符號',
	'Paint format': '格式複製',
	'Change mode': '改變模式',
	Margins: '外邊距（Margins）',
	top: 'top',
	right: 'right',
	bottom: 'bottom',
	left: 'left',
	Styles: '樣式',
	Classes: 'Classes',
	Align: '對齊方式',
	Right: '居右',
	Center: '居中',
	Left: '居左',
	'--Not Set--': '無',
	Src: 'Src',
	Title: 'Title',
	Alternative: '替代',
	Link: 'Link',
	'Open link in new tab': '在新窗口打開鏈接',
	Image: '圖片',
	file: 'file',
	Advansed: '高級',
	'Image properties': '圖片屬性',
	Cancel: '取消',
	Ok: '確定',
	'Your code is similar to HTML. Keep as HTML?':
		'你黏貼的文本是一段html代碼，是否保留源格式',
	'Paste as HTML': 'html黏貼',
	Keep: '保留源格式',
	Clean: '匹配目標格式',
	'Insert as Text': '把html代碼視為普通文本',
	'Word Paste Detected': '文本黏貼',
	'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?':
		'正在黏貼 Word/Excel 的文本，是否保留源格式？',
	'Insert only Text': '只保留文本',
	'File Browser': '文件管理',
	'Error on load list': '加載list錯誤',
	'Error on load folders': '加載folders錯誤',
	'Are you sure?': '你確定嗎？',
	'Enter Directory name': '輸入路徑',
	'Create directory': '創建路徑',
	'type name': 'type name',
	'Drop image': '拖動圖片到此',
	'Drop file': '拖動文件到此',
	'or click': '或點擊',
	'Alternative text': '替代文字',
	Browse: '瀏覽',
	Upload: '上傳',
	Background: '背景色',
	Text: '文字',
	Top: '頂部',
	Middle: '中間',
	Bottom: '底部',
	'Insert column before': '在之前插入列',
	'Insert column after': '在之後插入列',
	'Insert row above': '在之前插入行',
	'Insert row below': '在之後插入行',
	'Delete table': '刪除表格',
	'Delete row': '刪除行',
	'Delete column': '刪除列',
	'Empty cell': '清除內容',
	'Chars: %d': '字符數: %d',
	'Words: %d': '單詞數: %d',
	'Strike through': '刪除線',
	Underline: '下劃線',
	superscript: '上標',
	subscript: '下標',
	'Cut selection': '剪切',
	'Select all': '全選',
	Break: 'Pause',
	'Search for': '查找',
	'Replace with': '替換為',
	Replace: 'แทนที่',
	Paste: '黏貼',
	'Choose Content to Paste': '選擇內容並黏貼',
	All: '全部',
	source: '源碼',
	bold: '粗體',
	italic: '斜體',
	brush: '顏色',
	link: '鏈接',
	undo: '撤銷',
	redo: '重做',
	table: '表格',
	image: '圖片',
	eraser: '橡皮擦',
	paragraph: '段落',
	fontsize: '字號',
	video: '影片',
	font: '字體',
	about: '關於',
	print: '打印',
	symbol: '符號',
	underline: '下劃線',
	strikethrough: '上出現',
	indent: '增加縮進',
	outdent: '減少縮進',
	fullsize: '全屏',
	shrink: '收縮',
	copyformat: '複製格式',
	hr: '分割線',
	ul: '無序列表',
	ol: '順序列表',
	cut: '剪切',
	selectall: '全選',
	'Open link': '打開鏈接',
	'Edit link': '編輯鏈接',
	'No follow': 'No follow',
	Unlink: '取消連結',
	Eye: '回顧',
	' URL': 'URL',
	Reset: '重置',
	Save: '保存',
	'Save as ...': '保存為',
	Resize: '調整大小',
	Crop: 'Crop',
	Width: '寬',
	Height: '高',
	'Keep Aspect Ratio': '保存長寬比',
	Yes: '是',
	No: '不',
	Remove: '移除',
	Select: '選擇',
	'Select %s': '選擇: %s',
	Update: '更新',
	'Vertical align': '垂直對齊',
	Merge: '合併',
	'Add column': '添加列',
	'Add row': '添加行',
	Border: '邊框',
	'Embed code': '嵌入代碼',
	Delete: '刪除',
	'Horizontal align': '水平對齊',
	Filter: '篩選',
	'Sort by changed': '修改時間排序',
	'Sort by name': '名稱排序',
	'Sort by size': '大小排序',
	'Add folder': '新建文件夾',
	Split: '拆分',
	'Split vertical': '垂直拆分',
	'Split horizontal': '水平拆分',
	'You can only edit your own images. Download this image on the host?':
		'你只能編輯你自己的圖片。是否下載此圖片到本地?',
	'The image has been successfully uploaded to the host!': '圖片上傳成功',
	palette: '調色板',
	pencil: '鉛筆',
	'There are no files': '此目錄中沒有文件。',
	Rename: '重命名',
	'Enter new name': '輸入新名稱',
	preview: '預覽',
	download: '下載',
	'Paste from clipboard': '從剪貼板貼上',
	"Your browser doesn't support direct access to the clipboard.":
		'瀏覽器無法存取剪贴板。',
	'Copy selection': '複製已選取項目',
	copy: '複製',
	'Border radius': '邊框圓角',
	'Show all': '顯示所有',
	Apply: '應用',
	'Please fill out this field': 'ได้โปรดกรอกช่องข้อมูลนี้',
	'Please enter a web address': 'โปรดเติมที่อยู่บนเว็บ',
	Default: 'ค่าปริยาย',
	Circle: 'วงกลม',
	Dot: 'จุด',
	Quadrate: 'Quadrate',
	Find: 'ค้นหา',
	'Find Previous': 'ค้นหาก่อนหน้านี้',
	'Find Next': 'ค้นหาถัดไป',
	'Insert className': 'ใส่ชื่อคลาส'
};


/***/ }),
/* 234 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.xpath = exports.tooltip = exports.symbols = exports.sticky = exports.stat = exports.source = exports.resizeHandler = exports.size = exports.select = exports.search = exports.resizer = exports.redoUndo = exports.placeholder = exports.orderedList = exports.mobile = exports.link = exports.limit = exports.justify = exports.inlinePopup = exports.hr = exports.indent = exports.iframe = exports.hotkeys = exports.fullsize = exports.formatBlock = exports.font = exports.errorMessages = exports.enter = exports.DragAndDropElement = exports.DragAndDrop = exports.color = exports.pasteStorage = exports.paste = exports.clipboard = exports.copyFormat = exports.WrapTextNodes = exports.cleanHtml = exports.bold = exports.Delete = exports.classSpan = exports.focus = exports.about = exports.addNewLine = void 0;
var tslib_1 = __webpack_require__(7);
var add_new_line_1 = __webpack_require__(235);
Object.defineProperty(exports, "addNewLine", ({ enumerable: true, get: function () { return add_new_line_1.addNewLine; } }));
var about_1 = __webpack_require__(237);
Object.defineProperty(exports, "about", ({ enumerable: true, get: function () { return about_1.about; } }));
var focus_1 = __webpack_require__(239);
Object.defineProperty(exports, "focus", ({ enumerable: true, get: function () { return focus_1.focus; } }));
var class_span_1 = __webpack_require__(240);
Object.defineProperty(exports, "classSpan", ({ enumerable: true, get: function () { return class_span_1.classSpan; } }));
var delete_1 = __webpack_require__(242);
Object.defineProperty(exports, "Delete", ({ enumerable: true, get: function () { return delete_1.Delete; } }));
var bold_1 = __webpack_require__(244);
Object.defineProperty(exports, "bold", ({ enumerable: true, get: function () { return bold_1.bold; } }));
var clean_html_1 = __webpack_require__(245);
Object.defineProperty(exports, "cleanHtml", ({ enumerable: true, get: function () { return clean_html_1.cleanHtml; } }));
var wrap_text_nodes_1 = __webpack_require__(246);
Object.defineProperty(exports, "WrapTextNodes", ({ enumerable: true, get: function () { return wrap_text_nodes_1.WrapTextNodes; } }));
var clipboard_1 = __webpack_require__(247);
Object.defineProperty(exports, "copyFormat", ({ enumerable: true, get: function () { return clipboard_1.copyFormat; } }));
Object.defineProperty(exports, "clipboard", ({ enumerable: true, get: function () { return clipboard_1.clipboard; } }));
Object.defineProperty(exports, "paste", ({ enumerable: true, get: function () { return clipboard_1.paste; } }));
Object.defineProperty(exports, "pasteStorage", ({ enumerable: true, get: function () { return clipboard_1.pasteStorage; } }));
var color_1 = __webpack_require__(255);
Object.defineProperty(exports, "color", ({ enumerable: true, get: function () { return color_1.color; } }));
var drag_and_drop_1 = __webpack_require__(262);
Object.defineProperty(exports, "DragAndDrop", ({ enumerable: true, get: function () { return drag_and_drop_1.DragAndDrop; } }));
var drag_and_drop_element_1 = __webpack_require__(263);
Object.defineProperty(exports, "DragAndDropElement", ({ enumerable: true, get: function () { return drag_and_drop_element_1.DragAndDropElement; } }));
var enter_1 = __webpack_require__(264);
Object.defineProperty(exports, "enter", ({ enumerable: true, get: function () { return enter_1.enter; } }));
var error_messages_1 = __webpack_require__(265);
Object.defineProperty(exports, "errorMessages", ({ enumerable: true, get: function () { return error_messages_1.errorMessages; } }));
var font_1 = __webpack_require__(267);
Object.defineProperty(exports, "font", ({ enumerable: true, get: function () { return font_1.font; } }));
var format_block_1 = __webpack_require__(268);
Object.defineProperty(exports, "formatBlock", ({ enumerable: true, get: function () { return format_block_1.formatBlock; } }));
var fullsize_1 = __webpack_require__(269);
Object.defineProperty(exports, "fullsize", ({ enumerable: true, get: function () { return fullsize_1.fullsize; } }));
var hotkeys_1 = __webpack_require__(271);
Object.defineProperty(exports, "hotkeys", ({ enumerable: true, get: function () { return hotkeys_1.hotkeys; } }));
var iframe_1 = __webpack_require__(272);
Object.defineProperty(exports, "iframe", ({ enumerable: true, get: function () { return iframe_1.iframe; } }));
tslib_1.__exportStar(__webpack_require__(273), exports);
var indent_1 = __webpack_require__(283);
Object.defineProperty(exports, "indent", ({ enumerable: true, get: function () { return indent_1.indent; } }));
var insert_1 = __webpack_require__(284);
Object.defineProperty(exports, "hr", ({ enumerable: true, get: function () { return insert_1.hr; } }));
var inline_popup_1 = __webpack_require__(286);
Object.defineProperty(exports, "inlinePopup", ({ enumerable: true, get: function () { return inline_popup_1.inlinePopup; } }));
var justify_1 = __webpack_require__(293);
Object.defineProperty(exports, "justify", ({ enumerable: true, get: function () { return justify_1.justify; } }));
var limit_1 = __webpack_require__(294);
Object.defineProperty(exports, "limit", ({ enumerable: true, get: function () { return limit_1.limit; } }));
var link_1 = __webpack_require__(295);
Object.defineProperty(exports, "link", ({ enumerable: true, get: function () { return link_1.link; } }));
tslib_1.__exportStar(__webpack_require__(297), exports);
var mobile_1 = __webpack_require__(302);
Object.defineProperty(exports, "mobile", ({ enumerable: true, get: function () { return mobile_1.mobile; } }));
var ordered_list_1 = __webpack_require__(303);
Object.defineProperty(exports, "orderedList", ({ enumerable: true, get: function () { return ordered_list_1.orderedList; } }));
var placeholder_1 = __webpack_require__(304);
Object.defineProperty(exports, "placeholder", ({ enumerable: true, get: function () { return placeholder_1.placeholder; } }));
var redo_undo_1 = __webpack_require__(306);
Object.defineProperty(exports, "redoUndo", ({ enumerable: true, get: function () { return redo_undo_1.redoUndo; } }));
var resizer_1 = __webpack_require__(307);
Object.defineProperty(exports, "resizer", ({ enumerable: true, get: function () { return resizer_1.resizer; } }));
var search_1 = __webpack_require__(309);
Object.defineProperty(exports, "search", ({ enumerable: true, get: function () { return search_1.search; } }));
var select_1 = __webpack_require__(311);
Object.defineProperty(exports, "select", ({ enumerable: true, get: function () { return select_1.select; } }));
var size_1 = __webpack_require__(312);
Object.defineProperty(exports, "size", ({ enumerable: true, get: function () { return size_1.size; } }));
Object.defineProperty(exports, "resizeHandler", ({ enumerable: true, get: function () { return size_1.resizeHandler; } }));
var source_1 = __webpack_require__(317);
Object.defineProperty(exports, "source", ({ enumerable: true, get: function () { return source_1.source; } }));
var stat_1 = __webpack_require__(326);
Object.defineProperty(exports, "stat", ({ enumerable: true, get: function () { return stat_1.stat; } }));
var sticky_1 = __webpack_require__(327);
Object.defineProperty(exports, "sticky", ({ enumerable: true, get: function () { return sticky_1.sticky; } }));
var symbols_1 = __webpack_require__(329);
Object.defineProperty(exports, "symbols", ({ enumerable: true, get: function () { return symbols_1.symbols; } }));
tslib_1.__exportStar(__webpack_require__(332), exports);
var tooltip_1 = __webpack_require__(339);
Object.defineProperty(exports, "tooltip", ({ enumerable: true, get: function () { return tooltip_1.tooltip; } }));
tslib_1.__exportStar(__webpack_require__(341), exports);
var xpath_1 = __webpack_require__(344);
Object.defineProperty(exports, "xpath", ({ enumerable: true, get: function () { return xpath_1.xpath; } }));


/***/ }),
/* 235 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.addNewLine = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(236);
var config_1 = __webpack_require__(8);
var modules_1 = __webpack_require__(10);
var helpers_1 = __webpack_require__(19);
config_1.Config.prototype.addNewLine = true;
config_1.Config.prototype.addNewLineOnDBLClick = true;
config_1.Config.prototype.addNewLineTagsTriggers = [
    'table',
    'iframe',
    'img',
    'hr',
    'jodit'
];
config_1.Config.prototype.addNewLineDeltaShow = 20;
var ns = 'addnewline';
var addNewLine = (function (_super) {
    tslib_1.__extends(addNewLine, _super);
    function addNewLine() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.line = _this.j.c.fromHTML("<div role=\"button\" tabIndex=\"-1\" title=\"" + _this.j.i18n('Break') + "\" class=\"jodit-add-new-line\"><span>" + modules_1.Icon.get('enter') + "</span></div>");
        _this.isMatchedTag = function (node) {
            return Boolean(node &&
                _this.j.o.addNewLineTagsTriggers.includes(node.nodeName.toLowerCase()));
        };
        _this.preview = false;
        _this.lineInFocus = false;
        _this.isShown = false;
        _this.hideForce = function () {
            if (!_this.isShown) {
                return;
            }
            _this.isShown = false;
            _this.j.async.clearTimeout(_this.timeout);
            _this.lineInFocus = false;
            modules_1.Dom.safeRemove(_this.line);
        };
        _this.hide = function () {
            if (!_this.isShown || _this.lineInFocus) {
                return;
            }
            _this.timeout = _this.j.async.setTimeout(_this.hideForce, {
                timeout: 500,
                label: 'add-new-line-hide'
            });
        };
        _this.canGetFocus = function (elm) {
            return (elm != null &&
                modules_1.Dom.isBlock(elm, _this.j.ew) &&
                !/^(img|table|iframe|hr)$/i.test(elm.nodeName));
        };
        _this.onClickLine = function (e) {
            var editor = _this.j;
            var p = editor.createInside.element(editor.o.enter);
            if (_this.preview && _this.current && _this.current.parentNode) {
                _this.current.parentNode.insertBefore(p, _this.current);
            }
            else {
                editor.editor.appendChild(p);
            }
            editor.s.setCursorIn(p);
            helpers_1.scrollIntoViewIfNeeded(p, editor.editor, editor.ed);
            editor.e.fire('synchro');
            _this.hideForce();
            e.preventDefault();
        };
        _this.onDblClickEditor = function (e) {
            var editor = _this.j;
            if (!editor.o.readonly &&
                editor.o.addNewLineOnDBLClick &&
                e.target === editor.editor &&
                editor.s.isCollapsed()) {
                var editorBound = helpers_1.offset(editor.editor, editor, editor.ed);
                var top_1 = e.pageY - editor.ew.pageYOffset;
                var p = editor.createInside.element(editor.o.enter);
                if (Math.abs(top_1 - editorBound.top) <
                    Math.abs(top_1 - (editorBound.height + editorBound.top)) &&
                    editor.editor.firstChild) {
                    editor.editor.insertBefore(p, editor.editor.firstChild);
                }
                else {
                    editor.editor.appendChild(p);
                }
                editor.s.setCursorIn(p);
                editor.setEditorValue();
                _this.hideForce();
                e.preventDefault();
            }
        };
        _this.onMouseMove = function (e) {
            var editor = _this.j;
            var currentElement = editor.ed.elementFromPoint(e.clientX, e.clientY);
            if (!modules_1.Dom.isHTMLElement(currentElement, editor.ew) ||
                modules_1.Dom.isOrContains(_this.line, currentElement)) {
                return;
            }
            if (!modules_1.Dom.isOrContains(editor.editor, currentElement)) {
                return;
            }
            if (!_this.isMatchedTag(currentElement)) {
                currentElement = modules_1.Dom.closest(currentElement, _this.isMatchedTag, editor.editor);
            }
            if (!currentElement) {
                _this.hide();
                return;
            }
            if (_this.isMatchedTag(currentElement)) {
                var parentBox = modules_1.Dom.up(currentElement, function (node) { return modules_1.Dom.isBlock(node, editor.ew); }, editor.editor);
                if (parentBox && parentBox !== editor.editor) {
                    currentElement = parentBox;
                }
            }
            var pos = helpers_1.position(currentElement, _this.j);
            var top = false;
            var clientY = e.clientY;
            if (_this.j.iframe) {
                var top_2 = helpers_1.position(_this.j.iframe, _this.j, true).top;
                clientY += top_2;
            }
            var delta = _this.j.o.addNewLineDeltaShow;
            if (Math.abs(clientY - pos.top) <= delta) {
                top = pos.top;
                _this.preview = true;
            }
            if (Math.abs(clientY - (pos.top + pos.height)) <= delta) {
                top = pos.top + pos.height;
                _this.preview = false;
            }
            if (top !== false &&
                !helpers_1.call(_this.preview ? modules_1.Dom.prev : modules_1.Dom.next, currentElement, _this.canGetFocus, editor.editor)) {
                _this.line.style.top = top + 'px';
                _this.current = currentElement;
                _this.show();
            }
            else {
                _this.current = false;
                _this.hide();
            }
        };
        return _this;
    }
    addNewLine.prototype.show = function () {
        if (this.isShown || this.j.o.readonly || this.j.isLocked) {
            return;
        }
        this.isShown = true;
        this.j.async.clearTimeout(this.timeout);
        this.line.classList.toggle('jodit-add-new-line_after', !this.preview);
        this.j.container.appendChild(this.line);
        this.line.style.width = this.j.editor.clientWidth + 'px';
    };
    addNewLine.prototype.afterInit = function (editor) {
        var _this = this;
        if (!editor.o.addNewLine) {
            return;
        }
        editor.e
            .on(this.line, 'mousemove', function (e) {
            e.stopPropagation();
        })
            .on(this.line, 'mousedown touchstart', this.onClickLine)
            .on('change', this.hideForce)
            .on(this.line, 'mouseenter', function () {
            _this.j.async.clearTimeout(_this.timeout);
            _this.lineInFocus = true;
        })
            .on(this.line, 'mouseleave', function () {
            _this.lineInFocus = false;
        })
            .on('changePlace', this.addEventListeners.bind(this));
        this.addEventListeners();
    };
    addNewLine.prototype.addEventListeners = function () {
        var editor = this.j;
        editor.e
            .off(editor.editor, '.' + ns)
            .off(editor.container, '.' + ns)
            .on([editor.ow, editor.ew, editor.editor], 'scroll' + '.' + ns, this.hideForce)
            .on(editor.editor, 'dblclick' + '.' + ns, this.onDblClickEditor)
            .on(editor.editor, 'click' + '.' + ns, this.hide)
            .on(editor.container, 'mouseleave' + '.' + ns, this.hide)
            .on(editor.editor, 'mousemove' + '.' + ns, editor.async.debounce(this.onMouseMove, editor.defaultTimeout * 3));
    };
    addNewLine.prototype.beforeDestruct = function () {
        this.j.async.clearTimeout(this.timeout);
        this.j.e.off(this.line);
        this.j.e.off('changePlace', this.addEventListeners);
        modules_1.Dom.safeRemove(this.line);
        this.j.e
            .off([this.j.ow, this.j.ew, this.j.editor], '.' + ns)
            .off(this.j.container, '.' + ns);
    };
    return addNewLine;
}(modules_1.Plugin));
exports.addNewLine = addNewLine;


/***/ }),
/* 236 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 237 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.about = void 0;
__webpack_require__(238);
var config_1 = __webpack_require__(8);
var helpers_1 = __webpack_require__(19);
var constants = __webpack_require__(9);
var dialog_1 = __webpack_require__(163);
config_1.Config.prototype.controls.about = {
    exec: function (editor) {
        var dialog = new dialog_1.Dialog({
            language: editor.o.language
        }), i18n = editor.i18n.bind(editor);
        dialog.setMod('theme', editor.o.theme);
        dialog.setHeader(i18n('About Jodit'));
        dialog.setContent("<div class=\"jodit-about\">\n\t\t\t\t\t<div>" + i18n('Jodit Editor') + " v." + editor.getVersion() + "</div>\n\t\t\t\t\t<div>" + i18n('License: %s', !helpers_1.isLicense(editor.o.license)
            ? 'MIT'
            : helpers_1.normalizeLicense(editor.o.license)) + "</div>\n\t\t\t\t\t<div>\n\t\t\t\t\t\t<a href=\"" + "https://xdsoft.net/jodit/" + "\" target=\"_blank\">" + "https://xdsoft.net/jodit/" + "</a>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div>\n\t\t\t\t\t\t<a href=\"https://xdsoft.net/jodit/doc/\" target=\"_blank\">" + i18n("Jodit User's Guide") + "</a>\n\t\t\t\t\t\t" + i18n('contains detailed help for using') + "\n\t\t\t\t\t</div>\n\t\t\t\t\t<div>" + i18n('Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.') + "</div>\n\t\t\t\t</div>");
        helpers_1.css(dialog.dialog, {
            minHeight: 200,
            minWidth: 420
        });
        dialog.open(true);
        dialog.bindDestruct(editor);
    },
    tooltip: 'About Jodit',
    mode: constants.MODE_SOURCE + constants.MODE_WYSIWYG
};
function about(editor) {
    editor.registerButton({
        name: 'about',
        group: 'info'
    });
}
exports.about = about;


/***/ }),
/* 238 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 239 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.focus = void 0;
var config_1 = __webpack_require__(8);
var dom_1 = __webpack_require__(32);
config_1.Config.prototype.autofocus = false;
config_1.Config.prototype.cursorAfterAutofocus = 'end';
config_1.Config.prototype.saveSelectionOnBlur = true;
function focus(editor) {
    if (editor.o.saveSelectionOnBlur) {
        editor.e
            .on('blur', function () {
            if (editor.isEditorMode()) {
                editor.s.save(true);
            }
        })
            .on('focus', function () {
            editor.s.restore();
        });
    }
    var focus = function () {
        editor.s.focus();
        if (editor.o.cursorAfterAutofocus === 'end') {
            var lastTextNode = dom_1.Dom.last(editor.editor, function (node) {
                return dom_1.Dom.isText(node);
            });
            if (lastTextNode) {
                editor.s.setCursorIn(lastTextNode, false);
            }
        }
    };
    editor.e.on('afterInit', function () {
        if (editor.o.autofocus) {
            if (editor.defaultTimeout) {
                editor.async.setTimeout(focus, 300);
            }
            else {
                focus();
            }
        }
    });
    editor.e.on('afterInit afterAddPlace', function () {
        editor.e
            .off(editor.editor, 'mousedown.autofocus')
            .on(editor.editor, 'mousedown.autofocus', function (e) {
            if (editor.isEditorMode() &&
                e.target &&
                dom_1.Dom.isBlock(e.target, editor.ew) &&
                !e.target.childNodes.length) {
                if (editor.editor === e.target) {
                    editor.s.focus();
                }
                else {
                    editor.s.setCursorIn(e.target);
                }
            }
        });
    });
}
exports.focus = focus;


/***/ }),
/* 240 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.classSpan = void 0;
var tslib_1 = __webpack_require__(7);
var plugin_1 = __webpack_require__(184);
var config_1 = __webpack_require__(8);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
config_1.Config.prototype.controls.classSpan = {
    command: 'applyClassName',
    icon: __webpack_require__(241),
    exec: helpers_1.memorizeExec,
    list: [
        'enabled',
        'disabled',
        'activated',
        'text-left',
        'text-center',
        'text-right',
        'warning',
        'error'
    ],
    isChildActive: function (editor, control) {
        var current = editor.s.current();
        if (current) {
            var currentBpx = dom_1.Dom.closest(current, function (elm) {
                return (dom_1.Dom.isBlock(elm, editor.ew) ||
                    (elm && dom_1.Dom.isElement(elm)));
            }, editor.editor) || editor.editor;
            return Boolean(control.args &&
                currentBpx.classList.contains(control.args[0].toString()));
        }
        return false;
    },
    isActive: function (editor, control) {
        var current = editor.s.current();
        if (current) {
            var currentBpx_1 = dom_1.Dom.closest(current, function (elm) {
                return (dom_1.Dom.isBlock(elm, editor.ew) ||
                    (elm && dom_1.Dom.isElement(elm)));
            }, editor.editor) || editor.editor;
            var present_1 = false;
            control.list &&
                Object.keys(control.list).forEach(function (className) {
                    if (currentBpx_1.classList.contains(className)) {
                        present_1 = true;
                    }
                });
            return Boolean(currentBpx_1 &&
                currentBpx_1 !== editor.editor &&
                control.list !== undefined &&
                present_1);
        }
        return false;
    },
    childTemplate: function (e, key, value) {
        return "<span class=\"" + key + "\">" + e.i18n(value) + "</span>";
    },
    tooltip: 'Insert className'
};
var classSpan = (function (_super) {
    tslib_1.__extends(classSpan, _super);
    function classSpan() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.buttons = [
            {
                name: 'classSpan',
                group: 'font'
            }
        ];
        return _this;
    }
    classSpan.prototype.afterInit = function (jodit) {
        jodit.registerCommand('applyClassName', function (command, second, third) {
            jodit.s.applyStyle(undefined, {
                className: third
            });
            return false;
        });
    };
    classSpan.prototype.beforeDestruct = function (jodit) { };
    return classSpan;
}(plugin_1.Plugin));
exports.classSpan = classSpan;


/***/ }),
/* 241 */
/***/ ((module) => {

module.exports = "<svg viewBox=\"0 0 48 48\" xmlns=\"http://www.w3.org/2000/svg\"> <path d=\"M36 4h-24c-2.21 0-4 1.79-4 4v32c0 2.21 1.79 4 4 4h24c2.21 0 4-1.79 4-4v-32c0-2.21-1.79-4-4-4zm-24 4h10v16l-5-3-5 3v-16z\"/> </svg>"

/***/ }),
/* 242 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Delete = void 0;
var tslib_1 = __webpack_require__(7);
var plugin_1 = __webpack_require__(184);
var dom_1 = __webpack_require__(32);
var constants_1 = __webpack_require__(9);
var helpers_1 = __webpack_require__(19);
var helpers_2 = __webpack_require__(243);
var config_1 = __webpack_require__(8);
config_1.Config.prototype.delete = {
    hotkeys: {
        delete: ['delete', 'cmd+backspace'],
        deleteWord: ['ctrl+delete', 'cmd+alt+backspace', 'ctrl+alt+backspace'],
        backspace: ['backspace'],
        backspaceWord: ['ctrl+backspace']
    }
};
var Delete = (function (_super) {
    tslib_1.__extends(Delete, _super);
    function Delete() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.requires = ['hotkeys'];
        return _this;
    }
    Object.defineProperty(Delete.prototype, "root", {
        get: function () {
            return this.j.editor;
        },
        enumerable: false,
        configurable: true
    });
    Delete.prototype.afterInit = function (jodit) {
        var _this = this;
        jodit.e.on('afterCommand.delete', function (command) {
            if (command === 'delete') {
                _this.afterDeleteCommand();
            }
        });
        jodit
            .registerCommand('deleteButton', {
            exec: function () { return _this.onDelete(false); },
            hotkeys: jodit.o.delete.hotkeys.delete
        }, {
            stopPropagation: false
        })
            .registerCommand('backspaceButton', {
            exec: function () { return _this.onDelete(true); },
            hotkeys: jodit.o.delete.hotkeys.backspace
        }, {
            stopPropagation: false
        })
            .registerCommand('deleteWordButton', {
            exec: function () { return _this.onDelete(false, true); },
            hotkeys: jodit.o.delete.hotkeys.deleteWord
        })
            .registerCommand('backspaceWordButton', {
            exec: function () { return _this.onDelete(true, true); },
            hotkeys: jodit.o.delete.hotkeys.backspaceWord
        });
    };
    Delete.prototype.beforeDestruct = function (jodit) {
        jodit.e.off('afterCommand.delete');
    };
    Delete.prototype.afterDeleteCommand = function () {
        var jodit = this.j;
        var current = jodit.s.current();
        if (current && dom_1.Dom.isTag(current.firstChild, 'br')) {
            jodit.s.removeNode(current.firstChild);
        }
        if (!helpers_1.trim(jodit.editor.textContent || '') &&
            !jodit.editor.querySelector('img') &&
            (!current || !dom_1.Dom.closest(current, 'table', jodit.editor))) {
            jodit.editor.innerHTML = '';
            var node = jodit.s.setCursorIn(jodit.editor);
            jodit.s.removeNode(node);
        }
    };
    Delete.prototype.onDelete = function (backspace, block) {
        var _a;
        if (block === void 0) { block = false; }
        var sel = this.j.selection;
        if (!sel.isFocused()) {
            sel.focus();
        }
        if (!((_a = sel.sel) === null || _a === void 0 ? void 0 : _a.rangeCount) || this.checkNotCollapsed()) {
            return false;
        }
        var jodit = this.j;
        var range = sel.range;
        var fakeNode = jodit.createInside.text(constants_1.INVISIBLE_SPACE);
        try {
            range.insertNode(fakeNode);
            if (!dom_1.Dom.isOrContains(jodit.editor, fakeNode)) {
                return;
            }
            helpers_2.normalizeCursorPosition(fakeNode, backspace);
            if (this.checkRemoveInseparableElement(fakeNode, backspace) ||
                this.checkRemoveChar(fakeNode, backspace, block) ||
                this.checkTableCell(fakeNode, backspace) ||
                this.checkRemoveEmptyParent(fakeNode, backspace) ||
                this.checkRemoveEmptyNeighbor(fakeNode, backspace) ||
                this.checkJoinTwoLists(fakeNode, backspace) ||
                this.checkJoinNeighbors(fakeNode, backspace) ||
                this.checkRewrapListItem(fakeNode, backspace)) {
                return false;
            }
        }
        catch (e) {
            if (false) {}
            throw e;
        }
        finally {
            this.safeRemoveEmptyNode(fakeNode);
        }
        return false;
    };
    Delete.prototype.checkNotCollapsed = function () {
        var jodit = this.j;
        if (!jodit.s.isCollapsed()) {
            jodit.execCommand('Delete');
            return true;
        }
    };
    Delete.prototype.checkRemoveChar = function (fakeNode, backspace, block) {
        var _a, _b, _c;
        var step = backspace ? -1 : 1;
        var anotherSibling = helpers_2.getSibling(fakeNode, !backspace);
        var sibling = helpers_2.getSibling(fakeNode, backspace), removeNeighbor = null;
        var charRemoved = false, removed;
        while (sibling && (dom_1.Dom.isText(sibling) || dom_1.Dom.isInlineBlock(sibling))) {
            while (dom_1.Dom.isInlineBlock(sibling)) {
                sibling = (backspace ? sibling === null || sibling === void 0 ? void 0 : sibling.lastChild : sibling === null || sibling === void 0 ? void 0 : sibling.firstChild);
            }
            if (!sibling) {
                break;
            }
            if ((_a = sibling.nodeValue) === null || _a === void 0 ? void 0 : _a.length) {
                var value = helpers_1.toArray(sibling.nodeValue);
                var length_1 = value.length;
                var index = backspace ? length_1 - 1 : 0;
                if (value[index] === constants_1.INVISIBLE_SPACE) {
                    while (value[index] === constants_1.INVISIBLE_SPACE) {
                        index += step;
                    }
                }
                removed = value[index];
                if (value[index + step] === constants_1.INVISIBLE_SPACE) {
                    index += step;
                    while (value[index] === constants_1.INVISIBLE_SPACE) {
                        index += step;
                    }
                    index += backspace ? 1 : -1;
                }
                if (backspace && index < 0) {
                    value = [];
                }
                else {
                    value = value.slice(backspace ? 0 : index + 1, backspace ? index : length_1);
                }
                if (!anotherSibling ||
                    !dom_1.Dom.isText(anotherSibling) ||
                    (!backspace ? / $/ : /^ /).test((_b = anotherSibling.nodeValue) !== null && _b !== void 0 ? _b : '') ||
                    !helpers_1.trimInv(anotherSibling.nodeValue || '').length) {
                    for (var i = backspace ? value.length - 1 : 0; backspace ? i >= 0 : i < value.length; i += backspace ? -1 : 1) {
                        if (value[i] === ' ') {
                            value[i] = constants_1.NBSP_SPACE;
                        }
                        else {
                            break;
                        }
                    }
                }
                sibling.nodeValue = value.join('');
            }
            if (!((_c = sibling.nodeValue) === null || _c === void 0 ? void 0 : _c.length)) {
                removeNeighbor = sibling;
            }
            if (!helpers_1.isVoid(removed) && removed !== constants_1.INVISIBLE_SPACE) {
                charRemoved = true;
                helpers_1.call(backspace ? dom_1.Dom.after : dom_1.Dom.before, sibling, fakeNode);
                if (block) {
                    while (this.checkRemoveChar(fakeNode, backspace, false)) { }
                }
                break;
            }
            var nextSibling = helpers_2.getSibling(sibling, backspace);
            if (!nextSibling &&
                sibling.parentNode &&
                sibling.parentNode !== this.root) {
                nextSibling = helpers_2.findMostNestedNeighbor(sibling, !backspace, this.root, true);
            }
            if (removeNeighbor) {
                dom_1.Dom.safeRemove(removeNeighbor);
                removeNeighbor = null;
            }
            sibling = nextSibling;
        }
        if (charRemoved) {
            this.removeEmptyInlineParent(fakeNode);
            this.addBRInsideEmptyBlock(fakeNode);
            this.j.s.setCursorBefore(fakeNode);
        }
        return charRemoved || undefined;
    };
    Delete.prototype.removeEmptyInlineParent = function (node) {
        var parent = node.parentElement;
        while (parent && dom_1.Dom.isInlineBlock(parent)) {
            var p = parent.parentElement;
            if (dom_1.Dom.isEmpty(parent)) {
                dom_1.Dom.after(parent, node);
                dom_1.Dom.safeRemove(parent);
            }
            parent = p;
        }
    };
    Delete.prototype.addBRInsideEmptyBlock = function (node) {
        if (node.parentElement !== this.root &&
            dom_1.Dom.isBlock(node.parentElement, this.j.ew) &&
            dom_1.Dom.each(node.parentElement, dom_1.Dom.isEmptyTextNode)) {
            dom_1.Dom.after(node, this.j.createInside.element('br'));
        }
    };
    Delete.prototype.checkRemoveInseparableElement = function (fakeNode, backspace) {
        var neighbor = dom_1.Dom.findSibling(fakeNode, backspace);
        if (dom_1.Dom.isElement(neighbor) &&
            (dom_1.Dom.isTag(neighbor, constants_1.INSEPARABLE_TAGS) ||
                dom_1.Dom.isEmpty(neighbor) ||
                helpers_1.attr(neighbor, 'contenteditable') === 'false')) {
            dom_1.Dom.safeRemove(neighbor);
            this.j.s.setCursorBefore(fakeNode);
            if (dom_1.Dom.isTag(neighbor, 'br')) {
                this.checkRemoveEmptyParent(fakeNode, backspace);
            }
            return true;
        }
    };
    Delete.prototype.checkTableCell = function (fakeNode, backspace) {
        var cell = fakeNode.parentElement;
        if (dom_1.Dom.isCell(cell, this.j.ew)) {
            return true;
        }
    };
    Delete.prototype.checkRemoveEmptyParent = function (fakeNode, backspace) {
        var found = false;
        var _a = this.j.s, setCursorBefore = _a.setCursorBefore, setCursorIn = _a.setCursorIn;
        var prn = dom_1.Dom.closest(fakeNode, dom_1.Dom.isElement, this.root);
        if (!prn || !dom_1.Dom.isEmpty(prn)) {
            return;
        }
        var neighbor = helpers_2.findNotEmptyNeighbor(fakeNode, backspace, this.root);
        do {
            if (prn && dom_1.Dom.isEmpty(prn) && !dom_1.Dom.isCell(prn, this.j.ew)) {
                dom_1.Dom.after(prn, fakeNode);
                var tmp = dom_1.Dom.closest(prn, function (n) { return dom_1.Dom.isElement(n) && n !== prn; }, this.root);
                dom_1.Dom.safeRemove(prn);
                found = true;
                prn = tmp;
            }
            else {
                break;
            }
        } while (prn);
        if (found && this.checkJoinTwoLists(fakeNode, backspace)) {
            return true;
        }
        if (neighbor &&
            !dom_1.Dom.isText(neighbor) &&
            !dom_1.Dom.isTag(neighbor, constants_1.INSEPARABLE_TAGS)) {
            setCursorIn(neighbor, !backspace);
        }
        else {
            setCursorBefore(fakeNode);
        }
        return found || undefined;
    };
    Delete.prototype.checkJoinTwoLists = function (fakeNode, backspace) {
        var next = dom_1.Dom.findSibling(fakeNode, backspace), prev = dom_1.Dom.findSibling(fakeNode, !backspace);
        if (!dom_1.Dom.closest(fakeNode, dom_1.Dom.isElement, this.root) &&
            dom_1.Dom.isTag(next, ['ul', 'ol']) &&
            dom_1.Dom.isTag(prev, ['ul', 'ol']) &&
            dom_1.Dom.isTag(next.lastElementChild, 'li') &&
            dom_1.Dom.isTag(prev.firstElementChild, 'li')) {
            var _a = this.j.s, setCursorBefore = _a.setCursorBefore, setCursorAfter = _a.setCursorAfter;
            var target = next.lastElementChild, second = prev.firstElementChild;
            helpers_1.call(!backspace ? dom_1.Dom.append : dom_1.Dom.prepend, second, fakeNode);
            dom_1.Dom.moveContent(prev, next, !backspace);
            dom_1.Dom.safeRemove(prev);
            helpers_1.call(backspace ? dom_1.Dom.append : dom_1.Dom.prepend, target, fakeNode);
            helpers_1.call(backspace ? setCursorBefore : setCursorAfter, fakeNode);
            return true;
        }
    };
    Delete.prototype.checkRemoveEmptyNeighbor = function (fakeNode, backspace) {
        var parent = dom_1.Dom.closest(fakeNode, dom_1.Dom.isElement, this.root);
        if (!parent) {
            return;
        }
        var neighbor = helpers_2.findNotEmptySibling(parent, backspace);
        if (neighbor && dom_1.Dom.isEmpty(neighbor)) {
            dom_1.Dom.safeRemove(neighbor);
            this.j.s.setCursorBefore(fakeNode);
            return true;
        }
    };
    Delete.prototype.checkJoinNeighbors = function (fakeNode, backspace) {
        var jodit = this.jodit;
        var nextBox = fakeNode, mainClosestBox = nextBox;
        while (nextBox &&
            !helpers_2.findNotEmptySibling(nextBox, backspace) &&
            nextBox.parentElement !== this.root) {
            nextBox = nextBox.parentElement;
            mainClosestBox = nextBox;
        }
        if (dom_1.Dom.isElement(mainClosestBox)) {
            var sibling = helpers_2.findNotEmptySibling(mainClosestBox, backspace);
            if (sibling &&
                (this.checkMoveListContent(mainClosestBox, sibling, backspace) ||
                    this.moveContentAndRemoveEmpty(mainClosestBox, sibling, backspace))) {
                jodit.s.setCursorBefore(fakeNode);
                return true;
            }
        }
    };
    Delete.prototype.checkMoveListContent = function (mainClosestBox, sibling, backspace) {
        var jodit = this.jodit;
        var siblingIsList = dom_1.Dom.isTag(sibling, ['ol', 'ul']);
        var boxIsList = dom_1.Dom.isTag(mainClosestBox, ['ol', 'ul']);
        var elementChild = function (elm, side) {
            return side ? elm.firstElementChild : elm.lastElementChild;
        };
        if (boxIsList) {
            sibling = jodit.createInside.element(jodit.o.enterBlock);
            dom_1.Dom.before(mainClosestBox, sibling);
            return this.moveContentAndRemoveEmpty(elementChild(mainClosestBox, backspace), sibling, backspace);
        }
        if (sibling && siblingIsList && !boxIsList) {
            return this.moveContentAndRemoveEmpty(mainClosestBox, elementChild(sibling, !backspace), backspace);
        }
        return false;
    };
    Delete.prototype.moveContentAndRemoveEmpty = function (mainClosestBox, sibling, backspace) {
        if (mainClosestBox && dom_1.Dom.isElement(sibling)) {
            dom_1.Dom.moveContent(mainClosestBox, sibling, !backspace);
            var remove = mainClosestBox;
            while (remove && remove !== this.root && dom_1.Dom.isEmpty(remove)) {
                var parent_1 = remove.parentElement;
                dom_1.Dom.safeRemove(remove);
                remove = parent_1;
            }
            return true;
        }
        return false;
    };
    Delete.prototype.checkJoinNeighbors2 = function (fakeNode, backspace) {
        var parent = dom_1.Dom.closest(fakeNode, dom_1.Dom.isElement, this.root);
        if (!parent) {
            return;
        }
        var neighbor = helpers_2.getSiblingBox(parent, backspace, this.root);
        if (!neighbor) {
            return;
        }
        var startNeighbor = neighbor;
        this.j.s.setCursorBefore(fakeNode);
        if (!this.j.s.cursorInTheEdge(backspace, parent)) {
            return;
        }
        if (dom_1.Dom.isTag(neighbor, ['ul', 'ol']) &&
            !dom_1.Dom.isTag(parent, ['ul', 'ol'])) {
            neighbor = backspace
                ? neighbor.lastElementChild
                : neighbor.firstElementChild;
        }
        if (parent &&
            neighbor &&
            startNeighbor &&
            dom_1.Dom.isElement(neighbor) &&
            this.j.s.cursorInTheEdge(backspace, parent)) {
            dom_1.Dom.moveContent(parent, neighbor, !backspace);
            var next = void 0;
            do {
                next = helpers_2.findMostNestedNeighbor(startNeighbor, backspace, this.root);
                if (next === parent) {
                    var nextParentNode = next;
                    do {
                        var nextParent = nextParentNode.parentElement;
                        dom_1.Dom.safeRemove(nextParentNode);
                        nextParentNode = nextParent;
                    } while (nextParentNode && dom_1.Dom.isEmpty(nextParentNode));
                }
                dom_1.Dom.safeRemove(next);
            } while (next !== parent);
            this.j.s.setCursorBefore(fakeNode);
            return true;
        }
        if (dom_1.Dom.isTag(parent, 'li') &&
            this.j.s.cursorInTheEdge(backspace, parent)) {
            helpers_1.call(backspace ? dom_1.Dom.before : dom_1.Dom.after, parent, fakeNode);
            var result = this.checkJoinNeighbors(fakeNode, backspace);
            helpers_1.call(!backspace ? dom_1.Dom.append : dom_1.Dom.prepend, parent, fakeNode);
            this.j.s.setCursorBefore(fakeNode);
            return result;
        }
    };
    Delete.prototype.checkRewrapListItem = function (fakeNode, backspace) {
        var _a;
        if (backspace) {
            var li = dom_1.Dom.closest(fakeNode, dom_1.Dom.isElement, this.root);
            if (dom_1.Dom.isTag(li, 'li') &&
                ((_a = li === null || li === void 0 ? void 0 : li.parentElement) === null || _a === void 0 ? void 0 : _a.firstElementChild) === li &&
                this.j.s.cursorInTheEdge(true, li)) {
                var ul = li.parentElement;
                var p = this.j.createInside.element(this.j.o.enterBlock);
                dom_1.Dom.before(ul, p);
                dom_1.Dom.moveContent(li, p);
                dom_1.Dom.safeRemove(li);
                if (dom_1.Dom.isEmpty(ul)) {
                    dom_1.Dom.safeRemove(ul);
                }
                this.j.s.setCursorBefore(fakeNode);
                return true;
            }
        }
    };
    Delete.prototype.safeRemoveEmptyNode = function (fakeNode) {
        var _a, _b;
        var range = this.j.s.range;
        if (range.startContainer === fakeNode) {
            if (fakeNode.previousSibling) {
                if (dom_1.Dom.isText(fakeNode.previousSibling)) {
                    range.setStart(fakeNode.previousSibling, (_b = (_a = fakeNode.previousSibling.nodeValue) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0);
                }
                else {
                    range.setStartAfter(fakeNode.previousSibling);
                }
            }
            else if (fakeNode.nextSibling) {
                if (dom_1.Dom.isText(fakeNode.nextSibling)) {
                    range.setStart(fakeNode.nextSibling, 0);
                }
                else {
                    range.setStartBefore(fakeNode.nextSibling);
                }
            }
            range.collapse(true);
            this.j.s.selectRange(range);
        }
        dom_1.Dom.safeRemove(fakeNode);
    };
    return Delete;
}(plugin_1.Plugin));
exports.Delete = Delete;


/***/ }),
/* 243 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getSiblingBox = exports.normalizeCursorPosition = exports.findMostNestedNeighbor = exports.findNotEmptySibling = exports.findNotEmptyNeighbor = exports.getSibling = void 0;
var utils_1 = __webpack_require__(20);
var dom_1 = __webpack_require__(32);
var constants_1 = __webpack_require__(9);
var string_1 = __webpack_require__(68);
function getSibling(node, backspace) {
    return backspace ? node.previousSibling : node.nextSibling;
}
exports.getSibling = getSibling;
function findNotEmptyNeighbor(node, backspace, root) {
    return utils_1.call(backspace ? dom_1.Dom.prev : dom_1.Dom.next, node, function (n) { return Boolean(n && (!dom_1.Dom.isText(n) || string_1.trim((n === null || n === void 0 ? void 0 : n.nodeValue) || '').length)); }, root);
}
exports.findNotEmptyNeighbor = findNotEmptyNeighbor;
function findNotEmptySibling(node, backspace) {
    return dom_1.Dom.findSibling(node, backspace, function (n) {
        var _a;
        return (!dom_1.Dom.isEmptyTextNode(n) &&
            Boolean(!dom_1.Dom.isText(n) || (((_a = n.nodeValue) === null || _a === void 0 ? void 0 : _a.length) && string_1.trim(n.nodeValue))));
    });
}
exports.findNotEmptySibling = findNotEmptySibling;
function findMostNestedNeighbor(node, right, root, onlyInlide) {
    if (onlyInlide === void 0) { onlyInlide = false; }
    var nextChild = function (node) {
        return right ? node.firstChild : node.lastChild;
    };
    var next = findNotEmptyNeighbor(node, !right, root);
    if (onlyInlide && dom_1.Dom.isElement(next) && !dom_1.Dom.isInlineBlock(next)) {
        return null;
    }
    if (next) {
        do {
            if (nextChild(next)) {
                next = nextChild(next);
            }
            else {
                return next;
            }
        } while (next);
    }
    return null;
}
exports.findMostNestedNeighbor = findMostNestedNeighbor;
function normalizeCursorPosition(node, backspace) {
    var sibling = dom_1.Dom.findSibling(node, backspace), anotherSibling = dom_1.Dom.findSibling(node, !backspace);
    while (dom_1.Dom.isElement(sibling) &&
        !dom_1.Dom.isTag(sibling, constants_1.INSEPARABLE_TAGS) &&
        !anotherSibling) {
        if (backspace || !sibling.firstChild) {
            sibling.appendChild(node);
        }
        else {
            dom_1.Dom.before(sibling.firstChild, node);
        }
        sibling = getSibling(node, backspace);
        anotherSibling = getSibling(node, !backspace);
    }
}
exports.normalizeCursorPosition = normalizeCursorPosition;
function getSiblingBox(node, backspace, root) {
    var _loop_1 = function () {
        var isBox = function (elm) {
            return dom_1.Dom.isElement(elm) && !dom_1.Dom.isTag(elm, constants_1.INSEPARABLE_TAGS);
        };
        var getBox_1 = function (node) {
            var child = backspace ? node.lastChild : node.firstChild;
            if (isBox(child)) {
                return getBox_1(child);
            }
            return isBox(node) ? node : null;
        };
        var sibling = findNotEmptySibling(node, backspace);
        if (sibling) {
            return { value: isBox(sibling) ? getBox_1(sibling) : null };
        }
        if (node.parentElement && node.parentElement !== root) {
            node = node.parentElement;
        }
    };
    while (node) {
        var state_1 = _loop_1();
        if (typeof state_1 === "object")
            return state_1.value;
    }
    return null;
}
exports.getSiblingBox = getSiblingBox;


/***/ }),
/* 244 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bold = void 0;
var tslib_1 = __webpack_require__(7);
var config_1 = __webpack_require__(8);
var helpers_1 = __webpack_require__(19);
config_1.Config.prototype.controls.subscript = {
    tags: ['sub'],
    tooltip: 'subscript'
};
config_1.Config.prototype.controls.superscript = {
    tags: ['sup'],
    tooltip: 'superscript'
};
config_1.Config.prototype.controls.bold = {
    tagRegExp: /^(strong|b)$/i,
    tags: ['strong', 'b'],
    css: {
        'font-weight': ['bold', '700']
    },
    tooltip: 'Bold'
};
config_1.Config.prototype.controls.italic = {
    tagRegExp: /^(em|i)$/i,
    tags: ['em', 'i'],
    css: {
        'font-style': 'italic'
    },
    tooltip: 'Italic'
};
config_1.Config.prototype.controls.underline = {
    tagRegExp: /^(u)$/i,
    tags: ['u'],
    css: {
        'text-decoration': 'underline'
    },
    tooltip: 'Underline'
};
config_1.Config.prototype.controls.strikethrough = {
    tagRegExp: /^(s)$/i,
    tags: ['s'],
    css: {
        'text-decoration': 'line-through'
    },
    tooltip: 'Strike through'
};
function bold(editor) {
    var callBack = function (command) {
        var control = config_1.Config.defaultOptions.controls[command], cssOptions = tslib_1.__assign({}, control.css), cssRules = {};
        Object.keys(cssOptions).forEach(function (key) {
            cssRules[key] = helpers_1.isArray(cssOptions[key])
                ? cssOptions[key][0]
                : cssOptions[key];
        });
        editor.s.applyStyle(cssRules, {
            element: control.tags ? control.tags[0] : undefined
        });
        editor.e.fire('synchro');
        return false;
    };
    ['bold', 'italic', 'underline', 'strikethrough'].forEach(function (name) {
        editor.registerButton({
            name: name,
            group: 'font-style'
        });
    });
    ['superscript', 'subscript'].forEach(function (name) {
        editor.registerButton({
            name: name,
            group: 'script'
        });
    });
    editor
        .registerCommand('bold', {
        exec: callBack,
        hotkeys: ['ctrl+b', 'cmd+b']
    })
        .registerCommand('italic', {
        exec: callBack,
        hotkeys: ['ctrl+i', 'cmd+i']
    })
        .registerCommand('underline', {
        exec: callBack,
        hotkeys: ['ctrl+u', 'cmd+u']
    })
        .registerCommand('strikethrough', {
        exec: callBack
    });
}
exports.bold = bold;


/***/ }),
/* 245 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.cleanHtml = void 0;
var tslib_1 = __webpack_require__(7);
var config_1 = __webpack_require__(8);
var constants_1 = __webpack_require__(9);
var modules_1 = __webpack_require__(10);
var helpers_1 = __webpack_require__(19);
var plugin_1 = __webpack_require__(184);
var decorators_1 = __webpack_require__(99);
var helpers_2 = __webpack_require__(243);
config_1.Config.prototype.cleanHTML = {
    timeout: 300,
    removeEmptyElements: true,
    fillEmptyParagraph: true,
    replaceNBSP: true,
    replaceOldTags: {
        i: 'em',
        b: 'strong'
    },
    allowTags: false,
    denyTags: false
};
config_1.Config.prototype.controls.eraser = {
    command: 'removeFormat',
    tooltip: 'Clear Formatting'
};
var cleanHtml = (function (_super) {
    tslib_1.__extends(cleanHtml, _super);
    function cleanHtml() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.buttons = [
            {
                name: 'eraser',
                group: 'font-style'
            }
        ];
        _this.visitNode = function (nodeElm, current, remove) {
            var work = false;
            if (!nodeElm) {
                return work;
            }
            if (_this.isRemovableNode(nodeElm, current)) {
                remove.push(nodeElm);
                return _this.visitNode(nodeElm.nextSibling, current, remove);
            }
            if (_this.j.o.cleanHTML.fillEmptyParagraph &&
                modules_1.Dom.isBlock(nodeElm, _this.j.ew) &&
                modules_1.Dom.isEmpty(nodeElm, /^(img|svg|canvas|input|textarea|form|br)$/)) {
                var br = _this.j.createInside.element('br');
                nodeElm.appendChild(br);
                work = true;
            }
            var allow = _this.allowTagsHash;
            if (allow && allow[nodeElm.nodeName] !== true) {
                var attrs = nodeElm.attributes;
                if (attrs && attrs.length) {
                    var removeAttrs = [];
                    for (var i = 0; i < attrs.length; i += 1) {
                        var attr = allow[nodeElm.nodeName][attrs[i].name];
                        if (!attr || (attr !== true && attr !== attrs[i].value)) {
                            removeAttrs.push(attrs[i].name);
                        }
                    }
                    if (removeAttrs.length) {
                        work = true;
                    }
                    removeAttrs.forEach(function (attr) {
                        nodeElm.removeAttribute(attr);
                    });
                }
            }
            work = _this.visitNode(nodeElm.firstChild, current, remove) || work;
            work = _this.visitNode(nodeElm.nextSibling, current, remove) || work;
            return work;
        };
        _this.allowTagsHash = cleanHtml.getHash(_this.j.o.cleanHTML.allowTags);
        _this.denyTagsHash = cleanHtml.getHash(_this.j.o.cleanHTML.denyTags);
        _this.onKeyUpCleanUp = function () {
            var editor = _this.j;
            if (!_this.allowEdit()) {
                return;
            }
            var currentNode = editor.s.current();
            if (currentNode) {
                var currentParagraph = modules_1.Dom.up(currentNode, function (node) { return modules_1.Dom.isBlock(node, editor.ew); }, editor.editor);
                if (currentParagraph) {
                    modules_1.Dom.all(currentParagraph, function (node) {
                        if (node && modules_1.Dom.isText(node)) {
                            if (node.nodeValue != null &&
                                constants_1.INVISIBLE_SPACE_REG_EXP().test(node.nodeValue) &&
                                node.nodeValue.replace(constants_1.INVISIBLE_SPACE_REG_EXP(), '').length !== 0) {
                                node.nodeValue = node.nodeValue.replace(constants_1.INVISIBLE_SPACE_REG_EXP(), '');
                                if (node === currentNode &&
                                    editor.s.isCollapsed()) {
                                    editor.s.setCursorAfter(node);
                                }
                            }
                        }
                    });
                }
            }
        };
        _this.beforeCommand = function (command) {
            if (command.toLowerCase() === 'removeformat') {
                _this.onRemoveFormat();
                return false;
            }
        };
        return _this;
    }
    cleanHtml.prototype.afterInit = function (jodit) {
        jodit.e
            .off('.cleanHtml')
            .on('change.cleanHtml afterSetMode.cleanHtml afterInit.cleanHtml mousedown.cleanHtml keydown.cleanHtml', this.onChangeCleanHTML)
            .on('keyup.cleanHtml', this.onKeyUpCleanUp)
            .on('beforeCommand.cleanHtml', this.beforeCommand);
    };
    cleanHtml.prototype.onChangeCleanHTML = function () {
        if (!this.allowEdit()) {
            return;
        }
        var editor = this.j;
        var current = editor.s.current();
        var replaceOldTags = editor.o.cleanHTML.replaceOldTags;
        if (replaceOldTags && current) {
            var tags = helpers_1.keys(replaceOldTags, false);
            if (editor.s.isCollapsed()) {
                var oldParent = modules_1.Dom.closest(current, tags, editor.editor);
                if (oldParent) {
                    editor.s.save();
                    var tagName = replaceOldTags[oldParent.nodeName.toLowerCase()] ||
                        replaceOldTags[oldParent.nodeName];
                    modules_1.Dom.replace(oldParent, tagName, editor.createInside, true, false);
                    editor.s.restore();
                }
            }
        }
        var node = null;
        if (editor.editor.firstChild) {
            node = editor.editor.firstChild;
        }
        var remove = [];
        var work = this.visitNode(node, current, remove);
        remove.forEach(modules_1.Dom.safeRemove);
        if (remove.length || work) {
            editor.events && editor.e.fire('synchro');
        }
    };
    cleanHtml.prototype.allowEdit = function () {
        return !(this.j.isInDestruct ||
            !this.j.isEditorMode() ||
            this.j.getReadOnly());
    };
    cleanHtml.getHash = function (tags) {
        var attributesReg = /([^[]*)\[([^\]]+)]/;
        var seperator = /[\s]*,[\s]*/, attrReg = /^(.*)[\s]*=[\s]*(.*)$/;
        var tagsHash = {};
        if (helpers_1.isString(tags)) {
            tags.split(seperator).map(function (elm) {
                elm = helpers_1.trim(elm);
                var attr = attributesReg.exec(elm), allowAttributes = {}, attributeMap = function (attrName) {
                    attrName = helpers_1.trim(attrName);
                    var val = attrReg.exec(attrName);
                    if (val) {
                        allowAttributes[val[1]] = val[2];
                    }
                    else {
                        allowAttributes[attrName] = true;
                    }
                };
                if (attr) {
                    var attr2 = attr[2].split(seperator);
                    if (attr[1]) {
                        attr2.forEach(attributeMap);
                        tagsHash[attr[1].toUpperCase()] = allowAttributes;
                    }
                }
                else {
                    tagsHash[elm.toUpperCase()] = true;
                }
            });
            return tagsHash;
        }
        if (tags) {
            Object.keys(tags).forEach(function (tagName) {
                tagsHash[tagName.toUpperCase()] = tags[tagName];
            });
            return tagsHash;
        }
        return false;
    };
    cleanHtml.prototype.onRemoveFormat = function () {
        if (this.j.s.isCollapsed()) {
            this.removeFormatForCollapsedSelection();
        }
        else {
            this.removeFormatForSelection();
        }
    };
    cleanHtml.prototype.removeFormatForCollapsedSelection = function (fake) {
        var s = this.j.s;
        var fakeNode = fake;
        if (!fakeNode) {
            fakeNode = this.j.createInside.fake();
            s.range.insertNode(fakeNode);
            s.range.collapse();
        }
        var mainInline = modules_1.Dom.furthest(fakeNode, this.isInlineBlock, this.j.editor);
        if (mainInline) {
            if (s.cursorOnTheLeft(mainInline)) {
                modules_1.Dom.before(mainInline, fakeNode);
            }
            else if (s.cursorOnTheRight(mainInline)) {
                modules_1.Dom.after(mainInline, fakeNode);
            }
            else {
                var leftHand = s.splitSelection(mainInline);
                leftHand && modules_1.Dom.after(leftHand, fakeNode);
            }
        }
        if (!fake) {
            s.setCursorBefore(fakeNode);
            modules_1.Dom.safeRemove(fakeNode);
        }
    };
    cleanHtml.prototype.isInlineBlock = function (node) {
        return modules_1.Dom.isInlineBlock(node) && !modules_1.Dom.isTag(node, constants_1.INSEPARABLE_TAGS);
    };
    cleanHtml.prototype.removeFormatForSelection = function () {
        var _this = this;
        var s = this.j.s, range = s.range, left = range.cloneRange(), right = range.cloneRange(), fakeLeft = this.j.createInside.fake(), fakeRight = this.j.createInside.fake();
        left.collapse(true);
        right.collapse(false);
        left.insertNode(fakeLeft);
        right.insertNode(fakeRight);
        range.setStartBefore(fakeLeft);
        range.collapse(true);
        s.selectRange(range);
        this.removeFormatForCollapsedSelection(fakeLeft);
        range.setEndAfter(fakeRight);
        range.collapse(false);
        s.selectRange(range);
        this.removeFormatForCollapsedSelection(fakeRight);
        var shouldUnwrap = [];
        modules_1.Dom.between(fakeLeft, fakeRight, function (node) {
            if (_this.isInlineBlock(node)) {
                shouldUnwrap.push(node);
            }
        });
        shouldUnwrap.forEach(function (node) { return modules_1.Dom.unwrap(node); });
        var clearParent = function (node, left) {
            if (!helpers_2.findNotEmptySibling(node, left)) {
                var pn = node.parentNode;
                if (pn && pn !== s.area && pn.getAttribute('style')) {
                    pn.removeAttribute('style');
                    clearParent(pn, left);
                    return true;
                }
            }
        };
        clearParent(fakeLeft, true) && clearParent(fakeRight, false);
        range.setStartAfter(fakeLeft);
        range.setEndBefore(fakeRight);
        s.selectRange(range);
        modules_1.Dom.safeRemove(fakeLeft);
        modules_1.Dom.safeRemove(fakeRight);
    };
    cleanHtml.prototype.isRemovableNode = function (node, current) {
        var _this = this;
        var allow = this.allowTagsHash;
        if (!modules_1.Dom.isText(node) &&
            ((allow && !allow[node.nodeName]) ||
                (this.denyTagsHash && this.denyTagsHash[node.nodeName]))) {
            return true;
        }
        if (current &&
            modules_1.Dom.isTag(node, 'br') &&
            cleanHtml.hasNotEmptyTextSibling(node) &&
            !cleanHtml.hasNotEmptyTextSibling(node, true) &&
            modules_1.Dom.up(node, function (node) { return modules_1.Dom.isBlock(node, _this.j.ew); }, this.j.editor) !==
                modules_1.Dom.up(current, function (node) { return modules_1.Dom.isBlock(node, _this.j.ew); }, this.j.editor)) {
            return true;
        }
        return (this.j.o.cleanHTML.removeEmptyElements &&
            current != null &&
            modules_1.Dom.isElement(node) &&
            node.nodeName.match(constants_1.IS_INLINE) != null &&
            !this.j.s.isMarker(node) &&
            helpers_1.trim(node.innerHTML).length === 0 &&
            !modules_1.Dom.isOrContains(node, current));
    };
    cleanHtml.hasNotEmptyTextSibling = function (node, next) {
        if (next === void 0) { next = false; }
        var prev = next ? node.nextSibling : node.previousSibling;
        while (prev) {
            if (modules_1.Dom.isElement(prev) || !modules_1.Dom.isEmptyTextNode(prev)) {
                return true;
            }
            prev = next ? prev.nextSibling : prev.previousSibling;
        }
        return false;
    };
    cleanHtml.prototype.beforeDestruct = function () {
        this.j.e.off('.cleanHtml');
    };
    tslib_1.__decorate([
        decorators_1.debounce(function (ctx) { return ctx.jodit.o.cleanHTML.timeout; })
    ], cleanHtml.prototype, "onChangeCleanHTML", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], cleanHtml.prototype, "isInlineBlock", null);
    return cleanHtml;
}(plugin_1.Plugin));
exports.cleanHtml = cleanHtml;


/***/ }),
/* 246 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WrapTextNodes = void 0;
var tslib_1 = __webpack_require__(7);
var plugin_1 = __webpack_require__(184);
var dom_1 = __webpack_require__(32);
var checker_1 = __webpack_require__(34);
var decorators_1 = __webpack_require__(99);
var WrapTextNodes = (function (_super) {
    tslib_1.__extends(WrapTextNodes, _super);
    function WrapTextNodes() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isSuitableStart = function (n) {
            return (dom_1.Dom.isText(n) && checker_1.isString(n.nodeValue) && /[^\s]/.test(n.nodeValue)) ||
                (_this.isNotClosed(n) && !_this.jodit.selection.isMarker(n));
        };
        _this.isSuitable = function (n) {
            return dom_1.Dom.isText(n) || _this.isNotClosed(n);
        };
        _this.isNotClosed = function (n) {
            return dom_1.Dom.isElement(n) &&
                !(dom_1.Dom.isBlock(n, _this.jodit.ew) || dom_1.Dom.isTag(n, ['hr', 'style']));
        };
        return _this;
    }
    WrapTextNodes.prototype.afterInit = function (jodit) {
        if (jodit.o.enter.toLowerCase() === 'br') {
            return;
        }
        jodit.e.on('afterInit.wtn postProcessSetEditorValue.wtn', this.postProcessSetEditorValue);
    };
    WrapTextNodes.prototype.beforeDestruct = function (jodit) {
        jodit.e.off('.wtn');
    };
    WrapTextNodes.prototype.postProcessSetEditorValue = function () {
        var jodit = this.jodit;
        if (!jodit.isEditorMode()) {
            return;
        }
        var child = jodit.editor.firstChild, isChanged = false;
        while (child) {
            if (this.isSuitableStart(child)) {
                if (!isChanged) {
                    jodit.s.save();
                }
                isChanged = true;
                var box_1 = jodit.createInside.element(jodit.o.enter);
                dom_1.Dom.before(child, box_1);
                while (child && this.isSuitable(child)) {
                    var next = child.nextSibling;
                    box_1.appendChild(child);
                    child = next;
                }
                box_1.normalize();
            }
            child = child && child.nextSibling;
        }
        if (isChanged) {
            jodit.s.restore();
            if (jodit.e.current === 'afterInit') {
                jodit.e.fire('internalChange');
            }
        }
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], WrapTextNodes.prototype, "postProcessSetEditorValue", null);
    return WrapTextNodes;
}(plugin_1.Plugin));
exports.WrapTextNodes = WrapTextNodes;


/***/ }),
/* 247 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
__webpack_require__(248);
tslib_1.__exportStar(__webpack_require__(250), exports);
tslib_1.__exportStar(__webpack_require__(251), exports);
tslib_1.__exportStar(__webpack_require__(252), exports);
tslib_1.__exportStar(__webpack_require__(254), exports);


/***/ }),
/* 248 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var _a;
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
var config_1 = __webpack_require__(8);
var constants_1 = __webpack_require__(9);
var dialog_1 = __webpack_require__(163);
var helpers_1 = __webpack_require__(249);
var clipboard_1 = __webpack_require__(250);
config_1.Config.prototype.askBeforePasteHTML = true;
config_1.Config.prototype.processPasteHTML = true;
config_1.Config.prototype.askBeforePasteFromWord = true;
config_1.Config.prototype.processPasteFromWord = true;
config_1.Config.prototype.nl2brInPlainText = true;
config_1.Config.prototype.defaultActionOnPaste = constants_1.INSERT_AS_HTML;
config_1.Config.prototype.defaultActionOnPasteFromWord = null;
config_1.Config.prototype.draggableTags = ['img', 'a', 'jodit-media', 'jodit'];
config_1.Config.prototype.controls.cut = {
    command: 'cut',
    isDisabled: function (editor) { return editor.s.isCollapsed(); },
    tooltip: 'Cut selection'
};
config_1.Config.prototype.controls.copy = {
    command: 'copy',
    isDisabled: function (editor) { return editor.s.isCollapsed(); },
    tooltip: 'Copy selection'
};
var psKey = 'pasteStorage';
config_1.Config.prototype.controls.paste = {
    tooltip: 'Paste from clipboard',
    exec: function (editor, _, _a) {
        var control = _a.control;
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var text, error, items, textBlob, e_1, e_2, value;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (control.name === psKey) {
                            editor.execCommand('showPasteStorage');
                            return [2];
                        }
                        editor.s.focus();
                        text = '', error = true;
                        if (!navigator.clipboard) return [3, 11];
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 6, , 7]);
                        return [4, navigator.clipboard.read()];
                    case 2:
                        items = _b.sent();
                        if (!(items && items.length)) return [3, 5];
                        return [4, items[0].getType(constants_1.TEXT_PLAIN)];
                    case 3:
                        textBlob = _b.sent();
                        return [4, new Response(textBlob).text()];
                    case 4:
                        text = _b.sent();
                        _b.label = 5;
                    case 5:
                        error = false;
                        return [3, 7];
                    case 6:
                        e_1 = _b.sent();
                        if (false) {}
                        return [3, 7];
                    case 7:
                        if (!error) return [3, 11];
                        _b.label = 8;
                    case 8:
                        _b.trys.push([8, 10, , 11]);
                        return [4, navigator.clipboard.readText()];
                    case 9:
                        text = _b.sent();
                        error = false;
                        return [3, 11];
                    case 10:
                        e_2 = _b.sent();
                        if (false) {}
                        return [3, 11];
                    case 11:
                        if (error) {
                            text = editor.buffer.get(clipboard_1.pluginKey) || '';
                            error = text.length === 0;
                        }
                        value = editor.value;
                        if (error) {
                            editor.ed.execCommand('paste');
                            error = value === editor.value;
                            !error && editor.e.fire('afterPaste');
                        }
                        else if (text.length) {
                            helpers_1.pasteInsertHtml(null, editor, text);
                            editor.e.fire('afterPaste');
                        }
                        else {
                            if (error) {
                                dialog_1.Alert(editor.i18n("Your browser doesn't support direct access to the clipboard."), function () {
                                    editor.s.focus();
                                }).bindDestruct(editor);
                            }
                        }
                        return [2];
                }
            });
        });
    },
    list: (_a = {},
        _a[psKey] = 'Paste Storage',
        _a),
    isChildDisabled: function (j) {
        return j.e.fire('pasteStorageList') < 2;
    }
};
config_1.Config.prototype.controls.selectall = {
    icon: 'select-all',
    command: 'selectall',
    tooltip: 'Select all'
};


/***/ }),
/* 249 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getAllTypes = exports.pasteInsertHtml = exports.getDataTransfer = void 0;
var helpers_1 = __webpack_require__(19);
var dom_1 = __webpack_require__(32);
var constants_1 = __webpack_require__(9);
var getDataTransfer = function (event) {
    if (event.clipboardData) {
        return event.clipboardData;
    }
    try {
        return event.dataTransfer || new DataTransfer();
    }
    catch (_a) {
        return null;
    }
};
exports.getDataTransfer = getDataTransfer;
function removeExtraFragments(html) {
    html = html.replace(/<meta[^>]+?>/g, '');
    var start = html.search(/<!--StartFragment-->/i);
    if (start !== -1) {
        html = html.substr(start + 20);
    }
    var end = html.search(/<!--EndFragment-->/i);
    if (end !== -1) {
        html = html.substr(0, end);
    }
    return html;
}
function pasteInsertHtml(e, editor, html) {
    if (editor.isInDestruct) {
        return;
    }
    if ((e === null || e === void 0 ? void 0 : e.type) === 'drop') {
        editor.s.insertCursorAtPoint(e.clientX, e.clientY);
    }
    var result = editor.e.fire('beforePasteInsert', html);
    if (!helpers_1.isVoid(result) &&
        (helpers_1.isString(result) || helpers_1.isNumber(result) || dom_1.Dom.isNode(result, editor.ew))) {
        html = result;
    }
    if (helpers_1.isString(html)) {
        html = removeExtraFragments(html);
    }
    editor.s.insertHTML(html);
}
exports.pasteInsertHtml = pasteInsertHtml;
function getAllTypes(dt) {
    var types = dt.types;
    var types_str = '';
    if (helpers_1.isArray(types) ||
        {}.toString.call(types) === '[object DOMStringList]') {
        for (var i = 0; i < types.length; i += 1) {
            types_str += types[i] + ';';
        }
    }
    else {
        types_str = (types || constants_1.TEXT_PLAIN).toString() + ';';
    }
    return types_str;
}
exports.getAllTypes = getAllTypes;


/***/ }),
/* 250 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.clipboard = exports.pluginKey = void 0;
var constants_1 = __webpack_require__(9);
var helpers_1 = __webpack_require__(19);
var helpers_2 = __webpack_require__(249);
exports.pluginKey = 'clipboard';
var clipboard = (function () {
    function clipboard() {
        this.buttons = [
            {
                name: 'cut',
                group: 'clipboard'
            },
            {
                name: 'copy',
                group: 'clipboard'
            },
            {
                name: 'paste',
                group: 'clipboard'
            },
            {
                name: 'selectall',
                group: 'clipboard'
            }
        ];
    }
    clipboard.prototype.init = function (editor) {
        var _a;
        (_a = this.buttons) === null || _a === void 0 ? void 0 : _a.forEach(function (btn) { return editor.registerButton(btn); });
        editor.e
            .off("copy." + exports.pluginKey + " cut." + exports.pluginKey)
            .on("copy." + exports.pluginKey + " cut." + exports.pluginKey, function (event) {
            var _a;
            var selectedText = editor.s.html;
            var clipboardData = helpers_2.getDataTransfer(event) ||
                helpers_2.getDataTransfer(editor.ew) ||
                helpers_2.getDataTransfer(event.originalEvent);
            if (clipboardData) {
                clipboardData.setData(constants_1.TEXT_PLAIN, helpers_1.stripTags(selectedText));
                clipboardData.setData(constants_1.TEXT_HTML, selectedText);
            }
            editor.buffer.set(exports.pluginKey, selectedText);
            editor.e.fire('pasteStack', {
                html: selectedText,
                action: editor.o.defaultActionOnPaste
            });
            if (event.type === 'cut') {
                editor.s.remove();
                editor.s.focus();
            }
            event.preventDefault();
            (_a = editor === null || editor === void 0 ? void 0 : editor.events) === null || _a === void 0 ? void 0 : _a.fire('afterCopy', selectedText);
        });
    };
    clipboard.prototype.destruct = function (editor) {
        var _a, _b;
        (_a = editor === null || editor === void 0 ? void 0 : editor.buffer) === null || _a === void 0 ? void 0 : _a.set(exports.pluginKey, '');
        (_b = editor === null || editor === void 0 ? void 0 : editor.events) === null || _b === void 0 ? void 0 : _b.off('.' + exports.pluginKey);
    };
    return clipboard;
}());
exports.clipboard = clipboard;


/***/ }),
/* 251 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.paste = void 0;
var tslib_1 = __webpack_require__(7);
var plugin_1 = __webpack_require__(184);
var helpers_1 = __webpack_require__(249);
var constants_1 = __webpack_require__(9);
var helpers_2 = __webpack_require__(19);
var clipboard_1 = __webpack_require__(250);
var dom_1 = __webpack_require__(32);
var dialog_1 = __webpack_require__(163);
var button_1 = __webpack_require__(92);
var decorators_1 = __webpack_require__(99);
var paste = (function (_super) {
    tslib_1.__extends(paste, _super);
    function paste() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.pasteStack = new helpers_2.LimitedStack(20);
        return _this;
    }
    paste.prototype.afterInit = function (jodit) {
        var _this = this;
        jodit.e
            .on('paste.paste', this.onPaste)
            .on('pasteStack.paste', function (item) {
            return _this.pasteStack.push(item);
        });
        if (jodit.o.nl2brInPlainText) {
            this.j.e.on('processPaste.paste', this.onProcessPasteReplaceNl2Br);
        }
    };
    paste.prototype.onPaste = function (e) {
        try {
            if (this.customPasteProcess(e) === false ||
                this.j.e.fire('beforePaste', e) === false) {
                e.preventDefault();
                return false;
            }
            this.defaultPasteProcess(e);
        }
        finally {
            this.j.e.fire('afterPaste', e);
        }
    };
    paste.prototype.customPasteProcess = function (e) {
        if (!this.j.o.processPasteHTML) {
            return;
        }
        var dt = helpers_1.getDataTransfer(e), texts = [dt === null || dt === void 0 ? void 0 : dt.getData(constants_1.TEXT_HTML), dt === null || dt === void 0 ? void 0 : dt.getData(constants_1.TEXT_PLAIN)];
        for (var _i = 0, texts_1 = texts; _i < texts_1.length; _i++) {
            var text = texts_1[_i];
            if (helpers_2.isHTML(text) &&
                (this.processWordHTML(e, text) || this.processHTML(e, text))) {
                return false;
            }
        }
    };
    paste.prototype.defaultPasteProcess = function (e) {
        var dt = helpers_1.getDataTransfer(e);
        var text = (dt === null || dt === void 0 ? void 0 : dt.getData(constants_1.TEXT_HTML)) || (dt === null || dt === void 0 ? void 0 : dt.getData(constants_1.TEXT_PLAIN));
        if (dt && text && helpers_2.trim(text) !== '') {
            var result = this.j.e.fire('processPaste', e, text, helpers_1.getAllTypes(dt));
            if (result !== undefined) {
                text = result;
            }
            if (helpers_2.isString(text) || dom_1.Dom.isNode(text, this.j.ew)) {
                this.insertByType(e, text, this.j.o.defaultActionOnPaste);
            }
            e.preventDefault();
            e.stopPropagation();
        }
    };
    paste.prototype.processWordHTML = function (e, text) {
        var _this = this;
        if (this.j.o.processPasteFromWord && helpers_2.isHtmlFromWord(text)) {
            if (this.j.o.askBeforePasteFromWord) {
                this.askInsertTypeDialog('The pasted content is coming from a Microsoft Word/Excel document. ' +
                    'Do you want to keep the format or clean it up?', 'Word Paste Detected', function (insertType) {
                    _this.insertFromWordByType(e, text, insertType);
                });
            }
            else {
                this.insertFromWordByType(e, text, this.j.o.defaultActionOnPasteFromWord ||
                    this.j.o.defaultActionOnPaste);
            }
            return true;
        }
        return false;
    };
    paste.prototype.processHTML = function (e, html) {
        var _this = this;
        if (this.j.o.askBeforePasteHTML) {
            var cached = this.pasteStack.find(function (cachedItem) { return cachedItem.html === html; });
            if (cached) {
                this.insertByType(e, html, cached.action || this.j.o.defaultActionOnPaste);
                return true;
            }
            this.askInsertTypeDialog('Your code is similar to HTML. Keep as HTML?', 'Paste as HTML', function (insertType) {
                _this.insertByType(e, html, insertType);
            }, 'Insert as Text');
            return true;
        }
        return false;
    };
    paste.prototype.insertFromWordByType = function (e, html, insertType) {
        var _a;
        switch (insertType) {
            case constants_1.INSERT_AS_HTML: {
                html = helpers_2.applyStyles(html);
                if (this.j.o.beautifyHTML) {
                    var value = (_a = this.j.events) === null || _a === void 0 ? void 0 : _a.fire('beautifyHTML', html);
                    if (helpers_2.isString(value)) {
                        html = value;
                    }
                }
                break;
            }
            case constants_1.INSERT_AS_TEXT: {
                html = helpers_2.cleanFromWord(html);
                break;
            }
            case constants_1.INSERT_ONLY_TEXT: {
                html = helpers_2.stripTags(helpers_2.cleanFromWord(html));
                break;
            }
        }
        helpers_1.pasteInsertHtml(e, this.j, html);
    };
    paste.prototype.insertByType = function (e, html, action) {
        this.pasteStack.push({ html: html, action: action });
        if (helpers_2.isString(html)) {
            this.j.buffer.set(clipboard_1.pluginKey, html);
            switch (action) {
                case constants_1.INSERT_CLEAR_HTML:
                    html = helpers_2.cleanFromWord(html);
                    break;
                case constants_1.INSERT_ONLY_TEXT:
                    html = helpers_2.stripTags(html);
                    break;
                case constants_1.INSERT_AS_TEXT:
                    html = helpers_2.htmlspecialchars(html);
                    break;
                default:
            }
        }
        helpers_1.pasteInsertHtml(e, this.j, html);
    };
    paste.prototype.askInsertTypeDialog = function (msg, title, callback, clearButton, insertText) {
        var _a, _b, _c, _d;
        if (clearButton === void 0) { clearButton = 'Clean'; }
        if (insertText === void 0) { insertText = 'Insert only Text'; }
        if (((_b = (_a = this.j) === null || _a === void 0 ? void 0 : _a.e) === null || _b === void 0 ? void 0 : _b.fire('beforeOpenPasteDialog', msg, title, callback, clearButton, insertText)) === false) {
            return;
        }
        var dialog = dialog_1.Confirm("<div style=\"word-break: normal; white-space: normal\">" + this.j.i18n(msg) + "</div>", this.j.i18n(title));
        dialog.bindDestruct(this.j);
        helpers_2.markOwner(this.j, dialog.container);
        var keep = button_1.Button(this.j, {
            text: 'Keep',
            name: 'keep',
            status: 'primary',
            tabIndex: 0
        });
        var clear = button_1.Button(this.j, {
            text: clearButton,
            tabIndex: 0
        });
        var clear2 = button_1.Button(this.j, {
            text: insertText,
            tabIndex: 0
        });
        var cancel = button_1.Button(this.j, {
            text: 'Cancel',
            tabIndex: 0
        });
        keep.onAction(function () {
            dialog.close();
            callback && callback(constants_1.INSERT_AS_HTML);
        });
        clear.onAction(function () {
            dialog.close();
            callback && callback(constants_1.INSERT_AS_TEXT);
        });
        clear2.onAction(function () {
            dialog.close();
            callback && callback(constants_1.INSERT_ONLY_TEXT);
        });
        cancel.onAction(function () {
            dialog.close();
        });
        dialog.setFooter([keep, clear, insertText ? clear2 : '', cancel]);
        keep.focus();
        (_d = (_c = this.j) === null || _c === void 0 ? void 0 : _c.e) === null || _d === void 0 ? void 0 : _d.fire('afterOpenPasteDialog', dialog, msg, title, callback, clearButton, insertText);
        return dialog;
    };
    paste.prototype.onProcessPasteReplaceNl2Br = function (event, text, type) {
        if (type === constants_1.TEXT_PLAIN + ';' && !helpers_2.isHTML(text)) {
            return helpers_2.nl2br(text);
        }
    };
    paste.prototype.useFakeDivBox = function (event) {
        var _this = this;
        var div = this.j.c.div('', {
            tabindex: -1,
            contenteditable: true,
            style: {
                left: -9999,
                top: 0,
                width: 0,
                height: '100%',
                lineHeight: '140%',
                overflow: 'hidden',
                position: 'fixed',
                zIndex: 2147483647,
                wordBreak: 'break-all'
            }
        });
        this.j.container.appendChild(div);
        this.j.s.save();
        div.focus();
        var tick = 0;
        var removeFakeFocus = function () {
            dom_1.Dom.safeRemove(div);
            _this.j.selection && _this.j.s.restore();
        };
        var waitData = function () {
            tick += 1;
            if (div.childNodes && div.childNodes.length > 0) {
                var pastedData = div.innerHTML;
                removeFakeFocus();
                _this.processHTML(event, pastedData);
                return;
            }
            if (tick < 5) {
                _this.j.async.setTimeout(waitData, 20);
            }
            else {
                removeFakeFocus();
            }
        };
        waitData();
    };
    paste.prototype.beforeDestruct = function (jodit) {
        jodit.e.off('paste.paste', this.onPaste);
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], paste.prototype, "onPaste", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], paste.prototype, "onProcessPasteReplaceNl2Br", null);
    return paste;
}(plugin_1.Plugin));
exports.paste = paste;


/***/ }),
/* 252 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.pasteStorage = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(253);
var constants_1 = __webpack_require__(9);
var dialog_1 = __webpack_require__(163);
var plugin_1 = __webpack_require__(184);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var pasteStorage = (function (_super) {
    tslib_1.__extends(pasteStorage, _super);
    function pasteStorage() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.currentIndex = 0;
        _this.list = [];
        _this.container = null;
        _this.listBox = null;
        _this.previewBox = null;
        _this.dialog = null;
        _this.paste = function () {
            _this.j.s.focus();
            _this.j.s.insertHTML(_this.list[_this.currentIndex]);
            if (_this.currentIndex !== 0) {
                var buffer = _this.list[0];
                _this.list[0] = _this.list[_this.currentIndex];
                _this.list[_this.currentIndex] = buffer;
            }
            _this.dialog && _this.dialog.close();
            _this.j.setEditorValue();
            _this.j.e.fire('afterPaste');
        };
        _this.onKeyDown = function (e) {
            var index = _this.currentIndex;
            if ([constants_1.KEY_UP, constants_1.KEY_DOWN, constants_1.KEY_ENTER].indexOf(e.key) === -1) {
                return;
            }
            if (e.key === constants_1.KEY_UP) {
                if (index === 0) {
                    index = _this.list.length - 1;
                }
                else {
                    index -= 1;
                }
            }
            if (e.key === constants_1.KEY_DOWN) {
                if (index === _this.list.length - 1) {
                    index = 0;
                }
                else {
                    index += 1;
                }
            }
            if (e.key === constants_1.KEY_ENTER) {
                _this.paste();
                return;
            }
            if (index !== _this.currentIndex) {
                _this.selectIndex(index);
            }
            e.stopImmediatePropagation();
            e.preventDefault();
        };
        _this.selectIndex = function (index) {
            if (_this.listBox) {
                helpers_1.toArray(_this.listBox.childNodes).forEach(function (a, i) {
                    a.classList.remove('jodit_active');
                    if (index === i && _this.previewBox) {
                        a.classList.add('jodit_active');
                        _this.previewBox.innerHTML = _this.list[index];
                        a.focus();
                    }
                });
            }
            _this.currentIndex = index;
        };
        _this.showDialog = function () {
            if (_this.list.length < 2) {
                return;
            }
            _this.dialog || _this.createDialog();
            if (_this.listBox) {
                _this.listBox.innerHTML = '';
            }
            if (_this.previewBox) {
                _this.previewBox.innerHTML = '';
            }
            _this.list.forEach(function (html, index) {
                var a = _this.j.c.element('a');
                a.textContent =
                    index + 1 + '. ' + html.replace(constants_1.SPACE_REG_EXP(), '');
                _this.j.e.on(a, 'keydown', _this.onKeyDown);
                helpers_1.attr(a, 'href', 'javascript:void(0)');
                helpers_1.attr(a, 'data-index', index.toString());
                helpers_1.attr(a, 'tab-index', '-1');
                _this.listBox && _this.listBox.appendChild(a);
            });
            _this.dialog && _this.dialog.open();
            _this.j.async.setTimeout(function () {
                _this.selectIndex(0);
            }, 100);
        };
        return _this;
    }
    pasteStorage.prototype.createDialog = function () {
        var _this = this;
        this.dialog = new dialog_1.Dialog({
            language: this.j.o.language
        });
        var pasteButton = this.j.c.fromHTML('<a href="javascript:void(0)" style="float:right;" class="jodit-button">' +
            '<span>' +
            this.j.i18n('Paste') +
            '</span>' +
            '</a>');
        this.j.e.on(pasteButton, 'click', this.paste);
        var cancelButton = this.j.c.fromHTML('<a href="javascript:void(0)" style="float:right; margin-right: 10px;" class="jodit-button">' +
            '<span>' +
            this.j.i18n('Cancel') +
            '</span>' +
            '</a>');
        this.j.e.on(cancelButton, 'click', this.dialog.close);
        this.container = this.j.c.div();
        this.container.classList.add('jodit-paste-storage');
        this.listBox = this.j.c.div();
        this.previewBox = this.j.c.div();
        this.container.appendChild(this.listBox);
        this.container.appendChild(this.previewBox);
        this.dialog.setHeader(this.j.i18n('Choose Content to Paste'));
        this.dialog.setContent(this.container);
        this.dialog.setFooter([pasteButton, cancelButton]);
        this.j.e.on(this.listBox, 'click dblclick', function (e) {
            var a = e.target;
            if (dom_1.Dom.isTag(a, 'a') && a.hasAttribute('data-index')) {
                _this.selectIndex(parseInt(helpers_1.attr(a, '-index') || '0', 10));
            }
            if (e.type === 'dblclick') {
                _this.paste();
            }
            return false;
        });
    };
    pasteStorage.prototype.afterInit = function () {
        var _this = this;
        this.j.e
            .off('afterCopy.paste-storage')
            .on('pasteStorageList.paste-storage', function () { return _this.list.length; })
            .on('afterCopy.paste-storage', function (html) {
            if (_this.list.indexOf(html) !== -1) {
                _this.list.splice(_this.list.indexOf(html), 1);
            }
            _this.list.unshift(html);
            if (_this.list.length > 5) {
                _this.list.length = 5;
            }
        });
        this.j.registerCommand('showPasteStorage', {
            exec: this.showDialog,
            hotkeys: ['ctrl+shift+v', 'cmd+shift+v']
        });
    };
    pasteStorage.prototype.beforeDestruct = function () {
        this.dialog && this.dialog.destruct();
        this.j.e.off('.paste-storage');
        dom_1.Dom.safeRemove(this.previewBox);
        dom_1.Dom.safeRemove(this.listBox);
        dom_1.Dom.safeRemove(this.container);
        this.container = null;
        this.listBox = null;
        this.previewBox = null;
        this.dialog = null;
        this.list = [];
    };
    return pasteStorage;
}(plugin_1.Plugin));
exports.pasteStorage = pasteStorage;


/***/ }),
/* 253 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 254 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.copyFormat = void 0;
var config_1 = __webpack_require__(8);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var pluginKey = 'copyformat';
var copyStyles = [
    'fontWeight',
    'fontStyle',
    'fontSize',
    'color',
    'margin',
    'padding',
    'borderWidth',
    'borderStyle',
    'borderColor',
    'borderRadius',
    'backgroundColor',
    'textDecorationLine',
    'fontFamily'
];
var getStyle = function (editor, key, box, defaultStyles) {
    var result = helpers_1.css(box, key);
    if (result === defaultStyles[key]) {
        if (box.parentNode &&
            box !== editor.editor &&
            box.parentNode !== editor.editor) {
            result = getStyle(editor, key, box.parentNode, defaultStyles);
        }
        else {
            result = undefined;
        }
    }
    return result;
};
var getStyles = function (editor, box, defaultStyles) {
    var result = {};
    if (box) {
        copyStyles.forEach(function (key) {
            result[key] = getStyle(editor, key, box, defaultStyles);
            if (key.match(/border(Style|Color)/) && !result.borderWidth) {
                result[key] = undefined;
            }
        });
    }
    return result;
};
config_1.Config.prototype.controls.copyformat = {
    exec: function (editor, current, _a) {
        var button = _a.button;
        if (!current) {
            return;
        }
        if (editor.buffer.exists(pluginKey)) {
            editor.buffer.delete(pluginKey);
            editor.e.off(editor.editor, 'mouseup.' + pluginKey);
        }
        else {
            var defaultStyles_1 = {}, box_1 = dom_1.Dom.up(current, function (elm) { return elm && !dom_1.Dom.isText(elm); }, editor.editor) || editor.editor;
            var ideal_1 = editor.createInside.span();
            editor.editor.appendChild(ideal_1);
            copyStyles.forEach(function (key) {
                defaultStyles_1[key] = helpers_1.css(ideal_1, key);
            });
            if (ideal_1 !== editor.editor) {
                dom_1.Dom.safeRemove(ideal_1);
            }
            var format_1 = getStyles(editor, box_1, defaultStyles_1);
            var onMouseUp = function () {
                editor.buffer.delete(pluginKey);
                var currentNode = editor.s.current();
                if (currentNode) {
                    if (dom_1.Dom.isTag(currentNode, 'img')) {
                        helpers_1.css(currentNode, format_1);
                    }
                    else {
                        editor.s.applyStyle(format_1);
                    }
                }
                editor.e.off(editor.editor, 'mouseup.' + pluginKey);
            };
            editor.e.on(editor.editor, 'mouseup.' + pluginKey, onMouseUp);
            editor.buffer.set(pluginKey, true);
        }
        button.update();
    },
    isActive: function (editor) { return editor.buffer.exists(pluginKey); },
    tooltip: 'Paint format'
};
function copyFormat(editor) {
    editor.registerButton({
        name: 'copyformat',
        group: 'clipboard'
    });
}
exports.copyFormat = copyFormat;


/***/ }),
/* 255 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.color = void 0;
var config_1 = __webpack_require__(8);
var modules_1 = __webpack_require__(10);
var helpers_1 = __webpack_require__(19);
var widget_1 = __webpack_require__(256);
config_1.Config.prototype.controls.brush = {
    update: function (button) {
        var color = helpers_1.dataBind(button, 'color');
        var editor = button.j;
        var update = function (key, value) {
            if (value && value !== helpers_1.css(editor.editor, key).toString()) {
                button.state.icon.fill = value;
                return;
            }
        };
        if (color) {
            var mode = helpers_1.dataBind(button, 'color');
            update(mode === 'color' ? mode : 'background-color', color);
            return;
        }
        var current = editor.s.current();
        if (current && !button.state.disabled) {
            var currentBpx = modules_1.Dom.closest(current, function (elm) {
                return (modules_1.Dom.isBlock(elm, editor.ew) ||
                    (elm && modules_1.Dom.isElement(elm)));
            }, editor.editor) || editor.editor;
            update('color', helpers_1.css(currentBpx, 'color').toString());
            update('background-color', helpers_1.css(currentBpx, 'background-color').toString());
        }
        button.state.icon.fill = '';
        button.state.activated = false;
    },
    popup: function (editor, current, self, close, button) {
        var colorHEX = '', bg_color = '', tabs = [], currentElement = null;
        if (current &&
            current !== editor.editor &&
            modules_1.Dom.isNode(current, editor.ew)) {
            if (modules_1.Dom.isElement(current) &&
                editor.s.isCollapsed() &&
                !modules_1.Dom.isTag(current, ['br', 'hr'])) {
                currentElement = current;
            }
            modules_1.Dom.up(current, function (node) {
                if (modules_1.Dom.isHTMLElement(node, editor.ew)) {
                    var color_1 = helpers_1.css(node, 'color', undefined, true), background = helpers_1.css(node, 'background-color', undefined, true);
                    if (color_1) {
                        colorHEX = color_1.toString();
                        return true;
                    }
                    if (background) {
                        bg_color = background.toString();
                        return true;
                    }
                }
            }, editor.editor);
        }
        var backgroundTag = widget_1.ColorPickerWidget(editor, function (value) {
            if (!currentElement) {
                editor.execCommand('background', false, value);
            }
            else {
                currentElement.style.backgroundColor = value;
            }
            helpers_1.dataBind(button, 'color', value);
            helpers_1.dataBind(button, 'color-mode', 'background');
            close();
        }, bg_color);
        var colorTab = widget_1.ColorPickerWidget(editor, function (value) {
            if (!currentElement) {
                editor.execCommand('forecolor', false, value);
            }
            else {
                currentElement.style.color = value;
            }
            helpers_1.dataBind(button, 'color', value);
            helpers_1.dataBind(button, 'color-mode', 'color');
            close();
        }, colorHEX);
        tabs = [
            {
                name: 'Background',
                content: backgroundTag
            },
            {
                name: 'Text',
                content: colorTab
            }
        ];
        if (editor.o.colorPickerDefaultTab !== 'background') {
            tabs = tabs.reverse();
        }
        return widget_1.TabsWidget(editor, tabs, currentElement);
    },
    exec: function (jodit, current, _a) {
        var button = _a.button;
        var mode = helpers_1.dataBind(button, 'color-mode'), color = helpers_1.dataBind(button, 'color');
        if (!mode) {
            return false;
        }
        if (current &&
            current !== jodit.editor &&
            modules_1.Dom.isNode(current, jodit.ew) &&
            modules_1.Dom.isElement(current)) {
            switch (mode) {
                case 'color':
                    current.style.color = color;
                    break;
                case 'background':
                    current.style.backgroundColor = color;
                    break;
            }
        }
        else {
            jodit.execCommand(mode === 'background' ? mode : 'forecolor', false, color);
        }
    },
    tooltip: 'Fill color or set the text color'
};
function color(editor) {
    editor.registerButton({
        name: 'brush',
        group: 'color'
    });
    var callback = function (command, second, third) {
        var colorHEX = helpers_1.normalizeColor(third);
        switch (command) {
            case 'background':
                editor.s.applyStyle({
                    backgroundColor: !colorHEX ? '' : colorHEX
                });
                break;
            case 'forecolor':
                editor.s.applyStyle({
                    color: !colorHEX ? '' : colorHEX
                });
                break;
        }
        editor.setEditorValue();
        return false;
    };
    editor
        .registerCommand('forecolor', callback)
        .registerCommand('background', callback);
}
exports.color = color;


/***/ }),
/* 256 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(257), exports);
tslib_1.__exportStar(__webpack_require__(259), exports);
tslib_1.__exportStar(__webpack_require__(261), exports);


/***/ }),
/* 257 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColorPickerWidget = void 0;
__webpack_require__(258);
var helpers_1 = __webpack_require__(19);
var ui_1 = __webpack_require__(75);
var dom_1 = __webpack_require__(32);
var ColorPickerWidget = function (editor, callback, coldColor) {
    var valueHex = helpers_1.normalizeColor(coldColor), form = editor.c.div('jodit-color-picker'), iconPalette = editor.o.textIcons
        ? "<span>" + editor.i18n('palette') + "</span>"
        : ui_1.Icon.get('palette'), eachColor = function (colors) {
        var stack = [];
        if (helpers_1.isPlainObject(colors)) {
            Object.keys(colors).forEach(function (key) {
                stack.push('<div class="jodit-color-picker__group jodit-color-picker__group-' +
                    key +
                    '">');
                stack.push(eachColor(colors[key]));
                stack.push('</div>');
            });
        }
        else if (helpers_1.isArray(colors)) {
            colors.forEach(function (color) {
                stack.push('<a ' +
                    (valueHex === color
                        ? ' class="jodit_active" '
                        : '') +
                    ' title="' +
                    color +
                    '" style="background-color:' +
                    color +
                    '" data-color="' +
                    color +
                    '" href="javascript:void(0)"></a>');
            });
        }
        return stack.join('');
    };
    form.appendChild(editor.c.fromHTML('<div class="jodit-color-picker__groups">' +
        eachColor(editor.o.colors) +
        '</div>'));
    form.appendChild(editor.c.fromHTML('<div data-ref="extra" class="jodit-color-picker__extra"></div>'));
    var extra = helpers_1.refs(form).extra;
    if (editor.o.showBrowserColorPicker && helpers_1.hasBrowserColorPicker()) {
        extra.appendChild(editor.c.fromHTML('<div class="jodit-color-picker__native">' +
            iconPalette +
            '<input type="color" value="#ffffff"/>' +
            '</div>'));
        editor.e.on(form, 'change', function (e) {
            e.stopPropagation();
            var target = e.target;
            if (!target || !target.tagName || !dom_1.Dom.isTag(target, 'input')) {
                return;
            }
            var color = target.value || '';
            if (helpers_1.isFunction(callback)) {
                callback(color);
            }
            e.preventDefault();
        });
    }
    editor.e.on(form, 'mousedown touchend', function (e) {
        e.stopPropagation();
        var target = e.target;
        if ((!target ||
            !target.tagName ||
            dom_1.Dom.isTag(target, 'svg') ||
            dom_1.Dom.isTag(target, 'path')) &&
            target.parentNode) {
            target = dom_1.Dom.closest(target.parentNode, 'a', editor.editor);
        }
        if (!dom_1.Dom.isTag(target, 'a')) {
            return;
        }
        var color = helpers_1.attr(target, '-color') || '';
        if (callback && typeof callback === 'function') {
            callback(color);
        }
        e.preventDefault();
    });
    editor.e.fire('afterGenerateColorPicker', form, extra, callback, valueHex);
    return form;
};
exports.ColorPickerWidget = ColorPickerWidget;


/***/ }),
/* 258 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 259 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TabsWidget = void 0;
__webpack_require__(260);
var helpers_1 = __webpack_require__(19);
var ui_1 = __webpack_require__(75);
var TabsWidget = function (editor, tabs, state) {
    var box = editor.c.div('jodit-tabs'), tabBox = editor.c.div('jodit-tabs__wrapper'), buttons = editor.c.div('jodit-tabs__buttons'), nameToTab = {}, buttonList = [];
    var firstTab = '', tabcount = 0;
    box.appendChild(buttons);
    box.appendChild(tabBox);
    tabs.forEach(function (_a) {
        var icon = _a.icon, name = _a.name, content = _a.content;
        var tab = editor.c.div('jodit-tab'), button = ui_1.Button(editor, icon || name, name);
        if (!firstTab) {
            firstTab = name;
        }
        buttons.appendChild(button.container);
        buttonList.push(button);
        button.container.classList.add('jodit-tabs__button', 'jodit-tabs__button_columns_' + tabs.length);
        if (!helpers_1.isFunction(content)) {
            tab.appendChild(content);
        }
        else {
            tab.appendChild(editor.c.div('jodit-tab_empty'));
        }
        tabBox.appendChild(tab);
        button.onAction(function () {
            buttonList.forEach(function (b) {
                b.state.activated = false;
            });
            helpers_1.$$('.jodit-tab', tabBox).forEach(function (a) {
                a.classList.remove('jodit-tab_active');
            });
            button.state.activated = true;
            tab.classList.add('jodit-tab_active');
            if (helpers_1.isFunction(content)) {
                content.call(editor);
            }
            if (state) {
                state.__activeTab = name;
            }
            return false;
        });
        nameToTab[name] = {
            button: button,
            tab: tab
        };
        tabcount += 1;
    });
    if (!tabcount) {
        return box;
    }
    helpers_1.$$('a', buttons).forEach(function (a) {
        a.style.width = (100 / tabcount).toFixed(10) + '%';
    });
    var tab = !state || !state.__activeTab || !nameToTab[state.__activeTab]
        ? firstTab
        : state.__activeTab;
    nameToTab[tab].button.state.activated = true;
    nameToTab[tab].tab.classList.add('jodit-tab_active');
    return box;
};
exports.TabsWidget = TabsWidget;


/***/ }),
/* 260 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 261 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileSelectorWidget = void 0;
var helpers_1 = __webpack_require__(19);
var dom_1 = __webpack_require__(32);
var tabs_1 = __webpack_require__(259);
var ui_1 = __webpack_require__(75);
var FileSelectorWidget = function (editor, callbacks, elm, close, isImage) {
    if (isImage === void 0) { isImage = true; }
    var currentImage;
    var tabs = [];
    if (callbacks.upload &&
        editor.o.uploader &&
        (editor.o.uploader.url || editor.o.uploader.insertImageAsBase64URI)) {
        var dragBox = editor.c.fromHTML('<div class="jodit-drag-and-drop__file-box">' +
            ("<strong>" + editor.i18n(isImage ? 'Drop image' : 'Drop file') + "</strong>") +
            ("<span><br>" + editor.i18n('or click') + "</span>") +
            ("<input type=\"file\" accept=\"" + (isImage ? 'image/*' : '*') + "\" tabindex=\"-1\" dir=\"auto\" multiple=\"\"/>") +
            '</div>');
        editor.uploader.bind(dragBox, function (resp) {
            var handler = helpers_1.isFunction(callbacks.upload)
                ? callbacks.upload
                : editor.o.uploader.defaultHandlerSuccess;
            if (helpers_1.isFunction(handler)) {
                handler.call(editor, resp);
            }
            editor.e.fire('closeAllPopups');
        }, function (error) {
            editor.e.fire('errorMessage', error.message);
            editor.e.fire('closeAllPopups');
        });
        tabs.push({
            icon: 'upload',
            name: 'Upload',
            content: dragBox
        });
    }
    if (callbacks.filebrowser) {
        if (editor.o.filebrowser.ajax.url || editor.o.filebrowser.items.url) {
            tabs.push({
                icon: 'folder',
                name: 'Browse',
                content: function () {
                    close && close();
                    if (callbacks.filebrowser) {
                        editor.filebrowser.open(callbacks.filebrowser, isImage);
                    }
                }
            });
        }
    }
    if (callbacks.url) {
        var button = new ui_1.UIButton(editor, {
            type: 'submit',
            status: 'primary',
            text: 'Insert'
        }), form = new ui_1.UIForm(editor, [
            new ui_1.UIInput(editor, {
                required: true,
                label: 'URL',
                name: 'url',
                type: 'text',
                placeholder: 'https://'
            }),
            new ui_1.UIInput(editor, {
                name: 'text',
                label: 'Alternative text'
            }),
            new ui_1.UIBlock(editor, [button])
        ]);
        currentImage = null;
        if (elm &&
            !dom_1.Dom.isText(elm) &&
            (dom_1.Dom.isTag(elm, 'img') || helpers_1.$$('img', elm).length)) {
            currentImage = elm.tagName === 'IMG' ? elm : helpers_1.$$('img', elm)[0];
            helpers_1.val(form.container, 'input[name=url]', helpers_1.attr(currentImage, 'src'));
            helpers_1.val(form.container, 'input[name=text]', helpers_1.attr(currentImage, 'alt'));
            button.state.text = 'Update';
        }
        if (elm && dom_1.Dom.isTag(elm, 'a')) {
            helpers_1.val(form.container, 'input[name=url]', helpers_1.attr(elm, 'href'));
            helpers_1.val(form.container, 'input[name=text]', helpers_1.attr(elm, 'title'));
            button.state.text = 'Update';
        }
        form.onSubmit(function (data) {
            if (helpers_1.isFunction(callbacks.url)) {
                callbacks.url.call(editor, data.url, data.text);
            }
        });
        tabs.push({
            icon: 'link',
            name: 'URL',
            content: form.container
        });
    }
    return tabs_1.TabsWidget(editor, tabs);
};
exports.FileSelectorWidget = FileSelectorWidget;


/***/ }),
/* 262 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DragAndDrop = void 0;
var tslib_1 = __webpack_require__(7);
var constants_1 = __webpack_require__(9);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var plugin_1 = __webpack_require__(184);
var helpers_2 = __webpack_require__(249);
var decorators_1 = __webpack_require__(99);
var DragAndDrop = (function (_super) {
    tslib_1.__extends(DragAndDrop, _super);
    function DragAndDrop() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isFragmentFromEditor = false;
        _this.isCopyMode = false;
        _this.startDragPoint = { x: 0, y: 0 };
        _this.draggable = null;
        _this.bufferRange = null;
        _this.getText = function (event) {
            var dt = helpers_2.getDataTransfer(event);
            return dt ? dt.getData(constants_1.TEXT_HTML) || dt.getData(constants_1.TEXT_PLAIN) : null;
        };
        return _this;
    }
    DragAndDrop.prototype.afterInit = function () {
        this.j.e.on([window, this.j.ed, this.j.editor], 'dragstart.DragAndDrop', this.onDragStart);
    };
    DragAndDrop.prototype.onDragStart = function (event) {
        var target = event.target;
        this.onDragEnd();
        this.isFragmentFromEditor = dom_1.Dom.isOrContains(this.j.editor, target, true);
        this.isCopyMode = this.isFragmentFromEditor ? helpers_1.ctrlKey(event) : true;
        if (this.isFragmentFromEditor) {
            var sel = this.j.s.sel;
            var range = sel && sel.rangeCount ? sel.getRangeAt(0) : null;
            if (range) {
                this.bufferRange = range.cloneRange();
            }
        }
        else {
            this.bufferRange = null;
        }
        this.startDragPoint.x = event.clientX;
        this.startDragPoint.y = event.clientY;
        if (dom_1.Dom.isElement(target) &&
            target.classList.contains('jodit-filebrowser__files-item')) {
            target = target.querySelector('img');
        }
        if (dom_1.Dom.isTag(target, 'img')) {
            this.draggable = target.cloneNode(true);
            helpers_1.dataBind(this.draggable, 'target', target);
        }
        this.addDragListeners();
    };
    DragAndDrop.prototype.addDragListeners = function () {
        this.j.e
            .on('dragover', this.onDrag)
            .on('drop.DragAndDrop', this.onDrop)
            .on(window, 'dragend.DragAndDrop drop.DragAndDrop mouseup.DragAndDrop', this.onDragEnd);
    };
    DragAndDrop.prototype.removeDragListeners = function () {
        this.j.e
            .off('dragover', this.onDrag)
            .off('drop.DragAndDrop', this.onDrop)
            .off(window, 'dragend.DragAndDrop drop.DragAndDrop mouseup.DragAndDrop', this.onDragEnd);
    };
    DragAndDrop.prototype.onDrag = function (event) {
        if (this.draggable) {
            this.j.e.fire('hidePopup');
            this.j.s.insertCursorAtPoint(event.clientX, event.clientY);
            event.preventDefault();
            event.stopPropagation();
        }
    };
    DragAndDrop.prototype.onDragEnd = function () {
        if (this.draggable) {
            dom_1.Dom.safeRemove(this.draggable);
            this.draggable = null;
        }
        this.isCopyMode = false;
        this.removeDragListeners();
    };
    DragAndDrop.prototype.onDrop = function (event) {
        if (!event.dataTransfer ||
            !event.dataTransfer.files ||
            !event.dataTransfer.files.length) {
            if (!this.isFragmentFromEditor && !this.draggable) {
                this.j.e.fire('paste', event);
                event.preventDefault();
                event.stopPropagation();
                return false;
            }
            var sel = this.j.s.sel;
            var range = this.bufferRange ||
                (sel && sel.rangeCount ? sel.getRangeAt(0) : null);
            var fragment = null;
            if (!this.draggable && range) {
                fragment = this.isCopyMode
                    ? range.cloneContents()
                    : range.extractContents();
            }
            else if (this.draggable) {
                if (this.isCopyMode) {
                    var _a = helpers_1.attr(this.draggable, '-is-file') === '1'
                        ? ['a', 'href']
                        : ['img', 'src'], tagName = _a[0], field = _a[1];
                    fragment = this.j.createInside.element(tagName);
                    fragment.setAttribute(field, helpers_1.attr(this.draggable, 'data-src') ||
                        helpers_1.attr(this.draggable, 'src') ||
                        '');
                    if (tagName === 'a') {
                        fragment.textContent = helpers_1.attr(fragment, field) || '';
                    }
                }
                else {
                    fragment = helpers_1.dataBind(this.draggable, 'target');
                }
            }
            else if (this.getText(event)) {
                fragment = this.j.createInside.fromHTML(this.getText(event));
            }
            sel && sel.removeAllRanges();
            this.j.s.insertCursorAtPoint(event.clientX, event.clientY);
            if (fragment) {
                this.j.s.insertNode(fragment, false, false);
                if (range && fragment.firstChild && fragment.lastChild) {
                    range.setStartBefore(fragment.firstChild);
                    range.setEndAfter(fragment.lastChild);
                    this.j.s.selectRange(range);
                    this.j.e.fire('synchro');
                }
                if (dom_1.Dom.isTag(fragment, 'img') && this.j.events) {
                    this.j.e.fire('afterInsertImage', fragment);
                }
            }
            event.preventDefault();
            event.stopPropagation();
        }
        this.isFragmentFromEditor = false;
        this.removeDragListeners();
    };
    DragAndDrop.prototype.beforeDestruct = function () {
        this.onDragEnd();
        this.j.e
            .off(window, '.DragAndDrop')
            .off('.DragAndDrop')
            .off([window, this.j.ed, this.j.editor], 'dragstart.DragAndDrop', this.onDragStart);
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], DragAndDrop.prototype, "onDragStart", null);
    tslib_1.__decorate([
        decorators_1.throttle(function (ctx) { return ctx.j.defaultTimeout / 10; })
    ], DragAndDrop.prototype, "onDrag", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], DragAndDrop.prototype, "onDragEnd", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], DragAndDrop.prototype, "onDrop", null);
    return DragAndDrop;
}(plugin_1.Plugin));
exports.DragAndDrop = DragAndDrop;


/***/ }),
/* 263 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DragAndDropElement = void 0;
var tslib_1 = __webpack_require__(7);
var helpers_1 = __webpack_require__(19);
var plugin_1 = __webpack_require__(184);
var dom_1 = __webpack_require__(32);
var global_1 = __webpack_require__(30);
var decorators_1 = __webpack_require__(99);
var DragAndDropElement = (function (_super) {
    tslib_1.__extends(DragAndDropElement, _super);
    function DragAndDropElement() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dragList = [];
        _this.draggable = null;
        _this.wasMoved = false;
        _this.isCopyMode = false;
        _this.diffStep = 10;
        _this.startX = 0;
        _this.startY = 0;
        return _this;
    }
    DragAndDropElement.prototype.afterInit = function () {
        this.dragList = this.j.o.draggableTags
            ? helpers_1.splitArray(this.j.o.draggableTags)
                .filter(Boolean)
                .map(function (item) { return item.toLowerCase(); })
            : [];
        if (!this.dragList.length) {
            return;
        }
        this.j.e.on('mousedown touchstart dragstart', this.onDragStart);
    };
    DragAndDropElement.prototype.onDragStart = function (event) {
        var _this = this;
        if (event.type === 'dragstart' && this.draggable) {
            return false;
        }
        var target = event.target;
        if (!this.dragList.length || !target) {
            return;
        }
        var matched = function (node) {
            return node && _this.dragList.includes(node.nodeName.toLowerCase());
        };
        var lastTarget = dom_1.Dom.furthest(target, matched, this.j.editor) ||
            (matched(target) ? target : null);
        if (!lastTarget) {
            return;
        }
        this.startX = event.clientX;
        this.startY = event.clientY;
        this.isCopyMode = helpers_1.ctrlKey(event);
        this.onDragEnd();
        this.draggable = lastTarget.cloneNode(true);
        helpers_1.dataBind(this.draggable, 'target', lastTarget);
        this.addDragListeners();
    };
    DragAndDropElement.prototype.onDrag = function (event) {
        var _a, _b;
        if (!this.draggable) {
            return;
        }
        var x = event.clientX, y = event.clientY;
        if (Math.sqrt(Math.pow(x - this.startX, 2) + Math.pow(y - this.startY, 2)) < this.diffStep) {
            return;
        }
        this.wasMoved = true;
        this.j.e.fire('hidePopup hideResizer');
        if (!this.draggable.parentNode) {
            var target = helpers_1.dataBind(this.draggable, 'target');
            helpers_1.css(this.draggable, {
                zIndex: 10000000000000,
                pointerEvents: 'none',
                pointer: 'drag',
                position: 'fixed',
                opacity: 0.7,
                display: 'inline-block',
                left: event.clientX,
                top: event.clientY,
                width: (_a = target === null || target === void 0 ? void 0 : target.offsetWidth) !== null && _a !== void 0 ? _a : 100,
                height: (_b = target === null || target === void 0 ? void 0 : target.offsetHeight) !== null && _b !== void 0 ? _b : 100
            });
            global_1.getContainer(this.j, DragAndDropElement).appendChild(this.draggable);
        }
        helpers_1.css(this.draggable, {
            left: event.clientX,
            top: event.clientY
        });
        this.j.s.insertCursorAtPoint(event.clientX, event.clientY);
    };
    DragAndDropElement.prototype.onDragEnd = function () {
        if (this.isInDestruct) {
            return;
        }
        if (this.draggable) {
            dom_1.Dom.safeRemove(this.draggable);
            this.draggable = null;
            this.wasMoved = false;
            this.removeDragListeners();
        }
    };
    DragAndDropElement.prototype.onDrop = function () {
        if (!this.draggable || !this.wasMoved) {
            this.onDragEnd();
            return;
        }
        var fragment = helpers_1.dataBind(this.draggable, 'target');
        this.onDragEnd();
        if (this.isCopyMode) {
            fragment = fragment.cloneNode(true);
        }
        var parentElement = fragment.parentElement;
        this.j.s.insertNode(fragment, true, false);
        if (parentElement && dom_1.Dom.isEmpty(parentElement)) {
            dom_1.Dom.safeRemove(parentElement);
        }
        if (dom_1.Dom.isTag(fragment, 'img') && this.j.e) {
            this.j.e.fire('afterInsertImage', fragment);
        }
        this.j.e.fire('synchro');
    };
    DragAndDropElement.prototype.addDragListeners = function () {
        this.j.e
            .on(this.j.editor, 'mousemove touchmove', this.onDrag)
            .on('mouseup touchend', this.onDrop)
            .on([this.j.ew, this.ow], 'mouseup touchend', this.onDragEnd);
    };
    DragAndDropElement.prototype.removeDragListeners = function () {
        this.j.e
            .off(this.j.editor, 'mousemove touchmove', this.onDrag)
            .off('mouseup touchend', this.onDrop)
            .off([this.j.ew, this.ow], 'mouseup touchend', this.onDragEnd);
    };
    DragAndDropElement.prototype.beforeDestruct = function () {
        this.onDragEnd();
        this.j.e.off('mousedown touchstart dragstart', this.onDragStart);
        this.removeDragListeners();
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], DragAndDropElement.prototype, "onDragStart", null);
    tslib_1.__decorate([
        decorators_1.throttle(function (ctx) { return ctx.j.defaultTimeout / 10; })
    ], DragAndDropElement.prototype, "onDrag", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], DragAndDropElement.prototype, "onDragEnd", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], DragAndDropElement.prototype, "onDrop", null);
    return DragAndDropElement;
}(plugin_1.Plugin));
exports.DragAndDropElement = DragAndDropElement;


/***/ }),
/* 264 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.enter = exports.insertParagraph = void 0;
var tslib_1 = __webpack_require__(7);
var consts = __webpack_require__(9);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var plugin_1 = __webpack_require__(184);
var constants_1 = __webpack_require__(9);
var insertParagraph = function (editor, fake, wrapperTag, style) {
    var _a;
    var p = editor.createInside.element(wrapperTag), helper_node = editor.createInside.element('br');
    p.appendChild(helper_node);
    if (style && style.cssText) {
        p.setAttribute('style', style.cssText);
    }
    editor.s.insertNode(p, false, false);
    editor.s.setCursorBefore(helper_node);
    var range = editor.s.createRange();
    range.setStartBefore(wrapperTag.toLowerCase() !== 'br' ? helper_node : p);
    range.collapse(true);
    editor.s.selectRange(range);
    dom_1.Dom.safeRemove(fake);
    helpers_1.scrollIntoViewIfNeeded(p, editor.editor, editor.ed);
    (_a = editor.events) === null || _a === void 0 ? void 0 : _a.fire('synchro');
    return p;
};
exports.insertParagraph = insertParagraph;
var enter = (function (_super) {
    tslib_1.__extends(enter, _super);
    function enter() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.brMode = false;
        _this.defaultTag = consts.PARAGRAPH;
        return _this;
    }
    enter.prototype.afterInit = function (editor) {
        var _this = this;
        this.defaultTag = editor.o.enter.toLowerCase();
        this.brMode = this.defaultTag === consts.BR.toLowerCase();
        if (!editor.o.enterBlock) {
            editor.o.enterBlock = this.brMode
                ? consts.PARAGRAPH
                : this.defaultTag;
        }
        editor.e
            .off('.enter')
            .on('keydown.enter', function (event) {
            if (event.key === consts.KEY_ENTER) {
                var beforeEnter = editor.e.fire('beforeEnter', event);
                if (beforeEnter !== undefined) {
                    return beforeEnter;
                }
                if (!editor.s.isCollapsed()) {
                    editor.execCommand('Delete');
                }
                editor.s.focus();
                _this.onEnter(event);
                return false;
            }
        });
    };
    enter.prototype.onEnter = function (event) {
        var editor = this.j, sel = editor.selection, defaultTag = this.defaultTag;
        var current = sel.current(false);
        if (!current || current === editor.editor) {
            current = editor.createInside.text(constants_1.INVISIBLE_SPACE);
            sel.insertNode(current);
            sel.select(current);
        }
        var currentBox = this.getBlockWrapper(current);
        var isLi = dom_1.Dom.isTag(currentBox, 'li');
        if ((!isLi || event.shiftKey) &&
            !this.checkBR(current, event.shiftKey)) {
            return false;
        }
        if (!currentBox && !this.hasPreviousBlock(current)) {
            currentBox = this.wrapText(current);
        }
        if (!currentBox || currentBox === current) {
            exports.insertParagraph(editor, null, isLi ? 'li' : defaultTag);
            return false;
        }
        if (!this.checkUnsplittableBox(currentBox)) {
            return false;
        }
        if (isLi && dom_1.Dom.isEmpty(currentBox)) {
            this.enterInsideEmptyLIelement(currentBox);
            return false;
        }
        var canSplit = currentBox.tagName.toLowerCase() === this.defaultTag || isLi;
        var cursorOnTheRight = sel.cursorOnTheRight(currentBox);
        var cursorOnTheLeft = sel.cursorOnTheLeft(currentBox);
        if (!canSplit && (cursorOnTheRight || cursorOnTheLeft)) {
            var fake = null;
            if (cursorOnTheRight) {
                fake = sel.setCursorAfter(currentBox);
            }
            else {
                fake = sel.setCursorBefore(currentBox);
            }
            exports.insertParagraph(editor, fake, this.defaultTag);
            if (cursorOnTheLeft && !cursorOnTheRight) {
                sel.setCursorIn(currentBox, true);
            }
            return;
        }
        sel.splitSelection(currentBox);
    };
    enter.prototype.getBlockWrapper = function (current, tagReg) {
        if (tagReg === void 0) { tagReg = consts.IS_BLOCK; }
        var node = current;
        var root = this.j.editor;
        do {
            if (!node || node === root) {
                break;
            }
            if (tagReg.test(node.nodeName)) {
                if (dom_1.Dom.isTag(node, 'li')) {
                    return node;
                }
                return (this.getBlockWrapper(node.parentNode, /^li$/i) ||
                    node);
            }
            node = node.parentNode;
        } while (node && node !== root);
        return null;
    };
    enter.prototype.checkBR = function (current, shiftKeyPressed) {
        var isMultiLineBlock = dom_1.Dom.closest(current, ['pre', 'blockquote'], this.j.editor);
        if (this.brMode ||
            (shiftKeyPressed && !isMultiLineBlock) ||
            (!shiftKeyPressed && isMultiLineBlock)) {
            var br = this.j.createInside.element('br');
            this.j.s.insertNode(br, true);
            helpers_1.scrollIntoViewIfNeeded(br, this.j.editor, this.j.ed);
            return false;
        }
        return true;
    };
    enter.prototype.wrapText = function (current) {
        var _this = this;
        var needWrap = current;
        dom_1.Dom.up(needWrap, function (node) {
            if (node && node.hasChildNodes() && node !== _this.j.editor) {
                needWrap = node;
            }
        }, this.j.editor);
        var currentBox = dom_1.Dom.wrapInline(needWrap, this.j.o.enter, this.j);
        if (dom_1.Dom.isEmpty(currentBox)) {
            var helper_node = this.j.createInside.element('br');
            currentBox.appendChild(helper_node);
            this.j.s.setCursorBefore(helper_node);
        }
        return currentBox;
    };
    enter.prototype.hasPreviousBlock = function (current) {
        var editor = this.j;
        return Boolean(dom_1.Dom.prev(current, function (elm) {
            return dom_1.Dom.isBlock(elm, editor.ew) || dom_1.Dom.isImage(elm, editor.ew);
        }, editor.editor));
    };
    enter.prototype.checkUnsplittableBox = function (currentBox) {
        var editor = this.j, sel = editor.selection;
        if (!dom_1.Dom.canSplitBlock(currentBox, editor.ew)) {
            var br = editor.createInside.element('br');
            sel.insertNode(br, false);
            sel.setCursorAfter(br);
            return false;
        }
        return true;
    };
    enter.prototype.enterInsideEmptyLIelement = function (currentBox) {
        var fakeTextNode = null;
        var ul = dom_1.Dom.closest(currentBox, ['ol', 'ul'], this.j.editor);
        if (!ul) {
            return;
        }
        if (!dom_1.Dom.prev(currentBox, function (elm) { return dom_1.Dom.isTag(elm, 'li'); }, ul)) {
            fakeTextNode = this.j.s.setCursorBefore(ul);
        }
        else if (!dom_1.Dom.next(currentBox, function (elm) { return dom_1.Dom.isTag(elm, 'li'); }, ul)) {
            fakeTextNode = this.j.s.setCursorAfter(ul);
        }
        else {
            var leftRange = this.j.s.createRange();
            leftRange.setStartBefore(ul);
            leftRange.setEndAfter(currentBox);
            var fragment = leftRange.extractContents();
            if (ul.parentNode) {
                ul.parentNode.insertBefore(fragment, ul);
            }
            fakeTextNode = this.j.s.setCursorBefore(ul);
        }
        dom_1.Dom.safeRemove(currentBox);
        exports.insertParagraph(this.j, fakeTextNode, this.defaultTag);
        if (!helpers_1.$$('li', ul).length) {
            dom_1.Dom.safeRemove(ul);
        }
    };
    enter.prototype.beforeDestruct = function (editor) {
        editor.e.off('keydown.enter');
    };
    return enter;
}(plugin_1.Plugin));
exports.enter = enter;


/***/ }),
/* 265 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.errorMessages = void 0;
__webpack_require__(266);
var config_1 = __webpack_require__(8);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
config_1.Config.prototype.showMessageErrors = true;
config_1.Config.prototype.showMessageErrorTime = 3000;
config_1.Config.prototype.showMessageErrorOffsetPx = 3;
function errorMessages(editor) {
    if (editor.o.showMessageErrors) {
        var height_1;
        var messagesBox_1 = editor.c.div('jodit_error_box_for_messages'), recalcOffsets_1 = function () {
            height_1 = 5;
            helpers_1.toArray(messagesBox_1.childNodes).forEach(function (elm) {
                helpers_1.css(messagesBox_1, 'bottom', height_1 + 'px');
                height_1 +=
                    elm.offsetWidth + editor.o.showMessageErrorOffsetPx;
            });
        };
        editor.e
            .on('beforeDestruct', function () {
            dom_1.Dom.safeRemove(messagesBox_1);
        })
            .on('errorMessage', function (message, className, timeout) {
            editor.workplace.appendChild(messagesBox_1);
            var newmessage = editor.c.div('active ' + (className || ''), message);
            messagesBox_1.appendChild(newmessage);
            recalcOffsets_1();
            editor.async.setTimeout(function () {
                newmessage.classList.remove('active');
                editor.async.setTimeout(function () {
                    dom_1.Dom.safeRemove(newmessage);
                    recalcOffsets_1();
                }, 300);
            }, timeout || editor.o.showMessageErrorTime);
        });
    }
}
exports.errorMessages = errorMessages;


/***/ }),
/* 266 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 267 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.font = void 0;
var tslib_1 = __webpack_require__(7);
var config_1 = __webpack_require__(8);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
config_1.Config.prototype.defaultFontSizePoints = 'px';
config_1.Config.prototype.controls.fontsize = {
    command: 'fontSize',
    data: {
        cssRule: 'font-size'
    },
    list: [
        '8',
        '9',
        '10',
        '11',
        '12',
        '14',
        '16',
        '18',
        '24',
        '30',
        '36',
        '48',
        '60',
        '72',
        '96'
    ],
    exec: function (editor, event, _a) {
        var control = _a.control;
        return helpers_1.memorizeExec(editor, event, { control: control }, function (value) {
            var _a;
            if (((_a = control.command) === null || _a === void 0 ? void 0 : _a.toLowerCase()) === 'fontsize') {
                return "" + value + editor.o.defaultFontSizePoints;
            }
            return value;
        });
    },
    childTemplate: function (editor, key, value) {
        return "" + value + editor.o.defaultFontSizePoints;
    },
    tooltip: 'Font size',
    isChildActive: function (editor, control) {
        var _a, _b;
        var current = editor.s.current(), cssKey = ((_a = control.data) === null || _a === void 0 ? void 0 : _a.cssRule) || 'font-size', normalize = ((_b = control.data) === null || _b === void 0 ? void 0 : _b.normalize) ||
            (function (v) {
                if (/pt$/i.test(v) &&
                    editor.o.defaultFontSizePoints === 'pt') {
                    return v.replace(/pt$/i, '');
                }
                return v;
            });
        if (current) {
            var currentBpx = dom_1.Dom.closest(current, function (elm) {
                return (dom_1.Dom.isBlock(elm, editor.ew) ||
                    (elm && dom_1.Dom.isElement(elm)));
            }, editor.editor) || editor.editor;
            var value = helpers_1.css(currentBpx, cssKey);
            return Boolean(value &&
                control.args &&
                normalize(control.args[0].toString()) ===
                    normalize(value.toString()));
        }
        return false;
    }
};
config_1.Config.prototype.controls.font = tslib_1.__assign(tslib_1.__assign({}, config_1.Config.prototype.controls.fontsize), { command: 'fontname', list: {
        '': 'Default',
        'Helvetica,sans-serif': 'Helvetica',
        'Arial,Helvetica,sans-serif': 'Arial',
        'Georgia,serif': 'Georgia',
        'Impact,Charcoal,sans-serif': 'Impact',
        'Tahoma,Geneva,sans-serif': 'Tahoma',
        "'Times New Roman',Times,serif": 'Times New Roman',
        'Verdana,Geneva,sans-serif': 'Verdana'
    }, childTemplate: function (editor, key, value) {
        return "<span style=\"font-family: " + key + "!important;\">" + value + "</span>";
    }, data: {
        cssRule: 'font-family',
        normalize: function (v) {
            return v
                .toLowerCase()
                .replace(/['"]+/g, '')
                .replace(/[^a-z0-9]+/g, ',');
        }
    }, tooltip: 'Font family' });
function font(editor) {
    editor
        .registerButton({
        name: 'font',
        group: 'font'
    })
        .registerButton({
        name: 'fontsize',
        group: 'font'
    });
    var callback = function (command, second, third) {
        switch (command) {
            case 'fontsize':
                editor.s.applyStyle({
                    fontSize: helpers_1.normalizeSize(third)
                });
                break;
            case 'fontname':
                editor.s.applyStyle({
                    fontFamily: third
                });
                break;
        }
        editor.e.fire('synchro');
        return false;
    };
    editor
        .registerCommand('fontsize', callback)
        .registerCommand('fontname', callback);
}
exports.font = font;


/***/ }),
/* 268 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.formatBlock = void 0;
var config_1 = __webpack_require__(8);
var modules_1 = __webpack_require__(10);
var helpers_1 = __webpack_require__(19);
config_1.Config.prototype.controls.paragraph = {
    command: 'formatBlock',
    update: function (button) {
        var editor = button.j, control = button.control, current = editor.s.current();
        if (current && editor.o.textIcons) {
            var currentBox = modules_1.Dom.closest(current, function (node) { return modules_1.Dom.isBlock(node, editor.ew); }, editor.editor) || editor.editor, currentValue = currentBox.nodeName.toLowerCase(), list = control.list;
            if (button &&
                control.data &&
                control.data.currentValue !== currentValue &&
                list &&
                list[currentValue]) {
                if (editor.o.textIcons) {
                    button.state.text = currentValue;
                }
                else {
                    button.state.icon.name = currentValue;
                }
                control.data.currentValue = currentValue;
            }
        }
        return false;
    },
    exec: helpers_1.memorizeExec,
    data: {
        currentValue: 'left'
    },
    list: {
        p: 'Normal',
        h1: 'Heading 1',
        h2: 'Heading 2',
        h3: 'Heading 3',
        h4: 'Heading 4',
        blockquote: 'Quote'
    },
    isChildActive: function (editor, control) {
        var current = editor.s.current();
        if (current) {
            var currentBox = modules_1.Dom.closest(current, function (node) { return modules_1.Dom.isBlock(node, editor.ew); }, editor.editor);
            return Boolean(currentBox &&
                currentBox !== editor.editor &&
                control.args !== undefined &&
                currentBox.nodeName.toLowerCase() === control.args[0]);
        }
        return false;
    },
    isActive: function (editor, control) {
        var current = editor.s.current();
        if (current) {
            var currentBpx = modules_1.Dom.closest(current, function (node) { return modules_1.Dom.isBlock(node, editor.ew); }, editor.editor);
            return Boolean(currentBpx &&
                currentBpx !== editor.editor &&
                control.list !== undefined &&
                !modules_1.Dom.isTag(currentBpx, 'p') &&
                control.list[currentBpx.nodeName.toLowerCase()] !== undefined);
        }
        return false;
    },
    childTemplate: function (e, key, value) {
        return "<" + key + " style=\"margin:0;padding:0\"><span>" + e.i18n(value) + "</span></" + key + ">";
    },
    tooltip: 'Insert format block'
};
function formatBlock(editor) {
    editor.registerButton({
        name: 'paragraph',
        group: 'font'
    });
    editor.registerCommand('formatblock', function (command, second, third) {
        editor.s.applyStyle(undefined, {
            element: third
        });
        editor.setEditorValue();
        return false;
    });
}
exports.formatBlock = formatBlock;


/***/ }),
/* 269 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.fullsize = void 0;
__webpack_require__(270);
var config_1 = __webpack_require__(8);
var consts = __webpack_require__(9);
var helpers_1 = __webpack_require__(19);
config_1.Config.prototype.fullsize = false;
config_1.Config.prototype.globalFullSize = true;
config_1.Config.prototype.controls.fullsize = {
    exec: function (editor) {
        editor.toggleFullSize();
    },
    update: function (button) {
        var editor = button.j, mode = editor.isFullSize ? 'shrink' : 'fullsize';
        button.state.activated = editor.isFullSize;
        if (editor.o.textIcons) {
            button.state.text = mode;
        }
        else {
            button.state.icon.name = mode;
        }
    },
    tooltip: 'Open editor in fullsize',
    mode: consts.MODE_SOURCE + consts.MODE_WYSIWYG
};
function fullsize(editor) {
    editor.registerButton({
        name: 'fullsize'
    });
    var isEnabled = false, oldHeight = 0, oldWidth = 0, wasToggled = false;
    var resize = function () {
        if (editor.events) {
            if (isEnabled) {
                oldHeight = helpers_1.css(editor.container, 'height', undefined, true);
                oldWidth = helpers_1.css(editor.container, 'width', undefined, true);
                helpers_1.css(editor.container, {
                    height: editor.ow.innerHeight,
                    width: editor.ow.innerWidth
                });
                wasToggled = true;
            }
            else if (wasToggled) {
                helpers_1.css(editor.container, {
                    height: oldHeight || 'auto',
                    width: oldWidth || 'auto'
                });
            }
        }
    }, toggle = function (enable) {
        var _a;
        if (!editor.container) {
            return;
        }
        if (enable === undefined) {
            enable = !editor.container.classList.contains('jodit_fullsize');
        }
        editor.setMod('fullsize', enable);
        editor.o.fullsize = enable;
        isEnabled = enable;
        editor.container.classList.toggle('jodit_fullsize', enable);
        if (editor.toolbar) {
            helpers_1.isJoditObject(editor) &&
                editor.toolbarContainer.appendChild(editor.toolbar.container);
            helpers_1.css(editor.toolbar.container, 'width', 'auto');
        }
        if (editor.o.globalFullSize) {
            var node = editor.container.parentNode;
            while (node && node.nodeType !== Node.DOCUMENT_NODE) {
                node.classList.toggle('jodit_fullsize-box_true', enable);
                node = node.parentNode;
            }
            resize();
        }
        (_a = editor.events) === null || _a === void 0 ? void 0 : _a.fire('afterResize');
    };
    if (editor.o.globalFullSize) {
        editor.e.on(editor.ow, 'resize', resize);
    }
    editor.e
        .on('afterInit afterOpen', function () {
        var _a;
        editor.toggleFullSize((_a = editor === null || editor === void 0 ? void 0 : editor.options) === null || _a === void 0 ? void 0 : _a.fullsize);
    })
        .on('toggleFullSize', toggle)
        .on('beforeDestruct', function () {
        isEnabled && toggle(false);
    })
        .on('beforeDestruct', function () {
        editor.events && editor.e.off(editor.ow, 'resize', resize);
    });
}
exports.fullsize = fullsize;


/***/ }),
/* 270 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 271 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.hotkeys = void 0;
var tslib_1 = __webpack_require__(7);
var config_1 = __webpack_require__(8);
var plugin_1 = __webpack_require__(184);
var helpers_1 = __webpack_require__(19);
var constants_1 = __webpack_require__(9);
config_1.Config.prototype.commandToHotkeys = {
    removeFormat: ['ctrl+shift+m', 'cmd+shift+m'],
    insertOrderedList: ['ctrl+shift+7', 'cmd+shift+7'],
    insertUnorderedList: ['ctrl+shift+8, cmd+shift+8'],
    selectall: ['ctrl+a', 'cmd+a']
};
var hotkeys = (function (_super) {
    tslib_1.__extends(hotkeys, _super);
    function hotkeys() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onKeyPress = function (event) {
            var special = _this.specialKeys[event.which], character = (event.key || String.fromCharCode(event.which)).toLowerCase();
            var modif = [special || character];
            ['alt', 'ctrl', 'shift', 'meta'].forEach(function (specialKey) {
                if (event[specialKey + 'Key'] && special !== specialKey) {
                    modif.push(specialKey);
                }
            });
            return helpers_1.normalizeKeyAliases(modif.join('+'));
        };
        _this.specialKeys = {
            8: 'backspace',
            9: 'tab',
            10: 'return',
            13: 'return',
            16: 'shift',
            17: 'ctrl',
            18: 'alt',
            19: 'pause',
            20: 'capslock',
            27: 'esc',
            32: 'space',
            33: 'pageup',
            34: 'pagedown',
            35: 'end',
            36: 'home',
            37: 'left',
            38: 'up',
            39: 'right',
            40: 'down',
            45: 'insert',
            46: 'del',
            59: ';',
            61: '=',
            91: 'meta',
            96: '0',
            97: '1',
            98: '2',
            99: '3',
            100: '4',
            101: '5',
            102: '6',
            103: '7',
            104: '8',
            105: '9',
            106: '*',
            107: '+',
            109: '-',
            110: '.',
            111: '/',
            112: 'f1',
            113: 'f2',
            114: 'f3',
            115: 'f4',
            116: 'f5',
            117: 'f6',
            118: 'f7',
            119: 'f8',
            120: 'f9',
            121: 'f10',
            122: 'f11',
            123: 'f12',
            144: 'numlock',
            145: 'scroll',
            173: '-',
            186: ';',
            187: '=',
            188: ',',
            189: '-',
            190: '.',
            191: '/',
            192: '`',
            219: '[',
            220: '\\',
            221: ']',
            222: "'"
        };
        return _this;
    }
    hotkeys.prototype.afterInit = function (editor) {
        var _this = this;
        helpers_1.keys(editor.o.commandToHotkeys, false).forEach(function (commandName) {
            var shortcuts = editor.o.commandToHotkeys[commandName];
            if (shortcuts && (helpers_1.isArray(shortcuts) || helpers_1.isString(shortcuts))) {
                editor.registerHotkeyToCommand(shortcuts, commandName);
            }
        });
        var itIsHotkey = false;
        editor.e
            .off('.hotkeys')
            .on([editor.ow, editor.ew], 'keydown.hotkeys', function (e) {
            if (e.key === constants_1.KEY_ESC) {
                return _this.j.e.fire('escape', e);
            }
        })
            .on('keydown.hotkeys', function (event) {
            var shortcut = _this.onKeyPress(event), stop = {
                shouldStop: true
            };
            var resultOfFire = _this.j.e.fire(shortcut + '.hotkey', event.type, stop);
            if (resultOfFire === false) {
                if (stop.shouldStop) {
                    itIsHotkey = true;
                    editor.e.stopPropagation('keydown');
                    return false;
                }
                else {
                    event.preventDefault();
                }
            }
        }, undefined, true)
            .on('keyup.hotkeys', function () {
            if (itIsHotkey) {
                itIsHotkey = false;
                editor.e.stopPropagation('keyup');
                return false;
            }
        }, undefined, true);
    };
    hotkeys.prototype.beforeDestruct = function (jodit) {
        if (jodit.events) {
            jodit.e.off('.hotkeys');
        }
    };
    return hotkeys;
}(plugin_1.Plugin));
exports.hotkeys = hotkeys;


/***/ }),
/* 272 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.iframe = void 0;
var config_1 = __webpack_require__(8);
var helpers_1 = __webpack_require__(19);
var helpers_2 = __webpack_require__(19);
var constants_1 = __webpack_require__(9);
config_1.Config.prototype.iframeBaseUrl = '';
config_1.Config.prototype.iframeTitle = 'Jodit Editor';
config_1.Config.prototype.iframeDoctype = '<!DOCTYPE html>';
config_1.Config.prototype.iframeDefaultSrc = 'about:blank';
config_1.Config.prototype.iframeStyle =
    'html{' +
        'margin:0;' +
        'padding:0;' +
        'min-height: 100%;' +
        '}' +
        'body{' +
        'box-sizing:border-box;' +
        'font-size:13px;' +
        'line-height:1.6;' +
        'padding:10px;' +
        'margin:0;' +
        'background:transparent;' +
        'color:#000;' +
        'position:' +
        'relative;' +
        'z-index:2;' +
        'user-select:auto;' +
        'margin:0px;' +
        'overflow:auto;' +
        'outline:none;' +
        '}' +
        'table{' +
        'width:100%;' +
        'border:none;' +
        'border-collapse:collapse;' +
        'empty-cells: show;' +
        'max-width: 100%;' +
        '}' +
        'th,td{' +
        'padding: 2px 5px;' +
        'border:1px solid #ccc;' +
        '-webkit-user-select:text;' +
        '-moz-user-select:text;' +
        '-ms-user-select:text;' +
        'user-select:text' +
        '}' +
        'p{' +
        'margin-top:0;' +
        '}' +
        '.jodit_editor .jodit_iframe_wrapper{' +
        'display: block;' +
        'clear: both;' +
        'user-select: none;' +
        'position: relative;' +
        '}' +
        '.jodit_editor .jodit_iframe_wrapper:after {' +
        'position:absolute;' +
        'content:"";' +
        'z-index:1;' +
        'top:0;' +
        'left:0;' +
        'right: 0;' +
        'bottom: 0;' +
        'cursor: pointer;' +
        'display: block;' +
        'background: rgba(0, 0, 0, 0);' +
        '} ' +
        '.jodit_disabled{' +
        'user-select: none;' +
        '-o-user-select: none;' +
        '-moz-user-select: none;' +
        '-khtml-user-select: none;' +
        '-webkit-user-select: none;' +
        '-ms-user-select: none' +
        '}';
config_1.Config.prototype.iframeCSSLinks = [];
config_1.Config.prototype.editHTMLDocumentMode = false;
function iframe(editor) {
    var opt = editor.options;
    editor.e
        .on('afterSetMode', function () {
        if (editor.isEditorMode()) {
            editor.s.focus();
        }
    })
        .on('generateDocumentStructure.iframe', function (__doc, jodit) {
        var doc = __doc ||
            jodit.iframe
                .contentWindow.document;
        doc.open();
        doc.write(opt.iframeDoctype +
            ("<html dir=\"" + opt.direction + "\" class=\"jodit\" lang=\"" + helpers_1.defaultLanguage(opt.language) + "\">") +
            '<head>' +
            ("<title>" + opt.iframeTitle + "</title>") +
            (opt.iframeBaseUrl
                ? "<base href=\"" + opt.iframeBaseUrl + "\"/>"
                : '') +
            '</head>' +
            '<body class="jodit-wysiwyg"></body>' +
            '</html>');
        doc.close();
        if (opt.iframeCSSLinks) {
            opt.iframeCSSLinks.forEach(function (href) {
                var link = doc.createElement('link');
                link.setAttribute('rel', 'stylesheet');
                link.setAttribute('href', href);
                doc.head && doc.head.appendChild(link);
            });
        }
        if (opt.iframeStyle) {
            var style = doc.createElement('style');
            style.innerHTML = opt.iframeStyle;
            doc.head && doc.head.appendChild(style);
        }
    })
        .on('createEditor', function () {
        if (!opt.iframe) {
            return;
        }
        var iframe = editor.c.element('iframe');
        iframe.style.display = 'block';
        iframe.src = 'about:blank';
        iframe.className = 'jodit-wysiwyg_iframe';
        iframe.setAttribute('allowtransparency', 'true');
        iframe.setAttribute('tabindex', opt.tabIndex.toString());
        iframe.setAttribute('frameborder', '0');
        editor.workplace.appendChild(iframe);
        editor.iframe = iframe;
        var result = editor.e.fire('generateDocumentStructure.iframe', null, editor);
        var init = function () {
            if (!editor.iframe) {
                return;
            }
            var doc = editor.iframe.contentWindow.document;
            editor.editorWindow = editor.iframe.contentWindow;
            var docMode = opt.editHTMLDocumentMode;
            var toggleEditable = function () {
                helpers_1.attr(doc.body, 'contenteditable', (editor.getMode() !== constants_1.MODE_SOURCE &&
                    !editor.getReadOnly()) ||
                    null);
            };
            var clearMarkers = function (html) {
                var bodyReg = /<body.*<\/body>/im, bodyMarker = '{%%BODY%%}', body = bodyReg.exec(html);
                if (body) {
                    html = html
                        .replace(bodyReg, bodyMarker)
                        .replace(/<span([^>]*?)>(.*?)<\/span>/gim, '')
                        .replace(/&lt;span([^&]*?)&gt;(.*?)&lt;\/span&gt;/gim, '')
                        .replace(bodyMarker, body[0]
                        .replace(/(<body[^>]+?)min-height["'\s]*:[\s"']*[0-9]+(px|%)/im, '$1')
                        .replace(/(<body[^>]+?)([\s]*["'])?contenteditable["'\s]*=[\s"']*true["']?/im, '$1')
                        .replace(/<(style|script|span)[^>]+jodit[^>]+>.*?<\/\1>/g, ''))
                        .replace(/(class\s*=\s*)(['"])([^"']*)(jodit-wysiwyg|jodit)([^"']*\2)/g, '$1$2$3$5')
                        .replace(/(<[^<]+?)\sclass="[\s]*"/gim, '$1')
                        .replace(/(<[^<]+?)\sstyle="[\s;]*"/gim, '$1')
                        .replace(/(<[^<]+?)\sdir="[\s]*"/gim, '$1');
                }
                return html;
            };
            if (docMode) {
                var tag = editor.element.tagName;
                if (tag !== 'TEXTAREA' && tag !== 'INPUT') {
                    throw helpers_2.error('If enable `editHTMLDocumentMode` - source element should be INPUT or TEXTAREA');
                }
                editor.e
                    .on('beforeGetNativeEditorValue', function () {
                    return clearMarkers(editor.o.iframeDoctype +
                        doc.documentElement.outerHTML);
                })
                    .on('beforeSetNativeEditorValue', function (value) {
                    if (editor.isLocked) {
                        return false;
                    }
                    if (/<(html|body)/i.test(value)) {
                        var old = doc.documentElement.outerHTML;
                        if (clearMarkers(old) !==
                            clearMarkers(value)) {
                            doc.open();
                            doc.write(editor.o.iframeDoctype +
                                clearMarkers(value));
                            doc.close();
                            editor.editor = doc.body;
                            toggleEditable();
                            editor.e.fire('prepareWYSIWYGEditor');
                        }
                    }
                    else {
                        doc.body.innerHTML = value;
                    }
                    return true;
                });
            }
            editor.editor = doc.body;
            editor.e.on('afterSetMode afterInit afterAddPlace', toggleEditable);
            if (opt.height === 'auto') {
                doc.documentElement &&
                    (doc.documentElement.style.overflowY = 'hidden');
                var resizeIframe = editor.async.throttle(function () {
                    if (editor.editor &&
                        editor.iframe &&
                        opt.height === 'auto') {
                        helpers_1.css(editor.iframe, 'height', editor.editor.offsetHeight);
                    }
                }, editor.defaultTimeout / 2);
                editor.e
                    .on('change afterInit afterSetMode resize', resizeIframe)
                    .on([editor.iframe, editor.ew, doc.documentElement], 'load', resizeIframe)
                    .on(doc, 'readystatechange DOMContentLoaded', resizeIframe);
            }
            if (doc.documentElement) {
                editor.e
                    .on(doc.documentElement, 'mousedown touchend', function () {
                    if (!editor.s.isFocused()) {
                        editor.s.focus();
                        if (editor.editor === doc.body) {
                            editor.s.setCursorIn(doc.body);
                        }
                    }
                })
                    .on(editor.ew, 'mousedown touchstart keydown keyup touchend click mouseup mousemove scroll', function (e) {
                    var _a;
                    (_a = editor.events) === null || _a === void 0 ? void 0 : _a.fire(editor.ow, e);
                });
            }
            return false;
        };
        return helpers_1.callPromise(result, init);
    });
}
exports.iframe = iframe;


/***/ }),
/* 273 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(274), exports);
tslib_1.__exportStar(__webpack_require__(281), exports);
tslib_1.__exportStar(__webpack_require__(282), exports);


/***/ }),
/* 274 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.imageProperties = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(275);
var config_1 = __webpack_require__(8);
var modules_1 = __webpack_require__(10);
var helpers_1 = __webpack_require__(19);
var widget_1 = __webpack_require__(256);
var button_1 = __webpack_require__(92);
var templates_1 = __webpack_require__(276);
var decorators_1 = __webpack_require__(99);
var image_editor_1 = __webpack_require__(196);
var helpers_2 = __webpack_require__(280);
config_1.Config.prototype.image = {
    dialogWidth: 600,
    openOnDblClick: true,
    editSrc: true,
    useImageEditor: true,
    editTitle: true,
    editAlt: true,
    editLink: true,
    editSize: true,
    editBorderRadius: true,
    editMargins: true,
    editClass: true,
    editStyle: true,
    editId: true,
    editAlign: true,
    showPreview: true,
    selectImageAfterClose: true
};
var normalSizeToString = function (value) {
    value = helpers_1.trim(value);
    return /^[0-9]+$/.test(value) ? value + 'px' : value;
};
var normalSizeFromString = function (value) {
    return /^[-+]?[0-9.]+px$/.test(value.toString())
        ? parseFloat(value.toString())
        : value;
};
var imageProperties = (function (_super) {
    tslib_1.__extends(imageProperties, _super);
    function imageProperties() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            image: new Image(),
            get ratio() {
                return this.image.naturalWidth / this.image.naturalHeight || 1;
            },
            sizeIsLocked: true,
            marginIsLocked: true
        };
        return _this;
    }
    imageProperties.prototype.onChangeMarginIsLocked = function () {
        var _this = this;
        if (!this.form) {
            return;
        }
        var _a = helpers_1.refs(this.form), marginRight = _a.marginRight, marginBottom = _a.marginBottom, marginLeft = _a.marginLeft, lockMargin = _a.lockMargin;
        [marginRight, marginBottom, marginLeft].forEach(function (elm) {
            helpers_1.attr(elm, 'disabled', _this.state.marginIsLocked || null);
        });
        lockMargin.innerHTML = modules_1.Icon.get(this.state.marginIsLocked ? 'lock' : 'unlock');
    };
    imageProperties.prototype.onChangeSizeIsLocked = function () {
        if (!this.form) {
            return;
        }
        var _a = helpers_1.refs(this.form), lockSize = _a.lockSize, imageWidth = _a.imageWidth;
        lockSize.innerHTML = modules_1.Icon.get(this.state.sizeIsLocked ? 'lock' : 'unlock');
        lockSize.classList.remove('jodit-properties__lock');
        lockSize.classList.remove('jodit-properties__unlock');
        lockSize.classList.add(this.state.sizeIsLocked
            ? 'jodit-properties__lock'
            : 'jodit-properties__unlock');
        this.j.e.fire(imageWidth, 'change');
    };
    imageProperties.prototype.open = function () {
        this.makeForm();
        this.j.e.fire('hidePopup');
        helpers_1.markOwner(this.j, this.dialog.container);
        this.state.marginIsLocked = true;
        this.state.sizeIsLocked = true;
        this.updateValues();
        this.dialog.open().setModal(true).setPosition();
        return false;
    };
    imageProperties.prototype.makeForm = function () {
        var _this = this;
        if (this.dialog) {
            return;
        }
        this.dialog = new modules_1.Dialog({
            fullsize: this.j.o.fullsize,
            globalFullSize: this.j.o.globalFullSize,
            theme: this.j.o.theme,
            language: this.j.o.language,
            minWidth: Math.min(400, screen.width),
            minHeight: 400,
            buttons: ['fullsize', 'dialog.close']
        });
        var editor = this.j, opt = editor.o, i18n = editor.i18n.bind(editor), buttons = {
            check: button_1.Button(editor, 'ok', 'Apply'),
            remove: button_1.Button(editor, 'bin', 'Delete')
        };
        editor.e.on(this.dialog, 'afterClose', function () {
            if (_this.state.image.parentNode &&
                opt.image.selectImageAfterClose) {
                editor.s.select(_this.state.image);
            }
        });
        buttons.remove.onAction(function () {
            editor.s.removeNode(_this.state.image);
            _this.dialog.close();
        });
        var dialog = this.dialog;
        dialog.setHeader(i18n('Image properties'));
        var mainForm = templates_1.form(editor);
        this.form = mainForm;
        dialog.setContent(mainForm);
        var tabsBox = helpers_1.refs(this.form).tabsBox;
        if (tabsBox) {
            tabsBox.appendChild(widget_1.TabsWidget(editor, [
                { name: 'Image', content: templates_1.mainTab(editor) },
                { name: 'Advanced', content: templates_1.positionTab(editor) }
            ]));
        }
        buttons.check.onAction(this.onApply);
        var _a = helpers_1.refs(this.form), changeImage = _a.changeImage, editImage = _a.editImage;
        editor.e.on(changeImage, 'click', this.openImagePopup);
        if (opt.image.useImageEditor) {
            editor.e.on(editImage, 'click', this.openImageEditor);
        }
        var _b = helpers_1.refs(mainForm), lockSize = _b.lockSize, lockMargin = _b.lockMargin, imageWidth = _b.imageWidth, imageHeight = _b.imageHeight;
        if (lockSize) {
            editor.e.on(lockSize, 'click', function () {
                _this.state.sizeIsLocked = !_this.state.sizeIsLocked;
            });
        }
        editor.e.on(lockMargin, 'click', function (e) {
            _this.state.marginIsLocked = !_this.state.marginIsLocked;
            e.preventDefault();
        });
        var changeSizes = function (event) {
            if (!helpers_1.isNumeric(imageWidth.value) || !helpers_1.isNumeric(imageHeight.value)) {
                return;
            }
            var w = parseFloat(imageWidth.value), h = parseFloat(imageHeight.value);
            if (event.target === imageWidth) {
                imageHeight.value = Math.round(w / _this.state.ratio).toString();
            }
            else {
                imageWidth.value = Math.round(h * _this.state.ratio).toString();
            }
        };
        editor.e.on([imageWidth, imageHeight], 'change keydown mousedown paste', function (event) {
            if (!_this.state.sizeIsLocked) {
                return;
            }
            editor.async.setTimeout(changeSizes.bind(_this, event), {
                timeout: editor.defaultTimeout,
                label: 'image-properties-changeSize'
            });
        });
        dialog.setFooter([buttons.remove, buttons.check]);
        dialog.setSize(this.j.o.image.dialogWidth);
    };
    imageProperties.prototype.updateValues = function () {
        var _this = this;
        var opt = this.j.o;
        var image = this.state.image;
        var _a = helpers_1.refs(this.form), marginTop = _a.marginTop, marginRight = _a.marginRight, marginBottom = _a.marginBottom, marginLeft = _a.marginLeft, lockMargin = _a.lockMargin, imageSrc = _a.imageSrc, id = _a.id, classes = _a.classes, align = _a.align, style = _a.style, imageTitle = _a.imageTitle, imageAlt = _a.imageAlt, borderRadius = _a.borderRadius, imageLink = _a.imageLink, imageWidth = _a.imageWidth, imageHeight = _a.imageHeight, imageLinkOpenInNewTab = _a.imageLinkOpenInNewTab, imageViewSrc = _a.imageViewSrc, lockSize = _a.lockSize;
        var updateLock = function () {
            lockMargin.checked = _this.state.marginIsLocked;
            lockSize.checked = _this.state.sizeIsLocked;
        }, updateAlign = function () {
            if (image.style.cssFloat &&
                ['left', 'right'].indexOf(image.style.cssFloat.toLowerCase()) !== -1) {
                align.value = helpers_1.css(image, 'float');
            }
            else {
                if (helpers_1.css(image, 'display') === 'block' &&
                    image.style.marginLeft === 'auto' &&
                    image.style.marginRight === 'auto') {
                    align.value = 'center';
                }
            }
        }, updateBorderRadius = function () {
            borderRadius.value = (parseInt(image.style.borderRadius || '0', 10) || '0').toString();
        }, updateId = function () {
            id.value = helpers_1.attr(image, 'id') || '';
        }, updateStyle = function () {
            style.value = helpers_1.attr(image, 'style') || '';
        }, updateClasses = function () {
            classes.value = (helpers_1.attr(image, 'class') || '').replace(/jodit_focused_image[\s]*/, '');
        }, updateMargins = function () {
            if (!opt.image.editMargins) {
                return;
            }
            var equal = true, wasEmptyField = false;
            [marginTop, marginRight, marginBottom, marginLeft].forEach(function (elm) {
                var id = helpers_1.attr(elm, 'data-ref') || '';
                var value = image.style.getPropertyValue(helpers_1.kebabCase(id));
                if (!value) {
                    wasEmptyField = true;
                    elm.value = '';
                    return;
                }
                if (/^[0-9]+(px)?$/.test(value)) {
                    value = parseInt(value, 10);
                }
                elm.value = value.toString() || '';
                if ((wasEmptyField && elm.value) ||
                    (equal &&
                        id !== 'marginTop' &&
                        elm.value !== marginTop.value)) {
                    equal = false;
                }
            });
            _this.state.marginIsLocked = equal;
        }, updateSizes = function () {
            var width = helpers_1.attr(image, 'width') ||
                helpers_1.css(image, 'width', undefined, true) ||
                false, height = helpers_1.attr(image, 'height') ||
                helpers_1.css(image, 'height', undefined, true) ||
                false;
            imageWidth.value =
                width !== false
                    ? normalSizeFromString(width).toString()
                    : image.offsetWidth.toString();
            imageHeight.value =
                height !== false
                    ? normalSizeFromString(height).toString()
                    : image.offsetHeight.toString();
            _this.state.sizeIsLocked = (function () {
                if (!helpers_1.isNumeric(imageWidth.value) ||
                    !helpers_1.isNumeric(imageHeight.value)) {
                    return false;
                }
                var w = parseFloat(imageWidth.value), h = parseFloat(imageHeight.value);
                return Math.abs(w - h * _this.state.ratio) < 1;
            })();
        }, updateText = function () {
            imageTitle.value = helpers_1.attr(image, 'title') || '';
            imageAlt.value = helpers_1.attr(image, 'alt') || '';
            var a = modules_1.Dom.closest(image, 'a', _this.j.editor);
            if (a) {
                imageLink.value = helpers_1.attr(a, 'href') || '';
                imageLinkOpenInNewTab.checked =
                    helpers_1.attr(a, 'target') === '_blank';
            }
            else {
                imageLink.value = '';
                imageLinkOpenInNewTab.checked = false;
            }
        }, updateSrc = function () {
            imageSrc.value = helpers_1.attr(image, 'src') || '';
            if (imageViewSrc) {
                helpers_1.attr(imageViewSrc, 'src', helpers_1.attr(image, 'src') || '');
            }
        };
        updateLock();
        updateSrc();
        updateText();
        updateSizes();
        updateMargins();
        updateClasses();
        updateId();
        updateBorderRadius();
        updateAlign();
        updateStyle();
    };
    imageProperties.prototype.onApply = function () {
        var _a = helpers_1.refs(this.form), style = _a.style, imageSrc = _a.imageSrc, borderRadius = _a.borderRadius, imageTitle = _a.imageTitle, imageAlt = _a.imageAlt, imageLink = _a.imageLink, imageWidth = _a.imageWidth, imageHeight = _a.imageHeight, marginTop = _a.marginTop, marginRight = _a.marginRight, marginBottom = _a.marginBottom, marginLeft = _a.marginLeft, imageLinkOpenInNewTab = _a.imageLinkOpenInNewTab, align = _a.align, classes = _a.classes, id = _a.id;
        var opt = this.j.o;
        var image = this.state.image;
        if (opt.image.editStyle) {
            helpers_1.attr(image, 'style', style.value || null);
        }
        if (imageSrc.value) {
            helpers_1.attr(image, 'src', imageSrc.value);
        }
        else {
            modules_1.Dom.safeRemove(image);
            this.dialog.close();
            return;
        }
        if (borderRadius.value !== '0' && /^[0-9]+$/.test(borderRadius.value)) {
            image.style.borderRadius = borderRadius.value + 'px';
        }
        else {
            image.style.borderRadius = '';
        }
        helpers_1.attr(image, 'title', imageTitle.value || null);
        helpers_1.attr(image, 'alt', imageAlt.value || null);
        var link = modules_1.Dom.closest(image, 'a', this.j.editor);
        if (imageLink.value) {
            if (!link) {
                link = modules_1.Dom.wrap(image, 'a', this.j.createInside);
            }
            helpers_1.attr(link, 'href', imageLink.value);
            helpers_1.attr(link, 'target', imageLinkOpenInNewTab.checked ? '_blank' : null);
        }
        else {
            if (link && link.parentNode) {
                link.parentNode.replaceChild(image, link);
            }
        }
        if (imageWidth.value !== image.offsetWidth.toString() ||
            imageHeight.value !== image.offsetHeight.toString()) {
            helpers_1.css(image, {
                width: helpers_1.trim(imageWidth.value)
                    ? normalSizeToString(imageWidth.value)
                    : null,
                height: helpers_1.trim(imageHeight.value)
                    ? normalSizeToString(imageHeight.value)
                    : null
            });
            helpers_1.attr(image, 'width', null);
            helpers_1.attr(image, 'height', null);
        }
        var margins = [marginTop, marginRight, marginBottom, marginLeft];
        if (opt.image.editMargins) {
            if (!this.state.marginIsLocked) {
                margins.forEach(function (margin) {
                    var side = helpers_1.attr(margin, 'data-ref') || '';
                    helpers_1.css(image, side, normalSizeToString(margin.value));
                });
            }
            else {
                helpers_1.css(image, 'margin', normalSizeToString(marginTop.value));
            }
        }
        if (opt.image.editClass) {
            helpers_1.attr(image, 'class', classes.value || null);
        }
        if (opt.image.editId) {
            helpers_1.attr(image, 'id', id.value || null);
        }
        if (opt.image.editAlign) {
            helpers_2.hAlignElement(image, align.value);
        }
        this.j.setEditorValue();
        this.dialog.close();
    };
    imageProperties.prototype.openImageEditor = function () {
        var _this = this;
        var url = helpers_1.attr(this.state.image, 'src') || '', a = this.j.c.element('a'), loadExternal = function () {
            if (a.host !== location.host) {
                modules_1.Confirm(_this.j.i18n('You can only edit your own images. Download this image on the host?'), function (yes) {
                    if (yes && _this.j.uploader) {
                        _this.j.uploader.uploadRemoteImage(a.href.toString(), function (resp) {
                            modules_1.Alert(_this.j.i18n('The image has been successfully uploaded to the host!'), function () {
                                if (helpers_1.isString(resp.newfilename)) {
                                    helpers_1.attr(_this.state.image, 'src', resp.baseurl +
                                        resp.newfilename);
                                    _this.updateValues();
                                }
                            }).bindDestruct(_this.j);
                        }, function (error) {
                            modules_1.Alert(_this.j.i18n('There was an error loading %s', error.message)).bindDestruct(_this.j);
                        });
                    }
                }).bindDestruct(_this.j);
                return;
            }
        };
        a.href = url;
        this.j.filebrowser.dataProvider
            .getPathByUrl(a.href.toString())
            .then(function (resp) {
            image_editor_1.openImageEditor.call(_this.j.filebrowser, a.href, resp.name, resp.path, resp.source, function () {
                var timestamp = new Date().getTime();
                helpers_1.attr(_this.state.image, 'src', url +
                    (url.indexOf('?') !== -1 ? '' : '?') +
                    '&_tmp=' +
                    timestamp.toString());
                _this.updateValues();
            }, function (error) {
                modules_1.Alert(error.message).bindDestruct(_this.j);
            });
        })
            .catch(function (error) {
            modules_1.Alert(error.message, loadExternal).bindDestruct(_this.j);
        });
    };
    imageProperties.prototype.openImagePopup = function (event) {
        var _this = this;
        var popup = new modules_1.Popup(this.j), changeImage = helpers_1.refs(this.form).changeImage;
        popup.setZIndex(this.dialog.getZIndex() + 1);
        popup
            .setContent(widget_1.FileSelectorWidget(this.j, {
            upload: function (data) {
                if (data.files && data.files.length) {
                    helpers_1.attr(_this.state.image, 'src', data.baseurl + data.files[0]);
                }
                _this.updateValues();
                popup.close();
            },
            filebrowser: function (data) {
                if (data &&
                    helpers_1.isArray(data.files) &&
                    data.files.length) {
                    helpers_1.attr(_this.state.image, 'src', data.files[0]);
                    popup.close();
                    _this.updateValues();
                }
            }
        }, this.state.image, popup.close))
            .open(function () { return helpers_1.position(changeImage); });
        event.stopPropagation();
    };
    imageProperties.prototype.afterInit = function (editor) {
        var _this = this;
        var self = this;
        editor.e
            .on('afterConstructor changePlace', function () {
            editor.e
                .off(editor.editor, '.imageproperties')
                .on(editor.editor, 'dblclick.imageproperties', function (e) {
                var image = e.target;
                if (!modules_1.Dom.isTag(image, 'img')) {
                    return;
                }
                if (editor.o.image.openOnDblClick) {
                    self.state.image = image;
                    if (!editor.o.readonly) {
                        e.stopImmediatePropagation();
                        e.preventDefault();
                        self.open();
                    }
                }
                else {
                    e.stopImmediatePropagation();
                    editor.s.select(image);
                }
            });
        })
            .on('openImageProperties.imageproperties', function (image) {
            _this.state.image = image;
            _this.open();
        });
    };
    imageProperties.prototype.beforeDestruct = function (editor) {
        this.dialog && this.dialog.destruct();
        editor.e.off(editor.editor, '.imageproperties').off('.imageproperties');
    };
    tslib_1.__decorate([
        decorators_1.watch('state.marginIsLocked')
    ], imageProperties.prototype, "onChangeMarginIsLocked", null);
    tslib_1.__decorate([
        decorators_1.watch('state.sizeIsLocked')
    ], imageProperties.prototype, "onChangeSizeIsLocked", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], imageProperties.prototype, "onApply", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], imageProperties.prototype, "openImageEditor", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], imageProperties.prototype, "openImagePopup", null);
    return imageProperties;
}(modules_1.Plugin));
exports.imageProperties = imageProperties;


/***/ }),
/* 275 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 276 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(277), exports);
tslib_1.__exportStar(__webpack_require__(278), exports);
tslib_1.__exportStar(__webpack_require__(279), exports);


/***/ }),
/* 277 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.form = void 0;
var ui_1 = __webpack_require__(75);
function form(editor) {
    var _a = editor.o.image, showPreview = _a.showPreview, editSize = _a.editSize, gi = ui_1.Icon.get.bind(ui_1.Icon);
    return editor.c.fromHTML("<form class=\"jodit-properties\">\n\t\t<div class=\"jodit-grid jodit-grid_xs-column\">\n\t\t\t<div class=\"jodit_col-lg-2-5 jodit_col-xs-5-5\">\n\t\t\t\t<div class=\"jodit-properties_view_box\">\n\t\t\t\t\t<div style=\"" + (!showPreview ? 'display:none' : '') + "\" class=\"jodit-properties_image_view\">\n\t\t\t\t\t\t<img data-ref=\"imageViewSrc\" src=\"\" alt=\"\"/>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div style=\"" + (!editSize ? 'display:none' : '') + "\" class=\"jodit-form__group jodit-properties_image_sizes\">\n\t\t\t\t\t\t<input data-ref=\"imageWidth\" type=\"text\" class=\"jodit-input\"/>\n\t\t\t\t\t\t<a data-ref=\"lockSize\" class=\"jodit-properties__lock\">" + gi('lock') + "</a>\n\t\t\t\t\t\t<input data-ref=\"imageHeight\" type=\"text\" class=\"imageHeight jodit-input\"/>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div data-ref=\"tabsBox\" class=\"jodit_col-lg-3-5 jodit_col-xs-5-5\"></div>\n\t\t</div>\n\t</form>");
}
exports.form = form;


/***/ }),
/* 278 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.mainTab = void 0;
var ui_1 = __webpack_require__(75);
function mainTab(editor) {
    var opt = editor.o, i18n = editor.i18n.bind(editor), gi = ui_1.Icon.get.bind(ui_1.Icon), hasFbUrl = opt.filebrowser.ajax.url || opt.uploader.url, hasEditor = opt.image.useImageEditor;
    return editor.c.fromHTML("<div style=\"" + (!opt.image.editSrc ? 'display:none' : '') + "\" class=\"jodit-form__group\">\n\t\t\t<label>" + i18n('Src') + "</label>\n\t\t\t<div class=\"jodit-input_group\">\n\t\t\t\t<input data-ref=\"imageSrc\" class=\"jodit-input\" type=\"text\"/>\n\t\t\t\t<div\n\t\t\t\t\tclass=\"jodit-input_group-buttons\"\n\t\t\t\t\tstyle=\"" + (hasFbUrl ? '' : 'display: none') + "\"\n\t\t\t\t>\n\t\t\t\t\t\t<a\n\t\t\t\t\t\t\tdata-ref=\"changeImage\"\n\t\t\t\t\t\t\tclass=\"jodit-button\"\n\t\t\t\t\t\t>" + gi('image') + "</a>\n\t\t\t\t\t\t<a\n\t\t\t\t\t\t\tdata-ref=\"editImage\"\n\t\t\t\t\t\t\tclass=\"jodit-button\"\n\t\t\t\t\t\t\tstyle=\"" + (hasEditor ? '' : 'display: none') + "\"\n\t\t\t\t\t\t>" + gi('crop') + "</a>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t\t<div style=\"" + (!opt.image.editTitle ? 'display:none' : '') + "\" class=\"jodit-form__group\">\n\t\t\t<label>" + i18n('Title') + "</label>\n\t\t\t<input data-ref=\"imageTitle\" type=\"text\" class=\"jodit-input\"/>\n\t\t</div>\n\t\t<div style=\"" + (!opt.image.editAlt ? 'display:none' : '') + "\" class=\"jodit-form__group\">\n\t\t\t<label>" + i18n('Alternative') + "</label>\n\t\t\t<input data-ref=\"imageAlt\" type=\"text\" class=\"jodit-input\"/>\n\t\t</div>\n\t\t<div style=\"" + (!opt.image.editLink ? 'display:none' : '') + "\" class=\"jodit-form__group\">\n\t\t\t<label>" + i18n('Link') + "</label>\n\t\t\t<input data-ref=\"imageLink\" type=\"text\" class=\"jodit-input\"/>\n\t\t</div>\n\t\t<div style=\"" + (!opt.image.editLink ? 'display:none' : '') + "\" class=\"jodit-form__group\">\n\t\t\t<label class=\"jodit_vertical_middle\">\n\t\t\t\t<input data-ref=\"imageLinkOpenInNewTab\" type=\"checkbox\" class=\"jodit-checkbox\"/>\n\t\t\t\t<span>" + i18n('Open link in new tab') + "</span>\n\t\t\t</label>\n\t\t</div>");
}
exports.mainTab = mainTab;


/***/ }),
/* 279 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.positionTab = void 0;
var ui_1 = __webpack_require__(75);
function positionTab(editor) {
    var opt = editor.o, i18n = editor.i18n.bind(editor), gi = ui_1.Icon.get.bind(ui_1.Icon);
    return editor.c.fromHTML("<div style=\"" + (!opt.image.editMargins ? 'display:none' : '') + "\" class=\"jodit-form__group\">\n\t\t\t<label>" + i18n('Margins') + "</label>\n\t\t\t<div class=\"jodit-grid jodit_vertical_middle\">\n\t\t\t\t<input class=\"jodit_col-lg-1-5 jodit-input\" data-ref=\"marginTop\" type=\"text\" placeholder=\"" + i18n('top') + "\"/>\n\t\t\t\t<a style=\"text-align: center;\" data-ref=\"lockMargin\" class=\"jodit-properties__lock jodit_col-lg-1-5\">" + gi('lock') + "</a>\n\t\t\t\t<input disabled=\"true\" class=\"jodit_col-lg-1-5 jodit-input\" data-ref=\"marginRight\" type=\"text\" placeholder=\"" + i18n('right') + "\"/>\n\t\t\t\t<input disabled=\"true\" class=\"jodit_col-lg-1-5 jodit-input\" data-ref=\"marginBottom\" type=\"text\" placeholder=\"" + i18n('bottom') + "\"/>\n\t\t\t\t<input disabled=\"true\" class=\"jodit_col-lg-1-5 jodit-input\" data-ref=\"marginLeft\" type=\"text\" placeholder=\"" + i18n('left') + "\"/>\n\t\t\t</div>\n\t\t</div>\n\t\t<div style=\"" + (!opt.image.editStyle ? 'display:none' : '') + "\" class=\"jodit-form__group\">\n\t\t\t<label>" + i18n('Styles') + "</label>\n\t\t\t<input data-ref=\"style\" type=\"text\" class=\"jodit-input\"/>\n\t\t</div>\n\t\t<div style=\"" + (!opt.image.editClass ? 'display:none' : '') + "\" class=\"jodit-form__group\">\n\t\t\t<label>" + i18n('Classes') + "</label>\n\t\t\t<input data-ref=\"classes\" type=\"text\" class=\"jodit-input\"/>\n\t\t</div>\n\t\t<div style=\"" + (!opt.image.editId ? 'display:none' : '') + "\" class=\"jodit-form__group\">\n\t\t\t<label>Id</label>\n\t\t\t<input data-ref=\"id\" type=\"text\" class=\"jodit-input\"/>\n\t\t</div>\n\t\t<div\n\t\t\tstyle=\"" + (!opt.image.editBorderRadius ? 'display:none' : '') + "\"\n\t\t\tclass=\"jodit-form__group\"\n\t\t>\n\t\t\t<label>" + i18n('Border radius') + "</label>\n\t\t\t\t<input data-ref=\"borderRadius\" type=\"number\" class=\"jodit-input\"/>\n\t\t</div>\n\t\t<div\n\t\t\tstyle=\"" + (!opt.image.editAlign ? 'display:none' : '') + "\"\n\t\t\tclass=\"jodit-form__group\"\n\t\t>\n\t\t\t<label>" + i18n('Align') + "</label>\n\t\t\t<select data-ref=\"align\" class=\"jodit-select\">\n\t\t\t\t<option value=\"\">" + i18n('--Not Set--') + "</option>\n\t\t\t\t<option value=\"left\">" + i18n('Left') + "</option>\n\t\t\t\t<option value=\"center\">" + i18n('Center') + "</option>\n\t\t\t\t<option value=\"right\">" + i18n('Right') + "</option>\n\t\t\t</select>\n\t\t</div>");
}
exports.positionTab = positionTab;


/***/ }),
/* 280 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.hAlignElement = void 0;
var helpers_1 = __webpack_require__(19);
var hAlignElement = function (image, align) {
    if (align && align !== 'normal') {
        if (align !== 'center') {
            helpers_1.css(image, 'float', align);
            helpers_1.clearCenterAlign(image);
        }
        else {
            helpers_1.css(image, {
                float: '',
                display: 'block',
                marginLeft: 'auto',
                marginRight: 'auto'
            });
        }
    }
    else {
        if (helpers_1.css(image, 'float') &&
            ['right', 'left'].indexOf(helpers_1.css(image, 'float').toString().toLowerCase()) !== -1) {
            helpers_1.css(image, 'float', '');
        }
        helpers_1.clearCenterAlign(image);
    }
};
exports.hAlignElement = hAlignElement;


/***/ }),
/* 281 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.imageProcessor = void 0;
var helpers_1 = __webpack_require__(19);
var JODIT_IMAGE_PROCESSOR_BINDED = '__jodit_imageprocessor_binded';
function imageProcessor(editor) {
    editor.e.on('change afterInit changePlace', editor.async.debounce(function () {
        if (editor.editor) {
            helpers_1.$$('img', editor.editor).forEach(function (elm) {
                if (!elm[JODIT_IMAGE_PROCESSOR_BINDED]) {
                    elm[JODIT_IMAGE_PROCESSOR_BINDED] = true;
                    if (!elm.complete) {
                        elm.addEventListener('load', function ElementOnLoad() {
                            var _a;
                            !editor.isInDestruct &&
                                ((_a = editor.e) === null || _a === void 0 ? void 0 : _a.fire('resize'));
                            elm.removeEventListener('load', ElementOnLoad);
                        });
                    }
                    editor.e.on(elm, 'mousedown touchstart', function () {
                        editor.s.select(elm);
                    });
                }
            });
        }
    }, editor.defaultTimeout));
}
exports.imageProcessor = imageProcessor;


/***/ }),
/* 282 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.image = void 0;
var tslib_1 = __webpack_require__(7);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var widget_1 = __webpack_require__(256);
var config_1 = __webpack_require__(8);
config_1.Config.prototype.controls.image = {
    popup: function (editor, current, self, close) {
        var sourceImage = null;
        if (current &&
            !dom_1.Dom.isText(current) &&
            dom_1.Dom.isHTMLElement(current, editor.ew) &&
            (dom_1.Dom.isTag(current, 'img') || helpers_1.$$('img', current).length)) {
            sourceImage = dom_1.Dom.isTag(current, 'img')
                ? current
                : helpers_1.$$('img', current)[0];
        }
        editor.s.save();
        return widget_1.FileSelectorWidget(editor, {
            filebrowser: function (data) {
                editor.s.restore();
                data.files &&
                    data.files.forEach(function (file) {
                        return editor.s.insertImage(data.baseurl + file, null, editor.o.imageDefaultWidth);
                    });
                close();
            },
            upload: true,
            url: function (url, text) { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
                var image;
                return tslib_1.__generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            editor.s.restore();
                            image = sourceImage || editor.createInside.element('img');
                            image.setAttribute('src', url);
                            image.setAttribute('alt', text);
                            if (!!sourceImage) return [3, 2];
                            return [4, editor.s.insertImage(image, null, editor.o.imageDefaultWidth)];
                        case 1:
                            _a.sent();
                            _a.label = 2;
                        case 2:
                            close();
                            return [2];
                    }
                });
            }); }
        }, sourceImage, close);
    },
    tags: ['img'],
    tooltip: 'Insert Image'
};
function image(editor) {
    editor.registerButton({
        name: 'image',
        group: 'media'
    });
}
exports.image = image;


/***/ }),
/* 283 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.indent = void 0;
var config_1 = __webpack_require__(8);
var constants_1 = __webpack_require__(9);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
config_1.Config.prototype.controls.indent = {
    tooltip: 'Increase Indent'
};
var getKey = function (direction) {
    return direction === 'rtl' ? 'marginRight' : 'marginLeft';
};
config_1.Config.prototype.controls.outdent = {
    isDisabled: function (editor) {
        var current = editor.s.current();
        if (current) {
            var currentBox = dom_1.Dom.closest(current, function (node) { return dom_1.Dom.isBlock(node, editor.ew); }, editor.editor);
            var key = getKey(editor.o.direction);
            if (currentBox && currentBox.style && currentBox.style[key]) {
                return parseInt(currentBox.style[key], 10) <= 0;
            }
        }
        return true;
    },
    tooltip: 'Decrease Indent'
};
config_1.Config.prototype.indentMargin = 10;
function indent(editor) {
    var key = getKey(editor.o.direction);
    editor
        .registerButton({
        name: 'indent',
        group: 'indent'
    })
        .registerButton({
        name: 'outdent',
        group: 'indent'
    });
    var callback = function (command) {
        var indentedBoxes = [];
        editor.s.eachSelection(function (current) {
            editor.s.save();
            var currentBox = current
                ? dom_1.Dom.up(current, function (node) { return dom_1.Dom.isBlock(node, editor.ew); }, editor.editor)
                : false;
            var enter = editor.o.enter;
            if (!currentBox && current) {
                currentBox = dom_1.Dom.wrapInline(current, enter !== constants_1.BR ? enter : constants_1.PARAGRAPH, editor);
            }
            if (!currentBox) {
                editor.s.restore();
                return false;
            }
            var alreadyIndented = indentedBoxes.indexOf(currentBox) !== -1;
            if (currentBox && currentBox.style && !alreadyIndented) {
                indentedBoxes.push(currentBox);
                var value = currentBox.style[key]
                    ? parseInt(currentBox.style[key], 10)
                    : 0;
                value +=
                    editor.o.indentMargin * (command === 'outdent' ? -1 : 1);
                currentBox.style[key] = value > 0 ? value + 'px' : '';
                if (!helpers_1.attr(currentBox, 'style')) {
                    currentBox.removeAttribute('style');
                }
            }
            editor.s.restore();
        });
        editor.setEditorValue();
        return false;
    };
    editor.registerCommand('indent', {
        exec: callback,
        hotkeys: ['ctrl+]', 'cmd+]']
    });
    editor.registerCommand('outdent', {
        exec: callback,
        hotkeys: ['ctrl+[', 'cmd+[']
    });
}
exports.indent = indent;


/***/ }),
/* 284 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var tslib_1 = __webpack_require__(7);
tslib_1.__exportStar(__webpack_require__(285), exports);


/***/ }),
/* 285 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.hr = void 0;
var config_1 = __webpack_require__(8);
var dom_1 = __webpack_require__(32);
config_1.Config.prototype.controls.hr = {
    command: 'insertHorizontalRule',
    tags: ['hr'],
    tooltip: 'Insert Horizontal Line'
};
function hr(editor) {
    editor.registerButton({
        name: 'hr',
        group: 'insert'
    });
    editor.registerCommand('insertHorizontalRule', function () {
        var elm = editor.createInside.element('hr');
        editor.s.insertNode(elm, false, false);
        var block = dom_1.Dom.closest(elm.parentElement, function (node) { return dom_1.Dom.isBlock(node, editor.ew); }, editor.editor);
        if (block && dom_1.Dom.isEmpty(block) && block !== editor.editor) {
            dom_1.Dom.after(block, elm);
            dom_1.Dom.safeRemove(block);
        }
        var p = dom_1.Dom.next(elm, function (node) { return dom_1.Dom.isBlock(node, editor.ew); }, editor.editor, false);
        if (!p) {
            p = editor.createInside.element(editor.o.enter);
            dom_1.Dom.after(elm, p);
        }
        editor.s.setCursorIn(p);
        return false;
    });
}
exports.hr = hr;


/***/ }),
/* 286 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.inlinePopup = void 0;
var tslib_1 = __webpack_require__(7);
__webpack_require__(287);
__webpack_require__(288);
var plugin_1 = __webpack_require__(184);
var factory_1 = __webpack_require__(173);
var popup_1 = __webpack_require__(116);
var helpers_1 = __webpack_require__(19);
var modules_1 = __webpack_require__(10);
var decorators_1 = __webpack_require__(99);
var inlinePopup = (function (_super) {
    tslib_1.__extends(inlinePopup, _super);
    function inlinePopup() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.requires = ['select'];
        _this.type = null;
        _this.popup = new popup_1.Popup(_this.jodit, false);
        _this.toolbar = factory_1.makeCollection(_this.jodit, _this.popup);
        _this.snapRange = null;
        _this.elmsList = helpers_1.keys(_this.j.o.popup, false).filter(function (s) { return !_this.isExcludedTarget(s); });
        return _this;
    }
    inlinePopup.prototype.onClick = function (node) {
        var _this = this;
        var elements = this.elmsList, target = modules_1.Dom.isTag(node, 'img')
            ? node
            : modules_1.Dom.closest(node, elements, this.j.editor);
        if (target && this.canShowPopupForType(target.nodeName.toLowerCase())) {
            this.showPopup(function () { return helpers_1.position(target, _this.j); }, target.nodeName.toLowerCase(), target);
            return false;
        }
    };
    inlinePopup.prototype.showPopup = function (rect, type, target) {
        type = type.toLowerCase();
        if (!this.canShowPopupForType(type)) {
            return false;
        }
        if (this.type !== type || target !== this.previousTarget) {
            this.previousTarget = target;
            var data = this.j.o.popup[type];
            var content = void 0;
            if (helpers_1.isFunction(data)) {
                content = data(this.j, target, this.popup.close);
            }
            else {
                content = data;
            }
            if (helpers_1.isArray(content)) {
                this.toolbar.build(content, target);
                this.toolbar.buttonSize = this.j.o.toolbarButtonSize;
                content = this.toolbar.container;
            }
            this.popup.setContent(content);
            this.type = type;
        }
        this.popup.open(rect);
        return true;
    };
    inlinePopup.prototype.hidePopup = function (type) {
        if (!helpers_1.isString(type) || type === this.type) {
            this.popup.close();
        }
    };
    inlinePopup.prototype.onOutsideClick = function (e) {
        this.popup.close();
    };
    inlinePopup.prototype.canShowPopupForType = function (type) {
        var data = this.j.o.popup[type.toLowerCase()];
        if (this.j.o.readonly || !this.j.o.toolbarInline || !data) {
            return false;
        }
        return !this.isExcludedTarget(type);
    };
    inlinePopup.prototype.isExcludedTarget = function (type) {
        return helpers_1.splitArray(this.j.o.toolbarInlineDisableFor)
            .map(function (a) { return a.toLowerCase(); })
            .includes(type.toLowerCase());
    };
    inlinePopup.prototype.afterInit = function (jodit) {
        var _this = this;
        this.j.e
            .on('getDiffButtons.mobile', function (toolbar) {
            if (_this.toolbar === toolbar) {
                var names_1 = _this.toolbar.getButtonsNames();
                return helpers_1.toArray(jodit.registeredButtons)
                    .filter(function (btn) {
                    return !_this.j.o.toolbarInlineDisabledButtons.includes(btn.name);
                })
                    .filter(function (item) {
                    var name = helpers_1.isString(item) ? item : item.name;
                    return (name &&
                        name !== '|' &&
                        name !== '\n' &&
                        !names_1.includes(name));
                });
            }
        })
            .on('hidePopup', this.hidePopup)
            .on('showPopup', function (elm, rect, type) {
            _this.showPopup(rect, type || (helpers_1.isString(elm) ? elm : elm.nodeName), helpers_1.isString(elm) ? undefined : elm);
        })
            .on('mousedown keydown', this.onSelectionStart)
            .on('change', function () {
            if (_this.popup.isOpened &&
                _this.previousTarget &&
                !_this.previousTarget.parentNode) {
                _this.hidePopup();
                _this.previousTarget = undefined;
            }
        })
            .on([this.j.ew, this.j.ow], 'mouseup keyup', this.onSelectionEnd);
        this.addListenersForElements();
    };
    inlinePopup.prototype.onSelectionStart = function () {
        this.snapRange = this.j.s.range.cloneRange();
    };
    inlinePopup.prototype.onSelectionEnd = function (e) {
        if (e &&
            e.target &&
            modules_1.UIElement.closestElement(e.target, popup_1.Popup)) {
            return;
        }
        var snapRange = this.snapRange, range = this.j.s.range;
        if (!snapRange ||
            range.collapsed ||
            range.startContainer !== snapRange.startContainer ||
            range.startOffset !== snapRange.startOffset ||
            range.endContainer !== snapRange.endContainer ||
            range.endOffset !== snapRange.endOffset) {
            this.onSelectionChange();
        }
    };
    inlinePopup.prototype.onSelectionChange = function () {
        if (!this.j.o.toolbarInlineForSelection) {
            return;
        }
        var type = 'selection', sel = this.j.s.sel, range = this.j.s.range;
        if ((sel === null || sel === void 0 ? void 0 : sel.isCollapsed) ||
            this.isSelectedTarget(range) ||
            this.tableModule.getAllSelectedCells().length) {
            if (this.type === type && this.popup.isOpened) {
                this.hidePopup();
            }
            return;
        }
        var node = this.j.s.current();
        if (!node) {
            return;
        }
        this.showPopup(function () { return range.getBoundingClientRect(); }, type);
    };
    inlinePopup.prototype.isSelectedTarget = function (r) {
        var sc = r.startContainer;
        return (modules_1.Dom.isElement(sc) &&
            sc === r.endContainer &&
            modules_1.Dom.isTag(sc.childNodes[r.startOffset], helpers_1.keys(this.j.o.popup, false)) &&
            r.startOffset === r.endOffset - 1);
    };
    Object.defineProperty(inlinePopup.prototype, "tableModule", {
        get: function () {
            return this.j.getInstance('Table', this.j.o);
        },
        enumerable: false,
        configurable: true
    });
    inlinePopup.prototype.beforeDestruct = function (jodit) {
        jodit.e
            .off('showPopup')
            .off([this.j.ew, this.j.ow], 'mouseup keyup', this.onSelectionEnd);
        this.removeListenersForElements();
    };
    inlinePopup.prototype.addListenersForElements = function () {
        this.j.e.on(this.elmsList.map(function (e) { return helpers_1.camelCase("click_" + e); }).join(' '), this.onClick);
    };
    inlinePopup.prototype.removeListenersForElements = function () {
        this.j.e.off(this.elmsList.map(function (e) { return helpers_1.camelCase("click_" + e); }).join(' '), this.onClick);
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], inlinePopup.prototype, "onClick", null);
    tslib_1.__decorate([
        decorators_1.wait(function (ctx) { return !ctx.j.isLocked; })
    ], inlinePopup.prototype, "showPopup", null);
    tslib_1.__decorate([
        decorators_1.watch(':clickEditor'),
        decorators_1.autobind
    ], inlinePopup.prototype, "hidePopup", null);
    tslib_1.__decorate([
        decorators_1.watch(':outsideClick')
    ], inlinePopup.prototype, "onOutsideClick", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], inlinePopup.prototype, "onSelectionStart", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], inlinePopup.prototype, "onSelectionEnd", null);
    tslib_1.__decorate([
        decorators_1.debounce(function (ctx) { return ctx.defaultTimeout; })
    ], inlinePopup.prototype, "onSelectionChange", null);
    return inlinePopup;
}(plugin_1.Plugin));
exports.inlinePopup = inlinePopup;


/***/ }),
/* 287 */
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),
/* 288 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
var config_1 = __webpack_require__(8);
config_1.Config.prototype.toolbarInline = true;
config_1.Config.prototype.toolbarInlineForSelection = false;
config_1.Config.prototype.toolbarInlineDisableFor = [];
config_1.Config.prototype.toolbarInlineDisabledButtons = ['source'];
config_1.Config.prototype.popup = {
    a: __webpack_require__(289)/* .default */ .Z,
    img: __webpack_require__(290).default,
    cells: __webpack_require__(291)/* .default */ .Z,
    jodit: __webpack_require__(292)/* .default */ .Z,
    'jodit-media': __webpack_require__(292)/* .default */ .Z,
    selection: [
        'bold',
        'underline',
        'italic',
        'ul',
        'ol',
        '\n',
        'outdent',
        'indent',
        'fontsize',
        'brush',
        'cut',
        '\n',
        'paragraph',
        'link',
        'align',
        'dots'
    ]
};


/***/ }),
/* 289 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
var __webpack_unused_export__;

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
__webpack_unused_export__ = ({ value: true });
var utils_1 = __webpack_require__(20);
exports.Z = [
    {
        name: 'eye',
        tooltip: 'Open link',
        exec: function (editor, current) {
            var href = utils_1.attr(current, 'href');
            if (current && href) {
                editor.ow.open(href);
            }
        }
    },
    {
        name: 'link',
        tooltip: 'Edit link',
        icon: 'pencil'
    },
    'unlink',
    'brush',
    'file'
];


/***/ }),
/* 290 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.align = void 0;
var dom_1 = __webpack_require__(32);
var checker_1 = __webpack_require__(34);
var helpers_1 = __webpack_require__(19);
var helpers_2 = __webpack_require__(280);
exports.align = {
    name: 'left',
    childTemplate: function (_, __, value) { return value; },
    list: ['Left', 'Right', 'Center', 'Normal'],
    exec: function (editor, elm, _a) {
        var control = _a.control;
        if (!dom_1.Dom.isTag(elm, ['img', 'jodit', 'jodit-media'])) {
            return;
        }
        var command = (control.args && checker_1.isString(control.args[0])
            ? control.args[0].toLowerCase()
            : '');
        if (!command) {
            return false;
        }
        helpers_2.hAlignElement(elm, command);
        if (dom_1.Dom.isTag(elm, ['jodit', 'jodit-media']) && elm.firstElementChild) {
            helpers_2.hAlignElement(elm.firstElementChild, command);
        }
        editor.setEditorValue();
        editor.e.fire('recalcPositionPopup');
    },
    tooltip: 'Horizontal align'
};
exports.default = [
    {
        name: 'delete',
        icon: 'bin',
        tooltip: 'Delete',
        exec: function (editor, image) {
            image && editor.s.removeNode(image);
        }
    },
    {
        name: 'pencil',
        exec: function (editor, current) {
            var tagName = current.tagName.toLowerCase();
            if (tagName === 'img') {
                editor.e.fire('openImageProperties', current);
            }
        },
        tooltip: 'Edit'
    },
    {
        name: 'valign',
        list: ['Top', 'Middle', 'Bottom', 'Normal'],
        tooltip: 'Vertical align',
        exec: function (editor, image, _a) {
            var control = _a.control;
            if (!dom_1.Dom.isTag(image, 'img')) {
                return;
            }
            var command = control.args && checker_1.isString(control.args[0])
                ? control.args[0].toLowerCase()
                : '';
            if (!command) {
                return false;
            }
            helpers_1.css(image, 'vertical-align', command === 'normal' ? '' : command);
            editor.e.fire('recalcPositionPopup');
        }
    },
    exports.align
];


/***/ }),
/* 291 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
var __webpack_unused_export__;

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
__webpack_unused_export__ = ({ value: true });
var checker_1 = __webpack_require__(34);
var helpers_1 = __webpack_require__(19);
var widget_1 = __webpack_require__(256);
var cmd = function (control) {
    return control.args && checker_1.isString(control.args[0])
        ? control.args[0].toLowerCase()
        : '';
};
exports.Z = [
    {
        name: 'brush',
        popup: function (editor) {
            if (!checker_1.isJoditObject(editor)) {
                return;
            }
            var selected = editor
                .getInstance('Table', editor.o)
                .getAllSelectedCells();
            if (!selected.length) {
                return false;
            }
            var color = helpers_1.css(selected[0], 'color'), bg_color = helpers_1.css(selected[0], 'background-color'), br_color = helpers_1.css(selected[0], 'border-color'), $bg = widget_1.ColorPickerWidget(editor, function (value) {
                selected.forEach(function (cell) {
                    helpers_1.css(cell, 'background-color', value);
                });
                editor.setEditorValue();
            }, bg_color), $cl = widget_1.ColorPickerWidget(editor, function (value) {
                selected.forEach(function (cell) {
                    helpers_1.css(cell, 'color', value);
                });
                editor.setEditorValue();
            }, color);
            var $br = widget_1.ColorPickerWidget(editor, function (value) {
                selected.forEach(function (cell) {
                    helpers_1.css(cell, 'border-color', value);
                });
                editor.setEditorValue();
            }, br_color);
            return widget_1.TabsWidget(editor, [
                { name: 'Background', content: $bg },
                { name: 'Text', content: $cl },
                { name: 'Border', content: $br }
            ]);
        },
        tooltip: 'Background'
    },
    {
        name: 'valign',
        list: ['Top', 'Middle', 'Bottom', 'Normal'],
        childTemplate: function (_, __, value) { return value; },
        exec: function (editor, table, _a) {
            var control = _a.control;
            var command = cmd(control);
            editor
                .getInstance('Table', editor.o)
                .getAllSelectedCells()
                .forEach(function (cell) {
                helpers_1.css(cell, 'vertical-align', command === 'normal' ? '' : command);
            });
        },
        tooltip: 'Vertical align'
    },
    {
        name: 'splitv',
        list: {
            tablesplitv: 'Split vertical',
            tablesplitg: 'Split horizontal'
        },
        tooltip: 'Split'
    },
    {
        name: 'align',
        icon: 'left'
    },
    '\n',
    {
        name: 'merge',
        command: 'tablemerge',
        tooltip: 'Merge'
    },
    {
        name: 'addcolumn',
        list: {
            tableaddcolumnbefore: 'Insert column before',
            tableaddcolumnafter: 'Insert column after'
        },
        exec: function (editor, table, _a) {
            var control = _a.control;
            if (!checker_1.isJoditObject(editor)) {
                return;
            }
            var command = cmd(control);
            editor.execCommand(command, false, table);
        },
        tooltip: 'Add column'
    },
    {
        name: 'addrow',
        list: {
            tableaddrowbefore: 'Insert row above',
            tableaddrowafter: 'Insert row below'
        },
        exec: function (editor, table, _a) {
            var control = _a.control;
            if (!checker_1.isJoditObject(editor)) {
                return;
            }
            var command = cmd(control);
            editor.execCommand(command, false, table);
        },
        tooltip: 'Add row'
    },
    {
        name: 'delete',
        icon: 'bin',
        list: {
            tablebin: 'Delete table',
            tablebinrow: 'Delete row',
            tablebincolumn: 'Delete column',
            tableempty: 'Empty cell'
        },
        exec: function (editor, table, _a) {
            var control = _a.control;
            if (!checker_1.isJoditObject(editor)) {
                return;
            }
            var command = cmd(control);
            editor.execCommand(command, false, table);
            editor.e.fire('hidePopup');
        },
        tooltip: 'Delete'
    }
];


/***/ }),
/* 292 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
var __webpack_unused_export__;

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
__webpack_unused_export__ = ({ value: true });
var img_1 = __webpack_require__(290);
exports.Z = [
    {
        name: 'bin',
        tooltip: 'Delete',
        exec: function (editor, image) {
            image && editor.s.removeNode(image);
        }
    },
    img_1.align
];


/***/ }),
/* 293 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.justify = exports.alignElement = exports.clearAlign = void 0;
var config_1 = __webpack_require__(8);
var modules_1 = __webpack_require__(10);
var helpers_1 = __webpack_require__(19);
config_1.Config.prototype.controls.align = {
    name: 'left',
    tooltip: 'Align',
    update: function (button) {
        var editor = button.j, control = button.control, current = editor.s.current();
        if (current) {
            var currentBox = modules_1.Dom.closest(current, function (node) { return modules_1.Dom.isBlock(node, editor.ew); }, editor.editor) || editor.editor;
            var currentValue = helpers_1.css(currentBox, 'text-align').toString();
            if (control.defaultValue &&
                control.defaultValue.indexOf(currentValue) !== -1) {
                currentValue = 'left';
            }
            if (control.data &&
                control.data.currentValue !== currentValue &&
                control.list &&
                control.list.indexOf(currentValue) !== -1) {
                if (editor.o.textIcons) {
                    button.state.text = currentValue;
                }
                else {
                    button.state.icon.name = currentValue;
                }
                control.data.currentValue = currentValue;
            }
        }
    },
    isActive: function (editor, btn) {
        var current = editor.s.current();
        if (current && btn.defaultValue) {
            var currentBox = modules_1.Dom.closest(current, function (node) { return modules_1.Dom.isBlock(node, editor.ew); }, editor.editor) || editor.editor;
            return (btn.defaultValue.indexOf(helpers_1.css(currentBox, 'text-align').toString()) === -1);
        }
        return false;
    },
    defaultValue: ['left', 'start', 'inherit'],
    data: {
        currentValue: 'left'
    },
    list: ['center', 'left', 'right', 'justify']
};
config_1.Config.prototype.controls.center = {
    command: 'justifyCenter',
    css: {
        'text-align': 'center'
    },
    tooltip: 'Align Center'
};
config_1.Config.prototype.controls.justify = {
    command: 'justifyFull',
    css: {
        'text-align': 'justify'
    },
    tooltip: 'Align Justify'
};
config_1.Config.prototype.controls.left = {
    command: 'justifyLeft',
    css: {
        'text-align': 'left'
    },
    tooltip: 'Align Left'
};
config_1.Config.prototype.controls.right = {
    command: 'justifyRight',
    css: {
        'text-align': 'right'
    },
    tooltip: 'Align Right'
};
var clearAlign = function (node, editor) {
    modules_1.Dom.each(node, function (elm) {
        if (modules_1.Dom.isHTMLElement(elm, editor.ew)) {
            if (elm.style.textAlign) {
                elm.style.textAlign = '';
                if (!elm.style.cssText.trim().length) {
                    elm.removeAttribute('style');
                }
            }
        }
    });
};
exports.clearAlign = clearAlign;
var alignElement = function (command, box, editor) {
    if (modules_1.Dom.isNode(box, editor.ew) && modules_1.Dom.isElement(box)) {
        exports.clearAlign(box, editor);
        switch (command.toLowerCase()) {
            case 'justifyfull':
                box.style.textAlign = 'justify';
                break;
            case 'justifyright':
                box.style.textAlign = 'right';
                break;
            case 'justifyleft':
                box.style.textAlign = 'left';
                break;
            case 'justifycenter':
                box.style.textAlign = 'center';
                break;
        }
    }
};
exports.alignElement = alignElement;
function justify(editor) {
    editor.registerButton({
        name: 'align',
        group: 'indent'
    });
    var callback = function (command) {
        editor.s.focus();
        editor.s.eachSelection(function (current) {
            if (!current) {
                return;
            }
            var currentBox = modules_1.Dom.up(current, function (node) { return modules_1.Dom.isBlock(node, editor.ew); }, editor.editor);
            if (!currentBox) {
                currentBox = modules_1.Dom.wrapInline(current, editor.o.enterBlock, editor);
            }
            exports.alignElement(command, currentBox, editor);
        });
        return false;
    };
    editor.registerCommand('justifyfull', callback);
    editor.registerCommand('justifyright', callback);
    editor.registerCommand('justifyleft', callback);
    editor.registerCommand('justifycenter', callback);
}
exports.justify = justify;


/***/ }),
/* 294 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.limit = void 0;
var tslib_1 = __webpack_require__(7);
var config_1 = __webpack_require__(8);
var plugin_1 = __webpack_require__(184);
var constants_1 = __webpack_require__(9);
var helpers_1 = __webpack_require__(19);
var decorators_1 = __webpack_require__(99);
config_1.Config.prototype.limitWords = false;
config_1.Config.prototype.limitChars = false;
config_1.Config.prototype.limitHTML = false;
var limit = (function (_super) {
    tslib_1.__extends(limit, _super);
    function limit() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    limit.prototype.afterInit = function (jodit) {
        var _this = this;
        var _a = jodit.o, limitWords = _a.limitWords, limitChars = _a.limitChars;
        if (jodit && (limitWords || limitChars)) {
            var snapshot_1 = null;
            jodit.e
                .off('.limit')
                .on('beforePaste.limit', function () {
                snapshot_1 = jodit.observer.snapshot.make();
            })
                .on('keydown.limit keyup.limit beforeEnter.limit beforePaste.limit', this.checkPreventKeyPressOrPaste)
                .on('change.limit', this.checkPreventChanging)
                .on('afterPaste.limit', function () {
                if (_this.shouldPreventInsertHTML() && snapshot_1) {
                    jodit.observer.snapshot.restore(snapshot_1);
                    return false;
                }
            });
        }
    };
    limit.prototype.shouldPreventInsertHTML = function (event, inputText) {
        if (event === void 0) { event = null; }
        if (inputText === void 0) { inputText = ''; }
        if (event && constants_1.COMMAND_KEYS.includes(event.key)) {
            return false;
        }
        var jodit = this.jodit;
        var _a = jodit.o, limitWords = _a.limitWords, limitChars = _a.limitChars;
        var text = inputText || (jodit.o.limitHTML ? jodit.value : jodit.text);
        var words = this.splitWords(text);
        if (limitWords && words.length >= limitWords) {
            return true;
        }
        return Boolean(limitChars) && words.join('').length >= limitChars;
    };
    limit.prototype.checkPreventKeyPressOrPaste = function (event) {
        if (this.shouldPreventInsertHTML(event)) {
            return false;
        }
    };
    limit.prototype.checkPreventChanging = function (newValue, oldValue) {
        var jodit = this.jodit;
        var _a = jodit.o, limitWords = _a.limitWords, limitChars = _a.limitChars;
        var text = jodit.o.limitHTML ? newValue : helpers_1.stripTags(newValue), words = this.splitWords(text);
        if ((limitWords && words.length > limitWords) ||
            (Boolean(limitChars) && words.join('').length > limitChars)) {
            jodit.value = oldValue;
        }
    };
    limit.prototype.splitWords = function (text) {
        return text
            .replace(constants_1.INVISIBLE_SPACE_REG_EXP(), '')
            .split(constants_1.SPACE_REG_EXP())
            .filter(function (e) { return e.length; });
    };
    limit.prototype.beforeDestruct = function (jodit) {
        jodit.e.off('.limit');
    };
    tslib_1.__decorate([
        decorators_1.autobind
    ], limit.prototype, "checkPreventKeyPressOrPaste", null);
    tslib_1.__decorate([
        decorators_1.autobind
    ], limit.prototype, "checkPreventChanging", null);
    return limit;
}(plugin_1.Plugin));
exports.limit = limit;


/***/ }),
/* 295 */
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2021 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.link = void 0;
var tslib_1 = __webpack_require__(7);
var config_1 = __webpack_require__(8);
var dom_1 = __webpack_require__(32);
var helpers_1 = __webpack_require__(19);
var template_1 = __webpack_require__(296);
var plugin_1 = __webpack_require__(184);
var decorators_1 = __webpack_require__(99);
var modules_1 = __webpack_require__(10);
config_1.Config.prototype.link = {
    formTemplate: template_1.formTemplate,
    followOnDblClick: false,
    processVideoLink: true,
    processPastedLink: true,
    noFollowCheckbox: true,
    openInNewTabCheckbox: true,
    modeClassName: 'input',
    selectMultipleClassName: true,
    selectSizeClassName: 3,
    selectOptionsClassName: [],
    hotkeys: ['ctrl+k', 'cmd+k']
};
config_1.Config.prototype.controls.unlink = {
    exec: function (editor, current) {
        var anchor = dom_1.Dom.closest(current, 'a', editor.editor);
        if (anchor) {
            dom_1.Dom.unwrap(anchor);
        }
        editor.setEditorValue();
        editor.e.fire('hidePopup');
    },
    tooltip: 'Unlink'
};
config_1.Config.prototype.controls.link = {
    isActive: function (editor) {
        var current = editor.s.current();
        return Boolean(current && dom_1.Dom.closest(current, 'a', editor.editor));
    },
    popup: function (editor, current, self, close) {
        return editor.e.fire('generateLinkForm.link', current, close);
    },
    tags: ['a'],
    tooltip: 'Insert link'
};
var link = (function (_super) {
    tslib_1.__extends(link, _super);
    function link() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.buttons = [
            {
                name: 'link',
                group: 'insert'
            }
        ];
        return _this;
    }
    link.prototype.afterInit = function (jodit) {
        var _this = this;
        if (jodit.o.link.followOnDblClick) {
            jodit.e.on('dblclick.link', this.onDblClickOnLink);
        }
        if (jodit.o.link.processPastedLink) {
            jodit.e.on('processPaste.link', this.onProcessPasteLink);
        }
        jodit.e.on('generateLinkForm.link', this.generateForm);
        jodit.registerCommand('openLinkDialog', {
            exec: function () {
                var dialog = new modules_1.Dialog({
                    resizable: false
                });
                var htmlForm = _this.generateForm(jodit.s.current(), function () {
                    dialog.close();
                });
                htmlForm.container.classList.add('jodit-dialog_alert');
                dialog.setContent(htmlForm);
                dialog.open();
                jodit.async.requestIdleCallback(function () {
                    var url_input = helpers_1.refs(htmlForm.container).url_input;
                    url_input === null || url_input === void 0 ? void 0 : url_input.focus();
                });
            },
            hotkeys: jodit.o.link.hotkeys
        });
    };
    link.prototype.onDblClickOnLink = function (e) {
        if (!dom_1.Dom.isTag(e.target, 'a')) {
            return;
        }
        var href = helpers_1.attr(e.target, 'href');
        if (href) {
            location.href = href;
            e.preventDefault();
        }
    };
    link.prototype.onProcessPasteLink = function (ignore, html) {
        var jodit = this.jodit;
        if (helpers_1.isURL(html)) {
            if (jodit.o.link.processVideoLink) {
                var embed = helpers_1.convertMediaUrlToVideoEmbed(html);
                if (embed !== html) {
                    return jodit.createInside.fromHTML(embed);
                }
            }
            var a = jodit.createInside.element('a');
            a.setAttribute('href', html);
            a.textContent = html;
            jodit.e.stopPropagation('processPaste');
            return a;
        }
    };
    link.prototype.generateForm = function (current, close) {
        var jodit = this.jodit;
        var i18n = jodit.i18n.bind(jodit), _a = jodit.o.link, openInNewTabCheckbox = _a.openInNewTabCheckbox, noFollowCheckbox = _a.noFollowCheckbox, formTemplate = _a.formTemplate, formClassName = _a.formClassName, modeClassName = _a.modeClassName;
        var html = formTemplate(jodit), form = helpers_1.isString(html)
            ? jodit.c.fromHTML(html, {
                target_checkbox_box: openInNewTabCheckbox,
                nofollow_checkbox_box: noFollowCheckbox
            })
            : html, htmlForm = dom_1.Dom.isElement(form) ? form : form.container;
        var elements = helpers_1.refs(htmlForm), insert = elements.insert, unlink = elements.unlink, content_input_box = elements.content_input_box, _b = elements, target_checkbox = _b.target_checkbox, nofollow_checkbox = _b.nofollow_checkbox, url_input = _b.url_input, currentElement = current, isImageContent = dom_1.Dom.isImage(currentElement, jodit.ew);
        var content_input = elements.content_input;
        var className_input = elements.className_input, className_select = elements.className_select;
        if (!content_input) {
            content_input = jodit.c.element('input', {
                type: 'hidden',
                ref: 'content_input'
            });
        }
        if (formClassName) {
            htmlForm.classList.add(formClassName);
        }
        if (isImageContent) {
            dom_1.Dom.hide(content_input_box);
        }
        var link;
        var getSelectionText = function () {
            return link
                ? link.innerText
                : helpers_1.stripTags(jodit.s.range.cloneContents(), jodit.ed);
        };
        if (current && dom_1.Dom.closest(current, 'a', jodit.editor)) {
            link = dom_1.Dom.closest(current, 'a', jodit.editor);
        }
        else {
            link = false;
        }
        if (!isImageContent && current) {
            content_input.value = getSelectionText();
        }
        if (link) {
            url_input.value = helpers_1.attr(link, 'href') || '';
            if (modeClassName) {
                switch (modeClassName) {
                    case 'input':
                        if (className_input) {
                            className_input.value = helpers_1.attr(link, 'class') || '';
                        }
                        break;
                    case 'select':
                        if (className_select) {
                            for (var i = 0; i < className_select.selectedOptions.length; i++) {
                                var option = className_select.options.item(i);
                                if (option) {
                                    option.selected = false;
                                }
                            }
                            var classNames = helpers_1.attr(link, 'class') || '';
                            classNames.split(' ').forEach(function (className) {
                                if (className) {
                                    for (var i = 0; i < className_select.options.length; i++) {
                                        var option = className_select.options.item(i);
                                        if ((option === null || option === void 0 ? void 0 : option.value) &&
                                            option.value === className) {
                                            option.selected = true;
                                        }
                                    }
                                }
                            });
                        }
                        break;
    