CREATE SCHEMA IF NOT EXISTS CMDB_TEST;
SET SCHEMA CMDB_TEST;
SET FOREIGN_KEY_CHECKS=0;

CREATE TABLE IF NOT EXISTS `adm_attr_group` (
  `id_adm_attr_group` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_attr_group',
  `name` varchar(64) DEFAULT NULL COMMENT '组名',
  PRIMARY KEY (`id_adm_attr_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `adm_ci_type` (
  `id_adm_ci_type` int(4) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_ci_type',
  `name` varchar(32) DEFAULT NULL COMMENT 'ci类型中文名称',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `id_adm_tenement` int(11) DEFAULT NULL COMMENT 'id_adm_tenement',
  `table_name` varchar(64) NOT NULL COMMENT '真实表名',
  `status` varchar(20) DEFAULT 'notCreated' COMMENT '表状态',
  `catalog_id` int(11) DEFAULT NULL COMMENT 'ci大类类别',
  `ci_global_unique_id` int(11) DEFAULT NULL,
  `seq_no` int(11) NOT NULL DEFAULT '0' COMMENT '序列号',
  `layer_id` int(11) DEFAULT NULL,
  `zoom_level_id` int(11) DEFAULT NULL,
  `image_file_id` int(11) DEFAULT NULL,
  `ci_state_type` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_adm_ci_type`),
  UNIQUE KEY `tableNameIndex` (`table_name`),
  KEY `fk_adm_ci_type_adm_ci_type_1` (`catalog_id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

INSERT INTO `adm_ci_type` (`id_adm_ci_type`, `name`, `description`, `id_adm_tenement`, `table_name`, `status`, `catalog_id`, `ci_global_unique_id`, `seq_no`, `layer_id`, `zoom_level_id`, `image_file_id`, `ci_state_type`) VALUES
	(1, '系统设计', '系统设计', NULL, 'system_design', 'dirty', 131, NULL, 1, 1, NULL, 1, NULL),
	(2, '子系统设计', '子系统设计', NULL, 'subsys_design', 'created', 131, NULL, 2, 1, NULL, 2, NULL),
	(3, '单元设计', '单元设计', NULL, 'unit_design', 'created', 131, NULL, 3, 1, NULL, 3, NULL),
	(4, '服务设计', '服务设计', NULL, 'service_design', 'created', 131, NULL, 4, 1, NULL, 4, NULL),
	(5, '调用设计', '调用设计', NULL, 'invoke_design', 'created', 131, NULL, 5, 1, NULL, 5, NULL),
	(6, '调用时序设计', '调用时序设计', NULL, 'invoke_sequence_design', 'created', 131, NULL, 6, 1, NULL, 6, NULL),
	(7, '子系统', '子系统', NULL, 'subsys', 'created', 132, NULL, 1, 2, NULL, 7, NULL),
	(8, '单元', '单元', NULL, 'unit', 'created', 132, NULL, 2, 2, NULL, 8, NULL),
	(9, '服务', '服务', NULL, 'service', 'created', 132, NULL, 3, 2, NULL, 9, NULL),
	(10, '调用', '调用', NULL, 'invoke', 'created', 132, NULL, 4, 2, NULL, 10, NULL),
	(11, '应用包', '应用包', NULL, 'package', 'created', 132, NULL, 5, 2, NULL, 11, NULL),
	(12, '主机', '主机', NULL, 'host', 'created', 133, NULL, 1, 3, NULL, 12, NULL),
	(13, '块存储', '块存储', NULL, 'block_storage', 'created', 133, NULL, 2, 3, NULL, 13, NULL),
	(14, 'IP地址', 'IP地址', NULL, 'ip_addr', 'created', 133, NULL, 3, 3, NULL, 14, NULL),
	(15, '运行实例', '运行实例', NULL, 'running_instance', 'created', 133, NULL, 4, 3, NULL, 15, NULL),
	(16, '机房', '机房', NULL, 'IDC', 'created', 134, NULL, 1, 4, NULL, 16, NULL),
	(17, '安全区域', '安全区域', NULL, 'zone', 'created', 134, NULL, 2, 4, NULL, 17, NULL),
	(18, '安全区域连接', '安全区域连接', NULL, 'zone_link', 'created', 134, NULL, 3, 4, NULL, 18, NULL),
	(19, '数据中心节点', '数据中心节点', NULL, 'DCN', 'created', 134, NULL, 4, 4, NULL, 19, NULL),
	(20, '资源集', '资源集', NULL, 'resource_set', 'created', 134, NULL, 5, 4, NULL, 20, NULL),
	(21, '网段', '网段', NULL, 'network_segment', 'dirty', 134, NULL, 6, 4, NULL, 21, NULL),
	(22, '机房设计', '机房设计', NULL, 'IDC_design', 'created', 135, NULL, 1, 5, NULL, 22, NULL),
	(23, '安全区域设计', '安全区域设计', NULL, 'zone_design', 'dirty', 135, NULL, 2, 5, NULL, 23, NULL),
	(24, '安全区域连接设计', '安全区域连接设计', NULL, 'zone_link_design', 'created', 135, NULL, 3, 5, NULL, 24, NULL),
	(25, '数据中心节点设计', '数据中心节点设计', NULL, 'DCN_desgin', 'dirty', 135, NULL, 4, 5, NULL, 25, NULL),
	(26, '资源集设计', '资源集设计', NULL, 'resource_set_design', 'dirty', 135, NULL, 5, 5, NULL, 26, NULL),
	(27, '网络连接', '网络连接', NULL, 'network_link', 'created', 11, NULL, 7, 5, 14, 18, NULL),
	(46, '子系统', '子系统', NULL, 'subsystem', 'created', 132, NULL, 1, 2, NULL, 7, NULL),
	(50, 'Mult_Ref_CI_A', 'multiple reference CI', NULL, 'muti_ref_ci_a', 'notCreated', 135, NULL, 6, 5, NULL, 27, NULL),
	(51, 'Mult_Ref_CI_B', 'multiple referenced CI', NULL, 'muti_ref_ci_b', 'notCreated', 135, NULL, 6, 5, NULL, 28, NULL);

CREATE TABLE IF NOT EXISTS `adm_basekey_cat_type` (
  `id_adm_basekey_cat_type` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ci_type_id` int(11) DEFAULT NULL,
  `type` int(4) DEFAULT NULL,
  PRIMARY KEY (`id_adm_basekey_cat_type`),
  KEY `adm_basekey_cat_type_ci_type_1` (`ci_type_id`),
  CONSTRAINT `adm_basekey_cat_type_ci_type_1` FOREIGN KEY (`ci_type_id`) REFERENCES `adm_ci_type` (`id_adm_ci_type`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

INSERT INTO `adm_basekey_cat_type` (`id_adm_basekey_cat_type`, `name`, `description`, `ci_type_id`, `type`) VALUES
	(1, 'sys', NULL, NULL, 1),
	(2, 'common', NULL, NULL, 2),
	(3, 'system_design', NULL, 1, 3),
	(4, 'subsys_design', NULL, 2, 3),
	(5, 'unit_design', NULL, 3, 3),
	(6, 'service_design', NULL, 4, 3),
	(7, 'invoke_design', NULL, 5, 3),
	(8, 'invoke_sequence_design', NULL, 6, 3),
	(9, 'subsys', NULL, 7, 3),
	(10, 'unit', NULL, 8, 3),
	(11, 'service', NULL, 9, 3),
	(12, 'invoke', NULL, 10, 3),
	(13, 'package', NULL, 11, 3),
	(14, 'host', NULL, 12, 3),
	(15, 'block_storage', NULL, 13, 3),
	(16, 'ip_used', NULL, 14, 3),
	(17, 'running_instance', NULL, 15, 3),
	(18, 'IDC', NULL, 16, 3),
	(19, 'zone', NULL, 17, 3),
	(20, 'zone_link', NULL, 18, 3),
	(21, 'DCN', NULL, 19, 3),
	(22, 'resource_set', NULL, 20, 3),
	(23, 'network_segment', NULL, 21, 3),
	(24, 'IDC_design', NULL, 22, 3),
	(25, 'zone_design', NULL, 23, 3),
	(26, 'zone_link_design', NULL, 24, 3),
	(27, 'DCN_desgin', NULL, 25, 3),
	(28, 'resource_set_design', NULL, 26, 3),
	(29, 'subsystem', NULL, 7, 3);

CREATE TABLE IF NOT EXISTS `adm_basekey_cat` (
  `id_adm_basekey_cat` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_basekey_cat',
  `cat_name` varchar(32) DEFAULT NULL COMMENT '类别名称',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `id_adm_role` int(11) DEFAULT NULL COMMENT 'id_adm_role',
  `id_adm_basekey_cat_type` int(11) DEFAULT NULL COMMENT '类型',
  `group_type_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_adm_basekey_cat`),
  KEY `fk_adm_basekey_cat_adm_role_1` (`id_adm_role`),
  KEY `fk_adm_basekey_cat_type` (`id_adm_basekey_cat_type`),
  KEY `fk_adm_basekey_group_type_id` (`group_type_id`),
  CONSTRAINT `fk_adm_basekey_cat_type` FOREIGN KEY (`id_adm_basekey_cat_type`) REFERENCES `adm_basekey_cat_type` (`id_adm_basekey_cat_type`),
  CONSTRAINT `fk_adm_basekey_group_type_id` FOREIGN KEY (`group_type_id`) REFERENCES `adm_basekey_cat` (`id_adm_basekey_cat`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8;

INSERT INTO `adm_basekey_cat` (`id_adm_basekey_cat`, `cat_name`, `description`, `id_adm_role`, `id_adm_basekey_cat_type`, `group_type_id`) VALUES
	(1, 'ci_layer', '层级', NULL, 1, NULL),
	(2, 'ci_attr_type', '属性类型', NULL, 1, NULL),
	(3, 'ci_attr_enum_type', '枚举类型', NULL, 1, NULL),
	(4, 'ci_attr_is_unique', '是否唯一', NULL, 1, NULL),
	(5, 'ci_attr_is_null', '是否为空', NULL, 1, NULL),
	(6, 'ci_attr_is_control', '是否权限', NULL, 1, NULL),
	(7, 'ci_attr_is_auto', '是否自动', NULL, 1, NULL),
	(8, 'ci_attr_ref_type', '引用类型', NULL, 1, NULL),
	(9, 'ci_state_create', '可创建类CI状态', NULL, 1, NULL),
	(10, 'ci_state_start_stop', '可起停类CI状态', NULL, 1, NULL),
	(11, 'business_group', '业务群组', NULL, 2, NULL),
	(12, 'unit_type', '部署单元类型', NULL, 2, NULL),
	(13, 'env_type', '环境类型', NULL, 2, NULL),
	(14, 'charge_type', '计费模式', NULL, 2, NULL),
	(15, 'zone_design_type', '安全区域设计类型', NULL, 2, NULL),
	(16, 'dcn_design_type', 'DCN设计类型', NULL, 2, NULL),
	(17, 'resource_set_design_type', '资源集设计类型', NULL, 2, NULL),
	(18, 'diff_conf', '差异配置', NULL, 2, NULL),
	(19, 'env_int', '环境初始化', NULL, 2, NULL),
	(20, 'deploy_environment', '环境', NULL, 2, 13),
	(21, 'across_idc', '跨IDC部署', NULL, 5, NULL),
	(22, 'service_type', '服务类型', NULL, 6, NULL),
	(23, 'ha_type', '高可用类型', NULL, 2, NULL),
	(24, 'invoke_type', '调用类型', NULL, 7, NULL),
	(25, 'service_dns_domain', '服务域名域', NULL, 11, NULL),
	(26, 'host_type', '主机类型', NULL, 14, NULL),
	(27, 'host_os_type', '主机操作系统类型', NULL, 14, NULL),
	(28, 'host_cpu', '主机CPU', NULL, 14, NULL),
	(29, 'host_mem', '主机内存', NULL, 14, NULL),
	(30, 'host_sys_disk', '主机系统磁盘', NULL, 14, NULL),
	(31, 'block_storage_type', '块存储类型', NULL, 15, NULL),
	(32, 'ip_addr_type', 'IP地址类型', NULL, 16, NULL),
	(33, 'Instance_type', '实例类型', NULL, 17, NULL),
	(34, 'instance_cpu', '实例CPU', NULL, 17, NULL),
	(35, 'instance_mem', '实例内存', NULL, 17, NULL),
	(36, 'instance_disk', '实例磁盘', NULL, 17, NULL),
	(37, 'ci_catalog', '目录', NULL, 1, NULL),
	(38, 'ci_zoom_level', 'Zoom', NULL, 1, NULL),
	(39, 'state_transition_operation', '状态迁移操作', NULL, 1, NULL),
	(40, 'state_transition_action', '状态迁移动作', NULL, 1, NULL),
	(41, 'ci_state_design', '设计类CI状态', NULL, 1, NULL),
	(42, 'zone_layer', '安全区域设计层级', NULL, 2, NULL),
	(43, 'tab_of_architecture_design', '架构设计CI标签', NULL, 1, NULL),
	(44, 'tab_query_of_architecture_design', '架构设计标签查询', NULL, 1, 43),
	(45, 'tab_of_deploy_design', '部署设计CI标签', NULL, 1, NULL),
	(46, 'tab_query_of_deploy_design', '部署设计标签查询', NULL, 1, 45),
	(47, 'tmp', 'tmp', NULL, 1, NULL),
	(48, 'deploy_user', '部署用户', NULL, 13, NULL),
	(49, 'network_segment_type', NULL, NULL, 23, NULL),
	(50, 'charge_period', NULL, NULL, 2, NULL),
	(51, 'view_ci_type_id', '视图相关CI的ID', NULL, 1, NULL);

CREATE TABLE IF NOT EXISTS `adm_basekey_code` (
  `id_adm_basekey` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_basekey',
  `id_adm_basekey_cat` int(11) DEFAULT NULL COMMENT 'id_adm_basekey_cat',
  `code` varchar(255) DEFAULT NULL COMMENT 'key',
  `value` varchar(2000) DEFAULT NULL COMMENT 'name',
  `group_code_id` int(11) DEFAULT NULL COMMENT 'the group code it belong to',
  `code_description` varchar(255) DEFAULT NULL COMMENT '编码描述',
  `seq_no` int(11) DEFAULT NULL COMMENT '排序序号',
  `status` varchar(20) DEFAULT 'active' COMMENT '枚举状态',
  PRIMARY KEY (`id_adm_basekey`),
  UNIQUE KEY `id_adm_basekey_cat_code` (`id_adm_basekey_cat`,`code`),
  KEY `fk_adm_basekey_code_adm_basekey_cat_1` (`id_adm_basekey_cat`),
  KEY `fk_adm_basekey_code_group_code_id` (`group_code_id`),
  CONSTRAINT `fk_adm_basekey_code_adm_basekey_cat_1` FOREIGN KEY (`id_adm_basekey_cat`) REFERENCES `adm_basekey_cat` (`id_adm_basekey_cat`),
  CONSTRAINT `fk_adm_basekey_code_group_code_id` FOREIGN KEY (`group_code_id`) REFERENCES `adm_basekey_code` (`id_adm_basekey`)
) ENGINE=InnoDB AUTO_INCREMENT=218 DEFAULT CHARSET=utf8;

INSERT INTO `adm_basekey_code` (`id_adm_basekey`, `id_adm_basekey_cat`, `code`, `value`, `group_code_id`, `code_description`, `seq_no`, `status`) VALUES
	(1, 1, 'AAL', '应用架构层', NULL, NULL, 1, 'active'),
	(2, 1, 'ADL', '应用部署层', NULL, NULL, 2, 'active'),
	(3, 1, 'SRL', '资源运行层', NULL, NULL, 3, 'active'),
	(4, 1, 'RPL', '资源规划层', NULL, NULL, 4, 'active'),
	(5, 1, 'PDL', '规划设计层', NULL, NULL, 5, 'active'),
	(6, 2, 'text', '文本', NULL, NULL, 1, 'active'),
	(7, 2, 'area', '文本域', NULL, NULL, 2, 'active'),
	(8, 2, 'number', '整型数字', NULL, NULL, 3, 'active'),
	(9, 2, 'regular_text', '正则校验文本', NULL, NULL, 4, 'active'),
	(10, 2, 'datetime', '时间', NULL, NULL, 5, 'active'),
	(11, 2, 'select', '下拉选择', NULL, NULL, 6, 'active'),
	(12, 2, 'multi_enum', '多选下拉选择', NULL, NULL, 7, 'active'),
	(13, 2, 'ref', '引用', NULL, NULL, 8, 'active'),
	(14, 2, 'multi_ref', '多选引用', NULL, NULL, 9, 'active'),
	(15, 2, 'orchestration_ref', '编排引用', NULL, NULL, 10, 'active'),
	(16, 2, 'orchestration_multi_ref', '编排多选引用', NULL, NULL, 11, 'active'),
	(17, 3, 'common', '公共枚举', NULL, NULL, 1, 'active'),
	(18, 3, 'private', '私有枚举', NULL, NULL, 2, 'active'),
	(19, 4, '1', '唯一', NULL, NULL, 1, 'active'),
	(20, 4, '0', '不唯一', NULL, NULL, 2, 'active'),
	(21, 5, '1', '为空', NULL, NULL, 1, 'active'),
	(22, 5, '0', '不为空', NULL, NULL, 1, 'active'),
	(23, 6, '1', '权限控制', NULL, NULL, 1, 'active'),
	(24, 6, '0', '非权限控制', NULL, NULL, 2, 'active'),
	(25, 7, '1', '自动填充', NULL, NULL, 1, 'active'),
	(26, 7, '0', '非自动填充', NULL, NULL, 2, 'active'),
	(27, 8, 'belong', '属于', NULL, NULL, 1, 'active'),
	(28, 8, 'running', '运行在', NULL, NULL, 2, 'active'),
	(29, 8, 'composition', '组成', NULL, NULL, 3, 'active'),
	(30, 8, 'relation', '关联', NULL, NULL, 4, 'active'),
	(31, 8, 'realize', '实现', NULL, NULL, 5, 'active'),
	(32, 8, '预留1', '预留', NULL, NULL, 1, 'active'),
	(33, 8, '预留2', '预留', NULL, NULL, 2, 'active'),
	(34, 10, 'created', '创建', NULL, NULL, 1, 'active'),
	(35, 10, 'startup', '启动', NULL, NULL, 2, 'active'),
	(36, 10, 'change', '变更', NULL, NULL, 3, 'active'),
	(37, 10, 'stoped', '停止', NULL, NULL, 4, 'active'),
	(38, 10, 'destroyed', '销毁', NULL, NULL, 5, 'active'),
	(39, 9, 'created', '创建', NULL, NULL, 6, 'active'),
	(40, 9, 'change', '变更', NULL, NULL, 7, 'active'),
	(41, 9, 'destroyed', '销毁', NULL, NULL, 8, 'active'),
	(42, 11, 'loan_group', '贷款业务群组', NULL, NULL, 1, 'active'),
	(43, 11, 'deposit_group', '存款业务群组', NULL, NULL, 2, 'active'),
	(44, 12, 'mysql', 'mysql', NULL, NULL, 1, 'active'),
	(45, 12, 'tomcat', 'tomcat', NULL, NULL, 2, 'active'),
	(46, 12, 'redis', 'redis', NULL, NULL, 3, 'active'),
	(47, 13, 'PRD', '生产', NULL, NULL, 1, 'active'),
	(48, 13, 'STG', '准生产', NULL, NULL, 2, 'active'),
	(49, 20, 'PRD', '生产环境', 47, NULL, 1, 'active'),
	(50, 20, 'STGi', 'STGi环境', 48, NULL, 2, 'active'),
	(51, 20, 'STGk', 'STGk环境', 48, NULL, 3, 'active'),
	(52, 14, 'PREPAID', '包年包月', NULL, NULL, 1, 'active'),
	(53, 14, 'time_count', '按时间计费', NULL, NULL, 2, 'inactive'),
	(54, 14, 'POSTPAID_BY_HOUR', '按量计费', NULL, NULL, 3, 'active'),
	(55, 15, 'dmz', 'DMZ', NULL, NULL, 1, 'active'),
	(56, 15, 'ecn', 'ECN', NULL, NULL, 2, 'active'),
	(57, 15, 'qz', 'QZ', NULL, NULL, 3, 'active'),
	(58, 15, 'sf', 'SF', NULL, NULL, 4, 'active'),
	(59, 15, 'mgmt', 'MGMT', NULL, NULL, 5, 'active'),
	(60, 16, 'adm', 'ADM', NULL, NULL, 1, 'active'),
	(61, 16, 'cs', 'CS', NULL, NULL, 2, 'active'),
	(62, 16, 'dnca', 'CDCN', NULL, NULL, 3, 'active'),
	(63, 16, 'dncb', 'RDCN', NULL, NULL, 4, 'active'),
	(64, 16, 'dmz', 'DMZ', NULL, NULL, 5, 'active'),
	(65, 16, 'ecn', 'ECN', NULL, NULL, 6, 'active'),
	(66, 17, 'app', '应用', NULL, NULL, 1, 'active'),
	(67, 17, 'db', '数据库', NULL, NULL, 2, 'active'),
	(68, 17, 'cache', '缓存', NULL, NULL, 3, 'active'),
	(69, 18, 'rmb_ip', '', NULL, NULL, 1, 'active'),
	(70, 18, 'rmb_port', '', NULL, NULL, 2, 'active'),
	(71, 18, 'rmb_name', '', NULL, NULL, 3, 'active'),
	(72, 19, 'tomcat初始化', 'XXXX', NULL, NULL, 1, 'active'),
	(73, 19, 'mysql初始化', 'XXXX', NULL, NULL, 2, 'active'),
	(74, 21, 'cross_regional', '异地IDC', NULL, NULL, 1, 'active'),
	(75, 21, 'cross-local', '同城IDC', NULL, NULL, 2, 'active'),
	(76, 21, 'single', '单IDC', NULL, NULL, 3, 'active'),
	(77, 22, 'tcp_long', 'tcp长连接', NULL, NULL, 1, 'active'),
	(78, 22, 'tcp_short', 'tcp短连接', NULL, NULL, 2, 'active'),
	(79, 22, 'udp', 'udp', NULL, NULL, 3, 'active'),
	(80, 23, 'dns', 'DNS', NULL, NULL, 1, 'active'),
	(81, 23, 'clb-intranet', '腾讯云内网负载均衡', NULL, NULL, 2, 'active'),
	(82, 23, 'clb-internet', '腾讯云外网负载均衡', NULL, NULL, 3, 'active'),
	(83, 23, 'mysql_ms', 'mysql主从切换', NULL, NULL, 4, 'active'),
	(84, 24, 'sync_invoke', '同步调用', NULL, NULL, 1, 'active'),
	(85, 24, 'sync_request', '同步请求', NULL, NULL, 2, 'active'),
	(86, 24, 'async_respond', '异步返回', NULL, NULL, 3, 'active'),
	(87, 25, 'app.wbtest.com', '内网应用域名', NULL, NULL, 1, 'active'),
	(88, 25, 'db.wbtest.com', '内网数据库域名', NULL, NULL, 2, 'active'),
	(89, 25, 'cache.wbtest.com', '内网缓存域名', NULL, NULL, 3, 'active'),
	(90, 25, 'wbtest.com', '外网应用域名', NULL, NULL, 4, 'active'),
	(91, 26, 'SA1.SMALL2', '标准型-1Core2G', NULL, NULL, 1, 'active'),
	(92, 26, 'V_HOST', '虚拟机', NULL, NULL, 2, 'inactive'),
	(93, 26, 'SA1.MEDIUM4', '标准型-2Core4G', NULL, NULL, 3, 'active'),
	(94, 27, 'img-31tjrtph', 'CentOS 7.2 64位', NULL, NULL, 1, 'active'),
	(95, 27, 'img-6ns5om13', 'CentOS 6.8 64位', NULL, NULL, 2, 'active'),
	(96, 27, 'CentOs7.4', 'CentOs7.4', NULL, NULL, 3, 'inactive'),
	(97, 28, '2', '2', NULL, NULL, 1, 'active'),
	(98, 28, '4', '4', NULL, NULL, 2, 'active'),
	(99, 28, '8', '8', NULL, NULL, 3, 'active'),
	(100, 29, '4', '4', NULL, NULL, 1, 'active'),
	(101, 29, '8', '8', NULL, NULL, 2, 'active'),
	(102, 29, '16', '16', NULL, NULL, 3, 'active'),
	(103, 30, '50', '50', NULL, NULL, 1, 'active'),
	(104, 30, '100', '100', NULL, NULL, 2, 'active'),
	(105, 30, '200', '200', NULL, NULL, 3, 'active'),
	(106, 31, 'high_performance', '高性能', NULL, NULL, 1, 'active'),
	(107, 31, 'high_capacity', '高容量', NULL, NULL, 2, 'active'),
	(108, 31, 'ssd', 'SSD', NULL, NULL, 3, 'active'),
	(109, 32, 'intranet_ip', '内网IP', NULL, NULL, 1, 'active'),
	(110, 32, 'internet_ip', '外网IP', NULL, NULL, 2, 'active'),
	(111, 32, '预留4', '预留', NULL, NULL, 3, 'active'),
	(112, 32, '预留5', '预留', NULL, NULL, 4, 'active'),
	(113, 32, '预留6', '预留', NULL, NULL, 5, 'active'),
	(114, 32, '预留7', '预留', NULL, NULL, 6, 'active'),
	(115, 32, '预留8', '预留', NULL, NULL, 7, 'active'),
	(116, 33, 'master', '主节点', NULL, NULL, 1, 'active'),
	(117, 33, 'slave', '从节点', NULL, NULL, 2, 'active'),
	(118, 33, 'balance', '负载均衡节点', NULL, NULL, 3, 'active'),
	(119, 34, '1', '1', NULL, NULL, 1, 'active'),
	(120, 34, '2', '2', NULL, NULL, 2, 'active'),
	(121, 34, '4', '4', NULL, NULL, 3, 'active'),
	(122, 35, '2', '2', NULL, NULL, 1, 'active'),
	(123, 35, '4', '4', NULL, NULL, 2, 'active'),
	(124, 35, '8', '8', NULL, NULL, 3, 'active'),
	(125, 36, '10', '10', NULL, NULL, 1, 'active'),
	(126, 36, '50', '50', NULL, NULL, 2, 'active'),
	(127, 38, '1', '1', NULL, NULL, 1, 'active'),
	(131, 37, 'AAL', '应用架构层', NULL, NULL, 1, 'active'),
	(132, 37, 'ADL', '应用部署层', NULL, NULL, 2, 'active'),
	(133, 37, 'SRL', '资源运行层', NULL, NULL, 3, 'active'),
	(134, 37, 'RPL', '资源规划层', NULL, NULL, 4, 'active'),
	(135, 37, 'PDL', '规划设计层', NULL, NULL, 5, 'active'),
	(137, 38, '2', '2', NULL, NULL, 2, 'active'),
	(138, 38, '3', '3', NULL, NULL, 3, 'active'),
	(139, 38, '4', '4', NULL, NULL, 4, 'active'),
	(140, 38, '5', '5', NULL, NULL, 5, 'active'),
	(141, 41, 'new', '新增', NULL, NULL, 1, 'active'),
	(142, 41, 'update', '更新', NULL, NULL, 2, 'active'),
	(143, 41, 'delete', '删除', NULL, NULL, 3, 'active'),
	(144, 39, 'insert', '添加', NULL, NULL, 1, 'active'),
	(145, 39, 'update', '更新', NULL, NULL, 2, 'active'),
	(146, 39, 'discard', '放弃', NULL, NULL, 3, 'active'),
	(147, 39, 'delete', '删除', NULL, NULL, 4, 'active'),
	(148, 39, 'confirm', '确认', NULL, NULL, 5, 'active'),
	(149, 40, 'insert', '插入', NULL, NULL, 1, 'active'),
	(150, 40, 'insert-update', '插入-更新', NULL, NULL, 2, 'active'),
	(151, 40, 'delete', '删除', NULL, NULL, 3, 'active'),
	(152, 40, 'update-delete', '更新-删除', NULL, NULL, 4, 'active'),
	(153, 40, 'update', '更新', NULL, NULL, 5, 'active'),
	(154, 40, 'confirm', '确认', NULL, NULL, 6, 'active'),
	(155, 42, 'client_layer', '客户端层', NULL, NULL, 1, 'active'),
	(156, 42, 'link_layer', '接入层', NULL, NULL, 2, 'active'),
	(157, 42, 'buss_layer', '业务层', NULL, NULL, 3, 'active'),
	(158, 39, 'startup', '启动', NULL, NULL, 6, 'active'),
	(159, 39, 'stop', '停止', NULL, NULL, 7, 'active'),
	(160, 43, '2', '子系统设计', NULL, NULL, 1, 'active'),
	(161, 43, '3', '单元设计', NULL, NULL, 2, 'active'),
	(162, 43, '4', '服务设计', NULL, NULL, 3, 'active'),
	(163, 43, '5', '调用设计', NULL, NULL, 4, 'active'),
	(164, 43, '6', '调用时序设计', NULL, NULL, 5, 'active'),
	(165, 44, 'guid_of_subsys_design', '[{"ciTypeId":2},{"ciTypeId":1,"parentRs":{"attrId":27,"isReferedFromParent":1}}]', 160, NULL, 1, 'active'),
	(166, 44, 'guid_of_unit_design', '[{"ciTypeId":3},{"ciTypeId":2,"parentRs":{"attrId":43,"isReferedFromParent":1}},{"ciTypeId":1,"parentRs":{"attrId":27,"isReferedFromParent":1}}]', 161, NULL, 2, 'active'),
	(167, 44, 'guid_of_service_design', '[{"ciTypeId":4},{"ciTypeId":3,"parentRs":{"attrId":61,"isReferedFromParent":1}},{"ciTypeId":2,"parentRs":{"attrId":43,"isReferedFromParent":1}},{"ciTypeId":1,"parentRs":{"attrId":27,"isReferedFromParent":1}}]', 162, NULL, 3, 'active'),
	(168, 44, 'guid_of_invoke_design', '[{"ciTypeId":5},{"ciTypeId":3,"parentRs":{"attrId":78,"isReferedFromParent":1}},{"ciTypeId":2,"parentRs":{"attrId":43,"isReferedFromParent":1}},{"ciTypeId":1,"parentRs":{"attrId":27,"isReferedFromParent":1}}]', 163, NULL, 4, 'active'),
	(169, 44, 'guid_of_invoke_seq_design', '[{"ciTypeId":6},{"ciTypeId":4,"parentRs":{"attrId":94,"isReferedFromParent":1}},{"ciTypeId":3,"parentRs":{"attrId":61,"isReferedFromParent":1}},{"ciTypeId":2,"parentRs":{"attrId":43,"isReferedFromParent":1}},{"ciTypeId":1,"parentRs":{"attrId":27,"isReferedFromParent":1}}]', 164, NULL, 5, 'active'),
	(170, 45, '7', '子系统', NULL, NULL, 1, 'active'),
	(171, 45, '8', '单元', NULL, NULL, 2, 'active'),
	(172, 45, '9', '服务', NULL, NULL, 3, 'active'),
	(173, 45, '10', '调用', NULL, NULL, 4, 'active'),
	(174, 45, '11', '应用包', NULL, NULL, 5, 'active'),
	(175, 46, 'guid_of_subsys', '[{"ciTypeId":7},{"ciTypeId":2,"parentRs":{"attrId":109,"isReferedFromParent":1}},{"ciTypeId":1,"parentRs":{"attrId":27,"isReferedFromParent":1}}]', 170, NULL, 1, 'active'),
	(176, 46, 'guid_of_unit', '[{"ciTypeId":8},{"ciTypeId":7,"parentRs":{"attrId":124,"isReferedFromParent":1}},{"ciTypeId":2,"parentRs":{"attrId":109,"isReferedFromParent":1}},{"ciTypeId":1,"parentRs":{"attrId":27,"isReferedFromParent":1}}]', 171, NULL, 2, 'active'),
	(177, 46, 'guid_of_service', '[{"ciTypeId":9},{"ciTypeId":8,"parentRs":{"attrId":142,"isReferedFromParent":1}},{"ciTypeId":7,"parentRs":{"attrId":124,"isReferedFromParent":1}},{"ciTypeId":2,"parentRs":{"attrId":109,"isReferedFromParent":1}},{"ciTypeId":1,"parentRs":{"attrId":27,"isReferedFromParent":1}}]', 172, NULL, 3, 'active'),
	(178, 46, 'guid_of_invoke', '[{"ciTypeId":10},{"ciTypeId":8,"parentRs":{"attrId":162,"isReferedFromParent":1}},{"ciTypeId":7,"parentRs":{"attrId":124,"isReferedFromParent":1}},{"ciTypeId":2,"parentRs":{"attrId":109,"isReferedFromParent":1}},{"ciTypeId":1,"parentRs":{"attrId":27,"isReferedFromParent":1}}]', 173, NULL, 4, 'active'),
	(179, 46, 'guid_of_package', '[{"ciTypeId":11},{"ciTypeId":3,"parentRs":{"attrId":178,"isReferedFromParent":1}},{"ciTypeId":2,"parentRs":{"attrId":43,"isReferedFromParent":1}},{"ciTypeId":1,"parentRs":{"attrId":27,"isReferedFromParent":1}}]', 174, NULL, 5, 'active'),
	(201, 15, 'internet', 'INTERNET', NULL, NULL, 6, 'active'),
	(202, 15, 'intranet', 'INTRANET', NULL, NULL, 7, 'active'),
	(203, 15, 'partnernet', 'PARTNERNET', NULL, NULL, 8, 'active'),
	(204, 16, 'mgmt', 'MGMT', NULL, NULL, 7, 'active'),
	(205, 49, 'vpc', 'VPC网段', NULL, NULL, 1, 'active'),
	(206, 49, 'internet', '互联网网段', NULL, NULL, 2, 'active'),
	(207, 49, 'subnet', 'VPC子网网段', NULL, NULL, 3, 'active'),
	(208, 49, 'idc', '机房网段', NULL, NULL, 4, 'active'),
	(209, 50, '1', '1', NULL, NULL, 1, 'active'),
	(210, 50, '2', '2', NULL, NULL, 2, 'active'),
	(211, 50, '3', '3', NULL, NULL, 3, 'active'),
	(212, 50, '4', '4', NULL, NULL, 4, 'active'),
	(213, 50, '5', '5', NULL, NULL, 5, 'active'),
	(214, 48, 'app', 'tomcat应用用户', NULL, NULL, 1, 'active'),
	(215, 46, 'guid_of_deploy_detail', '[{"ciTypeId": 7},{ "ciTypeId": 2, "parentRs": { "attrId": 109, "isReferedFromParent": 1}},{ "ciTypeId": 1,"parentRs": { "attrId": 27,"isReferedFromParent": 1}}]', NULL, NULL, 6, 'active'),
	(216, 45, '15', '实例', NULL, NULL, 6, 'active'),
	(217, 46, 'guid_of_instance', '[{"ciTypeId":15},{"ciTypeId":8,"parentRs":{"attrId":264,"isReferedFromParent":1}},{"ciTypeId":7,"parentRs":{"attrId":124,"isReferedFromParent":1}},{"ciTypeId":2,"parentRs":{"attrId":109,"isReferedFromParent":1}},{"ciTypeId":1,"parentRs":{"attrId":27,"isReferedFromParent":1}}]', 216, NULL, 7, 'active'),
	(218, 51, 'ciTypeIdOfSystemDesign', '37', NULL, NULL, NULL, 'active'),
	(219, 51, 'ciTypeIdOfSubsystemDesign', '38', NULL, NULL, NULL, 'active'),
	(220, 51, 'ciTypeIdOfUnitDesign', '39', NULL, NULL, NULL, 'active'),
	(221, 51, 'ciTypeIdOfUnit', '48', NULL, NULL, NULL, 'active'),
	(222, 51, 'ciTypeIdOfSubsys', '47', NULL, NULL, NULL, 'active'),
	(223, 51, 'ciTypeIdOfSystem', '46', NULL, NULL, NULL, 'active'),
	(224, 51, 'ciTypeIdOfHost', '32', NULL, NULL, NULL, 'active'),
	(225, 51, 'ciTypeIdOfInstance', '50', NULL, NULL, NULL, 'active'),
	(226, 51, 'ciTypeIdOfIdc', '22', NULL, NULL, NULL, 'active'),
	(227, 51, 'ciTypeIdOfZone', '24', NULL, NULL, NULL, 'active'),
	(228, 51, 'ciTypeIdOfZoneLink', '26', NULL, NULL, NULL, 'active'),
	(229, 51, 'ciTypeIdOfIdcDesign', '12', NULL, NULL, NULL, 'active'),
	(230, 51, 'ciTypeIdOfZoneDesign', '14', NULL, NULL, NULL, 'active'),
	(231, 51, 'ciTypeIdOfZoneLinkDesign', '16', NULL, NULL, NULL, 'active');
CREATE TABLE IF NOT EXISTS `adm_ci_type_attr_base` (
  `id_adm_ci_type_attr` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_ci_type_attr',
  `id_adm_ci_type` int(4) NOT NULL COMMENT 'id_adm_ci_type',
  `name` varchar(64) NOT NULL COMMENT 'CI类型属性中文名',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `input_type` varchar(32) NOT NULL COMMENT '输入类型',
  `property_name` varchar(64) NOT NULL COMMENT '属性真实列名',
  `property_type` varchar(32) NOT NULL COMMENT '属性真实类型',
  `length` int(32) DEFAULT '1' COMMENT '长度',
  `reference_id` int(11) DEFAULT NULL COMMENT '引用ID',
  `reference_name` varchar(64) DEFAULT NULL COMMENT '引用命名',
  `reference_type` int(4) DEFAULT NULL COMMENT '引用类型',
  `filter_rule` varchar(1000) DEFAULT NULL,
  `search_seq_no` int(11) DEFAULT NULL COMMENT '搜索条件排序序号',
  `display_type` int(1) DEFAULT NULL COMMENT '展示类型',
  `display_seq_no` int(11) DEFAULT NULL COMMENT '展示排序',
  `edit_is_null` int(1) DEFAULT NULL,
  `edit_is_only` int(1) DEFAULT NULL COMMENT '是否唯一',
  `edit_is_hiden` int(1) DEFAULT NULL COMMENT '是否隐藏',
  `edit_is_editable` int(1) DEFAULT NULL COMMENT '是否可编辑',
  `is_defunct` int(1) DEFAULT '0' COMMENT '是否丢弃',
  `special_logic` varchar(32) DEFAULT NULL COMMENT '特殊逻辑',
  `status` varchar(20) DEFAULT 'notCreated' COMMENT '属性状态',
  `is_system` int(1) DEFAULT NULL COMMENT '是否系统字段',
  `is_access_controlled` int(1) DEFAULT '0' COMMENT '是否权限控制',
  `is_auto` int(1) DEFAULT NULL,
  `auto_fill_rule` varchar(2000) DEFAULT NULL COMMENT '自动填充规则',
  `regular_expression_rule` varchar(200) DEFAULT NULL COMMENT '正则规则',
  `is_refreshable` int(1) DEFAULT NULL,
  `is_delete_validate` INT(1) NULL DEFAULT 1,
  PRIMARY KEY (`id_adm_ci_type_attr`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


INSERT INTO `adm_ci_type_attr_base` (`id_adm_ci_type_attr`, `id_adm_ci_type`, `name`, `description`, `input_type`, `property_name`, `property_type`, `length`, `reference_id`, `reference_name`, `reference_type`, `filter_rule`, `search_seq_no`, `display_type`, `display_seq_no`, `edit_is_null`, `edit_is_only`, `edit_is_hiden`, `edit_is_editable`, `is_defunct`, `special_logic`, `status`, `is_system`, `is_access_controlled`, `is_auto`, `auto_fill_rule`, `regular_expression_rule`, `is_refreshable`,`is_delete_validate`) VALUES
	(1, 1, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, 0, 0, 1, 0, 1, 0, 0, 0, NULL, 'notCreated', 1, 0, 0, NULL, NULL, 0, 1),
	(2, 1, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, 0, 0, 0, 1, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 0, NULL, NULL, 0, 1),
	(3, 1, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 'notCreated', 1, 0, 0, NULL, NULL, 0, 1),
	(4, 1, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 0, NULL, NULL, 0, 1),
	(5, 1, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 0, NULL, NULL, 0, 1),
	(6, 1, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 0, NULL, NULL, 0, 1),
	(7, 1, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 0, NULL, NULL, 0, 1),
	(8, 1, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 1, 1, 1, 0, 1, 0, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL, NULL, 0, 1),
	(9, 1, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 2, 1, 2, 0, 0, 0, 0, 0, NULL, 'notCreated', 1, 0, 0, NULL, NULL, 0, 1),
	(10, 1, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 3, 1, 3, 1, 0, 0, 0, 0, NULL, 'notCreated', 1, 0, 0, NULL, NULL, 0, 1),
	(11, 1, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, 4, 1, 4, 1, 0, 0, 1, 0, NULL, 'notCreated', 1, 0, 0, NULL, NULL, 0, 1),
	(12, 1, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 5, 0, 0, 0, 1, 0, NULL, 'notCreated', 1, 0, 0, NULL, NULL, 0, 1);

CREATE TABLE IF NOT EXISTS `adm_ci_type_attr` (
  `id_adm_ci_type_attr` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_ci_type_attr',
  `id_adm_ci_type` int(4) NOT NULL COMMENT 'id_adm_ci_type',
  `name` varchar(64) NOT NULL COMMENT 'CI类型属性中文名',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `input_type` varchar(32) NOT NULL COMMENT '输入类型',
  `property_name` varchar(64) NOT NULL COMMENT '属性真实列名',
  `property_type` varchar(32) NOT NULL COMMENT '属性真实类型',
  `length` int(32) DEFAULT '1' COMMENT '长度',
  `reference_id` int(11) DEFAULT NULL COMMENT '引用ID',
  `reference_name` varchar(64) DEFAULT NULL COMMENT '引用命名',
  `reference_type` int(4) DEFAULT NULL COMMENT '引用类型',
  `filter_rule` varchar(1000) DEFAULT NULL,
  `search_seq_no` int(11) DEFAULT NULL COMMENT '搜索条件排序序号',
  `display_type` int(1) DEFAULT NULL COMMENT '展示类型',
  `display_seq_no` int(11) DEFAULT NULL COMMENT '展示排序',
  `edit_is_null` int(1) DEFAULT NULL,
  `edit_is_only` int(1) DEFAULT NULL COMMENT '是否唯一',
  `edit_is_hiden` int(1) DEFAULT NULL COMMENT '是否隐藏',
  `edit_is_editable` int(1) DEFAULT NULL COMMENT '是否可编辑',
  `is_defunct` int(1) DEFAULT '0' COMMENT '是否丢弃',
  `special_logic` varchar(32) DEFAULT NULL COMMENT '特殊逻辑',
  `status` varchar(20) DEFAULT 'notCreated' COMMENT '属性状态',
  `is_system` int(1) DEFAULT NULL COMMENT '是否系统字段',
  `is_access_controlled` int(1) DEFAULT '0' COMMENT '是否权限控制',
  `is_refreshable` INT(1) NULL DEFAULT 0,
  `is_auto` int(1) DEFAULT NULL,
  `auto_fill_rule` varchar(1000) DEFAULT NULL COMMENT '自动填充规则',
  `regular_expression_rule` varchar(200) DEFAULT NULL COMMENT '正则规则',
  `is_delete_validate` INT(1) NULL DEFAULT 1,
  PRIMARY KEY (`id_adm_ci_type_attr`),
  UNIQUE KEY `uniqCiType` (`id_adm_ci_type`,`property_name`)
) ENGINE=InnoDB AUTO_INCREMENT=455 DEFAULT CHARSET=utf8;

INSERT INTO `adm_ci_type_attr` (`id_adm_ci_type_attr`, `id_adm_ci_type`, `name`, `description`, `input_type`, `property_name`, `property_type`, `length`, `reference_id`, `reference_name`, `reference_type`, `filter_rule`, `search_seq_no`, `display_type`, `display_seq_no`, `edit_is_null`, `edit_is_only`, `edit_is_hiden`, `edit_is_editable`, `is_defunct`, `special_logic`, `status`, `is_system`, `is_access_controlled`, `is_auto`, `auto_fill_rule`) VALUES
	(1, 1, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(2, 1, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(3, 1, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(4, 1, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(5, 1, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(6, 1, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(7, 1, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(8, 1, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'dirty', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":1},{\"ciTypeId\":1,\"parentRs\":{\"attrId\":11,\"isReferedFromParent\":1}}]"}]'),
	(9, 1, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(10, 1, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(11, 1, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(12, 1, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(13, 1, '名称', '名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(14, 1, '业务群组', '业务群组', 'select', 'business_group', 'int', 50, 11, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(15, 2, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(16, 2, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(17, 2, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(18, 2, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(19, 2, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(20, 2, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(21, 2, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(22, 2, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":2},{\"ciTypeId\":1,\"parentRs\":{\"attrId\":27,\"isReferedFromParent\":1}},{\"ciTypeId\":1,\"parentRs\":{\"attrId\":8,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"-"},{"type":"rule","value":"[{\"ciTypeId\":2},{\"ciTypeId\":2,\"parentRs\":{\"attrId\":25,\"isReferedFromParent\":1}}]"}]'),
	(23, 2, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(24, 2, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(25, 2, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(26, 2, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(27, 2, '系统设计', '系统设计', 'ref', 'system_design', 'varchar', 15, 1, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(28, 2, '名称', '名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(29, 2, '业务群组', '业务群组', 'select', 'business_group', 'int', 15, 11, NULL, NULL, NULL, 8, 1, 15, 0, 0, 0, 1, 0, NULL, 'dirty', 0, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":2},{\"ciTypeId\":1,\"parentRs\":{\"attrId\":27,\"isReferedFromParent\":1}},{\"ciTypeId\":1,\"parentRs\":{\"attrId\":14,\"isReferedFromParent\":1},\"enumCodeAttr\":\"id\"}]"},{"type":"delimiter","value":""}]'),
	(30, 2, 'DCN设计类型', 'DCN设计类型', 'select', 'dcn_design_type', 'int', 15, 16, NULL, NULL, NULL, 9, 1, 16, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(31, 3, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(32, 3, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(33, 3, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(34, 3, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(35, 3, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(36, 3, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(37, 3, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(38, 3, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":3},{\"ciTypeId\":2,\"parentRs\":{\"attrId\":43,\"isReferedFromParent\":1}},{\"ciTypeId\":2,\"parentRs\":{\"attrId\":22,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"-"},{"type":"rule","value":"[{\"ciTypeId\":3},{\"ciTypeId\":3,\"parentRs\":{\"attrId\":41,\"isReferedFromParent\":1}}]"}]'),
	(39, 3, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(40, 3, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(41, 3, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(42, 3, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(43, 3, '子系统设计', '系统', 'ref', 'subsys_design', 'varchar', 15, 2, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(44, 3, '资源集设计类型', '资源集设计类型', 'select', 'resource_set_design_type', 'int', 15, 17, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(45, 3, '名称', '单元名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 8, 1, 15, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(46, 3, '类型', '类型', 'select', 'type', 'int', 15, 12, NULL, NULL, NULL, 9, 1, 16, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(47, 3, '跨IDC部署', '跨IDC部署', 'select', 'across_idc', 'int', 15, 21, NULL, NULL, NULL, 10, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(48, 3, '编排', '编排', 'orchestration_multi_ref', 'orchestration', 'varchar', 1000, NULL, NULL, NULL, NULL, 11, 1, 18, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(49, 4, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(50, 4, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(51, 4, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(52, 4, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(53, 4, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(54, 4, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(55, 4, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(56, 4, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":4},{\"ciTypeId\":3,\"parentRs\":{\"attrId\":61,\"isReferedFromParent\":1}},{\"ciTypeId\":3,\"parentRs\":{\"attrId\":38,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"-"},{"type":"rule","value":"[{\"ciTypeId\":4},{\"ciTypeId\":4,\"parentRs\":{\"attrId\":59,\"isReferedFromParent\":1}}]"}]'),
	(57, 4, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(58, 4, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(59, 4, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(60, 4, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(61, 4, '单元设计', '单元设计', 'ref', 'unit_design', 'varchar', 15, 3, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(62, 4, '名称', '服务名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(63, 4, '类型', '类型', 'select', 'type', 'int', 15, 22, NULL, NULL, NULL, 8, 1, 15, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(64, 4, '高可用', '高可用', 'select', 'ha_type', 'int', 15, 23, NULL, NULL, NULL, 9, 1, 16, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(65, 4, '编排', '编排', 'orchestration_multi_ref', 'orchestration', 'varchar', 1000, NULL, NULL, NULL, NULL, 10, 1, 17, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(66, 5, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(67, 5, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(68, 5, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(69, 5, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(70, 5, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(71, 5, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(72, 5, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(73, 5, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'dirty', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":5},{\"ciTypeId\":3,\"parentRs\":{\"attrId\":78,\"isReferedFromParent\":1}},{\"ciTypeId\":3,\"parentRs\":{\"attrId\":38,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_invoke_"},{"type":"rule","value":"[{\"ciTypeId\":5},{\"ciTypeId\":4,\"parentRs\":{\"attrId\":79,\"isReferedFromParent\":1}},{\"ciTypeId\":4,\"parentRs\":{\"attrId\":56,\"isReferedFromParent\":1}}]"}]'),
	(74, 5, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(75, 5, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(76, 5, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(77, 5, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(78, 5, '单元设计', '单元设计', 'ref', 'unit_design', 'varchar', 15, 3, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(79, 5, '服务设计', '服务设计', 'ref', 'service_design', 'varchar', 15, 4, '关联', 30, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(80, 5, '类型', '类型', 'select', 'type', 'int', 15, 24, NULL, NULL, NULL, 8, 1, 15, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(81, 5, '编排', '编排', 'orchestration_multi_ref', 'orchestration', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 16, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(82, 6, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(83, 6, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(84, 6, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(85, 6, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(86, 6, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(87, 6, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(88, 6, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(89, 6, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":6},{\"ciTypeId\":4,\"parentRs\":{\"attrId\":94,\"isReferedFromParent\":1}},{\"ciTypeId\":4,\"parentRs\":{\"attrId\":56,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"-"},{"type":"rule","value":"[{\"ciTypeId\":6},{\"ciTypeId\":6,\"parentRs\":{\"attrId\":92,\"isReferedFromParent\":1}}]"}]'),
	(90, 6, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(91, 6, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(92, 6, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(93, 6, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(94, 6, '服务设计', '服务设计', 'ref', 'service_design', 'varchar', 15, 4, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(95, 6, '名称', '服务名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(96, 6, '调用设计序列', '调用序列', 'multiRef', 'invoke_design_sequence', 'varchar', 15, 5, '关联', 30, NULL, 8, 1, 15, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(97, 7, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(98, 7, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(99, 7, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(100, 7, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(101, 7, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(102, 7, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(103, 7, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(104, 7, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":7},{\"ciTypeId\":2,\"parentRs\":{\"attrId\":109,\"isReferedFromParent\":1}},{\"ciTypeId\":2,\"parentRs\":{\"attrId\":22,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":7},{\"ciTypeId\":7,\"parentRs\":{\"attrId\":110,\"isReferedFromParent\":1}}]"}]'),
	(105, 7, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(106, 7, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(107, 7, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(108, 7, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(109, 7, '子系统设计', '子系统设计', 'ref', 'subsys_design', 'varchar', 20, 2, '实现', 31, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(110, 7, '环境', '环境', 'select', 'env', 'int', 15, 20, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(111, 7, '运维人员', '运维人员', 'text', 'manager', 'varchar', 50, NULL, NULL, NULL, NULL, 8, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(112, 8, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(113, 8, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(114, 8, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(115, 8, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(116, 8, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(117, 8, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(118, 8, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(119, 8, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":8},{\"ciTypeId\":7,\"parentRs\":{\"attrId\":124,\"isReferedFromParent\":1}},{\"ciTypeId\":7,\"parentRs\":{\"attrId\":104,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":8},{\"ciTypeId\":3,\"parentRs\":{\"attrId\":125,\"isReferedFromParent\":1}},{\"ciTypeId\":3,\"parentRs\":{\"attrId\":41,\"isReferedFromParent\":1}}]"}]'),
	(120, 8, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(121, 8, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(122, 8, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(123, 8, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(124, 8, '子系统', '子系统', 'ref', 'subsys', 'varchar', 20, 7, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(125, 8, '单元设计', '单元统设计', 'ref', 'unit_design', 'varchar', 20, 3, '实现', 31, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(126, 8, '实例数量', '实例数量', 'number', 'instance_num', 'int', 3, NULL, NULL, NULL, NULL, NULL, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(127, 8, '包', '部署包', 'ref', 'package', 'varchar', 20, 11, '使用', 30, NULL, NULL, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(128, 8, '资源集', '资源集', 'ref', 'resource_set', 'varchar', 15, 20, '关联', 30, NULL, 8, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(129, 8, '编排', '编排', 'orchestration_ref', 'orchestration', 'varchar', 100, NULL, NULL, NULL, NULL, NULL, 1, 18, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(130, 9, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(131, 9, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(132, 9, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(133, 9, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(134, 9, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(135, 9, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(136, 9, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(137, 9, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":9},{\"ciTypeId\":8,\"parentRs\":{\"attrId\":142,\"isReferedFromParent\":1}},{\"ciTypeId\":8,\"parentRs\":{\"attrId\":119,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":9},{\"ciTypeId\":4,\"parentRs\":{\"attrId\":143,\"isReferedFromParent\":1}},{\"ciTypeId\":4,\"parentRs\":{\"attrId\":59,\"isReferedFromParent\":1}}]"}]'),
	(138, 9, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(139, 9, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(140, 9, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(141, 9, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(142, 9, '单元', '单元', 'ref', 'unit', 'varchar', 15, 8, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(143, 9, '服务设计', '服务设计', 'ref', 'service_design', 'varchar', 15, 4, '实现', 31, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(144, 9, '域名域', '域名域', 'select', 'dns_domain', 'int', 15, 25, NULL, NULL, NULL, NULL, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(145, 9, '域名名', '域名名', 'text', 'dns_name', 'varchar', 50, NULL, NULL, NULL, NULL, 8, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(146, 9, '服务端口', '服务端口', 'text', 'service_port', 'varchar', 50, NULL, NULL, NULL, NULL, 9, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(147, 9, '高可用', '高可用', 'select', 'ha_type', 'int', 15, 23, NULL, NULL, NULL, 10, 1, 18, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(148, 9, '服务IP', '服务IP', 'ref', 'service_ip', 'varchar', 15, 14, '使用', 30, NULL, NULL, 1, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(149, 9, '编排', '编排', 'orchestration_ref', 'orchestration', 'varchar', 100, NULL, NULL, NULL, NULL, NULL, 1, 20, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(150, 10, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(151, 10, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(152, 10, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(153, 10, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(154, 10, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(155, 10, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(156, 10, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(157, 10, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":10},{\"ciTypeId\":8,\"parentRs\":{\"attrId\":162,\"isReferedFromParent\":1}},{\"ciTypeId\":8,\"parentRs\":{\"attrId\":119,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_INVOKE_"},{"type":"rule","value":"[{\"ciTypeId\":10},{\"ciTypeId\":9,\"parentRs\":{\"attrId\":163,\"isReferedFromParent\":1}},{\"ciTypeId\":9,\"parentRs\":{\"attrId\":137,\"isReferedFromParent\":1}}]"}]'),
	(158, 10, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(159, 10, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(160, 10, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(161, 10, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(162, 10, '单元', '单元', 'ref', 'unit', 'varchar', 15, 8, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(163, 10, '服务', '服务', 'ref', 'service', 'varchar', 15, 9, '关联', 30, NULL, 7, 1, 14, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(164, 10, '调用设计', '调用设计', 'ref', 'invoke_design', 'varchar', 20, 5, '实现', 31, NULL, 8, 1, 15, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(165, 10, '编排', '编排', 'orchestration_ref', 'orchestration', 'varchar', 100, NULL, NULL, NULL, NULL, NULL, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(166, 11, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(167, 11, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(168, 11, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(169, 11, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(170, 11, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(171, 11, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(172, 11, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(173, 11, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 1, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":11},{\"ciTypeId\":11,\"parentRs\":{\"attrId\":179,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":11},{\"ciTypeId\":11,\"parentRs\":{\"attrId\":181,\"isReferedFromParent\":1}}]"}]'),
	(174, 11, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(175, 11, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(176, 11, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(177, 11, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(178, 11, '单元设计', '单元设计', 'ref', 'unit_design', 'varchar', 15, 3, '关联', 30, NULL, 6, 1, 13, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(179, 11, '包名称', '包名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 7, 1, 14, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(180, 11, 'MD5值', 'MD5值', 'text', 'md5_value', 'varchar', 50, NULL, NULL, NULL, NULL, 8, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(181, 11, '上传时间', '上传时间', 'date', 'upload_time', 'varchar', 19, NULL, NULL, NULL, NULL, 9, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(182, 11, '上传人', '上传人', 'text', 'upload_user', 'varchar', 50, NULL, NULL, NULL, NULL, 10, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(183, 11, '存储路径', '存储路径', 'text', 'url', 'varchar', 1000, NULL, NULL, NULL, NULL, 11, 1, 18, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(184, 11, '执行部署脚本文件', '执行部署脚本文件', 'text', 'deploy_file', 'varchar', 200, NULL, NULL, NULL, NULL, 12, 1, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(185, 11, '部署用户', '部署用户', 'select', 'deploy_user', 'int', 15, 48, NULL, NULL, NULL, 13, 1, 20, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(186, 11, '差异配置文件', '差异配置文件', 'text', 'diff_conf_file', 'varchar', 200, NULL, NULL, NULL, NULL, 14, 1, 21, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(187, 11, '差异配置变量', '差异配置变量', 'select', 'diff_conf_variable', 'int', 15, 18, NULL, NULL, NULL, 15, 1, 22, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(188, 11, '启动脚本文件', '启动脚步文件', 'text', 'start_file', 'varchar', 200, NULL, NULL, NULL, NULL, 16, 1, 23, 1, 0, 0, 1, 0, NULL, 'dirty', 0, 0, 0, NULL),
	(189, 11, '停止脚本文件', '停止脚步文件', 'text', 'stop_file', 'varchar', 200, NULL, NULL, NULL, NULL, 17, 1, 24, 1, 0, 0, 1, 0, NULL, 'dirty', 0, 0, 0, NULL),
	(190, 12, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(191, 12, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(192, 12, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(193, 12, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(194, 12, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(195, 12, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(196, 12, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(197, 12, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":12},{\"ciTypeId\":12,\"parentRs\":{\"attrId\":203,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"-"},{"type":"rule","value":"[{\"ciTypeId\":12},{\"ciTypeId\":14,\"parentRs\":{\"attrId\":206,\"isReferedFromParent\":1}},{\"ciTypeId\":14,\"parentRs\":{\"attrId\":244,\"isReferedFromParent\":1}}]"}]'),
	(198, 12, '状态', '状态', 'select', 'state', 'int', 15, 10, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(199, 12, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(200, 12, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(201, 12, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(202, 12, '资源集', '资源集', 'ref', 'resource_set', 'varchar', 15, 20, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(203, 12, '名称', '名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(204, 12, '类型', '类型', 'select', 'type', 'int', 15, 26, NULL, NULL, NULL, 8, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(205, 12, '操作系统', '操作系统', 'select', 'os', 'int', 15, 27, NULL, NULL, NULL, 9, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(206, 12, '内网IP', '内网IP', 'ref', 'intranet_ip', 'varchar', 15, 14, '使用', 30, NULL, 10, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(207, 12, '外网NATIP', '外网IP', 'ref', 'internet_nat_ip', 'varchar', 15, 14, '使用', 30, NULL, 11, 1, 18, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(208, 12, 'CPU(c)', 'CPU(c)', 'select', 'cpu', 'int', 15, 28, NULL, NULL, NULL, 12, 1, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(209, 12, '内存(G)', '内存(G)', 'select', 'mem', 'int', 15, 29, NULL, NULL, NULL, 13, 1, 20, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(210, 12, '系统盘(G)', '系统盘(G)', 'select', 'disk', 'int', 15, 30, NULL, NULL, NULL, 14, 1, 21, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(211, 12, '计费模式', '计费模式', 'select', 'charge_type', 'int', 15, 14, NULL, NULL, NULL, 15, 1, 22, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(212, 12, '资产编码', '资产编码', 'text', 'asset_code', 'varchar', 50, NULL, NULL, NULL, NULL, 16, 1, 23, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(213, 12, '编排', '编排', 'orchestration_ref', 'orchestration', 'varchar', 100, NULL, NULL, NULL, NULL, NULL, 1, 24, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(214, 13, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(215, 13, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(216, 13, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(217, 13, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(218, 13, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(219, 13, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(220, 13, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(221, 13, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":13},{\"ciTypeId\":12,\"parentRs\":{\"attrId\":226,\"isReferedFromParent\":1}},{\"ciTypeId\":14,\"parentRs\":{\"attrId\":206,\"isReferedFromParent\":1}},{\"ciTypeId\":14,\"parentRs\":{\"attrId\":244,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":13},{\"ciTypeId\":13,\"parentRs\":{\"attrId\":224,\"isReferedFromParent\":1}}]"}]'),
	(222, 13, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(223, 13, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(224, 13, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(225, 13, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(226, 13, '主机', '主机', 'ref', 'host', 'varchar', 15, 12, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(227, 13, '名称', '名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 7, 1, 14, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(228, 13, '挂载点', '挂载点', 'text', 'mount_point', 'varchar', 50, NULL, NULL, NULL, NULL, 8, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(229, 13, '类型', '类型', 'select', 'type', 'int', 15, 31, NULL, NULL, NULL, 9, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(230, 13, '容量(G)', '容量(G)', 'number', 'disk_size', 'int', 15, NULL, NULL, NULL, NULL, 10, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(231, 13, '计费模式', '计费模式', 'select', 'charge_type', 'int', 15, 14, NULL, NULL, NULL, 11, 1, 18, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(232, 13, '资产编码', '资产编码', 'text', 'asset_code', 'varchar', 50, NULL, NULL, NULL, NULL, 12, 1, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(233, 13, '编排', '编排', 'orchestration_ref', 'orchestration', 'varchar', 100, NULL, NULL, NULL, NULL, 13, 1, 20, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(234, 14, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(235, 14, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(236, 14, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(237, 14, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(238, 14, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(239, 14, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(240, 14, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(241, 14, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":14},{\"ciTypeId\":14,\"parentRs\":{\"attrId\":244,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":14},{\"ciTypeId\":14,\"parentRs\":{\"attrId\":250,\"isReferedFromParent\":1}}]"}]'),
	(242, 14, '状态', '状态', 'select', 'state', 'int', 15, 10, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(243, 14, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(244, 14, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(245, 14, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(246, 14, '名称', '名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(247, 14, '子网掩码', '子网掩码', 'number', 'mash', 'int', 2, NULL, NULL, NULL, NULL, 6, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(248, 14, '编排', '编排', 'orchestration_ref', 'orchestration', 'varchar', 100, NULL, NULL, NULL, NULL, 6, 1, 15, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(249, 14, '类型', '类型', 'select', 'type', 'int', 15, 32, NULL, NULL, NULL, 6, 1, 16, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(250, 14, '使用记录', '使用记录', 'textArea', 'used_record', 'varchar', 1000, NULL, NULL, NULL, NULL, 6, 1, 17, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 1, NULL),
	(251, 14, 'IP网段', 'IP网段', 'ref', 'network_segment', 'varchar', 15, 21, '属于', 27, NULL, 6, 1, 18, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(252, 15, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(253, 15, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(254, 15, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(255, 15, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(256, 15, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(257, 15, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(258, 15, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(259, 15, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":15},{\"ciTypeId\":8,\"parentRs\":{\"attrId\":264,\"isReferedFromParent\":1}},{\"ciTypeId\":8,\"parentRs\":{\"attrId\":119,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":15},{\"ciTypeId\":15,\"parentRs\":{\"attrId\":262,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":15},{\"ciTypeId\":12,\"parentRs\":{\"attrId\":265,\"isReferedFromParent\":1}},{\"ciTypeId\":14,\"parentRs\":{\"attrId\":206,\"isReferedFromParent\":1}},{\"ciTypeId\":14,\"parentRs\":{\"attrId\":244,\"isReferedFromParent\":1}}]"}]'),
	(260, 15, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(261, 15, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(262, 15, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(263, 15, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(264, 15, '单元', '单元', 'ref', 'unit', 'varchar', 15, 8, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(265, 15, '主机', '资源集', 'ref', 'host', 'varchar', 15, 12, '运行在', 30, NULL, 7, 1, 14, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(266, 15, '名称', '名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 8, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(267, 15, '端口', '端口', 'text', 'port', 'varchar', 50, NULL, NULL, NULL, NULL, 9, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(268, 15, '资产编码', '资产编码', 'text', 'asset_code', 'varchar', 50, NULL, NULL, NULL, NULL, 10, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(269, 15, '类型', '类型', 'select', 'type', 'int', 15, 33, NULL, NULL, NULL, 11, 1, 18, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(270, 15, 'CPU(c)', 'CPU(c)', 'select', 'cpu', 'int', 15, 34, NULL, NULL, NULL, 12, 1, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(271, 15, '内存(G)', '内存(G)', 'select', 'mem', 'int', 15, 35, NULL, NULL, NULL, 13, 1, 20, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(272, 15, '应用盘(G)', '应用盘(G)', 'select', 'app_disk', 'int', 15, 36, NULL, NULL, NULL, 14, 1, 21, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(273, 15, '计费模式', '计费模式', 'select', 'charge_type', 'int', 15, 14, NULL, NULL, NULL, 15, 1, 22, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(274, 15, '编排', '编排', 'orchestration_ref', 'orchestration', 'varchar', 100, NULL, NULL, NULL, NULL, NULL, 1, 23, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(275, 16, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(276, 16, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(277, 16, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(278, 16, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(279, 16, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(280, 16, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(281, 16, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(282, 16, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":16},{\"ciTypeId\":22,\"parentRs\":{\"attrId\":287,\"isReferedFromParent\":1}},{\"ciTypeId\":22,\"parentRs\":{\"attrId\":390,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":16},{\"ciTypeId\":16,\"parentRs\":{\"attrId\":285,\"isReferedFromParent\":1}}]"}]'),
	(283, 16, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(284, 16, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(285, 16, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(286, 16, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(287, 16, '机房设计', '机房设计', 'ref', 'idc_design', 'varchar', 15, 22, '实现', 31, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(288, 16, '名称', '名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 7, 1, 14, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(289, 16, '城市', '城市', 'text', 'city', 'varchar', 50, NULL, NULL, NULL, NULL, 8, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(290, 16, '地址', '地址', 'text', 'address', 'varchar', 1000, NULL, NULL, NULL, NULL, 9, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(291, 16, '环境类型', '类型', 'select', 'env_type', 'int', 15, 13, NULL, NULL, NULL, 10, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(292, 16, '远程参数', '远程参数', 'textArea', 'parameter', 'varchar', 1000, NULL, NULL, NULL, NULL, 11, 1, 18, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(293, 17, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(294, 17, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(295, 17, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(296, 17, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(297, 17, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(298, 17, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(299, 17, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(300, 17, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'dirty', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":17},{\"ciTypeId\":16,\"parentRs\":{\"attrId\":305,\"isReferedFromParent\":1}},{\"ciTypeId\":16,\"parentRs\":{\"attrId\":282,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":17},{\"ciTypeId\":17,\"parentRs\":{\"attrId\":303,\"isReferedFromParent\":1}}]"}]'),
	(301, 17, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(302, 17, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(303, 17, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(304, 17, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(305, 17, '机房', '机房', 'ref', 'idc', 'varchar', 15, 16, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(306, 17, '安全区域设计', '安全区域设计', 'ref', 'zone_design', 'varchar', 15, 23, '实现', 31, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(307, 17, '名称', '服务名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 8, 1, 15, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(308, 17, '层级', '层级', 'select', 'zone_layer', 'int', 15, 42, NULL, NULL, NULL, 9, 1, 16, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(309, 17, '类型', '类型', 'select', 'type', 'int', 15, 15, NULL, NULL, NULL, 10, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(310, 17, '网段', '网段', 'ref', 'network_segment', 'varchar', 15, 21, '关联', 30, NULL, 11, 1, 18, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(311, 17, '虚拟专用网', '虚拟专用网', 'text', 'vpc', 'varchar', 50, NULL, NULL, NULL, NULL, 12, 1, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(312, 17, '资产编码', '资产编码', 'text', 'asset_code', 'varchar', 50, NULL, NULL, NULL, NULL, 13, 1, 20, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(313, 17, '编排', '编排', 'orchestration_ref', 'orchestration', 'varchar', 100, NULL, NULL, NULL, NULL, 14, 1, 21, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(314, 18, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(315, 18, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(316, 18, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(317, 18, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(318, 18, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(319, 18, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(320, 18, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(321, 18, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'dirty', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":18},{\"ciTypeId\":17,\"parentRs\":{\"attrId\":326,\"isReferedFromParent\":1}},{\"ciTypeId\":17,\"parentRs\":{\"attrId\":300,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_link_"},{"type":"rule","value":"[{\"ciTypeId\":18},{\"ciTypeId\":17,\"parentRs\":{\"attrId\":327,\"isReferedFromParent\":1}},{\"ciTypeId\":17,\"parentRs\":{\"attrId\":300,\"isReferedFromParent\":1}}]"}]'),
	(322, 18, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(323, 18, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(324, 18, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(325, 18, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(326, 18, '安全区域1', '安全区域1', 'ref', 'zone1', 'varchar', 15, 17, '关联', 30, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(327, 18, '安全区域2', '安全区域2', 'ref', 'zone2', 'varchar', 15, 17, '关联', 30, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(328, 18, '安全区域连接设计', '安全区域连接设计', 'ref', 'zone_link_design', 'varchar', 15, 24, '实现', 31, NULL, 8, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(329, 18, '名称', '名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 9, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(330, 18, '资产编码', '资产编码', 'text', 'asset_code', 'varchar', 50, NULL, NULL, NULL, NULL, 10, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(331, 18, '编排', '编排', 'orchestration_ref', 'orchestration', 'varchar', 100, NULL, NULL, NULL, NULL, 11, 1, 18, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(332, 19, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(333, 19, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(334, 19, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(335, 19, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(336, 19, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(337, 19, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(338, 19, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(339, 19, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'dirty', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":19},{\"ciTypeId\":17,\"parentRs\":{\"attrId\":344,\"isReferedFromParent\":1}},{\"ciTypeId\":17,\"parentRs\":{\"attrId\":300,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":19},{\"ciTypeId\":19,\"parentRs\":{\"attrId\":342,\"isReferedFromParent\":1}}]"}]'),
	(340, 19, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(341, 19, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(342, 19, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(343, 19, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(344, 19, '安全区域', '安全区域', 'ref', 'zone', 'varchar', 15, 17, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(345, 19, 'DCN设计', '数据中心节点设计', 'ref', 'dcn_design', 'varchar', 15, 25, '实现', 31, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(346, 19, '名称', '名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 8, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(347, 20, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(348, 20, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(349, 20, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(350, 20, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(351, 20, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(352, 20, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(353, 20, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(354, 20, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'dirty', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":20},{\"ciTypeId\":19,\"parentRs\":{\"attrId\":359,\"isReferedFromParent\":1}},{\"ciTypeId\":19,\"parentRs\":{\"attrId\":339,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":20},{\"ciTypeId\":20,\"parentRs\":{\"attrId\":357,\"isReferedFromParent\":1}}]"}]'),
	(355, 20, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(356, 20, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(357, 20, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(358, 20, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(359, 20, 'DCN', 'DCN', 'ref', 'dcn', 'varchar', 15, 19, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(360, 20, '资源集设计', '资源集设计', 'ref', 'resource_set_design', 'varchar', 15, 26, '实现', 31, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(361, 20, '名称', '名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 8, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(362, 20, '环境', '环境', 'select', 'env', 'int', 15, 20, NULL, NULL, NULL, 9, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(363, 20, '网段', '网段', 'ref', 'network_segment', 'varchar', 15, 21, '关联', 30, NULL, 10, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(364, 20, '编排', '编排', 'orchestration_ref', 'orchestration', 'varchar', 100, NULL, NULL, NULL, NULL, NULL, 1, 18, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(365, 21, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(366, 21, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(367, 21, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(368, 21, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(369, 21, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(370, 21, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(371, 21, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(372, 21, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'dirty', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":21},{\"ciTypeId\":21,\"parentRs\":{\"attrId\":375,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":""}]'),
	(373, 21, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(374, 21, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(375, 21, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(376, 21, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(377, 21, '名称', '服务名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 6, 1, 14, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(378, 21, '子网掩码', '子网', 'number', 'mask', 'int', 15, NULL, NULL, NULL, NULL, 7, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(379, 21, '网关IP地址', '网关IP地址', 'ref', 'gateway_ip', 'varchar', 15, 14, '关联', 30, NULL, 8, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(380, 21, '父网段', '父网段', 'ref', 'f_network_segment', 'varchar', 15, 21, '属于', 27, NULL, 9, 1, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(381, 21, '资产编码', '资产编码', 'text', 'asset_code', 'varchar', 50, NULL, NULL, NULL, NULL, 10, 1, 18, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(382, 21, '编排', '编排', 'orchestration_ref', 'orchestration', 'varchar', 100, NULL, NULL, NULL, NULL, 11, 1, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(383, 22, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(384, 22, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(385, 22, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(386, 22, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(387, 22, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(388, 22, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(389, 22, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(390, 22, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":22},{\"ciTypeId\":22,\"parentRs\":{\"attrId\":393,\"isReferedFromParent\":1}}]"}]'),
	(391, 22, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(392, 22, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(393, 22, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(394, 22, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(395, 22, '名称', '名称', 'text', 'name', 'varchar', 50, NULL, NULL, NULL, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(396, 22, '环境类型', '环境类型', 'select', 'env_type', 'int', 15, 13, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(397, 23, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(398, 23, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(399, 23, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(400, 23, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(401, 23, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(402, 23, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(403, 23, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(404, 23, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'dirty', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":23},{\"ciTypeId\":22,\"parentRs\":{\"attrId\":409,\"isReferedFromParent\":1}},{\"ciTypeId\":22,\"parentRs\":{\"attrId\":390,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":23},{\"ciTypeId\":23,\"parentRs\":{\"attrId\":407,\"isReferedFromParent\":1}}]"}]'),
	(405, 23, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(406, 23, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(407, 23, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(408, 23, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(409, 23, '机房设计', '机房设计', 'ref', 'idc_design', 'varchar', 15, 22, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(410, 23, '类型', '类型', 'select', 'type', 'int', 15, 15, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(411, 23, '层级', '层级', 'select', 'zone_layer', 'int', 15, 42, NULL, NULL, NULL, 8, 1, 15, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(412, 24, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(413, 24, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(414, 24, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(415, 24, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(416, 24, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(417, 24, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(418, 24, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(419, 24, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":24},{\"ciTypeId\":23,\"parentRs\":{\"attrId\":424,\"isReferedFromParent\":1}},{\"ciTypeId\":23,\"parentRs\":{\"attrId\":404,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_LINK_"},{"type":"rule","value":"[{\"ciTypeId\":24},{\"ciTypeId\":23,\"parentRs\":{\"attrId\":425,\"isReferedFromParent\":1}},{\"ciTypeId\":23,\"parentRs\":{\"attrId\":404,\"isReferedFromParent\":1}}]"}]'),
	(420, 24, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(421, 24, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(422, 24, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(423, 24, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(424, 24, '安全区域设计1', '安全区域设计', 'ref', 'zone_design1', 'varchar', 15, 23, '关联', 30, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(425, 24, '安全区域设计2', '安全区域设计', 'ref', 'zone_design2', 'varchar', 15, 23, '关联', 30, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(426, 25, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(427, 25, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(428, 25, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(429, 25, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(430, 25, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(431, 25, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(432, 25, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(433, 25, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'dirty', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":25},{\"ciTypeId\":23,\"parentRs\":{\"attrId\":438,\"isReferedFromParent\":1}},{\"ciTypeId\":23,\"parentRs\":{\"attrId\":404,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":25},{\"ciTypeId\":25,\"parentRs\":{\"attrId\":436,\"isReferedFromParent\":1}}]"}]'),
	(434, 25, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(435, 25, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(436, 25, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(437, 25, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(438, 25, '安全区域设计', '安全区域设计', 'ref', 'zone_design', 'varchar', 15, 23, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(439, 25, '业务群组', '业务群组', 'select', 'business_group', 'int', 15, 11, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(440, 25, '类型', '类型', 'select', 'type', 'int', 15, 16, NULL, NULL, NULL, 8, 1, 15, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(441, 26, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(442, 26, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(443, 26, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(444, 26, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(445, 26, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(446, 26, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(447, 26, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(448, 26, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'dirty', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":26},{\"ciTypeId\":25,\"parentRs\":{\"attrId\":453,\"isReferedFromParent\":1}},{\"ciTypeId\":25,\"parentRs\":{\"attrId\":433,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":26},{\"ciTypeId\":26,\"parentRs\":{\"attrId\":451,\"isReferedFromParent\":1}}]"}]'),
	(449, 26, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(450, 26, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(451, 26, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(452, 26, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(453, 26, '数据中心节点设计', '数据中心节点设计', 'ref', 'dcn_design', 'varchar', 15, 25, '属于', 27, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(454, 26, '类型', '类型', 'select', 'type', 'int', 15, 17, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(455, 21, '类型', '类型', 'select', 'type', 'int', 15, 49, NULL, NULL, NULL, NULL, NULL, 13, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(456, 12, '计费周期', '计费周期', 'select', 'charge_period', 'int', 15, 50, NULL, NULL, NULL, NULL, NULL, NULL, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(457, 15, '计费周期', '计费周期', 'select', 'charge_period', 'int', 15, 50, NULL, NULL, NULL, NULL, 0, 24, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(458, 20, '资产编码', '资产编码', 'text', 'asset_code', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, NULL, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(459, 11, '部署路径', '部署路径', 'text', 'deploy_path', 'varchar', 200, NULL, NULL, NULL, NULL, NULL, 0, 25, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(460, 17, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 22, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(462, 20, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 20, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(463, 12, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 25, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(464, 8, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 1, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(465, 7, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, 9, 1, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(466, 15, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 25, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(467, 11, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 26, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(468, 9, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 21, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(469, 10, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 17, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(470, 14, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(471, 13, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 21, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(472, 16, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(473, 21, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 20, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(474, 18, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 19, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(475, 19, '编排实例ID', '编排实例ID', 'text', 'biz_key', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 16, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
    (497, 46, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(498, 46, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(499, 46, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(500, 46, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(501, 46, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(502, 46, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(503, 46, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(504, 46, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"delimiter","value":""},{"type":"rule","value":"[{\"ciTypeId\":7},{\"ciTypeId\":2,\"parentRs\":{\"attrId\":109,\"isReferedFromParent\":1}},{\"ciTypeId\":2,\"parentRs\":{\"attrId\":22,\"isReferedFromParent\":1}}]"},{"type":"delimiter","value":"_"},{"type":"rule","value":"[{\"ciTypeId\":7},{\"ciTypeId\":7,\"parentRs\":{\"attrId\":110,\"isReferedFromParent\":1}}]"}]'),
	(505, 46, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(506, 46, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'created', 1, 0, 1, NULL),
	(507, 46, '编码', '编码', 'text', 'code', 'varchar', 50, NULL, NULL, NULL, NULL, 5, 1, 11, 0, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	(508, 46, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'created', 1, 0, 0, NULL),
	/*(109, 46, '子系统设计', '子系统设计', 'ref', 'subsys_design', 'varchar', 20, 2, '实现', 31, NULL, 6, 1, 13, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(510, 46, '环境', '环境', 'select', 'env', 'int', 15, 20, NULL, NULL, NULL, 7, 1, 14, 0, 0, 0, 1, 0, NULL, 'created', 0, 1, 0, NULL),
	(511, 46, '运维人员', '运维人员', 'text', 'manager', 'varchar', 50, NULL, NULL, NULL, NULL, 8, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),*/
-- network_link
	(520, 27, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 0, NULL),
	(521, 27, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, 0, 0, 0, 1, 0, 0, 0, 0, NULL, 'created', 1, 0, 0, NULL),
	(522, 27, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 'created', 1, 0, 0, NULL),
	(523, 27, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 'created', 1, 0, 0, NULL),
	(524, 27, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 'created', 1, 0, 0, NULL),
	(525, 27, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 'created', 1, 0, 0, NULL),
	(526, 27, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 'created', 1, 0, 0, NULL),
	(527, 27, '状态', '状态', 'select', 'state', 'int', 15, 8, NULL, NULL, NULL, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 'created', 1, 0, 0, NULL),
	(528, 27, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 1000, NULL, NULL, NULL, NULL, 1, 1, 1, 0, 1, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"rule","value":"[{\\"ciTypeId\\":26},{\\"ciTypeId\\":23,\\"parentRs\\":{\\"attrId\\":423,\\"isReferedFromParent\\":1}},{\\"ciTypeId\\":23,\\"parentRs\\":{\\"attrId\\":360,\\"isReferedFromParent\\":1}}]"},{"type":"delimiter","value":"__"},{"type":"rule","value":"[{\\"ciTypeId\\":26},{\\"ciTypeId\\":16,\\"parentRs\\":{\\"attrId\\":425,\\"isReferedFromParent\\":1}},{\\"ciTypeId\\":16,\\"parentRs\\":{\\"attrId\\":243,\\"isReferedFromParent\\":1}}]"},{"type":"delimiter","value":"__"},{"type":"rule","value":"[{\\"ciTypeId\\":26},{\\"ciTypeId\\":23,\\"parentRs\\":{\\"attrId\\":424,\\"isReferedFromParent\\":1}},{\\"ciTypeId\\":23,\\"parentRs\\":{\\"attrId\\":360,\\"isReferedFromParent\\":1}}]"}]'),
	(529, 27, '状态编码', '状态编码', 'text', 'state_code', 'varchar', 50, NULL, NULL, NULL, NULL, 2, 1, 2, 0, 0, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"rule","value":"[{\\"ciTypeId\\":26},{\\"ciTypeId\\":27,\\"parentRs\\":{\\"attrId\\":418,\\"isReferedFromParent\\":1},\\"enumCodeAttr\\":\\"code\\"}]"}]'),
	(530, 27, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 3, 1, 3, 1, 0, 0, 0, 0, NULL, 'created', 1, 0, 0, NULL),
	(531, 27, '编码', '编码', 'text', 'code', 'varchar', 1000, NULL, NULL, NULL, NULL, 4, 1, 4, 0, 0, 0, 0, 0, NULL, 'created', 1, 0, 1, '[{"type":"rule","value":"[{\\"ciTypeId\\":26},{\\"ciTypeId\\":16,\\"parentRs\\":{\\"attrId\\":425,\\"isReferedFromParent\\":1}},{\\"ciTypeId\\":16,\\"parentRs\\":{\\"attrId\\":243,\\"isReferedFromParent\\":1}}]"}]'),
	(532, 27, '网段1', '网段1', 'ref', 'network_segment_1', 'varchar', 15, 21, '关联', 32, null, 6, 1, 6, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(533, 27, '网段2', '网段2', 'ref', 'network_segment_2', 'varchar', 15, 21, '关联', 32, null, 7, 1, 7, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(534, 27, '网络带宽(M)', '网络带宽(M)', 'text', 'netband_width', 'varchar', 200, NULL, NULL, NULL, NULL, 9, 1, 9, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(535, 27, '资产ID', '资产ID', 'text', 'asset_id', 'varchar', 200, NULL, NULL, NULL, NULL, 13, 1, 13, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(536, 27, '最大并发连接数', '最大并发连接数', 'text', 'max_concurrent', 'varchar', 200, NULL, NULL, NULL, NULL, 10, 1, 10, 0, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
	(537, 27, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, 15, 1, 15, 1, 0, 0, 1, 0, NULL, 'created', 0, 0, 0, NULL),
-- multiple reference CI A
-- `id_adm_ci_type_attr(1)`, `id_adm_ci_type(2)`, `name(3)`, `description`(4), `input_type`(5), `property_name`(6), `property_type`(7), `length`(8), `reference_id`(9), `reference_name`(10), `reference_type`(11), `filter_rule`(12), `search_seq_no`(13), `display_type`(14), `display_seq_no`(15), `edit_is_null`(16), `edit_is_only`, `edit_is_hiden`, `edit_is_editable`, `is_defunct`, `special_logic`, `status`, `is_system`, `is_access_controlled`, `is_auto`, `auto_fill_rule`
	(800, 50, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 0, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(801, 50, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(802, 50, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(803, 50, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(804, 50, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(805, 50, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(806, 50, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(807, 50, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'notCreated', 1, 0, 1, ''),
	(808, 50, '状态', '状态', 'select', 'state', 'int', 15, 9, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(809, 50, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(810, 50, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'notCreated', 1, 0, 0, NULL),
	(811, 50, 'mul_select', 'mul_select', 'multiSelect', 'mul_select', 'int', 15, 13, NULL, NULL, NULL, NULL, 1, 13, 1, 0, 0, 1, 0, NULL, 'notCreated', 0, 0, 0, NULL),
	(812, 50, 'mul_reference', 'mul_reference', 'multiRef', 'mul_reference', 'varchar', 15, 51, NULL, NULL, NULL, NULL, 1, 14, 1, 0, 0, 1, 0, NULL, 'notCreated', 0, 0, 0, NULL),
-- multiple reference CI B
	(820, 51, '全局唯一ID', '全局唯一ID', 'text', 'guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 1, 0, 1, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(821, 51, '前全局唯一ID', '前一版本数据的guid', 'text', 'p_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 2, 1, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(822, 51, '根全局唯一ID', '原始数据guid', 'text', 'r_guid', 'varchar', 15, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(823, 51, '更新用户', '更新用户', 'text', 'updated_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 4, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(824, 51, '更新日期', '更新日期', 'date', 'updated_date', 'datetime', 1, NULL, NULL, NULL, NULL, NULL, 0, 5, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(825, 51, '创建用户', '创建用户', 'text', 'created_by', 'varchar', 50, NULL, NULL, NULL, NULL, NULL, 0, 6, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(826, 51, '创建日期', '创建日期', 'date', 'created_date', 'datetime', 1, NULL, NULL, NULL, NULL, 1, 0, 7, 0, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(827, 51, '唯一名称', '唯一名称', 'text', 'key_name', 'varchar', 200, NULL, NULL, NULL, NULL, 2, 1, 8, 0, 1, 0, 0, 0, NULL, 'notCreated', 1, 0, 1, ''),
	(828, 51, '状态', '状态', 'select', 'state', 'int', 15, 41, NULL, NULL, NULL, 3, 1, 9, 0, 0, 0, 1, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(829, 51, '确认日期', '确认日期', 'text', 'fixed_date', 'varchar', 19, NULL, NULL, NULL, NULL, 4, 1, 10, 1, 0, 1, 0, 0, NULL, 'notCreated', 1, 0, 1, NULL),
	(830, 51, '描述说明', '描述说明', 'textArea', 'description', 'varchar', 1000, NULL, NULL, NULL, NULL, NULL, 1, 12, 1, 0, 0, 1, 0, NULL, 'notCreated', 1, 0, 0, NULL);


CREATE TABLE IF NOT EXISTS `subsystem` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `business_group` int(15) DEFAULT NULL COMMENT '业务群组',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `adm_ci_type_attr_group` (
  `id_adm_ci_type_attr_group` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_ci_type_attr_group',
  `id_adm_ci_type_attr` int(11) DEFAULT NULL COMMENT 'id_adm_ci_type_attr',
  `id_adm_attr_group` int(11) DEFAULT NULL COMMENT 'id_adm_attr_group',
  PRIMARY KEY (`id_adm_ci_type_attr_group`),
  KEY `fk_adm_ci_type_attr_group_adm_attr_group_1` (`id_adm_attr_group`),
  KEY `fk_adm_ci_type_attr_group_adm_ci_type_attr_1` (`id_adm_ci_type_attr`),
  CONSTRAINT `fk_adm_ci_type_attr_group_adm_attr_group_1` FOREIGN KEY (`id_adm_attr_group`) REFERENCES `adm_attr_group` (`id_adm_attr_group`),
  CONSTRAINT `fk_adm_ci_type_attr_group_adm_ci_type_attr_1` FOREIGN KEY (`id_adm_ci_type_attr`) REFERENCES `adm_ci_type_attr` (`id_adm_ci_type_attr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `adm_files` (
  `id_adm_file` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(32) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `content` blob,
  PRIMARY KEY (`id_adm_file`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `adm_integrate_template` (
  `id_adm_integrate_template` int(11) NOT NULL AUTO_INCREMENT,
  `ci_type_id` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `des` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id_adm_integrate_template`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO `adm_integrate_template` (`id_adm_integrate_template`, `ci_type_id`, `name`, `des`) VALUES
	(1, 17, 'aaaaa-4-28-45', 'aaaaa-4-28-45'),
	(2, 17, 'aaaaa-4-28-46', 'aaaaa-4-28-46'),
	(3, 20, 'aaaaa-4-32-53', 'aaaaa-4-32-53'),
	(4, 20, 'aaaaa-4-32-54', 'aaaaa-4-32-54'),
	(5, 17, 'aaaaa-5-39-67', 'aaaaa-5-39-67'),
	(6, 17, 'aaaaa-5-39-68', 'aaaaa-5-39-68'),
	(7, 20, 'aaaaa-5-43-75', 'aaaaa-5-43-75'),
	(8, 20, 'aaaaa-5-43-76', 'aaaaa-5-43-76'),
	(9, 12, 'aaaaa-5-44-77', 'aaaaa-5-44-77'),
	(10, 12, 'aaaaa-5-44-78', 'aaaaa-5-44-78'),
	(11, 15, 'aaaaa-3-20-34', 'aaaaa-3-20-34'),
	(12, 15, 'aaaaa-3-23-37', 'aaaaa-3-23-37'),
	(13, 1, 'system', 'system');

CREATE TABLE IF NOT EXISTS `adm_integrate_template_alias` (
  `id_alias` int(11) NOT NULL AUTO_INCREMENT,
  `id_adm_ci_type` int(11) DEFAULT NULL,
  `id_adm_integrate_template` int(11) DEFAULT NULL,
  `alias` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id_alias`),
  KEY `fk_adm_integrate_template_alias_template_1` (`id_adm_integrate_template`),
  KEY `fk_adm_integrate_template_alias_adm_ci_type_1` (`id_adm_ci_type`),
  CONSTRAINT `fk_adm_integrate_template_alias_adm_ci_type_1` FOREIGN KEY (`id_adm_ci_type`) REFERENCES `adm_ci_type` (`id_adm_ci_type`),
  CONSTRAINT `fk_adm_integrate_template_alias_adm_integrate_template_1` FOREIGN KEY (`id_adm_integrate_template`) REFERENCES `adm_integrate_template` (`id_adm_integrate_template`)
) ENGINE=InnoDB AUTO_INCREMENT=199 DEFAULT CHARSET=utf8;

INSERT INTO `adm_integrate_template_alias` (`id_alias`, `id_adm_ci_type`, `id_adm_integrate_template`, `alias`) VALUES
	(1, 17, 1, 'zone'),
	(2, 16, 1, 'zone-idc'),
	(3, 21, 1, 'zone-networkSegment'),
	(4, 17, 2, 'zone'),
	(5, 16, 2, 'zone-idc'),
	(6, 20, 3, 'resourceSet'),
	(7, 21, 3, 'resourceSet-networkSegment'),
	(8, 19, 3, 'resourceSet-dcn'),
	(9, 17, 3, 'resourceSet-dcn-dcn-zone'),
	(10, 16, 3, 'resourceSet-dcn-dcn-zone-zone-idc'),
	(11, 20, 4, 'resourceSet'),
	(12, 19, 4, 'resourceSet-dcn'),
	(13, 17, 4, 'resourceSet-dcn-dcn-zone'),
	(14, 16, 4, 'resourceSet-dcn-dcn-zone-zone-idc'),
	(50, 15, 11, 'runningInstance'),
	(51, 12, 11, 'runningInstance-host'),
	(52, 14, 11, 'runningInstance-host-host-ipAddr'),
	(53, 8, 11, 'runningInstance-unit'),
	(54, 11, 11, 'runningInstance-unit-unit-package'),
	(55, 15, 12, 'runningInstance'),
	(56, 12, 12, 'runningInstance-host'),
	(57, 14, 12, 'runningInstance-host-host-ipAddr'),
	(58, 8, 12, 'runningInstance-unit'),
	(59, 11, 12, 'runningInstance-unit-unit-package'),
	(124, 1, 13, '系统设计'),
	(125, 2, 13, '2-1-子系统设计-系统设计'),
	(126, 3, 13, '3-1-单元设计-子系统设计'),
	(127, 4, 13, '4-1-服务设计-单元设计'),
	(128, 5, 13, '4-2-调用设计-单元设计'),
	(158, 20, 7, 'resourceSet'),
	(159, 21, 7, 'resourceSet-networkSegment'),
	(160, 19, 7, 'resourceSet-dcn'),
	(161, 17, 7, 'resourceSet-dcn-dcn-zone'),
	(162, 16, 7, 'resourceSet-dcn-dcn-zone-zone-idc'),
	(163, 20, 8, 'resourceSet'),
	(164, 19, 8, 'resourceSet-dcn'),
	(165, 17, 8, 'resourceSet-dcn-dcn-zone'),
	(166, 16, 8, 'resourceSet-dcn-dcn-zone-zone-idc'),
	(178, 12, 9, 'host'),
	(179, 20, 9, 'host-resourceSet'),
	(180, 19, 9, 'host-resourceSet-resourceSet-dcn'),
	(181, 17, 9, 'host-resourceSet-resourceSet-dcn-dcn-zone'),
	(182, 16, 9, 'host-resourceSet-resourceSet-dcn-dcn-zone-zone-idc'),
	(183, 14, 9, 'host-ipAddr'),
	(184, 12, 10, 'host'),
	(185, 20, 10, 'host-resourceSet'),
	(186, 19, 10, 'host-resourceSet-resourceSet-dcn'),
	(187, 17, 10, 'host-resourceSet-resourceSet-dcn-dcn-zone'),
	(188, 16, 10, 'host-resourceSet-resourceSet-dcn-dcn-zone-zone-idc'),
	(194, 17, 5, 'zone'),
	(195, 16, 5, 'zone-idc'),
	(196, 21, 5, 'zone-networkSegment'),
	(197, 17, 6, 'zone'),
	(198, 16, 6, 'zone-idc');

CREATE TABLE IF NOT EXISTS `adm_integrate_template_alias_attr` (
  `id_attr` int(11) NOT NULL AUTO_INCREMENT,
  `id_alias` int(11) DEFAULT NULL,
  `id_ci_type_attr` int(11) DEFAULT NULL,
  `is_condition` varchar(2) DEFAULT NULL COMMENT '是否是查询条件',
  `is_displayed` varchar(2) DEFAULT NULL COMMENT '是否展示',
  `mapping_name` varchar(200) DEFAULT NULL COMMENT '属性英文别名',
  `filter` varchar(200) DEFAULT NULL COMMENT '过滤条件',
  `key_name` varchar(500) DEFAULT NULL COMMENT '唯一值',
  `seq_no` int(11) DEFAULT NULL COMMENT '展示排序序号（越小优先级越高）',
  `cn_alias` varchar(64) DEFAULT NULL COMMENT '属性中文别名',
  `sys_attr` varchar(64) DEFAULT NULL COMMENT '系统属性（guid,created_user,created_date,updated_user,updated_date）',
  PRIMARY KEY (`id_attr`),
  KEY `fk_adm_integrate_template_alias_attr_1` (`id_alias`),
  KEY `fk_adm_integrate_template_alias_attr_2` (`id_ci_type_attr`),
  CONSTRAINT `fk_adm_integrate_template_alias_attr_1` FOREIGN KEY (`id_alias`) REFERENCES `adm_integrate_template_alias` (`id_alias`),
  CONSTRAINT `fk_adm_integrate_template_alias_attr_2` FOREIGN KEY (`id_ci_type_attr`) REFERENCES `adm_ci_type_attr` (`id_adm_ci_type_attr`)
) ENGINE=InnoDB AUTO_INCREMENT=225 DEFAULT CHARSET=utf8;

INSERT INTO `adm_integrate_template_alias_attr` (`id_attr`, `id_alias`, `id_ci_type_attr`, `is_condition`, `is_displayed`, `mapping_name`, `filter`, `key_name`, `seq_no`, `cn_alias`, `sys_attr`) VALUES
	(1, 1, 293, '1', '1', 'zone$guid', NULL, 'zone$guid', 1, NULL, NULL),
	(2, 1, 300, '1', '1', 'zone$key_name', NULL, 'zone$key_name', 1, NULL, NULL),
	(3, 2, 292, '1', '1', 'zone-idc-idc$parameter', NULL, 'zone-idc-idc$parameter', 1, NULL, NULL),
	(4, 3, 375, '1', '1', 'zone-networkSegment-networkSegment$code', NULL, 'zone-networkSegment-networkSegment$code', 1, NULL, NULL),
	(5, 4, 293, '1', '1', 'zone$guid', NULL, 'zone$guid', 1, NULL, NULL),
	(6, 4, 303, '1', '1', 'zone$code', NULL, 'zone$code', 1, NULL, NULL),
	(7, 5, 292, '1', '1', 'zone-idc-idc$parameter', NULL, 'zone-idc-idc$parameter', 1, NULL, NULL),
	(8, 6, 354, '1', '1', 'resourceSet$key_name', NULL, 'resourceSet$key_name', 1, NULL, NULL),
	(9, 6, 347, '1', '1', 'resourceSet$guid', NULL, 'resourceSet$guid', 1, NULL, NULL),
	(10, 6, 349, '1', '1', 'resourceSet$r_guid', NULL, 'resourceSet$r_guid', 1, NULL, NULL),
	(11, 7, 375, '1', '1', 'resourceSet-networkSegment-networkSegment$code', NULL, 'resourceSet-networkSegment-networkSegment$code', 1, NULL, NULL),
	(12, 9, 312, '1', '1', 'resourceSet-dcn-dcn-zone-zone$asset_code', NULL, 'resourceSet-dcn-dcn-zone-zone$asset_code', 1, NULL, NULL),
	(13, 10, 292, '1', '1', 'resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', NULL, 'resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', 1, NULL, NULL),
	(14, 11, 347, '1', '1', 'resourceSet$guid', NULL, 'resourceSet$guid', 1, NULL, NULL),
	(15, 11, 357, '1', '1', 'resourceSet$code', NULL, 'resourceSet$code', 1, NULL, NULL),
	(16, 14, 292, '1', '1', 'resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', NULL, 'resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', 1, NULL, NULL),
	(54, 50, 252, '1', '1', 'runningInstance$guid', NULL, 'runningInstance$guid', 1, NULL, NULL),
	(55, 52, 244, '1', '1', 'runningInstance-host-host-ipAddr-intranetIp$code', NULL, 'runningInstance-host-host-ipAddr-intranetIp$code', 1, NULL, NULL),
	(56, 54, 183, '1', '1', 'runningInstance-unit-unit-package-package$path', NULL, 'runningInstance-unit-unit-package-package$path', 1, NULL, NULL),
	(57, 54, 459, '1', '1', 'runningInstance-unit-unit-package-package$deploy_path', NULL, 'runningInstance-unit-unit-package-package$deploy_path', 1, NULL, NULL),
	(58, 57, 244, '1', '1', 'runningInstance-host-host-ipAddr-intranetIp$code', NULL, 'runningInstance-host-host-ipAddr-intranetIp$code', 1, NULL, NULL),
	(59, 59, 185, '1', '1', 'runningInstance-unit-unit-package-package$deploy_user', NULL, 'runningInstance-unit-unit-package-package$deploy_user', 1, NULL, NULL),
	(60, 59, 179, '1', '1', 'runningInstance-unit-unit-package-package$name', NULL, 'runningInstance-unit-unit-package-package$name', 1, NULL, NULL),
	(61, 59, 184, '1', '1', 'runningInstance-unit-unit-package-package$deploy_file', NULL, 'runningInstance-unit-unit-package-package$deploy_file', 1, NULL, NULL),
	(135, 124, 8, '1', '1', '唯一名称', NULL, 'systemDesign$keyName', 1, NULL, NULL),
	(136, 125, 22, '1', '1', '唯一名称', NULL, 'systemDesign-subsysDesign$keyName', 1, NULL, NULL),
	(137, 126, 38, '1', '1', '唯一名称', NULL, 'systemDesign-subsysDesign-unitDesign$keyName', 1, NULL, NULL),
	(138, 126, 46, '1', '1', '类型', NULL, 'systemDesign-subsysDesign-unitDesign$type', 1, NULL, NULL),
	(175, 158, 354, '1', '1', 'resourceSet$key_name', NULL, 'resourceSet$key_name', 1, NULL, NULL),
	(176, 158, 347, '1', '1', 'resourceSet$guid', NULL, 'resourceSet$guid', 1, NULL, NULL),
	(177, 159, 375, '1', '1', 'resourceSet-networkSegment-networkSegment$code', NULL, 'resourceSet-networkSegment-networkSegment$code', 1, NULL, NULL),
	(178, 161, 312, '1', '1', 'resourceSet-dcn-dcn-zone-zone$asset_code', NULL, 'resourceSet-dcn-dcn-zone-zone$asset_code', 1, NULL, NULL),
	(179, 162, 292, '1', '1', 'resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', NULL, 'resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', 1, NULL, NULL),
	(180, 163, 347, '1', '1', 'resourceSet$guid', NULL, 'resourceSet$guid', 1, NULL, NULL),
	(181, 163, 458, '1', '1', 'resourceSet$asset_code', NULL, 'resourceSet$asset_code', 1, NULL, NULL),
	(182, 166, 292, '1', '1', 'resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', NULL, 'resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', 1, NULL, NULL),
	(197, 178, 211, '1', '1', 'host$charge_type', NULL, 'host$charge_type', 1, NULL, NULL),
	(198, 178, 190, '1', '1', 'host$guid', NULL, 'host$guid', 1, NULL, NULL),
	(199, 178, 205, '1', '1', 'host$os', NULL, 'host$os', 1, NULL, NULL),
	(200, 178, 456, '1', '1', 'host$charge_period', NULL, 'host$charge_period', 1, NULL, NULL),
	(201, 178, 203, '1', '1', 'host$name', NULL, 'host$name', 1, NULL, NULL),
	(202, 178, 210, '1', '1', 'host$disk', NULL, 'host$disk', 1, NULL, NULL),
	(203, 178, 204, '1', '1', 'host$type', NULL, 'host$type', 1, NULL, NULL),
	(204, 179, 458, '1', '1', 'host-resourceSet-resourceSet$asset_code', NULL, 'host-resourceSet-resourceSet$asset_code', 1, NULL, NULL),
	(205, 181, 312, '1', '1', 'host-resourceSet-resourceSet-dcn-dcn-zone-zone$asset_code', NULL, 'host-resourceSet-resourceSet-dcn-dcn-zone-zone$asset_code', 1, NULL, NULL),
	(206, 182, 292, '1', '1', 'host-resourceSet-resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', NULL, 'host-resourceSet-resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', 1, NULL, NULL),
	(207, 183, 244, '1', '1', 'host-ipAddr-intranetIp$code', NULL, 'host-ipAddr-intranetIp$code', 1, NULL, NULL),
	(208, 184, 190, '1', '1', 'host$guid', NULL, 'host$guid', 1, NULL, NULL),
	(209, 184, 212, '1', '1', 'host$asset_code', NULL, 'host$asset_code', 1, NULL, NULL),
	(210, 188, 292, '1', '1', 'host-resourceSet-resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', NULL, 'host-resourceSet-resourceSet-dcn-dcn-zone-zone-idc-idc$parameter', 1, NULL, NULL),
	(218, 194, 293, '1', '1', 'zone$guid', NULL, 'zone$guid', 1, NULL, NULL),
	(219, 194, 300, '1', '1', 'zone$key_name', NULL, 'zone$key_name', 1, NULL, NULL),
	(220, 195, 292, '1', '1', 'zone-idc-idc$parameter', NULL, 'zone-idc-idc$parameter', 1, NULL, NULL),
	(221, 196, 375, '1', '1', 'zone-networkSegment-networkSegment$code', NULL, 'zone-networkSegment-networkSegment$code', 1, NULL, NULL),
	(222, 197, 293, '1', '1', 'zone$guid', NULL, 'zone$guid', 1, NULL, NULL),
	(223, 197, 312, '1', '1', 'zone$asset_code', NULL, 'zone$asset_code', 1, NULL, NULL),
	(224, 198, 292, '1', '1', 'zone-idc-idc$parameter', NULL, 'zone-idc-idc$parameter', 1, NULL, NULL);

CREATE TABLE IF NOT EXISTS `adm_integrate_template_relation` (
  `id_relation` int(11) NOT NULL AUTO_INCREMENT,
  `child_alias_id` int(11) DEFAULT NULL,
  `child_ref_attr_id` int(11) DEFAULT NULL,
  `parent_alias_id` int(11) DEFAULT NULL,
  `is_refered_from_parent` int(1) NOT NULL,
  PRIMARY KEY (`id_relation`),
  KEY `fk_adm_integrate_template_relation_alias_2` (`parent_alias_id`),
  KEY `fk_adm_integrate_template_relation_alias_1` (`child_alias_id`),
  KEY `fk_adm_integrate_template_relation_attr_1` (`child_ref_attr_id`),
  CONSTRAINT `fk_adm_integrate_template_relation_alias_1` FOREIGN KEY (`child_alias_id`) REFERENCES `adm_integrate_template_alias` (`id_alias`),
  CONSTRAINT `fk_adm_integrate_template_relation_alias_2` FOREIGN KEY (`parent_alias_id`) REFERENCES `adm_integrate_template_alias` (`id_alias`),
  CONSTRAINT `fk_adm_integrate_template_relation_attr_1` FOREIGN KEY (`child_ref_attr_id`) REFERENCES `adm_ci_type_attr` (`id_adm_ci_type_attr`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8;

INSERT INTO `adm_integrate_template_relation` (`id_relation`, `child_alias_id`, `child_ref_attr_id`, `parent_alias_id`, `is_refered_from_parent`) VALUES
	(1, 2, 305, 1, 1),
	(2, 3, 310, 1, 1),
	(3, 5, 305, 4, 1),
	(4, 7, 363, 6, 1),
	(5, 8, 359, 6, 1),
	(6, 9, 344, 8, 1),
	(7, 10, 305, 9, 1),
	(8, 12, 359, 11, 1),
	(9, 13, 344, 12, 1),
	(10, 14, 305, 13, 1),
	(38, 51, 265, 50, 1),
	(39, 53, 264, 50, 1),
	(40, 52, 206, 51, 1),
	(41, 54, 127, 53, 1),
	(42, 56, 265, 55, 1),
	(43, 58, 264, 55, 1),
	(44, 57, 206, 56, 1),
	(45, 59, 127, 58, 1),
	(94, 125, 27, 124, 0),
	(95, 126, 43, 125, 0),
	(96, 127, 61, 126, 0),
	(97, 128, 78, 126, 0),
	(117, 159, 363, 158, 1),
	(118, 160, 359, 158, 1),
	(119, 161, 344, 160, 1),
	(120, 162, 305, 161, 1),
	(121, 164, 359, 163, 1),
	(122, 165, 344, 164, 1),
	(123, 166, 305, 165, 1),
	(133, 179, 202, 178, 1),
	(134, 183, 206, 178, 1),
	(135, 180, 359, 179, 1),
	(136, 181, 344, 180, 1),
	(137, 182, 305, 181, 1),
	(138, 185, 202, 184, 1),
	(139, 186, 359, 185, 1),
	(140, 187, 344, 186, 1),
	(141, 188, 305, 187, 1),
	(145, 195, 305, 194, 1),
	(146, 196, 310, 194, 1),
	(147, 198, 305, 197, 1);

CREATE TABLE IF NOT EXISTS `adm_log` (
  `id_log` int(11) NOT NULL AUTO_INCREMENT,
  `log_cat` varchar(50) DEFAULT NULL,
  `id_adm_user` varchar(50) DEFAULT NULL,
  `operation` varchar(50) DEFAULT NULL,
  `log_content` longtext,
  `created_at` varchar(19) DEFAULT NULL,
  `guid` varchar(20) DEFAULT NULL ,
  `updated_by` varchar(64) DEFAULT NULL,
  `updated_date` varchar(64) DEFAULT NULL,
  `created_by` varchar(64) DEFAULT NULL,
  `created_date` varchar(64) DEFAULT NULL,
  `ci_type_instance_guid` varchar(64) DEFAULT NULL,
  `remark` varchar(1000) DEFAULT NULL COMMENT '标注',
  `ci_type_name` varchar(100) DEFAULT NULL COMMENT 'ci类型名称',
  `ci_name` varchar(100) DEFAULT NULL COMMENT '操作ci名称',
  `status` int(2) DEFAULT '0',
  `ci_type_id` int(10) DEFAULT NULL COMMENT 'ci类型id',
  `client_host` varchar(20) DEFAULT NULL,
  `request_url` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id_log`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_ci_guid` (`ci_type_instance_guid`),
  KEY `NewIndex1` (`log_cat`),
  KEY `NewIndex2` (`ci_type_name`),
  KEY `NewIndex3` (`ci_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `adm_menu` (
  `id_adm_menu` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL COMMENT '菜单名称',
  `other_name` varchar(255) DEFAULT NULL COMMENT '菜单别名',
  `url` varchar(255) DEFAULT NULL COMMENT 'url',
  `seq_no` int(11) DEFAULT NULL COMMENT '排序序号',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `parent_id_adm_menu` int(11) DEFAULT NULL COMMENT '父菜单ID',
  `class_path` varchar(100) DEFAULT NULL COMMENT '目录对应的图标class',
  `is_active` int(1) DEFAULT '0' COMMENT '0正常，1禁用',
  PRIMARY KEY (`id_adm_menu`),
  KEY `fk_adm_menu_adm_menu_1` (`parent_id_adm_menu`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO adm_menu (id_adm_menu, name,other_name,url,seq_no,remark,parent_id_adm_menu,class_path,is_active) VALUES
(1, 'menuA','','menuA/index.html',1,NULL,NULL,NULL,0)
,(2, 'menuB','','menuB/index.html',2,NULL,NULL,NULL,0)
,(3, 'menuC','','menuC/index.html',3,NULL,NULL,NULL,0)
,(4, 'menuD','','menuD/index.html',4,NULL,NULL,NULL,0)
;

CREATE TABLE IF NOT EXISTS `adm_tenement` (
  `id_adm_tenement` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) DEFAULT NULL COMMENT '名称',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `en_short_name` varchar(32) DEFAULT NULL COMMENT '英文简称',
  PRIMARY KEY (`id_adm_tenement`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `adm_user` (
  `id_adm_user` varchar(64) NOT NULL COMMENT 'id_adm_user',
  `name` varchar(64) DEFAULT NULL COMMENT '名称',
  `code` varchar(100) DEFAULT NULL COMMENT '编码（接口类用户使用）',
  `encrypted_password` varchar(100) DEFAULT NULL COMMENT '加密的密码',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `id_adm_tenement` int(11) DEFAULT NULL COMMENT 'id_adm_tenement',
  `action_flag` tinyint(1) DEFAULT '0' COMMENT '用户操作Flag',
  `is_system` int(1) DEFAULT '0' COMMENT '是否系统数据',
  PRIMARY KEY (`id_adm_user`),
  KEY `fk_adm_user_adm_tenement_1` (`id_adm_tenement`),
  CONSTRAINT `fk_adm_user_adm_tenement_1` FOREIGN KEY (`id_adm_tenement`) REFERENCES `adm_tenement` (`id_adm_tenement`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `adm_user` (`id_adm_user`, `name`, `code`, `description`, `id_adm_tenement`, `action_flag`,`is_system`) VALUES
	('1', 'umadmin', 'umadmin', 'umadmin', NULL, 0, 1);

CREATE TABLE IF NOT EXISTS `adm_role` (
  `id_adm_role` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_role',
  `role_name` varchar(32) DEFAULT NULL COMMENT '角色名称',
  `description` varchar(255) DEFAULT NULL COMMENT '描述',
  `id_adm_tenement` int(11) DEFAULT NULL COMMENT 'id_adm_tenement',
  `parent_id_adm_role` int(11) DEFAULT NULL COMMENT '父角色ID',
  `role_type` varchar(32) DEFAULT NULL COMMENT '角色类型（平台管理、租户管理、CI管理、数据使用）',
  `is_system` int(1) DEFAULT '0' COMMENT '是否系统数据',
  PRIMARY KEY (`id_adm_role`),
  KEY `fk_adm_role_adm_tenement_1` (`id_adm_tenement`),
  KEY `fk_adm_role_adm_role_1` (`parent_id_adm_role`),
  CONSTRAINT `fk_adm_role_adm_role_1` FOREIGN KEY (`parent_id_adm_role`) REFERENCES `adm_role` (`id_adm_role`),
  CONSTRAINT `fk_adm_role_adm_tenement_1` FOREIGN KEY (`id_adm_tenement`) REFERENCES `adm_tenement` (`id_adm_tenement`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO `adm_role` (`id_adm_role`, `role_name`, `description`, `id_adm_tenement`, `parent_id_adm_role`, `role_type`, `is_system`) VALUES
	(1, 'SUPER_ADMIN', '超级管理员', NULL, NULL, 'ADMIN', 1),
	(2, 'CMDB_ADMIN', 'CMDB管理员', NULL, NULL, 'ADMIN', 0),
	(3, 'PLUGIN_ADMIN', '插件管理员', NULL, NULL, 'ADMIN', 0),
	(4, 'IDC_ARCHITECT', '基础架构规划-IDC', NULL, NULL, 'ADMIN', 0),
	(5, 'NETWORK_ARCHITECT', '基础架构规划-网络', NULL, NULL, 'ADMIN', 0),
	(6, 'APP_ARCHITECT', '应用架构师', NULL, NULL, 'ADMIN', 0),
	(7, 'OPS-PROD', '生产环境运维', NULL, NULL, 'ADMIN', 0),
	(8, 'OPS-TEST', '测试环境运维', NULL, NULL, 'ADMIN', 0),
	(9, 'DEVELOPER', '开发人员', NULL, NULL, 'ADMIN', 0),
	(10, 'REGULAR', '普通用户', NULL, NULL, 'REGULAR', 0),
	(11, 'READONLY', '只读用户', NULL, NULL, 'READONLY', 0);

CREATE TABLE IF NOT EXISTS `adm_role_ci_type` (
  `id_adm_role_ci_type` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_role_ci_type',
  `id_adm_role` int(11) NOT NULL COMMENT 'id_adm_role',
  `id_adm_ci_type` int(11) NOT NULL COMMENT 'id_adm_ci_type',
  `ci_type_name` varchar(100) DEFAULT NULL,
  `creation_permission` varchar(1) NOT NULL DEFAULT 'N',
  `removal_permission` varchar(1) NOT NULL DEFAULT 'N',
  `modification_permission` varchar(1) NOT NULL DEFAULT 'N',
  `enquiry_permission` varchar(1) NOT NULL DEFAULT 'N',
  `execution_permission` varchar(1) NOT NULL DEFAULT 'N',
  `grant_permission` varchar(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (`id_adm_role_ci_type`),
  UNIQUE KEY `role_citype_unique` (`id_adm_role`,`id_adm_ci_type`),
  KEY `fk_adm_role_ci_type_adm_role_1` (`id_adm_role`),
  KEY `FK_adm_role_ci_type_adm_ci_type` (`id_adm_ci_type`),
  CONSTRAINT `fk_adm_role_ci_type_adm_citype_1` FOREIGN KEY (`id_adm_ci_type`) REFERENCES `adm_ci_type` (`id_adm_ci_type`) ON DELETE CASCADE,
  CONSTRAINT `fk_adm_role_ci_type_adm_role_1` FOREIGN KEY (`id_adm_role`) REFERENCES `adm_role` (`id_adm_role`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=131 DEFAULT CHARSET=utf8;

INSERT INTO `adm_role_ci_type` (`id_adm_role_ci_type`, `id_adm_role`, `id_adm_ci_type`, `ci_type_name`, `creation_permission`, `removal_permission`, `modification_permission`, `enquiry_permission`, `execution_permission`, `grant_permission`) VALUES
	(1, 1, 1, '系统设计', 'Y', 'Y', 'Y', 'Y', 'N', 'N'),
	(2, 1, 7, '子系统', 'N', 'N', 'N', 'N', 'N', 'N'),
	(3, 1, 12, '主机', 'N', 'N', 'N', 'N', 'N', 'N'),
	(4, 1, 16, '机房', 'N', 'N', 'N', 'N', 'N', 'N'),
	(5, 1, 22, '机房设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(6, 1, 2, '子系统设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(7, 1, 8, '单元', 'N', 'N', 'N', 'N', 'N', 'N'),
	(8, 1, 13, '块存储', 'N', 'N', 'N', 'N', 'N', 'N'),
	(9, 1, 17, '安全区域', 'N', 'N', 'N', 'N', 'N', 'N'),
	(10, 1, 23, '安全区域设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(11, 1, 3, '单元设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(12, 1, 9, '服务', 'N', 'N', 'N', 'N', 'N', 'N'),
	(13, 1, 14, 'IP地址', 'N', 'N', 'N', 'N', 'N', 'N'),
	(14, 1, 18, '安全区域连接', 'N', 'N', 'N', 'N', 'N', 'N'),
	(15, 1, 24, '安全区域连接设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(16, 1, 4, '服务设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(17, 1, 10, '调用', 'N', 'N', 'N', 'N', 'N', 'N'),
	(18, 1, 15, '运行实例', 'N', 'N', 'N', 'N', 'N', 'N'),
	(19, 1, 19, '数据中心节点', 'N', 'N', 'N', 'N', 'N', 'N'),
	(20, 1, 25, '数据中心节点设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(21, 1, 5, '调用设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(22, 1, 11, '应用包', 'N', 'N', 'N', 'N', 'N', 'N'),
	(23, 1, 20, '资源集', 'N', 'N', 'N', 'N', 'N', 'N'),
	(24, 1, 26, '资源集设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(25, 1, 6, '调用时序设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(26, 1, 21, '网段', 'N', 'N', 'N', 'N', 'N', 'N'),
	(27, 4, 1, '系统设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(28, 4, 7, '子系统', 'N', 'N', 'N', 'N', 'N', 'N'),
	(29, 4, 12, '主机', 'N', 'N', 'N', 'N', 'N', 'N'),
	(30, 4, 16, '机房', 'N', 'N', 'N', 'N', 'N', 'N'),
	(31, 4, 22, '机房设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(32, 4, 2, '子系统设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(33, 4, 8, '单元', 'N', 'N', 'N', 'N', 'N', 'N'),
	(34, 4, 13, '块存储', 'N', 'N', 'N', 'N', 'N', 'N'),
	(35, 4, 17, '安全区域', 'N', 'N', 'N', 'N', 'N', 'N'),
	(36, 4, 23, '安全区域设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(37, 4, 3, '单元设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(38, 4, 9, '服务', 'N', 'N', 'N', 'N', 'N', 'N'),
	(39, 4, 14, 'IP地址', 'N', 'N', 'N', 'N', 'N', 'N'),
	(40, 4, 18, '安全区域连接', 'N', 'N', 'N', 'N', 'N', 'N'),
	(41, 4, 24, '安全区域连接设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(42, 4, 4, '服务设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(43, 4, 10, '调用', 'N', 'N', 'N', 'N', 'N', 'N'),
	(44, 4, 15, '运行实例', 'N', 'N', 'N', 'N', 'N', 'N'),
	(45, 4, 19, '数据中心节点', 'N', 'N', 'N', 'N', 'N', 'N'),
	(46, 4, 25, '数据中心节点设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(47, 4, 5, '调用设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(48, 4, 11, '应用包', 'N', 'N', 'N', 'N', 'N', 'N'),
	(49, 4, 20, '资源集', 'N', 'N', 'N', 'N', 'N', 'N'),
	(50, 4, 26, '资源集设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(51, 4, 6, '调用时序设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(52, 4, 21, '网段', 'N', 'N', 'N', 'N', 'N', 'N'),
	(53, 5, 1, '系统设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(54, 5, 7, '子系统', 'N', 'N', 'N', 'N', 'N', 'N'),
	(55, 5, 12, '主机', 'N', 'N', 'N', 'N', 'N', 'N'),
	(56, 5, 16, '机房', 'N', 'N', 'N', 'N', 'N', 'N'),
	(57, 5, 22, '机房设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(58, 5, 2, '子系统设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(59, 5, 8, '单元', 'N', 'N', 'N', 'N', 'N', 'N'),
	(60, 5, 13, '块存储', 'Y', 'N', 'N', 'Y', 'N', 'N'),
	(61, 5, 17, '安全区域', 'N', 'N', 'N', 'N', 'N', 'N'),
	(62, 5, 23, '安全区域设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(63, 5, 3, '单元设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(64, 5, 9, '服务', 'N', 'N', 'N', 'N', 'N', 'N'),
	(65, 5, 14, 'IP地址', 'N', 'N', 'N', 'N', 'N', 'N'),
	(66, 5, 18, '安全区域连接', 'N', 'N', 'N', 'N', 'N', 'N'),
	(67, 5, 24, '安全区域连接设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(68, 5, 4, '服务设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(69, 5, 10, '调用', 'N', 'N', 'N', 'N', 'N', 'N'),
	(70, 5, 15, '运行实例', 'N', 'N', 'N', 'N', 'N', 'N'),
	(71, 5, 19, '数据中心节点', 'N', 'N', 'N', 'N', 'N', 'N'),
	(72, 5, 25, '数据中心节点设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(73, 5, 5, '调用设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(74, 5, 11, '应用包', 'N', 'N', 'N', 'N', 'N', 'N'),
	(75, 5, 20, '资源集', 'N', 'N', 'N', 'N', 'N', 'N'),
	(76, 5, 26, '资源集设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(77, 5, 6, '调用时序设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(78, 5, 21, '网段', 'N', 'N', 'N', 'N', 'N', 'N'),
	(79, 2, 1, '系统设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(80, 2, 7, '子系统', 'N', 'N', 'N', 'N', 'N', 'N'),
	(81, 2, 12, '主机', 'N', 'N', 'N', 'N', 'N', 'N'),
	(82, 2, 16, '机房', 'N', 'N', 'N', 'N', 'N', 'N'),
	(83, 2, 22, '机房设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(84, 2, 2, '子系统设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(85, 2, 8, '单元', 'N', 'N', 'N', 'N', 'N', 'N'),
	(86, 2, 13, '块存储', 'N', 'N', 'N', 'N', 'N', 'N'),
	(87, 2, 17, '安全区域', 'N', 'N', 'N', 'N', 'N', 'N'),
	(88, 2, 23, '安全区域设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(89, 2, 3, '单元设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(90, 2, 9, '服务', 'N', 'N', 'N', 'N', 'N', 'N'),
	(91, 2, 14, 'IP地址', 'N', 'N', 'N', 'N', 'N', 'N'),
	(92, 2, 18, '安全区域连接', 'N', 'N', 'N', 'N', 'N', 'N'),
	(93, 2, 24, '安全区域连接设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(94, 2, 4, '服务设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(95, 2, 10, '调用', 'N', 'N', 'N', 'N', 'N', 'N'),
	(96, 2, 15, '运行实例', 'N', 'N', 'N', 'N', 'N', 'N'),
	(97, 2, 19, '数据中心节点', 'N', 'N', 'N', 'N', 'N', 'N'),
	(98, 2, 25, '数据中心节点设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(99, 2, 5, '调用设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(100, 2, 11, '应用包', 'N', 'N', 'N', 'N', 'N', 'N'),
	(101, 2, 20, '资源集', 'N', 'N', 'N', 'N', 'N', 'N'),
	(102, 2, 26, '资源集设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(103, 2, 6, '调用时序设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(104, 2, 21, '网段', 'N', 'N', 'N', 'N', 'N', 'N'),
	(105, 3, 1, '系统设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(106, 3, 7, '子系统', 'N', 'N', 'N', 'N', 'N', 'N'),
	(107, 3, 12, '主机', 'N', 'N', 'N', 'N', 'N', 'N'),
	(108, 3, 16, '机房', 'N', 'N', 'N', 'N', 'N', 'N'),
	(109, 3, 22, '机房设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(110, 3, 2, '子系统设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(111, 3, 8, '单元', 'N', 'N', 'N', 'N', 'N', 'N'),
	(112, 3, 13, '块存储', 'N', 'N', 'N', 'N', 'N', 'N'),
	(113, 3, 17, '安全区域', 'N', 'N', 'N', 'N', 'N', 'N'),
	(114, 3, 23, '安全区域设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(115, 3, 3, '单元设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(116, 3, 9, '服务', 'N', 'N', 'N', 'N', 'N', 'N'),
	(117, 3, 14, 'IP地址', 'N', 'N', 'N', 'N', 'N', 'N'),
	(118, 3, 18, '安全区域连接', 'N', 'N', 'N', 'N', 'N', 'N'),
	(119, 3, 24, '安全区域连接设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(120, 3, 4, '服务设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(121, 3, 10, '调用', 'N', 'N', 'N', 'N', 'N', 'N'),
	(122, 3, 15, '运行实例', 'N', 'N', 'N', 'N', 'N', 'N'),
	(123, 3, 19, '数据中心节点', 'N', 'N', 'N', 'N', 'N', 'N'),
	(124, 3, 25, '数据中心节点设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(125, 3, 5, '调用设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(126, 3, 11, '应用包', 'N', 'N', 'N', 'N', 'N', 'N'),
	(127, 3, 20, '资源集', 'N', 'N', 'N', 'N', 'N', 'N'),
	(128, 3, 26, '资源集设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(129, 3, 6, '调用时序设计', 'N', 'N', 'N', 'N', 'N', 'N'),
	(130, 3, 21, '网段', 'N', 'N', 'N', 'N', 'N', 'N');

CREATE TABLE IF NOT EXISTS `adm_role_user` (
  `id_adm_role_user` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_role_user',
  `id_adm_role` int(11) DEFAULT NULL COMMENT 'id_adm_role',
  `id_adm_user` varchar(64) DEFAULT NULL COMMENT 'id_adm_user',
  `is_system` int(1) DEFAULT '0' COMMENT '是否系统数据',
  PRIMARY KEY (`id_adm_role_user`),
  KEY `fk_adm_role_user_adm_role_1` (`id_adm_role`),
  KEY `fk_adm_role_user_adm_user_1` (`id_adm_user`),
  CONSTRAINT `fk_adm_role_user_adm_role_1` FOREIGN KEY (`id_adm_role`) REFERENCES `adm_role` (`id_adm_role`),
  CONSTRAINT `fk_adm_role_user_adm_user_1` FOREIGN KEY (`id_adm_user`) REFERENCES `adm_user` (`id_adm_user`)
) ENGINE=InnoDB AUTO_INCREMENT=349 DEFAULT CHARSET=utf8;

INSERT INTO `adm_role_user` (`id_adm_role_user`, `id_adm_role`, `id_adm_user`, `is_system`) VALUES
	(5, 2, '1', '1'),
	(348, 1, '1', '0');

CREATE TABLE `adm_role_menu` (
  `id_adm_role_menu` int(11) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_role_menu',
  `id_adm_role` int(11) DEFAULT NULL COMMENT 'id_adm_role',
  `id_adm_menu` int(11) DEFAULT NULL COMMENT 'id_adm_menu',
  `is_system` int(1) DEFAULT '0' COMMENT '是否系统数据',
  PRIMARY KEY (`id_adm_role_menu`),
  UNIQUE KEY `role_menu_unique` (`id_adm_role`,`id_adm_menu`),
  KEY `fk_adm_role_menu_adm_role_1` (`id_adm_role`),
  KEY `fk_adm_role_menu_adm_menu_1` (`id_adm_menu`),
  CONSTRAINT `fk_adm_role_menu_adm_role_1` FOREIGN KEY (`id_adm_role`) REFERENCES `adm_role` (`id_adm_role`) ON DELETE CASCADE,
  CONSTRAINT `fk_adm_role_menu_adm_menu_1` FOREIGN KEY (`id_adm_menu`) REFERENCES `adm_menu` (`id_adm_menu`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO adm_role_menu (id_adm_role_menu, id_adm_role, id_adm_menu,is_system) VALUES
(1,1,1,1)
,(2,1,2,0)
,(3,1,3,0)
,(4,2,1,0)
;

CREATE TABLE IF NOT EXISTS `adm_sequence` (
  `id_adm_sequence` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id_adm_sequence',
  `seq_name` varchar(64) NOT NULL COMMENT '序列名称',
  `current_val` int(11) DEFAULT NULL COMMENT '当前值',
  `increment_val` int(11) DEFAULT NULL COMMENT '步长',
  `length_limitation` int(11) DEFAULT NULL COMMENT '位数限制',
  `left_zero_padding` varchar(1) DEFAULT NULL COMMENT '是否补零，y为是，n为否',
  PRIMARY KEY (`id_adm_sequence`),
  UNIQUE KEY `seq_name_index` (`seq_name`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

INSERT INTO `adm_sequence` (`id_adm_sequence`, `seq_name`, `current_val`, `increment_val`, `length_limitation`, `left_zero_padding`) VALUES
	(1, 'IDC_design', 2, 1, 8, 'N'),
	(2, 'zone_design', 9, 1, 8, 'N'),
	(3, 'zone_link_design', 9, 1, 8, 'N'),
	(4, 'DCN_desgin', 8, 1, 8, 'N'),
	(5, 'resource_set_design', 18, 1, 8, 'N'),
	(6, 'IDC', 3, 1, 8, 'N'),
	(7, 'zone', 7, 1, 8, 'N'),
	(8, 'ip_addr', 14, 1, 8, 'N'),
	(9, 'network_segment', 21, 1, 8, 'N'),
	(10, 'zone_link', 8, 1, 8, 'N'),
	(11, 'DCN', 5, 1, 8, 'N'),
	(12, 'system_design', 8, 1, 8, 'N'),
	(13, 'subsys_design', 14, 1, 8, 'N'),
	(14, 'unit_design', 15, 1, 8, 'N'),
	(15, 'service_design', 9, 1, 8, 'N'),
	(16, 'invoke_design', 13, 1, 8, 'N'),
	(17, 'resource_set', 6, 1, 8, 'N'),
	(18, 'host', 4, 1, 8, 'N'),
	(19, 'subsys', 1, 1, 8, 'N'),
	(20, 'unit', 1, 1, 8, 'N'),
	(21, 'running_instance', 2, 1, 8, 'N'),
	(22, 'invoke_sequence_design', 1, 1, 8, 'N'),
	(23, 'package', 5, 1, 8, 'N'),
	(24, 'network_link', 1, 1, 8, 'N')
	;

CREATE TABLE IF NOT EXISTS `adm_state_transition` (
  `id_adm_state_transition` int(11) NOT NULL,
  `current_state` int(11) DEFAULT NULL,
  `current_state_is_confirmed` tinyint(4) DEFAULT NULL,
  `target_state` int(11) DEFAULT NULL,
  `target_state_is_confirmed` tinyint(4) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL,
  `action` int(11) DEFAULT NULL,
  `status` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id_adm_state_transition`),
  KEY `fk_adm_state_transition_current_state_idx` (`current_state`),
  KEY `fk_adm_state_transition_target_state_idx` (`target_state`),
  KEY `fk_adm_state_transition_operation_idx` (`operation`),
  KEY `fk_adm_state_transition_action_idx` (`action`),
  CONSTRAINT `fk_adm_state_transition_action` FOREIGN KEY (`action`) REFERENCES `adm_basekey_code` (`id_adm_basekey`),
  CONSTRAINT `fk_adm_state_transition_current_state` FOREIGN KEY (`current_state`) REFERENCES `adm_basekey_code` (`id_adm_basekey`),
  CONSTRAINT `fk_adm_state_transition_operation` FOREIGN KEY (`operation`) REFERENCES `adm_basekey_code` (`id_adm_basekey`),
  CONSTRAINT `fk_adm_state_transition_target_state` FOREIGN KEY (`target_state`) REFERENCES `adm_basekey_code` (`id_adm_basekey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `adm_state_transition` (`id_adm_state_transition`, `current_state`, `current_state_is_confirmed`, `target_state`, `target_state_is_confirmed`, `operation`, `action`, `status`) VALUES
	(1, 39, 0, NULL, NULL, 147, 151, 'active'),
	(2, NULL, NULL, 39, 0, 144, 149, 'active'),
	(3, 39, 0, 39, 0, 145, 153, 'active'),
	(4, 39, 0, 39, 1, 148, 154, 'active'),
	(5, 39, 1, 40, 0, 145, 150, 'active'),
	(6, 40, 0, 39, 1, 146, 152, 'active'),
	(7, 39, 1, 41, 0, 147, 150, 'active'),
	(8, 41, 0, 39, 1, 146, 152, 'active'),
	(9, 40, 0, 40, 0, 145, 153, 'active'),
	(10, 40, 0, 40, 1, 148, 154, 'active'),
	(11, 40, 1, 40, 0, 145, 150, 'active'),
	(12, 40, 0, 40, 1, 146, 152, 'active'),
	(13, 40, 1, 41, 0, 147, 150, 'active'),
	(14, 41, 0, 40, 1, 146, 152, 'active'),
	(15, 41, 0, 41, 1, 148, 154, 'active'),
	(16, 34, 0, NULL, NULL, 147, 151, 'active'),
	(17, NULL, NULL, 34, 0, 144, 149, 'active'),
	(18, 34, 0, 34, 0, 145, 153, 'active'),
	(19, 34, 0, 34, 1, 148, 154, 'active'),
	(20, 34, 1, 35, 0, 158, 150, 'active'),
	(21, 35, 0, 34, 1, 146, 152, 'active'),
	(22, 35, 0, 35, 1, 148, 154, 'active'),
	(23, 34, 1, 37, 0, 159, 150, 'active'),
	(24, 37, 0, 34, 1, 146, 152, 'active'),
	(25, 37, 0, 37, 1, 148, 154, 'active'),
	(26, 35, 1, 37, 0, 159, 150, 'active'),
	(27, 37, 0, 35, 1, 146, 152, 'active'),
	(28, 37, 1, 35, 0, 158, 150, 'active'),
	(29, 35, 0, 37, 1, 146, 152, 'active'),
	(30, 35, 1, 36, 0, 145, 150, 'active'),
	(31, 36, 0, 35, 1, 146, 152, 'active'),
	(32, 37, 1, 36, 0, 145, 150, 'active'),
	(33, 36, 0, 37, 1, 146, 152, 'active'),
	(34, 36, 0, 36, 0, 145, 153, 'active'),
	(35, 36, 0, 36, 1, 148, 154, 'active'),
	(36, 36, 1, 37, 0, 159, 150, 'active'),
	(37, 37, 0, 36, 1, 146, 152, 'active'),
	(38, 36, 1, 35, 0, 158, 150, 'active'),
	(39, 35, 0, 36, 1, 146, 152, 'active'),
	(40, 37, 1, 38, 0, 147, 150, 'active'),
	(41, 38, 0, 37, 1, 146, 152, 'active'),
	(42, 38, 0, 38, 1, 148, 154, 'active'),
	(43, 141, 0, NULL, NULL, 147, 151, 'active'),
	(44, NULL, NULL, 141, 0, 144, 149, 'active'),
	(45, 141, 0, 141, 0, 145, 153, 'active'),
	(46, 141, 0, 141, 1, 148, 154, 'active'),
	(47, 141, 1, 142, 0, 145, 150, 'active'),
	(48, 142, 0, 141, 1, 146, 152, 'active'),
	(49, 141, 1, 143, 0, 147, 150, 'active'),
	(50, 143, 0, 141, 1, 146, 152, 'active'),
	(51, 142, 0, 142, 0, 145, 153, 'active'),
	(52, 142, 0, 142, 1, 148, 154, 'active'),
	(53, 142, 1, 142, 0, 145, 150, 'active'),
	(54, 142, 0, 142, 1, 146, 152, 'active'),
	(55, 142, 1, 143, 0, 147, 150, 'active'),
	(56, 143, 0, 142, 1, 146, 152, 'active'),
	(57, 143, 0, 143, 1, 148, 154, 'active');

CREATE TABLE IF NOT EXISTS `block_storage` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(8) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `asset_code` varchar(50) DEFAULT NULL COMMENT '资产编码',
  `charge_type` int(15) DEFAULT NULL COMMENT '计费模式',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `disk_size` int(15) DEFAULT NULL COMMENT '容量(G)',
  `host` varchar(15) DEFAULT NULL COMMENT '主机',
  `mount_point` varchar(50) DEFAULT NULL COMMENT '挂载点',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `orchestration` varchar(100) DEFAULT NULL COMMENT '编排',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `type` int(15) DEFAULT NULL COMMENT '类型',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `DCN` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `dcn_design` varchar(15) DEFAULT NULL COMMENT '数据中心节点设计',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `zone` varchar(15) DEFAULT NULL COMMENT '安全区域',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `DCN` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `dcn_design`, `name`, `state`, `zone`, `biz_key`) VALUES
	('0019_0000000001', NULL, '0019_0000000001', '', NULL, 'PRDs_GZ1_DMZ_DMZ', 'umadm', '2019-07-03 11:05:01', 'umadmin', '2019-07-02 08:11:52', 'DMZ', '0025_0000000003', 'DMZ', 39, '0017_0000000001', NULL),
	('0019_0000000002', NULL, '0019_0000000002', '', NULL, 'PRDs_GZ1_ECN_ECN', 'umadmin', '2019-07-02 08:14:49', 'umadmin', '2019-07-02 08:12:24', 'ECN', '0025_0000000004', 'ECN', 39, '0017_0000000002', NULL),
	('0019_0000000003', NULL, '0019_0000000003', '', NULL, 'PRDs_GZ1_SF_RDCN1', 'umadm', '2019-07-05 03:09:50', 'umadmin', '2019-07-02 08:17:21', 'RDCN1', '0025_0000000006', 'RDCN1', 39, '0017_0000000007', NULL),
	('0019_0000000004', NULL, '0019_0000000004', '', NULL, 'PRDs_GZ1_SF_RDCN2', 'umadm', '2019-07-05 03:09:50', 'umadmin', '2019-07-02 08:17:42', 'RDCN2', '0025_0000000007', 'RDCN2', 39, '0017_0000000007', NULL),
	('0019_0000000005', NULL, '0019_0000000005', '', NULL, 'PRDs_GZ1_MGMT_MGMT', 'umadmin', '2019-07-02 08:18:52', 'umadmin', '2019-07-02 08:18:52', 'MGMT', '0025_0000000005', 'MGMT', 39, '0017_0000000003', NULL);

CREATE TABLE IF NOT EXISTS `DCN_desgin` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `business_group` int(15) DEFAULT NULL COMMENT '业务群组',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `type` int(15) DEFAULT NULL COMMENT '类型',
  `zone_design` varchar(15) DEFAULT NULL COMMENT '安全区域设计',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `DCN_desgin` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `business_group`, `code`, `state`, `type`, `zone_design`) VALUES
	('0025_0000000001', NULL, '0025_0000000001', '客户接入', NULL, 'STGs_CORE_DMZ', 'umadmin', '2019-07-02 03:49:55', 'umadmin', '2019-07-02 03:49:55', 43, 'DMZ', 141, 64, '0023_0000000002'),
	('0025_0000000002', NULL, '0025_0000000002', '核心业务', NULL, 'STGs_CORE_RDCN', 'umadmin', '2019-07-02 03:50:35', 'umadmin', '2019-07-02 03:50:35', 43, 'RDCN', 141, 63, '0023_0000000002'),
	('0025_0000000003', NULL, '0025_0000000003', '客户接入', NULL, 'PRDs_DMZ_DMZ', 'umadmin', '2019-07-02 04:02:56', 'umadmin', '2019-07-02 04:02:56', 43, 'DMZ', 141, 64, '0023_0000000006'),
	('0025_0000000004', NULL, '0025_0000000004', '伙伴接入', NULL, 'PRDs_ECN_ECN', 'umadmin', '2019-07-02 04:03:21', 'umadmin', '2019-07-02 04:03:21', 43, 'ECN', 141, 65, '0023_0000000008'),
	('0025_0000000005', NULL, '0025_0000000005', '工具管理', NULL, 'PRDs_MGMT_MGMT', 'umadmin', '2019-07-02 04:05:04', 'umadmin', '2019-07-02 04:04:47', 43, 'MGMT', 141, 204, '0023_0000000007'),
	('0025_0000000006', NULL, '0025_0000000006', '存款核心', NULL, 'PRDs_SF_RDCN1', 'umadmin', '2019-07-02 04:08:14', 'umadmin', '2019-07-02 04:05:35', 43, 'RDCN1', 141, 63, '0023_0000000009'),
	('0025_0000000007', NULL, '0025_0000000007', '核心业务', NULL, 'PRDs_SF_ADM', 'umadmin', '2019-07-03 09:12:18', 'umadmin', '2019-07-02 04:08:09', 43, 'ADM', 141, 60, '0023_0000000009'),
	('0025_0000000008', NULL, '0025_0000000008', '核心业务', NULL, 'PRDs_SF_RDCN2', 'umadmin', '2019-07-03 09:12:00', 'umadmin', '2019-07-03 09:09:18', 43, 'RDCN2', 141, 63, '0023_0000000009');

CREATE TABLE IF NOT EXISTS `host` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `asset_code` varchar(50) DEFAULT NULL COMMENT '资产编码',
  `charge_type` int(15) DEFAULT NULL COMMENT '计费模式',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `cpu` int(15) DEFAULT NULL COMMENT 'CPU(c)',
  `disk` int(15) DEFAULT NULL COMMENT '系统盘(G)',
  `internet_nat_ip` varchar(15) DEFAULT NULL COMMENT '外网IP',
  `intranet_ip` varchar(15) DEFAULT NULL COMMENT '内网IP',
  `mem` int(15) DEFAULT NULL COMMENT '内存(G)',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `orchestration` varchar(100) DEFAULT NULL COMMENT '编排',
  `os` int(15) DEFAULT NULL COMMENT '操作系统',
  `resource_set` varchar(15) DEFAULT NULL COMMENT '资源集',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `type` int(15) DEFAULT NULL COMMENT '类型',
  `charge_period` int(15) DEFAULT NULL COMMENT 'null',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `host` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `asset_code`, `charge_type`, `code`, `cpu`, `disk`, `internet_nat_ip`, `intranet_ip`, `mem`, `name`, `orchestration`, `os`, `resource_set`, `state`, `type`, `charge_period`, `biz_key`) VALUES
	('0012_0000000001', NULL, '0012_0000000001', 'MGMT_APP_01', NULL, 'MGMT_APP_01-10.0.16.200', 'umadmin', '2019-07-03 12:49:51', 'umadmin', '2019-07-03 08:10:26', 'MGMT_APP_01', 54, 'MGMT_APP_01', 97, 104, '0014_0000000008', '0014_0000000008', 100, 'MGMT_APP_01', '', 94, '0020_0000000006', 34, 93, 209, ''),
	('0012_0000000002', NULL, '0012_0000000002', 'MGMT_APP_02', NULL, 'MGMT_APP_02-10.0.16.239', 'umadmin', '2019-07-03 12:50:24', 'umadmin', '2019-07-03 08:11:11', 'MGMT_APP_02', 54, 'MGMT_APP_02', 97, 104, '0014_0000000009', '0014_0000000009', 100, 'MGMT_APP_02', '', 94, '0020_0000000006', 34, 93, 209, ''),
	('0012_0000000003', NULL, '0012_0000000003', '', NULL, 'APP01-10.0.16.10', 'umadmin', '2019-07-05 03:09:47', 'umadmin', '2019-07-03 11:33:58', 'ins-3bhngias', 54, 'APP-01', 97, 104, '0014_0000000013', '0014_0000000013', 100, 'APP01', '', 94, '0020_0000000003', 34, 93, 209, 'rvjBA4092Bl'),
	('0012_0000000004', NULL, '0012_0000000004', '', NULL, 'APP01-10.0.16.11', 'umadmin', '2019-07-05 03:09:47', 'umadmin', '2019-07-03 11:35:00', 'ins-6mkh6ito', 54, 'APP-02', 97, 104, '', '0014_0000000014', 100, 'APP01', '', 94, '0020_0000000003', 34, 93, 209, 'rvjBA4092Bl');

CREATE TABLE IF NOT EXISTS `IDC` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `address` varchar(1000) DEFAULT NULL COMMENT '地址',
  `city` varchar(50) DEFAULT NULL COMMENT '城市',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `env_type` varchar(15) DEFAULT NULL COMMENT '类型',
  `idc_design` varchar(15) DEFAULT NULL COMMENT '机房设计',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `parameter` varchar(1000) DEFAULT NULL COMMENT '远程参数',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `IDC` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `address`, `city`, `code`, `env_type`, `idc_design`, `name`, `parameter`, `state`, `biz_key`) VALUES
	('0016_0000000001', NULL, '0016_0000000001', '沙箱POC广州云机房', NULL, 'STGs_GZ', 'umadmin', '2019-07-03 01:16:29', 'umadmin', '2019-07-02 04:14:47', '', '广州', 'GZ', '48', '0022_0000000001', '沙箱POC广州云机房', 'Region=ap-guangzhou;AvailableZone=ap-guangzhou-3;SecretID=SecretID;SecretKey=SecretKey', 39, NULL),
	('0016_0000000002', NULL, '0016_0000000002', '沙箱生产广州云机房1', NULL, 'PRDs_GZ1', 'umadmin', '2019-07-03 12:26:41', 'umadmin', '2019-07-02 04:15:34', '', '广州', 'GZ1', '47', '0022_0000000002', '沙箱生产广州云机房1', 'Region=ap-guangzhou;AvailableZone=ap-guangzhou-3;SecretID=SecretID;SecretKey=SecretKey', 39, NULL),
	('0016_0000000003', NULL, '0016_0000000003', '沙箱生产广州云机房2', NULL, 'PRDs_GZ2', 'umadmin', '2019-07-03 01:16:44', 'umadmin', '2019-07-02 06:03:33', '', '广州', 'GZ2', '47', '0022_0000000002', '沙箱生产广州云机房2', 'Region=ap-guangzhou;AvailableZone=ap-guangzhou-3;SecretID=SecretID;SecretKey=SecretKey', 39, NULL);

CREATE TABLE IF NOT EXISTS `IDC_design` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `env_type` int(15) DEFAULT NULL COMMENT '环境类型',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `IDC_design` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `env_type`, `name`, `state`) VALUES
	('0022_0000000001', NULL, '0022_0000000001', '沙箱POC云机房', NULL, 'STGs', 'umadmin', '2019-07-02 03:31:17', 'umadmin', '2019-07-02 03:31:17', 'STGs', 48, '沙箱POC云机房', 141),
	('0022_0000000002', NULL, '0022_0000000002', '沙箱生产云机房', NULL, 'PRDs', 'umadmin', '2019-07-02 03:31:44', 'umadmin', '2019-07-02 03:31:44', 'PRDs', 47, '沙箱生产云机房', 141);

CREATE TABLE IF NOT EXISTS `invoke` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `invoke_design` varchar(20) DEFAULT NULL COMMENT '调用设计',
  `orchestration` varchar(100) DEFAULT NULL COMMENT '编排',
  `service` varchar(15) DEFAULT NULL COMMENT '服务',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `unit` varchar(15) DEFAULT NULL COMMENT '单元',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `invoke_design` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `orchestration` varchar(1000) DEFAULT NULL COMMENT '编排',
  `service_design` varchar(15) DEFAULT NULL COMMENT '服务设计',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `type` int(15) DEFAULT NULL COMMENT '类型',
  `unit_design` varchar(15) DEFAULT NULL COMMENT '单元设计',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `invoke_design` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `orchestration`, `service_design`, `state`, `type`, `unit_design`) VALUES
	('0005_0000000002', NULL, '0005_0000000002', 'INVOKE_1', '2019-07-03 20:54:42', 'WECUBE-DEMO-APP_invoke_WECUBE-DEMO-APP-SERVICE-T', 'umadmin', '2019-07-03 12:54:42', 'umadmin', '2019-07-03 08:59:35', 'INVOKE_1', '', '0004_0000000002', 141, 84, '0003_0000000013'),
	('0005_0000000005', NULL, '0005_0000000005', '', '2019-07-04 15:46:31', 'EDP-CORE-APP_invoke_WECUBE-DEMO-APP-SERVICE-T', 'umadmin', '2019-07-04 07:46:31', 'umadmin', '2019-07-03 11:21:31', '', '', '0004_0000000002', 141, 84, '0003_0000000002'),
	('0005_0000000006', NULL, '0005_0000000006', '', '2019-07-04 15:46:31', 'EDP-CORE-APP_invoke_EDP-CORE-DB-R', 'umadmin', '2019-07-04 07:46:31', 'umadmin', '2019-07-03 11:22:45', '', '', '0004_0000000004', 141, 84, '0003_0000000002'),
	('0005_0000000007', NULL, '0005_0000000007', '', '2019-07-04 15:46:32', 'EDP-CLIENT-API_invoke_EDP-CORE-APP-S1', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:34:35', '', '', '0004_0000000001', 141, 84, '0003_0000000014'),
	('0005_0000000008', NULL, '0005_0000000008', '', '2019-07-04 15:46:32', 'EDP-CONSOLE-APP_invoke_EDP-CORE-APP-S2', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:35:23', '', '', '0004_0000000003', 141, 84, '0003_0000000007'),
	('0005_0000000009', NULL, '0005_0000000009', '', '2019-07-04 15:46:32', 'EDP-CLIENT-WEB_invoke_EDP-CONSOLE-APP-S', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:38:04', '', '', '0004_0000000007', 141, 84, '0003_0000000015'),
	('0005_0000000010', NULL, '0005_0000000010', '', '2019-07-04 15:46:32', 'EDP-ADMCORE-APP_invoke_EDP-CORE-APP-S1', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:40:09', '', '', '0004_0000000001', 141, 84, '0003_0000000005'),
	('0005_0000000011', NULL, '0005_0000000011', '', '2019-07-04 15:46:32', 'EDP-ADMCORE-APP_invoke_EDP-ADMCORE-DB-S', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:41:03', '', '', '0004_0000000008', 141, 84, '0003_0000000005'),
	('0005_0000000012', NULL, '0005_0000000012', '', '2019-07-04 15:46:32', 'EDP-GL-APP_invoke_EDP-ADMCORE-APP-S', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:42:52', '', '', '0004_0000000009', 141, 84, '0003_0000000006'),
	('0005_0000000013', NULL, '0005_0000000013', '', '2019-07-04 15:46:32', 'EDP-GL-APP_invoke_EDP-CORE-APP-S1', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:43:10', '', '', '0004_0000000001', 141, 84, '0003_0000000006');

CREATE TABLE IF NOT EXISTS `invoke_sequence_design` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `invoke_design_sequence` varchar(300) DEFAULT NULL COMMENT '调用序列',
  `name` varchar(50) DEFAULT NULL COMMENT '服务名称',
  `service_design` varchar(15) DEFAULT NULL COMMENT '服务设计',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `invoke_sequence_design` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `invoke_design_sequence`, `name`, `service_design`, `state`) VALUES
	('0006_0000000001', NULL, '0006_0000000001', '', '2019-07-03 20:54:42', 'WECUBE-DEMO-APP-SERVICE-T-INVOKE_SEQ_1', 'umadmin', '2019-07-03 12:54:42', 'umadmin', '2019-07-03 09:00:08', 'INVOKE_SEQ_1', '0005_0000000002', 'INVOKE_SEQ_1', '0004_0000000002', 141);

CREATE table invoke_sequence_design$invoke_design_sequence(
	 `id` INT(11) NOT NULL AUTO_INCREMENT,
	`from_guid` VARCHAR(15) NOT NULL,
	`to_guid` VARCHAR(15) NOT NULL,
PRIMARY KEY (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `invoke_sequence_design$invoke_design_sequence` (`id`, `from_guid`, `to_guid`) VALUES
    (1, '0006_0000000001', '0005_0000000002');

CREATE TABLE IF NOT EXISTS `ip_addr` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `mash` int(2) DEFAULT NULL COMMENT '子网掩码',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `network_segment` varchar(15) DEFAULT NULL COMMENT 'IP网段',
  `orchestration` varchar(100) DEFAULT NULL COMMENT '编排',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `type` int(15) DEFAULT NULL COMMENT '类型',
  `used_record` varchar(1000) DEFAULT NULL COMMENT '使用记录',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `ip_addr` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `mash`, `name`, `network_segment`, `orchestration`, `state`, `type`, `used_record`, `biz_key`) VALUES
	('0014_0000000001', NULL, '0014_0000000001', '网关', NULL, '10.0.0.1_', 'umadmin', '2019-07-02 07:49:53', NULL, NULL, '10.0.0.1', 24, '10.0.0.1', '0021_0000000011', '', 34, 109, '', NULL),
	('0014_0000000003', NULL, '0014_0000000003', '网关', NULL, '10.0.1.1_', 'umadmin', '2019-07-02 07:49:54', 'umadmin', '2019-07-02 07:25:44', '10.0.1.1', 24, '10.0.1.1', '0021_0000000012', '', 34, 109, NULL, NULL),
	('0014_0000000004', NULL, '0014_0000000004', '网关', NULL, '10.0.2.1_', 'umadmin', '2019-07-02 07:49:55', 'umadmin', '2019-07-02 07:27:05', '10.0.2.1', 24, '10.0.2.1', '0021_0000000013', '', 34, 109, NULL, NULL),
	('0014_0000000005', NULL, '0014_0000000005', '互联网地址', NULL, '0.0.0.1_', 'umadmin', '2019-07-02 07:49:55', 'umadmin', '2019-07-02 07:34:56', '0.0.0.1', 0, '0.0.0.1', '0021_0000000014', '', 34, 110, NULL, NULL),
	('0014_0000000006', NULL, '0014_0000000006', '网关', NULL, '10.128.0.1_', 'umadmin', '2019-07-02 07:49:56', 'umadmin', '2019-07-02 07:37:14', '10.128.0.1', 16, '10.128.0.1', '0021_0000000015', '', 34, 109, NULL, NULL),
	('0014_0000000007', NULL, '0014_0000000007', '网关', NULL, '10.0.4.1_', 'umadmin', '2019-07-02 07:50:41', 'umadmin', '2019-07-02 07:50:41', '10.0.4.1', 22, '10.0.4.1', '0021_0000000016', '', 34, 109, NULL, NULL),
	('0014_0000000008', NULL, '0014_0000000008', '主机地址', NULL, '10.0.16.200_', 'umadmin', '2019-07-03 10:07:05', 'umadmin', '2019-07-03 08:12:10', '10.0.16.200', 24, '10.0.16.200', '0021_0000000019', '', 34, 109, NULL, NULL),
	('0014_0000000009', NULL, '0014_0000000009', '主机地址', NULL, '10.0.16.239_', 'umadmin', '2019-07-03 10:07:06', 'umadmin', '2019-07-03 08:12:36', '10.0.16.239', 24, '10.0.16.239', '0021_0000000019', '', 34, 109, NULL, NULL),
	('0014_0000000010', NULL, '0014_0000000010', '主机地址', NULL, '10.0.4.2_', 'umadmin', '2019-07-03 11:11:36', 'umadmin', '2019-07-03 11:11:36', '10.0.4.2', 24, '10.0.4.2', '0021_0000000016', '', 34, 109, NULL, NULL),
	('0014_0000000011', NULL, '0014_0000000011', '主机IP', NULL, '10.0.4.3_', 'umadmin', '2019-07-03 11:12:14', 'umadmin', '2019-07-03 11:12:14', '10.0.4.3', 24, '10.0.4.3', '0021_0000000016', '', 34, 109, NULL, NULL),
	('0014_0000000012', NULL, '0014_0000000012', '', NULL, '10.0.16.1_', 'umadmin', '2019-07-03 11:28:10', 'umadmin', '2019-07-03 11:28:10', '10.0.16.1', 24, '网关', '0021_0000000021', '', 34, 109, NULL, NULL),
	('0014_0000000013', NULL, '0014_0000000013', '主机IP', NULL, '10.0.16.10_', 'umadmin', '2019-07-03 11:28:58', 'umadmin', '2019-07-03 11:28:58', '10.0.16.10', 24, '10.0.16.10', '0021_0000000021', '', 34, 109, NULL, NULL),
	('0014_0000000014', NULL, '0014_0000000014', '主机IP', NULL, '10.0.16.11_', 'umadmin', '2019-07-03 11:29:36', 'umadmin', '2019-07-03 11:29:36', '10.0.16.11', 24, '10.0.16.11', '0021_0000000021', '', 34, 109, NULL, NULL);

CREATE TABLE IF NOT EXISTS `network_segment` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `asset_code` varchar(50) DEFAULT NULL COMMENT '资产编码',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `f_network_segment` varchar(15) DEFAULT NULL COMMENT '父网段',
  `gateway_ip` varchar(15) DEFAULT NULL COMMENT '网关IP地址',
  `mask` int(15) DEFAULT NULL COMMENT '子网',
  `name` varchar(50) DEFAULT NULL COMMENT '服务名称',
  `orchestration` varchar(100) DEFAULT NULL COMMENT '编排',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `type` int(15) DEFAULT NULL COMMENT 'null',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `network_segment` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `asset_code`, `code`, `f_network_segment`, `gateway_ip`, `mask`, `name`, `orchestration`, `state`, `type`, `biz_key`) VALUES
	('0021_0000000001', NULL, '0021_0000000001', 'jj', NULL, '10.0.0.0/16', 'umadmin', '2019-07-03 11:26:46', NULL, NULL, NULL, '10.0.0.0/16', null, '0014_0000000001', 16, '10.0.0.0/16', NULL, 39, 208, NULL),
	('0021_0000000011', NULL, '0021_0000000011', 'dmz', NULL, '10.0.0.0/24', 'umadmin', '2019-07-02 07:29:59', 'umadmin', '2019-07-02 07:16:38', '', '10.0.0.0/24', '0021_0000000001', '0014_0000000001', 24, '10.0.0.0/24', '', 39, NULL, NULL),
	('0021_0000000012', NULL, '0021_0000000012', 'ecn', NULL, '10.0.1.0/24', 'umadmin', '2019-07-02 07:24:54', 'umadmin', '2019-07-02 07:24:54', '', '10.0.1.0/24', '0021_0000000001', '0014_0000000001', 24, '10.0.1.0/24', '', 39, NULL, NULL),
	('0021_0000000013', NULL, '0021_0000000013', 'mgmt', NULL, '10.0.2.0/24', 'umadmin', '2019-07-02 07:27:52', 'umadmin', '2019-07-02 07:27:52', '', '10.0.2.0/24', '0021_0000000001', '0014_0000000004', 24, '10.0.2.0/24', '', 39, NULL, NULL),
	('0021_0000000014', NULL, '0021_0000000014', '互联网地址', NULL, '0.0.0.0/0', 'umadmin', '2019-07-02 07:35:31', 'umadmin', '2019-07-02 07:33:34', '', '0.0.0.0/0', null, '0014_0000000005', 0, '0.0.0.0/0', '', 39, NULL, NULL),
	('0021_0000000015', NULL, '0021_0000000015', '内网地址段', NULL, '10.128.0.0/16', 'umadmin', '2019-07-02 07:38:21', 'umadmin', '2019-07-02 07:38:03', '', '10.128.0.0/16', null, '0014_0000000006', 16, '10.128.0.0/16', '', 39, NULL, NULL),
	('0021_0000000016', NULL, '0021_0000000016', 'sf', NULL, '10.0.4.0/22', 'umadmin', '2019-07-02 07:51:09', 'umadmin', '2019-07-02 07:47:23', '', '10.0.4.0/22', null, '0014_0000000007', 22, '10.0.4.0/22', '', 39, NULL, NULL),
	('0021_0000000017', NULL, '0021_0000000017', '', NULL, '10.0.0.0/25', 'umadmin', '2019-07-03 02:29:53', 'umadmin', '2019-07-03 02:29:53', '', '10.0.0.0/25', '0021_0000000011', '0014_0000000001', 25, '10.0.0.0/25', '', 39, NULL, NULL),
	('0021_0000000018', NULL, '0021_0000000018', '机房', NULL, '10.1.0.0/16', 'umadmin', '2019-07-03 03:05:29', 'umadmin', '2019-07-03 03:05:29', '', '10.1.0.0/16', '0021_0000000001', '0014_0000000001', 16, '10.1.0.0/16', '', 39, 208, NULL),
	('0021_0000000019', NULL, '0021_0000000019', 'sf', NULL, '10.0.16.0/24', 'umadmin', '2019-07-03 08:01:55', 'umadmin', '2019-07-03 08:01:55', '', '10.0.16.0/24', '0021_0000000014', '0014_0000000005', 24, '10.0.16.0/24', '', 39, 208, NULL),
	('0021_0000000020', NULL, '0021_0000000020', '', NULL, '10.0.16.0/20', 'umadmin', '2019-07-03 11:30:52', 'umadmin', '2019-07-03 11:23:40', '', '10.0.16.0/20', '0021_0000000001', '0014_0000000012', 16, '10.0.16.0/16', '', 39, 205, NULL),
	('0021_0000000021', NULL, '0021_0000000021', '', NULL, '10.0.16.0/24', 'umadmin', '2019-07-03 11:30:13', 'umadmin', '2019-07-03 11:25:06', '', '10.0.16.0/24', '0021_0000000020', '0014_0000000012', 24, '10.0.16.0/24', '', 39, 207, NULL);

CREATE TABLE IF NOT EXISTS `package` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `deploy_file` varchar(200) DEFAULT NULL COMMENT '执行部署脚本文件',
  `deploy_user` int(15) DEFAULT NULL COMMENT '部署用户',
  `diff_conf_file` varchar(200) DEFAULT NULL COMMENT '差异配置文件',
  `diff_conf_variable` varchar(1000) DEFAULT NULL COMMENT '差异配置变量',
  `md5_value` varchar(50) DEFAULT NULL COMMENT 'MD5值',
  `name` varchar(50) DEFAULT NULL COMMENT '包名称',
  `url` varchar(1000) DEFAULT NULL COMMENT '存储路径',
  `start_file` varchar(200) DEFAULT NULL COMMENT '启动脚步文件',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `stop_file` varchar(200) DEFAULT NULL COMMENT '停止脚步文件',
  `unit_design` varchar(15) DEFAULT NULL COMMENT '单元设计',
  `upload_time` varchar(19) DEFAULT NULL COMMENT '上传时间',
  `upload_user` varchar(50) DEFAULT NULL COMMENT '上传人',
  `deploy_path` varchar(200) DEFAULT NULL COMMENT 'null',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `package` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `deploy_file`, `deploy_user`, `diff_conf_file`, `diff_conf_variable`, `md5_value`, `name`, `url`, `start_file`, `state`, `stop_file`, `unit_design`, `upload_time`, `upload_user`, `deploy_path`, `biz_key`) VALUES
	('0011_0000000003', NULL, '0011_0000000003', 'wecube-demo.zip', NULL, 'wecube-demo.zip_2019-07-03 21:41:38', 'umadmin', '2019-07-03 14:23:43', 'umadmin', '2019-07-03 13:41:38', 'wecube-demo', 'http://10.10.119.52:9000/scripts/wecube-demo.sh', 214, NULL, NULL, 'b043bd34649dee665224191bec9ab2a6', 'wecube-demo.zip', 'http://10.10.119.52:9000/wecube-artifact/b043bd34649dee665224191bec9ab2a6_wecube-demo.zip', NULL, 39, NULL, '0003_0000000013', '2019-07-03 21:41:38', 'umadmin', '/home/app/wecube-demo.zip', NULL),
	('0011_0000000004', NULL, '0011_0000000004', 'wecube-demo_v1.0.zip', NULL, 'wecube-demo_v1.0.zip_2019-07-03 22:45:34', 'umadmin', '2019-07-03 14:47:43', 'umadmin', '2019-07-03 14:45:34', 'wecube-demo', 'http://10.10.119.52:9000/scripts/wecube-demo.sh', 214, NULL, NULL, '425f18c91e10015f270fb6f54bdd17ad', 'wecube-demo_v1.0.zip', 'http://10.10.119.52:9000/wecube-artifact/425f18c91e10015f270fb6f54bdd17ad_wecube-demo_v1.0.zip', NULL, 39, NULL, '0003_0000000013', '2019-07-03 22:45:34', 'umadmin', '/home/app/wecube-demo.zip', NULL),
	('0011_0000000005', NULL, '0011_0000000005', 'wecube-demo_v2.0.zip', NULL, 'wecube-demo_v2.0.zip_2019-07-04 12:41:35', 'umadmin', '2019-07-04 04:41:35', 'umadmin', '2019-07-04 04:41:35', NULL, NULL, NULL, NULL, NULL, '9c1572e6241c689fa75cee12fa9ba3f2', 'wecube-demo_v2.0.zip', 'http://10.10.119.52:9000/wecube-artifact/9c1572e6241c689fa75cee12fa9ba3f2_wecube-demo_v2.0.zip', NULL, 39, NULL, '0003_0000000013', '2019-07-04 12:41:35', 'umadmin', NULL, NULL);

CREATE TABLE IF NOT EXISTS `resource_set` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `dcn` varchar(15) DEFAULT NULL COMMENT 'DCN',
  `env` int(15) DEFAULT NULL COMMENT '环境',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `network_segment` varchar(15) DEFAULT NULL COMMENT '网段',
  `orchestration` varchar(100) DEFAULT NULL COMMENT '编排',
  `resource_set_design` varchar(15) DEFAULT NULL COMMENT '资源集设计',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `asset_code` varchar(50) DEFAULT NULL COMMENT 'null',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `resource_set` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `dcn`, `env`, `name`, `network_segment`, `orchestration`, `resource_set_design`, `state`, `asset_code`, `biz_key`) VALUES
	('0020_0000000001', NULL, '0020_0000000001', '', NULL, 'PRDs_GZ1_DMZ_DMZ_PROXY', 'umadmin', '2019-07-03 01:25:19', 'umadmin', '2019-07-03 01:25:02', 'PROXY', '0019_0000000001', 49, '', '0021_0000000011', '', '0026_0000000001', 39, NULL, NULL),
	('0020_0000000002', NULL, '0020_0000000002', '', NULL, 'PRDs_GZ1_ECN_ECN_PROXY', 'umadmin', '2019-07-03 01:26:39', 'umadmin', '2019-07-03 01:26:39', 'PROXY', '0019_0000000002', 49, '', '0021_0000000012', '', '0026_0000000006', 39, NULL, NULL),
	('0020_0000000003', NULL, '0020_0000000003', '', NULL, 'PRDs_GZ1_SF_RDCN1_APP', 'umadmin', '2019-07-05 03:09:51', 'umadmin', '2019-07-03 01:27:55', 'APP', '0019_0000000003', 49, '', '0021_0000000021', '', '0026_0000000010', 39, 'subnet-58q1ekcy', 'rvjBA4092Bl'),
	('0020_0000000004', NULL, '0020_0000000004', '', NULL, 'PRDs_GZ1_ECN_ECN_MYSQL', 'umadmin', '2019-07-04 09:56:37', 'umadmin', '2019-07-03 01:32:52', 'MYSQL', '0019_0000000002', 49, '', '0021_0000000016', '', '0026_0000000012', 40, NULL, 'rvfoL7D12BJ'),
	('0020_0000000005', NULL, '0020_0000000005', '', NULL, 'PRDs_GZ1_ECN_ECN_REDIS', 'umadmin', '2019-07-04 09:56:37', 'umadmin', '2019-07-03 01:33:34', 'REDIS', '0019_0000000002', 49, '', '0021_0000000016', '', '0026_0000000014', 40, NULL, 'rvfoL7D12BJ'),
	('0020_0000000006', NULL, '0020_0000000006', '', NULL, 'PRDs_GZ1_MGMT_MGMT_APP', 'umadmin', '2019-07-03 12:47:58', 'umadmin', '2019-07-03 08:00:14', 'APP', '0019_0000000005', 49, '', '0021_0000000019', '', '0026_0000000007', 39, '', '');

CREATE TABLE IF NOT EXISTS `resource_set_design` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `dcn_design` varchar(15) DEFAULT NULL COMMENT '数据中心节点设计',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `type` int(15) DEFAULT NULL COMMENT '类型',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `resource_set_design` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `dcn_design`, `state`, `type`) VALUES
	('0026_0000000001', NULL, '0026_0000000001', '代理资源集', NULL, 'STGs_CORE_DMZ_PROXY', 'umadmin', '2019-07-02 03:52:29', 'umadmin', '2019-07-02 03:52:29', 'PROXY', '0025_0000000001', 141, 66),
	('0026_0000000002', NULL, '0026_0000000002', '应用资源集', NULL, 'STGs_CORE_RDCN_APP', 'umadmin', '2019-07-02 03:52:52', 'umadmin', '2019-07-02 03:52:52', 'APP', '0025_0000000002', 141, 66),
	('0026_0000000003', NULL, '0026_0000000003', '数据库资源集', NULL, 'STGs_CORE_RDCN_MYSQL', 'umadmin', '2019-07-02 03:53:14', 'umadmin', '2019-07-02 03:53:14', 'MYSQL', '0025_0000000002', 141, 67),
	('0026_0000000004', NULL, '0026_0000000004', '缓存资源集', NULL, 'STGs_CORE_RDCN_REDIS', 'umadmin', '2019-07-02 03:53:49', 'umadmin', '2019-07-02 03:53:49', 'REDIS', '0025_0000000002', 141, 68),
	('0026_0000000005', NULL, '0026_0000000005', '代理资源集', NULL, 'PRDs_DMZ_DMZ_PROXY', 'umadmin', '2019-07-02 04:05:58', 'umadmin', '2019-07-02 04:05:58', 'PROXY', '0025_0000000003', 141, 66),
	('0026_0000000006', NULL, '0026_0000000006', '代理资源集', NULL, 'PRDs_ECN_ECN_PROXY', 'umadmin', '2019-07-02 04:06:14', 'umadmin', '2019-07-02 04:06:14', 'PROXY', '0025_0000000004', 141, 66),
	('0026_0000000007', NULL, '0026_0000000007', '工具应用', NULL, 'PRDs_MGMT_MGMT_APP', 'umadmin', '2019-07-02 04:06:49', 'umadmin', '2019-07-02 04:06:49', 'APP', '0025_0000000005', 141, 66),
	('0026_0000000008', NULL, '0026_0000000008', '工具数据库', NULL, 'PRDs_MGMT_MGMT_MYSQL', 'umadmin', '2019-07-02 04:07:09', 'umadmin', '2019-07-02 04:07:09', 'MYSQL', '0025_0000000005', 141, 67),
	('0026_0000000009', NULL, '0026_0000000009', '工具缓存', NULL, 'PRDs_MGMT_MGMT_REDIS', 'umadmin', '2019-07-02 04:07:34', 'umadmin', '2019-07-02 04:07:34', 'REDIS', '0025_0000000005', 141, 68),
	('0026_0000000010', NULL, '0026_0000000010', '业务应用', NULL, 'PRDs_SF_RDCN1_APP', 'umadmin', '2019-07-02 04:08:48', 'umadmin', '2019-07-02 04:08:48', 'APP', '0025_0000000006', 141, 66),
	('0026_0000000011', NULL, '0026_0000000011', '业务应用', NULL, 'PRDs_SF_ADM_APP', 'umadm', '2019-07-03 09:12:18', 'umadmin', '2019-07-02 04:09:13', 'APP', '0025_0000000007', 141, 66),
	('0026_0000000012', NULL, '0026_0000000012', '业务数据库', NULL, 'PRDs_SF_RDCN1_MYSQL', 'umadmin', '2019-07-02 04:09:32', 'umadmin', '2019-07-02 04:09:32', 'MYSQL', '0025_0000000006', 141, 67),
	('0026_0000000013', NULL, '0026_0000000013', '业务数据库', NULL, 'PRDs_SF_ADM_MYSQL', 'umadm', '2019-07-03 09:12:18', 'umadmin', '2019-07-02 04:09:59', 'MYSQL', '0025_0000000007', 141, 67),
	('0026_0000000014', NULL, '0026_0000000014', '业务缓存', NULL, 'PRDs_SF_RDCN1_REDIS', 'umadmin', '2019-07-02 04:10:27', 'umadmin', '2019-07-02 04:10:27', 'REDIS', '0025_0000000006', 141, 68),
	('0026_0000000015', NULL, '0026_0000000015', '业务缓存', NULL, 'PRDs_SF_ADM_REDIS', 'umadm', '2019-07-03 09:12:18', 'umadmin', '2019-07-02 04:10:47', 'REDIS', '0025_0000000007', 141, 68),
	('0026_0000000016', NULL, '0026_0000000016', '应用资源集', NULL, 'PRDs_SF_RDCN2_APP', 'umadm', '2019-07-03 09:12:00', 'umadmin', '2019-07-03 09:09:44', 'APP', '0025_0000000008', 141, 66),
	('0026_0000000017', NULL, '0026_0000000017', '数据库资源集', NULL, 'PRDs_SF_RDCN2_MYSQL', 'umadm', '2019-07-03 09:12:00', 'umadmin', '2019-07-03 09:10:06', 'MYSQL', '0025_0000000008', 141, 67),
	('0026_0000000018', NULL, '0026_0000000018', '缓存资源集', NULL, 'PRDs_SF_RDCN2_REDIS', 'umadm', '2019-07-03 09:12:00', 'umadmin', '2019-07-03 09:10:30', 'REDIS', '0025_0000000008', 141, 68);

CREATE TABLE IF NOT EXISTS `running_instance` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `app_disk` int(15) DEFAULT NULL COMMENT '应用盘(G)',
  `asset_code` varchar(50) DEFAULT NULL COMMENT '资产编码',
  `charge_type` int(15) DEFAULT NULL COMMENT '计费模式',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `cpu` int(15) DEFAULT NULL COMMENT 'CPU(c)',
  `host` varchar(15) DEFAULT NULL COMMENT '资源集',
  `mem` int(15) DEFAULT NULL COMMENT '内存(G)',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `orchestration` varchar(100) DEFAULT NULL COMMENT '编排',
  `port` varchar(50) DEFAULT NULL COMMENT '端口',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `type` int(15) DEFAULT NULL COMMENT '类型',
  `unit` varchar(15) DEFAULT NULL COMMENT '单元',
  `charge_period` int(15) DEFAULT NULL COMMENT 'null',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `running_instance` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `app_disk`, `asset_code`, `charge_type`, `code`, `cpu`, `host`, `mem`, `name`, `orchestration`, `port`, `state`, `type`, `unit`, `charge_period`, `biz_key`) VALUES
	('0015_0000000001', NULL, '0015_0000000001', 'WECUBE-DEMO-UNIT_1_INS_1', NULL, 'WECUBE-DEMO_生产环境_APP_INS_1_10.0.16.200', 'umadmin', '2019-07-04 09:03:16', 'umadmin', '2019-07-03 08:51:46', 126, 'WECUBE-DEMO-UNIT_1_INS_1', 54, 'INS_1', 121, '0012_0000000001', 124, 'WECUBE-DEMO-UNIT_1_INS_1', '', '', 39, 116, '0008_0000000001', 213, 'rvfc2zK12Bl'),
	('0015_0000000002', NULL, '0015_0000000002', 'WECUBE-DEMO-UNIT_1_INS_2', NULL, 'WECUBE-DEMO_生产环境_APP_INS_2_10.0.16.239', 'umadmin', '2019-07-04 09:03:16', 'umadmin', '2019-07-03 08:52:30', 126, 'WECUBE-DEMO-UNIT_1_INS_2', 54, 'INS_2', 121, '0012_0000000002', 124, 'WECUBE-DEMO-UNIT_1_INS_2', '', '', 39, 116, '0008_0000000001', 213, 'rvfc2zK12Bl');

CREATE TABLE IF NOT EXISTS `service` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `dns_domain` int(15) DEFAULT NULL COMMENT '域名域',
  `dns_name` varchar(50) DEFAULT NULL COMMENT '域名名',
  `ha_type` int(15) DEFAULT NULL COMMENT '高可用',
  `orchestration` varchar(100) DEFAULT NULL COMMENT '编排',
  `service_design` varchar(15) DEFAULT NULL COMMENT '服务设计',
  `service_ip` varchar(15) DEFAULT NULL COMMENT '服务IP',
  `service_port` varchar(50) DEFAULT NULL COMMENT '服务端口',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `unit` varchar(15) DEFAULT NULL COMMENT '单元',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `service_design` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `ha_type` int(15) DEFAULT NULL COMMENT '高可用',
  `name` varchar(50) DEFAULT NULL COMMENT '服务名称',
  `orchestration` varchar(1000) DEFAULT NULL COMMENT '编排',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `type` int(15) DEFAULT NULL COMMENT '类型',
  `unit_design` varchar(15) DEFAULT NULL COMMENT '单元设计',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `service_design` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `ha_type`, `name`, `orchestration`, `state`, `type`, `unit_design`) VALUES
	('0004_0000000001', NULL, '0004_0000000001', '', '2019-07-04 15:46:31', 'EDP-CORE-APP-S1', 'umadmin', '2019-07-04 07:46:31', 'umadmin', '2019-07-02 09:09:53', 'S1', 81, '', '', 141, 77, '0003_0000000002'),
	('0004_0000000002', NULL, '0004_0000000002', '', '2019-07-03 20:54:42', 'WECUBE-DEMO-APP-SERVICE-T', 'umadmin', '2019-07-03 12:54:42', 'umadmin', '2019-07-03 08:58:42', 'SERVICE-T', 80, 'SERVICE-T', '', 141, 77, '0003_0000000013'),
	('0004_0000000003', NULL, '0004_0000000003', '', '2019-07-04 15:46:31', 'EDP-CORE-APP-S2', 'umadmin', '2019-07-04 07:46:31', 'umadmin', '2019-07-04 04:03:06', 'S2', 80, '', '', 141, 77, '0003_0000000002'),
	('0004_0000000004', NULL, '0004_0000000004', '', '2019-07-04 15:46:32', 'EDP-CORE-DB-R', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:03:50', 'R', 83, '', '', 141, 77, '0003_0000000003'),
	('0004_0000000005', NULL, '0004_0000000005', '', '2019-07-04 15:46:32', 'EDP-CORE-DB-W', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:04:09', 'W', 83, '', '', 141, 77, '0003_0000000003'),
	('0004_0000000006', NULL, '0004_0000000006', '', '2019-07-04 15:46:32', 'EDP-CONSOLE-APP-S1', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:05:10', 'S1', 80, '', '', 141, 77, '0003_0000000007'),
	('0004_0000000007', NULL, '0004_0000000007', '', '2019-07-04 15:46:32', 'EDP-CONSOLE-APP-S', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:35:59', 'S', 81, '', '', 141, 77, '0003_0000000007'),
	('0004_0000000008', NULL, '0004_0000000008', '', '2019-07-04 15:46:32', 'EDP-ADMCORE-DB-S', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:40:41', 'S', 83, '', '', 141, 77, '0003_0000000004'),
	('0004_0000000009', NULL, '0004_0000000009', '', '2019-07-04 15:46:32', 'EDP-ADMCORE-APP-S', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:42:37', 'S', 81, '', '', 141, 77, '0003_0000000005');

CREATE TABLE IF NOT EXISTS `subsys` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `env` int(15) DEFAULT NULL COMMENT '环境',
  `manager` varchar(50) DEFAULT NULL COMMENT '运维人员',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `subsys_design` varchar(20) DEFAULT NULL COMMENT '子系统设计',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `subsys` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `env`, `manager`, `state`, `subsys_design`, `biz_key`) VALUES
	('0007_0000000001', NULL, '0007_0000000001', 'WECUBE-演示子系统', NULL, 'WECUBE-DEMO_生产环境', 'umadmin', '2019-07-03 08:39:46', 'umadmin', '2019-07-03 08:24:22', 'WECUBE-DEMO', 49, '', 39, '0002_0000000013', NULL);

CREATE TABLE IF NOT EXISTS `subsys_design` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `business_group` int(15) DEFAULT NULL COMMENT '业务群组',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `dcn_design_type` int(15) DEFAULT NULL COMMENT 'DCN设计类型',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `system_design` varchar(15) DEFAULT NULL COMMENT '系统设计',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `subsys_design` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `business_group`, `code`, `dcn_design_type`, `name`, `state`, `system_design`) VALUES
	('0002_0000000001', NULL, '0002_0000000001', '微信存款-联机', '2019-07-04 15:46:31', 'EDP-CORE', 'umadm', '2019-07-05 03:38:01', 'umadmin', '2019-07-02 08:59:26', 43, 'CORE', 63, '微信存款-联机', 141, '0001_0000000001'),
	('0002_0000000002', NULL, '0002_0000000002', '客户信息核心系统', NULL, 'ECIF-CORE', 'umadm', '2019-07-05 03:33:42', 'umadmin', '2019-07-02 09:57:18', 43, 'CORE', 63, '客户信息核心系统', 141, '0001_0000000003'),
	('0002_0000000003', NULL, '0002_0000000003', '客户信息索引', NULL, 'ECIF-INDEX', 'umadm', '2019-07-05 03:33:42', 'umadmin', '2019-07-02 09:59:38', 43, 'INDEX', 63, '客户信息索引', 141, '0001_0000000003'),
	('0002_0000000004', NULL, '0002_0000000004', '微信存款-ADM批量', '2019-07-04 15:46:32', 'EDP-ADMBATCH', 'umadm', '2019-07-05 03:38:01', 'umadmin', '2019-07-02 10:03:58', 43, 'ADMBATCH', 60, '微信存款-ADM批量', 141, '0001_0000000001'),
	('0002_0000000005', NULL, '0002_0000000005', '微信存款-ADM联机', '2019-07-04 15:46:32', 'EDP-ADMCORE', 'umadm', '2019-07-05 03:38:01', 'umadmin', '2019-07-02 10:05:03', 43, 'ADMCORE', 60, '微信存款-ADM联机', 141, '0001_0000000001'),
	('0002_0000000006', NULL, '0002_0000000006', '微信存款-小总账', '2019-07-04 15:46:32', 'EDP-GL', 'umadm', '2019-07-05 03:38:02', 'umadmin', '2019-07-02 10:06:10', 43, 'GL', 63, '微信存款-小总账', 141, '0001_0000000001'),
	('0002_0000000007', NULL, '0002_0000000007', '微信存款-控制台', '2019-07-04 15:46:32', 'EDP-CONSOLE', 'umadm', '2019-07-05 03:38:02', 'umadmin', '2019-07-02 10:06:51', 43, 'CONSOLE', 60, '微信存款-控制台', 141, '0001_0000000001'),
	('0002_0000000008', NULL, '0002_0000000008', '微信存款-批量', '2019-07-04 15:46:32', 'EDP-BATCH', 'umadm', '2019-07-05 03:38:02', 'umadmin', '2019-07-02 10:07:39', 43, 'BATCH', 63, '微信存款-批量', 141, '0001_0000000001'),
	('0002_0000000009', NULL, '0002_0000000009', '有折-后台子系统', NULL, 'HATS-BS', 'umadm', '2019-07-05 03:33:36', 'umadmin', '2019-07-02 10:34:28', 43, 'BS', 63, '有折-后台子系统', 141, '0001_0000000002'),
	('0002_0000000010', NULL, '0002_0000000010', '有折-H5接入子系统', NULL, 'HATS-HPRE', 'umadm', '2019-07-05 03:33:37', 'umadmin', '2019-07-02 10:35:16', 43, 'HPRE', 63, '有折-H5接入子系统', 141, '0001_0000000002'),
	('0002_0000000011', NULL, '0002_0000000011', '有折-页面发布子系统', NULL, 'HATS-WEB', 'umadm', '2019-07-05 03:33:37', 'umadmin', '2019-07-02 10:36:17', 43, 'WEB', 63, '有折-页面发布子系统', 141, '0001_0000000002'),
	('0002_0000000012', NULL, '0002_0000000012', '', '2019-07-04 15:46:32', 'EDP-ETL', 'umadm', '2019-07-05 03:38:02', 'umadmin', '2019-07-02 11:59:53', 43, 'ETL', 63, 'dd', 141, '0001_0000000001'),
	('0002_0000000013', NULL, '0002_0000000013', 'WECUBE-演示子系统', '2019-07-03 20:54:42', 'WECUBE-DEMO', 'umadm', '2019-07-05 03:33:57', 'umadmin', '2019-07-03 08:19:53', 43, 'DEMO', 63, 'WECUBE-演示子系统', 141, '0001_0000000004'),
	('0002_0000000014', NULL, '0002_0000000014', '客户端', '2019-07-04 15:46:32', 'EDP-CLIENT', 'umadm', '2019-07-05 03:38:02', 'umadmin', '2019-07-04 04:06:15', 43, 'CLIENT', 64, '微信存款-客户端', 141, '0001_0000000001');

CREATE TABLE IF NOT EXISTS `system_design` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `business_group` int(50) DEFAULT NULL COMMENT '业务群组',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `system_design` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `business_group`, `code`, `name`, `state`) VALUES
	('0001_0000000001', '0001_0000000007', '0001_0000000001', '存款核心系统', NULL, 'EDP', 'umadmin', '2019-07-05 03:38:00', 'umadmin', '2019-07-02 08:56:32', 43, 'EDP', '存款微核心系统', 142),
	('0001_0000000002', NULL, '0001_0000000002', '有折', NULL, 'HATS', 'umadmin', '2019-07-05 03:33:36', 'umadmin', '2019-07-02 09:55:09', 43, 'HATS', '有折', 141),
	('0001_0000000003', NULL, '0001_0000000003', '客户信息管理', NULL, 'ECIF', 'umadmin', '2019-07-05 03:33:42', 'umadmin', '2019-07-02 09:55:40', 43, 'ECIF', '客户信息管理', 141),
	('0001_0000000004', '0001_0000000008', '0001_0000000004', 'WeCube演示系统', NULL, 'WECUBE', 'umadmin', '2019-07-05 03:33:56', 'umadmin', '2019-07-03 08:18:14', 43, 'WECUBE', 'WeCube演示系统', 142),
	('0001_0000000005', NULL, '0001_0000000004', 'WeCube演示系统', '2019-07-03 20:54:42', 'WECUBE', 'umadmin', '2019-07-04 01:48:00', 'umadmin', '2019-07-03 08:18:14', 43, 'WECUBE', 'WeCube演示系统', 141),
	('0001_0000000006', '0001_0000000005', '0001_0000000004', 'WeCube演示系统', '2019-07-04 12:41:18', 'WECUBE', 'umadmin', '2019-07-04 07:37:25', 'umadmin', '2019-07-03 08:18:14', 43, 'WECUBE', 'WeCube演示系统', 142),
	('0001_0000000007', NULL, '0001_0000000001', '存款核心系统', '2019-07-04 15:46:31', 'EDP', 'umadmin', '2019-07-04 07:46:56', 'umadmin', '2019-07-02 08:56:32', 43, 'EDP', '存款微核心系统', 141),
	('0001_0000000008', '0001_0000000006', '0001_0000000004', 'WeCube演示系统', '2019-07-04 15:42:29', 'WECUBE', 'umadmin', '2019-07-05 03:33:56', 'umadmin', '2019-07-03 08:18:14', 43, 'WECUBE', 'WeCube演示系统', 142);

CREATE TABLE IF NOT EXISTS `unit` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `instance_num` int(3) DEFAULT NULL COMMENT '实例数量',
  `orchestration` varchar(100) DEFAULT NULL COMMENT '编排',
  `package` varchar(20) DEFAULT NULL COMMENT '部署包',
  `resource_set` varchar(20) DEFAULT NULL COMMENT '资源集',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `subsys` varchar(20) DEFAULT NULL COMMENT '子系统',
  `unit_design` varchar(20) DEFAULT NULL COMMENT '单元统设计',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `unit` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `instance_num`, `orchestration`, `package`, `resource_set`, `state`, `subsys`, `unit_design`, `biz_key`) VALUES
	('0008_0000000001', NULL, '0008_0000000001', 'WECUBE-DEMO-UNIT_1', NULL, 'WECUBE-DEMO_生产环境_APP', 'umadmin', '2019-07-04 09:03:13', 'umadmin', '2019-07-03 08:41:57', 'WECUBE-DEMO-UNIT_1', 2, 'wecube-appdeploy', '0011_0000000004', '0020_0000000006', 39, '0007_0000000001', '0003_0000000013', 'rvfc2zK12Bl');

CREATE TABLE IF NOT EXISTS `unit_design` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `across_idc` int(15) DEFAULT NULL COMMENT '跨IDC部署',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `name` varchar(50) DEFAULT NULL COMMENT '单元名称',
  `orchestration` varchar(1000) DEFAULT NULL COMMENT '编排',
  `resource_set_design_type` int(15) DEFAULT NULL COMMENT '资源集设计类型',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `subsys_design` varchar(15) DEFAULT NULL COMMENT '系统',
  `type` int(15) DEFAULT NULL COMMENT '类型',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `unit_design` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `across_idc`, `code`, `name`, `orchestration`, `resource_set_design_type`, `state`, `subsys_design`, `type`) VALUES
	('0003_0000000002', NULL, '0003_0000000002', '', '2019-07-04 15:46:31', 'EDP-CORE-APP', 'umadmin', '2019-07-04 07:46:31', 'umadmin', '2019-07-02 09:06:45', 76, 'APP', '应用模块', '', 66, 141, '0002_0000000001', 45),
	('0003_0000000003', NULL, '0003_0000000003', '', '2019-07-04 15:46:32', 'EDP-CORE-DB', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-02 09:07:16', 75, 'DB', '数据库模块', '', 67, 141, '0002_0000000001', 44),
	('0003_0000000004', NULL, '0003_0000000004', '', '2019-07-04 15:46:32', 'EDP-ADMCORE-DB', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-02 10:28:09', 75, 'DB', '数据库模块', '', 67, 141, '0002_0000000005', 44),
	('0003_0000000005', NULL, '0003_0000000005', '', '2019-07-04 15:46:32', 'EDP-ADMCORE-APP', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-02 10:28:41', 76, 'APP', '应用模块', '', 66, 141, '0002_0000000005', 45),
	('0003_0000000006', NULL, '0003_0000000006', '', '2019-07-04 15:46:32', 'EDP-GL-APP', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-02 10:29:21', 76, 'APP', '应用模块', '', 66, 141, '0002_0000000006', 45),
	('0003_0000000007', NULL, '0003_0000000007', '', '2019-07-04 15:46:32', 'EDP-CONSOLE-APP', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-02 10:30:13', 76, 'APP', '应用模块', '', 66, 141, '0002_0000000007', 45),
	('0003_0000000008', NULL, '0003_0000000008', '', '2019-07-04 15:46:32', 'EDP-GL-DB', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-02 10:31:13', 75, 'DB', '数据库模块', '', 67, 141, '0002_0000000006', 44),
	('0003_0000000009', NULL, '0003_0000000009', '', NULL, 'ECIF-CORE-DB', 'umadmin', '2019-07-02 10:37:50', 'umadmin', '2019-07-02 10:37:50', 75, 'DB', '数据库模块', '', 67, 141, '0002_0000000002', 44),
	('0003_0000000010', NULL, '0003_0000000010', '', NULL, 'ECIF-CORE-APP', 'umadmin', '2019-07-02 10:38:28', 'umadmin', '2019-07-02 10:38:28', 76, 'APP', '应用模块', '', 66, 141, '0002_0000000002', 45),
	('0003_0000000011', NULL, '0003_0000000011', '', NULL, 'ECIF-INDEX-DB', 'umadmin', '2019-07-02 10:38:58', 'umadmin', '2019-07-02 10:38:58', 75, 'DB', '数据库模块', '', 67, 141, '0002_0000000003', 44),
	('0003_0000000012', NULL, '0003_0000000012', '', NULL, 'ECIF-INDEX-APP', 'umadmin', '2019-07-02 10:39:27', 'umadmin', '2019-07-02 10:39:27', 76, 'APP', '应用模块', '', 66, 141, '0002_0000000003', 45),
	('0003_0000000013', NULL, '0003_0000000013', '', '2019-07-03 20:54:42', 'WECUBE-DEMO-APP', 'umadmin', '2019-07-03 12:54:42', 'umadmin', '2019-07-03 08:43:54', 76, 'APP', '应用模块', '', 66, 141, '0002_0000000013', 45),
	('0003_0000000014', NULL, '0003_0000000014', '', '2019-07-04 15:46:32', 'EDP-CLIENT-API', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:07:13', 76, 'API', '客户端', '', 66, 141, '0002_0000000014', 45),
	('0003_0000000015', NULL, '0003_0000000015', '', '2019-07-04 15:46:32', 'EDP-CLIENT-WEB', 'umadmin', '2019-07-04 07:46:32', 'umadmin', '2019-07-04 04:37:44', 76, 'WEB', '管理台', '', 66, 141, '0002_0000000014', 45);

CREATE TABLE IF NOT EXISTS `zone` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `asset_code` varchar(50) DEFAULT NULL COMMENT '资产编码',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `idc` varchar(15) DEFAULT NULL COMMENT '机房',
  `name` varchar(50) DEFAULT NULL COMMENT '服务名称',
  `network_segment` varchar(15) DEFAULT NULL COMMENT '网段',
  `orchestration` varchar(100) DEFAULT NULL COMMENT '编排',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `type` int(15) DEFAULT NULL COMMENT '类型',
  `vpc` varchar(50) DEFAULT NULL COMMENT '虚拟专用网',
  `zone_design` varchar(15) DEFAULT NULL COMMENT '安全区域设计',
  `zone_layer` int(15) DEFAULT NULL COMMENT '层级',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `zone` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `asset_code`, `code`, `idc`, `name`, `network_segment`, `orchestration`, `state`, `type`, `vpc`, `zone_design`, `zone_layer`, `biz_key`) VALUES
	('0017_0000000001', NULL, '0017_0000000001', '', NULL, 'PRDs_GZ1_DMZ', 'umadm', '2019-07-03 12:26:41', 'umadmin', '2019-07-02 06:55:41', '', 'DMZ', '0016_0000000002', 'DMZ ', '0021_0000000011', '', 39, 55, '', '0023_0000000006', 156, NULL),
	('0017_0000000002', NULL, '0017_0000000002', '', NULL, 'PRDs_GZ1_ECN', 'umadm', '2019-07-03 12:26:41', 'umadmin', '2019-07-02 07:30:50', '', 'ECN', '0016_0000000002', 'ECN', '0021_0000000012', '', 39, 56, '', '0023_0000000008', 156, NULL),
	('0017_0000000003', NULL, '0017_0000000003', '', NULL, 'PRDs_GZ1_MGMT', 'umadm', '2019-07-03 12:26:42', 'umadmin', '2019-07-02 07:31:24', '', 'MGMT', '0016_0000000002', 'MGMT', '0021_0000000013', '', 39, 59, '', '0023_0000000007', 156, NULL),
	('0017_0000000004', NULL, '0017_0000000004', '', NULL, 'PRDs_GZ1_INTERNET', 'umadm', '2019-07-03 12:26:42', 'umadmin', '2019-07-02 07:40:36', '', 'INTERNET', '0016_0000000002', 'INTERNET', '0021_0000000014', '', 39, 201, '', '0023_0000000003', 155, NULL),
	('0017_0000000005', NULL, '0017_0000000005', '', NULL, 'PRDs_GZ1_INTRANET', 'umadm', '2019-07-03 12:26:42', 'umadmin', '2019-07-02 07:41:13', '', 'INTRANET', '0016_0000000002', 'INTRANET', '0021_0000000015', '', 39, 202, '', '0023_0000000004', 155, NULL),
	('0017_0000000006', NULL, '0017_0000000006', '', NULL, 'PRDs_GZ1_PARTNER', 'umadm', '2019-07-03 12:26:42', 'umadmin', '2019-07-02 07:54:46', '', 'PARTNER', '0016_0000000002', 'PARTNER', '0021_0000000014', '', 39, 203, '', '0023_0000000005', 155, NULL),
	('0017_0000000007', NULL, '0017_0000000007', '', NULL, 'PRDs_GZ1_SF', 'umadmin', '2019-07-05 03:09:49', 'umadmin', '2019-07-02 07:56:33', 'vpc-0je6u9af', 'SF', '0016_0000000002', 'SF', '0021_0000000020', 'wecube-zone-create', 39, 58, '', '0023_0000000009', 157, 'rvjBA4092Bl');

CREATE TABLE IF NOT EXISTS `zone_design` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `idc_design` varchar(15) DEFAULT NULL COMMENT '机房设计',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `type` int(15) DEFAULT NULL COMMENT '类型',
  `zone_layer` int(15) DEFAULT NULL COMMENT '层级',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `zone_design` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `idc_design`, `state`, `type`, `zone_layer`) VALUES
	('0023_0000000001', NULL, '0023_0000000001', '互联网', NULL, 'STGs_INTERNET', 'umadmin', '2019-07-02 03:44:26', 'umadmin', '2019-07-02 03:38:54', 'INTERNET', '0022_0000000001', 141, 201, 155),
	('0023_0000000002', NULL, '0023_0000000002', '业务区域', NULL, 'STGs_CORE', 'umadmin', '2019-07-02 03:44:28', 'umadmin', '2019-07-02 03:39:29', 'CORE', '0022_0000000001', 141, 58, 157),
	('0023_0000000003', NULL, '0023_0000000003', '互联网', NULL, 'PRDs_INTERNET', 'umadmin', '2019-07-02 03:54:57', 'umadmin', '2019-07-02 03:54:57', 'INTERNET', '0022_0000000002', 141, 201, 155),
	('0023_0000000004', NULL, '0023_0000000004', '内部网', NULL, 'PRDs_INTRANET', 'umadmin', '2019-07-02 03:55:23', 'umadmin', '2019-07-02 03:55:23', 'INTRANET', '0022_0000000002', 141, 202, 155),
	('0023_0000000005', NULL, '0023_0000000005', '伙伴网', NULL, 'PRDs_PARTNERNET', 'umadmin', '2019-07-02 03:55:46', 'umadmin', '2019-07-02 03:55:46', 'PARTNERNET', '0022_0000000002', 141, 203, 155),
	('0023_0000000006', NULL, '0023_0000000006', '互联网接入区', NULL, 'PRDs_DMZ', 'umadmin', '2019-07-02 03:56:25', 'umadmin', '2019-07-02 03:56:25', 'DMZ', '0022_0000000002', 141, 55, 156),
	('0023_0000000007', NULL, '0023_0000000007', '管理工具区域', NULL, 'PRDs_MGMT', 'umadmin', '2019-07-02 03:56:56', 'umadmin', '2019-07-02 03:56:56', 'MGMT', '0022_0000000002', 141, 59, 156),
	('0023_0000000008', NULL, '0023_0000000008', '伙伴接入区', NULL, 'PRDs_ECN', 'umadmin', '2019-07-02 03:57:16', 'umadmin', '2019-07-02 03:57:16', 'ECN', '0022_0000000002', 141, 56, 156),
	('0023_0000000009', NULL, '0023_0000000009', '核心业务区', NULL, 'PRDs_SF', 'umadmin', '2019-07-02 03:57:41', 'umadmin', '2019-07-02 03:57:41', 'SF', '0022_0000000002', 141, 58, 157);

CREATE TABLE IF NOT EXISTS `zone_link` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `asset_code` varchar(50) DEFAULT NULL COMMENT '资产编码',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `name` varchar(50) DEFAULT NULL COMMENT '名称',
  `orchestration` varchar(100) DEFAULT NULL COMMENT '编排',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `zone1` varchar(15) DEFAULT NULL COMMENT '安全区域1',
  `zone2` varchar(15) DEFAULT NULL COMMENT '安全区域2',
  `zone_link_design` varchar(15) DEFAULT NULL COMMENT '安全区域连接设计',
  `biz_key` varchar(50) DEFAULT NULL COMMENT 'null',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `zone_link` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `asset_code`, `code`, `name`, `orchestration`, `state`, `zone1`, `zone2`, `zone_link_design`, `biz_key`) VALUES
	('0018_0000000001', NULL, '0018_0000000001', '', NULL, 'PRDs_GZ1_INTERNET_link_PRDs_GZ1_DMZ', 'umadm', '2019-07-03 11:05:00', 'umadmin', '2019-07-02 07:51:48', '', '', '', '', 39, '0017_0000000004', '0017_0000000001', '0024_0000000002', NULL),
	('0018_0000000002', NULL, '0018_0000000002', '', NULL, 'PRDs_GZ1_INTRANET_link_PRDs_GZ1_MGMT', 'umadmin', '2019-07-02 08:03:48', 'umadmin', '2019-07-02 07:54:07', '', '', '', '', 39, '0017_0000000005', '0017_0000000003', '0024_0000000003', NULL),
	('0018_0000000003', NULL, '0018_0000000003', '', NULL, 'PRDs_GZ1_PARTNER_link_PRDs_GZ1_ECN', 'umadmin', '2019-07-02 07:57:53', 'umadmin', '2019-07-02 07:57:53', '', '', '', '', 39, '0017_0000000006', '0017_0000000002', '0024_0000000004', NULL),
	('0018_0000000004', NULL, '0018_0000000004', '', NULL, 'PRDs_GZ1_DMZ_link_PRDs_GZ1_SF', 'umadm', '2019-07-05 03:09:49', 'umadmin', '2019-07-02 07:58:10', '', '', '', '', 39, '0017_0000000001', '0017_0000000007', '0024_0000000005', NULL),
	('0018_0000000005', NULL, '0018_0000000005', '', NULL, 'PRDs_GZ1_ECN_link_PRDs_GZ1_SF', 'umadm', '2019-07-05 03:09:49', 'umadmin', '2019-07-02 07:58:37', '', '', '', '', 39, '0017_0000000002', '0017_0000000007', '0024_0000000007', NULL),
	('0018_0000000006', NULL, '0018_0000000006', '', NULL, 'PRDs_GZ1_MGMT_link_PRDs_GZ1_SF', 'umadm', '2019-07-05 03:09:50', 'umadmin', '2019-07-02 08:05:17', '', '', '', '', 39, '0017_0000000003', '0017_0000000007', '0024_0000000006', NULL),
	('0018_0000000007', NULL, '0018_0000000007', '', NULL, 'PRDs_GZ1_MGMT_link_PRDs_GZ1_ECN', 'umadmin', '2019-07-02 08:07:10', 'umadmin', '2019-07-02 08:07:10', '', '', '', '', 39, '0017_0000000003', '0017_0000000002', '0024_0000000008', NULL),
	('0018_0000000008', NULL, '0018_0000000008', '', NULL, 'PRDs_GZ1_DMZ_link_PRDs_GZ1_MGMT', 'umadm', '2019-07-03 11:05:00', 'umadmin', '2019-07-02 08:07:29', '', '', '', '', 39, '0017_0000000001', '0017_0000000003', '0024_0000000009', NULL);

CREATE TABLE IF NOT EXISTS `zone_link_design` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前全局唯一ID',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '根全局唯一ID',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `key_name` varchar(64) DEFAULT NULL COMMENT '唯一值',
  `updated_by` varchar(64) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(64) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `zone_design1` varchar(15) DEFAULT NULL COMMENT '安全区域设计',
  `zone_design2` varchar(15) DEFAULT NULL COMMENT '安全区域设计',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `zone_link_design` (`guid`, `p_guid`, `r_guid`, `description`, `fixed_date`, `key_name`, `updated_by`, `updated_date`, `created_by`, `created_date`, `code`, `state`, `zone_design1`, `zone_design2`) VALUES
	('0024_0000000001', NULL, '0024_0000000001', '互联网接入', NULL, 'STGs_INTERNET_LINK_STGs_CORE', 'umadm', '2019-07-02 03:44:28', 'umadmin', '2019-07-02 03:39:55', '1', 141, '0023_0000000001', '0023_0000000002'),
	('0024_0000000002', NULL, '0024_0000000002', '互联网接入', NULL, 'PRDs_INTERNET_LINK_PRDs_DMZ', 'umadmin', '2019-07-02 03:58:13', 'umadmin', '2019-07-02 03:58:13', '1', 141, '0023_0000000003', '0023_0000000006'),
	('0024_0000000003', NULL, '0024_0000000003', '内部网接入', NULL, 'PRDs_INTRANET_LINK_PRDs_MGMT', 'umadmin', '2019-07-02 03:58:34', 'umadmin', '2019-07-02 03:58:34', '2', 141, '0023_0000000004', '0023_0000000007'),
	('0024_0000000004', NULL, '0024_0000000004', '伙伴网接入', NULL, 'PRDs_PARTNERNET_LINK_PRDs_ECN', 'umadmin', '2019-07-02 03:59:01', 'umadmin', '2019-07-02 03:59:01', '3', 141, '0023_0000000005', '0023_0000000008'),
	('0024_0000000005', NULL, '0024_0000000005', 'DMZ-SF', NULL, 'PRDs_DMZ_LINK_PRDs_SF', 'umadmin', '2019-07-02 03:59:26', 'umadmin', '2019-07-02 03:59:26', '4', 141, '0023_0000000006', '0023_0000000009'),
	('0024_0000000006', NULL, '0024_0000000006', 'MGMT-SF', NULL, 'PRDs_MGMT_LINK_PRDs_SF', 'umadmin', '2019-07-02 03:59:46', 'umadmin', '2019-07-02 03:59:46', '5', 141, '0023_0000000007', '0023_0000000009'),
	('0024_0000000007', NULL, '0024_0000000007', 'ECN-SF', NULL, 'PRDs_ECN_LINK_PRDs_SF', 'umadmin', '2019-07-02 04:00:13', 'umadmin', '2019-07-02 04:00:13', '6', 141, '0023_0000000008', '0023_0000000009'),
	('0024_0000000008', NULL, '0024_0000000008', 'MGMT-ECN', NULL, 'PRDs_MGMT_LINK_PRDs_ECN', 'umadmin', '2019-07-02 04:00:37', 'umadmin', '2019-07-02 04:00:37', '7', 141, '0023_0000000007', '0023_0000000008'),
	('0024_0000000009', NULL, '0024_0000000009', 'MGMT-DMZ', NULL, 'PRDs_DMZ_LINK_PRDs_MGMT', 'umadmin', '2019-07-02 04:02:00', 'umadmin', '2019-07-02 04:01:27', '8', 141, '0023_0000000006', '0023_0000000007');

CREATE TABLE IF NOT EXISTS `network_link` (
  `guid` varchar(15) NOT NULL COMMENT '全局唯一ID',
  `p_guid` varchar(15) DEFAULT NULL COMMENT '前一版本数据的guid',
  `r_guid` varchar(15) DEFAULT NULL COMMENT '原始数据guid',
  `updated_by` varchar(50) DEFAULT NULL COMMENT '更新用户',
  `updated_date` datetime DEFAULT NULL COMMENT '更新日期',
  `created_by` varchar(50) DEFAULT NULL COMMENT '创建用户',
  `created_date` datetime DEFAULT NULL COMMENT '创建日期',
  `state` int(15) DEFAULT NULL COMMENT '状态',
  `key_name` varchar(1000) DEFAULT NULL COMMENT '唯一名称',
  `fixed_date` varchar(19) DEFAULT NULL COMMENT '确认日期',
  `code` varchar(1000) DEFAULT NULL COMMENT '编码',
  `description` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `asset_id` varchar(200) DEFAULT NULL COMMENT '资产ID',
  `max_concurrent` varchar(200) DEFAULT NULL COMMENT '最大并发连接数',
  `netband_width` varchar(200) DEFAULT NULL COMMENT '网络带宽(M)',
  `network_segment_1` varchar(15) DEFAULT NULL COMMENT '网段1',
  `network_segment_2` varchar(15) DEFAULT NULL COMMENT '网段2',
  `state_code` varchar(50) DEFAULT NULL COMMENT '状态编码',
  `subnet_network_segment` varchar(15) DEFAULT NULL COMMENT '子网网段',
  `nat_table_asset_id` varchar(200) DEFAULT NULL COMMENT 'NAT表资产编码',
  PRIMARY KEY (`guid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


SET FOREIGN_KEY_CHECKS=1;
