package com.tamguo.modules.sys.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotations.KeySequence;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

@Data
@TableName(value="sys_company")
@KeySequence
public class SysCompanyEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final String ROOT_COMPANY_CODE = "0";
	public static final String TREE_CODE_COMPANY_SEPARATE = ",";
	public static final String TREE_NAME_COMPANY_SEPARATE = "/";

	@TableId
	private String companyCode;
	private String areaCode;
	private String companyName;
	private String corpCode;
	private String corpName;
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String createBy;
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date createDate;
	private String fullName;
	private String parentCode;
	private String parentCodes;
	private String remarks;
	private String status;
	private Boolean treeLeaf;
	private BigDecimal treeLevel;
	private String treeNames;
	private String treeSort;
	private String treeSorts;
	@TableField(fill = FieldFill.INSERT)
	private String updateBy;
	@TableField(fill = FieldFill.INSERT)
	private Date updateDate;
	private String viewCode;
	@TableField(exist=false)
	private String treeAreaNames;

	public String getId() {
		return companyCode;
	}
}