/*
Navicat MySQL Data Transfer

Source Server         : dev
Source Server Version : 80012
Source Host           : localhost:3306
Source Database       : tamguo_20181110

Target Server Type    : MYSQL
Target Server Version : 80012
File Encoding         : 65001

Date: 2018-12-25 11:37:05
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for b_book
-- ----------------------------
DROP TABLE IF EXISTS `b_book`;
CREATE TABLE `b_book` (
  `id` varchar(64) NOT NULL DEFAULT '' COMMENT 'ID',
  `category_id` varchar(64) NOT NULL DEFAULT '' COMMENT '分类ID',
  `book_image` varchar(255) NOT NULL DEFAULT '' COMMENT '背景图片',
  `owner` varchar(64) NOT NULL DEFAULT '' COMMENT '所属人',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '书籍',
  `seo_title` varchar(100) NOT NULL DEFAULT '' COMMENT 'seo 标题',
  `seo_keywords` varchar(255) NOT NULL DEFAULT '' COMMENT 'seo 关键字',
  `seo_description` varchar(1000) NOT NULL DEFAULT '' COMMENT 'seo 描述',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of b_book
-- ----------------------------
INSERT INTO `b_book` VALUES ('1', 'bcyy,c', '/files/tamguo.jpg', '1065071806269284353', '理科数学必修一', '理科数学必修一', '理科数学必修一', '理科数学必修一', '2018-12-06 10:05:18', '2018-12-06 10:05:18');
INSERT INTO `b_book` VALUES ('1065126653186768898', 'zxx,lishi', '/files/201811/avatar/归还店铺选择.png', '1065071806269284353', '理科数学必修一', '理科数学必修一', '理科数学必修一', '理科数学必修一', '2018-12-06 10:11:38', '2018-12-06 10:11:38');
INSERT INTO `b_book` VALUES ('1065140605992009729', 'bcyy,c', '', '1065071806269284353', 'MyBook', 'MyBook', 'MyBook', 'MyBook', '2018-12-06 10:05:32', '2018-12-06 10:05:32');
INSERT INTO `b_book` VALUES ('1065958910688444418', 'zxx,shuxue', '', '1065071806269284353', '高中语法常考点', '高中语法常考点', '高中语法常考点', '高中语法常考点', '2018-11-23 21:23:04', '2018-11-23 21:23:04');
INSERT INTO `b_book` VALUES ('1066233676301287425', 'bcyy', '', '1065071806269284353', 'Axios 中文说明', 'Axios 中文说明', 'Axios 中文说明', 'Axios 中文说明', '2018-11-24 15:34:53', '2018-11-24 15:34:53');
INSERT INTO `b_book` VALUES ('1066236400531095553', 'bcyy', '/files/201811/avatar/u=3471481518,1845750506&fm=11&gp=0.jpg', '1065071806269284353', 'Linux入门教程', 'Linux入门教程', 'Linux入门教程', 'Linux入门教程', '2018-11-26 18:53:17', '2018-11-26 18:53:17');
INSERT INTO `b_book` VALUES ('1067009988594970626', 'bcyy', '/files/201811/avatar/timg.jpg', '1065071806269284353', 'MySQL 5.1说明文档', 'MySQL 5.1说明文档', 'MySQL 5.1说明文档', 'MySQL 5.1说明文档', '2018-11-26 18:59:40', '2018-11-26 18:59:40');
INSERT INTO `b_book` VALUES ('1067315901956567041', 'bcyy', '/files/201811/avatar/spring.jpg', '1065071806269284353', '关于Spring的思考', '关于Spring的思考', '关于Spring的思考', '关于Spring的思考', '2018-11-27 15:15:35', '2018-11-27 15:15:35');
INSERT INTO `b_book` VALUES ('1067593780321792001', 'bcyy', '', '1065071806269284353', 'AOP 的利器：ASM 3.0 介绍', 'AOP 的利器：ASM 3.0 介绍', 'AOP 的利器：ASM 3.0 介绍', 'AOP 的利器：ASM 3.0 介绍', '2018-11-28 09:39:27', '2018-11-28 09:39:27');
INSERT INTO `b_book` VALUES ('1069448618760417281', 'zxx,shuxue', '', '1065071806269284353', '人教版高中必修一', '人教版高中必修一', '人教版高中必修一', '人教版高中必修一', '2018-12-03 12:29:55', '2018-12-03 12:29:55');

-- ----------------------------
-- Table structure for b_book_category
-- ----------------------------
DROP TABLE IF EXISTS `b_book_category`;
CREATE TABLE `b_book_category` (
  `id` varchar(64) NOT NULL DEFAULT '' COMMENT 'ID',
  `parent_id` varchar(64) NOT NULL COMMENT '父级编号',
  `parent_ids` varchar(1000) NOT NULL COMMENT '所有父级编号',
  `tree_sort` decimal(10,0) NOT NULL COMMENT '本级排序号（升序）',
  `tree_sorts` varchar(1000) NOT NULL COMMENT '所有级别排序号',
  `tree_leaf` char(1) NOT NULL COMMENT '是否最末级',
  `tree_level` decimal(4,0) NOT NULL COMMENT '层次级别',
  `tree_names` varchar(1000) NOT NULL COMMENT '全节点名',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '名称',
  `seo_title` varchar(100) NOT NULL DEFAULT '' COMMENT 'seo 标题',
  `seo_keywords` varchar(255) NOT NULL DEFAULT '' COMMENT 'seo 关键字',
  `seo_description` varchar(1000) NOT NULL DEFAULT '' COMMENT 'seo 描述',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of b_book_category
-- ----------------------------
INSERT INTO `b_book_category` VALUES ('bcyy', '0', '0,bcyy,', '50', '0000000050,500000000,', '0', '1', '编程语言/编程语言', '编程语言', '专业的编程书籍托管平台 - 探书网', '文档说明、官方文档、技术文档、专业文档、开发手册、api手册、在线文档', 'book.tamguo.com 是一个面向程序员的书籍托管平台，提供书籍 、文章、博客、章节、在线文档、开发手册、文档说明、分享、打印、下载服务', '2018-11-20 17:52:25', '2018-11-20 17:52:27');
INSERT INTO `b_book_category` VALUES ('c', 'bcyy', '0,bcyy,c', '80', '0000000080,800000000,', '1', '2', '编程语言/编程语言/c', 'c语言', 'c语言', 'c语言', 'c语言', '2018-11-27 14:44:29', '2018-11-27 14:44:48');
INSERT INTO `b_book_category` VALUES ('c++', 'bcyy', '0,bcyy,c++', '90', '0000000090,900000000,', '1', '2', '编程语言/编程语言/c++', 'c++', 'c++', 'c++', 'c++', '2018-11-27 14:46:03', '2018-11-27 14:46:07');
INSERT INTO `b_book_category` VALUES ('huaxue', 'zxx', '0,zxx,huaxue', '70', '0000000070,700000000,', '0', '1', '高考/高考/化学', '化学', '化学', '化学', '化学', '2018-11-27 15:08:47', '2018-11-27 15:08:50');
INSERT INTO `b_book_category` VALUES ('java', 'bcyy', '0,bcyy,java', '60', '0000000060,600000000,', '1', '2', '编程语言/编程语言/java', 'java', 'java', 'java', 'java', '2018-11-27 14:41:22', '2018-11-27 14:41:24');
INSERT INTO `b_book_category` VALUES ('javascript', 'bcyy', '0,bcyy,javascript', '110', '00000000110,1100000000,', '1', '2', '编程语言/编程语言/javascript', 'javascript', 'javascript', 'javascript', 'javascript', '2018-11-27 14:49:07', '2018-11-27 14:49:09');
INSERT INTO `b_book_category` VALUES ('lishi', 'gaokao', '0,gaokao,lishi', '100', '00000000100,1000000000,', '0', '1', '高考/高考/历史', '历史', '历史', '历史', '历史', '2018-11-27 15:11:43', '2018-11-27 15:11:45');
INSERT INTO `b_book_category` VALUES ('mssqlserver', 'sjk', '0,sjk,mssqlserver', '80', '0000000080,800000000,', '1', '2', '数据库/数据库/mssqlserver', 'mssqlserver', 'mssqlserver', 'mssqlserver', 'mssqlserver', '2018-11-27 15:00:49', '2018-11-27 15:00:51');
INSERT INTO `b_book_category` VALUES ('mysql', 'sjk', '0,sjk,mysql', '60', '0000000060,600000000,', '1', '2', '数据库/数据库/mysql', 'mysql', 'mysql', 'mysql', 'mysql', '2018-11-27 14:56:43', '2018-11-27 14:56:45');
INSERT INTO `b_book_category` VALUES ('oracle', 'sjk', '0,sjk,mysql', '70', '0000000070,700000000,', '1', '2', '数据库/数据库/oracle', 'oracle', 'oracle', 'oracle', 'oracle', '2018-11-27 14:57:41', '2018-11-27 14:57:44');
INSERT INTO `b_book_category` VALUES ('php', 'bcyy', '0,bcyy,php', '70', '0000000070,700000000,', '1', '2', '编程语言/编程语言/php', 'php', 'php', 'php', 'php', '2018-11-27 14:43:47', '2018-11-27 14:43:50');
INSERT INTO `b_book_category` VALUES ('python', 'bcyy', '0,bcyy,python', '100', '00000000100,1000000000,', '1', '2', '编程语言/编程语言/python', 'python', 'python', 'python', 'python', '2018-11-27 14:47:33', '2018-11-27 14:47:36');
INSERT INTO `b_book_category` VALUES ('shengwu', 'zxx', '0,zxx,shengwu', '90', '0000000090,900000000,', '0', '1', '高考/高考/生物', '生物', '生物', '生物', '生物', '2018-11-27 15:10:43', '2018-11-27 15:10:45');
INSERT INTO `b_book_category` VALUES ('shuxue', 'zxx', '0,zxx,shuxue', '50', '0000000050,500000000,', '0', '1', '高考/高考/数学', '数学', '数学', '数学', '数学', '2018-11-27 15:06:23', '2018-11-27 15:06:25');
INSERT INTO `b_book_category` VALUES ('sjk', '0', '0,sjk,', '50', '0000000050,500000000,', '0', '1', '数据库/数据库', '数据库', '专业的数据库书籍托管平台 - 探书网', 'mysql官方文档、oracle官方文档、文档说明、官方文档、技术文档、专业文档、开发手册、api手册、在线文档', 'book.tamguo.com 是一个DBA的书籍托管平台，提供书籍 、文章、博客、章节、在线文档、开发手册、文档说明、分享、打印、下载服务', '2018-11-27 14:55:32', '2018-11-27 14:55:34');
INSERT INTO `b_book_category` VALUES ('yingyu', 'zxx', '0,zxx,yingyu', '80', '0000000080,800000000,', '0', '1', '高考/高考/英语', '英语', '英语', '语音', '英语', '2018-11-27 15:09:52', '2018-11-27 15:09:54');
INSERT INTO `b_book_category` VALUES ('yuwen', 'zxx', '0,zxx,yuwen', '60', '0000000060,600000000,', '0', '1', '高考/高考/语文', '语文', '语文', '语文', '语文', '2018-11-27 15:07:26', '2018-11-27 15:07:30');
INSERT INTO `b_book_category` VALUES ('zxx', '0', '0,zxx,', '40', '0000000040,400000000,', '0', '1', '中小学/中小学', '中小学', '专业的中小学书籍托管平台 - 探书网', '书籍管理、章节管理、知识点管理、真题解析、试卷管理、专业文档', 'book.tamguo.com 是一个面向中小学学生的书籍托管平台，提供书籍 、文章、博客、章节、试卷分析、试题分析、知识点分享、打印、下载服务', '2018-11-13 14:04:21', '2018-11-13 14:04:23');

-- ----------------------------
-- Table structure for b_document
-- ----------------------------
DROP TABLE IF EXISTS `b_document`;
CREATE TABLE `b_document` (
  `id` varchar(64) NOT NULL DEFAULT '' COMMENT 'ID',
  `batch_no` varchar(64) NOT NULL DEFAULT '' COMMENT '批次号',
  `parent_id` varchar(64) NOT NULL DEFAULT '' COMMENT '父级ID',
  `book_id` varchar(64) NOT NULL DEFAULT '' COMMENT '书籍ID',
  `is_open` varchar(1) NOT NULL DEFAULT '' COMMENT '是否打开',
  `content` longtext COMMENT '内容',
  `markdown` longtext COMMENT 'Markdown',
  `owner` varchar(64) NOT NULL DEFAULT '' COMMENT '所属人',
  `name` varchar(100) NOT NULL DEFAULT '' COMMENT '名称',
  `status` varchar(10) NOT NULL DEFAULT '' COMMENT '状态',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of b_document
-- ----------------------------

-- ----------------------------
-- Table structure for b_file_entity
-- ----------------------------
DROP TABLE IF EXISTS `b_file_entity`;
CREATE TABLE `b_file_entity` (
  `file_id` varchar(64) NOT NULL COMMENT '文件编号',
  `file_md5` varchar(64) NOT NULL COMMENT '文件MD5',
  `file_path` varchar(1000) NOT NULL COMMENT '文件相对路径',
  `file_content_type` varchar(200) NOT NULL COMMENT '文件内容类型',
  `file_extension` varchar(100) NOT NULL COMMENT '文件后缀扩展名',
  `file_size` decimal(38,0) NOT NULL COMMENT '文件大小(单位B)',
  PRIMARY KEY (`file_id`),
  UNIQUE KEY `file_md5` (`file_md5`),
  KEY `idx_sys_file_entity_md5` (`file_md5`),
  KEY `idx_sys_file_entity_size` (`file_size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文件实体表';

-- ----------------------------
-- Records of b_file_entity
-- ----------------------------
INSERT INTO `b_file_entity` VALUES ('1062631872539299841', '4d9a6eb8234246940e23f43310b7bd37', 'book/201811/1/空间地理.png', 'image/png', '空间地理.png', '7887');
INSERT INTO `b_file_entity` VALUES ('1062639462757306370', '4dba5693b540e7a8b2f5cfd2a85d3f83', 'book/201811/1/2017-5.png', 'image/png', '2017-5.png', '25776');
INSERT INTO `b_file_entity` VALUES ('1062640066862911490', 'ef1266f7d16ae3db3acd1ae8dd103afa', 'book/201811/1/数学直播课.png', 'image/png', '数学直播课.png', '9000');
INSERT INTO `b_file_entity` VALUES ('1062640500084183041', '9a4c2462ba272ff7228098b807831eee', 'book/201811/1/qrcode.png', 'image/png', 'qrcode.png', '6149');
INSERT INTO `b_file_entity` VALUES ('1062640540500496385', '3894c9c800fc141f22f12d25e278c536', 'book/201811/1/历史.png', 'image/png', '历史.png', '11907');
INSERT INTO `b_file_entity` VALUES ('1062648328958144514', '73757cebb583756e55ebacabeb0a985a', 'book/201811/1/物理.png', 'image/png', '物理.png', '16865');
INSERT INTO `b_file_entity` VALUES ('1062650487510548481', '2f1dde121cb6db5b0b26376e692b4a79', 'book/201811/1/f.txt', 'text/plain', 'f.txt', '12755');
INSERT INTO `b_file_entity` VALUES ('1062650543143796737', '7f436f1d37c3e5df3b193e339e7080f4', 'book/201811/1/蜘蛛.png', 'image/png', '蜘蛛.png', '8266');
INSERT INTO `b_file_entity` VALUES ('1065126645330837505', '73414ca181389f7afd14ef4a3bce4286', '201811/avatar/归还店铺选择.png', 'image/png', '归还店铺选择.png', '240438');
INSERT INTO `b_file_entity` VALUES ('1065141062659440642', 'eb45aa05317a066056bb11f5be9a3e9e', 'book/201811/1065140605992009729/feignClient.png', 'image/png', 'feignClient.png', '118903');
INSERT INTO `b_file_entity` VALUES ('1067002610306166785', '870522fab5e010eb846863b87f304389', '201811/avatar/11.png', 'image/png', '11.png', '232447');
INSERT INTO `b_file_entity` VALUES ('1067002776589348865', '008d665381cf960482f542d2d040b5b7', '201811/avatar/3.png', 'image/png', '3.png', '264739');
INSERT INTO `b_file_entity` VALUES ('1067002805249028097', '3971ef5e2f23dee5ada3c564224fcc74', '201811/avatar/15.png', 'image/png', '15.png', '282625');
INSERT INTO `b_file_entity` VALUES ('1067006565044166657', 'd245b42e9a32125110d52f525b92ceff', '201811/avatar/u=3471481518,1845750506&fm=11&gp=0.jpg', 'image/jpeg', 'u=3471481518,1845750506&fm=11&gp=0.jpg', '18603');

-- ----------------------------
-- Table structure for b_file_upload
-- ----------------------------
DROP TABLE IF EXISTS `b_file_upload`;
CREATE TABLE `b_file_upload` (
  `id` varchar(64) NOT NULL COMMENT '编号',
  `file_id` varchar(64) NOT NULL COMMENT '文件编号',
  `file_name` varchar(500) NOT NULL COMMENT '文件名称',
  `file_type` varchar(20) NOT NULL DEFAULT '' COMMENT '文件分类（image、media、file）',
  `biz_key` varchar(64) DEFAULT NULL COMMENT '业务主键',
  `biz_type` varchar(64) DEFAULT NULL COMMENT '业务类型',
  `status` varchar(10) NOT NULL DEFAULT '0' COMMENT '状态（0正常 1删除 2停用）',
  `create_by` varchar(64) NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `update_by` varchar(64) NOT NULL COMMENT '更新者',
  `update_date` datetime NOT NULL COMMENT '更新时间',
  `remarks` varchar(500) DEFAULT NULL COMMENT '备注信息',
  PRIMARY KEY (`id`),
  KEY `idx_sys_file_biz_ft` (`file_type`),
  KEY `idx_sys_file_biz_fi` (`file_id`),
  KEY `idx_sys_file_biz_status` (`status`),
  KEY `idx_sys_file_biz_cb` (`create_by`),
  KEY `idx_sys_file_biz_ud` (`update_date`),
  KEY `idx_sys_file_biz_bt` (`biz_type`),
  KEY `idx_sys_file_biz_bk` (`biz_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文件上传表';

-- ----------------------------
-- Records of b_file_upload
-- ----------------------------
INSERT INTO `b_file_upload` VALUES ('1062648329138499586', '1062648328958144514', '物理.png', 'image/png', '1', 'document', 'normal', 'system', '2018-11-14 18:07:59', 'system', '2018-11-14 18:07:59', null);

-- ----------------------------
-- Table structure for crawler_book
-- ----------------------------
DROP TABLE IF EXISTS `crawler_book`;
CREATE TABLE `crawler_book` (
  `id` varchar(192) DEFAULT NULL,
  `book_url` varchar(500) DEFAULT NULL,
  `book_uid` varchar(192) DEFAULT NULL,
  `orders` int(10) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of crawler_book
-- ----------------------------

-- ----------------------------
-- Table structure for crawler_chapter
-- ----------------------------
DROP TABLE IF EXISTS `crawler_chapter`;
CREATE TABLE `crawler_chapter` (
  `id` varchar(64) NOT NULL,
  `chapter_url` varchar(500) NOT NULL COMMENT '科目URL',
  `chapter_uid` varchar(64) NOT NULL DEFAULT '' COMMENT '对应的科目ID',
  `course_uid` varchar(64) NOT NULL COMMENT '科目ID',
  `subject_uid` varchar(64) NOT NULL DEFAULT '' COMMENT '科目',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of crawler_chapter
-- ----------------------------

-- ----------------------------
-- Table structure for crawler_question
-- ----------------------------
DROP TABLE IF EXISTS `crawler_question`;
CREATE TABLE `crawler_question` (
  `id` varchar(64) NOT NULL DEFAULT '' COMMENT 'UID',
  `question_url` varchar(500) NOT NULL DEFAULT '' COMMENT '题目URL',
  `chapter_id` varchar(64) NOT NULL DEFAULT '' COMMENT '题目对应章节',
  `status` varchar(1) NOT NULL DEFAULT '0' COMMENT '是否爬取',
  PRIMARY KEY (`id`),
  KEY `index_question_url` (`question_url`(333)) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of crawler_question
-- ----------------------------
INSERT INTO `crawler_question` VALUES ('1025991497427124226', 'https://tiku.baidu.com/tikupc/singledetail/007a168884868762caaed506', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991497615867905', 'https://tiku.baidu.com/tikupc/singledetail/8c5b01f69e3143323968932f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991497733308420', 'https://tiku.baidu.com/tikupc/singledetail/263210a6f524ccbff121842f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991497733308418', 'https://tiku.baidu.com/tikupc/singledetail/57230722192e45361066f501', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991497968189442', 'https://tiku.baidu.com/tikupc/singledetail/8eec89eb172ded630b1cb62e', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991498177904642', 'https://tiku.baidu.com/tikupc/singledetail/c906a6c30c22590102029d03', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991498177904643', 'https://tiku.baidu.com/tikupc/singledetail/cdc10c225901020207409c07', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991498270179329', 'https://tiku.baidu.com/tikupc/singledetail/84f06f1aff00bed5b9f31d2e', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991498333093891', 'https://tiku.baidu.com/tikupc/singledetail/2c315a8102d276a200292e07', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991498333093890', 'https://tiku.baidu.com/tikupc/singledetail/14eb9ec3d5bbfd0a79567328', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991498333093889', 'https://tiku.baidu.com/tikupc/singledetail/132ebed5b9f3f90f76c61b2b', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991498605723649', 'https://tiku.baidu.com/tikupc/singledetail/29ff28ea81c758f5f61f672f', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991498651860994', 'https://tiku.baidu.com/tikupc/singledetail/152f90c69ec3d5bbfd0a742f', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991498819633153', 'https://tiku.baidu.com/tikupc/singledetail/02b469dc5022aaea998f0f01', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991498094018562', 'https://tiku.baidu.com/tikupc/singledetail/1be9d5bbfd0a79563c1e722f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991498899324929', 'https://tiku.baidu.com/tikupc/singledetail/f919c281e53a580216fcfe01', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991498899324931', 'https://tiku.baidu.com/tikupc/singledetail/32fa49649b6648d7c1c7462f', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991498987405314', 'https://tiku.baidu.com/tikupc/singledetail/9a703b3567ec102de2bd8929', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991499083874305', 'https://tiku.baidu.com/tikupc/singledetail/d004e87101f69e3143329406', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991498899324930', 'https://tiku.baidu.com/tikupc/singledetail/5407ed630b1c59eef8c7b42f', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991498681221121', 'https://tiku.baidu.com/tikupc/singledetail/ec81dd3383c4bb4cf7ecd12a', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991499260035074', 'https://tiku.baidu.com/tikupc/singledetail/4fa3680203d8ce2f0066232f', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991499260035073', 'https://tiku.baidu.com/tikupc/singledetail/1bd2700abb68a98271fefa2b', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991499301978115', 'https://tiku.baidu.com/tikupc/singledetail/53587e21af45b307e8719735', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991499301978114', 'https://tiku.baidu.com/tikupc/singledetail/8e024b73f242336c1eb95e2f', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991499356504066', 'https://tiku.baidu.com/tikupc/singledetail/64213169a45177232f60a20f', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991499385864194', 'https://tiku.baidu.com/tikupc/singledetail/20e8551810a6f524ccbf8507', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991499385864193', 'https://tiku.baidu.com/tikupc/singledetail/e2062af90242a8956bece42e', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991499415224321', 'https://tiku.baidu.com/tikupc/singledetail/16621ed9ad51f01dc281f101', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991499503304708', 'https://tiku.baidu.com/tikupc/singledetail/1c2ceff9aef8941ea76e052f', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991499503304707', 'https://tiku.baidu.com/tikupc/singledetail/0bd9a58da0116c175f0e4806', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991499503304706', 'https://tiku.baidu.com/tikupc/singledetail/0931a417866fb84ae45c8d41', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991499503304709', 'https://tiku.baidu.com/tikupc/singledetail/fa63b84ae45c3b3567ec8b09', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991499616550914', 'https://tiku.baidu.com/tikupc/singledetail/142252ea551810a6f5248629', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991499817877508', 'https://tiku.baidu.com/tikupc/singledetail/0411192e453610661ed9f436', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991499817877506', 'https://tiku.baidu.com/tikupc/singledetail/a0ad8762caaedd3383c4d32e', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991499817877507', 'https://tiku.baidu.com/tikupc/singledetail/83e80508763231126edb1123', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991499616550915', 'https://tiku.baidu.com/tikupc/singledetail/9107e2bd960590c69ec3762f', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991499733991426', 'https://tiku.baidu.com/tikupc/singledetail/41234b35eefdc8d376ee3203', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991499889180673', 'https://tiku.baidu.com/tikupc/singledetail/60bb960590c69ec3d5bb7503', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991499889180674', 'https://tiku.baidu.com/tikupc/singledetail/0052168884868762caaed52e', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991499914346498', 'https://tiku.baidu.com/tikupc/singledetail/64763169a45177232f60a258', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991499914346499', 'https://tiku.baidu.com/tikupc/singledetail/a53da32d7375a417866f8f0e', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991500111478786', 'https://tiku.baidu.com/tikupc/singledetail/6842be1e650e52ea55189807', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991500111478787', 'https://tiku.baidu.com/tikupc/singledetail/9f6b1eb91a37f111f1855b02', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991500111478785', 'https://tiku.baidu.com/tikupc/singledetail/d8116edb6f1aff00bed51e06', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991500237307906', 'https://tiku.baidu.com/tikupc/singledetail/c57ae45c3b3567ec102d8a35', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991500237307905', 'https://tiku.baidu.com/tikupc/singledetail/6ec62cc58bd63186bcebbc06', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991500237307907', 'https://tiku.baidu.com/tikupc/singledetail/13e458f5f61fb7360b4c6526', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991500350554114', 'https://tiku.baidu.com/tikupc/singledetail/e9dd7c1cfad6195f312ba62e', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991500384108546', 'https://tiku.baidu.com/tikupc/singledetail/cc7a27284b73f242336c5f02', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991500384108547', 'https://tiku.baidu.com/tikupc/singledetail/fa64b84ae45c3b3567ec8b0e', '1025991495598407681', '0');
INSERT INTO `crawler_question` VALUES ('1025991500467994626', 'https://tiku.baidu.com/tikupc/singledetail/ae225f0e7cd184254b353530', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991500467994627', 'https://tiku.baidu.com/tikupc/singledetail/6caa7f21af45b307e87197c7', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991500384108545', 'https://tiku.baidu.com/tikupc/singledetail/0426192e453610661ed9f401', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991500497354753', 'https://tiku.baidu.com/tikupc/singledetail/b9c081c758f5f61fb736662f', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991500543492097', 'https://tiku.baidu.com/tikupc/singledetail/75264a7302768e9951e7382e', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991500639961090', 'https://tiku.baidu.com/tikupc/singledetail/3ddc240c844769eae009ed0a', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991500639961089', 'https://tiku.baidu.com/tikupc/singledetail/8dafeefdc8d376eeaeaa319f', '1025991495598407681', '0');
INSERT INTO `crawler_question` VALUES ('1025991500639961091', 'https://tiku.baidu.com/tikupc/singledetail/df15866fb84ae45c3b358c07', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991500707069954', 'https://tiku.baidu.com/tikupc/singledetail/e2b0f342336c1eb91a375dc6', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991500774178817', 'https://tiku.baidu.com/tikupc/singledetail/4fb5680203d8ce2f00662339', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991500853870594', 'https://tiku.baidu.com/tikupc/singledetail/6231b7360b4c2e3f5727632b', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991500883230723', 'https://tiku.baidu.com/tikupc/singledetail/8e6ca26925c52cc58bd6be14', '1025991495598407681', '0');
INSERT INTO `crawler_question` VALUES ('1025991500883230722', 'https://tiku.baidu.com/tikupc/singledetail/1cc1aef8941ea76e58fa043d', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991500350554115', 'https://tiku.baidu.com/tikupc/singledetail/82eb9b89680203d8ce2f2409', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991500975505410', 'https://tiku.baidu.com/tikupc/singledetail/cc6327284b73f242336c5f1b', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991501189414914', 'https://tiku.baidu.com/tikupc/singledetail/afd4fab069dc5022aaea002b', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991501147471874', 'https://tiku.baidu.com/tikupc/singledetail/6497a55177232f60ddcca1fb', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991501189414915', 'https://tiku.baidu.com/tikupc/singledetail/0967a417866fb84ae45c8d17', '1025991495598407681', '0');
INSERT INTO `crawler_question` VALUES ('1025991500933562369', 'https://tiku.baidu.com/tikupc/singledetail/a24cfe4733687e21af45a906', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991501399130115', 'https://tiku.baidu.com/tikupc/singledetail/ee0f580216fc700abb68fc30', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991501399130114', 'https://tiku.baidu.com/tikupc/singledetail/a17e33687e21af45b307a83c', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991501474627586', 'https://tiku.baidu.com/tikupc/singledetail/1d916294dd88d0d233d46a7f', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991501537542146', 'https://tiku.baidu.com/tikupc/singledetail/1980ad51f01dc281e53af05c', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991501537542147', 'https://tiku.baidu.com/tikupc/singledetail/5e2af18583d049649b66583e', '1025991495598407681', '0');
INSERT INTO `crawler_question` VALUES ('1025991501537542148', 'https://tiku.baidu.com/tikupc/singledetail/6c010740be1e650e52ea9906', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991501537542149', 'https://tiku.baidu.com/tikupc/singledetail/330848649b6648d7c1c746dd', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991501734674436', 'https://tiku.baidu.com/tikupc/singledetail/13ed58f5f61fb7360b4c652f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991501734674437', 'https://tiku.baidu.com/tikupc/singledetail/5941336c1eb91a37f1115c06', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991501734674435', 'https://tiku.baidu.com/tikupc/singledetail/53657e21af45b307e8719708', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991501734674434', 'https://tiku.baidu.com/tikupc/singledetail/879fda38376baf1ffc4fad56', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991501634011138', 'https://tiku.baidu.com/tikupc/singledetail/5895ec3a87c24028915fc315', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991501856309249', 'https://tiku.baidu.com/tikupc/singledetail/fb6e760bf78a6529647d5390', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991501856309250', 'https://tiku.baidu.com/tikupc/singledetail/cbdbf61fb7360b4c2e3f642b', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991502066024450', 'https://tiku.baidu.com/tikupc/singledetail/9267f7ec4afe04a1b071de2e', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991501982138372', 'https://tiku.baidu.com/tikupc/singledetail/d271f78a6529647d2728527f', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991501982138370', 'https://tiku.baidu.com/tikupc/singledetail/cc5727284b73f242336c5f2f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991501982138371', 'https://tiku.baidu.com/tikupc/singledetail/140052ea551810a6f524860b', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991502103773186', 'https://tiku.baidu.com/tikupc/singledetail/1367852458fb770bf78a552c', '1025991496621817858', '0');
INSERT INTO `crawler_question` VALUES ('1025991502170882050', 'https://tiku.baidu.com/tikupc/singledetail/dd19bd64783e0912a2162a35', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991502170882049', 'https://tiku.baidu.com/tikupc/singledetail/fc2fba4ae45c3b3567ec8b45', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991502338654213', 'https://tiku.baidu.com/tikupc/singledetail/a25cfe4733687e21af45a916', '1025991496621817858', '0');
INSERT INTO `crawler_question` VALUES ('1025991502338654210', 'https://tiku.baidu.com/tikupc/singledetail/952bb52acfc789eb172dc82e', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991502338654212', 'https://tiku.baidu.com/tikupc/singledetail/6128a76e58fafab069dc0233', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991502338654211', 'https://tiku.baidu.com/tikupc/singledetail/0bf0a58da0116c175f0e482f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991502380597250', 'https://tiku.baidu.com/tikupc/singledetail/d84cf5335a8102d276a22f2f', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991502477066242', 'https://tiku.baidu.com/tikupc/singledetail/e9fd7c1cfad6195f312ba60e', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991502477066244', 'https://tiku.baidu.com/tikupc/singledetail/64b29e3143323968011c9241', '1025991496621817858', '0');
INSERT INTO `crawler_question` VALUES ('1025991502477066245', 'https://tiku.baidu.com/tikupc/singledetail/cbc0172ded630b1c59eeb52e', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991502556758017', 'https://tiku.baidu.com/tikupc/singledetail/5cb351e79b89680203d8252f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991502594506753', 'https://tiku.baidu.com/tikupc/singledetail/0070168884868762caaed50c', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991502594506754', 'https://tiku.baidu.com/tikupc/singledetail/412e4b35eefdc8d376ee320e', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991502724530179', 'https://tiku.baidu.com/tikupc/singledetail/b9a971fe910ef12d2af9e72e', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991502724530178', 'https://tiku.baidu.com/tikupc/singledetail/a9480b1c59eef8c75fbfb32e', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991502682587137', 'https://tiku.baidu.com/tikupc/singledetail/6110a76e58fafab069dc020b', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991502724530180', 'https://tiku.baidu.com/tikupc/singledetail/5cae51e79b89680203d82532', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991502829387778', 'https://tiku.baidu.com/tikupc/singledetail/82cd9b89680203d8ce2f242f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991502900690945', 'https://tiku.baidu.com/tikupc/singledetail/9e3131126edb6f1aff001f06', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991502900690946', 'https://tiku.baidu.com/tikupc/singledetail/6fd4d15abe23482fb4da4c09', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991502900690948', 'https://tiku.baidu.com/tikupc/singledetail/64fb9e3143323968011c9208', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991502829387780', 'https://tiku.baidu.com/tikupc/singledetail/9e3531126edb6f1aff001f02', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991503001354242', 'https://tiku.baidu.com/tikupc/singledetail/952cb52acfc789eb172dc829', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991503001354241', 'https://tiku.baidu.com/tikupc/singledetail/5cfa961ea76e58fafab00307', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991503110406145', 'https://tiku.baidu.com/tikupc/singledetail/67e4a1c7aa00b52acfc7ca2e', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991503110406147', 'https://tiku.baidu.com/tikupc/singledetail/e9e67c1cfad6195f312ba615', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991503110406146', 'https://tiku.baidu.com/tikupc/singledetail/abefbb4cf7ec4afe04a1df2e', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991503110406148', 'https://tiku.baidu.com/tikupc/singledetail/8d0deefdc8d376eeaeaa313d', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991502724530177', 'https://tiku.baidu.com/tikupc/singledetail/52106429647d27284b73519f', '1025991496621817858', '0');
INSERT INTO `crawler_question` VALUES ('1025991503194292225', 'https://tiku.baidu.com/tikupc/singledetail/18ebbb1aa8114431b90dd8e2', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991503219458049', 'https://tiku.baidu.com/tikupc/singledetail/6010590102020740be1e9b37', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991503219458050', 'https://tiku.baidu.com/tikupc/singledetail/19ddad51f01dc281e53af001', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991503219458052', 'https://tiku.baidu.com/tikupc/singledetail/f90ec281e53a580216fcfe16', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991503194292226', 'https://tiku.baidu.com/tikupc/singledetail/1303bed5b9f3f90f76c61b06', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991503219458051', 'https://tiku.baidu.com/tikupc/singledetail/f226fc4ffe4733687e21aa3c', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991503349481473', 'https://tiku.baidu.com/tikupc/singledetail/f501cfc789eb172ded63b72e', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991503668248578', 'https://tiku.baidu.com/tikupc/singledetail/2e17fad6195f312b3169a50e', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991503668248579', 'https://tiku.baidu.com/tikupc/singledetail/a555f01dc281e53a5802ff01', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991503827632131', 'https://tiku.baidu.com/tikupc/singledetail/1908ba1aa8114431b90dd801', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991503840215042', 'https://tiku.baidu.com/tikupc/singledetail/536c7e21af45b307e8719701', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991500623183873', 'https://tiku.baidu.com/tikupc/singledetail/f932c281e53a580216fcfe2a', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991504024764419', 'https://tiku.baidu.com/tikupc/singledetail/47126bd97f1922791688e80c', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991504024764417', 'https://tiku.baidu.com/tikupc/singledetail/90fcba0d4a7302768e99390e', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991503827632130', 'https://tiku.baidu.com/tikupc/singledetail/2f382f60ddccda38376baf1e', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991503890546689', 'https://tiku.baidu.com/tikupc/singledetail/5aa6941ea76e58fafab0035b', '1025991495598407681', '0');
INSERT INTO `crawler_question` VALUES ('1025991504024764418', 'https://tiku.baidu.com/tikupc/singledetail/4e3759eef8c75fbfc77db22e', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991504104456195', 'https://tiku.baidu.com/tikupc/singledetail/7663ddccda38376baf1fae06', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991504104456196', 'https://tiku.baidu.com/tikupc/singledetail/0072168884868762caaed50e', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991504196730882', 'https://tiku.baidu.com/tikupc/singledetail/ed6d27d3240c844769eaee0d', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991504163176449', 'https://tiku.baidu.com/tikupc/singledetail/1fe3f8c75fbfc77da269b108', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991504230285314', 'https://tiku.baidu.com/tikupc/singledetail/6382ce22bcd126fff7050b08', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991504259645442', 'https://tiku.baidu.com/tikupc/singledetail/8084366baf1ffc4ffe47acb9', '1025991495598407681', '0');
INSERT INTO `crawler_question` VALUES ('1025991504268034049', 'https://tiku.baidu.com/tikupc/singledetail/611aa76e58fafab069dc0201', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991504268034050', 'https://tiku.baidu.com/tikupc/singledetail/47306bd97f1922791688e82e', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991502900690947', 'https://tiku.baidu.com/tikupc/singledetail/0beca58da0116c175f0e4833', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991504469360643', 'https://tiku.baidu.com/tikupc/singledetail/91a630126edb6f1aff001f91', '1025991495598407681', '0');
INSERT INTO `crawler_question` VALUES ('1025991504469360644', 'https://tiku.baidu.com/tikupc/singledetail/1c2bd680d4d8d15abe234e2c', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991504314171395', 'https://tiku.baidu.com/tikupc/singledetail/abf3bb4cf7ec4afe04a1df32', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991504469360642', 'https://tiku.baidu.com/tikupc/singledetail/61126c175f0e7cd184253606', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991504515497986', 'https://tiku.baidu.com/tikupc/singledetail/3dd7240c844769eae009ed01', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991504104456194', 'https://tiku.baidu.com/tikupc/singledetail/adcc5e0e7cd184254b3535de', '1025991496621817858', '0');
INSERT INTO `crawler_question` VALUES ('1025991504557441025', 'https://tiku.baidu.com/tikupc/singledetail/2f34b1717fd5360cba1adb90', '1025991495598407681', '0');
INSERT INTO `crawler_question` VALUES ('1025991504616161283', 'https://tiku.baidu.com/tikupc/singledetail/987f69eae009581b6bd9eb3d', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991504616161282', 'https://tiku.baidu.com/tikupc/singledetail/3ed20242a8956bec0975e32e', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991504616161281', 'https://tiku.baidu.com/tikupc/singledetail/4880b1d528ea81c758f57801', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991503907323906', 'https://tiku.baidu.com/tikupc/singledetail/49eeb8f67c1cfad6195fa703', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991504666492930', 'https://tiku.baidu.com/tikupc/singledetail/3ed50242a8956bec0975e329', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991504314171394', 'https://tiku.baidu.com/tikupc/singledetail/c546e45c3b3567ec102d8a09', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991504741990401', 'https://tiku.baidu.com/tikupc/singledetail/11b1c884b9d528ea81c779ff', '1025991495598407681', '0');
INSERT INTO `crawler_question` VALUES ('1025991504771350529', 'https://tiku.baidu.com/tikupc/singledetail/41bd83d049649b6648d7473d', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991504771350530', 'https://tiku.baidu.com/tikupc/singledetail/5c0a1efc700abb68a982fb0d', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991504771350531', 'https://tiku.baidu.com/tikupc/singledetail/83cd0508763231126edb1106', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991504872013827', 'https://tiku.baidu.com/tikupc/singledetail/cdef0c225901020207409c29', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991504872013826', 'https://tiku.baidu.com/tikupc/singledetail/bfe8aeaad1f34693daef3e03', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991505023008770', 'https://tiku.baidu.com/tikupc/singledetail/99834431b90d6c85ec3ac697', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991504381280257', 'https://tiku.baidu.com/tikupc/singledetail/115e872458fb770bf78a5515', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991505236918274', 'https://tiku.baidu.com/tikupc/singledetail/e954dbbbfd0a79563c1e7292', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991505236918276', 'https://tiku.baidu.com/tikupc/singledetail/bd3a03d8ce2f0066f533223d', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991504469360645', 'https://tiku.baidu.com/tikupc/singledetail/a11433687e21af45b307a856', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991505366941697', 'https://tiku.baidu.com/tikupc/singledetail/a249caaedd3383c4bb4cd22e', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991505366941699', 'https://tiku.baidu.com/tikupc/singledetail/3062767f5acfa1c7aa00cc29', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991505366941700', 'https://tiku.baidu.com/tikupc/singledetail/cd6bb307e87101f69e31952b', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991505366941698', 'https://tiku.baidu.com/tikupc/singledetail/3dc2240c844769eae009ed14', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991505434050561', 'https://tiku.baidu.com/tikupc/singledetail/a04365ec0975f46527d3e1d3', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991505434050562', 'https://tiku.baidu.com/tikupc/singledetail/0964a417866fb84ae45c8d14', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991505434050563', 'https://tiku.baidu.com/tikupc/singledetail/fa4883c4bb4cf7ec4afed07e', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991505530519554', 'https://tiku.baidu.com/tikupc/singledetail/fa1883c4bb4cf7ec4afed02e', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991505530519555', 'https://tiku.baidu.com/tikupc/singledetail/1bf4700abb68a98271fefa0d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991505530519557', 'https://tiku.baidu.com/tikupc/singledetail/b451a98271fe910ef12df83c', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991505530519556', 'https://tiku.baidu.com/tikupc/singledetail/ee15580216fc700abb68fc2a', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991505530519558', 'https://tiku.baidu.com/tikupc/singledetail/b434f111f18583d049645906', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991505647960066', 'https://tiku.baidu.com/tikupc/singledetail/cf36a5e9856a561252d36f14', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991505668931585', 'https://tiku.baidu.com/tikupc/singledetail/1ddad7bbfd0a79563c1e721c', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991505958338562', 'https://tiku.baidu.com/tikupc/singledetail/90d9ba0d4a7302768e99392b', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991505958338563', 'https://tiku.baidu.com/tikupc/singledetail/2c195a8102d276a200292e2f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991505958338561', 'https://tiku.baidu.com/tikupc/singledetail/f3d119e8b8f67c1cfad6b83f', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991506042224642', 'https://tiku.baidu.com/tikupc/singledetail/df1e866fb84ae45c3b358c0c', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991506172248066', 'https://tiku.baidu.com/tikupc/singledetail/e9cf7c1cfad6195f312ba63c', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991506197413890', 'https://tiku.baidu.com/tikupc/singledetail/9c027cd184254b35eefd3409', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991506197413891', 'https://tiku.baidu.com/tikupc/singledetail/abfabb4cf7ec4afe04a1df3b', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991506197413893', 'https://tiku.baidu.com/tikupc/singledetail/2f0c2f60ddccda38376baf2a', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991506197413892', 'https://tiku.baidu.com/tikupc/singledetail/17fc5ef7ba0d4a7302763a16', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991506306465794', 'https://tiku.baidu.com/tikupc/singledetail/403210661ed9ad51f01df201', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991506356797442', 'https://tiku.baidu.com/tikupc/singledetail/19040066f5335a8102d2202e', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991506449072129', 'https://tiku.baidu.com/tikupc/singledetail/fa3e83c4bb4cf7ec4afed008', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991506465849348', 'https://tiku.baidu.com/tikupc/singledetail/d3378e9951e79b8968022644', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991506465849346', 'https://tiku.baidu.com/tikupc/singledetail/20c1551810a6f524ccbf852e', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991506465849347', 'https://tiku.baidu.com/tikupc/singledetail/2e0bfad6195f312b3169a512', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991506465849349', 'https://tiku.baidu.com/tikupc/singledetail/a249fe4733687e21af45a903', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991506465849350', 'https://tiku.baidu.com/tikupc/singledetail/11040b4e767f5acfa1c7cd17', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991506507792385', 'https://tiku.baidu.com/tikupc/singledetail/163b76c66137ee06eff91831', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991506449072130', 'https://tiku.baidu.com/tikupc/singledetail/b40cf111f18583d04964593e', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991506306465795', 'https://tiku.baidu.com/tikupc/singledetail/f453cc7931b765ce05081447', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991506675564546', 'https://tiku.baidu.com/tikupc/singledetail/90dcba0d4a7302768e99392e', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991506675564547', 'https://tiku.baidu.com/tikupc/singledetail/e168f242336c1eb91a375d1e', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991506700730371', 'https://tiku.baidu.com/tikupc/singledetail/d48265ce0508763231121230', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991506390351873', 'https://tiku.baidu.com/tikupc/singledetail/154490c69ec3d5bbfd0a7444', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991506612649985', 'https://tiku.baidu.com/tikupc/singledetail/8137376baf1ffc4ffe47ac0a', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991506763644931', 'https://tiku.baidu.com/tikupc/singledetail/cc570d225901020207409c91', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991506763644933', 'https://tiku.baidu.com/tikupc/singledetail/f87243323968011ca3009146', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991506851725315', 'https://tiku.baidu.com/tikupc/singledetail/cbc3f61fb7360b4c2e3f6433', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991506851725314', 'https://tiku.baidu.com/tikupc/singledetail/d4ad65ce050876323112121f', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991506763644932', 'https://tiku.baidu.com/tikupc/singledetail/53acfd0a79563c1ec5da7112', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991506763644930', 'https://tiku.baidu.com/tikupc/singledetail/1cbbaef8941ea76e58fa0447', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991506973360130', 'https://tiku.baidu.com/tikupc/singledetail/1c30eff9aef8941ea76e0533', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991506973360131', 'https://tiku.baidu.com/tikupc/singledetail/fdd0b94ae45c3b3567ec8bba', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991506973360132', 'https://tiku.baidu.com/tikupc/singledetail/7fa4bceb19e8b8f67c1cb927', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991506973360133', 'https://tiku.baidu.com/tikupc/singledetail/64e4f524ccbff121dd368347', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991506973360135', 'https://tiku.baidu.com/tikupc/singledetail/cd4ab307e87101f69e31950a', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991506973360134', 'https://tiku.baidu.com/tikupc/singledetail/14e691c69ec3d5bbfd0a74e6', '1025991496621817858', '0');
INSERT INTO `crawler_question` VALUES ('1025991507174686721', 'https://tiku.baidu.com/tikupc/singledetail/90d85022aaea998fcc220e01', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991507262767108', 'https://tiku.baidu.com/tikupc/singledetail/9c157cd184254b35eefd341e', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991507262767106', 'https://tiku.baidu.com/tikupc/singledetail/42e726fff705cc1755270933', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991507262767109', 'https://tiku.baidu.com/tikupc/singledetail/6020590102020740be1e9b07', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991507325681665', 'https://tiku.baidu.com/tikupc/singledetail/d6026cdb6f1aff00bed51e15', '1025991496621817858', '0');
INSERT INTO `crawler_question` VALUES ('1025991507262767107', 'https://tiku.baidu.com/tikupc/singledetail/d83777a20029bd64783e2ce0', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991507388596225', 'https://tiku.baidu.com/tikupc/singledetail/40c5b9d528ea81c758f57844', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991507409567746', 'https://tiku.baidu.com/tikupc/singledetail/65a3cc22bcd126fff7050b29', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991507459899393', 'https://tiku.baidu.com/tikupc/singledetail/19eead51f01dc281e53af032', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991507459899394', 'https://tiku.baidu.com/tikupc/singledetail/192a0066f5335a8102d22000', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991507552174083', 'https://tiku.baidu.com/tikupc/singledetail/636b783e0912a2161479290a', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991507552174084', 'https://tiku.baidu.com/tikupc/singledetail/e0e4743231126edb6f1a10e9', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991507552174082', 'https://tiku.baidu.com/tikupc/singledetail/f5e2cd7931b765ce050814f6', '1025991496621817858', '0');
INSERT INTO `crawler_question` VALUES ('1025991507631865859', 'https://tiku.baidu.com/tikupc/singledetail/753a4a7302768e9951e73832', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991507631865857', 'https://tiku.baidu.com/tikupc/singledetail/24283968011ca300a6c3901f', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991507665420289', 'https://tiku.baidu.com/tikupc/singledetail/90d95022aaea998fcc220e00', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991506763644929', 'https://tiku.baidu.com/tikupc/singledetail/680f964bcf84b9d528ea7a12', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991507778666498', 'https://tiku.baidu.com/tikupc/singledetail/b72e29160b4e767f5acfce66', '1025991496621817858', '0');
INSERT INTO `crawler_question` VALUES ('1025991507778666499', 'https://tiku.baidu.com/tikupc/singledetail/f20cfc4ffe4733687e21aa16', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991507854163971', 'https://tiku.baidu.com/tikupc/singledetail/49c5b8f67c1cfad6195fa728', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991507854163970', 'https://tiku.baidu.com/tikupc/singledetail/fa1983c4bb4cf7ec4afed02f', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991507854163972', 'https://tiku.baidu.com/tikupc/singledetail/a96d804d2b160b4e767fcf37', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991506700730370', 'https://tiku.baidu.com/tikupc/singledetail/c6d03186bceb19e8b8f6ba03', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991507946438658', 'https://tiku.baidu.com/tikupc/singledetail/5e052279168884868762d619', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991507946438660', 'https://tiku.baidu.com/tikupc/singledetail/519ada0e7cd184254b353588', '1025991495598407681', '0');
INSERT INTO `crawler_question` VALUES ('1025991507912884225', 'https://tiku.baidu.com/tikupc/singledetail/70dbb568a98271fe910ef9d4', '1025991496621817858', '0');
INSERT INTO `crawler_question` VALUES ('1025991507946438662', 'https://tiku.baidu.com/tikupc/singledetail/8631dd36a32d7375a4178015', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991507946438661', 'https://tiku.baidu.com/tikupc/singledetail/9d5b7fd5360cba1aa811da2f', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991508059684866', 'https://tiku.baidu.com/tikupc/singledetail/51a06529647d27284b73512f', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991508110016515', 'https://tiku.baidu.com/tikupc/singledetail/284848d7c1c708a1284a442b', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991508110016514', 'https://tiku.baidu.com/tikupc/singledetail/103959f5f61fb7360b4c65fb', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991508110016516', 'https://tiku.baidu.com/tikupc/singledetail/c8d0e53a580216fc700afd54', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991508193902595', 'https://tiku.baidu.com/tikupc/singledetail/f34077232f60ddccda38a014', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991508193902594', 'https://tiku.baidu.com/tikupc/singledetail/74ed08a1284ac850ad02422f', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991508193902593', 'https://tiku.baidu.com/tikupc/singledetail/a9490b1c59eef8c75fbfb32f', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991507342458881', 'https://tiku.baidu.com/tikupc/singledetail/4e0c59eef8c75fbfc77db215', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991507631865858', 'https://tiku.baidu.com/tikupc/singledetail/e9db7c1cfad6195f312ba628', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991508269400065', 'https://tiku.baidu.com/tikupc/singledetail/a221caaedd3383c4bb4cd246', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991508328120322', 'https://tiku.baidu.com/tikupc/singledetail/1c52eff9aef8941ea76e0551', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991508445560834', 'https://tiku.baidu.com/tikupc/singledetail/1bc0d5bbfd0a79563c1e7206', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991508525252610', 'https://tiku.baidu.com/tikupc/singledetail/9212b14e852458fb770b56c3', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991508445560833', 'https://tiku.baidu.com/tikupc/singledetail/d9fbf705cc17552707220801', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991508445560835', 'https://tiku.baidu.com/tikupc/singledetail/5658903143323968011c92ab', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991508957265921', 'https://tiku.baidu.com/tikupc/singledetail/6c040740be1e650e52ea9903', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991509083095041', 'https://tiku.baidu.com/tikupc/singledetail/ed5c27d3240c844769eaee3c', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991509116649474', 'https://tiku.baidu.com/tikupc/singledetail/de30e518964bcf84b9d57b78', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991509150203906', 'https://tiku.baidu.com/tikupc/singledetail/5ff13f2b3169a4517723a3ab', '1025991496948973569', '0');
INSERT INTO `crawler_question` VALUES ('1025991509150203905', 'https://tiku.baidu.com/tikupc/singledetail/df14866fb84ae45c3b358c06', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991509150203909', 'https://tiku.baidu.com/tikupc/singledetail/82f69b89680203d8ce2f2414', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991509150203908', 'https://tiku.baidu.com/tikupc/singledetail/2e2cfad6195f312b3169a535', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991509053734914', 'https://tiku.baidu.com/tikupc/singledetail/e9f57c1cfad6195f312ba606', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991509246672898', 'https://tiku.baidu.com/tikupc/singledetail/53d6b9f3f90f76c661371a06', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991509267644418', 'https://tiku.baidu.com/tikupc/singledetail/fd4217e8b8f67c1cfad6b8ac', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991509322170369', 'https://tiku.baidu.com/tikupc/singledetail/7704915f804d2b160b4ec029', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991509322170370', 'https://tiku.baidu.com/tikupc/singledetail/c534e45c3b3567ec102d8a7b', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991509322170371', 'https://tiku.baidu.com/tikupc/singledetail/e903a21614791711cc791714', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991509401862148', 'https://tiku.baidu.com/tikupc/singledetail/57f0f90f76c66137ee061906', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991509401862147', 'https://tiku.baidu.com/tikupc/singledetail/004d168884868762caaed531', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991509443805186', 'https://tiku.baidu.com/tikupc/singledetail/de12876fb84ae45c3b358c00', '1025991495875231745', '0');
INSERT INTO `crawler_question` VALUES ('1025991509150203907', 'https://tiku.baidu.com/tikupc/singledetail/ceff80eb6294dd88d0d26b29', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991509531885572', 'https://tiku.baidu.com/tikupc/singledetail/cbdd172ded630b1c59eeb533', '1025991505467604994', '0');
INSERT INTO `crawler_question` VALUES ('1025991509401862146', 'https://tiku.baidu.com/tikupc/singledetail/53b8fd0a79563c1ec5da7106', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991509531885571', 'https://tiku.baidu.com/tikupc/singledetail/ccef54270722192e4536f6fd', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991509531885570', 'https://tiku.baidu.com/tikupc/singledetail/517f58fafab069dc50220114', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991509590605827', 'https://tiku.baidu.com/tikupc/singledetail/3065767f5acfa1c7aa00cc2e', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991509674491906', 'https://tiku.baidu.com/tikupc/singledetail/d37d8e9951e79b896802260e', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991509590605826', 'https://tiku.baidu.com/tikupc/singledetail/e85d25c52cc58bd63186bd31', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991509674491907', 'https://tiku.baidu.com/tikupc/singledetail/150a90c69ec3d5bbfd0a740a', '1025991505467604994', '0');
INSERT INTO `crawler_question` VALUES ('1025991509699657731', 'https://tiku.baidu.com/tikupc/singledetail/a5fdc9aedd3383c4bb4cd29a', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991509699657730', 'https://tiku.baidu.com/tikupc/singledetail/f62cb4daa58da0116c174906', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991509716434946', 'https://tiku.baidu.com/tikupc/singledetail/e14af242336c1eb91a375d3c', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991509775155202', 'https://tiku.baidu.com/tikupc/singledetail/400310661ed9ad51f01df230', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991509775155201', 'https://tiku.baidu.com/tikupc/singledetail/4a545acfa1c7aa00b52acb2e', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991509796126722', 'https://tiku.baidu.com/tikupc/singledetail/643bd1f34693daef5ef73d94', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991509796126723', 'https://tiku.baidu.com/tikupc/singledetail/51dc998fcc22bcd126ff0c33', '1025991505467604994', '0');
INSERT INTO `crawler_question` VALUES ('1025991509842264065', 'https://tiku.baidu.com/tikupc/singledetail/8c33f700bed5b9f3f90f1c2c', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991509871624194', 'https://tiku.baidu.com/tikupc/singledetail/d5dbce2f0066f5335a812106', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991509892595713', 'https://tiku.baidu.com/tikupc/singledetail/86c86137ee06eff9aef8070b', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991509892595714', 'https://tiku.baidu.com/tikupc/singledetail/9fecaa00b52acfc789ebc92e', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991509921955843', 'https://tiku.baidu.com/tikupc/singledetail/b9ba71fe910ef12d2af9e73d', '1025991505467604994', '0');
INSERT INTO `crawler_question` VALUES ('1025991509921955842', 'https://tiku.baidu.com/tikupc/singledetail/7a7e79563c1ec5da50e27071', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991510035202049', 'https://tiku.baidu.com/tikupc/singledetail/8a9ddaef5ef7ba0d4a733b0b', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991510001647617', 'https://tiku.baidu.com/tikupc/singledetail/bea9284ac850ad02de80410d', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991510035202050', 'https://tiku.baidu.com/tikupc/singledetail/f204fc4ffe4733687e21aa1e', '1025991505467604994', '0');
INSERT INTO `crawler_question` VALUES ('1025991510077145090', 'https://tiku.baidu.com/tikupc/singledetail/41174b35eefdc8d376ee3237', '1025991506042224643', '0');
INSERT INTO `crawler_question` VALUES ('1025991510131671042', 'https://tiku.baidu.com/tikupc/singledetail/13f158f5f61fb7360b4c6533', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991510186196994', 'https://tiku.baidu.com/tikupc/singledetail/fc85dd88d0d233d4b14e6914', '1025991506042224643', '0');
INSERT INTO `crawler_question` VALUES ('1025991510295248898', 'https://tiku.baidu.com/tikupc/singledetail/b3e81a37f111f18583d05a54', '1025991506390351874', '0');
INSERT INTO `crawler_question` VALUES ('1025991510295248899', 'https://tiku.baidu.com/tikupc/singledetail/840cff00bed5b9f3f90f1c13', '1025991506042224643', '0');
INSERT INTO `crawler_question` VALUES ('1025991510450438145', 'https://tiku.baidu.com/tikupc/singledetail/7cc8e809581b6bd97f19ea27', '1025991506390351874', '0');
INSERT INTO `crawler_question` VALUES ('1025991510463021057', 'https://tiku.baidu.com/tikupc/singledetail/20a1551810a6f524ccbf854e', '1025991506042224643', '0');
INSERT INTO `crawler_question` VALUES ('1025991510572072961', 'https://tiku.baidu.com/tikupc/singledetail/9c8af5ec4afe04a1b071dec3', '1025991506042224643', '0');
INSERT INTO `crawler_question` VALUES ('1025991510630793217', 'https://tiku.baidu.com/tikupc/singledetail/29f9c8d376eeaeaad1f33001', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991510735650818', 'https://tiku.baidu.com/tikupc/singledetail/cd3b55270722192e4536f629', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991510752428034', 'https://tiku.baidu.com/tikupc/singledetail/4b4e332b3169a4517723a314', '1025991507459899395', '0');
INSERT INTO `crawler_question` VALUES ('1025991510752428035', 'https://tiku.baidu.com/tikupc/singledetail/53e1b9f3f90f76c661371a31', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991510752428036', 'https://tiku.baidu.com/tikupc/singledetail/9d2dbd2acfc789eb172dc828', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991510823731202', 'https://tiku.baidu.com/tikupc/singledetail/d92787c24028915f804dc218', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991510823731203', 'https://tiku.baidu.com/tikupc/singledetail/1306bed5b9f3f90f76c61b03', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991510844702721', 'https://tiku.baidu.com/tikupc/singledetail/a7150912a21614791711282e', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991510878257153', 'https://tiku.baidu.com/tikupc/singledetail/845dff00bed5b9f3f90f1c42', '1025991506621038594', '0');
INSERT INTO `crawler_question` VALUES ('1025991510932783107', 'https://tiku.baidu.com/tikupc/singledetail/d6d2b42b3169a4517723a38b', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991510932783106', 'https://tiku.baidu.com/tikupc/singledetail/13c958f5f61fb7360b4c650b', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991510932783108', 'https://tiku.baidu.com/tikupc/singledetail/e85b25c52cc58bd63186bd37', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991510932783109', 'https://tiku.baidu.com/tikupc/singledetail/6007590102020740be1e9b20', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991510966337537', 'https://tiku.baidu.com/tikupc/singledetail/ce32650e52ea551810a68729', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991510991503361', 'https://tiku.baidu.com/tikupc/singledetail/260a10a6f524ccbff1218417', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991511008280579', 'https://tiku.baidu.com/tikupc/singledetail/801cccbff121dd36a32d823d', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991511008280578', 'https://tiku.baidu.com/tikupc/singledetail/1d40d522aaea998fcc220e99', '1025991493899714562', '0');
INSERT INTO `crawler_question` VALUES ('1025991511008280580', 'https://tiku.baidu.com/tikupc/singledetail/f36a19e8b8f67c1cfad6b884', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991511008280577', 'https://tiku.baidu.com/tikupc/singledetail/eca5dd3383c4bb4cf7ecd10e', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991511113138178', 'https://tiku.baidu.com/tikupc/singledetail/41be83d049649b6648d7473e', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991511113138179', 'https://tiku.baidu.com/tikupc/singledetail/e22b2af90242a8956bece403', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991511113138177', 'https://tiku.baidu.com/tikupc/singledetail/64b6f524ccbff121dd368315', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991511197024260', 'https://tiku.baidu.com/tikupc/singledetail/1afe4693daef5ef7ba0d3c08', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991511197024257', 'https://tiku.baidu.com/tikupc/singledetail/dd68bd64783e0912a2162a44', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991511389962241', 'https://tiku.baidu.com/tikupc/singledetail/cd0252d380eb6294dd886c15', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991511389962242', 'https://tiku.baidu.com/tikupc/singledetail/538ffd0a79563c1ec5da7131', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991511389962244', 'https://tiku.baidu.com/tikupc/singledetail/1405de80d4d8d15abe234e02', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991511197024258', 'https://tiku.baidu.com/tikupc/singledetail/4bc87f19227916888486d714', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991511389962243', 'https://tiku.baidu.com/tikupc/singledetail/258c3868011ca300a6c390bb', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991511503208450', 'https://tiku.baidu.com/tikupc/singledetail/7cae0975f46527d3240ce047', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991511557734402', 'https://tiku.baidu.com/tikupc/singledetail/5e26f18583d049649b665832', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991511557734401', 'https://tiku.baidu.com/tikupc/singledetail/925ef7ec4afe04a1b071de17', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991511557734403', 'https://tiku.baidu.com/tikupc/singledetail/74e4e009581b6bd97f19ea0b', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991511557734404', 'https://tiku.baidu.com/tikupc/singledetail/cd54b307e87101f69e319514', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991511557734405', 'https://tiku.baidu.com/tikupc/singledetail/6f032dc58bd63186bcebbcc3', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991511624843266', 'https://tiku.baidu.com/tikupc/singledetail/32d749649b6648d7c1c74602', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991511624843269', 'https://tiku.baidu.com/tikupc/singledetail/bff0aeaad1f34693daef3e1b', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991511624843268', 'https://tiku.baidu.com/tikupc/singledetail/678da1c7aa00b52acfc7ca47', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991511742283778', 'https://tiku.baidu.com/tikupc/singledetail/7046ad02de80d4d8d15a4f13', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991511624843270', 'https://tiku.baidu.com/tikupc/singledetail/29ed28ea81c758f5f61f673d', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991511750672386', 'https://tiku.baidu.com/tikupc/singledetail/fa3c83c4bb4cf7ec4afed00a', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991511197024259', 'https://tiku.baidu.com/tikupc/singledetail/7714915f804d2b160b4ec039', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991511792615425', 'https://tiku.baidu.com/tikupc/singledetail/19c3ad51f01dc281e53af01f', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991511792615427', 'https://tiku.baidu.com/tikupc/singledetail/4bc67f19227916888486d71a', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991511792615426', 'https://tiku.baidu.com/tikupc/singledetail/402d10661ed9ad51f01df21e', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991511884890113', 'https://tiku.baidu.com/tikupc/singledetail/fb5c9b6648d7c1c708a1453d', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991511884890114', 'https://tiku.baidu.com/tikupc/singledetail/143152ea551810a6f524863a', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991511905861634', 'https://tiku.baidu.com/tikupc/singledetail/2c055a8102d276a200292e33', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991511964581890', 'https://tiku.baidu.com/tikupc/singledetail/ddd24afe04a1b0717fd5dd3b', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991511964581892', 'https://tiku.baidu.com/tikupc/singledetail/1d0f453610661ed9ad51f324', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991511964581891', 'https://tiku.baidu.com/tikupc/singledetail/6d18be23482fb4daa58d4b47', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991511993942019', 'https://tiku.baidu.com/tikupc/singledetail/5e032279168884868762d61f', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991511993942018', 'https://tiku.baidu.com/tikupc/singledetail/60848bd63186bceb19e8bb44', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991512031690755', 'https://tiku.baidu.com/tikupc/singledetail/f1413c1ec5da50e2524d7f12', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991512132354049', 'https://tiku.baidu.com/tikupc/singledetail/926df7ec4afe04a1b071de24', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991512031690754', 'https://tiku.baidu.com/tikupc/singledetail/aa32aaea998fcc22bcd10d15', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991512031690756', 'https://tiku.baidu.com/tikupc/singledetail/750a4a7302768e9951e73802', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991512132354050', 'https://tiku.baidu.com/tikupc/singledetail/ecb4dd3383c4bb4cf7ecd11f', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991512132354051', 'https://tiku.baidu.com/tikupc/singledetail/b98771fe910ef12d2af9e700', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991512203657217', 'https://tiku.baidu.com/tikupc/singledetail/b1884028915f804d2b16c14f', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991512031690753', 'https://tiku.baidu.com/tikupc/singledetail/842dff00bed5b9f3f90f1c32', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991512304320513', 'https://tiku.baidu.com/tikupc/singledetail/19c8ad51f01dc281e53af014', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991512304320516', 'https://tiku.baidu.com/tikupc/singledetail/80c002d276a20029bd642d44', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991512304320517', 'https://tiku.baidu.com/tikupc/singledetail/a5f4f01dc281e53a5802ffa0', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991512392400898', 'https://tiku.baidu.com/tikupc/singledetail/fe41581b6bd97f192279e94d', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991512304320514', 'https://tiku.baidu.com/tikupc/singledetail/8ee889eb172ded630b1cb62a', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991512392400899', 'https://tiku.baidu.com/tikupc/singledetail/cee280eb6294dd88d0d26b34', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991512304320515', 'https://tiku.baidu.com/tikupc/singledetail/fa43b84ae45c3b3567ec8b29', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991512493064194', 'https://tiku.baidu.com/tikupc/singledetail/74dd08a1284ac850ad02421f', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991512493064193', 'https://tiku.baidu.com/tikupc/singledetail/60ef910ef12d2af90242e614', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991512576950275', 'https://tiku.baidu.com/tikupc/singledetail/9c057cd184254b35eefd340e', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991512576950273', 'https://tiku.baidu.com/tikupc/singledetail/f92cc281e53a580216fcfe34', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991512576950274', 'https://tiku.baidu.com/tikupc/singledetail/c4dee55c3b3567ec102d8a91', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991512761499653', 'https://tiku.baidu.com/tikupc/singledetail/efa2590216fc700abb68fc9d', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991512690196482', 'https://tiku.baidu.com/tikupc/singledetail/d49a65ce0508763231121228', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991512761499650', 'https://tiku.baidu.com/tikupc/singledetail/a9dc195f312b3169a451a40f', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991512761499651', 'https://tiku.baidu.com/tikupc/singledetail/87df6e1aff00bed5b9f31d01', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991512761499652', 'https://tiku.baidu.com/tikupc/singledetail/0be2a58da0116c175f0e483d', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991512874745857', 'https://tiku.baidu.com/tikupc/singledetail/3ec30242a8956bec0975e33f', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991512874745859', 'https://tiku.baidu.com/tikupc/singledetail/d016e87101f69e3143329414', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991512874745858', 'https://tiku.baidu.com/tikupc/singledetail/74ede009581b6bd97f19ea02', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991512874745861', 'https://tiku.baidu.com/tikupc/singledetail/d198e97101f69e314332949a', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991512874745860', 'https://tiku.baidu.com/tikupc/singledetail/ae1c5f0e7cd184254b35350e', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991513025740802', 'https://tiku.baidu.com/tikupc/singledetail/aa27aaea998fcc22bcd10d00', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991513038323714', 'https://tiku.baidu.com/tikupc/singledetail/1d2a453610661ed9ad51f301', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991513038323715', 'https://tiku.baidu.com/tikupc/singledetail/5abc941ea76e58fafab00341', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991512996380674', 'https://tiku.baidu.com/tikupc/singledetail/4f85680203d8ce2f00662309', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991513105432579', 'https://tiku.baidu.com/tikupc/singledetail/278711a6f524ccbff121849a', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991513105432578', 'https://tiku.baidu.com/tikupc/singledetail/64053169a45177232f60a22b', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991513105432580', 'https://tiku.baidu.com/tikupc/singledetail/aaae0029bd64783e09122b09', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991513126404098', 'https://tiku.baidu.com/tikupc/singledetail/4bf47f19227916888486d728', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991513197707265', 'https://tiku.baidu.com/tikupc/singledetail/7627ddccda38376baf1fae42', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991513197707266', 'https://tiku.baidu.com/tikupc/singledetail/19dcad51f01dc281e53af000', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991513197707267', 'https://tiku.baidu.com/tikupc/singledetail/f617b4daa58da0116c17493d', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991513243844609', 'https://tiku.baidu.com/tikupc/singledetail/3e3518a6f524ccbff1218428', '1025991497196437505', '0');
INSERT INTO `crawler_question` VALUES ('1025991513243844611', 'https://tiku.baidu.com/tikupc/singledetail/1cf7aef8941ea76e58fa040b', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991513243844612', 'https://tiku.baidu.com/tikupc/singledetail/842fff00bed5b9f3f90f1c30', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991513243844613', 'https://tiku.baidu.com/tikupc/singledetail/4d72312b3169a4517723a328', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991513344507906', 'https://tiku.baidu.com/tikupc/singledetail/f81143323968011ca3009125', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991513344507907', 'https://tiku.baidu.com/tikupc/singledetail/a94f0b1c59eef8c75fbfb329', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991513403228162', 'https://tiku.baidu.com/tikupc/singledetail/dd08bd64783e0912a2162a24', '1025991505467604994', '0');
INSERT INTO `crawler_question` VALUES ('1025991513403228161', 'https://tiku.baidu.com/tikupc/singledetail/8c7e01f69e3143323968930a', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991513403228164', 'https://tiku.baidu.com/tikupc/singledetail/1bf5d5bbfd0a79563c1e7233', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991513403228163', 'https://tiku.baidu.com/tikupc/singledetail/cd1855270722192e4536f60a', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991513537445891', 'https://tiku.baidu.com/tikupc/singledetail/92a9c2bff121dd36a32d8288', '1025991506042224643', '0');
INSERT INTO `crawler_question` VALUES ('1025991513537445890', 'https://tiku.baidu.com/tikupc/singledetail/4a7a5acfa1c7aa00b52acb00', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991513608749058', 'https://tiku.baidu.com/tikupc/singledetail/94f8b42acfc789eb172dc8fd', '1025991505467604994', '0');
INSERT INTO `crawler_question` VALUES ('1025991513608749057', 'https://tiku.baidu.com/tikupc/singledetail/d9c8f705cc17552707220832', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991513403228165', 'https://tiku.baidu.com/tikupc/singledetail/596f336c1eb91a37f1115c28', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991513608749059', 'https://tiku.baidu.com/tikupc/singledetail/f87843323968011ca300914c', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991513701023746', 'https://tiku.baidu.com/tikupc/singledetail/842cff00bed5b9f3f90f1c33', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991513701023747', 'https://tiku.baidu.com/tikupc/singledetail/538dfd0a79563c1ec5da7133', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991513940099077', 'https://tiku.baidu.com/tikupc/singledetail/153590c69ec3d5bbfd0a7435', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991513940099074', 'https://tiku.baidu.com/tikupc/singledetail/0959a417866fb84ae45c8d29', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991513940099078', 'https://tiku.baidu.com/tikupc/singledetail/32df49649b6648d7c1c7460a', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991513940099079', 'https://tiku.baidu.com/tikupc/singledetail/eca1dd3383c4bb4cf7ecd10a', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991513940099080', 'https://tiku.baidu.com/tikupc/singledetail/ddc34afe04a1b0717fd5dd2a', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991514229506049', 'https://tiku.baidu.com/tikupc/singledetail/636ef424ccbff121dd3683cd', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991513940099075', 'https://tiku.baidu.com/tikupc/singledetail/285e48d7c1c708a1284a443d', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991514284032002', 'https://tiku.baidu.com/tikupc/singledetail/343402020740be1e650e9a30', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991513940099076', 'https://tiku.baidu.com/tikupc/singledetail/2620787f5acfa1c7aa00cc6b', '1025991505467604994', '0');
INSERT INTO `crawler_question` VALUES ('1025991514334363650', 'https://tiku.baidu.com/tikupc/singledetail/57cdf90f76c66137ee06193b', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991514388889602', 'https://tiku.baidu.com/tikupc/singledetail/6490d4d8d15abe23482f4d15', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991514388889601', 'https://tiku.baidu.com/tikupc/singledetail/143ade80d4d8d15abe234e3d', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991514334363652', 'https://tiku.baidu.com/tikupc/singledetail/d3c3f68a6529647d272852cd', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991514334363649', 'https://tiku.baidu.com/tikupc/singledetail/4be17f19227916888486d73d', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991514334363651', 'https://tiku.baidu.com/tikupc/singledetail/a260fe4733687e21af45a92a', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991514732822529', 'https://tiku.baidu.com/tikupc/singledetail/5d5a660203d8ce2f006623d6', '1025991505467604994', '0');
INSERT INTO `crawler_question` VALUES ('1025991514799931393', 'https://tiku.baidu.com/tikupc/singledetail/e85125c52cc58bd63186bd3d', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991514854457346', 'https://tiku.baidu.com/tikupc/singledetail/e9ef7c1cfad6195f312ba61c', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991514854457345', 'https://tiku.baidu.com/tikupc/singledetail/622fcd22bcd126fff7050ba5', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991514799931394', 'https://tiku.baidu.com/tikupc/singledetail/b9562b160b4e767f5acfce1e', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991514921566210', 'https://tiku.baidu.com/tikupc/singledetail/2c005a8102d276a200292e36', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991514967703555', 'https://tiku.baidu.com/tikupc/singledetail/99524431b90d6c85ec3ac646', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991514967703554', 'https://tiku.baidu.com/tikupc/singledetail/64e79e3143323968011c9214', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991515030618113', 'https://tiku.baidu.com/tikupc/singledetail/0bcda58da0116c175f0e4812', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991515030618115', 'https://tiku.baidu.com/tikupc/singledetail/1850cf84b9d528ea81c7791e', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991515030618114', 'https://tiku.baidu.com/tikupc/singledetail/86df6137ee06eff9aef8071c', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991515030618116', 'https://tiku.baidu.com/tikupc/singledetail/5624b9f67c1cfad6195fa7c9', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991515072561154', 'https://tiku.baidu.com/tikupc/singledetail/1316bed5b9f3f90f76c61b13', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991515097726978', 'https://tiku.baidu.com/tikupc/singledetail/4fb1680203d8ce2f0066233d', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991515114504194', 'https://tiku.baidu.com/tikupc/singledetail/ae005f0e7cd184254b353512', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991515114504193', 'https://tiku.baidu.com/tikupc/singledetail/1414de80d4d8d15abe234e13', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991515156447233', 'https://tiku.baidu.com/tikupc/singledetail/4152b8d528ea81c758f578d3', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991515173224451', 'https://tiku.baidu.com/tikupc/singledetail/e26c2af90242a8956bece444', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991515173224450', 'https://tiku.baidu.com/tikupc/singledetail/13799fc3d5bbfd0a795673ba', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991515190001668', 'https://tiku.baidu.com/tikupc/singledetail/163776c66137ee06eff9183d', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991515190001667', 'https://tiku.baidu.com/tikupc/singledetail/e9c87c1cfad6195f312ba63b', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991515261304834', 'https://tiku.baidu.com/tikupc/singledetail/f907c281e53a580216fcfe1f', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991515294859265', 'https://tiku.baidu.com/tikupc/singledetail/92fdb14e852458fb770b562c', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991515328413698', 'https://tiku.baidu.com/tikupc/singledetail/685cbe1e650e52ea55189819', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991515471020033', 'https://tiku.baidu.com/tikupc/singledetail/5197360cba1aa8114431d947', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991515416494082', 'https://tiku.baidu.com/tikupc/singledetail/920df7ec4afe04a1b071de44', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991515416494083', 'https://tiku.baidu.com/tikupc/singledetail/d20ff78a6529647d27285201', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991515471020035', 'https://tiku.baidu.com/tikupc/singledetail/29c528ea81c758f5f61f6715', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991515471020034', 'https://tiku.baidu.com/tikupc/singledetail/1bc5700abb68a98271fefa3c', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991515491991554', 'https://tiku.baidu.com/tikupc/singledetail/1f02af45b307e87101f69626', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991515491991555', 'https://tiku.baidu.com/tikupc/singledetail/676fa45177232f60ddcca103', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991515559100421', 'https://tiku.baidu.com/tikupc/singledetail/2092551810a6f524ccbf857d', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991515559100418', 'https://tiku.baidu.com/tikupc/singledetail/176ea8956bec0975f465e229', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991515559100422', 'https://tiku.baidu.com/tikupc/singledetail/3f34844769eae009581bec3d', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991515559100420', 'https://tiku.baidu.com/tikupc/singledetail/9e4531126edb6f1aff001f72', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991515693318147', 'https://tiku.baidu.com/tikupc/singledetail/4080b9d528ea81c758f57801', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991515693318145', 'https://tiku.baidu.com/tikupc/singledetail/3cdf856a561252d380eb6e33', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991515731066884', 'https://tiku.baidu.com/tikupc/singledetail/29d228ea81c758f5f61f6702', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991515731066883', 'https://tiku.baidu.com/tikupc/singledetail/138658f5f61fb7360b4c6544', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991515693318146', 'https://tiku.baidu.com/tikupc/singledetail/20a8551810a6f524ccbf8547', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991515731066886', 'https://tiku.baidu.com/tikupc/singledetail/92c5b14e852458fb770b5614', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991515731066882', 'https://tiku.baidu.com/tikupc/singledetail/447867ec102de2bd96058848', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991515827535873', 'https://tiku.baidu.com/tikupc/singledetail/cd4e52d380eb6294dd886c59', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991515731066885', 'https://tiku.baidu.com/tikupc/singledetail/aaf50029bd64783e09122b52', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991515869478913', 'https://tiku.baidu.com/tikupc/singledetail/8a98daef5ef7ba0d4a733b0e', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991515869478914', 'https://tiku.baidu.com/tikupc/singledetail/a08d8762caaedd3383c4d30e', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991515944976386', 'https://tiku.baidu.com/tikupc/singledetail/5ca051e79b89680203d8253c', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991515944976385', 'https://tiku.baidu.com/tikupc/singledetail/ae555f0e7cd184254b353547', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991515827535874', 'https://tiku.baidu.com/tikupc/singledetail/9505b52acfc789eb172dc800', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991515944976387', 'https://tiku.baidu.com/tikupc/singledetail/c253647d27284b73f242507f', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991515852701698', 'https://tiku.baidu.com/tikupc/singledetail/13d758f5f61fb7360b4c6515', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991516049833985', 'https://tiku.baidu.com/tikupc/singledetail/515c011ca300a6c30c229f31', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991516079194114', 'https://tiku.baidu.com/tikupc/singledetail/17a75ef7ba0d4a7302763a4d', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991516095971330', 'https://tiku.baidu.com/tikupc/singledetail/0338482fb4daa58da0114a1e', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991516095971331', 'https://tiku.baidu.com/tikupc/singledetail/fb769b6648d7c1c708a14517', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991516095971332', 'https://tiku.baidu.com/tikupc/singledetail/29f149d7c1c708a1284a4492', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991516121137154', 'https://tiku.baidu.com/tikupc/singledetail/8ce101f69e31433239689395', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991516171468801', 'https://tiku.baidu.com/tikupc/singledetail/534d7e21af45b307e8719720', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991516179857410', 'https://tiku.baidu.com/tikupc/singledetail/be9d6bec0975f46527d3e10d', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991516179857411', 'https://tiku.baidu.com/tikupc/singledetail/3f1d844769eae009581bec14', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991516209217538', 'https://tiku.baidu.com/tikupc/singledetail/5e5a2279168884868762d646', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991516263743492', 'https://tiku.baidu.com/tikupc/singledetail/6581cc22bcd126fff7050b0b', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991516263743490', 'https://tiku.baidu.com/tikupc/singledetail/b449f111f18583d04964597b', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991516263743491', 'https://tiku.baidu.com/tikupc/singledetail/5593ec630b1c59eef8c7b4bb', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991516381184002', 'https://tiku.baidu.com/tikupc/singledetail/517558fafab069dc5022011e', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991516280520705', 'https://tiku.baidu.com/tikupc/singledetail/a952804d2b160b4e767fcf08', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991516389572610', 'https://tiku.baidu.com/tikupc/singledetail/b88684254b35eefdc8d33352', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991516410544129', 'https://tiku.baidu.com/tikupc/singledetail/53787e21af45b307e8719715', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991516418932738', 'https://tiku.baidu.com/tikupc/singledetail/42e926fff705cc175527093d', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991516523790338', 'https://tiku.baidu.com/tikupc/singledetail/8794da38376baf1ffc4fad5d', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991516540567554', 'https://tiku.baidu.com/tikupc/singledetail/7e33bb68a98271fe910ef93c', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991516540567553', 'https://tiku.baidu.com/tikupc/singledetail/60f58bd63186bceb19e8bb35', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991516553150466', 'https://tiku.baidu.com/tikupc/singledetail/261610a6f524ccbff121840b', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991516611870723', 'https://tiku.baidu.com/tikupc/singledetail/df05866fb84ae45c3b358c17', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991516611870722', 'https://tiku.baidu.com/tikupc/singledetail/babdf121dd36a32d73758107', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991516662202370', 'https://tiku.baidu.com/tikupc/singledetail/61246c175f0e7cd184253630', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991516683173890', 'https://tiku.baidu.com/tikupc/singledetail/c3b926284b73f242336c5fc1', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991516792225793', 'https://tiku.baidu.com/tikupc/singledetail/be27afaad1f34693daef3ecc', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991516750282755', 'https://tiku.baidu.com/tikupc/singledetail/984869eae009581b6bd9eb0a', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991516750282753', 'https://tiku.baidu.com/tikupc/singledetail/9f7e1eb91a37f111f1855b17', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991516750282754', 'https://tiku.baidu.com/tikupc/singledetail/51a36529647d27284b73512c', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991516834168833', 'https://tiku.baidu.com/tikupc/singledetail/8129376baf1ffc4ffe47ac14', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991516922249217', 'https://tiku.baidu.com/tikupc/singledetail/58afec3a87c24028915fc32f', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991516922249219', 'https://tiku.baidu.com/tikupc/singledetail/fcf9c1c708a1284ac850432b', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991516922249220', 'https://tiku.baidu.com/tikupc/singledetail/9a4402768e9951e79b892732', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991516922249218', 'https://tiku.baidu.com/tikupc/singledetail/6759d5d8d15abe23482f4ddc', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991516947415042', 'https://tiku.baidu.com/tikupc/singledetail/194dba1aa8114431b90dd844', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991517098409985', 'https://tiku.baidu.com/tikupc/singledetail/67e5a1c7aa00b52acfc7ca2f', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991517106798593', 'https://tiku.baidu.com/tikupc/singledetail/11eb5cf7ba0d4a7302763a01', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991517106798594', 'https://tiku.baidu.com/tikupc/singledetail/985569eae009581b6bd9eb17', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991517106798595', 'https://tiku.baidu.com/tikupc/singledetail/d9e576a20029bd64783e2c32', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991517106798596', 'https://tiku.baidu.com/tikupc/singledetail/2f552f60ddccda38376baf73', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991517261987842', 'https://tiku.baidu.com/tikupc/singledetail/8eed89eb172ded630b1cb62f', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991517270376449', 'https://tiku.baidu.com/tikupc/singledetail/8c3301f69e31433239689347', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991517270376450', 'https://tiku.baidu.com/tikupc/singledetail/42dbd0d233d4b14e85246856', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991517408788481', 'https://tiku.baidu.com/tikupc/singledetail/3053767f5acfa1c7aa00cc18', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991517425565697', 'https://tiku.baidu.com/tikupc/singledetail/264e10a6f524ccbff1218453', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991517425565698', 'https://tiku.baidu.com/tikupc/singledetail/0939a417866fb84ae45c8d49', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991517459120130', 'https://tiku.baidu.com/tikupc/singledetail/185acf84b9d528ea81c77914', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991517576560641', 'https://tiku.baidu.com/tikupc/singledetail/bee4284ac850ad02de804140', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991517576560642', 'https://tiku.baidu.com/tikupc/singledetail/753b4a7302768e9951e73833', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991517576560644', 'https://tiku.baidu.com/tikupc/singledetail/92deb14e852458fb770b560f', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991517576560645', 'https://tiku.baidu.com/tikupc/singledetail/995c4431b90d6c85ec3ac648', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991517685612546', 'https://tiku.baidu.com/tikupc/singledetail/3dea240c844769eae009ed3c', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991517702389762', 'https://tiku.baidu.com/tikupc/singledetail/8a0b6c85ec3a87c24028c403', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991517685612547', 'https://tiku.baidu.com/tikupc/singledetail/8100376baf1ffc4ffe47ac3d', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991517702389763', 'https://tiku.baidu.com/tikupc/singledetail/f35c77232f60ddccda38a008', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991517857579009', 'https://tiku.baidu.com/tikupc/singledetail/a7320912a216147917112809', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991517857579010', 'https://tiku.baidu.com/tikupc/singledetail/99374431b90d6c85ec3ac623', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991517857579011', 'https://tiku.baidu.com/tikupc/singledetail/1c38eff9aef8941ea76e053b', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991517702389761', 'https://tiku.baidu.com/tikupc/singledetail/433f14791711cc7931b7162c', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991517949853697', 'https://tiku.baidu.com/tikupc/singledetail/ed7727d3240c844769eaee17', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991517949853699', 'https://tiku.baidu.com/tikupc/singledetail/ca0bf71fb7360b4c2e3f64fb', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991517702389764', 'https://tiku.baidu.com/tikupc/singledetail/f83e43323968011ca300910a', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991518025351169', 'https://tiku.baidu.com/tikupc/singledetail/3072767f5acfa1c7aa00cc39', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991518025351170', 'https://tiku.baidu.com/tikupc/singledetail/9039ee06eff9aef8941e060b', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991518025351172', 'https://tiku.baidu.com/tikupc/singledetail/6120a76e58fafab069dc023b', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991518025351171', 'https://tiku.baidu.com/tikupc/singledetail/c94fa6c30c22590102029d4a', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991518054711297', 'https://tiku.baidu.com/tikupc/singledetail/42b1d0d233d4b14e8524683c', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991518071488515', 'https://tiku.baidu.com/tikupc/singledetail/dbf3524de518964bcf847c14', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991517844996098', 'https://tiku.baidu.com/tikupc/singledetail/766bddccda38376baf1fae0e', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991518151180291', 'https://tiku.baidu.com/tikupc/singledetail/515058fafab069dc5022013b', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991518151180289', 'https://tiku.baidu.com/tikupc/singledetail/d8536edb6f1aff00bed51e44', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991518151180290', 'https://tiku.baidu.com/tikupc/singledetail/65b5a0116c175f0e7cd1373d', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991518151180293', 'https://tiku.baidu.com/tikupc/singledetail/47216bd97f1922791688e83f', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991518205706242', 'https://tiku.baidu.com/tikupc/singledetail/ae2f5f0e7cd184254b35353d', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991518092460033', 'https://tiku.baidu.com/tikupc/singledetail/543ded630b1c59eef8c7b415', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991518151180292', 'https://tiku.baidu.com/tikupc/singledetail/816b376baf1ffc4ffe47ac56', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991518277009412', 'https://tiku.baidu.com/tikupc/singledetail/b9552b160b4e767f5acfce1d', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991518277009410', 'https://tiku.baidu.com/tikupc/singledetail/60b6910ef12d2af90242e64d', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991518277009413', 'https://tiku.baidu.com/tikupc/singledetail/432114791711cc7931b71632', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991518277009411', 'https://tiku.baidu.com/tikupc/singledetail/b425f111f18583d049645917', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991518277009414', 'https://tiku.baidu.com/tikupc/singledetail/8c4a01f69e3143323968933e', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991518369284098', 'https://tiku.baidu.com/tikupc/singledetail/9d977dd184254b35eefd349c', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991518369284097', 'https://tiku.baidu.com/tikupc/singledetail/f6411711cc7931b765ce153d', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991518071488514', 'https://tiku.baidu.com/tikupc/singledetail/d4b065ce0508763231121202', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991517949853698', 'https://tiku.baidu.com/tikupc/singledetail/5972336c1eb91a37f1115c35', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991518482530305', 'https://tiku.baidu.com/tikupc/singledetail/232d541810a6f524ccbf85c2', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991518482530306', 'https://tiku.baidu.com/tikupc/singledetail/afb0fab069dc5022aaea004f', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991518482530307', 'https://tiku.baidu.com/tikupc/singledetail/6d4abe23482fb4daa58d4b15', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991518465753091', 'https://tiku.baidu.com/tikupc/singledetail/67c2a1c7aa00b52acfc7ca08', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991518465753090', 'https://tiku.baidu.com/tikupc/singledetail/f82943323968011ca300911d', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991518574804995', 'https://tiku.baidu.com/tikupc/singledetail/bd79294ac850ad02de8041dd', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991518499307522', 'https://tiku.baidu.com/tikupc/singledetail/8ba800f69e314332396893dc', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991518574804996', 'https://tiku.baidu.com/tikupc/singledetail/a0d832687e21af45b307a89a', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991518574804994', 'https://tiku.baidu.com/tikupc/singledetail/f85843323968011ca300916c', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991518667079681', 'https://tiku.baidu.com/tikupc/singledetail/d8256edb6f1aff00bed51e32', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991518679662594', 'https://tiku.baidu.com/tikupc/singledetail/70c833d4b14e852458fb571f', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991518709022722', 'https://tiku.baidu.com/tikupc/singledetail/1bea6094dd88d0d233d46a04', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991518767742977', 'https://tiku.baidu.com/tikupc/singledetail/7a3479563c1ec5da50e2703b', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991518767742978', 'https://tiku.baidu.com/tikupc/singledetail/be35afaad1f34693daef3ede', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991518709022723', 'https://tiku.baidu.com/tikupc/singledetail/572a0722192e45361066f508', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991518784520194', 'https://tiku.baidu.com/tikupc/singledetail/287631b765ce05087632130a', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991518847434753', 'https://tiku.baidu.com/tikupc/singledetail/1354852458fb770bf78a551f', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991518847434755', 'https://tiku.baidu.com/tikupc/singledetail/5058fc0a79563c1ec5da71e6', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991518847434756', 'https://tiku.baidu.com/tikupc/singledetail/cbfc172ded630b1c59eeb512', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991518943903745', 'https://tiku.baidu.com/tikupc/singledetail/4c6e58cfa1c7aa00b52acb14', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991518981652482', 'https://tiku.baidu.com/tikupc/singledetail/fcefc1c708a1284ac850433d', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991518981652481', 'https://tiku.baidu.com/tikupc/singledetail/c9a3a6c30c22590102029da6', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991519040372740', 'https://tiku.baidu.com/tikupc/singledetail/fc035a1b6bd97f192279e90f', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991519040372738', 'https://tiku.baidu.com/tikupc/singledetail/d9c876a20029bd64783e2c1f', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991519040372739', 'https://tiku.baidu.com/tikupc/singledetail/cc4327284b73f242336c5f3b', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991519120064514', 'https://tiku.baidu.com/tikupc/singledetail/cb8af61fb7360b4c2e3f647a', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991519120064516', 'https://tiku.baidu.com/tikupc/singledetail/8ab3cec789eb172ded63b79c', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991519195561985', 'https://tiku.baidu.com/tikupc/singledetail/bdcc5dbfc77da26925c5b00e', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991519212339202', 'https://tiku.baidu.com/tikupc/singledetail/194eba1aa8114431b90dd847', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991519212339201', 'https://tiku.baidu.com/tikupc/singledetail/87dbda38376baf1ffc4fad12', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991519212339203', 'https://tiku.baidu.com/tikupc/singledetail/e17ef242336c1eb91a375d08', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991519354945538', 'https://tiku.baidu.com/tikupc/singledetail/e991a21614791711cc791786', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991519354945539', 'https://tiku.baidu.com/tikupc/singledetail/2839c9d376eeaeaad1f330c1', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991519354945540', 'https://tiku.baidu.com/tikupc/singledetail/16531ed9ad51f01dc281f130', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991519401082882', 'https://tiku.baidu.com/tikupc/singledetail/a54af01dc281e53a5802ff1e', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991519375917057', 'https://tiku.baidu.com/tikupc/singledetail/17d15ef7ba0d4a7302763a3b', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991519493357569', 'https://tiku.baidu.com/tikupc/singledetail/4ae0302b3169a4517723a3ba', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991519531106306', 'https://tiku.baidu.com/tikupc/singledetail/fda9b94ae45c3b3567ec8bc3', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991519531106307', 'https://tiku.baidu.com/tikupc/singledetail/cdf60c225901020207409c30', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991519531106308', 'https://tiku.baidu.com/tikupc/singledetail/aa94f11dc281e53a5802ffc0', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991519610798082', 'https://tiku.baidu.com/tikupc/singledetail/e162f242336c1eb91a375d14', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991519610798081', 'https://tiku.baidu.com/tikupc/singledetail/1eeff56527d3240c8447ef9f', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991519698878467', 'https://tiku.baidu.com/tikupc/singledetail/29db28ea81c758f5f61f670b', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991519698878469', 'https://tiku.baidu.com/tikupc/singledetail/9df37dd184254b35eefd34f8', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991519745015809', 'https://tiku.baidu.com/tikupc/singledetail/3e96854769eae009581bec9f', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991519745015810', 'https://tiku.baidu.com/tikupc/singledetail/67f6a1c7aa00b52acfc7ca3c', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991519698878468', 'https://tiku.baidu.com/tikupc/singledetail/a69a814d2b160b4e767fcfc0', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991519858262019', 'https://tiku.baidu.com/tikupc/singledetail/3139bcd126fff705cc170a1e', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991519858262018', 'https://tiku.baidu.com/tikupc/singledetail/7f92ac02de80d4d8d15a4fc7', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991519887622145', 'https://tiku.baidu.com/tikupc/singledetail/d877f5335a8102d276a22f14', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991519887622146', 'https://tiku.baidu.com/tikupc/singledetail/ee35580216fc700abb68fc0a', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991519912787970', 'https://tiku.baidu.com/tikupc/singledetail/bfe3aeaad1f34693daef3e08', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991519954731010', 'https://tiku.baidu.com/tikupc/singledetail/8a59a8114431b90d6c85c746', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991520026034178', 'https://tiku.baidu.com/tikupc/singledetail/abd6bb4cf7ec4afe04a1df17', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991520026034179', 'https://tiku.baidu.com/tikupc/singledetail/744408a1284ac850ad024286', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991520042811394', 'https://tiku.baidu.com/tikupc/singledetail/f426cc7931b765ce05081432', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991520042811395', 'https://tiku.baidu.com/tikupc/singledetail/2e1afad6195f312b3169a503', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991520088948738', 'https://tiku.baidu.com/tikupc/singledetail/47256bd97f1922791688e83b', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991520088948739', 'https://tiku.baidu.com/tikupc/singledetail/b4a1c4da50e2524de5187eba', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991520156057602', 'https://tiku.baidu.com/tikupc/singledetail/6cd47f21af45b307e87197b9', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991520156057601', 'https://tiku.baidu.com/tikupc/singledetail/f82d43323968011ca3009119', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991520156057605', 'https://tiku.baidu.com/tikupc/singledetail/287c48d7c1c708a1284a441f', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991520156057608', 'https://tiku.baidu.com/tikupc/singledetail/d92887c24028915f804dc217', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991520156057606', 'https://tiku.baidu.com/tikupc/singledetail/ee0c580216fc700abb68fc33', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991520156057607', 'https://tiku.baidu.com/tikupc/singledetail/1aec443610661ed9ad51f3c7', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991520156057603', 'https://tiku.baidu.com/tikupc/singledetail/6b64af1ffc4ffe473368ab0a', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991520365772803', 'https://tiku.baidu.com/tikupc/singledetail/74c508a1284ac850ad024207', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991520156057604', 'https://tiku.baidu.com/tikupc/singledetail/cd7db307e87101f69e31953d', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991520403521539', 'https://tiku.baidu.com/tikupc/singledetail/cddf0c225901020207409c19', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991520445464578', 'https://tiku.baidu.com/tikupc/singledetail/bfe0aeaad1f34693daef3e0b', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991520445464579', 'https://tiku.baidu.com/tikupc/singledetail/8e334b73f242336c1eb95e1e', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991520445464580', 'https://tiku.baidu.com/tikupc/singledetail/749a4b7302768e9951e73892', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991520466436098', 'https://tiku.baidu.com/tikupc/singledetail/a67170fe910ef12d2af9e7f6', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991520403521538', 'https://tiku.baidu.com/tikupc/singledetail/4f8558eef8c75fbfc77db29c', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991520512573442', 'https://tiku.baidu.com/tikupc/singledetail/49f9b8f67c1cfad6195fa714', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991520512573441', 'https://tiku.baidu.com/tikupc/singledetail/1c04eff9aef8941ea76e0507', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991520579682306', 'https://tiku.baidu.com/tikupc/singledetail/4d1b312b3169a4517723a341', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991520579682308', 'https://tiku.baidu.com/tikupc/singledetail/8fb14a73f242336c1eb95e9c', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991520579682309', 'https://tiku.baidu.com/tikupc/singledetail/659ecc22bcd126fff7050b14', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991520617431042', 'https://tiku.baidu.com/tikupc/singledetail/32c249649b6648d7c1c74617', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991520579682307', 'https://tiku.baidu.com/tikupc/singledetail/9d327fd5360cba1aa811da46', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991520667762690', 'https://tiku.baidu.com/tikupc/singledetail/cdd30c225901020207409c15', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991520667762689', 'https://tiku.baidu.com/tikupc/singledetail/6ca87f21af45b307e87197c5', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991520667762691', 'https://tiku.baidu.com/tikupc/singledetail/ee03580216fc700abb68fc3c', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991520667762692', 'https://tiku.baidu.com/tikupc/singledetail/8c7601f69e31433239689302', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991520764231681', 'https://tiku.baidu.com/tikupc/singledetail/d5cace2f0066f5335a812117', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991520764231682', 'https://tiku.baidu.com/tikupc/singledetail/4815690203d8ce2f00662399', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991520562905090', 'https://tiku.baidu.com/tikupc/singledetail/d031e87101f69e3143329433', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991520789397505', 'https://tiku.baidu.com/tikupc/singledetail/c892e53a580216fc700afd16', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991520617431043', 'https://tiku.baidu.com/tikupc/singledetail/75c2b80d6c85ec3a87c2c5f6', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991520869089282', 'https://tiku.baidu.com/tikupc/singledetail/e134f242336c1eb91a375d42', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991520923615233', 'https://tiku.baidu.com/tikupc/singledetail/ce27650e52ea551810a6873c', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991520944586754', 'https://tiku.baidu.com/tikupc/singledetail/ee29580216fc700abb68fc16', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991520990724100', 'https://tiku.baidu.com/tikupc/singledetail/b99171fe910ef12d2af9e716', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991520990724101', 'https://tiku.baidu.com/tikupc/singledetail/90ea5022aaea998fcc220e33', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991520990724099', 'https://tiku.baidu.com/tikupc/singledetail/a4aeaa60ddccda38376baf8b', '1025991502829387779', '0');
INSERT INTO `crawler_question` VALUES ('1025991521162690561', 'https://tiku.baidu.com/tikupc/singledetail/0977a417866fb84ae45c8d07', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991520990724098', 'https://tiku.baidu.com/tikupc/singledetail/49aab8f67c1cfad6195fa747', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991521171079171', 'https://tiku.baidu.com/tikupc/singledetail/d9fdf705cc17552707220807', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991521171079173', 'https://tiku.baidu.com/tikupc/singledetail/aaad0029bd64783e09122b0a', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991521171079170', 'https://tiku.baidu.com/tikupc/singledetail/b92c5727a5e9856a56126016', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991521171079172', 'https://tiku.baidu.com/tikupc/singledetail/42eb26fff705cc175527093f', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991521275936771', 'https://tiku.baidu.com/tikupc/singledetail/29fbc8d376eeaeaad1f33003', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991520869089281', 'https://tiku.baidu.com/tikupc/singledetail/402210661ed9ad51f01df211', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991521275936770', 'https://tiku.baidu.com/tikupc/singledetail/8a97daef5ef7ba0d4a733b01', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991521313685507', 'https://tiku.baidu.com/tikupc/singledetail/29b949d7c1c708a1284a44da', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991521384988673', 'https://tiku.baidu.com/tikupc/singledetail/a957804d2b160b4e767fcf0d', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991521410154498', 'https://tiku.baidu.com/tikupc/singledetail/615aa76e58fafab069dc0241', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991521422737410', 'https://tiku.baidu.com/tikupc/singledetail/ec80dd3383c4bb4cf7ecd12b', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991521473069059', 'https://tiku.baidu.com/tikupc/singledetail/7c1cbdeb19e8b8f67c1cb99f', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991521473069058', 'https://tiku.baidu.com/tikupc/singledetail/aa0caaea998fcc22bcd10d2b', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991521473069060', 'https://tiku.baidu.com/tikupc/singledetail/28fcb0717fd5360cba1adb58', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991521523400705', 'https://tiku.baidu.com/tikupc/singledetail/9e92c950ad02de80d4d840dd', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991521603092482', 'https://tiku.baidu.com/tikupc/singledetail/afcdfab069dc5022aaea0032', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991521603092483', 'https://tiku.baidu.com/tikupc/singledetail/df3c85c24028915f804dc203', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991521603092484', 'https://tiku.baidu.com/tikupc/singledetail/1923ba1aa8114431b90dd82a', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991521666007042', 'https://tiku.baidu.com/tikupc/singledetail/8a356c85ec3a87c24028c43d', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991521787641857', 'https://tiku.baidu.com/tikupc/singledetail/c76a3086bceb19e8b8f6bab9', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991521787641858', 'https://tiku.baidu.com/tikupc/singledetail/caeba7c30c22590102029dee', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991521666007041', 'https://tiku.baidu.com/tikupc/singledetail/aab00029bd64783e09122b17', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991521787641860', 'https://tiku.baidu.com/tikupc/singledetail/f81043323968011ca3009124', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991521787641859', 'https://tiku.baidu.com/tikupc/singledetail/bfe85fbfc77da26925c5b02a', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991521951219713', 'https://tiku.baidu.com/tikupc/singledetail/b9d281c758f5f61fb736663d', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991521963802626', 'https://tiku.baidu.com/tikupc/singledetail/d24bf78a6529647d27285245', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991521963802627', 'https://tiku.baidu.com/tikupc/singledetail/c4dce55c3b3567ec102d8a93', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991521963802628', 'https://tiku.baidu.com/tikupc/singledetail/24113968011ca300a6c39026', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991521976385538', 'https://tiku.baidu.com/tikupc/singledetail/93a1f6ec4afe04a1b071dee8', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991521988968450', 'https://tiku.baidu.com/tikupc/singledetail/53477e21af45b307e871972a', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991522081243137', 'https://tiku.baidu.com/tikupc/singledetail/7f97bceb19e8b8f67c1cb914', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991522081243138', 'https://tiku.baidu.com/tikupc/singledetail/c570e45c3b3567ec102d8a3f', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991522089631745', 'https://tiku.baidu.com/tikupc/singledetail/6cf5ae1ffc4ffe473368ab9b', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991522089631746', 'https://tiku.baidu.com/tikupc/singledetail/80d302d276a20029bd642d57', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991522202877953', 'https://tiku.baidu.com/tikupc/singledetail/9586a9114431b90d6c85c799', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991522202877954', 'https://tiku.baidu.com/tikupc/singledetail/9d482e3f5727a5e9856a6101', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991522202877955', 'https://tiku.baidu.com/tikupc/singledetail/9a663b3567ec102de2bd893f', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991522202877956', 'https://tiku.baidu.com/tikupc/singledetail/513c011ca300a6c30c229f51', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991522215460866', 'https://tiku.baidu.com/tikupc/singledetail/1bd2d5bbfd0a79563c1e7214', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991522328707074', 'https://tiku.baidu.com/tikupc/singledetail/47676bd97f1922791688e879', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991522328707075', 'https://tiku.baidu.com/tikupc/singledetail/42a5d0d233d4b14e85246828', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991522379038722', 'https://tiku.baidu.com/tikupc/singledetail/84cd6f1aff00bed5b9f31d13', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991522408398850', 'https://tiku.baidu.com/tikupc/singledetail/408bb9d528ea81c758f5780a', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991522483896322', 'https://tiku.baidu.com/tikupc/singledetail/8e75a26925c52cc58bd6be0d', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991522483896323', 'https://tiku.baidu.com/tikupc/singledetail/643c3169a45177232f60a212', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991522483896324', 'https://tiku.baidu.com/tikupc/singledetail/4a035acfa1c7aa00b52acb79', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991522626502658', 'https://tiku.baidu.com/tikupc/singledetail/8efb89eb172ded630b1cb639', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991522626502657', 'https://tiku.baidu.com/tikupc/singledetail/3f20844769eae009581bec29', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991522647474178', 'https://tiku.baidu.com/tikupc/singledetail/b90f2b160b4e767f5acfce47', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991522714583041', 'https://tiku.baidu.com/tikupc/singledetail/683cbe1e650e52ea55189879', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991522714583042', 'https://tiku.baidu.com/tikupc/singledetail/648cd4d8d15abe23482f4d09', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991522714583043', 'https://tiku.baidu.com/tikupc/singledetail/bf7faeaad1f34693daef3e94', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991522714583044', 'https://tiku.baidu.com/tikupc/singledetail/dba0524de518964bcf847c47', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991522773303298', 'https://tiku.baidu.com/tikupc/singledetail/a10733687e21af45b307a845', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991522773303297', 'https://tiku.baidu.com/tikupc/singledetail/1d32453610661ed9ad51f319', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991522848800770', 'https://tiku.baidu.com/tikupc/singledetail/c857162ded630b1c59eeb5b9', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991522823634946', 'https://tiku.baidu.com/tikupc/singledetail/9d322e3f5727a5e9856a617b', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991522823634947', 'https://tiku.baidu.com/tikupc/singledetail/b1f64028915f804d2b16c131', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991522894938113', 'https://tiku.baidu.com/tikupc/singledetail/13c458f5f61fb7360b4c6506', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991522894938115', 'https://tiku.baidu.com/tikupc/singledetail/130e852458fb770bf78a5545', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991522894938114', 'https://tiku.baidu.com/tikupc/singledetail/65c8cc22bcd126fff7050b42', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991522894938118', 'https://tiku.baidu.com/tikupc/singledetail/689c964bcf84b9d528ea7a81', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991522894938117', 'https://tiku.baidu.com/tikupc/singledetail/f912c281e53a580216fcfe0a', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991523041738754', 'https://tiku.baidu.com/tikupc/singledetail/a70b0912a216147917112830', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991523041738755', 'https://tiku.baidu.com/tikupc/singledetail/ecb9dd3383c4bb4cf7ecd112', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991523087876098', 'https://tiku.baidu.com/tikupc/singledetail/d97b87c24028915f804dc244', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991523087876100', 'https://tiku.baidu.com/tikupc/singledetail/c7103086bceb19e8b8f6bac3', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991523087876099', 'https://tiku.baidu.com/tikupc/singledetail/aaa60029bd64783e09122b01', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991523125624834', 'https://tiku.baidu.com/tikupc/singledetail/2fa52f60ddccda38376baf83', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991523125624835', 'https://tiku.baidu.com/tikupc/singledetail/284131b765ce05087632133d', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991523180150786', 'https://tiku.baidu.com/tikupc/singledetail/6352783e0912a21614792933', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991523205316610', 'https://tiku.baidu.com/tikupc/singledetail/430b14791711cc7931b71618', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991523205316613', 'https://tiku.baidu.com/tikupc/singledetail/1be6700abb68a98271fefa1f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991523205316611', 'https://tiku.baidu.com/tikupc/singledetail/524d6429647d27284b7351c2', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991522894938119', 'https://tiku.baidu.com/tikupc/singledetail/6332f424ccbff121dd368391', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991523272425475', 'https://tiku.baidu.com/tikupc/singledetail/f20efc4ffe4733687e21aa14', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991523272425476', 'https://tiku.baidu.com/tikupc/singledetail/e20c763231126edb6f1a1001', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991523272425474', 'https://tiku.baidu.com/tikupc/singledetail/7e2cbb68a98271fe910ef923', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991523322757124', 'https://tiku.baidu.com/tikupc/singledetail/9122e2bd960590c69ec3760a', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991523322757122', 'https://tiku.baidu.com/tikupc/singledetail/534b7e21af45b307e8719726', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991523322757123', 'https://tiku.baidu.com/tikupc/singledetail/359284868762caaedd33d41f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991523394060291', 'https://tiku.baidu.com/tikupc/singledetail/a0b28762caaedd3383c4d331', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991523415031809', 'https://tiku.baidu.com/tikupc/singledetail/53797e21af45b307e8719714', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991523415031810', 'https://tiku.baidu.com/tikupc/singledetail/f918c281e53a580216fcfe00', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991523436003329', 'https://tiku.baidu.com/tikupc/singledetail/6742a45177232f60ddcca12e', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991523436003330', 'https://tiku.baidu.com/tikupc/singledetail/767cb90d6c85ec3a87c2c548', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991523473752065', 'https://tiku.baidu.com/tikupc/singledetail/83c10508763231126edb110a', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991523473752066', 'https://tiku.baidu.com/tikupc/singledetail/aa8cf11dc281e53a5802ffd8', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991523607969794', 'https://tiku.baidu.com/tikupc/singledetail/19efad51f01dc281e53af033', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991523607969795', 'https://tiku.baidu.com/tikupc/singledetail/028969dc5022aaea998f0f3c', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991523607969796', 'https://tiku.baidu.com/tikupc/singledetail/e7e8102de2bd960590c67701', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991523708633089', 'https://tiku.baidu.com/tikupc/singledetail/7e1bbb68a98271fe910ef914', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991523607969798', 'https://tiku.baidu.com/tikupc/singledetail/b9f471fe910ef12d2af9e773', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991523746381825', 'https://tiku.baidu.com/tikupc/singledetail/8a086c85ec3a87c24028c400', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991523779936259', 'https://tiku.baidu.com/tikupc/singledetail/1f096e175f0e7cd18425361d', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991523821879298', 'https://tiku.baidu.com/tikupc/singledetail/8ef189eb172ded630b1cb633', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991523821879300', 'https://tiku.baidu.com/tikupc/singledetail/19030066f5335a8102d22029', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991523821879301', 'https://tiku.baidu.com/tikupc/singledetail/fe85df88d0d233d4b14e6914', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991523821879299', 'https://tiku.baidu.com/tikupc/singledetail/1bc6700abb68a98271fefa3f', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991523607969797', 'https://tiku.baidu.com/tikupc/singledetail/8e78a26925c52cc58bd6be00', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991523708633090', 'https://tiku.baidu.com/tikupc/singledetail/140b74c66137ee06eff91801', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991523746381826', 'https://tiku.baidu.com/tikupc/singledetail/d232f78a6529647d2728523c', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991523964485634', 'https://tiku.baidu.com/tikupc/singledetail/f3ff19e8b8f67c1cfad6b811', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991523993845763', 'https://tiku.baidu.com/tikupc/singledetail/d211f78a6529647d2728521f', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991523922542594', 'https://tiku.baidu.com/tikupc/singledetail/65d9a0116c175f0e7cd13751', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991523863822337', 'https://tiku.baidu.com/tikupc/singledetail/6819a300a6c30c2259019e00', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991523993845764', 'https://tiku.baidu.com/tikupc/singledetail/dee5876fb84ae45c3b358cf7', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991524035788802', 'https://tiku.baidu.com/tikupc/singledetail/61e904a1b0717fd5360cdc12', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991524035788803', 'https://tiku.baidu.com/tikupc/singledetail/a509a32d7375a417866f8f3a', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991524035788804', 'https://tiku.baidu.com/tikupc/singledetail/414983d049649b6648d747c9', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991523985457154', 'https://tiku.baidu.com/tikupc/singledetail/57fcbaf67c1cfad6195fa711', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991524123869185', 'https://tiku.baidu.com/tikupc/singledetail/8a226c85ec3a87c24028c42a', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991524144840705', 'https://tiku.baidu.com/tikupc/singledetail/a09032687e21af45b307a8d2', '1025991519401082883', '0');
INSERT INTO `crawler_question` VALUES ('1025991524111286274', 'https://tiku.baidu.com/tikupc/singledetail/858fd838376baf1ffc4fad46', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991524174200833', 'https://tiku.baidu.com/tikupc/singledetail/5170011ca300a6c30c229f1d', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991523993845762', 'https://tiku.baidu.com/tikupc/singledetail/fa3483c4bb4cf7ec4afed002', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991524232921089', 'https://tiku.baidu.com/tikupc/singledetail/4a3e5acfa1c7aa00b52acb44', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991524232921091', 'https://tiku.baidu.com/tikupc/singledetail/8e34a26925c52cc58bd6be4c', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991524232921090', 'https://tiku.baidu.com/tikupc/singledetail/1da0d7bbfd0a79563c1e7266', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991524262281218', 'https://tiku.baidu.com/tikupc/singledetail/1b370266f5335a8102d2201d', '1025991519401082883', '0');
INSERT INTO `crawler_question` VALUES ('1025991524262281221', 'https://tiku.baidu.com/tikupc/singledetail/28bab0717fd5360cba1adb1e', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991524262281220', 'https://tiku.baidu.com/tikupc/singledetail/a255fe4733687e21af45a91f', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991524362944514', 'https://tiku.baidu.com/tikupc/singledetail/11a15af5f61fb7360b4c6563', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991524362944516', 'https://tiku.baidu.com/tikupc/singledetail/fa0b83c4bb4cf7ec4afed03d', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991524362944515', 'https://tiku.baidu.com/tikupc/singledetail/a506f01dc281e53a5802ff52', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991524438441986', 'https://tiku.baidu.com/tikupc/singledetail/c6943186bceb19e8b8f6ba47', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991524438441987', 'https://tiku.baidu.com/tikupc/singledetail/5781baf67c1cfad6195fa76c', '1025991519401082883', '0');
INSERT INTO `crawler_question` VALUES ('1025991524425859073', 'https://tiku.baidu.com/tikupc/singledetail/9321b04e852458fb770b56f0', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991524438441985', 'https://tiku.baidu.com/tikupc/singledetail/b97e5727a5e9856a56126044', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991524673323011', 'https://tiku.baidu.com/tikupc/singledetail/81220708763231126edb11e9', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991524673323010', 'https://tiku.baidu.com/tikupc/singledetail/0f0877eeaeaad1f346933fde', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991524673323013', 'https://tiku.baidu.com/tikupc/singledetail/2e5efad6195f312b3169a547', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991524740431874', 'https://tiku.baidu.com/tikupc/singledetail/75dfb80d6c85ec3a87c2c5eb', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991524740431875', 'https://tiku.baidu.com/tikupc/singledetail/ca32f71fb7360b4c2e3f64c2', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991524778180610', 'https://tiku.baidu.com/tikupc/singledetail/bd4303d8ce2f0066f5332244', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991524824317953', 'https://tiku.baidu.com/tikupc/singledetail/55d7bbf3f90f76c661371a07', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991524841095170', 'https://tiku.baidu.com/tikupc/singledetail/6c400740be1e650e52ea9947', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991524874649602', 'https://tiku.baidu.com/tikupc/singledetail/f5d9cd7931b765ce050814cd', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991524874649601', 'https://tiku.baidu.com/tikupc/singledetail/bd9af611f18583d0496459a8', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991524945952771', 'https://tiku.baidu.com/tikupc/singledetail/7d0116791711cc7931b71612', '1025991519698878466', '0');
INSERT INTO `crawler_question` VALUES ('1025991524945952770', 'https://tiku.baidu.com/tikupc/singledetail/415ab8d528ea81c758f578db', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991524971118595', 'https://tiku.baidu.com/tikupc/singledetail/cf65a5e9856a561252d36f47', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991524971118594', 'https://tiku.baidu.com/tikupc/singledetail/7c1abdeb19e8b8f67c1cb999', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991525013061633', 'https://tiku.baidu.com/tikupc/singledetail/1f106e175f0e7cd184253604', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991525063393281', 'https://tiku.baidu.com/tikupc/singledetail/8335356baf1ffc4ffe47ac08', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991525063393282', 'https://tiku.baidu.com/tikupc/singledetail/ce9180eb6294dd88d0d26b47', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991525088559105', 'https://tiku.baidu.com/tikupc/singledetail/efff590216fc700abb68fcc0', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991525113724929', 'https://tiku.baidu.com/tikupc/singledetail/305c767f5acfa1c7aa00cc17', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991525214388225', 'https://tiku.baidu.com/tikupc/singledetail/7c61bdeb19e8b8f67c1cb9e2', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991525214388226', 'https://tiku.baidu.com/tikupc/singledetail/0b9fa58da0116c175f0e4840', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991525214388227', 'https://tiku.baidu.com/tikupc/singledetail/263658fb770bf78a65295417', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991525214388228', 'https://tiku.baidu.com/tikupc/singledetail/a1d0ff4733687e21af45a99a', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991525306662914', 'https://tiku.baidu.com/tikupc/singledetail/9001ee06eff9aef8941e0633', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991525407326209', 'https://tiku.baidu.com/tikupc/singledetail/985869eae009581b6bd9eb1a', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991525407326210', 'https://tiku.baidu.com/tikupc/singledetail/bd1003d8ce2f0066f5332217', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991525436686338', 'https://tiku.baidu.com/tikupc/singledetail/641c3169a45177232f60a232', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991525524766721', 'https://tiku.baidu.com/tikupc/singledetail/7e19bb68a98271fe910ef916', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991525524766722', 'https://tiku.baidu.com/tikupc/singledetail/407010661ed9ad51f01df243', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991525587681281', 'https://tiku.baidu.com/tikupc/singledetail/53e2b9f3f90f76c661371a32', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991525638012930', 'https://tiku.baidu.com/tikupc/singledetail/760ab90d6c85ec3a87c2c53e', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991525638012931', 'https://tiku.baidu.com/tikupc/singledetail/c8c7e53a580216fc700afd43', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991525726093314', 'https://tiku.baidu.com/tikupc/singledetail/bfff5fbfc77da26925c5b03d', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991525738676226', 'https://tiku.baidu.com/tikupc/singledetail/98ad1fb91a37f111f1855bc4', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991525814173698', 'https://tiku.baidu.com/tikupc/singledetail/3115bcd126fff705cc170a32', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991525814173699', 'https://tiku.baidu.com/tikupc/singledetail/3cdb856a561252d380eb6e37', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991525868699650', 'https://tiku.baidu.com/tikupc/singledetail/5025fc0a79563c1ec5da719b', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991525881282561', 'https://tiku.baidu.com/tikupc/singledetail/d199e97101f69e314332949b', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991525868699651', 'https://tiku.baidu.com/tikupc/singledetail/ee7c580216fc700abb68fc43', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991525931614209', 'https://tiku.baidu.com/tikupc/singledetail/d90287c24028915f804dc23d', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991525931614210', 'https://tiku.baidu.com/tikupc/singledetail/aa950029bd64783e09122b32', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991525944197121', 'https://tiku.baidu.com/tikupc/singledetail/25ad3868011ca300a6c3909a', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991525990334465', 'https://tiku.baidu.com/tikupc/singledetail/fda8b94ae45c3b3567ec8bc2', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991526103580676', 'https://tiku.baidu.com/tikupc/singledetail/4f1532d4b14e852458fb57c2', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991526103580674', 'https://tiku.baidu.com/tikupc/singledetail/b9c071fe910ef12d2af9e747', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991526103580678', 'https://tiku.baidu.com/tikupc/singledetail/fe913d1ec5da50e2524d7fc2', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991526103580675', 'https://tiku.baidu.com/tikupc/singledetail/82f79b89680203d8ce2f2415', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991526204243969', 'https://tiku.baidu.com/tikupc/singledetail/d7adf4335a8102d276a22fce', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991526262964228', 'https://tiku.baidu.com/tikupc/singledetail/e96da21614791711cc79177a', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991526262964226', 'https://tiku.baidu.com/tikupc/singledetail/153d90c69ec3d5bbfd0a743d', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991526262964227', 'https://tiku.baidu.com/tikupc/singledetail/6f9d0640be1e650e52ea999a', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991526271352834', 'https://tiku.baidu.com/tikupc/singledetail/20d3551810a6f524ccbf853c', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991526338461697', 'https://tiku.baidu.com/tikupc/singledetail/907eee06eff9aef8941e064c', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991526338461698', 'https://tiku.baidu.com/tikupc/singledetail/359703020740be1e650e9a93', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991526338461699', 'https://tiku.baidu.com/tikupc/singledetail/f53bcfc789eb172ded63b714', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991526384599041', 'https://tiku.baidu.com/tikupc/singledetail/143752ea551810a6f524863c', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991526430736385', 'https://tiku.baidu.com/tikupc/singledetail/7e42bb68a98271fe910ef94d', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991526451707907', 'https://tiku.baidu.com/tikupc/singledetail/09c2ce1755270722192ef7cd', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991526451707906', 'https://tiku.baidu.com/tikupc/singledetail/a269caaedd3383c4bb4cd20e', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991526527205378', 'https://tiku.baidu.com/tikupc/singledetail/84fa6f1aff00bed5b9f31d24', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991526527205382', 'https://tiku.baidu.com/tikupc/singledetail/9c3c7cd184254b35eefd3437', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991526527205379', 'https://tiku.baidu.com/tikupc/singledetail/1ae04693daef5ef7ba0d3c16', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991526527205380', 'https://tiku.baidu.com/tikupc/singledetail/90f75022aaea998fcc220e2e', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991526481068034', 'https://tiku.baidu.com/tikupc/singledetail/3f1e844769eae009581bec17', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991526527205381', 'https://tiku.baidu.com/tikupc/singledetail/06ea1b2e453610661ed9f4cd', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991526720143365', 'https://tiku.baidu.com/tikupc/singledetail/67d7a1c7aa00b52acfc7ca1d', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991526720143362', 'https://tiku.baidu.com/tikupc/singledetail/d9f176a20029bd64783e2c26', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991526837583873', 'https://tiku.baidu.com/tikupc/singledetail/1377852458fb770bf78a553c', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991526850166786', 'https://tiku.baidu.com/tikupc/singledetail/cdc60c225901020207409c00', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991526850166785', 'https://tiku.baidu.com/tikupc/singledetail/041f192e453610661ed9f438', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991526837583874', 'https://tiku.baidu.com/tikupc/singledetail/f7d5c081e53a580216fcfecd', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991526690783234', 'https://tiku.baidu.com/tikupc/singledetail/5e522279168884868762d64e', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991526850166787', 'https://tiku.baidu.com/tikupc/singledetail/4e4159eef8c75fbfc77db258', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991526720143363', 'https://tiku.baidu.com/tikupc/singledetail/9a683b3567ec102de2bd8931', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991526946635778', 'https://tiku.baidu.com/tikupc/singledetail/ee20580216fc700abb68fc1f', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991526946635780', 'https://tiku.baidu.com/tikupc/singledetail/7713915f804d2b160b4ec03e', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991526946635781', 'https://tiku.baidu.com/tikupc/singledetail/9c187cd184254b35eefd3413', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991526975995906', 'https://tiku.baidu.com/tikupc/singledetail/d298f78a6529647d27285296', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991526975995905', 'https://tiku.baidu.com/tikupc/singledetail/924af7ec4afe04a1b071de03', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991526975995907', 'https://tiku.baidu.com/tikupc/singledetail/80ca02d276a20029bd642d4e', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991526967607297', 'https://tiku.baidu.com/tikupc/singledetail/81230708763231126edb11e8', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991527047299074', 'https://tiku.baidu.com/tikupc/singledetail/baaff121dd36a32d73758115', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991527047299075', 'https://tiku.baidu.com/tikupc/singledetail/13e758f5f61fb7360b4c6525', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991527080853506', 'https://tiku.baidu.com/tikupc/singledetail/6118a76e58fafab069dc0203', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991527080853507', 'https://tiku.baidu.com/tikupc/singledetail/ed2827d3240c844769eaee48', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991527047299076', 'https://tiku.baidu.com/tikupc/singledetail/1875cf84b9d528ea81c7793b', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991527097630721', 'https://tiku.baidu.com/tikupc/singledetail/8fc1a36925c52cc58bd6beb9', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991527114407938', 'https://tiku.baidu.com/tikupc/singledetail/9247b14e852458fb770b5696', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991527114407939', 'https://tiku.baidu.com/tikupc/singledetail/f50ecfc789eb172ded63b721', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991527147962370', 'https://tiku.baidu.com/tikupc/singledetail/82c79b89680203d8ce2f2425', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991527147962369', 'https://tiku.baidu.com/tikupc/singledetail/d9c7f705cc1755270722083d', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991526946635779', 'https://tiku.baidu.com/tikupc/singledetail/9247f7ec4afe04a1b071de0e', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991527231848449', 'https://tiku.baidu.com/tikupc/singledetail/29eb28ea81c758f5f61f673b', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991527231848450', 'https://tiku.baidu.com/tikupc/singledetail/cb3ce43a580216fc700afdb8', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991527315734529', 'https://tiku.baidu.com/tikupc/singledetail/64503169a45177232f60a27e', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991527223459841', 'https://tiku.baidu.com/tikupc/singledetail/8ab5daef5ef7ba0d4a733b23', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991527307345921', 'https://tiku.baidu.com/tikupc/singledetail/1878112de2bd960590c67791', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991527374454786', 'https://tiku.baidu.com/tikupc/singledetail/affcfab069dc5022aaea0003', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991527353483266', 'https://tiku.baidu.com/tikupc/singledetail/d6fda31614791711cc7917ea', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991527298957313', 'https://tiku.baidu.com/tikupc/singledetail/19d4ad51f01dc281e53af008', '1025991521129136130', '0');
INSERT INTO `crawler_question` VALUES ('1025991527370260482', 'https://tiku.baidu.com/tikupc/singledetail/264110a6f524ccbff121845c', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991527395426306', 'https://tiku.baidu.com/tikupc/singledetail/e7ef102de2bd960590c67706', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991527433175042', 'https://tiku.baidu.com/tikupc/singledetail/9e8bc950ad02de80d4d840c4', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991527433175041', 'https://tiku.baidu.com/tikupc/singledetail/144cde80d4d8d15abe234e4b', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991527508672513', 'https://tiku.baidu.com/tikupc/singledetail/698f974bcf84b9d528ea7a92', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991527533838340', 'https://tiku.baidu.com/tikupc/singledetail/fe82df88d0d233d4b14e6913', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991527533838338', 'https://tiku.baidu.com/tikupc/singledetail/9f3cc850ad02de80d4d84073', '1025991521129136130', '0');
INSERT INTO `crawler_question` VALUES ('1025991527533838339', 'https://tiku.baidu.com/tikupc/singledetail/9d7a2e3f5727a5e9856a6133', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991527592558594', 'https://tiku.baidu.com/tikupc/singledetail/be77afaad1f34693daef3e9c', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991527592558593', 'https://tiku.baidu.com/tikupc/singledetail/6b40af1ffc4ffe473368ab2e', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991527651278850', 'https://tiku.baidu.com/tikupc/singledetail/57acf90f76c66137ee06195a', '1025991521129136130', '0');
INSERT INTO `crawler_question` VALUES ('1025991527651278849', 'https://tiku.baidu.com/tikupc/singledetail/d54564ce05087632311212f7', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991527651278851', 'https://tiku.baidu.com/tikupc/singledetail/41134b35eefdc8d376ee3233', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991527651278853', 'https://tiku.baidu.com/tikupc/singledetail/6983a200a6c30c2259019e9a', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991527709999105', 'https://tiku.baidu.com/tikupc/singledetail/0bdea58da0116c175f0e4801', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991527785496577', 'https://tiku.baidu.com/tikupc/singledetail/32e8876a561252d380eb6e04', '1025991521129136130', '0');
INSERT INTO `crawler_question` VALUES ('1025991527785496578', 'https://tiku.baidu.com/tikupc/singledetail/efcc590216fc700abb68fcf3', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991527831633921', 'https://tiku.baidu.com/tikupc/singledetail/49c8b8f67c1cfad6195fa725', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991527865188354', 'https://tiku.baidu.com/tikupc/singledetail/9241f7ec4afe04a1b071de08', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991527953268738', 'https://tiku.baidu.com/tikupc/singledetail/a6fe814d2b160b4e767fcfa4', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991527865188353', 'https://tiku.baidu.com/tikupc/singledetail/a9660b1c59eef8c75fbfb300', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991527982628865', 'https://tiku.baidu.com/tikupc/singledetail/f2b176232f60ddccda38a0e5', '1025991521129136130', '0');
INSERT INTO `crawler_question` VALUES ('1025991527953268739', 'https://tiku.baidu.com/tikupc/singledetail/6d76ad1ffc4ffe473368ab18', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991527995211778', 'https://tiku.baidu.com/tikupc/singledetail/fcd9c1c708a1284ac850430b', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991528058126337', 'https://tiku.baidu.com/tikupc/singledetail/a70d0912a216147917112836', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991528058126338', 'https://tiku.baidu.com/tikupc/singledetail/2f03b1717fd5360cba1adba7', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991528058126339', 'https://tiku.baidu.com/tikupc/singledetail/82e29b89680203d8ce2f2400', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991528162983939', 'https://tiku.baidu.com/tikupc/singledetail/f527cfc789eb172ded63b708', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991528162983940', 'https://tiku.baidu.com/tikupc/singledetail/e87b25c52cc58bd63186bd17', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991528162983937', 'https://tiku.baidu.com/tikupc/singledetail/a55ef01dc281e53a5802ff0a', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991528435613698', 'https://tiku.baidu.com/tikupc/singledetail/f92ac281e53a580216fcfe32', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991528435613700', 'https://tiku.baidu.com/tikupc/singledetail/74677e19227916888486d7bb', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991528297201666', 'https://tiku.baidu.com/tikupc/singledetail/63a8783e0912a216147929c9', '1025991522328707073', '0');
INSERT INTO `crawler_question` VALUES ('1025991528297201665', 'https://tiku.baidu.com/tikupc/singledetail/698dbf1e650e52ea551898c8', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991528435613699', 'https://tiku.baidu.com/tikupc/singledetail/6c1a0740be1e650e52ea991d', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991528871821314', 'https://tiku.baidu.com/tikupc/singledetail/5616b9f67c1cfad6195fa7fb', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991528871821313', 'https://tiku.baidu.com/tikupc/singledetail/c6d788eb6294dd88d0d26b01', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991528720826370', 'https://tiku.baidu.com/tikupc/singledetail/8b2acdc789eb172ded63b705', '1025991522513256449', '0');
INSERT INTO `crawler_question` VALUES ('1025991528729214978', 'https://tiku.baidu.com/tikupc/singledetail/60fc8bd63186bceb19e8bb3c', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991528745992194', 'https://tiku.baidu.com/tikupc/singledetail/430514791711cc7931b71616', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991528985067521', 'https://tiku.baidu.com/tikupc/singledetail/8d16eefdc8d376eeaeaa3126', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991529148645377', 'https://tiku.baidu.com/tikupc/singledetail/1a13dc80d4d8d15abe234e14', '1025991522513256449', '0');
INSERT INTO `crawler_question` VALUES ('1025991529115090945', 'https://tiku.baidu.com/tikupc/singledetail/92f78962caaedd3383c4d374', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991529115090946', 'https://tiku.baidu.com/tikupc/singledetail/5382fd0a79563c1ec5da713c', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991528888598530', 'https://tiku.baidu.com/tikupc/singledetail/b90c2b160b4e767f5acfce44', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991528880209921', 'https://tiku.baidu.com/tikupc/singledetail/30cdbdd126fff705cc170aea', '1025991522328707073', '0');
INSERT INTO `crawler_question` VALUES ('1025991529308028929', 'https://tiku.baidu.com/tikupc/singledetail/84fe6f1aff00bed5b9f31d20', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991529308028930', 'https://tiku.baidu.com/tikupc/singledetail/b94df021dd36a32d737581f7', '1025991522513256449', '0');
INSERT INTO `crawler_question` VALUES ('1025991529308028932', 'https://tiku.baidu.com/tikupc/singledetail/fcccdd88d0d233d4b14e695d', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991529308028931', 'https://tiku.baidu.com/tikupc/singledetail/fbdfbd07e87101f69e31959f', '1025991513243844610', '0');
INSERT INTO `crawler_question` VALUES ('1025991529517744130', 'https://tiku.baidu.com/tikupc/singledetail/846cdb38376baf1ffc4fada5', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991529517744131', 'https://tiku.baidu.com/tikupc/singledetail/49d7b8f67c1cfad6195fa73a', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991529597435907', 'https://tiku.baidu.com/tikupc/singledetail/8fd94a73f242336c1eb95ef4', '1025991522328707073', '0');
INSERT INTO `crawler_question` VALUES ('1025991529597435908', 'https://tiku.baidu.com/tikupc/singledetail/9c567cd184254b35eefd345d', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991529681321985', 'https://tiku.baidu.com/tikupc/singledetail/c0f1a4e9856a561252d36fd3', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991529698099201', 'https://tiku.baidu.com/tikupc/singledetail/6fbb0640be1e650e52ea99bc', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991529681321986', 'https://tiku.baidu.com/tikupc/singledetail/20eb2e60ddccda38376bafcd', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991529765208066', 'https://tiku.baidu.com/tikupc/singledetail/d9c1504de518964bcf847c26', '1025991522328707073', '0');
INSERT INTO `crawler_question` VALUES ('1025991529765208065', 'https://tiku.baidu.com/tikupc/singledetail/c6973186bceb19e8b8f6ba44', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991529811345411', 'https://tiku.baidu.com/tikupc/singledetail/2e9dfad6195f312b3169a584', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991529811345410', 'https://tiku.baidu.com/tikupc/singledetail/ce86b207e87101f69e3195c6', '1025991523205316612', '0');
INSERT INTO `crawler_question` VALUES ('1025991529811345412', 'https://tiku.baidu.com/tikupc/singledetail/acd5b34e852458fb770b5604', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991529878454273', 'https://tiku.baidu.com/tikupc/singledetail/27a111a6f524ccbff12184bc', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991529878454275', 'https://tiku.baidu.com/tikupc/singledetail/bcf2a4ea998fcc22bcd10dd5', '1025991522328707073', '0');
INSERT INTO `crawler_question` VALUES ('1025991529878454274', 'https://tiku.baidu.com/tikupc/singledetail/d626cf2f0066f5335a8121fb', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991529920397314', 'https://tiku.baidu.com/tikupc/singledetail/29c5c8d376eeaeaad1f3303d', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991529970728962', 'https://tiku.baidu.com/tikupc/singledetail/76e6ddccda38376baf1fae83', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991529970728961', 'https://tiku.baidu.com/tikupc/singledetail/0ed674eeaeaad1f346933f00', '1025991523205316612', '0');
INSERT INTO `crawler_question` VALUES ('1025991529970728963', 'https://tiku.baidu.com/tikupc/singledetail/5f8e2379168884868762d692', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991529031204865', 'https://tiku.baidu.com/tikupc/singledetail/d026e87101f69e3143329424', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991530050420737', 'https://tiku.baidu.com/tikupc/singledetail/d660f7335a8102d276a22f03', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991530050420738', 'https://tiku.baidu.com/tikupc/singledetail/263558fb770bf78a65295414', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991530079780865', 'https://tiku.baidu.com/tikupc/singledetail/51876529647d27284b735108', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991530088169474', 'https://tiku.baidu.com/tikupc/singledetail/25d93868011ca300a6c390ee', '1025991523205316612', '0');
INSERT INTO `crawler_question` VALUES ('1025991530088169475', 'https://tiku.baidu.com/tikupc/singledetail/a5c2b94cf7ec4afe04a1df03', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991530113335297', 'https://tiku.baidu.com/tikupc/singledetail/be9a284ac850ad02de80413e', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991530113335298', 'https://tiku.baidu.com/tikupc/singledetail/6068590102020740be1e9b4f', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991530176249858', 'https://tiku.baidu.com/tikupc/singledetail/287748d7c1c708a1284a4414', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991530176249860', 'https://tiku.baidu.com/tikupc/singledetail/601805a1b0717fd5360cdce3', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991530176249859', 'https://tiku.baidu.com/tikupc/singledetail/284e31b765ce050876321332', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991530176249861', 'https://tiku.baidu.com/tikupc/singledetail/b620f311f18583d049645912', '1025991523205316612', '0');
INSERT INTO `crawler_question` VALUES ('1025991530243358721', 'https://tiku.baidu.com/tikupc/singledetail/d80f6edb6f1aff00bed51e18', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991530037837826', 'https://tiku.baidu.com/tikupc/singledetail/631ff424ccbff121dd3683bc', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991530272718849', 'https://tiku.baidu.com/tikupc/singledetail/3f74844769eae009581bec7d', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991529106702337', 'https://tiku.baidu.com/tikupc/singledetail/1ef8ae45b307e87101f696dc', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991530331439107', 'https://tiku.baidu.com/tikupc/singledetail/9f45c850ad02de80d4d8400a', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991530331439106', 'https://tiku.baidu.com/tikupc/singledetail/90cd5022aaea998fcc220e14', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991529920397313', 'https://tiku.baidu.com/tikupc/singledetail/17fec77da26925c52cc5bf44', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991530406936578', 'https://tiku.baidu.com/tikupc/singledetail/3102bcd126fff705cc170a25', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991530406936579', 'https://tiku.baidu.com/tikupc/singledetail/52d059fafab069dc502201bb', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991530297884674', 'https://tiku.baidu.com/tikupc/singledetail/516b58fafab069dc50220100', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991530436296705', 'https://tiku.baidu.com/tikupc/singledetail/cf5aa5e9856a561252d36f78', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991530406936577', 'https://tiku.baidu.com/tikupc/singledetail/4bb3332b3169a4517723a3e9', '1025991523205316612', '0');
INSERT INTO `crawler_question` VALUES ('1025991530536960003', 'https://tiku.baidu.com/tikupc/singledetail/b1834028915f804d2b16c144', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991530536960002', 'https://tiku.baidu.com/tikupc/singledetail/dd39bd64783e0912a2162a15', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991530562125826', 'https://tiku.baidu.com/tikupc/singledetail/d9dff705cc17552707220825', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991530574708738', 'https://tiku.baidu.com/tikupc/singledetail/d9e476a20029bd64783e2c33', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991530574708739', 'https://tiku.baidu.com/tikupc/singledetail/8e1c4b73f242336c1eb95e31', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991530528571394', 'https://tiku.baidu.com/tikupc/singledetail/fb6a760bf78a6529647d5394', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991530671177729', 'https://tiku.baidu.com/tikupc/singledetail/9e1731126edb6f1aff001f20', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991530671177730', 'https://tiku.baidu.com/tikupc/singledetail/64b7f524ccbff121dd368314', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991530671177731', 'https://tiku.baidu.com/tikupc/singledetail/e169f242336c1eb91a375d1f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991530671177732', 'https://tiku.baidu.com/tikupc/singledetail/53507e21af45b307e871973d', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991530717315075', 'https://tiku.baidu.com/tikupc/singledetail/8aa4daef5ef7ba0d4a733b32', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991530843144194', 'https://tiku.baidu.com/tikupc/singledetail/da3d7375a417866fb84a8e15', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991530830561282', 'https://tiku.baidu.com/tikupc/singledetail/402510661ed9ad51f01df216', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991530843144193', 'https://tiku.baidu.com/tikupc/singledetail/419f83d049649b6648d7471f', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991530989944834', 'https://tiku.baidu.com/tikupc/singledetail/c942a6c30c22590102029d47', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991530989944835', 'https://tiku.baidu.com/tikupc/singledetail/b3ba1a37f111f18583d05a06', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991530998333441', 'https://tiku.baidu.com/tikupc/singledetail/196e0066f5335a8102d22044', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991531023499266', 'https://tiku.baidu.com/tikupc/singledetail/e9b3dbbbfd0a79563c1e7275', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991531082219522', 'https://tiku.baidu.com/tikupc/singledetail/f6681711cc7931b765ce1514', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991531090608130', 'https://tiku.baidu.com/tikupc/singledetail/aab80029bd64783e09122b1f', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991531140939778', 'https://tiku.baidu.com/tikupc/singledetail/e8cf10d9ad51f01dc281f1af', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991531182882818', 'https://tiku.baidu.com/tikupc/singledetail/709033d4b14e852458fb5747', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991531182882819', 'https://tiku.baidu.com/tikupc/singledetail/cd0255270722192e4536f610', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991531182882820', 'https://tiku.baidu.com/tikupc/singledetail/bed76bec0975f46527d3e147', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991531254185985', 'https://tiku.baidu.com/tikupc/singledetail/82085e22aaea998fcc220ed1', '1025991513038323713', '0');
INSERT INTO `crawler_question` VALUES ('1025991531296129026', 'https://tiku.baidu.com/tikupc/singledetail/65f1cc22bcd126fff7050b7b', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991531296129025', 'https://tiku.baidu.com/tikupc/singledetail/37d42aea81c758f5f61f6704', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991531317100545', 'https://tiku.baidu.com/tikupc/singledetail/cbc8172ded630b1c59eeb526', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991531350654977', 'https://tiku.baidu.com/tikupc/singledetail/286331b765ce05087632131f', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991531442929666', 'https://tiku.baidu.com/tikupc/singledetail/9a103b3567ec102de2bd8949', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991531434541057', 'https://tiku.baidu.com/tikupc/singledetail/9cae7ed5360cba1aa811dada', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991531455512579', 'https://tiku.baidu.com/tikupc/singledetail/60ac960590c69ec3d5bb7514', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991531455512578', 'https://tiku.baidu.com/tikupc/singledetail/805accbff121dd36a32d827b', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991531442929665', 'https://tiku.baidu.com/tikupc/singledetail/f38bfd4ffe4733687e21aa91', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991531539398657', 'https://tiku.baidu.com/tikupc/singledetail/5e5b2279168884868762d647', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991531560370177', 'https://tiku.baidu.com/tikupc/singledetail/9f7d1eb91a37f111f1855b14', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991531560370179', 'https://tiku.baidu.com/tikupc/singledetail/b1ebacaad1f34693daef3e00', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991531560370178', 'https://tiku.baidu.com/tikupc/singledetail/1f39561252d380eb62946d56', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991531560370180', 'https://tiku.baidu.com/tikupc/singledetail/9a223b3567ec102de2bd897b', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991531702976514', 'https://tiku.baidu.com/tikupc/singledetail/90e4ba0d4a7302768e993916', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991531728142338', 'https://tiku.baidu.com/tikupc/singledetail/997d1cb91a37f111f1855b14', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991531765891073', 'https://tiku.baidu.com/tikupc/singledetail/757c09a1284ac850ad0242be', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991531828805633', 'https://tiku.baidu.com/tikupc/singledetail/9d6f7fd5360cba1aa811da1b', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991531858165762', 'https://tiku.baidu.com/tikupc/singledetail/443967ec102de2bd96058809', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991531858165763', 'https://tiku.baidu.com/tikupc/singledetail/d9a96fdb6f1aff00bed51ebe', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991531937857537', 'https://tiku.baidu.com/tikupc/singledetail/1418de80d4d8d15abe234e1f', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991531937857538', 'https://tiku.baidu.com/tikupc/singledetail/97eaa200b52acfc789ebc928', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991531971411970', 'https://tiku.baidu.com/tikupc/singledetail/87e3da38376baf1ffc4fad2a', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991531988189186', 'https://tiku.baidu.com/tikupc/singledetail/6d13be23482fb4daa58d4b4c', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991532059492355', 'https://tiku.baidu.com/tikupc/singledetail/8a4f6c85ec3a87c24028c447', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991532059492354', 'https://tiku.baidu.com/tikupc/singledetail/285d48d7c1c708a1284a443e', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991532072075265', 'https://tiku.baidu.com/tikupc/singledetail/14bbbfd5b9f3f90f76c61bbe', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991532097241090', 'https://tiku.baidu.com/tikupc/singledetail/cb5489c24028915f804dc26b', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991532155961346', 'https://tiku.baidu.com/tikupc/singledetail/80a0ccbff121dd36a32d8281', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991532227264513', 'https://tiku.baidu.com/tikupc/singledetail/f258fc4ffe4733687e21aa42', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991532227264514', 'https://tiku.baidu.com/tikupc/singledetail/7e11bb68a98271fe910ef91e', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991532227264515', 'https://tiku.baidu.com/tikupc/singledetail/3c250a020740be1e650e9a21', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991532298567682', 'https://tiku.baidu.com/tikupc/singledetail/3e12250c844769eae009edc4', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991532298567683', 'https://tiku.baidu.com/tikupc/singledetail/320100020740be1e650e9a05', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991532348899334', 'https://tiku.baidu.com/tikupc/singledetail/d4ea7175a417866fb84a8ec2', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991532348899332', 'https://tiku.baidu.com/tikupc/singledetail/1bd8d5bbfd0a79563c1e721e', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991532348899331', 'https://tiku.baidu.com/tikupc/singledetail/50bcff8583d049649b6658a8', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991532298567684', 'https://tiku.baidu.com/tikupc/singledetail/331457270722192e4536f601', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991532348899330', 'https://tiku.baidu.com/tikupc/singledetail/6825a300a6c30c2259019e3c', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991532629917699', 'https://tiku.baidu.com/tikupc/singledetail/991a6037ee06eff9aef807d9', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991532629917698', 'https://tiku.baidu.com/tikupc/singledetail/7621b90d6c85ec3a87c2c515', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991532629917701', 'https://tiku.baidu.com/tikupc/singledetail/512b011ca300a6c30c229f46', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991532705415170', 'https://tiku.baidu.com/tikupc/singledetail/3a35ce232f60ddccda38a060', '1025991498177904644', '0');
INSERT INTO `crawler_question` VALUES ('1025991532705415169', 'https://tiku.baidu.com/tikupc/singledetail/1b2c6094dd88d0d233d46ac2', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991532629917700', 'https://tiku.baidu.com/tikupc/singledetail/b89384254b35eefdc8d33347', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991532722192385', 'https://tiku.baidu.com/tikupc/singledetail/7d1316791711cc7931b71600', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991532789301250', 'https://tiku.baidu.com/tikupc/singledetail/987e69eae009581b6bd9eb3c', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991532789301249', 'https://tiku.baidu.com/tikupc/singledetail/d824f605cc175527072208de', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991532789301251', 'https://tiku.baidu.com/tikupc/singledetail/4bf97f19227916888486d725', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991532843827201', 'https://tiku.baidu.com/tikupc/singledetail/74d108a1284ac850ad024213', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991532843827202', 'https://tiku.baidu.com/tikupc/singledetail/661389d63186bceb19e8bbd3', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991532898353153', 'https://tiku.baidu.com/tikupc/singledetail/361429ea81c758f5f61f67c4', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991532873187331', 'https://tiku.baidu.com/tikupc/singledetail/8d77eefdc8d376eeaeaa3147', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991532898353154', 'https://tiku.baidu.com/tikupc/singledetail/19430066f5335a8102d22069', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991532898353155', 'https://tiku.baidu.com/tikupc/singledetail/cccc53d380eb6294dd886cdb', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991532948684802', 'https://tiku.baidu.com/tikupc/singledetail/b520c5da50e2524de5187e3b', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991532948684803', 'https://tiku.baidu.com/tikupc/singledetail/46084835eefdc8d376ee3228', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991532978044929', 'https://tiku.baidu.com/tikupc/singledetail/751f09a1284ac850ad0242dd', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991532873187330', 'https://tiku.baidu.com/tikupc/singledetail/df3085c24028915f804dc20f', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991533040959490', 'https://tiku.baidu.com/tikupc/singledetail/610a6c175f0e7cd18425361e', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991533040959491', 'https://tiku.baidu.com/tikupc/singledetail/149191c69ec3d5bbfd0a7491', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991533040959492', 'https://tiku.baidu.com/tikupc/singledetail/c1d03286bceb19e8b8f6ba03', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991533095485443', 'https://tiku.baidu.com/tikupc/singledetail/7522935f804d2b160b4ec00f', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991533095485441', 'https://tiku.baidu.com/tikupc/singledetail/cd0f55270722192e4536f61d', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991532348899333', 'https://tiku.baidu.com/tikupc/singledetail/ce48650e52ea551810a68753', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991533141622786', 'https://tiku.baidu.com/tikupc/singledetail/0066168884868762caaed51a', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991533141622787', 'https://tiku.baidu.com/tikupc/singledetail/131bbed5b9f3f90f76c61b1e', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991533229703169', 'https://tiku.baidu.com/tikupc/singledetail/cbf1f61fb7360b4c2e3f6401', '1025991525889671170', '0');
INSERT INTO `crawler_question` VALUES ('1025991533229703170', 'https://tiku.baidu.com/tikupc/singledetail/1a14a1116c175f0e7cd1379c', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991533284229121', 'https://tiku.baidu.com/tikupc/singledetail/05304a2fb4daa58da0114a16', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991533301006338', 'https://tiku.baidu.com/tikupc/singledetail/61916c175f0e7cd184253685', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991533301006339', 'https://tiku.baidu.com/tikupc/singledetail/1a47710abb68a98271fefabe', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991533347143682', 'https://tiku.baidu.com/tikupc/singledetail/cd0b55270722192e4536f619', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991532579586049', 'https://tiku.baidu.com/tikupc/singledetail/2b95cad376eeaeaad1f3306d', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991533384892417', 'https://tiku.baidu.com/tikupc/singledetail/920af7ec4afe04a1b071de43', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991533393281026', 'https://tiku.baidu.com/tikupc/singledetail/1875112de2bd960590c6779c', '1025991525889671170', '0');
INSERT INTO `crawler_question` VALUES ('1025991533095485442', 'https://tiku.baidu.com/tikupc/singledetail/54860622192e45361066f5a4', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991533393281025', 'https://tiku.baidu.com/tikupc/singledetail/2867c9d376eeaeaad1f3309f', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991533493944321', 'https://tiku.baidu.com/tikupc/singledetail/dbf9524de518964bcf847c1e', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991533443612673', 'https://tiku.baidu.com/tikupc/singledetail/b9665727a5e9856a5612605c', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991533527498754', 'https://tiku.baidu.com/tikupc/singledetail/60da8bd63186bceb19e8bb1a', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991533527498756', 'https://tiku.baidu.com/tikupc/singledetail/60ec6d175f0e7cd1842536f8', '1025991525889671170', '0');
INSERT INTO `crawler_question` VALUES ('1025991533527498759', 'https://tiku.baidu.com/tikupc/singledetail/0f1777eeaeaad1f346933fc1', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991533527498758', 'https://tiku.baidu.com/tikupc/singledetail/3d37846a561252d380eb6edb', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991533573636097', 'https://tiku.baidu.com/tikupc/singledetail/1787c77da26925c52cc5bf3d', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991533527498755', 'https://tiku.baidu.com/tikupc/singledetail/bd005dbfc77da26925c5b0c2', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991533644939266', 'https://tiku.baidu.com/tikupc/singledetail/9e0f7ed184254b35eefd3404', '1025991526103580677', '0');
INSERT INTO `crawler_question` VALUES ('1025991533842071554', 'https://tiku.baidu.com/tikupc/singledetail/a1d1ff4733687e21af45a99b', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991533842071553', 'https://tiku.baidu.com/tikupc/singledetail/53777e21af45b307e871971a', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991533858848769', 'https://tiku.baidu.com/tikupc/singledetail/7823dfccda38376baf1fae46', '1025991525889671170', '0');
INSERT INTO `crawler_question` VALUES ('1025991533867237377', 'https://tiku.baidu.com/tikupc/singledetail/1d21aff8941ea76e58fa04dd', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991533867237378', 'https://tiku.baidu.com/tikupc/singledetail/f6477f1cfad6195f312ba6b4', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991533867237379', 'https://tiku.baidu.com/tikupc/singledetail/8e45a26925c52cc58bd6be3d', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991533879820289', 'https://tiku.baidu.com/tikupc/singledetail/8ed5effdc8d376eeaeaa31e5', '1025991526103580677', '0');
INSERT INTO `crawler_question` VALUES ('1025991533980483587', 'https://tiku.baidu.com/tikupc/singledetail/7bea78563c1ec5da50e270e5', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991533980483586', 'https://tiku.baidu.com/tikupc/singledetail/67bd580102020740be1e9b9a', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991533913374723', 'https://tiku.baidu.com/tikupc/singledetail/a10033687e21af45b307a842', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991533993066498', 'https://tiku.baidu.com/tikupc/singledetail/962d39126edb6f1aff001f1a', '1025991515190001666', '0');
INSERT INTO `crawler_question` VALUES ('1025991533993066497', 'https://tiku.baidu.com/tikupc/singledetail/a277fe4733687e21af45a93d', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991534005649409', 'https://tiku.baidu.com/tikupc/singledetail/d8d186c24028915f804dc2ee', '1025991526103580677', '0');
INSERT INTO `crawler_question` VALUES ('1025991534085341185', 'https://tiku.baidu.com/tikupc/singledetail/4db252e2524de518964b7d6d', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991534097924097', 'https://tiku.baidu.com/tikupc/singledetail/101159f5f61fb7360b4c65d3', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991534097924098', 'https://tiku.baidu.com/tikupc/singledetail/1f19af45b307e87101f6963d', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991534152450051', 'https://tiku.baidu.com/tikupc/singledetail/77ebc222bcd126fff7050b61', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991534152450050', 'https://tiku.baidu.com/tikupc/singledetail/ef6cdc3383c4bb4cf7ecd1c7', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991534097924099', 'https://tiku.baidu.com/tikupc/singledetail/15ecbcd5b9f3f90f76c61be9', '1025991526103580677', '0');
INSERT INTO `crawler_question` VALUES ('1025991534227947522', 'https://tiku.baidu.com/tikupc/singledetail/f429cc7931b765ce0508143d', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991534307639298', 'https://tiku.baidu.com/tikupc/singledetail/fd93b94ae45c3b3567ec8bf9', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991534307639299', 'https://tiku.baidu.com/tikupc/singledetail/a964804d2b160b4e767fcf3e', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991534437662722', 'https://tiku.baidu.com/tikupc/singledetail/80fd4973f242336c1eb95ed0', '1025991526103580677', '0');
INSERT INTO `crawler_question` VALUES ('1025991534307639300', 'https://tiku.baidu.com/tikupc/singledetail/7a1b79563c1ec5da50e27014', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991534437662721', 'https://tiku.baidu.com/tikupc/singledetail/40e14a35eefdc8d376ee32c1', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991534471217154', 'https://tiku.baidu.com/tikupc/singledetail/1fa7f8c75fbfc77da269b14c', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991534471217153', 'https://tiku.baidu.com/tikupc/singledetail/9115e2bd960590c69ec3763d', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991534538326019', 'https://tiku.baidu.com/tikupc/singledetail/b50fc5da50e2524de5187e14', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991534538326018', 'https://tiku.baidu.com/tikupc/singledetail/c6ed3186bceb19e8b8f6ba3e', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991534538326020', 'https://tiku.baidu.com/tikupc/singledetail/6757d0f34693daef5ef73df8', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991534576074754', 'https://tiku.baidu.com/tikupc/singledetail/1a3a710abb68a98271fefac3', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991534576074753', 'https://tiku.baidu.com/tikupc/singledetail/b47ef111f18583d04964594c', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991534634795010', 'https://tiku.baidu.com/tikupc/singledetail/4095b9d528ea81c758f57814', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991534634795011', 'https://tiku.baidu.com/tikupc/singledetail/6ed12cc58bd63186bcebbc11', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991534655766529', 'https://tiku.baidu.com/tikupc/singledetail/5e15f18583d049649b665801', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991534655766530', 'https://tiku.baidu.com/tikupc/singledetail/2f7ab1717fd5360cba1adbde', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991534731264002', 'https://tiku.baidu.com/tikupc/singledetail/00f576eeaeaad1f346933f23', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991534731264003', 'https://tiku.baidu.com/tikupc/singledetail/23f10a4c2e3f5727a5e962c2', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991534731264004', 'https://tiku.baidu.com/tikupc/singledetail/60ec910ef12d2af90242e617', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991534781595651', 'https://tiku.baidu.com/tikupc/singledetail/0313482fb4daa58da0114a35', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991534781595650', 'https://tiku.baidu.com/tikupc/singledetail/16731ed9ad51f01dc281f110', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991534781595649', 'https://tiku.baidu.com/tikupc/singledetail/fb20760bf78a6529647d53de', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991534869676033', 'https://tiku.baidu.com/tikupc/singledetail/6f96d15abe23482fb4da4c4b', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991534899036163', 'https://tiku.baidu.com/tikupc/singledetail/f210fc4ffe4733687e21aa0a', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991534936784898', 'https://tiku.baidu.com/tikupc/singledetail/5bb9316c1eb91a37f1115cfe', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991534899036162', 'https://tiku.baidu.com/tikupc/singledetail/395c0342a8956bec0975e3a0', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991534961950722', 'https://tiku.baidu.com/tikupc/singledetail/143252ea551810a6f5248639', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991534978727938', 'https://tiku.baidu.com/tikupc/singledetail/f3b319e8b8f67c1cfad6b85d', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991535003893761', 'https://tiku.baidu.com/tikupc/singledetail/17bf5ef7ba0d4a7302763a55', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991535041642497', 'https://tiku.baidu.com/tikupc/singledetail/ed005b0216fc700abb68fc3f', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991535075196930', 'https://tiku.baidu.com/tikupc/singledetail/d64acf2f0066f5335a812197', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991535138111490', 'https://tiku.baidu.com/tikupc/singledetail/6ddd2fc58bd63186bcebbc1d', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991535167471619', 'https://tiku.baidu.com/tikupc/singledetail/f231fc4ffe4733687e21aa2b', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991535213608961', 'https://tiku.baidu.com/tikupc/singledetail/b2051b37f111f18583d05ab9', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991535318466568', 'https://tiku.baidu.com/tikupc/singledetail/c4b6e55c3b3567ec102d8af9', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991535318466564', 'https://tiku.baidu.com/tikupc/singledetail/bfd55fbfc77da26925c5b017', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991535318466563', 'https://tiku.baidu.com/tikupc/singledetail/47136bd97f1922791688e80d', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991535318466562', 'https://tiku.baidu.com/tikupc/singledetail/b67228160b4e767f5acfce3a', '1025991515559100419', '0');
INSERT INTO `crawler_question` VALUES ('1025991535465267202', 'https://tiku.baidu.com/tikupc/singledetail/540eed630b1c59eef8c7b426', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991535465267203', 'https://tiku.baidu.com/tikupc/singledetail/f7b67e1cfad6195f312ba645', '1025991526720143364', '0');
INSERT INTO `crawler_question` VALUES ('1025991535465267204', 'https://tiku.baidu.com/tikupc/singledetail/ad8e5e0e7cd184254b35359c', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991535318466566', 'https://tiku.baidu.com/tikupc/singledetail/1a1aa1116c175f0e7cd13792', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991535565930498', 'https://tiku.baidu.com/tikupc/singledetail/35bc84868762caaedd33d431', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991535557541889', 'https://tiku.baidu.com/tikupc/singledetail/cfc30e225901020207409c05', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991535586902017', 'https://tiku.baidu.com/tikupc/singledetail/8633dd36a32d7375a4178017', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991535318466565', 'https://tiku.baidu.com/tikupc/singledetail/bfd0aeaad1f34693daef3e3b', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991535586902019', 'https://tiku.baidu.com/tikupc/singledetail/22150b4c2e3f5727a5e96226', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991535649816577', 'https://tiku.baidu.com/tikupc/singledetail/7f91ac02de80d4d8d15a4fc4', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991535649816578', 'https://tiku.baidu.com/tikupc/singledetail/b762aa8271fe910ef12df80f', '1025991526720143364', '0');
INSERT INTO `crawler_question` VALUES ('1025991535649816579', 'https://tiku.baidu.com/tikupc/singledetail/7d490875f46527d3240ce0a0', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991535649816580', 'https://tiku.baidu.com/tikupc/singledetail/7067ad02de80d4d8d15a4f32', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991535318466567', 'https://tiku.baidu.com/tikupc/singledetail/42a426fff705cc1755270970', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991535746285569', 'https://tiku.baidu.com/tikupc/singledetail/ddad4afe04a1b0717fd5dd44', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991535746285570', 'https://tiku.baidu.com/tikupc/singledetail/90b9e3bd960590c69ec37691', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991535763062787', 'https://tiku.baidu.com/tikupc/singledetail/9c5dab00b52acfc789ebc99f', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991535763062786', 'https://tiku.baidu.com/tikupc/singledetail/cf07a5e9856a561252d36f25', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991535763062788', 'https://tiku.baidu.com/tikupc/singledetail/26333b68011ca300a6c39004', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991535800811521', 'https://tiku.baidu.com/tikupc/singledetail/680fbe1e650e52ea5518984a', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991535834365954', 'https://tiku.baidu.com/tikupc/singledetail/64c29e3143323968011c9231', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991535909863426', 'https://tiku.baidu.com/tikupc/singledetail/1b82d5bbfd0a79563c1e7244', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991535918252035', 'https://tiku.baidu.com/tikupc/singledetail/e3b12bf90242a8956bece499', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991535918252034', 'https://tiku.baidu.com/tikupc/singledetail/512958fafab069dc50220142', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991535939223554', 'https://tiku.baidu.com/tikupc/singledetail/6c7a0740be1e650e52ea997d', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991535993749505', 'https://tiku.baidu.com/tikupc/singledetail/8e744b73f242336c1eb95e59', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991535993749507', 'https://tiku.baidu.com/tikupc/singledetail/180acf84b9d528ea81c77944', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991536048275459', 'https://tiku.baidu.com/tikupc/singledetail/6848a300a6c30c2259019e51', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991536048275458', 'https://tiku.baidu.com/tikupc/singledetail/4e5159eef8c75fbfc77db248', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991536102801410', 'https://tiku.baidu.com/tikupc/singledetail/94a1b42acfc789eb172dc8a4', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991536132161539', 'https://tiku.baidu.com/tikupc/singledetail/502ffc0a79563c1ec5da7191', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991536132161540', 'https://tiku.baidu.com/tikupc/singledetail/bd1303d8ce2f0066f5332214', '1025991527865188355', '0');
INSERT INTO `crawler_question` VALUES ('1025991536132161538', 'https://tiku.baidu.com/tikupc/singledetail/d225ea7101f69e3143329427', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991536190881794', 'https://tiku.baidu.com/tikupc/singledetail/6806a300a6c30c2259019e1f', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991536220241922', 'https://tiku.baidu.com/tikupc/singledetail/6b45af1ffc4ffe473368ab2b', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991536220241921', 'https://tiku.baidu.com/tikupc/singledetail/e25c763231126edb6f1a1051', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991536337682435', 'https://tiku.baidu.com/tikupc/singledetail/f13275232f60ddccda38a066', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991536329293826', 'https://tiku.baidu.com/tikupc/singledetail/802c4973f242336c1eb95e01', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991536337682434', 'https://tiku.baidu.com/tikupc/singledetail/9d622e3f5727a5e9856a612b', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991536408985602', 'https://tiku.baidu.com/tikupc/singledetail/cb5f89c24028915f804dc260', '1025991528162983938', '0');
INSERT INTO `crawler_question` VALUES ('1025991536408985603', 'https://tiku.baidu.com/tikupc/singledetail/51d2360cba1aa8114431d902', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991536509648897', 'https://tiku.baidu.com/tikupc/singledetail/d7e5cc2f0066f5335a812138', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991536509648898', 'https://tiku.baidu.com/tikupc/singledetail/d8156edb6f1aff00bed51e02', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991536534814722', 'https://tiku.baidu.com/tikupc/singledetail/1178f46527d3240c8447ef08', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991536534814723', 'https://tiku.baidu.com/tikupc/singledetail/e8ddf542336c1eb91a375dab', '1025991528162983938', '0');
INSERT INTO `crawler_question` VALUES ('1025991536564174850', 'https://tiku.baidu.com/tikupc/singledetail/c84b162ded630b1c59eeb5a5', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991536664838145', 'https://tiku.baidu.com/tikupc/singledetail/de0584c24028915f804dc23a', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991536673226754', 'https://tiku.baidu.com/tikupc/singledetail/1bd3d5bbfd0a79563c1e7215', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991536673226755', 'https://tiku.baidu.com/tikupc/singledetail/c6ee3186bceb19e8b8f6ba3d', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991536673226756', 'https://tiku.baidu.com/tikupc/singledetail/5e9f53e79b89680203d82503', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991536799055875', 'https://tiku.baidu.com/tikupc/singledetail/3eea0242a8956bec0975e316', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991536799055874', 'https://tiku.baidu.com/tikupc/singledetail/16d0c184b9d528ea81c7799e', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991536836804610', 'https://tiku.baidu.com/tikupc/singledetail/809b02d276a20029bd642d1f', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991536836804609', 'https://tiku.baidu.com/tikupc/singledetail/90e45022aaea998fcc220e3d', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991536845193219', 'https://tiku.baidu.com/tikupc/singledetail/4e3959eef8c75fbfc77db220', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991536845193218', 'https://tiku.baidu.com/tikupc/singledetail/7be978563c1ec5da50e270e6', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991536971022338', 'https://tiku.baidu.com/tikupc/singledetail/fe4b581b6bd97f192279e947', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991536971022339', 'https://tiku.baidu.com/tikupc/singledetail/74c0e009581b6bd97f19ea2f', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991537063297025', 'https://tiku.baidu.com/tikupc/singledetail/7d530875f46527d3240ce0ba', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991537012965378', 'https://tiku.baidu.com/tikupc/singledetail/8e8beffdc8d376eeaeaa31bb', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991537088462849', 'https://tiku.baidu.com/tikupc/singledetail/5f3fed3a87c24028915fc3bf', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991537101045761', 'https://tiku.baidu.com/tikupc/singledetail/c943a6c30c22590102029d46', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991537122017281', 'https://tiku.baidu.com/tikupc/singledetail/4fd550e2524de518964b7d0a', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991537189126146', 'https://tiku.baidu.com/tikupc/singledetail/fb62760bf78a6529647d539c', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991537176543233', 'https://tiku.baidu.com/tikupc/singledetail/958da9114431b90d6c85c792', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991537205903362', 'https://tiku.baidu.com/tikupc/singledetail/ce5d650e52ea551810a68746', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991537205903363', 'https://tiku.baidu.com/tikupc/singledetail/c74c3086bceb19e8b8f6ba9f', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991537273012226', 'https://tiku.baidu.com/tikupc/singledetail/a17f33687e21af45b307a83d', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991537273012227', 'https://tiku.baidu.com/tikupc/singledetail/1b1cb81aa8114431b90dd815', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991537289789442', 'https://tiku.baidu.com/tikupc/singledetail/40bc4a35eefdc8d376ee329c', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991537365286915', 'https://tiku.baidu.com/tikupc/singledetail/d6fea31614791711cc7917e9', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991537365286914', 'https://tiku.baidu.com/tikupc/singledetail/1f3baf45b307e87101f6961f', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991537365286913', 'https://tiku.baidu.com/tikupc/singledetail/9c1dab00b52acfc789ebc9df', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991537461755906', 'https://tiku.baidu.com/tikupc/singledetail/2e07fad6195f312b3169a51e', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991537461755907', 'https://tiku.baidu.com/tikupc/singledetail/341302020740be1e650e9a17', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991537478533122', 'https://tiku.baidu.com/tikupc/singledetail/ceae80eb6294dd88d0d26b78', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991537533059074', 'https://tiku.baidu.com/tikupc/singledetail/72d6e209581b6bd97f19ea39', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991537533059075', 'https://tiku.baidu.com/tikupc/singledetail/11cd36b765ce0508763213b1', '1025991523205316612', '0');
INSERT INTO `crawler_question` VALUES ('1025991537533059076', 'https://tiku.baidu.com/tikupc/singledetail/be7b5ebfc77da26925c5b0b9', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991537533059077', 'https://tiku.baidu.com/tikupc/singledetail/6e08944bcf84b9d528ea7a15', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991537633722369', 'https://tiku.baidu.com/tikupc/singledetail/de0fe518964bcf84b9d57b47', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991537633722370', 'https://tiku.baidu.com/tikupc/singledetail/bf91aeaad1f34693daef3e7a', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991537633722372', 'https://tiku.baidu.com/tikupc/singledetail/7dd6ba68a98271fe910ef9d9', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991537633722371', 'https://tiku.baidu.com/tikupc/singledetail/a91e804d2b160b4e767fcf44', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991537738579970', 'https://tiku.baidu.com/tikupc/singledetail/aa890029bd64783e09122b2e', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991537793105922', 'https://tiku.baidu.com/tikupc/singledetail/e950a21614791711cc791747', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991537793105923', 'https://tiku.baidu.com/tikupc/singledetail/d55ece2f0066f5335a812183', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991537818271745', 'https://tiku.baidu.com/tikupc/singledetail/a2c9fe4733687e21af45a983', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991537793105921', 'https://tiku.baidu.com/tikupc/singledetail/f20718e8b8f67c1cfad6b8e9', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991537780523009', 'https://tiku.baidu.com/tikupc/singledetail/a71c8662caaedd3383c4d39f', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991537843437569', 'https://tiku.baidu.com/tikupc/singledetail/3740bed126fff705cc170a67', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991537843437570', 'https://tiku.baidu.com/tikupc/singledetail/d5f8ce2f0066f5335a812125', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991537868603394', 'https://tiku.baidu.com/tikupc/singledetail/ef81590216fc700abb68fcbe', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991537868603395', 'https://tiku.baidu.com/tikupc/singledetail/7a4e79563c1ec5da50e27041', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991537868603393', 'https://tiku.baidu.com/tikupc/singledetail/681aa300a6c30c2259019e03', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991537914740737', 'https://tiku.baidu.com/tikupc/singledetail/69fabf1e650e52ea551898bf', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991538002821122', 'https://tiku.baidu.com/tikupc/singledetail/6231cd22bcd126fff7050bbb', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991537793105924', 'https://tiku.baidu.com/tikupc/singledetail/57ebbaf67c1cfad6195fa706', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991538090901505', 'https://tiku.baidu.com/tikupc/singledetail/6738a45177232f60ddcca154', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991538090901507', 'https://tiku.baidu.com/tikupc/singledetail/cc5027284b73f242336c5f28', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991538090901506', 'https://tiku.baidu.com/tikupc/singledetail/b427a98271fe910ef12df84a', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991538090901508', 'https://tiku.baidu.com/tikupc/singledetail/1803c67da26925c52cc5bfb9', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991538174787585', 'https://tiku.baidu.com/tikupc/singledetail/b2004128915f804d2b16c1c7', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991538174787586', 'https://tiku.baidu.com/tikupc/singledetail/4356d1d233d4b14e852468db', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991538233507842', 'https://tiku.baidu.com/tikupc/singledetail/cf09a5e9856a561252d36f2b', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991538233507841', 'https://tiku.baidu.com/tikupc/singledetail/100659f5f61fb7360b4c65c4', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991538254479361', 'https://tiku.baidu.com/tikupc/singledetail/9f37c850ad02de80d4d84078', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991538288033793', 'https://tiku.baidu.com/tikupc/singledetail/6827a300a6c30c2259019e3e', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991538321588226', 'https://tiku.baidu.com/tikupc/singledetail/d9a6e418964bcf84b9d57bee', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991538350948355', 'https://tiku.baidu.com/tikupc/singledetail/5a87941ea76e58fafab0037a', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991538338365442', 'https://tiku.baidu.com/tikupc/singledetail/930ab04e852458fb770b56db', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991538350948354', 'https://tiku.baidu.com/tikupc/singledetail/fb4a9b6648d7c1c708a1452b', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991538350948356', 'https://tiku.baidu.com/tikupc/singledetail/2f052f60ddccda38376baf23', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991538350948353', 'https://tiku.baidu.com/tikupc/singledetail/87dddc36a32d7375a41780f9', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991538447417345', 'https://tiku.baidu.com/tikupc/singledetail/53edb9f3f90f76c661371a3d', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991538447417346', 'https://tiku.baidu.com/tikupc/singledetail/4fc150e2524de518964b7d1e', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991538485166082', 'https://tiku.baidu.com/tikupc/singledetail/70ad33d4b14e852458fb577a', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991538615189506', 'https://tiku.baidu.com/tikupc/singledetail/5d27951ea76e58fafab003da', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991538623578114', 'https://tiku.baidu.com/tikupc/singledetail/40dd24fff705cc1755270909', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991538640355329', 'https://tiku.baidu.com/tikupc/singledetail/6326783e0912a21614792947', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991538640355330', 'https://tiku.baidu.com/tikupc/singledetail/b426f111f18583d049645914', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991538631966722', 'https://tiku.baidu.com/tikupc/singledetail/6261b7360b4c2e3f5727637b', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991538657132547', 'https://tiku.baidu.com/tikupc/singledetail/918bef06eff9aef8941e06b9', '1025991530922835970', '0');
INSERT INTO `crawler_question` VALUES ('1025991538682298369', 'https://tiku.baidu.com/tikupc/singledetail/cdc5b307e87101f69e319585', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991538657132546', 'https://tiku.baidu.com/tikupc/singledetail/ccf953d380eb6294dd886cee', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991538736824322', 'https://tiku.baidu.com/tikupc/singledetail/afe1fab069dc5022aaea001e', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991538736824323', 'https://tiku.baidu.com/tikupc/singledetail/dd38bd64783e0912a2162a14', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991538808127490', 'https://tiku.baidu.com/tikupc/singledetail/1090842458fb770bf78a55db', '1025991530922835970', '0');
INSERT INTO `crawler_question` VALUES ('1025991538808127489', 'https://tiku.baidu.com/tikupc/singledetail/997a6037ee06eff9aef807b9', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991538808127491', 'https://tiku.baidu.com/tikupc/singledetail/ff0bdc88d0d233d4b14e699a', '1025991531208048642', '0');
INSERT INTO `crawler_question` VALUES ('1025991538862653442', 'https://tiku.baidu.com/tikupc/singledetail/194fba1aa8114431b90dd846', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991538862653443', 'https://tiku.baidu.com/tikupc/singledetail/16741ed9ad51f01dc281f117', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991538917179394', 'https://tiku.baidu.com/tikupc/singledetail/2125ad45b307e87101f69601', '1025991531208048642', '0');
INSERT INTO `crawler_question` VALUES ('1025991538917179393', 'https://tiku.baidu.com/tikupc/singledetail/1aa3c47da26925c52cc5bf19', '1025991530922835970', '0');
INSERT INTO `crawler_question` VALUES ('1025991538933956610', 'https://tiku.baidu.com/tikupc/singledetail/5fd0f08583d049649b6658c4', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991538996871171', 'https://tiku.baidu.com/tikupc/singledetail/b474a98271fe910ef12df819', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991538996871170', 'https://tiku.baidu.com/tikupc/singledetail/9512b52acfc789eb172dc817', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991539063980033', 'https://tiku.baidu.com/tikupc/singledetail/1ea8f56527d3240c8447efd8', '1025991531208048642', '0');
INSERT INTO `crawler_question` VALUES ('1025991539076562945', 'https://tiku.baidu.com/tikupc/singledetail/df07866fb84ae45c3b358c15', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991539164643330', 'https://tiku.baidu.com/tikupc/singledetail/77bddcccda38376baf1faed8', '1025991531208048642', '0');
INSERT INTO `crawler_question` VALUES ('1025991539173031938', 'https://tiku.baidu.com/tikupc/singledetail/0333482fb4daa58da0114a15', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991539256918018', 'https://tiku.baidu.com/tikupc/singledetail/6164a76e58fafab069dc027f', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991539265306625', 'https://tiku.baidu.com/tikupc/singledetail/601b590102020740be1e9b3c', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991539311443969', 'https://tiku.baidu.com/tikupc/singledetail/2bfccad376eeaeaad1f33004', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991539353387010', 'https://tiku.baidu.com/tikupc/singledetail/7a7679563c1ec5da50e27079', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991539361775617', 'https://tiku.baidu.com/tikupc/singledetail/6c3b0740be1e650e52ea993c', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991539412107265', 'https://tiku.baidu.com/tikupc/singledetail/6f9b0640be1e650e52ea999c', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991539428884481', 'https://tiku.baidu.com/tikupc/singledetail/61f504a1b0717fd5360cdc0e', '1025991531497455617', '0');
INSERT INTO `crawler_question` VALUES ('1025991539428884482', 'https://tiku.baidu.com/tikupc/singledetail/6595cc22bcd126fff7050b1f', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991539475021826', 'https://tiku.baidu.com/tikupc/singledetail/986d69eae009581b6bd9eb2f', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991539475021825', 'https://tiku.baidu.com/tikupc/singledetail/51c7360cba1aa8114431d917', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991539475021827', 'https://tiku.baidu.com/tikupc/singledetail/8a67a8114431b90d6c85c778', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991539533742083', 'https://tiku.baidu.com/tikupc/singledetail/80d602d276a20029bd642d52', '1025991531497455617', '0');
INSERT INTO `crawler_question` VALUES ('1025991539533742082', 'https://tiku.baidu.com/tikupc/singledetail/9d6a7fd5360cba1aa811da1e', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991539533742081', 'https://tiku.baidu.com/tikupc/singledetail/38f90042a8956bec0975e305', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991539676348417', 'https://tiku.baidu.com/tikupc/singledetail/53f7fd0a79563c1ec5da7149', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991539676348419', 'https://tiku.baidu.com/tikupc/singledetail/d3708e9951e79b8968022603', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991539676348418', 'https://tiku.baidu.com/tikupc/singledetail/6248b7360b4c2e3f57276352', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991539735068674', 'https://tiku.baidu.com/tikupc/singledetail/a9faabea998fcc22bcd10ddd', '1025991531497455617', '0');
INSERT INTO `crawler_question` VALUES ('1025991539735068673', 'https://tiku.baidu.com/tikupc/singledetail/a944804d2b160b4e767fcf1e', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991539743457281', 'https://tiku.baidu.com/tikupc/singledetail/6254cd22bcd126fff7050bde', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991539793788931', 'https://tiku.baidu.com/tikupc/singledetail/2f51b1717fd5360cba1adbf5', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991539793788930', 'https://tiku.baidu.com/tikupc/singledetail/029e69dc5022aaea998f0f2b', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991539793788932', 'https://tiku.baidu.com/tikupc/singledetail/0a31cf1755270722192ef730', '1025991531497455617', '0');
INSERT INTO `crawler_question` VALUES ('1025991539793788933', 'https://tiku.baidu.com/tikupc/singledetail/4a645acfa1c7aa00b52acb1e', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991539793788934', 'https://tiku.baidu.com/tikupc/singledetail/22490b4c2e3f5727a5e9627a', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991539793788935', 'https://tiku.baidu.com/tikupc/singledetail/d83677a20029bd64783e2ce1', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991539923812353', 'https://tiku.baidu.com/tikupc/singledetail/946b6f37ee06eff9aef807a8', '1025991531090608131', '0');
INSERT INTO `crawler_question` VALUES ('1025991539923812355', 'https://tiku.baidu.com/tikupc/singledetail/12a80a4e767f5acfa1c7cdbb', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991539923812356', 'https://tiku.baidu.com/tikupc/singledetail/1a0d710abb68a98271fefaf4', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991539881869314', 'https://tiku.baidu.com/tikupc/singledetail/b9002b160b4e767f5acfce48', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991539995115522', 'https://tiku.baidu.com/tikupc/singledetail/0b98a58da0116c175f0e4847', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991540087390209', 'https://tiku.baidu.com/tikupc/singledetail/5e1a2279168884868762d606', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991540087390210', 'https://tiku.baidu.com/tikupc/singledetail/a15633687e21af45b307a814', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991540158693377', 'https://tiku.baidu.com/tikupc/singledetail/ba7bc6da50e2524de5187e60', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991540158693378', 'https://tiku.baidu.com/tikupc/singledetail/2da3fbd6195f312b3169a5ba', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991540171276289', 'https://tiku.baidu.com/tikupc/singledetail/6851a300a6c30c2259019e48', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991540192247811', 'https://tiku.baidu.com/tikupc/singledetail/358b84868762caaedd33d406', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991540192247812', 'https://tiku.baidu.com/tikupc/singledetail/c74a3086bceb19e8b8f6ba99', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991540192247813', 'https://tiku.baidu.com/tikupc/singledetail/3004767f5acfa1c7aa00cc4f', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991540192247814', 'https://tiku.baidu.com/tikupc/singledetail/fe01bcdaa58da0116c17492b', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991540313882626', 'https://tiku.baidu.com/tikupc/singledetail/540bed630b1c59eef8c7b423', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991540439711746', 'https://tiku.baidu.com/tikupc/singledetail/35a384868762caaedd33d42e', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991540439711747', 'https://tiku.baidu.com/tikupc/singledetail/378286868762caaedd33d40f', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991540485849089', 'https://tiku.baidu.com/tikupc/singledetail/283ac9d376eeaeaad1f330c2', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991540485849090', 'https://tiku.baidu.com/tikupc/singledetail/6594cc22bcd126fff7050b1e', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991540548763651', 'https://tiku.baidu.com/tikupc/singledetail/bd2903d8ce2f0066f533222e', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991540548763652', 'https://tiku.baidu.com/tikupc/singledetail/5fddf10f76c66137ee06192b', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991540548763650', 'https://tiku.baidu.com/tikupc/singledetail/77af915f804d2b160b4ec082', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991540678787074', 'https://tiku.baidu.com/tikupc/singledetail/0a1f50ea551810a6f5248614', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991540678787073', 'https://tiku.baidu.com/tikupc/singledetail/1dfb6294dd88d0d233d46a15', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991540678787075', 'https://tiku.baidu.com/tikupc/singledetail/4c7a58cfa1c7aa00b52acb00', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991540703952897', 'https://tiku.baidu.com/tikupc/singledetail/685b964bcf84b9d528ea7a46', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991540745895937', 'https://tiku.baidu.com/tikupc/singledetail/45a166ec102de2bd96058891', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991540485849091', 'https://tiku.baidu.com/tikupc/singledetail/bfe15fbfc77da26925c5b023', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991540775256067', 'https://tiku.baidu.com/tikupc/singledetail/69a7d2f34693daef5ef73d08', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991540775256066', 'https://tiku.baidu.com/tikupc/singledetail/92d0b14e852458fb770b5601', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991540800421890', 'https://tiku.baidu.com/tikupc/singledetail/78137b563c1ec5da50e2701c', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991540703952898', 'https://tiku.baidu.com/tikupc/singledetail/42c115791711cc7931b716d2', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991540800421891', 'https://tiku.baidu.com/tikupc/singledetail/8d22eefdc8d376eeaeaa3112', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991540863336449', 'https://tiku.baidu.com/tikupc/singledetail/93f1f6ec4afe04a1b071deb8', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991540863336451', 'https://tiku.baidu.com/tikupc/singledetail/af200112a21614791711281b', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991540863336450', 'https://tiku.baidu.com/tikupc/singledetail/672da45177232f60ddcca141', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991540892696578', 'https://tiku.baidu.com/tikupc/singledetail/c22d647d27284b73f2425001', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991540892696577', 'https://tiku.baidu.com/tikupc/singledetail/ae950a1c59eef8c75fbfb3f3', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991540892696581', 'https://tiku.baidu.com/tikupc/singledetail/a04bfc4733687e21af45a901', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991540892696580', 'https://tiku.baidu.com/tikupc/singledetail/d7faf4335a8102d276a22f99', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991540980776961', 'https://tiku.baidu.com/tikupc/singledetail/69a7974bcf84b9d528ea7aba', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991540980776962', 'https://tiku.baidu.com/tikupc/singledetail/10f456fb770bf78a652954d5', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991541022720001', 'https://tiku.baidu.com/tikupc/singledetail/4d40312b3169a4517723a31a', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991541068857347', 'https://tiku.baidu.com/tikupc/singledetail/f7f57e1cfad6195f312ba606', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991541068857345', 'https://tiku.baidu.com/tikupc/singledetail/67e3a1c7aa00b52acfc7ca29', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991541068857348', 'https://tiku.baidu.com/tikupc/singledetail/786c7b563c1ec5da50e27063', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991541068857346', 'https://tiku.baidu.com/tikupc/singledetail/527d6429647d27284b7351f2', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991541135966209', 'https://tiku.baidu.com/tikupc/singledetail/1889f36527d3240c8447eff9', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991541135966210', 'https://tiku.baidu.com/tikupc/singledetail/6f042dc58bd63186bcebbcc4', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991541182103554', 'https://tiku.baidu.com/tikupc/singledetail/09c9a78da0116c175f0e4816', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991541207269380', 'https://tiku.baidu.com/tikupc/singledetail/f4941511cc7931b765ce15e8', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991541207269379', 'https://tiku.baidu.com/tikupc/singledetail/a15833687e21af45b307a81a', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991541207269378', 'https://tiku.baidu.com/tikupc/singledetail/df3a866fb84ae45c3b358c28', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991541286961154', 'https://tiku.baidu.com/tikupc/singledetail/1b95a2116c175f0e7cd1371d', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991541370847235', 'https://tiku.baidu.com/tikupc/singledetail/d203ea7101f69e3143329401', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991541370847236', 'https://tiku.baidu.com/tikupc/singledetail/396d0342a8956bec0975e391', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991541672837122', 'https://tiku.baidu.com/tikupc/singledetail/340302020740be1e650e9a07', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991541370847234', 'https://tiku.baidu.com/tikupc/singledetail/cc6627284b73f242336c5f1e', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991541370847233', 'https://tiku.baidu.com/tikupc/singledetail/54d30622192e45361066f5f1', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991541748334594', 'https://tiku.baidu.com/tikupc/singledetail/8fbd4a73f242336c1eb95e90', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991541748334595', 'https://tiku.baidu.com/tikupc/singledetail/536b7e21af45b307e8719706', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991541748334593', 'https://tiku.baidu.com/tikupc/singledetail/6763d5d8d15abe23482f4de6', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991541748334597', 'https://tiku.baidu.com/tikupc/singledetail/340202020740be1e650e9a06', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991541748334596', 'https://tiku.baidu.com/tikupc/singledetail/ce02650e52ea551810a68719', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991541958049794', 'https://tiku.baidu.com/tikupc/singledetail/dc97bc64783e0912a2162abb', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991541974827009', 'https://tiku.baidu.com/tikupc/singledetail/f35577232f60ddccda38a001', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991541966438401', 'https://tiku.baidu.com/tikupc/singledetail/12fd0a4e767f5acfa1c7cdee', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991541983215617', 'https://tiku.baidu.com/tikupc/singledetail/fa6cb84ae45c3b3567ec8b06', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991541983215618', 'https://tiku.baidu.com/tikupc/singledetail/7735915f804d2b160b4ec018', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991542033547267', 'https://tiku.baidu.com/tikupc/singledetail/2c135a8102d276a200292e25', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991542033547266', 'https://tiku.baidu.com/tikupc/singledetail/6c80ae1ffc4ffe473368abee', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991542033547268', 'https://tiku.baidu.com/tikupc/singledetail/fef53d1ec5da50e2524d7fa6', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991542109044737', 'https://tiku.baidu.com/tikupc/singledetail/606905a1b0717fd5360cdc92', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991542117433346', 'https://tiku.baidu.com/tikupc/singledetail/4fd950e2524de518964b7d06', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991542117433347', 'https://tiku.baidu.com/tikupc/singledetail/f1123c1ec5da50e2524d7f41', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991542218096642', 'https://tiku.baidu.com/tikupc/singledetail/57060722192e45361066f524', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991542251651073', 'https://tiku.baidu.com/tikupc/singledetail/801d0408763231126edb11d6', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991542218096641', 'https://tiku.baidu.com/tikupc/singledetail/5c00f38583d049649b665814', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991542268428289', 'https://tiku.baidu.com/tikupc/singledetail/f605b4daa58da0116c17492f', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991542251651074', 'https://tiku.baidu.com/tikupc/singledetail/8d04dbef5ef7ba0d4a733b92', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991542276816897', 'https://tiku.baidu.com/tikupc/singledetail/8d2beefdc8d376eeaeaa311b', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991542310371329', 'https://tiku.baidu.com/tikupc/singledetail/cd840c225901020207409c42', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991542390063107', 'https://tiku.baidu.com/tikupc/singledetail/b4fec4da50e2524de5187ee5', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991542390063106', 'https://tiku.baidu.com/tikupc/singledetail/03cb321ec5da50e2524d7f98', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991542419423234', 'https://tiku.baidu.com/tikupc/singledetail/65a7a0116c175f0e7cd1372f', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991542478143490', 'https://tiku.baidu.com/tikupc/singledetail/9eac2f3f5727a5e9856a61e5', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991542478143489', 'https://tiku.baidu.com/tikupc/singledetail/fcb4dd88d0d233d4b14e6925', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991542536863745', 'https://tiku.baidu.com/tikupc/singledetail/aa1aaaea998fcc22bcd10d3d', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991542507503618', 'https://tiku.baidu.com/tikupc/singledetail/4e19b7d528ea81c758f57898', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991542637527044', 'https://tiku.baidu.com/tikupc/singledetail/beac6bec0975f46527d3e13c', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991542637527042', 'https://tiku.baidu.com/tikupc/singledetail/a36cf621dd36a32d737581d6', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991542637527043', 'https://tiku.baidu.com/tikupc/singledetail/fc90c1c708a1284ac8504342', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991542708830210', 'https://tiku.baidu.com/tikupc/singledetail/86466137ee06eff9aef80785', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991542700441601', 'https://tiku.baidu.com/tikupc/singledetail/7e28930ef12d2af90242e6d3', '1025991526103580677', '0');
INSERT INTO `crawler_question` VALUES ('1025991542591389698', 'https://tiku.baidu.com/tikupc/singledetail/8d1feefdc8d376eeaeaa312f', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991542759161858', 'https://tiku.baidu.com/tikupc/singledetail/515758fafab069dc5022013c', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991542801104898', 'https://tiku.baidu.com/tikupc/singledetail/14ff9ec3d5bbfd0a7956733c', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991542801104897', 'https://tiku.baidu.com/tikupc/singledetail/417ceb3a87c24028915fc3fc', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991542817882113', 'https://tiku.baidu.com/tikupc/singledetail/c6513186bceb19e8b8f6ba82', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991542817882115', 'https://tiku.baidu.com/tikupc/singledetail/516d011ca300a6c30c229f00', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991542817882114', 'https://tiku.baidu.com/tikupc/singledetail/c58be63a580216fc700afd0f', '1025991526103580677', '0');
INSERT INTO `crawler_question` VALUES ('1025991542864019457', 'https://tiku.baidu.com/tikupc/singledetail/8aa9daef5ef7ba0d4a733b3f', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991542897573893', 'https://tiku.baidu.com/tikupc/singledetail/f402cc7931b765ce05081416', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991542918545409', 'https://tiku.baidu.com/tikupc/singledetail/de83876fb84ae45c3b358c91', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991542897573892', 'https://tiku.baidu.com/tikupc/singledetail/e2022af90242a8956bece42a', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991542897573890', 'https://tiku.baidu.com/tikupc/singledetail/712fb2eb19e8b8f67c1cb9ac', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991542918545410', 'https://tiku.baidu.com/tikupc/singledetail/9754ab114431b90d6c85c74b', '1025991526103580677', '0');
INSERT INTO `crawler_question` VALUES ('1025991542977265666', 'https://tiku.baidu.com/tikupc/singledetail/3118bcd126fff705cc170a3f', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991542985654273', 'https://tiku.baidu.com/tikupc/singledetail/860bdd36a32d7375a417802f', '1025991534584463361', '0');
INSERT INTO `crawler_question` VALUES ('1025991543019208707', 'https://tiku.baidu.com/tikupc/singledetail/097fa417866fb84ae45c8d0f', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991543019208706', 'https://tiku.baidu.com/tikupc/singledetail/ebd524c52cc58bd63186bdb9', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991543019208708', 'https://tiku.baidu.com/tikupc/singledetail/f7c7cf7931b765ce050814d3', '1025991526103580677', '0');
INSERT INTO `crawler_question` VALUES ('1025991543019208710', 'https://tiku.baidu.com/tikupc/singledetail/d9eef705cc17552707220814', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991543019208711', 'https://tiku.baidu.com/tikupc/singledetail/9d592e3f5727a5e9856a6110', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991543019208705', 'https://tiku.baidu.com/tikupc/singledetail/60fe8bd63186bceb19e8bb3e', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991543132454913', 'https://tiku.baidu.com/tikupc/singledetail/6012590102020740be1e9b35', '1025991534584463361', '0');
INSERT INTO `crawler_question` VALUES ('1025991543228923906', 'https://tiku.baidu.com/tikupc/singledetail/f625b4daa58da0116c17490f', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991543270866945', 'https://tiku.baidu.com/tikupc/singledetail/30fbbdd126fff705cc170adc', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991543270866946', 'https://tiku.baidu.com/tikupc/singledetail/232b598102d276a200292e1d', '1025991526103580677', '0');
INSERT INTO `crawler_question` VALUES ('1025991543291838466', 'https://tiku.baidu.com/tikupc/singledetail/1f63af45b307e87101f69647', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991543325392897', 'https://tiku.baidu.com/tikupc/singledetail/1d3d453610661ed9ad51f316', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991543325392898', 'https://tiku.baidu.com/tikupc/singledetail/5af6941ea76e58fafab0030b', '1025991534584463361', '0');
INSERT INTO `crawler_question` VALUES ('1025991543371530242', 'https://tiku.baidu.com/tikupc/singledetail/5e3bf18583d049649b66582f', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991543379918850', 'https://tiku.baidu.com/tikupc/singledetail/18f24493daef5ef7ba0d3c04', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991543379918849', 'https://tiku.baidu.com/tikupc/singledetail/4089d2d233d4b14e85246804', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991543455416322', 'https://tiku.baidu.com/tikupc/singledetail/7eef0b75f46527d3240ce006', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991543455416323', 'https://tiku.baidu.com/tikupc/singledetail/b51dc5da50e2524de5187e06', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991543430250498', 'https://tiku.baidu.com/tikupc/singledetail/6037590102020740be1e9b10', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991543455416324', 'https://tiku.baidu.com/tikupc/singledetail/a15733687e21af45b307a815', '1025991534584463361', '0');
INSERT INTO `crawler_question` VALUES ('1025991543539302401', 'https://tiku.baidu.com/tikupc/singledetail/f8c1c381e53a580216fcfed9', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991543623188481', 'https://tiku.baidu.com/tikupc/singledetail/8f1988eb172ded630b1cb6db', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991543648354306', 'https://tiku.baidu.com/tikupc/singledetail/1bd7700abb68a98271fefa2e', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991543648354307', 'https://tiku.baidu.com/tikupc/singledetail/242f3968011ca300a6c39018', '1025991534584463361', '0');
INSERT INTO `crawler_question` VALUES ('1025991543656742913', 'https://tiku.baidu.com/tikupc/singledetail/08decd1755270722192ef7d9', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991543719657474', 'https://tiku.baidu.com/tikupc/singledetail/5899326c1eb91a37f1115cde', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991543753211906', 'https://tiku.baidu.com/tikupc/singledetail/53bffd0a79563c1ec5da7101', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991543832903682', 'https://tiku.baidu.com/tikupc/singledetail/14dfbfd5b9f3f90f76c61bda', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991543870652418', 'https://tiku.baidu.com/tikupc/singledetail/20c6551810a6f524ccbf8529', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991543879041026', 'https://tiku.baidu.com/tikupc/singledetail/5f0e50e79b89680203d82592', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991543971315714', 'https://tiku.baidu.com/tikupc/singledetail/c3b0657d27284b73f242509c', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991543971315713', 'https://tiku.baidu.com/tikupc/singledetail/8edf89eb172ded630b1cb61d', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991544071979010', 'https://tiku.baidu.com/tikupc/singledetail/603a590102020740be1e9b1d', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991544071979011', 'https://tiku.baidu.com/tikupc/singledetail/fb3a760bf78a6529647d53c4', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991544147476482', 'https://tiku.baidu.com/tikupc/singledetail/1f12561252d380eb62946d7d', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991544181030914', 'https://tiku.baidu.com/tikupc/singledetail/8121376baf1ffc4ffe47ac1c', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991544181030915', 'https://tiku.baidu.com/tikupc/singledetail/6329970590c69ec3d5bb7591', '1025991535167471618', '0');
INSERT INTO `crawler_question` VALUES ('1025991544214585346', 'https://tiku.baidu.com/tikupc/singledetail/8ab0cec789eb172ded63b79f', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991544285888514', 'https://tiku.baidu.com/tikupc/singledetail/347f02020740be1e650e9a7b', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991544311054338', 'https://tiku.baidu.com/tikupc/singledetail/51ca6529647d27284b735145', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991544311054339', 'https://tiku.baidu.com/tikupc/singledetail/a65bb84cf7ec4afe04a1df9a', '1025991535167471618', '0');
INSERT INTO `crawler_question` VALUES ('1025991544361385986', 'https://tiku.baidu.com/tikupc/singledetail/2d89fbd6195f312b3169a590', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991544361385987', 'https://tiku.baidu.com/tikupc/singledetail/9d152e3f5727a5e9856a615c', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991544403329025', 'https://tiku.baidu.com/tikupc/singledetail/999fbd0d4a7302768e99396d', '1025991535167471618', '0');
INSERT INTO `crawler_question` VALUES ('1025991544436883457', 'https://tiku.baidu.com/tikupc/singledetail/abdfbb4cf7ec4afe04a1df1e', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991544512380930', 'https://tiku.baidu.com/tikupc/singledetail/26a758fb770bf78a65295486', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991544520769538', 'https://tiku.baidu.com/tikupc/singledetail/b2554128915f804d2b16c192', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991544562712578', 'https://tiku.baidu.com/tikupc/singledetail/b9aa5ee2524de518964b7d75', '1025991535167471618', '0');
INSERT INTO `crawler_question` VALUES ('1025991544617238529', 'https://tiku.baidu.com/tikupc/singledetail/f73dcc1755270722192ef73d', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991544680153089', 'https://tiku.baidu.com/tikupc/singledetail/0bd850f5f61fb7360b4c651a', '1025991535167471618', '0');
INSERT INTO `crawler_question` VALUES ('1025991544705318914', 'https://tiku.baidu.com/tikupc/singledetail/1412de80d4d8d15abe234e15', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991544730484738', 'https://tiku.baidu.com/tikupc/singledetail/342b02020740be1e650e9a2f', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991544764039170', 'https://tiku.baidu.com/tikupc/singledetail/562def630b1c59eef8c7b405', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991544801787905', 'https://tiku.baidu.com/tikupc/singledetail/a72e0912a216147917112815', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991544810176513', 'https://tiku.baidu.com/tikupc/singledetail/99124431b90d6c85ec3ac606', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991544843730946', 'https://tiku.baidu.com/tikupc/singledetail/b4c4c4da50e2524de5187edf', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991544915034114', 'https://tiku.baidu.com/tikupc/singledetail/f3d319e8b8f67c1cfad6b83d', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991544936005635', 'https://tiku.baidu.com/tikupc/singledetail/37d72aea81c758f5f61f6707', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991544936005634', 'https://tiku.baidu.com/tikupc/singledetail/f529cfc789eb172ded63b706', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991544936005636', 'https://tiku.baidu.com/tikupc/singledetail/65daa0116c175f0e7cd13752', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991544982142978', 'https://tiku.baidu.com/tikupc/singledetail/261b10a6f524ccbff1218406', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991545040863235', 'https://tiku.baidu.com/tikupc/singledetail/4bda7f19227916888486d706', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991545040863234', 'https://tiku.baidu.com/tikupc/singledetail/325f747f5acfa1c7aa00cc14', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991545061834753', 'https://tiku.baidu.com/tikupc/singledetail/5ac0941ea76e58fafab0033d', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991545082806274', 'https://tiku.baidu.com/tikupc/singledetail/542eed630b1c59eef8c7b406', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991545082806275', 'https://tiku.baidu.com/tikupc/singledetail/c27c25284b73f242336c5f04', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991545082806273', 'https://tiku.baidu.com/tikupc/singledetail/e2ad2af90242a8956bece485', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991545128943618', 'https://tiku.baidu.com/tikupc/singledetail/1b134793daef5ef7ba0d3ce5', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991545128943619', 'https://tiku.baidu.com/tikupc/singledetail/babaf121dd36a32d73758100', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991545145720833', 'https://tiku.baidu.com/tikupc/singledetail/1ed3ae45b307e87101f696f7', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991545175080962', 'https://tiku.baidu.com/tikupc/singledetail/a261caaedd3383c4bb4cd206', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991545212829699', 'https://tiku.baidu.com/tikupc/singledetail/163f1ed9ad51f01dc281f15c', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991545212829701', 'https://tiku.baidu.com/tikupc/singledetail/1bd3700abb68a98271fefa2a', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991545212829698', 'https://tiku.baidu.com/tikupc/singledetail/80d8366baf1ffc4ffe47ace5', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991545212829702', 'https://tiku.baidu.com/tikupc/singledetail/dcb5bc64783e0912a2162a99', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991545321881601', 'https://tiku.baidu.com/tikupc/singledetail/db31bf64783e0912a2162a1d', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991545212829700', 'https://tiku.baidu.com/tikupc/singledetail/d9ebf705cc17552707220811', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991545321881603', 'https://tiku.baidu.com/tikupc/singledetail/9c787cd184254b35eefd3473', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991545321881602', 'https://tiku.baidu.com/tikupc/singledetail/cde90c225901020207409c2f', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991545401573379', 'https://tiku.baidu.com/tikupc/singledetail/d087e87101f69e3143329485', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991545401573378', 'https://tiku.baidu.com/tikupc/singledetail/53e0b9f3f90f76c661371a30', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991545401573380', 'https://tiku.baidu.com/tikupc/singledetail/5210b8f3f90f76c661371ac0', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991545401573381', 'https://tiku.baidu.com/tikupc/singledetail/6c3e0740be1e650e52ea9939', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991545401573382', 'https://tiku.baidu.com/tikupc/singledetail/8a5c6c85ec3a87c24028c454', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991545212829697', 'https://tiku.baidu.com/tikupc/singledetail/cef980eb6294dd88d0d26b2f', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991545510625282', 'https://tiku.baidu.com/tikupc/singledetail/cdd90c225901020207409c1f', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991545510625285', 'https://tiku.baidu.com/tikupc/singledetail/7779915f804d2b160b4ec054', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991545510625283', 'https://tiku.baidu.com/tikupc/singledetail/ecaddd3383c4bb4cf7ecd106', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991545510625286', 'https://tiku.baidu.com/tikupc/singledetail/83e30508763231126edb1128', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991545510625287', 'https://tiku.baidu.com/tikupc/singledetail/ddfb4afe04a1b0717fd5dd12', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991545510625284', 'https://tiku.baidu.com/tikupc/singledetail/30e3bdd126fff705cc170ac4', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991545628065795', 'https://tiku.baidu.com/tikupc/singledetail/82c19b89680203d8ce2f2423', '1025991535800811522', '0');
INSERT INTO `crawler_question` VALUES ('1025991545628065794', 'https://tiku.baidu.com/tikupc/singledetail/d1cc7ea20029bd64783e2c1b', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991545707757569', 'https://tiku.baidu.com/tikupc/singledetail/d99376a20029bd64783e2c44', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991545699368962', 'https://tiku.baidu.com/tikupc/singledetail/90885022aaea998fcc220e51', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991545716146179', 'https://tiku.baidu.com/tikupc/singledetail/b1d54028915f804d2b16c112', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991545716146177', 'https://tiku.baidu.com/tikupc/singledetail/6008590102020740be1e9b2f', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991545716146180', 'https://tiku.baidu.com/tikupc/singledetail/38f20042a8956bec0975e30e', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991545716146178', 'https://tiku.baidu.com/tikupc/singledetail/1115f46527d3240c8447ef65', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991545787449346', 'https://tiku.baidu.com/tikupc/singledetail/15c853ea551810a6f52486c3', '1025991535800811522', '0');
INSERT INTO `crawler_question` VALUES ('1025991545825198081', 'https://tiku.baidu.com/tikupc/singledetail/9c597cd184254b35eefd3452', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991545825198082', 'https://tiku.baidu.com/tikupc/singledetail/bebb284ac850ad02de80411f', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991545795837954', 'https://tiku.baidu.com/tikupc/singledetail/9998cdaedd3383c4bb4cd2ff', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991545850363907', 'https://tiku.baidu.com/tikupc/singledetail/b3931a37f111f18583d05a2f', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991545850363906', 'https://tiku.baidu.com/tikupc/singledetail/5817ec3a87c24028915fc397', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991545951027202', 'https://tiku.baidu.com/tikupc/singledetail/86876137ee06eff9aef80744', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991545971998721', 'https://tiku.baidu.com/tikupc/singledetail/148a9ec3d5bbfd0a79567349', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991545984581633', 'https://tiku.baidu.com/tikupc/singledetail/9a4902768e9951e79b89273f', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991545971998722', 'https://tiku.baidu.com/tikupc/singledetail/e039d2bbfd0a79563c1e72ff', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991546068467714', 'https://tiku.baidu.com/tikupc/singledetail/d97787c24028915f804dc248', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991546068467715', 'https://tiku.baidu.com/tikupc/singledetail/1f0aaf45b307e87101f6962e', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991546068467716', 'https://tiku.baidu.com/tikupc/singledetail/ccd554270722192e4536f6c7', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991546068467717', 'https://tiku.baidu.com/tikupc/singledetail/9fcaaa00b52acfc789ebc908', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991546068467718', 'https://tiku.baidu.com/tikupc/singledetail/47596bd97f1922791688e847', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991546122993666', 'https://tiku.baidu.com/tikupc/singledetail/24093968011ca300a6c3903e', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991546122993667', 'https://tiku.baidu.com/tikupc/singledetail/477ebed528ea81c758f578ff', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991546156548097', 'https://tiku.baidu.com/tikupc/singledetail/1703a8956bec0975f465e244', '1025991536673226757', '0');
INSERT INTO `crawler_question` VALUES ('1025991546156548098', 'https://tiku.baidu.com/tikupc/singledetail/7a2679563c1ec5da50e27029', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991546236239874', 'https://tiku.baidu.com/tikupc/singledetail/fb299b6648d7c1c708a14548', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991546236239873', 'https://tiku.baidu.com/tikupc/singledetail/85dffe00bed5b9f3f90f1cc0', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991546299154433', 'https://tiku.baidu.com/tikupc/singledetail/874f6e1aff00bed5b9f31d91', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991546328514563', 'https://tiku.baidu.com/tikupc/singledetail/6169a76e58fafab069dc0272', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991546328514564', 'https://tiku.baidu.com/tikupc/singledetail/99174431b90d6c85ec3ac603', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991546315931650', 'https://tiku.baidu.com/tikupc/singledetail/32ca49649b6648d7c1c7461f', '1025991536673226757', '0');
INSERT INTO `crawler_question` VALUES ('1025991546328514562', 'https://tiku.baidu.com/tikupc/singledetail/85b403768e9951e79b8927c2', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991546483703812', 'https://tiku.baidu.com/tikupc/singledetail/d2b18f9951e79b89680226c2', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991546483703813', 'https://tiku.baidu.com/tikupc/singledetail/301f767f5acfa1c7aa00cc54', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991546483703810', 'https://tiku.baidu.com/tikupc/singledetail/430c14791711cc7931b7161f', '1025991536673226757', '0');
INSERT INTO `crawler_question` VALUES ('1025991546483703811', 'https://tiku.baidu.com/tikupc/singledetail/8e4da26925c52cc58bd6be35', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991546542424065', 'https://tiku.baidu.com/tikupc/singledetail/755d4a7302768e9951e73855', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991546596950019', 'https://tiku.baidu.com/tikupc/singledetail/1b3a4793daef5ef7ba0d3ccc', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991546596950018', 'https://tiku.baidu.com/tikupc/singledetail/7fc4bceb19e8b8f67c1cb947', '1025991536673226757', '0');
INSERT INTO `crawler_question` VALUES ('1025991546634698753', 'https://tiku.baidu.com/tikupc/singledetail/317bbcd126fff705cc170a5c', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991546676641793', 'https://tiku.baidu.com/tikupc/singledetail/f34a77232f60ddccda38a01e', '1025991536673226757', '0');
INSERT INTO `crawler_question` VALUES ('1025991546898939906', 'https://tiku.baidu.com/tikupc/singledetail/7f85bceb19e8b8f67c1cb906', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991546982825986', 'https://tiku.baidu.com/tikupc/singledetail/55ddec630b1c59eef8c7b4f5', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991546982825985', 'https://tiku.baidu.com/tikupc/singledetail/150690c69ec3d5bbfd0a7406', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991547100266499', 'https://tiku.baidu.com/tikupc/singledetail/d8386edb6f1aff00bed51e2f', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991547100266498', 'https://tiku.baidu.com/tikupc/singledetail/f0a58beb172ded630b1cb667', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991547138015234', 'https://tiku.baidu.com/tikupc/singledetail/6d0e7c21af45b307e8719763', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991547184152577', 'https://tiku.baidu.com/tikupc/singledetail/f11375232f60ddccda38a047', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991547213512705', 'https://tiku.baidu.com/tikupc/singledetail/5e322279168884868762d62e', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991547247067138', 'https://tiku.baidu.com/tikupc/singledetail/7e3b930ef12d2af90242e6c0', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991547247067139', 'https://tiku.baidu.com/tikupc/singledetail/5e12f18583d049649b665806', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991547297398785', 'https://tiku.baidu.com/tikupc/singledetail/324200020740be1e650e9a46', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991547339341825', 'https://tiku.baidu.com/tikupc/singledetail/64003169a45177232f60a22e', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991547356119043', 'https://tiku.baidu.com/tikupc/singledetail/7fc5ac02de80d4d8d15a4f90', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991547356119042', 'https://tiku.baidu.com/tikupc/singledetail/53ffb9f3f90f76c661371a2f', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991547356119044', 'https://tiku.baidu.com/tikupc/singledetail/f0008beb172ded630b1cb6c2', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991547410644994', 'https://tiku.baidu.com/tikupc/singledetail/aca9f9b069dc5022aaea0056', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991547427422209', 'https://tiku.baidu.com/tikupc/singledetail/5e14f18583d049649b665800', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991547435810818', 'https://tiku.baidu.com/tikupc/singledetail/e8497d1cfad6195f312ba6ba', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991547519696897', 'https://tiku.baidu.com/tikupc/singledetail/936bb04e852458fb770b56ba', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991547511308290', 'https://tiku.baidu.com/tikupc/singledetail/28a6b0717fd5360cba1adb02', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991547649720323', 'https://tiku.baidu.com/tikupc/singledetail/60f6910ef12d2af90242e60d', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991547641331713', 'https://tiku.baidu.com/tikupc/singledetail/f17c3c1ec5da50e2524d7f2f', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991547649720322', 'https://tiku.baidu.com/tikupc/singledetail/57dcf90f76c66137ee06192a', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991547662303234', 'https://tiku.baidu.com/tikupc/singledetail/1f5a561252d380eb62946d35', '1025991538300616705', '0');
INSERT INTO `crawler_question` VALUES ('1025991547662303235', 'https://tiku.baidu.com/tikupc/singledetail/e8377d1cfad6195f312ba6c4', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991547762966530', 'https://tiku.baidu.com/tikupc/singledetail/be0aafaad1f34693daef3ee1', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991547788132354', 'https://tiku.baidu.com/tikupc/singledetail/6b62af1ffc4ffe473368ab0c', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991547788132357', 'https://tiku.baidu.com/tikupc/singledetail/1861cf84b9d528ea81c7792f', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991547788132356', 'https://tiku.baidu.com/tikupc/singledetail/14cc9ec3d5bbfd0a7956730f', '1025991538300616705', '0');
INSERT INTO `crawler_question` VALUES ('1025991547788132355', 'https://tiku.baidu.com/tikupc/singledetail/e2eaf342336c1eb91a375d9c', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991547830075393', 'https://tiku.baidu.com/tikupc/singledetail/3ee7854769eae009581becee', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991547897184259', 'https://tiku.baidu.com/tikupc/singledetail/90f9ba0d4a7302768e99390b', '1025991538300616705', '0');
INSERT INTO `crawler_question` VALUES ('1025991547897184260', 'https://tiku.baidu.com/tikupc/singledetail/c203647d27284b73f242502f', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991547897184258', 'https://tiku.baidu.com/tikupc/singledetail/5e21f18583d049649b665835', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991547993653249', 'https://tiku.baidu.com/tikupc/singledetail/32d349649b6648d7c1c74606', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991547993653251', 'https://tiku.baidu.com/tikupc/singledetail/1bccd5bbfd0a79563c1e720a', '1025991538300616705', '0');
INSERT INTO `crawler_question` VALUES ('1025991547993653250', 'https://tiku.baidu.com/tikupc/singledetail/cd2352d380eb6294dd886c34', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991548140453890', 'https://tiku.baidu.com/tikupc/singledetail/0320482fb4daa58da0114a06', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991548140453891', 'https://tiku.baidu.com/tikupc/singledetail/400110661ed9ad51f01df232', '1025991538300616705', '0');
INSERT INTO `crawler_question` VALUES ('1025991548148842498', 'https://tiku.baidu.com/tikupc/singledetail/5773f90f76c66137ee061985', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991548148842499', 'https://tiku.baidu.com/tikupc/singledetail/181e112de2bd960590c677f7', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991548278865922', 'https://tiku.baidu.com/tikupc/singledetail/5cac51e79b89680203d82530', '1025991538736824324', '0');
INSERT INTO `crawler_question` VALUES ('1025991548278865923', 'https://tiku.baidu.com/tikupc/singledetail/9fe91eb91a37f111f1855b80', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991548295643138', 'https://tiku.baidu.com/tikupc/singledetail/53c3340cba1aa8114431d913', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991548278865924', 'https://tiku.baidu.com/tikupc/singledetail/8bfe6d85ec3a87c24028c4f6', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991548341780483', 'https://tiku.baidu.com/tikupc/singledetail/0b6ba617866fb84ae45c8d1b', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991548341780481', 'https://tiku.baidu.com/tikupc/singledetail/29da28ea81c758f5f61f670a', '1025991538736824324', '0');
INSERT INTO `crawler_question` VALUES ('1025991548341780484', 'https://tiku.baidu.com/tikupc/singledetail/8fbe4a73f242336c1eb95e93', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991548341780482', 'https://tiku.baidu.com/tikupc/singledetail/fa97c3c708a1284ac8504345', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991548572467202', 'https://tiku.baidu.com/tikupc/singledetail/64d6a55177232f60ddcca1ba', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991548564078593', 'https://tiku.baidu.com/tikupc/singledetail/fca3dd88d0d233d4b14e6932', '1025991538736824324', '0');
INSERT INTO `crawler_question` VALUES ('1025991548572467201', 'https://tiku.baidu.com/tikupc/singledetail/9ebe5222aaea998fcc220e67', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991548572467203', 'https://tiku.baidu.com/tikupc/singledetail/ad4ff8b069dc5022aaea00b0', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991548660547585', 'https://tiku.baidu.com/tikupc/singledetail/8eeeeffdc8d376eeaeaa31de', '1025991538736824324', '0');
INSERT INTO `crawler_question` VALUES ('1025991548668936194', 'https://tiku.baidu.com/tikupc/singledetail/1bc20266f5335a8102d220e8', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991548668936193', 'https://tiku.baidu.com/tikupc/singledetail/67aba56e58fafab069dc02b0', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991548773793793', 'https://tiku.baidu.com/tikupc/singledetail/b0ddadaad1f34693daef3e36', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991548903817218', 'https://tiku.baidu.com/tikupc/singledetail/f569cfc789eb172ded63b746', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991548903817217', 'https://tiku.baidu.com/tikupc/singledetail/10d1842458fb770bf78a559a', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991548962537474', 'https://tiku.baidu.com/tikupc/singledetail/8f5d88eb172ded630b1cb69f', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991548962537476', 'https://tiku.baidu.com/tikupc/singledetail/fa7683c4bb4cf7ec4afed040', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991548962537475', 'https://tiku.baidu.com/tikupc/singledetail/b2604128915f804d2b16c1a7', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991548962537478', 'https://tiku.baidu.com/tikupc/singledetail/14859ec3d5bbfd0a79567346', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991548962537477', 'https://tiku.baidu.com/tikupc/singledetail/f5eeb5daa58da0116c1749c4', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991548962537479', 'https://tiku.baidu.com/tikupc/singledetail/1494bfd5b9f3f90f76c61b91', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991549134503939', 'https://tiku.baidu.com/tikupc/singledetail/bf1385254b35eefdc8d333c7', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991549201612803', 'https://tiku.baidu.com/tikupc/singledetail/00fd76eeaeaad1f346933f2b', '1025991539173031937', '0');
INSERT INTO `crawler_question` VALUES ('1025991549201612804', 'https://tiku.baidu.com/tikupc/singledetail/142e52ea551810a6f5248625', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991549201612806', 'https://tiku.baidu.com/tikupc/singledetail/b8b02a160b4e767f5acfcef8', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991549201612805', 'https://tiku.baidu.com/tikupc/singledetail/dba1524de518964bcf847c46', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991549201612802', 'https://tiku.baidu.com/tikupc/singledetail/adea5e0e7cd184254b3535f8', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991549201612807', 'https://tiku.baidu.com/tikupc/singledetail/98d01fb91a37f111f1855bb9', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991549264527369', 'https://tiku.baidu.com/tikupc/singledetail/5e28f18583d049649b66583c', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991549264527366', 'https://tiku.baidu.com/tikupc/singledetail/a942804d2b160b4e767fcf18', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991549264527362', 'https://tiku.baidu.com/tikupc/singledetail/4da15bcfa1c7aa00b52acbdb', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991549264527363', 'https://tiku.baidu.com/tikupc/singledetail/7a4d79563c1ec5da50e27042', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991549264527368', 'https://tiku.baidu.com/tikupc/singledetail/c4aee55c3b3567ec102d8ae1', '1025991531208048642', '0');
INSERT INTO `crawler_question` VALUES ('1025991549264527367', 'https://tiku.baidu.com/tikupc/singledetail/fe33581b6bd97f192279e93f', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991549264527361', 'https://tiku.baidu.com/tikupc/singledetail/a71b8662caaedd3383c4d398', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991549654597634', 'https://tiku.baidu.com/tikupc/singledetail/3d9b240c844769eae009ed4d', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991549654597636', 'https://tiku.baidu.com/tikupc/singledetail/8665dd36a32d7375a4178041', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991549654597638', 'https://tiku.baidu.com/tikupc/singledetail/c818162ded630b1c59eeb5f6', '1025991531208048642', '0');
INSERT INTO `crawler_question` VALUES ('1025991549654597637', 'https://tiku.baidu.com/tikupc/singledetail/6d6c7c21af45b307e8719701', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991549654597639', 'https://tiku.baidu.com/tikupc/singledetail/ca30f71fb7360b4c2e3f64c0', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991549654597640', 'https://tiku.baidu.com/tikupc/singledetail/165d1ed9ad51f01dc281f13e', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991549264527364', 'https://tiku.baidu.com/tikupc/singledetail/1bdaaf51f01dc281e53af006', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991549264527365', 'https://tiku.baidu.com/tikupc/singledetail/fb6bc0c708a1284ac85043b9', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991549860118530', 'https://tiku.baidu.com/tikupc/singledetail/99304431b90d6c85ec3ac624', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991549910450177', 'https://tiku.baidu.com/tikupc/singledetail/1e39edf9aef8941ea76e053a', '1025991531208048642', '0');
INSERT INTO `crawler_question` VALUES ('1025991549910450178', 'https://tiku.baidu.com/tikupc/singledetail/8ab4cec789eb172ded63b79b', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991549910450179', 'https://tiku.baidu.com/tikupc/singledetail/ed5e27d3240c844769eaee3e', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991549910450180', 'https://tiku.baidu.com/tikupc/singledetail/2430094c2e3f5727a5e96203', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991549952393219', 'https://tiku.baidu.com/tikupc/singledetail/5269b8f3f90f76c661371ab9', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991549952393218', 'https://tiku.baidu.com/tikupc/singledetail/d48e65ce050876323112123c', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991550048862211', 'https://tiku.baidu.com/tikupc/singledetail/25d83868011ca300a6c390ef', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991550048862212', 'https://tiku.baidu.com/tikupc/singledetail/987c69eae009581b6bd9eb3e', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991550048862210', 'https://tiku.baidu.com/tikupc/singledetail/b83718661ed9ad51f01df207', '1025991531208048642', '0');
INSERT INTO `crawler_question` VALUES ('1025991550057250818', 'https://tiku.baidu.com/tikupc/singledetail/47586bd97f1922791688e846', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991550065639425', 'https://tiku.baidu.com/tikupc/singledetail/5391fd0a79563c1ec5da712f', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991550099193860', 'https://tiku.baidu.com/tikupc/singledetail/1fd5f8c75fbfc77da269b13e', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991550099193859', 'https://tiku.baidu.com/tikupc/singledetail/86534731b90d6c85ec3ac647', '1025991531497455617', '0');
INSERT INTO `crawler_question` VALUES ('1025991550099193858', 'https://tiku.baidu.com/tikupc/singledetail/9f64c850ad02de80d4d8402b', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991550099193863', 'https://tiku.baidu.com/tikupc/singledetail/003a168884868762caaed546', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991550099193861', 'https://tiku.baidu.com/tikupc/singledetail/8fc24a73f242336c1eb95eef', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991550099193864', 'https://tiku.baidu.com/tikupc/singledetail/95dfff2d2af90242a895e5d4', '1025991531208048642', '0');
INSERT INTO `crawler_question` VALUES ('1025991550099193865', 'https://tiku.baidu.com/tikupc/singledetail/c541e45c3b3567ec102d8a0e', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991550057250819', 'https://tiku.baidu.com/tikupc/singledetail/a99eabea998fcc22bcd10db9', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991550292131841', 'https://tiku.baidu.com/tikupc/singledetail/9d0f2e3f5727a5e9856a6146', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991550292131843', 'https://tiku.baidu.com/tikupc/singledetail/2dc1a145b307e87101f696e5', '1025991531497455617', '0');
INSERT INTO `crawler_question` VALUES ('1025991550292131842', 'https://tiku.baidu.com/tikupc/singledetail/440567ec102de2bd96058835', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991550065639426', 'https://tiku.baidu.com/tikupc/singledetail/f710cc1755270722192ef710', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991550325686274', 'https://tiku.baidu.com/tikupc/singledetail/cf23a5e9856a561252d36f01', '1025991539923812354', '0');
INSERT INTO `crawler_question` VALUES ('1025991550308909059', 'https://tiku.baidu.com/tikupc/singledetail/cf2ca5e9856a561252d36f0e', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991550573150210', 'https://tiku.baidu.com/tikupc/singledetail/e9b27c1cfad6195f312ba641', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991550573150211', 'https://tiku.baidu.com/tikupc/singledetail/1ac13fb765ce0508763213bd', '1025991531497455617', '0');
INSERT INTO `crawler_question` VALUES ('1025991550619287553', 'https://tiku.baidu.com/tikupc/singledetail/28e4b0717fd5360cba1adb40', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991550619287554', 'https://tiku.baidu.com/tikupc/singledetail/00d576eeaeaad1f346933f03', '1025991539923812354', '0');
INSERT INTO `crawler_question` VALUES ('1025991550619287555', 'https://tiku.baidu.com/tikupc/singledetail/cc7427284b73f242336c5f0c', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991550619287557', 'https://tiku.baidu.com/tikupc/singledetail/9d332e3f5727a5e9856a617a', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991550619287556', 'https://tiku.baidu.com/tikupc/singledetail/1ddf6294dd88d0d233d46a31', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991550690590721', 'https://tiku.baidu.com/tikupc/singledetail/fe16581b6bd97f192279e91a', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991550745116674', 'https://tiku.baidu.com/tikupc/singledetail/666906a1284ac850ad0242ab', '1025991531497455617', '0');
INSERT INTO `crawler_question` VALUES ('1025991550782865409', 'https://tiku.baidu.com/tikupc/singledetail/8a136c85ec3a87c24028c41b', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991550795448322', 'https://tiku.baidu.com/tikupc/singledetail/d000e87101f69e3143329402', '1025991539923812354', '0');
INSERT INTO `crawler_question` VALUES ('1025991550359240706', 'https://tiku.baidu.com/tikupc/singledetail/608f8bd63186bceb19e8bb4f', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991550308909058', 'https://tiku.baidu.com/tikupc/singledetail/4863690203d8ce2f006623ef', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991550459904002', 'https://tiku.baidu.com/tikupc/singledetail/42e626fff705cc1755270932', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991551114215428', 'https://tiku.baidu.com/tikupc/singledetail/cd2052d380eb6294dd886c37', '1025991539923812354', '0');
INSERT INTO `crawler_question` VALUES ('1025991551114215427', 'https://tiku.baidu.com/tikupc/singledetail/862fdd36a32d7375a417800b', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991551114215429', 'https://tiku.baidu.com/tikupc/singledetail/ed6827d3240c844769eaee08', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991551177129986', 'https://tiku.baidu.com/tikupc/singledetail/a276fe4733687e21af45a93c', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991551177129987', 'https://tiku.baidu.com/tikupc/singledetail/a42fba4cf7ec4afe04a1dfee', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991551177129988', 'https://tiku.baidu.com/tikupc/singledetail/a10d33687e21af45b307a84f', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991551177129985', 'https://tiku.baidu.com/tikupc/singledetail/b8e484254b35eefdc8d33330', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991551114215426', 'https://tiku.baidu.com/tikupc/singledetail/5777f90f76c66137ee061981', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991551227461634', 'https://tiku.baidu.com/tikupc/singledetail/5a7aad00a6c30c2259019e63', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991551298764801', 'https://tiku.baidu.com/tikupc/singledetail/193bba1aa8114431b90dd832', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991551277793281', 'https://tiku.baidu.com/tikupc/singledetail/6229b7360b4c2e3f57276333', '1025991539923812354', '0');
INSERT INTO `crawler_question` VALUES ('1025991551298764802', 'https://tiku.baidu.com/tikupc/singledetail/a6b4814d2b160b4e767fcfee', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991551298764803', 'https://tiku.baidu.com/tikupc/singledetail/da177375a417866fb84a8e3f', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991551298764804', 'https://tiku.baidu.com/tikupc/singledetail/65f9cc22bcd126fff7050b73', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991551332319233', 'https://tiku.baidu.com/tikupc/singledetail/649fd1f34693daef5ef73d30', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991551344902146', 'https://tiku.baidu.com/tikupc/singledetail/f1853c1ec5da50e2524d7fd6', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991551386845186', 'https://tiku.baidu.com/tikupc/singledetail/a278caaedd3383c4bb4cd21f', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991551428788227', 'https://tiku.baidu.com/tikupc/singledetail/6b7aaf1ffc4ffe473368ab14', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991551428788229', 'https://tiku.baidu.com/tikupc/singledetail/da237375a417866fb84a8e0b', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991551428788226', 'https://tiku.baidu.com/tikupc/singledetail/ea9e72d184254b35eefd3495', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991551428788228', 'https://tiku.baidu.com/tikupc/singledetail/9c52ab00b52acfc789ebc990', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991551495897089', 'https://tiku.baidu.com/tikupc/singledetail/615c6c175f0e7cd184253648', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991551495897090', 'https://tiku.baidu.com/tikupc/singledetail/42ca26fff705cc175527091e', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991551542034433', 'https://tiku.baidu.com/tikupc/singledetail/49bab8f67c1cfad6195fa757', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991551542034435', 'https://tiku.baidu.com/tikupc/singledetail/6809964bcf84b9d528ea7a14', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991551542034434', 'https://tiku.baidu.com/tikupc/singledetail/6183f9d184254b35eefd3488', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991551554617346', 'https://tiku.baidu.com/tikupc/singledetail/443b67ec102de2bd9605880b', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991551583977473', 'https://tiku.baidu.com/tikupc/singledetail/b25c4128915f804d2b16c19b', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991551609143298', 'https://tiku.baidu.com/tikupc/singledetail/fcdd770bf78a6529647d5323', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991551609143299', 'https://tiku.baidu.com/tikupc/singledetail/e87625c52cc58bd63186bd1a', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991551634309122', 'https://tiku.baidu.com/tikupc/singledetail/32632baad1f34693daef3e88', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991551634309121', 'https://tiku.baidu.com/tikupc/singledetail/a258caaedd3383c4bb4cd23f', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991551676252161', 'https://tiku.baidu.com/tikupc/singledetail/1cb1571252d380eb62946dde', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991551709806594', 'https://tiku.baidu.com/tikupc/singledetail/593a336c1eb91a37f1115c7d', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991551709806595', 'https://tiku.baidu.com/tikupc/singledetail/c8cfe53a580216fc700afd4b', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991551747555330', 'https://tiku.baidu.com/tikupc/singledetail/8f5588eb172ded630b1cb697', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991551755943938', 'https://tiku.baidu.com/tikupc/singledetail/bf845fbfc77da26925c5b046', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991551747555331', 'https://tiku.baidu.com/tikupc/singledetail/977ec393daef5ef7ba0d3c88', '1025991494281396226', '0');
INSERT INTO `crawler_question` VALUES ('1025991551772721153', 'https://tiku.baidu.com/tikupc/singledetail/8461df36a32d7375a4178045', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991551789498369', 'https://tiku.baidu.com/tikupc/singledetail/1ef8acf8941ea76e58fa0404', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991551814664194', 'https://tiku.baidu.com/tikupc/singledetail/53f3b9f3f90f76c661371a23', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991551814664195', 'https://tiku.baidu.com/tikupc/singledetail/547ced630b1c59eef8c7b454', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991551873384449', 'https://tiku.baidu.com/tikupc/singledetail/65609f3143323968011c9293', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991551873384450', 'https://tiku.baidu.com/tikupc/singledetail/c69c3186bceb19e8b8f6ba4f', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991551911133186', 'https://tiku.baidu.com/tikupc/singledetail/bed486254b35eefdc8d33300', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991551911133187', 'https://tiku.baidu.com/tikupc/singledetail/12a09cc3d5bbfd0a79567363', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991551911133185', 'https://tiku.baidu.com/tikupc/singledetail/bfb25fbfc77da26925c5b070', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991551974047746', 'https://tiku.baidu.com/tikupc/singledetail/bf6f85254b35eefdc8d333bb', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991551986630657', 'https://tiku.baidu.com/tikupc/singledetail/64613169a45177232f60a24f', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991552003407873', 'https://tiku.baidu.com/tikupc/singledetail/027f148884868762caaed503', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991552003407874', 'https://tiku.baidu.com/tikupc/singledetail/e9f7f08a6529647d272852f9', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991552032768001', 'https://tiku.baidu.com/tikupc/singledetail/11afaa956bec0975f465e2e8', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991552074711041', 'https://tiku.baidu.com/tikupc/singledetail/ad1c0129bd64783e09122bbb', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991552133431298', 'https://tiku.baidu.com/tikupc/singledetail/59ecf68583d049649b6658f8', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991552133431297', 'https://tiku.baidu.com/tikupc/singledetail/db16e618964bcf84b9d57b5e', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991552179568642', 'https://tiku.baidu.com/tikupc/singledetail/f8d9c381e53a580216fcfec1', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991552238288897', 'https://tiku.baidu.com/tikupc/singledetail/b83858bfc77da26925c5b0fa', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991552238288898', 'https://tiku.baidu.com/tikupc/singledetail/1a8e6194dd88d0d233d46a60', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991552326369282', 'https://tiku.baidu.com/tikupc/singledetail/8c3ef700bed5b9f3f90f1c21', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991552410255362', 'https://tiku.baidu.com/tikupc/singledetail/fb16c0c708a1284ac85043c4', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991552468975618', 'https://tiku.baidu.com/tikupc/singledetail/e50a4d3610661ed9ad51f320', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991552477364226', 'https://tiku.baidu.com/tikupc/singledetail/32b5747f5acfa1c7aa00ccfe', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991552515112961', 'https://tiku.baidu.com/tikupc/singledetail/ca9ea7c30c22590102029d9b', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991552557056001', 'https://tiku.baidu.com/tikupc/singledetail/90c933126edb6f1aff001ffe', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991552674496514', 'https://tiku.baidu.com/tikupc/singledetail/17ac77c66137ee06eff918a6', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991552712245249', 'https://tiku.baidu.com/tikupc/singledetail/9d02f4ec4afe04a1b071de4b', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991552770965505', 'https://tiku.baidu.com/tikupc/singledetail/4ff750e2524de518964b7d28', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991552770965506', 'https://tiku.baidu.com/tikupc/singledetail/f17b3c1ec5da50e2524d7f28', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991552779354113', 'https://tiku.baidu.com/tikupc/singledetail/1cc7571252d380eb62946da8', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991552829685761', 'https://tiku.baidu.com/tikupc/singledetail/6f14954bcf84b9d528ea7a09', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991552846462979', 'https://tiku.baidu.com/tikupc/singledetail/841cff00bed5b9f3f90f1c03', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991552846462978', 'https://tiku.baidu.com/tikupc/singledetail/bfeaaeaad1f34693daef3e01', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991552871628802', 'https://tiku.baidu.com/tikupc/singledetail/64a0f524ccbff121dd368303', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991552871628801', 'https://tiku.baidu.com/tikupc/singledetail/8627dd36a32d7375a4178003', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991552884211714', 'https://tiku.baidu.com/tikupc/singledetail/aacaa22d7375a417866f8ff9', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991552913571842', 'https://tiku.baidu.com/tikupc/singledetail/6b6faf1ffc4ffe473368ab01', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991552930349058', 'https://tiku.baidu.com/tikupc/singledetail/fb155b1b6bd97f192279e919', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991552938737665', 'https://tiku.baidu.com/tikupc/singledetail/f731cc1755270722192ef731', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991552947126273', 'https://tiku.baidu.com/tikupc/singledetail/c884e53a580216fc700afd00', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991552968097794', 'https://tiku.baidu.com/tikupc/singledetail/5945336c1eb91a37f1115c02', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991552968097795', 'https://tiku.baidu.com/tikupc/singledetail/84f66f1aff00bed5b9f31d28', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991552997457922', 'https://tiku.baidu.com/tikupc/singledetail/1f6e561252d380eb62946d01', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991553026818051', 'https://tiku.baidu.com/tikupc/singledetail/e9b47c1cfad6195f312ba647', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991553026818050', 'https://tiku.baidu.com/tikupc/singledetail/ea2927c52cc58bd63186bd45', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991553043595265', 'https://tiku.baidu.com/tikupc/singledetail/f52fcfc789eb172ded63b700', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991553123287042', 'https://tiku.baidu.com/tikupc/singledetail/6c022ec58bd63186bcebbcc2', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991553077149698', 'https://tiku.baidu.com/tikupc/singledetail/e7c0102de2bd960590c67729', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991553140064258', 'https://tiku.baidu.com/tikupc/singledetail/d4f565ce0508763231121247', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991553140064260', 'https://tiku.baidu.com/tikupc/singledetail/c905a6c30c22590102029d00', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991553140064259', 'https://tiku.baidu.com/tikupc/singledetail/c0c8a4e9856a561252d36fea', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991553148452865', 'https://tiku.baidu.com/tikupc/singledetail/75134a7302768e9951e7381b', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991553202978819', 'https://tiku.baidu.com/tikupc/singledetail/a24b30687e21af45b307a809', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991553202978818', 'https://tiku.baidu.com/tikupc/singledetail/da007375a417866fb84a8e28', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991553244921858', 'https://tiku.baidu.com/tikupc/singledetail/1ff1f8c75fbfc77da269b11a', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991553244921857', 'https://tiku.baidu.com/tikupc/singledetail/402a10661ed9ad51f01df219', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991553295253507', 'https://tiku.baidu.com/tikupc/singledetail/c084ed3a580216fc700afd00', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991553257504770', 'https://tiku.baidu.com/tikupc/singledetail/997b1cb91a37f111f1855b12', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991553295253506', 'https://tiku.baidu.com/tikupc/singledetail/912ee2bd960590c69ec37606', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991553295253508', 'https://tiku.baidu.com/tikupc/singledetail/7f83bceb19e8b8f67c1cb900', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991553295253509', 'https://tiku.baidu.com/tikupc/singledetail/b9e981c758f5f61fb7366606', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991553446248449', 'https://tiku.baidu.com/tikupc/singledetail/8e62a26925c52cc58bd6be1a', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991553446248452', 'https://tiku.baidu.com/tikupc/singledetail/30d6834769eae009581becdf', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991553446248451', 'https://tiku.baidu.com/tikupc/singledetail/330057270722192e4536f61d', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991553483997187', 'https://tiku.baidu.com/tikupc/singledetail/a7140912a21614791711282f', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991553483997186', 'https://tiku.baidu.com/tikupc/singledetail/46816ad97f1922791688e89f', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991553483997188', 'https://tiku.baidu.com/tikupc/singledetail/ee16580216fc700abb68fc29', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991553521745922', 'https://tiku.baidu.com/tikupc/singledetail/8135376baf1ffc4ffe47ac08', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991553567883266', 'https://tiku.baidu.com/tikupc/singledetail/8a3ba8114431b90d6c85c724', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991553626603521', 'https://tiku.baidu.com/tikupc/singledetail/f34e77232f60ddccda38a01a', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991553626603524', 'https://tiku.baidu.com/tikupc/singledetail/ef34dc3383c4bb4cf7ecd19f', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991553626603523', 'https://tiku.baidu.com/tikupc/singledetail/10bf842458fb770bf78a55f4', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991553626603525', 'https://tiku.baidu.com/tikupc/singledetail/515a58fafab069dc50220131', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991553626603522', 'https://tiku.baidu.com/tikupc/singledetail/a9fd195f312b3169a451a42e', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991553689518081', 'https://tiku.baidu.com/tikupc/singledetail/137a852458fb770bf78a5531', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991553718878210', 'https://tiku.baidu.com/tikupc/singledetail/f96e996648d7c1c708a1450f', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991553777598466', 'https://tiku.baidu.com/tikupc/singledetail/87d3da38376baf1ffc4fad1a', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991553777598467', 'https://tiku.baidu.com/tikupc/singledetail/87c8da38376baf1ffc4fad01', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991553777598468', 'https://tiku.baidu.com/tikupc/singledetail/5436f80f76c66137ee0619c0', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991553777598469', 'https://tiku.baidu.com/tikupc/singledetail/6f960640be1e650e52ea9991', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991553777598471', 'https://tiku.baidu.com/tikupc/singledetail/ae375f0e7cd184254b353525', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991553777598470', 'https://tiku.baidu.com/tikupc/singledetail/9325b04e852458fb770b56f4', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991553874067458', 'https://tiku.baidu.com/tikupc/singledetail/5b5a316c1eb91a37f1115c1d', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991553911816194', 'https://tiku.baidu.com/tikupc/singledetail/b9ee81c758f5f61fb7366601', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991553957953539', 'https://tiku.baidu.com/tikupc/singledetail/3cc2856a561252d380eb6e2e', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991553974730754', 'https://tiku.baidu.com/tikupc/singledetail/1fc3eef9aef8941ea76e05c0', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991553974730753', 'https://tiku.baidu.com/tikupc/singledetail/6862be1e650e52ea55189827', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991553957953538', 'https://tiku.baidu.com/tikupc/singledetail/341c02020740be1e650e9a18', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991553974730755', 'https://tiku.baidu.com/tikupc/singledetail/8a2c6c85ec3a87c24028c424', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991554041839618', 'https://tiku.baidu.com/tikupc/singledetail/32e449649b6648d7c1c74631', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991554041839617', 'https://tiku.baidu.com/tikupc/singledetail/14f3bfd5b9f3f90f76c61bf6', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991554117337090', 'https://tiku.baidu.com/tikupc/singledetail/02f469dc5022aaea998f0f41', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991554117337089', 'https://tiku.baidu.com/tikupc/singledetail/709833d4b14e852458fb574f', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991554117337092', 'https://tiku.baidu.com/tikupc/singledetail/c6f73186bceb19e8b8f6ba24', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991554129920001', 'https://tiku.baidu.com/tikupc/singledetail/bd3703d8ce2f0066f5332230', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991554129920002', 'https://tiku.baidu.com/tikupc/singledetail/cbc5a4c30c22590102029dc0', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991554117337091', 'https://tiku.baidu.com/tikupc/singledetail/933bbb0d4a7302768e9939c9', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991554218000385', 'https://tiku.baidu.com/tikupc/singledetail/d04ce87101f69e314332944e', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991554238971905', 'https://tiku.baidu.com/tikupc/singledetail/cba3172ded630b1c59eeb54d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991554276720641', 'https://tiku.baidu.com/tikupc/singledetail/c57ee45c3b3567ec102d8a31', '1025991542897573891', '0');
INSERT INTO `crawler_question` VALUES ('1025991554238971906', 'https://tiku.baidu.com/tikupc/singledetail/7e39930ef12d2af90242e6c2', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991554339635202', 'https://tiku.baidu.com/tikupc/singledetail/b519c5da50e2524de5187e02', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991554331246594', 'https://tiku.baidu.com/tikupc/singledetail/35c584868762caaedd33d448', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991554339635203', 'https://tiku.baidu.com/tikupc/singledetail/4e5459eef8c75fbfc77db24d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991554360606722', 'https://tiku.baidu.com/tikupc/singledetail/83dd0508763231126edb1116', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991554406744066', 'https://tiku.baidu.com/tikupc/singledetail/2c235a8102d276a200292e15', '1025991542897573891', '0');
INSERT INTO `crawler_question` VALUES ('1025991554461270019', 'https://tiku.baidu.com/tikupc/singledetail/83da0508763231126edb1111', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991554461270018', 'https://tiku.baidu.com/tikupc/singledetail/3e950242a8956bec0975e369', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991554507407361', 'https://tiku.baidu.com/tikupc/singledetail/bfd6aeaad1f34693daef3e3d', '1025991542897573891', '0');
INSERT INTO `crawler_question` VALUES ('1025991554507407362', 'https://tiku.baidu.com/tikupc/singledetail/b9792b160b4e767f5acfce31', '1025991543019208709', '0');
INSERT INTO `crawler_question` VALUES ('1025991554587099137', 'https://tiku.baidu.com/tikupc/singledetail/6496d1f34693daef5ef73d39', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991554587099138', 'https://tiku.baidu.com/tikupc/singledetail/5e172279168884868762d60b', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991554608070659', 'https://tiku.baidu.com/tikupc/singledetail/d7ed580e7cd184254b3535ff', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991554608070661', 'https://tiku.baidu.com/tikupc/singledetail/1bc4700abb68a98271fefa3d', '1025991543019208709', '0');
INSERT INTO `crawler_question` VALUES ('1025991554608070662', 'https://tiku.baidu.com/tikupc/singledetail/8aafdaef5ef7ba0d4a733b39', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991554608070660', 'https://tiku.baidu.com/tikupc/singledetail/a9710b1c59eef8c75fbfb317', '1025991542897573891', '0');
INSERT INTO `crawler_question` VALUES ('1025991554608070663', 'https://tiku.baidu.com/tikupc/singledetail/91605122aaea998fcc220eb9', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991554608070664', 'https://tiku.baidu.com/tikupc/singledetail/535e7e21af45b307e8719733', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991554884894722', 'https://tiku.baidu.com/tikupc/singledetail/3df3240c844769eae009ed25', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991554918449155', 'https://tiku.baidu.com/tikupc/singledetail/092d71eeaeaad1f346933ffb', '1025991501399130113', '0');
INSERT INTO `crawler_question` VALUES ('1025991554918449154', 'https://tiku.baidu.com/tikupc/singledetail/6492d1f34693daef5ef73d3d', '1025991543019208709', '0');
INSERT INTO `crawler_question` VALUES ('1025991554918449156', 'https://tiku.baidu.com/tikupc/singledetail/2fc730b765ce0508763213bb', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991554918449157', 'https://tiku.baidu.com/tikupc/singledetail/9a4f02768e9951e79b892739', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991554918449158', 'https://tiku.baidu.com/tikupc/singledetail/65c9b6360b4c2e3f572763d3', '1025991542897573891', '0');
INSERT INTO `crawler_question` VALUES ('1025991554931032065', 'https://tiku.baidu.com/tikupc/singledetail/9a4b02768e9951e79b89273d', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991554981363713', 'https://tiku.baidu.com/tikupc/singledetail/5e392279168884868762d625', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991555027501058', 'https://tiku.baidu.com/tikupc/singledetail/0043168884868762caaed53f', '1025991543019208709', '0');
INSERT INTO `crawler_question` VALUES ('1025991555044278274', 'https://tiku.baidu.com/tikupc/singledetail/e3922bf90242a8956bece4ba', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991555090415617', 'https://tiku.baidu.com/tikupc/singledetail/64d69e3143323968011c9225', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991555123970050', 'https://tiku.baidu.com/tikupc/singledetail/840cdb38376baf1ffc4fadc5', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991555123970049', 'https://tiku.baidu.com/tikupc/singledetail/2826c9d376eeaeaad1f330de', '1025991543019208709', '0');
INSERT INTO `crawler_question` VALUES ('1025991555203661826', 'https://tiku.baidu.com/tikupc/singledetail/1b8ace84b9d528ea81c779c4', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991555203661827', 'https://tiku.baidu.com/tikupc/singledetail/611b6c175f0e7cd18425360f', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991555203661828', 'https://tiku.baidu.com/tikupc/singledetail/2e54fad6195f312b3169a54d', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991555249799170', 'https://tiku.baidu.com/tikupc/singledetail/de774bfe04a1b0717fd5dd9e', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991555316908034', 'https://tiku.baidu.com/tikupc/singledetail/e133f242336c1eb91a375d45', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991555316908036', 'https://tiku.baidu.com/tikupc/singledetail/64bf9e3143323968011c924c', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991555316908035', 'https://tiku.baidu.com/tikupc/singledetail/5e4482d049649b6648d747c4', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991555316908037', 'https://tiku.baidu.com/tikupc/singledetail/e82b7d1cfad6195f312ba6d8', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991555396599810', 'https://tiku.baidu.com/tikupc/singledetail/1dc5d7bbfd0a79563c1e7203', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991555438542849', 'https://tiku.baidu.com/tikupc/singledetail/b8fb5627a5e9856a561260c1', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991555446931458', 'https://tiku.baidu.com/tikupc/singledetail/1c356394dd88d0d233d46adb', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991555455320065', 'https://tiku.baidu.com/tikupc/singledetail/9f54c850ad02de80d4d8401b', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991555493068801', 'https://tiku.baidu.com/tikupc/singledetail/1a17710abb68a98271fefaee', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991555539206146', 'https://tiku.baidu.com/tikupc/singledetail/b501c5da50e2524de5187e1a', '1025991534584463361', '0');
INSERT INTO `crawler_question` VALUES ('1025991555539206145', 'https://tiku.baidu.com/tikupc/singledetail/a7ec83c758f5f61fb7366603', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991555564371969', 'https://tiku.baidu.com/tikupc/singledetail/f3c919e8b8f67c1cfad6b827', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991555564371970', 'https://tiku.baidu.com/tikupc/singledetail/17bac77da26925c52cc5bf00', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991555623092226', 'https://tiku.baidu.com/tikupc/singledetail/5604b9f67c1cfad6195fa7e9', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991555719561218', 'https://tiku.baidu.com/tikupc/singledetail/1ba8ce84b9d528ea81c779e6', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991555727949825', 'https://tiku.baidu.com/tikupc/singledetail/99644431b90d6c85ec3ac670', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991555782475781', 'https://tiku.baidu.com/tikupc/singledetail/401a10661ed9ad51f01df229', '1025991543753211907', '0');
INSERT INTO `crawler_question` VALUES ('1025991555782475778', 'https://tiku.baidu.com/tikupc/singledetail/e86c25c52cc58bd63186bd00', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991555782475779', 'https://tiku.baidu.com/tikupc/singledetail/112c872458fb770bf78a5567', '1025991544017453058', '0');
INSERT INTO `crawler_question` VALUES ('1025991555782475777', 'https://tiku.baidu.com/tikupc/singledetail/3f75844769eae009581bec7c', '1025991534584463361', '0');
INSERT INTO `crawler_question` VALUES ('1025991555782475780', 'https://tiku.baidu.com/tikupc/singledetail/ac055d0e7cd184254b353517', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991555853778946', 'https://tiku.baidu.com/tikupc/singledetail/2f9a30b765ce0508763213e6', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991555853778947', 'https://tiku.baidu.com/tikupc/singledetail/6981a200a6c30c2259019e98', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991555887333378', 'https://tiku.baidu.com/tikupc/singledetail/f73ecc1755270722192ef73e', '1025991543585439745', '0');
INSERT INTO `crawler_question` VALUES ('1025991555954442243', 'https://tiku.baidu.com/tikupc/singledetail/6f5b2dc58bd63186bcebbc9b', '1025991543753211907', '0');
INSERT INTO `crawler_question` VALUES ('1025991555954442241', 'https://tiku.baidu.com/tikupc/singledetail/87c9da38376baf1ffc4fad00', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991555954442242', 'https://tiku.baidu.com/tikupc/singledetail/c3e8657d27284b73f24250c4', '1025991534584463361', '0');
INSERT INTO `crawler_question` VALUES ('1025991556008968193', 'https://tiku.baidu.com/tikupc/singledetail/ba94f121dd36a32d7375812e', '1025991543912595458', '0');
INSERT INTO `crawler_question` VALUES ('1025991556180934659', 'https://tiku.baidu.com/tikupc/singledetail/c94c81eb6294dd88d0d26b9a', '1025991534584463361', '0');
INSERT INTO `crawler_question` VALUES ('1025991556180934660', 'https://tiku.baidu.com/tikupc/singledetail/24373968011ca300a6c39000', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991556168351745', 'https://tiku.baidu.com/tikupc/singledetail/8453db38376baf1ffc4fad9a', '1025991543585439745', '0');
INSERT INTO `crawler_question` VALUES ('1025991556180934658', 'https://tiku.baidu.com/tikupc/singledetail/30ecbdd126fff705cc170acb', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991556206100481', 'https://tiku.baidu.com/tikupc/singledetail/940caa114431b90d6c85c713', '1025991544294277122', '0');
INSERT INTO `crawler_question` VALUES ('1025991556281597954', 'https://tiku.baidu.com/tikupc/singledetail/101959f5f61fb7360b4c65db', '1025991543585439745', '0');
INSERT INTO `crawler_question` VALUES ('1025991556281597955', 'https://tiku.baidu.com/tikupc/singledetail/9eecc950ad02de80d4d840a3', '1025991534584463361', '0');
INSERT INTO `crawler_question` VALUES ('1025991556281597956', 'https://tiku.baidu.com/tikupc/singledetail/808402d276a20029bd642d00', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991556289986563', 'https://tiku.baidu.com/tikupc/singledetail/62c1f724ccbff121dd368362', '1025991544294277122', '0');
INSERT INTO `crawler_question` VALUES ('1025991556289986562', 'https://tiku.baidu.com/tikupc/singledetail/b3c24228915f804d2b16c105', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991556348706818', 'https://tiku.baidu.com/tikupc/singledetail/5e9c53e79b89680203d82500', '1025991543585439745', '0');
INSERT INTO `crawler_question` VALUES ('1025991556445175809', 'https://tiku.baidu.com/tikupc/singledetail/05d0182e453610661ed9f4f7', '1025991543585439745', '0');
INSERT INTO `crawler_question` VALUES ('1025991556554227713', 'https://tiku.baidu.com/tikupc/singledetail/87d0da38376baf1ffc4fad19', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991556587782146', 'https://tiku.baidu.com/tikupc/singledetail/35355d270722192e4536f626', '1025991535167471618', '0');
INSERT INTO `crawler_question` VALUES ('1025991556642308099', 'https://tiku.baidu.com/tikupc/singledetail/f87543323968011ca3009141', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991556919132162', 'https://tiku.baidu.com/tikupc/singledetail/fcd8c1c708a1284ac850430a', '1025991543325392899', '0');
INSERT INTO `crawler_question` VALUES ('1025991556919132163', 'https://tiku.baidu.com/tikupc/singledetail/87a8e0eef8c75fbfc77db2b0', '1025991535167471618', '0');
INSERT INTO `crawler_question` VALUES ('1025991556919132166', 'https://tiku.baidu.com/tikupc/singledetail/c871162ded630b1c59eeb59f', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991556919132165', 'https://tiku.baidu.com/tikupc/singledetail/51fb998fcc22bcd126ff0c14', '1025991544503992321', '0');
INSERT INTO `crawler_question` VALUES ('1025991556919132164', 'https://tiku.baidu.com/tikupc/singledetail/1aaf4693daef5ef7ba0d3c59', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991556956880897', 'https://tiku.baidu.com/tikupc/singledetail/9169e2bd960590c69ec37641', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991557053349890', 'https://tiku.baidu.com/tikupc/singledetail/4d66312b3169a4517723a33c', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991557141430273', 'https://tiku.baidu.com/tikupc/singledetail/f66db4daa58da0116c174947', '1025991543325392899', '0');
INSERT INTO `crawler_question` VALUES ('1025991557141430275', 'https://tiku.baidu.com/tikupc/singledetail/84c66f1aff00bed5b9f31d18', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991557141430276', 'https://tiku.baidu.com/tikupc/singledetail/de764bfe04a1b0717fd5dd9f', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991557141430277', 'https://tiku.baidu.com/tikupc/singledetail/6986bf1e650e52ea551898c3', '1025991544503992321', '0');
INSERT INTO `crawler_question` VALUES ('1025991557141430274', 'https://tiku.baidu.com/tikupc/singledetail/1bc5d5bbfd0a79563c1e7203', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991557141430278', 'https://tiku.baidu.com/tikupc/singledetail/70d4ad02de80d4d8d15a4f81', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991557158207490', 'https://tiku.baidu.com/tikupc/singledetail/28b3b0717fd5360cba1adb17', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991557204344833', 'https://tiku.baidu.com/tikupc/singledetail/282348d7c1c708a1284a4440', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991557250482178', 'https://tiku.baidu.com/tikupc/singledetail/aeba0a1c59eef8c75fbfb3dc', '1025991543325392899', '0');
INSERT INTO `crawler_question` VALUES ('1025991557263065091', 'https://tiku.baidu.com/tikupc/singledetail/924bf7ec4afe04a1b071de02', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991557263065090', 'https://tiku.baidu.com/tikupc/singledetail/f8d8c381e53a580216fcfec0', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991557275648002', 'https://tiku.baidu.com/tikupc/singledetail/64113169a45177232f60a23f', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991557275648001', 'https://tiku.baidu.com/tikupc/singledetail/6339783e0912a21614792958', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991557284036609', 'https://tiku.baidu.com/tikupc/singledetail/8602dd36a32d7375a4178026', '1025991544772427778', '0');
INSERT INTO `crawler_question` VALUES ('1025991557284036610', 'https://tiku.baidu.com/tikupc/singledetail/d84be718964bcf84b9d57b03', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991557338562562', 'https://tiku.baidu.com/tikupc/singledetail/1500bcd5b9f3f90f76c61b05', '1025991543325392899', '0');
INSERT INTO `crawler_question` VALUES ('1025991557267259393', 'https://tiku.baidu.com/tikupc/singledetail/1769b41aa8114431b90dd860', '1025991544503992321', '0');
INSERT INTO `crawler_question` VALUES ('1025991557338562563', 'https://tiku.baidu.com/tikupc/singledetail/53d2b9f3f90f76c661371a02', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991557397282818', 'https://tiku.baidu.com/tikupc/singledetail/1c52f9c75fbfc77da269b1b9', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991557506334723', 'https://tiku.baidu.com/tikupc/singledetail/f8e9c381e53a580216fcfef1', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991557506334721', 'https://tiku.baidu.com/tikupc/singledetail/662f5b0102020740be1e9b08', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991557506334722', 'https://tiku.baidu.com/tikupc/singledetail/9c766285ec3a87c24028c47e', '1025991544772427778', '0');
INSERT INTO `crawler_question` VALUES ('1025991557552472065', 'https://tiku.baidu.com/tikupc/singledetail/6c300740be1e650e52ea9937', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991557397282817', 'https://tiku.baidu.com/tikupc/singledetail/3de8240c844769eae009ed3e', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991557569249282', 'https://tiku.baidu.com/tikupc/singledetail/7607b90d6c85ec3a87c2c533', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991557606998018', 'https://tiku.baidu.com/tikupc/singledetail/fa0e41323968011ca300913a', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991557606998017', 'https://tiku.baidu.com/tikupc/singledetail/578abaf67c1cfad6195fa767', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991557606998019', 'https://tiku.baidu.com/tikupc/singledetail/453066ec102de2bd96058800', '1025991544772427778', '0');
INSERT INTO `crawler_question` VALUES ('1025991557716049923', 'https://tiku.baidu.com/tikupc/singledetail/9121e2bd960590c69ec37609', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991557716049925', 'https://tiku.baidu.com/tikupc/singledetail/e9aa7c1cfad6195f312ba659', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991557716049922', 'https://tiku.baidu.com/tikupc/singledetail/abcbbb4cf7ec4afe04a1df0a', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991557716049924', 'https://tiku.baidu.com/tikupc/singledetail/193c0066f5335a8102d22016', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991557770575874', 'https://tiku.baidu.com/tikupc/singledetail/f34877232f60ddccda38a01c', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991557770575875', 'https://tiku.baidu.com/tikupc/singledetail/648cf524ccbff121dd36832f', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991557770575873', 'https://tiku.baidu.com/tikupc/singledetail/d98a504de518964bcf847c6d', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991557812518913', 'https://tiku.baidu.com/tikupc/singledetail/f1593c1ec5da50e2524d7f0a', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991557820907521', 'https://tiku.baidu.com/tikupc/singledetail/7cb10975f46527d3240ce058', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991557841879041', 'https://tiku.baidu.com/tikupc/singledetail/82e09b89680203d8ce2f2402', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991557892210690', 'https://tiku.baidu.com/tikupc/singledetail/c2a825284b73f242336c5fd0', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991557892210692', 'https://tiku.baidu.com/tikupc/singledetail/418683d049649b6648d74706', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991557892210691', 'https://tiku.baidu.com/tikupc/singledetail/afe3fab069dc5022aaea001c', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991557929959425', 'https://tiku.baidu.com/tikupc/singledetail/1844cf84b9d528ea81c7790a', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991557929959427', 'https://tiku.baidu.com/tikupc/singledetail/7d090875f46527d3240ce0e0', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991557929959428', 'https://tiku.baidu.com/tikupc/singledetail/5351b9f3f90f76c661371a81', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991557929959430', 'https://tiku.baidu.com/tikupc/singledetail/321a56270722192e4536f60b', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991557929959429', 'https://tiku.baidu.com/tikupc/singledetail/dd26bd64783e0912a2162a0a', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991558039011331', 'https://tiku.baidu.com/tikupc/singledetail/f1173c1ec5da50e2524d7f44', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991558039011330', 'https://tiku.baidu.com/tikupc/singledetail/570b0722192e45361066f529', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991558135480321', 'https://tiku.baidu.com/tikupc/singledetail/680ca300a6c30c2259019e15', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991558177423362', 'https://tiku.baidu.com/tikupc/singledetail/4982b8f67c1cfad6195fa76f', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991558177423361', 'https://tiku.baidu.com/tikupc/singledetail/90c65022aaea998fcc220e1f', '1025991545447710721', '0');
INSERT INTO `crawler_question` VALUES ('1025991558177423364', 'https://tiku.baidu.com/tikupc/singledetail/a0978762caaedd3383c4d314', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991558177423363', 'https://tiku.baidu.com/tikupc/singledetail/c38c26284b73f242336c5ff4', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991558185811971', 'https://tiku.baidu.com/tikupc/singledetail/affefab069dc5022aaea0001', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991558185811970', 'https://tiku.baidu.com/tikupc/singledetail/4f9b50e2524de518964b7d44', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991558286475265', 'https://tiku.baidu.com/tikupc/singledetail/529f59fafab069dc502201f4', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991558299058177', 'https://tiku.baidu.com/tikupc/singledetail/51986529647d27284b735117', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991558299058179', 'https://tiku.baidu.com/tikupc/singledetail/344202020740be1e650e9a46', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991558299058178', 'https://tiku.baidu.com/tikupc/singledetail/6b36af1ffc4ffe473368ab58', '1025991545447710721', '0');
INSERT INTO `crawler_question` VALUES ('1025991558366167041', 'https://tiku.baidu.com/tikupc/singledetail/9e256beae009581b6bd9eb67', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991558437470210', 'https://tiku.baidu.com/tikupc/singledetail/a66570fe910ef12d2af9e7e2', '1025991545447710721', '0');
INSERT INTO `crawler_question` VALUES ('1025991558496190466', 'https://tiku.baidu.com/tikupc/singledetail/cf691011cc7931b765ce1515', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991558542327810', 'https://tiku.baidu.com/tikupc/singledetail/86e1fd00bed5b9f3f90f1cfe', '1025991545447710721', '0');
INSERT INTO `crawler_question` VALUES ('1025991558584270850', 'https://tiku.baidu.com/tikupc/singledetail/0976a417866fb84ae45c8d06', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991558647185409', 'https://tiku.baidu.com/tikupc/singledetail/3cfc856a561252d380eb6e10', '1025991545716146181', '0');
INSERT INTO `crawler_question` VALUES ('1025991558684934146', 'https://tiku.baidu.com/tikupc/singledetail/64aad4d8d15abe23482f4d2f', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991558726877185', 'https://tiku.baidu.com/tikupc/singledetail/ef60a9a6f524ccbff121847c', '1025991545716146181', '0');
INSERT INTO `crawler_question` VALUES ('1025991558773014529', 'https://tiku.baidu.com/tikupc/singledetail/9c247cd184254b35eefd342f', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991558840123393', 'https://tiku.baidu.com/tikupc/singledetail/e170f242336c1eb91a375d06', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991558907232258', 'https://tiku.baidu.com/tikupc/singledetail/516058fafab069dc5022010b', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991558890455042', 'https://tiku.baidu.com/tikupc/singledetail/57a70722192e45361066f585', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991558928203777', 'https://tiku.baidu.com/tikupc/singledetail/d9f876a20029bd64783e2c2f', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991558982729730', 'https://tiku.baidu.com/tikupc/singledetail/bfd8aeaad1f34693daef3e33', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991559007895554', 'https://tiku.baidu.com/tikupc/singledetail/f783cc1755270722192ef783', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991559041449986', 'https://tiku.baidu.com/tikupc/singledetail/a91d804d2b160b4e767fcf47', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991559083393026', 'https://tiku.baidu.com/tikupc/singledetail/da157375a417866fb84a8e3d', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991559083393025', 'https://tiku.baidu.com/tikupc/singledetail/16106594dd88d0d233d46afe', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991559100170242', 'https://tiku.baidu.com/tikupc/singledetail/a9b6195f312b3169a451a465', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991559100170243', 'https://tiku.baidu.com/tikupc/singledetail/147252ea551810a6f5248679', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991559146307586', 'https://tiku.baidu.com/tikupc/singledetail/167d1ed9ad51f01dc281f11e', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991559171473410', 'https://tiku.baidu.com/tikupc/singledetail/2f322f60ddccda38376baf14', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991559171473411', 'https://tiku.baidu.com/tikupc/singledetail/fdd12df90242a8956bece4f9', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991559179862019', 'https://tiku.baidu.com/tikupc/singledetail/9dcb2e3f5727a5e9856a6182', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991559196639234', 'https://tiku.baidu.com/tikupc/singledetail/bf925fbfc77da26925c5b050', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991559213416449', 'https://tiku.baidu.com/tikupc/singledetail/cd07b307e87101f69e319547', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991559263748097', 'https://tiku.baidu.com/tikupc/singledetail/65b7cc22bcd126fff7050b3d', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991559280525314', 'https://tiku.baidu.com/tikupc/singledetail/2e76fad6195f312b3169a56f', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991559280525315', 'https://tiku.baidu.com/tikupc/singledetail/c4da7f0bf78a6529647d5324', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991559288913921', 'https://tiku.baidu.com/tikupc/singledetail/fc86770bf78a6529647d5378', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991559288913922', 'https://tiku.baidu.com/tikupc/singledetail/ce5c650e52ea551810a68747', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991559343439874', 'https://tiku.baidu.com/tikupc/singledetail/760eb90d6c85ec3a87c2c53a', '1025991546504675329', '0');
INSERT INTO `crawler_question` VALUES ('1025991559368605698', 'https://tiku.baidu.com/tikupc/singledetail/b8db84254b35eefdc8d3330f', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991559376994305', 'https://tiku.baidu.com/tikupc/singledetail/a1a179fe910ef12d2af9e726', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991559406354433', 'https://tiku.baidu.com/tikupc/singledetail/e275763231126edb6f1a1078', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991559406354434', 'https://tiku.baidu.com/tikupc/singledetail/df53866fb84ae45c3b358c41', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991559423131649', 'https://tiku.baidu.com/tikupc/singledetail/c3e426284b73f242336c5f9c', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991559431520258', 'https://tiku.baidu.com/tikupc/singledetail/980569eae009581b6bd9eb47', '1025991546504675329', '0');
INSERT INTO `crawler_question` VALUES ('1025991559473463298', 'https://tiku.baidu.com/tikupc/singledetail/83c40508763231126edb110f', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991559498629121', 'https://tiku.baidu.com/tikupc/singledetail/7ff4ac02de80d4d8d15a4fa1', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991559498629122', 'https://tiku.baidu.com/tikupc/singledetail/b88784254b35eefdc8d33353', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991559511212033', 'https://tiku.baidu.com/tikupc/singledetail/cedfb207e87101f69e31959f', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991559527989250', 'https://tiku.baidu.com/tikupc/singledetail/a15c33687e21af45b307a81e', '1025991546504675329', '0');
INSERT INTO `crawler_question` VALUES ('1025991559553155074', 'https://tiku.baidu.com/tikupc/singledetail/53aafd0a79563c1ec5da7114', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991559607681026', 'https://tiku.baidu.com/tikupc/singledetail/fc095a1b6bd97f192279e905', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991559649624066', 'https://tiku.baidu.com/tikupc/singledetail/57610722192e45361066f543', '1025991546504675329', '0');
INSERT INTO `crawler_question` VALUES ('1025991559649624068', 'https://tiku.baidu.com/tikupc/singledetail/93d6f6ec4afe04a1b071de9f', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991559649624067', 'https://tiku.baidu.com/tikupc/singledetail/cd4e55270722192e4536f65c', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991559658012673', 'https://tiku.baidu.com/tikupc/singledetail/64b59e3143323968011c9246', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991559695761410', 'https://tiku.baidu.com/tikupc/singledetail/57d8f90f76c66137ee06192e', '1025991546840219650', '0');
INSERT INTO `crawler_question` VALUES ('1025991559704150018', 'https://tiku.baidu.com/tikupc/singledetail/4ddb52e2524de518964b7d04', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991559729315842', 'https://tiku.baidu.com/tikupc/singledetail/c0164b323968011ca3009122', '1025991546504675329', '0');
INSERT INTO `crawler_question` VALUES ('1025991559687372802', 'https://tiku.baidu.com/tikupc/singledetail/20c0551810a6f524ccbf852f', '1025991547041546242', '0');
INSERT INTO `crawler_question` VALUES ('1025991559729315841', 'https://tiku.baidu.com/tikupc/singledetail/a78c83c758f5f61fb7366663', '1025991536673226757', '0');
INSERT INTO `crawler_question` VALUES ('1025991559750287361', 'https://tiku.baidu.com/tikupc/singledetail/add35e0e7cd184254b3535c1', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991559750287362', 'https://tiku.baidu.com/tikupc/singledetail/577d0722192e45361066f55f', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991559783841794', 'https://tiku.baidu.com/tikupc/singledetail/e371f042336c1eb91a375d07', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991559775453185', 'https://tiku.baidu.com/tikupc/singledetail/a11233687e21af45b307a850', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991559817396226', 'https://tiku.baidu.com/tikupc/singledetail/1909ba1aa8114431b90dd800', '1025991546840219650', '0');
INSERT INTO `crawler_question` VALUES ('1025991559842562050', 'https://tiku.baidu.com/tikupc/singledetail/28a5b0717fd5360cba1adb01', '1025991547041546242', '0');
INSERT INTO `crawler_question` VALUES ('1025991559842562051', 'https://tiku.baidu.com/tikupc/singledetail/751e7d19227916888486d7c2', '1025991536673226757', '0');
INSERT INTO `crawler_question` VALUES ('1025991559846756354', 'https://tiku.baidu.com/tikupc/singledetail/4af85acfa1c7aa00b52acb82', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991559913865217', 'https://tiku.baidu.com/tikupc/singledetail/deca876fb84ae45c3b358cd8', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991559913865218', 'https://tiku.baidu.com/tikupc/singledetail/b93a5727a5e9856a56126000', '1025991546840219650', '0');
INSERT INTO `crawler_question` VALUES ('1025991559951613953', 'https://tiku.baidu.com/tikupc/singledetail/772c915f804d2b160b4ec001', '1025991547041546242', '0');
INSERT INTO `crawler_question` VALUES ('1025991559951613954', 'https://tiku.baidu.com/tikupc/singledetail/6b4d703e0912a2161479292c', '1025991536673226757', '0');
INSERT INTO `crawler_question` VALUES ('1025991559968391169', 'https://tiku.baidu.com/tikupc/singledetail/65a3b6360b4c2e3f572763b9', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991560098414593', 'https://tiku.baidu.com/tikupc/singledetail/3a12034c2e3f5727a5e96221', '1025991536673226757', '0');
INSERT INTO `crawler_question` VALUES ('1025991560119386114', 'https://tiku.baidu.com/tikupc/singledetail/abeebb4cf7ec4afe04a1df2f', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991560119386115', 'https://tiku.baidu.com/tikupc/singledetail/5fa0971ea76e58fafab0035d', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991560119386113', 'https://tiku.baidu.com/tikupc/singledetail/60c18bd63186bceb19e8bb01', '1025991547041546242', '0');
INSERT INTO `crawler_question` VALUES ('1025991560140357633', 'https://tiku.baidu.com/tikupc/singledetail/61fa04a1b0717fd5360cdc01', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991560203272193', 'https://tiku.baidu.com/tikupc/singledetail/da087375a417866fb84a8e20', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991560203272194', 'https://tiku.baidu.com/tikupc/singledetail/f96a80c4bb4cf7ec4afed05c', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991560287158273', 'https://tiku.baidu.com/tikupc/singledetail/b9145727a5e9856a5612602e', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991560287158274', 'https://tiku.baidu.com/tikupc/singledetail/c6d23186bceb19e8b8f6ba01', '1025991547041546242', '0');
INSERT INTO `crawler_question` VALUES ('1025991560337489921', 'https://tiku.baidu.com/tikupc/singledetail/f7207e1cfad6195f312ba6d3', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991560358461441', 'https://tiku.baidu.com/tikupc/singledetail/142552ea551810a6f524862e', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991560358461442', 'https://tiku.baidu.com/tikupc/singledetail/954db52acfc789eb172dc848', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991560383627265', 'https://tiku.baidu.com/tikupc/singledetail/256d084c2e3f5727a5e9625e', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991560408793089', 'https://tiku.baidu.com/tikupc/singledetail/0bf1a58da0116c175f0e482e', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991560438153218', 'https://tiku.baidu.com/tikupc/singledetail/475b25fff705cc175527098f', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991560446541827', 'https://tiku.baidu.com/tikupc/singledetail/d220f78a6529647d2728522e', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991560446541826', 'https://tiku.baidu.com/tikupc/singledetail/8db5eefdc8d376eeaeaa3185', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991560501067779', 'https://tiku.baidu.com/tikupc/singledetail/be906bec0975f46527d3e100', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991560501067778', 'https://tiku.baidu.com/tikupc/singledetail/ad53f81dc281e53a5802ff07', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991560543010818', 'https://tiku.baidu.com/tikupc/singledetail/e105753231126edb6f1a1008', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991560555593730', 'https://tiku.baidu.com/tikupc/singledetail/15c3df80d4d8d15abe234ec4', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991560589148163', 'https://tiku.baidu.com/tikupc/singledetail/27e559fb770bf78a652954c4', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991560589148162', 'https://tiku.baidu.com/tikupc/singledetail/9129e2bd960590c69ec37601', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991560635285506', 'https://tiku.baidu.com/tikupc/singledetail/66ad06a1284ac850ad02426f', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991560635285505', 'https://tiku.baidu.com/tikupc/singledetail/7a32bf360b4c2e3f57276328', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991560681422849', 'https://tiku.baidu.com/tikupc/singledetail/686cbe1e650e52ea55189829', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991560681422850', 'https://tiku.baidu.com/tikupc/singledetail/0308482fb4daa58da0114a2e', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991560681422852', 'https://tiku.baidu.com/tikupc/singledetail/524b6429647d27284b7351c4', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991560681422853', 'https://tiku.baidu.com/tikupc/singledetail/60b9960590c69ec3d5bb7501', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991560773697537', 'https://tiku.baidu.com/tikupc/singledetail/d9df504de518964bcf847c38', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991560794669058', 'https://tiku.baidu.com/tikupc/singledetail/400610661ed9ad51f01df235', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991560836612098', 'https://tiku.baidu.com/tikupc/singledetail/1f24af45b307e87101f69600', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991560874360834', 'https://tiku.baidu.com/tikupc/singledetail/55b7ec630b1c59eef8c7b49f', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991560874360835', 'https://tiku.baidu.com/tikupc/singledetail/7705915f804d2b160b4ec028', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991560886943745', 'https://tiku.baidu.com/tikupc/singledetail/12a29cc3d5bbfd0a79567361', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991560903720962', 'https://tiku.baidu.com/tikupc/singledetail/14d99ec3d5bbfd0a7956731a', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991560903720961', 'https://tiku.baidu.com/tikupc/singledetail/60cc8bd63186bceb19e8bb0c', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991560941469697', 'https://tiku.baidu.com/tikupc/singledetail/772b915f804d2b160b4ec006', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991560958246913', 'https://tiku.baidu.com/tikupc/singledetail/afd6fab069dc5022aaea0029', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991560991801345', 'https://tiku.baidu.com/tikupc/singledetail/f85581c4bb4cf7ec4afed063', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991561000189953', 'https://tiku.baidu.com/tikupc/singledetail/cbc5f61fb7360b4c2e3f6435', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991561067298817', 'https://tiku.baidu.com/tikupc/singledetail/f35b77232f60ddccda38a00f', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991561067298818', 'https://tiku.baidu.com/tikupc/singledetail/187dcf84b9d528ea81c77933', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991561105047553', 'https://tiku.baidu.com/tikupc/singledetail/29f6c8d376eeaeaad1f3300e', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991561126019075', 'https://tiku.baidu.com/tikupc/singledetail/dd02bd64783e0912a2162a2e', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991561126019076', 'https://tiku.baidu.com/tikupc/singledetail/32e049649b6648d7c1c74635', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991561197322242', 'https://tiku.baidu.com/tikupc/singledetail/9a7802768e9951e79b89270e', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991561230876673', 'https://tiku.baidu.com/tikupc/singledetail/686bbe1e650e52ea5518982e', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991561268625410', 'https://tiku.baidu.com/tikupc/singledetail/be91284ac850ad02de804135', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991561268625409', 'https://tiku.baidu.com/tikupc/singledetail/c204647d27284b73f2425028', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991561297985537', 'https://tiku.baidu.com/tikupc/singledetail/d91587c24028915f804dc22a', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991561369288706', 'https://tiku.baidu.com/tikupc/singledetail/5881ec3a87c24028915fc301', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991561394454530', 'https://tiku.baidu.com/tikupc/singledetail/cded0c225901020207409c2b', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991561444786177', 'https://tiku.baidu.com/tikupc/singledetail/dd1abd64783e0912a2162a36', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991561495117827', 'https://tiku.baidu.com/tikupc/singledetail/5e102279168884868762d60c', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991561495117829', 'https://tiku.baidu.com/tikupc/singledetail/5620ef630b1c59eef8c7b408', '1025991538736824324', '0');
INSERT INTO `crawler_question` VALUES ('1025991561495117828', 'https://tiku.baidu.com/tikupc/singledetail/f905c281e53a580216fcfe1d', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991561495117826', 'https://tiku.baidu.com/tikupc/singledetail/64a2f524ccbff121dd368301', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991561595781123', 'https://tiku.baidu.com/tikupc/singledetail/d68bf7335a8102d276a22fe8', '1025991538736824324', '0');
INSERT INTO `crawler_question` VALUES ('1025991561595781122', 'https://tiku.baidu.com/tikupc/singledetail/b1ee4028915f804d2b16c129', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991561595781124', 'https://tiku.baidu.com/tikupc/singledetail/9a113b3567ec102de2bd8948', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991561604169730', 'https://tiku.baidu.com/tikupc/singledetail/5953336c1eb91a37f1115c14', '1025991538300616705', '0');
INSERT INTO `crawler_question` VALUES ('1025991561646112770', 'https://tiku.baidu.com/tikupc/singledetail/441867ec102de2bd96058828', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991561696444418', 'https://tiku.baidu.com/tikupc/singledetail/e9a6f08a6529647d272852a8', '1025991538736824324', '0');
INSERT INTO `crawler_question` VALUES ('1025991561696444417', 'https://tiku.baidu.com/tikupc/singledetail/51ee998fcc22bcd126ff0c01', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991561797107713', 'https://tiku.baidu.com/tikupc/singledetail/681f964bcf84b9d528ea7a02', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991561797107714', 'https://tiku.baidu.com/tikupc/singledetail/49636a0203d8ce2f006623ef', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991561839050754', 'https://tiku.baidu.com/tikupc/singledetail/18cebb1aa8114431b90dd8c7', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991561893576705', 'https://tiku.baidu.com/tikupc/singledetail/1c86eff9aef8941ea76e0585', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991561893576706', 'https://tiku.baidu.com/tikupc/singledetail/7a37bfeb19e8b8f67c1cb9b4', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991561927131137', 'https://tiku.baidu.com/tikupc/singledetail/bf1585254b35eefdc8d333c1', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991561960685569', 'https://tiku.baidu.com/tikupc/singledetail/dae175a20029bd64783e2c36', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991561973268483', 'https://tiku.baidu.com/tikupc/singledetail/29da49d7c1c708a1284a44b9', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991561973268482', 'https://tiku.baidu.com/tikupc/singledetail/1c00a7116c175f0e7cd13788', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991562011017217', 'https://tiku.baidu.com/tikupc/singledetail/6766d0f34693daef5ef73dc9', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991562061348866', 'https://tiku.baidu.com/tikupc/singledetail/b64728160b4e767f5acfce0f', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991562086514689', 'https://tiku.baidu.com/tikupc/singledetail/a0dff9ec4afe04a1b071de96', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991562094903298', 'https://tiku.baidu.com/tikupc/singledetail/64303169a45177232f60a21e', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991562103291906', 'https://tiku.baidu.com/tikupc/singledetail/3d3f846a561252d380eb6ed3', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991562153623554', 'https://tiku.baidu.com/tikupc/singledetail/cbb3172ded630b1c59eeb55d', '1025991548903817219', '0');
INSERT INTO `crawler_question` VALUES ('1025991562199760898', 'https://tiku.baidu.com/tikupc/singledetail/bfa0175f312b3169a451a473', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991562199760897', 'https://tiku.baidu.com/tikupc/singledetail/d57ef6335a8102d276a22f1d', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991562224926722', 'https://tiku.baidu.com/tikupc/singledetail/4876690203d8ce2f006623fa', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991562224926723', 'https://tiku.baidu.com/tikupc/singledetail/fc8bc1c708a1284ac8504359', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991562271064065', 'https://tiku.baidu.com/tikupc/singledetail/7e6abb68a98271fe910ef965', '1025991548903817219', '0');
INSERT INTO `crawler_question` VALUES ('1025991562287841282', 'https://tiku.baidu.com/tikupc/singledetail/139e62175f0e7cd18425368a', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991562321395713', 'https://tiku.baidu.com/tikupc/singledetail/237f541810a6f524ccbf8590', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991562342367234', 'https://tiku.baidu.com/tikupc/singledetail/6828a300a6c30c2259019e31', '1025991548618604545', '0');
INSERT INTO `crawler_question` VALUES ('1025991562363338754', 'https://tiku.baidu.com/tikupc/singledetail/02b4492fb4daa58da0114a92', '1025991548903817219', '0');
INSERT INTO `crawler_question` VALUES ('1025991562396893186', 'https://tiku.baidu.com/tikupc/singledetail/af1f71d5360cba1aa811da6b', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991562430447617', 'https://tiku.baidu.com/tikupc/singledetail/7709915f804d2b160b4ec024', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991562522722305', 'https://tiku.baidu.com/tikupc/singledetail/5e512279168884868762d64d', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991562585636866', 'https://tiku.baidu.com/tikupc/singledetail/8ab5cec789eb172ded63b79a', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991562614996993', 'https://tiku.baidu.com/tikupc/singledetail/5175011ca300a6c30c229f18', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991562623385602', 'https://tiku.baidu.com/tikupc/singledetail/90cbba0d4a7302768e993939', '1025991549654597635', '0');
INSERT INTO `crawler_question` VALUES ('1025991562656940034', 'https://tiku.baidu.com/tikupc/singledetail/a78173fe910ef12d2af9e706', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991562782769154', 'https://tiku.baidu.com/tikupc/singledetail/8bd400f69e314332396893a0', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991562782769155', 'https://tiku.baidu.com/tikupc/singledetail/cf62a5e9856a561252d36f40', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991562782769153', 'https://tiku.baidu.com/tikupc/singledetail/6b23af1ffc4ffe473368ab4d', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991562833100802', 'https://tiku.baidu.com/tikupc/singledetail/94deb42acfc789eb172dc8db', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991562833100801', 'https://tiku.baidu.com/tikupc/singledetail/f66a1711cc7931b765ce1516', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991562875043843', 'https://tiku.baidu.com/tikupc/singledetail/f1723c1ec5da50e2524d7f21', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991562875043844', 'https://tiku.baidu.com/tikupc/singledetail/67ba580102020740be1e9b9d', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991562875043842', 'https://tiku.baidu.com/tikupc/singledetail/6128900ef12d2af90242e6d3', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991562875043845', 'https://tiku.baidu.com/tikupc/singledetail/f66ab4daa58da0116c174940', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991562929569793', 'https://tiku.baidu.com/tikupc/singledetail/6efe2cc58bd63186bcebbc3e', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991562937958402', 'https://tiku.baidu.com/tikupc/singledetail/f82e81c4bb4cf7ec4afed018', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991562937958403', 'https://tiku.baidu.com/tikupc/singledetail/85c8d838376baf1ffc4fad01', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991563000872962', 'https://tiku.baidu.com/tikupc/singledetail/1a5ad4bbfd0a79563c1e729c', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991563000872963', 'https://tiku.baidu.com/tikupc/singledetail/53547e21af45b307e8719739', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991562988290050', 'https://tiku.baidu.com/tikupc/singledetail/866add36a32d7375a417804e', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991563051204610', 'https://tiku.baidu.com/tikupc/singledetail/66aba100a6c30c2259019eb2', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991563051204609', 'https://tiku.baidu.com/tikupc/singledetail/8e364b73f242336c1eb95e1b', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991563059593219', 'https://tiku.baidu.com/tikupc/singledetail/40d84a35eefdc8d376ee32f8', '1025991550099193862', '0');
INSERT INTO `crawler_question` VALUES ('1025991563059593218', 'https://tiku.baidu.com/tikupc/singledetail/622f3369a45177232f60a201', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991563026038786', 'https://tiku.baidu.com/tikupc/singledetail/64343169a45177232f60a21a', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991563193810945', 'https://tiku.baidu.com/tikupc/singledetail/0437192e453610661ed9f410', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991563193810946', 'https://tiku.baidu.com/tikupc/singledetail/546aed630b1c59eef8c7b442', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991563218976769', 'https://tiku.baidu.com/tikupc/singledetail/e3f02bf90242a8956bece4d8', '1025991550099193862', '0');
INSERT INTO `crawler_question` VALUES ('1025991563218976770', 'https://tiku.baidu.com/tikupc/singledetail/b6e7142ded630b1c59eeb509', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991563290279939', 'https://tiku.baidu.com/tikupc/singledetail/ae505f0e7cd184254b353542', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991563290279938', 'https://tiku.baidu.com/tikupc/singledetail/1757a8956bec0975f465e210', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991563311251458', 'https://tiku.baidu.com/tikupc/singledetail/6477b5360b4c2e3f5727636d', '1025991550099193862', '0');
INSERT INTO `crawler_question` VALUES ('1025991563319640065', 'https://tiku.baidu.com/tikupc/singledetail/6e16b10d6c85ec3a87c2c522', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991563328028673', 'https://tiku.baidu.com/tikupc/singledetail/400f10661ed9ad51f01df23c', '1025991539923812354', '0');
INSERT INTO `crawler_question` VALUES ('1025991563369971714', 'https://tiku.baidu.com/tikupc/singledetail/8a4b6c85ec3a87c24028c443', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991563382554626', 'https://tiku.baidu.com/tikupc/singledetail/4d7f312b3169a4517723a325', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991563416109059', 'https://tiku.baidu.com/tikupc/singledetail/fcd6dd88d0d233d4b14e6947', '1025991539923812354', '0');
INSERT INTO `crawler_question` VALUES ('1025991563416109058', 'https://tiku.baidu.com/tikupc/singledetail/363bf2d6195f312b3169a522', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991563416109060', 'https://tiku.baidu.com/tikupc/singledetail/5962336c1eb91a37f1115c25', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991563504189441', 'https://tiku.baidu.com/tikupc/singledetail/57b4f90f76c66137ee061942', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991563550326785', 'https://tiku.baidu.com/tikupc/singledetail/9df17fd5360cba1aa811da85', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991563592269826', 'https://tiku.baidu.com/tikupc/singledetail/d91b87c24028915f804dc224', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991563634212867', 'https://tiku.baidu.com/tikupc/singledetail/7d760875f46527d3240ce09f', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991563634212869', 'https://tiku.baidu.com/tikupc/singledetail/58a8326c1eb91a37f1115cef', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991563634212870', 'https://tiku.baidu.com/tikupc/singledetail/74a2e009581b6bd97f19ea4d', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991563634212866', 'https://tiku.baidu.com/tikupc/singledetail/1bcb700abb68a98271fefa32', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991563806179330', 'https://tiku.baidu.com/tikupc/singledetail/1f40561252d380eb62946d2f', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991563806179329', 'https://tiku.baidu.com/tikupc/singledetail/d8a986c24028915f804dc296', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991563806179332', 'https://tiku.baidu.com/tikupc/singledetail/5963336c1eb91a37f1115c24', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991563806179331', 'https://tiku.baidu.com/tikupc/singledetail/87466e1aff00bed5b9f31d98', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991563806179333', 'https://tiku.baidu.com/tikupc/singledetail/1934ba1aa8114431b90dd83d', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991563806179334', 'https://tiku.baidu.com/tikupc/singledetail/faea750bf78a6529647d5314', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991563806179335', 'https://tiku.baidu.com/tikupc/singledetail/8087366baf1ffc4ffe47acba', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991563965562881', 'https://tiku.baidu.com/tikupc/singledetail/5f3bed3a87c24028915fc3bb', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991563965562882', 'https://tiku.baidu.com/tikupc/singledetail/99144431b90d6c85ec3ac600', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991563965562884', 'https://tiku.baidu.com/tikupc/singledetail/5179011ca300a6c30c229f14', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991563965562885', 'https://tiku.baidu.com/tikupc/singledetail/45f366ec102de2bd960588c3', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991563965562886', 'https://tiku.baidu.com/tikupc/singledetail/40b24a35eefdc8d376ee3292', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991563965562887', 'https://tiku.baidu.com/tikupc/singledetail/b8d45627a5e9856a561260ee', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991563965562888', 'https://tiku.baidu.com/tikupc/singledetail/da077375a417866fb84a8e2f', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991564091392003', 'https://tiku.baidu.com/tikupc/singledetail/749b4b7302768e9951e73893', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991564091392002', 'https://tiku.baidu.com/tikupc/singledetail/29f928ea81c758f5f61f6729', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991564124946434', 'https://tiku.baidu.com/tikupc/singledetail/70c333d4b14e852458fb5714', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991564124946435', 'https://tiku.baidu.com/tikupc/singledetail/b7aef011f18583d04964599c', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991564124946436', 'https://tiku.baidu.com/tikupc/singledetail/c82c162ded630b1c59eeb5c2', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991564166889474', 'https://tiku.baidu.com/tikupc/singledetail/61f804a1b0717fd5360cdc03', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991564166889473', 'https://tiku.baidu.com/tikupc/singledetail/d3e0f68a6529647d272852ee', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991564187860993', 'https://tiku.baidu.com/tikupc/singledetail/cbd9f61fb7360b4c2e3f6429', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991564187860996', 'https://tiku.baidu.com/tikupc/singledetail/47226bd97f1922791688e83c', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991564187860994', 'https://tiku.baidu.com/tikupc/singledetail/4c4251e2524de518964b7d9d', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991564187860997', 'https://tiku.baidu.com/tikupc/singledetail/90ebe3bd960590c69ec376c3', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991564267552769', 'https://tiku.baidu.com/tikupc/singledetail/f14075232f60ddccda38a014', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991564275941378', 'https://tiku.baidu.com/tikupc/singledetail/7a0c79563c1ec5da50e27003', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991564330467332', 'https://tiku.baidu.com/tikupc/singledetail/a810185f312b3169a451a4c3', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991564330467331', 'https://tiku.baidu.com/tikupc/singledetail/b82b80c758f5f61fb73666c4', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991564330467330', 'https://tiku.baidu.com/tikupc/singledetail/1cffaef8941ea76e58fa0403', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991564410159107', 'https://tiku.baidu.com/tikupc/singledetail/cedc80eb6294dd88d0d26b0a', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991564410159106', 'https://tiku.baidu.com/tikupc/singledetail/87e2da38376baf1ffc4fad2b', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991564439519233', 'https://tiku.baidu.com/tikupc/singledetail/b1804028915f804d2b16c147', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991564439519234', 'https://tiku.baidu.com/tikupc/singledetail/132bbed5b9f3f90f76c61b2e', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991564498239490', 'https://tiku.baidu.com/tikupc/singledetail/9d767fd5360cba1aa811da02', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991564498239491', 'https://tiku.baidu.com/tikupc/singledetail/f3d077232f60ddccda38a084', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991564523405313', 'https://tiku.baidu.com/tikupc/singledetail/2f332f60ddccda38376baf15', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991564531793922', 'https://tiku.baidu.com/tikupc/singledetail/da75534de518964bcf847c92', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991564531793923', 'https://tiku.baidu.com/tikupc/singledetail/9c0a7cd184254b35eefd3401', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991564590514177', 'https://tiku.baidu.com/tikupc/singledetail/6c5f0740be1e650e52ea9958', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991564607291393', 'https://tiku.baidu.com/tikupc/singledetail/163876c66137ee06eff91832', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991564607291394', 'https://tiku.baidu.com/tikupc/singledetail/750b4a7302768e9951e73803', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991564615680001', 'https://tiku.baidu.com/tikupc/singledetail/340702020740be1e650e9a03', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991564615680002', 'https://tiku.baidu.com/tikupc/singledetail/3d0f864769eae009581bec06', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991564682788865', 'https://tiku.baidu.com/tikupc/singledetail/c2ba647d27284b73f2425096', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991564703760385', 'https://tiku.baidu.com/tikupc/singledetail/c911a6c30c22590102029d14', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991564703760386', 'https://tiku.baidu.com/tikupc/singledetail/28aab0717fd5360cba1adb0e', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991564724731905', 'https://tiku.baidu.com/tikupc/singledetail/b9ad71fe910ef12d2af9e72a', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991564724731906', 'https://tiku.baidu.com/tikupc/singledetail/c8d482eb6294dd88d0d26b02', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991564804423683', 'https://tiku.baidu.com/tikupc/singledetail/00d876eeaeaad1f346933f0e', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991564804423681', 'https://tiku.baidu.com/tikupc/singledetail/7e7cbb68a98271fe910ef973', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991564804423682', 'https://tiku.baidu.com/tikupc/singledetail/e2cff342336c1eb91a375db9', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991564804423685', 'https://tiku.baidu.com/tikupc/singledetail/8a12a8114431b90d6c85c70d', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991564804423684', 'https://tiku.baidu.com/tikupc/singledetail/64c9a55177232f60ddcca1a5', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991564930252802', 'https://tiku.baidu.com/tikupc/singledetail/28acb0717fd5360cba1adb08', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991564930252803', 'https://tiku.baidu.com/tikupc/singledetail/b5aca88271fe910ef12df8c1', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991564930252804', 'https://tiku.baidu.com/tikupc/singledetail/f659b4daa58da0116c174973', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991564984778753', 'https://tiku.baidu.com/tikupc/singledetail/c9f2f41fb7360b4c2e3f6402', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991564984778754', 'https://tiku.baidu.com/tikupc/singledetail/b44ff111f18583d04964597d', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991565056081921', 'https://tiku.baidu.com/tikupc/singledetail/4db95bcfa1c7aa00b52acbc3', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991565060276226', 'https://tiku.baidu.com/tikupc/singledetail/dbb2524de518964bcf847c55', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991565060276227', 'https://tiku.baidu.com/tikupc/singledetail/f90780c4bb4cf7ec4afed031', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991565060276228', 'https://tiku.baidu.com/tikupc/singledetail/9e4c6beae009581b6bd9eb0e', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991565060276229', 'https://tiku.baidu.com/tikupc/singledetail/b9342b160b4e767f5acfce7c', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991565144162305', 'https://tiku.baidu.com/tikupc/singledetail/aaa00029bd64783e09122b07', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991565144162306', 'https://tiku.baidu.com/tikupc/singledetail/98f31fb91a37f111f1855b9a', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991565165133825', 'https://tiku.baidu.com/tikupc/singledetail/f534e6fdc8d376eeaeaa3104', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991565165133826', 'https://tiku.baidu.com/tikupc/singledetail/212cad45b307e87101f69608', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991565144162307', 'https://tiku.baidu.com/tikupc/singledetail/605a590102020740be1e9b7d', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991565198688257', 'https://tiku.baidu.com/tikupc/singledetail/137bbed5b9f3f90f76c61b7e', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991565253214210', 'https://tiku.baidu.com/tikupc/singledetail/75dab80d6c85ec3a87c2c5ee', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991565253214211', 'https://tiku.baidu.com/tikupc/singledetail/2c185a8102d276a200292e2e', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991565374849027', 'https://tiku.baidu.com/tikupc/singledetail/9e3031126edb6f1aff001f07', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991565374849025', 'https://tiku.baidu.com/tikupc/singledetail/7549e109581b6bd97f19eaa6', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991565374849026', 'https://tiku.baidu.com/tikupc/singledetail/891f3f6baf1ffc4ffe47ac22', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991565374849028', 'https://tiku.baidu.com/tikupc/singledetail/2f752f60ddccda38376baf53', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991565374849029', 'https://tiku.baidu.com/tikupc/singledetail/9fbeaa00b52acfc789ebc97c', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991565433569282', 'https://tiku.baidu.com/tikupc/singledetail/a248fe4733687e21af45a902', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991565492289537', 'https://tiku.baidu.com/tikupc/singledetail/0ab161dc5022aaea998f0f04', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991565492289539', 'https://tiku.baidu.com/tikupc/singledetail/90de5022aaea998fcc220e07', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991565492289538', 'https://tiku.baidu.com/tikupc/singledetail/a219fe4733687e21af45a953', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991565492289540', 'https://tiku.baidu.com/tikupc/singledetail/a68a814d2b160b4e767fcfd0', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991565542621187', 'https://tiku.baidu.com/tikupc/singledetail/572d0722192e45361066f50f', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991565542621186', 'https://tiku.baidu.com/tikupc/singledetail/a73c0912a216147917112807', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991565597147138', 'https://tiku.baidu.com/tikupc/singledetail/d35d8e9951e79b896802262e', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991565597147139', 'https://tiku.baidu.com/tikupc/singledetail/fc26112e453610661ed9f400', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991565626507266', 'https://tiku.baidu.com/tikupc/singledetail/57f1f90f76c66137ee061907', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991565718781953', 'https://tiku.baidu.com/tikupc/singledetail/a265caaedd3383c4bb4cd202', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991565735559170', 'https://tiku.baidu.com/tikupc/singledetail/f1503c1ec5da50e2524d7f03', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991565785890818', 'https://tiku.baidu.com/tikupc/singledetail/1cfbaef8941ea76e58fa0407', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991565777502210', 'https://tiku.baidu.com/tikupc/singledetail/963339126edb6f1aff001f04', '1025991525122113538', '0');
INSERT INTO `crawler_question` VALUES ('1025991565802668033', 'https://tiku.baidu.com/tikupc/singledetail/ab9825160b4e767f5acfced0', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991565819445250', 'https://tiku.baidu.com/tikupc/singledetail/b1c54028915f804d2b16c102', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991565844611073', 'https://tiku.baidu.com/tikupc/singledetail/6d74be23482fb4daa58d4b2b', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991565844611074', 'https://tiku.baidu.com/tikupc/singledetail/aa24aaea998fcc22bcd10d03', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991565899137027', 'https://tiku.baidu.com/tikupc/singledetail/952ab52acfc789eb172dc82f', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991565899137026', 'https://tiku.baidu.com/tikupc/singledetail/adb910b91a37f111f1855bd0', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991565903331330', 'https://tiku.baidu.com/tikupc/singledetail/6b6caf1ffc4ffe473368ab02', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991565945274370', 'https://tiku.baidu.com/tikupc/singledetail/707ead02de80d4d8d15a4f2b', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991565991411714', 'https://tiku.baidu.com/tikupc/singledetail/8014366baf1ffc4ffe47ac29', '1025991506973360129', '0');
INSERT INTO `crawler_question` VALUES ('1025991565991411715', 'https://tiku.baidu.com/tikupc/singledetail/be8f284ac850ad02de80412b', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991566054326274', 'https://tiku.baidu.com/tikupc/singledetail/1fc1f8c75fbfc77da269b12a', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991566096269313', 'https://tiku.baidu.com/tikupc/singledetail/340602020740be1e650e9a02', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991566154989570', 'https://tiku.baidu.com/tikupc/singledetail/8aa5daef5ef7ba0d4a733b33', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991566238875650', 'https://tiku.baidu.com/tikupc/singledetail/1a70a1116c175f0e7cd137f8', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991566268235777', 'https://tiku.baidu.com/tikupc/singledetail/87c3da38376baf1ffc4fad0a', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991566301790210', 'https://tiku.baidu.com/tikupc/singledetail/77b9dcccda38376baf1faedc', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991566360510466', 'https://tiku.baidu.com/tikupc/singledetail/889f0ad276a20029bd642d1b', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991566360510467', 'https://tiku.baidu.com/tikupc/singledetail/51dd998fcc22bcd126ff0c32', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991566431813633', 'https://tiku.baidu.com/tikupc/singledetail/9a7402768e9951e79b892702', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991566440202242', 'https://tiku.baidu.com/tikupc/singledetail/a9fbabea998fcc22bcd10ddc', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991566503116802', 'https://tiku.baidu.com/tikupc/singledetail/c72887eb6294dd88d0d26bfe', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991566524088323', 'https://tiku.baidu.com/tikupc/singledetail/bd2e03d8ce2f0066f5332229', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991566524088322', 'https://tiku.baidu.com/tikupc/singledetail/b40ff111f18583d04964593d', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991566524088324', 'https://tiku.baidu.com/tikupc/singledetail/c6e63186bceb19e8b8f6ba35', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991566637334531', 'https://tiku.baidu.com/tikupc/singledetail/6b77af1ffc4ffe473368ab19', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991566637334530', 'https://tiku.baidu.com/tikupc/singledetail/15c86a94dd88d0d233d46a26', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991566675083265', 'https://tiku.baidu.com/tikupc/singledetail/9f691eb91a37f111f1855b00', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991566675083266', 'https://tiku.baidu.com/tikupc/singledetail/400510661ed9ad51f01df236', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991566737997826', 'https://tiku.baidu.com/tikupc/singledetail/60fa960590c69ec3d5bb7542', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991566737997825', 'https://tiku.baidu.com/tikupc/singledetail/cbefcb7931b765ce050814fb', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991566763163650', 'https://tiku.baidu.com/tikupc/singledetail/0054168884868762caaed528', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991566763163651', 'https://tiku.baidu.com/tikupc/singledetail/cbe6172ded630b1c59eeb508', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991566805106690', 'https://tiku.baidu.com/tikupc/singledetail/64dc9e3143323968011c922f', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991566834466818', 'https://tiku.baidu.com/tikupc/singledetail/13e158f5f61fb7360b4c6523', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991566834466819', 'https://tiku.baidu.com/tikupc/singledetail/a1ce89c758f5f61fb7366621', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991566859632641', 'https://tiku.baidu.com/tikupc/singledetail/35a584868762caaedd33d428', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991566893187073', 'https://tiku.baidu.com/tikupc/singledetail/fa3083c4bb4cf7ec4afed006', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991566918352897', 'https://tiku.baidu.com/tikupc/singledetail/1330852458fb770bf78a557b', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991566981267458', 'https://tiku.baidu.com/tikupc/singledetail/55ebfb0f76c66137ee06191d', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991566951907330', 'https://tiku.baidu.com/tikupc/singledetail/3063767f5acfa1c7aa00cc28', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991566981267457', 'https://tiku.baidu.com/tikupc/singledetail/e84925c52cc58bd63186bd25', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991567014821890', 'https://tiku.baidu.com/tikupc/singledetail/3f03844769eae009581bec0a', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991567014821891', 'https://tiku.baidu.com/tikupc/singledetail/163b1ed9ad51f01dc281f158', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991567014821889', 'https://tiku.baidu.com/tikupc/singledetail/7670ddccda38376baf1fae15', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991567060959234', 'https://tiku.baidu.com/tikupc/singledetail/41624b35eefdc8d376ee3242', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991567060959233', 'https://tiku.baidu.com/tikupc/singledetail/ff62dc88d0d233d4b14e69f3', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991567132262402', 'https://tiku.baidu.com/tikupc/singledetail/9000ee06eff9aef8941e0632', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991567132262403', 'https://tiku.baidu.com/tikupc/singledetail/9d722e3f5727a5e9856a613b', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991567186788353', 'https://tiku.baidu.com/tikupc/singledetail/8ad4daef5ef7ba0d4a733b42', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991567195176962', 'https://tiku.baidu.com/tikupc/singledetail/6eb50540be1e650e52ea99b2', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991567195176963', 'https://tiku.baidu.com/tikupc/singledetail/5968336c1eb91a37f1115c2f', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991567237120001', 'https://tiku.baidu.com/tikupc/singledetail/87ddda38376baf1ffc4fad14', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991567249702913', 'https://tiku.baidu.com/tikupc/singledetail/53ebb9f3f90f76c661371a3b', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991567266480130', 'https://tiku.baidu.com/tikupc/singledetail/9f61c850ad02de80d4d8402e', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991567287451649', 'https://tiku.baidu.com/tikupc/singledetail/fcdb770bf78a6529647d5325', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991567266480129', 'https://tiku.baidu.com/tikupc/singledetail/d9ccf705cc17552707220836', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991567304228865', 'https://tiku.baidu.com/tikupc/singledetail/c92ba6c30c22590102029d2e', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991567354560515', 'https://tiku.baidu.com/tikupc/singledetail/0d6b68dc5022aaea998f0fde', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991567354560514', 'https://tiku.baidu.com/tikupc/singledetail/1820463610661ed9ad51f30b', '1025991524874649603', '0');
INSERT INTO `crawler_question` VALUES ('1025991567430057986', 'https://tiku.baidu.com/tikupc/singledetail/1bc7d5bbfd0a79563c1e7201', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991567430057985', 'https://tiku.baidu.com/tikupc/singledetail/fc90dd88d0d233d4b14e6901', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991567430057987', 'https://tiku.baidu.com/tikupc/singledetail/d5d4ce2f0066f5335a812109', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991567451029505', 'https://tiku.baidu.com/tikupc/singledetail/5c13f38583d049649b665807', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991567430057988', 'https://tiku.baidu.com/tikupc/singledetail/90985022aaea998fcc220e41', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991567522332674', 'https://tiku.baidu.com/tikupc/singledetail/d25b67ce05087632311212e9', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991567522332673', 'https://tiku.baidu.com/tikupc/singledetail/0058168884868762caaed524', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991567602024450', 'https://tiku.baidu.com/tikupc/singledetail/00d776eeaeaad1f346933f01', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991567602024452', 'https://tiku.baidu.com/tikupc/singledetail/aaeba22d7375a417866f8fd8', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991567602024451', 'https://tiku.baidu.com/tikupc/singledetail/b470f111f18583d049645942', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991567602024454', 'https://tiku.baidu.com/tikupc/singledetail/7672b90d6c85ec3a87c2c546', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991567602024453', 'https://tiku.baidu.com/tikupc/singledetail/19f5ad51f01dc281e53af029', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991567643967490', 'https://tiku.baidu.com/tikupc/singledetail/48db5beef8c75fbfc77db2c2', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991567685910531', 'https://tiku.baidu.com/tikupc/singledetail/286831b765ce050876321314', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991567719464962', 'https://tiku.baidu.com/tikupc/singledetail/14d891c69ec3d5bbfd0a74d8', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991567727853569', 'https://tiku.baidu.com/tikupc/singledetail/00f376eeaeaad1f346933f25', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991567719464963', 'https://tiku.baidu.com/tikupc/singledetail/6090960590c69ec3d5bb7528', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991567727853570', 'https://tiku.baidu.com/tikupc/singledetail/7764915f804d2b160b4ec049', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991567727853571', 'https://tiku.baidu.com/tikupc/singledetail/17eb5ef7ba0d4a7302763a01', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991567736242178', 'https://tiku.baidu.com/tikupc/singledetail/1d29fac75fbfc77da269b1c2', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991567769796609', 'https://tiku.baidu.com/tikupc/singledetail/82de9b89680203d8ce2f243c', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991567824322564', 'https://tiku.baidu.com/tikupc/singledetail/f8c3c381e53a580216fcfedb', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991567824322562', 'https://tiku.baidu.com/tikupc/singledetail/5fa72379168884868762d6bb', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991567832711170', 'https://tiku.baidu.com/tikupc/singledetail/a73a0912a216147917112801', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991567832711172', 'https://tiku.baidu.com/tikupc/singledetail/9a5502768e9951e79b892723', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991567832711171', 'https://tiku.baidu.com/tikupc/singledetail/b9155727a5e9856a5612602f', '1025991554108948482', '0');
INSERT INTO `crawler_question` VALUES ('1025991567845294081', 'https://tiku.baidu.com/tikupc/singledetail/b6beab8271fe910ef12df8d3', '1025991525549932545', '0');
INSERT INTO `crawler_question` VALUES ('1025991567920791553', 'https://tiku.baidu.com/tikupc/singledetail/849c6f1aff00bed5b9f31d42', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991567962734594', 'https://tiku.baidu.com/tikupc/singledetail/6fdbd15abe23482fb4da4c06', '1025991554108948482', '0');
INSERT INTO `crawler_question` VALUES ('1025991567992094721', 'https://tiku.baidu.com/tikupc/singledetail/e86a25c52cc58bd63186bd06', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991568017260546', 'https://tiku.baidu.com/tikupc/singledetail/1cd9aef8941ea76e58fa0425', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991568071786497', 'https://tiku.baidu.com/tikupc/singledetail/c6fd3186bceb19e8b8f6ba2e', '1025991554108948482', '0');
INSERT INTO `crawler_question` VALUES ('1025991568088563713', 'https://tiku.baidu.com/tikupc/singledetail/f21cfc4ffe4733687e21aa06', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991568096952321', 'https://tiku.baidu.com/tikupc/singledetail/1bb4700abb68a98271fefa4d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991568109535233', 'https://tiku.baidu.com/tikupc/singledetail/4d5c312b3169a4517723a306', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991568155672578', 'https://tiku.baidu.com/tikupc/singledetail/1d7c453610661ed9ad51f357', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991568164061185', 'https://tiku.baidu.com/tikupc/singledetail/9d757fd5360cba1aa811da01', '1025991554108948482', '0');
INSERT INTO `crawler_question` VALUES ('1025991568197615618', 'https://tiku.baidu.com/tikupc/singledetail/fcfcc1c708a1284ac850432e', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991568214392833', 'https://tiku.baidu.com/tikupc/singledetail/ce1d650e52ea551810a68706', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991568201809921', 'https://tiku.baidu.com/tikupc/singledetail/b9cb81c758f5f61fb7366624', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991568235364354', 'https://tiku.baidu.com/tikupc/singledetail/a984195f312b3169a451a457', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991568281501697', 'https://tiku.baidu.com/tikupc/singledetail/14c29ec3d5bbfd0a79567301', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991568281501698', 'https://tiku.baidu.com/tikupc/singledetail/20ee551810a6f524ccbf8501', '1025991554108948482', '0');
INSERT INTO `crawler_question` VALUES ('1025991568298278913', 'https://tiku.baidu.com/tikupc/singledetail/64a5f524ccbff121dd368306', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991568289890305', 'https://tiku.baidu.com/tikupc/singledetail/fa27b84ae45c3b3567ec8b4d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991568331833346', 'https://tiku.baidu.com/tikupc/singledetail/d055e87101f69e3143329457', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991568382164994', 'https://tiku.baidu.com/tikupc/singledetail/c549e45c3b3567ec102d8a06', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991568382164995', 'https://tiku.baidu.com/tikupc/singledetail/8c5d01f69e31433239689329', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991568436690946', 'https://tiku.baidu.com/tikupc/singledetail/16a5a9956bec0975f465e2e2', '1025991542897573891', '0');
INSERT INTO `crawler_question` VALUES ('1025991568436690945', 'https://tiku.baidu.com/tikupc/singledetail/282b31b765ce050876321357', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991568478633986', 'https://tiku.baidu.com/tikupc/singledetail/6235b7360b4c2e3f5727632f', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991568487022593', 'https://tiku.baidu.com/tikupc/singledetail/4087b9d528ea81c758f57806', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991568541548546', 'https://tiku.baidu.com/tikupc/singledetail/0a8fcf1755270722192ef78e', '1025991542897573891', '0');
INSERT INTO `crawler_question` VALUES ('1025991568549937154', 'https://tiku.baidu.com/tikupc/singledetail/e25a763231126edb6f1a1057', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991568566714369', 'https://tiku.baidu.com/tikupc/singledetail/3cc3856a561252d380eb6e2f', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991568667377666', 'https://tiku.baidu.com/tikupc/singledetail/85c7fe00bed5b9f3f90f1cd8', '1025991543019208709', '0');
INSERT INTO `crawler_question` VALUES ('1025991568667377667', 'https://tiku.baidu.com/tikupc/singledetail/da2e7375a417866fb84a8e06', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991568747069442', 'https://tiku.baidu.com/tikupc/singledetail/b8df5627a5e9856a561260e5', '1025991543019208709', '0');
INSERT INTO `crawler_question` VALUES ('1025991568763846658', 'https://tiku.baidu.com/tikupc/singledetail/60be960590c69ec3d5bb7506', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991568835149826', 'https://tiku.baidu.com/tikupc/singledetail/c26525284b73f242336c5f1d', '1025991543019208709', '0');
INSERT INTO `crawler_question` VALUES ('1025991568860315650', 'https://tiku.baidu.com/tikupc/singledetail/284c48d7c1c708a1284a442f', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991568940007427', 'https://tiku.baidu.com/tikupc/singledetail/70c733d4b14e852458fb5710', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991568940007426', 'https://tiku.baidu.com/tikupc/singledetail/5fc581d049649b6648d74745', '1025991543019208709', '0');
INSERT INTO `crawler_question` VALUES ('1025991569023893506', 'https://tiku.baidu.com/tikupc/singledetail/1beed5bbfd0a79563c1e7228', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991569057447937', 'https://tiku.baidu.com/tikupc/singledetail/f1683c1ec5da50e2524d7f3b', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991569111973889', 'https://tiku.baidu.com/tikupc/singledetail/4a725acfa1c7aa00b52acb08', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991569137139714', 'https://tiku.baidu.com/tikupc/singledetail/d9d076a20029bd64783e2c07', '1025991555241410562', '0');
INSERT INTO `crawler_question` VALUES ('1025991569170694146', 'https://tiku.baidu.com/tikupc/singledetail/40e94a35eefdc8d376ee32c9', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991569170694147', 'https://tiku.baidu.com/tikupc/singledetail/9d667fd5360cba1aa811da12', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991569233608707', 'https://tiku.baidu.com/tikupc/singledetail/84ee6f1aff00bed5b9f31d30', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991569233608706', 'https://tiku.baidu.com/tikupc/singledetail/7a3279563c1ec5da50e2703d', '1025991555241410562', '0');
INSERT INTO `crawler_question` VALUES ('1025991569246191617', 'https://tiku.baidu.com/tikupc/singledetail/9539b52acfc789eb172dc83c', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991569300717572', 'https://tiku.baidu.com/tikupc/singledetail/7e12bb68a98271fe910ef91d', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991569300717573', 'https://tiku.baidu.com/tikupc/singledetail/7d94ba68a98271fe910ef99b', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991569300717570', 'https://tiku.baidu.com/tikupc/singledetail/d1a2e97101f69e31433294a0', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991569342660611', 'https://tiku.baidu.com/tikupc/singledetail/f381fd4ffe4733687e21aa9b', '1025991555396599811', '0');
INSERT INTO `crawler_question` VALUES ('1025991569300717571', 'https://tiku.baidu.com/tikupc/singledetail/57d5f90f76c66137ee061923', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991569351049218', 'https://tiku.baidu.com/tikupc/singledetail/161e76c66137ee06eff91814', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991569351049219', 'https://tiku.baidu.com/tikupc/singledetail/8fedd238376baf1ffc4fad24', '1025991555241410562', '0');
INSERT INTO `crawler_question` VALUES ('1025991569325883393', 'https://tiku.baidu.com/tikupc/singledetail/6113900ef12d2af90242e6e8', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991569342660610', 'https://tiku.baidu.com/tikupc/singledetail/a567f01dc281e53a5802ff33', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991569426546691', 'https://tiku.baidu.com/tikupc/singledetail/da3a534de518964bcf847cdd', '1025991555396599811', '0');
INSERT INTO `crawler_question` VALUES ('1025991569418158082', 'https://tiku.baidu.com/tikupc/singledetail/fb71c0c708a1284ac85043a3', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991569443323907', 'https://tiku.baidu.com/tikupc/singledetail/9035ee06eff9aef8941e0607', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991569443323906', 'https://tiku.baidu.com/tikupc/singledetail/6f3be0bd960590c69ec37613', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991569443323905', 'https://tiku.baidu.com/tikupc/singledetail/139858f5f61fb7360b4c655a', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991569426546690', 'https://tiku.baidu.com/tikupc/singledetail/90fa5022aaea998fcc220e23', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991569468489730', 'https://tiku.baidu.com/tikupc/singledetail/53287e21af45b307e8719745', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991569426546689', 'https://tiku.baidu.com/tikupc/singledetail/aaf0a22d7375a417866f8fc3', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991569523015681', 'https://tiku.baidu.com/tikupc/singledetail/4e2a59eef8c75fbfc77db233', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991569552375809', 'https://tiku.baidu.com/tikupc/singledetail/8ec8effdc8d376eeaeaa31f8', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991569569153026', 'https://tiku.baidu.com/tikupc/singledetail/8ee489eb172ded630b1cb626', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991569569153028', 'https://tiku.baidu.com/tikupc/singledetail/a1bdff4733687e21af45a9f7', '1025991555396599811', '0');
INSERT INTO `crawler_question` VALUES ('1025991569569153027', 'https://tiku.baidu.com/tikupc/singledetail/98e34531b90d6c85ec3ac6f7', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991569569153029', 'https://tiku.baidu.com/tikupc/singledetail/ece0dd3383c4bb4cf7ecd14b', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991569585930241', 'https://tiku.baidu.com/tikupc/singledetail/2f202f60ddccda38376baf06', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991569636261890', 'https://tiku.baidu.com/tikupc/singledetail/1a08dc80d4d8d15abe234e0f', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991569690787842', 'https://tiku.baidu.com/tikupc/singledetail/8a6d03f69e31433239689319', '1025991534584463361', '0');
INSERT INTO `crawler_question` VALUES ('1025991569690787843', 'https://tiku.baidu.com/tikupc/singledetail/1868cf84b9d528ea81c77926', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991569690787845', 'https://tiku.baidu.com/tikupc/singledetail/52c514fc700abb68a982fbc2', '1025991555396599811', '0');
INSERT INTO `crawler_question` VALUES ('1025991569690787844', 'https://tiku.baidu.com/tikupc/singledetail/90dfe3bd960590c69ec376f7', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991569690787846', 'https://tiku.baidu.com/tikupc/singledetail/145b52ea551810a6f5248650', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991569699176450', 'https://tiku.baidu.com/tikupc/singledetail/e86d25c52cc58bd63186bd01', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991569741119489', 'https://tiku.baidu.com/tikupc/singledetail/d40ff58a6529647d27285201', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991569783062531', 'https://tiku.baidu.com/tikupc/singledetail/c83782eb6294dd88d0d26be1', '1025991555396599811', '0');
INSERT INTO `crawler_question` VALUES ('1025991569783062533', 'https://tiku.baidu.com/tikupc/singledetail/51a56529647d27284b73512a', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991569783062530', 'https://tiku.baidu.com/tikupc/singledetail/90a7ba0d4a7302768e993955', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991569783062532', 'https://tiku.baidu.com/tikupc/singledetail/c9f1152ded630b1c59eeb51f', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991569783062534', 'https://tiku.baidu.com/tikupc/singledetail/cd38b307e87101f69e319578', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991569833394178', 'https://tiku.baidu.com/tikupc/singledetail/6d657c21af45b307e8719708', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991569841782785', 'https://tiku.baidu.com/tikupc/singledetail/74c7e009581b6bd97f19ea28', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991569913085954', 'https://tiku.baidu.com/tikupc/singledetail/4d0c312b3169a4517723a356', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991569913085955', 'https://tiku.baidu.com/tikupc/singledetail/3047767f5acfa1c7aa00cc0c', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991569921474562', 'https://tiku.baidu.com/tikupc/singledetail/e282f342336c1eb91a375df4', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991569950834690', 'https://tiku.baidu.com/tikupc/singledetail/2f0d2f60ddccda38376baf2b', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991569984389121', 'https://tiku.baidu.com/tikupc/singledetail/5657b9f67c1cfad6195fa7ba', '1025991555874750465', '0');
INSERT INTO `crawler_question` VALUES ('1025991569992777731', 'https://tiku.baidu.com/tikupc/singledetail/64783169a45177232f60a256', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991570043109377', 'https://tiku.baidu.com/tikupc/singledetail/53467e21af45b307e871972b', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991570076663810', 'https://tiku.baidu.com/tikupc/singledetail/e3d22bf90242a8956bece4fa', '1025991555874750465', '0');
INSERT INTO `crawler_question` VALUES ('1025991570135384066', 'https://tiku.baidu.com/tikupc/singledetail/1f0eaf45b307e87101f6962a', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991570135384065', 'https://tiku.baidu.com/tikupc/singledetail/55f8fb0f76c66137ee06190e', '1025991556222877698', '0');
INSERT INTO `crawler_question` VALUES ('1025991570156355586', 'https://tiku.baidu.com/tikupc/singledetail/8f25ecfdc8d376eeaeaa3115', '1025991555874750465', '0');
INSERT INTO `crawler_question` VALUES ('1025991570198298626', 'https://tiku.baidu.com/tikupc/singledetail/0412192e453610661ed9f435', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991570257018881', 'https://tiku.baidu.com/tikupc/singledetail/33f04535eefdc8d376ee32d0', '1025991556222877698', '0');
INSERT INTO `crawler_question` VALUES ('1025991570277990401', 'https://tiku.baidu.com/tikupc/singledetail/6256cd22bcd126fff7050bdc', '1025991556348706819', '0');
INSERT INTO `crawler_question` VALUES ('1025991570328322050', 'https://tiku.baidu.com/tikupc/singledetail/9e806beae009581b6bd9ebc2', '1025991555874750465', '0');
INSERT INTO `crawler_question` VALUES ('1025991570395430913', 'https://tiku.baidu.com/tikupc/singledetail/dbfef505cc17552707220804', '1025991556348706819', '0');
INSERT INTO `crawler_question` VALUES ('1025991570500288513', 'https://tiku.baidu.com/tikupc/singledetail/85cad838376baf1ffc4fad03', '1025991556348706819', '0');
INSERT INTO `crawler_question` VALUES ('1025991570689032194', 'https://tiku.baidu.com/tikupc/singledetail/1c006394dd88d0d233d46aee', '1025991556348706819', '0');
INSERT INTO `crawler_question` VALUES ('1025991570819055617', 'https://tiku.baidu.com/tikupc/singledetail/41674b35eefdc8d376ee3247', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991570819055618', 'https://tiku.baidu.com/tikupc/singledetail/8af4cec789eb172ded63b7db', '1025991543325392899', '0');
INSERT INTO `crawler_question` VALUES ('1025991570840027138', 'https://tiku.baidu.com/tikupc/singledetail/80ca366baf1ffc4ffe47acf7', '1025991556348706819', '0');
INSERT INTO `crawler_question` VALUES ('1025991570865192961', 'https://tiku.baidu.com/tikupc/singledetail/1144f46527d3240c8447ef34', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991570923913217', 'https://tiku.baidu.com/tikupc/singledetail/9410aa114431b90d6c85c70f', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991570974244866', 'https://tiku.baidu.com/tikupc/singledetail/64203169a45177232f60a20e', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991571037159425', 'https://tiku.baidu.com/tikupc/singledetail/e003743231126edb6f1a100e', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991571108462593', 'https://tiku.baidu.com/tikupc/singledetail/1ccdaef8941ea76e58fa0431', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991571121045506', 'https://tiku.baidu.com/tikupc/singledetail/87f4da38376baf1ffc4fad3d', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991571162988547', 'https://tiku.baidu.com/tikupc/singledetail/1a68a1116c175f0e7cd137e0', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991571162988546', 'https://tiku.baidu.com/tikupc/singledetail/d50b64ce05087632311212b9', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991571242680322', 'https://tiku.baidu.com/tikupc/singledetail/d5e0ce2f0066f5335a81213d', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991571251068930', 'https://tiku.baidu.com/tikupc/singledetail/aa940029bd64783e09122b33', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991571251068931', 'https://tiku.baidu.com/tikupc/singledetail/c5d020284b73f242336c5fa8', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991571284623362', 'https://tiku.baidu.com/tikupc/singledetail/61b804a1b0717fd5360cdc43', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991571293011969', 'https://tiku.baidu.com/tikupc/singledetail/819acdbff121dd36a32d82bb', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991571284623363', 'https://tiku.baidu.com/tikupc/singledetail/3ee80242a8956bec0975e314', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991571293011970', 'https://tiku.baidu.com/tikupc/singledetail/40c04a35eefdc8d376ee32e0', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991571372703746', 'https://tiku.baidu.com/tikupc/singledetail/fa57b84ae45c3b3567ec8b3d', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991571343343618', 'https://tiku.baidu.com/tikupc/singledetail/49fcb8f67c1cfad6195fa711', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991571372703747', 'https://tiku.baidu.com/tikupc/singledetail/9fe4aa00b52acfc789ebc926', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991571427229698', 'https://tiku.baidu.com/tikupc/singledetail/c24325284b73f242336c5f3b', '1025991543585439745', '0');
INSERT INTO `crawler_question` VALUES ('1025991571427229699', 'https://tiku.baidu.com/tikupc/singledetail/14819ec3d5bbfd0a79567342', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991571372703748', 'https://tiku.baidu.com/tikupc/singledetail/3c10874769eae009581bec19', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991571477561346', 'https://tiku.baidu.com/tikupc/singledetail/3902b4d126fff705cc170a25', '1025991557929959426', '0');
INSERT INTO `crawler_question` VALUES ('1025991571477561347', 'https://tiku.baidu.com/tikupc/singledetail/e7fd102de2bd960590c67714', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991571548864514', 'https://tiku.baidu.com/tikupc/singledetail/159953ea551810a6f5248692', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991571548864517', 'https://tiku.baidu.com/tikupc/singledetail/8b9a6d85ec3a87c24028c492', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991571548864516', 'https://tiku.baidu.com/tikupc/singledetail/242a3968011ca300a6c3901d', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991571624361986', 'https://tiku.baidu.com/tikupc/singledetail/22102c60ddccda38376baf36', '1025991543585439745', '0');
INSERT INTO `crawler_question` VALUES ('1025991571624361988', 'https://tiku.baidu.com/tikupc/singledetail/b8e984254b35eefdc8d3333d', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991571624361987', 'https://tiku.baidu.com/tikupc/singledetail/e147f242336c1eb91a375d31', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991571632750594', 'https://tiku.baidu.com/tikupc/singledetail/2706a745b307e87101f69622', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991571649527810', 'https://tiku.baidu.com/tikupc/singledetail/b8da2a160b4e767f5acfce92', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991571674693633', 'https://tiku.baidu.com/tikupc/singledetail/cd58b307e87101f69e319518', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991571674693634', 'https://tiku.baidu.com/tikupc/singledetail/fcea770bf78a6529647d5314', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991571666305026', 'https://tiku.baidu.com/tikupc/singledetail/4f9d50e2524de518964b7d42', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991571729219585', 'https://tiku.baidu.com/tikupc/singledetail/53517e21af45b307e871973c', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991571737608193', 'https://tiku.baidu.com/tikupc/singledetail/64f99e3143323968011c920a', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991571737608194', 'https://tiku.baidu.com/tikupc/singledetail/f562bb07e87101f69e319522', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991571787939842', 'https://tiku.baidu.com/tikupc/singledetail/74d908a1284ac850ad02421b', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991571762774017', 'https://tiku.baidu.com/tikupc/singledetail/fdfbb94ae45c3b3567ec8b91', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991571804717058', 'https://tiku.baidu.com/tikupc/singledetail/193e0066f5335a8102d22014', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991571787939841', 'https://tiku.baidu.com/tikupc/singledetail/f45ffe4ffe4733687e21aa45', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991571829882883', 'https://tiku.baidu.com/tikupc/singledetail/41c283d049649b6648d74742', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991571842465794', 'https://tiku.baidu.com/tikupc/singledetail/16771ed9ad51f01dc281f114', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991571842465793', 'https://tiku.baidu.com/tikupc/singledetail/791faf6e58fafab069dc0204', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991571829882882', 'https://tiku.baidu.com/tikupc/singledetail/fa22b84ae45c3b3567ec8b48', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991571884408834', 'https://tiku.baidu.com/tikupc/singledetail/6ee52cc58bd63186bcebbc25', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991571876020226', 'https://tiku.baidu.com/tikupc/singledetail/ef87590216fc700abb68fcb8', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991571896991745', 'https://tiku.baidu.com/tikupc/singledetail/cc6f27284b73f242336c5f17', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991571934740482', 'https://tiku.baidu.com/tikupc/singledetail/cf23b107e87101f69e319563', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991571943129089', 'https://tiku.baidu.com/tikupc/singledetail/90d7ba0d4a7302768e993925', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991571976683521', 'https://tiku.baidu.com/tikupc/singledetail/9517b52acfc789eb172dc812', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991572144455681', 'https://tiku.baidu.com/tikupc/singledetail/f924996648d7c1c708a14545', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991572144455682', 'https://tiku.baidu.com/tikupc/singledetail/c3bc657d27284b73f2425090', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991572152844290', 'https://tiku.baidu.com/tikupc/singledetail/1370852458fb770bf78a553b', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991572261896195', 'https://tiku.baidu.com/tikupc/singledetail/66ebd3f34693daef5ef73d44', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991572261896194', 'https://tiku.baidu.com/tikupc/singledetail/133ebed5b9f3f90f76c61b3b', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991572261896196', 'https://tiku.baidu.com/tikupc/singledetail/342302020740be1e650e9a27', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991572270284802', 'https://tiku.baidu.com/tikupc/singledetail/58d7326c1eb91a37f1115c90', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991572270284803', 'https://tiku.baidu.com/tikupc/singledetail/d878f5335a8102d276a22f1b', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991572358365185', 'https://tiku.baidu.com/tikupc/singledetail/b8c684254b35eefdc8d33312', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991572358365186', 'https://tiku.baidu.com/tikupc/singledetail/5f84f08583d049649b665890', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991572358365187', 'https://tiku.baidu.com/tikupc/singledetail/b91f5727a5e9856a56126025', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991572358365188', 'https://tiku.baidu.com/tikupc/singledetail/674fa45177232f60ddcca123', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991572425474050', 'https://tiku.baidu.com/tikupc/singledetail/0ec15bf5f61fb7360b4c6503', '1025991527651278852', '0');
INSERT INTO `crawler_question` VALUES ('1025991572584857603', 'https://tiku.baidu.com/tikupc/singledetail/fb8e82c4bb4cf7ec4afed0b8', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991572584857604', 'https://tiku.baidu.com/tikupc/singledetail/5465ed630b1c59eef8c7b44d', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991572584857602', 'https://tiku.baidu.com/tikupc/singledetail/902eee06eff9aef8941e061c', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991572756824065', 'https://tiku.baidu.com/tikupc/singledetail/191bba1aa8114431b90dd812', '1025991558420692994', '0');
INSERT INTO `crawler_question` VALUES ('1025991572807155713', 'https://tiku.baidu.com/tikupc/singledetail/1dca6294dd88d0d233d46a24', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991572857487362', 'https://tiku.baidu.com/tikupc/singledetail/f3d519e8b8f67c1cfad6b83b', '1025991558420692994', '0');
INSERT INTO `crawler_question` VALUES ('1025991572916207617', 'https://tiku.baidu.com/tikupc/singledetail/588dec3a87c24028915fc30d', '1025991558726877186', '0');
INSERT INTO `crawler_question` VALUES ('1025991572949762050', 'https://tiku.baidu.com/tikupc/singledetail/9a3202768e9951e79b892744', '1025991558420692994', '0');
INSERT INTO `crawler_question` VALUES ('1025991573004288003', 'https://tiku.baidu.com/tikupc/singledetail/b55cc5da50e2524de5187e47', '1025991558420692994', '0');
INSERT INTO `crawler_question` VALUES ('1025991573004288002', 'https://tiku.baidu.com/tikupc/singledetail/90e85022aaea998fcc220e31', '1025991558726877186', '0');
INSERT INTO `crawler_question` VALUES ('1025991573067202562', 'https://tiku.baidu.com/tikupc/singledetail/4fa2680203d8ce2f0066232e', '1025991559041449985', '0');
INSERT INTO `crawler_question` VALUES ('1025991573100756994', 'https://tiku.baidu.com/tikupc/singledetail/53fcb9f3f90f76c661371a2c', '1025991558584270849', '0');
INSERT INTO `crawler_question` VALUES ('1025991573117534214', 'https://tiku.baidu.com/tikupc/singledetail/cd0352d380eb6294dd886c14', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991573117534215', 'https://tiku.baidu.com/tikupc/singledetail/f230fc4ffe4733687e21aa2a', '1025991558584270849', '0');
INSERT INTO `crawler_question` VALUES ('1025991573117534213', 'https://tiku.baidu.com/tikupc/singledetail/22330b4c2e3f5727a5e96200', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991573117534212', 'https://tiku.baidu.com/tikupc/singledetail/286248d7c1c708a1284a4401', '1025991559041449985', '0');
INSERT INTO `crawler_question` VALUES ('1025991573117534210', 'https://tiku.baidu.com/tikupc/singledetail/f63b1711cc7931b765ce1547', '1025991558420692994', '0');
INSERT INTO `crawler_question` VALUES ('1025991573117534211', 'https://tiku.baidu.com/tikupc/singledetail/8467ff00bed5b9f3f90f1c78', '1025991558726877186', '0');
INSERT INTO `crawler_question` VALUES ('1025991573285306369', 'https://tiku.baidu.com/tikupc/singledetail/8430ff00bed5b9f3f90f1c2f', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991573344026627', 'https://tiku.baidu.com/tikupc/singledetail/1c68aef8941ea76e58fa0494', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991573364998145', 'https://tiku.baidu.com/tikupc/singledetail/53a9fd0a79563c1ec5da7117', '1025991558584270849', '0');
INSERT INTO `crawler_question` VALUES ('1025991573364998146', 'https://tiku.baidu.com/tikupc/singledetail/113a0b4e767f5acfa1c7cd29', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991573394358274', 'https://tiku.baidu.com/tikupc/singledetail/e8367d1cfad6195f312ba6c5', '1025991558726877186', '0');
INSERT INTO `crawler_question` VALUES ('1025991573402746881', 'https://tiku.baidu.com/tikupc/singledetail/7cc00975f46527d3240ce029', '1025991559041449985', '0');
INSERT INTO `crawler_question` VALUES ('1025991573402746882', 'https://tiku.baidu.com/tikupc/singledetail/cd56b307e87101f69e319516', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991573432107009', 'https://tiku.baidu.com/tikupc/singledetail/ec85dd3383c4bb4cf7ecd12e', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991573490827265', 'https://tiku.baidu.com/tikupc/singledetail/606a910ef12d2af90242e691', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991573490827267', 'https://tiku.baidu.com/tikupc/singledetail/0416192e453610661ed9f431', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991573532770306', 'https://tiku.baidu.com/tikupc/singledetail/48f13bd4b14e852458fb5726', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991573490827266', 'https://tiku.baidu.com/tikupc/singledetail/c233647d27284b73f242501f', '1025991558584270849', '0');
INSERT INTO `crawler_question` VALUES ('1025991573578907649', 'https://tiku.baidu.com/tikupc/singledetail/b1c14028915f804d2b16c106', '1025991559179862018', '0');
INSERT INTO `crawler_question` VALUES ('1025991573608267778', 'https://tiku.baidu.com/tikupc/singledetail/cd4d55270722192e4536f65f', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991573608267777', 'https://tiku.baidu.com/tikupc/singledetail/d3d28e9951e79b89680226a1', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991573616656385', 'https://tiku.baidu.com/tikupc/singledetail/2f272f60ddccda38376baf01', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991573658599427', 'https://tiku.baidu.com/tikupc/singledetail/f3a919e8b8f67c1cfad6b847', '1025991558584270849', '0');
INSERT INTO `crawler_question` VALUES ('1025991573675376641', 'https://tiku.baidu.com/tikupc/singledetail/fb4e9b6648d7c1c708a1452f', '1025991559179862018', '0');
INSERT INTO `crawler_question` VALUES ('1025991573658599426', 'https://tiku.baidu.com/tikupc/singledetail/c2ef55d380eb6294dd886cf8', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991573700542466', 'https://tiku.baidu.com/tikupc/singledetail/da58534de518964bcf847cbf', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991573700542467', 'https://tiku.baidu.com/tikupc/singledetail/7664ddccda38376baf1fae01', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991573700542468', 'https://tiku.baidu.com/tikupc/singledetail/a7620912a216147917112859', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991573759262721', 'https://tiku.baidu.com/tikupc/singledetail/ad77f81dc281e53a5802ff23', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991573759262722', 'https://tiku.baidu.com/tikupc/singledetail/de66e518964bcf84b9d57b2e', '1025991559179862018', '0');
INSERT INTO `crawler_question` VALUES ('1025991573797011457', 'https://tiku.baidu.com/tikupc/singledetail/a14333687e21af45b307a801', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991573797011458', 'https://tiku.baidu.com/tikupc/singledetail/4fa9680203d8ce2f00662325', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991573788622850', 'https://tiku.baidu.com/tikupc/singledetail/918830126edb6f1aff001fbf', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991573817982978', 'https://tiku.baidu.com/tikupc/singledetail/238a0a4c2e3f5727a5e962b9', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991573880897538', 'https://tiku.baidu.com/tikupc/singledetail/b4bb3f86bceb19e8b8f6ba68', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991573880897537', 'https://tiku.baidu.com/tikupc/singledetail/4e3059eef8c75fbfc77db229', '1025991559179862018', '0');
INSERT INTO `crawler_question` VALUES ('1025991573960589314', 'https://tiku.baidu.com/tikupc/singledetail/24753968011ca300a6c39042', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991574002532354', 'https://tiku.baidu.com/tikupc/singledetail/b446a98271fe910ef12df82b', '1025991559481851906', '0');
INSERT INTO `crawler_question` VALUES ('1025991574052864001', 'https://tiku.baidu.com/tikupc/singledetail/6e19d05abe23482fb4da4cc4', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991574069641218', 'https://tiku.baidu.com/tikupc/singledetail/e20f2af90242a8956bece427', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991574107389953', 'https://tiku.baidu.com/tikupc/singledetail/70c033d4b14e852458fb5717', '1025991559481851906', '0');
INSERT INTO `crawler_question` VALUES ('1025991574136750082', 'https://tiku.baidu.com/tikupc/singledetail/4ac0302b3169a4517723a39a', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991574166110210', 'https://tiku.baidu.com/tikupc/singledetail/810df32d2af90242a895e506', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991574166110211', 'https://tiku.baidu.com/tikupc/singledetail/fcb7770bf78a6529647d5349', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991574191276034', 'https://tiku.baidu.com/tikupc/singledetail/c8d6e53a580216fc700afd52', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991574191276033', 'https://tiku.baidu.com/tikupc/singledetail/ea9372d184254b35eefd3498', '1025991546504675329', '0');
INSERT INTO `crawler_question` VALUES ('1025991574245801985', 'https://tiku.baidu.com/tikupc/singledetail/fcb9dd88d0d233d4b14e6928', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991574245801986', 'https://tiku.baidu.com/tikupc/singledetail/b4d4c4da50e2524de5187ecf', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991574245801987', 'https://tiku.baidu.com/tikupc/singledetail/abd3bb4cf7ec4afe04a1df12', '1025991559481851906', '0');
INSERT INTO `crawler_question` VALUES ('1025991574262579202', 'https://tiku.baidu.com/tikupc/singledetail/7ccdb968a98271fe910ef9c2', '1025991536941662209', '0');
INSERT INTO `crawler_question` VALUES ('1025991574296133634', 'https://tiku.baidu.com/tikupc/singledetail/2bd4ea630b1c59eef8c7b4fc', '1025991546504675329', '0');
INSERT INTO `crawler_question` VALUES ('1025991574296133633', 'https://tiku.baidu.com/tikupc/singledetail/ee6d580216fc700abb68fc52', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991574413574147', 'https://tiku.baidu.com/tikupc/singledetail/d3eafe1fb7360b4c2e3f641a', '1025991546504675329', '0');
INSERT INTO `crawler_question` VALUES ('1025991574413574145', 'https://tiku.baidu.com/tikupc/singledetail/65529f3143323968011c92a1', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991574413574146', 'https://tiku.baidu.com/tikupc/singledetail/f43ccc7931b765ce05081428', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991574413574148', 'https://tiku.baidu.com/tikupc/singledetail/110af46527d3240c8447ef7a', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991574426157057', 'https://tiku.baidu.com/tikupc/singledetail/8e8b89eb172ded630b1cb649', '1025991559481851906', '0');
INSERT INTO `crawler_question` VALUES ('1025991574522626050', 'https://tiku.baidu.com/tikupc/singledetail/7635b90d6c85ec3a87c2c501', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991574531014657', 'https://tiku.baidu.com/tikupc/singledetail/ad750129bd64783e09122bd2', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991574539403265', 'https://tiku.baidu.com/tikupc/singledetail/764eb90d6c85ec3a87c2c57a', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991574539403266', 'https://tiku.baidu.com/tikupc/singledetail/70fc33d4b14e852458fb572b', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991574547791873', 'https://tiku.baidu.com/tikupc/singledetail/bee86bec0975f46527d3e178', '1025991559481851906', '0');
INSERT INTO `crawler_question` VALUES ('1025991574614900739', 'https://tiku.baidu.com/tikupc/singledetail/176ca8956bec0975f465e22b', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991574614900738', 'https://tiku.baidu.com/tikupc/singledetail/f15575232f60ddccda38a001', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991574640066562', 'https://tiku.baidu.com/tikupc/singledetail/41ab83d049649b6648d7472b', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991574640066561', 'https://tiku.baidu.com/tikupc/singledetail/607a590102020740be1e9b5d', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991574719758338', 'https://tiku.baidu.com/tikupc/singledetail/de4ae518964bcf84b9d57b02', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991574900113409', 'https://tiku.baidu.com/tikupc/singledetail/31db777f5acfa1c7aa00cc90', '1025991560048082946', '0');
INSERT INTO `crawler_question` VALUES ('1025991574925279233', 'https://tiku.baidu.com/tikupc/singledetail/62be940590c69ec3d5bb7506', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991574925279234', 'https://tiku.baidu.com/tikupc/singledetail/b9085727a5e9856a56126032', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991574975610882', 'https://tiku.baidu.com/tikupc/singledetail/fb9542323968011ca30091a1', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991575000776706', 'https://tiku.baidu.com/tikupc/singledetail/8fe4a36925c52cc58bd6be9c', '1025991560048082946', '0');
INSERT INTO `crawler_question` VALUES ('1025991575025942529', 'https://tiku.baidu.com/tikupc/singledetail/1861c67da26925c52cc5bfdb', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991575063691265', 'https://tiku.baidu.com/tikupc/singledetail/caa5a7c30c22590102029da0', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991575105634305', 'https://tiku.baidu.com/tikupc/singledetail/a463c8aedd3383c4bb4cd204', '1025991560048082946', '0');
INSERT INTO `crawler_question` VALUES ('1025991575105634306', 'https://tiku.baidu.com/tikupc/singledetail/98b31fb91a37f111f1855bda', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991575151771649', 'https://tiku.baidu.com/tikupc/singledetail/360329ea81c758f5f61f67d3', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991575206297602', 'https://tiku.baidu.com/tikupc/singledetail/4c3d6fec102de2bd9605880d', '1025991560048082946', '0');
INSERT INTO `crawler_question` VALUES ('1025991575214686209', 'https://tiku.baidu.com/tikupc/singledetail/b7e8f011f18583d0496459da', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991575214686210', 'https://tiku.baidu.com/tikupc/singledetail/baa3ff11f18583d049645991', '1025991514921566211', '0');
INSERT INTO `crawler_question` VALUES ('1025991575223074817', 'https://tiku.baidu.com/tikupc/singledetail/cbee172ded630b1c59eeb500', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991575277600770', 'https://tiku.baidu.com/tikupc/singledetail/42a1d0d233d4b14e8524682c', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991575294377985', 'https://tiku.baidu.com/tikupc/singledetail/f267b04ae45c3b3567ec8b0d', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991575302766593', 'https://tiku.baidu.com/tikupc/singledetail/38701e8884868762caaed50c', '1025991560048082946', '0');
INSERT INTO `crawler_question` VALUES ('1025991575311155203', 'https://tiku.baidu.com/tikupc/singledetail/24183968011ca300a6c3902f', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991575311155201', 'https://tiku.baidu.com/tikupc/singledetail/7ee70b75f46527d3240ce00e', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991575327932417', 'https://tiku.baidu.com/tikupc/singledetail/221a0b4c2e3f5727a5e96229', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991575378264066', 'https://tiku.baidu.com/tikupc/singledetail/1def6294dd88d0d233d46a01', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991575378264067', 'https://tiku.baidu.com/tikupc/singledetail/cb5b869951e79b8968022628', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991575424401411', 'https://tiku.baidu.com/tikupc/singledetail/f83443323968011ca3009100', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991575424401410', 'https://tiku.baidu.com/tikupc/singledetail/f729cc1755270722192ef729', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991575483121666', 'https://tiku.baidu.com/tikupc/singledetail/6835964bcf84b9d528ea7a28', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991575483121667', 'https://tiku.baidu.com/tikupc/singledetail/ece896c3d5bbfd0a7956732b', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991575541841922', 'https://tiku.baidu.com/tikupc/singledetail/51a66529647d27284b735129', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991575541841923', 'https://tiku.baidu.com/tikupc/singledetail/8308f12d2af90242a895e503', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991575592173570', 'https://tiku.baidu.com/tikupc/singledetail/4083b9d528ea81c758f57802', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991575592173571', 'https://tiku.baidu.com/tikupc/singledetail/1da3a8116c175f0e7cd1372b', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991575650893825', 'https://tiku.baidu.com/tikupc/singledetail/cc5e0d225901020207409c98', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991575751557121', 'https://tiku.baidu.com/tikupc/singledetail/8e52a26925c52cc58bd6be2a', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991575751557124', 'https://tiku.baidu.com/tikupc/singledetail/8021ccbff121dd36a32d8200', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991575751557122', 'https://tiku.baidu.com/tikupc/singledetail/a9550712a21614791711286e', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991575751557123', 'https://tiku.baidu.com/tikupc/singledetail/57f4f90f76c66137ee061902', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991575910940673', 'https://tiku.baidu.com/tikupc/singledetail/ed5d27d3240c844769eaee3d', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991575973855233', 'https://tiku.baidu.com/tikupc/singledetail/150c90c69ec3d5bbfd0a740c', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991576045158401', 'https://tiku.baidu.com/tikupc/singledetail/fb0fc0c708a1284ac85043dd', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991576078712833', 'https://tiku.baidu.com/tikupc/singledetail/d221f78a6529647d2728522f', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991576112267267', 'https://tiku.baidu.com/tikupc/singledetail/a972804d2b160b4e767fcf28', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991576112267266', 'https://tiku.baidu.com/tikupc/singledetail/d8246edb6f1aff00bed51e33', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991576259067905', 'https://tiku.baidu.com/tikupc/singledetail/fcfdc1c708a1284ac850432f', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991576145821698', 'https://tiku.baidu.com/tikupc/singledetail/1f5b561252d380eb62946d34', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991576145821697', 'https://tiku.baidu.com/tikupc/singledetail/21632d60ddccda38376baf45', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991576292622338', 'https://tiku.baidu.com/tikupc/singledetail/5ace941ea76e58fafab00333', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991576292622339', 'https://tiku.baidu.com/tikupc/singledetail/b46ea98271fe910ef12df803', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991576292622337', 'https://tiku.baidu.com/tikupc/singledetail/f422cc7931b765ce05081436', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991576292622340', 'https://tiku.baidu.com/tikupc/singledetail/b8835627a5e9856a561260b9', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991576338759682', 'https://tiku.baidu.com/tikupc/singledetail/287731b765ce05087632130b', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991576401674242', 'https://tiku.baidu.com/tikupc/singledetail/e207763231126edb6f1a100a', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991576393285633', 'https://tiku.baidu.com/tikupc/singledetail/fcce5a1b6bd97f192279e9c2', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991576401674243', 'https://tiku.baidu.com/tikupc/singledetail/74c4e009581b6bd97f19ea2b', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991576414257155', 'https://tiku.baidu.com/tikupc/singledetail/6d6bbe23482fb4daa58d4b34', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991576414257157', 'https://tiku.baidu.com/tikupc/singledetail/d86bf605cc17552707220891', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991576414257154', 'https://tiku.baidu.com/tikupc/singledetail/17b2c77da26925c52cc5bf08', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991576472977409', 'https://tiku.baidu.com/tikupc/singledetail/19180066f5335a8102d22032', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991576498143234', 'https://tiku.baidu.com/tikupc/singledetail/532d9b8fcc22bcd126ff0cc2', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991576519114754', 'https://tiku.baidu.com/tikupc/singledetail/1848cf84b9d528ea81c77906', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991576552669186', 'https://tiku.baidu.com/tikupc/singledetail/9e1831126edb6f1aff001f2f', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991576544280577', 'https://tiku.baidu.com/tikupc/singledetail/5e372279168884868762d62b', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991576603000834', 'https://tiku.baidu.com/tikupc/singledetail/dbd6524de518964bcf847c31', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991576603000836', 'https://tiku.baidu.com/tikupc/singledetail/dbe8524de518964bcf847c0f', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991576636555266', 'https://tiku.baidu.com/tikupc/singledetail/f6a17f1cfad6195f312ba652', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991576603000835', 'https://tiku.baidu.com/tikupc/singledetail/60fd8bd63186bceb19e8bb3d', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991576653332481', 'https://tiku.baidu.com/tikupc/singledetail/c92aa6c30c22590102029d2f', '1025991561541255169', '0');
INSERT INTO `crawler_question` VALUES ('1025991576653332483', 'https://tiku.baidu.com/tikupc/singledetail/8e2b4b73f242336c1eb95e06', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991576699469825', 'https://tiku.baidu.com/tikupc/singledetail/5ad2941ea76e58fafab0032f', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991576707858433', 'https://tiku.baidu.com/tikupc/singledetail/3126bcd126fff705cc170a01', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991576707858434', 'https://tiku.baidu.com/tikupc/singledetail/1f5e561252d380eb62946d31', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991576707858435', 'https://tiku.baidu.com/tikupc/singledetail/1344852458fb770bf78a550f', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991576774967299', 'https://tiku.baidu.com/tikupc/singledetail/311bbcd126fff705cc170a3c', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991576774967298', 'https://tiku.baidu.com/tikupc/singledetail/634e783e0912a2161479292f', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991576774967297', 'https://tiku.baidu.com/tikupc/singledetail/f62bb4daa58da0116c174901', '1025991561541255169', '0');
INSERT INTO `crawler_question` VALUES ('1025991576783355906', 'https://tiku.baidu.com/tikupc/singledetail/e2012af90242a8956bece429', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991576821104642', 'https://tiku.baidu.com/tikupc/singledetail/1bf9700abb68a98271fefa00', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991576867241985', 'https://tiku.baidu.com/tikupc/singledetail/b99871fe910ef12d2af9e71f', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991576875630594', 'https://tiku.baidu.com/tikupc/singledetail/1befd5bbfd0a79563c1e7229', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991576875630593', 'https://tiku.baidu.com/tikupc/singledetail/f3ed19e8b8f67c1cfad6b803', '1025991561541255169', '0');
INSERT INTO `crawler_question` VALUES ('1025991576934350849', 'https://tiku.baidu.com/tikupc/singledetail/60fb910ef12d2af90242e600', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991576934350850', 'https://tiku.baidu.com/tikupc/singledetail/d58fce2f0066f5335a812152', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991576934350851', 'https://tiku.baidu.com/tikupc/singledetail/53617e21af45b307e871970c', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991576993071107', 'https://tiku.baidu.com/tikupc/singledetail/813e376baf1ffc4ffe47ac03', '1025991561541255169', '0');
INSERT INTO `crawler_question` VALUES ('1025991576993071105', 'https://tiku.baidu.com/tikupc/singledetail/fb619b6648d7c1c708a14500', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991577030819842', 'https://tiku.baidu.com/tikupc/singledetail/d863f5335a8102d276a22f00', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991577030819843', 'https://tiku.baidu.com/tikupc/singledetail/f8a2c381e53a580216fcfeba', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991577055985666', 'https://tiku.baidu.com/tikupc/singledetail/ec9add3383c4bb4cf7ecd131', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991577055985665', 'https://tiku.baidu.com/tikupc/singledetail/48955ffafab069dc502201fe', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991577127288835', 'https://tiku.baidu.com/tikupc/singledetail/bd026aec0975f46527d3e192', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991577127288834', 'https://tiku.baidu.com/tikupc/singledetail/11130b4e767f5acfa1c7cd00', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991577127288836', 'https://tiku.baidu.com/tikupc/singledetail/affffab069dc5022aaea0000', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991577127288837', 'https://tiku.baidu.com/tikupc/singledetail/5883326c1eb91a37f1115cc4', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991577181814787', 'https://tiku.baidu.com/tikupc/singledetail/42d326fff705cc1755270907', '1025991561901965314', '0');
INSERT INTO `crawler_question` VALUES ('1025991577261506561', 'https://tiku.baidu.com/tikupc/singledetail/60c6910ef12d2af90242e63d', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991577261506564', 'https://tiku.baidu.com/tikupc/singledetail/6ac3bf23482fb4daa58d4b9c', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991577261506562', 'https://tiku.baidu.com/tikupc/singledetail/60c38bd63186bceb19e8bb03', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991577261506563', 'https://tiku.baidu.com/tikupc/singledetail/d1ddff05cc17552707220827', '1025991530436296706', '0');
INSERT INTO `crawler_question` VALUES ('1025991577311838210', 'https://tiku.baidu.com/tikupc/singledetail/e222763231126edb6f1a102f', '1025991561901965314', '0');
INSERT INTO `crawler_question` VALUES ('1025991577324421123', 'https://tiku.baidu.com/tikupc/singledetail/16345ff7ba0d4a7302763ade', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991577370558467', 'https://tiku.baidu.com/tikupc/singledetail/2e0dfad6195f312b3169a514', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991577370558466', 'https://tiku.baidu.com/tikupc/singledetail/5e3ff18583d049649b66582b', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991577378947073', 'https://tiku.baidu.com/tikupc/singledetail/3f26844769eae009581bec2f', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991577378947074', 'https://tiku.baidu.com/tikupc/singledetail/aef90a1c59eef8c75fbfb39f', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991577429278722', 'https://tiku.baidu.com/tikupc/singledetail/82cc9b89680203d8ce2f242e', '1025991561901965314', '0');
INSERT INTO `crawler_question` VALUES ('1025991577429278721', 'https://tiku.baidu.com/tikupc/singledetail/7c09b968a98271fe910ef906', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991577467027458', 'https://tiku.baidu.com/tikupc/singledetail/7719915f804d2b160b4ec034', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991577467027459', 'https://tiku.baidu.com/tikupc/singledetail/8a30a8114431b90d6c85c72f', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991577467027460', 'https://tiku.baidu.com/tikupc/singledetail/3ec00242a8956bec0975e33c', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991577487998978', 'https://tiku.baidu.com/tikupc/singledetail/ad8c5e0e7cd184254b35359e', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991577529942018', 'https://tiku.baidu.com/tikupc/singledetail/1141aa956bec0975f465e206', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991577525747713', 'https://tiku.baidu.com/tikupc/singledetail/64da9e3143323968011c9229', '1025991561901965314', '0');
INSERT INTO `crawler_question` VALUES ('1025991577555107841', 'https://tiku.baidu.com/tikupc/singledetail/6c360740be1e650e52ea9931', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991577571885057', 'https://tiku.baidu.com/tikupc/singledetail/443367ec102de2bd96058803', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991577613828098', 'https://tiku.baidu.com/tikupc/singledetail/5144011ca300a6c30c229f29', '1025991561901965314', '0');
INSERT INTO `crawler_question` VALUES ('1025991577878069249', 'https://tiku.baidu.com/tikupc/singledetail/1853112de2bd960590c677ba', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991577936789506', 'https://tiku.baidu.com/tikupc/singledetail/7738915f804d2b160b4ec015', '1025991548618604545', '0');
INSERT INTO `crawler_question` VALUES ('1025991577987121154', 'https://tiku.baidu.com/tikupc/singledetail/0ab2a517866fb84ae45c8dc2', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991578003898370', 'https://tiku.baidu.com/tikupc/singledetail/e6b690c3d5bbfd0a79567375', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991578020675587', 'https://tiku.baidu.com/tikupc/singledetail/411d4b35eefdc8d376ee323d', '1025991548618604545', '0');
INSERT INTO `crawler_question` VALUES ('1025991578054230018', 'https://tiku.baidu.com/tikupc/singledetail/9d727fd5360cba1aa811da06', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991578054230019', 'https://tiku.baidu.com/tikupc/singledetail/163a5ff7ba0d4a7302763ad0', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991578112950274', 'https://tiku.baidu.com/tikupc/singledetail/016bac17866fb84ae45c8d1b', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991578129727490', 'https://tiku.baidu.com/tikupc/singledetail/140d52ea551810a6f5248606', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991578142310402', 'https://tiku.baidu.com/tikupc/singledetail/ba80f121dd36a32d7375813a', '1025991548618604545', '0');
INSERT INTO `crawler_question` VALUES ('1025991578196836353', 'https://tiku.baidu.com/tikupc/singledetail/6024590102020740be1e9b03', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991578196836354', 'https://tiku.baidu.com/tikupc/singledetail/9c3aab00b52acfc789ebc9f8', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991578196836355', 'https://tiku.baidu.com/tikupc/singledetail/b81a0e29bd64783e09122bbd', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991578234585090', 'https://tiku.baidu.com/tikupc/singledetail/3cea856a561252d380eb6e06', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991578276528129', 'https://tiku.baidu.com/tikupc/singledetail/5063fc0a79563c1ec5da71dd', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991578284916739', 'https://tiku.baidu.com/tikupc/singledetail/ed6d134bcf84b9d528ea7a70', '1025991494872793089', '0');
INSERT INTO `crawler_question` VALUES ('1025991578284916738', 'https://tiku.baidu.com/tikupc/singledetail/150390c69ec3d5bbfd0a7403', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991578343636994', 'https://tiku.baidu.com/tikupc/singledetail/5880ec3a87c24028915fc300', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991578364608514', 'https://tiku.baidu.com/tikupc/singledetail/a04efc4733687e21af45a904', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991578381385730', 'https://tiku.baidu.com/tikupc/singledetail/163976c66137ee06eff91833', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991578414940161', 'https://tiku.baidu.com/tikupc/singledetail/ca34f71fb7360b4c2e3f64c4', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991578431717377', 'https://tiku.baidu.com/tikupc/singledetail/5428ed630b1c59eef8c7b400', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991578431717378', 'https://tiku.baidu.com/tikupc/singledetail/4f8158eef8c75fbfc77db298', '1025991548903817219', '0');
INSERT INTO `crawler_question` VALUES ('1025991578431717380', 'https://tiku.baidu.com/tikupc/singledetail/463512661ed9ad51f01df206', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991578482049026', 'https://tiku.baidu.com/tikupc/singledetail/179fc77da26925c52cc5bf25', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991578490437633', 'https://tiku.baidu.com/tikupc/singledetail/e14bf242336c1eb91a375d3d', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991578498826241', 'https://tiku.baidu.com/tikupc/singledetail/6719d5d8d15abe23482f4d9c', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991578544963585', 'https://tiku.baidu.com/tikupc/singledetail/0aa9a517866fb84ae45c8dd9', '1025991548903817219', '0');
INSERT INTO `crawler_question` VALUES ('1025991578553352195', 'https://tiku.baidu.com/tikupc/singledetail/92f9b14e852458fb770b5628', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991578553352194', 'https://tiku.baidu.com/tikupc/singledetail/c835162ded630b1c59eeb5db', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991578565935106', 'https://tiku.baidu.com/tikupc/singledetail/cd02b307e87101f69e319542', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991578620461057', 'https://tiku.baidu.com/tikupc/singledetail/40cfb9d528ea81c758f5784e', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991578645626881', 'https://tiku.baidu.com/tikupc/singledetail/916ae2bd960590c69ec37642', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991578645626882', 'https://tiku.baidu.com/tikupc/singledetail/4b5c332b3169a4517723a306', '1025991548903817219', '0');
INSERT INTO `crawler_question` VALUES ('1025991578712735750', 'https://tiku.baidu.com/tikupc/singledetail/61617a3e0912a21614792900', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991578712735747', 'https://tiku.baidu.com/tikupc/singledetail/9c497cd184254b35eefd3442', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991578712735749', 'https://tiku.baidu.com/tikupc/singledetail/aa20aaea998fcc22bcd10d07', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991578712735745', 'https://tiku.baidu.com/tikupc/singledetail/179ac77da26925c52cc5bf20', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991578712735751', 'https://tiku.baidu.com/tikupc/singledetail/262a10a6f524ccbff1218437', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991578712735748', 'https://tiku.baidu.com/tikupc/singledetail/15b91fd9ad51f01dc281f1da', '1025991548903817219', '0');
INSERT INTO `crawler_question` VALUES ('1025991578712735752', 'https://tiku.baidu.com/tikupc/singledetail/a9e9195f312b3169a451a43a', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991578712735754', 'https://tiku.baidu.com/tikupc/singledetail/1bdfaf51f01dc281e53af003', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991578712735753', 'https://tiku.baidu.com/tikupc/singledetail/51ca998fcc22bcd126ff0c25', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991578712735755', 'https://tiku.baidu.com/tikupc/singledetail/5886ec3a87c24028915fc306', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526274', 'https://tiku.baidu.com/tikupc/singledetail/fc9ac1c708a1284ac8504348', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526275', 'https://tiku.baidu.com/tikupc/singledetail/0407e7f9aef8941ea76e0504', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526276', 'https://tiku.baidu.com/tikupc/singledetail/6233b7360b4c2e3f57276329', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526277', 'https://tiku.baidu.com/tikupc/singledetail/20d5551810a6f524ccbf853a', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526278', 'https://tiku.baidu.com/tikupc/singledetail/90f1ba0d4a7302768e993903', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526279', 'https://tiku.baidu.com/tikupc/singledetail/27fc11a6f524ccbff12184e1', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526280', 'https://tiku.baidu.com/tikupc/singledetail/8c7201f69e31433239689306', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526282', 'https://tiku.baidu.com/tikupc/singledetail/266d10a6f524ccbff1218470', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526284', 'https://tiku.baidu.com/tikupc/singledetail/fca2770bf78a6529647d535c', '1025991539923812354', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526285', 'https://tiku.baidu.com/tikupc/singledetail/914ba400b52acfc789ebc989', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526286', 'https://tiku.baidu.com/tikupc/singledetail/4081b9d528ea81c758f57800', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526287', 'https://tiku.baidu.com/tikupc/singledetail/61256c175f0e7cd184253631', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526288', 'https://tiku.baidu.com/tikupc/singledetail/6804a300a6c30c2259019e1d', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526289', 'https://tiku.baidu.com/tikupc/singledetail/8a7c03f69e31433239689308', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526283', 'https://tiku.baidu.com/tikupc/singledetail/6762a45177232f60ddcca10e', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526293', 'https://tiku.baidu.com/tikupc/singledetail/f56fda88d0d233d4b14e69fe', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526291', 'https://tiku.baidu.com/tikupc/singledetail/28dbb0717fd5360cba1adb7f', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526292', 'https://tiku.baidu.com/tikupc/singledetail/632b970590c69ec3d5bb7593', '1025991539923812354', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526290', 'https://tiku.baidu.com/tikupc/singledetail/6d70be23482fb4daa58d4b2f', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526295', 'https://tiku.baidu.com/tikupc/singledetail/3055767f5acfa1c7aa00cc1e', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526296', 'https://tiku.baidu.com/tikupc/singledetail/dbf2524de518964bcf847c15', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526297', 'https://tiku.baidu.com/tikupc/singledetail/e924a21614791711cc791733', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526294', 'https://tiku.baidu.com/tikupc/singledetail/682e964bcf84b9d528ea7a33', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991579161526298', 'https://tiku.baidu.com/tikupc/singledetail/f1d2741cfad6195f312ba621', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991579576762372', 'https://tiku.baidu.com/tikupc/singledetail/d97987c24028915f804dc246', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991579576762371', 'https://tiku.baidu.com/tikupc/singledetail/4ff650e2524de518964b7d29', '1025991563634212868', '0');
INSERT INTO `crawler_question` VALUES ('1025991579576762373', 'https://tiku.baidu.com/tikupc/singledetail/df2f866fb84ae45c3b358c3d', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991579576762374', 'https://tiku.baidu.com/tikupc/singledetail/64ce9e3143323968011c923d', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991579576762377', 'https://tiku.baidu.com/tikupc/singledetail/86816137ee06eff9aef80742', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991579576762375', 'https://tiku.baidu.com/tikupc/singledetail/188af36527d3240c8447effa', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991579706785795', 'https://tiku.baidu.com/tikupc/singledetail/58a4ec3a87c24028915fc324', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991579706785794', 'https://tiku.baidu.com/tikupc/singledetail/da43534de518964bcf847ca4', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991579576762370', 'https://tiku.baidu.com/tikupc/singledetail/fcbe770bf78a6529647d5340', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991579799060481', 'https://tiku.baidu.com/tikupc/singledetail/f700cc1755270722192ef700', '1025991563634212868', '0');
INSERT INTO `crawler_question` VALUES ('1025991579866169346', 'https://tiku.baidu.com/tikupc/singledetail/674dd5d8d15abe23482f4dc8', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991579866169347', 'https://tiku.baidu.com/tikupc/singledetail/809002d276a20029bd642d14', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991579866169349', 'https://tiku.baidu.com/tikupc/singledetail/433714791711cc7931b71624', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991579866169348', 'https://tiku.baidu.com/tikupc/singledetail/5abf941ea76e58fafab00342', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991579937472515', 'https://tiku.baidu.com/tikupc/singledetail/6038960590c69ec3d5bb7580', '1025991563634212868', '0');
INSERT INTO `crawler_question` VALUES ('1025991580008775682', 'https://tiku.baidu.com/tikupc/singledetail/4bf37f19227916888486d72f', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991580054913025', 'https://tiku.baidu.com/tikupc/singledetail/8a476c85ec3a87c24028c44f', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991580054913026', 'https://tiku.baidu.com/tikupc/singledetail/fa1283c4bb4cf7ec4afed024', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991580054913027', 'https://tiku.baidu.com/tikupc/singledetail/3df1240c844769eae009ed27', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991580096856067', 'https://tiku.baidu.com/tikupc/singledetail/86c46137ee06eff9aef80707', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991580096856066', 'https://tiku.baidu.com/tikupc/singledetail/4fde58eef8c75fbfc77db2c7', '1025991563634212868', '0');
INSERT INTO `crawler_question` VALUES ('1025991580260433921', 'https://tiku.baidu.com/tikupc/singledetail/65c5cc22bcd126fff7050b4f', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991580260433922', 'https://tiku.baidu.com/tikupc/singledetail/433214791711cc7931b71621', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991580306571265', 'https://tiku.baidu.com/tikupc/singledetail/e9d47c1cfad6195f312ba627', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991580306571267', 'https://tiku.baidu.com/tikupc/singledetail/cbf0f61fb7360b4c2e3f6400', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991580306571266', 'https://tiku.baidu.com/tikupc/singledetail/b979f021dd36a32d737581c3', '1025991563634212868', '0');
INSERT INTO `crawler_question` VALUES ('1025991580361097218', 'https://tiku.baidu.com/tikupc/singledetail/abe0bb4cf7ec4afe04a1df21', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991580361097219', 'https://tiku.baidu.com/tikupc/singledetail/52fd59fafab069dc50220196', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991580419817473', 'https://tiku.baidu.com/tikupc/singledetail/64b0d4d8d15abe23482f4d35', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991580419817474', 'https://tiku.baidu.com/tikupc/singledetail/ce57650e52ea551810a6874c', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991580444983298', 'https://tiku.baidu.com/tikupc/singledetail/b78bf011f18583d0496459b9', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991580537257986', 'https://tiku.baidu.com/tikupc/singledetail/5afa941ea76e58fafab00307', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991580537257988', 'https://tiku.baidu.com/tikupc/singledetail/fa2641323968011ca3009112', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991580545646593', 'https://tiku.baidu.com/tikupc/singledetail/1eb9f56527d3240c8447efc9', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991580633726977', 'https://tiku.baidu.com/tikupc/singledetail/fcbadd88d0d233d4b14e692b', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991580642115586', 'https://tiku.baidu.com/tikupc/singledetail/1b0e4793daef5ef7ba0d3cf8', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991580642115587', 'https://tiku.baidu.com/tikupc/singledetail/dbe8f505cc17552707220812', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991580738584577', 'https://tiku.baidu.com/tikupc/singledetail/45f766ec102de2bd960588c7', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991580738584578', 'https://tiku.baidu.com/tikupc/singledetail/a224fe4733687e21af45a96e', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991580738584580', 'https://tiku.baidu.com/tikupc/singledetail/779edcccda38376baf1faefb', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991580738584579', 'https://tiku.baidu.com/tikupc/singledetail/b3c61f2ded630b1c59eeb528', '1025991524035788801', '0');
INSERT INTO `crawler_question` VALUES ('1025991580738584583', 'https://tiku.baidu.com/tikupc/singledetail/46df6ad97f1922791688e8c1', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991580738584582', 'https://tiku.baidu.com/tikupc/singledetail/9a5802768e9951e79b89272e', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991580948299778', 'https://tiku.baidu.com/tikupc/singledetail/400210661ed9ad51f01df231', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991580948299779', 'https://tiku.baidu.com/tikupc/singledetail/60ba960590c69ec3d5bb7502', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991580948299780', 'https://tiku.baidu.com/tikupc/singledetail/8fa4a36925c52cc58bd6bedc', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991580948299781', 'https://tiku.baidu.com/tikupc/singledetail/c567e45c3b3567ec102d8a28', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991580948299782', 'https://tiku.baidu.com/tikupc/singledetail/aa14aaea998fcc22bcd10d33', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991580948299783', 'https://tiku.baidu.com/tikupc/singledetail/8629dd36a32d7375a417800d', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991581204152321', 'https://tiku.baidu.com/tikupc/singledetail/6d69be23482fb4daa58d4b36', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991581204152322', 'https://tiku.baidu.com/tikupc/singledetail/4c8458cfa1c7aa00b52acbfe', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991581204152323', 'https://tiku.baidu.com/tikupc/singledetail/a96b804d2b160b4e767fcf31', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991581300621314', 'https://tiku.baidu.com/tikupc/singledetail/19ecad51f01dc281e53af030', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991581329981442', 'https://tiku.baidu.com/tikupc/singledetail/b6ccf311f18583d0496459fe', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991581350952962', 'https://tiku.baidu.com/tikupc/singledetail/8abdcec789eb172ded63b792', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991581388701697', 'https://tiku.baidu.com/tikupc/singledetail/516f011ca300a6c30c229f02', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991581388701698', 'https://tiku.baidu.com/tikupc/singledetail/0943a417866fb84ae45c8d33', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991581430644738', 'https://tiku.baidu.com/tikupc/singledetail/0f9e55ea551810a6f5248695', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991581430644739', 'https://tiku.baidu.com/tikupc/singledetail/1b89ce84b9d528ea81c779c7', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991581472587779', 'https://tiku.baidu.com/tikupc/singledetail/5e162279168884868762d60a', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991581489364993', 'https://tiku.baidu.com/tikupc/singledetail/262358fb770bf78a65295402', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991581489364994', 'https://tiku.baidu.com/tikupc/singledetail/0f3677eeaeaad1f346933fe0', '1025991564682788866', '0');
INSERT INTO `crawler_question` VALUES ('1025991581489364995', 'https://tiku.baidu.com/tikupc/singledetail/9f367fd184254b35eefd343d', '1025991540192247810', '0');
INSERT INTO `crawler_question` VALUES ('1025991581489364996', 'https://tiku.baidu.com/tikupc/singledetail/65ed3069a45177232f60a2c3', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991581669720065', 'https://tiku.baidu.com/tikupc/singledetail/90ffba0d4a7302768e99390d', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991581489364997', 'https://tiku.baidu.com/tikupc/singledetail/60702079168884868762d66c', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991581686497282', 'https://tiku.baidu.com/tikupc/singledetail/261658fb770bf78a65295437', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991581694885891', 'https://tiku.baidu.com/tikupc/singledetail/a0a88762caaedd3383c4d32b', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991581694885890', 'https://tiku.baidu.com/tikupc/singledetail/94f0b42acfc789eb172dc8f5', '1025991564682788866', '0');
INSERT INTO `crawler_question` VALUES ('1025991581761994754', 'https://tiku.baidu.com/tikupc/singledetail/d3d8fe1fb7360b4c2e3f6428', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991581766189059', 'https://tiku.baidu.com/tikupc/singledetail/dde14afe04a1b0717fd5dd08', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991581766189058', 'https://tiku.baidu.com/tikupc/singledetail/0478192e453610661ed9f45f', '1025991565009944578', '0');
INSERT INTO `crawler_question` VALUES ('1025991581887823874', 'https://tiku.baidu.com/tikupc/singledetail/afc9fab069dc5022aaea0036', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991581933961217', 'https://tiku.baidu.com/tikupc/singledetail/4aca302b3169a4517723a390', '1025991565009944578', '0');
INSERT INTO `crawler_question` VALUES ('1025991581933961219', 'https://tiku.baidu.com/tikupc/singledetail/c8c582eb6294dd88d0d26b13', '1025991564682788866', '0');
INSERT INTO `crawler_question` VALUES ('1025991581933961218', 'https://tiku.baidu.com/tikupc/singledetail/7f30e709581b6bd97f19eadf', '1025991538002821123', '0');
INSERT INTO `crawler_question` VALUES ('1025991581933961220', 'https://tiku.baidu.com/tikupc/singledetail/cf13a5e9856a561252d36f31', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991581980098562', 'https://tiku.baidu.com/tikupc/singledetail/b90271fe910ef12d2af9e785', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991582001070081', 'https://tiku.baidu.com/tikupc/singledetail/1bf1700abb68a98271fefa08', '1025991564531793924', '0');
INSERT INTO `crawler_question` VALUES ('1025991582034624513', 'https://tiku.baidu.com/tikupc/singledetail/51d9998fcc22bcd126ff0c36', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991582089150465', 'https://tiku.baidu.com/tikupc/singledetail/390a0342a8956bec0975e3f6', '1025991565009944578', '0');
INSERT INTO `crawler_question` VALUES ('1025991582097539074', 'https://tiku.baidu.com/tikupc/singledetail/d219f78a6529647d27285217', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991582097539073', 'https://tiku.baidu.com/tikupc/singledetail/4a065acfa1c7aa00b52acb7c', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991582097539075', 'https://tiku.baidu.com/tikupc/singledetail/22a9571810a6f524ccbf8546', '1025991564682788866', '0');
INSERT INTO `crawler_question` VALUES ('1025991582097539076', 'https://tiku.baidu.com/tikupc/singledetail/746be009581b6bd97f19ea84', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991582131093506', 'https://tiku.baidu.com/tikupc/singledetail/8d15eefdc8d376eeaeaa3125', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991582173036546', 'https://tiku.baidu.com/tikupc/singledetail/6581a0116c175f0e7cd13709', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991582269505538', 'https://tiku.baidu.com/tikupc/singledetail/27bb59fb770bf78a6529549a', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991582269505537', 'https://tiku.baidu.com/tikupc/singledetail/5451ed630b1c59eef8c7b479', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991582269505539', 'https://tiku.baidu.com/tikupc/singledetail/dd25bd64783e0912a2162a09', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991582282088450', 'https://tiku.baidu.com/tikupc/singledetail/c0fc667d27284b73f24250d0', '1025991565009944578', '0');
INSERT INTO `crawler_question` VALUES ('1025991582282088449', 'https://tiku.baidu.com/tikupc/singledetail/309ebdd126fff705cc170ab9', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991582370168834', 'https://tiku.baidu.com/tikupc/singledetail/4a2a5acfa1c7aa00b52acb50', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991582370168833', 'https://tiku.baidu.com/tikupc/singledetail/1cbc571252d380eb62946dd3', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991582382751745', 'https://tiku.baidu.com/tikupc/singledetail/e752a351f01dc281e53af089', '1025991565009944578', '0');
INSERT INTO `crawler_question` VALUES ('1025991582382751746', 'https://tiku.baidu.com/tikupc/singledetail/d1a0640e52ea551810a687bb', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991582462443522', 'https://tiku.baidu.com/tikupc/singledetail/520114fc700abb68a982fb06', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991582487609346', 'https://tiku.baidu.com/tikupc/singledetail/264d10a6f524ccbff1218450', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991582487609347', 'https://tiku.baidu.com/tikupc/singledetail/b52ac5da50e2524de5187e31', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991582487609349', 'https://tiku.baidu.com/tikupc/singledetail/740cbb0d6c85ec3a87c2c538', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991582533746690', 'https://tiku.baidu.com/tikupc/singledetail/69b9a200a6c30c2259019ea0', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991582554718210', 'https://tiku.baidu.com/tikupc/singledetail/94ebb42acfc789eb172dc8ee', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991582588272642', 'https://tiku.baidu.com/tikupc/singledetail/ca85e73a580216fc700afd01', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991582621827075', 'https://tiku.baidu.com/tikupc/singledetail/df42866fb84ae45c3b358c50', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991582621827074', 'https://tiku.baidu.com/tikupc/singledetail/6f20995f804d2b160b4ec00d', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991582621827076', 'https://tiku.baidu.com/tikupc/singledetail/649cd1f34693daef5ef73d33', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991582672158721', 'https://tiku.baidu.com/tikupc/singledetail/d43c7175a417866fb84a8e14', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991582672158723', 'https://tiku.baidu.com/tikupc/singledetail/69a46d29647d27284b73512b', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991582672158722', 'https://tiku.baidu.com/tikupc/singledetail/b66cab8271fe910ef12df801', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991582756044801', 'https://tiku.baidu.com/tikupc/singledetail/7a1a79563c1ec5da50e27015', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991582772822018', 'https://tiku.baidu.com/tikupc/singledetail/41af83d049649b6648d7472f', '1025991565542621188', '0');
INSERT INTO `crawler_question` VALUES ('1025991582865096707', 'https://tiku.baidu.com/tikupc/singledetail/15711e2de2bd960590c67798', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991582865096706', 'https://tiku.baidu.com/tikupc/singledetail/4fd450e2524de518964b7d0b', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991582886068225', 'https://tiku.baidu.com/tikupc/singledetail/f15a75232f60ddccda38a00e', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991582886068226', 'https://tiku.baidu.com/tikupc/singledetail/1854c67da26925c52cc5bfee', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991582969954305', 'https://tiku.baidu.com/tikupc/singledetail/cde00c225901020207409c26', '1025991565542621188', '0');
INSERT INTO `crawler_question` VALUES ('1025991582969954306', 'https://tiku.baidu.com/tikupc/singledetail/47f025fff705cc1755270924', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991582969954307', 'https://tiku.baidu.com/tikupc/singledetail/64a4d1f34693daef5ef73d0b', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991582969954309', 'https://tiku.baidu.com/tikupc/singledetail/21282d60ddccda38376baf0e', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991583079006210', 'https://tiku.baidu.com/tikupc/singledetail/cd67ec5c3b3567ec102d8a28', '1025991565542621188', '0');
INSERT INTO `crawler_question` VALUES ('1025991583120949249', 'https://tiku.baidu.com/tikupc/singledetail/a17133687e21af45b307a833', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991583179669506', 'https://tiku.baidu.com/tikupc/singledetail/73d07719227916888486d70c', '1025991565542621188', '0');
INSERT INTO `crawler_question` VALUES ('1025991583230001153', 'https://tiku.baidu.com/tikupc/singledetail/a240fe4733687e21af45a90a', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991583267749889', 'https://tiku.baidu.com/tikupc/singledetail/14ec9ec3d5bbfd0a7956732f', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991583267749890', 'https://tiku.baidu.com/tikupc/singledetail/4c1b6fec102de2bd9605882b', '1025991565542621188', '0');
INSERT INTO `crawler_question` VALUES ('1025991583334858754', 'https://tiku.baidu.com/tikupc/singledetail/343102020740be1e650e9a35', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991583469076482', 'https://tiku.baidu.com/tikupc/singledetail/6837a300a6c30c2259019e2e', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991583477465090', 'https://tiku.baidu.com/tikupc/singledetail/84ca6f1aff00bed5b9f31d14', '1025991552838074370', '0');
INSERT INTO `crawler_question` VALUES ('1025991583557156866', 'https://tiku.baidu.com/tikupc/singledetail/8012ccbff121dd36a32d8233', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991583557156867', 'https://tiku.baidu.com/tikupc/singledetail/6c060740be1e650e52ea9901', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991583670403073', 'https://tiku.baidu.com/tikupc/singledetail/7864dfccda38376baf1fae01', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991583670403074', 'https://tiku.baidu.com/tikupc/singledetail/cc5127284b73f242336c5f29', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991583699763204', 'https://tiku.baidu.com/tikupc/singledetail/e21e2af90242a8956bece436', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991583699763202', 'https://tiku.baidu.com/tikupc/singledetail/e925a21614791711cc791732', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991583699763203', 'https://tiku.baidu.com/tikupc/singledetail/b8fb84254b35eefdc8d3332f', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991583758483459', 'https://tiku.baidu.com/tikupc/singledetail/1a06dc80d4d8d15abe234e01', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991583758483457', 'https://tiku.baidu.com/tikupc/singledetail/ee32580216fc700abb68fc0d', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991583758483458', 'https://tiku.baidu.com/tikupc/singledetail/53d7b9f3f90f76c661371a07', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991583800426498', 'https://tiku.baidu.com/tikupc/singledetail/307a767f5acfa1c7aa00cc31', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991583825592321', 'https://tiku.baidu.com/tikupc/singledetail/70af33d4b14e852458fb5778', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991583825592322', 'https://tiku.baidu.com/tikupc/singledetail/471f6bd97f1922791688e801', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991583825592323', 'https://tiku.baidu.com/tikupc/singledetail/9d5e7fd5360cba1aa811da2a', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991583850758146', 'https://tiku.baidu.com/tikupc/singledetail/0965a417866fb84ae45c8d15', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991583867535361', 'https://tiku.baidu.com/tikupc/singledetail/641cb5360b4c2e3f57276306', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991583867535362', 'https://tiku.baidu.com/tikupc/singledetail/7632b90d6c85ec3a87c2c506', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991583888506882', 'https://tiku.baidu.com/tikupc/singledetail/00de76eeaeaad1f346933f08', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991583922061314', 'https://tiku.baidu.com/tikupc/singledetail/db63524de518964bcf847c84', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991583922061315', 'https://tiku.baidu.com/tikupc/singledetail/8a056c85ec3a87c24028c40d', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991583930449922', 'https://tiku.baidu.com/tikupc/singledetail/70f933d4b14e852458fb572e', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991583938838530', 'https://tiku.baidu.com/tikupc/singledetail/a568f01dc281e53a5802ff3c', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991583980781571', 'https://tiku.baidu.com/tikupc/singledetail/4164b8d528ea81c758f578e5', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991583980781570', 'https://tiku.baidu.com/tikupc/singledetail/29d128ea81c758f5f61f6701', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991584018530305', 'https://tiku.baidu.com/tikupc/singledetail/328c49649b6648d7c1c74659', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991584018530306', 'https://tiku.baidu.com/tikupc/singledetail/7720915f804d2b160b4ec00d', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991584035307521', 'https://tiku.baidu.com/tikupc/singledetail/fcd0770bf78a6529647d532e', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991584064667649', 'https://tiku.baidu.com/tikupc/singledetail/3de9240c844769eae009ed3f', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991584135970818', 'https://tiku.baidu.com/tikupc/singledetail/beb96bec0975f46527d3e129', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991584135970820', 'https://tiku.baidu.com/tikupc/singledetail/a96e0b1c59eef8c75fbfb308', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991584135970817', 'https://tiku.baidu.com/tikupc/singledetail/263f3b68011ca300a6c39008', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991584135970821', 'https://tiku.baidu.com/tikupc/singledetail/b33d1a37f111f18583d05a81', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991584135970822', 'https://tiku.baidu.com/tikupc/singledetail/1309bed5b9f3f90f76c61b0c', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991584232439809', 'https://tiku.baidu.com/tikupc/singledetail/f909c281e53a580216fcfe11', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991584253411330', 'https://tiku.baidu.com/tikupc/singledetail/eaaa60db6f1aff00bed51ebd', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991584215662593', 'https://tiku.baidu.com/tikupc/singledetail/e2282af90242a8956bece400', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991584253411331', 'https://tiku.baidu.com/tikupc/singledetail/51d3360cba1aa8114431d903', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991584303742979', 'https://tiku.baidu.com/tikupc/singledetail/8d6beefdc8d376eeaeaa315b', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991584303742980', 'https://tiku.baidu.com/tikupc/singledetail/5e25f18583d049649b665831', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991584303742978', 'https://tiku.baidu.com/tikupc/singledetail/83ca0508763231126edb1101', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991584362463233', 'https://tiku.baidu.com/tikupc/singledetail/134a852458fb770bf78a5501', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991584362463234', 'https://tiku.baidu.com/tikupc/singledetail/c141e2ec102de2bd96058870', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991584404406273', 'https://tiku.baidu.com/tikupc/singledetail/1897bb1aa8114431b90dd89e', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991584454737922', 'https://tiku.baidu.com/tikupc/singledetail/912be2bd960590c69ec37603', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991584454737923', 'https://tiku.baidu.com/tikupc/singledetail/c902a6c30c22590102029d07', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991584521846785', 'https://tiku.baidu.com/tikupc/singledetail/c39126284b73f242336c5fe9', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991584572178433', 'https://tiku.baidu.com/tikupc/singledetail/4fdc50e2524de518964b7d03', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991584597344257', 'https://tiku.baidu.com/tikupc/singledetail/1d36453610661ed9ad51f31d', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991584597344258', 'https://tiku.baidu.com/tikupc/singledetail/7534b80d6c85ec3a87c2c500', '1025991493702582273', '0');
INSERT INTO `crawler_question` VALUES ('1025991584622510082', 'https://tiku.baidu.com/tikupc/singledetail/27d659fb770bf78a652954f7', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991584656064513', 'https://tiku.baidu.com/tikupc/singledetail/285431b765ce050876321328', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991584689618946', 'https://tiku.baidu.com/tikupc/singledetail/b429a98271fe910ef12df844', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991584706396161', 'https://tiku.baidu.com/tikupc/singledetail/8f3188eb172ded630b1cb6f3', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991584739950593', 'https://tiku.baidu.com/tikupc/singledetail/29fb28ea81c758f5f61f672b', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991584739950594', 'https://tiku.baidu.com/tikupc/singledetail/8431ff00bed5b9f3f90f1c2e', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991584807059458', 'https://tiku.baidu.com/tikupc/singledetail/431214791711cc7931b71601', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991584798670849', 'https://tiku.baidu.com/tikupc/singledetail/e82825c52cc58bd63186bd44', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991584849002498', 'https://tiku.baidu.com/tikupc/singledetail/f3c519e8b8f67c1cfad6b82b', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991584890945538', 'https://tiku.baidu.com/tikupc/singledetail/241e3968011ca300a6c39029', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991584895139842', 'https://tiku.baidu.com/tikupc/singledetail/ed2727d3240c844769eaee47', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991584941277185', 'https://tiku.baidu.com/tikupc/singledetail/cd2455270722192e4536f636', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991584949665793', 'https://tiku.baidu.com/tikupc/singledetail/47366bd97f1922791688e828', '1025991567354560516', '0');
INSERT INTO `crawler_question` VALUES ('1025991584987414530', 'https://tiku.baidu.com/tikupc/singledetail/aa0eaaea998fcc22bcd10d29', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991584995803137', 'https://tiku.baidu.com/tikupc/singledetail/776a915f804d2b160b4ec047', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991585029357570', 'https://tiku.baidu.com/tikupc/singledetail/c934a6c30c22590102029d31', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991585079689218', 'https://tiku.baidu.com/tikupc/singledetail/8362f12d2af90242a895e569', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991585142603778', 'https://tiku.baidu.com/tikupc/singledetail/2f2e2f60ddccda38376baf08', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991585163575298', 'https://tiku.baidu.com/tikupc/singledetail/a243caaedd3383c4bb4cd224', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991585171963905', 'https://tiku.baidu.com/tikupc/singledetail/41bf4b35eefdc8d376ee329f', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991585247461378', 'https://tiku.baidu.com/tikupc/singledetail/aab30029bd64783e09122b14', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991585247461379', 'https://tiku.baidu.com/tikupc/singledetail/bfe6aeaad1f34693daef3e0d', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991585268432898', 'https://tiku.baidu.com/tikupc/singledetail/b420a98271fe910ef12df84d', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991585348124674', 'https://tiku.baidu.com/tikupc/singledetail/ae215f0e7cd184254b353533', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991585348124676', 'https://tiku.baidu.com/tikupc/singledetail/a92b0b1c59eef8c75fbfb34d', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991585348124677', 'https://tiku.baidu.com/tikupc/singledetail/b95f2b160b4e767f5acfce17', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991585444593666', 'https://tiku.baidu.com/tikupc/singledetail/643a3169a45177232f60a214', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991585444593667', 'https://tiku.baidu.com/tikupc/singledetail/621bb7360b4c2e3f57276301', '1025991567685910530', '0');
INSERT INTO `crawler_question` VALUES ('1025991585444593668', 'https://tiku.baidu.com/tikupc/singledetail/5ad8941ea76e58fafab00325', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991585473953793', 'https://tiku.baidu.com/tikupc/singledetail/f16c3c1ec5da50e2524d7f3f', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991585541062658', 'https://tiku.baidu.com/tikupc/singledetail/4d17312b3169a4517723a34d', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991585541062659', 'https://tiku.baidu.com/tikupc/singledetail/9c367cd184254b35eefd343d', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991585541062660', 'https://tiku.baidu.com/tikupc/singledetail/dbe5524de518964bcf847c02', '1025991567685910530', '0');
INSERT INTO `crawler_question` VALUES ('1025991585641725953', 'https://tiku.baidu.com/tikupc/singledetail/645d3169a45177232f60a273', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991585683668994', 'https://tiku.baidu.com/tikupc/singledetail/285231b765ce05087632132e', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991585734000642', 'https://tiku.baidu.com/tikupc/singledetail/c8cee53a580216fc700afd4a', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991585780137986', 'https://tiku.baidu.com/tikupc/singledetail/99e33a3567ec102de2bd89ba', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991585780137987', 'https://tiku.baidu.com/tikupc/singledetail/e916a21614791711cc791701', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991585838858243', 'https://tiku.baidu.com/tikupc/singledetail/b3c64228915f804d2b16c101', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991585838858242', 'https://tiku.baidu.com/tikupc/singledetail/9a143b3567ec102de2bd894d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991585864024065', 'https://tiku.baidu.com/tikupc/singledetail/11470b4e767f5acfa1c7cd54', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991585872412673', 'https://tiku.baidu.com/tikupc/singledetail/8581a56925c52cc58bd6bef9', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991585918550018', 'https://tiku.baidu.com/tikupc/singledetail/32ad49649b6648d7c1c74678', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991585918550017', 'https://tiku.baidu.com/tikupc/singledetail/537b7e21af45b307e8719716', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991585918550019', 'https://tiku.baidu.com/tikupc/singledetail/ed4927d3240c844769eaee29', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991585935327235', 'https://tiku.baidu.com/tikupc/singledetail/be195ebfc77da26925c5b0db', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991585935327234', 'https://tiku.baidu.com/tikupc/singledetail/148e9ec3d5bbfd0a7956734d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991585968881665', 'https://tiku.baidu.com/tikupc/singledetail/ee3f580216fc700abb68fc00', '1025991554108948482', '0');
INSERT INTO `crawler_question` VALUES ('1025991585968881666', 'https://tiku.baidu.com/tikupc/singledetail/dd78bd64783e0912a2162a54', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991586002436097', 'https://tiku.baidu.com/tikupc/singledetail/2ab2822458fb770bf78a55f9', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991586094710786', 'https://tiku.baidu.com/tikupc/singledetail/bf9b5fbfc77da26925c5b059', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991586094710788', 'https://tiku.baidu.com/tikupc/singledetail/f67d1711cc7931b765ce1501', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991586094710789', 'https://tiku.baidu.com/tikupc/singledetail/7f8eac02de80d4d8d15a4fdb', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991586094710790', 'https://tiku.baidu.com/tikupc/singledetail/d227f78a6529647d27285229', '1025991554108948482', '0');
INSERT INTO `crawler_question` VALUES ('1025991586094710787', 'https://tiku.baidu.com/tikupc/singledetail/f11e3c1ec5da50e2524d7f4d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991586124070914', 'https://tiku.baidu.com/tikupc/singledetail/605c590102020740be1e9b7b', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991586124070915', 'https://tiku.baidu.com/tikupc/singledetail/402410661ed9ad51f01df217', '1025991568155672579', '0');
INSERT INTO `crawler_question` VALUES ('1025991586145042434', 'https://tiku.baidu.com/tikupc/singledetail/f62b501b6bd97f192279e927', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991586061156354', 'https://tiku.baidu.com/tikupc/singledetail/8aeedaef5ef7ba0d4a733b78', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991586237317121', 'https://tiku.baidu.com/tikupc/singledetail/5802ec3a87c24028915fc382', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991586237317124', 'https://tiku.baidu.com/tikupc/singledetail/5061fc0a79563c1ec5da71df', '1025991554108948482', '0');
INSERT INTO `crawler_question` VALUES ('1025991586237317123', 'https://tiku.baidu.com/tikupc/singledetail/f3d4fd4ffe4733687e21aace', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991586237317125', 'https://tiku.baidu.com/tikupc/singledetail/b556c5da50e2524de5187e4d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991586237317122', 'https://tiku.baidu.com/tikupc/singledetail/3dff240c844769eae009ed29', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991586350563330', 'https://tiku.baidu.com/tikupc/singledetail/eca326d3240c844769eaeec3', '1025991568155672579', '0');
INSERT INTO `crawler_question` VALUES ('1025991586350563329', 'https://tiku.baidu.com/tikupc/singledetail/bc4ba18271fe910ef12df826', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991586350563331', 'https://tiku.baidu.com/tikupc/singledetail/b1c74028915f804d2b16c100', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991586421866499', 'https://tiku.baidu.com/tikupc/singledetail/9877393567ec102de2bd892e', '1025991554108948482', '0');
INSERT INTO `crawler_question` VALUES ('1025991586421866498', 'https://tiku.baidu.com/tikupc/singledetail/1360852458fb770bf78a552b', '1025991568340221953', '0');
INSERT INTO `crawler_question` VALUES ('1025991586421866497', 'https://tiku.baidu.com/tikupc/singledetail/3dbe240c844769eae009ed68', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991586421866500', 'https://tiku.baidu.com/tikupc/singledetail/330f48649b6648d7c1c746da', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991586413477890', 'https://tiku.baidu.com/tikupc/singledetail/d029e87101f69e314332942b', '1025991567962734595', '0');
INSERT INTO `crawler_question` VALUES ('1025991586493169665', 'https://tiku.baidu.com/tikupc/singledetail/cf06a5e9856a561252d36f24', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991586472198146', 'https://tiku.baidu.com/tikupc/singledetail/d4b365ce0508763231121201', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991586522529794', 'https://tiku.baidu.com/tikupc/singledetail/4f4332d4b14e852458fb5794', '1025991568155672579', '0');
INSERT INTO `crawler_question` VALUES ('1025991586530918403', 'https://tiku.baidu.com/tikupc/singledetail/7d260875f46527d3240ce0cf', '1025991568340221953', '0');
INSERT INTO `crawler_question` VALUES ('1025991586530918402', 'https://tiku.baidu.com/tikupc/singledetail/4e1959eef8c75fbfc77db200', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991586530918404', 'https://tiku.baidu.com/tikupc/singledetail/9019ee06eff9aef8941e062b', '1025991567962734595', '0');
INSERT INTO `crawler_question` VALUES ('1025991586530918405', 'https://tiku.baidu.com/tikupc/singledetail/91b96eeae009581b6bd9ebfb', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991586606415873', 'https://tiku.baidu.com/tikupc/singledetail/346585868762caaedd33d4e8', '1025991568155672579', '0');
INSERT INTO `crawler_question` VALUES ('1025991586614804483', 'https://tiku.baidu.com/tikupc/singledetail/1b01b6d5b9f3f90f76c61b04', '1025991568340221953', '0');
INSERT INTO `crawler_question` VALUES ('1025991586614804482', 'https://tiku.baidu.com/tikupc/singledetail/32fc49649b6648d7c1c74629', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991586631581697', 'https://tiku.baidu.com/tikupc/singledetail/b92f5727a5e9856a56126015', '1025991567962734595', '0');
INSERT INTO `crawler_question` VALUES ('1025991586749022209', 'https://tiku.baidu.com/tikupc/singledetail/c8d2e53a580216fc700afd56', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991586749022210', 'https://tiku.baidu.com/tikupc/singledetail/4bf27f19227916888486d72e', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991586765799427', 'https://tiku.baidu.com/tikupc/singledetail/9254333567ec102de2bd890d', '1025991568340221953', '0');
INSERT INTO `crawler_question` VALUES ('1025991586765799426', 'https://tiku.baidu.com/tikupc/singledetail/b3bc1a37f111f18583d05a00', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991586811936770', 'https://tiku.baidu.com/tikupc/singledetail/181ecf84b9d528ea81c77950', '1025991567962734595', '0');
INSERT INTO `crawler_question` VALUES ('1025991586811936772', 'https://tiku.baidu.com/tikupc/singledetail/3f5f844769eae009581bec56', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991586811936771', 'https://tiku.baidu.com/tikupc/singledetail/613b6c175f0e7cd18425362f', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991586811936773', 'https://tiku.baidu.com/tikupc/singledetail/8a1ea8114431b90d6c85c701', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991586946154498', 'https://tiku.baidu.com/tikupc/singledetail/e2999c6648d7c1c708a145f8', '1025991568340221953', '0');
INSERT INTO `crawler_question` VALUES ('1025991586811936774', 'https://tiku.baidu.com/tikupc/singledetail/140c52ea551810a6f5248607', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991586988097538', 'https://tiku.baidu.com/tikupc/singledetail/41204b35eefdc8d376ee3200', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991586996486145', 'https://tiku.baidu.com/tikupc/singledetail/40afb9d528ea81c758f5782e', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991587042623490', 'https://tiku.baidu.com/tikupc/singledetail/c904a6c30c22590102029d01', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991587042623489', 'https://tiku.baidu.com/tikupc/singledetail/f949c281e53a580216fcfe51', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991587051012097', 'https://tiku.baidu.com/tikupc/singledetail/1171f46527d3240c8447ef01', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991587084566529', 'https://tiku.baidu.com/tikupc/singledetail/a838a02d7375a417866f8f0b', '1025991543019208709', '0');
INSERT INTO `crawler_question` VALUES ('1025991587084566530', 'https://tiku.baidu.com/tikupc/singledetail/3120bcd126fff705cc170a07', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991587101343746', 'https://tiku.baidu.com/tikupc/singledetail/7fabbceb19e8b8f67c1cb928', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991587101343748', 'https://tiku.baidu.com/tikupc/singledetail/a973804d2b160b4e767fcf29', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991587176841217', 'https://tiku.baidu.com/tikupc/singledetail/4a2b5acfa1c7aa00b52acb51', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991587176841218', 'https://tiku.baidu.com/tikupc/singledetail/516a58fafab069dc50220101', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991587176841220', 'https://tiku.baidu.com/tikupc/singledetail/6e67ac1ffc4ffe473368ab09', '1025991543019208709', '0');
INSERT INTO `crawler_question` VALUES ('1025991587176841219', 'https://tiku.baidu.com/tikupc/singledetail/a0858762caaedd3383c4d306', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991587277504514', 'https://tiku.baidu.com/tikupc/singledetail/7639b90d6c85ec3a87c2c50d', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991587315253249', 'https://tiku.baidu.com/tikupc/singledetail/65a4cc22bcd126fff7050b2e', '1025991568860315649', '0');
INSERT INTO `crawler_question` VALUES ('1025991587348807681', 'https://tiku.baidu.com/tikupc/singledetail/f81d43323968011ca3009129', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991587357196291', 'https://tiku.baidu.com/tikupc/singledetail/1790c77da26925c52cc5bf2a', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991587357196292', 'https://tiku.baidu.com/tikupc/singledetail/fa37b84ae45c3b3567ec8b5d', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991587373973505', 'https://tiku.baidu.com/tikupc/singledetail/040e192e453610661ed9f429', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991587373973506', 'https://tiku.baidu.com/tikupc/singledetail/b56ac5da50e2524de5187e71', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991587441082369', 'https://tiku.baidu.com/tikupc/singledetail/4314d1d233d4b14e85246899', '1025991568860315649', '0');
INSERT INTO `crawler_question` VALUES ('1025991587491414017', 'https://tiku.baidu.com/tikupc/singledetail/6832964bcf84b9d528ea7a2f', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991587503996930', 'https://tiku.baidu.com/tikupc/singledetail/8117376baf1ffc4ffe47ac2a', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991587503996931', 'https://tiku.baidu.com/tikupc/singledetail/443067ec102de2bd96058800', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991587503996932', 'https://tiku.baidu.com/tikupc/singledetail/86f36137ee06eff9aef80730', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991587579494402', 'https://tiku.baidu.com/tikupc/singledetail/a14433687e21af45b307a806', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991587579494401', 'https://tiku.baidu.com/tikupc/singledetail/85ad03768e9951e79b8927db', '1025991568860315649', '0');
INSERT INTO `crawler_question` VALUES ('1025991587642408962', 'https://tiku.baidu.com/tikupc/singledetail/8ec489eb172ded630b1cb606', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991587709517826', 'https://tiku.baidu.com/tikupc/singledetail/5e1d2279168884868762d601', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991587709517827', 'https://tiku.baidu.com/tikupc/singledetail/d7decc2f0066f5335a812103', '1025991568860315649', '0');
INSERT INTO `crawler_question` VALUES ('1025991587772432386', 'https://tiku.baidu.com/tikupc/singledetail/443667ec102de2bd96058806', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991587860512772', 'https://tiku.baidu.com/tikupc/singledetail/5632b9f67c1cfad6195fa7df', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991587860512769', 'https://tiku.baidu.com/tikupc/singledetail/9d0d2e3f5727a5e9856a6144', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991587860512771', 'https://tiku.baidu.com/tikupc/singledetail/aadba22d7375a417866f8fe8', '1025991568860315649', '0');
INSERT INTO `crawler_question` VALUES ('1025991587860512770', 'https://tiku.baidu.com/tikupc/singledetail/813c376baf1ffc4ffe47ac01', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991587885678594', 'https://tiku.baidu.com/tikupc/singledetail/1b284793daef5ef7ba0d3cde', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991587910844417', 'https://tiku.baidu.com/tikupc/singledetail/681b964bcf84b9d528ea7a06', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991587961176066', 'https://tiku.baidu.com/tikupc/singledetail/c545e45c3b3567ec102d8a0a', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991587961176067', 'https://tiku.baidu.com/tikupc/singledetail/4a82302b3169a4517723a3d8', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991587961176065', 'https://tiku.baidu.com/tikupc/singledetail/24763968011ca300a6c39041', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991587969564674', 'https://tiku.baidu.com/tikupc/singledetail/cd3952d380eb6294dd886c2e', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991587998924801', 'https://tiku.baidu.com/tikupc/singledetail/240912a6f524ccbff1218414', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991588019896321', 'https://tiku.baidu.com/tikupc/singledetail/5f8581d049649b6648d74705', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991588057645058', 'https://tiku.baidu.com/tikupc/singledetail/344502020740be1e650e9a41', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991588057645057', 'https://tiku.baidu.com/tikupc/singledetail/ae265f0e7cd184254b353534', '1025991569598513153', '0');
INSERT INTO `crawler_question` VALUES ('1025991588066033666', 'https://tiku.baidu.com/tikupc/singledetail/ae24fbb069dc5022aaea00db', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991588066033665', 'https://tiku.baidu.com/tikupc/singledetail/ce0f650e52ea551810a68714', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991588082810881', 'https://tiku.baidu.com/tikupc/singledetail/5406ed630b1c59eef8c7b42e', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991588162502658', 'https://tiku.baidu.com/tikupc/singledetail/7cf20975f46527d3240ce01b', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991588162502657', 'https://tiku.baidu.com/tikupc/singledetail/6b5daf1ffc4ffe473368ab33', '1025991569598513153', '0');
INSERT INTO `crawler_question` VALUES ('1025991588145725441', 'https://tiku.baidu.com/tikupc/singledetail/1807ac51f01dc281e53af0db', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991588162502659', 'https://tiku.baidu.com/tikupc/singledetail/3cd0856a561252d380eb6e3c', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991588187668482', 'https://tiku.baidu.com/tikupc/singledetail/be916bec0975f46527d3e101', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991588254777345', 'https://tiku.baidu.com/tikupc/singledetail/ce9680eb6294dd88d0d26b40', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991588263165953', 'https://tiku.baidu.com/tikupc/singledetail/9d637fd5360cba1aa811da17', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991588263165954', 'https://tiku.baidu.com/tikupc/singledetail/2e9433b765ce0508763213e8', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991588334469122', 'https://tiku.baidu.com/tikupc/singledetail/cd2b52d380eb6294dd886c3c', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991588334469121', 'https://tiku.baidu.com/tikupc/singledetail/b12af4b069dc5022aaea00d5', '1025991555396599811', '0');
INSERT INTO `crawler_question` VALUES ('1025991588355440642', 'https://tiku.baidu.com/tikupc/singledetail/d0b549fe04a1b0717fd5dd5c', '1025991542759161859', '0');
INSERT INTO `crawler_question` VALUES ('1025991588380606466', 'https://tiku.baidu.com/tikupc/singledetail/4c1a58cfa1c7aa00b52acb60', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991588405772290', 'https://tiku.baidu.com/tikupc/singledetail/155390c69ec3d5bbfd0a7453', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991588489658370', 'https://tiku.baidu.com/tikupc/singledetail/16166594dd88d0d233d46af8', '1025991555396599811', '0');
INSERT INTO `crawler_question` VALUES ('1025991588489658371', 'https://tiku.baidu.com/tikupc/singledetail/cfaa0e225901020207409c6c', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991588519018497', 'https://tiku.baidu.com/tikupc/singledetail/f1003c1ec5da50e2524d7f53', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991588615487490', 'https://tiku.baidu.com/tikupc/singledetail/4f8c50e2524de518964b7d53', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991588615487489', 'https://tiku.baidu.com/tikupc/singledetail/302a2fea81c758f5f61f67fa', '1025991555396599811', '0');
INSERT INTO `crawler_question` VALUES ('1025991588632264706', 'https://tiku.baidu.com/tikupc/singledetail/288bb0717fd5360cba1adb2f', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991588686790657', 'https://tiku.baidu.com/tikupc/singledetail/7c930975f46527d3240ce07a', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991588749705218', 'https://tiku.baidu.com/tikupc/singledetail/babcf121dd36a32d73758106', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991588762288129', 'https://tiku.baidu.com/tikupc/singledetail/bb395527a5e9856a56126003', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991588854562817', 'https://tiku.baidu.com/tikupc/singledetail/8d6deefdc8d376eeaeaa315d', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991588862951426', 'https://tiku.baidu.com/tikupc/singledetail/1cd3aef8941ea76e58fa042f', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991588892311554', 'https://tiku.baidu.com/tikupc/singledetail/75d37d19227916888486d70f', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991588900700161', 'https://tiku.baidu.com/tikupc/singledetail/6c290740be1e650e52ea992e', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991588997169154', 'https://tiku.baidu.com/tikupc/singledetail/fceedd88d0d233d4b14e697f', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991589076860929', 'https://tiku.baidu.com/tikupc/singledetail/53feb9f3f90f76c661371a2e', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991589076860930', 'https://tiku.baidu.com/tikupc/singledetail/540616fc700abb68a982fb01', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991589085249538', 'https://tiku.baidu.com/tikupc/singledetail/42f2d0d233d4b14e8524687f', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991589156552705', 'https://tiku.baidu.com/tikupc/singledetail/2f252f60ddccda38376baf03', '1025991569992777730', '0');
INSERT INTO `crawler_question` VALUES ('1025991589198495745', 'https://tiku.baidu.com/tikupc/singledetail/ed5427d3240c844769eaee34', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991589198495746', 'https://tiku.baidu.com/tikupc/singledetail/221d0b4c2e3f5727a5e9622e', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991589198495747', 'https://tiku.baidu.com/tikupc/singledetail/7633ddccda38376baf1fae56', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991589248827393', 'https://tiku.baidu.com/tikupc/singledetail/47316bd97f1922791688e82f', '1025991569858560001', '0');
INSERT INTO `crawler_question` VALUES ('1025991589261410305', 'https://tiku.baidu.com/tikupc/singledetail/140852ea551810a6f5248603', '1025991569992777730', '0');
INSERT INTO `crawler_question` VALUES ('1025991589307547649', 'https://tiku.baidu.com/tikupc/singledetail/8a9f6c85ec3a87c24028c497', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991589315936257', 'https://tiku.baidu.com/tikupc/singledetail/1db86294dd88d0d233d46a56', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991589345296386', 'https://tiku.baidu.com/tikupc/singledetail/428cd0d233d4b14e85246801', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991589374656513', 'https://tiku.baidu.com/tikupc/singledetail/42bad0d233d4b14e85246837', '1025991569858560001', '0');
INSERT INTO `crawler_question` VALUES ('1025991589383045122', 'https://tiku.baidu.com/tikupc/singledetail/9f411eb91a37f111f1855b28', '1025991569992777730', '0');
INSERT INTO `crawler_question` VALUES ('1025991589404016642', 'https://tiku.baidu.com/tikupc/singledetail/17e75ef7ba0d4a7302763a0d', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991589404016641', 'https://tiku.baidu.com/tikupc/singledetail/8a1d6c85ec3a87c24028c415', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991589466931202', 'https://tiku.baidu.com/tikupc/singledetail/60c7910ef12d2af90242e63c', '1025991569858560001', '0');
INSERT INTO `crawler_question` VALUES ('1025991589466931204', 'https://tiku.baidu.com/tikupc/singledetail/8026ccbff121dd36a32d8207', '1025991570433179649', '0');
INSERT INTO `crawler_question` VALUES ('1025991589466931203', 'https://tiku.baidu.com/tikupc/singledetail/028669dc5022aaea998f0f33', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991589466931205', 'https://tiku.baidu.com/tikupc/singledetail/53fbb9f3f90f76c661371a2b', '1025991569992777730', '0');
INSERT INTO `crawler_question` VALUES ('1025991589441765378', 'https://tiku.baidu.com/tikupc/singledetail/c980a6c30c22590102029d85', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991589550817281', 'https://tiku.baidu.com/tikupc/singledetail/f80143323968011ca3009135', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991589567594497', 'https://tiku.baidu.com/tikupc/singledetail/3e24250c844769eae009edf2', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991589613731842', 'https://tiku.baidu.com/tikupc/singledetail/8131376baf1ffc4ffe47ac0c', '1025991569992777730', '0');
INSERT INTO `crawler_question` VALUES ('1025991589613731843', 'https://tiku.baidu.com/tikupc/singledetail/6563a65177232f60ddcca10f', '1025991570433179649', '0');
INSERT INTO `crawler_question` VALUES ('1025991589613731841', 'https://tiku.baidu.com/tikupc/singledetail/d5efce2f0066f5335a812132', '1025991570617729025', '0');
INSERT INTO `crawler_question` VALUES ('1025991589613731844', 'https://tiku.baidu.com/tikupc/singledetail/51fcc0d376eeaeaad1f33004', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991589685035009', 'https://tiku.baidu.com/tikupc/singledetail/f706cc1755270722192ef706', '1025991570827444226', '0');
INSERT INTO `crawler_question` VALUES ('1025991589689229315', 'https://tiku.baidu.com/tikupc/singledetail/6aacbf23482fb4daa58d4bf3', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991589689229314', 'https://tiku.baidu.com/tikupc/singledetail/fcf2770bf78a6529647d530c', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991589768921090', 'https://tiku.baidu.com/tikupc/singledetail/dd1ebd64783e0912a2162a32', '1025991570617729025', '0');
INSERT INTO `crawler_question` VALUES ('1025991589777309697', 'https://tiku.baidu.com/tikupc/singledetail/1f98f66527d3240c8447efe8', '1025991570433179649', '0');
INSERT INTO `crawler_question` VALUES ('1025991589785698306', 'https://tiku.baidu.com/tikupc/singledetail/aa68f64733687e21af45a922', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991589794086913', 'https://tiku.baidu.com/tikupc/singledetail/d84ce718964bcf84b9d57b04', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991589827641345', 'https://tiku.baidu.com/tikupc/singledetail/c1f824284b73f242336c5f80', '1025991570827444226', '0');
INSERT INTO `crawler_question` VALUES ('1025991589848612865', 'https://tiku.baidu.com/tikupc/singledetail/14f7bfd5b9f3f90f76c61bf2', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991589848612866', 'https://tiku.baidu.com/tikupc/singledetail/8e214b73f242336c1eb95e0c', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991589865390081', 'https://tiku.baidu.com/tikupc/singledetail/343302020740be1e650e9a37', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991589907333121', 'https://tiku.baidu.com/tikupc/singledetail/c3a626284b73f242336c5fde', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991589882167299', 'https://tiku.baidu.com/tikupc/singledetail/98b59e0590c69ec3d5bb750d', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991589961859073', 'https://tiku.baidu.com/tikupc/singledetail/150bbcd5b9f3f90f76c61b0e', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991589961859074', 'https://tiku.baidu.com/tikupc/singledetail/24475afb770bf78a65295466', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991589961859075', 'https://tiku.baidu.com/tikupc/singledetail/649bd1f34693daef5ef73d34', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991590016385026', 'https://tiku.baidu.com/tikupc/singledetail/60f18bd63186bceb19e8bb31', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991590037356546', 'https://tiku.baidu.com/tikupc/singledetail/be0bafaad1f34693daef3ee0', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991590037356547', 'https://tiku.baidu.com/tikupc/singledetail/1acf4693daef5ef7ba0d3c39', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991590117048322', 'https://tiku.baidu.com/tikupc/singledetail/29e328ea81c758f5f61f6733', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991590037356548', 'https://tiku.baidu.com/tikupc/singledetail/a71f824d2b160b4e767fcf45', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991590133825538', 'https://tiku.baidu.com/tikupc/singledetail/f61eb4daa58da0116c174934', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991590230294530', 'https://tiku.baidu.com/tikupc/singledetail/265210a6f524ccbff121844f', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991590230294529', 'https://tiku.baidu.com/tikupc/singledetail/8d03eefdc8d376eeaeaa3133', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991590230294532', 'https://tiku.baidu.com/tikupc/singledetail/649f9e3143323968011c926c', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991590230294531', 'https://tiku.baidu.com/tikupc/singledetail/ec8226d3240c844769eaeee2', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991590347735042', 'https://tiku.baidu.com/tikupc/singledetail/9d297fd5360cba1aa811da5d', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991590347735043', 'https://tiku.baidu.com/tikupc/singledetail/658dcc22bcd126fff7050b07', '1025991571293011971', '0');
INSERT INTO `crawler_question` VALUES ('1025991590347735044', 'https://tiku.baidu.com/tikupc/singledetail/41104b35eefdc8d376ee3230', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991590398066690', 'https://tiku.baidu.com/tikupc/singledetail/fb11760bf78a6529647d53ef', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991590452592641', 'https://tiku.baidu.com/tikupc/singledetail/b4bfc4da50e2524de5187ea4', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991590515507203', 'https://tiku.baidu.com/tikupc/singledetail/278f11a6f524ccbff1218492', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991590515507202', 'https://tiku.baidu.com/tikupc/singledetail/d5f3ce2f0066f5335a81212e', '1025991571293011971', '0');
INSERT INTO `crawler_question` VALUES ('1025991590528090114', 'https://tiku.baidu.com/tikupc/singledetail/b9315727a5e9856a5612600b', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991590544867330', 'https://tiku.baidu.com/tikupc/singledetail/efd4590216fc700abb68fceb', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991590595198978', 'https://tiku.baidu.com/tikupc/singledetail/102759f5f61fb7360b4c65e5', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991590595198980', 'https://tiku.baidu.com/tikupc/singledetail/e939a21614791711cc79172e', '1025991571293011971', '0');
INSERT INTO `crawler_question` VALUES ('1025991590645530625', 'https://tiku.baidu.com/tikupc/singledetail/810e376baf1ffc4ffe47ac33', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991590595198979', 'https://tiku.baidu.com/tikupc/singledetail/7fc7ac02de80d4d8d15a4f92', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991590729416706', 'https://tiku.baidu.com/tikupc/singledetail/642d3169a45177232f60a203', '1025991571293011971', '0');
INSERT INTO `crawler_question` VALUES ('1025991590729416705', 'https://tiku.baidu.com/tikupc/singledetail/32ee876a561252d380eb6e02', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991590796525570', 'https://tiku.baidu.com/tikupc/singledetail/1eb4f56527d3240c8447efc4', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991590888800257', 'https://tiku.baidu.com/tikupc/singledetail/53e19b8fcc22bcd126ff0c0e', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991590913966082', 'https://tiku.baidu.com/tikupc/singledetail/648dd4d8d15abe23482f4d08', '1025991571548864515', '0');
INSERT INTO `crawler_question` VALUES ('1025991590913966083', 'https://tiku.baidu.com/tikupc/singledetail/d2e18f9951e79b8968022692', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991591098515457', 'https://tiku.baidu.com/tikupc/singledetail/53677e21af45b307e871970a', '1025991571548864515', '0');
INSERT INTO `crawler_question` VALUES ('1025991591098515458', 'https://tiku.baidu.com/tikupc/singledetail/9d5f2e3f5727a5e9856a6116', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991591098515461', 'https://tiku.baidu.com/tikupc/singledetail/904e61eae009581b6bd9eb0c', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991591098515459', 'https://tiku.baidu.com/tikupc/singledetail/0ac8a517866fb84ae45c8db8', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991591257899009', 'https://tiku.baidu.com/tikupc/singledetail/141f52ea551810a6f5248614', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991591257899010', 'https://tiku.baidu.com/tikupc/singledetail/fcc7c1c708a1284ac8504315', '1025991571750191105', '0');
INSERT INTO `crawler_question` VALUES ('1025991591358562306', 'https://tiku.baidu.com/tikupc/singledetail/5415ed630b1c59eef8c7b43d', '1025991571548864515', '0');
INSERT INTO `crawler_question` VALUES ('1025991591379533826', 'https://tiku.baidu.com/tikupc/singledetail/f600501b6bd97f192279e90c', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991591379533825', 'https://tiku.baidu.com/tikupc/singledetail/b507c5da50e2524de5187e1c', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991591379533827', 'https://tiku.baidu.com/tikupc/singledetail/831403d276a20029bd642d90', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991591379533828', 'https://tiku.baidu.com/tikupc/singledetail/f724cc1755270722192ef724', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991591421476865', 'https://tiku.baidu.com/tikupc/singledetail/fb3c760bf78a6529647d53c2', '1025991571750191105', '0');
INSERT INTO `crawler_question` VALUES ('1025991591421476866', 'https://tiku.baidu.com/tikupc/singledetail/64b8d4d8d15abe23482f4d3d', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991591488585729', 'https://tiku.baidu.com/tikupc/singledetail/acb93f126edb6f1aff001f8e', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991591480197121', 'https://tiku.baidu.com/tikupc/singledetail/7a1879563c1ec5da50e27017', '1025991571548864515', '0');
INSERT INTO `crawler_question` VALUES ('1025991591555694594', 'https://tiku.baidu.com/tikupc/singledetail/99c53a3567ec102de2bd899c', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991591555694593', 'https://tiku.baidu.com/tikupc/singledetail/ee6b580216fc700abb68fc54', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991591555694595', 'https://tiku.baidu.com/tikupc/singledetail/a9460b1c59eef8c75fbfb320', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991591585054722', 'https://tiku.baidu.com/tikupc/singledetail/bbf92b4ac850ad02de80415d', '1025991571750191105', '0');
INSERT INTO `crawler_question` VALUES ('1025991591614414849', 'https://tiku.baidu.com/tikupc/singledetail/878bda38376baf1ffc4fad42', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991591635386372', 'https://tiku.baidu.com/tikupc/singledetail/f572cfc789eb172ded63b75d', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991591635386370', 'https://tiku.baidu.com/tikupc/singledetail/069b0c020740be1e650e9a9f', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991591635386371', 'https://tiku.baidu.com/tikupc/singledetail/22320b4c2e3f5727a5e96201', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991591249510401', 'https://tiku.baidu.com/tikupc/singledetail/162f76c66137ee06eff91825', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991591685718017', 'https://tiku.baidu.com/tikupc/singledetail/2196ad45b307e87101f696b2', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991591685718018', 'https://tiku.baidu.com/tikupc/singledetail/17f2c77da26925c52cc5bf48', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991591635386369', 'https://tiku.baidu.com/tikupc/singledetail/d9f0e418964bcf84b9d57bb8', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991591765409794', 'https://tiku.baidu.com/tikupc/singledetail/cdf30c225901020207409c35', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991591765409795', 'https://tiku.baidu.com/tikupc/singledetail/fedf29284b73f242336c5fa7', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991591811547138', 'https://tiku.baidu.com/tikupc/singledetail/3c230a020740be1e650e9a27', '1025991571750191105', '0');
INSERT INTO `crawler_question` VALUES ('1025991591811547140', 'https://tiku.baidu.com/tikupc/singledetail/1c26eff9aef8941ea76e0525', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991591811547139', 'https://tiku.baidu.com/tikupc/singledetail/fce45a1b6bd97f192279e9e8', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991591849295873', 'https://tiku.baidu.com/tikupc/singledetail/f2ee76232f60ddccda38a0ba', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991591832518657', 'https://tiku.baidu.com/tikupc/singledetail/f953c281e53a580216fcfe4b', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991591765409793', 'https://tiku.baidu.com/tikupc/singledetail/f3a3fd4ffe4733687e21aab9', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991591899627521', 'https://tiku.baidu.com/tikupc/singledetail/8e3a4b73f242336c1eb95e17', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991591928987649', 'https://tiku.baidu.com/tikupc/singledetail/f6fdce7931b765ce050814e9', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991591928987650', 'https://tiku.baidu.com/tikupc/singledetail/4f6c32d4b14e852458fb57bb', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991591928987651', 'https://tiku.baidu.com/tikupc/singledetail/afdafab069dc5022aaea0025', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991591731855361', 'https://tiku.baidu.com/tikupc/singledetail/d19de97101f69e314332949f', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991591975124993', 'https://tiku.baidu.com/tikupc/singledetail/02ba492fb4daa58da0114a9c', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991591975124994', 'https://tiku.baidu.com/tikupc/singledetail/64d3f524ccbff121dd368370', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991591991902209', 'https://tiku.baidu.com/tikupc/singledetail/b472a98271fe910ef12df81f', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991591991902210', 'https://tiku.baidu.com/tikupc/singledetail/627a940590c69ec3d5bb75c2', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991591991902212', 'https://tiku.baidu.com/tikupc/singledetail/170ba8956bec0975f465e24c', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991592088371201', 'https://tiku.baidu.com/tikupc/singledetail/6a9bbf23482fb4daa58d4bc4', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991592088371202', 'https://tiku.baidu.com/tikupc/singledetail/929eb14e852458fb770b564f', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991592109342721', 'https://tiku.baidu.com/tikupc/singledetail/90c9ba0d4a7302768e99393b', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991592151285761', 'https://tiku.baidu.com/tikupc/singledetail/cbd3f61fb7360b4c2e3f6423', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991592189034497', 'https://tiku.baidu.com/tikupc/singledetail/64ec9e3143323968011c921f', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991592205811714', 'https://tiku.baidu.com/tikupc/singledetail/b415f111f18583d049645927', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991592218394626', 'https://tiku.baidu.com/tikupc/singledetail/bf1085254b35eefdc8d333c4', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991592277114882', 'https://tiku.baidu.com/tikupc/singledetail/d22ff78a6529647d27285221', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991592323252226', 'https://tiku.baidu.com/tikupc/singledetail/ac9f3f126edb6f1aff001fa8', '1025991558420692994', '0');
INSERT INTO `crawler_question` VALUES ('1025991592323252227', 'https://tiku.baidu.com/tikupc/singledetail/8c6d01f69e31433239689319', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991592348418049', 'https://tiku.baidu.com/tikupc/singledetail/0335482fb4daa58da0114a13', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991592407138306', 'https://tiku.baidu.com/tikupc/singledetail/ecff26d3240c844769eaee9f', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991592407138305', 'https://tiku.baidu.com/tikupc/singledetail/ddf74afe04a1b0717fd5dd1e', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991592428109826', 'https://tiku.baidu.com/tikupc/singledetail/fcf3c1c708a1284ac8504321', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991592520384513', 'https://tiku.baidu.com/tikupc/singledetail/41604b35eefdc8d376ee3240', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991592520384514', 'https://tiku.baidu.com/tikupc/singledetail/87d5da38376baf1ffc4fad1c', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991592520384515', 'https://tiku.baidu.com/tikupc/singledetail/6772a45177232f60ddcca11e', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991592616853507', 'https://tiku.baidu.com/tikupc/singledetail/ea6e27c52cc58bd63186bd02', '1025991558726877186', '0');
INSERT INTO `crawler_question` VALUES ('1025991592616853506', 'https://tiku.baidu.com/tikupc/singledetail/42c3d0d233d4b14e8524684e', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991592662990849', 'https://tiku.baidu.com/tikupc/singledetail/57b2f90f76c66137ee061944', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991592662990850', 'https://tiku.baidu.com/tikupc/singledetail/57e8f90f76c66137ee06191e', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991592662990851', 'https://tiku.baidu.com/tikupc/singledetail/61df04a1b0717fd5360cdc24', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991592751071233', 'https://tiku.baidu.com/tikupc/singledetail/03f4ad8da0116c175f0e482b', '1025991558726877186', '0');
INSERT INTO `crawler_question` VALUES ('1025991592759459841', 'https://tiku.baidu.com/tikupc/singledetail/541e16fc700abb68a982fb19', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991592759459842', 'https://tiku.baidu.com/tikupc/singledetail/285d31b765ce050876321321', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991592805597185', 'https://tiku.baidu.com/tikupc/singledetail/dd33bd64783e0912a2162a1f', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991592813985794', 'https://tiku.baidu.com/tikupc/singledetail/8346f12d2af90242a895e54d', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991592797208578', 'https://tiku.baidu.com/tikupc/singledetail/ab87bb4cf7ec4afe04a1df46', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991592839151617', 'https://tiku.baidu.com/tikupc/singledetail/cc75c92f0066f5335a8121a8', '1025991558726877186', '0');
INSERT INTO `crawler_question` VALUES ('1025991592931426305', 'https://tiku.baidu.com/tikupc/singledetail/cf0278a20029bd64783e2cd5', '1025991558726877186', '0');
INSERT INTO `crawler_question` VALUES ('1025991592956592130', 'https://tiku.baidu.com/tikupc/singledetail/540716fc700abb68a982fb00', '1025991559041449985', '0');
INSERT INTO `crawler_question` VALUES ('1025991592973369346', 'https://tiku.baidu.com/tikupc/singledetail/fe25581b6bd97f192279e929', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991593011118082', 'https://tiku.baidu.com/tikupc/singledetail/dc7f8eeb6294dd88d0d26ba9', '1025991558726877186', '0');
INSERT INTO `crawler_question` VALUES ('1025991593032089602', 'https://tiku.baidu.com/tikupc/singledetail/6ec02cc58bd63186bcebbc00', '1025991559041449985', '0');
INSERT INTO `crawler_question` VALUES ('1025991593065644033', 'https://tiku.baidu.com/tikupc/singledetail/b1f04028915f804d2b16c137', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991593174695938', 'https://tiku.baidu.com/tikupc/singledetail/f35477232f60ddccda38a000', '1025991559041449985', '0');
INSERT INTO `crawler_question` VALUES ('1025991593199861761', 'https://tiku.baidu.com/tikupc/singledetail/74e5e009581b6bd97f19ea0a', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991593229221889', 'https://tiku.baidu.com/tikupc/singledetail/992a6037ee06eff9aef807e9', '1025991558584270849', '0');
INSERT INTO `crawler_question` VALUES ('1025991593283747842', 'https://tiku.baidu.com/tikupc/singledetail/74eb08a1284ac850ad024229', '1025991559041449985', '0');
INSERT INTO `crawler_question` VALUES ('1025991593304719364', 'https://tiku.baidu.com/tikupc/singledetail/a279caaedd3383c4bb4cd21e', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991593304719362', 'https://tiku.baidu.com/tikupc/singledetail/d9d676a20029bd64783e2c01', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991593304719365', 'https://tiku.baidu.com/tikupc/singledetail/8c1bf700bed5b9f3f90f1c04', '1025991558584270849', '0');
INSERT INTO `crawler_question` VALUES ('1025991593434742785', 'https://tiku.baidu.com/tikupc/singledetail/a73a8662caaedd3383c4d3b9', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991593434742787', 'https://tiku.baidu.com/tikupc/singledetail/dd2dbd64783e0912a2162a01', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991593434742786', 'https://tiku.baidu.com/tikupc/singledetail/4c6551e2524de518964b7dba', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991593506045954', 'https://tiku.baidu.com/tikupc/singledetail/7665ddccda38376baf1fae00', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991593514434562', 'https://tiku.baidu.com/tikupc/singledetail/5f8e3f2b3169a4517723a3d4', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991593531211777', 'https://tiku.baidu.com/tikupc/singledetail/de504bfe04a1b0717fd5ddb9', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991593531211778', 'https://tiku.baidu.com/tikupc/singledetail/b9482b160b4e767f5acfce00', '1025991559179862018', '0');
INSERT INTO `crawler_question` VALUES ('1025991593539600387', 'https://tiku.baidu.com/tikupc/singledetail/287d31b765ce050876321301', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991593539600386', 'https://tiku.baidu.com/tikupc/singledetail/d3caf68a6529647d272852c4', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991593581543426', 'https://tiku.baidu.com/tikupc/singledetail/a956804d2b160b4e767fcf0c', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991593623486466', 'https://tiku.baidu.com/tikupc/singledetail/f9998c75f46527d3240ce073', '1025991500774178818', '0');
INSERT INTO `crawler_question` VALUES ('1025991593640263681', 'https://tiku.baidu.com/tikupc/singledetail/278d11a6f524ccbff1218490', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991593640263682', 'https://tiku.baidu.com/tikupc/singledetail/6360783e0912a21614792901', '1025991559179862018', '0');
INSERT INTO `crawler_question` VALUES ('1025991593648652289', 'https://tiku.baidu.com/tikupc/singledetail/830bf12d2af90242a895e500', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991593648652290', 'https://tiku.baidu.com/tikupc/singledetail/a64070fe910ef12d2af9e7c7', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991593694789634', 'https://tiku.baidu.com/tikupc/singledetail/4fd650e2524de518964b7d09', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991593694789635', 'https://tiku.baidu.com/tikupc/singledetail/d9f976a20029bd64783e2c2e', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991593749315585', 'https://tiku.baidu.com/tikupc/singledetail/9128e2bd960590c69ec37600', '1025991559179862018', '0');
INSERT INTO `crawler_question` VALUES ('1025991593749315588', 'https://tiku.baidu.com/tikupc/singledetail/bf4d85254b35eefdc8d33399', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991593749315587', 'https://tiku.baidu.com/tikupc/singledetail/6830a300a6c30c2259019e29', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991593749315586', 'https://tiku.baidu.com/tikupc/singledetail/d1c7e97101f69e31433294c5', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991593803841537', 'https://tiku.baidu.com/tikupc/singledetail/8ec289eb172ded630b1cb600', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991593812230147', 'https://tiku.baidu.com/tikupc/singledetail/f81a43323968011ca300912e', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991593812230146', 'https://tiku.baidu.com/tikupc/singledetail/57cbf90f76c66137ee06193d', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991593870950403', 'https://tiku.baidu.com/tikupc/singledetail/32d549649b6648d7c1c74600', '1025991559179862018', '0');
INSERT INTO `crawler_question` VALUES ('1025991593870950402', 'https://tiku.baidu.com/tikupc/singledetail/c92ca6c30c22590102029d29', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991593870950404', 'https://tiku.baidu.com/tikupc/singledetail/562eb9f67c1cfad6195fa7c3', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991593879339010', 'https://tiku.baidu.com/tikupc/singledetail/40a8b9d528ea81c758f57829', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991593891921921', 'https://tiku.baidu.com/tikupc/singledetail/342a02020740be1e650e9a2e', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991593975808001', 'https://tiku.baidu.com/tikupc/singledetail/596e336c1eb91a37f1115c29', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991593984196610', 'https://tiku.baidu.com/tikupc/singledetail/007e168884868762caaed502', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991593975808002', 'https://tiku.baidu.com/tikupc/singledetail/9100e2bd960590c69ec37628', '1025991574157721602', '0');
INSERT INTO `crawler_question` VALUES ('1025991594093248514', 'https://tiku.baidu.com/tikupc/singledetail/e7ea102de2bd960590c67703', '1025991574157721602', '0');
INSERT INTO `crawler_question` VALUES ('1025991594093248515', 'https://tiku.baidu.com/tikupc/singledetail/beac284ac850ad02de804108', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991594168745986', 'https://tiku.baidu.com/tikupc/singledetail/fece3d1ec5da50e2524d7f9d', '1025991559481851906', '0');
INSERT INTO `crawler_question` VALUES ('1025991594168745987', 'https://tiku.baidu.com/tikupc/singledetail/9509b52acfc789eb172dc80c', '1025991574157721602', '0');
INSERT INTO `crawler_question` VALUES ('1025991594168745988', 'https://tiku.baidu.com/tikupc/singledetail/7e32bb68a98271fe910ef93d', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991594269409283', 'https://tiku.baidu.com/tikupc/singledetail/86e86137ee06eff9aef8072b', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991594269409282', 'https://tiku.baidu.com/tikupc/singledetail/288eb0717fd5360cba1adb2a', '1025991546840219650', '0');
INSERT INTO `crawler_question` VALUES ('1025991594269409281', 'https://tiku.baidu.com/tikupc/singledetail/cbd0f61fb7360b4c2e3f6420', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991594315546626', 'https://tiku.baidu.com/tikupc/singledetail/82ec9b89680203d8ce2f240e', '1025991574157721602', '0');
INSERT INTO `crawler_question` VALUES ('1025991594365878273', 'https://tiku.baidu.com/tikupc/singledetail/ff08dc88d0d233d4b14e6999', '1025991559481851906', '0');
INSERT INTO `crawler_question` VALUES ('1025991594365878275', 'https://tiku.baidu.com/tikupc/singledetail/7646ddccda38376baf1fae23', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991594365878274', 'https://tiku.baidu.com/tikupc/singledetail/d9f6f705cc1755270722080c', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991594479124482', 'https://tiku.baidu.com/tikupc/singledetail/90ef5022aaea998fcc220e36', '1025991574157721602', '0');
INSERT INTO `crawler_question` VALUES ('1025991594525261825', 'https://tiku.baidu.com/tikupc/singledetail/1a764693daef5ef7ba0d3c80', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991594533650433', 'https://tiku.baidu.com/tikupc/singledetail/12c79cc3d5bbfd0a79567304', '1025991559481851906', '0');
INSERT INTO `crawler_question` VALUES ('1025991594550427649', 'https://tiku.baidu.com/tikupc/singledetail/534e7e21af45b307e8719723', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991594550427650', 'https://tiku.baidu.com/tikupc/singledetail/42b9d0d233d4b14e85246834', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991594550427651', 'https://tiku.baidu.com/tikupc/singledetail/1efdacf8941ea76e58fa0401', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991594667868162', 'https://tiku.baidu.com/tikupc/singledetail/d554da3383c4bb4cf7ecd1ff', '1025991559481851906', '0');
INSERT INTO `crawler_question` VALUES ('1025991594672062466', 'https://tiku.baidu.com/tikupc/singledetail/1da8453610661ed9ad51f383', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991594672062465', 'https://tiku.baidu.com/tikupc/singledetail/1a864693daef5ef7ba0d3c70', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991594672062468', 'https://tiku.baidu.com/tikupc/singledetail/8d3eeefdc8d376eeaeaa310e', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991594672062469', 'https://tiku.baidu.com/tikupc/singledetail/80e29989680203d8ce2f2400', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991594672062467', 'https://tiku.baidu.com/tikupc/singledetail/1f18af45b307e87101f6963c', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991594743365634', 'https://tiku.baidu.com/tikupc/singledetail/8d31eefdc8d376eeaeaa3101', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991594768531459', 'https://tiku.baidu.com/tikupc/singledetail/8433ff00bed5b9f3f90f1c2c', '1025991574472294401', '0');
INSERT INTO `crawler_question` VALUES ('1025991594768531458', 'https://tiku.baidu.com/tikupc/singledetail/9213f7ec4afe04a1b071de5a', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991594768531461', 'https://tiku.baidu.com/tikupc/singledetail/138958f5f61fb7360b4c654b', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991594793697283', 'https://tiku.baidu.com/tikupc/singledetail/60cd910ef12d2af90242e636', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991594793697282', 'https://tiku.baidu.com/tikupc/singledetail/7fbcbceb19e8b8f67c1cb93f', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991594814668801', 'https://tiku.baidu.com/tikupc/singledetail/f5f2cd7931b765ce050814e6', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991594844028930', 'https://tiku.baidu.com/tikupc/singledetail/a9dd195f312b3169a451a40e', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991594911137794', 'https://tiku.baidu.com/tikupc/singledetail/8a8a6c85ec3a87c24028c482', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991594911137795', 'https://tiku.baidu.com/tikupc/singledetail/3df9240c844769eae009ed2f', '1025991574472294401', '0');
INSERT INTO `crawler_question` VALUES ('1025991594978246658', 'https://tiku.baidu.com/tikupc/singledetail/1faff8c75fbfc77da269b144', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991594978246660', 'https://tiku.baidu.com/tikupc/singledetail/750ee109581b6bd97f19eae1', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991594978246659', 'https://tiku.baidu.com/tikupc/singledetail/2375541810a6f524ccbf859a', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991594978246661', 'https://tiku.baidu.com/tikupc/singledetail/39240342a8956bec0975e3d8', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991595015995394', 'https://tiku.baidu.com/tikupc/singledetail/fc1bc1c708a1284ac85043c9', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991595015995395', 'https://tiku.baidu.com/tikupc/singledetail/151590c69ec3d5bbfd0a7415', '1025991574472294401', '0');
INSERT INTO `crawler_question` VALUES ('1025991595066327041', 'https://tiku.baidu.com/tikupc/singledetail/9f4f2c3f5727a5e9856a6106', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991595066327042', 'https://tiku.baidu.com/tikupc/singledetail/16095ff7ba0d4a7302763ae3', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991595112464386', 'https://tiku.baidu.com/tikupc/singledetail/6d5ebe23482fb4daa58d4b01', '1025991575038525441', '0');
INSERT INTO `crawler_question` VALUES ('1025991595154407426', 'https://tiku.baidu.com/tikupc/singledetail/b8eb84254b35eefdc8d3333f', '1025991574472294401', '0');
INSERT INTO `crawler_question` VALUES ('1025991595154407427', 'https://tiku.baidu.com/tikupc/singledetail/5e89001ca300a6c30c229fe4', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991595154407428', 'https://tiku.baidu.com/tikupc/singledetail/76c3905f804d2b160b4ec0ee', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991595154407429', 'https://tiku.baidu.com/tikupc/singledetail/7a0979563c1ec5da50e27006', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991595154407430', 'https://tiku.baidu.com/tikupc/singledetail/14ea9ec3d5bbfd0a79567329', '1025991575038525441', '0');
INSERT INTO `crawler_question` VALUES ('1025991595229904898', 'https://tiku.baidu.com/tikupc/singledetail/a00165ec0975f46527d3e191', '1025991560048082946', '0');
INSERT INTO `crawler_question` VALUES ('1025991595229904899', 'https://tiku.baidu.com/tikupc/singledetail/686abe1e650e52ea5518982f', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991595280236545', 'https://tiku.baidu.com/tikupc/singledetail/a82ea8ea998fcc22bcd10d09', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991595280236546', 'https://tiku.baidu.com/tikupc/singledetail/c038667d27284b73f2425014', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991595280236547', 'https://tiku.baidu.com/tikupc/singledetail/47186bd97f1922791688e806', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991595359928321', 'https://tiku.baidu.com/tikupc/singledetail/342f230c844769eae009edf9', '1025991560048082946', '0');
INSERT INTO `crawler_question` VALUES ('1025991595359928322', 'https://tiku.baidu.com/tikupc/singledetail/da287375a417866fb84a8e00', '1025991575038525441', '0');
INSERT INTO `crawler_question` VALUES ('1025991595359928323', 'https://tiku.baidu.com/tikupc/singledetail/7a2079563c1ec5da50e2702f', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991595359928324', 'https://tiku.baidu.com/tikupc/singledetail/87c6da38376baf1ffc4fad0f', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991595452203010', 'https://tiku.baidu.com/tikupc/singledetail/413e27fff705cc17552709ea', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991595460591617', 'https://tiku.baidu.com/tikupc/singledetail/707bad02de80d4d8d15a4f2e', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991595477368834', 'https://tiku.baidu.com/tikupc/singledetail/38ce5d1810a6f524ccbf8521', '1025991560048082946', '0');
INSERT INTO `crawler_question` VALUES ('1025991595477368835', 'https://tiku.baidu.com/tikupc/singledetail/aa09aaea998fcc22bcd10d2e', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991595544477697', 'https://tiku.baidu.com/tikupc/singledetail/1ac24693daef5ef7ba0d3c34', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991595544477698', 'https://tiku.baidu.com/tikupc/singledetail/9101e2bd960590c69ec37629', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991595544477699', 'https://tiku.baidu.com/tikupc/singledetail/f409fe4ffe4733687e21aa13', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991595569643521', 'https://tiku.baidu.com/tikupc/singledetail/90eae3bd960590c69ec376c2', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991595569643522', 'https://tiku.baidu.com/tikupc/singledetail/6f973d6c1eb91a37f1115cd0', '1025991560048082946', '0');
INSERT INTO `crawler_question` VALUES ('1025991595569643523', 'https://tiku.baidu.com/tikupc/singledetail/c8ade53a580216fc700afd29', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991595628363778', 'https://tiku.baidu.com/tikupc/singledetail/e202763231126edb6f1a100f', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991595628363779', 'https://tiku.baidu.com/tikupc/singledetail/dd02846fb84ae45c3b358c10', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991595653529601', 'https://tiku.baidu.com/tikupc/singledetail/1febf8c75fbfc77da269b100', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991595682889731', 'https://tiku.baidu.com/tikupc/singledetail/98b24531b90d6c85ec3ac6a6', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991595682889730', 'https://tiku.baidu.com/tikupc/singledetail/150090c69ec3d5bbfd0a7400', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991595737415683', 'https://tiku.baidu.com/tikupc/singledetail/da267375a417866fb84a8e0e', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991595737415682', 'https://tiku.baidu.com/tikupc/singledetail/60d2910ef12d2af90242e629', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991595737415684', 'https://tiku.baidu.com/tikupc/singledetail/7b61447302768e9951e73869', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991595800330243', 'https://tiku.baidu.com/tikupc/singledetail/80abf02d2af90242a895e5a0', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991595800330242', 'https://tiku.baidu.com/tikupc/singledetail/8abfdaef5ef7ba0d4a733b29', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991595863244801', 'https://tiku.baidu.com/tikupc/singledetail/c0ee1911cc7931b765ce1592', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991595905187842', 'https://tiku.baidu.com/tikupc/singledetail/d3738e9951e79b8968022600', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991595947130881', 'https://tiku.baidu.com/tikupc/singledetail/6c682c79168884868762d674', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991595947130882', 'https://tiku.baidu.com/tikupc/singledetail/161976c66137ee06eff91813', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991596018434049', 'https://tiku.baidu.com/tikupc/singledetail/190aba1aa8114431b90dd803', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991596026822658', 'https://tiku.baidu.com/tikupc/singledetail/fc0bac6925c52cc58bd6be73', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991596068765698', 'https://tiku.baidu.com/tikupc/singledetail/9009ee06eff9aef8941e063b', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991596119097346', 'https://tiku.baidu.com/tikupc/singledetail/67c6a1c7aa00b52acfc7ca0c', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991596152651777', 'https://tiku.baidu.com/tikupc/singledetail/4f8c680203d8ce2f00662300', '1025991575852220417', '0');
INSERT INTO `crawler_question` VALUES ('1025991596202983426', 'https://tiku.baidu.com/tikupc/singledetail/02a969dc5022aaea998f0f1c', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991596249120770', 'https://tiku.baidu.com/tikupc/singledetail/e86f25c52cc58bd63186bd03', '1025991575852220417', '0');
INSERT INTO `crawler_question` VALUES ('1025991596249120769', 'https://tiku.baidu.com/tikupc/singledetail/17aec77da26925c52cc5bf14', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991596282675201', 'https://tiku.baidu.com/tikupc/singledetail/7670b90d6c85ec3a87c2c544', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991596307841025', 'https://tiku.baidu.com/tikupc/singledetail/60d1910ef12d2af90242e62a', '1025991575973855234', '0');
INSERT INTO `crawler_question` VALUES ('1025991596353978369', 'https://tiku.baidu.com/tikupc/singledetail/de60e518964bcf84b9d57b28', '1025991575852220417', '0');
INSERT INTO `crawler_question` VALUES ('1025991596353978371', 'https://tiku.baidu.com/tikupc/singledetail/7e10bb68a98271fe910ef91f', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991596353978370', 'https://tiku.baidu.com/tikupc/singledetail/61296c175f0e7cd18425363d', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991596404310018', 'https://tiku.baidu.com/tikupc/singledetail/e23d24d3240c844769eaee5d', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991596404310017', 'https://tiku.baidu.com/tikupc/singledetail/d93287c24028915f804dc20d', '1025991575973855234', '0');
INSERT INTO `crawler_question` VALUES ('1025991596467224577', 'https://tiku.baidu.com/tikupc/singledetail/df06866fb84ae45c3b358c14', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991596484001794', 'https://tiku.baidu.com/tikupc/singledetail/f604b4daa58da0116c17492e', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991596521750529', 'https://tiku.baidu.com/tikupc/singledetail/d519f48a6529647d27285217', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991596576276482', 'https://tiku.baidu.com/tikupc/singledetail/571e0722192e45361066f53c', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991596618219522', 'https://tiku.baidu.com/tikupc/singledetail/22b9e3630b1c59eef8c7b491', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991596588859394', 'https://tiku.baidu.com/tikupc/singledetail/9c257cd184254b35eefd342e', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991596710494210', 'https://tiku.baidu.com/tikupc/singledetail/418b83d049649b6648d7470b', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991596794380289', 'https://tiku.baidu.com/tikupc/singledetail/a08a0e12a2161479171128b1', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991596794380291', 'https://tiku.baidu.com/tikupc/singledetail/6d50be23482fb4daa58d4b0f', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991596794380290', 'https://tiku.baidu.com/tikupc/singledetail/1bc6d5bbfd0a79563c1e7200', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991596869877762', 'https://tiku.baidu.com/tikupc/singledetail/1c31eff9aef8941ea76e0532', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991596869877763', 'https://tiku.baidu.com/tikupc/singledetail/b8da84254b35eefdc8d3330e', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991596869877764', 'https://tiku.baidu.com/tikupc/singledetail/53437e21af45b307e871972e', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991596895043586', 'https://tiku.baidu.com/tikupc/singledetail/16551ed9ad51f01dc281f136', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991596878266369', 'https://tiku.baidu.com/tikupc/singledetail/a074264ac850ad02de8041d0', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991596953763842', 'https://tiku.baidu.com/tikupc/singledetail/12a90a4e767f5acfa1c7cdba', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991596962152450', 'https://tiku.baidu.com/tikupc/singledetail/802accbff121dd36a32d820b', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991596962152451', 'https://tiku.baidu.com/tikupc/singledetail/8035ccbff121dd36a32d8214', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991596974735362', 'https://tiku.baidu.com/tikupc/singledetail/6234b7360b4c2e3f5727632e', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991596987318273', 'https://tiku.baidu.com/tikupc/singledetail/d9d4f705cc1755270722082e', '1025991576653332482', '0');
INSERT INTO `crawler_question` VALUES ('1025991597012484097', 'https://tiku.baidu.com/tikupc/singledetail/4f81680203d8ce2f0066230d', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991597058621441', 'https://tiku.baidu.com/tikupc/singledetail/ca98a7c30c22590102029d9d', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991597058621442', 'https://tiku.baidu.com/tikupc/singledetail/b3a81a37f111f18583d05a14', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991597058621443', 'https://tiku.baidu.com/tikupc/singledetail/1ac64693daef5ef7ba0d3c30', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991597100564481', 'https://tiku.baidu.com/tikupc/singledetail/67caa1c7aa00b52acfc7ca00', '1025991576653332482', '0');
INSERT INTO `crawler_question` VALUES ('1025991597100564482', 'https://tiku.baidu.com/tikupc/singledetail/443167ec102de2bd96058801', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991597108953090', 'https://tiku.baidu.com/tikupc/singledetail/b1f34028915f804d2b16c134', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991597155090435', 'https://tiku.baidu.com/tikupc/singledetail/b5aaa88271fe910ef12df8c7', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991597155090436', 'https://tiku.baidu.com/tikupc/singledetail/e225763231126edb6f1a1028', '1025991561541255169', '0');
INSERT INTO `crawler_question` VALUES ('1025991597234782210', 'https://tiku.baidu.com/tikupc/singledetail/b46da98271fe910ef12df800', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991597234782209', 'https://tiku.baidu.com/tikupc/singledetail/164a1ed9ad51f01dc281f129', '1025991576653332482', '0');
INSERT INTO `crawler_question` VALUES ('1025991597234782211', 'https://tiku.baidu.com/tikupc/singledetail/a563f01dc281e53a5802ff37', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991597155090433', 'https://tiku.baidu.com/tikupc/singledetail/2c225a8102d276a200292e14', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991597234782212', 'https://tiku.baidu.com/tikupc/singledetail/190fba1aa8114431b90dd806', '1025991576993071106', '0');
INSERT INTO `crawler_question` VALUES ('1025991597251559425', 'https://tiku.baidu.com/tikupc/singledetail/61d104a1b0717fd5360cdc2a', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991597155090434', 'https://tiku.baidu.com/tikupc/singledetail/cc6d27284b73f242336c5f15', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991597318668290', 'https://tiku.baidu.com/tikupc/singledetail/f81243323968011ca3009126', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991597486440450', 'https://tiku.baidu.com/tikupc/singledetail/8f0588eb172ded630b1cb6c7', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991597356417025', 'https://tiku.baidu.com/tikupc/singledetail/1f6f561252d380eb62946d00', '1025991576653332482', '0');
INSERT INTO `crawler_question` VALUES ('1025991597373194242', 'https://tiku.baidu.com/tikupc/singledetail/5402ed630b1c59eef8c7b42a', '1025991561541255169', '0');
INSERT INTO `crawler_question` VALUES ('1025991597373194243', 'https://tiku.baidu.com/tikupc/singledetail/dbdc524de518964bcf847c3b', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991597373194241', 'https://tiku.baidu.com/tikupc/singledetail/fb6a9b6648d7c1c708a1450b', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991597540966402', 'https://tiku.baidu.com/tikupc/singledetail/8d10eefdc8d376eeaeaa3120', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991597540966401', 'https://tiku.baidu.com/tikupc/singledetail/761cb90d6c85ec3a87c2c528', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991597595492354', 'https://tiku.baidu.com/tikupc/singledetail/1bca700abb68a98271fefa33', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991597595492356', 'https://tiku.baidu.com/tikupc/singledetail/299728ea81c758f5f61f6747', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991597670989827', 'https://tiku.baidu.com/tikupc/singledetail/f39319e8b8f67c1cfad6b87d', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991597595492355', 'https://tiku.baidu.com/tikupc/singledetail/87476e1aff00bed5b9f31d99', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991597670989826', 'https://tiku.baidu.com/tikupc/singledetail/b45ba98271fe910ef12df836', '1025991561541255169', '0');
INSERT INTO `crawler_question` VALUES ('1025991597348028418', 'https://tiku.baidu.com/tikupc/singledetail/441967ec102de2bd96058829', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991597738098689', 'https://tiku.baidu.com/tikupc/singledetail/32c149649b6648d7c1c74614', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991597683572737', 'https://tiku.baidu.com/tikupc/singledetail/b1ef4028915f804d2b16c128', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991597788430338', 'https://tiku.baidu.com/tikupc/singledetail/ae01fbb069dc5022aaea00fe', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991597788430339', 'https://tiku.baidu.com/tikupc/singledetail/e2152af90242a8956bece43d', '1025991577181814786', '0');
INSERT INTO `crawler_question` VALUES ('1025991597801013250', 'https://tiku.baidu.com/tikupc/singledetail/ae245f0e7cd184254b353536', '1025991561541255169', '0');
INSERT INTO `crawler_question` VALUES ('1025991597801013251', 'https://tiku.baidu.com/tikupc/singledetail/130c852458fb770bf78a5547', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991597801013249', 'https://tiku.baidu.com/tikupc/singledetail/9f34c850ad02de80d4d8407b', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991597838761986', 'https://tiku.baidu.com/tikupc/singledetail/80c8f02d2af90242a895e5c3', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991597872316418', 'https://tiku.baidu.com/tikupc/singledetail/840bff00bed5b9f3f90f1c14', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991597872316419', 'https://tiku.baidu.com/tikupc/singledetail/1c00eff9aef8941ea76e0503', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991597901676545', 'https://tiku.baidu.com/tikupc/singledetail/fe95df88d0d233d4b14e6904', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991597901676546', 'https://tiku.baidu.com/tikupc/singledetail/c89de53a580216fc700afd19', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991597914259457', 'https://tiku.baidu.com/tikupc/singledetail/32ef876a561252d380eb6e03', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991597872316420', 'https://tiku.baidu.com/tikupc/singledetail/18a278c66137ee06eff918a8', '1025991577181814786', '0');
INSERT INTO `crawler_question` VALUES ('1025991597977174018', 'https://tiku.baidu.com/tikupc/singledetail/eff0590216fc700abb68fccf', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991597968785409', 'https://tiku.baidu.com/tikupc/singledetail/8335f12d2af90242a895e53e', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991597977174019', 'https://tiku.baidu.com/tikupc/singledetail/b9ed81c758f5f61fb7366602', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991598035894273', 'https://tiku.baidu.com/tikupc/singledetail/5f9481d049649b6648d74714', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991598077837313', 'https://tiku.baidu.com/tikupc/singledetail/52516429647d27284b7351de', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991598086225921', 'https://tiku.baidu.com/tikupc/singledetail/51c2360cba1aa8114431d912', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991598086225922', 'https://tiku.baidu.com/tikupc/singledetail/17b7c77da26925c52cc5bf0d', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991598149140482', 'https://tiku.baidu.com/tikupc/singledetail/0395178884868762caaed5e9', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991598241415170', 'https://tiku.baidu.com/tikupc/singledetail/1bbcce84b9d528ea81c779f2', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991598321106945', 'https://tiku.baidu.com/tikupc/singledetail/8c3701f69e31433239689343', '1025991577508970497', '0');
INSERT INTO `crawler_question` VALUES ('1025991598329495553', 'https://tiku.baidu.com/tikupc/singledetail/e86625c52cc58bd63186bd0a', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991598488879106', 'https://tiku.baidu.com/tikupc/singledetail/80b702d276a20029bd642d33', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991598488879105', 'https://tiku.baidu.com/tikupc/singledetail/8c0c01f69e31433239689378', '1025991577508970497', '0');
INSERT INTO `crawler_question` VALUES ('1025991598488879107', 'https://tiku.baidu.com/tikupc/singledetail/bead284ac850ad02de804109', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991598610513922', 'https://tiku.baidu.com/tikupc/singledetail/fa0483c4bb4cf7ec4afed032', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991598639874049', 'https://tiku.baidu.com/tikupc/singledetail/4f8d50e2524de518964b7d52', '1025991577508970497', '0');
INSERT INTO `crawler_question` VALUES ('1025991598639874050', 'https://tiku.baidu.com/tikupc/singledetail/65bccc22bcd126fff7050b36', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991598790868993', 'https://tiku.baidu.com/tikupc/singledetail/90eb5022aaea998fcc220e32', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991598790868994', 'https://tiku.baidu.com/tikupc/singledetail/e3989ec69ec3d5bbfd0a7498', '1025991577508970497', '0');
INSERT INTO `crawler_question` VALUES ('1025991598790868995', 'https://tiku.baidu.com/tikupc/singledetail/c224647d27284b73f2425008', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991598841200641', 'https://tiku.baidu.com/tikupc/singledetail/0233148884868762caaed54f', '1025991577655771137', '0');
INSERT INTO `crawler_question` VALUES ('1025991598849589250', 'https://tiku.baidu.com/tikupc/singledetail/529559fafab069dc502201fe', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991598920892418', 'https://tiku.baidu.com/tikupc/singledetail/cd2f55270722192e4536f63d', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991598920892419', 'https://tiku.baidu.com/tikupc/singledetail/140fde80d4d8d15abe234e08', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991599000584194', 'https://tiku.baidu.com/tikupc/singledetail/bd486aec0975f46527d3e1d8', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991599017361409', 'https://tiku.baidu.com/tikupc/singledetail/17da5ef7ba0d4a7302763a30', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991599067693057', 'https://tiku.baidu.com/tikupc/singledetail/776b915f804d2b160b4ec046', '1025991548618604545', '0');
INSERT INTO `crawler_question` VALUES ('1025991599088664578', 'https://tiku.baidu.com/tikupc/singledetail/7dc5beeb19e8b8f67c1cb946', '1025991578297499650', '0');
INSERT INTO `crawler_question` VALUES ('1025991599105441794', 'https://tiku.baidu.com/tikupc/singledetail/c9f6f41fb7360b4c2e3f6406', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991599214493699', 'https://tiku.baidu.com/tikupc/singledetail/aa1baaea998fcc22bcd10d3c', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991599214493698', 'https://tiku.baidu.com/tikupc/singledetail/bfe45fbfc77da26925c5b026', '1025991548618604545', '0');
INSERT INTO `crawler_question` VALUES ('1025991599277408257', 'https://tiku.baidu.com/tikupc/singledetail/fa55b84ae45c3b3567ec8b3f', '1025991578431717379', '0');
INSERT INTO `crawler_question` VALUES ('1025991599277408258', 'https://tiku.baidu.com/tikupc/singledetail/5034988fcc22bcd126ff0cdb', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991599327739906', 'https://tiku.baidu.com/tikupc/singledetail/d644cf2f0066f5335a812199', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991599352905730', 'https://tiku.baidu.com/tikupc/singledetail/287448d7c1c708a1284a4417', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991599352905731', 'https://tiku.baidu.com/tikupc/singledetail/9d6f2e3f5727a5e9856a6126', '1025991548618604545', '0');
INSERT INTO `crawler_question` VALUES ('1025991599373877251', 'https://tiku.baidu.com/tikupc/singledetail/1d6d541252d380eb62946d02', '1025991548903817219', '0');
INSERT INTO `crawler_question` VALUES ('1025991599373877250', 'https://tiku.baidu.com/tikupc/singledetail/443e67ec102de2bd9605880e', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991599411625985', 'https://tiku.baidu.com/tikupc/singledetail/76823f69a45177232f60a2ac', '1025991578431717379', '0');
INSERT INTO `crawler_question` VALUES ('1025991599411625986', 'https://tiku.baidu.com/tikupc/singledetail/1eb3f56527d3240c8447efc3', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991599461957634', 'https://tiku.baidu.com/tikupc/singledetail/49d2b8f67c1cfad6195fa73f', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991599461957635', 'https://tiku.baidu.com/tikupc/singledetail/87406e1aff00bed5b9f31d9e', '1025991548618604545', '0');
INSERT INTO `crawler_question` VALUES ('1025991599499706370', 'https://tiku.baidu.com/tikupc/singledetail/6747a45177232f60ddcca12b', '1025991578591100930', '0');
INSERT INTO `crawler_question` VALUES ('1025991599550038018', 'https://tiku.baidu.com/tikupc/singledetail/c9e3f41fb7360b4c2e3f6413', '1025991548903817219', '0');
INSERT INTO `crawler_question` VALUES ('1025991599579398145', 'https://tiku.baidu.com/tikupc/singledetail/637b970590c69ec3d5bb75c3', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991599550038019', 'https://tiku.baidu.com/tikupc/singledetail/b1ed4028915f804d2b16c12a', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991599550038020', 'https://tiku.baidu.com/tikupc/singledetail/d9ff6fdb6f1aff00bed51ee8', '1025991578020675586', '0');
INSERT INTO `crawler_question` VALUES ('1025991599487123458', 'https://tiku.baidu.com/tikupc/singledetail/ce52790bf78a6529647d53ac', '1025991578163281921', '0');
INSERT INTO `crawler_question` VALUES ('1025991599633924097', 'https://tiku.baidu.com/tikupc/singledetail/90cdba0d4a7302768e99393f', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991599633924098', 'https://tiku.baidu.com/tikupc/singledetail/e2e6f342336c1eb91a375d90', '1025991577878069250', '0');
INSERT INTO `crawler_question` VALUES ('1025991599411625987', 'https://tiku.baidu.com/tikupc/singledetail/b58fa88271fe910ef12df8e2', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991599688450049', 'https://tiku.baidu.com/tikupc/singledetail/6d6fad1ffc4ffe473368ab01', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991599705227265', 'https://tiku.baidu.com/tikupc/singledetail/6c0b0740be1e650e52ea990c', '1025991578591100930', '0');
INSERT INTO `crawler_question` VALUES ('1025991599713615873', 'https://tiku.baidu.com/tikupc/singledetail/b731aa8271fe910ef12df85c', '1025991578020675586', '0');
INSERT INTO `crawler_question` VALUES ('1025991599738781698', 'https://tiku.baidu.com/tikupc/singledetail/a6b382c758f5f61fb736665c', '1025991577878069250', '0');
INSERT INTO `crawler_question` VALUES ('1025991599772336129', 'https://tiku.baidu.com/tikupc/singledetail/170aa8956bec0975f465e24d', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991599789113346', 'https://tiku.baidu.com/tikupc/singledetail/656aa65177232f60ddcca106', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991599789113347', 'https://tiku.baidu.com/tikupc/singledetail/29f0c8d376eeaeaad1f33008', '1025991578591100930', '0');
INSERT INTO `crawler_question` VALUES ('1025991599826862081', 'https://tiku.baidu.com/tikupc/singledetail/51633b6c1eb91a37f1115c24', '1025991577878069250', '0');
INSERT INTO `crawler_question` VALUES ('1025991599893970947', 'https://tiku.baidu.com/tikupc/singledetail/683da300a6c30c2259019e24', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991599893970946', 'https://tiku.baidu.com/tikupc/singledetail/8e3ea26925c52cc58bd6be46', '1025991578591100930', '0');
INSERT INTO `crawler_question` VALUES ('1025991599927525377', 'https://tiku.baidu.com/tikupc/singledetail/fa0a6c7d27284b73f2425026', '1025991577878069250', '0');
INSERT INTO `crawler_question` VALUES ('1025991600003022849', 'https://tiku.baidu.com/tikupc/singledetail/1b8bd5bbfd0a79563c1e724d', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991600011411458', 'https://tiku.baidu.com/tikupc/singledetail/661fa0c7aa00b52acfc7cad5', '1025991578591100930', '0');
INSERT INTO `crawler_question` VALUES ('1025991600082714625', 'https://tiku.baidu.com/tikupc/singledetail/fcb3770bf78a6529647d534d', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991600166600706', 'https://tiku.baidu.com/tikupc/singledetail/8d14eefdc8d376eeaeaa3124', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991600233709569', 'https://tiku.baidu.com/tikupc/singledetail/f975996648d7c1c708a14514', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991600267264002', 'https://tiku.baidu.com/tikupc/singledetail/8beb00f69e3143323968939f', '1025991539923812354', '0');
INSERT INTO `crawler_question` VALUES ('1025991600317595650', 'https://tiku.baidu.com/tikupc/singledetail/214a2d60ddccda38376baf6c', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991600493756418', 'https://tiku.baidu.com/tikupc/singledetail/bfc25fbfc77da26925c5b000', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991600510533634', 'https://tiku.baidu.com/tikupc/singledetail/594a091ca300a6c30c229f27', '1025991579161526281', '0');
INSERT INTO `crawler_question` VALUES ('1025991600586031105', 'https://tiku.baidu.com/tikupc/singledetail/f3c619e8b8f67c1cfad6b828', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991600745414657', 'https://tiku.baidu.com/tikupc/singledetail/1af54693daef5ef7ba0d3c03', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991600745414658', 'https://tiku.baidu.com/tikupc/singledetail/906261eae009581b6bd9eb20', '1025991578712735746', '0');
INSERT INTO `crawler_question` VALUES ('1025991600929964034', 'https://tiku.baidu.com/tikupc/singledetail/197d0066f5335a8102d22057', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991600929964033', 'https://tiku.baidu.com/tikupc/singledetail/8e8089eb172ded630b1cb642', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991600988684289', 'https://tiku.baidu.com/tikupc/singledetail/0a89a517866fb84ae45c8df9', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991600997072898', 'https://tiku.baidu.com/tikupc/singledetail/3eca0242a8956bec0975e336', '1025991579937472514', '0');
INSERT INTO `crawler_question` VALUES ('1025991600997072899', 'https://tiku.baidu.com/tikupc/singledetail/f62c501b6bd97f192279e920', '1025991529597435906', '0');
INSERT INTO `crawler_question` VALUES ('1025991600997072900', 'https://tiku.baidu.com/tikupc/singledetail/4a635acfa1c7aa00b52acb19', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991601051598850', 'https://tiku.baidu.com/tikupc/singledetail/a9180b1c59eef8c75fbfb37e', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991601059987457', 'https://tiku.baidu.com/tikupc/singledetail/65ada0116c175f0e7cd13725', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991601085153281', 'https://tiku.baidu.com/tikupc/singledetail/2de2fbd6195f312b3169a5fb', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991601110319105', 'https://tiku.baidu.com/tikupc/singledetail/40ddb9d528ea81c758f5785c', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991601143873538', 'https://tiku.baidu.com/tikupc/singledetail/17c4c77da26925c52cc5bf7e', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991601160650754', 'https://tiku.baidu.com/tikupc/singledetail/748008a1284ac850ad024242', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991601177427970', 'https://tiku.baidu.com/tikupc/singledetail/0278148884868762caaed504', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991601194205185', 'https://tiku.baidu.com/tikupc/singledetail/8a276c85ec3a87c24028c42f', '1025991580054913028', '0');
INSERT INTO `crawler_question` VALUES ('1025991601215176705', 'https://tiku.baidu.com/tikupc/singledetail/9250b14e852458fb770b5681', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991601215176706', 'https://tiku.baidu.com/tikupc/singledetail/f41bfe4ffe4733687e21aa01', '1025991563634212868', '0');
INSERT INTO `crawler_question` VALUES ('1025991601231953922', 'https://tiku.baidu.com/tikupc/singledetail/8e06a26925c52cc58bd6be7e', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991601269702658', 'https://tiku.baidu.com/tikupc/singledetail/532f7e21af45b307e8719742', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991601269702659', 'https://tiku.baidu.com/tikupc/singledetail/adf8f8b069dc5022aaea0007', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991601315840001', 'https://tiku.baidu.com/tikupc/singledetail/abfebb4cf7ec4afe04a1df3f', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991601349394435', 'https://tiku.baidu.com/tikupc/singledetail/a505f01dc281e53a5802ff51', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991601349394436', 'https://tiku.baidu.com/tikupc/singledetail/a6c8814d2b160b4e767fcf92', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991601349394434', 'https://tiku.baidu.com/tikupc/singledetail/bb3c5527a5e9856a56126006', '1025991563634212868', '0');
INSERT INTO `crawler_question` VALUES ('1025991601609441282', 'https://tiku.baidu.com/tikupc/singledetail/f22a18e8b8f67c1cfad6b8c4', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991601609441281', 'https://tiku.baidu.com/tikupc/singledetail/c8a3e53a580216fc700afd27', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991601542332417', 'https://tiku.baidu.com/tikupc/singledetail/87fbda38376baf1ffc4fad32', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991601689133059', 'https://tiku.baidu.com/tikupc/singledetail/1c05f9c75fbfc77da269b1ee', '1025991563634212868', '0');
INSERT INTO `crawler_question` VALUES ('1025991601689133058', 'https://tiku.baidu.com/tikupc/singledetail/11220b4e767f5acfa1c7cd31', '1025991580361097220', '0');
INSERT INTO `crawler_question` VALUES ('1025991601269702657', 'https://tiku.baidu.com/tikupc/singledetail/b9b871fe910ef12d2af9e73f', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991601764630530', 'https://tiku.baidu.com/tikupc/singledetail/b423a98271fe910ef12df84e', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991601798184961', 'https://tiku.baidu.com/tikupc/singledetail/cc5f27284b73f242336c5f27', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991601814962177', 'https://tiku.baidu.com/tikupc/singledetail/179cc77da26925c52cc5bf26', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991601814962179', 'https://tiku.baidu.com/tikupc/singledetail/ec96dd3383c4bb4cf7ecd13d', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991601814962180', 'https://tiku.baidu.com/tikupc/singledetail/d46e7175a417866fb84a8e46', '1025991563634212868', '0');
INSERT INTO `crawler_question` VALUES ('1025991601814962181', 'https://tiku.baidu.com/tikupc/singledetail/987d69eae009581b6bd9eb3f', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991601814962178', 'https://tiku.baidu.com/tikupc/singledetail/0a2da0f8941ea76e58fa04d1', '1025991580361097220', '0');
INSERT INTO `crawler_question` VALUES ('1025991601814962183', 'https://tiku.baidu.com/tikupc/singledetail/451969d97f1922791688e807', '1025991580537257987', '0');
INSERT INTO `crawler_question` VALUES ('1025991601936596994', 'https://tiku.baidu.com/tikupc/singledetail/74e508a1284ac850ad024227', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991601861099521', 'https://tiku.baidu.com/tikupc/singledetail/4b927f19227916888486d74e', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991601936596995', 'https://tiku.baidu.com/tikupc/singledetail/cae1a7c30c22590102029de4', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991601936596996', 'https://tiku.baidu.com/tikupc/singledetail/cd3452d380eb6294dd886c23', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991601978540033', 'https://tiku.baidu.com/tikupc/singledetail/e8c2b64ae45c3b3567ec8ba8', '1025991580537257987', '0');
INSERT INTO `crawler_question` VALUES ('1025991601961762817', 'https://tiku.baidu.com/tikupc/singledetail/dbd8524de518964bcf847c3f', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991602003705858', 'https://tiku.baidu.com/tikupc/singledetail/164676c66137ee06eff9184c', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991602003705860', 'https://tiku.baidu.com/tikupc/singledetail/8ee389eb172ded630b1cb621', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991602003705859', 'https://tiku.baidu.com/tikupc/singledetail/b949f021dd36a32d737581f3', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991602091786242', 'https://tiku.baidu.com/tikupc/singledetail/6cf82ec58bd63186bcebbc38', '1025991580679864321', '0');
INSERT INTO `crawler_question` VALUES ('1025991602091786243', 'https://tiku.baidu.com/tikupc/singledetail/53fcfd0a79563c1ec5da7142', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991602125340673', 'https://tiku.baidu.com/tikupc/singledetail/7c40bdeb19e8b8f67c1cb9c3', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991602163089409', 'https://tiku.baidu.com/tikupc/singledetail/8a95cec789eb172ded63b7ba', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991602209226754', 'https://tiku.baidu.com/tikupc/singledetail/60f1960590c69ec3d5bb7549', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991602217615361', 'https://tiku.baidu.com/tikupc/singledetail/7fa2bceb19e8b8f67c1cb921', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991602226003970', 'https://tiku.baidu.com/tikupc/singledetail/7c42bdeb19e8b8f67c1cb9c1', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991602406359042', 'https://tiku.baidu.com/tikupc/singledetail/65f63069a45177232f60a2d8', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991602775457797', 'https://tiku.baidu.com/tikupc/singledetail/49a3b8f67c1cfad6195fa74e', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991602775457795', 'https://tiku.baidu.com/tikupc/singledetail/5b85b6f67c1cfad6195fa768', '1025991580738584581', '0');
INSERT INTO `crawler_question` VALUES ('1025991602775457798', 'https://tiku.baidu.com/tikupc/singledetail/5c15f38583d049649b665801', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991602775457794', 'https://tiku.baidu.com/tikupc/singledetail/75284a7302768e9951e73820', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991602775457796', 'https://tiku.baidu.com/tikupc/singledetail/8bb900f69e314332396893cd', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991602859343875', 'https://tiku.baidu.com/tikupc/singledetail/29cac8d376eeaeaad1f33032', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991602859343874', 'https://tiku.baidu.com/tikupc/singledetail/571a0722192e45361066f538', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991602947424258', 'https://tiku.baidu.com/tikupc/singledetail/a0b88762caaedd3383c4d33b', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991603006144514', 'https://tiku.baidu.com/tikupc/singledetail/1fd9eef9aef8941ea76e05da', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991603006144513', 'https://tiku.baidu.com/tikupc/singledetail/73b7a96e58fafab069dc02ac', '1025991580738584581', '0');
INSERT INTO `crawler_question` VALUES ('1025991603043893250', 'https://tiku.baidu.com/tikupc/singledetail/fef73d1ec5da50e2524d7fa4', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991603043893249', 'https://tiku.baidu.com/tikupc/singledetail/147dde80d4d8d15abe234e7a', '1025991580948299784', '0');
INSERT INTO `crawler_question` VALUES ('1025991603043893252', 'https://tiku.baidu.com/tikupc/singledetail/4fbe680203d8ce2f00662332', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991603043893251', 'https://tiku.baidu.com/tikupc/singledetail/9c4c7cd184254b35eefd3447', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991603085836290', 'https://tiku.baidu.com/tikupc/singledetail/110a0b4e767f5acfa1c7cd19', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991603106807809', 'https://tiku.baidu.com/tikupc/singledetail/94f1353567ec102de2bd89a8', '1025991580738584581', '0');
INSERT INTO `crawler_question` VALUES ('1025991603106807810', 'https://tiku.baidu.com/tikupc/singledetail/35e003020740be1e650e9ae4', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991603148750849', 'https://tiku.baidu.com/tikupc/singledetail/f38619e8b8f67c1cfad6b868', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991603165528065', 'https://tiku.baidu.com/tikupc/singledetail/8ae103f69e31433239689395', '1025991580948299784', '0');
INSERT INTO `crawler_question` VALUES ('1025991603165528066', 'https://tiku.baidu.com/tikupc/singledetail/154290c69ec3d5bbfd0a7442', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991603215859714', 'https://tiku.baidu.com/tikupc/singledetail/a25acaaedd3383c4bb4cd23d', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991603253608450', 'https://tiku.baidu.com/tikupc/singledetail/ee7acfc708a1284ac85043a8', '1025991580738584581', '0');
INSERT INTO `crawler_question` VALUES ('1025991603316523010', 'https://tiku.baidu.com/tikupc/singledetail/802d0408763231126edb11e6', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991603253608449', 'https://tiku.baidu.com/tikupc/singledetail/028469dc5022aaea998f0f31', '1025991564531793924', '0');
INSERT INTO `crawler_question` VALUES ('1025991603341688835', 'https://tiku.baidu.com/tikupc/singledetail/683fa300a6c30c2259019e26', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991603316523012', 'https://tiku.baidu.com/tikupc/singledetail/e921a21614791711cc791736', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991603341688836', 'https://tiku.baidu.com/tikupc/singledetail/c572e45c3b3567ec102d8a3d', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991603379437570', 'https://tiku.baidu.com/tikupc/singledetail/e2252af90242a8956bece40d', '1025991581472587778', '0');
INSERT INTO `crawler_question` VALUES ('1025991603341688834', 'https://tiku.baidu.com/tikupc/singledetail/cf260e225901020207409ce0', '1025991580948299784', '0');
INSERT INTO `crawler_question` VALUES ('1025991603425574914', 'https://tiku.baidu.com/tikupc/singledetail/cf11a5e9856a561252d36f33', '1025991564531793924', '0');
INSERT INTO `crawler_question` VALUES ('1025991603475906562', 'https://tiku.baidu.com/tikupc/singledetail/3171bcd126fff705cc170a56', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991603475906564', 'https://tiku.baidu.com/tikupc/singledetail/4fe250e2524de518964b7d3d', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991603475906563', 'https://tiku.baidu.com/tikupc/singledetail/6361f424ccbff121dd3683c2', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991603505266689', 'https://tiku.baidu.com/tikupc/singledetail/7fa2ac02de80d4d8d15a4ff7', '1025991581472587778', '0');
INSERT INTO `crawler_question` VALUES ('1025991603538821122', 'https://tiku.baidu.com/tikupc/singledetail/40b2b9d528ea81c758f57833', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991603584958466', 'https://tiku.baidu.com/tikupc/singledetail/90c1ba0d4a7302768e993933', '1025991564531793924', '0');
INSERT INTO `crawler_question` VALUES ('1025991603597541377', 'https://tiku.baidu.com/tikupc/singledetail/4fee50e2524de518964b7d31', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991603597541379', 'https://tiku.baidu.com/tikupc/singledetail/b40ef111f18583d04964593c', '1025991581472587778', '0');
INSERT INTO `crawler_question` VALUES ('1025991603597541378', 'https://tiku.baidu.com/tikupc/singledetail/15a4df80d4d8d15abe234ea3', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991603677233154', 'https://tiku.baidu.com/tikupc/singledetail/6376783e0912a21614792917', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991603677233155', 'https://tiku.baidu.com/tikupc/singledetail/d6c5a31614791711cc7917d2', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991603924697091', 'https://tiku.baidu.com/tikupc/singledetail/cdf80c225901020207409c3e', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991603815645186', 'https://tiku.baidu.com/tikupc/singledetail/5acc941ea76e58fafab00331', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991603924697092', 'https://tiku.baidu.com/tikupc/singledetail/6e43ac1ffc4ffe473368ab2d', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991604071497729', 'https://tiku.baidu.com/tikupc/singledetail/b66bab8271fe910ef12df806', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991603924697090', 'https://tiku.baidu.com/tikupc/singledetail/42e79c1ea76e58fafab0031a', '1025991565009944578', '0');
INSERT INTO `crawler_question` VALUES ('1025991604092469249', 'https://tiku.baidu.com/tikupc/singledetail/ef75dc3383c4bb4cf7ecd1de', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991604105052162', 'https://tiku.baidu.com/tikupc/singledetail/4f8f50e2524de518964b7d50', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991604167966722', 'https://tiku.baidu.com/tikupc/singledetail/39014335eefdc8d376ee3221', '1025991565009944578', '0');
INSERT INTO `crawler_question` VALUES ('1025991604167966723', 'https://tiku.baidu.com/tikupc/singledetail/9fdaaa00b52acfc789ebc918', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991604167966724', 'https://tiku.baidu.com/tikupc/singledetail/467565ec102de2bd96058845', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991604180549633', 'https://tiku.baidu.com/tikupc/singledetail/1f37d980d4d8d15abe234e30', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991604197326850', 'https://tiku.baidu.com/tikupc/singledetail/5a84941ea76e58fafab00379', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991604260241410', 'https://tiku.baidu.com/tikupc/singledetail/c0c11911cc7931b765ce15bd', '1025991565009944578', '0');
INSERT INTO `crawler_question` VALUES ('1025991604272824321', 'https://tiku.baidu.com/tikupc/singledetail/d6fe6cdb6f1aff00bed51ee9', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991604272824322', 'https://tiku.baidu.com/tikupc/singledetail/4ff950e2524de518964b7d26', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991604285407234', 'https://tiku.baidu.com/tikupc/singledetail/ac30b34e852458fb770b56e1', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991604285407235', 'https://tiku.baidu.com/tikupc/singledetail/764cb90d6c85ec3a87c2c578', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991604335738882', 'https://tiku.baidu.com/tikupc/singledetail/a75473fe910ef12d2af9e7d3', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991604419624963', 'https://tiku.baidu.com/tikupc/singledetail/3c02874769eae009581bec0b', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991604419624962', 'https://tiku.baidu.com/tikupc/singledetail/1f17561252d380eb62946d78', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991604428013569', 'https://tiku.baidu.com/tikupc/singledetail/acc2b34e852458fb770b5613', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991604499316740', 'https://tiku.baidu.com/tikupc/singledetail/f3effd4ffe4733687e21aaf5', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991604499316737', 'https://tiku.baidu.com/tikupc/singledetail/5fab971ea76e58fafab00356', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991604499316741', 'https://tiku.baidu.com/tikupc/singledetail/f81b43323968011ca300912f', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991604499316738', 'https://tiku.baidu.com/tikupc/singledetail/693c0440be1e650e52ea993b', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991604499316739', 'https://tiku.baidu.com/tikupc/singledetail/fce9dd88d0d233d4b14e6978', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991604620951553', 'https://tiku.baidu.com/tikupc/singledetail/901dee06eff9aef8941e062f', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991604658700290', 'https://tiku.baidu.com/tikupc/singledetail/9d7e7fd5360cba1aa811da0a', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991604658700291', 'https://tiku.baidu.com/tikupc/singledetail/fd98b94ae45c3b3567ec8bf2', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991604658700292', 'https://tiku.baidu.com/tikupc/singledetail/02b569dc5022aaea998f0f00', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991604658700293', 'https://tiku.baidu.com/tikupc/singledetail/4e0d59eef8c75fbfc77db214', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991604658700294', 'https://tiku.baidu.com/tikupc/singledetail/778adcccda38376baf1faeef', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991604658700295', 'https://tiku.baidu.com/tikupc/singledetail/6f93b91e650e52ea551898d6', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991604897775617', 'https://tiku.baidu.com/tikupc/singledetail/c890e53a580216fc700afd14', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991604994244609', 'https://tiku.baidu.com/tikupc/singledetail/243d3968011ca300a6c3900a', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991605040381953', 'https://tiku.baidu.com/tikupc/singledetail/cbc7172ded630b1c59eeb529', '1025991582672158724', '0');
INSERT INTO `crawler_question` VALUES ('1025991605002633218', 'https://tiku.baidu.com/tikupc/singledetail/3ce2856a561252d380eb6e0e', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991605057159170', 'https://tiku.baidu.com/tikupc/singledetail/40c6b9d528ea81c758f57847', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991605040381954', 'https://tiku.baidu.com/tikupc/singledetail/f16f3c1ec5da50e2524d7f3c', '1025991552838074370', '0');
INSERT INTO `crawler_question` VALUES ('1025991605107490818', 'https://tiku.baidu.com/tikupc/singledetail/e3c02bf90242a8956bece4e8', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991605107490817', 'https://tiku.baidu.com/tikupc/singledetail/0ad6e1f9aef8941ea76e05d5', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991605132656642', 'https://tiku.baidu.com/tikupc/singledetail/87cfda38376baf1ffc4fad06', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991605132656643', 'https://tiku.baidu.com/tikupc/singledetail/aa9a0029bd64783e09122b3d', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991605170405378', 'https://tiku.baidu.com/tikupc/singledetail/c6e23186bceb19e8b8f6ba31', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991605203959810', 'https://tiku.baidu.com/tikupc/singledetail/1f78561252d380eb62946d17', '1025991552838074370', '0');
INSERT INTO `crawler_question` VALUES ('1025991605203959811', 'https://tiku.baidu.com/tikupc/singledetail/d48f65ce050876323112123d', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991605203959812', 'https://tiku.baidu.com/tikupc/singledetail/cd870c225901020207409c41', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991605308817411', 'https://tiku.baidu.com/tikupc/singledetail/19e0ad51f01dc281e53af03c', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991605350760450', 'https://tiku.baidu.com/tikupc/singledetail/1fedf8c75fbfc77da269b106', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991605308817409', 'https://tiku.baidu.com/tikupc/singledetail/64f59e3143323968011c9206', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991605287845890', 'https://tiku.baidu.com/tikupc/singledetail/83d8203f5727a5e9856a6191', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991605384314882', 'https://tiku.baidu.com/tikupc/singledetail/cd0752d380eb6294dd886c10', '1025991552838074370', '0');
INSERT INTO `crawler_question` VALUES ('1025991605392703490', 'https://tiku.baidu.com/tikupc/singledetail/1338bed5b9f3f90f76c61b3d', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991605308817410', 'https://tiku.baidu.com/tikupc/singledetail/b3d44228915f804d2b16c113', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991605476589569', 'https://tiku.baidu.com/tikupc/singledetail/0364482fb4daa58da0114a42', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991605459812354', 'https://tiku.baidu.com/tikupc/singledetail/56bf346c1eb91a37f1115cf8', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991605484978180', 'https://tiku.baidu.com/tikupc/singledetail/7a1579563c1ec5da50e2701a', '1025991552838074370', '0');
INSERT INTO `crawler_question` VALUES ('1025991605484978179', 'https://tiku.baidu.com/tikupc/singledetail/8e7ea26925c52cc58bd6be06', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991605644361732', 'https://tiku.baidu.com/tikupc/singledetail/40c624fff705cc1755270912', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991605644361730', 'https://tiku.baidu.com/tikupc/singledetail/64cf9e3143323968011c923c', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991605644361731', 'https://tiku.baidu.com/tikupc/singledetail/a535a32d7375a417866f8f06', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991605858271236', 'https://tiku.baidu.com/tikupc/singledetail/f227fc4ffe4733687e21aa3d', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991605858271235', 'https://tiku.baidu.com/tikupc/singledetail/40aeb9d528ea81c758f5782f', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991605858271237', 'https://tiku.baidu.com/tikupc/singledetail/e19522c52cc58bd63186bdf9', '1025991565542621188', '0');
INSERT INTO `crawler_question` VALUES ('1025991605858271234', 'https://tiku.baidu.com/tikupc/singledetail/a412ff21dd36a32d737581a8', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991605950545922', 'https://tiku.baidu.com/tikupc/singledetail/f8969a6648d7c1c708a145f7', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991605950545923', 'https://tiku.baidu.com/tikupc/singledetail/cbfaf61fb7360b4c2e3f640a', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991605950545924', 'https://tiku.baidu.com/tikupc/singledetail/86ec6137ee06eff9aef8072f', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991606034432002', 'https://tiku.baidu.com/tikupc/singledetail/cd3852d380eb6294dd886c2f', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991606034432003', 'https://tiku.baidu.com/tikupc/singledetail/c122aec30c22590102029d27', '1025991565542621188', '0');
INSERT INTO `crawler_question` VALUES ('1025991606034432005', 'https://tiku.baidu.com/tikupc/singledetail/99034431b90d6c85ec3ac617', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991606034432004', 'https://tiku.baidu.com/tikupc/singledetail/64d99e3143323968011c922a', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991606072180737', 'https://tiku.baidu.com/tikupc/singledetail/d4b865ce050876323112120a', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991606072180738', 'https://tiku.baidu.com/tikupc/singledetail/60ee8bd63186bceb19e8bb2e', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991605484978178', 'https://tiku.baidu.com/tikupc/singledetail/e159f242336c1eb91a375d2f', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991606227369985', 'https://tiku.baidu.com/tikupc/singledetail/a9600b1c59eef8c75fbfb306', '1025991583938838531', '0');
INSERT INTO `crawler_question` VALUES ('1025991606239952897', 'https://tiku.baidu.com/tikupc/singledetail/60d18bd63186bceb19e8bb11', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991606239952898', 'https://tiku.baidu.com/tikupc/singledetail/92ddb14e852458fb770b560c', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991606273507329', 'https://tiku.baidu.com/tikupc/singledetail/9c1e7cd184254b35eefd3415', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991606273507330', 'https://tiku.baidu.com/tikupc/singledetail/ed6127d3240c844769eaee01', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991606273507331', 'https://tiku.baidu.com/tikupc/singledetail/60f3a66e58fafab069dc02e8', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991606428696578', 'https://tiku.baidu.com/tikupc/singledetail/cd2552d380eb6294dd886c32', '1025991583938838531', '0');
INSERT INTO `crawler_question` VALUES ('1025991606227369986', 'https://tiku.baidu.com/tikupc/singledetail/0f21c41755270722192ef720', '1025991565542621188', '0');
INSERT INTO `crawler_question` VALUES ('1025991606441279489', 'https://tiku.baidu.com/tikupc/singledetail/f3c019e8b8f67c1cfad6b82e', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991606441279490', 'https://tiku.baidu.com/tikupc/singledetail/9f60c850ad02de80d4d8402f', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991606458056706', 'https://tiku.baidu.com/tikupc/singledetail/c6ad3186bceb19e8b8f6ba7e', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991606458056707', 'https://tiku.baidu.com/tikupc/singledetail/45c766ec102de2bd960588f7', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991606470639618', 'https://tiku.baidu.com/tikupc/singledetail/287a31b765ce050876321306', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991606558720002', 'https://tiku.baidu.com/tikupc/singledetail/162576c66137ee06eff9182f', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991606558720004', 'https://tiku.baidu.com/tikupc/singledetail/f82043323968011ca3009114', '1025991583938838531', '0');
INSERT INTO `crawler_question` VALUES ('1025991606558720005', 'https://tiku.baidu.com/tikupc/singledetail/5ce0961ea76e58fafab0031d', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991606558720006', 'https://tiku.baidu.com/tikupc/singledetail/9e4f31126edb6f1aff001f78', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991606558720003', 'https://tiku.baidu.com/tikupc/singledetail/57d9f90f76c66137ee06192f', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991606596468738', 'https://tiku.baidu.com/tikupc/singledetail/6fced15abe23482fb4da4c13', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991606596468737', 'https://tiku.baidu.com/tikupc/singledetail/1906ba1aa8114431b90dd80f', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991606583885826', 'https://tiku.baidu.com/tikupc/singledetail/766addccda38376baf1fae0f', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991606701326337', 'https://tiku.baidu.com/tikupc/singledetail/d54464ce05087632311212f6', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991606701326338', 'https://tiku.baidu.com/tikupc/singledetail/6375783e0912a21614792914', '1025991583938838531', '0');
INSERT INTO `crawler_question` VALUES ('1025991606718103555', 'https://tiku.baidu.com/tikupc/singledetail/8132376baf1ffc4ffe47ac0f', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991606718103556', 'https://tiku.baidu.com/tikupc/singledetail/7ce40975f46527d3240ce00d', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991606718103553', 'https://tiku.baidu.com/tikupc/singledetail/49ecb8f67c1cfad6195fa701', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991606718103554', 'https://tiku.baidu.com/tikupc/singledetail/8a5ba8114431b90d6c85c744', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991606806183937', 'https://tiku.baidu.com/tikupc/singledetail/bbee01d8ce2f0066f53322e9', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991606827155457', 'https://tiku.baidu.com/tikupc/singledetail/a6e58562caaedd3383c4d366', '1025991583938838531', '0');
INSERT INTO `crawler_question` VALUES ('1025991606856515585', 'https://tiku.baidu.com/tikupc/singledetail/7fb6bceb19e8b8f67c1cb935', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991606856515586', 'https://tiku.baidu.com/tikupc/singledetail/1dd96294dd88d0d233d46a37', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991606885875714', 'https://tiku.baidu.com/tikupc/singledetail/f450cc7931b765ce05081444', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991606923624450', 'https://tiku.baidu.com/tikupc/singledetail/20de551810a6f524ccbf8531', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991606923624451', 'https://tiku.baidu.com/tikupc/singledetail/ced880eb6294dd88d0d26b0e', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991606923624452', 'https://tiku.baidu.com/tikupc/singledetail/283831b765ce050876321344', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991606923624449', 'https://tiku.baidu.com/tikupc/singledetail/17c15ef7ba0d4a7302763a2b', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991607129145346', 'https://tiku.baidu.com/tikupc/singledetail/9ddc2e3f5727a5e9856a6195', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991607221420034', 'https://tiku.baidu.com/tikupc/singledetail/53e3b9f3f90f76c661371a33', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991607280140289', 'https://tiku.baidu.com/tikupc/singledetail/53ca6729647d27284b735145', '1025991584337297410', '0');
INSERT INTO `crawler_question` VALUES ('1025991607280140292', 'https://tiku.baidu.com/tikupc/singledetail/022369dc5022aaea998f0f96', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991607280140291', 'https://tiku.baidu.com/tikupc/singledetail/57c7f90f76c66137ee061931', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991607280140290', 'https://tiku.baidu.com/tikupc/singledetail/d8086edb6f1aff00bed51e1f', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991607380803586', 'https://tiku.baidu.com/tikupc/singledetail/a51aa32d7375a417866f8f29', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991607435329537', 'https://tiku.baidu.com/tikupc/singledetail/982a6337ee06eff9aef807e9', '1025991584337297410', '0');
INSERT INTO `crawler_question` VALUES ('1025991607435329538', 'https://tiku.baidu.com/tikupc/singledetail/7ecebb68a98271fe910ef9c1', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991607464689666', 'https://tiku.baidu.com/tikupc/singledetail/1c32eff9aef8941ea76e0531', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991607464689667', 'https://tiku.baidu.com/tikupc/singledetail/621ab7360b4c2e3f57276300', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991607619878914', 'https://tiku.baidu.com/tikupc/singledetail/da1abe64783e0912a2162a36', '1025991584337297410', '0');
INSERT INTO `crawler_question` VALUES ('1025991607619878916', 'https://tiku.baidu.com/tikupc/singledetail/4094b9d528ea81c758f57815', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991607619878917', 'https://tiku.baidu.com/tikupc/singledetail/90f05022aaea998fcc220e29', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991607619878915', 'https://tiku.baidu.com/tikupc/singledetail/6f46d15abe23482fb4da4c9b', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991607653433345', 'https://tiku.baidu.com/tikupc/singledetail/6589a0116c175f0e7cd13701', '1025991584135970819', '0');
INSERT INTO `crawler_question` VALUES ('1025991607817011201', 'https://tiku.baidu.com/tikupc/singledetail/00ef76eeaeaad1f346933f39', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991607879925762', 'https://tiku.baidu.com/tikupc/singledetail/8eb1a26925c52cc58bd6bec9', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991607888314370', 'https://tiku.baidu.com/tikupc/singledetail/abc2bb4cf7ec4afe04a1df03', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991607900897282', 'https://tiku.baidu.com/tikupc/singledetail/1a52a1116c175f0e7cd137da', '1025991584135970819', '0');
INSERT INTO `crawler_question` VALUES ('1025991607900897283', 'https://tiku.baidu.com/tikupc/singledetail/ae0c5f0e7cd184254b35351e', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991607900897284', 'https://tiku.baidu.com/tikupc/singledetail/22180b4c2e3f5727a5e9622b', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991607900897285', 'https://tiku.baidu.com/tikupc/singledetail/dbc5bf64783e0912a2162ae9', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991607900897286', 'https://tiku.baidu.com/tikupc/singledetail/5892ec3a87c24028915fc312', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991608026726402', 'https://tiku.baidu.com/tikupc/singledetail/f35777232f60ddccda38a003', '1025991567354560516', '0');
INSERT INTO `crawler_question` VALUES ('1025991608026726403', 'https://tiku.baidu.com/tikupc/singledetail/111e0b4e767f5acfa1c7cd0d', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991608077058051', 'https://tiku.baidu.com/tikupc/singledetail/4a4b5acfa1c7aa00b52acb31', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991608077058052', 'https://tiku.baidu.com/tikupc/singledetail/b447a98271fe910ef12df82a', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991608077058054', 'https://tiku.baidu.com/tikupc/singledetail/14ae1cd9ad51f01dc281f1cd', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991608077058053', 'https://tiku.baidu.com/tikupc/singledetail/64143169a45177232f60a23a', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991608077058050', 'https://tiku.baidu.com/tikupc/singledetail/aaa3f11dc281e53a5802fff7', '1025991585041940482', '0');
INSERT INTO `crawler_question` VALUES ('1025991608135778306', 'https://tiku.baidu.com/tikupc/singledetail/7f80bceb19e8b8f67c1cb903', '1025991567354560516', '0');
INSERT INTO `crawler_question` VALUES ('1025991608215470082', 'https://tiku.baidu.com/tikupc/singledetail/ecb5dd3383c4bb4cf7ecd11e', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991608316133379', 'https://tiku.baidu.com/tikupc/singledetail/358784868762caaedd33d40a', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991608316133378', 'https://tiku.baidu.com/tikupc/singledetail/9263f7ec4afe04a1b071de2a', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991608316133377', 'https://tiku.baidu.com/tikupc/singledetail/690e0440be1e650e52ea9909', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991608316133380', 'https://tiku.baidu.com/tikupc/singledetail/1dc66294dd88d0d233d46a28', '1025991567354560516', '0');
INSERT INTO `crawler_question` VALUES ('1025991608316133381', 'https://tiku.baidu.com/tikupc/singledetail/9266f7ec4afe04a1b071de2f', '1025991585171963906', '0');
INSERT INTO `crawler_question` VALUES ('1025991608370659330', 'https://tiku.baidu.com/tikupc/singledetail/838c0508763231126edb1147', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991608391630850', 'https://tiku.baidu.com/tikupc/singledetail/a53aa32d7375a417866f8f09', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991608450351105', 'https://tiku.baidu.com/tikupc/singledetail/1f17af45b307e87101f69633', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991608450351107', 'https://tiku.baidu.com/tikupc/singledetail/9f7ac850ad02de80d4d84035', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991608500682754', 'https://tiku.baidu.com/tikupc/singledetail/259c13a6f524ccbff1218481', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991608500682753', 'https://tiku.baidu.com/tikupc/singledetail/1d3b453610661ed9ad51f310', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991608500682755', 'https://tiku.baidu.com/tikupc/singledetail/1be0700abb68a98271fefa19', '1025991585171963906', '0');
INSERT INTO `crawler_question` VALUES ('1025991608513265666', 'https://tiku.baidu.com/tikupc/singledetail/fa61b84ae45c3b3567ec8b0b', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991608513265665', 'https://tiku.baidu.com/tikupc/singledetail/35cb84868762caaedd33d446', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991608580374530', 'https://tiku.baidu.com/tikupc/singledetail/20d8551810a6f524ccbf8537', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991608530042881', 'https://tiku.baidu.com/tikupc/singledetail/9f58c850ad02de80d4d84017', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991608618123265', 'https://tiku.baidu.com/tikupc/singledetail/801bccbff121dd36a32d823a', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991608672649219', 'https://tiku.baidu.com/tikupc/singledetail/526fb8f3f90f76c661371abf', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991608672649218', 'https://tiku.baidu.com/tikupc/singledetail/02ab69dc5022aaea998f0f1e', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991608672649220', 'https://tiku.baidu.com/tikupc/singledetail/e91ca21614791711cc79170b', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991608672649221', 'https://tiku.baidu.com/tikupc/singledetail/984f69eae009581b6bd9eb0d', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991608752340994', 'https://tiku.baidu.com/tikupc/singledetail/e86125c52cc58bd63186bd0d', '1025991567685910530', '0');
INSERT INTO `crawler_question` VALUES ('1025991608764923906', 'https://tiku.baidu.com/tikupc/singledetail/22170b4c2e3f5727a5e96224', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991608815255553', 'https://tiku.baidu.com/tikupc/singledetail/5fadf08583d049649b6658b9', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991608815255554', 'https://tiku.baidu.com/tikupc/singledetail/151a90c69ec3d5bbfd0a741a', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991608836227074', 'https://tiku.baidu.com/tikupc/singledetail/c88ee53a580216fc700afd0a', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991608836227075', 'https://tiku.baidu.com/tikupc/singledetail/7605b90d6c85ec3a87c2c531', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991608890753025', 'https://tiku.baidu.com/tikupc/singledetail/7fb2bceb19e8b8f67c1cb931', '1025991567685910530', '0');
INSERT INTO `crawler_question` VALUES ('1025991608911724545', 'https://tiku.baidu.com/tikupc/singledetail/9d6d2e3f5727a5e9856a6124', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991608953667586', 'https://tiku.baidu.com/tikupc/singledetail/b403f111f18583d049645931', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991608928501762', 'https://tiku.baidu.com/tikupc/singledetail/00e476eeaeaad1f346933f32', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991609020776449', 'https://tiku.baidu.com/tikupc/singledetail/d243f78a6529647d2728524d', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991609033359361', 'https://tiku.baidu.com/tikupc/singledetail/7a3e79563c1ec5da50e27031', '1025991567685910530', '0');
INSERT INTO `crawler_question` VALUES ('1025991609100468225', 'https://tiku.baidu.com/tikupc/singledetail/8a366c85ec3a87c24028c43e', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991609100468226', 'https://tiku.baidu.com/tikupc/singledetail/543816fc700abb68a982fb3f', '1025991585482342402', '0');
INSERT INTO `crawler_question` VALUES ('1025991609113051137', 'https://tiku.baidu.com/tikupc/singledetail/036b482fb4daa58da0114a4d', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991609192742915', 'https://tiku.baidu.com/tikupc/singledetail/7679ddccda38376baf1fae1c', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991609192742914', 'https://tiku.baidu.com/tikupc/singledetail/cf270e225901020207409ce1', '1025991585482342402', '0');
INSERT INTO `crawler_question` VALUES ('1025991609255657474', 'https://tiku.baidu.com/tikupc/singledetail/64f1f524ccbff121dd368352', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991609289211906', 'https://tiku.baidu.com/tikupc/singledetail/5cb851e79b89680203d82524', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991609364709377', 'https://tiku.baidu.com/tikupc/singledetail/1f14561252d380eb62946d7b', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991609364709379', 'https://tiku.baidu.com/tikupc/singledetail/c27925284b73f242336c5f01', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991609477955586', 'https://tiku.baidu.com/tikupc/singledetail/53675afafab069dc5022010c', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991609515704321', 'https://tiku.baidu.com/tikupc/singledetail/1a36710abb68a98271fefacf', '1025991585985658881', '0');
INSERT INTO `crawler_question` VALUES ('1025991609553453058', 'https://tiku.baidu.com/tikupc/singledetail/a479ba4cf7ec4afe04a1dfb8', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991609553453059', 'https://tiku.baidu.com/tikupc/singledetail/f678b4daa58da0116c174952', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991609553453060', 'https://tiku.baidu.com/tikupc/singledetail/69a0bf1e650e52ea551898e5', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991609599590402', 'https://tiku.baidu.com/tikupc/singledetail/0cb96bdc5022aaea998f0f0c', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991609637339139', 'https://tiku.baidu.com/tikupc/singledetail/8f34ecfdc8d376eeaeaa3104', '1025991585985658881', '0');
INSERT INTO `crawler_question` VALUES ('1025991609704448001', 'https://tiku.baidu.com/tikupc/singledetail/6f7b2dc58bd63186bcebbcbb', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991609704448002', 'https://tiku.baidu.com/tikupc/singledetail/839af12d2af90242a895e591', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991609704448003', 'https://tiku.baidu.com/tikupc/singledetail/88066e85ec3a87c24028c40e', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991609704448004', 'https://tiku.baidu.com/tikupc/singledetail/963ead00b52acfc789ebc9fc', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991609758973953', 'https://tiku.baidu.com/tikupc/singledetail/58a9ec3a87c24028915fc329', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991609851248643', 'https://tiku.baidu.com/tikupc/singledetail/6e41d05abe23482fb4da4c9c', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991609851248644', 'https://tiku.baidu.com/tikupc/singledetail/79c0aa5177232f60ddcca1ac', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991609851248642', 'https://tiku.baidu.com/tikupc/singledetail/615b900ef12d2af90242e6a0', '1025991586237317126', '0');
INSERT INTO `crawler_question` VALUES ('1025991609851248645', 'https://tiku.baidu.com/tikupc/singledetail/1de5fac75fbfc77da269b10e', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991609851248641', 'https://tiku.baidu.com/tikupc/singledetail/a86b185f312b3169a451a4b8', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991610140655622', 'https://tiku.baidu.com/tikupc/singledetail/15094193daef5ef7ba0d3cff', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991610140655621', 'https://tiku.baidu.com/tikupc/singledetail/2c17f8d6195f312b3169a50e', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991610258096129', 'https://tiku.baidu.com/tikupc/singledetail/14ba91c69ec3d5bbfd0a74ba', '1025991586472198147', '0');
INSERT INTO `crawler_question` VALUES ('1025991610140655620', 'https://tiku.baidu.com/tikupc/singledetail/b83480c758f5f61fb73666db', '1025991586237317126', '0');
INSERT INTO `crawler_question` VALUES ('1025991610140655618', 'https://tiku.baidu.com/tikupc/singledetail/d03666db6f1aff00bed51e21', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991610140655619', 'https://tiku.baidu.com/tikupc/singledetail/42d526fff705cc1755270901', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991610321010690', 'https://tiku.baidu.com/tikupc/singledetail/cd2c55270722192e4536f63e', '1025991586614804484', '0');
INSERT INTO `crawler_question` VALUES ('1025991610472005634', 'https://tiku.baidu.com/tikupc/singledetail/69dfbf1e650e52ea5518989a', '1025991586472198147', '0');
INSERT INTO `crawler_question` VALUES ('1025991610472005636', 'https://tiku.baidu.com/tikupc/singledetail/02cd492fb4daa58da0114aeb', '1025991586237317126', '0');
INSERT INTO `crawler_question` VALUES ('1025991610472005639', 'https://tiku.baidu.com/tikupc/singledetail/a429ba4cf7ec4afe04a1dfe8', '1025991568155672579', '0');
INSERT INTO `crawler_question` VALUES ('1025991610472005635', 'https://tiku.baidu.com/tikupc/singledetail/d7328e6fb84ae45c3b358c20', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991610472005638', 'https://tiku.baidu.com/tikupc/singledetail/7e0fbb68a98271fe910ef900', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991610472005637', 'https://tiku.baidu.com/tikupc/singledetail/67e8a45177232f60ddcca184', '1025991586614804484', '0');
INSERT INTO `crawler_question` VALUES ('1025991610572668929', 'https://tiku.baidu.com/tikupc/singledetail/160d76c66137ee06eff91807', '1025991586870657025', '0');
INSERT INTO `crawler_question` VALUES ('1025991610589446146', 'https://tiku.baidu.com/tikupc/singledetail/6c2e0740be1e650e52ea9929', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991610635583491', 'https://tiku.baidu.com/tikupc/singledetail/09c6a78da0116c175f0e4819', '1025991568155672579', '0');
INSERT INTO `crawler_question` VALUES ('1025991610635583490', 'https://tiku.baidu.com/tikupc/singledetail/c261647d27284b73f242504d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991610635583492', 'https://tiku.baidu.com/tikupc/singledetail/478e978fcc22bcd126ff0c61', '1025991586237317126', '0');
INSERT INTO `crawler_question` VALUES ('1025991610635583493', 'https://tiku.baidu.com/tikupc/singledetail/ff7ffc563c1ec5da50e27070', '1025991553672740866', '0');
INSERT INTO `crawler_question` VALUES ('1025991610690109441', 'https://tiku.baidu.com/tikupc/singledetail/7634b90d6c85ec3a87c2c500', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991610690109442', 'https://tiku.baidu.com/tikupc/singledetail/be116bec0975f46527d3e181', '1025991586614804484', '0');
INSERT INTO `crawler_question` VALUES ('1025991610589446145', 'https://tiku.baidu.com/tikupc/singledetail/6724d5d8d15abe23482f4da1', '1025991567962734595', '0');
INSERT INTO `crawler_question` VALUES ('1025991610711080961', 'https://tiku.baidu.com/tikupc/singledetail/4d6f312b3169a4517723a335', '1025991586870657025', '0');
INSERT INTO `crawler_question` VALUES ('1025991610723663873', 'https://tiku.baidu.com/tikupc/singledetail/261d10a6f524ccbff1218400', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991610794967041', 'https://tiku.baidu.com/tikupc/singledetail/f4951511cc7931b765ce15e9', '1025991568155672579', '0');
INSERT INTO `crawler_question` VALUES ('1025991610824327171', 'https://tiku.baidu.com/tikupc/singledetail/b416f111f18583d049645924', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991610824327170', 'https://tiku.baidu.com/tikupc/singledetail/bd306aec0975f46527d3e1a0', '1025991586472198147', '0');
INSERT INTO `crawler_question` VALUES ('1025991610832715778', 'https://tiku.baidu.com/tikupc/singledetail/42d1d0d233d4b14e8524685c', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991610807549953', 'https://tiku.baidu.com/tikupc/singledetail/22000b4c2e3f5727a5e96233', '1025991587101343747', '0');
INSERT INTO `crawler_question` VALUES ('1025991610841104386', 'https://tiku.baidu.com/tikupc/singledetail/304b767f5acfa1c7aa00cc00', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991611067596801', 'https://tiku.baidu.com/tikupc/singledetail/27c111a6f524ccbff12184dc', '1025991586472198147', '0');
INSERT INTO `crawler_question` VALUES ('1025991611050819587', 'https://tiku.baidu.com/tikupc/singledetail/cf22a5e9856a561252d36f00', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991611067596802', 'https://tiku.baidu.com/tikupc/singledetail/3eb10242a8956bec0975e34d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991611084374018', 'https://tiku.baidu.com/tikupc/singledetail/ff66a8c30c22590102029d63', '1025991568155672579', '0');
INSERT INTO `crawler_question` VALUES ('1025991611067596803', 'https://tiku.baidu.com/tikupc/singledetail/650ca0116c175f0e7cd13784', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991611050819586', 'https://tiku.baidu.com/tikupc/singledetail/241812a6f524ccbff1218405', '1025991587101343747', '0');
INSERT INTO `crawler_question` VALUES ('1025991611126317058', 'https://tiku.baidu.com/tikupc/singledetail/19260066f5335a8102d2200c', '1025991586870657025', '0');
INSERT INTO `crawler_question` VALUES ('1025991611206008834', 'https://tiku.baidu.com/tikupc/singledetail/5947336c1eb91a37f1115c00', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991611206008835', 'https://tiku.baidu.com/tikupc/singledetail/32d449649b6648d7c1c74601', '1025991587357196290', '0');
INSERT INTO `crawler_question` VALUES ('1025991611214397444', 'https://tiku.baidu.com/tikupc/singledetail/a6ec82c758f5f61fb7366603', '1025991587101343747', '0');
INSERT INTO `crawler_question` VALUES ('1025991611214397443', 'https://tiku.baidu.com/tikupc/singledetail/41a44b35eefdc8d376ee3284', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991611214397442', 'https://tiku.baidu.com/tikupc/singledetail/4b917f19227916888486d74d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991611214397445', 'https://tiku.baidu.com/tikupc/singledetail/4f82680203d8ce2f0066230e', '1025991586870657025', '0');
INSERT INTO `crawler_question` VALUES ('1025991611273117698', 'https://tiku.baidu.com/tikupc/singledetail/47356bd97f1922791688e82b', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991611285700609', 'https://tiku.baidu.com/tikupc/singledetail/58a8ec3a87c24028915fc328', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991611285700610', 'https://tiku.baidu.com/tikupc/singledetail/e230763231126edb6f1a103d', '1025991587357196290', '0');
INSERT INTO `crawler_question` VALUES ('1025991611457667074', 'https://tiku.baidu.com/tikupc/singledetail/92c8f7ec4afe04a1b071de81', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991611466055681', 'https://tiku.baidu.com/tikupc/singledetail/7fe20a75f46527d3240ce00b', '1025991587101343747', '0');
INSERT INTO `crawler_question` VALUES ('1025991611466055682', 'https://tiku.baidu.com/tikupc/singledetail/1f0faf45b307e87101f6962b', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991611466055683', 'https://tiku.baidu.com/tikupc/singledetail/1157872458fb770bf78a551c', '1025991587357196290', '0');
INSERT INTO `crawler_question` VALUES ('1025991611474444290', 'https://tiku.baidu.com/tikupc/singledetail/f667b4daa58da0116c17494d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991611541553153', 'https://tiku.baidu.com/tikupc/singledetail/b97f2b160b4e767f5acfce37', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991611604467714', 'https://tiku.baidu.com/tikupc/singledetail/cbc4172ded630b1c59eeb52a', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991611604467713', 'https://tiku.baidu.com/tikupc/singledetail/37058c4769eae009581bec0c', '1025991587101343747', '0');
INSERT INTO `crawler_question` VALUES ('1025991611587690497', 'https://tiku.baidu.com/tikupc/singledetail/da407375a417866fb84a8e68', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991611633827841', 'https://tiku.baidu.com/tikupc/singledetail/f43dcc7931b765ce05081429', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991611679965186', 'https://tiku.baidu.com/tikupc/singledetail/9a573b3567ec102de2bd890e', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991611717713921', 'https://tiku.baidu.com/tikupc/singledetail/2f762f60ddccda38376baf50', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991611734491138', 'https://tiku.baidu.com/tikupc/singledetail/4a525acfa1c7aa00b52acb28', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991611805794306', 'https://tiku.baidu.com/tikupc/singledetail/7803dfccda38376baf1fae66', '1025991568860315649', '0');
INSERT INTO `crawler_question` VALUES ('1025991611814182913', 'https://tiku.baidu.com/tikupc/singledetail/24233968011ca300a6c39014', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991611814182914', 'https://tiku.baidu.com/tikupc/singledetail/1bcf700abb68a98271fefa36', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991611847737347', 'https://tiku.baidu.com/tikupc/singledetail/345702020740be1e650e9a53', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991611847737346', 'https://tiku.baidu.com/tikupc/singledetail/984069eae009581b6bd9eb02', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991611898068994', 'https://tiku.baidu.com/tikupc/singledetail/63b0ce22bcd126fff7050b3a', '1025991568860315649', '0');
INSERT INTO `crawler_question` VALUES ('1025991611898068995', 'https://tiku.baidu.com/tikupc/singledetail/a15433687e21af45b307a816', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991611898068996', 'https://tiku.baidu.com/tikupc/singledetail/343502020740be1e650e9a31', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991611973566465', 'https://tiku.baidu.com/tikupc/singledetail/eca9dd3383c4bb4cf7ecd102', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991612015509506', 'https://tiku.baidu.com/tikupc/singledetail/0419192e453610661ed9f43e', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991612023898113', 'https://tiku.baidu.com/tikupc/singledetail/66c65b0102020740be1e9be1', '1025991568860315649', '0');
INSERT INTO `crawler_question` VALUES ('1025991612015509507', 'https://tiku.baidu.com/tikupc/singledetail/8a35a8114431b90d6c85c72a', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991612074229761', 'https://tiku.baidu.com/tikupc/singledetail/ba95f121dd36a32d7375812f', '1025991587860512773', '0');
INSERT INTO `crawler_question` VALUES ('1025991612099395585', 'https://tiku.baidu.com/tikupc/singledetail/764eddccda38376baf1fae2b', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991612099395586', 'https://tiku.baidu.com/tikupc/singledetail/0436192e453610661ed9f411', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991612204253189', 'https://tiku.baidu.com/tikupc/singledetail/cef880eb6294dd88d0d26b2e', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991612204253186', 'https://tiku.baidu.com/tikupc/singledetail/5410f80f76c66137ee0619e6', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991612204253187', 'https://tiku.baidu.com/tikupc/singledetail/094da417866fb84ae45c8d3d', '1025991587860512773', '0');
INSERT INTO `crawler_question` VALUES ('1025991612204253188', 'https://tiku.baidu.com/tikupc/singledetail/95f76b85ec3a87c24028c4ff', '1025991568860315649', '0');
INSERT INTO `crawler_question` VALUES ('1025991612204253191', 'https://tiku.baidu.com/tikupc/singledetail/9d59ca50ad02de80d4d84016', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991612292333570', 'https://tiku.baidu.com/tikupc/singledetail/4e5f59eef8c75fbfc77db246', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991612338470914', 'https://tiku.baidu.com/tikupc/singledetail/42a3d0d233d4b14e8524682e', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991612338470915', 'https://tiku.baidu.com/tikupc/singledetail/429ad0d233d4b14e85246817', '1025991587860512773', '0');
INSERT INTO `crawler_question` VALUES ('1025991612346859522', 'https://tiku.baidu.com/tikupc/singledetail/4b55332b3169a4517723a30f', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991612346859523', 'https://tiku.baidu.com/tikupc/singledetail/c0154b323968011ca3009121', '1025991568860315649', '0');
INSERT INTO `crawler_question` VALUES ('1025991612346859524', 'https://tiku.baidu.com/tikupc/singledetail/c0003386bceb19e8b8f6bad3', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991612434939906', 'https://tiku.baidu.com/tikupc/singledetail/801eccbff121dd36a32d823f', '1025991587860512773', '0');
INSERT INTO `crawler_question` VALUES ('1025991612434939905', 'https://tiku.baidu.com/tikupc/singledetail/ba93f121dd36a32d73758129', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991612485271553', 'https://tiku.baidu.com/tikupc/singledetail/15b753ea551810a6f52486bc', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991612531408898', 'https://tiku.baidu.com/tikupc/singledetail/4d74312b3169a4517723a32e', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991612531408899', 'https://tiku.baidu.com/tikupc/singledetail/ae015f0e7cd184254b353513', '1025991587860512773', '0');
INSERT INTO `crawler_question` VALUES ('1025991612556574721', 'https://tiku.baidu.com/tikupc/singledetail/9f401eb91a37f111f1855b29', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991612564963330', 'https://tiku.baidu.com/tikupc/singledetail/dbe1524de518964bcf847c06', '1025991588170891265', '0');
INSERT INTO `crawler_question` VALUES ('1025991612577546243', 'https://tiku.baidu.com/tikupc/singledetail/1854cf84b9d528ea81c7791a', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991612602712066', 'https://tiku.baidu.com/tikupc/singledetail/d1a7640e52ea551810a687bc', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991612627877889', 'https://tiku.baidu.com/tikupc/singledetail/ecaadd3383c4bb4cf7ecd101', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991612627877890', 'https://tiku.baidu.com/tikupc/singledetail/61f904a1b0717fd5360cdc02', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991612665626625', 'https://tiku.baidu.com/tikupc/singledetail/c21d647d27284b73f2425031', '1025991588170891265', '0');
INSERT INTO `crawler_question` VALUES ('1025991612682403842', 'https://tiku.baidu.com/tikupc/singledetail/cbac172ded630b1c59eeb542', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991612690792449', 'https://tiku.baidu.com/tikupc/singledetail/51d6360cba1aa8114431d906', '1025991588305108993', '0');
INSERT INTO `crawler_question` VALUES ('1025991612715958273', 'https://tiku.baidu.com/tikupc/singledetail/9248f7ec4afe04a1b071de01', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991612757901313', 'https://tiku.baidu.com/tikupc/singledetail/da217375a417866fb84a8e09', '1025991588170891265', '0');
INSERT INTO `crawler_question` VALUES ('1025991612783067138', 'https://tiku.baidu.com/tikupc/singledetail/20ca551810a6f524ccbf8525', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991612783067139', 'https://tiku.baidu.com/tikupc/singledetail/6030590102020740be1e9b17', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991612783067140', 'https://tiku.baidu.com/tikupc/singledetail/9a5a3b3567ec102de2bd8903', '1025991588032479233', '0');
INSERT INTO `crawler_question` VALUES ('1025991612783067141', 'https://tiku.baidu.com/tikupc/singledetail/a57df01dc281e53a5802ff29', '1025991588305108993', '0');
INSERT INTO `crawler_question` VALUES ('1025991612854370308', 'https://tiku.baidu.com/tikupc/singledetail/6009590102020740be1e9b2e', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991612854370306', 'https://tiku.baidu.com/tikupc/singledetail/f6751711cc7931b765ce1509', '1025991588170891265', '0');
INSERT INTO `crawler_question` VALUES ('1025991612862758913', 'https://tiku.baidu.com/tikupc/singledetail/64b4f524ccbff121dd368317', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991612854370307', 'https://tiku.baidu.com/tikupc/singledetail/304d767f5acfa1c7aa00cc06', '1025991588615487491', '0');
INSERT INTO `crawler_question` VALUES ('1025991612862758914', 'https://tiku.baidu.com/tikupc/singledetail/b559c5da50e2524de5187e42', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991612908896258', 'https://tiku.baidu.com/tikupc/singledetail/f3df19e8b8f67c1cfad6b831', '1025991588032479233', '0');
INSERT INTO `crawler_question` VALUES ('1025991612925673473', 'https://tiku.baidu.com/tikupc/singledetail/f931c281e53a580216fcfe29', '1025991588305108993', '0');
INSERT INTO `crawler_question` VALUES ('1025991612955033602', 'https://tiku.baidu.com/tikupc/singledetail/cbdef61fb7360b4c2e3f642e', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991612963422209', 'https://tiku.baidu.com/tikupc/singledetail/913fe2bd960590c69ec37617', '1025991588170891265', '0');
INSERT INTO `crawler_question` VALUES ('1025991612980199427', 'https://tiku.baidu.com/tikupc/singledetail/c558e45c3b3567ec102d8a17', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991612980199426', 'https://tiku.baidu.com/tikupc/singledetail/a0818762caaedd3383c4d302', '1025991588615487491', '0');
INSERT INTO `crawler_question` VALUES ('1025991612988588033', 'https://tiku.baidu.com/tikupc/singledetail/e24f763231126edb6f1a1042', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991613034725379', 'https://tiku.baidu.com/tikupc/singledetail/808502d276a20029bd642d01', '1025991588305108993', '0');
INSERT INTO `crawler_question` VALUES ('1025991613034725378', 'https://tiku.baidu.com/tikupc/singledetail/80b802d276a20029bd642d3c', '1025991588032479233', '0');
INSERT INTO `crawler_question` VALUES ('1025991613068279810', 'https://tiku.baidu.com/tikupc/singledetail/aaeef11dc281e53a5802ffba', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991613076668418', 'https://tiku.baidu.com/tikupc/singledetail/cbf9f61fb7360b4c2e3f6409', '1025991588615487491', '0');
INSERT INTO `crawler_question` VALUES ('1025991613135388675', 'https://tiku.baidu.com/tikupc/singledetail/90e55022aaea998fcc220e3c', '1025991588032479233', '0');
INSERT INTO `crawler_question` VALUES ('1025991613135388677', 'https://tiku.baidu.com/tikupc/singledetail/1356094e767f5acfa1c7cd45', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991613135388674', 'https://tiku.baidu.com/tikupc/singledetail/8322f12d2af90242a895e529', '1025991588305108993', '0');
INSERT INTO `crawler_question` VALUES ('1025991613215080452', 'https://tiku.baidu.com/tikupc/singledetail/7659ddccda38376baf1fae3c', '1025991588615487491', '0');
INSERT INTO `crawler_question` VALUES ('1025991613215080451', 'https://tiku.baidu.com/tikupc/singledetail/8a8acec789eb172ded63b7a5', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991613215080450', 'https://tiku.baidu.com/tikupc/singledetail/6d59be23482fb4daa58d4b06', '1025991588447715330', '0');
INSERT INTO `crawler_question` VALUES ('1025991613240246273', 'https://tiku.baidu.com/tikupc/singledetail/d734cc2f0066f5335a8121e9', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991613282189313', 'https://tiku.baidu.com/tikupc/singledetail/d44bf58a6529647d27285245', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991613290577922', 'https://tiku.baidu.com/tikupc/singledetail/28aa48d7c1c708a1284a44c9', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991613290577923', 'https://tiku.baidu.com/tikupc/singledetail/28b6b0717fd5360cba1adb12', '1025991588032479233', '0');
INSERT INTO `crawler_question` VALUES ('1025991613340909572', 'https://tiku.baidu.com/tikupc/singledetail/e15ff242336c1eb91a375d29', '1025991588447715330', '0');
INSERT INTO `crawler_question` VALUES ('1025991613340909571', 'https://tiku.baidu.com/tikupc/singledetail/3dcb864769eae009581becc2', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991613340909570', 'https://tiku.baidu.com/tikupc/singledetail/2e08fad6195f312b3169a511', '1025991588615487491', '0');
INSERT INTO `crawler_question` VALUES ('1025991613403824129', 'https://tiku.baidu.com/tikupc/singledetail/2c975a8102d276a200292ea1', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991613437378562', 'https://tiku.baidu.com/tikupc/singledetail/f43acc7931b765ce0508142e', '1025991588825202690', '0');
INSERT INTO `crawler_question` VALUES ('1025991613437378563', 'https://tiku.baidu.com/tikupc/singledetail/df12866fb84ae45c3b358c00', '1025991588447715330', '0');
INSERT INTO `crawler_question` VALUES ('1025991613496098817', 'https://tiku.baidu.com/tikupc/singledetail/ac13b34e852458fb770b56c2', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991613546430466', 'https://tiku.baidu.com/tikupc/singledetail/7551e109581b6bd97f19eabe', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991613563207681', 'https://tiku.baidu.com/tikupc/singledetail/8e0a4b73f242336c1eb95e27', '1025991588825202690', '0');
INSERT INTO `crawler_question` VALUES ('1025991613563207682', 'https://tiku.baidu.com/tikupc/singledetail/2c365a8102d276a200292e00', '1025991588447715330', '0');
INSERT INTO `crawler_question` VALUES ('1025991613563207683', 'https://tiku.baidu.com/tikupc/singledetail/1d2a720abb68a98271fefad3', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991613647093762', 'https://tiku.baidu.com/tikupc/singledetail/76dcf2232f60ddccda38a08b', '1025991569858560001', '0');
INSERT INTO `crawler_question` VALUES ('1025991613647093761', 'https://tiku.baidu.com/tikupc/singledetail/f38cfd4ffe4733687e21aa96', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991613647093763', 'https://tiku.baidu.com/tikupc/singledetail/1dd2fac75fbfc77da269b139', '1025991588825202690', '0');
INSERT INTO `crawler_question` VALUES ('1025991613647093764', 'https://tiku.baidu.com/tikupc/singledetail/cde80c225901020207409c2e', '1025991589198495748', '0');
INSERT INTO `crawler_question` VALUES ('1025991613726785538', 'https://tiku.baidu.com/tikupc/singledetail/d5ddce2f0066f5335a812100', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991613756145665', 'https://tiku.baidu.com/tikupc/singledetail/160976c66137ee06eff91803', '1025991588447715330', '0');
INSERT INTO `crawler_question` VALUES ('1025991613798088706', 'https://tiku.baidu.com/tikupc/singledetail/cdfa0c225901020207409c3c', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991613806477314', 'https://tiku.baidu.com/tikupc/singledetail/1d6aaff8941ea76e58fa0496', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991613806477315', 'https://tiku.baidu.com/tikupc/singledetail/ed1b98c69ec3d5bbfd0a741b', '1025991588825202690', '0');
INSERT INTO `crawler_question` VALUES ('1025991613806477316', 'https://tiku.baidu.com/tikupc/singledetail/634f783e0912a2161479292e', '1025991589198495748', '0');
INSERT INTO `crawler_question` VALUES ('1025991613831643138', 'https://tiku.baidu.com/tikupc/singledetail/a958804d2b160b4e767fcf02', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991613877780482', 'https://tiku.baidu.com/tikupc/singledetail/ba85f121dd36a32d7375813f', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991613911334914', 'https://tiku.baidu.com/tikupc/singledetail/c6de3186bceb19e8b8f6ba0d', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991613911334913', 'https://tiku.baidu.com/tikupc/singledetail/20ec551810a6f524ccbf8503', '1025991589198495748', '0');
INSERT INTO `crawler_question` VALUES ('1025991613911334915', 'https://tiku.baidu.com/tikupc/singledetail/65d6cc22bcd126fff7050b5c', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991613911334916', 'https://tiku.baidu.com/tikupc/singledetail/b79fad2d7375a417866f8fac', '1025991588825202690', '0');
INSERT INTO `crawler_question` VALUES ('1025991613986832385', 'https://tiku.baidu.com/tikupc/singledetail/c94aa6c30c22590102029d4f', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991614066524162', 'https://tiku.baidu.com/tikupc/singledetail/dbcc524de518964bcf847c2b', '1025991589198495748', '0');
INSERT INTO `crawler_question` VALUES ('1025991614066524163', 'https://tiku.baidu.com/tikupc/singledetail/cbabf61fb7360b4c2e3f645b', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991614066524164', 'https://tiku.baidu.com/tikupc/singledetail/fb40c0c708a1284ac8504392', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991614066524165', 'https://tiku.baidu.com/tikupc/singledetail/5cb251e79b89680203d8252e', '1025991589404016643', '0');
INSERT INTO `crawler_question` VALUES ('1025991614100078594', 'https://tiku.baidu.com/tikupc/singledetail/cd48b307e87101f69e319508', '1025991569992777730', '0');
INSERT INTO `crawler_question` VALUES ('1025991614213324803', 'https://tiku.baidu.com/tikupc/singledetail/135f9fc3d5bbfd0a7956739c', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991614213324802', 'https://tiku.baidu.com/tikupc/singledetail/f1513c1ec5da50e2524d7f02', '1025991589198495748', '0');
INSERT INTO `crawler_question` VALUES ('1025991614213324804', 'https://tiku.baidu.com/tikupc/singledetail/e7c1102de2bd960590c67728', '1025991589404016643', '0');
INSERT INTO `crawler_question` VALUES ('1025991614213324801', 'https://tiku.baidu.com/tikupc/singledetail/f3d777232f60ddccda38a083', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991614280433666', 'https://tiku.baidu.com/tikupc/singledetail/f17a3c1ec5da50e2524d7f29', '1025991589689229313', '0');
INSERT INTO `crawler_question` VALUES ('1025991614347542529', 'https://tiku.baidu.com/tikupc/singledetail/1864ac51f01dc281e53af0b8', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991614347542530', 'https://tiku.baidu.com/tikupc/singledetail/1307bed5b9f3f90f76c61b02', '1025991589404016643', '0');
INSERT INTO `crawler_question` VALUES ('1025991614393679873', 'https://tiku.baidu.com/tikupc/singledetail/1f46561252d380eb62946d29', '1025991589689229313', '0');
INSERT INTO `crawler_question` VALUES ('1025991614481760257', 'https://tiku.baidu.com/tikupc/singledetail/808d02d276a20029bd642d09', '1025991589404016643', '0');
INSERT INTO `crawler_question` VALUES ('1025991614544674817', 'https://tiku.baidu.com/tikupc/singledetail/75054a7302768e9951e7380d', '1025991589689229313', '0');
INSERT INTO `crawler_question` VALUES ('1025991614666309633', 'https://tiku.baidu.com/tikupc/singledetail/5af2941ea76e58fafab0030f', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991614666309635', 'https://tiku.baidu.com/tikupc/singledetail/3fd0260c844769eae009ed06', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991614666309634', 'https://tiku.baidu.com/tikupc/singledetail/9a7b02768e9951e79b89270d', '1025991589689229313', '0');
INSERT INTO `crawler_question` VALUES ('1025991614695669762', 'https://tiku.baidu.com/tikupc/singledetail/5cff963143323968011c920c', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991614750195714', 'https://tiku.baidu.com/tikupc/singledetail/2dc1fbd6195f312b3169a5d8', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991614750195715', 'https://tiku.baidu.com/tikupc/singledetail/516458fafab069dc5022010f', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991614821498881', 'https://tiku.baidu.com/tikupc/singledetail/0b96cc81e53a580216fcfe89', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991614821498882', 'https://tiku.baidu.com/tikupc/singledetail/bd2803d8ce2f0066f533222f', '1025991589882167298', '0');
INSERT INTO `crawler_question` VALUES ('1025991614821498883', 'https://tiku.baidu.com/tikupc/singledetail/ab101b5f312b3169a451a4c3', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991614876024834', 'https://tiku.baidu.com/tikupc/singledetail/19eaad51f01dc281e53af036', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991614930550786', 'https://tiku.baidu.com/tikupc/singledetail/c4428dc4bb4cf7ec4afed074', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991614930550788', 'https://tiku.baidu.com/tikupc/singledetail/c885e53a580216fc700afd01', '1025991589882167298', '0');
INSERT INTO `crawler_question` VALUES ('1025991614930550789', 'https://tiku.baidu.com/tikupc/singledetail/45dc69d97f1922791688e8c2', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991614972493826', 'https://tiku.baidu.com/tikupc/singledetail/1af84693daef5ef7ba0d3c0e', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991614989271042', 'https://tiku.baidu.com/tikupc/singledetail/aa880029bd64783e09122b2f', '1025991590037356545', '0');
INSERT INTO `crawler_question` VALUES ('1025991615056379907', 'https://tiku.baidu.com/tikupc/singledetail/de41e518964bcf84b9d57b09', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991615056379909', 'https://tiku.baidu.com/tikupc/singledetail/1ca5aef8941ea76e58fa0459', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991615056379908', 'https://tiku.baidu.com/tikupc/singledetail/fad541323968011ca30091e1', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991615056379906', 'https://tiku.baidu.com/tikupc/singledetail/566c903143323968011c929f', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991615056379910', 'https://tiku.baidu.com/tikupc/singledetail/6833964bcf84b9d528ea7a2e', '1025991589882167298', '0');
INSERT INTO `crawler_question` VALUES ('1025991615140265986', 'https://tiku.baidu.com/tikupc/singledetail/fcd5c1c708a1284ac8504307', '1025991590465175554', '0');
INSERT INTO `crawler_question` VALUES ('1025991615140265987', 'https://tiku.baidu.com/tikupc/singledetail/99154431b90d6c85ec3ac601', '1025991590037356545', '0');
INSERT INTO `crawler_question` VALUES ('1025991615173820418', 'https://tiku.baidu.com/tikupc/singledetail/52a0fa0f76c66137ee061956', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991615194791938', 'https://tiku.baidu.com/tikupc/singledetail/f41ecc7931b765ce0508140a', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991615194791937', 'https://tiku.baidu.com/tikupc/singledetail/13ec58f5f61fb7360b4c652e', '1025991589882167298', '0');
INSERT INTO `crawler_question` VALUES ('1025991615173820417', 'https://tiku.baidu.com/tikupc/singledetail/fd9d17e8b8f67c1cfad6b873', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991615173820419', 'https://tiku.baidu.com/tikupc/singledetail/a869185f312b3169a451a4ba', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991615257706498', 'https://tiku.baidu.com/tikupc/singledetail/8c5f01f69e3143323968932b', '1025991590465175554', '0');
INSERT INTO `crawler_question` VALUES ('1025991615257706497', 'https://tiku.baidu.com/tikupc/singledetail/cd41b307e87101f69e319501', '1025991590037356545', '0');
INSERT INTO `crawler_question` VALUES ('1025991615257706500', 'https://tiku.baidu.com/tikupc/singledetail/ade4b24e852458fb770b5635', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991615303843843', 'https://tiku.baidu.com/tikupc/singledetail/20fa551810a6f524ccbf8515', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991615303843842', 'https://tiku.baidu.com/tikupc/singledetail/6ff3d15abe23482fb4da4c2e', '1025991589882167298', '0');
INSERT INTO `crawler_question` VALUES ('1025991615303843844', 'https://tiku.baidu.com/tikupc/singledetail/3ecd854769eae009581becc4', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991615324815361', 'https://tiku.baidu.com/tikupc/singledetail/800fccbff121dd36a32d822e', '1025991590289014785', '0');
INSERT INTO `crawler_question` VALUES ('1025991615425478658', 'https://tiku.baidu.com/tikupc/singledetail/7636b90d6c85ec3a87c2c502', '1025991590465175554', '0');
INSERT INTO `crawler_question` VALUES ('1025991615425478660', 'https://tiku.baidu.com/tikupc/singledetail/8625dd36a32d7375a4178001', '1025991590037356545', '0');
INSERT INTO `crawler_question` VALUES ('1025991615425478659', 'https://tiku.baidu.com/tikupc/singledetail/1336bed5b9f3f90f76c61b33', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991615480004610', 'https://tiku.baidu.com/tikupc/singledetail/9f48c850ad02de80d4d84007', '1025991590695862273', '0');
INSERT INTO `crawler_question` VALUES ('1025991615480004611', 'https://tiku.baidu.com/tikupc/singledetail/913de2bd960590c69ec37615', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991615492587522', 'https://tiku.baidu.com/tikupc/singledetail/286348d7c1c708a1284a4400', '1025991590289014785', '0');
INSERT INTO `crawler_question` VALUES ('1025991615480004609', 'https://tiku.baidu.com/tikupc/singledetail/fe27581b6bd97f192279e92b', '1025991571293011971', '0');
INSERT INTO `crawler_question` VALUES ('1025991615492587521', 'https://tiku.baidu.com/tikupc/singledetail/46da6ad97f1922791688e8c4', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991615559696385', 'https://tiku.baidu.com/tikupc/singledetail/74ec08a1284ac850ad02422e', '1025991590037356545', '0');
INSERT INTO `crawler_question` VALUES ('1025991615559696386', 'https://tiku.baidu.com/tikupc/singledetail/a26bcaaedd3383c4bb4cd20c', '1025991590695862273', '0');
INSERT INTO `crawler_question` VALUES ('1025991615584862212', 'https://tiku.baidu.com/tikupc/singledetail/028869dc5022aaea998f0f3d', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991615584862211', 'https://tiku.baidu.com/tikupc/singledetail/fe0e581b6bd97f192279e902', '1025991590289014785', '0');
INSERT INTO `crawler_question` VALUES ('1025991615584862210', 'https://tiku.baidu.com/tikupc/singledetail/3cc7856a561252d380eb6e2b', '1025991571293011971', '0');
INSERT INTO `crawler_question` VALUES ('1025991615584862213', 'https://tiku.baidu.com/tikupc/singledetail/5fd82379168884868762d6c4', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991615584862209', 'https://tiku.baidu.com/tikupc/singledetail/60b2960590c69ec3d5bb750a', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991615723274243', 'https://tiku.baidu.com/tikupc/singledetail/514058fafab069dc5022012b', '1025991571293011971', '0');
INSERT INTO `crawler_question` VALUES ('1025991615534530562', 'https://tiku.baidu.com/tikupc/singledetail/9018ee06eff9aef8941e062a', '1025991590465175554', '0');
INSERT INTO `crawler_question` VALUES ('1025991615723274244', 'https://tiku.baidu.com/tikupc/singledetail/4d8f5bcfa1c7aa00b52acbf5', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991615723274242', 'https://tiku.baidu.com/tikupc/singledetail/608d960590c69ec3d5bb7535', '1025991590695862273', '0');
INSERT INTO `crawler_question` VALUES ('1025991615731662850', 'https://tiku.baidu.com/tikupc/singledetail/da277375a417866fb84a8e0f', '1025991590289014785', '0');
INSERT INTO `crawler_question` VALUES ('1025991615731662851', 'https://tiku.baidu.com/tikupc/singledetail/9417aa114431b90d6c85c708', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991615773605890', 'https://tiku.baidu.com/tikupc/singledetail/4145b8d528ea81c758f578c4', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991615756828674', 'https://tiku.baidu.com/tikupc/singledetail/80b202d276a20029bd642d36', '1025991591098515460', '0');
INSERT INTO `crawler_question` VALUES ('1025991615748440067', 'https://tiku.baidu.com/tikupc/singledetail/6210b7360b4c2e3f5727630a', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991615748440066', 'https://tiku.baidu.com/tikupc/singledetail/1786c77da26925c52cc5bf3c', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991615773605891', 'https://tiku.baidu.com/tikupc/singledetail/74d3e009581b6bd97f19ea3c', '1025991590880411649', '0');
INSERT INTO `crawler_question` VALUES ('1025991615882657793', 'https://tiku.baidu.com/tikupc/singledetail/3cd9856a561252d380eb6e35', '1025991590695862273', '0');
INSERT INTO `crawler_question` VALUES ('1025991615882657794', 'https://tiku.baidu.com/tikupc/singledetail/bb0ec7da50e2524de5187e15', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991615958155265', 'https://tiku.baidu.com/tikupc/singledetail/e85925c52cc58bd63186bd35', '1025991590465175554', '0');
INSERT INTO `crawler_question` VALUES ('1025991615958155269', 'https://tiku.baidu.com/tikupc/singledetail/6c120740be1e650e52ea9915', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991615958155268', 'https://tiku.baidu.com/tikupc/singledetail/f47cfe4ffe4733687e21aa66', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991615958155270', 'https://tiku.baidu.com/tikupc/singledetail/4af12efff705cc1755270925', '1025991590880411649', '0');
INSERT INTO `crawler_question` VALUES ('1025991615958155267', 'https://tiku.baidu.com/tikupc/singledetail/a2a1f921dd36a32d7375811b', '1025991591098515460', '0');
INSERT INTO `crawler_question` VALUES ('1025991615958155266', 'https://tiku.baidu.com/tikupc/singledetail/90b4e3bd960590c69ec3769c', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991616000098306', 'https://tiku.baidu.com/tikupc/singledetail/29be49d7c1c708a1284a44dd', '1025991590695862273', '0');
INSERT INTO `crawler_question` VALUES ('1025991616104955908', 'https://tiku.baidu.com/tikupc/singledetail/4ab3302b3169a4517723a3e9', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991616104955909', 'https://tiku.baidu.com/tikupc/singledetail/c239647d27284b73f2425015', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991616104955907', 'https://tiku.baidu.com/tikupc/singledetail/0e9e5bf5f61fb7360b4c655c', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991616104955906', 'https://tiku.baidu.com/tikupc/singledetail/6f236b29647d27284b7351ac', '1025991590880411649', '0');
INSERT INTO `crawler_question` VALUES ('1025991616125927426', 'https://tiku.baidu.com/tikupc/singledetail/86986137ee06eff9aef8075b', '1025991571548864515', '0');
INSERT INTO `crawler_question` VALUES ('1025991616159481859', 'https://tiku.baidu.com/tikupc/singledetail/1837ac51f01dc281e53af0eb', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991616234979329', 'https://tiku.baidu.com/tikupc/singledetail/d058e87101f69e314332945a', '1025991571548864515', '0');
INSERT INTO `crawler_question` VALUES ('1025991616234979330', 'https://tiku.baidu.com/tikupc/singledetail/9796396baf1ffc4ffe47acab', '1025991590880411649', '0');
INSERT INTO `crawler_question` VALUES ('1025991616234979331', 'https://tiku.baidu.com/tikupc/singledetail/2e70cfd376eeaeaad1f33088', '1025991556474535938', '0');
INSERT INTO `crawler_question` VALUES ('1025991616557940738', 'https://tiku.baidu.com/tikupc/singledetail/1766a8956bec0975f465e221', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991616583106561', 'https://tiku.baidu.com/tikupc/singledetail/31d9777f5acfa1c7aa00cc92', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991616591495169', 'https://tiku.baidu.com/tikupc/singledetail/a0a6874d2b160b4e767fcffc', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991616658604034', 'https://tiku.baidu.com/tikupc/singledetail/1a4ca1116c175f0e7cd137c4', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991616658604035', 'https://tiku.baidu.com/tikupc/singledetail/9a793b3567ec102de2bd8920', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991616658604036', 'https://tiku.baidu.com/tikupc/singledetail/b212102ded630b1c59eeb5fc', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991616658604037', 'https://tiku.baidu.com/tikupc/singledetail/87b6dc36a32d7375a4178092', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991616750878722', 'https://tiku.baidu.com/tikupc/singledetail/93eef6ec4afe04a1b071dea7', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991616880902146', 'https://tiku.baidu.com/tikupc/singledetail/d10caa1614791711cc79171b', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991616880902145', 'https://tiku.baidu.com/tikupc/singledetail/e9d07c1cfad6195f312ba623', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991616880902147', 'https://tiku.baidu.com/tikupc/singledetail/7b9d78563c1ec5da50e27092', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991616880902148', 'https://tiku.baidu.com/tikupc/singledetail/318c777f5acfa1c7aa00ccc7', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991616893485057', 'https://tiku.baidu.com/tikupc/singledetail/786adfccda38376baf1fae0f', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991616960593921', 'https://tiku.baidu.com/tikupc/singledetail/b9cc81c758f5f61fb7366623', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991616960593922', 'https://tiku.baidu.com/tikupc/singledetail/477dbed528ea81c758f578fc', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991617019314178', 'https://tiku.baidu.com/tikupc/singledetail/be5b5ebfc77da26925c5b099', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991617019314177', 'https://tiku.baidu.com/tikupc/singledetail/808302d276a20029bd642d07', '1025991591899627522', '0');
INSERT INTO `crawler_question` VALUES ('1025991617019314179', 'https://tiku.baidu.com/tikupc/singledetail/b2201b37f111f18583d05a9c', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991617061257217', 'https://tiku.baidu.com/tikupc/singledetail/cc3327284b73f242336c5f4b', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991617090617346', 'https://tiku.baidu.com/tikupc/singledetail/3d7d846a561252d380eb6e91', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991617132560386', 'https://tiku.baidu.com/tikupc/singledetail/8418ff00bed5b9f3f90f1c07', '1025991591899627522', '0');
INSERT INTO `crawler_question` VALUES ('1025991617145143298', 'https://tiku.baidu.com/tikupc/singledetail/1caf571252d380eb62946dc0', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991617157726209', 'https://tiku.baidu.com/tikupc/singledetail/8a756c85ec3a87c24028c47d', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991617166114817', 'https://tiku.baidu.com/tikupc/singledetail/936ebb0d4a7302768e99399c', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991617224835073', 'https://tiku.baidu.com/tikupc/singledetail/7d7b0875f46527d3240ce092', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991617241612290', 'https://tiku.baidu.com/tikupc/singledetail/d02de87101f69e314332942f', '1025991591899627522', '0');
INSERT INTO `crawler_question` VALUES ('1025991617262583810', 'https://tiku.baidu.com/tikupc/singledetail/7ffebceb19e8b8f67c1cb97d', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991617321304066', 'https://tiku.baidu.com/tikupc/singledetail/80ff366baf1ffc4ffe47acc2', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991617321304068', 'https://tiku.baidu.com/tikupc/singledetail/dd2bbd64783e0912a2162a07', '1025991592520384516', '0');
INSERT INTO `crawler_question` VALUES ('1025991617380024323', 'https://tiku.baidu.com/tikupc/singledetail/cb92172ded630b1c59eeb57c', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991617380024324', 'https://tiku.baidu.com/tikupc/singledetail/144bde80d4d8d15abe234e4c', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991617380024322', 'https://tiku.baidu.com/tikupc/singledetail/de67e518964bcf84b9d57b2f', '1025991591899627522', '0');
INSERT INTO `crawler_question` VALUES ('1025991617380024325', 'https://tiku.baidu.com/tikupc/singledetail/fa3c750bf78a6529647d53c2', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991617489076226', 'https://tiku.baidu.com/tikupc/singledetail/3d2e846a561252d380eb6ec2', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991617556185089', 'https://tiku.baidu.com/tikupc/singledetail/7765915f804d2b160b4ec048', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991617556185090', 'https://tiku.baidu.com/tikupc/singledetail/1926ba1aa8114431b90dd82f', '1025991592520384516', '0');
INSERT INTO `crawler_question` VALUES ('1025991617556185091', 'https://tiku.baidu.com/tikupc/singledetail/70ae33d4b14e852458fb5779', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991617489076227', 'https://tiku.baidu.com/tikupc/singledetail/ddc64afe04a1b0717fd5dd2f', '1025991591991902211', '0');
INSERT INTO `crawler_question` VALUES ('1025991617556185094', 'https://tiku.baidu.com/tikupc/singledetail/221c0b4c2e3f5727a5e9622f', '1025991591899627522', '0');
INSERT INTO `crawler_question` VALUES ('1025991617631682561', 'https://tiku.baidu.com/tikupc/singledetail/51e8998fcc22bcd126ff0c07', '1025991592797208579', '0');
INSERT INTO `crawler_question` VALUES ('1025991617686208515', 'https://tiku.baidu.com/tikupc/singledetail/148b9ec3d5bbfd0a79567348', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991617686208516', 'https://tiku.baidu.com/tikupc/singledetail/4ff050e2524de518964b7d2f', '1025991592520384516', '0');
INSERT INTO `crawler_question` VALUES ('1025991617686208517', 'https://tiku.baidu.com/tikupc/singledetail/d91087c24028915f804dc22f', '1025991591991902211', '0');
INSERT INTO `crawler_question` VALUES ('1025991617686208519', 'https://tiku.baidu.com/tikupc/singledetail/51f4360cba1aa8114431d924', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991617816231938', 'https://tiku.baidu.com/tikupc/singledetail/cf24a5e9856a561252d36f06', '1025991592797208579', '0');
INSERT INTO `crawler_question` VALUES ('1025991617686208514', 'https://tiku.baidu.com/tikupc/singledetail/b920f021dd36a32d7375819a', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991617849786370', 'https://tiku.baidu.com/tikupc/singledetail/7028ad02de80d4d8d15a4f7d', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991617849786373', 'https://tiku.baidu.com/tikupc/singledetail/9548b52acfc789eb172dc84d', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991617849786371', 'https://tiku.baidu.com/tikupc/singledetail/cd1455270722192e4536f606', '1025991591991902211', '0');
INSERT INTO `crawler_question` VALUES ('1025991617816231939', 'https://tiku.baidu.com/tikupc/singledetail/5399b9f3f90f76c661371a49', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991617556185093', 'https://tiku.baidu.com/tikupc/singledetail/24c05afb770bf78a652954e1', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991618038530050', 'https://tiku.baidu.com/tikupc/singledetail/433c14791711cc7931b7162f', '1025991592797208579', '0');
INSERT INTO `crawler_question` VALUES ('1025991618038530051', 'https://tiku.baidu.com/tikupc/singledetail/28e2b0717fd5360cba1adb46', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991618055307266', 'https://tiku.baidu.com/tikupc/singledetail/4317d1d233d4b14e8524689a', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991618055307267', 'https://tiku.baidu.com/tikupc/singledetail/9017ee06eff9aef8941e0625', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991618122416130', 'https://tiku.baidu.com/tikupc/singledetail/7631ddccda38376baf1fae54', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991618122416132', 'https://tiku.baidu.com/tikupc/singledetail/8a19a8114431b90d6c85c706', '1025991591991902211', '0');
INSERT INTO `crawler_question` VALUES ('1025991618122416131', 'https://tiku.baidu.com/tikupc/singledetail/f4bcb407e87101f69e3195fc', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991618122416133', 'https://tiku.baidu.com/tikupc/singledetail/1c4aeff9aef8941ea76e0549', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991618139193345', 'https://tiku.baidu.com/tikupc/singledetail/f1153c1ec5da50e2524d7f46', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991618160164865', 'https://tiku.baidu.com/tikupc/singledetail/8624dd36a32d7375a4178000', '1025991592797208579', '0');
INSERT INTO `crawler_question` VALUES ('1025991618202107906', 'https://tiku.baidu.com/tikupc/singledetail/fbe882c4bb4cf7ec4afed0de', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991618202107905', 'https://tiku.baidu.com/tikupc/singledetail/3cc8856a561252d380eb6e24', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991618202107907', 'https://tiku.baidu.com/tikupc/singledetail/b8e25627a5e9856a561260d8', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991618265022467', 'https://tiku.baidu.com/tikupc/singledetail/516b011ca300a6c30c229f06', '1025991591991902211', '0');
INSERT INTO `crawler_question` VALUES ('1025991618265022468', 'https://tiku.baidu.com/tikupc/singledetail/c91ca6c30c22590102029d19', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991618265022469', 'https://tiku.baidu.com/tikupc/singledetail/4b9a7f19227916888486d746', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991618265022470', 'https://tiku.baidu.com/tikupc/singledetail/4d59312b3169a4517723a303', '1025991592797208579', '0');
INSERT INTO `crawler_question` VALUES ('1025991617556185092', 'https://tiku.baidu.com/tikupc/singledetail/a16233687e21af45b307a820', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991618315354113', 'https://tiku.baidu.com/tikupc/singledetail/fb459b6648d7c1c708a14524', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991618265022466', 'https://tiku.baidu.com/tikupc/singledetail/f567cfc789eb172ded63b748', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991618340519938', 'https://tiku.baidu.com/tikupc/singledetail/2c1ff8d6195f312b3169a506', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991617849786372', 'https://tiku.baidu.com/tikupc/singledetail/ce35650e52ea551810a6872e', '1025991592520384516', '0');
INSERT INTO `crawler_question` VALUES ('1025991618395045891', 'https://tiku.baidu.com/tikupc/singledetail/6c1e0740be1e650e52ea9919', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991618395045890', 'https://tiku.baidu.com/tikupc/singledetail/a54df01dc281e53a5802ff19', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991618411823107', 'https://tiku.baidu.com/tikupc/singledetail/8068ccbff121dd36a32d8249', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991618441183234', 'https://tiku.baidu.com/tikupc/singledetail/b8f484254b35eefdc8d33320', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991618411823106', 'https://tiku.baidu.com/tikupc/singledetail/bea3284ac850ad02de804107', '1025991593107587074', '0');
INSERT INTO `crawler_question` VALUES ('1025991618483126273', 'https://tiku.baidu.com/tikupc/singledetail/418183d049649b6648d74701', '1025991592520384516', '0');
INSERT INTO `crawler_question` VALUES ('1025991618483126275', 'https://tiku.baidu.com/tikupc/singledetail/413b4b35eefdc8d376ee321b', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991618483126276', 'https://tiku.baidu.com/tikupc/singledetail/74cae009581b6bd97f19ea25', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991618483126277', 'https://tiku.baidu.com/tikupc/singledetail/8a4e6c85ec3a87c24028c446', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991618567012353', 'https://tiku.baidu.com/tikupc/singledetail/14c59ec3d5bbfd0a79567306', '1025991593304719363', '0');
INSERT INTO `crawler_question` VALUES ('1025991618579595267', 'https://tiku.baidu.com/tikupc/singledetail/d5f2ce2f0066f5335a81212f', '1025991593107587074', '0');
INSERT INTO `crawler_question` VALUES ('1025991618579595266', 'https://tiku.baidu.com/tikupc/singledetail/67baa1c7aa00b52acfc7ca70', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991618697035777', 'https://tiku.baidu.com/tikupc/singledetail/407810661ed9ad51f01df24b', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991618579595265', 'https://tiku.baidu.com/tikupc/singledetail/fa23b84ae45c3b3567ec8b49', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991618697035778', 'https://tiku.baidu.com/tikupc/singledetail/35a884868762caaedd33d425', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991618697035779', 'https://tiku.baidu.com/tikupc/singledetail/192c0066f5335a8102d22006', '1025991593304719363', '0');
INSERT INTO `crawler_question` VALUES ('1025991618726395907', 'https://tiku.baidu.com/tikupc/singledetail/49ebb8f67c1cfad6195fa706', '1025991593107587074', '0');
INSERT INTO `crawler_question` VALUES ('1025991618726395906', 'https://tiku.baidu.com/tikupc/singledetail/4e1f59eef8c75fbfc77db206', '1025991593514434563', '0');
INSERT INTO `crawler_question` VALUES ('1025991618751561730', 'https://tiku.baidu.com/tikupc/singledetail/e7a0102de2bd960590c67749', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991618751561731', 'https://tiku.baidu.com/tikupc/singledetail/1d956294dd88d0d233d46a7b', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991618827059202', 'https://tiku.baidu.com/tikupc/singledetail/51aa6529647d27284b735125', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991618827059203', 'https://tiku.baidu.com/tikupc/singledetail/00f976eeaeaad1f346933f2f', '1025991593304719363', '0');
INSERT INTO `crawler_question` VALUES ('1025991618827059204', 'https://tiku.baidu.com/tikupc/singledetail/cd2252d380eb6294dd886c35', '1025991593107587074', '0');
INSERT INTO `crawler_question` VALUES ('1025991618852225027', 'https://tiku.baidu.com/tikupc/singledetail/87cada38376baf1ffc4fad03', '1025991559041449985', '0');
INSERT INTO `crawler_question` VALUES ('1025991618852225026', 'https://tiku.baidu.com/tikupc/singledetail/64283169a45177232f60a206', '1025991593514434563', '0');
INSERT INTO `crawler_question` VALUES ('1025991618961276930', 'https://tiku.baidu.com/tikupc/singledetail/8c7501f69e31433239689301', '1025991593304719363', '0');
INSERT INTO `crawler_question` VALUES ('1025991618961276929', 'https://tiku.baidu.com/tikupc/singledetail/dba5524de518964bcf847c42', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991618986442754', 'https://tiku.baidu.com/tikupc/singledetail/1347852458fb770bf78a550c', '1025991593107587074', '0');
INSERT INTO `crawler_question` VALUES ('1025991619007414274', 'https://tiku.baidu.com/tikupc/singledetail/e15ef242336c1eb91a375d28', '1025991559041449985', '0');
INSERT INTO `crawler_question` VALUES ('1025991619007414275', 'https://tiku.baidu.com/tikupc/singledetail/cd46b307e87101f69e319506', '1025991593514434563', '0');
INSERT INTO `crawler_question` VALUES ('1025991619070328833', 'https://tiku.baidu.com/tikupc/singledetail/0f4977eeaeaad1f346933f9f', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991619087106050', 'https://tiku.baidu.com/tikupc/singledetail/8e034b73f242336c1eb95e2e', '1025991593304719363', '0');
INSERT INTO `crawler_question` VALUES ('1025991619087106051', 'https://tiku.baidu.com/tikupc/singledetail/4d13312b3169a4517723a349', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991619158409218', 'https://tiku.baidu.com/tikupc/singledetail/cbf6f61fb7360b4c2e3f6406', '1025991593514434563', '0');
INSERT INTO `crawler_question` VALUES ('1025991619158409220', 'https://tiku.baidu.com/tikupc/singledetail/f22f18e8b8f67c1cfad6b8c1', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991619158409217', 'https://tiku.baidu.com/tikupc/singledetail/84dc6f1aff00bed5b9f31d02', '1025991559041449985', '0');
INSERT INTO `crawler_question` VALUES ('1025991619158409219', 'https://tiku.baidu.com/tikupc/singledetail/0430192e453610661ed9f417', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991619217129474', 'https://tiku.baidu.com/tikupc/singledetail/53d3b9f3f90f76c661371a03', '1025991559179862018', '0');
INSERT INTO `crawler_question` VALUES ('1025991619292626945', 'https://tiku.baidu.com/tikupc/singledetail/562cb9f67c1cfad6195fa7c1', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991619292626946', 'https://tiku.baidu.com/tikupc/singledetail/410f4b35eefdc8d376ee322f', '1025991593514434563', '0');
INSERT INTO `crawler_question` VALUES ('1025991619292626947', 'https://tiku.baidu.com/tikupc/singledetail/e231763231126edb6f1a103c', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991619292626948', 'https://tiku.baidu.com/tikupc/singledetail/cdc40c225901020207409c02', '1025991559179862018', '0');
INSERT INTO `crawler_question` VALUES ('1025991619468787713', 'https://tiku.baidu.com/tikupc/singledetail/b9712b160b4e767f5acfce39', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991619573645314', 'https://tiku.baidu.com/tikupc/singledetail/342d02020740be1e650e9a29', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991619582033922', 'https://tiku.baidu.com/tikupc/singledetail/42c526fff705cc1755270911', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991619670114307', 'https://tiku.baidu.com/tikupc/singledetail/772d915f804d2b160b4ec000', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991619670114309', 'https://tiku.baidu.com/tikupc/singledetail/ce1c650e52ea551810a68707', '1025991593837395969', '0');
INSERT INTO `crawler_question` VALUES ('1025991619670114308', 'https://tiku.baidu.com/tikupc/singledetail/be806bec0975f46527d3e110', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991619791749121', 'https://tiku.baidu.com/tikupc/singledetail/90cfba0d4a7302768e99393d', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991619837886466', 'https://tiku.baidu.com/tikupc/singledetail/64a3f524ccbff121dd368300', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991619837886467', 'https://tiku.baidu.com/tikupc/singledetail/c7483086bceb19e8b8f6ba9b', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991619858857985', 'https://tiku.baidu.com/tikupc/singledetail/e158f242336c1eb91a375d2e', '1025991593837395969', '0');
INSERT INTO `crawler_question` VALUES ('1025991619904995329', 'https://tiku.baidu.com/tikupc/singledetail/6efc2cc58bd63186bcebbc3c', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991619946938370', 'https://tiku.baidu.com/tikupc/singledetail/14c39ec3d5bbfd0a79567300', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991619946938371', 'https://tiku.baidu.com/tikupc/singledetail/934bb04e852458fb770b569a', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991620005658625', 'https://tiku.baidu.com/tikupc/singledetail/ced780eb6294dd88d0d26b01', '1025991593837395969', '0');
INSERT INTO `crawler_question` VALUES ('1025991620022435842', 'https://tiku.baidu.com/tikupc/singledetail/8a0e6c85ec3a87c24028c406', '1025991594307158018', '0');
INSERT INTO `crawler_question` VALUES ('1025991620081156098', 'https://tiku.baidu.com/tikupc/singledetail/b3aa1a37f111f18583d05a16', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991620081156099', 'https://tiku.baidu.com/tikupc/singledetail/518e6529647d27284b735101', '1025991593837395969', '0');
INSERT INTO `crawler_question` VALUES ('1025991620160847874', 'https://tiku.baidu.com/tikupc/singledetail/f83243323968011ca3009106', '1025991594307158018', '0');
INSERT INTO `crawler_question` VALUES ('1025991620160847875', 'https://tiku.baidu.com/tikupc/singledetail/2df85b8102d276a200292ece', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991620160847876', 'https://tiku.baidu.com/tikupc/singledetail/bab9f121dd36a32d73758103', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991620160847877', 'https://tiku.baidu.com/tikupc/singledetail/00ff76eeaeaad1f346933f29', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991620177625089', 'https://tiku.baidu.com/tikupc/singledetail/4fca50e2524de518964b7d15', '1025991574157721602', '0');
INSERT INTO `crawler_question` VALUES ('1025991620236345345', 'https://tiku.baidu.com/tikupc/singledetail/d247f78a6529647d27285249', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991620269899777', 'https://tiku.baidu.com/tikupc/singledetail/c205647d27284b73f2425029', '1025991593837395969', '0');
INSERT INTO `crawler_question` VALUES ('1025991620328620035', 'https://tiku.baidu.com/tikupc/singledetail/2e1ffad6195f312b3169a506', '1025991593992585217', '0');
INSERT INTO `crawler_question` VALUES ('1025991620328620034', 'https://tiku.baidu.com/tikupc/singledetail/d35c8e9951e79b896802262f', '1025991594307158018', '0');
INSERT INTO `crawler_question` VALUES ('1025991620353785859', 'https://tiku.baidu.com/tikupc/singledetail/35a803020740be1e650e9aac', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991620353785858', 'https://tiku.baidu.com/tikupc/singledetail/bae6f121dd36a32d7375815c', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991620353785860', 'https://tiku.baidu.com/tikupc/singledetail/64d59e3143323968011c9226', '1025991574157721602', '0');
INSERT INTO `crawler_question` VALUES ('1025991620391534594', 'https://tiku.baidu.com/tikupc/singledetail/6836a300a6c30c2259019e2f', '1025991594768531460', '0');
INSERT INTO `crawler_question` VALUES ('1025991620416700418', 'https://tiku.baidu.com/tikupc/singledetail/9313b04e852458fb770b56c2', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991620467032066', 'https://tiku.baidu.com/tikupc/singledetail/6ff2d15abe23482fb4da4c2f', '1025991593992585217', '0');
INSERT INTO `crawler_question` VALUES ('1025991620467032068', 'https://tiku.baidu.com/tikupc/singledetail/9309bb0d4a7302768e9939fb', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991620483809282', 'https://tiku.baidu.com/tikupc/singledetail/7ce10975f46527d3240ce008', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991620467032067', 'https://tiku.baidu.com/tikupc/singledetail/6eee2cc58bd63186bcebbc2e', '1025991594307158018', '0');
INSERT INTO `crawler_question` VALUES ('1025991620328620036', 'https://tiku.baidu.com/tikupc/singledetail/42a6d0d233d4b14e8524682b', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991620483809285', 'https://tiku.baidu.com/tikupc/singledetail/6328783e0912a21614792949', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991620483809284', 'https://tiku.baidu.com/tikupc/singledetail/6c280740be1e650e52ea992f', '1025991594768531460', '0');
INSERT INTO `crawler_question` VALUES ('1025991620529946625', 'https://tiku.baidu.com/tikupc/singledetail/756109a1284ac850ad0242a3', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991620483809283', 'https://tiku.baidu.com/tikupc/singledetail/d3268e9951e79b8968022655', '1025991574157721602', '0');
INSERT INTO `crawler_question` VALUES ('1025991620559306753', 'https://tiku.baidu.com/tikupc/singledetail/6021590102020740be1e9b06', '1025991593992585217', '0');
INSERT INTO `crawler_question` VALUES ('1025991620601249793', 'https://tiku.baidu.com/tikupc/singledetail/8462ff00bed5b9f3f90f1c7d', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991620659970050', 'https://tiku.baidu.com/tikupc/singledetail/8c7c01f69e31433239689308', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991620630609923', 'https://tiku.baidu.com/tikupc/singledetail/142cde80d4d8d15abe234e2b', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991620668358657', 'https://tiku.baidu.com/tikupc/singledetail/a9e2195f312b3169a451a431', '1025991594768531460', '0');
INSERT INTO `crawler_question` VALUES ('1025991620739661826', 'https://tiku.baidu.com/tikupc/singledetail/e9b6a21614791711cc7917a1', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991620739661825', 'https://tiku.baidu.com/tikupc/singledetail/7ce80975f46527d3240ce001', '1025991593992585217', '0');
INSERT INTO `crawler_question` VALUES ('1025991620668358658', 'https://tiku.baidu.com/tikupc/singledetail/1f15561252d380eb62946d7a', '1025991574157721602', '0');
INSERT INTO `crawler_question` VALUES ('1025991620739661828', 'https://tiku.baidu.com/tikupc/singledetail/3cba856a561252d380eb6e56', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991620659970051', 'https://tiku.baidu.com/tikupc/singledetail/f8c4c381e53a580216fcfedc', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991620836130818', 'https://tiku.baidu.com/tikupc/singledetail/e362f042336c1eb91a375d14', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991620739661827', 'https://tiku.baidu.com/tikupc/singledetail/f6761711cc7931b765ce150a', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991620798382082', 'https://tiku.baidu.com/tikupc/singledetail/1d1e453610661ed9ad51f335', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991620894851073', 'https://tiku.baidu.com/tikupc/singledetail/2e4afad6195f312b3169a553', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991620894851075', 'https://tiku.baidu.com/tikupc/singledetail/431914791711cc7931b7160a', '1025991594768531460', '0');
INSERT INTO `crawler_question` VALUES ('1025991620886462465', 'https://tiku.baidu.com/tikupc/singledetail/18eb0166f5335a8102d220c1', '1025991574472294401', '0');
INSERT INTO `crawler_question` VALUES ('1025991620894851074', 'https://tiku.baidu.com/tikupc/singledetail/622a3369a45177232f60a204', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991620924211201', 'https://tiku.baidu.com/tikupc/singledetail/914f5122aaea998fcc220e96', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991620940988420', 'https://tiku.baidu.com/tikupc/singledetail/f228fc4ffe4733687e21aa32', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991620940988419', 'https://tiku.baidu.com/tikupc/singledetail/81d6cdbff121dd36a32d82f7', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991620999708673', 'https://tiku.baidu.com/tikupc/singledetail/6d62be23482fb4daa58d4b3d', '1025991594768531460', '0');
INSERT INTO `crawler_question` VALUES ('1025991620999708674', 'https://tiku.baidu.com/tikupc/singledetail/1f32561252d380eb62946d5d', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991620999708675', 'https://tiku.baidu.com/tikupc/singledetail/92f3b80d4a7302768e993901', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991620991320065', 'https://tiku.baidu.com/tikupc/singledetail/20e52e60ddccda38376bafc3', '1025991574472294401', '0');
INSERT INTO `crawler_question` VALUES ('1025991621024874497', 'https://tiku.baidu.com/tikupc/singledetail/30b1bdd126fff705cc170a96', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991621066817537', 'https://tiku.baidu.com/tikupc/singledetail/0e935bf5f61fb7360b4c6551', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991621066817538', 'https://tiku.baidu.com/tikupc/singledetail/0034168884868762caaed548', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991621117149187', 'https://tiku.baidu.com/tikupc/singledetail/e2742af90242a8956bece45c', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991621117149186', 'https://tiku.baidu.com/tikupc/singledetail/d39ef68a6529647d27285290', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991621129732098', 'https://tiku.baidu.com/tikupc/singledetail/346f85868762caaedd33d4e2', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991621213618180', 'https://tiku.baidu.com/tikupc/singledetail/74a4e009581b6bd97f19ea4b', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991621213618178', 'https://tiku.baidu.com/tikupc/singledetail/54ba6629647d27284b735135', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991621255561218', 'https://tiku.baidu.com/tikupc/singledetail/a0b532687e21af45b307a8f7', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991621272338435', 'https://tiku.baidu.com/tikupc/singledetail/15f01fd9ad51f01dc281f193', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991621272338434', 'https://tiku.baidu.com/tikupc/singledetail/d93987c24028915f804dc206', '1025991595154407431', '0');
INSERT INTO `crawler_question` VALUES ('1025991621322670082', 'https://tiku.baidu.com/tikupc/singledetail/a92a804d2b160b4e767fcf70', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991621364613122', 'https://tiku.baidu.com/tikupc/singledetail/5ceaf38583d049649b6658fe', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991621364613123', 'https://tiku.baidu.com/tikupc/singledetail/20e9551810a6f524ccbf8506', '1025991595154407431', '0');
INSERT INTO `crawler_question` VALUES ('1025991621410750465', 'https://tiku.baidu.com/tikupc/singledetail/d3218e9951e79b8968022652', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991621473665026', 'https://tiku.baidu.com/tikupc/singledetail/9fc2aa00b52acfc789ebc900', '1025991595154407431', '0');
INSERT INTO `crawler_question` VALUES ('1025991621553356801', 'https://tiku.baidu.com/tikupc/singledetail/d9c6f705cc1755270722083c', '1025991595015995393', '0');
INSERT INTO `crawler_question` VALUES ('1025991621586911234', 'https://tiku.baidu.com/tikupc/singledetail/29d028ea81c758f5f61f6700', '1025991595154407431', '0');
INSERT INTO `crawler_question` VALUES ('1025991621620465666', 'https://tiku.baidu.com/tikupc/singledetail/802cccbff121dd36a32d820d', '1025991575038525441', '0');
INSERT INTO `crawler_question` VALUES ('1025991621674991617', 'https://tiku.baidu.com/tikupc/singledetail/cf19a5e9856a561252d36f3b', '1025991595015995393', '0');
INSERT INTO `crawler_question` VALUES ('1025991621733711874', 'https://tiku.baidu.com/tikupc/singledetail/fcc9770bf78a6529647d5337', '1025991575038525441', '0');
INSERT INTO `crawler_question` VALUES ('1025991621784043522', 'https://tiku.baidu.com/tikupc/singledetail/3eb80242a8956bec0975e344', '1025991595015995393', '0');
INSERT INTO `crawler_question` VALUES ('1025991621880512513', 'https://tiku.baidu.com/tikupc/singledetail/6b66af1ffc4ffe473368ab08', '1025991575038525441', '0');
INSERT INTO `crawler_question` VALUES ('1025991621935038466', 'https://tiku.baidu.com/tikupc/singledetail/b42df111f18583d04964591f', '1025991595015995393', '0');
INSERT INTO `crawler_question` VALUES ('1025991621935038465', 'https://tiku.baidu.com/tikupc/singledetail/a834a8ea998fcc22bcd10d13', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991621985370114', 'https://tiku.baidu.com/tikupc/singledetail/82d29b89680203d8ce2f2430', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991622023118849', 'https://tiku.baidu.com/tikupc/singledetail/1404bfd5b9f3f90f76c61b01', '1025991575038525441', '0');
INSERT INTO `crawler_question` VALUES ('1025991622023118850', 'https://tiku.baidu.com/tikupc/singledetail/ae135f0e7cd184254b353501', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991622094422018', 'https://tiku.baidu.com/tikupc/singledetail/24703968011ca300a6c39047', '1025991595015995393', '0');
INSERT INTO `crawler_question` VALUES ('1025991622094422017', 'https://tiku.baidu.com/tikupc/singledetail/7877dfccda38376baf1fae12', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991622094422019', 'https://tiku.baidu.com/tikupc/singledetail/1bcdd5bbfd0a79563c1e720b', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991622136365057', 'https://tiku.baidu.com/tikupc/singledetail/1867cf84b9d528ea81c77929', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991622190891009', 'https://tiku.baidu.com/tikupc/singledetail/f408fe4ffe4733687e21aa12', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991622190891010', 'https://tiku.baidu.com/tikupc/singledetail/6816964bcf84b9d528ea7a0b', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991622224445442', 'https://tiku.baidu.com/tikupc/singledetail/64f39e3143323968011c9200', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991622232834050', 'https://tiku.baidu.com/tikupc/singledetail/11150b4e767f5acfa1c7cd06', '1025991595477368833', '0');
INSERT INTO `crawler_question` VALUES ('1025991622257999873', 'https://tiku.baidu.com/tikupc/singledetail/23e00a4c2e3f5727a5e962d3', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991622283165698', 'https://tiku.baidu.com/tikupc/singledetail/abebbb4cf7ec4afe04a1df2a', '1025991595888410626', '0');
INSERT INTO `crawler_question` VALUES ('1025991622283165697', 'https://tiku.baidu.com/tikupc/singledetail/65da3069a45177232f60a2f4', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991622283165699', 'https://tiku.baidu.com/tikupc/singledetail/9002ee06eff9aef8941e0630', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991622329303042', 'https://tiku.baidu.com/tikupc/singledetail/c4eae55c3b3567ec102d8aa5', '1025991595477368833', '0');
INSERT INTO `crawler_question` VALUES ('1025991622320914433', 'https://tiku.baidu.com/tikupc/singledetail/42a4d0d233d4b14e85246829', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991622354468865', 'https://tiku.baidu.com/tikupc/singledetail/d995e418964bcf84b9d57bdd', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991622404800513', 'https://tiku.baidu.com/tikupc/singledetail/f623b4daa58da0116c174909', '1025991595888410626', '0');
INSERT INTO `crawler_question` VALUES ('1025991622413189122', 'https://tiku.baidu.com/tikupc/singledetail/6697d6d8d15abe23482f4d12', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991622421577730', 'https://tiku.baidu.com/tikupc/singledetail/ef4962ce05087632311212fb', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991622429966338', 'https://tiku.baidu.com/tikupc/singledetail/d7368e6fb84ae45c3b358c24', '1025991595477368833', '0');
INSERT INTO `crawler_question` VALUES ('1025991622429966337', 'https://tiku.baidu.com/tikupc/singledetail/70fe33d4b14e852458fb5729', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991622488686595', 'https://tiku.baidu.com/tikupc/singledetail/903bee06eff9aef8941e0609', '1025991595888410626', '0');
INSERT INTO `crawler_question` VALUES ('1025991622539018242', 'https://tiku.baidu.com/tikupc/singledetail/c930a6c30c22590102029d35', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991622539018243', 'https://tiku.baidu.com/tikupc/singledetail/e90dfa42336c1eb91a375d7b', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991622539018244', 'https://tiku.baidu.com/tikupc/singledetail/bb981237f111f18583d05a24', '1025991595477368833', '0');
INSERT INTO `crawler_question` VALUES ('1025991622589349890', 'https://tiku.baidu.com/tikupc/singledetail/1bef700abb68a98271fefa16', '1025991595888410626', '0');
INSERT INTO `crawler_question` VALUES ('1025991622597738497', 'https://tiku.baidu.com/tikupc/singledetail/1866cf84b9d528ea81c77928', '1025991596177817602', '0');
INSERT INTO `crawler_question` VALUES ('1025991622622904321', 'https://tiku.baidu.com/tikupc/singledetail/a562f01dc281e53a5802ff36', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991622648070145', 'https://tiku.baidu.com/tikupc/singledetail/303f40d7c1c708a1284a445c', '1025991497733308419', '0');
INSERT INTO `crawler_question` VALUES ('1025991622669041667', 'https://tiku.baidu.com/tikupc/singledetail/262058fb770bf78a65295401', '1025991596404310019', '0');
INSERT INTO `crawler_question` VALUES ('1025991622669041671', 'https://tiku.baidu.com/tikupc/singledetail/ee76580216fc700abb68fc49', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991622669041669', 'https://tiku.baidu.com/tikupc/singledetail/de0ce518964bcf84b9d57b44', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991622669041668', 'https://tiku.baidu.com/tikupc/singledetail/be866bec0975f46527d3e116', '1025991595888410626', '0');
INSERT INTO `crawler_question` VALUES ('1025991622669041670', 'https://tiku.baidu.com/tikupc/singledetail/160876c66137ee06eff91802', '1025991596177817602', '0');
INSERT INTO `crawler_question` VALUES ('1025991622669041666', 'https://tiku.baidu.com/tikupc/singledetail/1747a8956bec0975f465e200', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991623310770177', 'https://tiku.baidu.com/tikupc/singledetail/51ec998fcc22bcd126ff0c03', '1025991575852220417', '0');
INSERT INTO `crawler_question` VALUES ('1025991623310770178', 'https://tiku.baidu.com/tikupc/singledetail/dbee524de518964bcf847c09', '1025991575973855234', '0');
INSERT INTO `crawler_question` VALUES ('1025991623386267649', 'https://tiku.baidu.com/tikupc/singledetail/159a53ea551810a6f5248691', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991623411433473', 'https://tiku.baidu.com/tikupc/singledetail/d93f87c24028915f804dc200', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991623394656259', 'https://tiku.baidu.com/tikupc/singledetail/70ff33d4b14e852458fb5728', '1025991596404310019', '0');
INSERT INTO `crawler_question` VALUES ('1025991623394656258', 'https://tiku.baidu.com/tikupc/singledetail/1f2b561252d380eb62946d44', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991623436599298', 'https://tiku.baidu.com/tikupc/singledetail/64a1d1f34693daef5ef73d0e', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991623428210690', 'https://tiku.baidu.com/tikupc/singledetail/6753a45177232f60ddcca13f', '1025991596039405569', '0');
INSERT INTO `crawler_question` VALUES ('1025991623403044866', 'https://tiku.baidu.com/tikupc/singledetail/9d417fd5360cba1aa811da35', '1025991596177817602', '0');
INSERT INTO `crawler_question` VALUES ('1025991623444987906', 'https://tiku.baidu.com/tikupc/singledetail/e161f242336c1eb91a375d17', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991623470153730', 'https://tiku.baidu.com/tikupc/singledetail/6874be1e650e52ea55189831', '1025991575973855234', '0');
INSERT INTO `crawler_question` VALUES ('1025991623520485379', 'https://tiku.baidu.com/tikupc/singledetail/8cb2ddf5f61fb7360b4c6570', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991623528873985', 'https://tiku.baidu.com/tikupc/singledetail/b9115727a5e9856a5612602b', '1025991596404310019', '0');
INSERT INTO `crawler_question` VALUES ('1025991623520485378', 'https://tiku.baidu.com/tikupc/singledetail/6091960590c69ec3d5bb7529', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991623537262594', 'https://tiku.baidu.com/tikupc/singledetail/d827f5335a8102d276a22f44', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991623575011329', 'https://tiku.baidu.com/tikupc/singledetail/8a396c85ec3a87c24028c431', '1025991575973855234', '0');
INSERT INTO `crawler_question` VALUES ('1025991623554039809', 'https://tiku.baidu.com/tikupc/singledetail/6803be1e650e52ea55189846', '1025991596039405569', '0');
INSERT INTO `crawler_question` VALUES ('1025991623537262595', 'https://tiku.baidu.com/tikupc/singledetail/ab5fbb4cf7ec4afe04a1df9e', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991623583399939', 'https://tiku.baidu.com/tikupc/singledetail/64a7d1f34693daef5ef73d08', '1025991596177817602', '0');
INSERT INTO `crawler_question` VALUES ('1025991623637925890', 'https://tiku.baidu.com/tikupc/singledetail/566cd74de518964bcf847c8b', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991623583399938', 'https://tiku.baidu.com/tikupc/singledetail/094fa417866fb84ae45c8d3f', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991623637925891', 'https://tiku.baidu.com/tikupc/singledetail/838f0508763231126edb1144', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991623637925892', 'https://tiku.baidu.com/tikupc/singledetail/2f262f60ddccda38376baf00', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991623688257537', 'https://tiku.baidu.com/tikupc/singledetail/2f3bb1717fd5360cba1adb9f', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991623730200578', 'https://tiku.baidu.com/tikupc/singledetail/c014a7b91a37f111f1855b7c', '1025991494113624065', '0');
INSERT INTO `crawler_question` VALUES ('1025991623730200580', 'https://tiku.baidu.com/tikupc/singledetail/b3801a37f111f18583d05a3c', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991623730200581', 'https://tiku.baidu.com/tikupc/singledetail/8f7b88eb172ded630b1cb6b9', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991623730200577', 'https://tiku.baidu.com/tikupc/singledetail/2e28fad6195f312b3169a531', '1025991575973855234', '0');
INSERT INTO `crawler_question` VALUES ('1025991623730200579', 'https://tiku.baidu.com/tikupc/singledetail/b97d5727a5e9856a56126047', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991623755366402', 'https://tiku.baidu.com/tikupc/singledetail/58cfec3a87c24028915fc34f', '1025991596039405569', '0');
INSERT INTO `crawler_question` VALUES ('1025991623772143618', 'https://tiku.baidu.com/tikupc/singledetail/83d40508763231126edb111f', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991623780532226', 'https://tiku.baidu.com/tikupc/singledetail/b9c681c758f5f61fb7366629', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991623780532227', 'https://tiku.baidu.com/tikupc/singledetail/b5aba88271fe910ef12df8c6', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991623843446785', 'https://tiku.baidu.com/tikupc/singledetail/16751ed9ad51f01dc281f116', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991623851835393', 'https://tiku.baidu.com/tikupc/singledetail/13cb58f5f61fb7360b4c6509', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991623893778433', 'https://tiku.baidu.com/tikupc/singledetail/6e8f2cc58bd63186bcebbc4f', '1025991596039405569', '0');
INSERT INTO `crawler_question` VALUES ('1025991623910555649', 'https://tiku.baidu.com/tikupc/singledetail/61466c175f0e7cd184253652', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991623981858817', 'https://tiku.baidu.com/tikupc/singledetail/1c1feff9aef8941ea76e051c', '1025991597218004993', '0');
INSERT INTO `crawler_question` VALUES ('1025991623981858818', 'https://tiku.baidu.com/tikupc/singledetail/cd1e52d380eb6294dd886c09', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991624032190465', 'https://tiku.baidu.com/tikupc/singledetail/cd890c225901020207409c4f', '1025991596039405569', '0');
INSERT INTO `crawler_question` VALUES ('1025991624023801859', 'https://tiku.baidu.com/tikupc/singledetail/800eccbff121dd36a32d822f', '1025991597033455618', '0');
INSERT INTO `crawler_question` VALUES ('1025991624023801858', 'https://tiku.baidu.com/tikupc/singledetail/1852cf84b9d528ea81c7791c', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991624908800002', 'https://tiku.baidu.com/tikupc/singledetail/1fc1561252d380eb62946dae', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991624908800003', 'https://tiku.baidu.com/tikupc/singledetail/263e58fb770bf78a6529541f', '1025991597218004993', '0');
INSERT INTO `crawler_question` VALUES ('1025991626611687428', 'https://tiku.baidu.com/tikupc/singledetail/45fd66ec102de2bd960588cd', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991626611687425', 'https://tiku.baidu.com/tikupc/singledetail/c6d33186bceb19e8b8f6ba00', '1025991597033455618', '0');
INSERT INTO `crawler_question` VALUES ('1025991626611687426', 'https://tiku.baidu.com/tikupc/singledetail/6ee72cc58bd63186bcebbc27', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991626611687429', 'https://tiku.baidu.com/tikupc/singledetail/5397fd0a79563c1ec5da7129', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991626909483011', 'https://tiku.baidu.com/tikupc/singledetail/f613ce7931b765ce05081407', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991626909483013', 'https://tiku.baidu.com/tikupc/singledetail/698d974bcf84b9d528ea7a90', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991626909483010', 'https://tiku.baidu.com/tikupc/singledetail/aa38aaea998fcc22bcd10d1f', '1025991597218004993', '0');
INSERT INTO `crawler_question` VALUES ('1025991626909483012', 'https://tiku.baidu.com/tikupc/singledetail/17bcc77da26925c52cc5bf06', '1025991597838761985', '0');
INSERT INTO `crawler_question` VALUES ('1025991628188745730', 'https://tiku.baidu.com/tikupc/singledetail/7bc278563c1ec5da50e270cd', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991628188745729', 'https://tiku.baidu.com/tikupc/singledetail/c55ae45c3b3567ec102d8a15', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991628188745731', 'https://tiku.baidu.com/tikupc/singledetail/c217647d27284b73f242503b', '1025991597033455618', '0');
INSERT INTO `crawler_question` VALUES ('1025991628188745732', 'https://tiku.baidu.com/tikupc/singledetail/4bde7f19227916888486d702', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991628541067267', 'https://tiku.baidu.com/tikupc/singledetail/f15275232f60ddccda38a006', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991628541067265', 'https://tiku.baidu.com/tikupc/singledetail/99e13a3567ec102de2bd89b8', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991628541067266', 'https://tiku.baidu.com/tikupc/singledetail/be8b284ac850ad02de80412f', '1025991597838761985', '0');
INSERT INTO `crawler_question` VALUES ('1025991628650119169', 'https://tiku.baidu.com/tikupc/singledetail/7fc7bceb19e8b8f67c1cb944', '1025991597033455618', '0');
INSERT INTO `crawler_question` VALUES ('1025991628650119170', 'https://tiku.baidu.com/tikupc/singledetail/1784c77da26925c52cc5bf3e', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991628650119173', 'https://tiku.baidu.com/tikupc/singledetail/a95c804d2b160b4e767fcf06', '1025991598035894274', '0');
INSERT INTO `crawler_question` VALUES ('1025991628650119172', 'https://tiku.baidu.com/tikupc/singledetail/d20cf78a6529647d27285202', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991628805308418', 'https://tiku.baidu.com/tikupc/singledetail/6342f424ccbff121dd3683e1', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991628696256514', 'https://tiku.baidu.com/tikupc/singledetail/23d20a4c2e3f5727a5e962e1', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991628750782465', 'https://tiku.baidu.com/tikupc/singledetail/cdd5b307e87101f69e319595', '1025991561541255169', '0');
INSERT INTO `crawler_question` VALUES ('1025991628851445764', 'https://tiku.baidu.com/tikupc/singledetail/d8506edb6f1aff00bed51e47', '1025991597033455618', '0');
INSERT INTO `crawler_question` VALUES ('1025991626611687427', 'https://tiku.baidu.com/tikupc/singledetail/d93c87c24028915f804dc203', '1025991576653332482', '0');
INSERT INTO `crawler_question` VALUES ('1025991628511707138', 'https://tiku.baidu.com/tikupc/singledetail/c48ce55c3b3567ec102d8ac3', '1025991597218004993', '0');
INSERT INTO `crawler_question` VALUES ('1025991628704645122', 'https://tiku.baidu.com/tikupc/singledetail/621cb7360b4c2e3f57276306', '1025991597838761985', '0');
INSERT INTO `crawler_question` VALUES ('1025991628851445765', 'https://tiku.baidu.com/tikupc/singledetail/9f4dc850ad02de80d4d84002', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991628696256515', 'https://tiku.baidu.com/tikupc/singledetail/1c546394dd88d0d233d46aba', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991628805308417', 'https://tiku.baidu.com/tikupc/singledetail/a915804d2b160b4e767fcf4f', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991628851445762', 'https://tiku.baidu.com/tikupc/singledetail/6097960590c69ec3d5bb752f', '1025991598035894274', '0');
INSERT INTO `crawler_question` VALUES ('1025991628905971713', 'https://tiku.baidu.com/tikupc/singledetail/9d072e3f5727a5e9856a614e', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991628905971714', 'https://tiku.baidu.com/tikupc/singledetail/1ba0ce84b9d528ea81c779ee', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991628956303363', 'https://tiku.baidu.com/tikupc/singledetail/d83f6edb6f1aff00bed51e28', '1025991576653332482', '0');
INSERT INTO `crawler_question` VALUES ('1025991628956303362', 'https://tiku.baidu.com/tikupc/singledetail/98811fb91a37f111f1855be8', '1025991597218004993', '0');
INSERT INTO `crawler_question` VALUES ('1025991628964691969', 'https://tiku.baidu.com/tikupc/singledetail/138558f5f61fb7360b4c6547', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991628851445763', 'https://tiku.baidu.com/tikupc/singledetail/9f461eb91a37f111f1855b2f', '1025991597595492353', '0');
INSERT INTO `crawler_question` VALUES ('1025991629010829315', 'https://tiku.baidu.com/tikupc/singledetail/b534c5da50e2524de5187e2f', '1025991598035894274', '0');
INSERT INTO `crawler_question` VALUES ('1025991629010829314', 'https://tiku.baidu.com/tikupc/singledetail/b1444028915f804d2b16c183', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991629019217921', 'https://tiku.baidu.com/tikupc/singledetail/905333126edb6f1aff001f64', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991628998246402', 'https://tiku.baidu.com/tikupc/singledetail/132abed5b9f3f90f76c61b2f', '1025991597838761985', '0');
INSERT INTO `crawler_question` VALUES ('1025991629040189441', 'https://tiku.baidu.com/tikupc/singledetail/74f708a1284ac850ad024235', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991629056966658', 'https://tiku.baidu.com/tikupc/singledetail/f7e77e1cfad6195f312ba614', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991629056966659', 'https://tiku.baidu.com/tikupc/singledetail/e155f242336c1eb91a375d23', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991629098909698', 'https://tiku.baidu.com/tikupc/singledetail/6843be1e650e52ea55189806', '1025991597595492353', '0');
INSERT INTO `crawler_question` VALUES ('1025991629098909699', 'https://tiku.baidu.com/tikupc/singledetail/e2eef342336c1eb91a375d98', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991629098909697', 'https://tiku.baidu.com/tikupc/singledetail/6b68af1ffc4ffe473368ab06', '1025991598035894274', '0');
INSERT INTO `crawler_question` VALUES ('1025991629111492609', 'https://tiku.baidu.com/tikupc/singledetail/8679fd00bed5b9f3f90f1c66', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991629140852737', 'https://tiku.baidu.com/tikupc/singledetail/6134a76e58fafab069dc022f', '1025991597838761985', '0');
INSERT INTO `crawler_question` VALUES ('1025991629140852739', 'https://tiku.baidu.com/tikupc/singledetail/9e5e6beae009581b6bd9eb1c', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991629174407169', 'https://tiku.baidu.com/tikupc/singledetail/02e469dc5022aaea998f0f51', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991629182795778', 'https://tiku.baidu.com/tikupc/singledetail/8419ff00bed5b9f3f90f1c06', '1025991597595492353', '0');
INSERT INTO `crawler_question` VALUES ('1025991629195378690', 'https://tiku.baidu.com/tikupc/singledetail/a41bba4cf7ec4afe04a1dfda', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991629224738817', 'https://tiku.baidu.com/tikupc/singledetail/dbc8524de518964bcf847c2f', '1025991598035894274', '0');
INSERT INTO `crawler_question` VALUES ('1025991629195378689', 'https://tiku.baidu.com/tikupc/singledetail/15dadf80d4d8d15abe234edd', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991629224738818', 'https://tiku.baidu.com/tikupc/singledetail/8019a06925c52cc58bd6be61', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991629308624898', 'https://tiku.baidu.com/tikupc/singledetail/52c414fc700abb68a982fbc3', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991629308624899', 'https://tiku.baidu.com/tikupc/singledetail/fa3783c4bb4cf7ec4afed001', '1025991597595492353', '0');
INSERT INTO `crawler_question` VALUES ('1025991629379928066', 'https://tiku.baidu.com/tikupc/singledetail/1cf5aef8941ea76e58fa0409', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991629371539457', 'https://tiku.baidu.com/tikupc/singledetail/5b02316c1eb91a37f1115c45', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991629405093889', 'https://tiku.baidu.com/tikupc/singledetail/1329bed5b9f3f90f76c61b2c', '1025991598199472129', '0');
INSERT INTO `crawler_question` VALUES ('1025991629430259714', 'https://tiku.baidu.com/tikupc/singledetail/6ec12cc58bd63186bcebbc01', '1025991597595492353', '0');
INSERT INTO `crawler_question` VALUES ('1025991629476397057', 'https://tiku.baidu.com/tikupc/singledetail/0befa58da0116c175f0e4830', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991629476397058', 'https://tiku.baidu.com/tikupc/singledetail/8027ccbff121dd36a32d8206', '1025991598199472129', '0');
INSERT INTO `crawler_question` VALUES ('1025991629606420482', 'https://tiku.baidu.com/tikupc/singledetail/340502020740be1e650e9a01', '1025991598199472129', '0');
INSERT INTO `crawler_question` VALUES ('1025991629606420481', 'https://tiku.baidu.com/tikupc/singledetail/22380b4c2e3f5727a5e9620b', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991629702889474', 'https://tiku.baidu.com/tikupc/singledetail/64f29e3143323968011c9201', '1025991598358855681', '0');
INSERT INTO `crawler_question` VALUES ('1025991629811941377', 'https://tiku.baidu.com/tikupc/singledetail/6844be1e650e52ea55189801', '1025991598199472129', '0');
INSERT INTO `crawler_question` VALUES ('1025991629828718594', 'https://tiku.baidu.com/tikupc/singledetail/a9d0195f312b3169a451a403', '1025991598358855681', '0');
INSERT INTO `crawler_question` VALUES ('1025991629933576194', 'https://tiku.baidu.com/tikupc/singledetail/1bfa700abb68a98271fefa03', '1025991598199472129', '0');
INSERT INTO `crawler_question` VALUES ('1025991629941964802', 'https://tiku.baidu.com/tikupc/singledetail/6846be1e650e52ea55189803', '1025991598358855681', '0');
INSERT INTO `crawler_question` VALUES ('1025991630055211010', 'https://tiku.baidu.com/tikupc/singledetail/536f7e21af45b307e8719702', '1025991598358855681', '0');
INSERT INTO `crawler_question` VALUES ('1025991630210400260', 'https://tiku.baidu.com/tikupc/singledetail/9d422e3f5727a5e9856a610b', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991630348812291', 'https://tiku.baidu.com/tikupc/singledetail/cd73b307e87101f69e319533', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991630210400258', 'https://tiku.baidu.com/tikupc/singledetail/de4ee518964bcf84b9d57b06', '1025991599105441793', '0');
INSERT INTO `crawler_question` VALUES ('1025991630348812290', 'https://tiku.baidu.com/tikupc/singledetail/70fb33d4b14e852458fb572c', '1025991599277408259', '0');
INSERT INTO `crawler_question` VALUES ('1025991630210400259', 'https://tiku.baidu.com/tikupc/singledetail/8e5fa26925c52cc58bd6be27', '1025991598568570881', '0');
INSERT INTO `crawler_question` VALUES ('1025991630516584449', 'https://tiku.baidu.com/tikupc/singledetail/6778a45177232f60ddcca114', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991630587887619', 'https://tiku.baidu.com/tikupc/singledetail/6b7caf1ffc4ffe473368ab12', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991630587887618', 'https://tiku.baidu.com/tikupc/singledetail/ec295a0216fc700abb68fc16', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991630587887620', 'https://tiku.baidu.com/tikupc/singledetail/d71f8e6fb84ae45c3b358c0d', '1025991598568570881', '0');
INSERT INTO `crawler_question` VALUES ('1025991630587887621', 'https://tiku.baidu.com/tikupc/singledetail/9d662e3f5727a5e9856a612f', '1025991599105441793', '0');
INSERT INTO `crawler_question` VALUES ('1025991630587887622', 'https://tiku.baidu.com/tikupc/singledetail/f20ffc4ffe4733687e21aa15', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991630571110401', 'https://tiku.baidu.com/tikupc/singledetail/99274431b90d6c85ec3ac633', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991630587887623', 'https://tiku.baidu.com/tikupc/singledetail/24193968011ca300a6c3902e', '1025991599277408259', '0');
INSERT INTO `crawler_question` VALUES ('1025991630587887624', 'https://tiku.baidu.com/tikupc/singledetail/2c0b5a8102d276a200292e3d', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991630755659778', 'https://tiku.baidu.com/tikupc/singledetail/d46d7175a417866fb84a8e45', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991630764048386', 'https://tiku.baidu.com/tikupc/singledetail/5401ed630b1c59eef8c7b429', '1025991599105441793', '0');
INSERT INTO `crawler_question` VALUES ('1025991630831157251', 'https://tiku.baidu.com/tikupc/singledetail/53427e21af45b307e871972f', '1025991599852027905', '0');
INSERT INTO `crawler_question` VALUES ('1025991630831157252', 'https://tiku.baidu.com/tikupc/singledetail/91035122aaea998fcc220eda', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991630831157253', 'https://tiku.baidu.com/tikupc/singledetail/409db9d528ea81c758f5781c', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991630831157250', 'https://tiku.baidu.com/tikupc/singledetail/64c09e3143323968011c9233', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991630831157254', 'https://tiku.baidu.com/tikupc/singledetail/2acf41649b6648d7c1c7461a', '1025991578591100930', '0');
INSERT INTO `crawler_question` VALUES ('1025991630755659779', 'https://tiku.baidu.com/tikupc/singledetail/5178011ca300a6c30c229f15', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991630764048387', 'https://tiku.baidu.com/tikupc/singledetail/d653ed18964bcf84b9d57b1b', '1025991598568570881', '0');
INSERT INTO `crawler_question` VALUES ('1025991630898266114', 'https://tiku.baidu.com/tikupc/singledetail/abc7bb4cf7ec4afe04a1df06', '1025991598954446849', '0');
INSERT INTO `crawler_question` VALUES ('1025991630889877506', 'https://tiku.baidu.com/tikupc/singledetail/f400cc7931b765ce05081414', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991630969569284', 'https://tiku.baidu.com/tikupc/singledetail/a95a804d2b160b4e767fcf00', '1025991599277408259', '0');
INSERT INTO `crawler_question` VALUES ('1025991630944403457', 'https://tiku.baidu.com/tikupc/singledetail/826b00d276a20029bd642def', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991630969569282', 'https://tiku.baidu.com/tikupc/singledetail/1d6c541252d380eb62946d03', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991630898266115', 'https://tiku.baidu.com/tikupc/singledetail/87e9dc36a32d7375a41780cd', '1025991514674102274', '0');
INSERT INTO `crawler_question` VALUES ('1025991630969569283', 'https://tiku.baidu.com/tikupc/singledetail/fa7283c4bb4cf7ec4afed044', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991630969569285', 'https://tiku.baidu.com/tikupc/singledetail/8008ccbff121dd36a32d8229', '1025991599105441793', '0');
INSERT INTO `crawler_question` VALUES ('1025991631296724994', 'https://tiku.baidu.com/tikupc/singledetail/9d3ca800b52acfc789ebc9fe', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991631296724995', 'https://tiku.baidu.com/tikupc/singledetail/5e3df18583d049649b665829', '1025991599277408259', '0');
INSERT INTO `crawler_question` VALUES ('1025991631296724997', 'https://tiku.baidu.com/tikupc/singledetail/13c358f5f61fb7360b4c6501', '1025991598954446849', '0');
INSERT INTO `crawler_question` VALUES ('1025991631296724993', 'https://tiku.baidu.com/tikupc/singledetail/0273148884868762caaed50f', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991631296724996', 'https://tiku.baidu.com/tikupc/singledetail/a7070912a21614791711283c', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991631036678145', 'https://tiku.baidu.com/tikupc/singledetail/4bd67f19227916888486d70a', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991631053455362', 'https://tiku.baidu.com/tikupc/singledetail/e910a21614791711cc791707', '1025991599986245634', '0');
INSERT INTO `crawler_question` VALUES ('1025991631418359810', 'https://tiku.baidu.com/tikupc/singledetail/9a713b3567ec102de2bd8928', '1025991599105441793', '0');
INSERT INTO `crawler_question` VALUES ('1025991631418359809', 'https://tiku.baidu.com/tikupc/singledetail/fce1770bf78a6529647d531f', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991631460302851', 'https://tiku.baidu.com/tikupc/singledetail/fcff770bf78a6529647d5301', '1025991598954446849', '0');
INSERT INTO `crawler_question` VALUES ('1025991631460302852', 'https://tiku.baidu.com/tikupc/singledetail/9c467cd184254b35eefd344d', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991631460302850', 'https://tiku.baidu.com/tikupc/singledetail/3cfb856a561252d380eb6e17', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991631544188931', 'https://tiku.baidu.com/tikupc/singledetail/c6d53186bceb19e8b8f6ba06', '1025991599986245634', '0');
INSERT INTO `crawler_question` VALUES ('1025991631544188932', 'https://tiku.baidu.com/tikupc/singledetail/aae30029bd64783e09122b44', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991631544188930', 'https://tiku.baidu.com/tikupc/singledetail/5142011ca300a6c30c229f2f', '1025991600133046273', '0');
INSERT INTO `crawler_question` VALUES ('1025991630994735106', 'https://tiku.baidu.com/tikupc/singledetail/e92ba21614791711cc79173c', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991631615492098', 'https://tiku.baidu.com/tikupc/singledetail/f3ee19e8b8f67c1cfad6b800', '1025991598954446849', '0');
INSERT INTO `crawler_question` VALUES ('1025991631011512321', 'https://tiku.baidu.com/tikupc/singledetail/1f0baf45b307e87101f6962f', '1025991599852027905', '0');
INSERT INTO `crawler_question` VALUES ('1025991631523217409', 'https://tiku.baidu.com/tikupc/singledetail/4e3359eef8c75fbfc77db22a', '1025991599277408259', '0');
INSERT INTO `crawler_question` VALUES ('1025991631615492097', 'https://tiku.baidu.com/tikupc/singledetail/9a5202768e9951e79b892724', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991631581937666', 'https://tiku.baidu.com/tikupc/singledetail/c5e104225901020207409c27', '1025991598568570881', '0');
INSERT INTO `crawler_question` VALUES ('1025991631699378179', 'https://tiku.baidu.com/tikupc/singledetail/60c68bd63186bceb19e8bb06', '1025991600133046273', '0');
INSERT INTO `crawler_question` VALUES ('1025991631699378178', 'https://tiku.baidu.com/tikupc/singledetail/cd6fb307e87101f69e31952f', '1025991599852027905', '0');
INSERT INTO `crawler_question` VALUES ('1025991631711961091', 'https://tiku.baidu.com/tikupc/singledetail/7a2779563c1ec5da50e27028', '1025991598954446849', '0');
INSERT INTO `crawler_question` VALUES ('1025991631711961090', 'https://tiku.baidu.com/tikupc/singledetail/1f22af45b307e87101f69606', '1025991599986245634', '0');
INSERT INTO `crawler_question` VALUES ('1025991631745515521', 'https://tiku.baidu.com/tikupc/singledetail/a18279fe910ef12d2af9e705', '1025991598568570881', '0');
INSERT INTO `crawler_question` VALUES ('1025991631745515522', 'https://tiku.baidu.com/tikupc/singledetail/64e2d1f34693daef5ef73d4d', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991631795847171', 'https://tiku.baidu.com/tikupc/singledetail/a9d5195f312b3169a451a406', '1025991599986245634', '0');
INSERT INTO `crawler_question` VALUES ('1025991631795847170', 'https://tiku.baidu.com/tikupc/singledetail/cdc00c225901020207409c06', '1025991600133046273', '0');
INSERT INTO `crawler_question` VALUES ('1025991631795847169', 'https://tiku.baidu.com/tikupc/singledetail/536d7e21af45b307e8719700', '1025991599852027905', '0');
INSERT INTO `crawler_question` VALUES ('1025991631858761730', 'https://tiku.baidu.com/tikupc/singledetail/5ef7001ca300a6c30c229f9a', '1025991539923812354', '0');
INSERT INTO `crawler_question` VALUES ('1025991631888121857', 'https://tiku.baidu.com/tikupc/singledetail/d9f376a20029bd64783e2c24', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991631896510467', 'https://tiku.baidu.com/tikupc/singledetail/1fd8f8c75fbfc77da269b133', '1025991599852027905', '0');
INSERT INTO `crawler_question` VALUES ('1025991631896510466', 'https://tiku.baidu.com/tikupc/singledetail/6589cc22bcd126fff7050b03', '1025991599986245634', '0');
INSERT INTO `crawler_question` VALUES ('1025991631900704769', 'https://tiku.baidu.com/tikupc/singledetail/29d7c8d376eeaeaad1f3302f', '1025991600133046273', '0');
INSERT INTO `crawler_question` VALUES ('1025991632051699713', 'https://tiku.baidu.com/tikupc/singledetail/b72429160b4e767f5acfce6c', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991632215277569', 'https://tiku.baidu.com/tikupc/singledetail/b6e1142ded630b1c59eeb50f', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991632215277570', 'https://tiku.baidu.com/tikupc/singledetail/80c902d276a20029bd642d4d', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991632215277571', 'https://tiku.baidu.com/tikupc/singledetail/7e21bb68a98271fe910ef92e', '1025991600133046273', '0');
INSERT INTO `crawler_question` VALUES ('1025991632303357954', 'https://tiku.baidu.com/tikupc/singledetail/a51ca32d7375a417866f8f2f', '1025991600393093121', '0');
INSERT INTO `crawler_question` VALUES ('1025991632303357955', 'https://tiku.baidu.com/tikupc/singledetail/b97c2b160b4e767f5acfce34', '1025991600518922241', '0');
INSERT INTO `crawler_question` VALUES ('1025991632404021249', 'https://tiku.baidu.com/tikupc/singledetail/1a120366f5335a8102d22038', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991632433381378', 'https://tiku.baidu.com/tikupc/singledetail/9f72c850ad02de80d4d8403d', '1025991600518922241', '0');
INSERT INTO `crawler_question` VALUES ('1025991632433381379', 'https://tiku.baidu.com/tikupc/singledetail/b93b5727a5e9856a56126001', '1025991600393093121', '0');
INSERT INTO `crawler_question` VALUES ('1025991632483713025', 'https://tiku.baidu.com/tikupc/singledetail/f709cf7931b765ce0508141d', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991632508878850', 'https://tiku.baidu.com/tikupc/singledetail/1d17453610661ed9ad51f33c', '1025991600518922241', '0');
INSERT INTO `crawler_question` VALUES ('1025991632517267458', 'https://tiku.baidu.com/tikupc/singledetail/cd1652d380eb6294dd886c01', '1025991600393093121', '0');
INSERT INTO `crawler_question` VALUES ('1025991632559210497', 'https://tiku.baidu.com/tikupc/singledetail/6706b4360b4c2e3f5727631c', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991632634707969', 'https://tiku.baidu.com/tikupc/singledetail/afebfab069dc5022aaea0014', '1025991600518922241', '0');
INSERT INTO `crawler_question` VALUES ('1025991632634707970', 'https://tiku.baidu.com/tikupc/singledetail/86ed6137ee06eff9aef8072e', '1025991600393093121', '0');
INSERT INTO `crawler_question` VALUES ('1025991632747954177', 'https://tiku.baidu.com/tikupc/singledetail/b98a71fe910ef12d2af9e70d', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991632756342785', 'https://tiku.baidu.com/tikupc/singledetail/284031b765ce05087632133c', '1025991600518922241', '0');
INSERT INTO `crawler_question` VALUES ('1025991632747954178', 'https://tiku.baidu.com/tikupc/singledetail/169fa9956bec0975f465e2d8', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991632756342786', 'https://tiku.baidu.com/tikupc/singledetail/e9f07c1cfad6195f312ba603', '1025991600393093121', '0');
INSERT INTO `crawler_question` VALUES ('1025991632764731393', 'https://tiku.baidu.com/tikupc/singledetail/d8106edb6f1aff00bed51e07', '1025991600837689345', '0');
INSERT INTO `crawler_question` VALUES ('1025991632907337730', 'https://tiku.baidu.com/tikupc/singledetail/2e67fad6195f312b3169a57e', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991632915726337', 'https://tiku.baidu.com/tikupc/singledetail/61d404a1b0717fd5360cdc2f', '1025991600837689345', '0');
INSERT INTO `crawler_question` VALUES ('1025991632915726339', 'https://tiku.baidu.com/tikupc/singledetail/72e9e209581b6bd97f19ea06', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991632915726338', 'https://tiku.baidu.com/tikupc/singledetail/8e4fa26925c52cc58bd6be37', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991632966057986', 'https://tiku.baidu.com/tikupc/singledetail/9f6f1eb91a37f111f1855b06', '1025991600686694401', '0');
INSERT INTO `crawler_question` VALUES ('1025991632991223809', 'https://tiku.baidu.com/tikupc/singledetail/b2781b37f111f18583d05ac4', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991632991223810', 'https://tiku.baidu.com/tikupc/singledetail/42aa26fff705cc175527097e', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991633008001027', 'https://tiku.baidu.com/tikupc/singledetail/da02534de518964bcf847ce5', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991633008001026', 'https://tiku.baidu.com/tikupc/singledetail/993b4431b90d6c85ec3ac62f', '1025991600837689345', '0');
INSERT INTO `crawler_question` VALUES ('1025991633016389633', 'https://tiku.baidu.com/tikupc/singledetail/74e2e009581b6bd97f19ea0d', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991633054138369', 'https://tiku.baidu.com/tikupc/singledetail/13eb58f5f61fb7360b4c6529', '1025991600686694401', '0');
INSERT INTO `crawler_question` VALUES ('1025991633096081409', 'https://tiku.baidu.com/tikupc/singledetail/334d48649b6648d7c1c74698', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991633062526977', 'https://tiku.baidu.com/tikupc/singledetail/3f70844769eae009581bec79', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991633112858625', 'https://tiku.baidu.com/tikupc/singledetail/80ab02d276a20029bd642d2f', '1025991601814962182', '0');
INSERT INTO `crawler_question` VALUES ('1025991633138024450', 'https://tiku.baidu.com/tikupc/singledetail/147ade80d4d8d15abe234e7d', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991633138024452', 'https://tiku.baidu.com/tikupc/singledetail/1babce84b9d528ea81c779e5', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991633138024451', 'https://tiku.baidu.com/tikupc/singledetail/02b269dc5022aaea998f0f07', '1025991600837689345', '0');
INSERT INTO `crawler_question` VALUES ('1025991633196744706', 'https://tiku.baidu.com/tikupc/singledetail/1cad571252d380eb62946dc2', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991633196744707', 'https://tiku.baidu.com/tikupc/singledetail/d02ce87101f69e314332942e', '1025991601814962182', '0');
INSERT INTO `crawler_question` VALUES ('1025991633196744705', 'https://tiku.baidu.com/tikupc/singledetail/540a16fc700abb68a982fb0d', '1025991600686694401', '0');
INSERT INTO `crawler_question` VALUES ('1025991633188356098', 'https://tiku.baidu.com/tikupc/singledetail/345402020740be1e650e9a50', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991633234493443', 'https://tiku.baidu.com/tikupc/singledetail/879dda38376baf1ffc4fad54', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991633234493442', 'https://tiku.baidu.com/tikupc/singledetail/1760a8956bec0975f465e227', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991633242882050', 'https://tiku.baidu.com/tikupc/singledetail/f0ca8beb172ded630b1cb608', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991633251270657', 'https://tiku.baidu.com/tikupc/singledetail/9fedaa00b52acfc789ebc92f', '1025991600837689345', '0');
INSERT INTO `crawler_question` VALUES ('1025991633276436482', 'https://tiku.baidu.com/tikupc/singledetail/b8d584254b35eefdc8d33301', '1025991601194205186', '0');
INSERT INTO `crawler_question` VALUES ('1025991633293213698', 'https://tiku.baidu.com/tikupc/singledetail/f1463c1ec5da50e2524d7f15', '1025991600686694401', '0');
INSERT INTO `crawler_question` VALUES ('1025991633293213699', 'https://tiku.baidu.com/tikupc/singledetail/64a5a55177232f60ddcca1c9', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991633305796610', 'https://tiku.baidu.com/tikupc/singledetail/60b98bd63186bceb19e8bb79', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991633330962434', 'https://tiku.baidu.com/tikupc/singledetail/e82025c52cc58bd63186bd4c', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991633330962435', 'https://tiku.baidu.com/tikupc/singledetail/1c85aef8941ea76e58fa0479', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991633293213697', 'https://tiku.baidu.com/tikupc/singledetail/8022ccbff121dd36a32d8203', '1025991601542332418', '0');
INSERT INTO `crawler_question` VALUES ('1025991633356128257', 'https://tiku.baidu.com/tikupc/singledetail/1429de80d4d8d15abe234e2e', '1025991601814962182', '0');
INSERT INTO `crawler_question` VALUES ('1025991633406459906', 'https://tiku.baidu.com/tikupc/singledetail/137f852458fb770bf78a5534', '1025991601194205186', '0');
INSERT INTO `crawler_question` VALUES ('1025991633494540291', 'https://tiku.baidu.com/tikupc/singledetail/9a7502768e9951e79b892703', '1025991601814962182', '0');
INSERT INTO `crawler_question` VALUES ('1025991633494540290', 'https://tiku.baidu.com/tikupc/singledetail/14c09ec3d5bbfd0a79567303', '1025991601542332418', '0');
INSERT INTO `crawler_question` VALUES ('1025991633494540289', 'https://tiku.baidu.com/tikupc/singledetail/fb64760bf78a6529647d539a', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991633494540293', 'https://tiku.baidu.com/tikupc/singledetail/d8926edb6f1aff00bed51e85', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991633494540292', 'https://tiku.baidu.com/tikupc/singledetail/32de49649b6648d7c1c7460b', '1025991602003705857', '0');
INSERT INTO `crawler_question` VALUES ('1025991633494540294', 'https://tiku.baidu.com/tikupc/singledetail/49cab8f67c1cfad6195fa727', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991633595203586', 'https://tiku.baidu.com/tikupc/singledetail/62423369a45177232f60a26c', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991633578426370', 'https://tiku.baidu.com/tikupc/singledetail/d4a365ce0508763231121211', '1025991601194205186', '0');
INSERT INTO `crawler_question` VALUES ('1025991633645535235', 'https://tiku.baidu.com/tikupc/singledetail/f81f43323968011ca300912b', '1025991601542332418', '0');
INSERT INTO `crawler_question` VALUES ('1025991633645535234', 'https://tiku.baidu.com/tikupc/singledetail/19650066f5335a8102d2204f', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991633662312450', 'https://tiku.baidu.com/tikupc/singledetail/a500a32d7375a417866f8f33', '1025991602003705857', '0');
INSERT INTO `crawler_question` VALUES ('1025991633662312452', 'https://tiku.baidu.com/tikupc/singledetail/6000590102020740be1e9b27', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991633662312453', 'https://tiku.baidu.com/tikupc/singledetail/5f62ed3a87c24028915fc3e2', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991633662312451', 'https://tiku.baidu.com/tikupc/singledetail/64d9d4d8d15abe23482f4d5c', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991633708449795', 'https://tiku.baidu.com/tikupc/singledetail/f48ffe4ffe4733687e21aa95', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991633729421313', 'https://tiku.baidu.com/tikupc/singledetail/1c7f6394dd88d0d233d46a91', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991633708449794', 'https://tiku.baidu.com/tikupc/singledetail/9c107cd184254b35eefd341b', '1025991601194205186', '0');
INSERT INTO `crawler_question` VALUES ('1025991633762975746', 'https://tiku.baidu.com/tikupc/singledetail/6ff6d15abe23482fb4da4c2b', '1025991601542332418', '0');
INSERT INTO `crawler_question` VALUES ('1025991633783947266', 'https://tiku.baidu.com/tikupc/singledetail/cee480eb6294dd88d0d26b32', '1025991602003705857', '0');
INSERT INTO `crawler_question` VALUES ('1025991633817501699', 'https://tiku.baidu.com/tikupc/singledetail/72870aa1284ac850ad024245', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991633817501700', 'https://tiku.baidu.com/tikupc/singledetail/40a2e43a87c24028915fc322', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991633817501702', 'https://tiku.baidu.com/tikupc/singledetail/1a55d4bbfd0a79563c1e7293', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991633817501698', 'https://tiku.baidu.com/tikupc/singledetail/51a86529647d27284b735127', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991633876221955', 'https://tiku.baidu.com/tikupc/singledetail/220e0b4c2e3f5727a5e9623d', '1025991602003705857', '0');
INSERT INTO `crawler_question` VALUES ('1025991633876221954', 'https://tiku.baidu.com/tikupc/singledetail/bd0503d8ce2f0066f5332202', '1025991601542332418', '0');
INSERT INTO `crawler_question` VALUES ('1025991633876221953', 'https://tiku.baidu.com/tikupc/singledetail/532e7e21af45b307e8719743', '1025991601194205186', '0');
INSERT INTO `crawler_question` VALUES ('1025991633960108033', 'https://tiku.baidu.com/tikupc/singledetail/cc3b8d9951e79b8968022648', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991633976885250', 'https://tiku.baidu.com/tikupc/singledetail/d9dae418964bcf84b9d57b92', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991633976885249', 'https://tiku.baidu.com/tikupc/singledetail/42f99c1ea76e58fafab00304', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991634073354241', 'https://tiku.baidu.com/tikupc/singledetail/dbec524de518964bcf847c0b', '1025991602775457799', '0');
INSERT INTO `crawler_question` VALUES ('1025991634073354242', 'https://tiku.baidu.com/tikupc/singledetail/00e676eeaeaad1f346933f30', '1025991602234392577', '0');
INSERT INTO `crawler_question` VALUES ('1025991634073354243', 'https://tiku.baidu.com/tikupc/singledetail/762bddccda38376baf1fae4e', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991634157240322', 'https://tiku.baidu.com/tikupc/singledetail/5fdaf10f76c66137ee06192c', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991634174017537', 'https://tiku.baidu.com/tikupc/singledetail/03b8178884868762caaed5c4', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991634174017538', 'https://tiku.baidu.com/tikupc/singledetail/d8036edb6f1aff00bed51e14', '1025991602775457799', '0');
INSERT INTO `crawler_question` VALUES ('1025991634299846657', 'https://tiku.baidu.com/tikupc/singledetail/53b5fd0a79563c1ec5da710b', '1025991602234392577', '0');
INSERT INTO `crawler_question` VALUES ('1025991634299846658', 'https://tiku.baidu.com/tikupc/singledetail/ba9bf121dd36a32d73758121', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991634425675778', 'https://tiku.baidu.com/tikupc/singledetail/33ef57270722192e4536f6fc', '1025991602775457799', '0');
INSERT INTO `crawler_question` VALUES ('1025991634471813121', 'https://tiku.baidu.com/tikupc/singledetail/df5c866fb84ae45c3b358c4e', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991634471813122', 'https://tiku.baidu.com/tikupc/singledetail/17e15ef7ba0d4a7302763a0b', '1025991602234392577', '0');
INSERT INTO `crawler_question` VALUES ('1025991634580865027', 'https://tiku.baidu.com/tikupc/singledetail/22120b4c2e3f5727a5e96221', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991634580865026', 'https://tiku.baidu.com/tikupc/singledetail/a9550b1c59eef8c75fbfb333', '1025991602234392577', '0');
INSERT INTO `crawler_question` VALUES ('1025991634719277060', 'https://tiku.baidu.com/tikupc/singledetail/2f722f60ddccda38376baf54', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991634719277061', 'https://tiku.baidu.com/tikupc/singledetail/11910b4e767f5acfa1c7cd82', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991634719277058', 'https://tiku.baidu.com/tikupc/singledetail/9f7dc850ad02de80d4d84032', '1025991602234392577', '0');
INSERT INTO `crawler_question` VALUES ('1025991634719277059', 'https://tiku.baidu.com/tikupc/singledetail/1b88d5bbfd0a79563c1e724e', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991634807357442', 'https://tiku.baidu.com/tikupc/singledetail/1816c67da26925c52cc5bfac', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991634807357443', 'https://tiku.baidu.com/tikupc/singledetail/e22d763231126edb6f1a1020', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991634874466306', 'https://tiku.baidu.com/tikupc/singledetail/1cf1730abb68a98271fefa08', '1025991580948299784', '0');
INSERT INTO `crawler_question` VALUES ('1025991634874466307', 'https://tiku.baidu.com/tikupc/singledetail/fc10dd88d0d233d4b14e6981', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991634891243522', 'https://tiku.baidu.com/tikupc/singledetail/9fe768eae009581b6bd9eba5', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991634920603650', 'https://tiku.baidu.com/tikupc/singledetail/1b9dce84b9d528ea81c779d3', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991634928992258', 'https://tiku.baidu.com/tikupc/singledetail/843fff00bed5b9f3f90f1c20', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991634958352387', 'https://tiku.baidu.com/tikupc/singledetail/3cb6856a561252d380eb6e5a', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991634958352386', 'https://tiku.baidu.com/tikupc/singledetail/8717fc00bed5b9f3f90f1c08', '1025991580948299784', '0');
INSERT INTO `crawler_question` VALUES ('1025991635025461250', 'https://tiku.baidu.com/tikupc/singledetail/913f5122aaea998fcc220ee6', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991635038044162', 'https://tiku.baidu.com/tikupc/singledetail/519a6529647d27284b735115', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991635038044163', 'https://tiku.baidu.com/tikupc/singledetail/aa07aaea998fcc22bcd10d20', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991635084181506', 'https://tiku.baidu.com/tikupc/singledetail/27042760ddccda38376baf22', '1025991580948299784', '0');
INSERT INTO `crawler_question` VALUES ('1025991635084181507', 'https://tiku.baidu.com/tikupc/singledetail/336c48649b6648d7c1c746b9', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991635142901761', 'https://tiku.baidu.com/tikupc/singledetail/df3785c24028915f804dc208', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991635142901762', 'https://tiku.baidu.com/tikupc/singledetail/d03fe87101f69e314332943d', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991635151290369', 'https://tiku.baidu.com/tikupc/singledetail/1bda700abb68a98271fefa23', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991635230982146', 'https://tiku.baidu.com/tikupc/singledetail/359984868762caaedd33d414', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991635230982145', 'https://tiku.baidu.com/tikupc/singledetail/04f8a6f8941ea76e58fa0404', '1025991580948299784', '0');
INSERT INTO `crawler_question` VALUES ('1025991635239370755', 'https://tiku.baidu.com/tikupc/singledetail/7ca10975f46527d3240ce048', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991635239370753', 'https://tiku.baidu.com/tikupc/singledetail/140dde80d4d8d15abe234e0a', '1025991564531793924', '0');
INSERT INTO `crawler_question` VALUES ('1025991635239370754', 'https://tiku.baidu.com/tikupc/singledetail/843edb38376baf1ffc4fadf7', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991635323256834', 'https://tiku.baidu.com/tikupc/singledetail/8ab0daef5ef7ba0d4a733b26', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991635323256833', 'https://tiku.baidu.com/tikupc/singledetail/cbcdf61fb7360b4c2e3f643d', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991635373588481', 'https://tiku.baidu.com/tikupc/singledetail/76db905f804d2b160b4ec0f6', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991635373588482', 'https://tiku.baidu.com/tikupc/singledetail/6a81bf23482fb4daa58d4bde', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991635373588483', 'https://tiku.baidu.com/tikupc/singledetail/1f7a561252d380eb62946d15', '1025991564531793924', '0');
INSERT INTO `crawler_question` VALUES ('1025991635373588485', 'https://tiku.baidu.com/tikupc/singledetail/640d3169a45177232f60a223', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991635373588484', 'https://tiku.baidu.com/tikupc/singledetail/635c783e0912a2161479293d', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991635373588486', 'https://tiku.baidu.com/tikupc/singledetail/0ab6a517866fb84ae45c8dc6', '1025991604113440769', '0');
INSERT INTO `crawler_question` VALUES ('1025991635549749250', 'https://tiku.baidu.com/tikupc/singledetail/83c90508763231126edb1102', '1025991604285407236', '0');
INSERT INTO `crawler_question` VALUES ('1025991635558137858', 'https://tiku.baidu.com/tikupc/singledetail/b1efacaad1f34693daef3e04', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991635595886593', 'https://tiku.baidu.com/tikupc/singledetail/86fe6137ee06eff9aef8073d', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991635595886594', 'https://tiku.baidu.com/tikupc/singledetail/14f574c66137ee06eff918ff', '1025991604113440769', '0');
INSERT INTO `crawler_question` VALUES ('1025991635595886595', 'https://tiku.baidu.com/tikupc/singledetail/fcadc1c708a1284ac850437f', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991635709132801', 'https://tiku.baidu.com/tikupc/singledetail/76a3b90d6c85ec3a87c2c597', '1025991604285407236', '0');
INSERT INTO `crawler_question` VALUES ('1025991635738492929', 'https://tiku.baidu.com/tikupc/singledetail/2e7b33b765ce050876321307', '1025991540678787076', '0');
INSERT INTO `crawler_question` VALUES ('1025991635738492930', 'https://tiku.baidu.com/tikupc/singledetail/9e0731126edb6f1aff001f30', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991635738492931', 'https://tiku.baidu.com/tikupc/singledetail/1dfa6294dd88d0d233d46a14', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991635738492932', 'https://tiku.baidu.com/tikupc/singledetail/6c6d2c79168884868762d671', '1025991604113440769', '0');
INSERT INTO `crawler_question` VALUES ('1025991635813990403', 'https://tiku.baidu.com/tikupc/singledetail/09fe581252d380eb62946d91', '1025991581472587778', '0');
INSERT INTO `crawler_question` VALUES ('1025991635813990402', 'https://tiku.baidu.com/tikupc/singledetail/6ef12cc58bd63186bcebbc31', '1025991604285407236', '0');
INSERT INTO `crawler_question` VALUES ('1025991635876904962', 'https://tiku.baidu.com/tikupc/singledetail/0a54a0f8941ea76e58fa04a8', '1025991604113440769', '0');
INSERT INTO `crawler_question` VALUES ('1025991635872710657', 'https://tiku.baidu.com/tikupc/singledetail/408ab9d528ea81c758f5780b', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991635927236610', 'https://tiku.baidu.com/tikupc/singledetail/9028e3bd960590c69ec37600', '1025991581472587778', '0');
INSERT INTO `crawler_question` VALUES ('1025991635973373953', 'https://tiku.baidu.com/tikupc/singledetail/620fb7360b4c2e3f57276315', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991636086620162', 'https://tiku.baidu.com/tikupc/singledetail/8336f12d2af90242a895e53d', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991636095008771', 'https://tiku.baidu.com/tikupc/singledetail/c254647d27284b73f2425078', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991636095008772', 'https://tiku.baidu.com/tikupc/singledetail/8292d2ef5ef7ba0d4a733b04', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991636191477762', 'https://tiku.baidu.com/tikupc/singledetail/114df46527d3240c8447ef3d', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991636191477763', 'https://tiku.baidu.com/tikupc/singledetail/4e4b59eef8c75fbfc77db252', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991636237615105', 'https://tiku.baidu.com/tikupc/singledetail/eb767f232f60ddccda38a022', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991636350861313', 'https://tiku.baidu.com/tikupc/singledetail/f1013c1ec5da50e2524d7f52', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991636384415745', 'https://tiku.baidu.com/tikupc/singledetail/063c1b2e453610661ed9f41b', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991636384415746', 'https://tiku.baidu.com/tikupc/singledetail/92c4b14e852458fb770b5615', '1025991604453179394', '0');
INSERT INTO `crawler_question` VALUES ('1025991636409581570', 'https://tiku.baidu.com/tikupc/singledetail/c8b8e53a580216fc700afd3c', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991636401192961', 'https://tiku.baidu.com/tikupc/singledetail/9296b14e852458fb770b5647', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991636447330306', 'https://tiku.baidu.com/tikupc/singledetail/5ac7306c1eb91a37f1115c80', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991636447330307', 'https://tiku.baidu.com/tikupc/singledetail/dbb5524de518964bcf847c52', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991636464107521', 'https://tiku.baidu.com/tikupc/singledetail/85edfe00bed5b9f3f90f1cf2', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991636581548034', 'https://tiku.baidu.com/tikupc/singledetail/0938a417866fb84ae45c8d48', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991636581548035', 'https://tiku.baidu.com/tikupc/singledetail/e3cbddbbfd0a79563c1e720d', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991636581548033', 'https://tiku.baidu.com/tikupc/singledetail/beaf6bec0975f46527d3e13f', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991636581548036', 'https://tiku.baidu.com/tikupc/singledetail/cf70a5e9856a561252d36f52', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991636678017027', 'https://tiku.baidu.com/tikupc/singledetail/11350b4e767f5acfa1c7cd26', '1025991552838074370', '0');
INSERT INTO `crawler_question` VALUES ('1025991636678017026', 'https://tiku.baidu.com/tikupc/singledetail/ab6df21dc281e53a5802ff39', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991636678017028', 'https://tiku.baidu.com/tikupc/singledetail/164276c66137ee06eff91848', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991636736737281', 'https://tiku.baidu.com/tikupc/singledetail/55dbec630b1c59eef8c7b4f3', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991636770291714', 'https://tiku.baidu.com/tikupc/singledetail/92c6b14e852458fb770b5617', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991636770291715', 'https://tiku.baidu.com/tikupc/singledetail/5fb881d049649b6648d74738', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991636761903106', 'https://tiku.baidu.com/tikupc/singledetail/7a3079563c1ec5da50e2703f', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991636770291713', 'https://tiku.baidu.com/tikupc/singledetail/a16433687e21af45b307a826', '1025991552838074370', '0');
INSERT INTO `crawler_question` VALUES ('1025991636778680321', 'https://tiku.baidu.com/tikupc/singledetail/fb1a9b6648d7c1c708a1457b', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991636812234753', 'https://tiku.baidu.com/tikupc/singledetail/55effb0f76c66137ee061919', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991636870955009', 'https://tiku.baidu.com/tikupc/singledetail/571c0722192e45361066f53e', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991636870955010', 'https://tiku.baidu.com/tikupc/singledetail/a9ec195f312b3169a451a43f', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991636870955011', 'https://tiku.baidu.com/tikupc/singledetail/8627fd00bed5b9f3f90f1c38', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991636879343617', 'https://tiku.baidu.com/tikupc/singledetail/40e44a35eefdc8d376ee32c4', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991636917092353', 'https://tiku.baidu.com/tikupc/singledetail/7535935f804d2b160b4ec018', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991636954841089', 'https://tiku.baidu.com/tikupc/singledetail/b9015727a5e9856a5612603b', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991636954841090', 'https://tiku.baidu.com/tikupc/singledetail/64e59e3143323968011c9216', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991637000978433', 'https://tiku.baidu.com/tikupc/singledetail/94c8b42acfc789eb172dc8cd', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991637017755650', 'https://tiku.baidu.com/tikupc/singledetail/ec9226d3240c844769eaeef2', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991637068087297', 'https://tiku.baidu.com/tikupc/singledetail/cec080eb6294dd88d0d26b16', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991637164556290', 'https://tiku.baidu.com/tikupc/singledetail/1b90a2116c175f0e7cd13718', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991637189722115', 'https://tiku.baidu.com/tikupc/singledetail/b3be1a37f111f18583d05a02', '1025991605505949698', '0');
INSERT INTO `crawler_question` VALUES ('1025991637189722114', 'https://tiku.baidu.com/tikupc/singledetail/541116fc700abb68a982fb16', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991637181333505', 'https://tiku.baidu.com/tikupc/singledetail/29cc28ea81c758f5f61f671c', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991637240053762', 'https://tiku.baidu.com/tikupc/singledetail/75c7b80d6c85ec3a87c2c5f3', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991637328134145', 'https://tiku.baidu.com/tikupc/singledetail/a15d33687e21af45b307a81f', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991637328134146', 'https://tiku.baidu.com/tikupc/singledetail/5952336c1eb91a37f1115c15', '1025991605505949698', '0');
INSERT INTO `crawler_question` VALUES ('1025991637382660097', 'https://tiku.baidu.com/tikupc/singledetail/5721ee630b1c59eef8c7b409', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991637416214530', 'https://tiku.baidu.com/tikupc/singledetail/0f0c87d276a20029bd642d88', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991637437186049', 'https://tiku.baidu.com/tikupc/singledetail/60bc910ef12d2af90242e647', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991637487517698', 'https://tiku.baidu.com/tikupc/singledetail/9aca9389680203d8ce2f2428', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991637533655041', 'https://tiku.baidu.com/tikupc/singledetail/dee94bfe04a1b0717fd5dd00', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991637571403777', 'https://tiku.baidu.com/tikupc/singledetail/6803964bcf84b9d528ea7a1e', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991637588180994', 'https://tiku.baidu.com/tikupc/singledetail/c888899951e79b89680226fb', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991637604958210', 'https://tiku.baidu.com/tikupc/singledetail/49c3b8f67c1cfad6195fa72e', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991637651095555', 'https://tiku.baidu.com/tikupc/singledetail/40c7b9d528ea81c758f57846', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991637651095554', 'https://tiku.baidu.com/tikupc/singledetail/9349f6ec4afe04a1b071de00', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991637676261378', 'https://tiku.baidu.com/tikupc/singledetail/51e1ffd8d15abe23482f4d64', '1025991565144162308', '0');
INSERT INTO `crawler_question` VALUES ('1025991637705621505', 'https://tiku.baidu.com/tikupc/singledetail/cd2355270722192e4536f631', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991637705621506', 'https://tiku.baidu.com/tikupc/singledetail/74eee009581b6bd97f19ea01', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991637797896194', 'https://tiku.baidu.com/tikupc/singledetail/111b0b4e767f5acfa1c7cd08', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991637797896195', 'https://tiku.baidu.com/tikupc/singledetail/764bddccda38376baf1fae2e', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991637797896196', 'https://tiku.baidu.com/tikupc/singledetail/9104ef06eff9aef8941e0636', '1025991494503694338', '0');
INSERT INTO `crawler_question` VALUES ('1025991637890170882', 'https://tiku.baidu.com/tikupc/singledetail/263310a6f524ccbff121842e', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991637881782273', 'https://tiku.baidu.com/tikupc/singledetail/9f46c850ad02de80d4d84009', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991637986639874', 'https://tiku.baidu.com/tikupc/singledetail/47146bd97f1922791688e80a', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991637986639875', 'https://tiku.baidu.com/tikupc/singledetail/7f82bceb19e8b8f67c1cb901', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991638028582914', 'https://tiku.baidu.com/tikupc/singledetail/6c862ec58bd63186bcebbc46', '1025991583938838531', '0');
INSERT INTO `crawler_question` VALUES ('1025991638053748738', 'https://tiku.baidu.com/tikupc/singledetail/c3bc26284b73f242336c5fc4', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991638078914561', 'https://tiku.baidu.com/tikupc/singledetail/658ea0116c175f0e7cd13706', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991638087303169', 'https://tiku.baidu.com/tikupc/singledetail/e7e3102de2bd960590c6770a', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991638137634818', 'https://tiku.baidu.com/tikupc/singledetail/4143b8d528ea81c758f578c2', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991638192160769', 'https://tiku.baidu.com/tikupc/singledetail/3f08844769eae009581bec01', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991638200549377', 'https://tiku.baidu.com/tikupc/singledetail/643df524ccbff121dd36839e', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991638242492418', 'https://tiku.baidu.com/tikupc/singledetail/94fdb42acfc789eb172dc8f8', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991638313795587', 'https://tiku.baidu.com/tikupc/singledetail/d86af5335a8102d276a22f09', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991638313795586', 'https://tiku.baidu.com/tikupc/singledetail/cd6eb307e87101f69e31952e', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991638397681666', 'https://tiku.baidu.com/tikupc/singledetail/83199a89680203d8ce2f24fb', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991638456401923', 'https://tiku.baidu.com/tikupc/singledetail/8e79a26925c52cc58bd6be01', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991638456401922', 'https://tiku.baidu.com/tikupc/singledetail/5539bbf3f90f76c661371ae9', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991638456401924', 'https://tiku.baidu.com/tikupc/singledetail/833af12d2af90242a895e531', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991638506733569', 'https://tiku.baidu.com/tikupc/singledetail/53d917fc700abb68a982fbde', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991638557065220', 'https://tiku.baidu.com/tikupc/singledetail/22de588102d276a200292ee8', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991638557065218', 'https://tiku.baidu.com/tikupc/singledetail/fe0d581b6bd97f192279e901', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991638557065221', 'https://tiku.baidu.com/tikupc/singledetail/4d6b312b3169a4517723a331', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991638557065219', 'https://tiku.baidu.com/tikupc/singledetail/e9f27c1cfad6195f312ba601', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991638653534210', 'https://tiku.baidu.com/tikupc/singledetail/162476c66137ee06eff9182e', '1025991607221420035', '0');
INSERT INTO `crawler_question` VALUES ('1025991638653534209', 'https://tiku.baidu.com/tikupc/singledetail/cd1d52d380eb6294dd886c0a', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991638729031681', 'https://tiku.baidu.com/tikupc/singledetail/8c5a01f69e3143323968932e', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991638754197506', 'https://tiku.baidu.com/tikupc/singledetail/0958a417866fb84ae45c8d28', '1025991607221420035', '0');
INSERT INTO `crawler_question` VALUES ('1025991638754197507', 'https://tiku.baidu.com/tikupc/singledetail/fc9bdd88d0d233d4b14e690a', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991638754197505', 'https://tiku.baidu.com/tikupc/singledetail/f910c281e53a580216fcfe08', '1025991606856515587', '0');
INSERT INTO `crawler_question` VALUES ('1025991638783557634', 'https://tiku.baidu.com/tikupc/singledetail/99c24431b90d6c85ec3ac6d6', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991638825500674', 'https://tiku.baidu.com/tikupc/singledetail/648df524ccbff121dd36832e', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991638833889282', 'https://tiku.baidu.com/tikupc/singledetail/41b283d049649b6648d74732', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991638833889283', 'https://tiku.baidu.com/tikupc/singledetail/dbcf524de518964bcf847c28', '1025991607221420035', '0');
INSERT INTO `crawler_question` VALUES ('1025991638850666497', 'https://tiku.baidu.com/tikupc/singledetail/f6691711cc7931b765ce1515', '1025991606856515587', '0');
INSERT INTO `crawler_question` VALUES ('1025991638888415234', 'https://tiku.baidu.com/tikupc/singledetail/140ede80d4d8d15abe234e09', '1025991606504194049', '0');
INSERT INTO `crawler_question` VALUES ('1025991638888415233', 'https://tiku.baidu.com/tikupc/singledetail/c3bb657d27284b73f2425097', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991638905192449', 'https://tiku.baidu.com/tikupc/singledetail/b55fc5da50e2524de5187e44', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991638938746881', 'https://tiku.baidu.com/tikupc/singledetail/57c4f90f76c66137ee061932', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991638938746882', 'https://tiku.baidu.com/tikupc/singledetail/260f58fb770bf78a6529542e', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991638963912706', 'https://tiku.baidu.com/tikupc/singledetail/4be07f19227916888486d73c', '1025991606856515587', '0');
INSERT INTO `crawler_question` VALUES ('1025991639005855746', 'https://tiku.baidu.com/tikupc/singledetail/b524c5da50e2524de5187e3f', '1025991606504194049', '0');
INSERT INTO `crawler_question` VALUES ('1025991639005855747', 'https://tiku.baidu.com/tikupc/singledetail/95a7a9114431b90d6c85c7b8', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991639005855748', 'https://tiku.baidu.com/tikupc/singledetail/110d0b4e767f5acfa1c7cd1e', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991639043604483', 'https://tiku.baidu.com/tikupc/singledetail/4a375acfa1c7aa00b52acb4d', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991639043604482', 'https://tiku.baidu.com/tikupc/singledetail/6efd2cc58bd63186bcebbc3d', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991639043604481', 'https://tiku.baidu.com/tikupc/singledetail/9f66c850ad02de80d4d84029', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991639072964610', 'https://tiku.baidu.com/tikupc/singledetail/de5ae518964bcf84b9d57b12', '1025991606856515587', '0');
INSERT INTO `crawler_question` VALUES ('1025991639106519041', 'https://tiku.baidu.com/tikupc/singledetail/0a46a48da0116c175f0e4899', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991639106519042', 'https://tiku.baidu.com/tikupc/singledetail/64eb9e3143323968011c9218', '1025991606504194049', '0');
INSERT INTO `crawler_question` VALUES ('1025991639123296259', 'https://tiku.baidu.com/tikupc/singledetail/5174011ca300a6c30c229f19', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991639123296260', 'https://tiku.baidu.com/tikupc/singledetail/49f5b8f67c1cfad6195fa718', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991639161044993', 'https://tiku.baidu.com/tikupc/singledetail/53edfd0a79563c1ec5da7153', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991639186210817', 'https://tiku.baidu.com/tikupc/singledetail/a9e6195f312b3169a451a435', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991639215570945', 'https://tiku.baidu.com/tikupc/singledetail/64b4a55177232f60ddcca1d8', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991639215570946', 'https://tiku.baidu.com/tikupc/singledetail/53d9b9f3f90f76c661371a09', '1025991607817011202', '0');
INSERT INTO `crawler_question` VALUES ('1025991639223959553', 'https://tiku.baidu.com/tikupc/singledetail/8004ccbff121dd36a32d8225', '1025991606504194049', '0');
INSERT INTO `crawler_question` VALUES ('1025991639249125379', 'https://tiku.baidu.com/tikupc/singledetail/138458f5f61fb7360b4c6546', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991639249125378', 'https://tiku.baidu.com/tikupc/singledetail/cdde0c225901020207409c18', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991639257513986', 'https://tiku.baidu.com/tikupc/singledetail/d86d6edb6f1aff00bed51e7a', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991639274291201', 'https://tiku.baidu.com/tikupc/singledetail/6114a76e58fafab069dc020f', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991639307845634', 'https://tiku.baidu.com/tikupc/singledetail/b1844028915f804d2b16c143', '1025991607817011202', '0');
INSERT INTO `crawler_question` VALUES ('1025991639316234243', 'https://tiku.baidu.com/tikupc/singledetail/beb16bec0975f46527d3e121', '1025991606504194049', '0');
INSERT INTO `crawler_question` VALUES ('1025991639333011457', 'https://tiku.baidu.com/tikupc/singledetail/61bb04a1b0717fd5360cdc40', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991639358177281', 'https://tiku.baidu.com/tikupc/singledetail/f75ccc1755270722192ef75c', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991639358177282', 'https://tiku.baidu.com/tikupc/singledetail/61236c175f0e7cd184253637', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991639383343105', 'https://tiku.baidu.com/tikupc/singledetail/a9470b1c59eef8c75fbfb321', '1025991607817011202', '0');
INSERT INTO `crawler_question` VALUES ('1025991639408508930', 'https://tiku.baidu.com/tikupc/singledetail/b1c64028915f804d2b16c101', '1025991608169332737', '0');
INSERT INTO `crawler_question` VALUES ('1025991639408508931', 'https://tiku.baidu.com/tikupc/singledetail/de52e518964bcf84b9d57b1a', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991639463034882', 'https://tiku.baidu.com/tikupc/singledetail/57140722192e45361066f536', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991639463034884', 'https://tiku.baidu.com/tikupc/singledetail/fa4a83c4bb4cf7ec4afed07c', '1025991607817011202', '0');
INSERT INTO `crawler_question` VALUES ('1025991639463034883', 'https://tiku.baidu.com/tikupc/singledetail/60d96d175f0e7cd1842536cd', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991639525949442', 'https://tiku.baidu.com/tikupc/singledetail/0076168884868762caaed50a', '1025991608169332737', '0');
INSERT INTO `crawler_question` VALUES ('1025991639559503874', 'https://tiku.baidu.com/tikupc/singledetail/bec66bec0975f46527d3e156', '1025991607817011202', '0');
INSERT INTO `crawler_question` VALUES ('1025991639605641218', 'https://tiku.baidu.com/tikupc/singledetail/4fdd50e2524de518964b7d02', '1025991567354560516', '0');
INSERT INTO `crawler_question` VALUES ('1025991639618224129', 'https://tiku.baidu.com/tikupc/singledetail/4335bad528ea81c758f578b4', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991639756636162', 'https://tiku.baidu.com/tikupc/singledetail/70e033d4b14e852458fb5737', '1025991567354560516', '0');
INSERT INTO `crawler_question` VALUES ('1025991639756636161', 'https://tiku.baidu.com/tikupc/singledetail/11dd71c66137ee06eff918d7', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991639756636163', 'https://tiku.baidu.com/tikupc/singledetail/42e826fff705cc175527093c', '1025991608169332737', '0');
INSERT INTO `crawler_question` VALUES ('1025991639857299457', 'https://tiku.baidu.com/tikupc/singledetail/63f99d3143323968011c920a', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991639920214018', 'https://tiku.baidu.com/tikupc/singledetail/1f26af45b307e87101f69602', '1025991608450351106', '0');
INSERT INTO `crawler_question` VALUES ('1025991639970545665', 'https://tiku.baidu.com/tikupc/singledetail/fc23112e453610661ed9f407', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991640054431746', 'https://tiku.baidu.com/tikupc/singledetail/b9e581c758f5f61fb736660a', '1025991608450351106', '0');
INSERT INTO `crawler_question` VALUES ('1025991640062820353', 'https://tiku.baidu.com/tikupc/singledetail/6c634893daef5ef7ba0d3c95', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991640108957697', 'https://tiku.baidu.com/tikupc/singledetail/4088b9d528ea81c758f57809', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991640155095043', 'https://tiku.baidu.com/tikupc/singledetail/fa2bb84ae45c3b3567ec8b41', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991640155095042', 'https://tiku.baidu.com/tikupc/singledetail/a572a32d7375a417866f8f41', '1025991608450351106', '0');
INSERT INTO `crawler_question` VALUES ('1025991640218009602', 'https://tiku.baidu.com/tikupc/singledetail/8e4ba26925c52cc58bd6be33', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991640243175425', 'https://tiku.baidu.com/tikupc/singledetail/2e3efad6195f312b3169a527', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991640243175426', 'https://tiku.baidu.com/tikupc/singledetail/fe17581b6bd97f192279e91b', '1025991608450351106', '0');
INSERT INTO `crawler_question` VALUES ('1025991640243175427', 'https://tiku.baidu.com/tikupc/singledetail/042d192e453610661ed9f40a', '1025991608618123266', '0');
INSERT INTO `crawler_question` VALUES ('1025991640306089986', 'https://tiku.baidu.com/tikupc/singledetail/a0898762caaedd3383c4d30a', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991640360615938', 'https://tiku.baidu.com/tikupc/singledetail/b53dc5da50e2524de5187e26', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991640360615939', 'https://tiku.baidu.com/tikupc/singledetail/65caa0116c175f0e7cd13742', '1025991608450351106', '0');
INSERT INTO `crawler_question` VALUES ('1025991640369004545', 'https://tiku.baidu.com/tikupc/singledetail/541a16fc700abb68a982fb1d', '1025991608618123266', '0');
INSERT INTO `crawler_question` VALUES ('1025991640398364674', 'https://tiku.baidu.com/tikupc/singledetail/9243f7ec4afe04a1b071de0a', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991640431919106', 'https://tiku.baidu.com/tikupc/singledetail/fa3fb84ae45c3b3567ec8b55', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991640473862145', 'https://tiku.baidu.com/tikupc/singledetail/b8f184254b35eefdc8d33325', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991640507416578', 'https://tiku.baidu.com/tikupc/singledetail/16765ff7ba0d4a7302763a9c', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991640511610882', 'https://tiku.baidu.com/tikupc/singledetail/1700a8956bec0975f465e247', '1025991608618123266', '0');
INSERT INTO `crawler_question` VALUES ('1025991640511610883', 'https://tiku.baidu.com/tikupc/singledetail/b2574128915f804d2b16c190', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991640553553922', 'https://tiku.baidu.com/tikupc/singledetail/ed2d27d3240c844769eaee4d', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991640599691266', 'https://tiku.baidu.com/tikupc/singledetail/7b9378563c1ec5da50e2709c', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991640608079873', 'https://tiku.baidu.com/tikupc/singledetail/a71d8662caaedd3383c4d39e', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991640608079874', 'https://tiku.baidu.com/tikupc/singledetail/51cb360cba1aa8114431d91b', '1025991608618123266', '0');
INSERT INTO `crawler_question` VALUES ('1025991640624857089', 'https://tiku.baidu.com/tikupc/singledetail/a7080912a216147917112833', '1025991567685910530', '0');
INSERT INTO `crawler_question` VALUES ('1025991640650022914', 'https://tiku.baidu.com/tikupc/singledetail/ce2a650e52ea551810a68731', '1025991608869781505', '0');
INSERT INTO `crawler_question` VALUES ('1025991640675188738', 'https://tiku.baidu.com/tikupc/singledetail/29b5c8d376eeaeaad1f3304d', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991640675188739', 'https://tiku.baidu.com/tikupc/singledetail/a25ffe4733687e21af45a915', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991640691965954', 'https://tiku.baidu.com/tikupc/singledetail/0f4a77eeaeaad1f346933f9c', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991640691965955', 'https://tiku.baidu.com/tikupc/singledetail/546ff80f76c66137ee061999', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991640691965956', 'https://tiku.baidu.com/tikupc/singledetail/b9a181c758f5f61fb736664e', '1025991608618123266', '0');
INSERT INTO `crawler_question` VALUES ('1025991640750686209', 'https://tiku.baidu.com/tikupc/singledetail/14d79ec3d5bbfd0a79567314', '1025991567685910530', '0');
INSERT INTO `crawler_question` VALUES ('1025991640792629250', 'https://tiku.baidu.com/tikupc/singledetail/1c3feff9aef8941ea76e053c', '1025991608869781505', '0');
INSERT INTO `crawler_question` VALUES ('1025991640792629251', 'https://tiku.baidu.com/tikupc/singledetail/6032590102020740be1e9b15', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991640792629252', 'https://tiku.baidu.com/tikupc/singledetail/f430cc7931b765ce05081424', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991640859738113', 'https://tiku.baidu.com/tikupc/singledetail/318b777f5acfa1c7aa00ccc0', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991640893292545', 'https://tiku.baidu.com/tikupc/singledetail/02a169dc5022aaea998f0f14', '1025991567685910530', '0');
INSERT INTO `crawler_question` VALUES ('1025991640893292546', 'https://tiku.baidu.com/tikupc/singledetail/6025590102020740be1e9b02', '1025991609033359362', '0');
INSERT INTO `crawler_question` VALUES ('1025991640943624193', 'https://tiku.baidu.com/tikupc/singledetail/22260b4c2e3f5727a5e96215', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991640952012802', 'https://tiku.baidu.com/tikupc/singledetail/afccfab069dc5022aaea0033', '1025991609364709378', '0');
INSERT INTO `crawler_question` VALUES ('1025991640952012803', 'https://tiku.baidu.com/tikupc/singledetail/8438ff00bed5b9f3f90f1c27', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991640952012804', 'https://tiku.baidu.com/tikupc/singledetail/b92a5727a5e9856a56126010', '1025991608869781505', '0');
INSERT INTO `crawler_question` VALUES ('1025991640952012805', 'https://tiku.baidu.com/tikupc/singledetail/a94c0b1c59eef8c75fbfb32a', '1025991609192742916', '0');
INSERT INTO `crawler_question` VALUES ('1025991641031704579', 'https://tiku.baidu.com/tikupc/singledetail/cec380eb6294dd88d0d26b15', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991641031704578', 'https://tiku.baidu.com/tikupc/singledetail/d18a640e52ea551810a68791', '1025991609033359362', '0');
INSERT INTO `crawler_question` VALUES ('1025991641052676097', 'https://tiku.baidu.com/tikupc/singledetail/6807964bcf84b9d528ea7a1a', '1025991608869781505', '0');
INSERT INTO `crawler_question` VALUES ('1025991641052676099', 'https://tiku.baidu.com/tikupc/singledetail/ce18650e52ea551810a68703', '1025991609637339138', '0');
INSERT INTO `crawler_question` VALUES ('1025991641052676098', 'https://tiku.baidu.com/tikupc/singledetail/65b9cc22bcd126fff7050b33', '1025991609364709378', '0');
INSERT INTO `crawler_question` VALUES ('1025991641086230530', 'https://tiku.baidu.com/tikupc/singledetail/4f8658eef8c75fbfc77db29f', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991641123979267', 'https://tiku.baidu.com/tikupc/singledetail/028369dc5022aaea998f0f36', '1025991609033359362', '0');
INSERT INTO `crawler_question` VALUES ('1025991641123979266', 'https://tiku.baidu.com/tikupc/singledetail/0041168884868762caaed53d', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991641140756482', 'https://tiku.baidu.com/tikupc/singledetail/7e43bb68a98271fe910ef94c', '1025991608869781505', '0');
INSERT INTO `crawler_question` VALUES ('1025991641153339394', 'https://tiku.baidu.com/tikupc/singledetail/74e7e009581b6bd97f19ea08', '1025991609637339138', '0');
INSERT INTO `crawler_question` VALUES ('1025991641153339395', 'https://tiku.baidu.com/tikupc/singledetail/5e212279168884868762d63d', '1025991609364709378', '0');
INSERT INTO `crawler_question` VALUES ('1025991641182699523', 'https://tiku.baidu.com/tikupc/singledetail/fbf182c4bb4cf7ec4afed0c7', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991641182699522', 'https://tiku.baidu.com/tikupc/singledetail/685c964bcf84b9d528ea7a41', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991641228836866', 'https://tiku.baidu.com/tikupc/singledetail/87dcda38376baf1ffc4fad15', '1025991609033359362', '0');
INSERT INTO `crawler_question` VALUES ('1025991641245614081', 'https://tiku.baidu.com/tikupc/singledetail/a94f804d2b160b4e767fcf15', '1025991609637339138', '0');
INSERT INTO `crawler_question` VALUES ('1025991641245614082', 'https://tiku.baidu.com/tikupc/singledetail/539ab9f3f90f76c661371a4a', '1025991609364709378', '0');
INSERT INTO `crawler_question` VALUES ('1025991641312722946', 'https://tiku.baidu.com/tikupc/singledetail/67e4580102020740be1e9bc3', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991641312722947', 'https://tiku.baidu.com/tikupc/singledetail/6853a300a6c30c2259019e4a', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991641354665985', 'https://tiku.baidu.com/tikupc/singledetail/a9c7195f312b3169a451a414', '1025991609033359362', '0');
INSERT INTO `crawler_question` VALUES ('1025991641379831810', 'https://tiku.baidu.com/tikupc/singledetail/0294148884868762caaed5e8', '1025991609364709378', '0');
INSERT INTO `crawler_question` VALUES ('1025991641379831811', 'https://tiku.baidu.com/tikupc/singledetail/840aff00bed5b9f3f90f1c15', '1025991609637339138', '0');
INSERT INTO `crawler_question` VALUES ('1025991641404997634', 'https://tiku.baidu.com/tikupc/singledetail/a71f0912a216147917112824', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991641413386241', 'https://tiku.baidu.com/tikupc/singledetail/65689f3143323968011c929b', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991641438552065', 'https://tiku.baidu.com/tikupc/singledetail/c978a6c30c22590102029d7d', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991641463717890', 'https://tiku.baidu.com/tikupc/singledetail/42c126fff705cc1755270915', '1025991609637339138', '0');
INSERT INTO `crawler_question` VALUES ('1025991641518243843', 'https://tiku.baidu.com/tikupc/singledetail/507f988fcc22bcd126ff0c90', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991641518243842', 'https://tiku.baidu.com/tikupc/singledetail/e933a21614791711cc791724', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991641518243844', 'https://tiku.baidu.com/tikupc/singledetail/ff52dc88d0d233d4b14e69c3', '1025991542557835265', '0');
INSERT INTO `crawler_question` VALUES ('1025991641564381186', 'https://tiku.baidu.com/tikupc/singledetail/53eafd0a79563c1ec5da7154', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991641610518531', 'https://tiku.baidu.com/tikupc/singledetail/60b5910ef12d2af90242e64e', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991641610518530', 'https://tiku.baidu.com/tikupc/singledetail/9ccf7ed5360cba1aa811dabb', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991641660850177', 'https://tiku.baidu.com/tikupc/singledetail/8ebe89eb172ded630b1cb67c', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991641719570435', 'https://tiku.baidu.com/tikupc/singledetail/77a7b4eb19e8b8f67c1cb924', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991641719570434', 'https://tiku.baidu.com/tikupc/singledetail/53237e21af45b307e871974e', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991641824428035', 'https://tiku.baidu.com/tikupc/singledetail/8e0c4b73f242336c1eb95e21', '1025991496206581761', '0');
INSERT INTO `crawler_question` VALUES ('1025991641824428034', 'https://tiku.baidu.com/tikupc/singledetail/e826e07101f69e3143329424', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991641920897025', 'https://tiku.baidu.com/tikupc/singledetail/bc16f911f18583d049645924', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991641971228673', 'https://tiku.baidu.com/tikupc/singledetail/542d16fc700abb68a982fb2a', '1025991610367148034', '0');
INSERT INTO `crawler_question` VALUES ('1025991642013171713', 'https://tiku.baidu.com/tikupc/singledetail/0305a9f8941ea76e58fa04f9', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991642059309059', 'https://tiku.baidu.com/tikupc/singledetail/54b20622192e45361066f590', '1025991586614804484', '0');
INSERT INTO `crawler_question` VALUES ('1025991642059309058', 'https://tiku.baidu.com/tikupc/singledetail/b8dd84254b35eefdc8d33309', '1025991610367148034', '0');
INSERT INTO `crawler_question` VALUES ('1025991642105446401', 'https://tiku.baidu.com/tikupc/singledetail/e950fa42336c1eb91a375d26', '1025991567824322563', '0');
INSERT INTO `crawler_question` VALUES ('1025991642159972355', 'https://tiku.baidu.com/tikupc/singledetail/d68cf7335a8102d276a22fef', '1025991586614804484', '0');
INSERT INTO `crawler_question` VALUES ('1025991642151583745', 'https://tiku.baidu.com/tikupc/singledetail/64acd1f34693daef5ef73d03', '1025991609788334081', '0');
INSERT INTO `crawler_question` VALUES ('1025991642159972354', 'https://tiku.baidu.com/tikupc/singledetail/00eb76eeaeaad1f346933f3d', '1025991610367148034', '0');
INSERT INTO `crawler_question` VALUES ('1025991642193526785', 'https://tiku.baidu.com/tikupc/singledetail/e7d8102de2bd960590c67731', '1025991586870657025', '0');
INSERT INTO `crawler_question` VALUES ('1025991642285801473', 'https://tiku.baidu.com/tikupc/singledetail/e7fc102de2bd960590c67715', '1025991586870657025', '0');
INSERT INTO `crawler_question` VALUES ('1025991642277412866', 'https://tiku.baidu.com/tikupc/singledetail/6eea2cc58bd63186bcebbc2a', '1025991609788334081', '0');
INSERT INTO `crawler_question` VALUES ('1025991642340327425', 'https://tiku.baidu.com/tikupc/singledetail/113b0b4e767f5acfa1c7cd28', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991642390659074', 'https://tiku.baidu.com/tikupc/singledetail/ba87f121dd36a32d7375813d', '1025991586870657025', '0');
INSERT INTO `crawler_question` VALUES ('1025991642390659075', 'https://tiku.baidu.com/tikupc/singledetail/fb509b6648d7c1c708a14531', '1025991609788334081', '0');
INSERT INTO `crawler_question` VALUES ('1025991642474545156', 'https://tiku.baidu.com/tikupc/singledetail/cbe4f61fb7360b4c2e3f6414', '1025991586870657025', '0');
INSERT INTO `crawler_question` VALUES ('1025991642474545154', 'https://tiku.baidu.com/tikupc/singledetail/f15c3c1ec5da50e2524d7f0f', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991642566819842', 'https://tiku.baidu.com/tikupc/singledetail/66f9a100a6c30c2259019ee0', '1025991567962734595', '0');
INSERT INTO `crawler_question` VALUES ('1025991642566819841', 'https://tiku.baidu.com/tikupc/singledetail/639fce22bcd126fff7050b15', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991642633928705', 'https://tiku.baidu.com/tikupc/singledetail/c6e43186bceb19e8b8f6ba37', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991642713620482', 'https://tiku.baidu.com/tikupc/singledetail/c13b677d27284b73f2425017', '1025991567962734595', '0');
INSERT INTO `crawler_question` VALUES ('1025991642713620481', 'https://tiku.baidu.com/tikupc/singledetail/b8942a160b4e767f5acfcedc', '1025991586472198147', '0');
INSERT INTO `crawler_question` VALUES ('1025991642713620483', 'https://tiku.baidu.com/tikupc/singledetail/5e6e82d049649b6648d747ee', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991642713620484', 'https://tiku.baidu.com/tikupc/singledetail/29d928ea81c758f5f61f6709', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991642713620485', 'https://tiku.baidu.com/tikupc/singledetail/9c197cd184254b35eefd3412', '1025991610618806274', '0');
INSERT INTO `crawler_question` VALUES ('1025991642881392642', 'https://tiku.baidu.com/tikupc/singledetail/fc66770bf78a6529647d5398', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991642881392643', 'https://tiku.baidu.com/tikupc/singledetail/416d4b35eefdc8d376ee324d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991642881392644', 'https://tiku.baidu.com/tikupc/singledetail/da017375a417866fb84a8e29', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991642961084417', 'https://tiku.baidu.com/tikupc/singledetail/12b385d63186bceb19e8bb73', '1025991567962734595', '0');
INSERT INTO `crawler_question` VALUES ('1025991642961084418', 'https://tiku.baidu.com/tikupc/singledetail/be986bec0975f46527d3e108', '1025991554406744067', '0');
INSERT INTO `crawler_question` VALUES ('1025991642994638849', 'https://tiku.baidu.com/tikupc/singledetail/9de27fd5360cba1aa811da96', '1025991610618806274', '0');
INSERT INTO `crawler_question` VALUES ('1025991642994638853', 'https://tiku.baidu.com/tikupc/singledetail/b532c5da50e2524de5187e29', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991643191771139', 'https://tiku.baidu.com/tikupc/singledetail/1a9c3768011ca300a6c390ab', '1025991567962734595', '0');
INSERT INTO `crawler_question` VALUES ('1025991643191771140', 'https://tiku.baidu.com/tikupc/singledetail/5033988fcc22bcd126ff0cdc', '1025991586472198147', '0');
INSERT INTO `crawler_question` VALUES ('1025991643191771138', 'https://tiku.baidu.com/tikupc/singledetail/ecce96c3d5bbfd0a7956730d', '1025991611654799362', '0');
INSERT INTO `crawler_question` VALUES ('1025991643191771141', 'https://tiku.baidu.com/tikupc/singledetail/b5f6a88271fe910ef12df89b', '1025991611440889857', '0');
INSERT INTO `crawler_question` VALUES ('1025991642994638851', 'https://tiku.baidu.com/tikupc/singledetail/8d7deefdc8d376eeaeaa314d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991643242102786', 'https://tiku.baidu.com/tikupc/singledetail/6ca62ec58bd63186bcebbc66', '1025991610618806274', '0');
INSERT INTO `crawler_question` VALUES ('1025991643242102785', 'https://tiku.baidu.com/tikupc/singledetail/e9f37c1cfad6195f312ba600', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991642994638850', 'https://tiku.baidu.com/tikupc/singledetail/40ce4a35eefdc8d376ee32ee', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991643321794561', 'https://tiku.baidu.com/tikupc/singledetail/b1d2acaad1f34693daef3e39', '1025991586472198147', '0');
INSERT INTO `crawler_question` VALUES ('1025991643321794564', 'https://tiku.baidu.com/tikupc/singledetail/d3578e9951e79b8968022624', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991643321794563', 'https://tiku.baidu.com/tikupc/singledetail/f558bb07e87101f69e319518', '1025991611440889857', '0');
INSERT INTO `crawler_question` VALUES ('1025991643338571778', 'https://tiku.baidu.com/tikupc/singledetail/1dc76294dd88d0d233d46a29', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991643355348994', 'https://tiku.baidu.com/tikupc/singledetail/e2b92af90242a8956bece491', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991643355348995', 'https://tiku.baidu.com/tikupc/singledetail/42e226fff705cc1755270936', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991643321794562', 'https://tiku.baidu.com/tikupc/singledetail/aa33a22d7375a417866f8f00', '1025991611654799362', '0');
INSERT INTO `crawler_question` VALUES ('1025991643397292034', 'https://tiku.baidu.com/tikupc/singledetail/b75829160b4e767f5acfce10', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991643439235073', 'https://tiku.baidu.com/tikupc/singledetail/82c69b89680203d8ce2f2424', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991643447623682', 'https://tiku.baidu.com/tikupc/singledetail/20ef551810a6f524ccbf8500', '1025991533301006340', '0');
INSERT INTO `crawler_question` VALUES ('1025991643456012289', 'https://tiku.baidu.com/tikupc/singledetail/6324970590c69ec3d5bb759c', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991643447623684', 'https://tiku.baidu.com/tikupc/singledetail/d09a0c1c59eef8c75fbfb3fc', '1025991611440889857', '0');
INSERT INTO `crawler_question` VALUES ('1025991643456012290', 'https://tiku.baidu.com/tikupc/singledetail/5af4941ea76e58fafab00309', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991643510538244', 'https://tiku.baidu.com/tikupc/singledetail/72d30aa1284ac850ad024211', '1025991611847737348', '0');
INSERT INTO `crawler_question` VALUES ('1025991643510538243', 'https://tiku.baidu.com/tikupc/singledetail/685fa300a6c30c2259019e46', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991642994638852', 'https://tiku.baidu.com/tikupc/singledetail/8082366baf1ffc4ffe47acbf', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991643577647105', 'https://tiku.baidu.com/tikupc/singledetail/9a3b02768e9951e79b89274d', '1025991502477066243', '0');
INSERT INTO `crawler_question` VALUES ('1025991643577647107', 'https://tiku.baidu.com/tikupc/singledetail/599a8bd049649b6648d7471a', '1025991611440889857', '0');
INSERT INTO `crawler_question` VALUES ('1025991643577647106', 'https://tiku.baidu.com/tikupc/singledetail/ebf424c52cc58bd63186bd98', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991643632173058', 'https://tiku.baidu.com/tikupc/singledetail/7d7216791711cc7931b71661', '1025991611847737348', '0');
INSERT INTO `crawler_question` VALUES ('1025991643703476228', 'https://tiku.baidu.com/tikupc/singledetail/d49565ce0508763231121227', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991643703476226', 'https://tiku.baidu.com/tikupc/singledetail/aed80a1c59eef8c75fbfb3be', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991643510538242', 'https://tiku.baidu.com/tikupc/singledetail/a1bfff4733687e21af45a9f5', '1025991524262281219', '0');
INSERT INTO `crawler_question` VALUES ('1025991643703476227', 'https://tiku.baidu.com/tikupc/singledetail/114ff46527d3240c8447ef3f', '1025991612057452546', '0');
INSERT INTO `crawler_question` VALUES ('1025991643577647108', 'https://tiku.baidu.com/tikupc/singledetail/fcf6770bf78a6529647d5308', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991643758002178', 'https://tiku.baidu.com/tikupc/singledetail/fa0e22f90242a8956bece426', '1025991611440889857', '0');
INSERT INTO `crawler_question` VALUES ('1025991643758002179', 'https://tiku.baidu.com/tikupc/singledetail/0ab3a517866fb84ae45c8dc3', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991643812528130', 'https://tiku.baidu.com/tikupc/singledetail/37534fd7c1c708a1284a4430', '1025991611847737348', '0');
INSERT INTO `crawler_question` VALUES ('1025991643875442689', 'https://tiku.baidu.com/tikupc/singledetail/266210a6f524ccbff121847f', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991643875442690', 'https://tiku.baidu.com/tikupc/singledetail/881e6e85ec3a87c24028c416', '1025991612057452546', '0');
INSERT INTO `crawler_question` VALUES ('1025991643892219905', 'https://tiku.baidu.com/tikupc/singledetail/69dfa200a6c30c2259019ec6', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991643883831298', 'https://tiku.baidu.com/tikupc/singledetail/65b8a0116c175f0e7cd13730', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991643917385729', 'https://tiku.baidu.com/tikupc/singledetail/b83c80c758f5f61fb73666d3', '1025991554238971907', '0');
INSERT INTO `crawler_question` VALUES ('1025991644001271810', 'https://tiku.baidu.com/tikupc/singledetail/f10f3c1ec5da50e2524d7f5c', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991644001271809', 'https://tiku.baidu.com/tikupc/singledetail/410b4b35eefdc8d376ee322b', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991644026437634', 'https://tiku.baidu.com/tikupc/singledetail/ca6ef71fb7360b4c2e3f649e', '1025991507946438659', '0');
INSERT INTO `crawler_question` VALUES ('1025991644026437633', 'https://tiku.baidu.com/tikupc/singledetail/193aba1aa8114431b90dd833', '1025991568726097921', '0');
INSERT INTO `crawler_question` VALUES ('1025991644097740801', 'https://tiku.baidu.com/tikupc/singledetail/428826fff705cc175527095c', '1025991569007116290', '0');
INSERT INTO `crawler_question` VALUES ('1025991644097740802', 'https://tiku.baidu.com/tikupc/singledetail/cd75b307e87101f69e319535', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991644097740803', 'https://tiku.baidu.com/tikupc/singledetail/62980775f46527d3240ce071', '1025991612204253190', '0');
INSERT INTO `crawler_question` VALUES ('1025991644190015490', 'https://tiku.baidu.com/tikupc/singledetail/0307a9f8941ea76e58fa04fb', '1025991568860315649', '0');
INSERT INTO `crawler_question` VALUES ('1025991644248735745', 'https://tiku.baidu.com/tikupc/singledetail/51df360cba1aa8114431d90f', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991644248735746', 'https://tiku.baidu.com/tikupc/singledetail/11ab36b765ce0508763213d7', '1025991612204253190', '0');
INSERT INTO `crawler_question` VALUES ('1025991644353593346', 'https://tiku.baidu.com/tikupc/singledetail/aff0fab069dc5022aaea000f', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991644370370562', 'https://tiku.baidu.com/tikupc/singledetail/624e1a2d7375a417866f8f7c', '1025991612204253190', '0');
INSERT INTO `crawler_question` VALUES ('1025991644441673729', 'https://tiku.baidu.com/tikupc/singledetail/b623f311f18583d049645911', '1025991612401385474', '0');
INSERT INTO `crawler_question` VALUES ('1025991644454256641', 'https://tiku.baidu.com/tikupc/singledetail/1f61561252d380eb62946d0e', '1025991554608070658', '0');
INSERT INTO `crawler_question` VALUES ('1025991644538142723', 'https://tiku.baidu.com/tikupc/singledetail/9f8568eae009581b6bd9ebc7', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991644538142722', 'https://tiku.baidu.com/tikupc/singledetail/daf2f405cc17552707220808', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991644571697154', 'https://tiku.baidu.com/tikupc/singledetail/834ff12d2af90242a895e544', '1025991587860512773', '0');
INSERT INTO `crawler_question` VALUES ('1025991644659777537', 'https://tiku.baidu.com/tikupc/singledetail/517758fafab069dc5022011c', '1025991587860512773', '0');
INSERT INTO `crawler_question` VALUES ('1025991644643000322', 'https://tiku.baidu.com/tikupc/singledetail/8f64ed06eff9aef8941e0656', '1025991526330073089', '0');
INSERT INTO `crawler_question` VALUES ('1025991644643000323', 'https://tiku.baidu.com/tikupc/singledetail/9580a9114431b90d6c85c79f', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991644701720577', 'https://tiku.baidu.com/tikupc/singledetail/433d14791711cc7931b7162e', '1025991612577546242', '0');
INSERT INTO `crawler_question` VALUES ('1025991644752052225', 'https://tiku.baidu.com/tikupc/singledetail/a16833687e21af45b307a82a', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991644752052226', 'https://tiku.baidu.com/tikupc/singledetail/a54bf01dc281e53a5802ff1f', '1025991587860512773', '0');
INSERT INTO `crawler_question` VALUES ('1025991644764635139', 'https://tiku.baidu.com/tikupc/singledetail/1aea443610661ed9ad51f3c1', '1025991612707569666', '0');
INSERT INTO `crawler_question` VALUES ('1025991644773023745', 'https://tiku.baidu.com/tikupc/singledetail/ac125d0e7cd184254b353500', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991644814966785', 'https://tiku.baidu.com/tikupc/singledetail/57ddf90f76c66137ee06192b', '1025991612577546242', '0');
INSERT INTO `crawler_question` VALUES ('1025991644840132610', 'https://tiku.baidu.com/tikupc/singledetail/f81e43323968011ca300912a', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991644840132611', 'https://tiku.baidu.com/tikupc/singledetail/849a6f1aff00bed5b9f31d44', '1025991587860512773', '0');
INSERT INTO `crawler_question` VALUES ('1025991644861104130', 'https://tiku.baidu.com/tikupc/singledetail/12cb9cc3d5bbfd0a79567308', '1025991495065731073', '0');
INSERT INTO `crawler_question` VALUES ('1025991644861104129', 'https://tiku.baidu.com/tikupc/singledetail/325d747f5acfa1c7aa00cc16', '1025991612707569666', '0');
INSERT INTO `crawler_question` VALUES ('1025991644919824386', 'https://tiku.baidu.com/tikupc/singledetail/950db52acfc789eb172dc808', '1025991612577546242', '0');
INSERT INTO `crawler_question` VALUES ('1025991644940795906', 'https://tiku.baidu.com/tikupc/singledetail/5c9151e79b89680203d8250d', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991645020487681', 'https://tiku.baidu.com/tikupc/singledetail/7721915f804d2b160b4ec00c', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991645028876289', 'https://tiku.baidu.com/tikupc/singledetail/927bf7ec4afe04a1b071de32', '1025991612577546242', '0');
INSERT INTO `crawler_question` VALUES ('1025991645095985154', 'https://tiku.baidu.com/tikupc/singledetail/e7dc102de2bd960590c67735', '1025991569137139713', '0');
INSERT INTO `crawler_question` VALUES ('1025991645112762370', 'https://tiku.baidu.com/tikupc/singledetail/571f0722192e45361066f53d', '1025991612577546242', '0');
INSERT INTO `crawler_question` VALUES ('1025991645192454145', 'https://tiku.baidu.com/tikupc/singledetail/8a326c85ec3a87c24028c43a', '1025991588170891265', '0');
INSERT INTO `crawler_question` VALUES ('1025991645314088962', 'https://tiku.baidu.com/tikupc/singledetail/9fdfaa00b52acfc789ebc91d', '1025991588170891265', '0');
INSERT INTO `crawler_question` VALUES ('1025991645356032002', 'https://tiku.baidu.com/tikupc/singledetail/9d672e3f5727a5e9856a612e', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991645372809218', 'https://tiku.baidu.com/tikupc/singledetail/78ed13791711cc7931b716fe', '1025991612783067142', '0');
INSERT INTO `crawler_question` VALUES ('1025991645372809219', 'https://tiku.baidu.com/tikupc/singledetail/d82ef5335a8102d276a22f4d', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991645423140866', 'https://tiku.baidu.com/tikupc/singledetail/8a58a8114431b90d6c85c747', '1025991588170891265', '0');
INSERT INTO `crawler_question` VALUES ('1025991645456695298', 'https://tiku.baidu.com/tikupc/singledetail/1f41561252d380eb62946d2e', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991645498638338', 'https://tiku.baidu.com/tikupc/singledetail/1af74693daef5ef7ba0d3c01', '1025991613135388676', '0');
INSERT INTO `crawler_question` VALUES ('1025991645498638339', 'https://tiku.baidu.com/tikupc/singledetail/d99a76a20029bd64783e2c4d', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991645507026945', 'https://tiku.baidu.com/tikupc/singledetail/65c3cc22bcd126fff7050b49', '1025991588170891265', '0');
INSERT INTO `crawler_question` VALUES ('1025991645548969985', 'https://tiku.baidu.com/tikupc/singledetail/65a6a0116c175f0e7cd1372e', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991645565747201', 'https://tiku.baidu.com/tikupc/singledetail/a7060912a21614791711283d', '1025991613005365250', '0');
INSERT INTO `crawler_question` VALUES ('1025991645586718721', 'https://tiku.baidu.com/tikupc/singledetail/74c6e009581b6bd97f19ea29', '1025991588305108993', '0');
INSERT INTO `crawler_question` VALUES ('1025991645586718722', 'https://tiku.baidu.com/tikupc/singledetail/d6d2ba64783e0912a2162afe', '1025991613135388676', '0');
INSERT INTO `crawler_question` VALUES ('1025991645620273155', 'https://tiku.baidu.com/tikupc/singledetail/e2642af90242a8956bece44c', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991645620273154', 'https://tiku.baidu.com/tikupc/singledetail/029569dc5022aaea998f0f20', '1025991588170891265', '0');
INSERT INTO `crawler_question` VALUES ('1025991645658021889', 'https://tiku.baidu.com/tikupc/singledetail/fa1c83c4bb4cf7ec4afed02a', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991645666410497', 'https://tiku.baidu.com/tikupc/singledetail/de73e518964bcf84b9d57b3b', '1025991588032479233', '0');
INSERT INTO `crawler_question` VALUES ('1025991645674799105', 'https://tiku.baidu.com/tikupc/singledetail/1beace84b9d528ea81c779a4', '1025991613005365250', '0');
INSERT INTO `crawler_question` VALUES ('1025991645691576321', 'https://tiku.baidu.com/tikupc/singledetail/029a492fb4daa58da0114abc', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991645729325058', 'https://tiku.baidu.com/tikupc/singledetail/3eb00242a8956bec0975e34c', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991645729325059', 'https://tiku.baidu.com/tikupc/singledetail/9162d438376baf1ffc4fadab', '1025991613135388676', '0');
INSERT INTO `crawler_question` VALUES ('1025991645729325057', 'https://tiku.baidu.com/tikupc/singledetail/a14233687e21af45b307a800', '1025991588305108993', '0');
INSERT INTO `crawler_question` VALUES ('1025991645741907971', 'https://tiku.baidu.com/tikupc/singledetail/909b5022aaea998fcc220e42', '1025991588615487491', '0');
INSERT INTO `crawler_question` VALUES ('1025991645741907972', 'https://tiku.baidu.com/tikupc/singledetail/1a4dcd84b9d528ea81c77903', '1025991613005365250', '0');
INSERT INTO `crawler_question` VALUES ('1025991645741907973', 'https://tiku.baidu.com/tikupc/singledetail/a9c1195f312b3169a451a412', '1025991588032479233', '0');
INSERT INTO `crawler_question` VALUES ('1025991645741907970', 'https://tiku.baidu.com/tikupc/singledetail/1c0ceff9aef8941ea76e050f', '1025991569279746050', '0');
INSERT INTO `crawler_question` VALUES ('1025991645741907974', 'https://tiku.baidu.com/tikupc/singledetail/22f3571810a6f524ccbf851c', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991645867737090', 'https://tiku.baidu.com/tikupc/singledetail/7e28bb68a98271fe910ef927', '1025991511926833154', '0');
INSERT INTO `crawler_question` VALUES ('1025991645867737091', 'https://tiku.baidu.com/tikupc/singledetail/b2bf611aff00bed5b9f31d61', '1025991613340909569', '0');
INSERT INTO `crawler_question` VALUES ('1025991645972594690', 'https://tiku.baidu.com/tikupc/singledetail/563eef630b1c59eef8c7b416', '1025991613005365250', '0');
INSERT INTO `crawler_question` VALUES ('1025991645972594691', 'https://tiku.baidu.com/tikupc/singledetail/81d8f32d2af90242a895e5d3', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991645972594692', 'https://tiku.baidu.com/tikupc/singledetail/cc2f8d9951e79b896802265c', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991645972594689', 'https://tiku.baidu.com/tikupc/singledetail/447967ec102de2bd96058849', '1025991588615487491', '0');
INSERT INTO `crawler_question` VALUES ('1025991645972594693', 'https://tiku.baidu.com/tikupc/singledetail/21ce2d60ddccda38376bafe8', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991645972594694', 'https://tiku.baidu.com/tikupc/singledetail/00ed76eeaeaad1f346933f3b', '1025991588032479233', '0');
INSERT INTO `crawler_question` VALUES ('1025991646031314946', 'https://tiku.baidu.com/tikupc/singledetail/6c070740be1e650e52ea9900', '1025991588305108993', '0');
INSERT INTO `crawler_question` VALUES ('1025991646090035202', 'https://tiku.baidu.com/tikupc/singledetail/8510de36a32d7375a4178034', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991646090035204', 'https://tiku.baidu.com/tikupc/singledetail/d7fea01614791711cc7917e9', '1025991613496098818', '0');
INSERT INTO `crawler_question` VALUES ('1025991646090035203', 'https://tiku.baidu.com/tikupc/singledetail/75347d19227916888486d7e8', '1025991613005365250', '0');
INSERT INTO `crawler_question` VALUES ('1025991646090035205', 'https://tiku.baidu.com/tikupc/singledetail/e182753231126edb6f1a108f', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991646098423810', 'https://tiku.baidu.com/tikupc/singledetail/d735cc2f0066f5335a8121e8', '1025991516444098562', '0');
INSERT INTO `crawler_question` VALUES ('1025991646106812417', 'https://tiku.baidu.com/tikupc/singledetail/12579cc3d5bbfd0a79567394', '1025991588615487491', '0');
INSERT INTO `crawler_question` VALUES ('1025991646106812418', 'https://tiku.baidu.com/tikupc/singledetail/cd5fb307e87101f69e31951f', '1025991588032479233', '0');
INSERT INTO `crawler_question` VALUES ('1025991646161338370', 'https://tiku.baidu.com/tikupc/singledetail/b41bf111f18583d049645929', '1025991588305108993', '0');
INSERT INTO `crawler_question` VALUES ('1025991646190698497', 'https://tiku.baidu.com/tikupc/singledetail/e823e07101f69e3143329421', '1025991516179857409', '0');
INSERT INTO `crawler_question` VALUES ('1025991646203281411', 'https://tiku.baidu.com/tikupc/singledetail/d909504de518964bcf847cee', '1025991588615487491', '0');
INSERT INTO `crawler_question` VALUES ('1025991646203281410', 'https://tiku.baidu.com/tikupc/singledetail/6044b61e650e52ea55189801', '1025991555090415618', '0');
INSERT INTO `crawler_question` VALUES ('1025991646203281412', 'https://tiku.baidu.com/tikupc/singledetail/6e872cc58bd63186bcebbc47', '1025991588032479233', '0');
INSERT INTO `crawler_question` VALUES ('1025991646266195970', 'https://tiku.baidu.com/tikupc/singledetail/be8d284ac850ad02de804129', '1025991588305108993', '0');
INSERT INTO `crawler_question` VALUES ('1025991646266195971', 'https://tiku.baidu.com/tikupc/singledetail/de7a4bfe04a1b0717fd5dd93', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991646333304833', 'https://tiku.baidu.com/tikupc/singledetail/d32f5c0e7cd184254b35353d', '1025991588615487491', '0');
INSERT INTO `crawler_question` VALUES ('1025991646375247874', 'https://tiku.baidu.com/tikupc/singledetail/15b053ea551810a6f52486bb', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991646421385218', 'https://tiku.baidu.com/tikupc/singledetail/7a0079563c1ec5da50e2700f', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991646463328258', 'https://tiku.baidu.com/tikupc/singledetail/6484d1f34693daef5ef73d2b', '1025991588447715330', '0');
INSERT INTO `crawler_question` VALUES ('1025991646471716865', 'https://tiku.baidu.com/tikupc/singledetail/2fc630b765ce0508763213ba', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991646509465603', 'https://tiku.baidu.com/tikupc/singledetail/ec4926d3240c844769eaee29', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991646509465602', 'https://tiku.baidu.com/tikupc/singledetail/0aaf61dc5022aaea998f0f1a', '1025991613865197570', '0');
INSERT INTO `crawler_question` VALUES ('1025991646551408641', 'https://tiku.baidu.com/tikupc/singledetail/bab7f121dd36a32d7375810d', '1025991588447715330', '0');
INSERT INTO `crawler_question` VALUES ('1025991646559797249', 'https://tiku.baidu.com/tikupc/singledetail/ce85b207e87101f69e3195c5', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991646626906114', 'https://tiku.baidu.com/tikupc/singledetail/1afeb9d5b9f3f90f76c61bfb', '1025991613865197570', '0');
INSERT INTO `crawler_question` VALUES ('1025991646626906115', 'https://tiku.baidu.com/tikupc/singledetail/d9eff705cc17552707220815', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991646656266241', 'https://tiku.baidu.com/tikupc/singledetail/6fbfb91e650e52ea551898fa', '1025991614011998210', '0');
INSERT INTO `crawler_question` VALUES ('1025991646656266242', 'https://tiku.baidu.com/tikupc/singledetail/d7aaea5c3b3567ec102d8ae5', '1025991588825202690', '0');
INSERT INTO `crawler_question` VALUES ('1025991646664654852', 'https://tiku.baidu.com/tikupc/singledetail/6c000740be1e650e52ea9907', '1025991613726785537', '0');
INSERT INTO `crawler_question` VALUES ('1025991646664654850', 'https://tiku.baidu.com/tikupc/singledetail/d37e8e9951e79b896802260d', '1025991588447715330', '0');
INSERT INTO `crawler_question` VALUES ('1025991646664654851', 'https://tiku.baidu.com/tikupc/singledetail/95d8a9114431b90d6c85c7c7', '1025991534307639297', '0');
INSERT INTO `crawler_question` VALUES ('1025991646714986498', 'https://tiku.baidu.com/tikupc/singledetail/200547649b6648d7c1c746d0', '1025991613865197570', '0');
INSERT INTO `crawler_question` VALUES ('1025991646731763715', 'https://tiku.baidu.com/tikupc/singledetail/0dad8c868762caaedd33d420', '1025991614011998210', '0');
INSERT INTO `crawler_question` VALUES ('1025991646731763714', 'https://tiku.baidu.com/tikupc/singledetail/fe29581b6bd97f192279e925', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991646836621314', 'https://tiku.baidu.com/tikupc/singledetail/1bcd700abb68a98271fefa34', '1025991588447715330', '0');
INSERT INTO `crawler_question` VALUES ('1025991646874370049', 'https://tiku.baidu.com/tikupc/singledetail/ff503e1ec5da50e2524d7f03', '1025991569460101122', '0');
INSERT INTO `crawler_question` VALUES ('1025991646865981441', 'https://tiku.baidu.com/tikupc/singledetail/b3d14228915f804d2b16c116', '1025991613726785537', '0');
INSERT INTO `crawler_question` VALUES ('1025991646949867522', 'https://tiku.baidu.com/tikupc/singledetail/0329482fb4daa58da0114a0f', '1025991588447715330', '0');
INSERT INTO `crawler_question` VALUES ('1025991647050530818', 'https://tiku.baidu.com/tikupc/singledetail/b8710e29bd64783e09122bd6', '1025991613726785537', '0');
INSERT INTO `crawler_question` VALUES ('1025991647163777026', 'https://tiku.baidu.com/tikupc/singledetail/3043767f5acfa1c7aa00cc08', '1025991569992777730', '0');
INSERT INTO `crawler_question` VALUES ('1025991647197331457', 'https://tiku.baidu.com/tikupc/singledetail/f8fbbadaa58da0116c1749d1', '1025991613726785537', '0');
INSERT INTO `crawler_question` VALUES ('1025991647214108674', 'https://tiku.baidu.com/tikupc/singledetail/23c80a4c2e3f5727a5e962fb', '1025991589198495748', '0');
INSERT INTO `crawler_question` VALUES ('1025991647306383364', 'https://tiku.baidu.com/tikupc/singledetail/dde34afe04a1b0717fd5dd0a', '1025991589404016643', '0');
INSERT INTO `crawler_question` VALUES ('1025991647306383363', 'https://tiku.baidu.com/tikupc/singledetail/61276c175f0e7cd184253633', '1025991589198495748', '0');
INSERT INTO `crawler_question` VALUES ('1025991647306383362', 'https://tiku.baidu.com/tikupc/singledetail/ebf524c52cc58bd63186bd99', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991647373492225', 'https://tiku.baidu.com/tikupc/singledetail/64d5d1f34693daef5ef73d7a', '1025991614628560898', '0');
INSERT INTO `crawler_question` VALUES ('1025991647411240963', 'https://tiku.baidu.com/tikupc/singledetail/c23b647d27284b73f2425017', '1025991589404016643', '0');
INSERT INTO `crawler_question` VALUES ('1025991647415435266', 'https://tiku.baidu.com/tikupc/singledetail/a6a2814d2b160b4e767fcff8', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991647411240962', 'https://tiku.baidu.com/tikupc/singledetail/414527fff705cc1755270991', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991647415435267', 'https://tiku.baidu.com/tikupc/singledetail/d008e87101f69e314332940a', '1025991589198495748', '0');
INSERT INTO `crawler_question` VALUES ('1025991647507709955', 'https://tiku.baidu.com/tikupc/singledetail/a545f01dc281e53a5802ff11', '1025991589404016643', '0');
INSERT INTO `crawler_question` VALUES ('1025991647507709954', 'https://tiku.baidu.com/tikupc/singledetail/1329094e767f5acfa1c7cd3a', '1025991614628560898', '0');
INSERT INTO `crawler_question` VALUES ('1025991647553847299', 'https://tiku.baidu.com/tikupc/singledetail/d21bea7101f69e3143329419', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991647553847300', 'https://tiku.baidu.com/tikupc/singledetail/1a91443610661ed9ad51f3ba', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991647553847298', 'https://tiku.baidu.com/tikupc/singledetail/d6f1a31614791711cc7917e6', '1025991516842557441', '0');
INSERT INTO `crawler_question` VALUES ('1025991647620956162', 'https://tiku.baidu.com/tikupc/singledetail/d93387c24028915f804dc20c', '1025991589689229313', '0');
INSERT INTO `crawler_question` VALUES ('1025991647620956161', 'https://tiku.baidu.com/tikupc/singledetail/61c004a1b0717fd5360cdc3b', '1025991589404016643', '0');
INSERT INTO `crawler_question` VALUES ('1025991647637733377', 'https://tiku.baidu.com/tikupc/singledetail/82e600d276a20029bd642d62', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991647646121986', 'https://tiku.baidu.com/tikupc/singledetail/b8f22a160b4e767f5acfceba', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991647675482114', 'https://tiku.baidu.com/tikupc/singledetail/9f581eb91a37f111f1855b31', '1025991614930550787', '0');
INSERT INTO `crawler_question` VALUES ('1025991647717425154', 'https://tiku.baidu.com/tikupc/singledetail/1432de80d4d8d15abe234e35', '1025991589689229313', '0');
INSERT INTO `crawler_question` VALUES ('1025991647734202370', 'https://tiku.baidu.com/tikupc/singledetail/60cecf22bcd126fff7050b44', '1025991569699176451', '0');
INSERT INTO `crawler_question` VALUES ('1025991647734202369', 'https://tiku.baidu.com/tikupc/singledetail/83709a89680203d8ce2f2492', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991647767756802', 'https://tiku.baidu.com/tikupc/singledetail/fe0a581b6bd97f192279e906', '1025991614481760258', '0');
INSERT INTO `crawler_question` VALUES ('1025991647767756803', 'https://tiku.baidu.com/tikupc/singledetail/f92bc281e53a580216fcfe33', '1025991614930550787', '0');
INSERT INTO `crawler_question` VALUES ('1025991647813894146', 'https://tiku.baidu.com/tikupc/singledetail/150990c69ec3d5bbfd0a7409', '1025991589689229313', '0');
INSERT INTO `crawler_question` VALUES ('1025991647813894147', 'https://tiku.baidu.com/tikupc/singledetail/fa02f44ffe4733687e21aa18', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991647813894148', 'https://tiku.baidu.com/tikupc/singledetail/9cb17ed5360cba1aa811dac5', '1025991494671466498', '0');
INSERT INTO `crawler_question` VALUES ('1025991647834865666', 'https://tiku.baidu.com/tikupc/singledetail/42bcd0d233d4b14e85246831', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991647872614403', 'https://tiku.baidu.com/tikupc/singledetail/b8c784254b35eefdc8d33313', '1025991614930550787', '0');
INSERT INTO `crawler_question` VALUES ('1025991647872614402', 'https://tiku.baidu.com/tikupc/singledetail/d9ea76a20029bd64783e2c3d', '1025991614481760258', '0');
INSERT INTO `crawler_question` VALUES ('1025991647918751748', 'https://tiku.baidu.com/tikupc/singledetail/261058fb770bf78a65295431', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991647918751747', 'https://tiku.baidu.com/tikupc/singledetail/38f45d1810a6f524ccbf851b', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991647918751746', 'https://tiku.baidu.com/tikupc/singledetail/344302020740be1e650e9a47', '1025991589689229313', '0');
INSERT INTO `crawler_question` VALUES ('1025991647990054914', 'https://tiku.baidu.com/tikupc/singledetail/4d48312b3169a4517723a312', '1025991614930550787', '0');
INSERT INTO `crawler_question` VALUES ('1025991647990054915', 'https://tiku.baidu.com/tikupc/singledetail/659aa0116c175f0e7cd13712', '1025991614481760258', '0');
INSERT INTO `crawler_question` VALUES ('1025991648090718210', 'https://tiku.baidu.com/tikupc/singledetail/ec9fdd3383c4bb4cf7ecd134', '1025991614750195716', '0');
INSERT INTO `crawler_question` VALUES ('1025991648090718213', 'https://tiku.baidu.com/tikupc/singledetail/a242fe4733687e21af45a908', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991648090718212', 'https://tiku.baidu.com/tikupc/singledetail/f8af3b1ec5da50e2524d7ffc', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991648090718211', 'https://tiku.baidu.com/tikupc/singledetail/285548d7c1c708a1284a4436', '1025991589689229313', '0');
INSERT INTO `crawler_question` VALUES ('1025991648136855553', 'https://tiku.baidu.com/tikupc/singledetail/8e11a26925c52cc58bd6be69', '1025991614481760258', '0');
INSERT INTO `crawler_question` VALUES ('1025991648136855554', 'https://tiku.baidu.com/tikupc/singledetail/29c3c8d376eeaeaad1f3303b', '1025991614930550787', '0');
INSERT INTO `crawler_question` VALUES ('1025991648174604289', 'https://tiku.baidu.com/tikupc/singledetail/d4bd65ce050876323112120f', '1025991614750195716', '0');
INSERT INTO `crawler_question` VALUES ('1025991648174604290', 'https://tiku.baidu.com/tikupc/singledetail/d23ff78a6529647d27285231', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991648174604291', 'https://tiku.baidu.com/tikupc/singledetail/a23ebc4cf7ec4afe04a1dfff', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991648229130242', 'https://tiku.baidu.com/tikupc/singledetail/606b910ef12d2af90242e690', '1025991614481760258', '0');
INSERT INTO `crawler_question` VALUES ('1025991648237518850', 'https://tiku.baidu.com/tikupc/singledetail/986b69eae009581b6bd9eb29', '1025991589882167298', '0');
INSERT INTO `crawler_question` VALUES ('1025991648292044801', 'https://tiku.baidu.com/tikupc/singledetail/24063968011ca300a6c39031', '1025991614750195716', '0');
INSERT INTO `crawler_question` VALUES ('1025991648292044802', 'https://tiku.baidu.com/tikupc/singledetail/cc4927284b73f242336c5f31', '1025991533913374722', '0');
INSERT INTO `crawler_question` VALUES ('1025991648325599233', 'https://tiku.baidu.com/tikupc/singledetail/fb609b6648d7c1c708a14501', '1025991589882167298', '0');
INSERT INTO `crawler_question` VALUES ('1025991648317210625', 'https://tiku.baidu.com/tikupc/singledetail/99b6f0ec4afe04a1b071deff', '1025991570126995458', '0');
INSERT INTO `crawler_question` VALUES ('1025991648380125186', 'https://tiku.baidu.com/tikupc/singledetail/993e4431b90d6c85ec3ac62a', '1025991614750195716', '0');
INSERT INTO `crawler_question` VALUES ('1025991648413679618', 'https://tiku.baidu.com/tikupc/singledetail/ce1b650e52ea551810a68700', '1025991589882167298', '0');
INSERT INTO `crawler_question` VALUES ('1025991648413679617', 'https://tiku.baidu.com/tikupc/singledetail/ae3d5f0e7cd184254b35352f', '1025991615056379911', '0');
INSERT INTO `crawler_question` VALUES ('1025991648455622658', 'https://tiku.baidu.com/tikupc/singledetail/cbe8172ded630b1c59eeb506', '1025991615257706499', '0');
INSERT INTO `crawler_question` VALUES ('1025991648455622659', 'https://tiku.baidu.com/tikupc/singledetail/22770b4c2e3f5727a5e96244', '1025991614750195716', '0');
INSERT INTO `crawler_question` VALUES ('1025991648514342913', 'https://tiku.baidu.com/tikupc/singledetail/142ede80d4d8d15abe234e29', '1025991589882167298', '0');
INSERT INTO `crawler_question` VALUES ('1025991648514342914', 'https://tiku.baidu.com/tikupc/singledetail/d002e87101f69e3143329400', '1025991615056379911', '0');
INSERT INTO `crawler_question` VALUES ('1025991648552091649', 'https://tiku.baidu.com/tikupc/singledetail/bffe5fbfc77da26925c5b03c', '1025991615257706499', '0');
INSERT INTO `crawler_question` VALUES ('1025991648598228993', 'https://tiku.baidu.com/tikupc/singledetail/7c47bdeb19e8b8f67c1cb9c4', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991648606617602', 'https://tiku.baidu.com/tikupc/singledetail/6340783e0912a21614792921', '1025991615056379911', '0');
INSERT INTO `crawler_question` VALUES ('1025991648615006210', 'https://tiku.baidu.com/tikupc/singledetail/9d492e3f5727a5e9856a6100', '1025991589882167298', '0');
INSERT INTO `crawler_question` VALUES ('1025991648623394818', 'https://tiku.baidu.com/tikupc/singledetail/1c1c084e767f5acfa1c7cd0f', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991648635977729', 'https://tiku.baidu.com/tikupc/singledetail/beb7284ac850ad02de804113', '1025991615257706499', '0');
INSERT INTO `crawler_question` VALUES ('1025991648690503682', 'https://tiku.baidu.com/tikupc/singledetail/8d0adbef5ef7ba0d4a733b9c', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991648690503683', 'https://tiku.baidu.com/tikupc/singledetail/64a4f524ccbff121dd368307', '1025991615480004612', '0');
INSERT INTO `crawler_question` VALUES ('1025991648690503684', 'https://tiku.baidu.com/tikupc/singledetail/8a2b6c85ec3a87c24028c423', '1025991615056379911', '0');
INSERT INTO `crawler_question` VALUES ('1025991648740835330', 'https://tiku.baidu.com/tikupc/singledetail/1880a3116c175f0e7cd13708', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991648749223938', 'https://tiku.baidu.com/tikupc/singledetail/613a6c175f0e7cd18425362e', '1025991590037356545', '0');
INSERT INTO `crawler_question` VALUES ('1025991648749223937', 'https://tiku.baidu.com/tikupc/singledetail/043a192e453610661ed9f41d', '1025991615257706499', '0');
INSERT INTO `crawler_question` VALUES ('1025991648812138498', 'https://tiku.baidu.com/tikupc/singledetail/f1553c1ec5da50e2524d7f06', '1025991615480004612', '0');
INSERT INTO `crawler_question` VALUES ('1025991648812138497', 'https://tiku.baidu.com/tikupc/singledetail/153f90c69ec3d5bbfd0a743f', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991648820527106', 'https://tiku.baidu.com/tikupc/singledetail/ad8b5e0e7cd184254b353599', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991648820527105', 'https://tiku.baidu.com/tikupc/singledetail/7cb50975f46527d3240ce05c', '1025991615056379911', '0');
INSERT INTO `crawler_question` VALUES ('1025991648828915713', 'https://tiku.baidu.com/tikupc/singledetail/f510ff4ffe4733687e21aa0a', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991648841498626', 'https://tiku.baidu.com/tikupc/singledetail/c50ee45c3b3567ec102d8a41', '1025991615257706499', '0');
INSERT INTO `crawler_question` VALUES ('1025991648841498625', 'https://tiku.baidu.com/tikupc/singledetail/49edb8f67c1cfad6195fa700', '1025991590037356545', '0');
INSERT INTO `crawler_question` VALUES ('1025991648896024578', 'https://tiku.baidu.com/tikupc/singledetail/f274fc4ffe4733687e21aa6e', '1025991615668748290', '0');
INSERT INTO `crawler_question` VALUES ('1025991648896024577', 'https://tiku.baidu.com/tikupc/singledetail/5143011ca300a6c30c229f2e', '1025991615480004612', '0');
INSERT INTO `crawler_question` VALUES ('1025991648904413186', 'https://tiku.baidu.com/tikupc/singledetail/182b112de2bd960590c677c2', '1025991557070127106', '0');
INSERT INTO `crawler_question` VALUES ('1025991648904413185', 'https://tiku.baidu.com/tikupc/singledetail/f40ccc7931b765ce05081418', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991648946356226', 'https://tiku.baidu.com/tikupc/singledetail/da2c7e3231126edb6f1a1021', '1025991520365772802', '0');
INSERT INTO `crawler_question` VALUES ('1025991648946356227', 'https://tiku.baidu.com/tikupc/singledetail/642e3169a45177232f60a200', '1025991590037356545', '0');
INSERT INTO `crawler_question` VALUES ('1025991648979910658', 'https://tiku.baidu.com/tikupc/singledetail/4f80680203d8ce2f0066230c', '1025991615480004612', '0');
INSERT INTO `crawler_question` VALUES ('1025991649005076482', 'https://tiku.baidu.com/tikupc/singledetail/3ce5856a561252d380eb6e09', '1025991615668748290', '0');
INSERT INTO `crawler_question` VALUES ('1025991649005076483', 'https://tiku.baidu.com/tikupc/singledetail/187a112de2bd960590c67793', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991649076379650', 'https://tiku.baidu.com/tikupc/singledetail/676ca45177232f60ddcca100', '1025991590037356545', '0');
INSERT INTO `crawler_question` VALUES ('1025991649135099907', 'https://tiku.baidu.com/tikupc/singledetail/8e74a26925c52cc58bd6be0c', '1025991590465175554', '0');
INSERT INTO `crawler_question` VALUES ('1025991649135099906', 'https://tiku.baidu.com/tikupc/singledetail/4fd050e2524de518964b7d0f', '1025991615480004612', '0');
INSERT INTO `crawler_question` VALUES ('1025991649177042945', 'https://tiku.baidu.com/tikupc/singledetail/160376c66137ee06eff91809', '1025991615668748290', '0');
INSERT INTO `crawler_question` VALUES ('1025991649177042946', 'https://tiku.baidu.com/tikupc/singledetail/81b3cdbff121dd36a32d8292', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991649235763201', 'https://tiku.baidu.com/tikupc/singledetail/9d602e3f5727a5e9856a6129', '1025991590037356545', '0');
INSERT INTO `crawler_question` VALUES ('1025991649244151810', 'https://tiku.baidu.com/tikupc/singledetail/c8b2e53a580216fc700afd36', '1025991590289014785', '0');
INSERT INTO `crawler_question` VALUES ('1025991649281900546', 'https://tiku.baidu.com/tikupc/singledetail/9a6c3b3567ec102de2bd8935', '1025991590465175554', '0');
INSERT INTO `crawler_question` VALUES ('1025991649294483458', 'https://tiku.baidu.com/tikupc/singledetail/20e4551810a6f524ccbf850b', '1025991615668748290', '0');
INSERT INTO `crawler_question` VALUES ('1025991649311260673', 'https://tiku.baidu.com/tikupc/singledetail/1821c67da26925c52cc5bf9b', '1025991571146211330', '0');
INSERT INTO `crawler_question` VALUES ('1025991649349009409', 'https://tiku.baidu.com/tikupc/singledetail/9a7d02768e9951e79b89270b', '1025991590695862273', '0');
INSERT INTO `crawler_question` VALUES ('1025991649349009410', 'https://tiku.baidu.com/tikupc/singledetail/414383d049649b6648d747c3', '1025991590289014785', '0');
INSERT INTO `crawler_question` VALUES ('1025991649386758146', 'https://tiku.baidu.com/tikupc/singledetail/f216fc4ffe4733687e21aa0c', '1025991590465175554', '0');
INSERT INTO `crawler_question` VALUES ('1025991649386758147', 'https://tiku.baidu.com/tikupc/singledetail/bfdbaeaad1f34693daef3e30', '1025991615668748290', '0');
INSERT INTO `crawler_question` VALUES ('1025991649437089793', 'https://tiku.baidu.com/tikupc/singledetail/fceb770bf78a6529647d5315', '1025991590695862273', '0');
INSERT INTO `crawler_question` VALUES ('1025991649453867011', 'https://tiku.baidu.com/tikupc/singledetail/0beba58da0116c175f0e4834', '1025991615840714753', '0');
INSERT INTO `crawler_question` VALUES ('1025991649453867010', 'https://tiku.baidu.com/tikupc/singledetail/b92bf021dd36a32d73758191', '1025991590289014785', '0');
INSERT INTO `crawler_question` VALUES ('1025991649500004354', 'https://tiku.baidu.com/tikupc/singledetail/285648d7c1c708a1284a4435', '1025991590465175554', '0');
INSERT INTO `crawler_question` VALUES ('1025991649533558787', 'https://tiku.baidu.com/tikupc/singledetail/d4a765ce0508763231121215', '1025991590695862273', '0');
INSERT INTO `crawler_question` VALUES ('1025991649533558788', 'https://tiku.baidu.com/tikupc/singledetail/0410192e453610661ed9f437', '1025991615840714753', '0');
INSERT INTO `crawler_question` VALUES ('1025991649533558786', 'https://tiku.baidu.com/tikupc/singledetail/4f99680203d8ce2f00662315', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991649562918914', 'https://tiku.baidu.com/tikupc/singledetail/d7036ddb6f1aff00bed51e14', '1025991616025264130', '0');
INSERT INTO `crawler_question` VALUES ('1025991649562918913', 'https://tiku.baidu.com/tikupc/singledetail/fce4c1c708a1284ac8504336', '1025991590289014785', '0');
INSERT INTO `crawler_question` VALUES ('1025991649596473346', 'https://tiku.baidu.com/tikupc/singledetail/51836529647d27284b73510c', '1025991590465175554', '0');
INSERT INTO `crawler_question` VALUES ('1025991649621639170', 'https://tiku.baidu.com/tikupc/singledetail/1753a8956bec0975f465e214', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991649630027777', 'https://tiku.baidu.com/tikupc/singledetail/0be8a58da0116c175f0e4837', '1025991615840714753', '0');
INSERT INTO `crawler_question` VALUES ('1025991649621639171', 'https://tiku.baidu.com/tikupc/singledetail/a95a0b1c59eef8c75fbfb33c', '1025991590695862273', '0');
INSERT INTO `crawler_question` VALUES ('1025991649663582210', 'https://tiku.baidu.com/tikupc/singledetail/9f79c850ad02de80d4d84036', '1025991590289014785', '0');
INSERT INTO `crawler_question` VALUES ('1025991649692942337', 'https://tiku.baidu.com/tikupc/singledetail/5f12ed3a87c24028915fc392', '1025991571548864515', '0');
INSERT INTO `crawler_question` VALUES ('1025991649709719554', 'https://tiku.baidu.com/tikupc/singledetail/82f49b89680203d8ce2f2416', '1025991590695862273', '0');
INSERT INTO `crawler_question` VALUES ('1025991649718108161', 'https://tiku.baidu.com/tikupc/singledetail/d82a6edb6f1aff00bed51e3d', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991649718108162', 'https://tiku.baidu.com/tikupc/singledetail/ce28650e52ea551810a68733', '1025991615840714753', '0');
INSERT INTO `crawler_question` VALUES ('1025991649785217026', 'https://tiku.baidu.com/tikupc/singledetail/65319f3143323968011c92c2', '1025991571548864515', '0');
INSERT INTO `crawler_question` VALUES ('1025991649839742978', 'https://tiku.baidu.com/tikupc/singledetail/ee02580216fc700abb68fc3d', '1025991615840714753', '0');
INSERT INTO `crawler_question` VALUES ('1025991649839742979', 'https://tiku.baidu.com/tikupc/singledetail/84e36f1aff00bed5b9f31d3d', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991649885880321', 'https://tiku.baidu.com/tikupc/singledetail/4ddd5bcfa1c7aa00b52acba7', '1025991571548864515', '0');
INSERT INTO `crawler_question` VALUES ('1025991649902657537', 'https://tiku.baidu.com/tikupc/singledetail/5fd3f08583d049649b6658c7', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991649948794882', 'https://tiku.baidu.com/tikupc/singledetail/442467ec102de2bd96058814', '1025991554918449159', '0');
INSERT INTO `crawler_question` VALUES ('1025991649948794883', 'https://tiku.baidu.com/tikupc/singledetail/4c4058cfa1c7aa00b52acb3a', '1025991616381779969', '0');
INSERT INTO `crawler_question` VALUES ('1025991649965572097', 'https://tiku.baidu.com/tikupc/singledetail/51a3ff0a79563c1ec5da711d', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991649994932226', 'https://tiku.baidu.com/tikupc/singledetail/1a11a1116c175f0e7cd13799', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991650062041089', 'https://tiku.baidu.com/tikupc/singledetail/6777d5d8d15abe23482f4df2', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991650078818305', 'https://tiku.baidu.com/tikupc/singledetail/be5a5ebfc77da26925c5b098', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991650145927170', 'https://tiku.baidu.com/tikupc/singledetail/f1473c1ec5da50e2524d7f14', '1025991616486637570', '0');
INSERT INTO `crawler_question` VALUES ('1025991650145927172', 'https://tiku.baidu.com/tikupc/singledetail/1684a9956bec0975f465e2c3', '1025991497427124225', '0');
INSERT INTO `crawler_question` VALUES ('1025991650145927171', 'https://tiku.baidu.com/tikupc/singledetail/80db9989680203d8ce2f2439', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991650204647425', 'https://tiku.baidu.com/tikupc/singledetail/84d96f1aff00bed5b9f31d07', '1025991616729907201', '0');
INSERT INTO `crawler_question` VALUES ('1025991650246590466', 'https://tiku.baidu.com/tikupc/singledetail/53b46729647d27284b73513b', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991650246590467', 'https://tiku.baidu.com/tikupc/singledetail/22160b4c2e3f5727a5e96225', '1025991616486637570', '0');
INSERT INTO `crawler_question` VALUES ('1025991650301116417', 'https://tiku.baidu.com/tikupc/singledetail/86f26137ee06eff9aef80731', '1025991616729907201', '0');
INSERT INTO `crawler_question` VALUES ('1025991650338865154', 'https://tiku.baidu.com/tikupc/singledetail/cf7ab107e87101f69e31953a', '1025991557506334724', '0');
INSERT INTO `crawler_question` VALUES ('1025991650431139842', 'https://tiku.baidu.com/tikupc/singledetail/674fd0f34693daef5ef73de0', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991650523414530', 'https://tiku.baidu.com/tikupc/singledetail/8d76dbef5ef7ba0d4a733be0', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991650615689217', 'https://tiku.baidu.com/tikupc/singledetail/d55264ce05087632311212e0', '1025991557753798658', '0');
INSERT INTO `crawler_question` VALUES ('1025991650657632258', 'https://tiku.baidu.com/tikupc/singledetail/9af502768e9951e79b892783', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991650741518339', 'https://tiku.baidu.com/tikupc/singledetail/80d6366baf1ffc4ffe47aceb', '1025991616943816705', '0');
INSERT INTO `crawler_question` VALUES ('1025991650741518338', 'https://tiku.baidu.com/tikupc/singledetail/aba4f50a79563c1ec5da711a', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991650762489858', 'https://tiku.baidu.com/tikupc/singledetail/828d9b89680203d8ce2f246f', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991650762489857', 'https://tiku.baidu.com/tikupc/singledetail/2faa30b765ce0508763213d6', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991650812821506', 'https://tiku.baidu.com/tikupc/singledetail/606405a1b0717fd5360cdc9f', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991650850570242', 'https://tiku.baidu.com/tikupc/singledetail/f506cfc789eb172ded63b729', '1025991617166114818', '0');
INSERT INTO `crawler_question` VALUES ('1025991650850570241', 'https://tiku.baidu.com/tikupc/singledetail/31ca20ea81c758f5f61f671a', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991650850570244', 'https://tiku.baidu.com/tikupc/singledetail/99ca3a3567ec102de2bd8993', '1025991544982142977', '0');
INSERT INTO `crawler_question` VALUES ('1025991650850570243', 'https://tiku.baidu.com/tikupc/singledetail/9e9a2f3f5727a5e9856a61d3', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991650892513281', 'https://tiku.baidu.com/tikupc/singledetail/9c05ab00b52acfc789ebc9c7', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991650942844931', 'https://tiku.baidu.com/tikupc/singledetail/3ef3854769eae009581becfa', '1025991504230285315', '0');
INSERT INTO `crawler_question` VALUES ('1025991650942844930', 'https://tiku.baidu.com/tikupc/singledetail/20a0551810a6f524ccbf854f', '1025991617166114818', '0');
INSERT INTO `crawler_question` VALUES ('1025991650951233538', 'https://tiku.baidu.com/tikupc/singledetail/7fd13669a45177232f60a2ff', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991650976399362', 'https://tiku.baidu.com/tikupc/singledetail/a18dff4733687e21af45a9c7', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991651009953794', 'https://tiku.baidu.com/tikupc/singledetail/81cc0708763231126edb1107', '1025991617166114818', '0');
INSERT INTO `crawler_question` VALUES ('1025991651009953795', 'https://tiku.baidu.com/tikupc/singledetail/b81618661ed9ad51f01df224', '1025991516662202371', '0');
INSERT INTO `crawler_question` VALUES ('1025991651060285442', 'https://tiku.baidu.com/tikupc/singledetail/b7efa6aad1f34693daef3e04', '1025991617321304067', '0');
INSERT INTO `crawler_question` VALUES ('1025991651060285443', 'https://tiku.baidu.com/tikupc/singledetail/b483c4da50e2524de5187e98', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991651060285444', 'https://tiku.baidu.com/tikupc/singledetail/9c0fab00b52acfc789ebc9cd', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991651089645569', 'https://tiku.baidu.com/tikupc/singledetail/24313968011ca300a6c39006', '1025991591899627522', '0');
INSERT INTO `crawler_question` VALUES ('1025991651127394305', 'https://tiku.baidu.com/tikupc/singledetail/1a74cd84b9d528ea81c7793a', '1025991617166114818', '0');
INSERT INTO `crawler_question` VALUES ('1025991651156754433', 'https://tiku.baidu.com/tikupc/singledetail/c389657d27284b73f24250a5', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991651173531652', 'https://tiku.baidu.com/tikupc/singledetail/b47809f69e3143323968930c', '1025991617321304067', '0');
INSERT INTO `crawler_question` VALUES ('1025991651173531650', 'https://tiku.baidu.com/tikupc/singledetail/4c4451e2524de518964b7d9b', '1025991534819344385', '0');
INSERT INTO `crawler_question` VALUES ('1025991651173531651', 'https://tiku.baidu.com/tikupc/singledetail/2c4f5a8102d276a200292e79', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991651345498115', 'https://tiku.baidu.com/tikupc/singledetail/fca8ba4ae45c3b3567ec8bc2', '1025991617166114818', '0');
INSERT INTO `crawler_question` VALUES ('1025991651345498116', 'https://tiku.baidu.com/tikupc/singledetail/05f8e8f9aef8941ea76e05fb', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991651345498114', 'https://tiku.baidu.com/tikupc/singledetail/8622dd36a32d7375a4178006', '1025991591899627522', '0');
INSERT INTO `crawler_question` VALUES ('1025991651345498117', 'https://tiku.baidu.com/tikupc/singledetail/6787580102020740be1e9ba0', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991651345498118', 'https://tiku.baidu.com/tikupc/singledetail/6b7a703e0912a2161479291b', '1025991617321304067', '0');
INSERT INTO `crawler_question` VALUES ('1025991651345498119', 'https://tiku.baidu.com/tikupc/singledetail/9f391eb91a37f111f1855b50', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991651345498120', 'https://tiku.baidu.com/tikupc/singledetail/08dbcd1755270722192ef7da', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991651412606979', 'https://tiku.baidu.com/tikupc/singledetail/707aad02de80d4d8d15a4f2f', '1025991591991902211', '0');
INSERT INTO `crawler_question` VALUES ('1025991651412606978', 'https://tiku.baidu.com/tikupc/singledetail/986969eae009581b6bd9eb2b', '1025991592797208579', '0');
INSERT INTO `crawler_question` VALUES ('1025991651412606981', 'https://tiku.baidu.com/tikupc/singledetail/e938a21614791711cc79172f', '1025991591899627522', '0');
INSERT INTO `crawler_question` VALUES ('1025991651412606980', 'https://tiku.baidu.com/tikupc/singledetail/76fa3f69a45177232f60a2d4', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991651412606982', 'https://tiku.baidu.com/tikupc/singledetail/6241cd22bcd126fff7050bcb', '1025991572102512641', '0');
INSERT INTO `crawler_question` VALUES ('1025991651412606985', 'https://tiku.baidu.com/tikupc/singledetail/9deb7dd184254b35eefd34e0', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991651412606983', 'https://tiku.baidu.com/tikupc/singledetail/1108f46527d3240c8447ef78', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991651412606984', 'https://tiku.baidu.com/tikupc/singledetail/17ce5ef7ba0d4a7302763a24', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991651559407617', 'https://tiku.baidu.com/tikupc/singledetail/7d310875f46527d3240ce0d8', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991651601350658', 'https://tiku.baidu.com/tikupc/singledetail/5146011ca300a6c30c229f2b', '1025991592797208579', '0');
INSERT INTO `crawler_question` VALUES ('1025991651601350657', 'https://tiku.baidu.com/tikupc/singledetail/0309482fb4daa58da0114a2f', '1025991591991902211', '0');
INSERT INTO `crawler_question` VALUES ('1025991651601350660', 'https://tiku.baidu.com/tikupc/singledetail/101967dc5022aaea998f0fac', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991651601350659', 'https://tiku.baidu.com/tikupc/singledetail/60d5910ef12d2af90242e62e', '1025991591899627522', '0');
INSERT INTO `crawler_question` VALUES ('1025991651601350661', 'https://tiku.baidu.com/tikupc/singledetail/825e0a768e9951e79b892728', '1025991617686208518', '0');
INSERT INTO `crawler_question` VALUES ('1025991651655876609', 'https://tiku.baidu.com/tikupc/singledetail/64aed1f34693daef5ef73d01', '1025991592520384516', '0');
INSERT INTO `crawler_question` VALUES ('1025991651647488001', 'https://tiku.baidu.com/tikupc/singledetail/35f584868762caaedd33d478', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991651655876610', 'https://tiku.baidu.com/tikupc/singledetail/55debbf3f90f76c661371a0e', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991651706208258', 'https://tiku.baidu.com/tikupc/singledetail/6836964bcf84b9d528ea7a2b', '1025991592797208579', '0');
INSERT INTO `crawler_question` VALUES ('1025991651706208259', 'https://tiku.baidu.com/tikupc/singledetail/a10c33687e21af45b307a84e', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991651706208260', 'https://tiku.baidu.com/tikupc/singledetail/790cdf5abe23482fb4da4cd1', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991651706208262', 'https://tiku.baidu.com/tikupc/singledetail/11c45af5f61fb7360b4c6506', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991651706208261', 'https://tiku.baidu.com/tikupc/singledetail/29d628ea81c758f5f61f6706', '1025991591991902211', '0');
INSERT INTO `crawler_question` VALUES ('1025991651760734211', 'https://tiku.baidu.com/tikupc/singledetail/8a1fa8114431b90d6c85c700', '1025991592520384516', '0');
INSERT INTO `crawler_question` VALUES ('1025991651760734210', 'https://tiku.baidu.com/tikupc/singledetail/28f7b0717fd5360cba1adb53', '1025991521531789314', '0');
INSERT INTO `crawler_question` VALUES ('1025991651760734212', 'https://tiku.baidu.com/tikupc/singledetail/2e96cfd376eeaeaad1f3306e', '1025991558890455041', '0');
INSERT INTO `crawler_question` VALUES ('1025991651806871554', 'https://tiku.baidu.com/tikupc/singledetail/bd1c03d8ce2f0066f533221b', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991651806871553', 'https://tiku.baidu.com/tikupc/singledetail/7a0d79563c1ec5da50e27002', '1025991592797208579', '0');
INSERT INTO `crawler_question` VALUES ('1025991651806871555', 'https://tiku.baidu.com/tikupc/singledetail/b53ac5da50e2524de5187e21', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991651819454465', 'https://tiku.baidu.com/tikupc/singledetail/4ddc52e2524de518964b7d03', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991651848814594', 'https://tiku.baidu.com/tikupc/singledetail/22350b4c2e3f5727a5e96206', '1025991591991902211', '0');
INSERT INTO `crawler_question` VALUES ('1025991651869786113', 'https://tiku.baidu.com/tikupc/singledetail/cdc50c225901020207409c03', '1025991592520384516', '0');
INSERT INTO `crawler_question` VALUES ('1025991651869786114', 'https://tiku.baidu.com/tikupc/singledetail/473e978fcc22bcd126ff0cd1', '1025991517148741634', '0');
INSERT INTO `crawler_question` VALUES ('1025991651890757633', 'https://tiku.baidu.com/tikupc/singledetail/f95bc281e53a580216fcfe43', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991651924312065', 'https://tiku.baidu.com/tikupc/singledetail/74e308a1284ac850ad024221', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991651924312066', 'https://tiku.baidu.com/tikupc/singledetail/7715487302768e9951e7381d', '1025991545196052481', '0');
INSERT INTO `crawler_question` VALUES ('1025991651924312067', 'https://tiku.baidu.com/tikupc/singledetail/676aa45177232f60ddcca106', '1025991591991902211', '0');
INSERT INTO `crawler_question` VALUES ('1025991651987226628', 'https://tiku.baidu.com/tikupc/singledetail/ee42580216fc700abb68fc7d', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991651987226627', 'https://tiku.baidu.com/tikupc/singledetail/3dfd240c844769eae009ed2b', '1025991592520384516', '0');
INSERT INTO `crawler_question` VALUES ('1025991651987226626', 'https://tiku.baidu.com/tikupc/singledetail/6eda2cc58bd63186bcebbc1a', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991652033363970', 'https://tiku.baidu.com/tikupc/singledetail/17a45ef7ba0d4a7302763a4e', '1025991572823932929', '0');
INSERT INTO `crawler_question` VALUES ('1025991652079501313', 'https://tiku.baidu.com/tikupc/singledetail/9235f7ec4afe04a1b071de7c', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991652079501314', 'https://tiku.baidu.com/tikupc/singledetail/99164431b90d6c85ec3ac602', '1025991592520384516', '0');
INSERT INTO `crawler_question` VALUES ('1025991652079501315', 'https://tiku.baidu.com/tikupc/singledetail/49f7b8f67c1cfad6195fa71a', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991652175970307', 'https://tiku.baidu.com/tikupc/singledetail/2f3c2f60ddccda38376baf1a', '1025991536450928641', '0');
INSERT INTO `crawler_question` VALUES ('1025991652175970306', 'https://tiku.baidu.com/tikupc/singledetail/9a0e3b3567ec102de2bd8957', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991652251467777', 'https://tiku.baidu.com/tikupc/singledetail/5d45951ea76e58fafab003b8', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991652285022209', 'https://tiku.baidu.com/tikupc/singledetail/dd7bbd64783e0912a2162a57', '1025991512690196481', '0');
INSERT INTO `crawler_question` VALUES ('1025991652347936769', 'https://tiku.baidu.com/tikupc/singledetail/b5f0a88271fe910ef12df89d', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991652423434241', 'https://tiku.baidu.com/tikupc/singledetail/70d633d4b14e852458fb5701', '1025991618751561729', '0');
INSERT INTO `crawler_question` VALUES ('1025991652465377281', 'https://tiku.baidu.com/tikupc/singledetail/65f73069a45177232f60a2d9', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991652561846274', 'https://tiku.baidu.com/tikupc/singledetail/41214b35eefdc8d376ee3201', '1025991618751561729', '0');
INSERT INTO `crawler_question` VALUES ('1025991652561846275', 'https://tiku.baidu.com/tikupc/singledetail/117df46527d3240c8447ef0d', '1025991593107587074', '0');
INSERT INTO `crawler_question` VALUES ('1025991652595400706', 'https://tiku.baidu.com/tikupc/singledetail/2f7eb1717fd5360cba1adbda', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991652712841217', 'https://tiku.baidu.com/tikupc/singledetail/bab3f121dd36a32d73758109', '1025991593107587074', '0');
INSERT INTO `crawler_question` VALUES ('1025991652712841218', 'https://tiku.baidu.com/tikupc/singledetail/6b6daf1ffc4ffe473368ab03', '1025991618751561729', '0');
INSERT INTO `crawler_question` VALUES ('1025991652817698818', 'https://tiku.baidu.com/tikupc/singledetail/8c9ad8ef5ef7ba0d4a733b0c', '1025991572953956353', '0');
INSERT INTO `crawler_question` VALUES ('1025991652859641857', 'https://tiku.baidu.com/tikupc/singledetail/3ced856a561252d380eb6e01', '1025991593304719363', '0');
INSERT INTO `crawler_question` VALUES ('1025991652889001986', 'https://tiku.baidu.com/tikupc/singledetail/862ddd36a32d7375a4178009', '1025991593107587074', '0');
INSERT INTO `crawler_question` VALUES ('1025991652914167811', 'https://tiku.baidu.com/tikupc/singledetail/cefe80eb6294dd88d0d26b28', '1025991618751561729', '0');
INSERT INTO `crawler_question` VALUES ('1025991652914167810', 'https://tiku.baidu.com/tikupc/singledetail/1b8ed5bbfd0a79563c1e7248', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991652968693761', 'https://tiku.baidu.com/tikupc/singledetail/3109bcd126fff705cc170a2e', '1025991593304719363', '0');
INSERT INTO `crawler_question` VALUES ('1025991652968693762', 'https://tiku.baidu.com/tikupc/singledetail/6d71be23482fb4daa58d4b2e', '1025991593514434563', '0');
INSERT INTO `crawler_question` VALUES ('1025991653027414019', 'https://tiku.baidu.com/tikupc/singledetail/9161e2bd960590c69ec37649', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991653027414018', 'https://tiku.baidu.com/tikupc/singledetail/02bc69dc5022aaea998f0f09', '1025991593107587074', '0');
INSERT INTO `crawler_question` VALUES ('1025991653027414017', 'https://tiku.baidu.com/tikupc/singledetail/bf9baeaad1f34693daef3e70', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991653039996930', 'https://tiku.baidu.com/tikupc/singledetail/6484d4d8d15abe23482f4d01', '1025991619351347201', '0');
INSERT INTO `crawler_question` VALUES ('1025991653073551361', 'https://tiku.baidu.com/tikupc/singledetail/6fdcd15abe23482fb4da4c01', '1025991593304719363', '0');
INSERT INTO `crawler_question` VALUES ('1025991653073551362', 'https://tiku.baidu.com/tikupc/singledetail/ae3c5f0e7cd184254b35352e', '1025991593514434563', '0');
INSERT INTO `crawler_question` VALUES ('1025991653090328577', 'https://tiku.baidu.com/tikupc/singledetail/61226c175f0e7cd184253636', '1025991559179862018', '0');
INSERT INTO `crawler_question` VALUES ('1025991653132271617', 'https://tiku.baidu.com/tikupc/singledetail/ce4b650e52ea551810a68750', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991653132271618', 'https://tiku.baidu.com/tikupc/singledetail/154990c69ec3d5bbfd0a7449', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991653140660226', 'https://tiku.baidu.com/tikupc/singledetail/d4b965ce050876323112120b', '1025991593107587074', '0');
INSERT INTO `crawler_question` VALUES ('1025991653157437443', 'https://tiku.baidu.com/tikupc/singledetail/8c7401f69e31433239689300', '1025991593304719363', '0');
INSERT INTO `crawler_question` VALUES ('1025991653157437444', 'https://tiku.baidu.com/tikupc/singledetail/0327482fb4daa58da0114a01', '1025991593514434563', '0');
INSERT INTO `crawler_question` VALUES ('1025991653157437442', 'https://tiku.baidu.com/tikupc/singledetail/51ad011ca300a6c30c229fc0', '1025991619351347201', '0');
INSERT INTO `crawler_question` VALUES ('1025991653211963394', 'https://tiku.baidu.com/tikupc/singledetail/74e208a1284ac850ad024220', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991653211963395', 'https://tiku.baidu.com/tikupc/singledetail/593f336c1eb91a37f1115c78', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991653350375426', 'https://tiku.baidu.com/tikupc/singledetail/f3e819e8b8f67c1cfad6b806', '1025991619670114306', '0');
INSERT INTO `crawler_question` VALUES ('1025991653350375429', 'https://tiku.baidu.com/tikupc/singledetail/707cad02de80d4d8d15a4f29', '1025991593514434563', '0');
INSERT INTO `crawler_question` VALUES ('1025991653350375427', 'https://tiku.baidu.com/tikupc/singledetail/74d4e009581b6bd97f19ea3b', '1025991619351347201', '0');
INSERT INTO `crawler_question` VALUES ('1025991653350375428', 'https://tiku.baidu.com/tikupc/singledetail/19e4ad51f01dc281e53af038', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991653350375425', 'https://tiku.baidu.com/tikupc/singledetail/d864f5335a8102d276a22f07', '1025991619531702274', '0');
INSERT INTO `crawler_question` VALUES ('1025991653442650114', 'https://tiku.baidu.com/tikupc/singledetail/41694b35eefdc8d376ee3249', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991653484593154', 'https://tiku.baidu.com/tikupc/singledetail/4de15bcfa1c7aa00b52acb9b', '1025991521313685506', '0');
INSERT INTO `crawler_question` VALUES ('1025991653484593153', 'https://tiku.baidu.com/tikupc/singledetail/7a7779563c1ec5da50e27078', '1025991573344026626', '0');
INSERT INTO `crawler_question` VALUES ('1025991653526536194', 'https://tiku.baidu.com/tikupc/singledetail/1adf4693daef5ef7ba0d3c29', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991653543313409', 'https://tiku.baidu.com/tikupc/singledetail/c8aee53a580216fc700afd2a', '1025991619670114306', '0');
INSERT INTO `crawler_question` VALUES ('1025991653534924801', 'https://tiku.baidu.com/tikupc/singledetail/6366783e0912a21614792907', '1025991619904995330', '0');
INSERT INTO `crawler_question` VALUES ('1025991653534924802', 'https://tiku.baidu.com/tikupc/singledetail/53befd0a79563c1ec5da7100', '1025991593514434563', '0');
INSERT INTO `crawler_question` VALUES ('1025991653560090626', 'https://tiku.baidu.com/tikupc/singledetail/42fa26fff705cc175527092e', '1025991619531702274', '0');
INSERT INTO `crawler_question` VALUES ('1025991653560090625', 'https://tiku.baidu.com/tikupc/singledetail/1cbdaef8941ea76e58fa0441', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991653564284929', 'https://tiku.baidu.com/tikupc/singledetail/9f8baa00b52acfc789ebc949', '1025991512253988865', '0');
INSERT INTO `crawler_question` VALUES ('1025991653551702018', 'https://tiku.baidu.com/tikupc/singledetail/1bfdd5bbfd0a79563c1e723b', '1025991619351347201', '0');
INSERT INTO `crawler_question` VALUES ('1025991653627199490', 'https://tiku.baidu.com/tikupc/singledetail/cd1752d380eb6294dd886c00', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991653635588098', 'https://tiku.baidu.com/tikupc/singledetail/df1c866fb84ae45c3b358c0e', '1025991619670114306', '0');
INSERT INTO `crawler_question` VALUES ('1025991653652365314', 'https://tiku.baidu.com/tikupc/singledetail/a24afe4733687e21af45a900', '1025991619531702274', '0');
INSERT INTO `crawler_question` VALUES ('1025991653660753922', 'https://tiku.baidu.com/tikupc/singledetail/9209f7ec4afe04a1b071de40', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991653660753924', 'https://tiku.baidu.com/tikupc/singledetail/677ea45177232f60ddcca112', '1025991619351347201', '0');
INSERT INTO `crawler_question` VALUES ('1025991653660753923', 'https://tiku.baidu.com/tikupc/singledetail/f35277232f60ddccda38a006', '1025991619904995330', '0');
INSERT INTO `crawler_question` VALUES ('1025991653711085569', 'https://tiku.baidu.com/tikupc/singledetail/5c9c51e79b89680203d82500', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991653719474178', 'https://tiku.baidu.com/tikupc/singledetail/a24ccaaedd3383c4bb4cd22b', '1025991593837395969', '0');
INSERT INTO `crawler_question` VALUES ('1025991653748834306', 'https://tiku.baidu.com/tikupc/singledetail/b9402b160b4e767f5acfce08', '1025991619670114306', '0');
INSERT INTO `crawler_question` VALUES ('1025991653765611522', 'https://tiku.baidu.com/tikupc/singledetail/4a3a5acfa1c7aa00b52acb40', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991653782388738', 'https://tiku.baidu.com/tikupc/singledetail/f505cfc789eb172ded63b72a', '1025991619531702274', '0');
INSERT INTO `crawler_question` VALUES ('1025991653870469122', 'https://tiku.baidu.com/tikupc/singledetail/6132a76e58fafab069dc0229', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991653870469123', 'https://tiku.baidu.com/tikupc/singledetail/b94e2b160b4e767f5acfce06', '1025991620177625090', '0');
INSERT INTO `crawler_question` VALUES ('1025991653870469124', 'https://tiku.baidu.com/tikupc/singledetail/d3718e9951e79b8968022602', '1025991593837395969', '0');
INSERT INTO `crawler_question` VALUES ('1025991653870469121', 'https://tiku.baidu.com/tikupc/singledetail/1365852458fb770bf78a552e', '1025991619904995330', '0');
INSERT INTO `crawler_question` VALUES ('1025991653916606466', 'https://tiku.baidu.com/tikupc/singledetail/154190c69ec3d5bbfd0a7441', '1025991573650210817', '0');
INSERT INTO `crawler_question` VALUES ('1025991653933383681', 'https://tiku.baidu.com/tikupc/singledetail/4e1459eef8c75fbfc77db20d', '1025991619531702274', '0');
INSERT INTO `crawler_question` VALUES ('1025991653987909634', 'https://tiku.baidu.com/tikupc/singledetail/5eb1001ca300a6c30c229fdc', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991653987909636', 'https://tiku.baidu.com/tikupc/singledetail/8ece89eb172ded630b1cb60c', '1025991593837395969', '0');
INSERT INTO `crawler_question` VALUES ('1025991653987909635', 'https://tiku.baidu.com/tikupc/singledetail/9503b52acfc789eb172dc806', '1025991620177625090', '0');
INSERT INTO `crawler_question` VALUES ('1025991653987909633', 'https://tiku.baidu.com/tikupc/singledetail/514258fafab069dc50220129', '1025991533527498757', '0');
INSERT INTO `crawler_question` VALUES ('1025991653987909637', 'https://tiku.baidu.com/tikupc/singledetail/d84df5335a8102d276a22f2e', '1025991619904995330', '0');
INSERT INTO `crawler_question` VALUES ('1025991654088572932', 'https://tiku.baidu.com/tikupc/singledetail/fa42b84ae45c3b3567ec8b28', '1025991620177625090', '0');
INSERT INTO `crawler_question` VALUES ('1025991654088572931', 'https://tiku.baidu.com/tikupc/singledetail/4bdd7f19227916888486d701', '1025991594307158018', '0');
INSERT INTO `crawler_question` VALUES ('1025991654088572930', 'https://tiku.baidu.com/tikupc/singledetail/1f76f66527d3240c8447ef06', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991654122127361', 'https://tiku.baidu.com/tikupc/singledetail/7e24bb68a98271fe910ef92b', '1025991619904995330', '0');
INSERT INTO `crawler_question` VALUES ('1025991654180847619', 'https://tiku.baidu.com/tikupc/singledetail/ce1a650e52ea551810a68701', '1025991594307158018', '0');
INSERT INTO `crawler_question` VALUES ('1025991654180847618', 'https://tiku.baidu.com/tikupc/singledetail/62283369a45177232f60a206', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991654256345090', 'https://tiku.baidu.com/tikupc/singledetail/8020ccbff121dd36a32d8201', '1025991594307158018', '0');
INSERT INTO `crawler_question` VALUES ('1025991654264733697', 'https://tiku.baidu.com/tikupc/singledetail/62153369a45177232f60a23b', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991654298288129', 'https://tiku.baidu.com/tikupc/singledetail/8456ff00bed5b9f3f90f1c49', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991654344425475', 'https://tiku.baidu.com/tikupc/singledetail/813d376baf1ffc4ffe47ac00', '1025991594307158018', '0');
INSERT INTO `crawler_question` VALUES ('1025991654344425474', 'https://tiku.baidu.com/tikupc/singledetail/f0878beb172ded630b1cb645', '1025991535003893762', '0');
INSERT INTO `crawler_question` VALUES ('1025991654398951426', 'https://tiku.baidu.com/tikupc/singledetail/d3508e9951e79b8968022623', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991654440894465', 'https://tiku.baidu.com/tikupc/singledetail/60b8960590c69ec3d5bb7500', '1025991594307158018', '0');
INSERT INTO `crawler_question` VALUES ('1025991654482837506', 'https://tiku.baidu.com/tikupc/singledetail/d8346edb6f1aff00bed51e23', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991654533169153', 'https://tiku.baidu.com/tikupc/singledetail/51ff360cba1aa8114431d92f', '1025991620429283329', '0');
INSERT INTO `crawler_question` VALUES ('1025991654587695105', 'https://tiku.baidu.com/tikupc/singledetail/9fbfaa00b52acfc789ebc97d', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991654587695106', 'https://tiku.baidu.com/tikupc/singledetail/b45aa98271fe910ef12df837', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991654646415362', 'https://tiku.baidu.com/tikupc/singledetail/d3438e9951e79b8968022630', '1025991620429283329', '0');
INSERT INTO `crawler_question` VALUES ('1025991654721912834', 'https://tiku.baidu.com/tikupc/singledetail/2e37fad6195f312b3169a52e', '1025991593992585217', '0');
INSERT INTO `crawler_question` VALUES ('1025991654721912836', 'https://tiku.baidu.com/tikupc/singledetail/307c767f5acfa1c7aa00cc37', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991654721912835', 'https://tiku.baidu.com/tikupc/singledetail/b411a98271fe910ef12df87c', '1025991574019309569', '0');
INSERT INTO `crawler_question` VALUES ('1025991654768050178', 'https://tiku.baidu.com/tikupc/singledetail/1bfad5bbfd0a79563c1e723c', '1025991620429283329', '0');
INSERT INTO `crawler_question` VALUES ('1025991654768050177', 'https://tiku.baidu.com/tikupc/singledetail/a65970fe910ef12d2af9e7de', '1025991574157721602', '0');
INSERT INTO `crawler_question` VALUES ('1025991654814187523', 'https://tiku.baidu.com/tikupc/singledetail/cc3d27284b73f242336c5f45', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991654814187522', 'https://tiku.baidu.com/tikupc/singledetail/87e7da38376baf1ffc4fad2e', '1025991593992585217', '0');
INSERT INTO `crawler_question` VALUES ('1025991654830964737', 'https://tiku.baidu.com/tikupc/singledetail/115bf46527d3240c8447ef2b', '1025991620630609922', '0');
INSERT INTO `crawler_question` VALUES ('1025991654856130562', 'https://tiku.baidu.com/tikupc/singledetail/f538cfc789eb172ded63b717', '1025991620429283329', '0');
INSERT INTO `crawler_question` VALUES ('1025991654898073603', 'https://tiku.baidu.com/tikupc/singledetail/1860cf84b9d528ea81c7792e', '1025991593992585217', '0');
INSERT INTO `crawler_question` VALUES ('1025991654898073604', 'https://tiku.baidu.com/tikupc/singledetail/8c4501f69e31433239689331', '1025991620630609922', '0');
INSERT INTO `crawler_question` VALUES ('1025991654898073602', 'https://tiku.baidu.com/tikupc/singledetail/9a0b3b3567ec102de2bd8952', '1025991573759262723', '0');
INSERT INTO `crawler_question` VALUES ('1025991654990348289', 'https://tiku.baidu.com/tikupc/singledetail/141c52ea551810a6f5248617', '1025991620429283329', '0');
INSERT INTO `crawler_question` VALUES ('1025991655061651459', 'https://tiku.baidu.com/tikupc/singledetail/a14833687e21af45b307a80a', '1025991620630609922', '0');
INSERT INTO `crawler_question` VALUES ('1025991655061651458', 'https://tiku.baidu.com/tikupc/singledetail/7637b90d6c85ec3a87c2c503', '1025991593992585217', '0');
INSERT INTO `crawler_question` VALUES ('1025991655061651460', 'https://tiku.baidu.com/tikupc/singledetail/39260342a8956bec0975e3da', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991655116177410', 'https://tiku.baidu.com/tikupc/singledetail/51e8011ca300a6c30c229f85', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991655162314754', 'https://tiku.baidu.com/tikupc/singledetail/fb6b9b6648d7c1c708a1450a', '1025991620630609922', '0');
INSERT INTO `crawler_question` VALUES ('1025991655162314755', 'https://tiku.baidu.com/tikupc/singledetail/b530c5da50e2524de5187e2b', '1025991593992585217', '0');
INSERT INTO `crawler_question` VALUES ('1025991655162314756', 'https://tiku.baidu.com/tikupc/singledetail/12c09cc3d5bbfd0a79567303', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991655212646401', 'https://tiku.baidu.com/tikupc/singledetail/cd430c225901020207409c85', '1025991511624843267', '0');
INSERT INTO `crawler_question` VALUES ('1025991655237812227', 'https://tiku.baidu.com/tikupc/singledetail/6e020540be1e650e52ea9905', '1025991574472294401', '0');
INSERT INTO `crawler_question` VALUES ('1025991655246200833', 'https://tiku.baidu.com/tikupc/singledetail/d88486c24028915f804dc2bb', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991655237812226', 'https://tiku.baidu.com/tikupc/singledetail/1f30af45b307e87101f69614', '1025991620630609922', '0');
INSERT INTO `crawler_question` VALUES ('1025991655246200834', 'https://tiku.baidu.com/tikupc/singledetail/20c92e60ddccda38376bafef', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991655397195778', 'https://tiku.baidu.com/tikupc/singledetail/86406137ee06eff9aef80783', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991655388807169', 'https://tiku.baidu.com/tikupc/singledetail/f64e1711cc7931b765ce1532', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991655405584385', 'https://tiku.baidu.com/tikupc/singledetail/74d0e009581b6bd97f19ea3f', '1025991594768531460', '0');
INSERT INTO `crawler_question` VALUES ('1025991655405584386', 'https://tiku.baidu.com/tikupc/singledetail/14c19ec3d5bbfd0a79567302', '1025991620940988418', '0');
INSERT INTO `crawler_question` VALUES ('1025991655422361601', 'https://tiku.baidu.com/tikupc/singledetail/9fd65322aaea998fcc220e0f', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991655468498945', 'https://tiku.baidu.com/tikupc/singledetail/76e8905f804d2b160b4ec0c5', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991655468498946', 'https://tiku.baidu.com/tikupc/singledetail/1e14edf9aef8941ea76e0517', '1025991574623289345', '0');
INSERT INTO `crawler_question` VALUES ('1025991655476887553', 'https://tiku.baidu.com/tikupc/singledetail/5ad6941ea76e58fafab0032b', '1025991620940988418', '0');
INSERT INTO `crawler_question` VALUES ('1025991655476887554', 'https://tiku.baidu.com/tikupc/singledetail/041a192e453610661ed9f43d', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991655476887555', 'https://tiku.baidu.com/tikupc/singledetail/be55afaad1f34693daef3ebe', '1025991559343439875', '0');
INSERT INTO `crawler_question` VALUES ('1025991655476887556', 'https://tiku.baidu.com/tikupc/singledetail/831df12d2af90242a895e516', '1025991594768531460', '0');
INSERT INTO `crawler_question` VALUES ('1025991655539802113', 'https://tiku.baidu.com/tikupc/singledetail/7c2517791711cc7931b71636', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991655514636290', 'https://tiku.baidu.com/tikupc/singledetail/fd0940323968011ca300913d', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991655569162241', 'https://tiku.baidu.com/tikupc/singledetail/184ccf84b9d528ea81c77902', '1025991595154407431', '0');
INSERT INTO `crawler_question` VALUES ('1025991655569162242', 'https://tiku.baidu.com/tikupc/singledetail/364d29ea81c758f5f61f679d', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991655602716673', 'https://tiku.baidu.com/tikupc/singledetail/f6541711cc7931b765ce1528', '1025991621448499201', '0');
INSERT INTO `crawler_question` VALUES ('1025991655619493889', 'https://tiku.baidu.com/tikupc/singledetail/bfd65fbfc77da26925c5b014', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991655619493890', 'https://tiku.baidu.com/tikupc/singledetail/540f16fc700abb68a982fb08', '1025991620940988418', '0');
INSERT INTO `crawler_question` VALUES ('1025991655627882498', 'https://tiku.baidu.com/tikupc/singledetail/659ba0116c175f0e7cd13713', '1025991594768531460', '0');
INSERT INTO `crawler_question` VALUES ('1025991655627882499', 'https://tiku.baidu.com/tikupc/singledetail/09b871eeaeaad1f346933f6e', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991655627882500', 'https://tiku.baidu.com/tikupc/singledetail/81364c31b90d6c85ec3ac622', '1025991546643087361', '0');
INSERT INTO `crawler_question` VALUES ('1025991655669825539', 'https://tiku.baidu.com/tikupc/singledetail/90f25022aaea998fcc220e2b', '1025991595154407431', '0');
INSERT INTO `crawler_question` VALUES ('1025991655669825538', 'https://tiku.baidu.com/tikupc/singledetail/0f4f77eeaeaad1f346933f99', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991655694991362', 'https://tiku.baidu.com/tikupc/singledetail/4d44312b3169a4517723a31e', '1025991621448499201', '0');
INSERT INTO `crawler_question` VALUES ('1025991655720157185', 'https://tiku.baidu.com/tikupc/singledetail/031b482fb4daa58da0114a3d', '1025991559658012674', '0');
INSERT INTO `crawler_question` VALUES ('1025991655745323010', 'https://tiku.baidu.com/tikupc/singledetail/5ae1941ea76e58fafab0031c', '1025991594768531460', '0');
INSERT INTO `crawler_question` VALUES ('1025991655745323009', 'https://tiku.baidu.com/tikupc/singledetail/83f60508763231126edb113d', '1025991620940988418', '0');
INSERT INTO `crawler_question` VALUES ('1025991655778877442', 'https://tiku.baidu.com/tikupc/singledetail/6a8de5bd960590c69ec376a5', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991655778877441', 'https://tiku.baidu.com/tikupc/singledetail/6849be1e650e52ea5518980c', '1025991595154407431', '0');
INSERT INTO `crawler_question` VALUES ('1025991655787266049', 'https://tiku.baidu.com/tikupc/singledetail/53f3fd0a79563c1ec5da714d', '1025991621448499201', '0');
INSERT INTO `crawler_question` VALUES ('1025991655787266050', 'https://tiku.baidu.com/tikupc/singledetail/8586fe00bed5b9f3f90f1c99', '1025991521871527937', '0');
INSERT INTO `crawler_question` VALUES ('1025991655883735041', 'https://tiku.baidu.com/tikupc/singledetail/0a6a5ff5f61fb7360b4c65a8', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991655883735042', 'https://tiku.baidu.com/tikupc/singledetail/90c2ba0d4a7302768e993930', '1025991595154407431', '0');
INSERT INTO `crawler_question` VALUES ('1025991655904706562', 'https://tiku.baidu.com/tikupc/singledetail/b9072b160b4e767f5acfce4f', '1025991621448499201', '0');
INSERT INTO `crawler_question` VALUES ('1025991655971815426', 'https://tiku.baidu.com/tikupc/singledetail/d5edce2f0066f5335a812130', '1025991595154407431', '0');
INSERT INTO `crawler_question` VALUES ('1025991655971815427', 'https://tiku.baidu.com/tikupc/singledetail/fd3d591b6bd97f192279e931', '1025991528976678913', '0');
INSERT INTO `crawler_question` VALUES ('1025991656013758466', 'https://tiku.baidu.com/tikupc/singledetail/6ec82cc58bd63186bcebbc08', '1025991575038525441', '0');
INSERT INTO `crawler_question` VALUES ('1025991656110227458', 'https://tiku.baidu.com/tikupc/singledetail/b90b5727a5e9856a56126031', '1025991575038525441', '0');
INSERT INTO `crawler_question` VALUES ('1025991656194113538', 'https://tiku.baidu.com/tikupc/singledetail/de7be518964bcf84b9d57b33', '1025991575038525441', '0');
INSERT INTO `crawler_question` VALUES ('1025991656324136962', 'https://tiku.baidu.com/tikupc/singledetail/b9095727a5e9856a56126033', '1025991575038525441', '0');
INSERT INTO `crawler_question` VALUES ('1025991656366080002', 'https://tiku.baidu.com/tikupc/singledetail/f87743323968011ca3009143', '1025991595015995393', '0');
INSERT INTO `crawler_question` VALUES ('1025991656391245826', 'https://tiku.baidu.com/tikupc/singledetail/1b380266f5335a8102d22012', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991656391245825', 'https://tiku.baidu.com/tikupc/singledetail/51e4998fcc22bcd126ff0c0b', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991656433188866', 'https://tiku.baidu.com/tikupc/singledetail/e7e9102de2bd960590c67700', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991656483520514', 'https://tiku.baidu.com/tikupc/singledetail/1bf3700abb68a98271fefa0a', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991656483520515', 'https://tiku.baidu.com/tikupc/singledetail/4a355acfa1c7aa00b52acb4f', '1025991595015995393', '0');
INSERT INTO `crawler_question` VALUES ('1025991656508686338', 'https://tiku.baidu.com/tikupc/singledetail/1df2fac75fbfc77da269b119', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991656508686339', 'https://tiku.baidu.com/tikupc/singledetail/40aab9d528ea81c758f5782b', '1025991622174113793', '0');
INSERT INTO `crawler_question` VALUES ('1025991656567406594', 'https://tiku.baidu.com/tikupc/singledetail/64acd4d8d15abe23482f4d29', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991656592572418', 'https://tiku.baidu.com/tikupc/singledetail/862edd36a32d7375a417800a', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991656592572419', 'https://tiku.baidu.com/tikupc/singledetail/8d78eefdc8d376eeaeaa3148', '1025991595015995393', '0');
INSERT INTO `crawler_question` VALUES ('1025991656609349634', 'https://tiku.baidu.com/tikupc/singledetail/6f1e2dc58bd63186bcebbcde', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991656638709762', 'https://tiku.baidu.com/tikupc/singledetail/f58c1611cc7931b765ce15f0', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991656651292674', 'https://tiku.baidu.com/tikupc/singledetail/13c258f5f61fb7360b4c6500', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991656638709763', 'https://tiku.baidu.com/tikupc/singledetail/9a2f02768e9951e79b892759', '1025991622174113793', '0');
INSERT INTO `crawler_question` VALUES ('1025991656680652802', 'https://tiku.baidu.com/tikupc/singledetail/1ccfaef8941ea76e58fa0433', '1025991560681422851', '0');
INSERT INTO `crawler_question` VALUES ('1025991656680652803', 'https://tiku.baidu.com/tikupc/singledetail/092ca417866fb84ae45c8d5c', '1025991595015995393', '0');
INSERT INTO `crawler_question` VALUES ('1025991656693235714', 'https://tiku.baidu.com/tikupc/singledetail/8d48dbef5ef7ba0d4a733bde', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991656756150273', 'https://tiku.baidu.com/tikupc/singledetail/90dbba0d4a7302768e993929', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991656756150275', 'https://tiku.baidu.com/tikupc/singledetail/5406f80f76c66137ee0619f0', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991656756150274', 'https://tiku.baidu.com/tikupc/singledetail/80fe366baf1ffc4ffe47acc3', '1025991622174113793', '0');
INSERT INTO `crawler_question` VALUES ('1025991656781316099', 'https://tiku.baidu.com/tikupc/singledetail/849aff00bed5b9f3f90f1c85', '1025991595015995393', '0');
INSERT INTO `crawler_question` VALUES ('1025991656781316098', 'https://tiku.baidu.com/tikupc/singledetail/0904ce1755270722192ef707', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991656810676226', 'https://tiku.baidu.com/tikupc/singledetail/2891b0717fd5360cba1adb35', '1025991575852220417', '0');
INSERT INTO `crawler_question` VALUES ('1025991656827453441', 'https://tiku.baidu.com/tikupc/singledetail/f8bc9a6648d7c1c708a145dd', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991656852619266', 'https://tiku.baidu.com/tikupc/singledetail/d5f4ce2f0066f5335a812129', '1025991575457955841', '0');
INSERT INTO `crawler_question` VALUES ('1025991656881979393', 'https://tiku.baidu.com/tikupc/singledetail/231c541810a6f524ccbf85f3', '1025991522135769089', '0');
INSERT INTO `crawler_question` VALUES ('1025991656881979394', 'https://tiku.baidu.com/tikupc/singledetail/d1b7640e52ea551810a687ac', '1025991622174113793', '0');
INSERT INTO `crawler_question` VALUES ('1025991656890368002', 'https://tiku.baidu.com/tikupc/singledetail/9c19ab00b52acfc789ebc9db', '1025991517576560643', '0');
INSERT INTO `crawler_question` VALUES ('1025991656902950913', 'https://tiku.baidu.com/tikupc/singledetail/d5e2ce2f0066f5335a81213f', '1025991595888410626', '0');
INSERT INTO `crawler_question` VALUES ('1025991656961671170', 'https://tiku.baidu.com/tikupc/singledetail/261410a6f524ccbff1218409', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991656961671171', 'https://tiku.baidu.com/tikupc/singledetail/358184868762caaedd33d40c', '1025991622488686594', '0');
INSERT INTO `crawler_question` VALUES ('1025991656970059777', 'https://tiku.baidu.com/tikupc/singledetail/53b2fd0a79563c1ec5da710c', '1025991575852220417', '0');
INSERT INTO `crawler_question` VALUES ('1025991657028780033', 'https://tiku.baidu.com/tikupc/singledetail/ce06650e52ea551810a6871d', '1025991595888410626', '0');
INSERT INTO `crawler_question` VALUES ('1025991657062334467', 'https://tiku.baidu.com/tikupc/singledetail/261558fb770bf78a65295434', '1025991575852220417', '0');
INSERT INTO `crawler_question` VALUES ('1025991657062334468', 'https://tiku.baidu.com/tikupc/singledetail/c5d5637d27284b73f24250f9', '1025991595477368833', '0');
INSERT INTO `crawler_question` VALUES ('1025991657062334466', 'https://tiku.baidu.com/tikupc/singledetail/b3a91a37f111f18583d05a15', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991657112666113', 'https://tiku.baidu.com/tikupc/singledetail/5902336c1eb91a37f1115c45', '1025991595888410626', '0');
INSERT INTO `crawler_question` VALUES ('1025991657183969282', 'https://tiku.baidu.com/tikupc/singledetail/8e44a26925c52cc58bd6be3c', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991657183969283', 'https://tiku.baidu.com/tikupc/singledetail/9d7a7fd5360cba1aa811da0e', '1025991575852220417', '0');
INSERT INTO `crawler_question` VALUES ('1025991657183969284', 'https://tiku.baidu.com/tikupc/singledetail/a806fdb069dc5022aaea00f9', '1025991595477368833', '0');
INSERT INTO `crawler_question` VALUES ('1025991657213329410', 'https://tiku.baidu.com/tikupc/singledetail/08c6cd1755270722192ef7c1', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991657225912321', 'https://tiku.baidu.com/tikupc/singledetail/ecb2dd3383c4bb4cf7ecd119', '1025991595888410626', '0');
INSERT INTO `crawler_question` VALUES ('1025991657213329409', 'https://tiku.baidu.com/tikupc/singledetail/8a01a8114431b90d6c85c71e', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991657251078145', 'https://tiku.baidu.com/tikupc/singledetail/4f8e680203d8ce2f00662302', '1025991623688257538', '0');
INSERT INTO `crawler_question` VALUES ('1025991657276243969', 'https://tiku.baidu.com/tikupc/singledetail/d3658e9951e79b8968022616', '1025991547247067140', '0');
INSERT INTO `crawler_question` VALUES ('1025991657305604098', 'https://tiku.baidu.com/tikupc/singledetail/98b7cf50ad02de80d4d840f8', '1025991595477368833', '0');
INSERT INTO `crawler_question` VALUES ('1025991657313992705', 'https://tiku.baidu.com/tikupc/singledetail/3cab856a561252d380eb6e47', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991657322381314', 'https://tiku.baidu.com/tikupc/singledetail/951db52acfc789eb172dc818', '1025991595888410626', '0');
INSERT INTO `crawler_question` VALUES ('1025991657322381313', 'https://tiku.baidu.com/tikupc/singledetail/35c703020740be1e650e9ac3', '1025991498488283137', '0');
INSERT INTO `crawler_question` VALUES ('1025991657322381315', 'https://tiku.baidu.com/tikupc/singledetail/cd810c225901020207409c47', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991657347547137', 'https://tiku.baidu.com/tikupc/singledetail/8a25a8114431b90d6c85c73a', '1025991623688257538', '0');
INSERT INTO `crawler_question` VALUES ('1025991657410461698', 'https://tiku.baidu.com/tikupc/singledetail/e82a25c52cc58bd63186bd46', '1025991530142695426', '0');
INSERT INTO `crawler_question` VALUES ('1025991657418850306', 'https://tiku.baidu.com/tikupc/singledetail/ea0bff8a6529647d27285205', '1025991595477368833', '0');
INSERT INTO `crawler_question` VALUES ('1025991657435627521', 'https://tiku.baidu.com/tikupc/singledetail/009176eeaeaad1f346933f47', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991657444016130', 'https://tiku.baidu.com/tikupc/singledetail/37c9bed126fff705cc170aee', '1025991623688257538', '0');
INSERT INTO `crawler_question` VALUES ('1025991657565650946', 'https://tiku.baidu.com/tikupc/singledetail/78d8990ef12d2af90242e623', '1025991595477368833', '0');
INSERT INTO `crawler_question` VALUES ('1025991657565650945', 'https://tiku.baidu.com/tikupc/singledetail/b8ca84254b35eefdc8d3331e', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991657641148418', 'https://tiku.baidu.com/tikupc/singledetail/d9dd76a20029bd64783e2c0a', '1025991596177817602', '0');
INSERT INTO `crawler_question` VALUES ('1025991657691480066', 'https://tiku.baidu.com/tikupc/singledetail/cd40b307e87101f69e319500', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991657716645889', 'https://tiku.baidu.com/tikupc/singledetail/cefd80eb6294dd88d0d26b2b', '1025991596404310019', '0');
INSERT INTO `crawler_question` VALUES ('1025991657716645890', 'https://tiku.baidu.com/tikupc/singledetail/573b0722192e45361066f519', '1025991560501067780', '0');
INSERT INTO `crawler_question` VALUES ('1025991657775366146', 'https://tiku.baidu.com/tikupc/singledetail/b3951a37f111f18583d05a29', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991657867640834', 'https://tiku.baidu.com/tikupc/singledetail/bd0703d8ce2f0066f5332200', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991657859252226', 'https://tiku.baidu.com/tikupc/singledetail/6112a76e58fafab069dc0209', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991657917972482', 'https://tiku.baidu.com/tikupc/singledetail/9123e2bd960590c69ec3760b', '1025991575973855234', '0');
INSERT INTO `crawler_question` VALUES ('1025991657959915523', 'https://tiku.baidu.com/tikupc/singledetail/90d05022aaea998fcc220e09', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991657959915522', 'https://tiku.baidu.com/tikupc/singledetail/51ef998fcc22bcd126ff0c00', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991658001858562', 'https://tiku.baidu.com/tikupc/singledetail/f64c1711cc7931b765ce1530', '1025991575973855234', '0');
INSERT INTO `crawler_question` VALUES ('1025991658043801602', 'https://tiku.baidu.com/tikupc/singledetail/9c3b7cd184254b35eefd3430', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991658043801601', 'https://tiku.baidu.com/tikupc/singledetail/ddea4afe04a1b0717fd5dd03', '1025991575311155202', '0');
INSERT INTO `crawler_question` VALUES ('1025991658098327554', 'https://tiku.baidu.com/tikupc/singledetail/9c387cd184254b35eefd3433', '1025991575973855234', '0');
INSERT INTO `crawler_question` VALUES ('1025991658182213633', 'https://tiku.baidu.com/tikupc/singledetail/de43e518964bcf84b9d57b0b', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991658299654146', 'https://tiku.baidu.com/tikupc/singledetail/35f484868762caaedd33d479', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991658299654147', 'https://tiku.baidu.com/tikupc/singledetail/1ad04693daef5ef7ba0d3c26', '1025991596039405569', '0');
INSERT INTO `crawler_question` VALUES ('1025991658299654148', 'https://tiku.baidu.com/tikupc/singledetail/141652ea551810a6f524861d', '1025991623893778434', '0');
INSERT INTO `crawler_question` VALUES ('1025991658345791490', 'https://tiku.baidu.com/tikupc/singledetail/8c6101f69e31433239689315', '1025991576414257156', '0');
INSERT INTO `crawler_question` VALUES ('1025991658387734531', 'https://tiku.baidu.com/tikupc/singledetail/49b4b8f67c1cfad6195fa759', '1025991623893778434', '0');
INSERT INTO `crawler_question` VALUES ('1025991658387734530', 'https://tiku.baidu.com/tikupc/singledetail/4af95acfa1c7aa00b52acb83', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991658429677569', 'https://tiku.baidu.com/tikupc/singledetail/49b9b8f67c1cfad6195fa754', '1025991596039405569', '0');
INSERT INTO `crawler_question` VALUES ('1025991658429677570', 'https://tiku.baidu.com/tikupc/singledetail/920ff7ec4afe04a1b071de46', '1025991597033455618', '0');
INSERT INTO `crawler_question` VALUES ('1025991658454843394', 'https://tiku.baidu.com/tikupc/singledetail/cd45ec5c3b3567ec102d8a0a', '1025991547695857665', '0');
INSERT INTO `crawler_question` VALUES ('1025991658471620610', 'https://tiku.baidu.com/tikupc/singledetail/1b2c4793daef5ef7ba0d3cda', '1025991623893778434', '0');
INSERT INTO `crawler_question` VALUES ('1025991658488397826', 'https://tiku.baidu.com/tikupc/singledetail/d2e08f9951e79b8968022693', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991658521952257', 'https://tiku.baidu.com/tikupc/singledetail/dda94afe04a1b0717fd5dd40', '1025991597033455618', '0');
INSERT INTO `crawler_question` VALUES ('1025991658513563650', 'https://tiku.baidu.com/tikupc/singledetail/8169376baf1ffc4ffe47ac54', '1025991596039405569', '0');
INSERT INTO `crawler_question` VALUES ('1025991658576478209', 'https://tiku.baidu.com/tikupc/singledetail/603c05a1b0717fd5360cdcc7', '1025991547490336770', '0');
INSERT INTO `crawler_question` VALUES ('1025991658668752899', 'https://tiku.baidu.com/tikupc/singledetail/678aa1c7aa00b52acfc7ca40', '1025991597033455618', '0');
INSERT INTO `crawler_question` VALUES ('1025991658668752898', 'https://tiku.baidu.com/tikupc/singledetail/6f80d15abe23482fb4da4c5d', '1025991596039405569', '0');
INSERT INTO `crawler_question` VALUES ('1025991658677141506', 'https://tiku.baidu.com/tikupc/singledetail/e23e2af90242a8956bece416', '1025991561541255169', '0');
INSERT INTO `crawler_question` VALUES ('1025991658693918721', 'https://tiku.baidu.com/tikupc/singledetail/607e910ef12d2af90242e685', '1025991547897184257', '0');
INSERT INTO `crawler_question` VALUES ('1025991658790387714', 'https://tiku.baidu.com/tikupc/singledetail/a98e195f312b3169a451a45d', '1025991596039405569', '0');
INSERT INTO `crawler_question` VALUES ('1025991658790387715', 'https://tiku.baidu.com/tikupc/singledetail/411f4b35eefdc8d376ee323f', '1025991561541255169', '0');
INSERT INTO `crawler_question` VALUES ('1025991658790387716', 'https://tiku.baidu.com/tikupc/singledetail/16201ed9ad51f01dc281f143', '1025991597033455618', '0');
INSERT INTO `crawler_question` VALUES ('1025991658861690881', 'https://tiku.baidu.com/tikupc/singledetail/61aaf624ccbff121dd368309', '1025991628880805889', '0');
INSERT INTO `crawler_question` VALUES ('1025991658903633922', 'https://tiku.baidu.com/tikupc/singledetail/cd3252d380eb6294dd886c25', '1025991597033455618', '0');
INSERT INTO `crawler_question` VALUES ('1025991658953965569', 'https://tiku.baidu.com/tikupc/singledetail/8113376baf1ffc4ffe47ac2e', '1025991597838761985', '0');
INSERT INTO `crawler_question` VALUES ('1025991659067211777', 'https://tiku.baidu.com/tikupc/singledetail/d003e87101f69e3143329401', '1025991597838761985', '0');
INSERT INTO `crawler_question` VALUES ('1025991659155292161', 'https://tiku.baidu.com/tikupc/singledetail/dbc3bf64783e0912a2162aef', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991659197235202', 'https://tiku.baidu.com/tikupc/singledetail/a24dcaaedd3383c4bb4cd22a', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991659214012417', 'https://tiku.baidu.com/tikupc/singledetail/623f3369a45177232f60a211', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991659214012418', 'https://tiku.baidu.com/tikupc/singledetail/babbf121dd36a32d73758101', '1025991597838761985', '0');
INSERT INTO `crawler_question` VALUES ('1025991659260149762', 'https://tiku.baidu.com/tikupc/singledetail/8f6fed06eff9aef8941e065d', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991659260149761', 'https://tiku.baidu.com/tikupc/singledetail/1cacaef8941ea76e58fa0450', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991659302092802', 'https://tiku.baidu.com/tikupc/singledetail/83209a89680203d8ce2f24c2', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991659318870017', 'https://tiku.baidu.com/tikupc/singledetail/60cd8bd63186bceb19e8bb0d', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991659318870018', 'https://tiku.baidu.com/tikupc/singledetail/cbdff61fb7360b4c2e3f642f', '1025991598035894274', '0');
INSERT INTO `crawler_question` VALUES ('1025991659318870020', 'https://tiku.baidu.com/tikupc/singledetail/da297375a417866fb84a8e01', '1025991597838761985', '0');
INSERT INTO `crawler_question` VALUES ('1025991659318870019', 'https://tiku.baidu.com/tikupc/singledetail/f14575232f60ddccda38a011', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991659356618755', 'https://tiku.baidu.com/tikupc/singledetail/cc288d9951e79b896802265b', '1025991548148842500', '0');
INSERT INTO `crawler_question` VALUES ('1025991659356618754', 'https://tiku.baidu.com/tikupc/singledetail/6d24be23482fb4daa58d4b7b', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991659419533314', 'https://tiku.baidu.com/tikupc/singledetail/8632cebff121dd36a32d8213', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991659419533313', 'https://tiku.baidu.com/tikupc/singledetail/7c17b968a98271fe910ef918', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991659436310529', 'https://tiku.baidu.com/tikupc/singledetail/b41df111f18583d04964592f', '1025991598035894274', '0');
INSERT INTO `crawler_question` VALUES ('1025991659436310530', 'https://tiku.baidu.com/tikupc/singledetail/17c45ef7ba0d4a7302763a2e', '1025991597838761985', '0');
INSERT INTO `crawler_question` VALUES ('1025991659436310531', 'https://tiku.baidu.com/tikupc/singledetail/53dcb9f3f90f76c661371a0c', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991659503419393', 'https://tiku.baidu.com/tikupc/singledetail/f8de9a6648d7c1c708a145bf', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991659511808001', 'https://tiku.baidu.com/tikupc/singledetail/36725b1810a6f524ccbf859d', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991659511808002', 'https://tiku.baidu.com/tikupc/singledetail/0918ce1755270722192ef71b', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991659511808003', 'https://tiku.baidu.com/tikupc/singledetail/bc8b69ec0975f46527d3e11b', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991659545362435', 'https://tiku.baidu.com/tikupc/singledetail/1bc9d5bbfd0a79563c1e720f', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991659545362434', 'https://tiku.baidu.com/tikupc/singledetail/9a5f3b3567ec102de2bd8906', '1025991598035894274', '0');
INSERT INTO `crawler_question` VALUES ('1025991659587305475', 'https://tiku.baidu.com/tikupc/singledetail/434c931ea76e58fafab003b1', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991659587305476', 'https://tiku.baidu.com/tikupc/singledetail/624f3369a45177232f60a261', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991659587305477', 'https://tiku.baidu.com/tikupc/singledetail/220e588102d276a200292e38', '1025991548475998209', '0');
INSERT INTO `crawler_question` VALUES ('1025991659587305474', 'https://tiku.baidu.com/tikupc/singledetail/a842185f312b3169a451a491', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991659641831426', 'https://tiku.baidu.com/tikupc/singledetail/9d4f2e3f5727a5e9856a6106', '1025991598035894274', '0');
INSERT INTO `crawler_question` VALUES ('1025991659666997250', 'https://tiku.baidu.com/tikupc/singledetail/1bce700abb68a98271fefa37', '1025991560916303874', '0');
INSERT INTO `crawler_question` VALUES ('1025991659700551681', 'https://tiku.baidu.com/tikupc/singledetail/d68df7335a8102d276a22fee', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991659725717506', 'https://tiku.baidu.com/tikupc/singledetail/3fb7717f5acfa1c7aa00ccfc', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991659755077635', 'https://tiku.baidu.com/tikupc/singledetail/881b6e85ec3a87c24028c413', '1025991537365286916', '0');
INSERT INTO `crawler_question` VALUES ('1025991659755077636', 'https://tiku.baidu.com/tikupc/singledetail/bc6aa18271fe910ef12df807', '1025991537558224898', '0');
INSERT INTO `crawler_question` VALUES ('1025991659755077634', 'https://tiku.baidu.com/tikupc/singledetail/9a5902768e9951e79b89272f', '1025991598035894274', '0');
INSERT INTO `crawler_question` VALUES ('1025991659797020673', 'https://tiku.baidu.com/tikupc/singledetail/bfe6f221dd36a32d7375815c', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991659872518146', 'https://tiku.baidu.com/tikupc/singledetail/16e2c184b9d528ea81c779ac', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991659872518147', 'https://tiku.baidu.com/tikupc/singledetail/75ee935f804d2b160b4ec0c3', '1025991629342179329', '0');
INSERT INTO `crawler_question` VALUES ('1025991659973181442', 'https://tiku.baidu.com/tikupc/singledetail/ed0d956648d7c1c708a1456c', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991659981570051', 'https://tiku.baidu.com/tikupc/singledetail/e3a225d3240c844769eaeec2', '1025991629140852738', '0');
INSERT INTO `crawler_question` VALUES ('1025991659981570049', 'https://tiku.baidu.com/tikupc/singledetail/be8a284ac850ad02de80412e', '1025991597595492353', '0');
INSERT INTO `crawler_question` VALUES ('1025991659981570050', 'https://tiku.baidu.com/tikupc/singledetail/b427f111f18583d049645915', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991660036096003', 'https://tiku.baidu.com/tikupc/singledetail/64f19e3143323968011c9202', '1025991598358855681', '0');
INSERT INTO `crawler_question` VALUES ('1025991660036096002', 'https://tiku.baidu.com/tikupc/singledetail/6f3c0fa1284ac850ad0242fe', '1025991561126019074', '0');
INSERT INTO `crawler_question` VALUES ('1025991660061261825', 'https://tiku.baidu.com/tikupc/singledetail/b9735ee2524de518964b7dac', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991660094816258', 'https://tiku.baidu.com/tikupc/singledetail/51d0360cba1aa8114431d900', '1025991597595492353', '0');
INSERT INTO `crawler_question` VALUES ('1025991660094816259', 'https://tiku.baidu.com/tikupc/singledetail/d5cbce2f0066f5335a812116', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991660153536513', 'https://tiku.baidu.com/tikupc/singledetail/e20f763231126edb6f1a1002', '1025991598358855681', '0');
INSERT INTO `crawler_question` VALUES ('1025991660161925121', 'https://tiku.baidu.com/tikupc/singledetail/b8335627a5e9856a56126009', '1025991517882744833', '0');
INSERT INTO `crawler_question` VALUES ('1025991660170313729', 'https://tiku.baidu.com/tikupc/singledetail/bfe5aeaad1f34693daef3e0e', '1025991561901965314', '0');
INSERT INTO `crawler_question` VALUES ('1025991660199673857', 'https://tiku.baidu.com/tikupc/singledetail/e2412af90242a8956bece469', '1025991597595492353', '0');
INSERT INTO `crawler_question` VALUES ('1025991660199673858', 'https://tiku.baidu.com/tikupc/singledetail/917be2bd960590c69ec37653', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991660208062466', 'https://tiku.baidu.com/tikupc/singledetail/e7d6102de2bd960590c6773f', '1025991629484785666', '0');
INSERT INTO `crawler_question` VALUES ('1025991660250005506', 'https://tiku.baidu.com/tikupc/singledetail/911de2bd960590c69ec37635', '1025991598358855681', '0');
INSERT INTO `crawler_question` VALUES ('1025991660250005507', 'https://tiku.baidu.com/tikupc/singledetail/766dddccda38376baf1fae08', '1025991561901965314', '0');
INSERT INTO `crawler_question` VALUES ('1025991660275171330', 'https://tiku.baidu.com/tikupc/singledetail/40c54a35eefdc8d376ee32e5', '1025991597595492353', '0');
INSERT INTO `crawler_question` VALUES ('1025991660275171331', 'https://tiku.baidu.com/tikupc/singledetail/616f6c175f0e7cd18425367b', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991660291948546', 'https://tiku.baidu.com/tikupc/singledetail/902633126edb6f1aff001f11', '1025991629484785666', '0');
INSERT INTO `crawler_question` VALUES ('1025991660363251713', 'https://tiku.baidu.com/tikupc/singledetail/5424ed630b1c59eef8c7b40c', '1025991598199472129', '0');
INSERT INTO `crawler_question` VALUES ('1025991660363251714', 'https://tiku.baidu.com/tikupc/singledetail/7cdd0975f46527d3240ce034', '1025991598358855681', '0');
INSERT INTO `crawler_question` VALUES ('1025991660363251715', 'https://tiku.baidu.com/tikupc/singledetail/c3c4657d27284b73f24250e8', '1025991597595492353', '0');
INSERT INTO `crawler_question` VALUES ('1025991660384223233', 'https://tiku.baidu.com/tikupc/singledetail/e2c99c6648d7c1c708a145a8', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991660371640321', 'https://tiku.baidu.com/tikupc/singledetail/1b46d5bbfd0a79563c1e7280', '1025991537122017282', '0');
INSERT INTO `crawler_question` VALUES ('1025991660409389057', 'https://tiku.baidu.com/tikupc/singledetail/416ab8d528ea81c758f578eb', '1025991629484785666', '0');
INSERT INTO `crawler_question` VALUES ('1025991660459720706', 'https://tiku.baidu.com/tikupc/singledetail/fa5fb84ae45c3b3567ec8b35', '1025991598199472129', '0');
INSERT INTO `crawler_question` VALUES ('1025991660459720705', 'https://tiku.baidu.com/tikupc/singledetail/1b264793daef5ef7ba0d3cd0', '1025991548618604545', '0');
INSERT INTO `crawler_question` VALUES ('1025991660468109313', 'https://tiku.baidu.com/tikupc/singledetail/d90b87c24028915f804dc234', '1025991598358855681', '0');
INSERT INTO `crawler_question` VALUES ('1025991660501663746', 'https://tiku.baidu.com/tikupc/singledetail/0469a717866fb84ae45c8d19', '1025991629484785666', '0');
INSERT INTO `crawler_question` VALUES ('1025991660501663745', 'https://tiku.baidu.com/tikupc/singledetail/08d27eeeaeaad1f346933f04', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991660551995395', 'https://tiku.baidu.com/tikupc/singledetail/6616a0c7aa00b52acfc7cadc', '1025991548618604545', '0');
INSERT INTO `crawler_question` VALUES ('1025991660551995394', 'https://tiku.baidu.com/tikupc/singledetail/fce7c1c708a1284ac8504335', '1025991598199472129', '0');
INSERT INTO `crawler_question` VALUES ('1025991660627492866', 'https://tiku.baidu.com/tikupc/singledetail/aa41fa0a79563c1ec5da71ff', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991660732350465', 'https://tiku.baidu.com/tikupc/singledetail/d5ebce2f0066f5335a812136', '1025991598199472129', '0');
INSERT INTO `crawler_question` VALUES ('1025991660732350466', 'https://tiku.baidu.com/tikupc/singledetail/09dba78da0116c175f0e4804', '1025991548618604545', '0');
INSERT INTO `crawler_question` VALUES ('1025991660786876417', 'https://tiku.baidu.com/tikupc/singledetail/d20c7b75a417866fb84a8e24', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991660828819458', 'https://tiku.baidu.com/tikupc/singledetail/9a4602768e9951e79b892730', '1025991598199472129', '0');
INSERT INTO `crawler_question` VALUES ('1025991660887539713', 'https://tiku.baidu.com/tikupc/singledetail/30f2834769eae009581becfb', '1025991549134503938', '0');
INSERT INTO `crawler_question` VALUES ('1025991660887539714', 'https://tiku.baidu.com/tikupc/singledetail/6cd4ae1ffc4ffe473368abba', '1025991631225421825', '0');
INSERT INTO `crawler_question` VALUES ('1025991661193723906', 'https://tiku.baidu.com/tikupc/singledetail/65fbb6360b4c2e3f572763e1', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991661265027074', 'https://tiku.baidu.com/tikupc/singledetail/b42aa98271fe910ef12df847', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991661323747330', 'https://tiku.baidu.com/tikupc/singledetail/1ddbd7bbfd0a79563c1e721d', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991661365690371', 'https://tiku.baidu.com/tikupc/singledetail/a0c58762caaedd3383c4d346', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991661365690370', 'https://tiku.baidu.com/tikupc/singledetail/ddb3abe9856a561252d36f91', '1025991598568570881', '0');
INSERT INTO `crawler_question` VALUES ('1025991661462159361', 'https://tiku.baidu.com/tikupc/singledetail/5c9e51e79b89680203d82502', '1025991598954446849', '0');
INSERT INTO `crawler_question` VALUES ('1025991661462159362', 'https://tiku.baidu.com/tikupc/singledetail/f1d71be8b8f67c1cfad6b839', '1025991523779936258', '0');
INSERT INTO `crawler_question` VALUES ('1025991661504102401', 'https://tiku.baidu.com/tikupc/singledetail/b9345727a5e9856a5612600e', '1025991599986245634', '0');
INSERT INTO `crawler_question` VALUES ('1025991661504102402', 'https://tiku.baidu.com/tikupc/singledetail/0aafe1f9aef8941ea76e05ac', '1025991598568570881', '0');
INSERT INTO `crawler_question` VALUES ('1025991661504102403', 'https://tiku.baidu.com/tikupc/singledetail/fa7083c4bb4cf7ec4afed046', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991661596377090', 'https://tiku.baidu.com/tikupc/singledetail/111f0b4e767f5acfa1c7cd0c', '1025991599277408259', '0');
INSERT INTO `crawler_question` VALUES ('1025991661613154305', 'https://tiku.baidu.com/tikupc/singledetail/f3d019e8b8f67c1cfad6b83e', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991661613154306', 'https://tiku.baidu.com/tikupc/singledetail/e143f242336c1eb91a375d35', '1025991598954446849', '0');
INSERT INTO `crawler_question` VALUES ('1025991661680263170', 'https://tiku.baidu.com/tikupc/singledetail/9a503b3567ec102de2bd8909', '1025991599986245634', '0');
INSERT INTO `crawler_question` VALUES ('1025991661684457473', 'https://tiku.baidu.com/tikupc/singledetail/19310066f5335a8102d2201b', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991661684457475', 'https://tiku.baidu.com/tikupc/singledetail/358384868762caaedd33d40e', '1025991599277408259', '0');
INSERT INTO `crawler_question` VALUES ('1025991661684457474', 'https://tiku.baidu.com/tikupc/singledetail/57330722192e45361066f511', '1025991562027794434', '0');
INSERT INTO `crawler_question` VALUES ('1025991661722206210', 'https://tiku.baidu.com/tikupc/singledetail/0428192e453610661ed9f40f', '1025991598954446849', '0');
INSERT INTO `crawler_question` VALUES ('1025991661730594818', 'https://tiku.baidu.com/tikupc/singledetail/286d31b765ce050876321311', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991661776732161', 'https://tiku.baidu.com/tikupc/singledetail/60b1960590c69ec3d5bb7509', '1025991599986245634', '0');
INSERT INTO `crawler_question` VALUES ('1025991661768343553', 'https://tiku.baidu.com/tikupc/singledetail/ba9ff121dd36a32d73758125', '1025991562405281794', '0');
INSERT INTO `crawler_question` VALUES ('1025991661806092289', 'https://tiku.baidu.com/tikupc/singledetail/b8e284254b35eefdc8d33336', '1025991599277408259', '0');
INSERT INTO `crawler_question` VALUES ('1025991661852229636', 'https://tiku.baidu.com/tikupc/singledetail/51fa360cba1aa8114431d92a', '1025991631837790210', '0');
INSERT INTO `crawler_question` VALUES ('1025991661852229634', 'https://tiku.baidu.com/tikupc/singledetail/fca5dd88d0d233d4b14e6934', '1025991598954446849', '0');
INSERT INTO `crawler_question` VALUES ('1025991661852229635', 'https://tiku.baidu.com/tikupc/singledetail/bd0103d8ce2f0066f5332206', '1025991600133046273', '0');
INSERT INTO `crawler_question` VALUES ('1025991661852229637', 'https://tiku.baidu.com/tikupc/singledetail/d34a8e9951e79b8968022639', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991661906755587', 'https://tiku.baidu.com/tikupc/singledetail/9119e2bd960590c69ec37631', '1025991599986245634', '0');
INSERT INTO `crawler_question` VALUES ('1025991661906755586', 'https://tiku.baidu.com/tikupc/singledetail/1f5d561252d380eb62946d32', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991661906755588', 'https://tiku.baidu.com/tikupc/singledetail/543716fc700abb68a982fb30', '1025991599277408259', '0');
INSERT INTO `crawler_question` VALUES ('1025991661952892930', 'https://tiku.baidu.com/tikupc/singledetail/4d54312b3169a4517723a30e', '1025991598954446849', '0');
INSERT INTO `crawler_question` VALUES ('1025991661952892931', 'https://tiku.baidu.com/tikupc/singledetail/60ea8bd63186bceb19e8bb2a', '1025991631837790210', '0');
INSERT INTO `crawler_question` VALUES ('1025991661973864451', 'https://tiku.baidu.com/tikupc/singledetail/285831b765ce050876321324', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991661952892929', 'https://tiku.baidu.com/tikupc/singledetail/83c00508763231126edb110b', '1025991599852027905', '0');
INSERT INTO `crawler_question` VALUES ('1025991661973864450', 'https://tiku.baidu.com/tikupc/singledetail/5e272279168884868762d63b', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991661965475842', 'https://tiku.baidu.com/tikupc/singledetail/d4b465ce0508763231121206', '1025991600133046273', '0');
INSERT INTO `crawler_question` VALUES ('1025991662007418881', 'https://tiku.baidu.com/tikupc/singledetail/47636bd97f1922791688e87d', '1025991632311746561', '0');
INSERT INTO `crawler_question` VALUES ('1025991662007418882', 'https://tiku.baidu.com/tikupc/singledetail/984a69eae009581b6bd9eb08', '1025991599277408259', '0');
INSERT INTO `crawler_question` VALUES ('1025991662061944833', 'https://tiku.baidu.com/tikupc/singledetail/86f86137ee06eff9aef8073b', '1025991631837790210', '0');
INSERT INTO `crawler_question` VALUES ('1025991662061944834', 'https://tiku.baidu.com/tikupc/singledetail/d49665ce0508763231121224', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991662061944835', 'https://tiku.baidu.com/tikupc/singledetail/3dc1240c844769eae009ed17', '1025991599852027905', '0');
INSERT INTO `crawler_question` VALUES ('1025991662053556226', 'https://tiku.baidu.com/tikupc/singledetail/cee780eb6294dd88d0d26b31', '1025991599986245634', '0');
INSERT INTO `crawler_question` VALUES ('1025991662061944837', 'https://tiku.baidu.com/tikupc/singledetail/fa2983c4bb4cf7ec4afed01f', '1025991561696444419', '0');
INSERT INTO `crawler_question` VALUES ('1025991662061944836', 'https://tiku.baidu.com/tikupc/singledetail/ee3e580216fc700abb68fc01', '1025991600133046273', '0');
INSERT INTO `crawler_question` VALUES ('1025991662129053698', 'https://tiku.baidu.com/tikupc/singledetail/1ac54693daef5ef7ba0d3c33', '1025991632492101633', '0');
INSERT INTO `crawler_question` VALUES ('1025991662129053697', 'https://tiku.baidu.com/tikupc/singledetail/a8384728915f804d2b16c1ff', '1025991632311746561', '0');
INSERT INTO `crawler_question` VALUES ('1025991662061944838', 'https://tiku.baidu.com/tikupc/singledetail/d48065ce0508763231121232', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991662175191042', 'https://tiku.baidu.com/tikupc/singledetail/1bde700abb68a98271fefa27', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991662175191044', 'https://tiku.baidu.com/tikupc/singledetail/680dbe1e650e52ea55189848', '1025991631837790210', '0');
INSERT INTO `crawler_question` VALUES ('1025991662175191043', 'https://tiku.baidu.com/tikupc/singledetail/83d7203f5727a5e9856a619e', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991662196162561', 'https://tiku.baidu.com/tikupc/singledetail/80aa02d276a20029bd642d2e', '1025991600133046273', '0');
INSERT INTO `crawler_question` VALUES ('1025991662187773953', 'https://tiku.baidu.com/tikupc/singledetail/8e6fa26925c52cc58bd6be17', '1025991599852027905', '0');
INSERT INTO `crawler_question` VALUES ('1025991662212939778', 'https://tiku.baidu.com/tikupc/singledetail/7e02bb68a98271fe910ef90d', '1025991599105441793', '0');
INSERT INTO `crawler_question` VALUES ('1025991662254882818', 'https://tiku.baidu.com/tikupc/singledetail/541316fc700abb68a982fb14', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991662254882817', 'https://tiku.baidu.com/tikupc/singledetail/c69f3186bceb19e8b8f6ba4c', '1025991632492101633', '0');
INSERT INTO `crawler_question` VALUES ('1025991662271660034', 'https://tiku.baidu.com/tikupc/singledetail/29788a4769eae009581bec71', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991662271660035', 'https://tiku.baidu.com/tikupc/singledetail/832cf12d2af90242a895e527', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991662254882819', 'https://tiku.baidu.com/tikupc/singledetail/160b1ed9ad51f01dc281f168', '1025991631837790210', '0');
INSERT INTO `crawler_question` VALUES ('1025991662301020161', 'https://tiku.baidu.com/tikupc/singledetail/8eeb89eb172ded630b1cb629', '1025991600133046273', '0');
INSERT INTO `crawler_question` VALUES ('1025991662301020162', 'https://tiku.baidu.com/tikupc/singledetail/82db9b89680203d8ce2f2439', '1025991599852027905', '0');
INSERT INTO `crawler_question` VALUES ('1025991662309408770', 'https://tiku.baidu.com/tikupc/singledetail/284931b765ce050876321335', '1025991599105441793', '0');
INSERT INTO `crawler_question` VALUES ('1025991662359740418', 'https://tiku.baidu.com/tikupc/singledetail/a543a32d7375a417866f8f70', '1025991632492101633', '0');
INSERT INTO `crawler_question` VALUES ('1025991662359740419', 'https://tiku.baidu.com/tikupc/singledetail/e23c2af90242a8956bece414', '1025991562673717250', '0');
INSERT INTO `crawler_question` VALUES ('1025991662368129026', 'https://tiku.baidu.com/tikupc/singledetail/59f7918fcc22bcd126ff0c18', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991662376517634', 'https://tiku.baidu.com/tikupc/singledetail/bfe55fbfc77da26925c5b027', '1025991493518032897', '0');
INSERT INTO `crawler_question` VALUES ('1025991662397489153', 'https://tiku.baidu.com/tikupc/singledetail/f639b4daa58da0116c174913', '1025991599852027905', '0');
INSERT INTO `crawler_question` VALUES ('1025991662422654977', 'https://tiku.baidu.com/tikupc/singledetail/11270b4e767f5acfa1c7cd34', '1025991599105441793', '0');
INSERT INTO `crawler_question` VALUES ('1025991662452015105', 'https://tiku.baidu.com/tikupc/singledetail/aa57aaea998fcc22bcd10d70', '1025991632492101633', '0');
INSERT INTO `crawler_question` VALUES ('1025991662460403713', 'https://tiku.baidu.com/tikupc/singledetail/c2c380c24028915f804dc2fc', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991662510735362', 'https://tiku.baidu.com/tikupc/singledetail/307f767f5acfa1c7aa00cc34', '1025991599105441793', '0');
INSERT INTO `crawler_question` VALUES ('1025991662552678403', 'https://tiku.baidu.com/tikupc/singledetail/86b16137ee06eff9aef80772', '1025991632492101633', '0');
INSERT INTO `crawler_question` VALUES ('1025991662552678402', 'https://tiku.baidu.com/tikupc/singledetail/a6b463ec0975f46527d3e124', '1025991513537445892', '0');
INSERT INTO `crawler_question` VALUES ('1025991662594621442', 'https://tiku.baidu.com/tikupc/singledetail/bff55fbfc77da26925c5b037', '1025991599105441793', '0');
INSERT INTO `crawler_question` VALUES ('1025991662674313217', 'https://tiku.baidu.com/tikupc/singledetail/f6521711cc7931b765ce152e', '1025991632672456706', '0');
INSERT INTO `crawler_question` VALUES ('1025991662783365122', 'https://tiku.baidu.com/tikupc/singledetail/7666ddccda38376baf1fae03', '1025991600393093121', '0');
INSERT INTO `crawler_question` VALUES ('1025991662800142338', 'https://tiku.baidu.com/tikupc/singledetail/14cf9ec3d5bbfd0a7956730c', '1025991632672456706', '0');
INSERT INTO `crawler_question` VALUES ('1025991662892417026', 'https://tiku.baidu.com/tikupc/singledetail/b41af111f18583d049645928', '1025991600393093121', '0');
INSERT INTO `crawler_question` VALUES ('1025991662967914497', 'https://tiku.baidu.com/tikupc/singledetail/9d307fd5360cba1aa811da44', '1025991632672456706', '0');
INSERT INTO `crawler_question` VALUES ('1025991663043411969', 'https://tiku.baidu.com/tikupc/singledetail/beb3284ac850ad02de804117', '1025991632806674434', '0');
INSERT INTO `crawler_question` VALUES ('1025991663085355010', 'https://tiku.baidu.com/tikupc/singledetail/546eed630b1c59eef8c7b446', '1025991600518922241', '0');
INSERT INTO `crawler_question` VALUES ('1025991663093743617', 'https://tiku.baidu.com/tikupc/singledetail/6fe8d15abe23482fb4da4c35', '1025991600393093121', '0');
INSERT INTO `crawler_question` VALUES ('1025991663110520834', 'https://tiku.baidu.com/tikupc/singledetail/985969eae009581b6bd9eb1b', '1025991632999612418', '0');
INSERT INTO `crawler_question` VALUES ('1025991663110520833', 'https://tiku.baidu.com/tikupc/singledetail/990f4431b90d6c85ec3ac61b', '1025991632672456706', '0');
INSERT INTO `crawler_question` VALUES ('1025991663160852482', 'https://tiku.baidu.com/tikupc/singledetail/20c8551810a6f524ccbf8527', '1025991632806674434', '0');
INSERT INTO `crawler_question` VALUES ('1025991663236349955', 'https://tiku.baidu.com/tikupc/singledetail/fcc9c1c708a1284ac850431b', '1025991632672456706', '0');
INSERT INTO `crawler_question` VALUES ('1025991663236349956', 'https://tiku.baidu.com/tikupc/singledetail/415f4b35eefdc8d376ee327f', '1025991600518922241', '0');
INSERT INTO `crawler_question` VALUES ('1025991663236349954', 'https://tiku.baidu.com/tikupc/singledetail/cbd5f61fb7360b4c2e3f6425', '1025991632999612418', '0');
INSERT INTO `crawler_question` VALUES ('1025991663253127170', 'https://tiku.baidu.com/tikupc/singledetail/62243369a45177232f60a20a', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991663253127169', 'https://tiku.baidu.com/tikupc/singledetail/4a4e5acfa1c7aa00b52acb34', '1025991600393093121', '0');
INSERT INTO `crawler_question` VALUES ('1025991663345401857', 'https://tiku.baidu.com/tikupc/singledetail/cbc1172ded630b1c59eeb52f', '1025991600837689345', '0');
INSERT INTO `crawler_question` VALUES ('1025991663391539202', 'https://tiku.baidu.com/tikupc/singledetail/6f91d15abe23482fb4da4c4c', '1025991632999612418', '0');
INSERT INTO `crawler_question` VALUES ('1025991663391539203', 'https://tiku.baidu.com/tikupc/singledetail/7fdcbceb19e8b8f67c1cb95f', '1025991600518922241', '0');
INSERT INTO `crawler_question` VALUES ('1025991663391539205', 'https://tiku.baidu.com/tikupc/singledetail/fea43d1ec5da50e2524d7ff7', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991663391539204', 'https://tiku.baidu.com/tikupc/singledetail/403910661ed9ad51f01df20a', '1025991600393093121', '0');
INSERT INTO `crawler_question` VALUES ('1025991663446065154', 'https://tiku.baidu.com/tikupc/singledetail/32f249649b6648d7c1c74627', '1025991600837689345', '0');
INSERT INTO `crawler_question` VALUES ('1025991663475425283', 'https://tiku.baidu.com/tikupc/singledetail/8781da38376baf1ffc4fad48', '1025991632999612418', '0');
INSERT INTO `crawler_question` VALUES ('1025991663475425282', 'https://tiku.baidu.com/tikupc/singledetail/d014e87101f69e3143329416', '1025991600686694401', '0');
INSERT INTO `crawler_question` VALUES ('1025991663483813889', 'https://tiku.baidu.com/tikupc/singledetail/ad805e0e7cd184254b353592', '1025991600518922241', '0');
INSERT INTO `crawler_question` VALUES ('1025991663483813890', 'https://tiku.baidu.com/tikupc/singledetail/fc345a1b6bd97f192279e938', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991663521562626', 'https://tiku.baidu.com/tikupc/singledetail/98ab1fb91a37f111f1855bc2', '1025991600837689345', '0');
INSERT INTO `crawler_question` VALUES ('1025991663559311362', 'https://tiku.baidu.com/tikupc/singledetail/2388b2d126fff705cc170aaf', '1025991632999612418', '0');
INSERT INTO `crawler_question` VALUES ('1025991663559311361', 'https://tiku.baidu.com/tikupc/singledetail/b9512b160b4e767f5acfce19', '1025991600686694401', '0');
INSERT INTO `crawler_question` VALUES ('1025991663559311363', 'https://tiku.baidu.com/tikupc/singledetail/75f5b80d6c85ec3a87c2c5c1', '1025991600518922241', '0');
INSERT INTO `crawler_question` VALUES ('1025991663584477187', 'https://tiku.baidu.com/tikupc/singledetail/5183360cba1aa8114431d953', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991663584477186', 'https://tiku.baidu.com/tikupc/singledetail/5313340cba1aa8114431d9c3', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991663639003139', 'https://tiku.baidu.com/tikupc/singledetail/02ee492fb4daa58da0114ac8', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991663639003138', 'https://tiku.baidu.com/tikupc/singledetail/761bb90d6c85ec3a87c2c52f', '1025991600837689345', '0');
INSERT INTO `crawler_question` VALUES ('1025991663685140481', 'https://tiku.baidu.com/tikupc/singledetail/8aecdaef5ef7ba0d4a733b7a', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991663685140483', 'https://tiku.baidu.com/tikupc/singledetail/1bbb700abb68a98271fefa42', '1025991600686694401', '0');
INSERT INTO `crawler_question` VALUES ('1025991663685140485', 'https://tiku.baidu.com/tikupc/singledetail/64aed4d8d15abe23482f4d2b', '1025991633637146625', '0');
INSERT INTO `crawler_question` VALUES ('1025991663685140484', 'https://tiku.baidu.com/tikupc/singledetail/261e10a6f524ccbff1218403', '1025991633196744708', '0');
INSERT INTO `crawler_question` VALUES ('1025991663685140482', 'https://tiku.baidu.com/tikupc/singledetail/bd115dbfc77da26925c5b0d3', '1025991539676348420', '0');
INSERT INTO `crawler_question` VALUES ('1025991663827746819', 'https://tiku.baidu.com/tikupc/singledetail/105039b765ce05087632132c', '1025991600837689345', '0');
INSERT INTO `crawler_question` VALUES ('1025991663827746818', 'https://tiku.baidu.com/tikupc/singledetail/52a059fafab069dc502201cb', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991663836135426', 'https://tiku.baidu.com/tikupc/singledetail/cf29a5e9856a561252d36f0b', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991663894855681', 'https://tiku.baidu.com/tikupc/singledetail/b9b381c758f5f61fb736665c', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991663911632898', 'https://tiku.baidu.com/tikupc/singledetail/a549f01dc281e53a5802ff1d', '1025991633637146625', '0');
INSERT INTO `crawler_question` VALUES ('1025991663911632897', 'https://tiku.baidu.com/tikupc/singledetail/92fab14e852458fb770b562b', '1025991633196744708', '0');
INSERT INTO `crawler_question` VALUES ('1025991663911632899', 'https://tiku.baidu.com/tikupc/singledetail/0b93a58da0116c175f0e484c', '1025991601194205186', '0');
INSERT INTO `crawler_question` VALUES ('1025991663920021506', 'https://tiku.baidu.com/tikupc/singledetail/772f915f804d2b160b4ec002', '1025991601814962182', '0');
INSERT INTO `crawler_question` VALUES ('1025991663940993026', 'https://tiku.baidu.com/tikupc/singledetail/0d4b68dc5022aaea998f0ffe', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991663966158849', 'https://tiku.baidu.com/tikupc/singledetail/be99284ac850ad02de80413d', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991663966158850', 'https://tiku.baidu.com/tikupc/singledetail/1380bed5b9f3f90f76c61b85', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991664016490499', 'https://tiku.baidu.com/tikupc/singledetail/6335783e0912a21614792954', '1025991601194205186', '0');
INSERT INTO `crawler_question` VALUES ('1025991664016490498', 'https://tiku.baidu.com/tikupc/singledetail/6c80d25abe23482fb4da4c5d', '1025991633637146625', '0');
INSERT INTO `crawler_question` VALUES ('1025991664016490500', 'https://tiku.baidu.com/tikupc/singledetail/14c99ec3d5bbfd0a7956730a', '1025991633196744708', '0');
INSERT INTO `crawler_question` VALUES ('1025991664016490501', 'https://tiku.baidu.com/tikupc/singledetail/4ff450e2524de518964b7d2b', '1025991601814962182', '0');
INSERT INTO `crawler_question` VALUES ('1025991664029073409', 'https://tiku.baidu.com/tikupc/singledetail/17d75ef7ba0d4a7302763a3d', '1025991602003705857', '0');
INSERT INTO `crawler_question` VALUES ('1025991664062627842', 'https://tiku.baidu.com/tikupc/singledetail/1e8af56527d3240c8447effa', '1025991563516772353', '0');
INSERT INTO `crawler_question` VALUES ('1025991664062627843', 'https://tiku.baidu.com/tikupc/singledetail/343802020740be1e650e9a3c', '1025991562875043841', '0');
INSERT INTO `crawler_question` VALUES ('1025991664062627844', 'https://tiku.baidu.com/tikupc/singledetail/4e9e59eef8c75fbfc77db287', '1025991504666492931', '0');
INSERT INTO `crawler_question` VALUES ('1025991664150708226', 'https://tiku.baidu.com/tikupc/singledetail/ff36bb4ae45c3b3567ec8b5c', '1025991633637146625', '0');
INSERT INTO `crawler_question` VALUES ('1025991664150708229', 'https://tiku.baidu.com/tikupc/singledetail/518d360cba1aa8114431d95d', '1025991601194205186', '0');
INSERT INTO `crawler_question` VALUES ('1025991664150708228', 'https://tiku.baidu.com/tikupc/singledetail/7e93a35177232f60ddcca1ff', '1025991633196744708', '0');
INSERT INTO `crawler_question` VALUES ('1025991664150708230', 'https://tiku.baidu.com/tikupc/singledetail/bf8b5fbfc77da26925c5b049', '1025991602003705857', '0');
INSERT INTO `crawler_question` VALUES ('1025991664150708227', 'https://tiku.baidu.com/tikupc/singledetail/162076c66137ee06eff9182a', '1025991601814962182', '0');
INSERT INTO `crawler_question` VALUES ('1025991664150708231', 'https://tiku.baidu.com/tikupc/singledetail/63033269a45177232f60a22d', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991664150708232', 'https://tiku.baidu.com/tikupc/singledetail/036a482fb4daa58da0114a4c', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991664356229121', 'https://tiku.baidu.com/tikupc/singledetail/6354783e0912a21614792935', '1025991601814962182', '0');
INSERT INTO `crawler_question` VALUES ('1025991664356229122', 'https://tiku.baidu.com/tikupc/singledetail/8f26ed06eff9aef8941e0614', '1025991633637146625', '0');
INSERT INTO `crawler_question` VALUES ('1025991664364617731', 'https://tiku.baidu.com/tikupc/singledetail/602e960590c69ec3d5bb7596', '1025991601194205186', '0');
INSERT INTO `crawler_question` VALUES ('1025991664364617730', 'https://tiku.baidu.com/tikupc/singledetail/441067ec102de2bd96058820', '1025991602003705857', '0');
INSERT INTO `crawler_question` VALUES ('1025991664398172161', 'https://tiku.baidu.com/tikupc/singledetail/9f237fd184254b35eefd3428', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991664398172162', 'https://tiku.baidu.com/tikupc/singledetail/f433cc7931b765ce05081427', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991664473669634', 'https://tiku.baidu.com/tikupc/singledetail/64453169a45177232f60a26b', '1025991601194205186', '0');
INSERT INTO `crawler_question` VALUES ('1025991664473669633', 'https://tiku.baidu.com/tikupc/singledetail/4e6959eef8c75fbfc77db270', '1025991602003705857', '0');
INSERT INTO `crawler_question` VALUES ('1025991664503029761', 'https://tiku.baidu.com/tikupc/singledetail/8d07eefdc8d376eeaeaa3137', '1025991601814962182', '0');
INSERT INTO `crawler_question` VALUES ('1025991664544972802', 'https://tiku.baidu.com/tikupc/singledetail/6098960590c69ec3d5bb7520', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991664544972803', 'https://tiku.baidu.com/tikupc/singledetail/0f25c41755270722192ef724', '1025991538485166083', '0');
INSERT INTO `crawler_question` VALUES ('1025991664544972801', 'https://tiku.baidu.com/tikupc/singledetail/3f8d844769eae009581bec84', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991664591110145', 'https://tiku.baidu.com/tikupc/singledetail/cd5855270722192e4536f64a', '1025991602003705857', '0');
INSERT INTO `crawler_question` VALUES ('1025991664645636097', 'https://tiku.baidu.com/tikupc/singledetail/429d26fff705cc1755270949', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991664645636098', 'https://tiku.baidu.com/tikupc/singledetail/206e551810a6f524ccbf8581', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991664742105091', 'https://tiku.baidu.com/tikupc/singledetail/e8107d1cfad6195f312ba6e3', '1025991633817501701', '0');
INSERT INTO `crawler_question` VALUES ('1025991664742105089', 'https://tiku.baidu.com/tikupc/singledetail/197cad51f01dc281e53af0a0', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991664742105090', 'https://tiku.baidu.com/tikupc/singledetail/542416fc700abb68a982fb23', '1025991518407032834', '0');
INSERT INTO `crawler_question` VALUES ('1025991664876322819', 'https://tiku.baidu.com/tikupc/singledetail/33bd866a561252d380eb6e51', '1025991633817501701', '0');
INSERT INTO `crawler_question` VALUES ('1025991664876322818', 'https://tiku.baidu.com/tikupc/singledetail/05b6182e453610661ed9f491', '1025991563328028674', '0');
INSERT INTO `crawler_question` VALUES ('1025991664918265857', 'https://tiku.baidu.com/tikupc/singledetail/8fe94a73f242336c1eb95ec4', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991664935043074', 'https://tiku.baidu.com/tikupc/singledetail/97cfa200b52acfc789ebc90d', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991664993763330', 'https://tiku.baidu.com/tikupc/singledetail/95c5b90d4a7302768e993937', '1025991633817501701', '0');
INSERT INTO `crawler_question` VALUES ('1025991665018929153', 'https://tiku.baidu.com/tikupc/singledetail/6733d0f34693daef5ef73d9c', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991665018929154', 'https://tiku.baidu.com/tikupc/singledetail/8321f12d2af90242a895e52a', '1025991601542332418', '0');
INSERT INTO `crawler_question` VALUES ('1025991665048289283', 'https://tiku.baidu.com/tikupc/singledetail/9a7cc2aedd3383c4bb4cd21b', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991665048289282', 'https://tiku.baidu.com/tikupc/singledetail/b533c5da50e2524de5187e28', '1025991634417287170', '0');
INSERT INTO `crawler_question` VALUES ('1025991665102815234', 'https://tiku.baidu.com/tikupc/singledetail/6872be1e650e52ea55189837', '1025991601542332418', '0');
INSERT INTO `crawler_question` VALUES ('1025991665102815233', 'https://tiku.baidu.com/tikupc/singledetail/5e4782d049649b6648d747c7', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991665148952579', 'https://tiku.baidu.com/tikupc/singledetail/51e2360cba1aa8114431d932', '1025991634073354244', '0');
INSERT INTO `crawler_question` VALUES ('1025991665148952577', 'https://tiku.baidu.com/tikupc/singledetail/599b8bd049649b6648d7471b', '1025991563965562883', '0');
INSERT INTO `crawler_question` VALUES ('1025991665148952578', 'https://tiku.baidu.com/tikupc/singledetail/7cc20975f46527d3240ce02b', '1025991634417287170', '0');
INSERT INTO `crawler_question` VALUES ('1025991665203478531', 'https://tiku.baidu.com/tikupc/singledetail/fe07581b6bd97f192279e90b', '1025991601542332418', '0');
INSERT INTO `crawler_question` VALUES ('1025991665203478529', 'https://tiku.baidu.com/tikupc/singledetail/341102020740be1e650e9a15', '1025991602234392577', '0');
INSERT INTO `crawler_question` VALUES ('1025991665203478530', 'https://tiku.baidu.com/tikupc/singledetail/16285ff7ba0d4a7302763ac2', '1025991563202199554', '0');
INSERT INTO `crawler_question` VALUES ('1025991665245421570', 'https://tiku.baidu.com/tikupc/singledetail/1cd7aef8941ea76e58fa042b', '1025991634417287170', '0');
INSERT INTO `crawler_question` VALUES ('1025991665245421571', 'https://tiku.baidu.com/tikupc/singledetail/7657ddccda38376baf1fae32', '1025991634073354244', '0');
INSERT INTO `crawler_question` VALUES ('1025991665304141826', 'https://tiku.baidu.com/tikupc/singledetail/53ecb9f3f90f76c661371a3c', '1025991602234392577', '0');
INSERT INTO `crawler_question` VALUES ('1025991665304141827', 'https://tiku.baidu.com/tikupc/singledetail/17d95ef7ba0d4a7302763a33', '1025991601542332418', '0');
INSERT INTO `crawler_question` VALUES ('1025991665362862081', 'https://tiku.baidu.com/tikupc/singledetail/515658fafab069dc5022013d', '1025991634073354244', '0');
INSERT INTO `crawler_question` VALUES ('1025991665362862082', 'https://tiku.baidu.com/tikupc/singledetail/9f481eb91a37f111f1855b21', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991665467719682', 'https://tiku.baidu.com/tikupc/singledetail/de01e518964bcf84b9d57b49', '1025991602234392577', '0');
INSERT INTO `crawler_question` VALUES ('1025991665534828546', 'https://tiku.baidu.com/tikupc/singledetail/b413f111f18583d049645921', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991665534828545', 'https://tiku.baidu.com/tikupc/singledetail/620eb7360b4c2e3f57276314', '1025991634073354244', '0');
INSERT INTO `crawler_question` VALUES ('1025991665593548802', 'https://tiku.baidu.com/tikupc/singledetail/65be3069a45177232f60a290', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991665627103233', 'https://tiku.baidu.com/tikupc/singledetail/aac6f11dc281e53a5802ff92', '1025991602234392577', '0');
INSERT INTO `crawler_question` VALUES ('1025991665643880450', 'https://tiku.baidu.com/tikupc/singledetail/32f449649b6648d7c1c74621', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991665702600705', 'https://tiku.baidu.com/tikupc/singledetail/7bb578563c1ec5da50e270ba', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991665702600706', 'https://tiku.baidu.com/tikupc/singledetail/9c636285ec3a87c24028c46b', '1025991602234392577', '0');
INSERT INTO `crawler_question` VALUES ('1025991665748738049', 'https://tiku.baidu.com/tikupc/singledetail/929fb14e852458fb770b564e', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991665828429826', 'https://tiku.baidu.com/tikupc/singledetail/77a6dcccda38376baf1faec3', '1025991564187860995', '0');
INSERT INTO `crawler_question` VALUES ('1025991665866178561', 'https://tiku.baidu.com/tikupc/singledetail/d49365ce0508763231121221', '1025991505236918275', '0');
INSERT INTO `crawler_question` VALUES ('1025991665916510210', 'https://tiku.baidu.com/tikupc/singledetail/05fe182e453610661ed9f4d9', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991665954258946', 'https://tiku.baidu.com/tikupc/singledetail/29c428ea81c758f5f61f6714', '1025991551739166721', '0');
INSERT INTO `crawler_question` VALUES ('1025991665962647553', 'https://tiku.baidu.com/tikupc/singledetail/b637f311f18583d049645905', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991666021367809', 'https://tiku.baidu.com/tikupc/singledetail/7efd930ef12d2af90242e606', '1025991504515497985', '0');
INSERT INTO `crawler_question` VALUES ('1025991666063310849', 'https://tiku.baidu.com/tikupc/singledetail/6899964bcf84b9d528ea7a84', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991666080088065', 'https://tiku.baidu.com/tikupc/singledetail/638fce22bcd126fff7050b05', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991666080088066', 'https://tiku.baidu.com/tikupc/singledetail/f2a276232f60ddccda38a0f6', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991666105253889', 'https://tiku.baidu.com/tikupc/singledetail/029b69dc5022aaea998f0f2e', '1025991635558137857', '0');
INSERT INTO `crawler_question` VALUES ('1025991666134614017', 'https://tiku.baidu.com/tikupc/singledetail/7617b90d6c85ec3a87c2c523', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991666163974146', 'https://tiku.baidu.com/tikupc/singledetail/428e26fff705cc175527095a', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991666205917186', 'https://tiku.baidu.com/tikupc/singledetail/efe7590216fc700abb68fcd8', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991666205917187', 'https://tiku.baidu.com/tikupc/singledetail/8cafd8ef5ef7ba0d4a733b39', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991666214305794', 'https://tiku.baidu.com/tikupc/singledetail/ec8fdd3383c4bb4cf7ecd124', '1025991635558137857', '0');
INSERT INTO `crawler_question` VALUES ('1025991666252054530', 'https://tiku.baidu.com/tikupc/singledetail/f37777232f60ddccda38a023', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991666252054532', 'https://tiku.baidu.com/tikupc/singledetail/42e2d0d233d4b14e8524686f', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991666252054531', 'https://tiku.baidu.com/tikupc/singledetail/1bd1d5bbfd0a79563c1e7217', '1025991604285407236', '0');
INSERT INTO `crawler_question` VALUES ('1025991666306580482', 'https://tiku.baidu.com/tikupc/singledetail/16315ff7ba0d4a7302763adb', '1025991564380798978', '0');
INSERT INTO `crawler_question` VALUES ('1025991666310774786', 'https://tiku.baidu.com/tikupc/singledetail/df7a85c24028915f804dc245', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991666310774787', 'https://tiku.baidu.com/tikupc/singledetail/6d1dbe23482fb4daa58d4b42', '1025991635558137857', '0');
INSERT INTO `crawler_question` VALUES ('1025991666415632385', 'https://tiku.baidu.com/tikupc/singledetail/de00e518964bcf84b9d57b48', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991666453381121', 'https://tiku.baidu.com/tikupc/singledetail/3cfa856a561252d380eb6e16', '1025991604285407236', '0');
INSERT INTO `crawler_question` VALUES ('1025991666453381122', 'https://tiku.baidu.com/tikupc/singledetail/1c6aeff9aef8941ea76e0569', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991666453381123', 'https://tiku.baidu.com/tikupc/singledetail/83ec0508763231126edb1127', '1025991635558137857', '0');
INSERT INTO `crawler_question` VALUES ('1025991666453381124', 'https://tiku.baidu.com/tikupc/singledetail/ab961b5f312b3169a451a445', '1025991531749113857', '0');
INSERT INTO `crawler_question` VALUES ('1025991666482741250', 'https://tiku.baidu.com/tikupc/singledetail/53c5b9f3f90f76c661371a15', '1025991564531793924', '0');
INSERT INTO `crawler_question` VALUES ('1025991666545655809', 'https://tiku.baidu.com/tikupc/singledetail/cd63b307e87101f69e319523', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991666545655810', 'https://tiku.baidu.com/tikupc/singledetail/c947a6c30c22590102029d42', '1025991604285407236', '0');
INSERT INTO `crawler_question` VALUES ('1025991666554044418', 'https://tiku.baidu.com/tikupc/singledetail/982a69eae009581b6bd9eb68', '1025991564804423686', '0');
INSERT INTO `crawler_question` VALUES ('1025991666554044417', 'https://tiku.baidu.com/tikupc/singledetail/1302bed5b9f3f90f76c61b07', '1025991635960791041', '0');
INSERT INTO `crawler_question` VALUES ('1025991666554044419', 'https://tiku.baidu.com/tikupc/singledetail/d4fc65ce050876323112124e', '1025991635558137857', '0');
INSERT INTO `crawler_question` VALUES ('1025991666616958977', 'https://tiku.baidu.com/tikupc/singledetail/3cf8856a561252d380eb6e14', '1025991564531793924', '0');
INSERT INTO `crawler_question` VALUES ('1025991666633736193', 'https://tiku.baidu.com/tikupc/singledetail/b9ad81c758f5f61fb7366642', '1025991635813990404', '0');
INSERT INTO `crawler_question` VALUES ('1025991666633736194', 'https://tiku.baidu.com/tikupc/singledetail/beec284ac850ad02de804148', '1025991518151180294', '0');
INSERT INTO `crawler_question` VALUES ('1025991666663096322', 'https://tiku.baidu.com/tikupc/singledetail/fcc2770bf78a6529647d533c', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991666663096323', 'https://tiku.baidu.com/tikupc/singledetail/6f5ed15abe23482fb4da4c83', '1025991604285407236', '0');
INSERT INTO `crawler_question` VALUES ('1025991666688262145', 'https://tiku.baidu.com/tikupc/singledetail/f500cfc789eb172ded63b72f', '1025991635960791041', '0');
INSERT INTO `crawler_question` VALUES ('1025991666696650753', 'https://tiku.baidu.com/tikupc/singledetail/8e394b73f242336c1eb95e14', '1025991564531793924', '0');
INSERT INTO `crawler_question` VALUES ('1025991666738593794', 'https://tiku.baidu.com/tikupc/singledetail/fb80721cfad6195f312ba673', '1025991635813990404', '0');
INSERT INTO `crawler_question` VALUES ('1025991666746982403', 'https://tiku.baidu.com/tikupc/singledetail/41bc83d049649b6648d7473c', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991666746982402', 'https://tiku.baidu.com/tikupc/singledetail/5d20951ea76e58fafab003dd', '1025991604285407236', '0');
INSERT INTO `crawler_question` VALUES ('1025991666801508353', 'https://tiku.baidu.com/tikupc/singledetail/174aa8956bec0975f465e20d', '1025991635960791041', '0');
INSERT INTO `crawler_question` VALUES ('1025991666809896961', 'https://tiku.baidu.com/tikupc/singledetail/b518c5da50e2524de5187e03', '1025991636095008770', '0');
INSERT INTO `crawler_question` VALUES ('1025991666843451393', 'https://tiku.baidu.com/tikupc/singledetail/6db4763e0912a216147929d5', '1025991635813990404', '0');
INSERT INTO `crawler_question` VALUES ('1025991666843451394', 'https://tiku.baidu.com/tikupc/singledetail/6852be1e650e52ea55189817', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991666889588739', 'https://tiku.baidu.com/tikupc/singledetail/a50ca32d7375a417866f8f3f', '1025991635960791041', '0');
INSERT INTO `crawler_question` VALUES ('1025991666889588738', 'https://tiku.baidu.com/tikupc/singledetail/9e1f31126edb6f1aff001f28', '1025991636095008770', '0');
INSERT INTO `crawler_question` VALUES ('1025991666935726081', 'https://tiku.baidu.com/tikupc/singledetail/89790979168884868762d664', '1025991635813990404', '0');
INSERT INTO `crawler_question` VALUES ('1025991666956697602', 'https://tiku.baidu.com/tikupc/singledetail/a524a32d7375a417866f8f17', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991666998640642', 'https://tiku.baidu.com/tikupc/singledetail/90f95022aaea998fcc220e20', '1025991635960791041', '0');
INSERT INTO `crawler_question` VALUES ('1025991666998640641', 'https://tiku.baidu.com/tikupc/singledetail/13c058f5f61fb7360b4c6502', '1025991636095008770', '0');
INSERT INTO `crawler_question` VALUES ('1025991667078332418', 'https://tiku.baidu.com/tikupc/singledetail/6160a76e58fafab069dc027b', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991667086721026', 'https://tiku.baidu.com/tikupc/singledetail/57caf90f76c66137ee06193c', '1025991551227461633', '0');
INSERT INTO `crawler_question` VALUES ('1025991667103498241', 'https://tiku.baidu.com/tikupc/singledetail/d21bf78a6529647d27285215', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991667141246978', 'https://tiku.baidu.com/tikupc/singledetail/86b2dd36a32d7375a4178096', '1025991636480884738', '0');
INSERT INTO `crawler_question` VALUES ('1025991667149635586', 'https://tiku.baidu.com/tikupc/singledetail/47d358e2524de518964b7d0c', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991667174801409', 'https://tiku.baidu.com/tikupc/singledetail/fc80c1c708a1284ac8504352', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991667183190017', 'https://tiku.baidu.com/tikupc/singledetail/8e384b73f242336c1eb95e15', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991667216744450', 'https://tiku.baidu.com/tikupc/singledetail/60b3910ef12d2af90242e648', '1025991636250198017', '0');
INSERT INTO `crawler_question` VALUES ('1025991667233521666', 'https://tiku.baidu.com/tikupc/singledetail/166b1ed9ad51f01dc281f108', '1025991636480884738', '0');
INSERT INTO `crawler_question` VALUES ('1025991667250298882', 'https://tiku.baidu.com/tikupc/singledetail/1c1759f7ba0d4a7302763afd', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991667275464705', 'https://tiku.baidu.com/tikupc/singledetail/fe76581b6bd97f192279e97a', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991667275464706', 'https://tiku.baidu.com/tikupc/singledetail/e163f242336c1eb91a375d15', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991667292241922', 'https://tiku.baidu.com/tikupc/singledetail/dbd774a20029bd64783e2c00', '1025991636250198017', '0');
INSERT INTO `crawler_question` VALUES ('1025991667317407746', 'https://tiku.baidu.com/tikupc/singledetail/7e3cbb68a98271fe910ef933', '1025991636480884738', '0');
INSERT INTO `crawler_question` VALUES ('1025991667334184961', 'https://tiku.baidu.com/tikupc/singledetail/0301a9f8941ea76e58fa04fd', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991667359350786', 'https://tiku.baidu.com/tikupc/singledetail/51ed360cba1aa8114431d93d', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991667367739393', 'https://tiku.baidu.com/tikupc/singledetail/4ff6680203d8ce2f0066237a', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991667384516609', 'https://tiku.baidu.com/tikupc/singledetail/dc786b0e52ea551810a68763', '1025991636250198017', '0');
INSERT INTO `crawler_question` VALUES ('1025991667392905218', 'https://tiku.baidu.com/tikupc/singledetail/d239ea7101f69e314332943b', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991667443236868', 'https://tiku.baidu.com/tikupc/singledetail/f8b543323968011ca3009181', '1025991552838074370', '0');
INSERT INTO `crawler_question` VALUES ('1025991667443236867', 'https://tiku.baidu.com/tikupc/singledetail/d7e3ea5c3b3567ec102d8aac', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991667443236866', 'https://tiku.baidu.com/tikupc/singledetail/99294431b90d6c85ec3ac63d', '1025991551428788230', '0');
INSERT INTO `crawler_question` VALUES ('1025991667451625473', 'https://tiku.baidu.com/tikupc/singledetail/577e0722192e45361066f55c', '1025991518667079682', '0');
INSERT INTO `crawler_question` VALUES ('1025991667493568513', 'https://tiku.baidu.com/tikupc/singledetail/ad1c10b91a37f111f1855b75', '1025991636250198017', '0');
INSERT INTO `crawler_question` VALUES ('1025991667514540034', 'https://tiku.baidu.com/tikupc/singledetail/e27924d3240c844769eaee19', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991667539705858', 'https://tiku.baidu.com/tikupc/singledetail/09f3a417866fb84ae45c8d83', '1025991552838074370', '0');
INSERT INTO `crawler_question` VALUES ('1025991667531317250', 'https://tiku.baidu.com/tikupc/singledetail/69a96d29647d27284b735126', '1025991551940493314', '0');
INSERT INTO `crawler_question` VALUES ('1025991667590037505', 'https://tiku.baidu.com/tikupc/singledetail/3c8857eef8c75fbfc77db291', '1025991524673323012', '0');
INSERT INTO `crawler_question` VALUES ('1025991667644563458', 'https://tiku.baidu.com/tikupc/singledetail/05b7182e453610661ed9f490', '1025991552838074370', '0');
INSERT INTO `crawler_question` VALUES ('1025991667661340673', 'https://tiku.baidu.com/tikupc/singledetail/2ec2b2717fd5360cba1adb66', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991667766198273', 'https://tiku.baidu.com/tikupc/singledetail/8836ccc789eb172ded63b719', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991667778781185', 'https://tiku.baidu.com/tikupc/singledetail/8ed089eb172ded630b1cb612', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991667803947010', 'https://tiku.baidu.com/tikupc/singledetail/0ae1a517866fb84ae45c8d91', '1025991636715765762', '0');
INSERT INTO `crawler_question` VALUES ('1025991667845890051', 'https://tiku.baidu.com/tikupc/singledetail/6c050740be1e650e52ea9902', '1025991636917092354', '0');
INSERT INTO `crawler_question` VALUES ('1025991667845890050', 'https://tiku.baidu.com/tikupc/singledetail/151e75c66137ee06eff91814', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991667904610306', 'https://tiku.baidu.com/tikupc/singledetail/47156bd97f1922791688e80b', '1025991636715765762', '0');
INSERT INTO `crawler_question` VALUES ('1025991667896221697', 'https://tiku.baidu.com/tikupc/singledetail/b509c5da50e2524de5187e12', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991667996884994', 'https://tiku.baidu.com/tikupc/singledetail/3df6561810a6f524ccbf8519', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991668005273602', 'https://tiku.baidu.com/tikupc/singledetail/4fcd50e2524de518964b7d12', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991668030439425', 'https://tiku.baidu.com/tikupc/singledetail/4fbc680203d8ce2f00662330', '1025991636715765762', '0');
INSERT INTO `crawler_question` VALUES ('1025991668072382465', 'https://tiku.baidu.com/tikupc/singledetail/e5472fd3240c844769eaee27', '1025991582969954308', '0');
INSERT INTO `crawler_question` VALUES ('1025991668089159681', 'https://tiku.baidu.com/tikupc/singledetail/1cc7aef8941ea76e58fa043b', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991668110131202', 'https://tiku.baidu.com/tikupc/singledetail/2426094c2e3f5727a5e96215', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991668118519809', 'https://tiku.baidu.com/tikupc/singledetail/e23d763231126edb6f1a1030', '1025991636715765762', '0');
INSERT INTO `crawler_question` VALUES ('1025991668177240065', 'https://tiku.baidu.com/tikupc/singledetail/8e3ca26925c52cc58bd6be44', '1025991582487609348', '0');
INSERT INTO `crawler_question` VALUES ('1025991668202405889', 'https://tiku.baidu.com/tikupc/singledetail/412627fff705cc17552709f2', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991668227571714', 'https://tiku.baidu.com/tikupc/singledetail/a66970fe910ef12d2af9e7ee', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991668277903361', 'https://tiku.baidu.com/tikupc/singledetail/11d35cf7ba0d4a7302763a39', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991668340817921', 'https://tiku.baidu.com/tikupc/singledetail/7d2b16791711cc7931b71638', '1025991552213123073', '0');
INSERT INTO `crawler_question` VALUES ('1025991668349206530', 'https://tiku.baidu.com/tikupc/singledetail/675ea45177232f60ddcca132', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991668407926785', 'https://tiku.baidu.com/tikupc/singledetail/465665ec102de2bd96058866', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991668462452738', 'https://tiku.baidu.com/tikupc/singledetail/1ddc6294dd88d0d233d46a32', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991668462452739', 'https://tiku.baidu.com/tikupc/singledetail/c918a6c30c22590102029d1d', '1025991637240053763', '0');
INSERT INTO `crawler_question` VALUES ('1025991668487618561', 'https://tiku.baidu.com/tikupc/singledetail/51cf6529647d27284b735140', '1025991552091488258', '0');
INSERT INTO `crawler_question` VALUES ('1025991668496007170', 'https://tiku.baidu.com/tikupc/singledetail/9620980590c69ec3d5bb7598', '1025991518847434754', '0');
INSERT INTO `crawler_question` VALUES ('1025991668546338818', 'https://tiku.baidu.com/tikupc/singledetail/a7090912a216147917112832', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991668546338819', 'https://tiku.baidu.com/tikupc/singledetail/40c524fff705cc1755270911', '1025991637659484162', '0');
INSERT INTO `crawler_question` VALUES ('1025991668672167937', 'https://tiku.baidu.com/tikupc/singledetail/114cf46527d3240c8447ef3c', '1025991566054326275', '0');
INSERT INTO `crawler_question` VALUES ('1025991668793802754', 'https://tiku.baidu.com/tikupc/singledetail/99971cb91a37f111f1855bfe', '1025991525336023042', '0');
INSERT INTO `crawler_question` VALUES ('1025991668793802755', 'https://tiku.baidu.com/tikupc/singledetail/41064b35eefdc8d376ee3226', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991668848328706', 'https://tiku.baidu.com/tikupc/singledetail/b9c181c758f5f61fb736662e', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991668869300226', 'https://tiku.baidu.com/tikupc/singledetail/1a38710abb68a98271fefac1', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991668902854658', 'https://tiku.baidu.com/tikupc/singledetail/4e3859eef8c75fbfc77db221', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991668961574914', 'https://tiku.baidu.com/tikupc/singledetail/a9d2195f312b3169a451a401', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991668982546433', 'https://tiku.baidu.com/tikupc/singledetail/1375094e767f5acfa1c7cd66', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991669137735682', 'https://tiku.baidu.com/tikupc/singledetail/b44af111f18583d049645978', '1025991552624164865', '0');
INSERT INTO `crawler_question` VALUES ('1025991669137735681', 'https://tiku.baidu.com/tikupc/singledetail/681ba300a6c30c2259019e02', '1025991607221420035', '0');
INSERT INTO `crawler_question` VALUES ('1025991669171290114', 'https://tiku.baidu.com/tikupc/singledetail/9a0602768e9951e79b892770', '1025991638817112066', '0');
INSERT INTO `crawler_question` VALUES ('1025991669171290113', 'https://tiku.baidu.com/tikupc/singledetail/676da45177232f60ddcca101', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991669200650241', 'https://tiku.baidu.com/tikupc/singledetail/443a67ec102de2bd9605880a', '1025991532722192386', '0');
INSERT INTO `crawler_question` VALUES ('1025991669217427457', 'https://tiku.baidu.com/tikupc/singledetail/1bc50266f5335a8102d220ef', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991669246787586', 'https://tiku.baidu.com/tikupc/singledetail/642f3169a45177232f60a201', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991669246787585', 'https://tiku.baidu.com/tikupc/singledetail/32fe49649b6648d7c1c7462b', '1025991607221420035', '0');
INSERT INTO `crawler_question` VALUES ('1025991669259370498', 'https://tiku.baidu.com/tikupc/singledetail/cf0ca5e9856a561252d36f2e', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991669259370497', 'https://tiku.baidu.com/tikupc/singledetail/2d8c5b8102d276a200292eba', '1025991638817112066', '0');
INSERT INTO `crawler_question` VALUES ('1025991669318090754', 'https://tiku.baidu.com/tikupc/singledetail/836f03d276a20029bd642deb', '1025991552410255363', '0');
INSERT INTO `crawler_question` VALUES ('1025991669355839490', 'https://tiku.baidu.com/tikupc/singledetail/1dc06294dd88d0d233d46a2e', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991669372616706', 'https://tiku.baidu.com/tikupc/singledetail/a24bfe4733687e21af45a901', '1025991583334858753', '0');
INSERT INTO `crawler_question` VALUES ('1025991669372616708', 'https://tiku.baidu.com/tikupc/singledetail/a0ab8762caaedd3383c4d328', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991669372616707', 'https://tiku.baidu.com/tikupc/singledetail/584ee1f5f61fb7360b4c658f', '1025991638817112066', '0');
INSERT INTO `crawler_question` VALUES ('1025991669469085698', 'https://tiku.baidu.com/tikupc/singledetail/60f8910ef12d2af90242e603', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991669469085697', 'https://tiku.baidu.com/tikupc/singledetail/fcbfdd88d0d233d4b14e692e', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991669573943298', 'https://tiku.baidu.com/tikupc/singledetail/f735cc1755270722192ef735', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991669573943297', 'https://tiku.baidu.com/tikupc/singledetail/2f1a2f60ddccda38376baf3c', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991669573943299', 'https://tiku.baidu.com/tikupc/singledetail/b98471fe910ef12d2af9e703', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991669699772419', 'https://tiku.baidu.com/tikupc/singledetail/e9c67c1cfad6195f312ba635', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991669699772418', 'https://tiku.baidu.com/tikupc/singledetail/9e1e7ed184254b35eefd3415', '1025991606856515587', '0');
INSERT INTO `crawler_question` VALUES ('1025991669699772420', 'https://tiku.baidu.com/tikupc/singledetail/7a3379563c1ec5da50e2703c', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991669708161026', 'https://tiku.baidu.com/tikupc/singledetail/bebb6bec0975f46527d3e12b', '1025991583171280898', '0');
INSERT INTO `crawler_question` VALUES ('1025991669766881281', 'https://tiku.baidu.com/tikupc/singledetail/9ec42bc52cc58bd63186bda8', '1025991639123296258', '0');
INSERT INTO `crawler_question` VALUES ('1025991669808824321', 'https://tiku.baidu.com/tikupc/singledetail/e86025c52cc58bd63186bd0c', '1025991583632654338', '0');
INSERT INTO `crawler_question` VALUES ('1025991669808824323', 'https://tiku.baidu.com/tikupc/singledetail/8a08a8114431b90d6c85c717', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991669808824322', 'https://tiku.baidu.com/tikupc/singledetail/5bd4b1f3f90f76c661371a04', '1025991606856515587', '0');
INSERT INTO `crawler_question` VALUES ('1025991669892710401', 'https://tiku.baidu.com/tikupc/singledetail/fb5902225901020207409c9f', '1025991606856515587', '0');
INSERT INTO `crawler_question` VALUES ('1025991669901099009', 'https://tiku.baidu.com/tikupc/singledetail/435414791711cc7931b71647', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991669968207874', 'https://tiku.baidu.com/tikupc/singledetail/ce671f11cc7931b765ce151b', '1025991606856515587', '0');
INSERT INTO `crawler_question` VALUES ('1025991669976596482', 'https://tiku.baidu.com/tikupc/singledetail/658cb6360b4c2e3f57276396', '1025991583800426499', '0');
INSERT INTO `crawler_question` VALUES ('1025991670152757251', 'https://tiku.baidu.com/tikupc/singledetail/1b174793daef5ef7ba0d3ce1', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991670152757250', 'https://tiku.baidu.com/tikupc/singledetail/9a6d02768e9951e79b89271b', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991670328918018', 'https://tiku.baidu.com/tikupc/singledetail/87c1da38376baf1ffc4fad08', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991670345695234', 'https://tiku.baidu.com/tikupc/singledetail/261a10a6f524ccbff1218407', '1025991639316234242', '0');
INSERT INTO `crawler_question` VALUES ('1025991670345695235', 'https://tiku.baidu.com/tikupc/singledetail/de4c4bfe04a1b0717fd5dda5', '1025991606504194049', '0');
INSERT INTO `crawler_question` VALUES ('1025991670354083841', 'https://tiku.baidu.com/tikupc/singledetail/c6f63186bceb19e8b8f6ba25', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991670345695236', 'https://tiku.baidu.com/tikupc/singledetail/fa3883c4bb4cf7ec4afed00e', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991670509273090', 'https://tiku.baidu.com/tikupc/singledetail/2e03fad6195f312b3169a51a', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991670509273091', 'https://tiku.baidu.com/tikupc/singledetail/fbd382c4bb4cf7ec4afed0e5', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991670509273089', 'https://tiku.baidu.com/tikupc/singledetail/c0d9a4e9856a561252d36ffb', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991670593159169', 'https://tiku.baidu.com/tikupc/singledetail/9d432e3f5727a5e9856a610a', '1025991639316234242', '0');
INSERT INTO `crawler_question` VALUES ('1025991670651879428', 'https://tiku.baidu.com/tikupc/singledetail/6494f524ccbff121dd368337', '1025991533015793665', '0');
INSERT INTO `crawler_question` VALUES ('1025991670651879427', 'https://tiku.baidu.com/tikupc/singledetail/833df12d2af90242a895e536', '1025991567354560516', '0');
INSERT INTO `crawler_question` VALUES ('1025991670651879426', 'https://tiku.baidu.com/tikupc/singledetail/0386178884868762caaed5fa', '1025991606504194049', '0');
INSERT INTO `crawler_question` VALUES ('1025991670651879429', 'https://tiku.baidu.com/tikupc/singledetail/7cce0975f46527d3240ce027', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991670677045251', 'https://tiku.baidu.com/tikupc/singledetail/6b2caf1ffc4ffe473368ab42', '1025991541144354818', '0');
INSERT INTO `crawler_question` VALUES ('1025991670677045250', 'https://tiku.baidu.com/tikupc/singledetail/d00ae87101f69e3143329408', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991670677045252', 'https://tiku.baidu.com/tikupc/singledetail/859b03768e9951e79b8927ed', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991670773514242', 'https://tiku.baidu.com/tikupc/singledetail/30d2bdd126fff705cc170af5', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991670857400322', 'https://tiku.baidu.com/tikupc/singledetail/abf17ffe910ef12d2af9e776', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991670857400323', 'https://tiku.baidu.com/tikupc/singledetail/8ed689eb172ded630b1cb614', '1025991639316234242', '0');
INSERT INTO `crawler_question` VALUES ('1025991670857400325', 'https://tiku.baidu.com/tikupc/singledetail/fb7a9b6648d7c1c708a1451b', '1025991639471423490', '0');
INSERT INTO `crawler_question` VALUES ('1025991670857400324', 'https://tiku.baidu.com/tikupc/singledetail/f64a1711cc7931b765ce1536', '1025991567354560516', '0');
INSERT INTO `crawler_question` VALUES ('1025991670781902850', 'https://tiku.baidu.com/tikupc/singledetail/f219fc4ffe4733687e21aa03', '1025991639895048193', '0');
INSERT INTO `crawler_question` VALUES ('1025991670916120577', 'https://tiku.baidu.com/tikupc/singledetail/80baa06925c52cc58bd6bec2', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991670895149058', 'https://tiku.baidu.com/tikupc/singledetail/2090551810a6f524ccbf857f', '1025991607817011202', '0');
INSERT INTO `crawler_question` VALUES ('1025991670916120578', 'https://tiku.baidu.com/tikupc/singledetail/cbfbf61fb7360b4c2e3f640b', '1025991566545059842', '0');
INSERT INTO `crawler_question` VALUES ('1025991670895149057', 'https://tiku.baidu.com/tikupc/singledetail/efe6590216fc700abb68fcd9', '1025991606504194049', '0');
INSERT INTO `crawler_question` VALUES ('1025991670928703490', 'https://tiku.baidu.com/tikupc/singledetail/82dd9b89680203d8ce2f243f', '1025991608169332737', '0');
INSERT INTO `crawler_question` VALUES ('1025991670958063620', 'https://tiku.baidu.com/tikupc/singledetail/6089960590c69ec3d5bb7531', '1025991567354560516', '0');
INSERT INTO `crawler_question` VALUES ('1025991670958063617', 'https://tiku.baidu.com/tikupc/singledetail/138c62175f0e7cd184253698', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991670958063621', 'https://tiku.baidu.com/tikupc/singledetail/1bcad5bbfd0a79563c1e720c', '1025991639895048193', '0');
INSERT INTO `crawler_question` VALUES ('1025991671008395266', 'https://tiku.baidu.com/tikupc/singledetail/3e3a250c844769eae009edec', '1025991532298567685', '0');
INSERT INTO `crawler_question` VALUES ('1025991670958063619', 'https://tiku.baidu.com/tikupc/singledetail/ed4727d3240c844769eaee27', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991670958063618', 'https://tiku.baidu.com/tikupc/singledetail/42d0d0d233d4b14e8524685d', '1025991639471423490', '0');
INSERT INTO `crawler_question` VALUES ('1025991671016783874', 'https://tiku.baidu.com/tikupc/singledetail/6d8ec422bcd126fff7050b04', '1025991566171766786', '0');
INSERT INTO `crawler_question` VALUES ('1025991671016783873', 'https://tiku.baidu.com/tikupc/singledetail/c530e45c3b3567ec102d8a7f', '1025991607817011202', '0');
INSERT INTO `crawler_question` VALUES ('1025991671054532610', 'https://tiku.baidu.com/tikupc/singledetail/2353541810a6f524ccbf85bc', '1025991606504194049', '0');
INSERT INTO `crawler_question` VALUES ('1025991671054532611', 'https://tiku.baidu.com/tikupc/singledetail/61536c175f0e7cd184253647', '1025991608169332737', '0');
INSERT INTO `crawler_question` VALUES ('1025991671264247810', 'https://tiku.baidu.com/tikupc/singledetail/6800a300a6c30c2259019e19', '1025991608169332737', '0');
INSERT INTO `crawler_question` VALUES ('1025991671171973121', 'https://tiku.baidu.com/tikupc/singledetail/b1914028915f804d2b16c156', '1025991607817011202', '0');
INSERT INTO `crawler_question` VALUES ('1025991671117447170', 'https://tiku.baidu.com/tikupc/singledetail/cbce172ded630b1c59eeb520', '1025991542033547265', '0');
INSERT INTO `crawler_question` VALUES ('1025991671171973122', 'https://tiku.baidu.com/tikupc/singledetail/1dd4d7bbfd0a79563c1e7212', '1025991606504194049', '0');
INSERT INTO `crawler_question` VALUES ('1025991671117447169', 'https://tiku.baidu.com/tikupc/singledetail/60079e4bcf84b9d528ea7a1a', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991671457185795', 'https://tiku.baidu.com/tikupc/singledetail/40cab9d528ea81c758f5784b', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991671457185794', 'https://tiku.baidu.com/tikupc/singledetail/a527a32d7375a417866f8f14', '1025991640180260865', '0');
INSERT INTO `crawler_question` VALUES ('1025991671494934530', 'https://tiku.baidu.com/tikupc/singledetail/b8ab84254b35eefdc8d3337f', '1025991607817011202', '0');
INSERT INTO `crawler_question` VALUES ('1025991671494934531', 'https://tiku.baidu.com/tikupc/singledetail/8828e606eff9aef8941e061a', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991671583014913', 'https://tiku.baidu.com/tikupc/singledetail/51b9998fcc22bcd126ff0c56', '1025991542310371330', '0');
INSERT INTO `crawler_question` VALUES ('1025991671583014914', 'https://tiku.baidu.com/tikupc/singledetail/8a4c6c85ec3a87c24028c444', '1025991640180260865', '0');
INSERT INTO `crawler_question` VALUES ('1025991671624957954', 'https://tiku.baidu.com/tikupc/singledetail/9f386637ee06eff9aef807fb', '1025991541307932674', '0');
INSERT INTO `crawler_question` VALUES ('1025991671624957955', 'https://tiku.baidu.com/tikupc/singledetail/8d4feefdc8d376eeaeaa317f', '1025991607817011202', '0');
INSERT INTO `crawler_question` VALUES ('1025991671675289602', 'https://tiku.baidu.com/tikupc/singledetail/60ed910ef12d2af90242e616', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991671713038337', 'https://tiku.baidu.com/tikupc/singledetail/d55bce2f0066f5335a812186', '1025991640180260865', '0');
INSERT INTO `crawler_question` VALUES ('1025991671801118722', 'https://tiku.baidu.com/tikupc/singledetail/cd0152d380eb6294dd886c16', '1025991566842855425', '0');
INSERT INTO `crawler_question` VALUES ('1025991671801118723', 'https://tiku.baidu.com/tikupc/singledetail/fcf5c1c708a1284ac8504327', '1025991608450351106', '0');
INSERT INTO `crawler_question` VALUES ('1025991671855644674', 'https://tiku.baidu.com/tikupc/singledetail/d9b2e418964bcf84b9d57bfa', '1025991640180260865', '0');
INSERT INTO `crawler_question` VALUES ('1025991671956307970', 'https://tiku.baidu.com/tikupc/singledetail/9d6a2e3f5727a5e9856a6123', '1025991608450351106', '0');
INSERT INTO `crawler_question` VALUES ('1025991671956307971', 'https://tiku.baidu.com/tikupc/singledetail/606b590102020740be1e9b4c', '1025991640322867202', '0');
INSERT INTO `crawler_question` VALUES ('1025991672061165570', 'https://tiku.baidu.com/tikupc/singledetail/775d915f804d2b160b4ec070', '1025991608450351106', '0');
INSERT INTO `crawler_question` VALUES ('1025991672061165569', 'https://tiku.baidu.com/tikupc/singledetail/a189ff4733687e21af45a9c3', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991672275075074', 'https://tiku.baidu.com/tikupc/singledetail/b977f021dd36a32d737581cd', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991672275075075', 'https://tiku.baidu.com/tikupc/singledetail/5408ed630b1c59eef8c7b420', '1025991608618123266', '0');
INSERT INTO `crawler_question` VALUES ('1025991672275075076', 'https://tiku.baidu.com/tikupc/singledetail/c956a6c30c22590102029d53', '1025991608450351106', '0');
INSERT INTO `crawler_question` VALUES ('1025991672275075077', 'https://tiku.baidu.com/tikupc/singledetail/e26f2af90242a8956bece447', '1025991640624857090', '0');
INSERT INTO `crawler_question` VALUES ('1025991672342183937', 'https://tiku.baidu.com/tikupc/singledetail/5ef5001ca300a6c30c229f98', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991672342183938', 'https://tiku.baidu.com/tikupc/singledetail/2327541810a6f524ccbf85c8', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991672342183939', 'https://tiku.baidu.com/tikupc/singledetail/2f7b2f60ddccda38376baf5d', '1025991608450351106', '0');
INSERT INTO `crawler_question` VALUES ('1025991672451235841', 'https://tiku.baidu.com/tikupc/singledetail/47244935eefdc8d376ee3204', '1025991640624857090', '0');
INSERT INTO `crawler_question` VALUES ('1025991672342183940', 'https://tiku.baidu.com/tikupc/singledetail/046c192e453610661ed9f44b', '1025991608618123266', '0');
INSERT INTO `crawler_question` VALUES ('1025991672451235842', 'https://tiku.baidu.com/tikupc/singledetail/f3f419e8b8f67c1cfad6b81a', '1025991640834572290', '0');
INSERT INTO `crawler_question` VALUES ('1025991672451235844', 'https://tiku.baidu.com/tikupc/singledetail/12eb0a4e767f5acfa1c7cdf8', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991672451235843', 'https://tiku.baidu.com/tikupc/singledetail/f29776232f60ddccda38a0c3', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991672677728258', 'https://tiku.baidu.com/tikupc/singledetail/9202f7ec4afe04a1b071de4b', '1025991608618123266', '0');
INSERT INTO `crawler_question` VALUES ('1025991672770002946', 'https://tiku.baidu.com/tikupc/singledetail/e82525c52cc58bd63186bd49', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991672770002945', 'https://tiku.baidu.com/tikupc/singledetail/35b084868762caaedd33d43d', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991672837111809', 'https://tiku.baidu.com/tikupc/singledetail/27d511a6f524ccbff12184c8', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991672837111810', 'https://tiku.baidu.com/tikupc/singledetail/5635b9f67c1cfad6195fa7d8', '1025991584622510081', '0');
INSERT INTO `crawler_question` VALUES ('1025991672837111811', 'https://tiku.baidu.com/tikupc/singledetail/e22a763231126edb6f1a1027', '1025991567685910530', '0');
INSERT INTO `crawler_question` VALUES ('1025991672837111812', 'https://tiku.baidu.com/tikupc/singledetail/af8ffab069dc5022aaea0070', '1025991608618123266', '0');
INSERT INTO `crawler_question` VALUES ('1025991672837111813', 'https://tiku.baidu.com/tikupc/singledetail/9d78f4ec4afe04a1b071de31', '1025991609364709378', '0');
INSERT INTO `crawler_question` VALUES ('1025991672837111815', 'https://tiku.baidu.com/tikupc/singledetail/3132bcd126fff705cc170a15', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991672967135234', 'https://tiku.baidu.com/tikupc/singledetail/76d5905f804d2b160b4ec0f8', '1025991553911816193', '0');
INSERT INTO `crawler_question` VALUES ('1025991672837111814', 'https://tiku.baidu.com/tikupc/singledetail/d98076a20029bd64783e2c57', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991672967135237', 'https://tiku.baidu.com/tikupc/singledetail/ded2876fb84ae45c3b358cc0', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991673109741570', 'https://tiku.baidu.com/tikupc/singledetail/2c0a5a8102d276a200292e3c', '1025991609033359362', '0');
INSERT INTO `crawler_question` VALUES ('1025991672967135236', 'https://tiku.baidu.com/tikupc/singledetail/1157f46527d3240c8447ef27', '1025991640977178625', '0');
INSERT INTO `crawler_question` VALUES ('1025991673168461825', 'https://tiku.baidu.com/tikupc/singledetail/165b76c66137ee06eff91851', '1025991608618123266', '0');
INSERT INTO `crawler_question` VALUES ('1025991672967135235', 'https://tiku.baidu.com/tikupc/singledetail/24453968011ca300a6c39072', '1025991608869781505', '0');
INSERT INTO `crawler_question` VALUES ('1025991673235570691', 'https://tiku.baidu.com/tikupc/singledetail/b3811a37f111f18583d05a3d', '1025991566998044673', '0');
INSERT INTO `crawler_question` VALUES ('1025991673235570690', 'https://tiku.baidu.com/tikupc/singledetail/99424431b90d6c85ec3ac656', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991673235570692', 'https://tiku.baidu.com/tikupc/singledetail/511058fafab069dc5022017b', '1025991567685910530', '0');
INSERT INTO `crawler_question` VALUES ('1025991673298485250', 'https://tiku.baidu.com/tikupc/singledetail/9e892f3f5727a5e9856a61c0', '1025991541727363074', '0');
INSERT INTO `crawler_question` VALUES ('1025991673298485251', 'https://tiku.baidu.com/tikupc/singledetail/e7e2102de2bd960590c6770b', '1025991609192742916', '0');
INSERT INTO `crawler_question` VALUES ('1025991673298485252', 'https://tiku.baidu.com/tikupc/singledetail/bed46bec0975f46527d3e144', '1025991609033359362', '0');
INSERT INTO `crawler_question` VALUES ('1025991673298485253', 'https://tiku.baidu.com/tikupc/singledetail/5196998fcc22bcd126ff0c79', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991673298485249', 'https://tiku.baidu.com/tikupc/singledetail/1711a8956bec0975f465e256', '1025991608869781505', '0');
INSERT INTO `crawler_question` VALUES ('1025991673235570693', 'https://tiku.baidu.com/tikupc/singledetail/9e04d536a32d7375a4178020', '1025991609364709378', '0');
INSERT INTO `crawler_question` VALUES ('1025991673373982722', 'https://tiku.baidu.com/tikupc/singledetail/1f7b561252d380eb62946d14', '1025991609637339138', '0');
INSERT INTO `crawler_question` VALUES ('1025991673373982723', 'https://tiku.baidu.com/tikupc/singledetail/8a5e6c85ec3a87c24028c456', '1025991553446248450', '0');
INSERT INTO `crawler_question` VALUES ('1025991673420120066', 'https://tiku.baidu.com/tikupc/singledetail/cddb0c225901020207409c1d', '1025991641740541954', '0');
INSERT INTO `crawler_question` VALUES ('1025991673420120067', 'https://tiku.baidu.com/tikupc/singledetail/7a4b79563c1ec5da50e27044', '1025991609033359362', '0');
INSERT INTO `crawler_question` VALUES ('1025991673420120070', 'https://tiku.baidu.com/tikupc/singledetail/a11133687e21af45b307a853', '1025991567170011137', '0');
INSERT INTO `crawler_question` VALUES ('1025991673420120068', 'https://tiku.baidu.com/tikupc/singledetail/b9e481c758f5f61fb736660b', '1025991609192742916', '0');
INSERT INTO 