The folder contains resource files for test cases:
* bolt.pfx: the server's keystore file.
* cbolt.pfx:  the client's keystore file.
* bolt.cer: the server's exported certificate file.

They are generated by following steps.

First, generate server keystore and export it's certificate file:

```sh
keytool -genkey -alias securebolt -keysize 2048 -validity  365 -keyalg RSA -dname "CN=localhost" -keypass sfbolt -storepass sfbolt -keystore bolt.pfx -deststoretype pkcs12

keytool -export -alias securebolt -keystore bolt.pfx -storepass sfbolt -file bolt.cer
```

Then generate client keystore:

```sh
keytool -genkey -alias smcc -keysize 2048 -validity 365 -keyalg RSA -dname "CN=localhost" -keypass sfbolt -storepass sfbolt -keystore cbolt.pfx -deststoretype pkcs12
```

Finally, import server's certificate into client's keystore:

```sh
keytool -import -trustcacerts -alias securebolt -file bolt.cer -storepass sfbolt -keystore cbolt.pfx
```


