/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc;

import com.ibm.db2.jcc.DB2Driver;
import com.ibm.db2.jcc.am.Connection;
import com.ibm.db2.jcc.am.ErrorKey;
import com.ibm.db2.jcc.am.GlobalProperties;
import com.ibm.db2.jcc.am.hb;
import com.ibm.db2.jcc.am.no;
import com.ibm.db2.jcc.am.pc;
import com.ibm.db2.jcc.am.qp;
import com.ibm.db2.jcc.am.sp;
import com.ibm.db2.jcc.am.ue;
import com.ibm.db2.jcc.t2.c;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class DB2Jcc {
    private static String commandString_ = "java com.ibm.db2.jcc.DB2Jcc ";
    private static String checkUrl_ = null;
    private static final String DEFAULT_INFORMIX_SQL = "select first 1 * from informix.systables";
    private static final String DEFAULT_OTHER_SQL = "select 1 from SYSIBM.SYSDUMMY1";
    private String licenseFilePath_ = null;
    private String url_ = null;
    private String user_ = null;
    private String password_ = null;
    private int tracing_ = 0;
    private String sql_ = null;

    public static void main(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        DB2Jcc dB2Jcc = new DB2Jcc();
        if (stringArray.length == 0) {
            DB2Jcc.printUsage(printWriter);
            System.exit(DB2Jcc.getAppropriateExitCode(-1));
        }
        int n2 = 0;
        commandString_ = commandString_ + stringArray[n2++];
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-password")) {
                commandString_ = commandString_ + " " + stringArray[n2++];
                commandString_ = commandString_ + " ********";
                ++n2;
                continue;
            }
            commandString_ = commandString_ + " " + stringArray[n2++];
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equalsIgnoreCase("-version") || stringArray[i2].equalsIgnoreCase("-configuration") || stringArray[i2].equalsIgnoreCase("-help") || stringArray[i2].equalsIgnoreCase("-expirationDate") || stringArray[i2].equalsIgnoreCase("-expirationDateWithLicenseType") || stringArray[i2].equalsIgnoreCase("-db2ConnectVersion")) continue;
            bl2 = true;
        }
        if (bl2) {
            System.out.println("\n");
            printWriter.println(no.a("10521", new Object[]{commandString_}, "13706"));
            System.out.println("\n");
            bl2 = false;
        }
        int n3 = 0;
        String string = null;
        String string2 = null;
        boolean bl3 = false;
        while (n3 < stringArray.length) {
            Object object;
            if ((string = stringArray[n3++]).equalsIgnoreCase("-help")) {
                DB2Jcc.printUsage(printWriter);
                return;
            }
            if (string.equals("-configuration")) {
                object = new PrintWriter(System.out, true);
                String[] stringArray2 = sp.x();
                String string3 = stringArray2[0];
                ((PrintWriter)object).println(string3);
                continue;
            }
            if (string.equals("-version")) {
                System.out.println(sp.d());
                continue;
            }
            if (string.equals("-expirationDate")) {
                object = ue.a();
                if (object == null) {
                    if (!hb.le[1] && !hb.le[3]) {
                        printWriter.println(no.d("10540"));
                        continue;
                    }
                    printWriter.println(no.d("10537"));
                    continue;
                }
                System.out.println(object);
                continue;
            }
            if (string.equals("-expirationDateWithLicenseType")) {
                System.out.println(ue.b());
                continue;
            }
            if (string.equals("-db2ConnectVersion")) {
                if (!DB2Jcc.checkMatchingValueForOption(string, n3, stringArray.length, printWriter)) {
                    System.exit(DB2Jcc.getAppropriateExitCode(-1));
                }
                dB2Jcc.setLicenseFilePath(stringArray[n3++]);
                try {
                    object = ue.a(dB2Jcc.getLicenseFilePath());
                    if (object == null) {
                        printWriter.println(no.d("10539"));
                        continue;
                    }
                    System.out.println((String)object);
                }
                catch (IOException iOException) {
                    printWriter.println(no.a("10538", new Object[]{String.valueOf(iOException.getMessage())}));
                }
                continue;
            }
            if (string.equalsIgnoreCase("-url")) {
                bl3 = true;
                if (!DB2Jcc.checkMatchingValueForOption(string, n3, stringArray.length, printWriter)) {
                    System.exit(DB2Jcc.getAppropriateExitCode(-1));
                }
                dB2Jcc.setUrl(stringArray[n3++]);
                continue;
            }
            if (string.equalsIgnoreCase("-user")) {
                if (!DB2Jcc.checkMatchingValueForOption(string, n3, stringArray.length, printWriter)) {
                    System.exit(DB2Jcc.getAppropriateExitCode(-1));
                }
                dB2Jcc.setUser(stringArray[n3++]);
                continue;
            }
            if (string.equalsIgnoreCase("-password")) {
                if (!DB2Jcc.checkMatchingValueForOption(string, n3, stringArray.length, printWriter)) {
                    System.exit(DB2Jcc.getAppropriateExitCode(-1));
                }
                dB2Jcc.setPassword(stringArray[n3++]);
                continue;
            }
            if (string.equalsIgnoreCase("-sql")) {
                if (bl3) {
                    bl3 = false;
                    if (!DB2Jcc.checkMatchingValueForOption(string, n3, stringArray.length, printWriter)) {
                        System.exit(DB2Jcc.getAppropriateExitCode(-1));
                    }
                    if (n3 >= stringArray.length || stringArray[n3].charAt(0) == '-' && stringArray[n3].charAt(0) == '\'') continue;
                    while (n3 < stringArray.length && stringArray[n3].charAt(0) != '-') {
                        if (string2 == null) {
                            string2 = stringArray[n3++];
                            continue;
                        }
                        string2 = string2 + " " + stringArray[n3++];
                    }
                    if (string2 != null) {
                        if (string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'') {
                            string2 = string2.substring(0, string2.length() - 1);
                            string2 = string2.replaceFirst("'", "");
                            dB2Jcc.setSql(string2);
                            continue;
                        }
                        DB2Jcc.callErrorSql(printWriter, string);
                        continue;
                    }
                    DB2Jcc.callErrorSql(printWriter, string);
                    continue;
                }
                printWriter.println(no.a("10518", new Object[]{string}, "13707"));
                DB2Jcc.printUsage(printWriter);
                System.exit(DB2Jcc.getAppropriateExitCode(-1));
                continue;
            }
            if (string.equalsIgnoreCase("-tracing")) {
                try {
                    dB2Jcc.setTraceLevel(qp.b("TRACE_ALL"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    printWriter.println(illegalArgumentException.getMessage());
                    System.exit(DB2Jcc.getAppropriateExitCode(-1));
                }
                continue;
            }
            printWriter.println(no.a("10272", new Object[]{string}, "10052"));
            DB2Jcc.printUsage(printWriter);
            System.exit(DB2Jcc.getAppropriateExitCode(-1));
        }
        if (checkUrl_ != null) {
            dB2Jcc.runConnectVerifyFromCommandLine(printWriter);
        }
    }

    public void setLicenseFilePath(String string) {
        this.licenseFilePath_ = string;
    }

    public String getLicenseFilePath() {
        return this.licenseFilePath_;
    }

    public void setUrl(String string) {
        this.url_ = string;
        checkUrl_ = string;
    }

    public void setUser(String string) {
        this.user_ = string;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public void setTraceLevel(int n2) {
        this.tracing_ = n2;
    }

    public void setSql(String string) {
        this.sql_ = string;
        this.sql_ = this.sql_.trim();
    }

    public void runConnectVerifyFromCommandLine(PrintWriter printWriter) {
        Connection connection = null;
        try {
            ResultSet resultSet;
            Object object;
            String string;
            Object object2;
            connection = this.getConnectionForConnect(printWriter);
            if (connection == null) {
                object2 = no.a("10512", "13708");
                DB2Jcc.printlnMessageIfCommandLine(printWriter, (String)object2);
                DB2Jcc.printUsage(printWriter);
                System.exit(DB2Jcc.getAppropriateExitCode(-1));
            } else {
                object2 = no.a("10516", "13709");
                DB2Jcc.printlnMessageIfCommandLine(printWriter, (String)object2);
                string = connection.getMetaData().getDatabaseProductVersion().substring(0, 5);
                try {
                    if (this.sql_ == null || this.sql_ == " ") {
                        object = string.startsWith("IFX") ? connection.prepareStatement(DEFAULT_INFORMIX_SQL) : connection.prepareStatement(DEFAULT_OTHER_SQL);
                        resultSet = object.executeQuery();
                        resultSet.close();
                        object.close();
                    } else {
                        object = connection.prepareStatement(this.sql_);
                        object.execute();
                        object.close();
                    }
                }
                catch (SQLException sQLException) {
                    int n2 = sQLException.getErrorCode();
                    if (n2 == -805) {
                        Integer n3 = new Integer(n2);
                        String string2 = no.a("10519", new Object[]{n3}, "13710");
                        DB2Jcc.printlnMessageIfCommandLine(printWriter, string2);
                        DB2Jcc.printUsage(printWriter);
                        System.exit(DB2Jcc.getAppropriateExitCode(-1));
                    }
                    Integer n4 = new Integer(n2);
                    String string3 = no.a("10515", new Object[]{n4}, "13711");
                    DB2Jcc.printlnMessageIfCommandLine(printWriter, string3);
                    DB2Jcc.printUsage(printWriter);
                    System.exit(DB2Jcc.getAppropriateExitCode(-1));
                }
            }
            connection.commit();
            object2 = connection.getMetaData();
            System.out.println("DB product version = " + object2.getDatabaseProductVersion());
            System.out.println("DB product name = " + object2.getDatabaseProductName());
            System.out.println("DB URL = " + object2.getURL());
            System.out.println("DB Drivername = " + object2.getDriverName());
            string = c.a("os.name");
            System.out.println("DB OS Name = " + string);
            object = new String[]{"TABLE"};
            resultSet = object2.getTables(null, null, "%", (String[])object);
            resultSet.close();
            connection.commit();
            connection.close();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -4472) {
                if (((pc)((Object)sQLException)).getErrorKey() == ErrorKey.FAILURE_LOADING_NATIVE_LIBRARY) {
                    System.out.println("\n");
                    String string = no.a("10520", new Object[]{sQLException.getSQLState()}, "13712");
                    String string4 = string + no.a(null, "10212", new Object[]{String.valueOf(sQLException.getErrorCode()), sQLException.getSQLState(), sQLException.getMessage()}, "13713");
                    DB2Jcc.printlnMessageIfCommandLine(printWriter, string4);
                    DB2Jcc.printUsage(printWriter);
                    System.exit(DB2Jcc.getAppropriateExitCode(-1));
                }
            }
            String string = no.a("10512", new Object[]{sQLException.getSQLState()}, "13714");
            String string5 = string + no.a(null, "10212", new Object[]{String.valueOf(sQLException.getErrorCode()), sQLException.getSQLState(), sQLException.getMessage()}, "13715");
            DB2Jcc.printlnMessageIfCommandLine(printWriter, string5);
            DB2Jcc.printUsage(printWriter);
            System.exit(DB2Jcc.getAppropriateExitCode(-1));
        }
    }

    protected Connection getConnectionForConnect(PrintWriter printWriter) throws SQLException {
        Connection connection = null;
        Properties properties = new Properties();
        if (this.user_ != null) {
            properties.put("user", this.user_);
        }
        if (this.password_ != null) {
            properties.put("password", this.password_);
        }
        if (printWriter != null && this.tracing_ != 0) {
            properties.put("traceLevel", Integer.toString(this.tracing_));
            DriverManager.setLogWriter(printWriter);
        }
        DB2Driver dB2Driver = null;
        try {
            dB2Driver = (DB2Driver)Class.forName("com.ibm.db2.jcc.DB2Driver").newInstance();
        }
        catch (Exception exception) {
            String string = no.a("1067", "13716");
            DB2Jcc.printlnMessageIfCommandLine(printWriter, string);
            System.exit(DB2Jcc.getAppropriateExitCode(-1));
        }
        connection = (Connection)dB2Driver.connect(this.url_, properties);
        return connection;
    }

    private static void printlnMessageIfCommandLine(PrintWriter printWriter, String string) {
        if (printWriter != null) {
            printWriter.println(string);
        }
    }

    public static int getAppropriateExitCode(int n2) {
        String string = GlobalProperties.c("os.name");
        return string != null && string.toUpperCase().indexOf("WINDOWS") != -1 ? n2 : 1;
    }

    private static boolean checkMatchingValueForOption(String string, int n2, int n3, PrintWriter printWriter) {
        if (n2 < n3) {
            return true;
        }
        printWriter.println(no.a("10187", new Object[]{string}, "13717"));
        DB2Jcc.printUsage(printWriter);
        return false;
    }

    private static void printUsage(PrintWriter printWriter) {
        System.out.println(no.a(null, "1046", new Object[]{"IBM Data Server Driver for JDBC and SQLJ"}, "10053"));
    }

    public static void callErrorSql(PrintWriter printWriter, String string) {
        printWriter.println(no.a("10517", new Object[]{string}, "13718"));
        DB2Jcc.printUsage(printWriter);
        System.exit(DB2Jcc.getAppropriateExitCode(-1));
    }
}

