/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.core;

import com.simba.cassandra.cassandra.commons.SettingsKeys;
import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.core.CDBJDBCEnvironment;
import com.simba.cassandra.cassandra.core.CDBJDBCPropertyKey;
import com.simba.cassandra.cassandra.core.CDBJDBCStatement;
import com.simba.cassandra.cassandra.core.ssl.CDBJDBCTrustManager;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.dsi.core.impl.DSIConnection;
import com.simba.cassandra.dsi.core.impl.DSILogger;
import com.simba.cassandra.dsi.core.interfaces.IStatement;
import com.simba.cassandra.dsi.core.utilities.ConnSettingRequestMap;
import com.simba.cassandra.dsi.core.utilities.ConnSettingResponseMap;
import com.simba.cassandra.dsi.core.utilities.PropertyUtilities;
import com.simba.cassandra.dsi.core.utilities.Variant;
import com.simba.cassandra.dsi.exceptions.BadAuthException;
import com.simba.cassandra.jdbc.common.CommonCoreUtils;
import com.simba.cassandra.jdbc.common.ProductInfoHandler;
import com.simba.cassandra.shaded.datastax.driver.core.Cluster;
import com.simba.cassandra.shaded.datastax.driver.core.ConsistencyLevel;
import com.simba.cassandra.shaded.datastax.driver.core.Host;
import com.simba.cassandra.shaded.datastax.driver.core.HostDistance;
import com.simba.cassandra.shaded.datastax.driver.core.PoolingOptions;
import com.simba.cassandra.shaded.datastax.driver.core.ProtocolVersion;
import com.simba.cassandra.shaded.datastax.driver.core.QueryOptions;
import com.simba.cassandra.shaded.datastax.driver.core.RemoteEndpointAwareJdkSSLOptions;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSet;
import com.simba.cassandra.shaded.datastax.driver.core.Row;
import com.simba.cassandra.shaded.datastax.driver.core.Session;
import com.simba.cassandra.shaded.datastax.driver.core.SniSSLOptions;
import com.simba.cassandra.shaded.datastax.driver.core.SocketOptions;
import com.simba.cassandra.shaded.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.simba.cassandra.shaded.datastax.driver.core.policies.LatencyAwarePolicy;
import com.simba.cassandra.shaded.datastax.driver.core.policies.LoadBalancingPolicy;
import com.simba.cassandra.shaded.datastax.driver.core.policies.RoundRobinPolicy;
import com.simba.cassandra.shaded.datastax.driver.core.policies.TokenAwarePolicy;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.Warning;
import com.simba.cassandra.support.WarningCode;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class CDBJDBCConnection
extends DSIConnection {
    private static int s_connectionID = 0;
    private static final String LOG_PREFIX_NAME = "CassandraJDBC_connection_";
    private final String[] DEFAULT_SSL_CIPHER_SUITES = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"};
    private CDBJDBCConnectionSettings m_settings = null;
    protected ILogger m_log;
    private Cluster m_cluster;
    private Session m_session;
    private ProductInfoHandler m_productInfoHandler;

    public CDBJDBCConnection(CDBJDBCEnvironment cDBJDBCEnvironment) throws ErrorException {
        super(cDBJDBCEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), cDBJDBCEnvironment);
        ++s_connectionID;
        String string = "2.0";
        this.m_productInfoHandler = new ProductInfoHandler("SimbaApacheCassandraJDBCDriver.lic", "Simba Apache Cassandra JDBC Driver", string, CDBJDBCDriver.class);
    }

    @Override
    public void beginTransaction() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    @Override
    public void commit() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_cluster) {
            this.m_cluster.close();
        }
    }

    @Override
    public void connect(ConnSettingRequestMap connSettingRequestMap) throws ErrorException, BadAuthException {
        Object object;
        Object object2;
        CommonCoreUtils.logConnectionFunctionEntrance(this.getConnectionLog(), connSettingRequestMap, 2, 0, 4, 1004);
        this.m_productInfoHandler.validateLicense();
        this.getConnectionSettings(connSettingRequestMap);
        Cluster.Builder builder = Cluster.builder();
        if (2 == this.m_settings.m_authMech) {
            if (null != this.m_settings.m_secureConnectionBundlePath) {
                try {
                    object2 = new File(this.m_settings.m_secureConnectionBundlePath);
                    builder.withCloudSecureConnectBundle((File)object2);
                }
                catch (Exception exception) {
                    ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.CONN_GENERAL_ERR.name(), "Cannot find the file: " + this.m_settings.m_secureConnectionBundlePath);
                    errorException.initCause(exception);
                    throw errorException;
                }
            } else {
                try {
                    object2 = new URL(this.m_settings.m_secureConnectionBundleURL);
                    builder.withCloudSecureConnectBundle((URL)object2);
                }
                catch (Exception exception) {
                    ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.CONN_GENERAL_ERR.name(), "Invalid SecureConnectionBundleUrl");
                    errorException.initCause(exception);
                    throw errorException;
                }
            }
        } else {
            builder.addContactPoint(this.m_settings.m_host);
            builder.withPort(this.m_settings.m_port);
        }
        object2 = new QueryOptions();
        ((QueryOptions)object2).setConsistencyLevel(this.m_settings.m_tunableConsistency);
        builder.withQueryOptions((QueryOptions)object2);
        if (1 == this.m_settings.m_authMech || 2 == this.m_settings.m_authMech) {
            builder.withCredentials(this.m_settings.m_uid, this.m_settings.m_pwd);
        }
        if (0 != this.m_settings.m_sslMode && 3 != this.m_settings.m_sslMode) {
            if (2 == this.m_settings.m_authMech) {
                builder.withSSL(SniSSLOptions.builder().withSSLContext(this.getCloudSSLContext()).build());
            } else {
                builder.withSSL(RemoteEndpointAwareJdkSSLOptions.builder().withSSLContext(this.getSSLContext()).withCipherSuites(this.DEFAULT_SSL_CIPHER_SUITES).build());
            }
        }
        LoadBalancingPolicy loadBalancingPolicy = null;
        loadBalancingPolicy = 0 == this.m_settings.m_loadBalancingPolicy ? DCAwareRoundRobinPolicy.builder().build() : new RoundRobinPolicy();
        if (this.m_settings.m_enableTokenAware) {
            object = new TokenAwarePolicy(loadBalancingPolicy);
            loadBalancingPolicy = object;
        }
        if (this.m_settings.m_enableLatencyAware) {
            object = LatencyAwarePolicy.builder(loadBalancingPolicy);
            loadBalancingPolicy = ((LatencyAwarePolicy.Builder)object).build();
        }
        builder.withLoadBalancingPolicy(loadBalancingPolicy);
        object = new SocketOptions();
        if (this.m_settings.m_isConnectionTimeoutSet) {
            ((SocketOptions)object).setConnectTimeoutMillis(this.m_settings.m_connectionTimeout);
        }
        if (this.m_settings.m_isReadTimeoutSet) {
            ((SocketOptions)object).setReadTimeoutMillis(this.m_settings.m_readTimeout);
        }
        if (this.m_settings.m_isConnectionTimeoutSet || this.m_settings.m_isReadTimeoutSet) {
            builder.withSocketOptions((SocketOptions)object);
        }
        this.m_cluster = builder.build();
        try {
            this.m_session = null != this.m_settings.m_defaultKeyspace ? this.m_cluster.connect(this.m_settings.m_defaultKeyspace) : this.m_cluster.connect();
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.CONN_GENERAL_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        if (SettingsKeys.CDB_DEFAULT_CONCURRENT_REQUESTS_LIMIT == this.m_settings.m_concurrentRequestsLimit) {
            PoolingOptions poolingOptions = this.m_cluster.getConfiguration().getPoolingOptions();
            ProtocolVersion protocolVersion = this.m_cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
            if (ProtocolVersion.V2 != protocolVersion) {
                poolingOptions.setMaxRequestsPerConnection(HostDistance.LOCAL, 32768);
                poolingOptions.setMaxRequestsPerConnection(HostDistance.REMOTE, 2000);
            }
            for (Host host : this.m_cluster.getMetadata().getAllHosts()) {
                HostDistance hostDistance = loadBalancingPolicy.distance(host);
                int n = poolingOptions.getMaxConnectionsPerHost(hostDistance);
                int n2 = poolingOptions.getMaxRequestsPerConnection(hostDistance);
                int n3 = poolingOptions.getMaxQueueSize();
                this.m_settings.m_concurrentRequestsLimit += n * n2 + n3;
                LogUtilities.logInfo("Host Datacenter: " + host.getDatacenter(), this.getConnectionLog());
                LogUtilities.logInfo("Host Rack: " + host.getRack(), this.getConnectionLog());
                LogUtilities.logInfo("Host Cassandra Version: " + host.getCassandraVersion(), this.getConnectionLog());
                LogUtilities.logInfo("Host State: " + host.getState(), this.getConnectionLog());
                LogUtilities.logInfo("MaxConnections for Host " + host.getAddress() + ": " + n, this.getConnectionLog());
                LogUtilities.logInfo("MaxRequestsPerConnection for Host " + host.getAddress() + ": " + n2, this.getConnectionLog());
                LogUtilities.logInfo("MaxQueueSize for Host " + host.getAddress() + ": " + n3, this.getConnectionLog());
            }
            LogUtilities.logInfo("Concurrent Requests Limit for the cluster is set to: " + this.m_settings.m_concurrentRequestsLimit, this.getConnectionLog());
        }
        this.setDefaultProperties();
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new CDBJDBCStatement(this);
    }

    @Override
    public void disconnect() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (null != this.m_cluster) {
            this.m_cluster.close();
        }
    }

    @Override
    protected void doReset() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_log) {
            this.m_log = new DSILogger(LOG_PREFIX_NAME + Integer.toString(s_connectionID));
            this.m_log.setLocale(this.getLocale());
        }
        return this.m_log;
    }

    public CDBJDBCConnectionSettings getConnectionSettings() {
        return this.m_settings;
    }

    public Session getSession() {
        return this.m_session;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        if (null == this.m_settings) {
            this.getConnectionSettings(connSettingRequestMap);
        }
        for (String string : CDBJDBCPropertyKey.getRequiredKeys(this.m_settings)) {
            this.verifyRequiredSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        for (String string : CDBJDBCPropertyKey.getOptionalKeys(this.m_settings)) {
            this.verifyOptionalSetting(string, connSettingRequestMap, connSettingResponseMap);
        }
        return connSettingResponseMap;
    }

    private void getConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        String[] stringArray;
        int n;
        String[] stringArray2;
        int n2;
        int n3;
        this.m_settings = new CDBJDBCConnectionSettings();
        Variant variant = null;
        variant = this.getOptionalSetting("AuthMech", connSettingRequestMap);
        if (null != variant) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (SettingsKeys.AUTH_MECHS.contains(n2)) {
                    this.m_settings.m_authMech = n2;
                    if (1 == n2) {
                        this.m_settings.m_uid = this.getRequiredSetting("UID", connSettingRequestMap).getString();
                        this.m_settings.m_pwd = this.getRequiredSetting("PWD", connSettingRequestMap).getString();
                    }
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 for authentication off, 1 for authentication on, ");
                stringBuilder.append("2 for Secure Connection Bundle.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append(this.m_settings.m_authMech);
                stringArray2 = new String[]{variant.getString(), "AuthMech", stringBuilder.toString()};
                this.postWarning(stringArray2);
            }
            LogUtilities.logInfo("AuthMech is set to: " + this.m_settings.m_authMech, this.getConnectionLog());
        }
        if (2 == this.m_settings.m_authMech) {
            variant = this.getOptionalSetting("SecureConnectionBundlePath", connSettingRequestMap);
            if (null != variant) {
                this.m_settings.m_secureConnectionBundlePath = variant.getString();
                LogUtilities.logInfo("SecureConnectionBundlePath is set to: " + this.m_settings.m_secureConnectionBundlePath, this.getConnectionLog());
            }
            if (null != (variant = this.getOptionalSetting("SecureConnectionBundleUrl", connSettingRequestMap))) {
                this.m_settings.m_secureConnectionBundleURL = variant.getString();
                LogUtilities.logInfo("SecureConnectionBundleUrl is set to: " + this.m_settings.m_secureConnectionBundleURL, this.getConnectionLog());
            }
            if (null == this.m_settings.m_secureConnectionBundlePath && null == this.m_settings.m_secureConnectionBundleURL) {
                this.getRequiredSetting("SecureConnectionBundlePath", connSettingRequestMap);
            }
            this.m_settings.m_uid = this.getRequiredSetting("UID", connSettingRequestMap).getString();
            this.m_settings.m_pwd = this.getRequiredSetting("PWD", connSettingRequestMap).getString();
            this.m_settings.m_sslMode = 3;
        }
        this.m_settings.m_batchType = SettingsKeys.CDB_DEFAULT_BATCH_TYPE;
        this.m_settings.m_host = 2 == this.m_settings.m_authMech ? null : this.getRequiredSetting("Host", connSettingRequestMap).getString();
        this.m_settings.m_port = 9042;
        variant = this.getOptionalSetting("Port", connSettingRequestMap);
        if (null != variant) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (1 <= n2 && 65535 >= n2) {
                    this.m_settings.m_port = n2;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("numbers from 1 to ");
                stringBuilder.append(65535);
                stringBuilder.append(". Falling back to default value ");
                stringBuilder.append(this.m_settings.m_port);
                stringArray2 = new String[]{variant.getString(), "Port", stringBuilder.toString()};
                this.postWarning(stringArray2);
            }
            LogUtilities.logInfo("Port is set to: " + this.m_settings.m_port, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("BatchLimit", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (0 < n2) {
                    this.m_settings.m_batchLimit = n2;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Should be greater than 0");
                stringBuilder.append(". Falling back to default value ");
                stringBuilder.append(this.m_settings.m_batchLimit);
                stringArray2 = new String[]{variant.getString(), "BatchLimit", stringBuilder.toString()};
                this.postWarning(stringArray2);
            }
            LogUtilities.logInfo("Batch Limit is set to : " + this.m_settings.m_batchLimit, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("BinaryColumnLength", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (0x4000000 < n2 || 0 == n2) {
                    this.m_settings.m_binaryColumnLength = 0x4000000;
                    n3 = 1;
                } else if (255 > n2) {
                    this.m_settings.m_binaryColumnLength = 255;
                    n3 = 1;
                } else {
                    this.m_settings.m_binaryColumnLength = n2;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("numbers from ");
                stringBuilder.append(255);
                stringBuilder.append(" to ");
                stringBuilder.append(0x4000000);
                stringBuilder.append(" or 0 for maximum column length. Falling back to value ");
                stringBuilder.append(this.m_settings.m_binaryColumnLength);
                stringArray2 = new String[]{variant.getString(), "BinaryColumnLength", stringBuilder.toString()};
                this.postWarning(stringArray2);
            }
            LogUtilities.logInfo("Binary Column Length is set to: " + this.m_settings.m_binaryColumnLength, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("ConcurrentRequestsLimit", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (0 < n2) {
                    this.m_settings.m_concurrentRequestsLimit = n2;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Should be greater than 0");
                stringBuilder.append(". Falling back to default value ");
                stringBuilder.append(this.m_settings.m_concurrentRequestsLimit);
                stringArray2 = new String[]{variant.getString(), "ConcurrentRequestsLimit", stringBuilder.toString()};
                this.postWarning(stringArray2);
            }
            LogUtilities.logInfo("Concurrent Requests Limit is set to: " + this.m_settings.m_concurrentRequestsLimit, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("DecimalColumnPrecision", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getShort();
                if (0 < n2 && Short.MAX_VALUE >= n2) {
                    this.m_settings.m_decimalColumnPrecision = (short)n2;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("numbers from 1 to ");
                stringBuilder.append(Short.MAX_VALUE);
                stringBuilder.append(". Falling back to default value ");
                stringBuilder.append(this.m_settings.m_decimalColumnPrecision);
                stringArray2 = new String[]{variant.getString(), "DecimalColumnPrecision", stringBuilder.toString()};
                this.postWarning(stringArray2);
            }
            LogUtilities.logInfo("Cassandra Decimal type column precision is set to: " + this.m_settings.m_decimalColumnPrecision, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("DecimalColumnScale", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getShort();
                if (0 < n2 && Short.MAX_VALUE >= n2) {
                    this.m_settings.m_decimalColumnScale = (short)n2;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("numbers from 1 to ");
                stringBuilder.append(Short.MAX_VALUE);
                stringBuilder.append(". Falling back to default value ");
                stringBuilder.append(this.m_settings.m_decimalColumnScale);
                stringArray2 = new String[]{variant.getString(), "DecimalColumnScale", stringBuilder.toString()};
                this.postWarning(stringArray2);
            }
            LogUtilities.logInfo("Cassandra Decimal type column scale is set to: " + this.m_settings.m_decimalColumnScale, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("DefaultKeyspace", connSettingRequestMap))) {
            this.m_settings.m_defaultKeyspace = variant.getString();
            LogUtilities.logInfo("Default Keyspace is set to : " + this.m_settings.m_defaultKeyspace, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("EnableAsynchronousWrites", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (0 == n2 || 1 == n2) {
                    this.m_settings.m_enableAsynchronousWrites = n2 == 1;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 to disable asynchronous writes, ");
                stringBuilder.append("1 to enable asynchronous writes.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append(this.m_settings.m_enableAsynchronousWrites ? 1 : 0);
                stringArray2 = new String[]{variant.getString(), "EnableAsynchronousWrites", stringBuilder.toString()};
                this.postWarning(stringArray2);
            }
            LogUtilities.logInfo("Enable Asynchronous Writes is set to : " + this.m_settings.m_enableAsynchronousWrites, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("EnableCaseSensitive", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (0 == n2 || 1 == n2) {
                    this.m_settings.m_enableCaseSensitive = n2 == 1;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 to disable case sensitive, ");
                stringBuilder.append("1 to enable case sensitive.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append(this.m_settings.m_enableCaseSensitive ? 1 : 0);
                stringArray2 = new String[]{variant.getString(), "EnableCaseSensitive", stringBuilder.toString()};
                this.postWarning(stringArray2);
            }
            LogUtilities.logInfo("Enable Case Sensitive is set to: " + this.m_settings.m_enableCaseSensitive, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("EnableLatencyAware", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (0 == n2 || 1 == n2) {
                    this.m_settings.m_enableLatencyAware = n2 == 1;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 to disable the use of LatencyAwarePolicy, ");
                stringBuilder.append("1 to use LatencyAwarePolicy as the parent policy.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append(this.m_settings.m_enableLatencyAware ? 1 : 0);
                stringArray2 = new String[]{variant.getString(), "EnableLatencyAware", stringBuilder.toString()};
                this.postWarning(stringArray2);
            }
            LogUtilities.logInfo("Enable Latency Aware is set to: " + this.m_settings.m_enableLatencyAware, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("EnablePaging", connSettingRequestMap))) {
            block162: {
                n3 = 0;
                try {
                    n2 = variant.getInt();
                    if (0 == n2 || 1 == n2) {
                        boolean bl = this.m_settings.m_enablePaging = n2 == 1;
                        if (!this.m_settings.m_enablePaging || null == (variant = this.getOptionalSetting("RowsPerPage", connSettingRequestMap))) break block162;
                        boolean bl2 = false;
                        try {
                            n = variant.getInt();
                            if (0 < n && 1000000 >= n) {
                                this.m_settings.m_rowsPerPage = n;
                            } else if (1000000 < n) {
                                this.m_settings.m_rowsPerPage = 1000000;
                                bl2 = true;
                            } else {
                                bl2 = true;
                            }
                        }
                        catch (Exception exception) {
                            bl2 = true;
                        }
                        if (bl2) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("numbers from 1 to ");
                            stringBuilder.append(1000000);
                            stringBuilder.append(". Falling back to value ");
                            stringBuilder.append(this.m_settings.m_rowsPerPage);
                            stringArray = new String[]{variant.getString(), "RowsPerPage", stringBuilder.toString()};
                            this.postWarning(stringArray);
                        }
                        break block162;
                    }
                    n3 = 1;
                }
                catch (Exception exception) {
                    n3 = 1;
                }
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 to disable paging, 1 to enable paging.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append(this.m_settings.m_enablePaging ? 1 : 0);
                String[] stringArray3 = new String[]{variant.getString(), "EnablePaging", stringBuilder.toString()};
                this.postWarning(stringArray3);
            }
            LogUtilities.logInfo("Enable Paging is set to: " + this.m_settings.m_enablePaging, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("EnableTokenAware", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (0 == n2 || 1 == n2) {
                    this.m_settings.m_enableTokenAware = n2 == 1;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 to disable the use of TokenAwarePolicy, ");
                stringBuilder.append("1 to use TokenAwarePolicy as the parent policy.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append(this.m_settings.m_enableTokenAware ? 1 : 0);
                String[] stringArray4 = new String[]{variant.getString(), "EnableTokenAware", stringBuilder.toString()};
                this.postWarning(stringArray4);
            }
            LogUtilities.logInfo("Enable Token Aware is set to: " + this.m_settings.m_enableTokenAware, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("FlattenUDTColumn", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (0 == n2 || 1 == n2) {
                    this.m_settings.m_flattenUDTColumn = n2 == 1;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 to not flatten UDT Column.");
                stringBuilder.append("1 to flatten UDT Column.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append(this.m_settings.m_flattenUDTColumn ? 1 : 0);
                String[] stringArray5 = new String[]{variant.getString(), "FlattenUDTColumn", stringBuilder.toString()};
                this.postWarning(stringArray5);
            }
            LogUtilities.logInfo("Flatten UDT Column is set to : " + this.m_settings.m_flattenUDTColumn, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("LoadBalancingPolicy", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (SettingsKeys.LOAD_BALANCING_POLICY.contains(n2)) {
                    this.m_settings.m_loadBalancingPolicy = n2;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 for DCAwareRoundRobinPolicy, 1 for RoundRobinPolicy.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append(this.m_settings.m_loadBalancingPolicy);
                String[] stringArray6 = new String[]{variant.getString(), "LoadBalancingPolicy", stringBuilder.toString()};
                this.postWarning(stringArray6);
            }
            LogUtilities.logInfo("Load Balancing is set to : " + this.m_settings.m_loadBalancingPolicy, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("QueryMode", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (SettingsKeys.QUERY_MODES.contains(n2)) {
                    this.m_settings.m_queryMode = n2;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 for SQL with CQL fallback, 1 for CQL, 2 for SQL.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append(this.m_settings.m_queryMode);
                String[] stringArray7 = new String[]{variant.getString(), "QueryMode", stringBuilder.toString()};
                this.postWarning(stringArray7);
            }
            LogUtilities.logInfo("Query Mode is set to : " + this.m_settings.m_queryMode, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("SSLMode", connSettingRequestMap))) {
            n3 = this.m_settings.m_sslMode;
            n2 = 0;
            try {
                n3 = variant.getInt();
            }
            catch (Exception exception) {
                n2 = 1;
            }
            if (SettingsKeys.SSL_MODES.contains(n3)) {
                this.m_settings.m_sslMode = n3;
                LogUtilities.logInfo("SSL Mode is set to: " + this.m_settings.m_sslMode, this.getConnectionLog());
                if (3 != this.m_settings.m_sslMode && 2 != this.m_settings.m_sslMode && 2 == this.m_settings.m_authMech) {
                    ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), new String[]{variant.getString(), "SSLMode", "2 or 3 when Cloud Secure Connection Bundle is selected for AuthMech"});
                    throw errorException;
                }
                if (0 != this.m_settings.m_sslMode) {
                    variant = this.getOptionalSetting("SSLTruststorePath", connSettingRequestMap);
                    if (null != variant) {
                        this.m_settings.m_sslTruststorePath = variant.getString();
                        LogUtilities.logInfo("SSL Truststore Path is set to: " + this.m_settings.m_sslTruststorePath, this.getConnectionLog());
                    }
                    if (null != (variant = this.getOptionalSetting("UseSslIdentityCheck", connSettingRequestMap))) {
                        boolean bl = false;
                        try {
                            n = variant.getInt();
                            if (0 == n || 1 == n) {
                                this.m_settings.m_sslIdentityCheck = n == 1;
                            } else {
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            bl = true;
                        }
                        if (bl) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("0 to disable SSL identity check, ");
                            stringBuilder.append("1 to enable SSL identity check.");
                            stringBuilder.append(" Falling back to default value ");
                            stringBuilder.append(this.m_settings.m_sslIdentityCheck ? 1 : 0);
                            stringArray = new String[]{variant.getString(), "UseSslIdentityCheck", stringBuilder.toString()};
                            this.postWarning(stringArray);
                        }
                        LogUtilities.logInfo("SSL Identity Check is set to: " + this.m_settings.m_sslIdentityCheck, this.getConnectionLog());
                    }
                    if (2 == this.m_settings.m_sslMode) {
                        variant = this.getOptionalSetting("SSLKeystorePath", connSettingRequestMap);
                        if (null != variant) {
                            this.m_settings.m_sslKeystorePath = variant.getString();
                            LogUtilities.logInfo("SSL Keystore Path is set to: " + this.m_settings.m_sslKeystorePath, this.getConnectionLog());
                        }
                        if (null != (variant = this.getOptionalSetting("SSLTruststorePwd", connSettingRequestMap))) {
                            this.m_settings.m_sslTruststorePwd = variant.getString();
                        }
                        if (null != (variant = this.getOptionalSetting("SSLKeystorePwd", connSettingRequestMap))) {
                            this.m_settings.m_sslKeystorePwd = variant.getString();
                        }
                    }
                }
            } else {
                n2 = 1;
            }
            if (n2 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 to disable SSL, ");
                stringBuilder.append("1 for one-way SSL, ");
                stringBuilder.append("2 for two-way SSL, ");
                stringBuilder.append("3 for Secure Connection Bundle Default.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append(this.m_settings.m_sslMode);
                String[] stringArray8 = new String[]{variant.getString(), "SSLMode", stringBuilder.toString()};
                this.postWarning(stringArray8);
            }
        }
        if (null != (variant = this.getOptionalSetting("StringColumnLength", connSettingRequestMap))) {
            n3 = 0;
            try {
                n2 = variant.getInt();
                if (0x4000000 < n2 || 0 == n2) {
                    this.m_settings.m_stringColumnLength = 0x4000000;
                    n3 = 1;
                } else if (255 > n2) {
                    this.m_settings.m_stringColumnLength = 255;
                    n3 = 1;
                } else {
                    this.m_settings.m_stringColumnLength = n2;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (1 == n3) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("numbers from ");
                stringBuilder.append(255);
                stringBuilder.append(" to ");
                stringBuilder.append(0x4000000);
                stringBuilder.append(" or 0 for maximum column length.");
                stringBuilder.append(" Falling back to value ");
                stringBuilder.append(this.m_settings.m_stringColumnLength);
                String[] stringArray9 = new String[]{variant.getString(), "StringColumnLength", stringBuilder.toString()};
                this.postWarning(stringArray9);
            }
            LogUtilities.logInfo("String Column Length is set to : " + this.m_settings.m_stringColumnLength, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("TunableConsistency", connSettingRequestMap))) {
            n3 = 0;
            try {
                int n4 = variant.getInt();
                if (SettingsKeys.TUNABLE_CONSISTENCY_LEVELS.contains(n4)) {
                    this.m_settings.m_tunableConsistency = this.getConsistencyLevel(n4);
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 for consistency ANY, 1 for consistency ONE, ");
                stringBuilder.append("2 for consistency TWO, 3 for consistency THREE, ");
                stringBuilder.append("4 for consistency QUORUM, 5 for consistency ALL, ");
                stringBuilder.append("6 for consistency LOCAL_QUORUM, 7 for consistency EACH_QUORUM, ");
                stringBuilder.append("10 for consistency LOCAL_ONE.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append((Object)this.m_settings.m_tunableConsistency);
                String[] stringArray10 = new String[]{variant.getString(), "TunableConsistency", stringBuilder.toString()};
                this.postWarning(stringArray10);
            }
            LogUtilities.logInfo("Tunable Consistency is set to : " + (Object)((Object)this.m_settings.m_tunableConsistency), this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("VarintColumnPrecision", connSettingRequestMap))) {
            n3 = 0;
            try {
                short s = variant.getShort();
                if (0 < s && Short.MAX_VALUE >= s) {
                    this.m_settings.m_varintColumnPrecision = s;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("numbers from 1 to ");
                stringBuilder.append(Short.MAX_VALUE);
                stringBuilder.append(". Falling back to default value ");
                stringBuilder.append(this.m_settings.m_varintColumnPrecision);
                String[] stringArray11 = new String[]{variant.getString(), "VarintColumnPrecision", stringBuilder.toString()};
                this.postWarning(stringArray11);
            }
            LogUtilities.logInfo("Cassandra Varint type column precision is set to: " + this.m_settings.m_varintColumnPrecision, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("VTTableNameSeparator", connSettingRequestMap))) {
            this.m_settings.m_vtTableNameSeparator = variant.getString();
        }
        if (null != (variant = this.getOptionalSetting("EnableNullInsert", connSettingRequestMap))) {
            n3 = 0;
            try {
                int n5 = variant.getInt();
                if (0 == n5 || 1 == n5) {
                    this.m_settings.m_enableNullInsert = n5 == 1;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("0 to disable Null inserts, ");
                stringBuilder.append("1 to enable Null inserts.");
                stringBuilder.append(" Falling back to default value ");
                stringBuilder.append(this.m_settings.m_enableNullInsert ? 1 : 0);
                String[] stringArray12 = new String[]{variant.getString(), "EnableNullInsert", stringBuilder.toString()};
                this.postWarning(stringArray12);
            }
            LogUtilities.logInfo("Enable null insert is set to : " + this.m_settings.m_enableNullInsert, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("ConnectTimeoutMillis", connSettingRequestMap))) {
            n3 = 0;
            try {
                int n6 = variant.getInt();
                if (0 < n6 && Integer.MAX_VALUE >= n6) {
                    this.m_settings.m_connectionTimeout = n6;
                    this.m_settings.m_isConnectionTimeoutSet = true;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("numbers from 1 to ");
                stringBuilder.append(Integer.MAX_VALUE);
                stringBuilder.append(". Falling back to default value ");
                stringBuilder.append(this.m_settings.m_connectionTimeout);
                String[] stringArray13 = new String[]{variant.getString(), "ConnectTimeoutMillis", stringBuilder.toString()};
                this.postWarning(stringArray13);
            }
            LogUtilities.logInfo("Cassandra connection timeout is set to: " + this.m_settings.m_connectionTimeout, this.getConnectionLog());
        }
        if (null != (variant = this.getOptionalSetting("ReadTimeoutMillis", connSettingRequestMap))) {
            n3 = 0;
            try {
                int n7 = variant.getInt();
                if (0 < n7 && Integer.MAX_VALUE >= n7) {
                    this.m_settings.m_readTimeout = n7;
                    this.m_settings.m_isReadTimeoutSet = true;
                } else {
                    n3 = 1;
                }
            }
            catch (Exception exception) {
                n3 = 1;
            }
            if (n3 != 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("numbers from 1 to ");
                stringBuilder.append(Integer.MAX_VALUE);
                stringBuilder.append(". Falling back to default value ");
                stringBuilder.append(this.m_settings.m_readTimeout);
                String[] stringArray14 = new String[]{variant.getString(), "ReadTimeoutMillis", stringBuilder.toString()};
                this.postWarning(stringArray14);
            }
            LogUtilities.logInfo("Cassandra read timeout is set to: " + this.m_settings.m_readTimeout, this.getConnectionLog());
        }
    }

    private ConsistencyLevel getConsistencyLevel(int n) {
        switch (n) {
            case 0: {
                return ConsistencyLevel.ANY;
            }
            case 1: {
                return ConsistencyLevel.ONE;
            }
            case 2: {
                return ConsistencyLevel.TWO;
            }
            case 3: {
                return ConsistencyLevel.THREE;
            }
            case 4: {
                return ConsistencyLevel.QUORUM;
            }
            case 5: {
                return ConsistencyLevel.ALL;
            }
            case 6: {
                return ConsistencyLevel.LOCAL_QUORUM;
            }
            case 7: {
                return ConsistencyLevel.EACH_QUORUM;
            }
            case 10: {
                return ConsistencyLevel.LOCAL_ONE;
            }
        }
        return null;
    }

    private String getReleaseVersion() throws ErrorException {
        String string = null;
        this.m_cluster.getConfiguration().getQueryOptions().setConsistencyLevel(ConsistencyLevel.ALL);
        Session session = this.m_cluster.newSession();
        ResultSet resultSet = session.execute("select release_version from system.local");
        List list = resultSet.all();
        if (list.size() != 1) {
            throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.DRIVER_DEFAULT_PROP_ERR.name());
        }
        string = ((Row)list.get(0)).getString(0);
        session.close();
        this.m_cluster.getConfiguration().getQueryOptions().setConsistencyLevel(this.m_settings.m_tunableConsistency);
        return string;
    }

    private SSLContext getCloudSSLContext() throws ErrorException {
        Object object;
        FileInputStream fileInputStream;
        SSLContext sSLContext = null;
        if (2 != this.m_settings.m_sslMode || null == this.m_settings.m_sslKeystorePath || null == this.m_settings.m_sslTruststorePath) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.CONN_GENERAL_ERR.name(), "Invalid SSL connection properties");
            throw errorException;
        }
        try {
            sSLContext = SSLContext.getInstance("TLS");
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.CONN_GENERAL_ERR.name(), "The protocol TLS is not supported");
            errorException.initCause(exception);
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        String string = this.m_settings.m_sslTruststorePath;
        String string2 = this.m_settings.m_sslTruststorePwd;
        String string3 = this.m_settings.m_sslKeystorePath;
        String string4 = this.m_settings.m_sslKeystorePwd;
        char[] cArray = null == string2 ? null : string2.toCharArray();
        char[] cArray2 = null == string4 ? null : string4.toCharArray();
        TrustManagerFactory trustManagerFactory = null;
        KeyManagerFactory keyManagerFactory = null;
        try {
            fileInputStream = new FileInputStream(string);
            object = KeyStore.getInstance("JKS");
            ((KeyStore)object).load(fileInputStream, cArray);
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)object);
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error loading the TrustStore");
            errorException.initCause(exception);
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        try {
            fileInputStream = new FileInputStream(string3);
            object = KeyStore.getInstance("JKS");
            ((KeyStore)object).load(fileInputStream, cArray2);
            keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init((KeyStore)object, cArray2);
        }
        catch (Exception exception) {
            object = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error loading the KeyStore");
            ((Throwable)object).initCause(exception);
            LogUtilities.logError((ErrorException)object, this.m_log);
            throw object;
        }
        try {
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
        }
        catch (Exception exception) {
            object = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error initializing SSL context");
            ((Throwable)object).initCause(exception);
            LogUtilities.logError((ErrorException)object, this.m_log);
            throw object;
        }
        return sSLContext;
    }

    private SSLContext getSSLContext() throws ErrorException {
        SSLContext sSLContext = null;
        try {
            Object object;
            KeyManager[] keyManagerArray;
            sSLContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagerArray = null;
            char[] cArray = null;
            String string = this.m_settings.m_sslTruststorePath;
            String string2 = this.m_settings.m_sslTruststorePwd;
            if (null != string) {
                keyManagerArray = new FileInputStream(string);
                object = KeyStore.getInstance(KeyStore.getDefaultType());
                if (null != string2) {
                    cArray = string2.toCharArray();
                }
                ((KeyStore)object).load((InputStream)keyManagerArray, cArray);
            }
            if (!this.m_settings.m_sslIdentityCheck) {
                keyManagerArray = new CDBJDBCTrustManager();
                trustManagerArray = new TrustManager[]{keyManagerArray};
            } else {
                keyManagerArray = new CDBJDBCTrustManager(this.m_settings.m_host);
                trustManagerArray = new TrustManager[]{keyManagerArray};
            }
            keyManagerArray = null;
            object = null;
            if (this.m_settings.m_sslMode == 2) {
                String string3 = this.m_settings.m_sslKeystorePath;
                String string4 = this.m_settings.m_sslKeystorePwd;
                if (null != string3) {
                    FileInputStream fileInputStream = new FileInputStream(string3);
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    if (null != string4) {
                        object = string4.toCharArray();
                    }
                    keyStore.load(fileInputStream, (char[])object);
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(keyStore, (char[])object);
                    keyManagerArray = keyManagerFactory.getKeyManagers();
                }
            }
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.CONN_GENERAL_ERR.name(), "Error loading the truststore or keystore");
            errorException.initCause(exception);
            LogUtilities.logError(errorException, this.m_log);
            throw errorException;
        }
        return sSLContext;
    }

    private void postWarning(String[] stringArray) {
        this.getWarningListener().postWarning(new Warning(WarningCode.INVALID_CONNECTION_STRING_ATTRIBUTE, 101, CDBJDBCMessageKey.CONN_INVALID_PROPERTY_VALUE.name(), stringArray));
    }

    @Override
    public void rollback() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    private void setDefaultProperties() throws ErrorException {
        String string = "N";
        char c = '\u0000';
        try {
            PropertyUtilities.setCatalogSupport(this, true);
            PropertyUtilities.setReadOnly(this, false);
            PropertyUtilities.setSavepointSupport(this, false);
            PropertyUtilities.setSchemaSupport(this, true);
            PropertyUtilities.setStoredProcedureSupport(this, false);
            this.setProperty(101, new Variant(0, "CassandraJDBC"));
            this.setProperty(41, new Variant(0, "Cassandra"));
            String string2 = this.getReleaseVersion();
            this.setProperty(42, new Variant(0, string2));
            if (null != this.m_settings.m_uid) {
                this.setProperty(139, new Variant(0, this.m_settings.m_uid));
            }
            this.setProperty(87, new Variant(0, "N"));
            if (this.m_settings.m_enableCaseSensitive) {
                this.setProperty(57, new Variant(2, Character.valueOf('\u0003')));
            } else {
                this.setProperty(57, new Variant(2, Character.valueOf('\u0002')));
            }
            this.setProperty(96, new Variant(0, ""));
            this.setProperty(136, new Variant(2, Character.valueOf('\u0001')));
            this.setProperty(45, new Variant(3, 2L));
            this.setProperty(137, new Variant(3, 2L));
            this.setProperty(26, new Variant(3, 2L));
            this.setProperty(65, new Variant(3, new Long(0x4000000L)));
            this.setProperty(81, new Variant(2, Character.valueOf('\u0000')));
            this.setProperty(34, new Variant(4, 1L));
            this.setProperty(33, new Variant(4, 1L));
            if (this.m_settings.m_queryMode == 1) {
                this.setProperty(104, new Variant(3, 0L));
                this.setProperty(90, new Variant(3, 0L));
                this.setProperty(135, new Variant(3, 0L));
                this.setProperty(131, new Variant(3, 0L));
                this.setProperty(6, new Variant(3, 576L));
                this.setProperty(103, new Variant(2, Character.valueOf(c)));
                this.setProperty(105, new Variant(2, Character.valueOf(c)));
                this.setProperty(55, new Variant(0, string));
                this.setProperty(92, new Variant(2, Character.valueOf(c)));
                this.setProperty(56, new Variant(2, Character.valueOf(c)));
                this.setProperty(63, new Variant(0, string));
                this.setProperty(138, new Variant(2, Character.valueOf(c)));
            }
        }
        catch (Exception exception) {
            throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.CONN_DEFAULT_PROP_ERR.name(), (Throwable)exception);
        }
    }
}

