/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.core.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.X509TrustManager;

public class CDBJDBCTrustManager
implements X509TrustManager {
    private boolean m_validating = false;
    private boolean m_allowSelfSigned = true;
    private boolean m_certNamesMismatch = false;
    private String m_host;

    public CDBJDBCTrustManager() {
    }

    public CDBJDBCTrustManager(String string) {
        this.m_validating = true;
        this.m_host = string;
    }

    public CDBJDBCTrustManager(boolean bl, boolean bl2, String string) {
        this.m_validating = true;
        this.m_allowSelfSigned = bl;
        this.m_certNamesMismatch = !bl2;
        this.m_host = string;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (this.m_validating) {
            boolean bl;
            String string2 = x509CertificateArray[0].getSubjectX500Principal().getName();
            boolean bl2 = false;
            if (x509CertificateArray[0].getIssuerDN().equals(x509CertificateArray[0].getSubjectDN())) {
                bl2 = true;
            }
            if (!(bl = this.verify(string2, bl2))) {
                throw new CertificateException("The certificate chain is not verified.");
            }
        }
    }

    private boolean verify(String string, boolean bl) {
        if (this.m_certNamesMismatch && this.m_allowSelfSigned && bl) {
            return true;
        }
        if (!this.m_allowSelfSigned && bl) {
            return false;
        }
        String string2 = "";
        try {
            LdapName ldapName = new LdapName(string);
            for (Rdn rdn : ldapName.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                string2 = rdn.getValue().toString();
                break;
            }
        }
        catch (InvalidNameException invalidNameException) {
            return false;
        }
        return this.matchName(string2);
    }

    private boolean matchName(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n2 < this.m_host.length()) {
            if (Character.toUpperCase(string.charAt(n)) == Character.toUpperCase(this.m_host.charAt(n2))) {
                ++n;
                ++n2;
                continue;
            }
            if (string.charAt(n) != '*') break;
            while (this.m_host.charAt(n2) != '.' && n2 < this.m_host.length()) {
                ++n2;
            }
            ++n;
        }
        if (n == string.length() && n2 == this.m_host.length()) {
            bl = true;
        }
        return bl;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

