/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.CDBJDBCColumnMetadata;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.cassandra.utils.CDBJDBCDataTypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.cassandra.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.exceptions.JDBCMessageKey;
import com.simba.cassandra.jdbc.common.CommonResultSet;
import com.simba.cassandra.shaded.datastax.driver.core.CodecRegistry;
import com.simba.cassandra.shaded.datastax.driver.core.ColumnDefinitions;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSet;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSetFuture;
import com.simba.cassandra.shaded.datastax.driver.core.Row;
import com.simba.cassandra.shaded.datastax.driver.core.TupleValue;
import com.simba.cassandra.shaded.datastax.driver.core.TypeCodec;
import com.simba.cassandra.shaded.datastax.driver.core.UDTValue;
import com.simba.cassandra.shaded.datastax.driver.core.UserType;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CDBJDBCNativeResultSet
extends CommonResultSet {
    protected Row m_currentRow;
    protected ILogger m_log;
    protected List<ColumnMetadata> m_metadata = new ArrayList<ColumnMetadata>();
    protected String m_query;
    protected ResultSetFuture m_resultSetFuture;
    protected ResultSet m_resultSet;
    protected CDBJDBCConnectionSettings m_settings;
    protected Map<Integer, UDTColumn> m_udtColumns = new HashMap<Integer, UDTColumn>();

    public CDBJDBCNativeResultSet(ILogger iLogger, ResultSetFuture resultSetFuture, String string, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) {
        this.m_log = iLogger;
        this.m_resultSetFuture = resultSetFuture;
        this.m_query = string;
        this.m_settings = cDBJDBCConnectionSettings;
    }

    public Row getCurrentRowValue() {
        return this.m_currentRow;
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        ColumnMetadata columnMetadata = null;
        try {
            columnMetadata = this.m_metadata.get(n);
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(JDBCMessageKey.INVALID_COLUMN_INDEX.name(), new String[]{String.valueOf(n)});
            errorException.initCause(exception);
            throw errorException;
        }
        short s = columnMetadata.getTypeMetadata().getType();
        return CDBJDBCDataTypeUtilities.convertCassValueToSqlData(n, dataWrapper, l, l2, s, this.m_currentRow);
    }

    public boolean getData(int n, CDBJDBCColumnMetadata cDBJDBCColumnMetadata, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        Object object = null;
        UDTColumn uDTColumn = this.m_udtColumns.get(n);
        UDTValue uDTValue = uDTColumn.m_udtValue;
        Integer n2 = cDBJDBCColumnMetadata.getUDTFieldIndex();
        DataType dataType = cDBJDBCColumnMetadata.getUDTFieldType();
        short s = cDBJDBCColumnMetadata.getTypeMetadata().getType();
        if (null != uDTValue) {
            if (uDTValue.isNull(n2)) {
                dataWrapper.setNull(s);
                return false;
            }
        } else {
            dataWrapper.setNull(s);
            return false;
        }
        object = this.getFieldDataFromUDTValue(cDBJDBCColumnMetadata, uDTValue);
        if (DataType.Name.UDT == dataType.getName()) {
            String string = null;
            UDTValue uDTValue2 = (UDTValue)object;
            string = CDBJDBCDataTypeUtilities.UDTToString(uDTValue2);
            return DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
        }
        if (DataType.Name.TUPLE == dataType.getName()) {
            String string = null;
            TupleValue tupleValue = (TupleValue)object;
            string = CDBJDBCDataTypeUtilities.TupleToString(tupleValue);
            return DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
        }
        return CDBJDBCDataTypeUtilities.convertCassSubValueToSqlData(dataWrapper, l, l2, s, dataType.getName(), object);
    }

    public ResultSetFuture getResultSetFuture() {
        return this.m_resultSetFuture;
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return -1L;
    }

    public ArrayList<ColumnMetadata> getSelectColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null == this.m_metadata || 0 == this.m_metadata.size()) {
            this.getResultSetMetadata();
        }
        return (ArrayList)this.m_metadata;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null == this.m_resultSet) {
            this.getResultSet();
        }
        return !this.m_resultSet.isExhausted();
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return false;
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        super.close();
        this.m_resultSetFuture.cancel(true);
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        int n;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (null == this.m_resultSet) {
            this.getResultSet();
        }
        if (null == this.m_metadata || 0 == this.m_metadata.size()) {
            this.getResultSetMetadata();
        }
        if (!this.hasMoreRows()) {
            return false;
        }
        this.m_currentRow = this.m_resultSet.one();
        if (0 < this.m_udtColumns.size()) {
            this.initializeDataForUDTColumns();
        }
        if ((n = this.m_resultSet.getAvailableWithoutFetching()) <= 100 && !this.m_resultSet.isFullyFetched()) {
            LogUtilities.logDebug(n + " result left, prefetching more", this.m_log);
            this.m_resultSet.fetchMoreResults();
        }
        return true;
    }

    public void setResultSetFuture(ResultSetFuture resultSetFuture) {
        this.m_resultSetFuture = resultSetFuture;
    }

    @Override
    public boolean supportsHasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return true;
    }

    protected Object getFieldDataFromUDTValue(CDBJDBCColumnMetadata cDBJDBCColumnMetadata, UDTValue uDTValue) {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        Object object = null;
        Integer n = cDBJDBCColumnMetadata.getUDTFieldIndex();
        DataType dataType = cDBJDBCColumnMetadata.getUDTFieldType();
        if (null != uDTValue) {
            if (uDTValue.isNull(n)) {
                return null;
            }
            TypeCodec typeCodec = new CodecRegistry().codecFor(dataType);
            object = uDTValue.get((int)n, typeCodec);
        }
        return object;
    }

    protected void getResultSet() throws ErrorException {
        try {
            this.m_resultSet = (ResultSet)this.m_resultSetFuture.get();
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.QUERY_EXE_GENERAL_ERR.name(), new String[]{exception.getMessage(), this.m_query});
            errorException.initCause(exception);
            throw errorException;
        }
    }

    protected void getResultSetMetadata() throws ErrorException {
        if (null == this.m_resultSet) {
            this.getResultSet();
        }
        ColumnDefinitions columnDefinitions = this.m_resultSet.getColumnDefinitions();
        int n = 0;
        for (ColumnDefinitions.Definition definition : columnDefinitions.asList()) {
            this.m_metadata.add(CDBJDBCDataTypeUtilities.createColumn(definition, this.m_settings));
            if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == definition.getType().getName()) {
                UDTColumn uDTColumn = new UDTColumn((UserType)definition.getType());
                this.m_udtColumns.put(n, uDTColumn);
            }
            ++n;
        }
    }

    protected void initializeDataForUDTColumns() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        int n = -1;
        UDTColumn uDTColumn = null;
        for (Map.Entry<Integer, UDTColumn> entry : this.m_udtColumns.entrySet()) {
            n = entry.getKey();
            uDTColumn = entry.getValue();
            uDTColumn.m_udtValue = this.m_currentRow.getUDTValue(n);
        }
    }

    @Override
    public boolean getDataNeeded(int n) {
        return false;
    }

    @Override
    public void setDataNeeded(int n, boolean bl) {
    }

    protected class UDTColumn {
        protected UserType m_udtType;
        protected UDTValue m_udtValue = null;

        protected UDTColumn(UserType userType) {
            this.m_udtType = userType;
        }
    }
}

