/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.dataengine.CDBJDBCNativeResultSet;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.CDBJDBCColumnMetadata;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.cassandra.utils.CDBJDBCDataTypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.shaded.datastax.driver.core.CodecRegistry;
import com.simba.cassandra.shaded.datastax.driver.core.ColumnDefinitions;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSetFuture;
import com.simba.cassandra.shaded.datastax.driver.core.TypeCodec;
import com.simba.cassandra.shaded.datastax.driver.core.UDTValue;
import com.simba.cassandra.shaded.datastax.driver.core.UserType;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogLevel;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CDBJDBCResultSet
extends CDBJDBCNativeResultSet {
    private Map<Integer, CollectionCol> m_complexColumns = new HashMap<Integer, CollectionCol>();
    private Iterator<CollectionCol> m_collectionlWalkedIt = null;
    private CollectionCol m_currentCollectionColWalked = null;

    public CDBJDBCResultSet(ILogger iLogger, ResultSetFuture resultSetFuture, String string, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) {
        super(iLogger, resultSetFuture, string, cDBJDBCConnectionSettings);
    }

    @Override
    public boolean getData(int n, CDBJDBCColumnMetadata cDBJDBCColumnMetadata, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        Object object;
        Object object2;
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        if (cDBJDBCColumnMetadata.isUDT() && !cDBJDBCColumnMetadata.isCollection()) {
            return super.getData(n, cDBJDBCColumnMetadata, l, l2, dataWrapper);
        }
        Object object3 = null;
        CollectionCol collectionCol = this.m_complexColumns.get(n);
        Integer n2 = cDBJDBCColumnMetadata.getCollectionIndex();
        boolean bl = false;
        switch (collectionCol.m_dataType.getName()) {
            case LIST: {
                if (null == n2) {
                    dataWrapper.setInteger(collectionCol.m_index);
                    return false;
                }
                if (0 == n2) {
                    object3 = collectionCol.m_currentVal;
                    if (!cDBJDBCColumnMetadata.isUDT()) break;
                    object2 = (UDTValue)object3;
                    object3 = this.getFieldDataFromUDTValue(cDBJDBCColumnMetadata, (UDTValue)object2);
                    break;
                }
                bl = true;
                break;
            }
            case MAP: {
                object2 = (Map.Entry)collectionCol.m_currentVal;
                if (null != object2) {
                    if (0 == n2) {
                        object3 = object2.getKey();
                        if (!cDBJDBCColumnMetadata.isUDT()) break;
                        object = (UDTValue)object3;
                        object3 = this.getFieldDataFromUDTValue(cDBJDBCColumnMetadata, (UDTValue)object);
                        break;
                    }
                    if (1 == n2) {
                        object3 = object2.getValue();
                        if (!cDBJDBCColumnMetadata.isUDT()) break;
                        object = (UDTValue)object3;
                        object3 = this.getFieldDataFromUDTValue(cDBJDBCColumnMetadata, (UDTValue)object);
                        break;
                    }
                    bl = true;
                    break;
                }
                object3 = null;
                break;
            }
            case SET: {
                if (0 == n2) {
                    object3 = collectionCol.m_currentVal;
                    if (!cDBJDBCColumnMetadata.isUDT()) break;
                    object2 = (UDTValue)object3;
                    object3 = this.getFieldDataFromUDTValue(cDBJDBCColumnMetadata, (UDTValue)object2);
                    break;
                }
                bl = true;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            object2 = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.QUERY_EXECUTION_FAIL_ERR.name(), new String[]{this.m_query, "Unexpected error retrieving collection data"});
            throw object2;
        }
        short s = cDBJDBCColumnMetadata.getTypeMetadata().getType();
        object = cDBJDBCColumnMetadata.isUDT() ? cDBJDBCColumnMetadata.getUDTFieldType() : cDBJDBCColumnMetadata.getCollectionElementType();
        return CDBJDBCDataTypeUtilities.convertCassSubValueToSqlData(dataWrapper, l, l2, s, ((DataType)object).getName(), object3);
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        boolean bl = false;
        if (null == this.m_resultSet) {
            this.getResultSet();
        }
        if (null != this.m_currentRow && this.m_complexColumns.size() > 0) {
            bl = this.hasMoreSubRows();
        }
        if (!bl) {
            bl = !this.m_resultSet.isExhausted();
        }
        return bl;
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        boolean bl = false;
        if (null == this.m_resultSet) {
            this.getResultSet();
        }
        if (null == this.m_metadata || 0 == this.m_metadata.size()) {
            this.getResultSetMetadata();
        }
        while (!bl && this.hasMoreRows()) {
            bl = true;
            if (null == this.m_currentRow || !this.hasMoreSubRows()) {
                this.m_currentRow = this.m_resultSet.one();
                this.initializeCurrentComplexCol();
                if (0 < this.m_udtColumns.size()) {
                    this.initializeDataForUDTColumns();
                }
            }
            if (this.m_complexColumns.size() <= 0) continue;
            if (this.hasMoreSubRows()) {
                this.m_currentCollectionColWalked.moveToNextRow();
                continue;
            }
            bl = false;
        }
        int n = this.m_resultSet.getAvailableWithoutFetching();
        if (n <= 100 && !this.m_resultSet.isFullyFetched()) {
            if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_log)) {
                LogUtilities.logDebug(n + " result left, prefetching more", this.m_log);
            }
            this.m_resultSet.fetchMoreResults();
        }
        return bl;
    }

    @Override
    protected void getResultSetMetadata() throws ErrorException {
        if (null == this.m_resultSet) {
            this.getResultSet();
        }
        ColumnDefinitions columnDefinitions = this.m_resultSet.getColumnDefinitions();
        int n = 0;
        for (ColumnDefinitions.Definition definition : columnDefinitions.asList()) {
            Object object;
            this.m_metadata.add(CDBJDBCDataTypeUtilities.createColumn(definition, this.m_settings));
            DataType dataType = definition.getType();
            if (dataType.isCollection()) {
                object = new CollectionCol(dataType);
                this.m_complexColumns.put(n, (CollectionCol)object);
            }
            if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == dataType.getName()) {
                object = new CDBJDBCNativeResultSet.UDTColumn((UserType)dataType);
                this.m_udtColumns.put(n, object);
            }
            ++n;
        }
    }

    private boolean hasMoreSubRows() throws ErrorException {
        boolean bl = false;
        if (null == this.m_currentCollectionColWalked && null != this.m_complexColumns) {
            this.m_collectionlWalkedIt = this.m_complexColumns.values().iterator();
            if (this.m_collectionlWalkedIt.hasNext()) {
                this.m_currentCollectionColWalked = this.m_collectionlWalkedIt.next();
            } else {
                return bl;
            }
        }
        if (this.m_currentCollectionColWalked.hasMoreRows()) {
            bl = true;
        } else if (this.m_collectionlWalkedIt.hasNext()) {
            this.m_currentCollectionColWalked = this.m_collectionlWalkedIt.next();
            bl = this.m_currentCollectionColWalked.hasMoreRows();
        }
        return bl;
    }

    private void initializeCurrentComplexCol() {
        int n = -1;
        CollectionCol collectionCol = null;
        List<DataType> list = null;
        for (Map.Entry<Integer, CollectionCol> entry : this.m_complexColumns.entrySet()) {
            n = entry.getKey();
            collectionCol = entry.getValue();
            collectionCol.m_index = -1;
            list = collectionCol.m_dataType.getTypeArguments();
            collectionCol.m_currentVal = null;
            switch (collectionCol.m_dataType.getName()) {
                case LIST: {
                    TypeCodec typeCodec = new CodecRegistry().codecFor(list.get(0));
                    Object object = this.m_currentRow.getList(n, typeCodec.getJavaType().getRawType());
                    collectionCol.m_iterator = object.iterator();
                    break;
                }
                case MAP: {
                    TypeCodec typeCodec = new CodecRegistry().codecFor(list.get(0));
                    Object object = new CodecRegistry().codecFor(list.get(1));
                    Map map = this.m_currentRow.getMap(n, typeCodec.getJavaType().getRawType(), ((TypeCodec)object).getJavaType().getRawType());
                    collectionCol.m_iterator = map.entrySet().iterator();
                    break;
                }
                case SET: {
                    TypeCodec typeCodec = new CodecRegistry().codecFor(list.get(0));
                    Object object = this.m_currentRow.getSet(n, typeCodec.getJavaType().getRawType());
                    collectionCol.m_iterator = object.iterator();
                    break;
                }
            }
        }
    }

    private class CollectionCol {
        protected DataType m_dataType;
        protected Iterator<?> m_iterator;
        protected int m_index;
        protected Object m_currentVal;

        protected CollectionCol(DataType dataType) {
            this.m_dataType = dataType;
            this.m_iterator = null;
            this.m_currentVal = null;
        }

        protected boolean hasMoreRows() {
            return this.m_iterator.hasNext();
        }

        protected void moveToNextRow() {
            if (this.hasMoreRows()) {
                this.m_currentVal = this.m_iterator.next();
                ++this.m_index;
            }
        }
    }
}

