/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine;

import com.simba.cassandra.cassandra.core.CDBJDBCConnection;
import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.core.CDBJDBCStatement;
import com.simba.cassandra.cassandra.dataengine.CDBJDBCQueryExecutor;
import com.simba.cassandra.cassandra.dataengine.jsql.passdown.CDBJDBCOperationHandlerFactory;
import com.simba.cassandra.cassandra.dataengine.metadata.CDBJDBCCatalogOnlyMetadataSource;
import com.simba.cassandra.cassandra.dataengine.metadata.CDBJDBCCatalogSchemaMetadataSource;
import com.simba.cassandra.cassandra.dataengine.metadata.CDBJDBCColumnsMetadataSource;
import com.simba.cassandra.cassandra.dataengine.metadata.CDBJDBCForeignKeysMetadataSource;
import com.simba.cassandra.cassandra.dataengine.metadata.CDBJDBCPrimaryKeysMetadataSource;
import com.simba.cassandra.cassandra.dataengine.metadata.CDBJDBCTablesMetadataSource;
import com.simba.cassandra.cassandra.dataengine.metadata.CDBJDBCTypeInfoMetadataSource;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.ICDBJDBCTableMetadata;
import com.simba.cassandra.cassandra.dataengine.metadata.utils.CDBJDBCMetadataUtils;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCReadTable;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCWriteTable;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCWriteVirtualTable;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.dsi.core.impl.DSIDriverSingleton;
import com.simba.cassandra.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.simba.cassandra.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.simba.cassandra.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.cassandra.dsi.dataengine.interfaces.IQueryExecutor;
import com.simba.cassandra.dsi.dataengine.interfaces.IResultSet;
import com.simba.cassandra.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.cassandra.dsi.dataengine.utilities.MetadataSourceID;
import com.simba.cassandra.dsi.dataengine.utilities.OrderType;
import com.simba.cassandra.dsi.exceptions.ParsingException;
import com.simba.cassandra.shaded.datastax.driver.core.Cluster;
import com.simba.cassandra.shaded.datastax.driver.core.KeyspaceMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.Metadata;
import com.simba.cassandra.shaded.datastax.driver.core.Session;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.QueryBuilder;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Truncate;
import com.simba.cassandra.sqlengine.SQLEngineGenericContext;
import com.simba.cassandra.sqlengine.aeprocessor.metadatautil.AECoercionProperties;
import com.simba.cassandra.sqlengine.aeprocessor.metadatautil.AEMetadataCoercionHandler;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtOperationHandlerFactory;
import com.simba.cassandra.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.simba.cassandra.sqlengine.dsiext.dataengine.OpenTableType;
import com.simba.cassandra.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.simba.cassandra.sqlengine.dsiext.dataengine.StoredProcedure;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogLevel;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.MessageSourceImpl;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CDBJDBCSQLDataEngine
extends SqlDataEngine {
    private static boolean s_isMessageSourceSet = false;
    private static final String IDENTIFIER_REGEX = "([a-zA-Z][a-zA-Z0-9_]*)";
    private static final Pattern DELETE_ALL = Pattern.compile(CDBJDBCSQLDataEngine.buildDeleteAllPattern(), 2);
    private static final Pattern TRUNCATE_TABLE = Pattern.compile(CDBJDBCSQLDataEngine.buildTruncatePattern(), 2);
    private Cluster m_cluster;
    private CDBJDBCConnection m_connection;
    private int m_fetchSize;
    private boolean m_isDirectExecution;
    private String m_query;
    private CDBJDBCConnectionSettings m_settings;
    private Session m_session;
    private ILogger m_logger;

    public CDBJDBCSQLDataEngine(CDBJDBCStatement cDBJDBCStatement) throws ErrorException {
        super(cDBJDBCStatement);
        LogUtilities.logFunctionEntrance(this.getLog(), cDBJDBCStatement);
        CDBJDBCSQLDataEngine.initMessageSource();
        this.m_logger = cDBJDBCStatement.getLog();
        this.m_connection = (CDBJDBCConnection)cDBJDBCStatement.getParentConnection();
        this.m_settings = this.m_connection.getConnectionSettings();
        this.m_session = this.m_connection.getSession();
        this.m_cluster = this.m_session.getCluster();
        try {
            this.m_fetchSize = cDBJDBCStatement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.QUERY_EXE_GENERAL_ERR.name(), new String[]{exception.getMessage(), ""});
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public ICoercionHandler createCoercionHandler() {
        AECoercionProperties.Builder builder = new AECoercionProperties.Builder();
        builder.maxExactNumPrecision((short)Short.MAX_VALUE);
        builder.defaultExactNumScale(this.m_settings.m_decimalColumnScale);
        return new AEMetadataCoercionHandler(builder.build());
    }

    @Override
    public DSIExtOperationHandlerFactory createOperationHandlerFactory() {
        return new CDBJDBCOperationHandlerFactory(this.m_logger, this.m_settings);
    }

    @Override
    public StoredProcedure openProcedure(String string, String string2, String string3) throws ErrorException {
        return null;
    }

    @Override
    public DSIExtJResultSet openTable(String string, String string2, String string3, OpenTableType openTableType) throws ErrorException {
        List<ICDBJDBCTableMetadata> list;
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{string, string2, string3, openTableType});
        CDBJDBCReadTable cDBJDBCReadTable = null;
        if (null == string || 0 == string.length()) {
            string = "cassandra";
        }
        if ((null == string2 || 0 == string2.length()) && null == (string2 = this.m_session.getLoggedKeyspace())) {
            string2 = "system";
        }
        if (null != (list = this.getTableMetadata(string2, string3)) && 0 < list.size()) {
            ICDBJDBCTableMetadata iCDBJDBCTableMetadata = list.get(0);
            CDBJDBCConnection cDBJDBCConnection = (CDBJDBCConnection)this.getParentStatement().getParentConnection();
            cDBJDBCReadTable = openTableType == OpenTableType.READ_ONLY ? new CDBJDBCReadTable(cDBJDBCConnection, iCDBJDBCTableMetadata, string, string2, string3, this.m_fetchSize, this.m_query, openTableType, this.getLog()) : (list.get(0).isVirtualTable() ? new CDBJDBCWriteVirtualTable(cDBJDBCConnection, iCDBJDBCTableMetadata, string, string2, string3, this.m_fetchSize, this.m_query, openTableType, this.getLog()) : new CDBJDBCWriteTable(cDBJDBCConnection, iCDBJDBCTableMetadata, string, string2, string3, this.m_fetchSize, this.m_query, openTableType, this.getLog()));
        }
        return cDBJDBCReadTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string);
        this.m_query = string;
        while (this.m_query.endsWith(";")) {
            this.m_query = this.m_query.substring(0, this.m_query.length() - 1);
        }
        if (2 != this.m_settings.m_queryMode && 0 != this.m_settings.m_queryMode) return new CDBJDBCQueryExecutor(this.m_query, this.m_settings, this.m_session, this.m_isDirectExecution, this.m_fetchSize, this.getLog());
        String string2 = this.tryTranslate(this.m_query);
        if (null == string2) {
            try {
                if (!LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_logger)) return super.prepare(this.m_query);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Query ");
                stringBuilder.append(this.m_query);
                stringBuilder.append(" is not directly translatable. Using the SQL engine.");
                LogUtilities.logDebug(stringBuilder.toString(), this.m_logger);
                return super.prepare(this.m_query);
            }
            catch (ErrorException errorException) {
                if (2 == this.m_settings.m_queryMode) {
                    throw errorException;
                }
                if (!LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_logger)) return new CDBJDBCQueryExecutor(this.m_query, this.m_settings, this.m_session, this.m_isDirectExecution, this.m_fetchSize, this.getLog());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Error executing query '");
                stringBuilder.append(this.m_query);
                stringBuilder.append("'. Falling back to direct CQL execution");
                stringBuilder.append("SQL execution error was: " + errorException.getLocalizedMessage());
                LogUtilities.logDebug(stringBuilder.toString(), this.m_logger);
                return new CDBJDBCQueryExecutor(this.m_query, this.m_settings, this.m_session, this.m_isDirectExecution, this.m_fetchSize, this.getLog());
            }
        } else {
            if (LogUtilities.shouldLogLevel(LogLevel.DEBUG, this.m_logger)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Translated ");
                stringBuilder.append(this.m_query);
                stringBuilder.append(" to ");
                stringBuilder.append(string2);
                stringBuilder.append(" and executing it directly.");
                LogUtilities.logDebug(stringBuilder.toString(), this.m_logger);
            }
            this.m_query = string2;
        }
        return new CDBJDBCQueryExecutor(this.m_query, this.m_settings, this.m_session, this.m_isDirectExecution, this.m_fetchSize, this.getLog());
    }

    @Override
    public void setDirectExecute() {
        this.m_isDirectExecution = true;
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl) throws ErrorException {
        if (!this.m_settings.m_enableCaseSensitive) {
            arrayList = this.convertFiltersToLowerCase(arrayList);
        }
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl);
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl, OrderType orderType) throws ErrorException {
        if (!this.m_settings.m_enableCaseSensitive) {
            arrayList = this.convertFiltersToLowerCase(arrayList);
        }
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, orderType);
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        IMetadataSource iMetadataSource = null;
        switch (metadataSourceID) {
            case TYPE_INFO: {
                iMetadataSource = new CDBJDBCTypeInfoMetadataSource(this.m_logger, this.m_settings);
                break;
            }
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: {
                iMetadataSource = new CDBJDBCCatalogSchemaMetadataSource(this.m_logger, this.m_cluster.getMetadata(), map, this.m_settings);
                break;
            }
            case CATALOG_ONLY: {
                iMetadataSource = new CDBJDBCCatalogOnlyMetadataSource(this.m_logger);
                break;
            }
            case COLUMNS: {
                iMetadataSource = new CDBJDBCColumnsMetadataSource(this.m_logger, this.m_cluster.getMetadata(), map, this.m_settings);
                break;
            }
            case TABLES: {
                iMetadataSource = new CDBJDBCTablesMetadataSource(this.m_logger, this.m_cluster.getMetadata(), map, this.m_settings);
                break;
            }
            case TABLETYPE_ONLY: {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("TABLE");
                iMetadataSource = new DSITableTypeOnlyMetadataSource(this.getLog(), arrayList);
                break;
            }
            case PRIMARY_KEYS: {
                iMetadataSource = new CDBJDBCPrimaryKeysMetadataSource(this.m_logger, this.m_cluster.getMetadata(), map, this.m_settings);
                break;
            }
            case FOREIGN_KEYS: {
                if (1 == this.m_settings.m_queryMode) {
                    iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
                    break;
                }
                iMetadataSource = new CDBJDBCForeignKeysMetadataSource(this.m_logger, this.m_cluster.getMetadata(), map, this.m_settings);
                break;
            }
            default: {
                iMetadataSource = new DSIEmptyMetadataSource(this.getLog());
            }
        }
        return iMetadataSource;
    }

    private ArrayList<String> convertFiltersToLowerCase(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (null != string) {
                arrayList.add(string.toLowerCase());
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    private List<ICDBJDBCTableMetadata> getTableMetadata(String string, String string2) throws ErrorException {
        KeyspaceMetadata keyspaceMetadata;
        List<ICDBJDBCTableMetadata> list = null;
        Metadata metadata = this.m_session.getCluster().getMetadata();
        List<KeyspaceMetadata> list2 = CDBJDBCMetadataUtils.getSchema(metadata, string, this.m_settings);
        if (0 < list2.size() && null != (keyspaceMetadata = list2.get(0))) {
            this.m_settings = this.m_connection.getConnectionSettings();
            list = CDBJDBCMetadataUtils.getTables(keyspaceMetadata, string2, this.m_settings);
        }
        return list;
    }

    private String tryTranslate(String string) throws ErrorException {
        String string2 = null;
        Matcher matcher = DELETE_ALL.matcher(string);
        Matcher matcher2 = TRUNCATE_TABLE.matcher(string);
        boolean bl = false;
        String string3 = null;
        String string4 = null;
        if (matcher.matches()) {
            string3 = matcher.group(2);
            string4 = matcher.group(3);
            bl = true;
        } else if (matcher2.matches()) {
            string3 = matcher2.group(2);
            string4 = matcher2.group(3);
            bl = true;
        }
        if (bl) {
            ICDBJDBCTableMetadata iCDBJDBCTableMetadata;
            List<ICDBJDBCTableMetadata> list;
            if ((null == string3 || 0 == string3.length()) && null == (string3 = this.m_session.getLoggedKeyspace())) {
                string3 = "system";
            }
            if (null != (list = this.getTableMetadata(string3, string4)) && list.size() > 0 && !(iCDBJDBCTableMetadata = list.get(0)).isVirtualTable()) {
                Truncate truncate = QueryBuilder.truncate(string3, string4);
                string2 = truncate.getQueryString();
            }
        }
        return string2;
    }

    private static String buildDeleteAllPattern() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("delete from ");
        stringBuilder.append("(");
        stringBuilder.append(IDENTIFIER_REGEX);
        stringBuilder.append("{1}\\.){0,2}");
        stringBuilder.append(IDENTIFIER_REGEX);
        stringBuilder.append("{1}");
        return stringBuilder.toString();
    }

    private static String buildTruncatePattern() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("truncate table ");
        stringBuilder.append("(");
        stringBuilder.append(IDENTIFIER_REGEX);
        stringBuilder.append("{1}\\.){0,2}");
        stringBuilder.append(IDENTIFIER_REGEX);
        stringBuilder.append("{1}");
        return stringBuilder.toString();
    }

    private static synchronized void initMessageSource() {
        if (!s_isMessageSourceSet) {
            SQLEngineGenericContext.setDefaultMsgSource((MessageSourceImpl)((CDBJDBCDriver)DSIDriverSingleton.getInstance()).getMessageSource());
            s_isMessageSourceSet = true;
        }
    }
}

