/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.jsql.passdown;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.dataengine.CDBJDBCNativeResultSet;
import com.simba.cassandra.cassandra.dataengine.CDBJDBCResultSet;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCReadTable;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCResultsBase;
import com.simba.cassandra.cassandra.dataengine.utils.CDBJDBCUtils;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.interfaces.IResultSet;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSetFuture;
import com.simba.cassandra.shaded.datastax.driver.core.Row;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;

public class CDBAggregationResult
extends CDBJDBCResultsBase {
    private int m_columnCount;
    private ArrayList<? extends IColumn> m_columnMetadata = null;
    private ILogger m_logger;
    private IResultSet m_resultSet;
    private Row m_currentRow;
    private CDBJDBCConnectionSettings m_settings;
    private CDBJDBCReadTable m_table;

    public CDBAggregationResult(CDBJDBCReadTable cDBJDBCReadTable, ILogger iLogger, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) throws ErrorException {
        super(true);
        LogUtilities.logFunctionEntrance(iLogger, cDBJDBCReadTable, cDBJDBCConnectionSettings);
        this.m_table = cDBJDBCReadTable;
        this.m_logger = iLogger;
        this.m_settings = cDBJDBCConnectionSettings;
        String string = "SELECT COUNT(*) FROM ";
        String string2 = this.m_table.getSchemaName();
        String string3 = this.m_table.getTableName();
        string2 = CDBJDBCUtils.cassNameGenerator(string2, this.m_settings.m_enableCaseSensitive);
        string3 = CDBJDBCUtils.cassNameGenerator(string3, this.m_settings.m_enableCaseSensitive);
        string = string + string2 + "." + string3;
        if (null != this.m_table.getFilter()) {
            string = string + " WHERE " + this.m_table.getFilter();
            string = string + " ALLOW FILTERING";
        }
        ResultSetFuture resultSetFuture = CDBJDBCUtils.executeQuery(this.m_table.getSession(), string, this.m_table.getFetchSize());
        this.m_resultSet = new CDBJDBCResultSet(this.m_logger, resultSetFuture, string, this.m_settings);
        this.m_columnMetadata = this.m_resultSet.getSelectColumns();
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        return this.m_resultSet.getData(0, l, l2, dataWrapper);
    }

    @Override
    public long getRowCount() throws ErrorException {
        return 1L;
    }

    @Override
    public ArrayList<? extends IColumn> getSelectColumns() throws ErrorException {
        return this.m_columnMetadata;
    }

    @Override
    public boolean hasRowCount() {
        return true;
    }

    @Override
    public String getCatalogName() {
        return this.m_table.getCatalogName();
    }

    @Override
    public String getSchemaName() {
        return this.m_table.getSchemaName();
    }

    @Override
    public String getTableName() {
        return this.m_table.getTableName();
    }

    @Override
    public void reset() throws ErrorException {
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl = false;
        bl = this.m_resultSet.moveToNextRow();
        this.m_currentRow = bl ? ((CDBJDBCNativeResultSet)this.m_resultSet).getCurrentRowValue() : null;
        return bl;
    }
}

