/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.jsql.passdown;

import com.simba.cassandra.cassandra.dataengine.jsql.passdown.CDBJDBCVisitResult;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.CDBJDBCColumnMetadata;
import com.simba.cassandra.cassandra.dataengine.utils.CDBJDBCUtils;
import com.simba.cassandra.cassandra.utils.CDBJDBCDataTypeUtilities;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.dataengine.utilities.TypeMetadata;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.AEComparisonType;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENode;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEExistsPredicate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AELikePredicate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AENot;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AENullPredicate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEOr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEQuantifiedComparison;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AENegate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.parser.type.PTLiteralType;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.HashSet;
import java.util.Set;

public class CDBJDBCExtBooleanExprPassdownVisitor
extends AEDefaultVisitor<CDBJDBCVisitResult> {
    private Set<Integer> m_filteredColumnIndexes = new HashSet<Integer>();
    private boolean m_isCaseSensitive = true;
    private int m_parameterSetCount;

    public CDBJDBCExtBooleanExprPassdownVisitor(int n, boolean bl) {
        this.m_parameterSetCount = n;
        this.m_isCaseSensitive = bl;
    }

    @Override
    protected CDBJDBCVisitResult defaultVisit(IAENode iAENode) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidOperationException("Unexpected node visited" + iAENode.getLogString());
    }

    private CDBJDBCVisitResult visit(AEBooleanExpr aEBooleanExpr) {
        try {
            return aEBooleanExpr.acceptVisitor(this);
        }
        catch (ErrorException errorException) {
            return new CDBJDBCVisitResult();
        }
    }

    @Override
    public CDBJDBCVisitResult visit(AEAnd aEAnd) {
        CDBJDBCVisitResult cDBJDBCVisitResult = new CDBJDBCVisitResult();
        CDBJDBCVisitResult cDBJDBCVisitResult2 = this.visit(aEAnd.getLeftOperand());
        CDBJDBCVisitResult cDBJDBCVisitResult3 = this.visit(aEAnd.getRightOperand());
        if (cDBJDBCVisitResult2.isPassDownPossible() || cDBJDBCVisitResult3.isPassDownPossible()) {
            cDBJDBCVisitResult.setFullyProcessed(cDBJDBCVisitResult2.isFullyProcessed() && cDBJDBCVisitResult3.isFullyProcessed());
            cDBJDBCVisitResult.addFilters(cDBJDBCVisitResult2);
            cDBJDBCVisitResult.addFilters(cDBJDBCVisitResult3);
        }
        if (!cDBJDBCVisitResult2.isPassDownPossible() && !cDBJDBCVisitResult3.isPassDownPossible()) {
            cDBJDBCVisitResult.setPassDownNotPossible();
        }
        if (!cDBJDBCVisitResult2.areAllFilterPartsEligibleForPassdown() || !cDBJDBCVisitResult3.areAllFilterPartsEligibleForPassdown()) {
            cDBJDBCVisitResult.setPartPassDownNotPossible();
        }
        return cDBJDBCVisitResult;
    }

    @Override
    public CDBJDBCVisitResult visit(AEComparison aEComparison) {
        CDBJDBCVisitResult cDBJDBCVisitResult = new CDBJDBCVisitResult();
        if (1 == aEComparison.getLeftOperand().getNumChildren() && 1 == aEComparison.getRightOperand().getNumChildren()) {
            AEValueExpr aEValueExpr = (AEValueExpr)aEComparison.getLeftOperand().getChild(0);
            AEValueExpr aEValueExpr2 = (AEValueExpr)aEComparison.getRightOperand().getChild(0);
            if (aEValueExpr2 instanceof AEColumnReference && aEValueExpr instanceof AEColumnReference) {
                cDBJDBCVisitResult.setPassDownNotPossible();
            } else {
                AEColumnReference aEColumnReference = null;
                AEValueExpr aEValueExpr3 = null;
                AEComparisonType aEComparisonType = null;
                if (aEValueExpr instanceof AEColumnReference) {
                    aEColumnReference = (AEColumnReference)aEValueExpr;
                    aEValueExpr3 = aEValueExpr2;
                    aEComparisonType = aEComparison.getComparisonOp();
                } else if (aEValueExpr2 instanceof AEColumnReference) {
                    aEColumnReference = (AEColumnReference)aEValueExpr2;
                    aEValueExpr3 = aEValueExpr;
                    aEComparisonType = aEComparison.getComparisonOp().flip();
                }
                if (aEColumnReference == null || aEValueExpr3 == null || aEComparisonType == null) {
                    cDBJDBCVisitResult.setPassDownNotPossible();
                } else {
                    int n = aEColumnReference.getColumnNum();
                    IColumn iColumn = aEColumnReference.getNamedRelationalExpr().getBaseColumn(n);
                    CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)iColumn;
                    String string = null;
                    if (cDBJDBCColumnMetadata.isPartitionKey() && !cDBJDBCColumnMetadata.isUDT() || cDBJDBCColumnMetadata.isIndex()) {
                        if (aEComparisonType != AEComparisonType.EQUAL || this.m_filteredColumnIndexes.contains(aEColumnReference.getColumnNum())) {
                            cDBJDBCVisitResult.setPassDownNotPossible();
                        } else {
                            string = this.tryToGenerateFilter(aEValueExpr3, cDBJDBCColumnMetadata);
                        }
                    } else if (cDBJDBCColumnMetadata.isClusteringKey() && !cDBJDBCColumnMetadata.isUDT()) {
                        if (aEComparisonType == AEComparisonType.NOT_EQUAL) {
                            cDBJDBCVisitResult.setPassDownNotPossible();
                        } else {
                            string = this.tryToGenerateFilter(aEValueExpr3, cDBJDBCColumnMetadata);
                        }
                    } else {
                        cDBJDBCVisitResult.setPassDownNotPossible();
                    }
                    if (null != string) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(CDBJDBCUtils.cassNameGenerator(aEColumnReference.getName(), this.m_isCaseSensitive));
                        stringBuilder.append(aEComparisonType.toString());
                        stringBuilder.append(string);
                        int n2 = aEColumnReference.getColumnNum();
                        String string2 = aEColumnReference.getName();
                        if (cDBJDBCColumnMetadata.isClusteringKey()) {
                            this.m_filteredColumnIndexes.add(n2);
                            cDBJDBCVisitResult.addClusteringKeysfilter(stringBuilder.toString(), string2, aEComparison);
                        } else if (cDBJDBCColumnMetadata.isPartitionKey()) {
                            this.m_filteredColumnIndexes.add(n2);
                            cDBJDBCVisitResult.addPartitionKeysfilter(stringBuilder.toString(), string2, aEComparison);
                        } else {
                            this.m_filteredColumnIndexes.add(n2);
                            cDBJDBCVisitResult.addIndexfilter(stringBuilder.toString(), aEComparison);
                        }
                    } else {
                        cDBJDBCVisitResult.setPartPassDownNotPossible();
                    }
                }
            }
        } else {
            cDBJDBCVisitResult.setPassDownNotPossible();
        }
        cDBJDBCVisitResult.setFullyProcessed(true);
        return cDBJDBCVisitResult;
    }

    @Override
    public CDBJDBCVisitResult visit(AEExistsPredicate aEExistsPredicate) {
        CDBJDBCVisitResult cDBJDBCVisitResult = new CDBJDBCVisitResult();
        cDBJDBCVisitResult.setPassDownNotPossible();
        cDBJDBCVisitResult.setFullyProcessed(true);
        return cDBJDBCVisitResult;
    }

    @Override
    public CDBJDBCVisitResult visit(AEInPredicate aEInPredicate) {
        CDBJDBCVisitResult cDBJDBCVisitResult = new CDBJDBCVisitResult();
        cDBJDBCVisitResult.setPassDownNotPossible();
        cDBJDBCVisitResult.setFullyProcessed(true);
        return cDBJDBCVisitResult;
    }

    @Override
    public CDBJDBCVisitResult visit(AELikePredicate aELikePredicate) {
        CDBJDBCVisitResult cDBJDBCVisitResult = new CDBJDBCVisitResult();
        cDBJDBCVisitResult.setPassDownNotPossible();
        cDBJDBCVisitResult.setFullyProcessed(true);
        return cDBJDBCVisitResult;
    }

    @Override
    public CDBJDBCVisitResult visit(AENot aENot) {
        CDBJDBCVisitResult cDBJDBCVisitResult = new CDBJDBCVisitResult();
        cDBJDBCVisitResult.setPassDownNotPossible();
        cDBJDBCVisitResult.setFullyProcessed(true);
        return cDBJDBCVisitResult;
    }

    @Override
    public CDBJDBCVisitResult visit(AENullPredicate aENullPredicate) {
        CDBJDBCVisitResult cDBJDBCVisitResult = new CDBJDBCVisitResult();
        cDBJDBCVisitResult.setPassDownNotPossible();
        cDBJDBCVisitResult.setFullyProcessed(true);
        return cDBJDBCVisitResult;
    }

    @Override
    public CDBJDBCVisitResult visit(AEOr aEOr) {
        CDBJDBCVisitResult cDBJDBCVisitResult = new CDBJDBCVisitResult();
        cDBJDBCVisitResult.setPassDownNotPossible();
        cDBJDBCVisitResult.setFullyProcessed(true);
        return cDBJDBCVisitResult;
    }

    @Override
    public CDBJDBCVisitResult visit(AEQuantifiedComparison aEQuantifiedComparison) {
        CDBJDBCVisitResult cDBJDBCVisitResult = new CDBJDBCVisitResult();
        cDBJDBCVisitResult.setPassDownNotPossible();
        cDBJDBCVisitResult.setFullyProcessed(true);
        return cDBJDBCVisitResult;
    }

    private String getLiteralValue(AELiteral aELiteral, boolean bl, CDBJDBCColumnMetadata cDBJDBCColumnMetadata) {
        String string = null;
        if (PTLiteralType.NULL != aELiteral.getLiteralType() && PTLiteralType.TIME != aELiteral.getLiteralType()) {
            DataType dataType = cDBJDBCColumnMetadata.unwrap().getType();
            switch (aELiteral.getLiteralType()) {
                case CHARSTR: {
                    if (DataType.timeuuid() != dataType && DataType.uuid() != dataType && DataType.Name.UDT != dataType.getName() && DataType.Name.TUPLE != dataType.getName()) {
                        string = "'" + aELiteral.getStringValue() + "'";
                        break;
                    }
                    if (DataType.blob() == dataType) {
                        string = "'0x" + aELiteral.getStringValue() + "'";
                        break;
                    }
                    string = aELiteral.getStringValue();
                    break;
                }
                case DATE: 
                case TIMESTAMP: {
                    string = "'" + aELiteral.getStringValue() + "'";
                    break;
                }
                default: {
                    string = bl && (cDBJDBCColumnMetadata.getTypeMetadata().isApproximateNumericType() || cDBJDBCColumnMetadata.getTypeMetadata().isExactNumericType()) ? "-" + aELiteral.getStringValue() : aELiteral.getStringValue();
                    if (DataType.cboolean() != dataType) break;
                    string = string.equals("1") && !bl ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
                }
            }
        }
        return string;
    }

    private String getParam(AEParameter aEParameter, CDBJDBCColumnMetadata cDBJDBCColumnMetadata) {
        String string = null;
        DataWrapper dataWrapper = aEParameter.getInputData();
        if (dataWrapper.isNull()) {
            return null;
        }
        TypeMetadata typeMetadata = cDBJDBCColumnMetadata.getTypeMetadata();
        try {
            switch (typeMetadata.getType()) {
                case -7: 
                case 16: {
                    string = dataWrapper.getBoolean().toString();
                    break;
                }
                case -5: {
                    string = dataWrapper.getBigInt().toString();
                    break;
                }
                case 2: 
                case 3: {
                    string = dataWrapper.getBigInt().toString();
                    break;
                }
                case 6: 
                case 8: {
                    string = dataWrapper.getDouble().toString();
                    break;
                }
                case -6: {
                    string = dataWrapper.getTinyInt().toString();
                    break;
                }
                case 5: {
                    string = dataWrapper.getSmallInt().toString();
                    break;
                }
                case 4: {
                    string = dataWrapper.getInteger().toString();
                    break;
                }
                case -2: {
                    string = CDBJDBCDataTypeUtilities.byteArrayToCassString(dataWrapper.getBinary());
                    break;
                }
                case -3: {
                    string = CDBJDBCDataTypeUtilities.byteArrayToCassString(dataWrapper.getBinary());
                    break;
                }
                case -4: {
                    string = CDBJDBCDataTypeUtilities.byteArrayToCassString(dataWrapper.getBinary());
                    break;
                }
                case 7: {
                    string = dataWrapper.getReal().toString();
                    break;
                }
                case 93: {
                    string = String.valueOf(dataWrapper.getTimestamp().getTime());
                    break;
                }
                case 91: {
                    string = String.valueOf(dataWrapper.getDate().getTime());
                    break;
                }
                case 12: {
                    string = dataWrapper.getVarChar();
                    break;
                }
                case 1: {
                    string = dataWrapper.getChar();
                    break;
                }
                case -1: {
                    string = dataWrapper.getLongVarChar();
                    break;
                }
                default: {
                    string = null;
                    break;
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            string = null;
        }
        return string;
    }

    private String tryToGenerateFilter(AEValueExpr aEValueExpr, CDBJDBCColumnMetadata cDBJDBCColumnMetadata) {
        String string = null;
        AEValueExpr aEValueExpr2 = aEValueExpr;
        boolean bl = false;
        if (aEValueExpr2 instanceof AENegate) {
            aEValueExpr2 = ((AENegate)aEValueExpr2).getOperand();
            bl = true;
        }
        if (aEValueExpr2 instanceof AELiteral) {
            string = this.getLiteralValue((AELiteral)aEValueExpr2, bl, cDBJDBCColumnMetadata);
        }
        if (aEValueExpr2 instanceof AEParameter && this.m_parameterSetCount == 1) {
            string = this.getParam((AEParameter)aEValueExpr2, cDBJDBCColumnMetadata);
        }
        return string;
    }
}

