/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.metadata;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.dataengine.metadata.utils.CDBJDBCMetadataUtils;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.cassandra.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.cassandra.shaded.datastax.driver.core.KeyspaceMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.Metadata;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CDBJDBCCatalogSchemaMetadataSource
implements IMetadataSource {
    private int m_currentIndex = -1;
    private ILogger m_logger;
    private boolean m_hasStartedFetch = false;
    private List<KeyspaceMetadata> m_schemas = new ArrayList<KeyspaceMetadata>();
    private CDBJDBCConnectionSettings m_settings;

    public CDBJDBCCatalogSchemaMetadataSource(ILogger iLogger, Metadata metadata, Map<MetadataSourceColumnTag, String> map, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_settings = cDBJDBCConnectionSettings;
        String string = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
        String string2 = CDBJDBCMetadataUtils.getCatalog(string, this.m_settings);
        if (null != string2) {
            String string3 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
            this.m_schemas = CDBJDBCMetadataUtils.getSchema(metadata, string3, this.m_settings);
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        if (metadataSourceColumnTag == MetadataSourceColumnTag.SCHEMA_NAME) {
            return DSITypeUtilities.outputVarCharStringData(this.m_schemas.get(this.m_currentIndex).getName(), dataWrapper, l, l2);
        }
        if (metadataSourceColumnTag == MetadataSourceColumnTag.CATALOG_NAME) {
            return DSITypeUtilities.outputVarCharStringData("cassandra", dataWrapper, l, l2);
        }
        throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return !this.m_hasStartedFetch;
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_hasStartedFetch) {
            ++this.m_currentIndex;
        } else {
            this.m_hasStartedFetch = true;
            this.m_currentIndex = 0;
        }
        return this.m_currentIndex < this.m_schemas.size();
    }
}

