/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.metadata;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.ICDBJDBCTableMetadata;
import com.simba.cassandra.cassandra.dataengine.metadata.utils.CDBJDBCMetadataUtils;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.cassandra.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.cassandra.dsi.dataengine.utilities.Nullable;
import com.simba.cassandra.dsi.dataengine.utilities.TypeMetadata;
import com.simba.cassandra.dsi.dataengine.utilities.TypeUtilities;
import com.simba.cassandra.shaded.datastax.driver.core.KeyspaceMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.Metadata;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CDBJDBCColumnsMetadataSource
implements IMetadataSource {
    private boolean m_hasStartedFetch = false;
    private int m_currentIndex = 0;
    private List<ColumnInfo> m_columns = new ArrayList<ColumnInfo>();
    private ILogger m_logger;
    private CDBJDBCConnectionSettings m_settings;

    public CDBJDBCColumnsMetadataSource(ILogger iLogger, Metadata metadata, Map<MetadataSourceColumnTag, String> map, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_settings = cDBJDBCConnectionSettings;
        this.initializeData(metadata, map);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get((int)this.m_currentIndex).m_tableCatalog, dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get((int)this.m_currentIndex).m_tableSchema, dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get((int)this.m_currentIndex).m_tableName, dataWrapper, l, l2);
            }
            case COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get((int)this.m_currentIndex).m_columnName, dataWrapper, l, l2);
            }
            case SQL_DATA_TYPE: 
            case DATA_TYPE: {
                dataWrapper.setSmallInt(this.m_columns.get((int)this.m_currentIndex).m_dataType);
                return false;
            }
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get((int)this.m_currentIndex).m_typeName, dataWrapper, l, l2);
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger(this.m_columns.get((int)this.m_currentIndex).m_columnSize);
                return false;
            }
            case BUFFER_LENGTH: {
                dataWrapper.setInteger(this.m_columns.get((int)this.m_currentIndex).m_bufferLength);
                return false;
            }
            case DECIMAL_DIGITS: {
                dataWrapper.setSmallInt(this.m_columns.get((int)this.m_currentIndex).m_decimalDigits);
                return false;
            }
            case NUM_PREC_RADIX: {
                short s = this.m_columns.get((int)this.m_currentIndex).m_dataType;
                if (TypeUtilities.isNumberType(s)) {
                    if (TypeUtilities.isApproximateNumericType(s)) {
                        dataWrapper.setInteger(2L);
                    } else {
                        dataWrapper.setInteger(10L);
                    }
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(this.m_columns.get((int)this.m_currentIndex).m_nullable.ordinal());
                return false;
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get((int)this.m_currentIndex).m_remarks, dataWrapper, l, l2);
            }
            case COLUMN_DEF: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get((int)this.m_currentIndex).m_columnDef, dataWrapper, l, l2);
            }
            case SQL_DATETIME_SUB: {
                short s = this.m_columns.get((int)this.m_currentIndex).m_dataType;
                short s2 = TypeUtilities.getIntervalCodeFromConciseType(s);
                if (0 == s2) {
                    dataWrapper.setNull(5);
                } else {
                    dataWrapper.setSmallInt(s2);
                }
                return false;
            }
            case CHAR_OCTET_LENGTH: {
                short s = this.m_columns.get((int)this.m_currentIndex).m_dataType;
                if (TypeUtilities.isCharacterOrBinaryType(s)) {
                    dataWrapper.setInteger(this.m_columns.get((int)this.m_currentIndex).m_charOctetLength);
                } else {
                    dataWrapper.setNull(4);
                }
                return false;
            }
            case ORDINAL_POSITION: {
                dataWrapper.setInteger(this.m_columns.get((int)this.m_currentIndex).m_ordinalPosition);
                return false;
            }
            case IS_NULLABLE: {
                return DSITypeUtilities.outputVarCharStringData(this.nullableToIsNullable(this.m_columns.get((int)this.m_currentIndex).m_nullable), dataWrapper, l, l2);
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                return false;
            }
            case IS_AUTOINCREMENT: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get((int)this.m_currentIndex).m_isAutoIncrement, dataWrapper, l, l2);
            }
            case IS_GENERATEDCOLUMN: {
                return DSITypeUtilities.outputVarCharStringData(this.m_columns.get((int)this.m_currentIndex).m_isGeneratedColumn, dataWrapper, l, l2);
            }
        }
        throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentIndex + 1 < this.m_columns.size();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_hasStartedFetch) {
            ++this.m_currentIndex;
        } else {
            this.m_hasStartedFetch = true;
            this.m_currentIndex = 0;
        }
        return this.m_currentIndex < this.m_columns.size();
    }

    private void initializeData(Metadata metadata, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
        String string2 = CDBJDBCMetadataUtils.getCatalog(string, this.m_settings);
        if (null != string2) {
            String string3 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
            String string4 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
            String string5 = map.get((Object)MetadataSourceColumnTag.COLUMN_NAME);
            List<KeyspaceMetadata> list = CDBJDBCMetadataUtils.getSchema(metadata, string3, this.m_settings);
            List<Object> list2 = new ArrayList();
            for (KeyspaceMetadata keyspaceMetadata : list) {
                list2 = CDBJDBCMetadataUtils.getTables(keyspaceMetadata, string4, this.m_settings);
                for (ICDBJDBCTableMetadata iCDBJDBCTableMetadata : list2) {
                    int n = 1;
                    for (IColumn iColumn : iCDBJDBCTableMetadata.getColumns(string5)) {
                        TypeMetadata typeMetadata = iColumn.getTypeMetadata();
                        ColumnInfo columnInfo = new ColumnInfo();
                        columnInfo.m_tableCatalog = "cassandra";
                        columnInfo.m_tableSchema = keyspaceMetadata.getName();
                        columnInfo.m_tableName = iCDBJDBCTableMetadata.getName();
                        columnInfo.m_columnName = iColumn.getName();
                        columnInfo.m_dataType = typeMetadata.getType();
                        columnInfo.m_isAutoIncrement = "NO";
                        columnInfo.m_isGeneratedColumn = "NO";
                        columnInfo.m_typeName = typeMetadata.getTypeName().replace("SQL_TYPE_", "").replace("SQL_", "");
                        columnInfo.m_columnSize = TypeUtilities.getColumnSize(typeMetadata, iColumn.getColumnLength());
                        columnInfo.m_bufferLength = TypeUtilities.isCharacterOrBinaryType(columnInfo.m_dataType) ? iColumn.getColumnLength() : (long)TypeUtilities.getSizeInBytes(columnInfo.m_dataType);
                        columnInfo.m_decimalDigits = typeMetadata.getScale();
                        columnInfo.m_nullable = iColumn.getNullable();
                        columnInfo.m_remarks = "";
                        columnInfo.m_columnDef = "";
                        columnInfo.m_charOctetLength = (int)iColumn.getColumnLength();
                        columnInfo.m_ordinalPosition = n++;
                        this.m_columns.add(columnInfo);
                    }
                }
            }
        }
    }

    private String nullableToIsNullable(Nullable nullable) {
        if (nullable == Nullable.NULLABLE) {
            return "YES";
        }
        if (nullable == Nullable.NO_NULLS) {
            return "NO";
        }
        return "";
    }

    private static class ColumnInfo {
        public String m_tableCatalog;
        public String m_tableSchema;
        public String m_tableName;
        public String m_columnName;
        public short m_dataType;
        public String m_typeName;
        public long m_columnSize;
        public long m_bufferLength;
        public int m_decimalDigits;
        public Nullable m_nullable;
        public String m_remarks;
        public String m_columnDef;
        public int m_charOctetLength;
        public int m_ordinalPosition;
        public String m_isAutoIncrement;
        public String m_isGeneratedColumn;

        private ColumnInfo() {
        }
    }
}

