/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.metadata;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.ICDBJDBCTableMetadata;
import com.simba.cassandra.cassandra.dataengine.metadata.utils.CDBJDBCMetadataUtils;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.cassandra.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.cassandra.shaded.datastax.driver.core.KeyspaceMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.Metadata;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.Pair;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CDBJDBCForeignKeysMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private int m_currentIndex = 0;
    private List<ForeignKeyInfo> m_foreignKeys = new ArrayList<ForeignKeyInfo>();
    private boolean m_hasStartedFetch = false;
    private CDBJDBCConnectionSettings m_settings;

    public CDBJDBCForeignKeysMetadataSource(ILogger iLogger, Metadata metadata, Map<MetadataSourceColumnTag, String> map, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_settings = cDBJDBCConnectionSettings;
        this.initializeData(metadata, map);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case PRIMARY_KEY_CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_foreignKeys.get((int)this.m_currentIndex).m_pkTableCatalog, dataWrapper, l, l2);
            }
            case PRIMARY_KEY_SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_foreignKeys.get((int)this.m_currentIndex).m_pkTableSchema, dataWrapper, l, l2);
            }
            case PRIMARY_KEY_TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_foreignKeys.get((int)this.m_currentIndex).m_pkTableName, dataWrapper, l, l2);
            }
            case PRIMARY_KEY_COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_foreignKeys.get((int)this.m_currentIndex).m_pkColumnName, dataWrapper, l, l2);
            }
            case PRIMARY_KEY_NAME: {
                dataWrapper.setNull(12);
                return false;
            }
            case FOREIGN_KEY_CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_foreignKeys.get((int)this.m_currentIndex).m_fkTableCatalog, dataWrapper, l, l2);
            }
            case FOREIGN_KEY_SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_foreignKeys.get((int)this.m_currentIndex).m_fkTableSchema, dataWrapper, l, l2);
            }
            case FOREIGN_KEY_TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_foreignKeys.get((int)this.m_currentIndex).m_fkTableName, dataWrapper, l, l2);
            }
            case FOREIGN_KEY_COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_foreignKeys.get((int)this.m_currentIndex).m_fkColumnName, dataWrapper, l, l2);
            }
            case FOREIGN_KEY_NAME: {
                dataWrapper.setNull(12);
                return false;
            }
            case FOREIGN_KEY_UPDATE_RULE: {
                dataWrapper.setSmallInt(this.m_foreignKeys.get((int)this.m_currentIndex).m_updateRule);
                return false;
            }
            case FOREIGN_KEY_DELETE_RULE: {
                dataWrapper.setSmallInt(this.m_foreignKeys.get((int)this.m_currentIndex).m_deleteRule);
                return false;
            }
            case DEFERRABILITY: {
                dataWrapper.setSmallInt(this.m_foreignKeys.get((int)this.m_currentIndex).m_deferrability);
                return false;
            }
            case KEY_SEQ: {
                dataWrapper.setSmallInt(this.m_foreignKeys.get((int)this.m_currentIndex).m_keySeq);
                return false;
            }
        }
        throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentIndex + 1 < this.m_foreignKeys.size();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_hasStartedFetch) {
            ++this.m_currentIndex;
        } else {
            this.m_hasStartedFetch = true;
            this.m_currentIndex = 0;
        }
        return this.m_currentIndex < this.m_foreignKeys.size();
    }

    private void initializeData(Metadata metadata, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME);
        String string2 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME);
        String string3 = CDBJDBCMetadataUtils.getCatalog(string, this.m_settings);
        String string4 = CDBJDBCMetadataUtils.getCatalog(string2, this.m_settings);
        if (null != string3 || null != string4) {
            String string5 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
            String string6 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME);
            if ((null == string5 || null == string6 || !this.m_settings.m_enableCaseSensitive || string5.equals(string6)) && (null == string5 || null == string6 || this.m_settings.m_enableCaseSensitive || string5.equalsIgnoreCase(string6))) {
                String string7 = null;
                if ((null != string5 || null != string6) && null == (string7 = string5)) {
                    string7 = string6;
                }
                List<KeyspaceMetadata> list = CDBJDBCMetadataUtils.getSchema(metadata, string7, this.m_settings);
                String string8 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
                String string9 = map.get((Object)MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME);
                for (KeyspaceMetadata keyspaceMetadata : list) {
                    List<ICDBJDBCTableMetadata> list2 = null;
                    boolean bl = false;
                    if (null != string8 && null == string9) {
                        if (0 < string8.length()) {
                            list2 = CDBJDBCMetadataUtils.getTables(keyspaceMetadata, string8, this.m_settings);
                            bl = true;
                        }
                    } else if (null != string9 && 0 < string9.length()) {
                        list2 = CDBJDBCMetadataUtils.getTables(keyspaceMetadata, string9, this.m_settings);
                    }
                    if (null == list2 || 0 >= list2.size()) continue;
                    short s = 0;
                    for (ICDBJDBCTableMetadata iCDBJDBCTableMetadata : list2) {
                        Object object;
                        if (bl) {
                            object = iCDBJDBCTableMetadata.getExportedKeys();
                            for (Map.Entry entry : object.entrySet()) {
                                this.addExportedKeyInfos(keyspaceMetadata, iCDBJDBCTableMetadata, entry);
                            }
                            continue;
                        }
                        object = iCDBJDBCTableMetadata.getImportedKeys();
                        Iterator<Object> iterator = object.iterator();
                        while (iterator.hasNext()) {
                            Pair pair = (Pair)iterator.next();
                            short s2 = s;
                            s = (short)(s + 1);
                            this.addImportedKeyInfos(keyspaceMetadata, iCDBJDBCTableMetadata, pair, s2);
                        }
                    }
                }
            }
        }
    }

    private void addImportedKeyInfos(KeyspaceMetadata keyspaceMetadata, ICDBJDBCTableMetadata iCDBJDBCTableMetadata, Pair<String, IColumn> pair, short s) {
        ForeignKeyInfo foreignKeyInfo = new ForeignKeyInfo();
        foreignKeyInfo.m_pkTableCatalog = "cassandra";
        foreignKeyInfo.m_pkTableSchema = keyspaceMetadata.getName();
        foreignKeyInfo.m_pkTableName = pair.value().getTableName();
        foreignKeyInfo.m_pkColumnName = pair.value().getName();
        foreignKeyInfo.m_fkTableCatalog = "cassandra";
        foreignKeyInfo.m_fkTableSchema = keyspaceMetadata.getName();
        foreignKeyInfo.m_fkTableName = iCDBJDBCTableMetadata.getName();
        foreignKeyInfo.m_fkColumnName = pair.key();
        foreignKeyInfo.m_keySeq = s;
        foreignKeyInfo.m_updateRule = Long.valueOf(1L).shortValue();
        foreignKeyInfo.m_deleteRule = Long.valueOf(1L).shortValue();
        foreignKeyInfo.m_deferrability = Long.valueOf(256L).shortValue();
        this.m_foreignKeys.add(foreignKeyInfo);
    }

    private void addExportedKeyInfos(KeyspaceMetadata keyspaceMetadata, ICDBJDBCTableMetadata iCDBJDBCTableMetadata, Map.Entry<String, List<IColumn>> entry) {
        int n = 0;
        for (IColumn iColumn : entry.getValue()) {
            ForeignKeyInfo foreignKeyInfo = new ForeignKeyInfo();
            foreignKeyInfo.m_pkTableCatalog = "cassandra";
            foreignKeyInfo.m_pkTableSchema = keyspaceMetadata.getName();
            foreignKeyInfo.m_pkTableName = iCDBJDBCTableMetadata.getName();
            foreignKeyInfo.m_pkColumnName = entry.getKey();
            foreignKeyInfo.m_fkTableCatalog = "cassandra";
            foreignKeyInfo.m_fkTableSchema = keyspaceMetadata.getName();
            foreignKeyInfo.m_fkTableName = iColumn.getTableName();
            foreignKeyInfo.m_fkColumnName = iColumn.getName();
            n = (short)(n + 1);
            foreignKeyInfo.m_keySeq = (short)n;
            foreignKeyInfo.m_updateRule = Long.valueOf(1L).shortValue();
            foreignKeyInfo.m_deleteRule = Long.valueOf(1L).shortValue();
            foreignKeyInfo.m_deferrability = Long.valueOf(256L).shortValue();
            this.m_foreignKeys.add(foreignKeyInfo);
        }
    }

    private static class ForeignKeyInfo {
        public String m_pkTableCatalog;
        public String m_pkTableSchema;
        public String m_pkTableName;
        public String m_pkColumnName;
        public String m_fkTableCatalog;
        public String m_fkTableSchema;
        public String m_fkTableName;
        public String m_fkColumnName;
        public short m_keySeq;
        public short m_updateRule;
        public short m_deleteRule;
        public short m_deferrability;

        private ForeignKeyInfo() {
        }
    }
}

