/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.metadata;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.ICDBJDBCTableMetadata;
import com.simba.cassandra.cassandra.dataengine.metadata.utils.CDBJDBCMetadataUtils;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.cassandra.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.cassandra.shaded.datastax.driver.core.KeyspaceMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.Metadata;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CDBJDBCTablesMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private String m_currentSchema = null;
    private ICDBJDBCTableMetadata m_currentTable = null;
    private boolean m_hasStartedFetch = false;
    private Iterator<String> m_schemasIterator;
    private CDBJDBCConnectionSettings m_settings;
    private Iterator<ICDBJDBCTableMetadata> m_tableIterator;
    private Map<String, List<ICDBJDBCTableMetadata>> m_tableNamesPerSchemas = new HashMap<String, List<ICDBJDBCTableMetadata>>();

    public CDBJDBCTablesMetadataSource(ILogger iLogger, Metadata metadata, Map<MetadataSourceColumnTag, String> map, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_settings = cDBJDBCConnectionSettings;
        String string = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME);
        String string2 = CDBJDBCMetadataUtils.getCatalog(string, this.m_settings);
        if (null != string2) {
            String string3 = map.get((Object)MetadataSourceColumnTag.SCHEMA_NAME);
            String string4 = map.get((Object)MetadataSourceColumnTag.TABLE_NAME);
            List<KeyspaceMetadata> list = CDBJDBCMetadataUtils.getSchema(metadata, string3, this.m_settings);
            for (KeyspaceMetadata keyspaceMetadata : list) {
                List<ICDBJDBCTableMetadata> list2 = CDBJDBCMetadataUtils.getTables(keyspaceMetadata, string4, this.m_settings);
                if (0 >= list2.size()) continue;
                this.m_tableNamesPerSchemas.put(keyspaceMetadata.getName(), list2);
            }
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData("cassandra", dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentSchema, dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_currentTable.getName(), dataWrapper, l, l2);
            }
            case TABLE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData("TABLE", dataWrapper, l, l2);
            }
            case REMARKS: {
                String string = this.m_currentTable.getComment();
                if (null == string) {
                    string = "";
                }
                return DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
            }
        }
        throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_tableIterator.hasNext() || this.m_schemasIterator.hasNext();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl = false;
        if (this.m_hasStartedFetch) {
            if (!this.m_tableIterator.hasNext() && this.m_schemasIterator.hasNext()) {
                this.m_currentSchema = this.m_schemasIterator.next();
                this.m_tableIterator = this.m_tableNamesPerSchemas.get(this.m_currentSchema).iterator();
            }
        } else {
            this.m_hasStartedFetch = true;
            this.m_schemasIterator = this.m_tableNamesPerSchemas.keySet().iterator();
            if (this.m_schemasIterator.hasNext()) {
                this.m_currentSchema = this.m_schemasIterator.next();
                this.m_tableIterator = this.m_tableNamesPerSchemas.get(this.m_currentSchema).iterator();
            }
        }
        if (null != this.m_tableIterator && this.m_tableIterator.hasNext()) {
            bl = true;
            this.m_currentTable = this.m_tableIterator.next();
        }
        return bl;
    }
}

