/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.metadata.schemamap;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.CDBJDBCColumnMetadata;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.ICDBJDBCTableMetadata;
import com.simba.cassandra.cassandra.dataengine.utils.CDBJDBCUtils;
import com.simba.cassandra.cassandra.utils.CDBJDBCDataTypeUtilities;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.shaded.datastax.driver.core.ColumnMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.TableMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.UserType;
import com.simba.cassandra.support.Pair;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CDBJDBCTableMetadata
implements ICDBJDBCTableMetadata {
    private List<ColumnMetadata> m_collectionColumns;
    private boolean m_hideComplexTypes = false;
    private Map<String, List<IColumn>> m_exportedKeys = new HashMap<String, List<IColumn>>();
    private CDBJDBCConnectionSettings m_settings;
    private TableMetadata m_tableMetadata;

    public CDBJDBCTableMetadata(TableMetadata tableMetadata, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) {
        this.m_tableMetadata = tableMetadata;
        this.m_tableMetadata.getClusteringColumns();
        this.m_settings = cDBJDBCConnectionSettings;
    }

    public void addExportedKey(String string, IColumn iColumn) {
        List<IColumn> list = this.m_exportedKeys.get(string);
        if (null == list) {
            list = new ArrayList<IColumn>();
            this.m_exportedKeys.put(string, list);
        }
        list.add(iColumn);
    }

    public List<IColumn> addUDTColumns(TableMetadata tableMetadata, ColumnMetadata columnMetadata, boolean bl, boolean bl2, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) throws ErrorException {
        String string = this.m_tableMetadata.getKeyspace().getName();
        String string2 = this.m_tableMetadata.getName();
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
        String string3 = null;
        UserType userType = (UserType)columnMetadata.getType();
        Iterator<UserType.Field> iterator = userType.iterator();
        int n = 0;
        UserType.Field field = null;
        String string4 = null;
        DataType dataType = null;
        while (iterator.hasNext()) {
            field = iterator.next();
            string4 = field.getName();
            dataType = field.getType();
            int n2 = CDBJDBCDataTypeUtilities.toSQLType(dataType.getName());
            string3 = columnMetadata.getName() + "_" + string4;
            CDBJDBCColumnMetadata cDBJDBCColumnMetadata = new CDBJDBCColumnMetadata(string, string2, n2, columnMetadata, string3, dataType, bl, bl2, null, n, this.m_settings);
            arrayList.add(cDBJDBCColumnMetadata);
            ++n;
        }
        return arrayList;
    }

    @Override
    public List<IColumn> getColumns(String string) throws ErrorException {
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (null != string) {
            Object object;
            if (!(0 >= string.length() || null == (object = this.m_tableMetadata.getColumn(string = CDBJDBCUtils.cassNameGenerator(string, this.m_settings.m_enableCaseSensitive))) || this.m_hideComplexTypes && ((ColumnMetadata)object).getType().isCollection())) {
                arrayList2.add(object);
            }
        } else {
            arrayList2.addAll(this.m_tableMetadata.getColumns());
        }
        for (ColumnMetadata columnMetadata : arrayList2) {
            Object object;
            if (this.m_hideComplexTypes && columnMetadata.getType().isCollection()) continue;
            boolean bl = this.m_tableMetadata.getPartitionKey().contains(columnMetadata);
            boolean bl2 = this.m_tableMetadata.getClusteringColumns().contains(columnMetadata);
            if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == columnMetadata.getType().getName()) {
                object = this.addUDTColumns(this.m_tableMetadata, columnMetadata, bl, bl2, this.m_settings);
                arrayList.addAll((Collection<IColumn>)object);
                continue;
            }
            object = new CDBJDBCColumnMetadata(this.m_tableMetadata, columnMetadata, bl, bl2, this.m_settings);
            arrayList.add((IColumn)object);
        }
        return arrayList;
    }

    public List<ColumnMetadata> getCollectionColumns() {
        if (null == this.m_collectionColumns) {
            this.m_collectionColumns = new ArrayList<ColumnMetadata>();
            for (ColumnMetadata columnMetadata : this.m_tableMetadata.getColumns()) {
                if (!columnMetadata.getType().isCollection()) continue;
                this.m_collectionColumns.add(columnMetadata);
            }
        }
        return this.m_collectionColumns;
    }

    @Override
    public String getComment() {
        return this.m_tableMetadata.getOptions().getComment();
    }

    @Override
    public List<IColumn> getClusteringKeys() throws ErrorException {
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
        for (ColumnMetadata columnMetadata : this.m_tableMetadata.getClusteringColumns()) {
            Object object;
            if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == columnMetadata.getType().getName()) {
                object = this.addUDTColumns(this.m_tableMetadata, columnMetadata, false, true, this.m_settings);
                arrayList.addAll((Collection<IColumn>)object);
                continue;
            }
            object = new CDBJDBCColumnMetadata(this.m_tableMetadata, columnMetadata, false, true, this.m_settings);
            ((com.simba.cassandra.dsi.dataengine.utilities.ColumnMetadata)object).setTableName(this.m_tableMetadata.getName());
            arrayList.add((IColumn)object);
        }
        return arrayList;
    }

    @Override
    public List<Pair<String, IColumn>> getImportedKeys() throws ErrorException {
        return new ArrayList<Pair<String, IColumn>>();
    }

    @Override
    public String getName() {
        return this.m_tableMetadata.getName();
    }

    @Override
    public List<IColumn> getPartitionKeys() throws ErrorException {
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
        for (ColumnMetadata columnMetadata : this.m_tableMetadata.getPartitionKey()) {
            Object object;
            if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == columnMetadata.getType().getName()) {
                object = this.addUDTColumns(this.m_tableMetadata, columnMetadata, true, false, this.m_settings);
                arrayList.addAll((Collection<IColumn>)object);
                continue;
            }
            object = new CDBJDBCColumnMetadata(this.m_tableMetadata, columnMetadata, true, false, this.m_settings);
            ((com.simba.cassandra.dsi.dataengine.utilities.ColumnMetadata)object).setTableName(this.m_tableMetadata.getName());
            arrayList.add((IColumn)object);
        }
        return arrayList;
    }

    @Override
    public List<IColumn> getPrimaryKeys() throws ErrorException {
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
        arrayList.addAll(this.getPartitionKeys());
        arrayList.addAll(this.getClusteringKeys());
        return arrayList;
    }

    @Override
    public Map<String, List<IColumn>> getExportedKeys() throws ErrorException {
        return this.m_exportedKeys;
    }

    public void hideComplexTypesColumn() {
        this.m_hideComplexTypes = true;
    }

    @Override
    public boolean isVirtualTable() {
        return false;
    }

    public TableMetadata unwrap() {
        return this.m_tableMetadata;
    }
}

