/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.table;

import com.simba.cassandra.cassandra.core.CDBJDBCConnection;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.CDBJDBCColumnMetadata;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.ICDBJDBCTableMetadata;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCReadTable;
import com.simba.cassandra.cassandra.dataengine.utils.CDBJDBCUtils;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.cassandra.utils.CDBJDBCDataTypeUtilities;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.shaded.datastax.driver.core.BatchStatement;
import com.simba.cassandra.shaded.datastax.driver.core.BoundStatement;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.PreparedStatement;
import com.simba.cassandra.shaded.datastax.driver.core.RegularStatement;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSet;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSetFuture;
import com.simba.cassandra.shaded.datastax.driver.core.SimpleStatement;
import com.simba.cassandra.shaded.datastax.driver.core.Statement;
import com.simba.cassandra.shaded.datastax.driver.core.UDTValue;
import com.simba.cassandra.shaded.datastax.driver.core.UserType;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Delete;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Insert;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.QueryBuilder;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Select;
import com.simba.cassandra.shaded.google.common.util.concurrent.FutureCallback;
import com.simba.cassandra.shaded.google.common.util.concurrent.Futures;
import com.simba.cassandra.shaded.google.common.util.concurrent.MoreExecutors;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.simba.cassandra.sqlengine.dsiext.dataengine.OpenTableType;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.IWarningListener;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CDBJDBCWriteTable
extends CDBJDBCReadTable {
    protected List<String> m_asyncErrorMessages = null;
    protected BatchStatement m_batch = null;
    protected List<ResultSetFuture> m_batchResults = null;
    protected Statement m_boundStatement = null;
    protected Object m_cachedCollectionData = null;
    protected DSIExtJResultSet.DMLType m_DMLType;
    protected boolean m_executionFailed = false;
    protected int m_numAsyncRowsFailed = 0;
    protected int m_numConcurrentRequests = 0;
    protected PreparedStatement m_preparedStatement = null;
    protected List<ByteBuffer[]> m_primaryKeysValues = null;
    protected final Object m_requestsLock = new Object();
    protected Map<String, UDTColumn> m_udtColumns;
    protected List<DataWrapper[]> m_upsertValues = null;
    private int m_currentColIndexesSize = 0;
    private String m_insertQuery = null;
    private int m_previousColIndexesSize = 0;
    private PreparedStatement m_preparedSelectStatement = null;
    private Set<Integer> m_upsertedColIndexes = null;

    public CDBJDBCWriteTable(CDBJDBCConnection cDBJDBCConnection, ICDBJDBCTableMetadata iCDBJDBCTableMetadata, String string, String string2, String string3, int n, String string4, OpenTableType openTableType, ILogger iLogger) throws ErrorException {
        super(cDBJDBCConnection, iCDBJDBCTableMetadata, string, string2, string3, n, string4, openTableType, iLogger);
    }

    @Override
    public void appendRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_upsertValues.add(new DataWrapper[this.m_columnMetadata.size()]);
    }

    @Override
    public void deleteRow() throws ErrorException {
        Object object;
        Statement statement;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_preparedStatement) {
            statement = QueryBuilder.delete().from(this.m_schemaName, this.m_cassTableName);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object object2 = null;
            for (Object object3 : this.m_primaryKeyIndices) {
                object = (CDBJDBCColumnMetadata)this.m_columnMetadata.get((Integer)object3);
                object2 = ((CDBJDBCColumnMetadata)object).unwrap().getName();
                if (arrayList.contains(object2)) continue;
                ((Delete)statement).where().and(QueryBuilder.eq((String)object2, QueryBuilder.bindMarker()));
                arrayList.add(object2);
            }
            this.m_preparedStatement = CDBJDBCUtils.prepareQuery(this.m_session, ((RegularStatement)statement).getQueryString());
            LogUtilities.logDebug("Query " + ((RegularStatement)statement).getQueryString(), this.m_logger);
        }
        statement = this.m_preparedStatement.bind();
        int n = 0;
        for (Object object4 : this.m_primaryKeyIndices) {
            Object object3;
            object3 = (CDBJDBCColumnMetadata)this.m_columnMetadata.get((Integer)object4);
            object = ((CDBJDBCColumnMetadata)object3).unwrap().getName();
            if (this.m_columnNameIndexMapping.containsKey(object)) {
                n = (Integer)this.m_columnNameIndexMapping.get(object);
                object4 = n;
            }
            CDBJDBCDataTypeUtilities.bindCqlData((BoundStatement)statement, (Integer)object4, n, this.m_currentRow);
            ++n;
        }
        this.m_boundStatement = statement;
        if (null != this.m_boundStatement) {
            if (this.m_settings.m_enableAsynchronousWrites) {
                this.flushRowAsync(this.m_boundStatement);
            } else {
                this.m_batch.add(this.m_boundStatement);
                if (this.m_batch.size() >= this.m_settings.m_batchLimit) {
                    this.flushBatch();
                }
            }
        }
    }

    @Override
    public void onFinishDMLBatch() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_enableAsynchronousWrites) {
            this.checkForAsyncCompletion();
        } else {
            this.flushBatch();
        }
    }

    @Override
    public void onFinishRowUpdate() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
            this.getPrimaryKeys();
        }
        if (DSIExtJResultSet.DMLType.INSERT == this.m_DMLType && !this.m_settings.m_enableNullInsert) {
            this.m_previousColIndexesSize = this.m_currentColIndexesSize;
            this.m_currentColIndexesSize = this.m_upsertedColIndexes.size();
            if (this.m_currentColIndexesSize > this.m_previousColIndexesSize) {
                this.prepareInsertQuery();
            }
        }
        this.prepareAndBindCachedRow();
        if (null != this.m_boundStatement) {
            if (this.m_settings.m_enableAsynchronousWrites) {
                this.flushRowAsync(this.m_boundStatement);
            } else {
                this.m_batch.add(this.m_boundStatement);
                if (this.m_batch.size() >= this.m_settings.m_batchLimit) {
                    this.flushBatch();
                }
            }
        }
        this.m_upsertValues = new LinkedList<DataWrapper[]>();
        this.m_primaryKeysValues = new ArrayList<ByteBuffer[]>();
        this.m_udtColumns = new HashMap<String, UDTColumn>();
    }

    @Override
    public void onStartDMLBatch(DSIExtJResultSet.DMLType dMLType, long l) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_DMLType = dMLType;
        this.initializeKeyIndexes();
        if (dMLType != DSIExtJResultSet.DMLType.DELETE) {
            this.m_upsertedColIndexes = new HashSet<Integer>();
            this.m_upsertValues = new ArrayList<DataWrapper[]>();
        }
        this.m_primaryKeysValues = new ArrayList<ByteBuffer[]>();
        this.m_udtColumns = new HashMap<String, UDTColumn>();
        if (!this.m_settings.m_enableAsynchronousWrites) {
            this.m_batch = new BatchStatement(BatchStatement.Type.UNLOGGED);
            this.m_batchResults = new ArrayList<ResultSetFuture>();
        } else {
            this.m_asyncErrorMessages = new ArrayList<String>();
        }
    }

    @Override
    public void onStartRowUpdate() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_upsertValues.add(new DataWrapper[this.m_columnMetadata.size()]);
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    @Override
    public void reset() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_resultSet = null;
    }

    @Override
    public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n);
        String string = this.validateData(cDBJDBCColumnMetadata, dataWrapper, bl);
        if (null != string) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.INVALID_QUERY_ERR.name(), new String[]{this.m_originalQuery, string});
            throw errorException;
        }
        DataWrapper dataWrapper2 = new DataWrapper();
        dataWrapper2.copyData(dataWrapper);
        this.manageCurrentData(n, dataWrapper2, bl);
        return false;
    }

    protected void checkForAsyncCompletion() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        while (0 != this.m_numConcurrentRequests) {
            LogUtilities.logDebug("Waiting for all the query requests to complete.", this.m_logger);
        }
        if (this.m_executionFailed) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.m_asyncErrorMessages.size(); ++i) {
                stringBuilder.append(this.m_asyncErrorMessages.get(i));
                if (i == this.m_asyncErrorMessages.size() - 1) continue;
                stringBuilder.append(", ");
            }
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.ASYNC_EXECUTION_FAIL_ERR.name(), new String[]{this.m_originalQuery, Integer.toString(this.m_numAsyncRowsFailed), stringBuilder.toString()});
            throw errorException;
        }
    }

    protected void getPrimaryKeys() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        int n = 0;
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.m_columnMetadata.size()];
        for (Integer n2 : this.m_primaryKeyIndices) {
            CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n2);
            String string = cDBJDBCColumnMetadata.unwrap().getName();
            if (this.m_columnNameIndexMapping.containsKey(string)) {
                n = (Integer)this.m_columnNameIndexMapping.get(string);
            }
            byteBufferArray[n2.intValue()] = this.m_currentRow.getBytesUnsafe(n);
            ++n;
        }
        this.m_primaryKeysValues.add(byteBufferArray);
    }

    protected void initializeKeyIndexes() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        CDBJDBCColumnMetadata cDBJDBCColumnMetadata = null;
        for (int i = 0; i < this.m_columnMetadata.size(); ++i) {
            cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(i);
            if (!cDBJDBCColumnMetadata.isClusteringKey() && !cDBJDBCColumnMetadata.isPartitionKey()) continue;
            this.m_primaryKeyIndices.add(i);
        }
    }

    protected void flushBatch() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ResultSetFuture resultSetFuture = this.m_session.executeAsync(this.m_batch);
        try {
            resultSetFuture.get();
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.QUERY_EXECUTION_FAIL_ERR.name(), new String[]{this.m_originalQuery, exception.getMessage()});
            errorException.initCause(exception);
            throw errorException;
        }
        this.m_batchResults.add(resultSetFuture);
        this.m_batch = new BatchStatement(BatchStatement.Type.UNLOGGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushRowAsync(Statement statement) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        while (true) {
            LogUtilities.logDebug("Limit for concurrent requests: " + this.m_settings.m_concurrentRequestsLimit, this.m_logger);
            if (this.m_settings.m_concurrentRequestsLimit > this.m_numConcurrentRequests) break;
            LogUtilities.logDebug("Maximum limit for concurrent requests reached. Waiting for responses to come back.", this.m_logger);
        }
        Object object = this.m_requestsLock;
        synchronized (object) {
            ++this.m_numConcurrentRequests;
        }
        LogUtilities.logDebug("Number of concurrent requests: " + this.m_numConcurrentRequests, this.m_logger);
        object = this.m_session.executeAsync(statement);
        Futures.addCallback(object, new FutureCallback<ResultSet>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(ResultSet resultSet) {
                Object object = CDBJDBCWriteTable.this.m_requestsLock;
                synchronized (object) {
                    --CDBJDBCWriteTable.this.m_numConcurrentRequests;
                }
                LogUtilities.logDebug("Row successfully inserted/updated", CDBJDBCWriteTable.this.m_logger);
                LogUtilities.logDebug("Number of concurrent requests: " + CDBJDBCWriteTable.this.m_numConcurrentRequests, CDBJDBCWriteTable.this.m_logger);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Throwable throwable) {
                Object object = CDBJDBCWriteTable.this.m_requestsLock;
                synchronized (object) {
                    CDBJDBCWriteTable.this.m_executionFailed = true;
                    ++CDBJDBCWriteTable.this.m_numAsyncRowsFailed;
                    CDBJDBCWriteTable.this.m_asyncErrorMessages.add(throwable.getMessage());
                    --CDBJDBCWriteTable.this.m_numConcurrentRequests;
                }
                LogUtilities.logError("Failed to insert/update the row: " + throwable.getMessage(), CDBJDBCWriteTable.this.m_logger);
                LogUtilities.logError("Number of concurrent requests: " + CDBJDBCWriteTable.this.m_numConcurrentRequests, CDBJDBCWriteTable.this.m_logger);
            }
        }, MoreExecutors.sameThreadExecutor());
        this.m_boundStatement = null;
    }

    protected void manageCurrentData(int n, DataWrapper dataWrapper, boolean bl) {
        this.m_upsertValues.get((int)(this.m_upsertValues.size() - 1))[n] = dataWrapper;
        if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType || !bl && (!dataWrapper.isNull() || this.m_settings.m_enableNullInsert)) {
            this.m_upsertedColIndexes.add(n);
        }
    }

    protected String validateData(CDBJDBCColumnMetadata cDBJDBCColumnMetadata, DataWrapper dataWrapper, boolean bl) {
        boolean bl2;
        String string = null;
        boolean bl3 = bl2 = cDBJDBCColumnMetadata.isClusteringKey() || cDBJDBCColumnMetadata.isPartitionKey();
        if (bl2) {
            if (dataWrapper.isNull()) {
                string = "Null for a primary key is not allowed";
            } else if (!bl && DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
                string = "Updating a primary key column is not supported";
            }
        }
        return string;
    }

    private Statement bindParametersOnStatement(int n) throws ErrorException {
        Object object;
        CDBJDBCColumnMetadata cDBJDBCColumnMetadata;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        BoundStatement boundStatement = this.m_preparedStatement.bind();
        int n2 = 0;
        if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
            for (Integer n3 : this.m_primaryKeyIndices) {
                cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n3);
                object = cDBJDBCColumnMetadata.unwrap().getName();
                if (this.m_columnNameIndexMapping.containsKey(object)) {
                    n2 = (Integer)this.m_columnNameIndexMapping.get(object);
                }
                boundStatement.setBytesUnsafe(n2, this.m_primaryKeysValues.get(n)[n3]);
                ++n2;
            }
        }
        for (Integer n3 : this.m_upsertedColIndexes) {
            Object object2;
            cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n3);
            object = this.m_upsertValues.get(n)[n3];
            String string = cDBJDBCColumnMetadata.unwrap().getName();
            if (cDBJDBCColumnMetadata.isUDT()) {
                this.bindColumnDataToUDTValue((DataWrapper)object, cDBJDBCColumnMetadata);
                if (null == this.m_udtColumns.get((Object)string).m_bindIndex) {
                    this.m_udtColumns.get((Object)string).m_bindIndex = n2;
                } else {
                    n2 = this.m_udtColumns.get((Object)string).m_bindIndex;
                }
                object2 = this.m_udtColumns.get((Object)string).m_udtValue;
                boundStatement.setUDTValue(n2, (UDTValue)object2);
            } else if (null != object) {
                object2 = this.m_preparedStatement.getVariables().getType(n2);
                short s = cDBJDBCColumnMetadata.getTypeMetadata().getType();
                if (DataType.Name.INET == ((DataType)object2).getName()) {
                    String string2 = null;
                    try {
                        string2 = ((DataWrapper)object).getVarChar();
                    }
                    catch (Exception exception) {
                        ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.QUERY_EXECUTION_FAIL_ERR.name(), new String[]{this.m_originalQuery, "SQL data type mismatch."});
                        errorException.initCause(exception.getCause());
                        throw errorException;
                    }
                    if (null != string2 && string2.isEmpty()) {
                        Statement statement = this.buildNonBoundInsertStatement(n);
                        return statement;
                    }
                }
                CDBJDBCDataTypeUtilities.bindSqlDataToCassValue(boundStatement, n2, (DataWrapper)object, s, (DataType)object2, this.m_logger);
            } else {
                boundStatement.setToNull(n2);
            }
            ++n2;
        }
        return boundStatement;
    }

    protected void bindColumnDataToUDTValue(DataWrapper dataWrapper, CDBJDBCColumnMetadata cDBJDBCColumnMetadata) throws ErrorException {
        UserType userType = null;
        String string = null;
        DataType dataType = null;
        int n = -1;
        String string2 = cDBJDBCColumnMetadata.getName();
        String[] stringArray = string2.split("_");
        String string3 = stringArray[0];
        string = stringArray[1];
        string2 = string3;
        userType = cDBJDBCColumnMetadata.getUDTType();
        dataType = userType.getFieldType(string);
        n = cDBJDBCColumnMetadata.getUDTFieldIndex();
        short s = cDBJDBCColumnMetadata.getTypeMetadata().getType();
        if (!cDBJDBCColumnMetadata.isPartitionKey() && !cDBJDBCColumnMetadata.isClusteringKey() && null == this.m_udtColumns.get(string2)) {
            this.prepareSelectStatementForRetrievingColumn(string2);
            this.retrieveExistingUDTFromCassandra(string2);
        }
        if (null == this.m_udtColumns.get(string2)) {
            this.m_udtColumns.put(string2, new UDTColumn(userType.newValue()));
        }
        UDTValue uDTValue = this.m_udtColumns.get((Object)string2).m_udtValue;
        CDBJDBCDataTypeUtilities.bindSqlDataToCassValue(uDTValue, n, dataWrapper, s, dataType, this.m_logger);
    }

    private void buildInsertQuery() {
        CDBJDBCColumnMetadata cDBJDBCColumnMetadata;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = null;
        String string2 = null;
        Insert insert = null;
        boolean bl = this.m_settings.m_enableCaseSensitive;
        string = CDBJDBCUtils.cassNameGenerator(this.m_schemaName, bl);
        string2 = CDBJDBCUtils.cassNameGenerator(this.m_cassTableName, bl);
        insert = QueryBuilder.insertInto(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
            for (Integer n : this.m_primaryKeyIndices) {
                cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n);
                string3 = CDBJDBCUtils.cassNameGenerator(cDBJDBCColumnMetadata.unwrap().getName(), bl);
                if (arrayList.contains(string3)) continue;
                insert.value(string3, QueryBuilder.bindMarker());
                arrayList.add(string3);
            }
        }
        for (Integer n : this.m_upsertedColIndexes) {
            cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n);
            string3 = CDBJDBCUtils.cassNameGenerator(cDBJDBCColumnMetadata.unwrap().getName(), bl);
            if (arrayList.contains(string3)) continue;
            insert.value(string3, QueryBuilder.bindMarker());
            arrayList.add(string3);
        }
        this.m_insertQuery = insert.getQueryString();
    }

    private Statement buildNonBoundInsertStatement(int n) throws ErrorException {
        String string;
        CDBJDBCColumnMetadata cDBJDBCColumnMetadata;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
            for (Integer n3 : this.m_primaryKeyIndices) {
                cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n3);
                string = cDBJDBCColumnMetadata.unwrap().getName();
                if (cDBJDBCColumnMetadata.isUDT()) {
                    if (this.m_columnNameIndexMapping.containsKey(string)) {
                        n2 = (Integer)this.m_columnNameIndexMapping.get(string);
                    }
                    if (n2 < arrayList.size()) {
                        arrayList.remove(n2);
                    }
                }
                arrayList.add(n2, this.m_primaryKeysValues.get(n)[n3]);
                ++n2;
            }
        }
        for (Integer n3 : this.m_upsertedColIndexes) {
            cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n3);
            string = cDBJDBCColumnMetadata.unwrap().getName();
            DataWrapper dataWrapper = this.m_upsertValues.get(n)[n3];
            if (this.m_preparedStatement.getVariables().contains(string)) {
                Object object;
                if (cDBJDBCColumnMetadata.isUDT()) {
                    this.bindColumnDataToUDTValue(dataWrapper, cDBJDBCColumnMetadata);
                    if (null == this.m_udtColumns.get((Object)string).m_bindIndex) {
                        this.m_udtColumns.get((Object)string).m_bindIndex = n2;
                    } else {
                        n2 = this.m_udtColumns.get((Object)string).m_bindIndex;
                    }
                    object = this.m_udtColumns.get((Object)string).m_udtValue;
                    if (n2 < arrayList.size()) {
                        arrayList.remove(n2);
                    }
                    arrayList.add(n2, object);
                } else if (null != dataWrapper) {
                    object = this.m_preparedStatement.getVariables().getType(n2);
                    Object object2 = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(dataWrapper, dataWrapper.getType(), (DataType)object);
                    arrayList.add(n2, object2);
                } else {
                    arrayList.add(n2, null);
                }
            }
            ++n2;
        }
        return new SimpleStatement(this.m_insertQuery, arrayList.toArray());
    }

    private void prepareSelectStatementForRetrievingColumn(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = null;
        String string3 = null;
        Select select = null;
        boolean bl = this.m_settings.m_enableCaseSensitive;
        string2 = CDBJDBCUtils.cassNameGenerator(this.m_schemaName, bl);
        string3 = CDBJDBCUtils.cassNameGenerator(this.m_cassTableName, bl);
        select = QueryBuilder.select(string).from(string2, string3);
        String string4 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Integer n : this.m_primaryKeyIndices) {
            CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n);
            string4 = CDBJDBCUtils.cassNameGenerator(cDBJDBCColumnMetadata.unwrap().getName(), bl);
            if (arrayList.contains(string4)) continue;
            select.where(QueryBuilder.eq(string4, QueryBuilder.bindMarker()));
            arrayList.add(string4);
        }
        LogUtilities.logDebug("Query " + select.getQueryString(), this.m_logger);
        this.m_preparedSelectStatement = CDBJDBCUtils.prepareQuery(this.m_session, select.getQueryString());
    }

    private void retrieveExistingUDTFromCassandra(String string) throws ErrorException {
        Object object;
        Object object2;
        Integer n;
        Object object3;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Statement statement = null;
        BoundStatement boundStatement = this.m_preparedSelectStatement.bind();
        int n2 = 0;
        if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
            object3 = this.m_primaryKeyIndices.iterator();
            while (object3.hasNext()) {
                n = (Integer)object3.next();
                object2 = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n);
                object = ((CDBJDBCColumnMetadata)object2).unwrap().getName();
                if (this.m_columnNameIndexMapping.containsKey(object)) {
                    n2 = (Integer)this.m_columnNameIndexMapping.get(object);
                }
                boundStatement.setBytesUnsafe(n2, this.m_primaryKeysValues.get(0)[n]);
                ++n2;
            }
        }
        if (DSIExtJResultSet.DMLType.INSERT == this.m_DMLType) {
            object3 = this.m_primaryKeyIndices.iterator();
            while (object3.hasNext()) {
                Object object4;
                n = (Integer)object3.next();
                object2 = this.m_upsertValues.get(0)[n];
                object = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n);
                String string2 = ((CDBJDBCColumnMetadata)object).unwrap().getName();
                if (((CDBJDBCColumnMetadata)object).isUDT()) {
                    this.bindColumnDataToUDTValue((DataWrapper)object2, (CDBJDBCColumnMetadata)object);
                    if (null == this.m_udtColumns.get((Object)string2).m_bindIndex) {
                        this.m_udtColumns.get((Object)string2).m_bindIndex = n2;
                    } else {
                        n2 = this.m_udtColumns.get((Object)string2).m_bindIndex;
                    }
                    object4 = this.m_udtColumns.get((Object)string2).m_udtValue;
                    boundStatement.setUDTValue(n2, (UDTValue)object4);
                } else if (null != object2) {
                    object4 = this.m_preparedSelectStatement.getVariables().getType(n2);
                    short s = ((IColumn)this.m_columnMetadata.get(n)).getTypeMetadata().getType();
                    if (DataType.Name.INET == ((DataType)object4).getName()) {
                        String string3 = null;
                        try {
                            string3 = ((DataWrapper)object2).getVarChar();
                            if (string3.isEmpty()) {
                                statement = this.buildNonBoundSelectStatement();
                                break;
                            }
                        }
                        catch (IncorrectTypeException incorrectTypeException) {
                            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.QUERY_EXECUTION_FAIL_ERR.name(), new String[]{this.m_originalQuery, "SQL data type mismatch."});
                            errorException.initCause(incorrectTypeException.getCause());
                            throw errorException;
                        }
                    }
                    CDBJDBCDataTypeUtilities.bindSqlDataToCassValue(boundStatement, n2, (DataWrapper)object2, s, (DataType)object4, this.m_logger);
                } else {
                    boundStatement.setToNull(n2);
                }
                ++n2;
            }
        }
        if (!(object3 = null != statement ? this.m_session.execute(statement) : this.m_session.execute(boundStatement)).isExhausted()) {
            this.m_currentRow = object3.one();
        }
        this.cacheUDTData(string);
    }

    private Statement buildNonBoundSelectStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DataWrapper dataWrapper = null;
        for (Integer n2 : this.m_primaryKeyIndices) {
            Object object;
            dataWrapper = this.m_upsertValues.get(0)[n2];
            CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n2);
            String string = cDBJDBCColumnMetadata.unwrap().getName();
            if (cDBJDBCColumnMetadata.isUDT()) {
                this.bindColumnDataToUDTValue(dataWrapper, cDBJDBCColumnMetadata);
                if (null == this.m_udtColumns.get((Object)string).m_bindIndex) {
                    this.m_udtColumns.get((Object)string).m_bindIndex = n;
                } else {
                    n = this.m_udtColumns.get((Object)string).m_bindIndex;
                }
                object = this.m_udtColumns.get((Object)string).m_udtValue;
                if (n < arrayList.size()) {
                    arrayList.remove(n);
                }
                arrayList.add(n, object);
            } else if (null != dataWrapper) {
                object = this.m_preparedSelectStatement.getVariables().getType(n);
                Object object2 = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(dataWrapper, dataWrapper.getType(), (DataType)object);
                arrayList.add(n, object2);
            } else {
                arrayList.add(n, null);
            }
            ++n;
        }
        return new SimpleStatement(this.m_preparedSelectStatement.getQueryString(), arrayList.toArray());
    }

    private void cacheUDTData(String string) {
        UDTValue uDTValue;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_currentRow && null != (uDTValue = this.m_currentRow.getUDTValue(string))) {
            this.m_udtColumns.put(string, new UDTColumn(uDTValue));
        }
    }

    private void prepareAndBindCachedRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (0 < this.m_upsertedColIndexes.size()) {
            if (null == this.m_preparedStatement) {
                this.prepareInsertQuery();
            }
            int n = 0;
            this.m_boundStatement = this.bindParametersOnStatement(n);
        }
    }

    private void prepareInsertQuery() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.buildInsertQuery();
        this.m_preparedStatement = CDBJDBCUtils.prepareQuery(this.m_session, this.m_insertQuery);
    }

    protected class UDTColumn {
        public Integer m_bindIndex = null;
        public UserType m_udtType;
        public UDTValue m_udtValue;

        public UDTColumn(UDTValue uDTValue) {
            this.m_udtValue = uDTValue;
        }
    }
}

