/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.utils;

import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.cassandra.utils.CDBJDBCDataTypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.cassandra.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.BoundStatement;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.PreparedStatement;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSetFuture;
import com.simba.cassandra.shaded.datastax.driver.core.Session;
import com.simba.cassandra.shaded.datastax.driver.core.SimpleStatement;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.List;

public class CDBJDBCUtils {
    public static BoundStatement bindParameter(PreparedStatement preparedStatement, List<ParameterInputValue> list, ILogger iLogger) throws ErrorException {
        BoundStatement boundStatement = preparedStatement.bind();
        ParameterMetadata parameterMetadata = null;
        int n = -1;
        DataType dataType = null;
        for (ParameterInputValue parameterInputValue : list) {
            parameterMetadata = parameterInputValue.getMetadata();
            n = parameterMetadata.getParameterNumber() - 1;
            short s = parameterMetadata.getTypeMetadata().getType();
            dataType = preparedStatement.getVariables().getType(n);
            DataWrapper dataWrapper = null;
            try {
                dataWrapper = parameterInputValue.getData();
            }
            catch (Exception exception) {
                ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.PARAMETER_BINDING_BUILD_ERR.name(), new String[]{Integer.toString(n)});
                errorException.initCause(exception.getCause());
                throw errorException;
            }
            CDBJDBCDataTypeUtilities.bindSqlDataToCassValue(boundStatement, n, dataWrapper, s, dataType, iLogger);
        }
        return boundStatement;
    }

    public static ResultSetFuture executePreparedStatement(Session session, BoundStatement boundStatement, int n) throws ErrorException {
        try {
            boundStatement.setFetchSize(n);
            ResultSetFuture resultSetFuture = session.executeAsync(boundStatement);
            return resultSetFuture;
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.INVALID_QUERY_ERR.name(), new String[]{boundStatement.preparedStatement().getQueryString(), exception.getMessage()});
            errorException.initCause(exception.getCause());
            throw errorException;
        }
    }

    public static ResultSetFuture executeQuery(Session session, String string, int n) throws ErrorException {
        try {
            SimpleStatement simpleStatement = new SimpleStatement(string);
            simpleStatement.setFetchSize(n);
            ResultSetFuture resultSetFuture = session.executeAsync(simpleStatement);
            resultSetFuture.get();
            return resultSetFuture;
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.INVALID_QUERY_ERR.name(), new String[]{string, exception.getMessage()});
            errorException.initCause(exception.getCause());
            throw errorException;
        }
    }

    public static PreparedStatement prepareQuery(Session session, String string) throws ErrorException {
        try {
            PreparedStatement preparedStatement = session.prepare(string);
            return preparedStatement;
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.INVALID_QUERY_ERR.name(), new String[]{string, exception.getMessage()});
            errorException.initCause(exception.getCause());
            throw errorException;
        }
    }

    public static String cassNameGenerator(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            string = string.toLowerCase();
        }
        stringBuilder.append("\"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }
}

