/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.dsi.dataengine.utilities;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.Nullable;
import com.simba.cassandra.dsi.dataengine.utilities.Searchable;
import com.simba.cassandra.dsi.dataengine.utilities.TypeMetadata;
import com.simba.cassandra.dsi.dataengine.utilities.TypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.Updatable;
import com.simba.cassandra.dsi.exceptions.NumericOverflowException;
import com.simba.cassandra.support.exceptions.ErrorException;

public class ColumnMetadata
implements IColumn {
    private String m_label;
    private String m_name;
    private String m_catalogName;
    private String m_schemaName;
    private String m_tableName;
    private TypeMetadata m_typeMetadata;
    private Updatable m_updatable;
    private Searchable m_searchable;
    private Nullable m_nullable;
    private long m_columnLength;
    private boolean m_isAutoUnique;
    private boolean m_isCaseSensitive;

    public ColumnMetadata(TypeMetadata typeMetadata) throws NullPointerException {
        if (null == typeMetadata) {
            throw new NullPointerException();
        }
        this.m_typeMetadata = typeMetadata;
        this.m_label = "";
        this.m_name = "";
        this.m_catalogName = "";
        this.m_schemaName = "";
        this.m_tableName = "";
        this.m_updatable = Updatable.UNKNOWN;
        this.m_searchable = Searchable.SEARCHABLE;
        this.m_nullable = Nullable.UNKNOWN;
        this.m_columnLength = 0L;
        this.m_isAutoUnique = false;
        this.m_isCaseSensitive = false;
    }

    public static ColumnMetadata copyOf(IColumn iColumn) {
        ColumnMetadata columnMetadata = new ColumnMetadata(TypeMetadata.copyOf(iColumn.getTypeMetadata()));
        columnMetadata.setAutoUnique(iColumn.isAutoUnique());
        columnMetadata.setCaseSensitive(iColumn.isCaseSensitive());
        columnMetadata.setCatalogName(iColumn.getCatalogName());
        try {
            columnMetadata.setColumnLength(iColumn.getColumnLength());
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new RuntimeException(numericOverflowException);
        }
        columnMetadata.setLabel(iColumn.getLabel());
        columnMetadata.setName(iColumn.getName());
        columnMetadata.setNullable(iColumn.getNullable());
        columnMetadata.setSchemaName(iColumn.getSchemaName());
        columnMetadata.setSearchable(iColumn.getSearchable());
        columnMetadata.setTableName(iColumn.getTableName());
        columnMetadata.setTypeMetadata(TypeMetadata.copyOf(iColumn.getTypeMetadata()));
        columnMetadata.setUpdatable(iColumn.getUpdatable());
        return columnMetadata;
    }

    @Override
    public String getCatalogName() {
        return this.m_catalogName;
    }

    @Override
    public long getColumnLength() {
        return this.m_columnLength;
    }

    @Override
    public long getDisplaySize() throws ErrorException {
        return TypeUtilities.getDisplaySize(this.m_typeMetadata, this.m_columnLength);
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Nullable getNullable() {
        return this.m_nullable;
    }

    @Override
    public String getSchemaName() {
        return this.m_schemaName;
    }

    @Override
    public Searchable getSearchable() {
        return this.m_searchable;
    }

    @Override
    public String getTableName() {
        return this.m_tableName;
    }

    @Override
    public TypeMetadata getTypeMetadata() {
        return this.m_typeMetadata;
    }

    @Override
    public Updatable getUpdatable() {
        return this.m_updatable;
    }

    @Override
    public boolean isAutoUnique() {
        return this.m_isAutoUnique;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.m_isCaseSensitive;
    }

    @Override
    public boolean isDefinitelyWritable() {
        return Updatable.WRITE == this.m_updatable;
    }

    @Override
    public boolean isUnnamed() {
        return null == this.m_name;
    }

    public void setAutoUnique(boolean bl) {
        this.m_isAutoUnique = bl;
    }

    public void setCaseSensitive(boolean bl) {
        this.m_isCaseSensitive = bl;
    }

    public void setCatalogName(String string) {
        this.m_catalogName = string;
    }

    public void setColumnLength(long l) throws NumericOverflowException {
        if (l > 0xFFFFFFFFL || l < 0L) {
            throw new NumericOverflowException();
        }
        this.m_columnLength = l;
    }

    public void setLabel(String string) {
        this.m_label = string;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setNullable(Nullable nullable) {
        this.m_nullable = nullable;
    }

    public void setSchemaName(String string) {
        this.m_schemaName = string;
    }

    public void setSearchable(Searchable searchable) {
        this.m_searchable = searchable;
    }

    public void setTableName(String string) {
        this.m_tableName = string;
    }

    public void setTypeMetadata(TypeMetadata typeMetadata) throws NullPointerException {
        if (null == typeMetadata) {
            throw new NullPointerException();
        }
        this.m_typeMetadata = typeMetadata;
    }

    public void setUpdatable(Updatable updatable) {
        this.m_updatable = updatable;
    }

    public String toString() {
        if (this.isUnnamed()) {
            return "ColumnMetadata: <null>";
        }
        return "ColumnMetadata: " + this.getName();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_catalogName == null ? 0 : this.m_catalogName.hashCode());
        n = 31 * n + (int)(this.m_columnLength ^ this.m_columnLength >>> 32);
        n = 31 * n + (this.m_isAutoUnique ? 1231 : 1237);
        n = 31 * n + (this.m_isCaseSensitive ? 1231 : 1237);
        n = 31 * n + (this.m_label == null ? 0 : this.m_label.hashCode());
        n = 31 * n + (this.m_name == null ? 0 : this.m_name.hashCode());
        n = 31 * n + (this.m_nullable == null ? 0 : this.m_nullable.hashCode());
        n = 31 * n + (this.m_schemaName == null ? 0 : this.m_schemaName.hashCode());
        n = 31 * n + (this.m_searchable == null ? 0 : this.m_searchable.hashCode());
        n = 31 * n + (this.m_tableName == null ? 0 : this.m_tableName.hashCode());
        n = 31 * n + (this.m_typeMetadata == null ? 0 : this.m_typeMetadata.hashCode());
        n = 31 * n + (this.m_updatable == null ? 0 : this.m_updatable.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColumnMetadata columnMetadata = (ColumnMetadata)object;
        if (this.m_catalogName == null ? columnMetadata.m_catalogName != null : !this.m_catalogName.equals(columnMetadata.m_catalogName)) {
            return false;
        }
        if (this.m_columnLength != columnMetadata.m_columnLength) {
            return false;
        }
        if (this.m_isAutoUnique != columnMetadata.m_isAutoUnique) {
            return false;
        }
        if (this.m_isCaseSensitive != columnMetadata.m_isCaseSensitive) {
            return false;
        }
        if (this.m_label == null ? columnMetadata.m_label != null : !this.m_label.equals(columnMetadata.m_label)) {
            return false;
        }
        if (this.m_name == null ? columnMetadata.m_name != null : !this.m_name.equals(columnMetadata.m_name)) {
            return false;
        }
        if (this.m_nullable != columnMetadata.m_nullable) {
            return false;
        }
        if (this.m_schemaName == null ? columnMetadata.m_schemaName != null : !this.m_schemaName.equals(columnMetadata.m_schemaName)) {
            return false;
        }
        if (this.m_searchable != columnMetadata.m_searchable) {
            return false;
        }
        if (this.m_tableName == null ? columnMetadata.m_tableName != null : !this.m_tableName.equals(columnMetadata.m_tableName)) {
            return false;
        }
        if (this.m_typeMetadata == null ? columnMetadata.m_typeMetadata != null : !this.m_typeMetadata.equals(columnMetadata.m_typeMetadata)) {
            return false;
        }
        return this.m_updatable == columnMetadata.m_updatable;
    }
}

