/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.dsi.dataengine.utilities;

import com.simba.cassandra.dsi.dataengine.impl.DSIEmptyResultSet;
import com.simba.cassandra.dsi.dataengine.interfaces.IErrorResult;
import com.simba.cassandra.dsi.dataengine.interfaces.IResultSet;
import com.simba.cassandra.dsi.dataengine.interfaces.IRowCountResult;
import com.simba.cassandra.dsi.dataengine.utilities.ExecutionResultType;
import com.simba.cassandra.support.exceptions.ErrorException;

public final class ExecutionResult {
    private ExecutionResultType m_type;
    private Object m_result;
    private IResultSet m_generatedResult = new DSIEmptyResultSet();

    public ExecutionResult(IErrorResult iErrorResult, boolean bl) {
        this.m_type = bl ? ExecutionResultType.ERROR_RESULT_SET : ExecutionResultType.ERROR_ROW_COUNT;
        this.m_result = iErrorResult;
    }

    public ExecutionResult(IResultSet iResultSet) {
        this.m_type = ExecutionResultType.RESULT_SET;
        this.m_result = iResultSet;
    }

    public ExecutionResult(IRowCountResult iRowCountResult) {
        this.m_type = ExecutionResultType.ROW_COUNT;
        this.m_result = iRowCountResult;
    }

    public Object getResult() {
        return this.m_result;
    }

    public ExecutionResultType getType() {
        return this.m_type;
    }

    public long getRowCount() throws ErrorException {
        switch (this.m_type) {
            case RESULT_SET: 
            case ERROR_RESULT_SET: {
                return ((IResultSet)this.m_result).getRowCount();
            }
            case ROW_COUNT: 
            case ERROR_ROW_COUNT: {
                return ((IRowCountResult)this.m_result).getRowCount();
            }
        }
        return -1L;
    }

    public IResultSet getGeneratedResult() {
        return this.m_generatedResult;
    }

    public void setGeneratedResult(IResultSet iResultSet) {
        this.m_generatedResult = iResultSet;
    }
}

