/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.dsi.utilities;

import com.simba.cassandra.support.exceptions.ErrorException;

public final class DataRetrievalUtilities {
    private DataRetrievalUtilities() {
    }

    public static byte[] retrieveBinaryData(byte[] byArray, long l, long l2, long l3, DataRetrievalStatus dataRetrievalStatus) throws ErrorException {
        if (l != 0L && (l >= (long)byArray.length || l >= l3)) {
            throw new IllegalArgumentException("Invalid offset: " + l);
        }
        int n = l2 == -1L || l2 > Long.MAX_VALUE - l || (long)byArray.length <= l2 + l ? byArray.length : (int)(l2 + l);
        if (l == 0L && (long)byArray.length <= l2 && (long)byArray.length <= l3) {
            dataRetrievalStatus.isTruncate = false;
            dataRetrievalStatus.hasMoreData = false;
            return byArray;
        }
        int n2 = (int)Math.min((long)n, l3);
        byte[] byArray2 = new byte[(int)((long)n2 - l)];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray[(int)((long)i + l)];
        }
        dataRetrievalStatus.isTruncate = l3 < (long)n;
        dataRetrievalStatus.hasMoreData = !dataRetrievalStatus.isTruncate && n2 < byArray.length;
        return byArray2;
    }

    public static String retrieveCharData(String string, long l, long l2, long l3, DataRetrievalStatus dataRetrievalStatus) throws ErrorException {
        if (l % 2L == 1L) {
            throw new IllegalStateException("Invalid offset value: " + l);
        }
        int n = string.length();
        if ((l /= 2L) != 0L && (l >= (long)n || l >= l3)) {
            dataRetrievalStatus.isTruncate = false;
            dataRetrievalStatus.hasMoreData = false;
            return "";
        }
        int n2 = l2 == -1L || l2 / 2L > Long.MAX_VALUE - l || (long)n <= l2 / 2L + l ? n : (int)(l + l2 / 2L);
        if (l == 0L && n == n2 && (long)n <= l3) {
            dataRetrievalStatus.isTruncate = false;
            dataRetrievalStatus.hasMoreData = false;
            return string;
        }
        dataRetrievalStatus.isTruncate = l3 < (long)n2;
        int n3 = (int)Math.min(l3, (long)n2);
        dataRetrievalStatus.hasMoreData = !dataRetrievalStatus.isTruncate && n3 < n;
        return string.substring((int)l, n3);
    }

    public static class DataRetrievalStatus {
        public boolean isTruncate;
        public boolean hasMoreData;
    }
}

