/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.jdbc.common;

import com.simba.cassandra.exceptions.ExceptionConverter;
import com.simba.cassandra.exceptions.JDBCMessageKey;
import com.simba.cassandra.jdbc.common.SConnection;
import com.simba.cassandra.jdbc.common.SPooledConnection;
import com.simba.cassandra.jdbc.common.utilities.WrapperUtilities;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.IWarningListener;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ExceptionType;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;

public abstract class SConnectionHandle
implements Connection {
    protected boolean m_isClosed = true;
    protected SConnection m_connection;
    protected SPooledConnection m_pooledConnection;

    protected SConnectionHandle(SConnection sConnection, SPooledConnection sPooledConnection) throws SQLException {
        this.m_connection = sConnection;
        this.m_pooledConnection = sPooledConnection;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.clearWarnings();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.m_isClosed) {
            return;
        }
        this.m_isClosed = true;
        this.m_connection.closeChildObjects();
        this.m_pooledConnection.onHandleClose();
    }

    @Override
    public void commit() throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.commit();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.createStatement();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.createStatement(n, n2, n3);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getCatalog();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getHoldability();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    protected ILogger getLogger() {
        return this.m_connection.m_logger;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getMetaData();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getTypeMap();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getWarnings();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    protected IWarningListener getWarningListener() {
        return this.m_connection.m_warningListener;
    }

    @Override
    public boolean isClosed() {
        return this.m_isClosed || this.m_connection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.isReadOnly();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareCall(string);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareCall(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(string, n);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(string, nArray);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(string, stringArray);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.rollback();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setCatalog(string);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setHoldability(n);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.setSavepoint();
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, objectArray);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public Blob createBlob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public Clob createClob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public NClob createNClob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), string, objectArray);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return !this.isClosed() && this.m_connection.getDSIConnection().isAlive();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    void open() throws SQLException {
        if (!this.m_isClosed) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_OPEN, this.m_connection.getWarningListener(), ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
        this.m_isClosed = false;
    }

    void forceClose() throws SQLException {
        this.m_connection.close();
    }

    protected void checkIfOpen() throws SQLException {
        if (this.m_isClosed) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
    }
}

