/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.DriverThrowables;
import com.simba.cassandra.shaded.datastax.driver.core.GuavaCompatibility;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSet;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSetFuture;
import com.simba.cassandra.shaded.google.common.util.concurrent.AbstractFuture;
import com.simba.cassandra.shaded.google.common.util.concurrent.FutureCallback;
import com.simba.cassandra.shaded.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ChainedResultSetFuture
extends AbstractFuture<ResultSet>
implements ResultSetFuture {
    private volatile ResultSetFuture source;

    ChainedResultSetFuture() {
    }

    void setSource(ResultSetFuture source) {
        if (this.isCancelled()) {
            source.cancel(false);
        }
        this.source = source;
        GuavaCompatibility.INSTANCE.addCallback(source, new FutureCallback<ResultSet>(){

            @Override
            public void onSuccess(ResultSet result) {
                ChainedResultSetFuture.this.set(result);
            }

            @Override
            public void onFailure(Throwable t) {
                ChainedResultSetFuture.this.setException(t);
            }
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return (this.source == null || this.source.cancel(mayInterruptIfRunning)) && super.cancel(mayInterruptIfRunning);
    }

    @Override
    public ResultSet getUninterruptibly() {
        try {
            return Uninterruptibles.getUninterruptibly(this);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return Uninterruptibles.getUninterruptibly(this, timeout, unit);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }
}

