/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.Clock;
import com.simba.cassandra.shaded.datastax.driver.core.Native;
import com.simba.cassandra.shaded.datastax.driver.core.NativeClock;
import com.simba.cassandra.shaded.datastax.driver.core.SystemClock;
import com.simba.cassandra.shaded.datastax.driver.core.SystemProperties;
import com.simba.cassandra.shaded.slf4j.Logger;
import com.simba.cassandra.shaded.slf4j.LoggerFactory;

class ClockFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClockFactory.class);
    private static final String USE_NATIVE_CLOCK_SYSTEM_PROPERTY = "com.simba.cassandra.shaded.datastax.driver.USE_NATIVE_CLOCK";

    ClockFactory() {
    }

    static Clock newInstance() {
        if (SystemProperties.getBoolean(USE_NATIVE_CLOCK_SYSTEM_PROPERTY, true) && Native.isGettimeofdayAvailable()) {
            LOGGER.info("Using native clock to generate timestamps.");
            return new NativeClock();
        }
        LOGGER.info("Using java.lang.System clock to generate timestamps.");
        return new SystemClock();
    }
}

