/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.Cluster;
import com.simba.cassandra.shaded.datastax.driver.core.ControlConnection;
import com.simba.cassandra.shaded.datastax.driver.core.EndPoint;
import com.simba.cassandra.shaded.datastax.driver.core.EndPointFactory;
import com.simba.cassandra.shaded.datastax.driver.core.Row;
import com.simba.cassandra.shaded.datastax.driver.core.TranslatedAddressEndPoint;
import com.simba.cassandra.shaded.slf4j.Logger;
import com.simba.cassandra.shaded.slf4j.LoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class DefaultEndPointFactory
implements EndPointFactory {
    private static final Logger logger = LoggerFactory.getLogger(ControlConnection.class);
    private static final InetAddress BIND_ALL_ADDRESS;
    private volatile Cluster cluster;

    @Override
    public void init(Cluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public EndPoint create(Row peersRow) {
        if (peersRow.getColumnDefinitions().contains("native_address")) {
            InetAddress nativeAddress = peersRow.getInet("native_address");
            int nativePort = peersRow.getInt("native_port");
            InetSocketAddress translateAddress = this.cluster.manager.translateAddress(new InetSocketAddress(nativeAddress, nativePort));
            return new TranslatedAddressEndPoint(translateAddress);
        }
        InetAddress broadcastAddress = peersRow.getInet("peer");
        InetAddress rpcAddress = peersRow.getInet("rpc_address");
        if (broadcastAddress == null || rpcAddress == null) {
            return null;
        }
        if (rpcAddress.equals(BIND_ALL_ADDRESS)) {
            logger.warn("Found host with 0.0.0.0 as rpc_address, using broadcast_address ({}) to contact it instead. If this is incorrect you should avoid the use of 0.0.0.0 server side.", (Object)broadcastAddress);
            rpcAddress = broadcastAddress;
        }
        InetSocketAddress translateAddress = this.cluster.manager.translateAddress(rpcAddress);
        return new TranslatedAddressEndPoint(translateAddress);
    }

    static {
        try {
            BIND_ALL_ADDRESS = InetAddress.getByAddress(new byte[4]);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

