/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.AggregateMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.ArrayBackedResultSet;
import com.simba.cassandra.shaded.datastax.driver.core.Cluster;
import com.simba.cassandra.shaded.datastax.driver.core.Connection;
import com.simba.cassandra.shaded.datastax.driver.core.DriverThrowables;
import com.simba.cassandra.shaded.datastax.driver.core.ExecutionInfo;
import com.simba.cassandra.shaded.datastax.driver.core.FunctionMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.KeyspaceMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.MaterializedViewMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.Message;
import com.simba.cassandra.shaded.datastax.driver.core.Metadata;
import com.simba.cassandra.shaded.datastax.driver.core.ProtocolVersion;
import com.simba.cassandra.shaded.datastax.driver.core.RequestHandler;
import com.simba.cassandra.shaded.datastax.driver.core.Responses;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSet;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSetFuture;
import com.simba.cassandra.shaded.datastax.driver.core.SchemaElement;
import com.simba.cassandra.shaded.datastax.driver.core.SessionManager;
import com.simba.cassandra.shaded.datastax.driver.core.Statement;
import com.simba.cassandra.shaded.datastax.driver.core.TableMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.UserType;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.ConnectionException;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.DriverInternalError;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.OperationTimedOutException;
import com.simba.cassandra.shaded.google.common.util.concurrent.AbstractFuture;
import com.simba.cassandra.shaded.google.common.util.concurrent.Uninterruptibles;
import com.simba.cassandra.shaded.slf4j.Logger;
import com.simba.cassandra.shaded.slf4j.LoggerFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class DefaultResultSetFuture
extends AbstractFuture<ResultSet>
implements ResultSetFuture,
RequestHandler.Callback {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetFuture.class);
    private final SessionManager session;
    private final ProtocolVersion protocolVersion;
    private final Message.Request request;
    private volatile RequestHandler handler;

    DefaultResultSetFuture(SessionManager session, ProtocolVersion protocolVersion, Message.Request request) {
        this.session = session;
        this.protocolVersion = protocolVersion;
        this.request = request;
    }

    @Override
    public void register(RequestHandler handler) {
        this.handler = handler;
    }

    @Override
    public Message.Request request() {
        return this.request;
    }

    @Override
    public void onSet(Connection connection, Message.Response response, ExecutionInfo info, Statement statement, long latency) {
        try {
            block1 : switch (response.type) {
                case RESULT: {
                    Responses.Result rm = (Responses.Result)response;
                    switch (rm.kind) {
                        case SET_KEYSPACE: {
                            this.session.poolsState.setKeyspace(((Responses.Result.SetKeyspace)rm).keyspace);
                            this.set(ArrayBackedResultSet.fromMessage(rm, this.session, this.protocolVersion, info, statement));
                            break block1;
                        }
                        case SCHEMA_CHANGE: {
                            ArrayBackedResultSet rs = ArrayBackedResultSet.fromMessage(rm, this.session, this.protocolVersion, info, statement);
                            final Cluster.Manager cluster = this.session.cluster.manager;
                            if (!cluster.configuration.getQueryOptions().isMetadataEnabled()) {
                                cluster.waitForSchemaAgreementAndSignal(connection, this, rs);
                                break block1;
                            }
                            Responses.Result.SchemaChange scc = (Responses.Result.SchemaChange)rm;
                            switch (scc.change) {
                                case CREATED: 
                                case UPDATED: {
                                    cluster.refreshSchemaAndSignal(connection, this, rs, scc.targetType, scc.targetKeyspace, scc.targetName, scc.targetSignature);
                                    break block1;
                                }
                                case DROPPED: {
                                    if (scc.targetType == SchemaElement.KEYSPACE) {
                                        final KeyspaceMetadata removedKeyspace = cluster.metadata.removeKeyspace(scc.targetKeyspace);
                                        if (removedKeyspace != null) {
                                            cluster.executor.submit(new Runnable(){

                                                @Override
                                                public void run() {
                                                    cluster.metadata.triggerOnKeyspaceRemoved(removedKeyspace);
                                                }
                                            });
                                        }
                                    } else {
                                        KeyspaceMetadata keyspace = (KeyspaceMetadata)this.session.cluster.manager.metadata.keyspaces.get(scc.targetKeyspace);
                                        if (keyspace == null) {
                                            logger.warn("Received a DROPPED notification for {} {}.{}, but this keyspace is unknown in our metadata", new Object[]{scc.targetType, scc.targetKeyspace, scc.targetName});
                                        } else {
                                            switch (scc.targetType) {
                                                case TABLE: {
                                                    final TableMetadata removedTable = keyspace.removeTable(scc.targetName);
                                                    if (removedTable != null) {
                                                        cluster.executor.submit(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                cluster.metadata.triggerOnTableRemoved(removedTable);
                                                            }
                                                        });
                                                        break;
                                                    }
                                                    final MaterializedViewMetadata removedView = keyspace.removeMaterializedView(scc.targetName);
                                                    if (removedView == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnMaterializedViewRemoved(removedView);
                                                        }
                                                    });
                                                    break;
                                                }
                                                case TYPE: {
                                                    final UserType removedType = keyspace.removeUserType(scc.targetName);
                                                    if (removedType == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnUserTypeRemoved(removedType);
                                                        }
                                                    });
                                                    break;
                                                }
                                                case FUNCTION: {
                                                    final FunctionMetadata removedFunction = keyspace.removeFunction(Metadata.fullFunctionName(scc.targetName, scc.targetSignature));
                                                    if (removedFunction == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnFunctionRemoved(removedFunction);
                                                        }
                                                    });
                                                    break;
                                                }
                                                case AGGREGATE: {
                                                    final AggregateMetadata removedAggregate = keyspace.removeAggregate(Metadata.fullFunctionName(scc.targetName, scc.targetSignature));
                                                    if (removedAggregate == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnAggregateRemoved(removedAggregate);
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                    this.session.cluster.manager.waitForSchemaAgreementAndSignal(connection, this, rs);
                                    break block1;
                                }
                            }
                            logger.info("Ignoring unknown schema change result");
                            break block1;
                        }
                    }
                    this.set(ArrayBackedResultSet.fromMessage(rm, this.session, this.protocolVersion, info, statement));
                    break;
                }
                case ERROR: {
                    this.setException(((Responses.Error)response).asException(connection.endPoint));
                    break;
                }
                default: {
                    connection.defunct(new ConnectionException(connection.endPoint, String.format("Got unexpected %s response", new Object[]{response.type})));
                    this.setException(new DriverInternalError(String.format("Got unexpected %s response from %s", new Object[]{response.type, connection.endPoint})));
                }
            }
        }
        catch (Throwable e) {
            this.setException(new DriverInternalError("Unexpected error while processing response from " + connection.endPoint, e));
        }
    }

    @Override
    public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
        this.onSet(connection, response, null, null, latency);
    }

    @Override
    public void onException(Connection connection, Exception exception, long latency, int retryCount) {
        this.setException(exception);
    }

    @Override
    public boolean onTimeout(Connection connection, long latency, int retryCount) {
        this.setException(new OperationTimedOutException(connection.endPoint));
        return true;
    }

    void setResult(ResultSet rs) {
        this.set(rs);
    }

    @Override
    public ResultSet getUninterruptibly() {
        try {
            return Uninterruptibles.getUninterruptibly(this);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return Uninterruptibles.getUninterruptibly(this, timeout, unit);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!super.cancel(mayInterruptIfRunning)) {
            return false;
        }
        if (this.handler != null) {
            this.handler.cancel();
        }
        return true;
    }

    @Override
    public int retryCount() {
        return 0;
    }
}

