/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.Cluster;
import com.simba.cassandra.shaded.datastax.driver.core.ConvictionPolicy;
import com.simba.cassandra.shaded.datastax.driver.core.EndPoint;
import com.simba.cassandra.shaded.datastax.driver.core.ExecutionInfo;
import com.simba.cassandra.shaded.datastax.driver.core.ProtocolVersion;
import com.simba.cassandra.shaded.datastax.driver.core.Token;
import com.simba.cassandra.shaded.datastax.driver.core.VersionNumber;
import com.simba.cassandra.shaded.google.common.util.concurrent.ListenableFuture;
import com.simba.cassandra.shaded.slf4j.Logger;
import com.simba.cassandra.shaded.slf4j.LoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class Host {
    private static final Logger logger = LoggerFactory.getLogger(Host.class);
    static final Logger statesLogger = LoggerFactory.getLogger(Host.class.getName() + ".STATES");
    private final EndPoint endPoint;
    private volatile InetSocketAddress broadcastRpcAddress;
    private volatile InetSocketAddress broadcastSocketAddress;
    private volatile InetSocketAddress listenSocketAddress;
    private volatile UUID hostId;
    private volatile UUID schemaVersion;
    volatile State state;
    final ReentrantLock notificationsLock = new ReentrantLock(true);
    final ConvictionPolicy convictionPolicy;
    private final Cluster.Manager manager;
    final AtomicReference<ListenableFuture<?>> reconnectionAttempt = new AtomicReference();
    final ExecutionInfo defaultExecutionInfo;
    private volatile String datacenter;
    private volatile String rack;
    private volatile VersionNumber cassandraVersion;
    private volatile Set<Token> tokens;
    private volatile String dseWorkload;
    private volatile boolean dseGraphEnabled;
    private volatile VersionNumber dseVersion;

    Host(EndPoint endPoint, ConvictionPolicy.Factory convictionPolicyFactory, Cluster.Manager manager) {
        if (endPoint == null || convictionPolicyFactory == null) {
            throw new NullPointerException();
        }
        this.endPoint = endPoint;
        this.convictionPolicy = convictionPolicyFactory.create(this, manager.reconnectionPolicy());
        this.manager = manager;
        this.defaultExecutionInfo = new ExecutionInfo(this);
        this.state = State.ADDED;
    }

    void setLocationInfo(String datacenter, String rack) {
        this.datacenter = datacenter;
        this.rack = rack;
    }

    void setVersion(String cassandraVersion) {
        VersionNumber versionNumber = null;
        try {
            if (cassandraVersion != null) {
                versionNumber = VersionNumber.parse(cassandraVersion);
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error parsing Cassandra version {}. This shouldn't have happened", (Object)cassandraVersion);
        }
        this.cassandraVersion = versionNumber;
    }

    void setBroadcastRpcAddress(InetSocketAddress broadcastRpcAddress) {
        this.broadcastRpcAddress = broadcastRpcAddress;
    }

    void setBroadcastSocketAddress(InetSocketAddress broadcastAddress) {
        this.broadcastSocketAddress = broadcastAddress;
    }

    void setListenSocketAddress(InetSocketAddress listenAddress) {
        this.listenSocketAddress = listenAddress;
    }

    void setDseVersion(String dseVersion) {
        VersionNumber versionNumber = null;
        try {
            if (dseVersion != null) {
                versionNumber = VersionNumber.parse(dseVersion);
            }
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error parsing DSE version {}. This shouldn't have happened", (Object)dseVersion);
        }
        this.dseVersion = versionNumber;
    }

    void setDseWorkload(String dseWorkload) {
        this.dseWorkload = dseWorkload;
    }

    void setDseGraphEnabled(boolean dseGraphEnabled) {
        this.dseGraphEnabled = dseGraphEnabled;
    }

    void setHostId(UUID hostId) {
        this.hostId = hostId;
    }

    void setSchemaVersion(UUID schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    boolean supports(ProtocolVersion version) {
        return this.getCassandraVersion() == null || version.minCassandraVersion().compareTo(this.getCassandraVersion().nextStable()) <= 0;
    }

    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Deprecated
    public InetAddress getAddress() {
        return this.endPoint.resolve().getAddress();
    }

    @Deprecated
    public InetSocketAddress getSocketAddress() {
        return this.endPoint.resolve();
    }

    public InetSocketAddress getBroadcastRpcAddress() {
        return this.broadcastRpcAddress;
    }

    public InetAddress getBroadcastAddress() {
        return this.broadcastSocketAddress != null ? this.broadcastSocketAddress.getAddress() : null;
    }

    public InetSocketAddress getBroadcastSocketAddress() {
        return this.broadcastSocketAddress;
    }

    public InetAddress getListenAddress() {
        return this.listenSocketAddress != null ? this.listenSocketAddress.getAddress() : null;
    }

    public InetSocketAddress getListenSocketAddress() {
        return this.listenSocketAddress;
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public String getRack() {
        return this.rack;
    }

    public VersionNumber getCassandraVersion() {
        return this.cassandraVersion;
    }

    @Deprecated
    public VersionNumber getDseVersion() {
        return this.dseVersion;
    }

    @Deprecated
    public String getDseWorkload() {
        return this.dseWorkload;
    }

    @Deprecated
    public boolean isDseGraphEnabled() {
        return this.dseGraphEnabled;
    }

    public UUID getHostId() {
        return this.hostId;
    }

    public UUID getSchemaVersion() {
        return this.schemaVersion;
    }

    public Set<Token> getTokens() {
        return this.tokens;
    }

    void setTokens(Set<Token> tokens) {
        this.tokens = tokens;
    }

    public boolean isUp() {
        return this.state == State.UP;
    }

    public String getState() {
        return this.state.name();
    }

    public ListenableFuture<?> getReconnectionAttemptFuture() {
        return this.reconnectionAttempt.get();
    }

    public void tryReconnectOnce() {
        this.manager.startSingleReconnectionAttempt(this);
    }

    public boolean equals(Object other) {
        if (other instanceof Host) {
            Host that = (Host)other;
            return this.endPoint.equals(that.endPoint);
        }
        return false;
    }

    public int hashCode() {
        return this.endPoint.hashCode();
    }

    boolean wasJustAdded() {
        return this.state == State.ADDED;
    }

    public String toString() {
        return this.endPoint.toString();
    }

    void setDown() {
        this.state = State.DOWN;
    }

    void setUp() {
        this.state = State.UP;
    }

    public static interface LifecycleAwareStateListener
    extends StateListener {
        @Override
        public void onRegister(Cluster var1);

        @Override
        public void onUnregister(Cluster var1);
    }

    public static interface StateListener {
        public void onAdd(Host var1);

        public void onUp(Host var1);

        public void onDown(Host var1);

        public void onRemove(Host var1);

        public void onRegister(Cluster var1);

        public void onUnregister(Cluster var1);
    }

    static enum State {
        ADDED,
        DOWN,
        UP;

    }
}

